package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class Shutter_GeneralConfigurationEvent extends CameraEvent {
  private final String version;

  private final double controller_centeringSpeed;

  private final String controller_localAMSaddr;

  private final double controller_maxHallPositionError;

  private final double controller_maxStrokeSpeed;

  private final String controller_minExposureTime;

  private final String controller_noticeReaderRestartDelay;

  private final String controller_noticeReaderStartupDelay;

  private final String controller_plcAMSaddr;

  private final String controller_plcAckTimeout;

  private final String controller_plcIPaddr;

  private final String controller_referenceMinusXpositions;

  private final String controller_referencePlusXpositions;

  private final String controller_safeCtrlTempRange;

  private final String controller_safeRtdTempRange;

  private final int periodictasks_schedulers_default_nTasks;

  private final int periodictasks_schedulers_default_nThreads;

  private final String publisher_configurationName;

  private final String publisher_publicationInterval;

  private final String statemachine_brakepower_brakeVoltageKey;

  private final double statemachine_brakepower_powerOnThreshold;

  private final String statemachine_resetSyncTimeout;

  private final String statemachine_taskRestartDelay;

  private final String watchdog_checkInterval;

  public Shutter_GeneralConfigurationEvent(String version, double controller_centeringSpeed,
      String controller_localAMSaddr, double controller_maxHallPositionError,
      double controller_maxStrokeSpeed, String controller_minExposureTime,
      String controller_noticeReaderRestartDelay, String controller_noticeReaderStartupDelay,
      String controller_plcAMSaddr, String controller_plcAckTimeout, String controller_plcIPaddr,
      String controller_referenceMinusXpositions, String controller_referencePlusXpositions,
      String controller_safeCtrlTempRange, String controller_safeRtdTempRange,
      int periodictasks_schedulers_default_nTasks, int periodictasks_schedulers_default_nThreads,
      String publisher_configurationName, String publisher_publicationInterval,
      String statemachine_brakepower_brakeVoltageKey,
      double statemachine_brakepower_powerOnThreshold, String statemachine_resetSyncTimeout,
      String statemachine_taskRestartDelay, String watchdog_checkInterval) {
    this.version = version;
    this.controller_centeringSpeed = controller_centeringSpeed;
    this.controller_localAMSaddr = controller_localAMSaddr;
    this.controller_maxHallPositionError = controller_maxHallPositionError;
    this.controller_maxStrokeSpeed = controller_maxStrokeSpeed;
    this.controller_minExposureTime = controller_minExposureTime;
    this.controller_noticeReaderRestartDelay = controller_noticeReaderRestartDelay;
    this.controller_noticeReaderStartupDelay = controller_noticeReaderStartupDelay;
    this.controller_plcAMSaddr = controller_plcAMSaddr;
    this.controller_plcAckTimeout = controller_plcAckTimeout;
    this.controller_plcIPaddr = controller_plcIPaddr;
    this.controller_referenceMinusXpositions = controller_referenceMinusXpositions;
    this.controller_referencePlusXpositions = controller_referencePlusXpositions;
    this.controller_safeCtrlTempRange = controller_safeCtrlTempRange;
    this.controller_safeRtdTempRange = controller_safeRtdTempRange;
    this.periodictasks_schedulers_default_nTasks = periodictasks_schedulers_default_nTasks;
    this.periodictasks_schedulers_default_nThreads = periodictasks_schedulers_default_nThreads;
    this.publisher_configurationName = publisher_configurationName;
    this.publisher_publicationInterval = publisher_publicationInterval;
    this.statemachine_brakepower_brakeVoltageKey = statemachine_brakepower_brakeVoltageKey;
    this.statemachine_brakepower_powerOnThreshold = statemachine_brakepower_powerOnThreshold;
    this.statemachine_resetSyncTimeout = statemachine_resetSyncTimeout;
    this.statemachine_taskRestartDelay = statemachine_taskRestartDelay;
    this.watchdog_checkInterval = watchdog_checkInterval;
  }

  public String getVersion() {
    return version;
  }

  public double getController_centeringSpeed() {
    return controller_centeringSpeed;
  }

  public String getController_localAMSaddr() {
    return controller_localAMSaddr;
  }

  public double getController_maxHallPositionError() {
    return controller_maxHallPositionError;
  }

  public double getController_maxStrokeSpeed() {
    return controller_maxStrokeSpeed;
  }

  public String getController_minExposureTime() {
    return controller_minExposureTime;
  }

  public String getController_noticeReaderRestartDelay() {
    return controller_noticeReaderRestartDelay;
  }

  public String getController_noticeReaderStartupDelay() {
    return controller_noticeReaderStartupDelay;
  }

  public String getController_plcAMSaddr() {
    return controller_plcAMSaddr;
  }

  public String getController_plcAckTimeout() {
    return controller_plcAckTimeout;
  }

  public String getController_plcIPaddr() {
    return controller_plcIPaddr;
  }

  public String getController_referenceMinusXpositions() {
    return controller_referenceMinusXpositions;
  }

  public String getController_referencePlusXpositions() {
    return controller_referencePlusXpositions;
  }

  public String getController_safeCtrlTempRange() {
    return controller_safeCtrlTempRange;
  }

  public String getController_safeRtdTempRange() {
    return controller_safeRtdTempRange;
  }

  public int getPeriodictasks_schedulers_default_nTasks() {
    return periodictasks_schedulers_default_nTasks;
  }

  public int getPeriodictasks_schedulers_default_nThreads() {
    return periodictasks_schedulers_default_nThreads;
  }

  public String getPublisher_configurationName() {
    return publisher_configurationName;
  }

  public String getPublisher_publicationInterval() {
    return publisher_publicationInterval;
  }

  public String getStatemachine_brakepower_brakeVoltageKey() {
    return statemachine_brakepower_brakeVoltageKey;
  }

  public double getStatemachine_brakepower_powerOnThreshold() {
    return statemachine_brakepower_powerOnThreshold;
  }

  public String getStatemachine_resetSyncTimeout() {
    return statemachine_resetSyncTimeout;
  }

  public String getStatemachine_taskRestartDelay() {
    return statemachine_taskRestartDelay;
  }

  public String getWatchdog_checkInterval() {
    return watchdog_checkInterval;
  }

  @Override
  public String toString() {
    return "Shutter_GeneralConfigurationEvent{" + "version=" + version +
        ", controller_centeringSpeed=" + controller_centeringSpeed +
        ", controller_localAMSaddr=" + controller_localAMSaddr +
        ", controller_maxHallPositionError=" + controller_maxHallPositionError +
        ", controller_maxStrokeSpeed=" + controller_maxStrokeSpeed +
        ", controller_minExposureTime=" + controller_minExposureTime +
        ", controller_noticeReaderRestartDelay=" + controller_noticeReaderRestartDelay +
        ", controller_noticeReaderStartupDelay=" + controller_noticeReaderStartupDelay +
        ", controller_plcAMSaddr=" + controller_plcAMSaddr +
        ", controller_plcAckTimeout=" + controller_plcAckTimeout +
        ", controller_plcIPaddr=" + controller_plcIPaddr +
        ", controller_referenceMinusXpositions=" + controller_referenceMinusXpositions +
        ", controller_referencePlusXpositions=" + controller_referencePlusXpositions +
        ", controller_safeCtrlTempRange=" + controller_safeCtrlTempRange +
        ", controller_safeRtdTempRange=" + controller_safeRtdTempRange +
        ", periodictasks_schedulers_default_nTasks=" + periodictasks_schedulers_default_nTasks +
        ", periodictasks_schedulers_default_nThreads=" + periodictasks_schedulers_default_nThreads +
        ", publisher_configurationName=" + publisher_configurationName +
        ", publisher_publicationInterval=" + publisher_publicationInterval +
        ", statemachine_brakepower_brakeVoltageKey=" + statemachine_brakepower_brakeVoltageKey +
        ", statemachine_brakepower_powerOnThreshold=" + statemachine_brakepower_powerOnThreshold +
        ", statemachine_resetSyncTimeout=" + statemachine_resetSyncTimeout +
        ", statemachine_taskRestartDelay=" + statemachine_taskRestartDelay +
        ", watchdog_checkInterval=" + watchdog_checkInterval +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private String version;

    private double controller_centeringSpeed;

    private String controller_localAMSaddr;

    private double controller_maxHallPositionError;

    private double controller_maxStrokeSpeed;

    private String controller_minExposureTime;

    private String controller_noticeReaderRestartDelay;

    private String controller_noticeReaderStartupDelay;

    private String controller_plcAMSaddr;

    private String controller_plcAckTimeout;

    private String controller_plcIPaddr;

    private String controller_referenceMinusXpositions;

    private String controller_referencePlusXpositions;

    private String controller_safeCtrlTempRange;

    private String controller_safeRtdTempRange;

    private int periodictasks_schedulers_default_nTasks;

    private int periodictasks_schedulers_default_nThreads;

    private String publisher_configurationName;

    private String publisher_publicationInterval;

    private String statemachine_brakepower_brakeVoltageKey;

    private double statemachine_brakepower_powerOnThreshold;

    private String statemachine_resetSyncTimeout;

    private String statemachine_taskRestartDelay;

    private String watchdog_checkInterval;

    private Builder() {
    }

    public Builder version(String version) {
      this.version = version;
      return this;
    }

    public Builder controller_centeringSpeed(double controller_centeringSpeed) {
      this.controller_centeringSpeed = controller_centeringSpeed;
      return this;
    }

    public Builder controller_localAMSaddr(String controller_localAMSaddr) {
      this.controller_localAMSaddr = controller_localAMSaddr;
      return this;
    }

    public Builder controller_maxHallPositionError(double controller_maxHallPositionError) {
      this.controller_maxHallPositionError = controller_maxHallPositionError;
      return this;
    }

    public Builder controller_maxStrokeSpeed(double controller_maxStrokeSpeed) {
      this.controller_maxStrokeSpeed = controller_maxStrokeSpeed;
      return this;
    }

    public Builder controller_minExposureTime(String controller_minExposureTime) {
      this.controller_minExposureTime = controller_minExposureTime;
      return this;
    }

    public Builder controller_noticeReaderRestartDelay(String controller_noticeReaderRestartDelay) {
      this.controller_noticeReaderRestartDelay = controller_noticeReaderRestartDelay;
      return this;
    }

    public Builder controller_noticeReaderStartupDelay(String controller_noticeReaderStartupDelay) {
      this.controller_noticeReaderStartupDelay = controller_noticeReaderStartupDelay;
      return this;
    }

    public Builder controller_plcAMSaddr(String controller_plcAMSaddr) {
      this.controller_plcAMSaddr = controller_plcAMSaddr;
      return this;
    }

    public Builder controller_plcAckTimeout(String controller_plcAckTimeout) {
      this.controller_plcAckTimeout = controller_plcAckTimeout;
      return this;
    }

    public Builder controller_plcIPaddr(String controller_plcIPaddr) {
      this.controller_plcIPaddr = controller_plcIPaddr;
      return this;
    }

    public Builder controller_referenceMinusXpositions(String controller_referenceMinusXpositions) {
      this.controller_referenceMinusXpositions = controller_referenceMinusXpositions;
      return this;
    }

    public Builder controller_referencePlusXpositions(String controller_referencePlusXpositions) {
      this.controller_referencePlusXpositions = controller_referencePlusXpositions;
      return this;
    }

    public Builder controller_safeCtrlTempRange(String controller_safeCtrlTempRange) {
      this.controller_safeCtrlTempRange = controller_safeCtrlTempRange;
      return this;
    }

    public Builder controller_safeRtdTempRange(String controller_safeRtdTempRange) {
      this.controller_safeRtdTempRange = controller_safeRtdTempRange;
      return this;
    }

    public Builder periodictasks_schedulers_default_nTasks(
        int periodictasks_schedulers_default_nTasks) {
      this.periodictasks_schedulers_default_nTasks = periodictasks_schedulers_default_nTasks;
      return this;
    }

    public Builder periodictasks_schedulers_default_nThreads(
        int periodictasks_schedulers_default_nThreads) {
      this.periodictasks_schedulers_default_nThreads = periodictasks_schedulers_default_nThreads;
      return this;
    }

    public Builder publisher_configurationName(String publisher_configurationName) {
      this.publisher_configurationName = publisher_configurationName;
      return this;
    }

    public Builder publisher_publicationInterval(String publisher_publicationInterval) {
      this.publisher_publicationInterval = publisher_publicationInterval;
      return this;
    }

    public Builder statemachine_brakepower_brakeVoltageKey(
        String statemachine_brakepower_brakeVoltageKey) {
      this.statemachine_brakepower_brakeVoltageKey = statemachine_brakepower_brakeVoltageKey;
      return this;
    }

    public Builder statemachine_brakepower_powerOnThreshold(
        double statemachine_brakepower_powerOnThreshold) {
      this.statemachine_brakepower_powerOnThreshold = statemachine_brakepower_powerOnThreshold;
      return this;
    }

    public Builder statemachine_resetSyncTimeout(String statemachine_resetSyncTimeout) {
      this.statemachine_resetSyncTimeout = statemachine_resetSyncTimeout;
      return this;
    }

    public Builder statemachine_taskRestartDelay(String statemachine_taskRestartDelay) {
      this.statemachine_taskRestartDelay = statemachine_taskRestartDelay;
      return this;
    }

    public Builder watchdog_checkInterval(String watchdog_checkInterval) {
      this.watchdog_checkInterval = watchdog_checkInterval;
      return this;
    }

    public Shutter_GeneralConfigurationEvent build() {
      return new Shutter_GeneralConfigurationEvent(version, controller_centeringSpeed, controller_localAMSaddr, controller_maxHallPositionError, controller_maxStrokeSpeed, controller_minExposureTime, controller_noticeReaderRestartDelay, controller_noticeReaderStartupDelay, controller_plcAMSaddr, controller_plcAckTimeout, controller_plcIPaddr, controller_referenceMinusXpositions, controller_referencePlusXpositions, controller_safeCtrlTempRange, controller_safeRtdTempRange, periodictasks_schedulers_default_nTasks, periodictasks_schedulers_default_nThreads, publisher_configurationName, publisher_publicationInterval, statemachine_brakepower_brakeVoltageKey, statemachine_brakepower_powerOnThreshold, statemachine_resetSyncTimeout, statemachine_taskRestartDelay, watchdog_checkInterval);
    }
  }
}
