package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class Rebpower_GeneralConfigurationEvent extends CameraEvent {
  private final String version;

  private final long powerOffSleepMillis;

  private final int psDeviceExcepNumToOffline;

  private final long psDeviceReadTimeout;

  public Rebpower_GeneralConfigurationEvent(String version, long powerOffSleepMillis,
      int psDeviceExcepNumToOffline, long psDeviceReadTimeout) {
    this.version = version;
    this.powerOffSleepMillis = powerOffSleepMillis;
    this.psDeviceExcepNumToOffline = psDeviceExcepNumToOffline;
    this.psDeviceReadTimeout = psDeviceReadTimeout;
  }

  public String getVersion() {
    return version;
  }

  public long getPowerOffSleepMillis() {
    return powerOffSleepMillis;
  }

  public int getPsDeviceExcepNumToOffline() {
    return psDeviceExcepNumToOffline;
  }

  public long getPsDeviceReadTimeout() {
    return psDeviceReadTimeout;
  }

  @Override
  public String toString() {
    return "Rebpower_GeneralConfigurationEvent{" + "version=" + version +
        ", powerOffSleepMillis=" + powerOffSleepMillis +
        ", psDeviceExcepNumToOffline=" + psDeviceExcepNumToOffline +
        ", psDeviceReadTimeout=" + psDeviceReadTimeout +"}";
  }
}
