package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class Hex_GeneralConfigurationEvent extends CameraEvent {
  private final String version;

  private final double lowCryoTempLimit;

  private final double rtnToEvapOffset;

  public Hex_GeneralConfigurationEvent(String version, double lowCryoTempLimit,
      double rtnToEvapOffset) {
    this.version = version;
    this.lowCryoTempLimit = lowCryoTempLimit;
    this.rtnToEvapOffset = rtnToEvapOffset;
  }

  public String getVersion() {
    return version;
  }

  public double getLowCryoTempLimit() {
    return lowCryoTempLimit;
  }

  public double getRtnToEvapOffset() {
    return rtnToEvapOffset;
  }

  @Override
  public String toString() {
    return "Hex_GeneralConfigurationEvent{" + "version=" + version +
        ", lowCryoTempLimit=" + lowCryoTempLimit +", rtnToEvapOffset=" + rtnToEvapOffset +"}";
  }
}
