package org.lsst.sal.camera.event;

import org.lsst.sal.SALEnum;
import org.lsst.sal.camera.CameraEvent;

public class FilterChangerPowerStatusEvent extends CameraEvent {
  private final double timestampStatusChanged;

  private final PowerState powerState;

  public FilterChangerPowerStatusEvent(double timestampStatusChanged, PowerState powerState) {
    this.timestampStatusChanged = timestampStatusChanged;
    this.powerState = powerState;
  }

  public double getTimestampStatusChanged() {
    return timestampStatusChanged;
  }

  public PowerState getPowerState() {
    return powerState;
  }

  @Override
  public String toString() {
    return "FilterChangerPowerStatusEvent{" + "timestampStatusChanged=" + timestampStatusChanged +
        ", powerState=" + powerState +"}";
  }

  public enum PowerState implements SALEnum {
    LOW_POWER,

    HIGH_POWER
  }
}
