package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class ErrorCodeEvent extends CameraEvent {
  private final int errorCode;

  private final String errorReport;

  private final String traceback;

  public ErrorCodeEvent(int errorCode, String errorReport, String traceback) {
    this.errorCode = errorCode;
    this.errorReport = errorReport;
    this.traceback = traceback;
  }

  public int getErrorCode() {
    return errorCode;
  }

  public String getErrorReport() {
    return errorReport;
  }

  public String getTraceback() {
    return traceback;
  }

  @Override
  public String toString() {
    return "ErrorCodeEvent{" + "errorCode=" + errorCode +", errorReport=" + errorReport +
        ", traceback=" + traceback +"}";
  }
}
