package org.lsst.sal.camera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class Vacuum_InstTelemetry extends CameraTelemetry {
  private final double cryoFlineValveState;

  private final double flineCurrent;

  private final double flinePower;

  private final double flineVoltage;

  private final double hxFlineValveState;

  private final double instVac;

  private final double pumpCartCycling;

  private final double pumpCartPressure;

  private final double pumpCartTemperature;

  private final double pumpCartVenting;

  public Vacuum_InstTelemetry(double cryoFlineValveState, double flineCurrent, double flinePower,
      double flineVoltage, double hxFlineValveState, double instVac, double pumpCartCycling,
      double pumpCartPressure, double pumpCartTemperature, double pumpCartVenting) {
    this.cryoFlineValveState = cryoFlineValveState;
    this.flineCurrent = flineCurrent;
    this.flinePower = flinePower;
    this.flineVoltage = flineVoltage;
    this.hxFlineValveState = hxFlineValveState;
    this.instVac = instVac;
    this.pumpCartCycling = pumpCartCycling;
    this.pumpCartPressure = pumpCartPressure;
    this.pumpCartTemperature = pumpCartTemperature;
    this.pumpCartVenting = pumpCartVenting;
  }

  public double getCryoFlineValveState() {
    return cryoFlineValveState;
  }

  public double getFlineCurrent() {
    return flineCurrent;
  }

  public double getFlinePower() {
    return flinePower;
  }

  public double getFlineVoltage() {
    return flineVoltage;
  }

  public double getHxFlineValveState() {
    return hxFlineValveState;
  }

  public double getInstVac() {
    return instVac;
  }

  public double getPumpCartCycling() {
    return pumpCartCycling;
  }

  public double getPumpCartPressure() {
    return pumpCartPressure;
  }

  public double getPumpCartTemperature() {
    return pumpCartTemperature;
  }

  public double getPumpCartVenting() {
    return pumpCartVenting;
  }

  @Override
  public String toString() {
    return "Vacuum_InstTelemetry{" + "cryoFlineValveState=" + cryoFlineValveState +
        ", flineCurrent=" + flineCurrent +", flinePower=" + flinePower +
        ", flineVoltage=" + flineVoltage +", hxFlineValveState=" + hxFlineValveState +
        ", instVac=" + instVac +", pumpCartCycling=" + pumpCartCycling +
        ", pumpCartPressure=" + pumpCartPressure +", pumpCartTemperature=" + pumpCartTemperature +
        ", pumpCartVenting=" + pumpCartVenting +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private double cryoFlineValveState;

    private double flineCurrent;

    private double flinePower;

    private double flineVoltage;

    private double hxFlineValveState;

    private double instVac;

    private double pumpCartCycling;

    private double pumpCartPressure;

    private double pumpCartTemperature;

    private double pumpCartVenting;

    private Builder() {
    }

    public Builder cryoFlineValveState(double cryoFlineValveState) {
      this.cryoFlineValveState = cryoFlineValveState;
      return this;
    }

    public Builder flineCurrent(double flineCurrent) {
      this.flineCurrent = flineCurrent;
      return this;
    }

    public Builder flinePower(double flinePower) {
      this.flinePower = flinePower;
      return this;
    }

    public Builder flineVoltage(double flineVoltage) {
      this.flineVoltage = flineVoltage;
      return this;
    }

    public Builder hxFlineValveState(double hxFlineValveState) {
      this.hxFlineValveState = hxFlineValveState;
      return this;
    }

    public Builder instVac(double instVac) {
      this.instVac = instVac;
      return this;
    }

    public Builder pumpCartCycling(double pumpCartCycling) {
      this.pumpCartCycling = pumpCartCycling;
      return this;
    }

    public Builder pumpCartPressure(double pumpCartPressure) {
      this.pumpCartPressure = pumpCartPressure;
      return this;
    }

    public Builder pumpCartTemperature(double pumpCartTemperature) {
      this.pumpCartTemperature = pumpCartTemperature;
      return this;
    }

    public Builder pumpCartVenting(double pumpCartVenting) {
      this.pumpCartVenting = pumpCartVenting;
      return this;
    }

    public Vacuum_InstTelemetry build() {
      return new Vacuum_InstTelemetry(cryoFlineValveState, flineCurrent, flinePower, flineVoltage, hxFlineValveState, instVac, pumpCartCycling, pumpCartPressure, pumpCartTemperature, pumpCartVenting);
    }
  }
}
