package org.lsst.sal.camera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class Hex_Cryo4Telemetry extends CameraTelemetry {
  private final double c3ExitTmp;

  private final double c4ExitTmp;

  private final double evapExitTmp;

  private final double hexRtrnTmp;

  private final double liquidPrs;

  private final double preC3Tmp;

  private final double preC4Tmp;

  private final double returnPrs;

  private final double vaporPrs;

  public Hex_Cryo4Telemetry(double c3ExitTmp, double c4ExitTmp, double evapExitTmp,
      double hexRtrnTmp, double liquidPrs, double preC3Tmp, double preC4Tmp, double returnPrs,
      double vaporPrs) {
    this.c3ExitTmp = c3ExitTmp;
    this.c4ExitTmp = c4ExitTmp;
    this.evapExitTmp = evapExitTmp;
    this.hexRtrnTmp = hexRtrnTmp;
    this.liquidPrs = liquidPrs;
    this.preC3Tmp = preC3Tmp;
    this.preC4Tmp = preC4Tmp;
    this.returnPrs = returnPrs;
    this.vaporPrs = vaporPrs;
  }

  public double getC3ExitTmp() {
    return c3ExitTmp;
  }

  public double getC4ExitTmp() {
    return c4ExitTmp;
  }

  public double getEvapExitTmp() {
    return evapExitTmp;
  }

  public double getHexRtrnTmp() {
    return hexRtrnTmp;
  }

  public double getLiquidPrs() {
    return liquidPrs;
  }

  public double getPreC3Tmp() {
    return preC3Tmp;
  }

  public double getPreC4Tmp() {
    return preC4Tmp;
  }

  public double getReturnPrs() {
    return returnPrs;
  }

  public double getVaporPrs() {
    return vaporPrs;
  }

  @Override
  public String toString() {
    return "Hex_Cryo4Telemetry{" + "c3ExitTmp=" + c3ExitTmp +", c4ExitTmp=" + c4ExitTmp +
        ", evapExitTmp=" + evapExitTmp +", hexRtrnTmp=" + hexRtrnTmp +", liquidPrs=" + liquidPrs +
        ", preC3Tmp=" + preC3Tmp +", preC4Tmp=" + preC4Tmp +", returnPrs=" + returnPrs +
        ", vaporPrs=" + vaporPrs +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private double c3ExitTmp;

    private double c4ExitTmp;

    private double evapExitTmp;

    private double hexRtrnTmp;

    private double liquidPrs;

    private double preC3Tmp;

    private double preC4Tmp;

    private double returnPrs;

    private double vaporPrs;

    private Builder() {
    }

    public Builder c3ExitTmp(double c3ExitTmp) {
      this.c3ExitTmp = c3ExitTmp;
      return this;
    }

    public Builder c4ExitTmp(double c4ExitTmp) {
      this.c4ExitTmp = c4ExitTmp;
      return this;
    }

    public Builder evapExitTmp(double evapExitTmp) {
      this.evapExitTmp = evapExitTmp;
      return this;
    }

    public Builder hexRtrnTmp(double hexRtrnTmp) {
      this.hexRtrnTmp = hexRtrnTmp;
      return this;
    }

    public Builder liquidPrs(double liquidPrs) {
      this.liquidPrs = liquidPrs;
      return this;
    }

    public Builder preC3Tmp(double preC3Tmp) {
      this.preC3Tmp = preC3Tmp;
      return this;
    }

    public Builder preC4Tmp(double preC4Tmp) {
      this.preC4Tmp = preC4Tmp;
      return this;
    }

    public Builder returnPrs(double returnPrs) {
      this.returnPrs = returnPrs;
      return this;
    }

    public Builder vaporPrs(double vaporPrs) {
      this.vaporPrs = vaporPrs;
      return this;
    }

    public Hex_Cryo4Telemetry build() {
      return new Hex_Cryo4Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs);
    }
  }
}
