package org.lsst.sal.camera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class Chiller_Maq20Telemetry extends CameraTelemetry {
  private final double ambientTemp;

  private final double coldPlHeatXfer;

  private final double coolantHXOut;

  private final double coolantHeatXfer;

  private final double coolantPumpIn;

  private final double coolantPumpOut;

  private final double coolantReturn;

  private final double coolantSupply;

  private final double glycChillerIn;

  private final double glycChillerOut;

  private final double glycCondensOut;

  private final double glycDeSuHtrFlow;

  private final double glycDeSuHtrOut;

  private final double glycFanIn;

  private final double glycFanOut;

  private final double glycHeatXfer;

  private final double glycInputFlow;

  private final double pBurstReturn;

  private final double pBurstSupply;

  private final double stg1CondensOut;

  private final double stg1Discharge;

  private final double stg1Return;

  private final double stg1TXVBulb;

  private final double stg2DeSuHtrOut;

  private final double stg2Discharge;

  private final double stg2DischargeP;

  private final double stg2EvapIn;

  private final double stg2EvapOut;

  private final double stg2Return;

  public Chiller_Maq20Telemetry(double ambientTemp, double coldPlHeatXfer, double coolantHXOut,
      double coolantHeatXfer, double coolantPumpIn, double coolantPumpOut, double coolantReturn,
      double coolantSupply, double glycChillerIn, double glycChillerOut, double glycCondensOut,
      double glycDeSuHtrFlow, double glycDeSuHtrOut, double glycFanIn, double glycFanOut,
      double glycHeatXfer, double glycInputFlow, double pBurstReturn, double pBurstSupply,
      double stg1CondensOut, double stg1Discharge, double stg1Return, double stg1TXVBulb,
      double stg2DeSuHtrOut, double stg2Discharge, double stg2DischargeP, double stg2EvapIn,
      double stg2EvapOut, double stg2Return) {
    this.ambientTemp = ambientTemp;
    this.coldPlHeatXfer = coldPlHeatXfer;
    this.coolantHXOut = coolantHXOut;
    this.coolantHeatXfer = coolantHeatXfer;
    this.coolantPumpIn = coolantPumpIn;
    this.coolantPumpOut = coolantPumpOut;
    this.coolantReturn = coolantReturn;
    this.coolantSupply = coolantSupply;
    this.glycChillerIn = glycChillerIn;
    this.glycChillerOut = glycChillerOut;
    this.glycCondensOut = glycCondensOut;
    this.glycDeSuHtrFlow = glycDeSuHtrFlow;
    this.glycDeSuHtrOut = glycDeSuHtrOut;
    this.glycFanIn = glycFanIn;
    this.glycFanOut = glycFanOut;
    this.glycHeatXfer = glycHeatXfer;
    this.glycInputFlow = glycInputFlow;
    this.pBurstReturn = pBurstReturn;
    this.pBurstSupply = pBurstSupply;
    this.stg1CondensOut = stg1CondensOut;
    this.stg1Discharge = stg1Discharge;
    this.stg1Return = stg1Return;
    this.stg1TXVBulb = stg1TXVBulb;
    this.stg2DeSuHtrOut = stg2DeSuHtrOut;
    this.stg2Discharge = stg2Discharge;
    this.stg2DischargeP = stg2DischargeP;
    this.stg2EvapIn = stg2EvapIn;
    this.stg2EvapOut = stg2EvapOut;
    this.stg2Return = stg2Return;
  }

  public double getAmbientTemp() {
    return ambientTemp;
  }

  public double getColdPlHeatXfer() {
    return coldPlHeatXfer;
  }

  public double getCoolantHXOut() {
    return coolantHXOut;
  }

  public double getCoolantHeatXfer() {
    return coolantHeatXfer;
  }

  public double getCoolantPumpIn() {
    return coolantPumpIn;
  }

  public double getCoolantPumpOut() {
    return coolantPumpOut;
  }

  public double getCoolantReturn() {
    return coolantReturn;
  }

  public double getCoolantSupply() {
    return coolantSupply;
  }

  public double getGlycChillerIn() {
    return glycChillerIn;
  }

  public double getGlycChillerOut() {
    return glycChillerOut;
  }

  public double getGlycCondensOut() {
    return glycCondensOut;
  }

  public double getGlycDeSuHtrFlow() {
    return glycDeSuHtrFlow;
  }

  public double getGlycDeSuHtrOut() {
    return glycDeSuHtrOut;
  }

  public double getGlycFanIn() {
    return glycFanIn;
  }

  public double getGlycFanOut() {
    return glycFanOut;
  }

  public double getGlycHeatXfer() {
    return glycHeatXfer;
  }

  public double getGlycInputFlow() {
    return glycInputFlow;
  }

  public double getPBurstReturn() {
    return pBurstReturn;
  }

  public double getPBurstSupply() {
    return pBurstSupply;
  }

  public double getStg1CondensOut() {
    return stg1CondensOut;
  }

  public double getStg1Discharge() {
    return stg1Discharge;
  }

  public double getStg1Return() {
    return stg1Return;
  }

  public double getStg1TXVBulb() {
    return stg1TXVBulb;
  }

  public double getStg2DeSuHtrOut() {
    return stg2DeSuHtrOut;
  }

  public double getStg2Discharge() {
    return stg2Discharge;
  }

  public double getStg2DischargeP() {
    return stg2DischargeP;
  }

  public double getStg2EvapIn() {
    return stg2EvapIn;
  }

  public double getStg2EvapOut() {
    return stg2EvapOut;
  }

  public double getStg2Return() {
    return stg2Return;
  }

  @Override
  public String toString() {
    return "Chiller_Maq20Telemetry{" + "ambientTemp=" + ambientTemp +
        ", coldPlHeatXfer=" + coldPlHeatXfer +", coolantHXOut=" + coolantHXOut +
        ", coolantHeatXfer=" + coolantHeatXfer +", coolantPumpIn=" + coolantPumpIn +
        ", coolantPumpOut=" + coolantPumpOut +", coolantReturn=" + coolantReturn +
        ", coolantSupply=" + coolantSupply +", glycChillerIn=" + glycChillerIn +
        ", glycChillerOut=" + glycChillerOut +", glycCondensOut=" + glycCondensOut +
        ", glycDeSuHtrFlow=" + glycDeSuHtrFlow +", glycDeSuHtrOut=" + glycDeSuHtrOut +
        ", glycFanIn=" + glycFanIn +", glycFanOut=" + glycFanOut +", glycHeatXfer=" + glycHeatXfer +
        ", glycInputFlow=" + glycInputFlow +", pBurstReturn=" + pBurstReturn +
        ", pBurstSupply=" + pBurstSupply +", stg1CondensOut=" + stg1CondensOut +
        ", stg1Discharge=" + stg1Discharge +", stg1Return=" + stg1Return +
        ", stg1TXVBulb=" + stg1TXVBulb +", stg2DeSuHtrOut=" + stg2DeSuHtrOut +
        ", stg2Discharge=" + stg2Discharge +", stg2DischargeP=" + stg2DischargeP +
        ", stg2EvapIn=" + stg2EvapIn +", stg2EvapOut=" + stg2EvapOut +", stg2Return=" + stg2Return +
        "}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private double ambientTemp;

    private double coldPlHeatXfer;

    private double coolantHXOut;

    private double coolantHeatXfer;

    private double coolantPumpIn;

    private double coolantPumpOut;

    private double coolantReturn;

    private double coolantSupply;

    private double glycChillerIn;

    private double glycChillerOut;

    private double glycCondensOut;

    private double glycDeSuHtrFlow;

    private double glycDeSuHtrOut;

    private double glycFanIn;

    private double glycFanOut;

    private double glycHeatXfer;

    private double glycInputFlow;

    private double pBurstReturn;

    private double pBurstSupply;

    private double stg1CondensOut;

    private double stg1Discharge;

    private double stg1Return;

    private double stg1TXVBulb;

    private double stg2DeSuHtrOut;

    private double stg2Discharge;

    private double stg2DischargeP;

    private double stg2EvapIn;

    private double stg2EvapOut;

    private double stg2Return;

    private Builder() {
    }

    public Builder ambientTemp(double ambientTemp) {
      this.ambientTemp = ambientTemp;
      return this;
    }

    public Builder coldPlHeatXfer(double coldPlHeatXfer) {
      this.coldPlHeatXfer = coldPlHeatXfer;
      return this;
    }

    public Builder coolantHXOut(double coolantHXOut) {
      this.coolantHXOut = coolantHXOut;
      return this;
    }

    public Builder coolantHeatXfer(double coolantHeatXfer) {
      this.coolantHeatXfer = coolantHeatXfer;
      return this;
    }

    public Builder coolantPumpIn(double coolantPumpIn) {
      this.coolantPumpIn = coolantPumpIn;
      return this;
    }

    public Builder coolantPumpOut(double coolantPumpOut) {
      this.coolantPumpOut = coolantPumpOut;
      return this;
    }

    public Builder coolantReturn(double coolantReturn) {
      this.coolantReturn = coolantReturn;
      return this;
    }

    public Builder coolantSupply(double coolantSupply) {
      this.coolantSupply = coolantSupply;
      return this;
    }

    public Builder glycChillerIn(double glycChillerIn) {
      this.glycChillerIn = glycChillerIn;
      return this;
    }

    public Builder glycChillerOut(double glycChillerOut) {
      this.glycChillerOut = glycChillerOut;
      return this;
    }

    public Builder glycCondensOut(double glycCondensOut) {
      this.glycCondensOut = glycCondensOut;
      return this;
    }

    public Builder glycDeSuHtrFlow(double glycDeSuHtrFlow) {
      this.glycDeSuHtrFlow = glycDeSuHtrFlow;
      return this;
    }

    public Builder glycDeSuHtrOut(double glycDeSuHtrOut) {
      this.glycDeSuHtrOut = glycDeSuHtrOut;
      return this;
    }

    public Builder glycFanIn(double glycFanIn) {
      this.glycFanIn = glycFanIn;
      return this;
    }

    public Builder glycFanOut(double glycFanOut) {
      this.glycFanOut = glycFanOut;
      return this;
    }

    public Builder glycHeatXfer(double glycHeatXfer) {
      this.glycHeatXfer = glycHeatXfer;
      return this;
    }

    public Builder glycInputFlow(double glycInputFlow) {
      this.glycInputFlow = glycInputFlow;
      return this;
    }

    public Builder pBurstReturn(double pBurstReturn) {
      this.pBurstReturn = pBurstReturn;
      return this;
    }

    public Builder pBurstSupply(double pBurstSupply) {
      this.pBurstSupply = pBurstSupply;
      return this;
    }

    public Builder stg1CondensOut(double stg1CondensOut) {
      this.stg1CondensOut = stg1CondensOut;
      return this;
    }

    public Builder stg1Discharge(double stg1Discharge) {
      this.stg1Discharge = stg1Discharge;
      return this;
    }

    public Builder stg1Return(double stg1Return) {
      this.stg1Return = stg1Return;
      return this;
    }

    public Builder stg1TXVBulb(double stg1TXVBulb) {
      this.stg1TXVBulb = stg1TXVBulb;
      return this;
    }

    public Builder stg2DeSuHtrOut(double stg2DeSuHtrOut) {
      this.stg2DeSuHtrOut = stg2DeSuHtrOut;
      return this;
    }

    public Builder stg2Discharge(double stg2Discharge) {
      this.stg2Discharge = stg2Discharge;
      return this;
    }

    public Builder stg2DischargeP(double stg2DischargeP) {
      this.stg2DischargeP = stg2DischargeP;
      return this;
    }

    public Builder stg2EvapIn(double stg2EvapIn) {
      this.stg2EvapIn = stg2EvapIn;
      return this;
    }

    public Builder stg2EvapOut(double stg2EvapOut) {
      this.stg2EvapOut = stg2EvapOut;
      return this;
    }

    public Builder stg2Return(double stg2Return) {
      this.stg2Return = stg2Return;
      return this;
    }

    public Chiller_Maq20Telemetry build() {
      return new Chiller_Maq20Telemetry(ambientTemp, coldPlHeatXfer, coolantHXOut, coolantHeatXfer, coolantPumpIn, coolantPumpOut, coolantReturn, coolantSupply, glycChillerIn, glycChillerOut, glycCondensOut, glycDeSuHtrFlow, glycDeSuHtrOut, glycFanIn, glycFanOut, glycHeatXfer, glycInputFlow, pBurstReturn, pBurstSupply, stg1CondensOut, stg1Discharge, stg1Return, stg1TXVBulb, stg2DeSuHtrOut, stg2Discharge, stg2DischargeP, stg2EvapIn, stg2EvapOut, stg2Return);
    }
  }
}
