package org.lsst.sal.camera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class Chiller_FParam_TrendingTelemetry extends CameraTelemetry {
  private final double bubblev_TIME;

  private final double clr_KI_SETPT;

  private final double cold_PERIOD;

  private final double cool_CAPACITY;

  private final double dut_DT_HI;

  private final double dut_DT_LO;

  private final double dut_KI;

  private final double dut_KP;

  private final double dut_TMAX;

  private final double dut_TMIN;

  private final double flowmeter_LO;

  private final double flow_ERR_MASK;

  private final double heat_CAPACITY;

  private final double heat_PERIOD;

  private final double pid_GAINFAC;

  private final double pid_KD;

  private final double pid_KI;

  private final double pid_KP;

  private final double purge_TIME;

  private final double ramp_DEFAULT;

  private final double refrig_OFF;

  private final double setpt_SETTLE;

  private final double setpt_TOL;

  private final double tank_SETPOINT;

  private final double thermsl_MASS;

  private final double t_CTRL_MODE;

  public Chiller_FParam_TrendingTelemetry(double bubblev_TIME, double clr_KI_SETPT,
      double cold_PERIOD, double cool_CAPACITY, double dut_DT_HI, double dut_DT_LO, double dut_KI,
      double dut_KP, double dut_TMAX, double dut_TMIN, double flowmeter_LO, double flow_ERR_MASK,
      double heat_CAPACITY, double heat_PERIOD, double pid_GAINFAC, double pid_KD, double pid_KI,
      double pid_KP, double purge_TIME, double ramp_DEFAULT, double refrig_OFF, double setpt_SETTLE,
      double setpt_TOL, double tank_SETPOINT, double thermsl_MASS, double t_CTRL_MODE) {
    this.bubblev_TIME = bubblev_TIME;
    this.clr_KI_SETPT = clr_KI_SETPT;
    this.cold_PERIOD = cold_PERIOD;
    this.cool_CAPACITY = cool_CAPACITY;
    this.dut_DT_HI = dut_DT_HI;
    this.dut_DT_LO = dut_DT_LO;
    this.dut_KI = dut_KI;
    this.dut_KP = dut_KP;
    this.dut_TMAX = dut_TMAX;
    this.dut_TMIN = dut_TMIN;
    this.flowmeter_LO = flowmeter_LO;
    this.flow_ERR_MASK = flow_ERR_MASK;
    this.heat_CAPACITY = heat_CAPACITY;
    this.heat_PERIOD = heat_PERIOD;
    this.pid_GAINFAC = pid_GAINFAC;
    this.pid_KD = pid_KD;
    this.pid_KI = pid_KI;
    this.pid_KP = pid_KP;
    this.purge_TIME = purge_TIME;
    this.ramp_DEFAULT = ramp_DEFAULT;
    this.refrig_OFF = refrig_OFF;
    this.setpt_SETTLE = setpt_SETTLE;
    this.setpt_TOL = setpt_TOL;
    this.tank_SETPOINT = tank_SETPOINT;
    this.thermsl_MASS = thermsl_MASS;
    this.t_CTRL_MODE = t_CTRL_MODE;
  }

  public double getBubblev_TIME() {
    return bubblev_TIME;
  }

  public double getClr_KI_SETPT() {
    return clr_KI_SETPT;
  }

  public double getCold_PERIOD() {
    return cold_PERIOD;
  }

  public double getCool_CAPACITY() {
    return cool_CAPACITY;
  }

  public double getDut_DT_HI() {
    return dut_DT_HI;
  }

  public double getDut_DT_LO() {
    return dut_DT_LO;
  }

  public double getDut_KI() {
    return dut_KI;
  }

  public double getDut_KP() {
    return dut_KP;
  }

  public double getDut_TMAX() {
    return dut_TMAX;
  }

  public double getDut_TMIN() {
    return dut_TMIN;
  }

  public double getFlowmeter_LO() {
    return flowmeter_LO;
  }

  public double getFlow_ERR_MASK() {
    return flow_ERR_MASK;
  }

  public double getHeat_CAPACITY() {
    return heat_CAPACITY;
  }

  public double getHeat_PERIOD() {
    return heat_PERIOD;
  }

  public double getPid_GAINFAC() {
    return pid_GAINFAC;
  }

  public double getPid_KD() {
    return pid_KD;
  }

  public double getPid_KI() {
    return pid_KI;
  }

  public double getPid_KP() {
    return pid_KP;
  }

  public double getPurge_TIME() {
    return purge_TIME;
  }

  public double getRamp_DEFAULT() {
    return ramp_DEFAULT;
  }

  public double getRefrig_OFF() {
    return refrig_OFF;
  }

  public double getSetpt_SETTLE() {
    return setpt_SETTLE;
  }

  public double getSetpt_TOL() {
    return setpt_TOL;
  }

  public double getTank_SETPOINT() {
    return tank_SETPOINT;
  }

  public double getThermsl_MASS() {
    return thermsl_MASS;
  }

  public double getT_CTRL_MODE() {
    return t_CTRL_MODE;
  }

  @Override
  public String toString() {
    return "Chiller_FParam_TrendingTelemetry{" + "bubblev_TIME=" + bubblev_TIME +
        ", clr_KI_SETPT=" + clr_KI_SETPT +", cold_PERIOD=" + cold_PERIOD +
        ", cool_CAPACITY=" + cool_CAPACITY +", dut_DT_HI=" + dut_DT_HI +", dut_DT_LO=" + dut_DT_LO +
        ", dut_KI=" + dut_KI +", dut_KP=" + dut_KP +", dut_TMAX=" + dut_TMAX +
        ", dut_TMIN=" + dut_TMIN +", flowmeter_LO=" + flowmeter_LO +
        ", flow_ERR_MASK=" + flow_ERR_MASK +", heat_CAPACITY=" + heat_CAPACITY +
        ", heat_PERIOD=" + heat_PERIOD +", pid_GAINFAC=" + pid_GAINFAC +", pid_KD=" + pid_KD +
        ", pid_KI=" + pid_KI +", pid_KP=" + pid_KP +", purge_TIME=" + purge_TIME +
        ", ramp_DEFAULT=" + ramp_DEFAULT +", refrig_OFF=" + refrig_OFF +
        ", setpt_SETTLE=" + setpt_SETTLE +", setpt_TOL=" + setpt_TOL +
        ", tank_SETPOINT=" + tank_SETPOINT +", thermsl_MASS=" + thermsl_MASS +
        ", t_CTRL_MODE=" + t_CTRL_MODE +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private double bubblev_TIME;

    private double clr_KI_SETPT;

    private double cold_PERIOD;

    private double cool_CAPACITY;

    private double dut_DT_HI;

    private double dut_DT_LO;

    private double dut_KI;

    private double dut_KP;

    private double dut_TMAX;

    private double dut_TMIN;

    private double flowmeter_LO;

    private double flow_ERR_MASK;

    private double heat_CAPACITY;

    private double heat_PERIOD;

    private double pid_GAINFAC;

    private double pid_KD;

    private double pid_KI;

    private double pid_KP;

    private double purge_TIME;

    private double ramp_DEFAULT;

    private double refrig_OFF;

    private double setpt_SETTLE;

    private double setpt_TOL;

    private double tank_SETPOINT;

    private double thermsl_MASS;

    private double t_CTRL_MODE;

    private Builder() {
    }

    public Builder bubblev_TIME(double bubblev_TIME) {
      this.bubblev_TIME = bubblev_TIME;
      return this;
    }

    public Builder clr_KI_SETPT(double clr_KI_SETPT) {
      this.clr_KI_SETPT = clr_KI_SETPT;
      return this;
    }

    public Builder cold_PERIOD(double cold_PERIOD) {
      this.cold_PERIOD = cold_PERIOD;
      return this;
    }

    public Builder cool_CAPACITY(double cool_CAPACITY) {
      this.cool_CAPACITY = cool_CAPACITY;
      return this;
    }

    public Builder dut_DT_HI(double dut_DT_HI) {
      this.dut_DT_HI = dut_DT_HI;
      return this;
    }

    public Builder dut_DT_LO(double dut_DT_LO) {
      this.dut_DT_LO = dut_DT_LO;
      return this;
    }

    public Builder dut_KI(double dut_KI) {
      this.dut_KI = dut_KI;
      return this;
    }

    public Builder dut_KP(double dut_KP) {
      this.dut_KP = dut_KP;
      return this;
    }

    public Builder dut_TMAX(double dut_TMAX) {
      this.dut_TMAX = dut_TMAX;
      return this;
    }

    public Builder dut_TMIN(double dut_TMIN) {
      this.dut_TMIN = dut_TMIN;
      return this;
    }

    public Builder flowmeter_LO(double flowmeter_LO) {
      this.flowmeter_LO = flowmeter_LO;
      return this;
    }

    public Builder flow_ERR_MASK(double flow_ERR_MASK) {
      this.flow_ERR_MASK = flow_ERR_MASK;
      return this;
    }

    public Builder heat_CAPACITY(double heat_CAPACITY) {
      this.heat_CAPACITY = heat_CAPACITY;
      return this;
    }

    public Builder heat_PERIOD(double heat_PERIOD) {
      this.heat_PERIOD = heat_PERIOD;
      return this;
    }

    public Builder pid_GAINFAC(double pid_GAINFAC) {
      this.pid_GAINFAC = pid_GAINFAC;
      return this;
    }

    public Builder pid_KD(double pid_KD) {
      this.pid_KD = pid_KD;
      return this;
    }

    public Builder pid_KI(double pid_KI) {
      this.pid_KI = pid_KI;
      return this;
    }

    public Builder pid_KP(double pid_KP) {
      this.pid_KP = pid_KP;
      return this;
    }

    public Builder purge_TIME(double purge_TIME) {
      this.purge_TIME = purge_TIME;
      return this;
    }

    public Builder ramp_DEFAULT(double ramp_DEFAULT) {
      this.ramp_DEFAULT = ramp_DEFAULT;
      return this;
    }

    public Builder refrig_OFF(double refrig_OFF) {
      this.refrig_OFF = refrig_OFF;
      return this;
    }

    public Builder setpt_SETTLE(double setpt_SETTLE) {
      this.setpt_SETTLE = setpt_SETTLE;
      return this;
    }

    public Builder setpt_TOL(double setpt_TOL) {
      this.setpt_TOL = setpt_TOL;
      return this;
    }

    public Builder tank_SETPOINT(double tank_SETPOINT) {
      this.tank_SETPOINT = tank_SETPOINT;
      return this;
    }

    public Builder thermsl_MASS(double thermsl_MASS) {
      this.thermsl_MASS = thermsl_MASS;
      return this;
    }

    public Builder t_CTRL_MODE(double t_CTRL_MODE) {
      this.t_CTRL_MODE = t_CTRL_MODE;
      return this;
    }

    public Chiller_FParam_TrendingTelemetry build() {
      return new Chiller_FParam_TrendingTelemetry(bubblev_TIME, clr_KI_SETPT, cold_PERIOD, cool_CAPACITY, dut_DT_HI, dut_DT_LO, dut_KI, dut_KP, dut_TMAX, dut_TMIN, flowmeter_LO, flow_ERR_MASK, heat_CAPACITY, heat_PERIOD, pid_GAINFAC, pid_KD, pid_KI, pid_KP, purge_TIME, ramp_DEFAULT, refrig_OFF, setpt_SETTLE, setpt_TOL, tank_SETPOINT, thermsl_MASS, t_CTRL_MODE);
    }
  }
}
