package org.lsst.sal.camera.states;

import org.lsst.sal.SALEnum;
import org.lsst.sal.camera.CameraStateChangeEvent;

public class ShutterDetailedStateEvent extends CameraStateChangeEvent {
  private final ShutterState substate;

  private final double timestampTransition;

  public ShutterDetailedStateEvent(ShutterState substate, double timestampTransition) {
    this.substate = substate;
    this.timestampTransition = timestampTransition;
  }

  @Override
  public ShutterState getSubstate() {
    return substate;
  }

  public double getTimestampTransition() {
    return timestampTransition;
  }

  @Override
  public String toString() {
    return "ShutterDetailedStateEvent{" + "substate=" + substate +
        ", timestampTransition=" + timestampTransition +"}";
  }

  public enum ShutterState implements SALEnum {
    CLOSED,

    OPEN,

    CLOSING,

    OPENING
  }
}
