package org.lsst.sal.camera.states;

import org.lsst.sal.SALEnum;
import org.lsst.sal.camera.CameraStateChangeEvent;

public class OfflineDetailedStateEvent extends CameraStateChangeEvent {
  private final OfflineState substate;

  private final double timestampTransition;

  public OfflineDetailedStateEvent(OfflineState substate, double timestampTransition) {
    this.substate = substate;
    this.timestampTransition = timestampTransition;
  }

  @Override
  public OfflineState getSubstate() {
    return substate;
  }

  public double getTimestampTransition() {
    return timestampTransition;
  }

  @Override
  public String toString() {
    return "OfflineDetailedStateEvent{" + "substate=" + substate +
        ", timestampTransition=" + timestampTransition +"}";
  }

  public enum OfflineState implements SALEnum {
    OFFLINE_AVAILABLE,

    OFFLINE_PUBLISH_ONLY
  }
}
