package org.lsst.sal.camera.event;

import java.util.Arrays;
import org.lsst.sal.camera.CameraEvent;

public class Thermal_RefrigConfigurationEvent extends CameraEvent {
  private final String version;

  private final double coldtempctrlc_tempDeadband;

  private final double coldtempctrlc_tempLimit;

  private final String coldtempctrlc_tempWeights;

  private final double coldtempctrlmye_tempDeadband;

  private final double coldtempctrlmye_tempLimit;

  private final String coldtempctrlmye_tempWeights;

  private final double coldtempctrlpye_tempDeadband;

  private final double coldtempctrlpye_tempLimit;

  private final String coldtempctrlpye_tempWeights;

  private final double cryotempctrl_tempDeadband;

  private final double cryotempctrl_tempLimit;

  private final String cryotempctrl_tempWeights;

  private final double[] trimpower_coldPowerWeights;

  private final String trimpower_connType;

  private final double[] trimpower_cryoPowerWeights;

  private final String trimpower_devcId;

  private final int trimpower_devcParm;

  private final int trimpower_node;

  public Thermal_RefrigConfigurationEvent(String version, double coldtempctrlc_tempDeadband,
      double coldtempctrlc_tempLimit, String coldtempctrlc_tempWeights,
      double coldtempctrlmye_tempDeadband, double coldtempctrlmye_tempLimit,
      String coldtempctrlmye_tempWeights, double coldtempctrlpye_tempDeadband,
      double coldtempctrlpye_tempLimit, String coldtempctrlpye_tempWeights,
      double cryotempctrl_tempDeadband, double cryotempctrl_tempLimit,
      String cryotempctrl_tempWeights, double[] trimpower_coldPowerWeights,
      String trimpower_connType, double[] trimpower_cryoPowerWeights, String trimpower_devcId,
      int trimpower_devcParm, int trimpower_node) {
    this.version = version;
    this.coldtempctrlc_tempDeadband = coldtempctrlc_tempDeadband;
    this.coldtempctrlc_tempLimit = coldtempctrlc_tempLimit;
    this.coldtempctrlc_tempWeights = coldtempctrlc_tempWeights;
    this.coldtempctrlmye_tempDeadband = coldtempctrlmye_tempDeadband;
    this.coldtempctrlmye_tempLimit = coldtempctrlmye_tempLimit;
    this.coldtempctrlmye_tempWeights = coldtempctrlmye_tempWeights;
    this.coldtempctrlpye_tempDeadband = coldtempctrlpye_tempDeadband;
    this.coldtempctrlpye_tempLimit = coldtempctrlpye_tempLimit;
    this.coldtempctrlpye_tempWeights = coldtempctrlpye_tempWeights;
    this.cryotempctrl_tempDeadband = cryotempctrl_tempDeadband;
    this.cryotempctrl_tempLimit = cryotempctrl_tempLimit;
    this.cryotempctrl_tempWeights = cryotempctrl_tempWeights;
    this.trimpower_coldPowerWeights = trimpower_coldPowerWeights;
    this.trimpower_connType = trimpower_connType;
    this.trimpower_cryoPowerWeights = trimpower_cryoPowerWeights;
    this.trimpower_devcId = trimpower_devcId;
    this.trimpower_devcParm = trimpower_devcParm;
    this.trimpower_node = trimpower_node;
  }

  public String getVersion() {
    return version;
  }

  public double getColdtempctrlc_tempDeadband() {
    return coldtempctrlc_tempDeadband;
  }

  public double getColdtempctrlc_tempLimit() {
    return coldtempctrlc_tempLimit;
  }

  public String getColdtempctrlc_tempWeights() {
    return coldtempctrlc_tempWeights;
  }

  public double getColdtempctrlmye_tempDeadband() {
    return coldtempctrlmye_tempDeadband;
  }

  public double getColdtempctrlmye_tempLimit() {
    return coldtempctrlmye_tempLimit;
  }

  public String getColdtempctrlmye_tempWeights() {
    return coldtempctrlmye_tempWeights;
  }

  public double getColdtempctrlpye_tempDeadband() {
    return coldtempctrlpye_tempDeadband;
  }

  public double getColdtempctrlpye_tempLimit() {
    return coldtempctrlpye_tempLimit;
  }

  public String getColdtempctrlpye_tempWeights() {
    return coldtempctrlpye_tempWeights;
  }

  public double getCryotempctrl_tempDeadband() {
    return cryotempctrl_tempDeadband;
  }

  public double getCryotempctrl_tempLimit() {
    return cryotempctrl_tempLimit;
  }

  public String getCryotempctrl_tempWeights() {
    return cryotempctrl_tempWeights;
  }

  public double[] getTrimpower_coldPowerWeights() {
    return trimpower_coldPowerWeights;
  }

  public String getTrimpower_connType() {
    return trimpower_connType;
  }

  public double[] getTrimpower_cryoPowerWeights() {
    return trimpower_cryoPowerWeights;
  }

  public String getTrimpower_devcId() {
    return trimpower_devcId;
  }

  public int getTrimpower_devcParm() {
    return trimpower_devcParm;
  }

  public int getTrimpower_node() {
    return trimpower_node;
  }

  @Override
  public String toString() {
    return "Thermal_RefrigConfigurationEvent{" + "version=" + version +
        ", coldtempctrlc_tempDeadband=" + coldtempctrlc_tempDeadband +
        ", coldtempctrlc_tempLimit=" + coldtempctrlc_tempLimit +
        ", coldtempctrlc_tempWeights=" + coldtempctrlc_tempWeights +
        ", coldtempctrlmye_tempDeadband=" + coldtempctrlmye_tempDeadband +
        ", coldtempctrlmye_tempLimit=" + coldtempctrlmye_tempLimit +
        ", coldtempctrlmye_tempWeights=" + coldtempctrlmye_tempWeights +
        ", coldtempctrlpye_tempDeadband=" + coldtempctrlpye_tempDeadband +
        ", coldtempctrlpye_tempLimit=" + coldtempctrlpye_tempLimit +
        ", coldtempctrlpye_tempWeights=" + coldtempctrlpye_tempWeights +
        ", cryotempctrl_tempDeadband=" + cryotempctrl_tempDeadband +
        ", cryotempctrl_tempLimit=" + cryotempctrl_tempLimit +
        ", cryotempctrl_tempWeights=" + cryotempctrl_tempWeights +
        ", trimpower_coldPowerWeights=" + Arrays.toString(trimpower_coldPowerWeights) +
        ", trimpower_connType=" + trimpower_connType +
        ", trimpower_cryoPowerWeights=" + Arrays.toString(trimpower_cryoPowerWeights) +
        ", trimpower_devcId=" + trimpower_devcId +", trimpower_devcParm=" + trimpower_devcParm +
        ", trimpower_node=" + trimpower_node +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private String version;

    private double coldtempctrlc_tempDeadband;

    private double coldtempctrlc_tempLimit;

    private String coldtempctrlc_tempWeights;

    private double coldtempctrlmye_tempDeadband;

    private double coldtempctrlmye_tempLimit;

    private String coldtempctrlmye_tempWeights;

    private double coldtempctrlpye_tempDeadband;

    private double coldtempctrlpye_tempLimit;

    private String coldtempctrlpye_tempWeights;

    private double cryotempctrl_tempDeadband;

    private double cryotempctrl_tempLimit;

    private String cryotempctrl_tempWeights;

    private double[] trimpower_coldPowerWeights;

    private String trimpower_connType;

    private double[] trimpower_cryoPowerWeights;

    private String trimpower_devcId;

    private int trimpower_devcParm;

    private int trimpower_node;

    private Builder() {
    }

    public Builder version(String version) {
      this.version = version;
      return this;
    }

    public Builder coldtempctrlc_tempDeadband(double coldtempctrlc_tempDeadband) {
      this.coldtempctrlc_tempDeadband = coldtempctrlc_tempDeadband;
      return this;
    }

    public Builder coldtempctrlc_tempLimit(double coldtempctrlc_tempLimit) {
      this.coldtempctrlc_tempLimit = coldtempctrlc_tempLimit;
      return this;
    }

    public Builder coldtempctrlc_tempWeights(String coldtempctrlc_tempWeights) {
      this.coldtempctrlc_tempWeights = coldtempctrlc_tempWeights;
      return this;
    }

    public Builder coldtempctrlmye_tempDeadband(double coldtempctrlmye_tempDeadband) {
      this.coldtempctrlmye_tempDeadband = coldtempctrlmye_tempDeadband;
      return this;
    }

    public Builder coldtempctrlmye_tempLimit(double coldtempctrlmye_tempLimit) {
      this.coldtempctrlmye_tempLimit = coldtempctrlmye_tempLimit;
      return this;
    }

    public Builder coldtempctrlmye_tempWeights(String coldtempctrlmye_tempWeights) {
      this.coldtempctrlmye_tempWeights = coldtempctrlmye_tempWeights;
      return this;
    }

    public Builder coldtempctrlpye_tempDeadband(double coldtempctrlpye_tempDeadband) {
      this.coldtempctrlpye_tempDeadband = coldtempctrlpye_tempDeadband;
      return this;
    }

    public Builder coldtempctrlpye_tempLimit(double coldtempctrlpye_tempLimit) {
      this.coldtempctrlpye_tempLimit = coldtempctrlpye_tempLimit;
      return this;
    }

    public Builder coldtempctrlpye_tempWeights(String coldtempctrlpye_tempWeights) {
      this.coldtempctrlpye_tempWeights = coldtempctrlpye_tempWeights;
      return this;
    }

    public Builder cryotempctrl_tempDeadband(double cryotempctrl_tempDeadband) {
      this.cryotempctrl_tempDeadband = cryotempctrl_tempDeadband;
      return this;
    }

    public Builder cryotempctrl_tempLimit(double cryotempctrl_tempLimit) {
      this.cryotempctrl_tempLimit = cryotempctrl_tempLimit;
      return this;
    }

    public Builder cryotempctrl_tempWeights(String cryotempctrl_tempWeights) {
      this.cryotempctrl_tempWeights = cryotempctrl_tempWeights;
      return this;
    }

    public Builder trimpower_coldPowerWeights(double[] trimpower_coldPowerWeights) {
      this.trimpower_coldPowerWeights = trimpower_coldPowerWeights;
      return this;
    }

    public Builder trimpower_connType(String trimpower_connType) {
      this.trimpower_connType = trimpower_connType;
      return this;
    }

    public Builder trimpower_cryoPowerWeights(double[] trimpower_cryoPowerWeights) {
      this.trimpower_cryoPowerWeights = trimpower_cryoPowerWeights;
      return this;
    }

    public Builder trimpower_devcId(String trimpower_devcId) {
      this.trimpower_devcId = trimpower_devcId;
      return this;
    }

    public Builder trimpower_devcParm(int trimpower_devcParm) {
      this.trimpower_devcParm = trimpower_devcParm;
      return this;
    }

    public Builder trimpower_node(int trimpower_node) {
      this.trimpower_node = trimpower_node;
      return this;
    }

    public Thermal_RefrigConfigurationEvent build() {
      return new Thermal_RefrigConfigurationEvent(version, coldtempctrlc_tempDeadband, coldtempctrlc_tempLimit, coldtempctrlc_tempWeights, coldtempctrlmye_tempDeadband, coldtempctrlmye_tempLimit, coldtempctrlmye_tempWeights, coldtempctrlpye_tempDeadband, coldtempctrlpye_tempLimit, coldtempctrlpye_tempWeights, cryotempctrl_tempDeadband, cryotempctrl_tempLimit, cryotempctrl_tempWeights, trimpower_coldPowerWeights, trimpower_connType, trimpower_cryoPowerWeights, trimpower_devcId, trimpower_devcParm, trimpower_node);
    }
  }
}
