package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class Thermal_GeneralConfigurationEvent extends CameraEvent {
  private final String version;

  private final String cold_Temp_AvgColdTemp_chanNames;

  private final String cold_Temp_AvgColdTemp_chanWeights;

  private final boolean cold_Temp_AvgColdTemp_ignoreNaN;

  private final String cryo_Temp_AvgCryoTemp_chanNames;

  private final String cryo_Temp_AvgCryoTemp_chanWeights;

  private final boolean cryo_Temp_AvgCryoTemp_ignoreNaN;

  private final int periodictasks_schedulers_default_nTasks;

  private final int periodictasks_schedulers_default_nThreads;

  private final int periodictasks_schedulers_monitor_check_scheduler_nTasks;

  private final int periodictasks_schedulers_monitor_check_scheduler_nThreads;

  private final int periodictasks_schedulers_monitor_update_publish_scheduler_nTasks;

  private final int periodictasks_schedulers_monitor_update_publish_scheduler_nThreads;

  public Thermal_GeneralConfigurationEvent(String version, String cold_Temp_AvgColdTemp_chanNames,
      String cold_Temp_AvgColdTemp_chanWeights, boolean cold_Temp_AvgColdTemp_ignoreNaN,
      String cryo_Temp_AvgCryoTemp_chanNames, String cryo_Temp_AvgCryoTemp_chanWeights,
      boolean cryo_Temp_AvgCryoTemp_ignoreNaN, int periodictasks_schedulers_default_nTasks,
      int periodictasks_schedulers_default_nThreads,
      int periodictasks_schedulers_monitor_check_scheduler_nTasks,
      int periodictasks_schedulers_monitor_check_scheduler_nThreads,
      int periodictasks_schedulers_monitor_update_publish_scheduler_nTasks,
      int periodictasks_schedulers_monitor_update_publish_scheduler_nThreads) {
    this.version = version;
    this.cold_Temp_AvgColdTemp_chanNames = cold_Temp_AvgColdTemp_chanNames;
    this.cold_Temp_AvgColdTemp_chanWeights = cold_Temp_AvgColdTemp_chanWeights;
    this.cold_Temp_AvgColdTemp_ignoreNaN = cold_Temp_AvgColdTemp_ignoreNaN;
    this.cryo_Temp_AvgCryoTemp_chanNames = cryo_Temp_AvgCryoTemp_chanNames;
    this.cryo_Temp_AvgCryoTemp_chanWeights = cryo_Temp_AvgCryoTemp_chanWeights;
    this.cryo_Temp_AvgCryoTemp_ignoreNaN = cryo_Temp_AvgCryoTemp_ignoreNaN;
    this.periodictasks_schedulers_default_nTasks = periodictasks_schedulers_default_nTasks;
    this.periodictasks_schedulers_default_nThreads = periodictasks_schedulers_default_nThreads;
    this.periodictasks_schedulers_monitor_check_scheduler_nTasks = periodictasks_schedulers_monitor_check_scheduler_nTasks;
    this.periodictasks_schedulers_monitor_check_scheduler_nThreads = periodictasks_schedulers_monitor_check_scheduler_nThreads;
    this.periodictasks_schedulers_monitor_update_publish_scheduler_nTasks = periodictasks_schedulers_monitor_update_publish_scheduler_nTasks;
    this.periodictasks_schedulers_monitor_update_publish_scheduler_nThreads = periodictasks_schedulers_monitor_update_publish_scheduler_nThreads;
  }

  public String getVersion() {
    return version;
  }

  public String getCold_Temp_AvgColdTemp_chanNames() {
    return cold_Temp_AvgColdTemp_chanNames;
  }

  public String getCold_Temp_AvgColdTemp_chanWeights() {
    return cold_Temp_AvgColdTemp_chanWeights;
  }

  public boolean isCold_Temp_AvgColdTemp_ignoreNaN() {
    return cold_Temp_AvgColdTemp_ignoreNaN;
  }

  public String getCryo_Temp_AvgCryoTemp_chanNames() {
    return cryo_Temp_AvgCryoTemp_chanNames;
  }

  public String getCryo_Temp_AvgCryoTemp_chanWeights() {
    return cryo_Temp_AvgCryoTemp_chanWeights;
  }

  public boolean isCryo_Temp_AvgCryoTemp_ignoreNaN() {
    return cryo_Temp_AvgCryoTemp_ignoreNaN;
  }

  public int getPeriodictasks_schedulers_default_nTasks() {
    return periodictasks_schedulers_default_nTasks;
  }

  public int getPeriodictasks_schedulers_default_nThreads() {
    return periodictasks_schedulers_default_nThreads;
  }

  public int getPeriodictasks_schedulers_monitor_check_scheduler_nTasks() {
    return periodictasks_schedulers_monitor_check_scheduler_nTasks;
  }

  public int getPeriodictasks_schedulers_monitor_check_scheduler_nThreads() {
    return periodictasks_schedulers_monitor_check_scheduler_nThreads;
  }

  public int getPeriodictasks_schedulers_monitor_update_publish_scheduler_nTasks() {
    return periodictasks_schedulers_monitor_update_publish_scheduler_nTasks;
  }

  public int getPeriodictasks_schedulers_monitor_update_publish_scheduler_nThreads() {
    return periodictasks_schedulers_monitor_update_publish_scheduler_nThreads;
  }

  @Override
  public String toString() {
    return "Thermal_GeneralConfigurationEvent{" + "version=" + version +
        ", cold_Temp_AvgColdTemp_chanNames=" + cold_Temp_AvgColdTemp_chanNames +
        ", cold_Temp_AvgColdTemp_chanWeights=" + cold_Temp_AvgColdTemp_chanWeights +
        ", cold_Temp_AvgColdTemp_ignoreNaN=" + cold_Temp_AvgColdTemp_ignoreNaN +
        ", cryo_Temp_AvgCryoTemp_chanNames=" + cryo_Temp_AvgCryoTemp_chanNames +
        ", cryo_Temp_AvgCryoTemp_chanWeights=" + cryo_Temp_AvgCryoTemp_chanWeights +
        ", cryo_Temp_AvgCryoTemp_ignoreNaN=" + cryo_Temp_AvgCryoTemp_ignoreNaN +
        ", periodictasks_schedulers_default_nTasks=" + periodictasks_schedulers_default_nTasks +
        ", periodictasks_schedulers_default_nThreads=" + periodictasks_schedulers_default_nThreads +
        ", periodictasks_schedulers_monitor_check_scheduler_nTasks=" + periodictasks_schedulers_monitor_check_scheduler_nTasks +
        ", periodictasks_schedulers_monitor_check_scheduler_nThreads=" + periodictasks_schedulers_monitor_check_scheduler_nThreads +
        ", periodictasks_schedulers_monitor_update_publish_scheduler_nTasks=" + periodictasks_schedulers_monitor_update_publish_scheduler_nTasks +
        ", periodictasks_schedulers_monitor_update_publish_scheduler_nThreads=" + periodictasks_schedulers_monitor_update_publish_scheduler_nThreads +
        "}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private String version;

    private String cold_Temp_AvgColdTemp_chanNames;

    private String cold_Temp_AvgColdTemp_chanWeights;

    private boolean cold_Temp_AvgColdTemp_ignoreNaN;

    private String cryo_Temp_AvgCryoTemp_chanNames;

    private String cryo_Temp_AvgCryoTemp_chanWeights;

    private boolean cryo_Temp_AvgCryoTemp_ignoreNaN;

    private int periodictasks_schedulers_default_nTasks;

    private int periodictasks_schedulers_default_nThreads;

    private int periodictasks_schedulers_monitor_check_scheduler_nTasks;

    private int periodictasks_schedulers_monitor_check_scheduler_nThreads;

    private int periodictasks_schedulers_monitor_update_publish_scheduler_nTasks;

    private int periodictasks_schedulers_monitor_update_publish_scheduler_nThreads;

    private Builder() {
    }

    public Builder version(String version) {
      this.version = version;
      return this;
    }

    public Builder cold_Temp_AvgColdTemp_chanNames(String cold_Temp_AvgColdTemp_chanNames) {
      this.cold_Temp_AvgColdTemp_chanNames = cold_Temp_AvgColdTemp_chanNames;
      return this;
    }

    public Builder cold_Temp_AvgColdTemp_chanWeights(String cold_Temp_AvgColdTemp_chanWeights) {
      this.cold_Temp_AvgColdTemp_chanWeights = cold_Temp_AvgColdTemp_chanWeights;
      return this;
    }

    public Builder cold_Temp_AvgColdTemp_ignoreNaN(boolean cold_Temp_AvgColdTemp_ignoreNaN) {
      this.cold_Temp_AvgColdTemp_ignoreNaN = cold_Temp_AvgColdTemp_ignoreNaN;
      return this;
    }

    public Builder cryo_Temp_AvgCryoTemp_chanNames(String cryo_Temp_AvgCryoTemp_chanNames) {
      this.cryo_Temp_AvgCryoTemp_chanNames = cryo_Temp_AvgCryoTemp_chanNames;
      return this;
    }

    public Builder cryo_Temp_AvgCryoTemp_chanWeights(String cryo_Temp_AvgCryoTemp_chanWeights) {
      this.cryo_Temp_AvgCryoTemp_chanWeights = cryo_Temp_AvgCryoTemp_chanWeights;
      return this;
    }

    public Builder cryo_Temp_AvgCryoTemp_ignoreNaN(boolean cryo_Temp_AvgCryoTemp_ignoreNaN) {
      this.cryo_Temp_AvgCryoTemp_ignoreNaN = cryo_Temp_AvgCryoTemp_ignoreNaN;
      return this;
    }

    public Builder periodictasks_schedulers_default_nTasks(
        int periodictasks_schedulers_default_nTasks) {
      this.periodictasks_schedulers_default_nTasks = periodictasks_schedulers_default_nTasks;
      return this;
    }

    public Builder periodictasks_schedulers_default_nThreads(
        int periodictasks_schedulers_default_nThreads) {
      this.periodictasks_schedulers_default_nThreads = periodictasks_schedulers_default_nThreads;
      return this;
    }

    public Builder periodictasks_schedulers_monitor_check_scheduler_nTasks(
        int periodictasks_schedulers_monitor_check_scheduler_nTasks) {
      this.periodictasks_schedulers_monitor_check_scheduler_nTasks = periodictasks_schedulers_monitor_check_scheduler_nTasks;
      return this;
    }

    public Builder periodictasks_schedulers_monitor_check_scheduler_nThreads(
        int periodictasks_schedulers_monitor_check_scheduler_nThreads) {
      this.periodictasks_schedulers_monitor_check_scheduler_nThreads = periodictasks_schedulers_monitor_check_scheduler_nThreads;
      return this;
    }

    public Builder periodictasks_schedulers_monitor_update_publish_scheduler_nTasks(
        int periodictasks_schedulers_monitor_update_publish_scheduler_nTasks) {
      this.periodictasks_schedulers_monitor_update_publish_scheduler_nTasks = periodictasks_schedulers_monitor_update_publish_scheduler_nTasks;
      return this;
    }

    public Builder periodictasks_schedulers_monitor_update_publish_scheduler_nThreads(
        int periodictasks_schedulers_monitor_update_publish_scheduler_nThreads) {
      this.periodictasks_schedulers_monitor_update_publish_scheduler_nThreads = periodictasks_schedulers_monitor_update_publish_scheduler_nThreads;
      return this;
    }

    public Thermal_GeneralConfigurationEvent build() {
      return new Thermal_GeneralConfigurationEvent(version, cold_Temp_AvgColdTemp_chanNames, cold_Temp_AvgColdTemp_chanWeights, cold_Temp_AvgColdTemp_ignoreNaN, cryo_Temp_AvgCryoTemp_chanNames, cryo_Temp_AvgCryoTemp_chanWeights, cryo_Temp_AvgCryoTemp_ignoreNaN, periodictasks_schedulers_default_nTasks, periodictasks_schedulers_default_nThreads, periodictasks_schedulers_monitor_check_scheduler_nTasks, periodictasks_schedulers_monitor_check_scheduler_nThreads, periodictasks_schedulers_monitor_update_publish_scheduler_nTasks, periodictasks_schedulers_monitor_update_publish_scheduler_nThreads);
    }
  }
}
