package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class Hex_Cold1_LimitsConfigurationEvent extends CameraEvent {
  private final String version;

  private final double returntmp_warnHi;

  private final double returntmp_warnLo;

  private final double returntmp_limitHi;

  private final double returntmp_limitLo;

  private final double supplytmp_warnHi;

  private final double supplytmp_warnLo;

  private final double supplytmp_limitHi;

  private final double supplytmp_limitLo;

  public Hex_Cold1_LimitsConfigurationEvent(String version, double returntmp_warnHi,
      double returntmp_warnLo, double returntmp_limitHi, double returntmp_limitLo,
      double supplytmp_warnHi, double supplytmp_warnLo, double supplytmp_limitHi,
      double supplytmp_limitLo) {
    this.version = version;
    this.returntmp_warnHi = returntmp_warnHi;
    this.returntmp_warnLo = returntmp_warnLo;
    this.returntmp_limitHi = returntmp_limitHi;
    this.returntmp_limitLo = returntmp_limitLo;
    this.supplytmp_warnHi = supplytmp_warnHi;
    this.supplytmp_warnLo = supplytmp_warnLo;
    this.supplytmp_limitHi = supplytmp_limitHi;
    this.supplytmp_limitLo = supplytmp_limitLo;
  }

  public String getVersion() {
    return version;
  }

  public double getReturntmp_warnHi() {
    return returntmp_warnHi;
  }

  public double getReturntmp_warnLo() {
    return returntmp_warnLo;
  }

  public double getReturntmp_limitHi() {
    return returntmp_limitHi;
  }

  public double getReturntmp_limitLo() {
    return returntmp_limitLo;
  }

  public double getSupplytmp_warnHi() {
    return supplytmp_warnHi;
  }

  public double getSupplytmp_warnLo() {
    return supplytmp_warnLo;
  }

  public double getSupplytmp_limitHi() {
    return supplytmp_limitHi;
  }

  public double getSupplytmp_limitLo() {
    return supplytmp_limitLo;
  }

  @Override
  public String toString() {
    return "Hex_Cold1_LimitsConfigurationEvent{" + "version=" + version +
        ", returntmp_warnHi=" + returntmp_warnHi +", returntmp_warnLo=" + returntmp_warnLo +
        ", returntmp_limitHi=" + returntmp_limitHi +", returntmp_limitLo=" + returntmp_limitLo +
        ", supplytmp_warnHi=" + supplytmp_warnHi +", supplytmp_warnLo=" + supplytmp_warnLo +
        ", supplytmp_limitHi=" + supplytmp_limitHi +", supplytmp_limitLo=" + supplytmp_limitLo +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private String version;

    private double returntmp_warnHi;

    private double returntmp_warnLo;

    private double returntmp_limitHi;

    private double returntmp_limitLo;

    private double supplytmp_warnHi;

    private double supplytmp_warnLo;

    private double supplytmp_limitHi;

    private double supplytmp_limitLo;

    private Builder() {
    }

    public Builder version(String version) {
      this.version = version;
      return this;
    }

    public Builder returntmp_warnHi(double returntmp_warnHi) {
      this.returntmp_warnHi = returntmp_warnHi;
      return this;
    }

    public Builder returntmp_warnLo(double returntmp_warnLo) {
      this.returntmp_warnLo = returntmp_warnLo;
      return this;
    }

    public Builder returntmp_limitHi(double returntmp_limitHi) {
      this.returntmp_limitHi = returntmp_limitHi;
      return this;
    }

    public Builder returntmp_limitLo(double returntmp_limitLo) {
      this.returntmp_limitLo = returntmp_limitLo;
      return this;
    }

    public Builder supplytmp_warnHi(double supplytmp_warnHi) {
      this.supplytmp_warnHi = supplytmp_warnHi;
      return this;
    }

    public Builder supplytmp_warnLo(double supplytmp_warnLo) {
      this.supplytmp_warnLo = supplytmp_warnLo;
      return this;
    }

    public Builder supplytmp_limitHi(double supplytmp_limitHi) {
      this.supplytmp_limitHi = supplytmp_limitHi;
      return this;
    }

    public Builder supplytmp_limitLo(double supplytmp_limitLo) {
      this.supplytmp_limitLo = supplytmp_limitLo;
      return this;
    }

    public Hex_Cold1_LimitsConfigurationEvent build() {
      return new Hex_Cold1_LimitsConfigurationEvent(version, returntmp_warnHi, returntmp_warnLo, returntmp_limitHi, returntmp_limitLo, supplytmp_warnHi, supplytmp_warnLo, supplytmp_limitHi, supplytmp_limitLo);
    }
  }
}
