package org.lsst.sal.camera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class Utiltrunk_UTTelemetry extends CameraTelemetry {
  private final double averageTemp;

  private final double coolFlowRate;

  private final double coolPipeRetnTemp;

  private final double coolPipeSplyTemp;

  private final double coolReturnPrs;

  private final double coolSupplyPrs;

  private final double domeXMinusTemp;

  private final double domeYMinusTemp;

  private final double fanInletTemp;

  private final double fanRunTime;

  private final double fanSpeed;

  private final double midXMinusTemp;

  private final double midXPlusTemp;

  private final double suppXMinusTemp;

  private final double suppXPlusTemp;

  private final double topXMinusTemp;

  private final double topXPlusTemp;

  private final double valvePosn;

  private final double w2Q1Temp;

  private final double w4Q3Temp;

  public Utiltrunk_UTTelemetry(double averageTemp, double coolFlowRate, double coolPipeRetnTemp,
      double coolPipeSplyTemp, double coolReturnPrs, double coolSupplyPrs, double domeXMinusTemp,
      double domeYMinusTemp, double fanInletTemp, double fanRunTime, double fanSpeed,
      double midXMinusTemp, double midXPlusTemp, double suppXMinusTemp, double suppXPlusTemp,
      double topXMinusTemp, double topXPlusTemp, double valvePosn, double w2Q1Temp,
      double w4Q3Temp) {
    this.averageTemp = averageTemp;
    this.coolFlowRate = coolFlowRate;
    this.coolPipeRetnTemp = coolPipeRetnTemp;
    this.coolPipeSplyTemp = coolPipeSplyTemp;
    this.coolReturnPrs = coolReturnPrs;
    this.coolSupplyPrs = coolSupplyPrs;
    this.domeXMinusTemp = domeXMinusTemp;
    this.domeYMinusTemp = domeYMinusTemp;
    this.fanInletTemp = fanInletTemp;
    this.fanRunTime = fanRunTime;
    this.fanSpeed = fanSpeed;
    this.midXMinusTemp = midXMinusTemp;
    this.midXPlusTemp = midXPlusTemp;
    this.suppXMinusTemp = suppXMinusTemp;
    this.suppXPlusTemp = suppXPlusTemp;
    this.topXMinusTemp = topXMinusTemp;
    this.topXPlusTemp = topXPlusTemp;
    this.valvePosn = valvePosn;
    this.w2Q1Temp = w2Q1Temp;
    this.w4Q3Temp = w4Q3Temp;
  }

  public double getAverageTemp() {
    return averageTemp;
  }

  public double getCoolFlowRate() {
    return coolFlowRate;
  }

  public double getCoolPipeRetnTemp() {
    return coolPipeRetnTemp;
  }

  public double getCoolPipeSplyTemp() {
    return coolPipeSplyTemp;
  }

  public double getCoolReturnPrs() {
    return coolReturnPrs;
  }

  public double getCoolSupplyPrs() {
    return coolSupplyPrs;
  }

  public double getDomeXMinusTemp() {
    return domeXMinusTemp;
  }

  public double getDomeYMinusTemp() {
    return domeYMinusTemp;
  }

  public double getFanInletTemp() {
    return fanInletTemp;
  }

  public double getFanRunTime() {
    return fanRunTime;
  }

  public double getFanSpeed() {
    return fanSpeed;
  }

  public double getMidXMinusTemp() {
    return midXMinusTemp;
  }

  public double getMidXPlusTemp() {
    return midXPlusTemp;
  }

  public double getSuppXMinusTemp() {
    return suppXMinusTemp;
  }

  public double getSuppXPlusTemp() {
    return suppXPlusTemp;
  }

  public double getTopXMinusTemp() {
    return topXMinusTemp;
  }

  public double getTopXPlusTemp() {
    return topXPlusTemp;
  }

  public double getValvePosn() {
    return valvePosn;
  }

  public double getW2Q1Temp() {
    return w2Q1Temp;
  }

  public double getW4Q3Temp() {
    return w4Q3Temp;
  }

  @Override
  public String toString() {
    return "Utiltrunk_UTTelemetry{" + "averageTemp=" + averageTemp +
        ", coolFlowRate=" + coolFlowRate +", coolPipeRetnTemp=" + coolPipeRetnTemp +
        ", coolPipeSplyTemp=" + coolPipeSplyTemp +", coolReturnPrs=" + coolReturnPrs +
        ", coolSupplyPrs=" + coolSupplyPrs +", domeXMinusTemp=" + domeXMinusTemp +
        ", domeYMinusTemp=" + domeYMinusTemp +", fanInletTemp=" + fanInletTemp +
        ", fanRunTime=" + fanRunTime +", fanSpeed=" + fanSpeed +", midXMinusTemp=" + midXMinusTemp +
        ", midXPlusTemp=" + midXPlusTemp +", suppXMinusTemp=" + suppXMinusTemp +
        ", suppXPlusTemp=" + suppXPlusTemp +", topXMinusTemp=" + topXMinusTemp +
        ", topXPlusTemp=" + topXPlusTemp +", valvePosn=" + valvePosn +", w2Q1Temp=" + w2Q1Temp +
        ", w4Q3Temp=" + w4Q3Temp +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private double averageTemp;

    private double coolFlowRate;

    private double coolPipeRetnTemp;

    private double coolPipeSplyTemp;

    private double coolReturnPrs;

    private double coolSupplyPrs;

    private double domeXMinusTemp;

    private double domeYMinusTemp;

    private double fanInletTemp;

    private double fanRunTime;

    private double fanSpeed;

    private double midXMinusTemp;

    private double midXPlusTemp;

    private double suppXMinusTemp;

    private double suppXPlusTemp;

    private double topXMinusTemp;

    private double topXPlusTemp;

    private double valvePosn;

    private double w2Q1Temp;

    private double w4Q3Temp;

    private Builder() {
    }

    public Builder averageTemp(double averageTemp) {
      this.averageTemp = averageTemp;
      return this;
    }

    public Builder coolFlowRate(double coolFlowRate) {
      this.coolFlowRate = coolFlowRate;
      return this;
    }

    public Builder coolPipeRetnTemp(double coolPipeRetnTemp) {
      this.coolPipeRetnTemp = coolPipeRetnTemp;
      return this;
    }

    public Builder coolPipeSplyTemp(double coolPipeSplyTemp) {
      this.coolPipeSplyTemp = coolPipeSplyTemp;
      return this;
    }

    public Builder coolReturnPrs(double coolReturnPrs) {
      this.coolReturnPrs = coolReturnPrs;
      return this;
    }

    public Builder coolSupplyPrs(double coolSupplyPrs) {
      this.coolSupplyPrs = coolSupplyPrs;
      return this;
    }

    public Builder domeXMinusTemp(double domeXMinusTemp) {
      this.domeXMinusTemp = domeXMinusTemp;
      return this;
    }

    public Builder domeYMinusTemp(double domeYMinusTemp) {
      this.domeYMinusTemp = domeYMinusTemp;
      return this;
    }

    public Builder fanInletTemp(double fanInletTemp) {
      this.fanInletTemp = fanInletTemp;
      return this;
    }

    public Builder fanRunTime(double fanRunTime) {
      this.fanRunTime = fanRunTime;
      return this;
    }

    public Builder fanSpeed(double fanSpeed) {
      this.fanSpeed = fanSpeed;
      return this;
    }

    public Builder midXMinusTemp(double midXMinusTemp) {
      this.midXMinusTemp = midXMinusTemp;
      return this;
    }

    public Builder midXPlusTemp(double midXPlusTemp) {
      this.midXPlusTemp = midXPlusTemp;
      return this;
    }

    public Builder suppXMinusTemp(double suppXMinusTemp) {
      this.suppXMinusTemp = suppXMinusTemp;
      return this;
    }

    public Builder suppXPlusTemp(double suppXPlusTemp) {
      this.suppXPlusTemp = suppXPlusTemp;
      return this;
    }

    public Builder topXMinusTemp(double topXMinusTemp) {
      this.topXMinusTemp = topXMinusTemp;
      return this;
    }

    public Builder topXPlusTemp(double topXPlusTemp) {
      this.topXPlusTemp = topXPlusTemp;
      return this;
    }

    public Builder valvePosn(double valvePosn) {
      this.valvePosn = valvePosn;
      return this;
    }

    public Builder w2Q1Temp(double w2Q1Temp) {
      this.w2Q1Temp = w2Q1Temp;
      return this;
    }

    public Builder w4Q3Temp(double w4Q3Temp) {
      this.w4Q3Temp = w4Q3Temp;
      return this;
    }

    public Utiltrunk_UTTelemetry build() {
      return new Utiltrunk_UTTelemetry(averageTemp, coolFlowRate, coolPipeRetnTemp, coolPipeSplyTemp, coolReturnPrs, coolSupplyPrs, domeXMinusTemp, domeYMinusTemp, fanInletTemp, fanRunTime, fanSpeed, midXMinusTemp, midXPlusTemp, suppXMinusTemp, suppXPlusTemp, topXMinusTemp, topXPlusTemp, valvePosn, w2Q1Temp, w4Q3Temp);
    }
  }
}
