package org.lsst.sal.camera.states;

import org.lsst.sal.SALEnum;
import org.lsst.sal.camera.CameraStateChangeEvent;

public class RaftsDetailedStateEvent extends CameraStateChangeEvent {
  private final RaftsState substate;

  private final double timestampTransition;

  public RaftsDetailedStateEvent(RaftsState substate, double timestampTransition) {
    this.substate = substate;
    this.timestampTransition = timestampTransition;
  }

  @Override
  public RaftsState getSubstate() {
    return substate;
  }

  public double getTimestampTransition() {
    return timestampTransition;
  }

  @Override
  public String toString() {
    return "RaftsDetailedStateEvent{" + "substate=" + substate +
        ", timestampTransition=" + timestampTransition +"}";
  }

  public enum RaftsState implements SALEnum {
    NEEDS_CLEAR,

    CLEARING,

    INTEGRATING,

    READING_OUT,

    QUIESCENT,

    DISCARDING
  }
}
