package org.lsst.sal.camera.states;

import org.lsst.sal.SALEnum;
import org.lsst.sal.camera.CameraStateChangeEvent;

public class FilterChangerDetailedStateEvent extends CameraStateChangeEvent {
  private final FilterChangerState substate;

  private final double timestampTransition;

  public FilterChangerDetailedStateEvent(FilterChangerState substate, double timestampTransition) {
    this.substate = substate;
    this.timestampTransition = timestampTransition;
  }

  @Override
  public FilterChangerState getSubstate() {
    return substate;
  }

  public double getTimestampTransition() {
    return timestampTransition;
  }

  @Override
  public String toString() {
    return "FilterChangerDetailedStateEvent{" + "substate=" + substate +
        ", timestampTransition=" + timestampTransition +"}";
  }

  public enum FilterChangerState implements SALEnum {
    UNLOADING,

    LOADING,

    LOADED,

    UNLOADED,

    ROTATING
  }
}
