package org.lsst.sal.camera.states;

import org.lsst.sal.SALEnum;
import org.lsst.sal.camera.CameraStateChangeEvent;

public class CalibrationDetailedStateEvent extends CameraStateChangeEvent {
  private final CalibrationState substate;

  private final double timestampTransition;

  public CalibrationDetailedStateEvent(CalibrationState substate, double timestampTransition) {
    this.substate = substate;
    this.timestampTransition = timestampTransition;
  }

  @Override
  public CalibrationState getSubstate() {
    return substate;
  }

  public double getTimestampTransition() {
    return timestampTransition;
  }

  @Override
  public String toString() {
    return "CalibrationDetailedStateEvent{" + "substate=" + substate +
        ", timestampTransition=" + timestampTransition +"}";
  }

  public enum CalibrationState implements SALEnum {
    DISABLED,

    ENABLED,

    INTEGRATING
  }
}
