package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class Vacuum_IonPumps_CryoConfigurationEvent extends CameraEvent {
  private final String version;

  private final double cip1c_current;

  private final double cip1c_power;

  private final double cip1c_voltage;

  private final double cip2c_current;

  private final double cip2c_power;

  private final double cip2c_voltage;

  private final double cip3c_current;

  private final double cip3c_power;

  private final double cip3c_voltage;

  private final double cip4c_current;

  private final double cip4c_power;

  private final double cip4c_voltage;

  private final double cip5c_current;

  private final double cip5c_power;

  private final double cip5c_voltage;

  private final double cip6c_current;

  private final double cip6c_power;

  private final double cip6c_voltage;

  private final double hip1c_current;

  private final double hip1c_power;

  private final double hip1c_voltage;

  private final double hip2c_current;

  private final double hip2c_power;

  private final double hip2c_voltage;

  private final String ipAddr;

  public Vacuum_IonPumps_CryoConfigurationEvent(String version, double cip1c_current,
      double cip1c_power, double cip1c_voltage, double cip2c_current, double cip2c_power,
      double cip2c_voltage, double cip3c_current, double cip3c_power, double cip3c_voltage,
      double cip4c_current, double cip4c_power, double cip4c_voltage, double cip5c_current,
      double cip5c_power, double cip5c_voltage, double cip6c_current, double cip6c_power,
      double cip6c_voltage, double hip1c_current, double hip1c_power, double hip1c_voltage,
      double hip2c_current, double hip2c_power, double hip2c_voltage, String ipAddr) {
    this.version = version;
    this.cip1c_current = cip1c_current;
    this.cip1c_power = cip1c_power;
    this.cip1c_voltage = cip1c_voltage;
    this.cip2c_current = cip2c_current;
    this.cip2c_power = cip2c_power;
    this.cip2c_voltage = cip2c_voltage;
    this.cip3c_current = cip3c_current;
    this.cip3c_power = cip3c_power;
    this.cip3c_voltage = cip3c_voltage;
    this.cip4c_current = cip4c_current;
    this.cip4c_power = cip4c_power;
    this.cip4c_voltage = cip4c_voltage;
    this.cip5c_current = cip5c_current;
    this.cip5c_power = cip5c_power;
    this.cip5c_voltage = cip5c_voltage;
    this.cip6c_current = cip6c_current;
    this.cip6c_power = cip6c_power;
    this.cip6c_voltage = cip6c_voltage;
    this.hip1c_current = hip1c_current;
    this.hip1c_power = hip1c_power;
    this.hip1c_voltage = hip1c_voltage;
    this.hip2c_current = hip2c_current;
    this.hip2c_power = hip2c_power;
    this.hip2c_voltage = hip2c_voltage;
    this.ipAddr = ipAddr;
  }

  public String getVersion() {
    return version;
  }

  public double getCip1c_current() {
    return cip1c_current;
  }

  public double getCip1c_power() {
    return cip1c_power;
  }

  public double getCip1c_voltage() {
    return cip1c_voltage;
  }

  public double getCip2c_current() {
    return cip2c_current;
  }

  public double getCip2c_power() {
    return cip2c_power;
  }

  public double getCip2c_voltage() {
    return cip2c_voltage;
  }

  public double getCip3c_current() {
    return cip3c_current;
  }

  public double getCip3c_power() {
    return cip3c_power;
  }

  public double getCip3c_voltage() {
    return cip3c_voltage;
  }

  public double getCip4c_current() {
    return cip4c_current;
  }

  public double getCip4c_power() {
    return cip4c_power;
  }

  public double getCip4c_voltage() {
    return cip4c_voltage;
  }

  public double getCip5c_current() {
    return cip5c_current;
  }

  public double getCip5c_power() {
    return cip5c_power;
  }

  public double getCip5c_voltage() {
    return cip5c_voltage;
  }

  public double getCip6c_current() {
    return cip6c_current;
  }

  public double getCip6c_power() {
    return cip6c_power;
  }

  public double getCip6c_voltage() {
    return cip6c_voltage;
  }

  public double getHip1c_current() {
    return hip1c_current;
  }

  public double getHip1c_power() {
    return hip1c_power;
  }

  public double getHip1c_voltage() {
    return hip1c_voltage;
  }

  public double getHip2c_current() {
    return hip2c_current;
  }

  public double getHip2c_power() {
    return hip2c_power;
  }

  public double getHip2c_voltage() {
    return hip2c_voltage;
  }

  public String getIpAddr() {
    return ipAddr;
  }

  @Override
  public String toString() {
    return "Vacuum_IonPumps_CryoConfigurationEvent{" + "version=" + version +
        ", cip1c_current=" + cip1c_current +", cip1c_power=" + cip1c_power +
        ", cip1c_voltage=" + cip1c_voltage +", cip2c_current=" + cip2c_current +
        ", cip2c_power=" + cip2c_power +", cip2c_voltage=" + cip2c_voltage +
        ", cip3c_current=" + cip3c_current +", cip3c_power=" + cip3c_power +
        ", cip3c_voltage=" + cip3c_voltage +", cip4c_current=" + cip4c_current +
        ", cip4c_power=" + cip4c_power +", cip4c_voltage=" + cip4c_voltage +
        ", cip5c_current=" + cip5c_current +", cip5c_power=" + cip5c_power +
        ", cip5c_voltage=" + cip5c_voltage +", cip6c_current=" + cip6c_current +
        ", cip6c_power=" + cip6c_power +", cip6c_voltage=" + cip6c_voltage +
        ", hip1c_current=" + hip1c_current +", hip1c_power=" + hip1c_power +
        ", hip1c_voltage=" + hip1c_voltage +", hip2c_current=" + hip2c_current +
        ", hip2c_power=" + hip2c_power +", hip2c_voltage=" + hip2c_voltage +", ipAddr=" + ipAddr +
        "}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private String version;

    private double cip1c_current;

    private double cip1c_power;

    private double cip1c_voltage;

    private double cip2c_current;

    private double cip2c_power;

    private double cip2c_voltage;

    private double cip3c_current;

    private double cip3c_power;

    private double cip3c_voltage;

    private double cip4c_current;

    private double cip4c_power;

    private double cip4c_voltage;

    private double cip5c_current;

    private double cip5c_power;

    private double cip5c_voltage;

    private double cip6c_current;

    private double cip6c_power;

    private double cip6c_voltage;

    private double hip1c_current;

    private double hip1c_power;

    private double hip1c_voltage;

    private double hip2c_current;

    private double hip2c_power;

    private double hip2c_voltage;

    private String ipAddr;

    private Builder() {
    }

    public Builder version(String version) {
      this.version = version;
      return this;
    }

    public Builder cip1c_current(double cip1c_current) {
      this.cip1c_current = cip1c_current;
      return this;
    }

    public Builder cip1c_power(double cip1c_power) {
      this.cip1c_power = cip1c_power;
      return this;
    }

    public Builder cip1c_voltage(double cip1c_voltage) {
      this.cip1c_voltage = cip1c_voltage;
      return this;
    }

    public Builder cip2c_current(double cip2c_current) {
      this.cip2c_current = cip2c_current;
      return this;
    }

    public Builder cip2c_power(double cip2c_power) {
      this.cip2c_power = cip2c_power;
      return this;
    }

    public Builder cip2c_voltage(double cip2c_voltage) {
      this.cip2c_voltage = cip2c_voltage;
      return this;
    }

    public Builder cip3c_current(double cip3c_current) {
      this.cip3c_current = cip3c_current;
      return this;
    }

    public Builder cip3c_power(double cip3c_power) {
      this.cip3c_power = cip3c_power;
      return this;
    }

    public Builder cip3c_voltage(double cip3c_voltage) {
      this.cip3c_voltage = cip3c_voltage;
      return this;
    }

    public Builder cip4c_current(double cip4c_current) {
      this.cip4c_current = cip4c_current;
      return this;
    }

    public Builder cip4c_power(double cip4c_power) {
      this.cip4c_power = cip4c_power;
      return this;
    }

    public Builder cip4c_voltage(double cip4c_voltage) {
      this.cip4c_voltage = cip4c_voltage;
      return this;
    }

    public Builder cip5c_current(double cip5c_current) {
      this.cip5c_current = cip5c_current;
      return this;
    }

    public Builder cip5c_power(double cip5c_power) {
      this.cip5c_power = cip5c_power;
      return this;
    }

    public Builder cip5c_voltage(double cip5c_voltage) {
      this.cip5c_voltage = cip5c_voltage;
      return this;
    }

    public Builder cip6c_current(double cip6c_current) {
      this.cip6c_current = cip6c_current;
      return this;
    }

    public Builder cip6c_power(double cip6c_power) {
      this.cip6c_power = cip6c_power;
      return this;
    }

    public Builder cip6c_voltage(double cip6c_voltage) {
      this.cip6c_voltage = cip6c_voltage;
      return this;
    }

    public Builder hip1c_current(double hip1c_current) {
      this.hip1c_current = hip1c_current;
      return this;
    }

    public Builder hip1c_power(double hip1c_power) {
      this.hip1c_power = hip1c_power;
      return this;
    }

    public Builder hip1c_voltage(double hip1c_voltage) {
      this.hip1c_voltage = hip1c_voltage;
      return this;
    }

    public Builder hip2c_current(double hip2c_current) {
      this.hip2c_current = hip2c_current;
      return this;
    }

    public Builder hip2c_power(double hip2c_power) {
      this.hip2c_power = hip2c_power;
      return this;
    }

    public Builder hip2c_voltage(double hip2c_voltage) {
      this.hip2c_voltage = hip2c_voltage;
      return this;
    }

    public Builder ipAddr(String ipAddr) {
      this.ipAddr = ipAddr;
      return this;
    }

    public Vacuum_IonPumps_CryoConfigurationEvent build() {
      return new Vacuum_IonPumps_CryoConfigurationEvent(version, cip1c_current, cip1c_power, cip1c_voltage, cip2c_current, cip2c_power, cip2c_voltage, cip3c_current, cip3c_power, cip3c_voltage, cip4c_current, cip4c_power, cip4c_voltage, cip5c_current, cip5c_power, cip5c_voltage, cip6c_current, cip6c_power, cip6c_voltage, hip1c_current, hip1c_power, hip1c_voltage, hip2c_current, hip2c_power, hip2c_voltage, ipAddr);
    }
  }
}
