/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.TestHelper;
import org.lsst.sal.camera.SALCamera;
import org.lsst.sal.camera.telemetry.Chiller_ChillerTelemetry;
import org.lsst.sal.camera.telemetry.Chiller_FParam_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Chiller_Maq20Telemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_Reb_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_StoreTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_Sum_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Autochanger_AutochangerTrucks_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Autochanger_Latches_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Autochanger_OnlineClamps_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Autochanger_TemperaturesTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_AcSensorsGateway_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_AcTruckXminusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_AcTruckXplusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_Accelerobf_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_Ai814_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_BrakeSystemGateway_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_CarouselController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_ClampXminusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_ClampXplusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_Hyttc580_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_LatchXminusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_LatchXplusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_OnlineClampXminusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_OnlineClampXplusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_OnlineClampYminusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_OnlineStrainGauge_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_ProximitySensorsDevice_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_Pt100_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_TempSensorsDevice1_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_TempSensorsDevice2_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus1_CarrierController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus1_HooksController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus1_LoaderPlutoGateway_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_Socket1_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_Socket2_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_Socket3_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_Socket4_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_Socket5_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Duration_Autochanger_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Duration_Carousel_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Duration_Loader_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Duration_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Fcs_Mcm_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Loader_Carrier_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Loader_Hooks_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_CcdTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebTotalPowerTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebsAverageTemp6Telemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_SegmentTelemetry;
import org.lsst.sal.camera.telemetry.Hex_Cold1Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cold2Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo1Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo2Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo3Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo4Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo5Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo6Telemetry;
import org.lsst.sal.camera.telemetry.Quadbox_BFRTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_24VCTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_24VDTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_48VTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_5VTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_REB_Bulk_PSTelemetry;
import org.lsst.sal.camera.telemetry.Rebpower_RebTelemetry;
import org.lsst.sal.camera.telemetry.Rebpower_RebTotalPowerTelemetry;
import org.lsst.sal.camera.telemetry.Rebpower_RebpsTelemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo1Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo2Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo3Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo4Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo5Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo6Telemetry;
import org.lsst.sal.camera.telemetry.Shutter_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Thermal_Cold_TempTelemetry;
import org.lsst.sal.camera.telemetry.Thermal_Cryo_TempTelemetry;
import org.lsst.sal.camera.telemetry.Thermal_RtdTelemetry;
import org.lsst.sal.camera.telemetry.Thermal_TrimTelemetry;
import org.lsst.sal.camera.telemetry.Thermal_Trim_HtrsTelemetry;
import org.lsst.sal.camera.telemetry.Utiltrunk_BodyTelemetry;
import org.lsst.sal.camera.telemetry.Utiltrunk_MPCTelemetry;
import org.lsst.sal.camera.telemetry.Utiltrunk_UTTelemetry;
import org.lsst.sal.camera.telemetry.Utiltrunk_VPCTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CipTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CryoTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_HXTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_InstTelemetry;

public class TelemetrySendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = SALCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALTelemetry testSendReceive(SALTelemetry item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALTelemetry> future = executor.submit(() -> sal.getTelemetry(Duration.ofSeconds(10L)));
        try {
            sal.sendTelemetry(item);
            SALTelemetry sALTelemetry = future.get(10L, TimeUnit.SECONDS);
            return sALTelemetry;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveQuadbox_BFRTelemetry() throws Exception {
        double clean_5_24V_I = 0.42802155017852783;
        double dirty_24V_I = 0.8841565251350403;
        double dirty_28V_I = 0.723391056060791;
        double dirty_48V_I = 0.012175381183624268;
        double protection_I = 0.06291204690933228;
        double rebps_0_2_I = 0.5327414274215698;
        double rebps_3_5_I = 0.32043081521987915;
        double rebps_6_8_I = 0.6729613542556763;
        double rebps_9_12_I = 0.27488642930984497;
        double rebps_Spr_I = 0.3728615641593933;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_BFRTelemetry(clean_5_24V_I, dirty_24V_I, dirty_28V_I, dirty_48V_I, protection_I, rebps_0_2_I, rebps_3_5_I, rebps_6_8_I, rebps_9_12_I, rebps_Spr_I));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFRTelemetry));
        Quadbox_BFRTelemetry item_ = (Quadbox_BFRTelemetry)item;
        Assert.assertEquals((double)clean_5_24V_I, (double)item_.getClean_5_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I, (double)item_.getDirty_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I, (double)item_.getDirty_28V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I, (double)item_.getDirty_48V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I, (double)item_.getProtection_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_2_I, (double)item_.getRebps_0_2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_3_5_I, (double)item_.getRebps_3_5_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_6_8_I, (double)item_.getRebps_6_8_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_9_12_I, (double)item_.getRebps_9_12_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_Spr_I, (double)item_.getRebps_Spr_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VCTelemetry() throws Exception {
        double board_T = 0.9913286566734314;
        double body_Maq20_I = 0.8676349520683289;
        double body_Maq20_V = 0.17567843198776245;
        double cryo_Maq20_I = 0.38904452323913574;
        double cryo_Maq20_V = 0.296139f;
        double fes_CarouselC_I = 0.7261744737625122;
        double fes_CarouselC_V = 0.6626887917518616;
        double fes_ChangerC_I = 0.04965662956237793;
        double fes_ChangerC_V = 0.0604214072227478;
        double fes_LoaderC_I = 0.25971394777297974;
        double fes_LoaderC_V = 0.18166548013687134;
        double fpga_T = 0.15060561895370483;
        double gauges_I = 0.969784677028656;
        double gauges_V = 0.5768238306045532;
        double int_Valves_I = 0.723280131816864;
        double int_Valves_V = 0.748953f;
        double ion_Pumps_I = 0.8426942229270935;
        double ion_Pumps_V = 0.17643022537231445;
        double main_I = 0.48615914583206177;
        double main_T = 0.5553824305534363;
        double main_V = 0.8494077324867249;
        double shtr_PLC1_I = 0.06183946132659912;
        double shtr_PLC1_V = 0.5651716589927673;
        double shtr_PLC2_I = 0.2926744818687439;
        double shtr_PLC2_V = 0.38204145431518555;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VCTelemetry(board_T, body_Maq20_I, body_Maq20_V, cryo_Maq20_I, cryo_Maq20_V, fes_CarouselC_I, fes_CarouselC_V, fes_ChangerC_I, fes_ChangerC_V, fes_LoaderC_I, fes_LoaderC_V, fpga_T, gauges_I, gauges_V, int_Valves_I, int_Valves_V, ion_Pumps_I, ion_Pumps_V, main_I, main_T, main_V, shtr_PLC1_I, shtr_PLC1_V, shtr_PLC2_I, shtr_PLC2_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VCTelemetry));
        Quadbox_PDU_24VCTelemetry item_ = (Quadbox_PDU_24VCTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Maq20_I, (double)item_.getBody_Maq20_I(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Maq20_V, (double)item_.getBody_Maq20_V(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Maq20_I, (double)item_.getCryo_Maq20_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Maq20_V, (double)item_.getCryo_Maq20_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselC_I, (double)item_.getFes_CarouselC_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselC_V, (double)item_.getFes_CarouselC_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerC_I, (double)item_.getFes_ChangerC_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerC_V, (double)item_.getFes_ChangerC_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderC_I, (double)item_.getFes_LoaderC_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderC_V, (double)item_.getFes_LoaderC_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I, (double)item_.getGauges_I(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V, (double)item_.getGauges_V(), (double)1.0E-6f);
        Assert.assertEquals((double)int_Valves_I, (double)item_.getInt_Valves_I(), (double)1.0E-6f);
        Assert.assertEquals((double)int_Valves_V, (double)item_.getInt_Valves_V(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I, (double)item_.getIon_Pumps_I(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V, (double)item_.getIon_Pumps_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC1_I, (double)item_.getShtr_PLC1_I(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC1_V, (double)item_.getShtr_PLC1_V(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC2_I, (double)item_.getShtr_PLC2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC2_V, (double)item_.getShtr_PLC2_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VDTelemetry() throws Exception {
        double board_T = 0.7304448485374451;
        double cryo_Turbo_I = 0.9954877495765686;
        double cryo_Turbo_V = 0.965650200843811;
        double fes_Brakes_I = 0.8986307978630066;
        double fes_Brakes_V = 0.1965857744216919;
        double fes_ChangerD_I = 0.08702284097671509;
        double fes_ChangerD_V = 0.2001015f;
        double fes_Clamps_I = 0.9886152744293213;
        double fes_Clamps_V = 0.33215343952178955;
        double fes_LoaderD_I = 0.9479057192802429;
        double fes_LoaderD_V = 0.5957809686660767;
        double fpga_T = 0.03004467487335205;
        double hex_Turbo_I = 0.6454641222953796;
        double hex_Turbo_V = 0.5377201437950134;
        double main_I = 0.7814640998840332;
        double main_T = 0.03719979524612427;
        double main_V = 0.5513439178466797;
        double shtr_Brakes_I = 0.2702589f;
        double shtr_Brakes_V = 0.766426146030426;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VDTelemetry(board_T, cryo_Turbo_I, cryo_Turbo_V, fes_Brakes_I, fes_Brakes_V, fes_ChangerD_I, fes_ChangerD_V, fes_Clamps_I, fes_Clamps_V, fes_LoaderD_I, fes_LoaderD_V, fpga_T, hex_Turbo_I, hex_Turbo_V, main_I, main_T, main_V, shtr_Brakes_I, shtr_Brakes_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VDTelemetry));
        Quadbox_PDU_24VDTelemetry item_ = (Quadbox_PDU_24VDTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I, (double)item_.getCryo_Turbo_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V, (double)item_.getCryo_Turbo_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Brakes_I, (double)item_.getFes_Brakes_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Brakes_V, (double)item_.getFes_Brakes_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerD_I, (double)item_.getFes_ChangerD_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerD_V, (double)item_.getFes_ChangerD_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Clamps_I, (double)item_.getFes_Clamps_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Clamps_V, (double)item_.getFes_Clamps_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderD_I, (double)item_.getFes_LoaderD_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderD_V, (double)item_.getFes_LoaderD_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_I, (double)item_.getHex_Turbo_I(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_V, (double)item_.getHex_Turbo_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Brakes_I, (double)item_.getShtr_Brakes_I(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Brakes_V, (double)item_.getShtr_Brakes_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_48VTelemetry() throws Exception {
        double board_T = 0.8041006922721863;
        double fes_CarouselD_I = 0.5551072359085083;
        double fes_CarouselD_V = 0.7508121132850647;
        double fes_Heater_I = 0.5385303497314453;
        double fes_Heater_V = 0.9230126142501831;
        double fpga_T = 0.1241145133972168;
        double main_I = 0.47461992502212524;
        double main_T = 0.2787594199180603;
        double main_V = 0.15165424346923828;
        double purge_Fan_I = 0.3499273657798767;
        double purge_Fan_V = 0.4117283225059509;
        double shtr_Motor1_I = 0.23782312870025635;
        double shtr_Motor1_V = 0.38809633255004883;
        double shtr_Motor2_I = 0.5119433999061584;
        double shtr_Motor2_V = 0.18037575483322144;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_48VTelemetry(board_T, fes_CarouselD_I, fes_CarouselD_V, fes_Heater_I, fes_Heater_V, fpga_T, main_I, main_T, main_V, purge_Fan_I, purge_Fan_V, shtr_Motor1_I, shtr_Motor1_V, shtr_Motor2_I, shtr_Motor2_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48VTelemetry));
        Quadbox_PDU_48VTelemetry item_ = (Quadbox_PDU_48VTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselD_I, (double)item_.getFes_CarouselD_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselD_V, (double)item_.getFes_CarouselD_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Heater_I, (double)item_.getFes_Heater_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Heater_V, (double)item_.getFes_Heater_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_I, (double)item_.getPurge_Fan_I(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_V, (double)item_.getPurge_Fan_V(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor1_I, (double)item_.getShtr_Motor1_I(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor1_V, (double)item_.getShtr_Motor1_V(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor2_I, (double)item_.getShtr_Motor2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor2_V, (double)item_.getShtr_Motor2_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_5VTelemetry() throws Exception {
        double otm_0_A_I = 0.27294737100601196;
        double otm_0_A_V = 0.9236583113670349;
        double otm_0_B_I = 0.9931003451347351;
        double otm_0_B_V = 0.6781256794929504;
        double otm_1_A_I = 0.3707275986671448;
        double otm_1_A_V = 0.9324435591697693;
        double otm_1_B_I = 0.5262464880943298;
        double otm_1_B_V = 0.449784517288208;
        double otm_2_A_I = 0.6117709279060364;
        double otm_2_A_V = 0.33810514211654663;
        double otm_2_B_I = 0.7756381630897522;
        double otm_2_B_V = 0.9668700695037842;
        double otm_3_A_I = 0.9696370959281921;
        double otm_3_A_V = 0.3062235713005066;
        double otm_3_B_I = 0.7944543957710266;
        double otm_3_B_V = 0.25881046056747437;
        double otm_4_A_I = 0.91333f;
        double otm_4_A_V = 0.9421666860580444;
        double otm_4_B_I = 0.9120232462882996;
        double otm_4_B_V = 0.7455727458000183;
        double otm_5_A_I = 0.9104164838790894;
        double otm_5_A_V = 0.1429547667503357;
        double otm_5_B_I = 0.26258552074432373;
        double otm_5_B_V = 0.590083f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_5VTelemetry(otm_0_A_I, otm_0_A_V, otm_0_B_I, otm_0_B_V, otm_1_A_I, otm_1_A_V, otm_1_B_I, otm_1_B_V, otm_2_A_I, otm_2_A_V, otm_2_B_I, otm_2_B_V, otm_3_A_I, otm_3_A_V, otm_3_B_I, otm_3_B_V, otm_4_A_I, otm_4_A_V, otm_4_B_I, otm_4_B_V, otm_5_A_I, otm_5_A_V, otm_5_B_I, otm_5_B_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5VTelemetry));
        Quadbox_PDU_5VTelemetry item_ = (Quadbox_PDU_5VTelemetry)item;
        Assert.assertEquals((double)otm_0_A_I, (double)item_.getOtm_0_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_V, (double)item_.getOtm_0_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I, (double)item_.getOtm_0_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_V, (double)item_.getOtm_0_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_I, (double)item_.getOtm_1_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_V, (double)item_.getOtm_1_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_I, (double)item_.getOtm_1_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_V, (double)item_.getOtm_1_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_I, (double)item_.getOtm_2_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_V, (double)item_.getOtm_2_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_I, (double)item_.getOtm_2_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_V, (double)item_.getOtm_2_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I, (double)item_.getOtm_3_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V, (double)item_.getOtm_3_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I, (double)item_.getOtm_3_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V, (double)item_.getOtm_3_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_I, (double)item_.getOtm_4_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_V, (double)item_.getOtm_4_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_I, (double)item_.getOtm_4_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_V, (double)item_.getOtm_4_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_I, (double)item_.getOtm_5_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_V, (double)item_.getOtm_5_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_I, (double)item_.getOtm_5_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_V, (double)item_.getOtm_5_B_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_REB_Bulk_PSTelemetry() throws Exception {
        double rebbulkps_0_2_I = 0.8460214138031006;
        double rebbulkps_0_2_T = 0.5365853905677795;
        double rebbulkps_0_2_V = 0.09294718503952026;
        double rebbulkps_3_5_I = 0.722268283367157;
        double rebbulkps_3_5_T = 0.8988456726074219;
        double rebbulkps_3_5_V = 0.6381955742835999;
        double rebbulkps_6_8_I = 0.5044876337051392;
        double rebbulkps_6_8_T = 0.8311173319816589;
        double rebbulkps_6_8_V = 0.1944863200187683;
        double rebbulkps_9_12_I = 0.6197198033332825;
        double rebbulkps_9_12_T = 0.6740178465843201;
        double rebbulkps_9_12_V = 0.9137324690818787;
        double rebbulkps_Brd_T = 0.3123382329940796;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_REB_Bulk_PSTelemetry(rebbulkps_0_2_I, rebbulkps_0_2_T, rebbulkps_0_2_V, rebbulkps_3_5_I, rebbulkps_3_5_T, rebbulkps_3_5_V, rebbulkps_6_8_I, rebbulkps_6_8_T, rebbulkps_6_8_V, rebbulkps_9_12_I, rebbulkps_9_12_T, rebbulkps_9_12_V, rebbulkps_Brd_T));
        Assert.assertTrue((boolean)(item instanceof Quadbox_REB_Bulk_PSTelemetry));
        Quadbox_REB_Bulk_PSTelemetry item_ = (Quadbox_REB_Bulk_PSTelemetry)item;
        Assert.assertEquals((double)rebbulkps_0_2_I, (double)item_.getRebbulkps_0_2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_T, (double)item_.getRebbulkps_0_2_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_V, (double)item_.getRebbulkps_0_2_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_I, (double)item_.getRebbulkps_3_5_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_T, (double)item_.getRebbulkps_3_5_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_V, (double)item_.getRebbulkps_3_5_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_I, (double)item_.getRebbulkps_6_8_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_T, (double)item_.getRebbulkps_6_8_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_V, (double)item_.getRebbulkps_6_8_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_I, (double)item_.getRebbulkps_9_12_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_T, (double)item_.getRebbulkps_9_12_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_V, (double)item_.getRebbulkps_9_12_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_Brd_T, (double)item_.getRebbulkps_Brd_T(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebTelemetry() throws Exception {
        double[] analog_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)-840519937);
        double[] analog_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)1457561536);
        double[] analog_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)1668465225);
        double[] analog_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-2117486254);
        double[] analog_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)1289560733);
        double[] clockhi_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)1562802890);
        double[] clockhi_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-1326698964);
        double[] clockhi_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)-222852784);
        double[] clockhi_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)1026586193);
        double[] clockhi_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)630946823);
        double[] clocklo_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)-1343063213);
        double[] clocklo_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-675789961);
        double[] clocklo_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)1290184497);
        double[] clocklo_VaftLDO2 = TestHelper.generateDoubleArray((int)71, (int)497882891);
        double[] clocklo_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)218551942);
        double[] clocklo_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)-2082501484);
        double[] digital_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)-2000652555);
        double[] digital_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)1345417508);
        double[] digital_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)67851467);
        double[] digital_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)1079721924);
        double[] digital_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)-1607979593);
        double[] dphi_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)1825962448);
        double[] dphi_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)172102851);
        double[] dphi_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)1715764738);
        double[] dphi_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)1805923321);
        double[] dphi_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)1895470702);
        double[] heater_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)-19754412);
        double[] heater_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)599368448);
        double[] heater_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)-1236612884);
        double[] heater_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)1650939192);
        double[] heater_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)2044596360);
        double[] hvbias_IbefSwch = TestHelper.generateDoubleArray((int)71, (int)-723373253);
        double[] hvbias_VbefSwch = TestHelper.generateDoubleArray((int)71, (int)2126797039);
        String location = "";
        double[] od_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)-816431692);
        double[] od_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-1711597751);
        double[] od_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)1631467605);
        double[] od_VaftLDO2 = TestHelper.generateDoubleArray((int)71, (int)-1440283942);
        double[] od_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-665356836);
        double[] od_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)379238517);
        double[] power = TestHelper.generateDoubleArray((int)71, (int)-376977813);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebTelemetry(analog_IaftLDO, analog_IbefLDO, analog_VaftLDO, analog_VaftSwch, analog_VbefLDO, clockhi_IaftLDO, clockhi_IbefLDO, clockhi_VaftLDO, clockhi_VaftSwch, clockhi_VbefLDO, clocklo_IaftLDO, clocklo_IbefLDO, clocklo_VaftLDO, clocklo_VaftLDO2, clocklo_VaftSwch, clocklo_VbefLDO, digital_IaftLDO, digital_IbefLDO, digital_VaftLDO, digital_VaftSwch, digital_VbefLDO, dphi_IaftLDO, dphi_IbefLDO, dphi_VaftLDO, dphi_VaftSwch, dphi_VbefLDO, heater_IaftLDO, heater_IbefLDO, heater_VaftLDO, heater_VaftSwch, heater_VbefLDO, hvbias_IbefSwch, hvbias_VbefSwch, location, od_IaftLDO, od_IbefLDO, od_VaftLDO, od_VaftLDO2, od_VaftSwch, od_VbefLDO, power));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebTelemetry));
        Rebpower_RebTelemetry item_ = (Rebpower_RebTelemetry)item;
        Assert.assertArrayEquals((double[])analog_IaftLDO, (double[])item_.getAnalog_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO, (double[])item_.getAnalog_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO, (double[])item_.getAnalog_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch, (double[])item_.getAnalog_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO, (double[])item_.getAnalog_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO, (double[])item_.getClockhi_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO, (double[])item_.getClockhi_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO, (double[])item_.getClockhi_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch, (double[])item_.getClockhi_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO, (double[])item_.getClockhi_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO, (double[])item_.getClocklo_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO, (double[])item_.getClocklo_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO, (double[])item_.getClocklo_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2, (double[])item_.getClocklo_VaftLDO2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch, (double[])item_.getClocklo_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO, (double[])item_.getClocklo_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO, (double[])item_.getDigital_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO, (double[])item_.getDigital_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO, (double[])item_.getDigital_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch, (double[])item_.getDigital_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO, (double[])item_.getDigital_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IaftLDO, (double[])item_.getDphi_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IbefLDO, (double[])item_.getDphi_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftLDO, (double[])item_.getDphi_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftSwch, (double[])item_.getDphi_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VbefLDO, (double[])item_.getDphi_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO, (double[])item_.getHeater_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO, (double[])item_.getHeater_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO, (double[])item_.getHeater_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch, (double[])item_.getHeater_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO, (double[])item_.getHeater_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch, (double[])item_.getHvbias_IbefSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch, (double[])item_.getHvbias_VbefSwch(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])od_IaftLDO, (double[])item_.getOd_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO, (double[])item_.getOd_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO, (double[])item_.getOd_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2, (double[])item_.getOd_VaftLDO2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch, (double[])item_.getOd_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO, (double[])item_.getOd_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebTotalPowerTelemetry() throws Exception {
        double rebTotalPower = 0.12183153629302979;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebTotalPowerTelemetry(rebTotalPower));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebTotalPowerTelemetry));
        Rebpower_RebTotalPowerTelemetry item_ = (Rebpower_RebTotalPowerTelemetry)item;
        Assert.assertEquals((double)rebTotalPower, (double)item_.getRebTotalPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebpsTelemetry() throws Exception {
        double[] boardTemp0 = TestHelper.generateDoubleArray((int)13, (int)-1241888939);
        double[] boardTemp1 = TestHelper.generateDoubleArray((int)13, (int)557961869);
        double[] boardTemp2 = TestHelper.generateDoubleArray((int)13, (int)-1213186888);
        double[] boardTemp3 = TestHelper.generateDoubleArray((int)13, (int)211058237);
        double[] boardTemp4 = TestHelper.generateDoubleArray((int)13, (int)-1985602132);
        double[] boardTemp5 = TestHelper.generateDoubleArray((int)13, (int)-968421639);
        double[] boardTemp6 = TestHelper.generateDoubleArray((int)13, (int)-1172590970);
        double[] fPGATemp = TestHelper.generateDoubleArray((int)13, (int)429161164);
        String location = "d";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebpsTelemetry(boardTemp0, boardTemp1, boardTemp2, boardTemp3, boardTemp4, boardTemp5, boardTemp6, fPGATemp, location));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebpsTelemetry));
        Rebpower_RebpsTelemetry item_ = (Rebpower_RebpsTelemetry)item;
        Assert.assertArrayEquals((double[])boardTemp0, (double[])item_.getBoardTemp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp1, (double[])item_.getBoardTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp2, (double[])item_.getBoardTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp3, (double[])item_.getBoardTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp4, (double[])item_.getBoardTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp5, (double[])item_.getBoardTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp6, (double[])item_.getBoardTemp6(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])fPGATemp, (double[])item_.getFPGATemp(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveHex_Cold1Telemetry() throws Exception {
        double returnTmp = 0.1031796932220459;
        double supplyTmp = 0.2733106017112732;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cold1Telemetry(returnTmp, supplyTmp));
        Assert.assertTrue((boolean)(item instanceof Hex_Cold1Telemetry));
        Hex_Cold1Telemetry item_ = (Hex_Cold1Telemetry)item;
        Assert.assertEquals((double)returnTmp, (double)item_.getReturnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyTmp, (double)item_.getSupplyTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cold2Telemetry() throws Exception {
        double returnTmp = 0.3846477270126343;
        double supplyTmp = 0.5456730723381042;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cold2Telemetry(returnTmp, supplyTmp));
        Assert.assertTrue((boolean)(item instanceof Hex_Cold2Telemetry));
        Hex_Cold2Telemetry item_ = (Hex_Cold2Telemetry)item;
        Assert.assertEquals((double)returnTmp, (double)item_.getReturnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyTmp, (double)item_.getSupplyTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo1Telemetry() throws Exception {
        double c3ExitTmp = 0.6833916306495667;
        double c4ExitTmp = 0.615400493144989;
        double evapExitTmp = 0.985266387462616;
        double hexRtrnTmp = 0.6262192130088806;
        double liquidPrs = 0.9268412590026855;
        double preC3Tmp = 0.7013934254646301;
        double preC4Tmp = 0.7946221232414246;
        double returnPrs = 0.8567145466804504;
        double vaporPrs = 0.10664993524551392;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo1Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo1Telemetry));
        Hex_Cryo1Telemetry item_ = (Hex_Cryo1Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo2Telemetry() throws Exception {
        double c3ExitTmp = 0.6390265226364136;
        double c4ExitTmp = 0.4128406047821045;
        double evapExitTmp = 0.7378131747245789;
        double hexRtrnTmp = 0.22139078378677368;
        double liquidPrs = 0.8042507171630859;
        double preC3Tmp = 0.6622820496559143;
        double preC4Tmp = 0.4527856707572937;
        double returnPrs = 0.2221236228942871;
        double vaporPrs = 0.7435727715492249;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo2Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo2Telemetry));
        Hex_Cryo2Telemetry item_ = (Hex_Cryo2Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo3Telemetry() throws Exception {
        double c3ExitTmp = 0.32882362604141235;
        double c4ExitTmp = 0.18640172481536865;
        double evapExitTmp = 0.331407f;
        double hexRtrnTmp = 0.49448084831237793;
        double liquidPrs = 0.6153187155723572;
        double preC3Tmp = 0.3528764843940735;
        double preC4Tmp = 0.6594946384429932;
        double returnPrs = 0.029887735843658447;
        double vaporPrs = 0.686722457408905;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo3Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo3Telemetry));
        Hex_Cryo3Telemetry item_ = (Hex_Cryo3Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo4Telemetry() throws Exception {
        double c3ExitTmp = 0.5515662431716919;
        double c4ExitTmp = 0.9538493156433105;
        double evapExitTmp = 0.1216285228729248;
        double hexRtrnTmp = 0.0994305f;
        double liquidPrs = 0.02028787136077881;
        double preC3Tmp = 0.12096691131591797;
        double preC4Tmp = 0.8419254422187805;
        double returnPrs = 0.5299714803695679;
        double vaporPrs = 0.4902523159980774;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo4Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo4Telemetry));
        Hex_Cryo4Telemetry item_ = (Hex_Cryo4Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo5Telemetry() throws Exception {
        double c3ExitTmp = 0.36965036392211914;
        double c4ExitTmp = 0.33370906114578247;
        double evapExitTmp = 0.26223433017730713;
        double hexRtrnTmp = 0.26226896047592163;
        double liquidPrs = 0.19328594207763672;
        double preC3Tmp = 0.7372046113014221;
        double preC4Tmp = 0.7104390859603882;
        double returnPrs = 0.9478601217269897;
        double vaporPrs = 0.4519529342651367;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo5Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo5Telemetry));
        Hex_Cryo5Telemetry item_ = (Hex_Cryo5Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo6Telemetry() throws Exception {
        double c3ExitTmp = 0.07082492113113403;
        double c4ExitTmp = 0.5902376770973206;
        double evapExitTmp = 0.1561023f;
        double hexRtrnTmp = 0.06556594371795654;
        double liquidPrs = 0.941853404045105;
        double preC3Tmp = 0.5864506959915161;
        double preC4Tmp = 0.79039067029953;
        double returnPrs = 0.08456408977508545;
        double vaporPrs = 0.672473f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo6Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo6Telemetry));
        Hex_Cryo6Telemetry item_ = (Hex_Cryo6Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo1Telemetry() throws Exception {
        double afterCoolTmp = 0.7774170637130737;
        double compCurrent = 0.9600421786308289;
        double compPower = 0.478396f;
        double compVoltage = 0.43834203481674194;
        double dischrgPrs = 0.07779967784881592;
        double dischrgtmp_M = 0.5489626526832581;
        double dischrgtmp_P = 0.953304648399353;
        double fanSpeed = 0.45221036672592163;
        double oilLevel = 0.35961318016052246;
        double oilSepTmp = 0.534893f;
        double phaseSepTmp = 0.574421226978302;
        double suctionPrs = 0.9091998934745789;
        double suctiontmp_M = 0.15150684118270874;
        double suctiontmp_P = 0.3635222315788269;
        double surgeTankTmp = 0.28328317403793335;
        double waterInTmp = 0.12166684865951538;
        double waterOutTmp = 0.23586708307266235;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo1Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo1Telemetry));
        Refrig_Cryo1Telemetry item_ = (Refrig_Cryo1Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo2Telemetry() throws Exception {
        double afterCoolTmp = 0.27564752101898193;
        double compCurrent = 0.4465714693069458;
        double compPower = 0.9914597868919373;
        double compVoltage = 0.5396295189857483;
        double dischrgPrs = 0.014325857162475586;
        double dischrgtmp_M = 0.9867229461669922;
        double dischrgtmp_P = 0.1304640769958496;
        double fanSpeed = 0.31598544120788574;
        double oilLevel = 0.932489275932312;
        double oilSepTmp = 0.0873381495475769;
        double phaseSepTmp = 0.6842671036720276;
        double suctionPrs = 0.2492081f;
        double suctiontmp_M = 0.1377851963043213;
        double suctiontmp_P = 0.8588252067565918;
        double surgeTankTmp = 0.3294191360473633;
        double waterInTmp = 0.18303775787353516;
        double waterOutTmp = 0.9865933656692505;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo2Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo2Telemetry));
        Refrig_Cryo2Telemetry item_ = (Refrig_Cryo2Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo3Telemetry() throws Exception {
        double afterCoolTmp = 0.13097500801086426;
        double ambientTmp = 0.29603683948516846;
        double cabinetTmp = 0.21447932720184326;
        double compCurrent = 0.3375188112258911;
        double compPower = 0.9132510423660278;
        double compVoltage = 0.36148297786712646;
        double dischrgPrs = 0.8401514887809753;
        double dischrgtmp_M = 0.4385449290275574;
        double dischrgtmp_P = 0.25022536516189575;
        double fanSpeed = 0.01773691177368164;
        double oilLevel = 0.26277297735214233;
        double oilSepTmp = 0.9219653606414795;
        double phaseSepTmp = 0.6841568946838379;
        double suctionPrs = 0.8381834626197815;
        double suctiontmp_M = 0.322886f;
        double suctiontmp_P = 0.965827226638794;
        double surgeTankTmp = 0.32015544176101685;
        double waterInTmp = 0.06532156467437744;
        double waterOutTmp = 0.41804826259613037;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo3Telemetry(afterCoolTmp, ambientTmp, cabinetTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo3Telemetry));
        Refrig_Cryo3Telemetry item_ = (Refrig_Cryo3Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo4Telemetry() throws Exception {
        double afterCoolTmp = 0.4266694188117981;
        double compCurrent = 0.33832043409347534;
        double compPower = 0.6689122319221497;
        double compVoltage = 0.20162934064865112;
        double dischrgPrs = 0.41071271896362305;
        double dischrgtmp_M = 0.4938998818397522;
        double dischrgtmp_P = 0.3470335602760315;
        double fanSpeed = 0.4498153328895569;
        double oilLevel = 0.9123595356941223;
        double oilSepTmp = 0.738744f;
        double phaseSepTmp = 0.8762168884277344;
        double suctionPrs = 0.7728777527809143;
        double suctiontmp_M = 0.4710242748260498;
        double suctiontmp_P = 0.1486014723777771;
        double surgeTankTmp = 0.7802398800849915;
        double waterInTmp = 0.4902266263961792;
        double waterOutTmp = 0.26919543743133545;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo4Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo4Telemetry));
        Refrig_Cryo4Telemetry item_ = (Refrig_Cryo4Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo5Telemetry() throws Exception {
        double afterCoolTmp = 0.1802259087562561;
        double ambientTmp = 0.8523287177085876;
        double cabinetTmp = 0.0439186692237854;
        double compCurrent = 0.2836172f;
        double compPower = 0.2545545f;
        double compVoltage = 0.707659900188446;
        double dischrgPrs = 0.488411009311676;
        double dischrgtmp_M = 0.4030695f;
        double dischrgtmp_P = 0.3777400851249695;
        double fanSpeed = 0.29047656059265137;
        double oilLevel = 0.4523560404777527;
        double oilSepTmp = 0.31406354904174805;
        double phaseSepTmp = 0.09653699398040771;
        double suctionPrs = 0.3442919850349426;
        double suctiontmp_M = 0.2486640214920044;
        double suctiontmp_P = 0.23160594701766968;
        double surgeTankTmp = 0.43006718158721924;
        double waterInTmp = 0.9591088891029358;
        double waterOutTmp = 0.6300771236419678;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo5Telemetry(afterCoolTmp, ambientTmp, cabinetTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo5Telemetry));
        Refrig_Cryo5Telemetry item_ = (Refrig_Cryo5Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo6Telemetry() throws Exception {
        double afterCoolTmp = 0.5959053635597229;
        double compCurrent = 0.433544397354126;
        double compPower = 0.8240374326705933;
        double compVoltage = 0.8078945875167847;
        double dischrgPrs = 0.8755069375038147;
        double dischrgtmp_M = 0.9039708375930786;
        double dischrgtmp_P = 0.07796567678451538;
        double fanSpeed = 0.420676589012146;
        double oilLevel = 0.8989740610122681;
        double oilSepTmp = 0.12161296606063843;
        double phaseSepTmp = 0.20896893739700317;
        double suctionPrs = 0.947770357131958;
        double suctiontmp_M = 0.2951557f;
        double suctiontmp_P = 0.888315f;
        double surgeTankTmp = 0.3020111918449402;
        double waterInTmp = 0.7900169491767883;
        double waterOutTmp = 0.8486577868461609;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo6Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo6Telemetry));
        Refrig_Cryo6Telemetry item_ = (Refrig_Cryo6Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CipTelemetry() throws Exception {
        double[] cryo_I = TestHelper.generateDoubleArray((int)6, (int)-239880069);
        double[] cryo_Life = TestHelper.generateDoubleArray((int)6, (int)-969019378);
        double[] cryo_Usage = TestHelper.generateDoubleArray((int)6, (int)-1252882785);
        double[] cryo_V = TestHelper.generateDoubleArray((int)6, (int)-460027132);
        double[] hx_I = TestHelper.generateDoubleArray((int)6, (int)-631917778);
        double[] hx_Life = TestHelper.generateDoubleArray((int)6, (int)955893244);
        double[] hx_Usage = TestHelper.generateDoubleArray((int)6, (int)994360616);
        double[] hx_V = TestHelper.generateDoubleArray((int)6, (int)1574667122);
        String location = "c";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CipTelemetry(cryo_I, cryo_Life, cryo_Usage, cryo_V, hx_I, hx_Life, hx_Usage, hx_V, location));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CipTelemetry));
        Vacuum_CipTelemetry item_ = (Vacuum_CipTelemetry)item;
        Assert.assertArrayEquals((double[])cryo_I, (double[])item_.getCryo_I(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_Life, (double[])item_.getCryo_Life(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_Usage, (double[])item_.getCryo_Usage(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_V, (double[])item_.getCryo_V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_I, (double[])item_.getHx_I(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_Life, (double[])item_.getHx_Life(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_Usage, (double[])item_.getHx_Usage(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_V, (double[])item_.getHx_V(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveVacuum_CryoTelemetry() throws Exception {
        double airPressure = 0.8720544576644897;
        double cryoVac = 0.27813196182250977;
        double flineCurrent = 0.4131561517715454;
        double flinePower = 0.854506f;
        double flineVoltage = 0.760930061340332;
        double forelineVac = 0.05844026803970337;
        double gaugeDose = 0.44296252727508545;
        double pumpCartPressure = 0.8741492033004761;
        double turboCurrent = 0.5222861170768738;
        double turboGaugeDose = 0.4755227565765381;
        double turboHours = 0.6505237221717834;
        double turboPower = 0.7943531274795532;
        double turboPumpStatus = 0.6197706460952759;
        double turboPumpTemp = 0.3344826102256775;
        double turboSpeed = 0.3656052350997925;
        double turboVac = 0.838508f;
        double turboVoltage = 0.9427078366279602;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CryoTelemetry(airPressure, cryoVac, flineCurrent, flinePower, flineVoltage, forelineVac, gaugeDose, pumpCartPressure, turboCurrent, turboGaugeDose, turboHours, turboPower, turboPumpStatus, turboPumpTemp, turboSpeed, turboVac, turboVoltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoTelemetry));
        Vacuum_CryoTelemetry item_ = (Vacuum_CryoTelemetry)item;
        Assert.assertEquals((double)airPressure, (double)item_.getAirPressure(), (double)1.0E-6f);
        Assert.assertEquals((double)cryoVac, (double)item_.getCryoVac(), (double)1.0E-6f);
        Assert.assertEquals((double)flineCurrent, (double)item_.getFlineCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)flinePower, (double)item_.getFlinePower(), (double)1.0E-6f);
        Assert.assertEquals((double)flineVoltage, (double)item_.getFlineVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)forelineVac, (double)item_.getForelineVac(), (double)1.0E-6f);
        Assert.assertEquals((double)gaugeDose, (double)item_.getGaugeDose(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpCartPressure, (double)item_.getPumpCartPressure(), (double)1.0E-6f);
        Assert.assertEquals((double)turboCurrent, (double)item_.getTurboCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)turboGaugeDose, (double)item_.getTurboGaugeDose(), (double)1.0E-6f);
        Assert.assertEquals((double)turboHours, (double)item_.getTurboHours(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPower, (double)item_.getTurboPower(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPumpStatus, (double)item_.getTurboPumpStatus(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPumpTemp, (double)item_.getTurboPumpTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)turboSpeed, (double)item_.getTurboSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)turboVac, (double)item_.getTurboVac(), (double)1.0E-6f);
        Assert.assertEquals((double)turboVoltage, (double)item_.getTurboVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_HXTelemetry() throws Exception {
        double airPressure = 0.3455565f;
        double flineCurrent = 0.4657749f;
        double flinePower = 0.6058825850486755;
        double flineVoltage = 0.36224573850631714;
        double forelineVac = 0.11827832460403442;
        double gaugeDose = 0.5935790538787842;
        double hexVac = 0.67257f;
        double pumpCartPressure = 0.3236528f;
        double turboCurrent = 0.8826066851615906;
        double turboGaugeDose = 0.5549773573875427;
        double turboHours = 0.5185275077819824;
        double turboPower = 0.0874180793762207;
        double turboPumpStatus = 0.9695937037467957;
        double turboPumpTemp = 0.12186849117279053;
        double turboSpeed = 0.102963387966156;
        double turboVac = 0.966339111328125;
        double turboVoltage = 0.3570827841758728;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_HXTelemetry(airPressure, flineCurrent, flinePower, flineVoltage, forelineVac, gaugeDose, hexVac, pumpCartPressure, turboCurrent, turboGaugeDose, turboHours, turboPower, turboPumpStatus, turboPumpTemp, turboSpeed, turboVac, turboVoltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_HXTelemetry));
        Vacuum_HXTelemetry item_ = (Vacuum_HXTelemetry)item;
        Assert.assertEquals((double)airPressure, (double)item_.getAirPressure(), (double)1.0E-6f);
        Assert.assertEquals((double)flineCurrent, (double)item_.getFlineCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)flinePower, (double)item_.getFlinePower(), (double)1.0E-6f);
        Assert.assertEquals((double)flineVoltage, (double)item_.getFlineVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)forelineVac, (double)item_.getForelineVac(), (double)1.0E-6f);
        Assert.assertEquals((double)gaugeDose, (double)item_.getGaugeDose(), (double)1.0E-6f);
        Assert.assertEquals((double)hexVac, (double)item_.getHexVac(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpCartPressure, (double)item_.getPumpCartPressure(), (double)1.0E-6f);
        Assert.assertEquals((double)turboCurrent, (double)item_.getTurboCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)turboGaugeDose, (double)item_.getTurboGaugeDose(), (double)1.0E-6f);
        Assert.assertEquals((double)turboHours, (double)item_.getTurboHours(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPower, (double)item_.getTurboPower(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPumpStatus, (double)item_.getTurboPumpStatus(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPumpTemp, (double)item_.getTurboPumpTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)turboSpeed, (double)item_.getTurboSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)turboVac, (double)item_.getTurboVac(), (double)1.0E-6f);
        Assert.assertEquals((double)turboVoltage, (double)item_.getTurboVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_InstTelemetry() throws Exception {
        double cryoFlineValveState = 0.9877268671989441;
        double flineCurrent = 0.7081656455993652;
        double flinePower = 0.19652915000915527;
        double flineVoltage = 0.32983511686325073;
        double hxFlineValveState = 0.4602123498916626;
        double instVac = 0.20682674646377563;
        double pumpCartCycling = 0.9360202550888062;
        double pumpCartPressure = 0.9764194488525391;
        double pumpCartTemperature = 0.04096514f;
        double pumpCartVenting = 0.2708238959312439;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_InstTelemetry(cryoFlineValveState, flineCurrent, flinePower, flineVoltage, hxFlineValveState, instVac, pumpCartCycling, pumpCartPressure, pumpCartTemperature, pumpCartVenting));
        Assert.assertTrue((boolean)(item instanceof Vacuum_InstTelemetry));
        Vacuum_InstTelemetry item_ = (Vacuum_InstTelemetry)item;
        Assert.assertEquals((double)cryoFlineValveState, (double)item_.getCryoFlineValveState(), (double)1.0E-6f);
        Assert.assertEquals((double)flineCurrent, (double)item_.getFlineCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)flinePower, (double)item_.getFlinePower(), (double)1.0E-6f);
        Assert.assertEquals((double)flineVoltage, (double)item_.getFlineVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)hxFlineValveState, (double)item_.getHxFlineValveState(), (double)1.0E-6f);
        Assert.assertEquals((double)instVac, (double)item_.getInstVac(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpCartCycling, (double)item_.getPumpCartCycling(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpCartPressure, (double)item_.getPumpCartPressure(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpCartTemperature, (double)item_.getPumpCartTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpCartVenting, (double)item_.getPumpCartVenting(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_Reb_TrendingTelemetry() throws Exception {
        long[] driver_errors = TestHelper.generateLongArray((int)71, (int)879623438);
        long[] driver_received = TestHelper.generateLongArray((int)71, (int)1646167193);
        long[] driver_rx0 = TestHelper.generateLongArray((int)71, (int)1198848508);
        long[] driver_rx1 = TestHelper.generateLongArray((int)71, (int)103955563);
        long[] driver_rx2 = TestHelper.generateLongArray((int)71, (int)1738454970);
        long[] driver_rx3 = TestHelper.generateLongArray((int)71, (int)-627619830);
        long[] firmware_cell_errors = TestHelper.generateLongArray((int)71, (int)-448561757);
        long[] firmware_last_rx = TestHelper.generateLongArray((int)71, (int)2134049333);
        long[] firmware_last_tx = TestHelper.generateLongArray((int)71, (int)-782861957);
        long[] firmware_link_down = TestHelper.generateLongArray((int)71, (int)-1202272553);
        long[] firmware_link_errors = TestHelper.generateLongArray((int)71, (int)-520024172);
        long[] firmware_link_status = TestHelper.generateLongArray((int)71, (int)-393499257);
        long[] firmware_overflow_local0 = TestHelper.generateLongArray((int)71, (int)1056183108);
        long[] firmware_overflow_local1 = TestHelper.generateLongArray((int)71, (int)-1741228926);
        long[] firmware_overflow_local2 = TestHelper.generateLongArray((int)71, (int)164131471);
        long[] firmware_overflow_local3 = TestHelper.generateLongArray((int)71, (int)887337194);
        long[] firmware_overflow_remote0 = TestHelper.generateLongArray((int)71, (int)-1315545550);
        long[] firmware_overflow_remote1 = TestHelper.generateLongArray((int)71, (int)-1779787179);
        long[] firmware_overflow_remote2 = TestHelper.generateLongArray((int)71, (int)-601800830);
        long[] firmware_overflow_remote3 = TestHelper.generateLongArray((int)71, (int)-2103178513);
        long[] firmware_rlink_data = TestHelper.generateLongArray((int)71, (int)-881463382);
        long[] firmware_rx_clock = TestHelper.generateLongArray((int)71, (int)-1137220935);
        long[] firmware_rx_errors = TestHelper.generateLongArray((int)71, (int)-1168887726);
        long[] firmware_rx_frames = TestHelper.generateLongArray((int)71, (int)-1212730453);
        long[] firmware_rx_op = TestHelper.generateLongArray((int)71, (int)249785278);
        long[] firmware_tx_clock = TestHelper.generateLongArray((int)71, (int)24430023);
        long[] firmware_tx_errors = TestHelper.generateLongArray((int)71, (int)-411905318);
        long[] firmware_tx_frames = TestHelper.generateLongArray((int)71, (int)-833229470);
        long[] firmware_tx_op = TestHelper.generateLongArray((int)71, (int)317594068);
        String location = "h";
        long[] rds_bdi_firsts = TestHelper.generateLongArray((int)71, (int)2063854721);
        long[] rds_bdi_frees = TestHelper.generateLongArray((int)71, (int)-1681088631);
        long[] rds_bdi_lasts = TestHelper.generateLongArray((int)71, (int)2096354553);
        long[] rds_bdi_nulls = TestHelper.generateLongArray((int)71, (int)-460458955);
        long[] rds_bdi_overflows = TestHelper.generateLongArray((int)71, (int)1050315473);
        long[] rds_bdi_seq_errors = TestHelper.generateLongArray((int)71, (int)844891602);
        long[] rds_bdi_waits = TestHelper.generateLongArray((int)71, (int)-318936967);
        long[] rds_discards = TestHelper.generateLongArray((int)71, (int)986825022);
        long[] rds_no_event = TestHelper.generateLongArray((int)71, (int)-1972438551);
        long[] rds_wakes = TestHelper.generateLongArray((int)71, (int)-190354332);
        long[] rms_in_reset = TestHelper.generateLongArray((int)71, (int)1368270662);
        long[] rms_inv_tids = TestHelper.generateLongArray((int)71, (int)-1383670735);
        long[] rms_link_down = TestHelper.generateLongArray((int)71, (int)-343627547);
        long[] rms_lists_posted = TestHelper.generateLongArray((int)71, (int)464326486);
        long[] rms_ops_posted = TestHelper.generateLongArray((int)71, (int)-1812386212);
        long[] rms_orphans = TestHelper.generateLongArray((int)71, (int)2132430017);
        long[] rms_probes = TestHelper.generateLongArray((int)71, (int)-1013722796);
        long[] rms_responses = TestHelper.generateLongArray((int)71, (int)784040707);
        long[] rms_rundowns = TestHelper.generateLongArray((int)71, (int)-1319547359);
        long[] rms_tid_hwm = TestHelper.generateLongArray((int)71, (int)-1279783441);
        long[] rms_unopened = TestHelper.generateLongArray((int)71, (int)-1497931914);
        long[] rms_waits = TestHelper.generateLongArray((int)71, (int)1292651061);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_Reb_TrendingTelemetry(driver_errors, driver_received, driver_rx0, driver_rx1, driver_rx2, driver_rx3, firmware_cell_errors, firmware_last_rx, firmware_last_tx, firmware_link_down, firmware_link_errors, firmware_link_status, firmware_overflow_local0, firmware_overflow_local1, firmware_overflow_local2, firmware_overflow_local3, firmware_overflow_remote0, firmware_overflow_remote1, firmware_overflow_remote2, firmware_overflow_remote3, firmware_rlink_data, firmware_rx_clock, firmware_rx_errors, firmware_rx_frames, firmware_rx_op, firmware_tx_clock, firmware_tx_errors, firmware_tx_frames, firmware_tx_op, location, rds_bdi_firsts, rds_bdi_frees, rds_bdi_lasts, rds_bdi_nulls, rds_bdi_overflows, rds_bdi_seq_errors, rds_bdi_waits, rds_discards, rds_no_event, rds_wakes, rms_in_reset, rms_inv_tids, rms_link_down, rms_lists_posted, rms_ops_posted, rms_orphans, rms_probes, rms_responses, rms_rundowns, rms_tid_hwm, rms_unopened, rms_waits));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Reb_TrendingTelemetry));
        Daq_monitor_Reb_TrendingTelemetry item_ = (Daq_monitor_Reb_TrendingTelemetry)item;
        Assert.assertArrayEquals((long[])driver_errors, (long[])item_.getDriver_errors());
        Assert.assertArrayEquals((long[])driver_received, (long[])item_.getDriver_received());
        Assert.assertArrayEquals((long[])driver_rx0, (long[])item_.getDriver_rx0());
        Assert.assertArrayEquals((long[])driver_rx1, (long[])item_.getDriver_rx1());
        Assert.assertArrayEquals((long[])driver_rx2, (long[])item_.getDriver_rx2());
        Assert.assertArrayEquals((long[])driver_rx3, (long[])item_.getDriver_rx3());
        Assert.assertArrayEquals((long[])firmware_cell_errors, (long[])item_.getFirmware_cell_errors());
        Assert.assertArrayEquals((long[])firmware_last_rx, (long[])item_.getFirmware_last_rx());
        Assert.assertArrayEquals((long[])firmware_last_tx, (long[])item_.getFirmware_last_tx());
        Assert.assertArrayEquals((long[])firmware_link_down, (long[])item_.getFirmware_link_down());
        Assert.assertArrayEquals((long[])firmware_link_errors, (long[])item_.getFirmware_link_errors());
        Assert.assertArrayEquals((long[])firmware_link_status, (long[])item_.getFirmware_link_status());
        Assert.assertArrayEquals((long[])firmware_overflow_local0, (long[])item_.getFirmware_overflow_local0());
        Assert.assertArrayEquals((long[])firmware_overflow_local1, (long[])item_.getFirmware_overflow_local1());
        Assert.assertArrayEquals((long[])firmware_overflow_local2, (long[])item_.getFirmware_overflow_local2());
        Assert.assertArrayEquals((long[])firmware_overflow_local3, (long[])item_.getFirmware_overflow_local3());
        Assert.assertArrayEquals((long[])firmware_overflow_remote0, (long[])item_.getFirmware_overflow_remote0());
        Assert.assertArrayEquals((long[])firmware_overflow_remote1, (long[])item_.getFirmware_overflow_remote1());
        Assert.assertArrayEquals((long[])firmware_overflow_remote2, (long[])item_.getFirmware_overflow_remote2());
        Assert.assertArrayEquals((long[])firmware_overflow_remote3, (long[])item_.getFirmware_overflow_remote3());
        Assert.assertArrayEquals((long[])firmware_rlink_data, (long[])item_.getFirmware_rlink_data());
        Assert.assertArrayEquals((long[])firmware_rx_clock, (long[])item_.getFirmware_rx_clock());
        Assert.assertArrayEquals((long[])firmware_rx_errors, (long[])item_.getFirmware_rx_errors());
        Assert.assertArrayEquals((long[])firmware_rx_frames, (long[])item_.getFirmware_rx_frames());
        Assert.assertArrayEquals((long[])firmware_rx_op, (long[])item_.getFirmware_rx_op());
        Assert.assertArrayEquals((long[])firmware_tx_clock, (long[])item_.getFirmware_tx_clock());
        Assert.assertArrayEquals((long[])firmware_tx_errors, (long[])item_.getFirmware_tx_errors());
        Assert.assertArrayEquals((long[])firmware_tx_frames, (long[])item_.getFirmware_tx_frames());
        Assert.assertArrayEquals((long[])firmware_tx_op, (long[])item_.getFirmware_tx_op());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((long[])rds_bdi_firsts, (long[])item_.getRds_bdi_firsts());
        Assert.assertArrayEquals((long[])rds_bdi_frees, (long[])item_.getRds_bdi_frees());
        Assert.assertArrayEquals((long[])rds_bdi_lasts, (long[])item_.getRds_bdi_lasts());
        Assert.assertArrayEquals((long[])rds_bdi_nulls, (long[])item_.getRds_bdi_nulls());
        Assert.assertArrayEquals((long[])rds_bdi_overflows, (long[])item_.getRds_bdi_overflows());
        Assert.assertArrayEquals((long[])rds_bdi_seq_errors, (long[])item_.getRds_bdi_seq_errors());
        Assert.assertArrayEquals((long[])rds_bdi_waits, (long[])item_.getRds_bdi_waits());
        Assert.assertArrayEquals((long[])rds_discards, (long[])item_.getRds_discards());
        Assert.assertArrayEquals((long[])rds_no_event, (long[])item_.getRds_no_event());
        Assert.assertArrayEquals((long[])rds_wakes, (long[])item_.getRds_wakes());
        Assert.assertArrayEquals((long[])rms_in_reset, (long[])item_.getRms_in_reset());
        Assert.assertArrayEquals((long[])rms_inv_tids, (long[])item_.getRms_inv_tids());
        Assert.assertArrayEquals((long[])rms_link_down, (long[])item_.getRms_link_down());
        Assert.assertArrayEquals((long[])rms_lists_posted, (long[])item_.getRms_lists_posted());
        Assert.assertArrayEquals((long[])rms_ops_posted, (long[])item_.getRms_ops_posted());
        Assert.assertArrayEquals((long[])rms_orphans, (long[])item_.getRms_orphans());
        Assert.assertArrayEquals((long[])rms_probes, (long[])item_.getRms_probes());
        Assert.assertArrayEquals((long[])rms_responses, (long[])item_.getRms_responses());
        Assert.assertArrayEquals((long[])rms_rundowns, (long[])item_.getRms_rundowns());
        Assert.assertArrayEquals((long[])rms_tid_hwm, (long[])item_.getRms_tid_hwm());
        Assert.assertArrayEquals((long[])rms_unopened, (long[])item_.getRms_unopened());
        Assert.assertArrayEquals((long[])rms_waits, (long[])item_.getRms_waits());
    }

    @Test
    public void sendReceiveDaq_monitor_StoreTelemetry() throws Exception {
        double capacity = 0.5838517546653748;
        double freeFraction = 0.910401f;
        double freeSpace = 0.19562774896621704;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_StoreTelemetry(capacity, freeFraction, freeSpace));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreTelemetry));
        Daq_monitor_StoreTelemetry item_ = (Daq_monitor_StoreTelemetry)item;
        Assert.assertEquals((double)capacity, (double)item_.getCapacity(), (double)1.0E-6f);
        Assert.assertEquals((double)freeFraction, (double)item_.getFreeFraction(), (double)1.0E-6f);
        Assert.assertEquals((double)freeSpace, (double)item_.getFreeSpace(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_Sum_TrendingTelemetry() throws Exception {
        long driver_errors = 775L;
        long firmware_cell_errors = 136L;
        long firmware_link_down = 594L;
        long firmware_link_errors = 866L;
        long firmware_overflow_local0 = 604L;
        long firmware_overflow_local1 = 163L;
        long firmware_overflow_local2 = 865L;
        long firmware_overflow_remote0 = 116L;
        long firmware_overflow_remote1 = 561L;
        long firmware_overflow_remote2 = 989L;
        long firmware_rx_errors = 84L;
        long firmware_tx_errors = 81L;
        long rds_bdi_nulls = 129L;
        long rds_bdi_overflows = 215L;
        long rds_bdi_seq_errors = 281L;
        long rds_discards = 139L;
        long rds_no_event = 903L;
        long rms_in_reset = 649L;
        long rms_inv_tids = 637L;
        long rms_link_down = 356L;
        long rms_orphans = 192L;
        long rms_unopened = 108L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_Sum_TrendingTelemetry(driver_errors, firmware_cell_errors, firmware_link_down, firmware_link_errors, firmware_overflow_local0, firmware_overflow_local1, firmware_overflow_local2, firmware_overflow_remote0, firmware_overflow_remote1, firmware_overflow_remote2, firmware_rx_errors, firmware_tx_errors, rds_bdi_nulls, rds_bdi_overflows, rds_bdi_seq_errors, rds_discards, rds_no_event, rms_in_reset, rms_inv_tids, rms_link_down, rms_orphans, rms_unopened));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Sum_TrendingTelemetry));
        Daq_monitor_Sum_TrendingTelemetry item_ = (Daq_monitor_Sum_TrendingTelemetry)item;
        Assert.assertEquals((long)driver_errors, (long)item_.getDriver_errors());
        Assert.assertEquals((long)firmware_cell_errors, (long)item_.getFirmware_cell_errors());
        Assert.assertEquals((long)firmware_link_down, (long)item_.getFirmware_link_down());
        Assert.assertEquals((long)firmware_link_errors, (long)item_.getFirmware_link_errors());
        Assert.assertEquals((long)firmware_overflow_local0, (long)item_.getFirmware_overflow_local0());
        Assert.assertEquals((long)firmware_overflow_local1, (long)item_.getFirmware_overflow_local1());
        Assert.assertEquals((long)firmware_overflow_local2, (long)item_.getFirmware_overflow_local2());
        Assert.assertEquals((long)firmware_overflow_remote0, (long)item_.getFirmware_overflow_remote0());
        Assert.assertEquals((long)firmware_overflow_remote1, (long)item_.getFirmware_overflow_remote1());
        Assert.assertEquals((long)firmware_overflow_remote2, (long)item_.getFirmware_overflow_remote2());
        Assert.assertEquals((long)firmware_rx_errors, (long)item_.getFirmware_rx_errors());
        Assert.assertEquals((long)firmware_tx_errors, (long)item_.getFirmware_tx_errors());
        Assert.assertEquals((long)rds_bdi_nulls, (long)item_.getRds_bdi_nulls());
        Assert.assertEquals((long)rds_bdi_overflows, (long)item_.getRds_bdi_overflows());
        Assert.assertEquals((long)rds_bdi_seq_errors, (long)item_.getRds_bdi_seq_errors());
        Assert.assertEquals((long)rds_discards, (long)item_.getRds_discards());
        Assert.assertEquals((long)rds_no_event, (long)item_.getRds_no_event());
        Assert.assertEquals((long)rms_in_reset, (long)item_.getRms_in_reset());
        Assert.assertEquals((long)rms_inv_tids, (long)item_.getRms_inv_tids());
        Assert.assertEquals((long)rms_link_down, (long)item_.getRms_link_down());
        Assert.assertEquals((long)rms_orphans, (long)item_.getRms_orphans());
        Assert.assertEquals((long)rms_unopened, (long)item_.getRms_unopened());
    }

    @Test
    public void sendReceiveFocal_plane_CcdTelemetry() throws Exception {
        double[] gDV = TestHelper.generateDoubleArray((int)201, (int)744886528);
        String location = "";
        double[] oDI = TestHelper.generateDoubleArray((int)201, (int)-1538515097);
        double[] oDV = TestHelper.generateDoubleArray((int)201, (int)1140086965);
        double[] oGV = TestHelper.generateDoubleArray((int)201, (int)-2042322663);
        double[] rDV = TestHelper.generateDoubleArray((int)201, (int)375133405);
        double[] temp = TestHelper.generateDoubleArray((int)201, (int)222673131);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_CcdTelemetry(gDV, location, oDI, oDV, oGV, rDV, temp));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_CcdTelemetry));
        Focal_plane_CcdTelemetry item_ = (Focal_plane_CcdTelemetry)item;
        Assert.assertArrayEquals((double[])gDV, (double[])item_.getGDV(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oGV, (double[])item_.getOGV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rDV, (double[])item_.getRDV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp, (double[])item_.getTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTelemetry() throws Exception {
        double[] anaI = TestHelper.generateDoubleArray((int)71, (int)-850479456);
        double[] anaV = TestHelper.generateDoubleArray((int)71, (int)1494146765);
        double[] aspicl_Temp0 = TestHelper.generateDoubleArray((int)71, (int)1144282287);
        double[] aspicl_Temp1 = TestHelper.generateDoubleArray((int)71, (int)2008558228);
        double[] aspicl_Temp2 = TestHelper.generateDoubleArray((int)71, (int)-685491271);
        double[] aspicu_Temp0 = TestHelper.generateDoubleArray((int)71, (int)394235292);
        double[] aspicu_Temp1 = TestHelper.generateDoubleArray((int)71, (int)-1189021742);
        double[] aspicu_Temp2 = TestHelper.generateDoubleArray((int)71, (int)280110092);
        double[] clkHI = TestHelper.generateDoubleArray((int)71, (int)52645011);
        double[] clkHV = TestHelper.generateDoubleArray((int)71, (int)1986452098);
        double[] clkLI = TestHelper.generateDoubleArray((int)71, (int)162947782);
        double[] clkLV = TestHelper.generateDoubleArray((int)71, (int)-507415694);
        double[] digI = TestHelper.generateDoubleArray((int)71, (int)-352615526);
        double[] digV = TestHelper.generateDoubleArray((int)71, (int)591466364);
        double[] hVBiasSwitch = TestHelper.generateDoubleArray((int)71, (int)-2120569687);
        double[] htrPI = TestHelper.generateDoubleArray((int)71, (int)-1186607487);
        double[] htrPV = TestHelper.generateDoubleArray((int)71, (int)293842278);
        double[] htrV = TestHelper.generateDoubleArray((int)71, (int)126253898);
        double[] htrW = TestHelper.generateDoubleArray((int)71, (int)930430373);
        String location = "p";
        double[] oDI = TestHelper.generateDoubleArray((int)71, (int)1504416117);
        double[] oDV = TestHelper.generateDoubleArray((int)71, (int)1651511465);
        double[] pClk0 = TestHelper.generateDoubleArray((int)71, (int)-1632247011);
        double[] pClk1 = TestHelper.generateDoubleArray((int)71, (int)-1501471408);
        double[] pClkL = TestHelper.generateDoubleArray((int)71, (int)649365139);
        double[] pClkU = TestHelper.generateDoubleArray((int)71, (int)-1826204582);
        double[] power = TestHelper.generateDoubleArray((int)71, (int)1705689061);
        double[] rG0 = TestHelper.generateDoubleArray((int)71, (int)-699154441);
        double[] rG1 = TestHelper.generateDoubleArray((int)71, (int)-1280316215);
        double[] rGL = TestHelper.generateDoubleArray((int)71, (int)522692428);
        double[] rGU = TestHelper.generateDoubleArray((int)71, (int)-2026633003);
        double[] rTDTemp = TestHelper.generateDoubleArray((int)71, (int)-1142484002);
        double[] ref05V = TestHelper.generateDoubleArray((int)71, (int)-1180691312);
        double[] ref125V = TestHelper.generateDoubleArray((int)71, (int)2096522092);
        double[] ref15V = TestHelper.generateDoubleArray((int)71, (int)1206059398);
        double[] ref25V = TestHelper.generateDoubleArray((int)71, (int)1441866028);
        double[] refN12 = TestHelper.generateDoubleArray((int)71, (int)-1198312004);
        double[] refP12 = TestHelper.generateDoubleArray((int)71, (int)-1579504447);
        double[] sClk0 = TestHelper.generateDoubleArray((int)71, (int)-716422332);
        double[] sClk1 = TestHelper.generateDoubleArray((int)71, (int)-1402711442);
        double[] sClkL = TestHelper.generateDoubleArray((int)71, (int)1546036410);
        double[] sClkU = TestHelper.generateDoubleArray((int)71, (int)-1035258029);
        double[] temp1 = TestHelper.generateDoubleArray((int)71, (int)1768766960);
        double[] temp10 = TestHelper.generateDoubleArray((int)71, (int)-1633391189);
        double[] temp2 = TestHelper.generateDoubleArray((int)71, (int)-1666082791);
        double[] temp3 = TestHelper.generateDoubleArray((int)71, (int)1816655978);
        double[] temp4 = TestHelper.generateDoubleArray((int)71, (int)1919836968);
        double[] temp5 = TestHelper.generateDoubleArray((int)71, (int)1092962997);
        double[] temp6 = TestHelper.generateDoubleArray((int)71, (int)555237963);
        double[] temp7 = TestHelper.generateDoubleArray((int)71, (int)-1877854469);
        double[] temp8 = TestHelper.generateDoubleArray((int)71, (int)1790599076);
        double[] temp9 = TestHelper.generateDoubleArray((int)71, (int)1561205442);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTelemetry(anaI, anaV, aspicl_Temp0, aspicl_Temp1, aspicl_Temp2, aspicu_Temp0, aspicu_Temp1, aspicu_Temp2, clkHI, clkHV, clkLI, clkLV, digI, digV, hVBiasSwitch, htrPI, htrPV, htrV, htrW, location, oDI, oDV, pClk0, pClk1, pClkL, pClkU, power, rG0, rG1, rGL, rGU, rTDTemp, ref05V, ref125V, ref15V, ref25V, refN12, refP12, sClk0, sClk1, sClkL, sClkU, temp1, temp10, temp2, temp3, temp4, temp5, temp6, temp7, temp8, temp9));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTelemetry));
        Focal_plane_RebTelemetry item_ = (Focal_plane_RebTelemetry)item;
        Assert.assertArrayEquals((double[])anaI, (double[])item_.getAnaI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anaV, (double[])item_.getAnaV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0, (double[])item_.getAspicl_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1, (double[])item_.getAspicl_Temp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2, (double[])item_.getAspicl_Temp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0, (double[])item_.getAspicu_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1, (double[])item_.getAspicu_Temp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2, (double[])item_.getAspicu_Temp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHI, (double[])item_.getClkHI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHV, (double[])item_.getClkHV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLI, (double[])item_.getClkLI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLV, (double[])item_.getClkLV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digI, (double[])item_.getDigI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digV, (double[])item_.getDigV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hVBiasSwitch, (double[])item_.getHVBiasSwitch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrPI, (double[])item_.getHtrPI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrPV, (double[])item_.getHtrPV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrV, (double[])item_.getHtrV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrW, (double[])item_.getHtrW(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClk0, (double[])item_.getPClk0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClk1, (double[])item_.getPClk1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkL, (double[])item_.getPClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkU, (double[])item_.getPClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rG0, (double[])item_.getRG0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rG1, (double[])item_.getRG1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGL, (double[])item_.getRGL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGU, (double[])item_.getRGU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rTDTemp, (double[])item_.getRTDTemp(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05V, (double[])item_.getRef05V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125V, (double[])item_.getRef125V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15V, (double[])item_.getRef15V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25V, (double[])item_.getRef25V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refN12, (double[])item_.getRefN12(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refP12, (double[])item_.getRefP12(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClk0, (double[])item_.getSClk0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClk1, (double[])item_.getSClk1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkL, (double[])item_.getSClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkU, (double[])item_.getSClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1, (double[])item_.getTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10, (double[])item_.getTemp10(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2, (double[])item_.getTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3, (double[])item_.getTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4, (double[])item_.getTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5, (double[])item_.getTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6, (double[])item_.getTemp6(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7, (double[])item_.getTemp7(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8, (double[])item_.getTemp8(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9, (double[])item_.getTemp9(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTotalPowerTelemetry() throws Exception {
        double rebTotalPower = 0.6174356341362;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTotalPowerTelemetry(rebTotalPower));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTotalPowerTelemetry));
        Focal_plane_RebTotalPowerTelemetry item_ = (Focal_plane_RebTotalPowerTelemetry)item;
        Assert.assertEquals((double)rebTotalPower, (double)item_.getRebTotalPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebsAverageTemp6Telemetry() throws Exception {
        double rebsAverageTemp6 = 0.1345319151878357;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebsAverageTemp6Telemetry(rebsAverageTemp6));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebsAverageTemp6Telemetry));
        Focal_plane_RebsAverageTemp6Telemetry item_ = (Focal_plane_RebsAverageTemp6Telemetry)item;
        Assert.assertEquals((double)rebsAverageTemp6, (double)item_.getRebsAverageTemp6(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_SegmentTelemetry() throws Exception {
        double[] i = TestHelper.generateDoubleArray((int)3024, (int)704972514);
        String location = "h";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_SegmentTelemetry(i, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SegmentTelemetry));
        Focal_plane_SegmentTelemetry item_ = (Focal_plane_SegmentTelemetry)item;
        Assert.assertArrayEquals((double[])i, (double[])item_.getI(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFcs_Autochanger_AutochangerTrucks_TrendingTelemetry() throws Exception {
        boolean actruckxminus_handoffInError = true;
        boolean actruckxminus_handoffSensorValue = true;
        boolean actruckxminus_onlineInError = true;
        boolean actruckxminus_onlineSensorValue = false;
        boolean actruckxminus_standbyInError = false;
        boolean actruckxminus_standbySensorValue = false;
        boolean actruckxplus_handoffInError = false;
        boolean actruckxplus_handoffSensorValue = true;
        boolean actruckxplus_onlineInError = true;
        boolean actruckxplus_onlineSensorValue = false;
        boolean actruckxplus_standbyInError = false;
        boolean actruckxplus_standbySensorValue = false;
        boolean atHandoff = false;
        boolean atOnline = false;
        boolean atStandby = true;
        int driverPosition = 729;
        int followerPosition = 411;
        boolean homingDone = false;
        boolean inError = false;
        int proximityDistance = 747;
        double proximityVoltage = 0.21610617637634277;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Autochanger_AutochangerTrucks_TrendingTelemetry(actruckxminus_handoffInError, actruckxminus_handoffSensorValue, actruckxminus_onlineInError, actruckxminus_onlineSensorValue, actruckxminus_standbyInError, actruckxminus_standbySensorValue, actruckxplus_handoffInError, actruckxplus_handoffSensorValue, actruckxplus_onlineInError, actruckxplus_onlineSensorValue, actruckxplus_standbyInError, actruckxplus_standbySensorValue, atHandoff, atOnline, atStandby, driverPosition, followerPosition, homingDone, inError, proximityDistance, proximityVoltage));
        Assert.assertTrue((boolean)(item instanceof Fcs_Autochanger_AutochangerTrucks_TrendingTelemetry));
        Fcs_Autochanger_AutochangerTrucks_TrendingTelemetry item_ = (Fcs_Autochanger_AutochangerTrucks_TrendingTelemetry)item;
        Assert.assertEquals((Object)actruckxminus_handoffInError, (Object)item_.isActruckxminus_handoffInError());
        Assert.assertEquals((Object)actruckxminus_handoffSensorValue, (Object)item_.isActruckxminus_handoffSensorValue());
        Assert.assertEquals((Object)actruckxminus_onlineInError, (Object)item_.isActruckxminus_onlineInError());
        Assert.assertEquals((Object)actruckxminus_onlineSensorValue, (Object)item_.isActruckxminus_onlineSensorValue());
        Assert.assertEquals((Object)actruckxminus_standbyInError, (Object)item_.isActruckxminus_standbyInError());
        Assert.assertEquals((Object)actruckxminus_standbySensorValue, (Object)item_.isActruckxminus_standbySensorValue());
        Assert.assertEquals((Object)actruckxplus_handoffInError, (Object)item_.isActruckxplus_handoffInError());
        Assert.assertEquals((Object)actruckxplus_handoffSensorValue, (Object)item_.isActruckxplus_handoffSensorValue());
        Assert.assertEquals((Object)actruckxplus_onlineInError, (Object)item_.isActruckxplus_onlineInError());
        Assert.assertEquals((Object)actruckxplus_onlineSensorValue, (Object)item_.isActruckxplus_onlineSensorValue());
        Assert.assertEquals((Object)actruckxplus_standbyInError, (Object)item_.isActruckxplus_standbyInError());
        Assert.assertEquals((Object)actruckxplus_standbySensorValue, (Object)item_.isActruckxplus_standbySensorValue());
        Assert.assertEquals((Object)atHandoff, (Object)item_.isAtHandoff());
        Assert.assertEquals((Object)atOnline, (Object)item_.isAtOnline());
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((long)driverPosition, (long)item_.getDriverPosition());
        Assert.assertEquals((long)followerPosition, (long)item_.getFollowerPosition());
        Assert.assertEquals((Object)homingDone, (Object)item_.isHomingDone());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)proximityDistance, (long)item_.getProximityDistance());
        Assert.assertEquals((double)proximityVoltage, (double)item_.getProximityVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Autochanger_Latches_TrendingTelemetry() throws Exception {
        int filterId = 79;
        String filterName = "";
        String filterPresenceStatus = "";
        boolean latchxminus_filterEngagedSensorsInError = false;
        boolean latchxminus_filterPresenceSensorValue = true;
        boolean latchxminus_inError = true;
        boolean latchxminus_lockSensorValue = false;
        boolean latchxminus_lockSensorsInError = false;
        String latchxminus_lockStatus = "";
        boolean latchxminus_unlockSensorValue = true;
        boolean latchxminus_unlockSensorsInError = true;
        boolean latchxplus_filterEngagedSensorsInError = false;
        boolean latchxplus_filterPresenceSensorValue = false;
        boolean latchxplus_inError = false;
        boolean latchxplus_lockSensorValue = false;
        boolean latchxplus_lockSensorsInError = false;
        String latchxplus_lockStatus = "";
        boolean latchxplus_unlockSensorValue = true;
        boolean latchxplus_unlockSensorsInError = true;
        String lockStatus = "f";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Autochanger_Latches_TrendingTelemetry(filterId, filterName, filterPresenceStatus, latchxminus_filterEngagedSensorsInError, latchxminus_filterPresenceSensorValue, latchxminus_inError, latchxminus_lockSensorValue, latchxminus_lockSensorsInError, latchxminus_lockStatus, latchxminus_unlockSensorValue, latchxminus_unlockSensorsInError, latchxplus_filterEngagedSensorsInError, latchxplus_filterPresenceSensorValue, latchxplus_inError, latchxplus_lockSensorValue, latchxplus_lockSensorsInError, latchxplus_lockStatus, latchxplus_unlockSensorValue, latchxplus_unlockSensorsInError, lockStatus));
        Assert.assertTrue((boolean)(item instanceof Fcs_Autochanger_Latches_TrendingTelemetry));
        Fcs_Autochanger_Latches_TrendingTelemetry item_ = (Fcs_Autochanger_Latches_TrendingTelemetry)item;
        Assert.assertEquals((long)filterId, (long)item_.getFilterId());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)filterPresenceStatus, (Object)item_.getFilterPresenceStatus());
        Assert.assertEquals((Object)latchxminus_filterEngagedSensorsInError, (Object)item_.isLatchxminus_filterEngagedSensorsInError());
        Assert.assertEquals((Object)latchxminus_filterPresenceSensorValue, (Object)item_.isLatchxminus_filterPresenceSensorValue());
        Assert.assertEquals((Object)latchxminus_inError, (Object)item_.isLatchxminus_inError());
        Assert.assertEquals((Object)latchxminus_lockSensorValue, (Object)item_.isLatchxminus_lockSensorValue());
        Assert.assertEquals((Object)latchxminus_lockSensorsInError, (Object)item_.isLatchxminus_lockSensorsInError());
        Assert.assertEquals((Object)latchxminus_lockStatus, (Object)item_.getLatchxminus_lockStatus());
        Assert.assertEquals((Object)latchxminus_unlockSensorValue, (Object)item_.isLatchxminus_unlockSensorValue());
        Assert.assertEquals((Object)latchxminus_unlockSensorsInError, (Object)item_.isLatchxminus_unlockSensorsInError());
        Assert.assertEquals((Object)latchxplus_filterEngagedSensorsInError, (Object)item_.isLatchxplus_filterEngagedSensorsInError());
        Assert.assertEquals((Object)latchxplus_filterPresenceSensorValue, (Object)item_.isLatchxplus_filterPresenceSensorValue());
        Assert.assertEquals((Object)latchxplus_inError, (Object)item_.isLatchxplus_inError());
        Assert.assertEquals((Object)latchxplus_lockSensorValue, (Object)item_.isLatchxplus_lockSensorValue());
        Assert.assertEquals((Object)latchxplus_lockSensorsInError, (Object)item_.isLatchxplus_lockSensorsInError());
        Assert.assertEquals((Object)latchxplus_lockStatus, (Object)item_.getLatchxplus_lockStatus());
        Assert.assertEquals((Object)latchxplus_unlockSensorValue, (Object)item_.isLatchxplus_unlockSensorValue());
        Assert.assertEquals((Object)latchxplus_unlockSensorsInError, (Object)item_.isLatchxplus_unlockSensorsInError());
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
    }

    @Test
    public void sendReceiveFcs_Autochanger_OnlineClamps_TrendingTelemetry() throws Exception {
        String lockStatus = "";
        int onlineClampRawStrain = 176;
        int onlineClampStrain = 722;
        boolean onlineclampxminus_inError = false;
        boolean onlineclampxminus_lockSensorInError = true;
        boolean onlineclampxminus_lockSensorValue = false;
        String onlineclampxminus_lockStatus = "";
        int onlineclampxminus_sentCurrent = 932;
        boolean onlineclampxminus_unlockSensorInError = true;
        boolean onlineclampxminus_unlockSensorValue = false;
        boolean onlineclampxplus_inError = true;
        boolean onlineclampxplus_lockSensorInError = false;
        boolean onlineclampxplus_lockSensorValue = false;
        String onlineclampxplus_lockStatus = "";
        int onlineclampxplus_sentCurrent = 393;
        boolean onlineclampxplus_unlockSensorInError = true;
        boolean onlineclampxplus_unlockSensorValue = true;
        boolean onlineclampyminus_inError = false;
        boolean onlineclampyminus_lockSensorInError = true;
        boolean onlineclampyminus_lockSensorValue = true;
        String onlineclampyminus_lockStatus = "";
        int onlineclampyminus_sentCurrent = 601;
        boolean onlineclampyminus_unlockSensorInError = false;
        boolean onlineclampyminus_unlockSensorValue = false;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Autochanger_OnlineClamps_TrendingTelemetry(lockStatus, onlineClampRawStrain, onlineClampStrain, onlineclampxminus_inError, onlineclampxminus_lockSensorInError, onlineclampxminus_lockSensorValue, onlineclampxminus_lockStatus, onlineclampxminus_sentCurrent, onlineclampxminus_unlockSensorInError, onlineclampxminus_unlockSensorValue, onlineclampxplus_inError, onlineclampxplus_lockSensorInError, onlineclampxplus_lockSensorValue, onlineclampxplus_lockStatus, onlineclampxplus_sentCurrent, onlineclampxplus_unlockSensorInError, onlineclampxplus_unlockSensorValue, onlineclampyminus_inError, onlineclampyminus_lockSensorInError, onlineclampyminus_lockSensorValue, onlineclampyminus_lockStatus, onlineclampyminus_sentCurrent, onlineclampyminus_unlockSensorInError, onlineclampyminus_unlockSensorValue));
        Assert.assertTrue((boolean)(item instanceof Fcs_Autochanger_OnlineClamps_TrendingTelemetry));
        Fcs_Autochanger_OnlineClamps_TrendingTelemetry item_ = (Fcs_Autochanger_OnlineClamps_TrendingTelemetry)item;
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
        Assert.assertEquals((long)onlineClampRawStrain, (long)item_.getOnlineClampRawStrain());
        Assert.assertEquals((long)onlineClampStrain, (long)item_.getOnlineClampStrain());
        Assert.assertEquals((Object)onlineclampxminus_inError, (Object)item_.isOnlineclampxminus_inError());
        Assert.assertEquals((Object)onlineclampxminus_lockSensorInError, (Object)item_.isOnlineclampxminus_lockSensorInError());
        Assert.assertEquals((Object)onlineclampxminus_lockSensorValue, (Object)item_.isOnlineclampxminus_lockSensorValue());
        Assert.assertEquals((Object)onlineclampxminus_lockStatus, (Object)item_.getOnlineclampxminus_lockStatus());
        Assert.assertEquals((long)onlineclampxminus_sentCurrent, (long)item_.getOnlineclampxminus_sentCurrent());
        Assert.assertEquals((Object)onlineclampxminus_unlockSensorInError, (Object)item_.isOnlineclampxminus_unlockSensorInError());
        Assert.assertEquals((Object)onlineclampxminus_unlockSensorValue, (Object)item_.isOnlineclampxminus_unlockSensorValue());
        Assert.assertEquals((Object)onlineclampxplus_inError, (Object)item_.isOnlineclampxplus_inError());
        Assert.assertEquals((Object)onlineclampxplus_lockSensorInError, (Object)item_.isOnlineclampxplus_lockSensorInError());
        Assert.assertEquals((Object)onlineclampxplus_lockSensorValue, (Object)item_.isOnlineclampxplus_lockSensorValue());
        Assert.assertEquals((Object)onlineclampxplus_lockStatus, (Object)item_.getOnlineclampxplus_lockStatus());
        Assert.assertEquals((long)onlineclampxplus_sentCurrent, (long)item_.getOnlineclampxplus_sentCurrent());
        Assert.assertEquals((Object)onlineclampxplus_unlockSensorInError, (Object)item_.isOnlineclampxplus_unlockSensorInError());
        Assert.assertEquals((Object)onlineclampxplus_unlockSensorValue, (Object)item_.isOnlineclampxplus_unlockSensorValue());
        Assert.assertEquals((Object)onlineclampyminus_inError, (Object)item_.isOnlineclampyminus_inError());
        Assert.assertEquals((Object)onlineclampyminus_lockSensorInError, (Object)item_.isOnlineclampyminus_lockSensorInError());
        Assert.assertEquals((Object)onlineclampyminus_lockSensorValue, (Object)item_.isOnlineclampyminus_lockSensorValue());
        Assert.assertEquals((Object)onlineclampyminus_lockStatus, (Object)item_.getOnlineclampyminus_lockStatus());
        Assert.assertEquals((long)onlineclampyminus_sentCurrent, (long)item_.getOnlineclampyminus_sentCurrent());
        Assert.assertEquals((Object)onlineclampyminus_unlockSensorInError, (Object)item_.isOnlineclampyminus_unlockSensorInError());
        Assert.assertEquals((Object)onlineclampyminus_unlockSensorValue, (Object)item_.isOnlineclampyminus_unlockSensorValue());
    }

    @Test
    public void sendReceiveFcs_Autochanger_TemperaturesTelemetry() throws Exception {
        double tempCellXminus = 0.8883137702941895;
        double tempClampMotorXminus = 0.46426987648010254;
        double tempClampMotorXplus = 0.1538153886795044;
        double tempClampMotorYminus = 0.6605433225631714;
        double tempFrontBox = 0.05602604150772095;
        double tempLinearRailMotorXminus = 0.6079491972923279;
        double tempLinearRailMotorXplus = 0.1355912685394287;
        double tempRearBox = 0.048298f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Autochanger_TemperaturesTelemetry(tempCellXminus, tempClampMotorXminus, tempClampMotorXplus, tempClampMotorYminus, tempFrontBox, tempLinearRailMotorXminus, tempLinearRailMotorXplus, tempRearBox));
        Assert.assertTrue((boolean)(item instanceof Fcs_Autochanger_TemperaturesTelemetry));
        Fcs_Autochanger_TemperaturesTelemetry item_ = (Fcs_Autochanger_TemperaturesTelemetry)item;
        Assert.assertEquals((double)tempCellXminus, (double)item_.getTempCellXminus(), (double)1.0E-6f);
        Assert.assertEquals((double)tempClampMotorXminus, (double)item_.getTempClampMotorXminus(), (double)1.0E-6f);
        Assert.assertEquals((double)tempClampMotorXplus, (double)item_.getTempClampMotorXplus(), (double)1.0E-6f);
        Assert.assertEquals((double)tempClampMotorYminus, (double)item_.getTempClampMotorYminus(), (double)1.0E-6f);
        Assert.assertEquals((double)tempFrontBox, (double)item_.getTempFrontBox(), (double)1.0E-6f);
        Assert.assertEquals((double)tempLinearRailMotorXminus, (double)item_.getTempLinearRailMotorXminus(), (double)1.0E-6f);
        Assert.assertEquals((double)tempLinearRailMotorXplus, (double)item_.getTempLinearRailMotorXplus(), (double)1.0E-6f);
        Assert.assertEquals((double)tempRearBox, (double)item_.getTempRearBox(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Canbus0_AcSensorsGateway_TrendingTelemetry() throws Exception {
        int acAF0b = 374;
        int acAF0s = 947;
        int acAF1b = 596;
        int acAF1s = 798;
        int acAF3b = 267;
        int acAF3s = 57;
        int acAP2b = 81;
        int acAP2s = 761;
        int carouselHoldingFilterSensor0 = 353;
        int carouselHoldingFilterSensor1 = 291;
        int carouselStoppedAtStandby = 987;
        int carouselStoppedAtStandbyC = 284;
        int carousel_CF0 = 170;
        int carousel_CF0_C = 941;
        int carousel_CF1 = 674;
        int carousel_CF1_C = 896;
        int clampedStatusSensor = 766;
        int closeSensorBLatchXminus = 344;
        int closeSensorBLatchXplus = 595;
        int closeSensorLatchXminus = 182;
        int closeSensorLatchXplus = 186;
        int engineeringKey = 19;
        int engineeringkey_C = 748;
        int filterEngagedSensorBLatchXminus = 499;
        int filterEngagedSensorBLatchXplus = 230;
        int filterEngagedSensorLatchXminus = 628;
        int filterEngagedSensorLatchXplus = 994;
        int filterIDSensor0 = 744;
        int filterIDSensor1 = 856;
        int filterIDSensor2 = 500;
        int filterIDSensor3 = 361;
        int filterIDSensor4 = 957;
        int filterIDSensor5 = 530;
        int forceSensor0 = 313;
        int forceSensor1 = 519;
        int handoffPositionSensorBXminus = 853;
        int handoffPositionSensorBXplus = 685;
        int handoffPositionSensorXminus = 797;
        int handoffPositionSensorXplus = 421;
        double inclinometerXminus = 0.4899361729621887;
        double inclinometerXplus = 0.9856657385826111;
        int keyEng = 267;
        int keyEngb = 763;
        int keyLock = 167;
        int keyLockb = 442;
        int lps_0 = 33;
        int lps_1 = 119;
        int lrh_0 = 675;
        int lrh_1 = 232;
        int loaderCarrierRelayStatus = 353;
        int loaderChainPresenceSensor = 786;
        int loaderCloseSensor1 = 84;
        int loaderCloseSensor2 = 59;
        int loaderCloseSensor3 = 890;
        int loaderCloseSensor4 = 255;
        int loaderConnectedSensor = 832;
        int loaderConnectedSensorC = 377;
        int loaderDefaultStatus = 68;
        int loaderEngagedPositionSensor0 = 489;
        int loaderEngagedPositionSensor1 = 962;
        int loaderFilterDistanceSensor = 190;
        int loaderFilterGoodPositionStatus = 321;
        int loaderFilterPresenceSensor0 = 31;
        int loaderFilterPresenceSensor1 = 210;
        int loaderHandoffPositionSensor0 = 391;
        int loaderHandoffPositionSensor1 = 814;
        int loaderHoldingFilterSensor0 = 823;
        int loaderHoldingFilterSensor1 = 155;
        int loaderHooksRelayStatus = 875;
        int loaderOnCameraSensor0 = 937;
        int loaderOnCameraSensor1 = 717;
        int loaderOpenSensor1 = 13;
        int loaderOpenSensor2 = 470;
        int loaderOpenSensor3 = 12;
        int loaderOpenSensor4 = 517;
        int loaderStoragePositionSensor0 = 161;
        int loaderStoragePositionSensor1 = 715;
        int loader_LFD = 303;
        int loader_LFS = 733;
        int lockOut = 874;
        int lockOutShunt = 45;
        int lockout_C = 580;
        int lpmLatchesStatus = 240;
        int lpmLinearRail1Status = 211;
        int lpmLinearRail2Status = 234;
        int lpmOnlineClampsStatus = 636;
        int out_AF0 = 184;
        int out_AF0_C = 963;
        int out_AF1 = 917;
        int out_AF1_C = 727;
        int out_AF3 = 907;
        int out_AF3_C = 101;
        int out_AIN = 102;
        int out_AOL = 73;
        int out_AP1 = 441;
        int out_AP1_C = 828;
        int out_AP2 = 40;
        int out_AP2_C = 391;
        int out_AP3 = 367;
        int out_AP3_C = 524;
        int onlineClampXminusCloseSensor = 735;
        int onlineClampXminusCloseSensorC = 977;
        int onlineClampXminusOpenSensor = 67;
        int onlineClampXminusOpenSensorC = 628;
        int onlineClampXplusCloseSensor = 692;
        int onlineClampXplusCloseSensorC = 706;
        int onlineClampXplusOpenSensor = 997;
        int onlineClampXplusOpenSensorC = 167;
        int onlineClampYminusCloseSensor = 871;
        int onlineClampYminusCloseSensorC = 842;
        int onlineClampYminusOpenSensor = 166;
        int onlineClampYminusOpenSensorC = 161;
        int onlinePositionSensorBXminus = 16;
        int onlinePositionSensorBXplus = 621;
        int onlinePositionSensorXminus = 264;
        int onlinePositionSensorXplus = 903;
        int openSensorBLatchXminus = 186;
        int openSensorBLatchXplus = 580;
        int openSensorLatchXminus = 186;
        int openSensorLatchXplus = 303;
        int overClampedStatusSensor = 444;
        int presenceLoader = 177;
        int presenceloader_C = 374;
        int standbyPositionSensorBXminus = 183;
        int standbyPositionSensorBXplus = 932;
        int standbyPositionSensorXminus = 199;
        int standbyPositionSensorXplus = 496;
        int unclampedStatusSensor = 889;
        int underClampedStatusSensor = 338;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_AcSensorsGateway_TrendingTelemetry(acAF0b, acAF0s, acAF1b, acAF1s, acAF3b, acAF3s, acAP2b, acAP2s, carouselHoldingFilterSensor0, carouselHoldingFilterSensor1, carouselStoppedAtStandby, carouselStoppedAtStandbyC, carousel_CF0, carousel_CF0_C, carousel_CF1, carousel_CF1_C, clampedStatusSensor, closeSensorBLatchXminus, closeSensorBLatchXplus, closeSensorLatchXminus, closeSensorLatchXplus, engineeringKey, engineeringkey_C, filterEngagedSensorBLatchXminus, filterEngagedSensorBLatchXplus, filterEngagedSensorLatchXminus, filterEngagedSensorLatchXplus, filterIDSensor0, filterIDSensor1, filterIDSensor2, filterIDSensor3, filterIDSensor4, filterIDSensor5, forceSensor0, forceSensor1, handoffPositionSensorBXminus, handoffPositionSensorBXplus, handoffPositionSensorXminus, handoffPositionSensorXplus, inclinometerXminus, inclinometerXplus, keyEng, keyEngb, keyLock, keyLockb, lps_0, lps_1, lrh_0, lrh_1, loaderCarrierRelayStatus, loaderChainPresenceSensor, loaderCloseSensor1, loaderCloseSensor2, loaderCloseSensor3, loaderCloseSensor4, loaderConnectedSensor, loaderConnectedSensorC, loaderDefaultStatus, loaderEngagedPositionSensor0, loaderEngagedPositionSensor1, loaderFilterDistanceSensor, loaderFilterGoodPositionStatus, loaderFilterPresenceSensor0, loaderFilterPresenceSensor1, loaderHandoffPositionSensor0, loaderHandoffPositionSensor1, loaderHoldingFilterSensor0, loaderHoldingFilterSensor1, loaderHooksRelayStatus, loaderOnCameraSensor0, loaderOnCameraSensor1, loaderOpenSensor1, loaderOpenSensor2, loaderOpenSensor3, loaderOpenSensor4, loaderStoragePositionSensor0, loaderStoragePositionSensor1, loader_LFD, loader_LFS, lockOut, lockOutShunt, lockout_C, lpmLatchesStatus, lpmLinearRail1Status, lpmLinearRail2Status, lpmOnlineClampsStatus, out_AF0, out_AF0_C, out_AF1, out_AF1_C, out_AF3, out_AF3_C, out_AIN, out_AOL, out_AP1, out_AP1_C, out_AP2, out_AP2_C, out_AP3, out_AP3_C, onlineClampXminusCloseSensor, onlineClampXminusCloseSensorC, onlineClampXminusOpenSensor, onlineClampXminusOpenSensorC, onlineClampXplusCloseSensor, onlineClampXplusCloseSensorC, onlineClampXplusOpenSensor, onlineClampXplusOpenSensorC, onlineClampYminusCloseSensor, onlineClampYminusCloseSensorC, onlineClampYminusOpenSensor, onlineClampYminusOpenSensorC, onlinePositionSensorBXminus, onlinePositionSensorBXplus, onlinePositionSensorXminus, onlinePositionSensorXplus, openSensorBLatchXminus, openSensorBLatchXplus, openSensorLatchXminus, openSensorLatchXplus, overClampedStatusSensor, presenceLoader, presenceloader_C, standbyPositionSensorBXminus, standbyPositionSensorBXplus, standbyPositionSensorXminus, standbyPositionSensorXplus, unclampedStatusSensor, underClampedStatusSensor));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_AcSensorsGateway_TrendingTelemetry));
        Fcs_Canbus0_AcSensorsGateway_TrendingTelemetry item_ = (Fcs_Canbus0_AcSensorsGateway_TrendingTelemetry)item;
        Assert.assertEquals((long)acAF0b, (long)item_.getAcAF0b());
        Assert.assertEquals((long)acAF0s, (long)item_.getAcAF0s());
        Assert.assertEquals((long)acAF1b, (long)item_.getAcAF1b());
        Assert.assertEquals((long)acAF1s, (long)item_.getAcAF1s());
        Assert.assertEquals((long)acAF3b, (long)item_.getAcAF3b());
        Assert.assertEquals((long)acAF3s, (long)item_.getAcAF3s());
        Assert.assertEquals((long)acAP2b, (long)item_.getAcAP2b());
        Assert.assertEquals((long)acAP2s, (long)item_.getAcAP2s());
        Assert.assertEquals((long)carouselHoldingFilterSensor0, (long)item_.getCarouselHoldingFilterSensor0());
        Assert.assertEquals((long)carouselHoldingFilterSensor1, (long)item_.getCarouselHoldingFilterSensor1());
        Assert.assertEquals((long)carouselStoppedAtStandby, (long)item_.getCarouselStoppedAtStandby());
        Assert.assertEquals((long)carouselStoppedAtStandbyC, (long)item_.getCarouselStoppedAtStandbyC());
        Assert.assertEquals((long)carousel_CF0, (long)item_.getCarousel_CF0());
        Assert.assertEquals((long)carousel_CF0_C, (long)item_.getCarousel_CF0_C());
        Assert.assertEquals((long)carousel_CF1, (long)item_.getCarousel_CF1());
        Assert.assertEquals((long)carousel_CF1_C, (long)item_.getCarousel_CF1_C());
        Assert.assertEquals((long)clampedStatusSensor, (long)item_.getClampedStatusSensor());
        Assert.assertEquals((long)closeSensorBLatchXminus, (long)item_.getCloseSensorBLatchXminus());
        Assert.assertEquals((long)closeSensorBLatchXplus, (long)item_.getCloseSensorBLatchXplus());
        Assert.assertEquals((long)closeSensorLatchXminus, (long)item_.getCloseSensorLatchXminus());
        Assert.assertEquals((long)closeSensorLatchXplus, (long)item_.getCloseSensorLatchXplus());
        Assert.assertEquals((long)engineeringKey, (long)item_.getEngineeringKey());
        Assert.assertEquals((long)engineeringkey_C, (long)item_.getEngineeringkey_C());
        Assert.assertEquals((long)filterEngagedSensorBLatchXminus, (long)item_.getFilterEngagedSensorBLatchXminus());
        Assert.assertEquals((long)filterEngagedSensorBLatchXplus, (long)item_.getFilterEngagedSensorBLatchXplus());
        Assert.assertEquals((long)filterEngagedSensorLatchXminus, (long)item_.getFilterEngagedSensorLatchXminus());
        Assert.assertEquals((long)filterEngagedSensorLatchXplus, (long)item_.getFilterEngagedSensorLatchXplus());
        Assert.assertEquals((long)filterIDSensor0, (long)item_.getFilterIDSensor0());
        Assert.assertEquals((long)filterIDSensor1, (long)item_.getFilterIDSensor1());
        Assert.assertEquals((long)filterIDSensor2, (long)item_.getFilterIDSensor2());
        Assert.assertEquals((long)filterIDSensor3, (long)item_.getFilterIDSensor3());
        Assert.assertEquals((long)filterIDSensor4, (long)item_.getFilterIDSensor4());
        Assert.assertEquals((long)filterIDSensor5, (long)item_.getFilterIDSensor5());
        Assert.assertEquals((long)forceSensor0, (long)item_.getForceSensor0());
        Assert.assertEquals((long)forceSensor1, (long)item_.getForceSensor1());
        Assert.assertEquals((long)handoffPositionSensorBXminus, (long)item_.getHandoffPositionSensorBXminus());
        Assert.assertEquals((long)handoffPositionSensorBXplus, (long)item_.getHandoffPositionSensorBXplus());
        Assert.assertEquals((long)handoffPositionSensorXminus, (long)item_.getHandoffPositionSensorXminus());
        Assert.assertEquals((long)handoffPositionSensorXplus, (long)item_.getHandoffPositionSensorXplus());
        Assert.assertEquals((double)inclinometerXminus, (double)item_.getInclinometerXminus(), (double)1.0E-6f);
        Assert.assertEquals((double)inclinometerXplus, (double)item_.getInclinometerXplus(), (double)1.0E-6f);
        Assert.assertEquals((long)keyEng, (long)item_.getKeyEng());
        Assert.assertEquals((long)keyEngb, (long)item_.getKeyEngb());
        Assert.assertEquals((long)keyLock, (long)item_.getKeyLock());
        Assert.assertEquals((long)keyLockb, (long)item_.getKeyLockb());
        Assert.assertEquals((long)lps_0, (long)item_.getLps_0());
        Assert.assertEquals((long)lps_1, (long)item_.getLps_1());
        Assert.assertEquals((long)lrh_0, (long)item_.getLrh_0());
        Assert.assertEquals((long)lrh_1, (long)item_.getLrh_1());
        Assert.assertEquals((long)loaderCarrierRelayStatus, (long)item_.getLoaderCarrierRelayStatus());
        Assert.assertEquals((long)loaderChainPresenceSensor, (long)item_.getLoaderChainPresenceSensor());
        Assert.assertEquals((long)loaderCloseSensor1, (long)item_.getLoaderCloseSensor1());
        Assert.assertEquals((long)loaderCloseSensor2, (long)item_.getLoaderCloseSensor2());
        Assert.assertEquals((long)loaderCloseSensor3, (long)item_.getLoaderCloseSensor3());
        Assert.assertEquals((long)loaderCloseSensor4, (long)item_.getLoaderCloseSensor4());
        Assert.assertEquals((long)loaderConnectedSensor, (long)item_.getLoaderConnectedSensor());
        Assert.assertEquals((long)loaderConnectedSensorC, (long)item_.getLoaderConnectedSensorC());
        Assert.assertEquals((long)loaderDefaultStatus, (long)item_.getLoaderDefaultStatus());
        Assert.assertEquals((long)loaderEngagedPositionSensor0, (long)item_.getLoaderEngagedPositionSensor0());
        Assert.assertEquals((long)loaderEngagedPositionSensor1, (long)item_.getLoaderEngagedPositionSensor1());
        Assert.assertEquals((long)loaderFilterDistanceSensor, (long)item_.getLoaderFilterDistanceSensor());
        Assert.assertEquals((long)loaderFilterGoodPositionStatus, (long)item_.getLoaderFilterGoodPositionStatus());
        Assert.assertEquals((long)loaderFilterPresenceSensor0, (long)item_.getLoaderFilterPresenceSensor0());
        Assert.assertEquals((long)loaderFilterPresenceSensor1, (long)item_.getLoaderFilterPresenceSensor1());
        Assert.assertEquals((long)loaderHandoffPositionSensor0, (long)item_.getLoaderHandoffPositionSensor0());
        Assert.assertEquals((long)loaderHandoffPositionSensor1, (long)item_.getLoaderHandoffPositionSensor1());
        Assert.assertEquals((long)loaderHoldingFilterSensor0, (long)item_.getLoaderHoldingFilterSensor0());
        Assert.assertEquals((long)loaderHoldingFilterSensor1, (long)item_.getLoaderHoldingFilterSensor1());
        Assert.assertEquals((long)loaderHooksRelayStatus, (long)item_.getLoaderHooksRelayStatus());
        Assert.assertEquals((long)loaderOnCameraSensor0, (long)item_.getLoaderOnCameraSensor0());
        Assert.assertEquals((long)loaderOnCameraSensor1, (long)item_.getLoaderOnCameraSensor1());
        Assert.assertEquals((long)loaderOpenSensor1, (long)item_.getLoaderOpenSensor1());
        Assert.assertEquals((long)loaderOpenSensor2, (long)item_.getLoaderOpenSensor2());
        Assert.assertEquals((long)loaderOpenSensor3, (long)item_.getLoaderOpenSensor3());
        Assert.assertEquals((long)loaderOpenSensor4, (long)item_.getLoaderOpenSensor4());
        Assert.assertEquals((long)loaderStoragePositionSensor0, (long)item_.getLoaderStoragePositionSensor0());
        Assert.assertEquals((long)loaderStoragePositionSensor1, (long)item_.getLoaderStoragePositionSensor1());
        Assert.assertEquals((long)loader_LFD, (long)item_.getLoader_LFD());
        Assert.assertEquals((long)loader_LFS, (long)item_.getLoader_LFS());
        Assert.assertEquals((long)lockOut, (long)item_.getLockOut());
        Assert.assertEquals((long)lockOutShunt, (long)item_.getLockOutShunt());
        Assert.assertEquals((long)lockout_C, (long)item_.getLockout_C());
        Assert.assertEquals((long)lpmLatchesStatus, (long)item_.getLpmLatchesStatus());
        Assert.assertEquals((long)lpmLinearRail1Status, (long)item_.getLpmLinearRail1Status());
        Assert.assertEquals((long)lpmLinearRail2Status, (long)item_.getLpmLinearRail2Status());
        Assert.assertEquals((long)lpmOnlineClampsStatus, (long)item_.getLpmOnlineClampsStatus());
        Assert.assertEquals((long)out_AF0, (long)item_.getOut_AF0());
        Assert.assertEquals((long)out_AF0_C, (long)item_.getOut_AF0_C());
        Assert.assertEquals((long)out_AF1, (long)item_.getOut_AF1());
        Assert.assertEquals((long)out_AF1_C, (long)item_.getOut_AF1_C());
        Assert.assertEquals((long)out_AF3, (long)item_.getOut_AF3());
        Assert.assertEquals((long)out_AF3_C, (long)item_.getOut_AF3_C());
        Assert.assertEquals((long)out_AIN, (long)item_.getOut_AIN());
        Assert.assertEquals((long)out_AOL, (long)item_.getOut_AOL());
        Assert.assertEquals((long)out_AP1, (long)item_.getOut_AP1());
        Assert.assertEquals((long)out_AP1_C, (long)item_.getOut_AP1_C());
        Assert.assertEquals((long)out_AP2, (long)item_.getOut_AP2());
        Assert.assertEquals((long)out_AP2_C, (long)item_.getOut_AP2_C());
        Assert.assertEquals((long)out_AP3, (long)item_.getOut_AP3());
        Assert.assertEquals((long)out_AP3_C, (long)item_.getOut_AP3_C());
        Assert.assertEquals((long)onlineClampXminusCloseSensor, (long)item_.getOnlineClampXminusCloseSensor());
        Assert.assertEquals((long)onlineClampXminusCloseSensorC, (long)item_.getOnlineClampXminusCloseSensorC());
        Assert.assertEquals((long)onlineClampXminusOpenSensor, (long)item_.getOnlineClampXminusOpenSensor());
        Assert.assertEquals((long)onlineClampXminusOpenSensorC, (long)item_.getOnlineClampXminusOpenSensorC());
        Assert.assertEquals((long)onlineClampXplusCloseSensor, (long)item_.getOnlineClampXplusCloseSensor());
        Assert.assertEquals((long)onlineClampXplusCloseSensorC, (long)item_.getOnlineClampXplusCloseSensorC());
        Assert.assertEquals((long)onlineClampXplusOpenSensor, (long)item_.getOnlineClampXplusOpenSensor());
        Assert.assertEquals((long)onlineClampXplusOpenSensorC, (long)item_.getOnlineClampXplusOpenSensorC());
        Assert.assertEquals((long)onlineClampYminusCloseSensor, (long)item_.getOnlineClampYminusCloseSensor());
        Assert.assertEquals((long)onlineClampYminusCloseSensorC, (long)item_.getOnlineClampYminusCloseSensorC());
        Assert.assertEquals((long)onlineClampYminusOpenSensor, (long)item_.getOnlineClampYminusOpenSensor());
        Assert.assertEquals((long)onlineClampYminusOpenSensorC, (long)item_.getOnlineClampYminusOpenSensorC());
        Assert.assertEquals((long)onlinePositionSensorBXminus, (long)item_.getOnlinePositionSensorBXminus());
        Assert.assertEquals((long)onlinePositionSensorBXplus, (long)item_.getOnlinePositionSensorBXplus());
        Assert.assertEquals((long)onlinePositionSensorXminus, (long)item_.getOnlinePositionSensorXminus());
        Assert.assertEquals((long)onlinePositionSensorXplus, (long)item_.getOnlinePositionSensorXplus());
        Assert.assertEquals((long)openSensorBLatchXminus, (long)item_.getOpenSensorBLatchXminus());
        Assert.assertEquals((long)openSensorBLatchXplus, (long)item_.getOpenSensorBLatchXplus());
        Assert.assertEquals((long)openSensorLatchXminus, (long)item_.getOpenSensorLatchXminus());
        Assert.assertEquals((long)openSensorLatchXplus, (long)item_.getOpenSensorLatchXplus());
        Assert.assertEquals((long)overClampedStatusSensor, (long)item_.getOverClampedStatusSensor());
        Assert.assertEquals((long)presenceLoader, (long)item_.getPresenceLoader());
        Assert.assertEquals((long)presenceloader_C, (long)item_.getPresenceloader_C());
        Assert.assertEquals((long)standbyPositionSensorBXminus, (long)item_.getStandbyPositionSensorBXminus());
        Assert.assertEquals((long)standbyPositionSensorBXplus, (long)item_.getStandbyPositionSensorBXplus());
        Assert.assertEquals((long)standbyPositionSensorXminus, (long)item_.getStandbyPositionSensorXminus());
        Assert.assertEquals((long)standbyPositionSensorXplus, (long)item_.getStandbyPositionSensorXplus());
        Assert.assertEquals((long)unclampedStatusSensor, (long)item_.getUnclampedStatusSensor());
        Assert.assertEquals((long)underClampedStatusSensor, (long)item_.getUnderClampedStatusSensor());
    }

    @Test
    public void sendReceiveFcs_Canbus0_AcTruckXminusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 648;
        boolean brakeActivated = false;
        int current = 524;
        int errorHistoryNB = 463;
        String errorRegister = "m";
        int followingError = 390;
        boolean inError = true;
        int lastErrorCode = 896;
        String lastErrorName = "b";
        String mode = "";
        int position = 974;
        long profileAcceleration = 881L;
        long profileDeceleration = 373L;
        long profileVelocity = 622L;
        String state = "m";
        int velocity = 195;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_AcTruckXminusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_AcTruckXminusController_TrendingTelemetry));
        Fcs_Canbus0_AcTruckXminusController_TrendingTelemetry item_ = (Fcs_Canbus0_AcTruckXminusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_AcTruckXplusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 654;
        boolean brakeActivated = false;
        int current = 969;
        int errorHistoryNB = 976;
        String errorRegister = "c";
        int followingError = 117;
        boolean inError = false;
        int lastErrorCode = 781;
        String lastErrorName = "y";
        String mode = "";
        int position = 193;
        long profileAcceleration = 500L;
        long profileDeceleration = 716L;
        long profileVelocity = 894L;
        String state = "";
        int velocity = 781;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_AcTruckXplusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_AcTruckXplusController_TrendingTelemetry));
        Fcs_Canbus0_AcTruckXplusController_TrendingTelemetry item_ = (Fcs_Canbus0_AcTruckXplusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_Accelerobf_TrendingTelemetry() throws Exception {
        double accelerationX = 0.4662118f;
        double accelerationY = 0.546428918838501;
        double accelerationZ = 0.5525586009025574;
        double airmass = 0.03247493505477905;
        double angularVelocityX = 0.5309037566184998;
        double angularVelocityY = 0.273589551448822;
        double angularVelocityZ = 0.4411134123802185;
        double azimut = 0.8271845579147339;
        double elevation = 0.05759161710739136;
        int errorHistoryNB = 217;
        String errorRegister = "o";
        double gravity = 0.8874979615211487;
        boolean inError = false;
        int lastErrorCode = 932;
        String lastErrorName = "i";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_Accelerobf_TrendingTelemetry(accelerationX, accelerationY, accelerationZ, airmass, angularVelocityX, angularVelocityY, angularVelocityZ, azimut, elevation, errorHistoryNB, errorRegister, gravity, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_Accelerobf_TrendingTelemetry));
        Fcs_Canbus0_Accelerobf_TrendingTelemetry item_ = (Fcs_Canbus0_Accelerobf_TrendingTelemetry)item;
        Assert.assertEquals((double)accelerationX, (double)item_.getAccelerationX(), (double)1.0E-6f);
        Assert.assertEquals((double)accelerationY, (double)item_.getAccelerationY(), (double)1.0E-6f);
        Assert.assertEquals((double)accelerationZ, (double)item_.getAccelerationZ(), (double)1.0E-6f);
        Assert.assertEquals((double)airmass, (double)item_.getAirmass(), (double)1.0E-6f);
        Assert.assertEquals((double)angularVelocityX, (double)item_.getAngularVelocityX(), (double)1.0E-6f);
        Assert.assertEquals((double)angularVelocityY, (double)item_.getAngularVelocityY(), (double)1.0E-6f);
        Assert.assertEquals((double)angularVelocityZ, (double)item_.getAngularVelocityZ(), (double)1.0E-6f);
        Assert.assertEquals((double)azimut, (double)item_.getAzimut(), (double)1.0E-6f);
        Assert.assertEquals((double)elevation, (double)item_.getElevation(), (double)1.0E-6f);
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((double)gravity, (double)item_.getGravity(), (double)1.0E-6f);
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus0_Ai814_TrendingTelemetry() throws Exception {
        int errorHistoryNB = 851;
        String errorRegister = "";
        boolean inError = true;
        int lastErrorCode = 363;
        String lastErrorName = "p";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_Ai814_TrendingTelemetry(errorHistoryNB, errorRegister, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_Ai814_TrendingTelemetry));
        Fcs_Canbus0_Ai814_TrendingTelemetry item_ = (Fcs_Canbus0_Ai814_TrendingTelemetry)item;
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus0_BrakeSystemGateway_TrendingTelemetry() throws Exception {
        int acAF0b = 346;
        int acAF0s = 2;
        int acAF1b = 882;
        int acAF1s = 880;
        int acAF3b = 176;
        int acAF3s = 847;
        int acAP2b = 247;
        int acAP2s = 160;
        int carouselHoldingFilterSensor0 = 321;
        int carouselHoldingFilterSensor1 = 916;
        int carouselStoppedAtStandby = 988;
        int carouselStoppedAtStandbyC = 586;
        int carousel_CF0 = 758;
        int carousel_CF0_C = 481;
        int carousel_CF1 = 792;
        int carousel_CF1_C = 94;
        int clampedStatusSensor = 40;
        int closeSensorBLatchXminus = 326;
        int closeSensorBLatchXplus = 137;
        int closeSensorLatchXminus = 945;
        int closeSensorLatchXplus = 215;
        int engineeringKey = 60;
        int engineeringkey_C = 678;
        int filterEngagedSensorBLatchXminus = 864;
        int filterEngagedSensorBLatchXplus = 110;
        int filterEngagedSensorLatchXminus = 624;
        int filterEngagedSensorLatchXplus = 19;
        int filterIDSensor0 = 799;
        int filterIDSensor1 = 404;
        int filterIDSensor2 = 813;
        int filterIDSensor3 = 278;
        int filterIDSensor4 = 524;
        int filterIDSensor5 = 102;
        int forceSensor0 = 29;
        int forceSensor1 = 214;
        int handoffPositionSensorBXminus = 292;
        int handoffPositionSensorBXplus = 767;
        int handoffPositionSensorXminus = 444;
        int handoffPositionSensorXplus = 331;
        double inclinometerXminus = 0.441038f;
        double inclinometerXplus = 0.7274959087371826;
        int keyEng = 561;
        int keyEngb = 432;
        int keyLock = 496;
        int keyLockb = 421;
        int lps_0 = 129;
        int lps_1 = 813;
        int lrh_0 = 643;
        int lrh_1 = 991;
        int loaderCarrierRelayStatus = 266;
        int loaderChainPresenceSensor = 753;
        int loaderCloseSensor1 = 831;
        int loaderCloseSensor2 = 501;
        int loaderCloseSensor3 = 993;
        int loaderCloseSensor4 = 581;
        int loaderConnectedSensor = 212;
        int loaderConnectedSensorC = 814;
        int loaderDefaultStatus = 784;
        int loaderEngagedPositionSensor0 = 420;
        int loaderEngagedPositionSensor1 = 596;
        int loaderFilterDistanceSensor = 519;
        int loaderFilterGoodPositionStatus = 568;
        int loaderFilterPresenceSensor0 = 830;
        int loaderFilterPresenceSensor1 = 650;
        int loaderHandoffPositionSensor0 = 905;
        int loaderHandoffPositionSensor1 = 38;
        int loaderHoldingFilterSensor0 = 828;
        int loaderHoldingFilterSensor1 = 529;
        int loaderHooksRelayStatus = 134;
        int loaderOnCameraSensor0 = 845;
        int loaderOnCameraSensor1 = 221;
        int loaderOpenSensor1 = 278;
        int loaderOpenSensor2 = 482;
        int loaderOpenSensor3 = 585;
        int loaderOpenSensor4 = 127;
        int loaderStoragePositionSensor0 = 435;
        int loaderStoragePositionSensor1 = 614;
        int loader_LFD = 27;
        int loader_LFS = 290;
        int lockOut = 528;
        int lockOutShunt = 127;
        int lockout_C = 990;
        int lpmLatchesStatus = 54;
        int lpmLinearRail1Status = 152;
        int lpmLinearRail2Status = 677;
        int lpmOnlineClampsStatus = 604;
        int out_AF0 = 220;
        int out_AF0_C = 685;
        int out_AF1 = 968;
        int out_AF1_C = 5;
        int out_AF3 = 618;
        int out_AF3_C = 513;
        int out_AIN = 261;
        int out_AOL = 982;
        int out_AP1 = 696;
        int out_AP1_C = 859;
        int out_AP2 = 478;
        int out_AP2_C = 122;
        int out_AP3 = 56;
        int out_AP3_C = 418;
        int onlineClampXminusCloseSensor = 432;
        int onlineClampXminusCloseSensorC = 440;
        int onlineClampXminusOpenSensor = 307;
        int onlineClampXminusOpenSensorC = 153;
        int onlineClampXplusCloseSensor = 478;
        int onlineClampXplusCloseSensorC = 800;
        int onlineClampXplusOpenSensor = 29;
        int onlineClampXplusOpenSensorC = 495;
        int onlineClampYminusCloseSensor = 755;
        int onlineClampYminusCloseSensorC = 963;
        int onlineClampYminusOpenSensor = 346;
        int onlineClampYminusOpenSensorC = 930;
        int onlinePositionSensorBXminus = 468;
        int onlinePositionSensorBXplus = 86;
        int onlinePositionSensorXminus = 219;
        int onlinePositionSensorXplus = 919;
        int openSensorBLatchXminus = 899;
        int openSensorBLatchXplus = 202;
        int openSensorLatchXminus = 113;
        int openSensorLatchXplus = 384;
        int overClampedStatusSensor = 880;
        int presenceLoader = 740;
        int presenceloader_C = 370;
        int standbyPositionSensorBXminus = 210;
        int standbyPositionSensorBXplus = 994;
        int standbyPositionSensorXminus = 852;
        int standbyPositionSensorXplus = 592;
        int unclampedStatusSensor = 546;
        int underClampedStatusSensor = 979;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_BrakeSystemGateway_TrendingTelemetry(acAF0b, acAF0s, acAF1b, acAF1s, acAF3b, acAF3s, acAP2b, acAP2s, carouselHoldingFilterSensor0, carouselHoldingFilterSensor1, carouselStoppedAtStandby, carouselStoppedAtStandbyC, carousel_CF0, carousel_CF0_C, carousel_CF1, carousel_CF1_C, clampedStatusSensor, closeSensorBLatchXminus, closeSensorBLatchXplus, closeSensorLatchXminus, closeSensorLatchXplus, engineeringKey, engineeringkey_C, filterEngagedSensorBLatchXminus, filterEngagedSensorBLatchXplus, filterEngagedSensorLatchXminus, filterEngagedSensorLatchXplus, filterIDSensor0, filterIDSensor1, filterIDSensor2, filterIDSensor3, filterIDSensor4, filterIDSensor5, forceSensor0, forceSensor1, handoffPositionSensorBXminus, handoffPositionSensorBXplus, handoffPositionSensorXminus, handoffPositionSensorXplus, inclinometerXminus, inclinometerXplus, keyEng, keyEngb, keyLock, keyLockb, lps_0, lps_1, lrh_0, lrh_1, loaderCarrierRelayStatus, loaderChainPresenceSensor, loaderCloseSensor1, loaderCloseSensor2, loaderCloseSensor3, loaderCloseSensor4, loaderConnectedSensor, loaderConnectedSensorC, loaderDefaultStatus, loaderEngagedPositionSensor0, loaderEngagedPositionSensor1, loaderFilterDistanceSensor, loaderFilterGoodPositionStatus, loaderFilterPresenceSensor0, loaderFilterPresenceSensor1, loaderHandoffPositionSensor0, loaderHandoffPositionSensor1, loaderHoldingFilterSensor0, loaderHoldingFilterSensor1, loaderHooksRelayStatus, loaderOnCameraSensor0, loaderOnCameraSensor1, loaderOpenSensor1, loaderOpenSensor2, loaderOpenSensor3, loaderOpenSensor4, loaderStoragePositionSensor0, loaderStoragePositionSensor1, loader_LFD, loader_LFS, lockOut, lockOutShunt, lockout_C, lpmLatchesStatus, lpmLinearRail1Status, lpmLinearRail2Status, lpmOnlineClampsStatus, out_AF0, out_AF0_C, out_AF1, out_AF1_C, out_AF3, out_AF3_C, out_AIN, out_AOL, out_AP1, out_AP1_C, out_AP2, out_AP2_C, out_AP3, out_AP3_C, onlineClampXminusCloseSensor, onlineClampXminusCloseSensorC, onlineClampXminusOpenSensor, onlineClampXminusOpenSensorC, onlineClampXplusCloseSensor, onlineClampXplusCloseSensorC, onlineClampXplusOpenSensor, onlineClampXplusOpenSensorC, onlineClampYminusCloseSensor, onlineClampYminusCloseSensorC, onlineClampYminusOpenSensor, onlineClampYminusOpenSensorC, onlinePositionSensorBXminus, onlinePositionSensorBXplus, onlinePositionSensorXminus, onlinePositionSensorXplus, openSensorBLatchXminus, openSensorBLatchXplus, openSensorLatchXminus, openSensorLatchXplus, overClampedStatusSensor, presenceLoader, presenceloader_C, standbyPositionSensorBXminus, standbyPositionSensorBXplus, standbyPositionSensorXminus, standbyPositionSensorXplus, unclampedStatusSensor, underClampedStatusSensor));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_BrakeSystemGateway_TrendingTelemetry));
        Fcs_Canbus0_BrakeSystemGateway_TrendingTelemetry item_ = (Fcs_Canbus0_BrakeSystemGateway_TrendingTelemetry)item;
        Assert.assertEquals((long)acAF0b, (long)item_.getAcAF0b());
        Assert.assertEquals((long)acAF0s, (long)item_.getAcAF0s());
        Assert.assertEquals((long)acAF1b, (long)item_.getAcAF1b());
        Assert.assertEquals((long)acAF1s, (long)item_.getAcAF1s());
        Assert.assertEquals((long)acAF3b, (long)item_.getAcAF3b());
        Assert.assertEquals((long)acAF3s, (long)item_.getAcAF3s());
        Assert.assertEquals((long)acAP2b, (long)item_.getAcAP2b());
        Assert.assertEquals((long)acAP2s, (long)item_.getAcAP2s());
        Assert.assertEquals((long)carouselHoldingFilterSensor0, (long)item_.getCarouselHoldingFilterSensor0());
        Assert.assertEquals((long)carouselHoldingFilterSensor1, (long)item_.getCarouselHoldingFilterSensor1());
        Assert.assertEquals((long)carouselStoppedAtStandby, (long)item_.getCarouselStoppedAtStandby());
        Assert.assertEquals((long)carouselStoppedAtStandbyC, (long)item_.getCarouselStoppedAtStandbyC());
        Assert.assertEquals((long)carousel_CF0, (long)item_.getCarousel_CF0());
        Assert.assertEquals((long)carousel_CF0_C, (long)item_.getCarousel_CF0_C());
        Assert.assertEquals((long)carousel_CF1, (long)item_.getCarousel_CF1());
        Assert.assertEquals((long)carousel_CF1_C, (long)item_.getCarousel_CF1_C());
        Assert.assertEquals((long)clampedStatusSensor, (long)item_.getClampedStatusSensor());
        Assert.assertEquals((long)closeSensorBLatchXminus, (long)item_.getCloseSensorBLatchXminus());
        Assert.assertEquals((long)closeSensorBLatchXplus, (long)item_.getCloseSensorBLatchXplus());
        Assert.assertEquals((long)closeSensorLatchXminus, (long)item_.getCloseSensorLatchXminus());
        Assert.assertEquals((long)closeSensorLatchXplus, (long)item_.getCloseSensorLatchXplus());
        Assert.assertEquals((long)engineeringKey, (long)item_.getEngineeringKey());
        Assert.assertEquals((long)engineeringkey_C, (long)item_.getEngineeringkey_C());
        Assert.assertEquals((long)filterEngagedSensorBLatchXminus, (long)item_.getFilterEngagedSensorBLatchXminus());
        Assert.assertEquals((long)filterEngagedSensorBLatchXplus, (long)item_.getFilterEngagedSensorBLatchXplus());
        Assert.assertEquals((long)filterEngagedSensorLatchXminus, (long)item_.getFilterEngagedSensorLatchXminus());
        Assert.assertEquals((long)filterEngagedSensorLatchXplus, (long)item_.getFilterEngagedSensorLatchXplus());
        Assert.assertEquals((long)filterIDSensor0, (long)item_.getFilterIDSensor0());
        Assert.assertEquals((long)filterIDSensor1, (long)item_.getFilterIDSensor1());
        Assert.assertEquals((long)filterIDSensor2, (long)item_.getFilterIDSensor2());
        Assert.assertEquals((long)filterIDSensor3, (long)item_.getFilterIDSensor3());
        Assert.assertEquals((long)filterIDSensor4, (long)item_.getFilterIDSensor4());
        Assert.assertEquals((long)filterIDSensor5, (long)item_.getFilterIDSensor5());
        Assert.assertEquals((long)forceSensor0, (long)item_.getForceSensor0());
        Assert.assertEquals((long)forceSensor1, (long)item_.getForceSensor1());
        Assert.assertEquals((long)handoffPositionSensorBXminus, (long)item_.getHandoffPositionSensorBXminus());
        Assert.assertEquals((long)handoffPositionSensorBXplus, (long)item_.getHandoffPositionSensorBXplus());
        Assert.assertEquals((long)handoffPositionSensorXminus, (long)item_.getHandoffPositionSensorXminus());
        Assert.assertEquals((long)handoffPositionSensorXplus, (long)item_.getHandoffPositionSensorXplus());
        Assert.assertEquals((double)inclinometerXminus, (double)item_.getInclinometerXminus(), (double)1.0E-6f);
        Assert.assertEquals((double)inclinometerXplus, (double)item_.getInclinometerXplus(), (double)1.0E-6f);
        Assert.assertEquals((long)keyEng, (long)item_.getKeyEng());
        Assert.assertEquals((long)keyEngb, (long)item_.getKeyEngb());
        Assert.assertEquals((long)keyLock, (long)item_.getKeyLock());
        Assert.assertEquals((long)keyLockb, (long)item_.getKeyLockb());
        Assert.assertEquals((long)lps_0, (long)item_.getLps_0());
        Assert.assertEquals((long)lps_1, (long)item_.getLps_1());
        Assert.assertEquals((long)lrh_0, (long)item_.getLrh_0());
        Assert.assertEquals((long)lrh_1, (long)item_.getLrh_1());
        Assert.assertEquals((long)loaderCarrierRelayStatus, (long)item_.getLoaderCarrierRelayStatus());
        Assert.assertEquals((long)loaderChainPresenceSensor, (long)item_.getLoaderChainPresenceSensor());
        Assert.assertEquals((long)loaderCloseSensor1, (long)item_.getLoaderCloseSensor1());
        Assert.assertEquals((long)loaderCloseSensor2, (long)item_.getLoaderCloseSensor2());
        Assert.assertEquals((long)loaderCloseSensor3, (long)item_.getLoaderCloseSensor3());
        Assert.assertEquals((long)loaderCloseSensor4, (long)item_.getLoaderCloseSensor4());
        Assert.assertEquals((long)loaderConnectedSensor, (long)item_.getLoaderConnectedSensor());
        Assert.assertEquals((long)loaderConnectedSensorC, (long)item_.getLoaderConnectedSensorC());
        Assert.assertEquals((long)loaderDefaultStatus, (long)item_.getLoaderDefaultStatus());
        Assert.assertEquals((long)loaderEngagedPositionSensor0, (long)item_.getLoaderEngagedPositionSensor0());
        Assert.assertEquals((long)loaderEngagedPositionSensor1, (long)item_.getLoaderEngagedPositionSensor1());
        Assert.assertEquals((long)loaderFilterDistanceSensor, (long)item_.getLoaderFilterDistanceSensor());
        Assert.assertEquals((long)loaderFilterGoodPositionStatus, (long)item_.getLoaderFilterGoodPositionStatus());
        Assert.assertEquals((long)loaderFilterPresenceSensor0, (long)item_.getLoaderFilterPresenceSensor0());
        Assert.assertEquals((long)loaderFilterPresenceSensor1, (long)item_.getLoaderFilterPresenceSensor1());
        Assert.assertEquals((long)loaderHandoffPositionSensor0, (long)item_.getLoaderHandoffPositionSensor0());
        Assert.assertEquals((long)loaderHandoffPositionSensor1, (long)item_.getLoaderHandoffPositionSensor1());
        Assert.assertEquals((long)loaderHoldingFilterSensor0, (long)item_.getLoaderHoldingFilterSensor0());
        Assert.assertEquals((long)loaderHoldingFilterSensor1, (long)item_.getLoaderHoldingFilterSensor1());
        Assert.assertEquals((long)loaderHooksRelayStatus, (long)item_.getLoaderHooksRelayStatus());
        Assert.assertEquals((long)loaderOnCameraSensor0, (long)item_.getLoaderOnCameraSensor0());
        Assert.assertEquals((long)loaderOnCameraSensor1, (long)item_.getLoaderOnCameraSensor1());
        Assert.assertEquals((long)loaderOpenSensor1, (long)item_.getLoaderOpenSensor1());
        Assert.assertEquals((long)loaderOpenSensor2, (long)item_.getLoaderOpenSensor2());
        Assert.assertEquals((long)loaderOpenSensor3, (long)item_.getLoaderOpenSensor3());
        Assert.assertEquals((long)loaderOpenSensor4, (long)item_.getLoaderOpenSensor4());
        Assert.assertEquals((long)loaderStoragePositionSensor0, (long)item_.getLoaderStoragePositionSensor0());
        Assert.assertEquals((long)loaderStoragePositionSensor1, (long)item_.getLoaderStoragePositionSensor1());
        Assert.assertEquals((long)loader_LFD, (long)item_.getLoader_LFD());
        Assert.assertEquals((long)loader_LFS, (long)item_.getLoader_LFS());
        Assert.assertEquals((long)lockOut, (long)item_.getLockOut());
        Assert.assertEquals((long)lockOutShunt, (long)item_.getLockOutShunt());
        Assert.assertEquals((long)lockout_C, (long)item_.getLockout_C());
        Assert.assertEquals((long)lpmLatchesStatus, (long)item_.getLpmLatchesStatus());
        Assert.assertEquals((long)lpmLinearRail1Status, (long)item_.getLpmLinearRail1Status());
        Assert.assertEquals((long)lpmLinearRail2Status, (long)item_.getLpmLinearRail2Status());
        Assert.assertEquals((long)lpmOnlineClampsStatus, (long)item_.getLpmOnlineClampsStatus());
        Assert.assertEquals((long)out_AF0, (long)item_.getOut_AF0());
        Assert.assertEquals((long)out_AF0_C, (long)item_.getOut_AF0_C());
        Assert.assertEquals((long)out_AF1, (long)item_.getOut_AF1());
        Assert.assertEquals((long)out_AF1_C, (long)item_.getOut_AF1_C());
        Assert.assertEquals((long)out_AF3, (long)item_.getOut_AF3());
        Assert.assertEquals((long)out_AF3_C, (long)item_.getOut_AF3_C());
        Assert.assertEquals((long)out_AIN, (long)item_.getOut_AIN());
        Assert.assertEquals((long)out_AOL, (long)item_.getOut_AOL());
        Assert.assertEquals((long)out_AP1, (long)item_.getOut_AP1());
        Assert.assertEquals((long)out_AP1_C, (long)item_.getOut_AP1_C());
        Assert.assertEquals((long)out_AP2, (long)item_.getOut_AP2());
        Assert.assertEquals((long)out_AP2_C, (long)item_.getOut_AP2_C());
        Assert.assertEquals((long)out_AP3, (long)item_.getOut_AP3());
        Assert.assertEquals((long)out_AP3_C, (long)item_.getOut_AP3_C());
        Assert.assertEquals((long)onlineClampXminusCloseSensor, (long)item_.getOnlineClampXminusCloseSensor());
        Assert.assertEquals((long)onlineClampXminusCloseSensorC, (long)item_.getOnlineClampXminusCloseSensorC());
        Assert.assertEquals((long)onlineClampXminusOpenSensor, (long)item_.getOnlineClampXminusOpenSensor());
        Assert.assertEquals((long)onlineClampXminusOpenSensorC, (long)item_.getOnlineClampXminusOpenSensorC());
        Assert.assertEquals((long)onlineClampXplusCloseSensor, (long)item_.getOnlineClampXplusCloseSensor());
        Assert.assertEquals((long)onlineClampXplusCloseSensorC, (long)item_.getOnlineClampXplusCloseSensorC());
        Assert.assertEquals((long)onlineClampXplusOpenSensor, (long)item_.getOnlineClampXplusOpenSensor());
        Assert.assertEquals((long)onlineClampXplusOpenSensorC, (long)item_.getOnlineClampXplusOpenSensorC());
        Assert.assertEquals((long)onlineClampYminusCloseSensor, (long)item_.getOnlineClampYminusCloseSensor());
        Assert.assertEquals((long)onlineClampYminusCloseSensorC, (long)item_.getOnlineClampYminusCloseSensorC());
        Assert.assertEquals((long)onlineClampYminusOpenSensor, (long)item_.getOnlineClampYminusOpenSensor());
        Assert.assertEquals((long)onlineClampYminusOpenSensorC, (long)item_.getOnlineClampYminusOpenSensorC());
        Assert.assertEquals((long)onlinePositionSensorBXminus, (long)item_.getOnlinePositionSensorBXminus());
        Assert.assertEquals((long)onlinePositionSensorBXplus, (long)item_.getOnlinePositionSensorBXplus());
        Assert.assertEquals((long)onlinePositionSensorXminus, (long)item_.getOnlinePositionSensorXminus());
        Assert.assertEquals((long)onlinePositionSensorXplus, (long)item_.getOnlinePositionSensorXplus());
        Assert.assertEquals((long)openSensorBLatchXminus, (long)item_.getOpenSensorBLatchXminus());
        Assert.assertEquals((long)openSensorBLatchXplus, (long)item_.getOpenSensorBLatchXplus());
        Assert.assertEquals((long)openSensorLatchXminus, (long)item_.getOpenSensorLatchXminus());
        Assert.assertEquals((long)openSensorLatchXplus, (long)item_.getOpenSensorLatchXplus());
        Assert.assertEquals((long)overClampedStatusSensor, (long)item_.getOverClampedStatusSensor());
        Assert.assertEquals((long)presenceLoader, (long)item_.getPresenceLoader());
        Assert.assertEquals((long)presenceloader_C, (long)item_.getPresenceloader_C());
        Assert.assertEquals((long)standbyPositionSensorBXminus, (long)item_.getStandbyPositionSensorBXminus());
        Assert.assertEquals((long)standbyPositionSensorBXplus, (long)item_.getStandbyPositionSensorBXplus());
        Assert.assertEquals((long)standbyPositionSensorXminus, (long)item_.getStandbyPositionSensorXminus());
        Assert.assertEquals((long)standbyPositionSensorXplus, (long)item_.getStandbyPositionSensorXplus());
        Assert.assertEquals((long)unclampedStatusSensor, (long)item_.getUnclampedStatusSensor());
        Assert.assertEquals((long)underClampedStatusSensor, (long)item_.getUnderClampedStatusSensor());
    }

    @Test
    public void sendReceiveFcs_Canbus0_CarouselController_TrendingTelemetry() throws Exception {
        int averageCurrent = 252;
        boolean brakeActivated = false;
        int current = 788;
        int errorHistoryNB = 386;
        String errorRegister = "v";
        int followingError = 520;
        boolean inError = false;
        int lastErrorCode = 419;
        String lastErrorName = "";
        String mode = "";
        int position = 16;
        long profileAcceleration = 780L;
        long profileDeceleration = 899L;
        long profileVelocity = 563L;
        String state = "x";
        int velocity = 548;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_CarouselController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_CarouselController_TrendingTelemetry));
        Fcs_Canbus0_CarouselController_TrendingTelemetry item_ = (Fcs_Canbus0_CarouselController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_ClampXminusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 609;
        boolean brakeActivated = true;
        int current = 767;
        int errorHistoryNB = 254;
        String errorRegister = "";
        int followingError = 626;
        boolean inError = false;
        int lastErrorCode = 991;
        String lastErrorName = "j";
        String mode = "w";
        int position = 75;
        long profileAcceleration = 963L;
        long profileDeceleration = 936L;
        long profileVelocity = 899L;
        String state = "t";
        int velocity = 607;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_ClampXminusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_ClampXminusController_TrendingTelemetry));
        Fcs_Canbus0_ClampXminusController_TrendingTelemetry item_ = (Fcs_Canbus0_ClampXminusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_ClampXplusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 806;
        boolean brakeActivated = false;
        int current = 314;
        int errorHistoryNB = 181;
        String errorRegister = "";
        int followingError = 165;
        boolean inError = false;
        int lastErrorCode = 756;
        String lastErrorName = "";
        String mode = "";
        int position = 813;
        long profileAcceleration = 132L;
        long profileDeceleration = 854L;
        long profileVelocity = 273L;
        String state = "";
        int velocity = 799;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_ClampXplusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_ClampXplusController_TrendingTelemetry));
        Fcs_Canbus0_ClampXplusController_TrendingTelemetry item_ = (Fcs_Canbus0_ClampXplusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_Hyttc580_TrendingTelemetry() throws Exception {
        long pdo1 = 912L;
        long pdo2 = 145L;
        long pdo4 = 977L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_Hyttc580_TrendingTelemetry(pdo1, pdo2, pdo4));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_Hyttc580_TrendingTelemetry));
        Fcs_Canbus0_Hyttc580_TrendingTelemetry item_ = (Fcs_Canbus0_Hyttc580_TrendingTelemetry)item;
        Assert.assertEquals((long)pdo1, (long)item_.getPdo1());
        Assert.assertEquals((long)pdo2, (long)item_.getPdo2());
        Assert.assertEquals((long)pdo4, (long)item_.getPdo4());
    }

    @Test
    public void sendReceiveFcs_Canbus0_LatchXminusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 869;
        boolean brakeActivated = false;
        int current = 63;
        int errorHistoryNB = 663;
        String errorRegister = "a";
        int followingError = 355;
        boolean inError = true;
        int lastErrorCode = 851;
        String lastErrorName = "";
        String mode = "";
        int position = 252;
        long profileAcceleration = 76L;
        long profileDeceleration = 244L;
        long profileVelocity = 847L;
        String state = "";
        int velocity = 386;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_LatchXminusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_LatchXminusController_TrendingTelemetry));
        Fcs_Canbus0_LatchXminusController_TrendingTelemetry item_ = (Fcs_Canbus0_LatchXminusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_LatchXplusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 757;
        boolean brakeActivated = true;
        int current = 540;
        int errorHistoryNB = 173;
        String errorRegister = "j";
        int followingError = 561;
        boolean inError = true;
        int lastErrorCode = 827;
        String lastErrorName = "l";
        String mode = "u";
        int position = 935;
        long profileAcceleration = 491L;
        long profileDeceleration = 976L;
        long profileVelocity = 592L;
        String state = "";
        int velocity = 23;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_LatchXplusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_LatchXplusController_TrendingTelemetry));
        Fcs_Canbus0_LatchXplusController_TrendingTelemetry item_ = (Fcs_Canbus0_LatchXplusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_OnlineClampXminusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 77;
        boolean brakeActivated = false;
        int current = 292;
        int errorHistoryNB = 756;
        String errorRegister = "u";
        int followingError = 150;
        boolean inError = true;
        int lastErrorCode = 322;
        String lastErrorName = "";
        String mode = "";
        int position = 271;
        long profileAcceleration = 247L;
        long profileDeceleration = 248L;
        long profileVelocity = 786L;
        String state = "";
        int velocity = 612;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_OnlineClampXminusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_OnlineClampXminusController_TrendingTelemetry));
        Fcs_Canbus0_OnlineClampXminusController_TrendingTelemetry item_ = (Fcs_Canbus0_OnlineClampXminusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_OnlineClampXplusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 91;
        boolean brakeActivated = true;
        int current = 50;
        int errorHistoryNB = 867;
        String errorRegister = "u";
        int followingError = 160;
        boolean inError = false;
        int lastErrorCode = 906;
        String lastErrorName = "";
        String mode = "";
        int position = 116;
        long profileAcceleration = 69L;
        long profileDeceleration = 51L;
        long profileVelocity = 733L;
        String state = "t";
        int velocity = 604;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_OnlineClampXplusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_OnlineClampXplusController_TrendingTelemetry));
        Fcs_Canbus0_OnlineClampXplusController_TrendingTelemetry item_ = (Fcs_Canbus0_OnlineClampXplusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_OnlineClampYminusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 389;
        boolean brakeActivated = false;
        int current = 360;
        int errorHistoryNB = 147;
        String errorRegister = "c";
        int followingError = 787;
        boolean inError = true;
        int lastErrorCode = 572;
        String lastErrorName = "l";
        String mode = "i";
        int position = 141;
        long profileAcceleration = 931L;
        long profileDeceleration = 827L;
        long profileVelocity = 276L;
        String state = "";
        int velocity = 44;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_OnlineClampYminusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_OnlineClampYminusController_TrendingTelemetry));
        Fcs_Canbus0_OnlineClampYminusController_TrendingTelemetry item_ = (Fcs_Canbus0_OnlineClampYminusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_OnlineStrainGauge_TrendingTelemetry() throws Exception {
        int errorHistoryNB = 643;
        String errorRegister = "";
        boolean inError = false;
        int lastErrorCode = 402;
        String lastErrorName = "h";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_OnlineStrainGauge_TrendingTelemetry(errorHistoryNB, errorRegister, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_OnlineStrainGauge_TrendingTelemetry));
        Fcs_Canbus0_OnlineStrainGauge_TrendingTelemetry item_ = (Fcs_Canbus0_OnlineStrainGauge_TrendingTelemetry)item;
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus0_ProximitySensorsDevice_TrendingTelemetry() throws Exception {
        int errorHistoryNB = 949;
        String errorRegister = "i";
        boolean inError = true;
        int lastErrorCode = 245;
        String lastErrorName = "s";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_ProximitySensorsDevice_TrendingTelemetry(errorHistoryNB, errorRegister, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_ProximitySensorsDevice_TrendingTelemetry));
        Fcs_Canbus0_ProximitySensorsDevice_TrendingTelemetry item_ = (Fcs_Canbus0_ProximitySensorsDevice_TrendingTelemetry)item;
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus0_Pt100_TrendingTelemetry() throws Exception {
        int errorHistoryNB = 985;
        String errorRegister = "";
        boolean inError = true;
        int lastErrorCode = 844;
        String lastErrorName = "i";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_Pt100_TrendingTelemetry(errorHistoryNB, errorRegister, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_Pt100_TrendingTelemetry));
        Fcs_Canbus0_Pt100_TrendingTelemetry item_ = (Fcs_Canbus0_Pt100_TrendingTelemetry)item;
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus0_TempSensorsDevice1_TrendingTelemetry() throws Exception {
        int errorHistoryNB = 869;
        String errorRegister = "k";
        boolean inError = false;
        int lastErrorCode = 766;
        String lastErrorName = "e";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_TempSensorsDevice1_TrendingTelemetry(errorHistoryNB, errorRegister, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_TempSensorsDevice1_TrendingTelemetry));
        Fcs_Canbus0_TempSensorsDevice1_TrendingTelemetry item_ = (Fcs_Canbus0_TempSensorsDevice1_TrendingTelemetry)item;
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus0_TempSensorsDevice2_TrendingTelemetry() throws Exception {
        int errorHistoryNB = 812;
        String errorRegister = "";
        boolean inError = true;
        int lastErrorCode = 339;
        String lastErrorName = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_TempSensorsDevice2_TrendingTelemetry(errorHistoryNB, errorRegister, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_TempSensorsDevice2_TrendingTelemetry));
        Fcs_Canbus0_TempSensorsDevice2_TrendingTelemetry item_ = (Fcs_Canbus0_TempSensorsDevice2_TrendingTelemetry)item;
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus1_CarrierController_TrendingTelemetry() throws Exception {
        int averageCurrent = 958;
        boolean brakeActivated = false;
        int current = 640;
        int errorHistoryNB = 165;
        String errorRegister = "";
        int followingError = 600;
        boolean inError = false;
        int lastErrorCode = 80;
        String lastErrorName = "";
        String mode = "";
        int position = 182;
        long profileAcceleration = 254L;
        long profileDeceleration = 330L;
        long profileVelocity = 350L;
        String state = "k";
        int velocity = 494;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus1_CarrierController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus1_CarrierController_TrendingTelemetry));
        Fcs_Canbus1_CarrierController_TrendingTelemetry item_ = (Fcs_Canbus1_CarrierController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus1_HooksController_TrendingTelemetry() throws Exception {
        int averageCurrent = 766;
        boolean brakeActivated = true;
        int current = 417;
        int errorHistoryNB = 390;
        String errorRegister = "m";
        int followingError = 282;
        boolean inError = true;
        int lastErrorCode = 614;
        String lastErrorName = "";
        String mode = "v";
        int position = 240;
        long profileAcceleration = 523L;
        long profileDeceleration = 843L;
        long profileVelocity = 421L;
        String state = "b";
        int velocity = 199;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus1_HooksController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus1_HooksController_TrendingTelemetry));
        Fcs_Canbus1_HooksController_TrendingTelemetry item_ = (Fcs_Canbus1_HooksController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus1_LoaderPlutoGateway_TrendingTelemetry() throws Exception {
        int acAF0b = 565;
        int acAF0s = 787;
        int acAF1b = 255;
        int acAF1s = 865;
        int acAF3b = 683;
        int acAF3s = 639;
        int acAP2b = 153;
        int acAP2s = 12;
        int carouselHoldingFilterSensor0 = 491;
        int carouselHoldingFilterSensor1 = 856;
        int carouselStoppedAtStandby = 315;
        int carouselStoppedAtStandbyC = 181;
        int carousel_CF0 = 717;
        int carousel_CF0_C = 556;
        int carousel_CF1 = 194;
        int carousel_CF1_C = 50;
        int clampedStatusSensor = 570;
        int closeSensorBLatchXminus = 175;
        int closeSensorBLatchXplus = 857;
        int closeSensorLatchXminus = 501;
        int closeSensorLatchXplus = 472;
        int engineeringKey = 488;
        int engineeringkey_C = 76;
        int filterEngagedSensorBLatchXminus = 916;
        int filterEngagedSensorBLatchXplus = 152;
        int filterEngagedSensorLatchXminus = 395;
        int filterEngagedSensorLatchXplus = 368;
        int filterIDSensor0 = 695;
        int filterIDSensor1 = 21;
        int filterIDSensor2 = 920;
        int filterIDSensor3 = 678;
        int filterIDSensor4 = 525;
        int filterIDSensor5 = 791;
        int forceSensor0 = 639;
        int forceSensor1 = 47;
        int handoffPositionSensorBXminus = 98;
        int handoffPositionSensorBXplus = 781;
        int handoffPositionSensorXminus = 365;
        int handoffPositionSensorXplus = 545;
        double inclinometerXminus = 0.06735879182815552;
        double inclinometerXplus = 0.1490703821182251;
        int keyEng = 464;
        int keyEngb = 536;
        int keyLock = 794;
        int keyLockb = 870;
        int lps_0 = 228;
        int lps_1 = 392;
        int lrh_0 = 945;
        int lrh_1 = 508;
        int loaderCarrierRelayStatus = 271;
        int loaderChainPresenceSensor = 342;
        int loaderCloseSensor1 = 515;
        int loaderCloseSensor2 = 732;
        int loaderCloseSensor3 = 207;
        int loaderCloseSensor4 = 334;
        int loaderConnectedSensor = 285;
        int loaderConnectedSensorC = 599;
        int loaderDefaultStatus = 454;
        int loaderEngagedPositionSensor0 = 670;
        int loaderEngagedPositionSensor1 = 931;
        int loaderFilterDistanceSensor = 832;
        int loaderFilterGoodPositionStatus = 855;
        int loaderFilterPresenceSensor0 = 106;
        int loaderFilterPresenceSensor1 = 169;
        int loaderHandoffPositionSensor0 = 466;
        int loaderHandoffPositionSensor1 = 192;
        int loaderHoldingFilterSensor0 = 105;
        int loaderHoldingFilterSensor1 = 705;
        int loaderHooksRelayStatus = 204;
        int loaderOnCameraSensor0 = 43;
        int loaderOnCameraSensor1 = 805;
        int loaderOpenSensor1 = 930;
        int loaderOpenSensor2 = 826;
        int loaderOpenSensor3 = 691;
        int loaderOpenSensor4 = 40;
        int loaderStoragePositionSensor0 = 34;
        int loaderStoragePositionSensor1 = 677;
        int loader_LFD = 264;
        int loader_LFS = 425;
        int lockOut = 184;
        int lockOutShunt = 378;
        int lockout_C = 222;
        int lpmLatchesStatus = 398;
        int lpmLinearRail1Status = 648;
        int lpmLinearRail2Status = 479;
        int lpmOnlineClampsStatus = 544;
        int out_AF0 = 500;
        int out_AF0_C = 60;
        int out_AF1 = 961;
        int out_AF1_C = 189;
        int out_AF3 = 65;
        int out_AF3_C = 651;
        int out_AIN = 996;
        int out_AOL = 388;
        int out_AP1 = 667;
        int out_AP1_C = 376;
        int out_AP2 = 250;
        int out_AP2_C = 802;
        int out_AP3 = 641;
        int out_AP3_C = 402;
        int onlineClampXminusCloseSensor = 405;
        int onlineClampXminusCloseSensorC = 925;
        int onlineClampXminusOpenSensor = 551;
        int onlineClampXminusOpenSensorC = 267;
        int onlineClampXplusCloseSensor = 775;
        int onlineClampXplusCloseSensorC = 723;
        int onlineClampXplusOpenSensor = 743;
        int onlineClampXplusOpenSensorC = 568;
        int onlineClampYminusCloseSensor = 646;
        int onlineClampYminusCloseSensorC = 252;
        int onlineClampYminusOpenSensor = 906;
        int onlineClampYminusOpenSensorC = 948;
        int onlinePositionSensorBXminus = 302;
        int onlinePositionSensorBXplus = 777;
        int onlinePositionSensorXminus = 663;
        int onlinePositionSensorXplus = 9;
        int openSensorBLatchXminus = 358;
        int openSensorBLatchXplus = 703;
        int openSensorLatchXminus = 866;
        int openSensorLatchXplus = 524;
        int overClampedStatusSensor = 148;
        int presenceLoader = 868;
        int presenceloader_C = 950;
        int standbyPositionSensorBXminus = 236;
        int standbyPositionSensorBXplus = 156;
        int standbyPositionSensorXminus = 557;
        int standbyPositionSensorXplus = 493;
        int unclampedStatusSensor = 271;
        int underClampedStatusSensor = 771;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus1_LoaderPlutoGateway_TrendingTelemetry(acAF0b, acAF0s, acAF1b, acAF1s, acAF3b, acAF3s, acAP2b, acAP2s, carouselHoldingFilterSensor0, carouselHoldingFilterSensor1, carouselStoppedAtStandby, carouselStoppedAtStandbyC, carousel_CF0, carousel_CF0_C, carousel_CF1, carousel_CF1_C, clampedStatusSensor, closeSensorBLatchXminus, closeSensorBLatchXplus, closeSensorLatchXminus, closeSensorLatchXplus, engineeringKey, engineeringkey_C, filterEngagedSensorBLatchXminus, filterEngagedSensorBLatchXplus, filterEngagedSensorLatchXminus, filterEngagedSensorLatchXplus, filterIDSensor0, filterIDSensor1, filterIDSensor2, filterIDSensor3, filterIDSensor4, filterIDSensor5, forceSensor0, forceSensor1, handoffPositionSensorBXminus, handoffPositionSensorBXplus, handoffPositionSensorXminus, handoffPositionSensorXplus, inclinometerXminus, inclinometerXplus, keyEng, keyEngb, keyLock, keyLockb, lps_0, lps_1, lrh_0, lrh_1, loaderCarrierRelayStatus, loaderChainPresenceSensor, loaderCloseSensor1, loaderCloseSensor2, loaderCloseSensor3, loaderCloseSensor4, loaderConnectedSensor, loaderConnectedSensorC, loaderDefaultStatus, loaderEngagedPositionSensor0, loaderEngagedPositionSensor1, loaderFilterDistanceSensor, loaderFilterGoodPositionStatus, loaderFilterPresenceSensor0, loaderFilterPresenceSensor1, loaderHandoffPositionSensor0, loaderHandoffPositionSensor1, loaderHoldingFilterSensor0, loaderHoldingFilterSensor1, loaderHooksRelayStatus, loaderOnCameraSensor0, loaderOnCameraSensor1, loaderOpenSensor1, loaderOpenSensor2, loaderOpenSensor3, loaderOpenSensor4, loaderStoragePositionSensor0, loaderStoragePositionSensor1, loader_LFD, loader_LFS, lockOut, lockOutShunt, lockout_C, lpmLatchesStatus, lpmLinearRail1Status, lpmLinearRail2Status, lpmOnlineClampsStatus, out_AF0, out_AF0_C, out_AF1, out_AF1_C, out_AF3, out_AF3_C, out_AIN, out_AOL, out_AP1, out_AP1_C, out_AP2, out_AP2_C, out_AP3, out_AP3_C, onlineClampXminusCloseSensor, onlineClampXminusCloseSensorC, onlineClampXminusOpenSensor, onlineClampXminusOpenSensorC, onlineClampXplusCloseSensor, onlineClampXplusCloseSensorC, onlineClampXplusOpenSensor, onlineClampXplusOpenSensorC, onlineClampYminusCloseSensor, onlineClampYminusCloseSensorC, onlineClampYminusOpenSensor, onlineClampYminusOpenSensorC, onlinePositionSensorBXminus, onlinePositionSensorBXplus, onlinePositionSensorXminus, onlinePositionSensorXplus, openSensorBLatchXminus, openSensorBLatchXplus, openSensorLatchXminus, openSensorLatchXplus, overClampedStatusSensor, presenceLoader, presenceloader_C, standbyPositionSensorBXminus, standbyPositionSensorBXplus, standbyPositionSensorXminus, standbyPositionSensorXplus, unclampedStatusSensor, underClampedStatusSensor));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus1_LoaderPlutoGateway_TrendingTelemetry));
        Fcs_Canbus1_LoaderPlutoGateway_TrendingTelemetry item_ = (Fcs_Canbus1_LoaderPlutoGateway_TrendingTelemetry)item;
        Assert.assertEquals((long)acAF0b, (long)item_.getAcAF0b());
        Assert.assertEquals((long)acAF0s, (long)item_.getAcAF0s());
        Assert.assertEquals((long)acAF1b, (long)item_.getAcAF1b());
        Assert.assertEquals((long)acAF1s, (long)item_.getAcAF1s());
        Assert.assertEquals((long)acAF3b, (long)item_.getAcAF3b());
        Assert.assertEquals((long)acAF3s, (long)item_.getAcAF3s());
        Assert.assertEquals((long)acAP2b, (long)item_.getAcAP2b());
        Assert.assertEquals((long)acAP2s, (long)item_.getAcAP2s());
        Assert.assertEquals((long)carouselHoldingFilterSensor0, (long)item_.getCarouselHoldingFilterSensor0());
        Assert.assertEquals((long)carouselHoldingFilterSensor1, (long)item_.getCarouselHoldingFilterSensor1());
        Assert.assertEquals((long)carouselStoppedAtStandby, (long)item_.getCarouselStoppedAtStandby());
        Assert.assertEquals((long)carouselStoppedAtStandbyC, (long)item_.getCarouselStoppedAtStandbyC());
        Assert.assertEquals((long)carousel_CF0, (long)item_.getCarousel_CF0());
        Assert.assertEquals((long)carousel_CF0_C, (long)item_.getCarousel_CF0_C());
        Assert.assertEquals((long)carousel_CF1, (long)item_.getCarousel_CF1());
        Assert.assertEquals((long)carousel_CF1_C, (long)item_.getCarousel_CF1_C());
        Assert.assertEquals((long)clampedStatusSensor, (long)item_.getClampedStatusSensor());
        Assert.assertEquals((long)closeSensorBLatchXminus, (long)item_.getCloseSensorBLatchXminus());
        Assert.assertEquals((long)closeSensorBLatchXplus, (long)item_.getCloseSensorBLatchXplus());
        Assert.assertEquals((long)closeSensorLatchXminus, (long)item_.getCloseSensorLatchXminus());
        Assert.assertEquals((long)closeSensorLatchXplus, (long)item_.getCloseSensorLatchXplus());
        Assert.assertEquals((long)engineeringKey, (long)item_.getEngineeringKey());
        Assert.assertEquals((long)engineeringkey_C, (long)item_.getEngineeringkey_C());
        Assert.assertEquals((long)filterEngagedSensorBLatchXminus, (long)item_.getFilterEngagedSensorBLatchXminus());
        Assert.assertEquals((long)filterEngagedSensorBLatchXplus, (long)item_.getFilterEngagedSensorBLatchXplus());
        Assert.assertEquals((long)filterEngagedSensorLatchXminus, (long)item_.getFilterEngagedSensorLatchXminus());
        Assert.assertEquals((long)filterEngagedSensorLatchXplus, (long)item_.getFilterEngagedSensorLatchXplus());
        Assert.assertEquals((long)filterIDSensor0, (long)item_.getFilterIDSensor0());
        Assert.assertEquals((long)filterIDSensor1, (long)item_.getFilterIDSensor1());
        Assert.assertEquals((long)filterIDSensor2, (long)item_.getFilterIDSensor2());
        Assert.assertEquals((long)filterIDSensor3, (long)item_.getFilterIDSensor3());
        Assert.assertEquals((long)filterIDSensor4, (long)item_.getFilterIDSensor4());
        Assert.assertEquals((long)filterIDSensor5, (long)item_.getFilterIDSensor5());
        Assert.assertEquals((long)forceSensor0, (long)item_.getForceSensor0());
        Assert.assertEquals((long)forceSensor1, (long)item_.getForceSensor1());
        Assert.assertEquals((long)handoffPositionSensorBXminus, (long)item_.getHandoffPositionSensorBXminus());
        Assert.assertEquals((long)handoffPositionSensorBXplus, (long)item_.getHandoffPositionSensorBXplus());
        Assert.assertEquals((long)handoffPositionSensorXminus, (long)item_.getHandoffPositionSensorXminus());
        Assert.assertEquals((long)handoffPositionSensorXplus, (long)item_.getHandoffPositionSensorXplus());
        Assert.assertEquals((double)inclinometerXminus, (double)item_.getInclinometerXminus(), (double)1.0E-6f);
        Assert.assertEquals((double)inclinometerXplus, (double)item_.getInclinometerXplus(), (double)1.0E-6f);
        Assert.assertEquals((long)keyEng, (long)item_.getKeyEng());
        Assert.assertEquals((long)keyEngb, (long)item_.getKeyEngb());
        Assert.assertEquals((long)keyLock, (long)item_.getKeyLock());
        Assert.assertEquals((long)keyLockb, (long)item_.getKeyLockb());
        Assert.assertEquals((long)lps_0, (long)item_.getLps_0());
        Assert.assertEquals((long)lps_1, (long)item_.getLps_1());
        Assert.assertEquals((long)lrh_0, (long)item_.getLrh_0());
        Assert.assertEquals((long)lrh_1, (long)item_.getLrh_1());
        Assert.assertEquals((long)loaderCarrierRelayStatus, (long)item_.getLoaderCarrierRelayStatus());
        Assert.assertEquals((long)loaderChainPresenceSensor, (long)item_.getLoaderChainPresenceSensor());
        Assert.assertEquals((long)loaderCloseSensor1, (long)item_.getLoaderCloseSensor1());
        Assert.assertEquals((long)loaderCloseSensor2, (long)item_.getLoaderCloseSensor2());
        Assert.assertEquals((long)loaderCloseSensor3, (long)item_.getLoaderCloseSensor3());
        Assert.assertEquals((long)loaderCloseSensor4, (long)item_.getLoaderCloseSensor4());
        Assert.assertEquals((long)loaderConnectedSensor, (long)item_.getLoaderConnectedSensor());
        Assert.assertEquals((long)loaderConnectedSensorC, (long)item_.getLoaderConnectedSensorC());
        Assert.assertEquals((long)loaderDefaultStatus, (long)item_.getLoaderDefaultStatus());
        Assert.assertEquals((long)loaderEngagedPositionSensor0, (long)item_.getLoaderEngagedPositionSensor0());
        Assert.assertEquals((long)loaderEngagedPositionSensor1, (long)item_.getLoaderEngagedPositionSensor1());
        Assert.assertEquals((long)loaderFilterDistanceSensor, (long)item_.getLoaderFilterDistanceSensor());
        Assert.assertEquals((long)loaderFilterGoodPositionStatus, (long)item_.getLoaderFilterGoodPositionStatus());
        Assert.assertEquals((long)loaderFilterPresenceSensor0, (long)item_.getLoaderFilterPresenceSensor0());
        Assert.assertEquals((long)loaderFilterPresenceSensor1, (long)item_.getLoaderFilterPresenceSensor1());
        Assert.assertEquals((long)loaderHandoffPositionSensor0, (long)item_.getLoaderHandoffPositionSensor0());
        Assert.assertEquals((long)loaderHandoffPositionSensor1, (long)item_.getLoaderHandoffPositionSensor1());
        Assert.assertEquals((long)loaderHoldingFilterSensor0, (long)item_.getLoaderHoldingFilterSensor0());
        Assert.assertEquals((long)loaderHoldingFilterSensor1, (long)item_.getLoaderHoldingFilterSensor1());
        Assert.assertEquals((long)loaderHooksRelayStatus, (long)item_.getLoaderHooksRelayStatus());
        Assert.assertEquals((long)loaderOnCameraSensor0, (long)item_.getLoaderOnCameraSensor0());
        Assert.assertEquals((long)loaderOnCameraSensor1, (long)item_.getLoaderOnCameraSensor1());
        Assert.assertEquals((long)loaderOpenSensor1, (long)item_.getLoaderOpenSensor1());
        Assert.assertEquals((long)loaderOpenSensor2, (long)item_.getLoaderOpenSensor2());
        Assert.assertEquals((long)loaderOpenSensor3, (long)item_.getLoaderOpenSensor3());
        Assert.assertEquals((long)loaderOpenSensor4, (long)item_.getLoaderOpenSensor4());
        Assert.assertEquals((long)loaderStoragePositionSensor0, (long)item_.getLoaderStoragePositionSensor0());
        Assert.assertEquals((long)loaderStoragePositionSensor1, (long)item_.getLoaderStoragePositionSensor1());
        Assert.assertEquals((long)loader_LFD, (long)item_.getLoader_LFD());
        Assert.assertEquals((long)loader_LFS, (long)item_.getLoader_LFS());
        Assert.assertEquals((long)lockOut, (long)item_.getLockOut());
        Assert.assertEquals((long)lockOutShunt, (long)item_.getLockOutShunt());
        Assert.assertEquals((long)lockout_C, (long)item_.getLockout_C());
        Assert.assertEquals((long)lpmLatchesStatus, (long)item_.getLpmLatchesStatus());
        Assert.assertEquals((long)lpmLinearRail1Status, (long)item_.getLpmLinearRail1Status());
        Assert.assertEquals((long)lpmLinearRail2Status, (long)item_.getLpmLinearRail2Status());
        Assert.assertEquals((long)lpmOnlineClampsStatus, (long)item_.getLpmOnlineClampsStatus());
        Assert.assertEquals((long)out_AF0, (long)item_.getOut_AF0());
        Assert.assertEquals((long)out_AF0_C, (long)item_.getOut_AF0_C());
        Assert.assertEquals((long)out_AF1, (long)item_.getOut_AF1());
        Assert.assertEquals((long)out_AF1_C, (long)item_.getOut_AF1_C());
        Assert.assertEquals((long)out_AF3, (long)item_.getOut_AF3());
        Assert.assertEquals((long)out_AF3_C, (long)item_.getOut_AF3_C());
        Assert.assertEquals((long)out_AIN, (long)item_.getOut_AIN());
        Assert.assertEquals((long)out_AOL, (long)item_.getOut_AOL());
        Assert.assertEquals((long)out_AP1, (long)item_.getOut_AP1());
        Assert.assertEquals((long)out_AP1_C, (long)item_.getOut_AP1_C());
        Assert.assertEquals((long)out_AP2, (long)item_.getOut_AP2());
        Assert.assertEquals((long)out_AP2_C, (long)item_.getOut_AP2_C());
        Assert.assertEquals((long)out_AP3, (long)item_.getOut_AP3());
        Assert.assertEquals((long)out_AP3_C, (long)item_.getOut_AP3_C());
        Assert.assertEquals((long)onlineClampXminusCloseSensor, (long)item_.getOnlineClampXminusCloseSensor());
        Assert.assertEquals((long)onlineClampXminusCloseSensorC, (long)item_.getOnlineClampXminusCloseSensorC());
        Assert.assertEquals((long)onlineClampXminusOpenSensor, (long)item_.getOnlineClampXminusOpenSensor());
        Assert.assertEquals((long)onlineClampXminusOpenSensorC, (long)item_.getOnlineClampXminusOpenSensorC());
        Assert.assertEquals((long)onlineClampXplusCloseSensor, (long)item_.getOnlineClampXplusCloseSensor());
        Assert.assertEquals((long)onlineClampXplusCloseSensorC, (long)item_.getOnlineClampXplusCloseSensorC());
        Assert.assertEquals((long)onlineClampXplusOpenSensor, (long)item_.getOnlineClampXplusOpenSensor());
        Assert.assertEquals((long)onlineClampXplusOpenSensorC, (long)item_.getOnlineClampXplusOpenSensorC());
        Assert.assertEquals((long)onlineClampYminusCloseSensor, (long)item_.getOnlineClampYminusCloseSensor());
        Assert.assertEquals((long)onlineClampYminusCloseSensorC, (long)item_.getOnlineClampYminusCloseSensorC());
        Assert.assertEquals((long)onlineClampYminusOpenSensor, (long)item_.getOnlineClampYminusOpenSensor());
        Assert.assertEquals((long)onlineClampYminusOpenSensorC, (long)item_.getOnlineClampYminusOpenSensorC());
        Assert.assertEquals((long)onlinePositionSensorBXminus, (long)item_.getOnlinePositionSensorBXminus());
        Assert.assertEquals((long)onlinePositionSensorBXplus, (long)item_.getOnlinePositionSensorBXplus());
        Assert.assertEquals((long)onlinePositionSensorXminus, (long)item_.getOnlinePositionSensorXminus());
        Assert.assertEquals((long)onlinePositionSensorXplus, (long)item_.getOnlinePositionSensorXplus());
        Assert.assertEquals((long)openSensorBLatchXminus, (long)item_.getOpenSensorBLatchXminus());
        Assert.assertEquals((long)openSensorBLatchXplus, (long)item_.getOpenSensorBLatchXplus());
        Assert.assertEquals((long)openSensorLatchXminus, (long)item_.getOpenSensorLatchXminus());
        Assert.assertEquals((long)openSensorLatchXplus, (long)item_.getOpenSensorLatchXplus());
        Assert.assertEquals((long)overClampedStatusSensor, (long)item_.getOverClampedStatusSensor());
        Assert.assertEquals((long)presenceLoader, (long)item_.getPresenceLoader());
        Assert.assertEquals((long)presenceloader_C, (long)item_.getPresenceloader_C());
        Assert.assertEquals((long)standbyPositionSensorBXminus, (long)item_.getStandbyPositionSensorBXminus());
        Assert.assertEquals((long)standbyPositionSensorBXplus, (long)item_.getStandbyPositionSensorBXplus());
        Assert.assertEquals((long)standbyPositionSensorXminus, (long)item_.getStandbyPositionSensorXminus());
        Assert.assertEquals((long)standbyPositionSensorXplus, (long)item_.getStandbyPositionSensorXplus());
        Assert.assertEquals((long)unclampedStatusSensor, (long)item_.getUnclampedStatusSensor());
        Assert.assertEquals((long)underClampedStatusSensor, (long)item_.getUnderClampedStatusSensor());
    }

    @Test
    public void sendReceiveFcs_Carousel_Socket1_TrendingTelemetry() throws Exception {
        boolean atStandby = true;
        String clampxminus1_clampState = "";
        int clampxminus1_filterPositionSensorValue = 544;
        int clampxminus1_filterPresenceOffset2 = 859;
        String clampxminus1_filterPresenceStatus = "";
        int clampxminus1_lockSensorOffset1 = 371;
        int clampxminus1_lockSensorValue = 472;
        String clampxminus1_lockStatus = "";
        String clampxplus1_clampState = "";
        int clampxplus1_filterPositionSensorValue = 633;
        int clampxplus1_filterPresenceOffset2 = 536;
        String clampxplus1_filterPresenceStatus = "";
        int clampxplus1_lockSensorOffset1 = 93;
        int clampxplus1_lockSensorValue = 511;
        String clampxplus1_lockStatus = "o";
        String clampsState = "n";
        boolean empty = true;
        int filterID = 196;
        String ioStatus = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_Socket1_TrendingTelemetry(atStandby, clampxminus1_clampState, clampxminus1_filterPositionSensorValue, clampxminus1_filterPresenceOffset2, clampxminus1_filterPresenceStatus, clampxminus1_lockSensorOffset1, clampxminus1_lockSensorValue, clampxminus1_lockStatus, clampxplus1_clampState, clampxplus1_filterPositionSensorValue, clampxplus1_filterPresenceOffset2, clampxplus1_filterPresenceStatus, clampxplus1_lockSensorOffset1, clampxplus1_lockSensorValue, clampxplus1_lockStatus, clampsState, empty, filterID, ioStatus));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_Socket1_TrendingTelemetry));
        Fcs_Carousel_Socket1_TrendingTelemetry item_ = (Fcs_Carousel_Socket1_TrendingTelemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)clampxminus1_clampState, (Object)item_.getClampxminus1_clampState());
        Assert.assertEquals((long)clampxminus1_filterPositionSensorValue, (long)item_.getClampxminus1_filterPositionSensorValue());
        Assert.assertEquals((long)clampxminus1_filterPresenceOffset2, (long)item_.getClampxminus1_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxminus1_filterPresenceStatus, (Object)item_.getClampxminus1_filterPresenceStatus());
        Assert.assertEquals((long)clampxminus1_lockSensorOffset1, (long)item_.getClampxminus1_lockSensorOffset1());
        Assert.assertEquals((long)clampxminus1_lockSensorValue, (long)item_.getClampxminus1_lockSensorValue());
        Assert.assertEquals((Object)clampxminus1_lockStatus, (Object)item_.getClampxminus1_lockStatus());
        Assert.assertEquals((Object)clampxplus1_clampState, (Object)item_.getClampxplus1_clampState());
        Assert.assertEquals((long)clampxplus1_filterPositionSensorValue, (long)item_.getClampxplus1_filterPositionSensorValue());
        Assert.assertEquals((long)clampxplus1_filterPresenceOffset2, (long)item_.getClampxplus1_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxplus1_filterPresenceStatus, (Object)item_.getClampxplus1_filterPresenceStatus());
        Assert.assertEquals((long)clampxplus1_lockSensorOffset1, (long)item_.getClampxplus1_lockSensorOffset1());
        Assert.assertEquals((long)clampxplus1_lockSensorValue, (long)item_.getClampxplus1_lockSensorValue());
        Assert.assertEquals((Object)clampxplus1_lockStatus, (Object)item_.getClampxplus1_lockStatus());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((long)filterID, (long)item_.getFilterID());
        Assert.assertEquals((Object)ioStatus, (Object)item_.getIoStatus());
    }

    @Test
    public void sendReceiveFcs_Carousel_Socket2_TrendingTelemetry() throws Exception {
        boolean atStandby = true;
        String clampxminus2_clampState = "";
        int clampxminus2_filterPositionSensorValue = 322;
        int clampxminus2_filterPresenceOffset2 = 103;
        String clampxminus2_filterPresenceStatus = "";
        int clampxminus2_lockSensorOffset1 = 977;
        int clampxminus2_lockSensorValue = 12;
        String clampxminus2_lockStatus = "";
        String clampxplus2_clampState = "e";
        int clampxplus2_filterPositionSensorValue = 985;
        int clampxplus2_filterPresenceOffset2 = 946;
        String clampxplus2_filterPresenceStatus = "";
        int clampxplus2_lockSensorOffset1 = 431;
        int clampxplus2_lockSensorValue = 946;
        String clampxplus2_lockStatus = "";
        String clampsState = "";
        boolean empty = false;
        int filterID = 253;
        String ioStatus = "l";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_Socket2_TrendingTelemetry(atStandby, clampxminus2_clampState, clampxminus2_filterPositionSensorValue, clampxminus2_filterPresenceOffset2, clampxminus2_filterPresenceStatus, clampxminus2_lockSensorOffset1, clampxminus2_lockSensorValue, clampxminus2_lockStatus, clampxplus2_clampState, clampxplus2_filterPositionSensorValue, clampxplus2_filterPresenceOffset2, clampxplus2_filterPresenceStatus, clampxplus2_lockSensorOffset1, clampxplus2_lockSensorValue, clampxplus2_lockStatus, clampsState, empty, filterID, ioStatus));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_Socket2_TrendingTelemetry));
        Fcs_Carousel_Socket2_TrendingTelemetry item_ = (Fcs_Carousel_Socket2_TrendingTelemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)clampxminus2_clampState, (Object)item_.getClampxminus2_clampState());
        Assert.assertEquals((long)clampxminus2_filterPositionSensorValue, (long)item_.getClampxminus2_filterPositionSensorValue());
        Assert.assertEquals((long)clampxminus2_filterPresenceOffset2, (long)item_.getClampxminus2_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxminus2_filterPresenceStatus, (Object)item_.getClampxminus2_filterPresenceStatus());
        Assert.assertEquals((long)clampxminus2_lockSensorOffset1, (long)item_.getClampxminus2_lockSensorOffset1());
        Assert.assertEquals((long)clampxminus2_lockSensorValue, (long)item_.getClampxminus2_lockSensorValue());
        Assert.assertEquals((Object)clampxminus2_lockStatus, (Object)item_.getClampxminus2_lockStatus());
        Assert.assertEquals((Object)clampxplus2_clampState, (Object)item_.getClampxplus2_clampState());
        Assert.assertEquals((long)clampxplus2_filterPositionSensorValue, (long)item_.getClampxplus2_filterPositionSensorValue());
        Assert.assertEquals((long)clampxplus2_filterPresenceOffset2, (long)item_.getClampxplus2_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxplus2_filterPresenceStatus, (Object)item_.getClampxplus2_filterPresenceStatus());
        Assert.assertEquals((long)clampxplus2_lockSensorOffset1, (long)item_.getClampxplus2_lockSensorOffset1());
        Assert.assertEquals((long)clampxplus2_lockSensorValue, (long)item_.getClampxplus2_lockSensorValue());
        Assert.assertEquals((Object)clampxplus2_lockStatus, (Object)item_.getClampxplus2_lockStatus());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((long)filterID, (long)item_.getFilterID());
        Assert.assertEquals((Object)ioStatus, (Object)item_.getIoStatus());
    }

    @Test
    public void sendReceiveFcs_Carousel_Socket3_TrendingTelemetry() throws Exception {
        boolean atStandby = false;
        String clampxminus3_clampState = "";
        int clampxminus3_filterPositionSensorValue = 719;
        int clampxminus3_filterPresenceOffset2 = 467;
        String clampxminus3_filterPresenceStatus = "a";
        int clampxminus3_lockSensorOffset1 = 551;
        int clampxminus3_lockSensorValue = 704;
        String clampxminus3_lockStatus = "";
        String clampxplus3_clampState = "u";
        int clampxplus3_filterPositionSensorValue = 809;
        int clampxplus3_filterPresenceOffset2 = 11;
        String clampxplus3_filterPresenceStatus = "l";
        int clampxplus3_lockSensorOffset1 = 889;
        int clampxplus3_lockSensorValue = 838;
        String clampxplus3_lockStatus = "";
        String clampsState = "";
        boolean empty = true;
        int filterID = 776;
        String ioStatus = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_Socket3_TrendingTelemetry(atStandby, clampxminus3_clampState, clampxminus3_filterPositionSensorValue, clampxminus3_filterPresenceOffset2, clampxminus3_filterPresenceStatus, clampxminus3_lockSensorOffset1, clampxminus3_lockSensorValue, clampxminus3_lockStatus, clampxplus3_clampState, clampxplus3_filterPositionSensorValue, clampxplus3_filterPresenceOffset2, clampxplus3_filterPresenceStatus, clampxplus3_lockSensorOffset1, clampxplus3_lockSensorValue, clampxplus3_lockStatus, clampsState, empty, filterID, ioStatus));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_Socket3_TrendingTelemetry));
        Fcs_Carousel_Socket3_TrendingTelemetry item_ = (Fcs_Carousel_Socket3_TrendingTelemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)clampxminus3_clampState, (Object)item_.getClampxminus3_clampState());
        Assert.assertEquals((long)clampxminus3_filterPositionSensorValue, (long)item_.getClampxminus3_filterPositionSensorValue());
        Assert.assertEquals((long)clampxminus3_filterPresenceOffset2, (long)item_.getClampxminus3_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxminus3_filterPresenceStatus, (Object)item_.getClampxminus3_filterPresenceStatus());
        Assert.assertEquals((long)clampxminus3_lockSensorOffset1, (long)item_.getClampxminus3_lockSensorOffset1());
        Assert.assertEquals((long)clampxminus3_lockSensorValue, (long)item_.getClampxminus3_lockSensorValue());
        Assert.assertEquals((Object)clampxminus3_lockStatus, (Object)item_.getClampxminus3_lockStatus());
        Assert.assertEquals((Object)clampxplus3_clampState, (Object)item_.getClampxplus3_clampState());
        Assert.assertEquals((long)clampxplus3_filterPositionSensorValue, (long)item_.getClampxplus3_filterPositionSensorValue());
        Assert.assertEquals((long)clampxplus3_filterPresenceOffset2, (long)item_.getClampxplus3_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxplus3_filterPresenceStatus, (Object)item_.getClampxplus3_filterPresenceStatus());
        Assert.assertEquals((long)clampxplus3_lockSensorOffset1, (long)item_.getClampxplus3_lockSensorOffset1());
        Assert.assertEquals((long)clampxplus3_lockSensorValue, (long)item_.getClampxplus3_lockSensorValue());
        Assert.assertEquals((Object)clampxplus3_lockStatus, (Object)item_.getClampxplus3_lockStatus());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((long)filterID, (long)item_.getFilterID());
        Assert.assertEquals((Object)ioStatus, (Object)item_.getIoStatus());
    }

    @Test
    public void sendReceiveFcs_Carousel_Socket4_TrendingTelemetry() throws Exception {
        boolean atStandby = false;
        String clampxminus4_clampState = "i";
        int clampxminus4_filterPositionSensorValue = 38;
        int clampxminus4_filterPresenceOffset2 = 927;
        String clampxminus4_filterPresenceStatus = "";
        int clampxminus4_lockSensorOffset1 = 630;
        int clampxminus4_lockSensorValue = 972;
        String clampxminus4_lockStatus = "";
        String clampxplus4_clampState = "";
        int clampxplus4_filterPositionSensorValue = 440;
        int clampxplus4_filterPresenceOffset2 = 512;
        String clampxplus4_filterPresenceStatus = "n";
        int clampxplus4_lockSensorOffset1 = 934;
        int clampxplus4_lockSensorValue = 514;
        String clampxplus4_lockStatus = "";
        String clampsState = "g";
        boolean empty = true;
        int filterID = 414;
        String ioStatus = "f";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_Socket4_TrendingTelemetry(atStandby, clampxminus4_clampState, clampxminus4_filterPositionSensorValue, clampxminus4_filterPresenceOffset2, clampxminus4_filterPresenceStatus, clampxminus4_lockSensorOffset1, clampxminus4_lockSensorValue, clampxminus4_lockStatus, clampxplus4_clampState, clampxplus4_filterPositionSensorValue, clampxplus4_filterPresenceOffset2, clampxplus4_filterPresenceStatus, clampxplus4_lockSensorOffset1, clampxplus4_lockSensorValue, clampxplus4_lockStatus, clampsState, empty, filterID, ioStatus));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_Socket4_TrendingTelemetry));
        Fcs_Carousel_Socket4_TrendingTelemetry item_ = (Fcs_Carousel_Socket4_TrendingTelemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)clampxminus4_clampState, (Object)item_.getClampxminus4_clampState());
        Assert.assertEquals((long)clampxminus4_filterPositionSensorValue, (long)item_.getClampxminus4_filterPositionSensorValue());
        Assert.assertEquals((long)clampxminus4_filterPresenceOffset2, (long)item_.getClampxminus4_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxminus4_filterPresenceStatus, (Object)item_.getClampxminus4_filterPresenceStatus());
        Assert.assertEquals((long)clampxminus4_lockSensorOffset1, (long)item_.getClampxminus4_lockSensorOffset1());
        Assert.assertEquals((long)clampxminus4_lockSensorValue, (long)item_.getClampxminus4_lockSensorValue());
        Assert.assertEquals((Object)clampxminus4_lockStatus, (Object)item_.getClampxminus4_lockStatus());
        Assert.assertEquals((Object)clampxplus4_clampState, (Object)item_.getClampxplus4_clampState());
        Assert.assertEquals((long)clampxplus4_filterPositionSensorValue, (long)item_.getClampxplus4_filterPositionSensorValue());
        Assert.assertEquals((long)clampxplus4_filterPresenceOffset2, (long)item_.getClampxplus4_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxplus4_filterPresenceStatus, (Object)item_.getClampxplus4_filterPresenceStatus());
        Assert.assertEquals((long)clampxplus4_lockSensorOffset1, (long)item_.getClampxplus4_lockSensorOffset1());
        Assert.assertEquals((long)clampxplus4_lockSensorValue, (long)item_.getClampxplus4_lockSensorValue());
        Assert.assertEquals((Object)clampxplus4_lockStatus, (Object)item_.getClampxplus4_lockStatus());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((long)filterID, (long)item_.getFilterID());
        Assert.assertEquals((Object)ioStatus, (Object)item_.getIoStatus());
    }

    @Test
    public void sendReceiveFcs_Carousel_Socket5_TrendingTelemetry() throws Exception {
        boolean atStandby = false;
        String clampxminus5_clampState = "g";
        int clampxminus5_filterPositionSensorValue = 520;
        int clampxminus5_filterPresenceOffset2 = 838;
        String clampxminus5_filterPresenceStatus = "l";
        int clampxminus5_lockSensorOffset1 = 731;
        int clampxminus5_lockSensorValue = 243;
        String clampxminus5_lockStatus = "q";
        String clampxplus5_clampState = "x";
        int clampxplus5_filterPositionSensorValue = 263;
        int clampxplus5_filterPresenceOffset2 = 559;
        String clampxplus5_filterPresenceStatus = "";
        int clampxplus5_lockSensorOffset1 = 593;
        int clampxplus5_lockSensorValue = 163;
        String clampxplus5_lockStatus = "";
        String clampsState = "x";
        boolean empty = false;
        int filterID = 538;
        String ioStatus = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_Socket5_TrendingTelemetry(atStandby, clampxminus5_clampState, clampxminus5_filterPositionSensorValue, clampxminus5_filterPresenceOffset2, clampxminus5_filterPresenceStatus, clampxminus5_lockSensorOffset1, clampxminus5_lockSensorValue, clampxminus5_lockStatus, clampxplus5_clampState, clampxplus5_filterPositionSensorValue, clampxplus5_filterPresenceOffset2, clampxplus5_filterPresenceStatus, clampxplus5_lockSensorOffset1, clampxplus5_lockSensorValue, clampxplus5_lockStatus, clampsState, empty, filterID, ioStatus));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_Socket5_TrendingTelemetry));
        Fcs_Carousel_Socket5_TrendingTelemetry item_ = (Fcs_Carousel_Socket5_TrendingTelemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)clampxminus5_clampState, (Object)item_.getClampxminus5_clampState());
        Assert.assertEquals((long)clampxminus5_filterPositionSensorValue, (long)item_.getClampxminus5_filterPositionSensorValue());
        Assert.assertEquals((long)clampxminus5_filterPresenceOffset2, (long)item_.getClampxminus5_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxminus5_filterPresenceStatus, (Object)item_.getClampxminus5_filterPresenceStatus());
        Assert.assertEquals((long)clampxminus5_lockSensorOffset1, (long)item_.getClampxminus5_lockSensorOffset1());
        Assert.assertEquals((long)clampxminus5_lockSensorValue, (long)item_.getClampxminus5_lockSensorValue());
        Assert.assertEquals((Object)clampxminus5_lockStatus, (Object)item_.getClampxminus5_lockStatus());
        Assert.assertEquals((Object)clampxplus5_clampState, (Object)item_.getClampxplus5_clampState());
        Assert.assertEquals((long)clampxplus5_filterPositionSensorValue, (long)item_.getClampxplus5_filterPositionSensorValue());
        Assert.assertEquals((long)clampxplus5_filterPresenceOffset2, (long)item_.getClampxplus5_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxplus5_filterPresenceStatus, (Object)item_.getClampxplus5_filterPresenceStatus());
        Assert.assertEquals((long)clampxplus5_lockSensorOffset1, (long)item_.getClampxplus5_lockSensorOffset1());
        Assert.assertEquals((long)clampxplus5_lockSensorValue, (long)item_.getClampxplus5_lockSensorValue());
        Assert.assertEquals((Object)clampxplus5_lockStatus, (Object)item_.getClampxplus5_lockStatus());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((long)filterID, (long)item_.getFilterID());
        Assert.assertEquals((Object)ioStatus, (Object)item_.getIoStatus());
    }

    @Test
    public void sendReceiveFcs_Carousel_TrendingTelemetry() throws Exception {
        boolean atStandby = false;
        String clampsStateAtStandby = "j";
        int deltaPositionAtStandby = 374;
        boolean emptyAtStandby = false;
        int estimatedPosition = 19;
        int filterAtStandbyId = 898;
        String filterOnAutochangerName = "p";
        long minLocked = 570L;
        int socketAtStandbyID = 361;
        String socketAtStandbyName = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_TrendingTelemetry(atStandby, clampsStateAtStandby, deltaPositionAtStandby, emptyAtStandby, estimatedPosition, filterAtStandbyId, filterOnAutochangerName, minLocked, socketAtStandbyID, socketAtStandbyName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_TrendingTelemetry));
        Fcs_Carousel_TrendingTelemetry item_ = (Fcs_Carousel_TrendingTelemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)clampsStateAtStandby, (Object)item_.getClampsStateAtStandby());
        Assert.assertEquals((long)deltaPositionAtStandby, (long)item_.getDeltaPositionAtStandby());
        Assert.assertEquals((Object)emptyAtStandby, (Object)item_.isEmptyAtStandby());
        Assert.assertEquals((long)estimatedPosition, (long)item_.getEstimatedPosition());
        Assert.assertEquals((long)filterAtStandbyId, (long)item_.getFilterAtStandbyId());
        Assert.assertEquals((Object)filterOnAutochangerName, (Object)item_.getFilterOnAutochangerName());
        Assert.assertEquals((long)minLocked, (long)item_.getMinLocked());
        Assert.assertEquals((long)socketAtStandbyID, (long)item_.getSocketAtStandbyID());
        Assert.assertEquals((Object)socketAtStandbyName, (Object)item_.getSocketAtStandbyName());
    }

    @Test
    public void sendReceiveFcs_Duration_Autochanger_TrendingTelemetry() throws Exception {
        long autochangertrucks_ALIGN_FOLLOWER = 567L;
        long autochangertrucks_MOVE_FOLLOWER_TRUCK_ALONE = 425L;
        long autochangertrucks_MOVE_TO_ABSOLUTE_POSITION = 902L;
        long latches_latchXminus_CLOSE = 388L;
        long latches_latchXminus_OPEN = 791L;
        long latches_latchXplus_CLOSE = 346L;
        long latches_latchXplus_OPEN = 392L;
        long onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_CURRENT = 630L;
        long onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION = 838L;
        long onlineclamps_onlineClampXminus_LOCK_ONLINECLAMP = 719L;
        long onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_CURRENT = 662L;
        long onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION = 260L;
        long onlineclamps_onlineClampXminus_REOPEN_ONLINECLAMP_MODE_CURRENT = 768L;
        long onlineclamps_onlineClampXminus_UNLOCK_ONLINECLAMP = 63L;
        long onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_CURRENT = 841L;
        long onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION = 322L;
        long onlineclamps_onlineClampXplus_LOCK_ONLINECLAMP = 987L;
        long onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_CURRENT = 609L;
        long onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION = 861L;
        long onlineclamps_onlineClampXplus_REOPEN_ONLINECLAMP_MODE_CURRENT = 167L;
        long onlineclamps_onlineClampXplus_UNLOCK_ONLINECLAMP = 19L;
        long onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_CURRENT = 703L;
        long onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION = 350L;
        long onlineclamps_onlineClampYminus_LOCK_ONLINECLAMP = 124L;
        long onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_CURRENT = 692L;
        long onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION = 946L;
        long onlineclamps_onlineClampYminus_REOPEN_ONLINECLAMP_MODE_CURRENT = 903L;
        long onlineclamps_onlineClampYminus_UNLOCK_ONLINECLAMP = 488L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Duration_Autochanger_TrendingTelemetry(autochangertrucks_ALIGN_FOLLOWER, autochangertrucks_MOVE_FOLLOWER_TRUCK_ALONE, autochangertrucks_MOVE_TO_ABSOLUTE_POSITION, latches_latchXminus_CLOSE, latches_latchXminus_OPEN, latches_latchXplus_CLOSE, latches_latchXplus_OPEN, onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampXminus_LOCK_ONLINECLAMP, onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampXminus_REOPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXminus_UNLOCK_ONLINECLAMP, onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampXplus_LOCK_ONLINECLAMP, onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampXplus_REOPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXplus_UNLOCK_ONLINECLAMP, onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampYminus_LOCK_ONLINECLAMP, onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampYminus_REOPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampYminus_UNLOCK_ONLINECLAMP));
        Assert.assertTrue((boolean)(item instanceof Fcs_Duration_Autochanger_TrendingTelemetry));
        Fcs_Duration_Autochanger_TrendingTelemetry item_ = (Fcs_Duration_Autochanger_TrendingTelemetry)item;
        Assert.assertEquals((long)autochangertrucks_ALIGN_FOLLOWER, (long)item_.getAutochangertrucks_ALIGN_FOLLOWER());
        Assert.assertEquals((long)autochangertrucks_MOVE_FOLLOWER_TRUCK_ALONE, (long)item_.getAutochangertrucks_MOVE_FOLLOWER_TRUCK_ALONE());
        Assert.assertEquals((long)autochangertrucks_MOVE_TO_ABSOLUTE_POSITION, (long)item_.getAutochangertrucks_MOVE_TO_ABSOLUTE_POSITION());
        Assert.assertEquals((long)latches_latchXminus_CLOSE, (long)item_.getLatches_latchXminus_CLOSE());
        Assert.assertEquals((long)latches_latchXminus_OPEN, (long)item_.getLatches_latchXminus_OPEN());
        Assert.assertEquals((long)latches_latchXplus_CLOSE, (long)item_.getLatches_latchXplus_CLOSE());
        Assert.assertEquals((long)latches_latchXplus_OPEN, (long)item_.getLatches_latchXplus_OPEN());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, (long)item_.getOnlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_LOCK_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampXminus_LOCK_ONLINECLAMP());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, (long)item_.getOnlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_REOPEN_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampXminus_REOPEN_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_UNLOCK_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampXminus_UNLOCK_ONLINECLAMP());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, (long)item_.getOnlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_LOCK_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampXplus_LOCK_ONLINECLAMP());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, (long)item_.getOnlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_REOPEN_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampXplus_REOPEN_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_UNLOCK_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampXplus_UNLOCK_ONLINECLAMP());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, (long)item_.getOnlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_LOCK_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampYminus_LOCK_ONLINECLAMP());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, (long)item_.getOnlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_REOPEN_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampYminus_REOPEN_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_UNLOCK_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampYminus_UNLOCK_ONLINECLAMP());
    }

    @Test
    public void sendReceiveFcs_Duration_Carousel_TrendingTelemetry() throws Exception {
        long rotate_CAROUSEL_TO_ABSOLUTE_POSITION = 976L;
        long rotate_CAROUSEL_TO_RELATIVE_POSITION = 342L;
        int socket1_RELEASECLAMPS = 334;
        int socket1_UNLOCKCLAMPS = 457;
        long socket1_clampXminus1_RELEASE = 280L;
        long socket1_clampXminus1_UNLOCK = 890L;
        long socket1_clampXplus1_RELEASE = 844L;
        long socket1_clampXplus1_UNLOCK = 601L;
        int socket2_RELEASECLAMPS = 695;
        int socket2_UNLOCKCLAMPS = 247;
        long socket2_clampXminus2_RELEASE = 872L;
        long socket2_clampXminus2_UNLOCK = 147L;
        long socket2_clampXplus2_RELEASE = 882L;
        long socket2_clampXplus2_UNLOCK = 523L;
        int socket3_RELEASECLAMPS = 883;
        int socket3_UNLOCKCLAMPS = 400;
        long socket3_clampXminus3_RELEASE = 204L;
        long socket3_clampXminus3_UNLOCK = 984L;
        long socket3_clampXplus3_RELEASE = 438L;
        long socket3_clampXplus3_UNLOCK = 747L;
        int socket4_RELEASECLAMPS = 662;
        int socket4_UNLOCKCLAMPS = 365;
        long socket4_clampXminus4_RELEASE = 95L;
        long socket4_clampXminus4_UNLOCK = 661L;
        long socket4_clampXplus4_RELEASE = 804L;
        long socket4_clampXplus4_UNLOCK = 793L;
        int socket5_RELEASECLAMPS = 555;
        int socket5_UNLOCKCLAMPS = 573;
        long socket5_clampXminus5_RELEASE = 370L;
        long socket5_clampXminus5_UNLOCK = 463L;
        long socket5_clampXplus5_RELEASE = 589L;
        long socket5_clampXplus5_UNLOCK = 400L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Duration_Carousel_TrendingTelemetry(rotate_CAROUSEL_TO_ABSOLUTE_POSITION, rotate_CAROUSEL_TO_RELATIVE_POSITION, socket1_RELEASECLAMPS, socket1_UNLOCKCLAMPS, socket1_clampXminus1_RELEASE, socket1_clampXminus1_UNLOCK, socket1_clampXplus1_RELEASE, socket1_clampXplus1_UNLOCK, socket2_RELEASECLAMPS, socket2_UNLOCKCLAMPS, socket2_clampXminus2_RELEASE, socket2_clampXminus2_UNLOCK, socket2_clampXplus2_RELEASE, socket2_clampXplus2_UNLOCK, socket3_RELEASECLAMPS, socket3_UNLOCKCLAMPS, socket3_clampXminus3_RELEASE, socket3_clampXminus3_UNLOCK, socket3_clampXplus3_RELEASE, socket3_clampXplus3_UNLOCK, socket4_RELEASECLAMPS, socket4_UNLOCKCLAMPS, socket4_clampXminus4_RELEASE, socket4_clampXminus4_UNLOCK, socket4_clampXplus4_RELEASE, socket4_clampXplus4_UNLOCK, socket5_RELEASECLAMPS, socket5_UNLOCKCLAMPS, socket5_clampXminus5_RELEASE, socket5_clampXminus5_UNLOCK, socket5_clampXplus5_RELEASE, socket5_clampXplus5_UNLOCK));
        Assert.assertTrue((boolean)(item instanceof Fcs_Duration_Carousel_TrendingTelemetry));
        Fcs_Duration_Carousel_TrendingTelemetry item_ = (Fcs_Duration_Carousel_TrendingTelemetry)item;
        Assert.assertEquals((long)rotate_CAROUSEL_TO_ABSOLUTE_POSITION, (long)item_.getRotate_CAROUSEL_TO_ABSOLUTE_POSITION());
        Assert.assertEquals((long)rotate_CAROUSEL_TO_RELATIVE_POSITION, (long)item_.getRotate_CAROUSEL_TO_RELATIVE_POSITION());
        Assert.assertEquals((long)socket1_RELEASECLAMPS, (long)item_.getSocket1_RELEASECLAMPS());
        Assert.assertEquals((long)socket1_UNLOCKCLAMPS, (long)item_.getSocket1_UNLOCKCLAMPS());
        Assert.assertEquals((long)socket1_clampXminus1_RELEASE, (long)item_.getSocket1_clampXminus1_RELEASE());
        Assert.assertEquals((long)socket1_clampXminus1_UNLOCK, (long)item_.getSocket1_clampXminus1_UNLOCK());
        Assert.assertEquals((long)socket1_clampXplus1_RELEASE, (long)item_.getSocket1_clampXplus1_RELEASE());
        Assert.assertEquals((long)socket1_clampXplus1_UNLOCK, (long)item_.getSocket1_clampXplus1_UNLOCK());
        Assert.assertEquals((long)socket2_RELEASECLAMPS, (long)item_.getSocket2_RELEASECLAMPS());
        Assert.assertEquals((long)socket2_UNLOCKCLAMPS, (long)item_.getSocket2_UNLOCKCLAMPS());
        Assert.assertEquals((long)socket2_clampXminus2_RELEASE, (long)item_.getSocket2_clampXminus2_RELEASE());
        Assert.assertEquals((long)socket2_clampXminus2_UNLOCK, (long)item_.getSocket2_clampXminus2_UNLOCK());
        Assert.assertEquals((long)socket2_clampXplus2_RELEASE, (long)item_.getSocket2_clampXplus2_RELEASE());
        Assert.assertEquals((long)socket2_clampXplus2_UNLOCK, (long)item_.getSocket2_clampXplus2_UNLOCK());
        Assert.assertEquals((long)socket3_RELEASECLAMPS, (long)item_.getSocket3_RELEASECLAMPS());
        Assert.assertEquals((long)socket3_UNLOCKCLAMPS, (long)item_.getSocket3_UNLOCKCLAMPS());
        Assert.assertEquals((long)socket3_clampXminus3_RELEASE, (long)item_.getSocket3_clampXminus3_RELEASE());
        Assert.assertEquals((long)socket3_clampXminus3_UNLOCK, (long)item_.getSocket3_clampXminus3_UNLOCK());
        Assert.assertEquals((long)socket3_clampXplus3_RELEASE, (long)item_.getSocket3_clampXplus3_RELEASE());
        Assert.assertEquals((long)socket3_clampXplus3_UNLOCK, (long)item_.getSocket3_clampXplus3_UNLOCK());
        Assert.assertEquals((long)socket4_RELEASECLAMPS, (long)item_.getSocket4_RELEASECLAMPS());
        Assert.assertEquals((long)socket4_UNLOCKCLAMPS, (long)item_.getSocket4_UNLOCKCLAMPS());
        Assert.assertEquals((long)socket4_clampXminus4_RELEASE, (long)item_.getSocket4_clampXminus4_RELEASE());
        Assert.assertEquals((long)socket4_clampXminus4_UNLOCK, (long)item_.getSocket4_clampXminus4_UNLOCK());
        Assert.assertEquals((long)socket4_clampXplus4_RELEASE, (long)item_.getSocket4_clampXplus4_RELEASE());
        Assert.assertEquals((long)socket4_clampXplus4_UNLOCK, (long)item_.getSocket4_clampXplus4_UNLOCK());
        Assert.assertEquals((long)socket5_RELEASECLAMPS, (long)item_.getSocket5_RELEASECLAMPS());
        Assert.assertEquals((long)socket5_UNLOCKCLAMPS, (long)item_.getSocket5_UNLOCKCLAMPS());
        Assert.assertEquals((long)socket5_clampXminus5_RELEASE, (long)item_.getSocket5_clampXminus5_RELEASE());
        Assert.assertEquals((long)socket5_clampXminus5_UNLOCK, (long)item_.getSocket5_clampXminus5_UNLOCK());
        Assert.assertEquals((long)socket5_clampXplus5_RELEASE, (long)item_.getSocket5_clampXplus5_RELEASE());
        Assert.assertEquals((long)socket5_clampXplus5_UNLOCK, (long)item_.getSocket5_clampXplus5_UNLOCK());
    }

    @Test
    public void sendReceiveFcs_Duration_Loader_TrendingTelemetry() throws Exception {
        long carrier_MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION = 269L;
        long carrier_MOVE_LOADERCARRIER_TO_ENGAGED = 419L;
        long carrier_MOVE_LOADERCARRIER_TO_HANDOFF = 77L;
        long carrier_MOVE_LOADERCARRIER_TO_STORAGE = 545L;
        long hooks_CLAMPLOADERHOOKS = 46L;
        long hooks_CLOSELOADERHOOKS = 415L;
        long hooks_OPENHOMINGLOADERHOOKS = 284L;
        long hooks_UNCLAMPLOADERHOOKS = 733L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Duration_Loader_TrendingTelemetry(carrier_MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION, carrier_MOVE_LOADERCARRIER_TO_ENGAGED, carrier_MOVE_LOADERCARRIER_TO_HANDOFF, carrier_MOVE_LOADERCARRIER_TO_STORAGE, hooks_CLAMPLOADERHOOKS, hooks_CLOSELOADERHOOKS, hooks_OPENHOMINGLOADERHOOKS, hooks_UNCLAMPLOADERHOOKS));
        Assert.assertTrue((boolean)(item instanceof Fcs_Duration_Loader_TrendingTelemetry));
        Fcs_Duration_Loader_TrendingTelemetry item_ = (Fcs_Duration_Loader_TrendingTelemetry)item;
        Assert.assertEquals((long)carrier_MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION, (long)item_.getCarrier_MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION());
        Assert.assertEquals((long)carrier_MOVE_LOADERCARRIER_TO_ENGAGED, (long)item_.getCarrier_MOVE_LOADERCARRIER_TO_ENGAGED());
        Assert.assertEquals((long)carrier_MOVE_LOADERCARRIER_TO_HANDOFF, (long)item_.getCarrier_MOVE_LOADERCARRIER_TO_HANDOFF());
        Assert.assertEquals((long)carrier_MOVE_LOADERCARRIER_TO_STORAGE, (long)item_.getCarrier_MOVE_LOADERCARRIER_TO_STORAGE());
        Assert.assertEquals((long)hooks_CLAMPLOADERHOOKS, (long)item_.getHooks_CLAMPLOADERHOOKS());
        Assert.assertEquals((long)hooks_CLOSELOADERHOOKS, (long)item_.getHooks_CLOSELOADERHOOKS());
        Assert.assertEquals((long)hooks_OPENHOMINGLOADERHOOKS, (long)item_.getHooks_OPENHOMINGLOADERHOOKS());
        Assert.assertEquals((long)hooks_UNCLAMPLOADERHOOKS, (long)item_.getHooks_UNCLAMPLOADERHOOKS());
    }

    @Test
    public void sendReceiveFcs_Duration_TrendingTelemetry() throws Exception {
        long sETFILTER = 121L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Duration_TrendingTelemetry(sETFILTER));
        Assert.assertTrue((boolean)(item instanceof Fcs_Duration_TrendingTelemetry));
        Fcs_Duration_TrendingTelemetry item_ = (Fcs_Duration_TrendingTelemetry)item;
        Assert.assertEquals((long)sETFILTER, (long)item_.getSETFILTER());
    }

    @Test
    public void sendReceiveFcs_Fcs_Mcm_TrendingTelemetry() throws Exception {
        String autochanger_trucks_location = "";
        int autochanger_trucks_position = 443;
        int filter_on_autochanger_id = 389;
        String filter_on_autochanger_name = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Fcs_Mcm_TrendingTelemetry(autochanger_trucks_location, autochanger_trucks_position, filter_on_autochanger_id, filter_on_autochanger_name));
        Assert.assertTrue((boolean)(item instanceof Fcs_Fcs_Mcm_TrendingTelemetry));
        Fcs_Fcs_Mcm_TrendingTelemetry item_ = (Fcs_Fcs_Mcm_TrendingTelemetry)item;
        Assert.assertEquals((Object)autochanger_trucks_location, (Object)item_.getAutochanger_trucks_location());
        Assert.assertEquals((long)autochanger_trucks_position, (long)item_.getAutochanger_trucks_position());
        Assert.assertEquals((long)filter_on_autochanger_id, (long)item_.getFilter_on_autochanger_id());
        Assert.assertEquals((Object)filter_on_autochanger_name, (Object)item_.getFilter_on_autochanger_name());
    }

    @Test
    public void sendReceiveFcs_Loader_Carrier_TrendingTelemetry() throws Exception {
        boolean atEngaged = false;
        boolean atHandoff = true;
        boolean atStorage = true;
        boolean controllerInError = true;
        boolean engagedSensorOn = false;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Loader_Carrier_TrendingTelemetry(atEngaged, atHandoff, atStorage, controllerInError, engagedSensorOn));
        Assert.assertTrue((boolean)(item instanceof Fcs_Loader_Carrier_TrendingTelemetry));
        Fcs_Loader_Carrier_TrendingTelemetry item_ = (Fcs_Loader_Carrier_TrendingTelemetry)item;
        Assert.assertEquals((Object)atEngaged, (Object)item_.isAtEngaged());
        Assert.assertEquals((Object)atHandoff, (Object)item_.isAtHandoff());
        Assert.assertEquals((Object)atStorage, (Object)item_.isAtStorage());
        Assert.assertEquals((Object)controllerInError, (Object)item_.isControllerInError());
        Assert.assertEquals((Object)engagedSensorOn, (Object)item_.isEngagedSensorOn());
    }

    @Test
    public void sendReceiveFcs_Loader_Hooks_TrendingTelemetry() throws Exception {
        boolean allHooksInStateCLOSED = true;
        String clampState = "w";
        boolean controllerInError = true;
        boolean forceClampedStatus = true;
        boolean forceOverClampedStatus = false;
        int forceSensorVoltage0 = 831;
        int forceSensorVoltage1 = 145;
        String forceStatus = "m";
        boolean forceUnclampedStatus = true;
        boolean forceUnderClampedStatus = false;
        boolean statuspublishedbyhook1_inError = true;
        boolean statuspublishedbyhook1_lockSensorValue = true;
        String statuspublishedbyhook1_lockStatus = "j";
        boolean statuspublishedbyhook1_unlockSensorValue = false;
        boolean statuspublishedbyhook2_inError = true;
        boolean statuspublishedbyhook2_lockSensorValue = true;
        String statuspublishedbyhook2_lockStatus = "j";
        boolean statuspublishedbyhook2_unlockSensorValue = true;
        boolean statuspublishedbyhook3_inError = false;
        boolean statuspublishedbyhook3_lockSensorValue = false;
        String statuspublishedbyhook3_lockStatus = "l";
        boolean statuspublishedbyhook3_unlockSensorValue = false;
        boolean statuspublishedbyhook4_inError = false;
        boolean statuspublishedbyhook4_lockSensorValue = false;
        String statuspublishedbyhook4_lockStatus = "z";
        boolean statuspublishedbyhook4_unlockSensorValue = true;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Loader_Hooks_TrendingTelemetry(allHooksInStateCLOSED, clampState, controllerInError, forceClampedStatus, forceOverClampedStatus, forceSensorVoltage0, forceSensorVoltage1, forceStatus, forceUnclampedStatus, forceUnderClampedStatus, statuspublishedbyhook1_inError, statuspublishedbyhook1_lockSensorValue, statuspublishedbyhook1_lockStatus, statuspublishedbyhook1_unlockSensorValue, statuspublishedbyhook2_inError, statuspublishedbyhook2_lockSensorValue, statuspublishedbyhook2_lockStatus, statuspublishedbyhook2_unlockSensorValue, statuspublishedbyhook3_inError, statuspublishedbyhook3_lockSensorValue, statuspublishedbyhook3_lockStatus, statuspublishedbyhook3_unlockSensorValue, statuspublishedbyhook4_inError, statuspublishedbyhook4_lockSensorValue, statuspublishedbyhook4_lockStatus, statuspublishedbyhook4_unlockSensorValue));
        Assert.assertTrue((boolean)(item instanceof Fcs_Loader_Hooks_TrendingTelemetry));
        Fcs_Loader_Hooks_TrendingTelemetry item_ = (Fcs_Loader_Hooks_TrendingTelemetry)item;
        Assert.assertEquals((Object)allHooksInStateCLOSED, (Object)item_.isAllHooksInStateCLOSED());
        Assert.assertEquals((Object)clampState, (Object)item_.getClampState());
        Assert.assertEquals((Object)controllerInError, (Object)item_.isControllerInError());
        Assert.assertEquals((Object)forceClampedStatus, (Object)item_.isForceClampedStatus());
        Assert.assertEquals((Object)forceOverClampedStatus, (Object)item_.isForceOverClampedStatus());
        Assert.assertEquals((long)forceSensorVoltage0, (long)item_.getForceSensorVoltage0());
        Assert.assertEquals((long)forceSensorVoltage1, (long)item_.getForceSensorVoltage1());
        Assert.assertEquals((Object)forceStatus, (Object)item_.getForceStatus());
        Assert.assertEquals((Object)forceUnclampedStatus, (Object)item_.isForceUnclampedStatus());
        Assert.assertEquals((Object)forceUnderClampedStatus, (Object)item_.isForceUnderClampedStatus());
        Assert.assertEquals((Object)statuspublishedbyhook1_inError, (Object)item_.isStatuspublishedbyhook1_inError());
        Assert.assertEquals((Object)statuspublishedbyhook1_lockSensorValue, (Object)item_.isStatuspublishedbyhook1_lockSensorValue());
        Assert.assertEquals((Object)statuspublishedbyhook1_lockStatus, (Object)item_.getStatuspublishedbyhook1_lockStatus());
        Assert.assertEquals((Object)statuspublishedbyhook1_unlockSensorValue, (Object)item_.isStatuspublishedbyhook1_unlockSensorValue());
        Assert.assertEquals((Object)statuspublishedbyhook2_inError, (Object)item_.isStatuspublishedbyhook2_inError());
        Assert.assertEquals((Object)statuspublishedbyhook2_lockSensorValue, (Object)item_.isStatuspublishedbyhook2_lockSensorValue());
        Assert.assertEquals((Object)statuspublishedbyhook2_lockStatus, (Object)item_.getStatuspublishedbyhook2_lockStatus());
        Assert.assertEquals((Object)statuspublishedbyhook2_unlockSensorValue, (Object)item_.isStatuspublishedbyhook2_unlockSensorValue());
        Assert.assertEquals((Object)statuspublishedbyhook3_inError, (Object)item_.isStatuspublishedbyhook3_inError());
        Assert.assertEquals((Object)statuspublishedbyhook3_lockSensorValue, (Object)item_.isStatuspublishedbyhook3_lockSensorValue());
        Assert.assertEquals((Object)statuspublishedbyhook3_lockStatus, (Object)item_.getStatuspublishedbyhook3_lockStatus());
        Assert.assertEquals((Object)statuspublishedbyhook3_unlockSensorValue, (Object)item_.isStatuspublishedbyhook3_unlockSensorValue());
        Assert.assertEquals((Object)statuspublishedbyhook4_inError, (Object)item_.isStatuspublishedbyhook4_inError());
        Assert.assertEquals((Object)statuspublishedbyhook4_lockSensorValue, (Object)item_.isStatuspublishedbyhook4_lockSensorValue());
        Assert.assertEquals((Object)statuspublishedbyhook4_lockStatus, (Object)item_.getStatuspublishedbyhook4_lockStatus());
        Assert.assertEquals((Object)statuspublishedbyhook4_unlockSensorValue, (Object)item_.isStatuspublishedbyhook4_unlockSensorValue());
    }

    @Test
    public void sendReceiveFcs_TrendingTelemetry() throws Exception {
        int canbus0 = 878;
        int canbus1 = 887;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_TrendingTelemetry(canbus0, canbus1));
        Assert.assertTrue((boolean)(item instanceof Fcs_TrendingTelemetry));
        Fcs_TrendingTelemetry item_ = (Fcs_TrendingTelemetry)item;
        Assert.assertEquals((long)canbus0, (long)item_.getCanbus0());
        Assert.assertEquals((long)canbus1, (long)item_.getCanbus1());
    }

    @Test
    public void sendReceiveShutter_TrendingTelemetry() throws Exception {
        double shutterstatus_axstatus_MINUSX_actPos = 0.7309850454330444;
        double shutterstatus_axstatus_MINUSX_actVel = 0.6179461479187012;
        int shutterstatus_axstatus_MINUSX_brakeEngaged = 899;
        double shutterstatus_axstatus_MINUSX_ctrlTemp = 0.7961078882217407;
        int shutterstatus_axstatus_MINUSX_enabled = 969;
        int shutterstatus_axstatus_MINUSX_errorID = 45;
        int shutterstatus_axstatus_MINUSX_hasSafeTemp = 565;
        int shutterstatus_axstatus_MINUSX_highLimit = 98;
        int shutterstatus_axstatus_MINUSX_isHomed = 865;
        int shutterstatus_axstatus_MINUSX_lowLimit = 305;
        double shutterstatus_axstatus_MINUSX_setAcc = 0.29538804292678833;
        double shutterstatus_axstatus_PLUSX_actPos = 0.8473324179649353;
        double shutterstatus_axstatus_PLUSX_actVel = 0.8338084816932678;
        int shutterstatus_axstatus_PLUSX_brakeEngaged = 947;
        double shutterstatus_axstatus_PLUSX_ctrlTemp = 0.405303418636322;
        int shutterstatus_axstatus_PLUSX_enabled = 792;
        int shutterstatus_axstatus_PLUSX_errorID = 862;
        int shutterstatus_axstatus_PLUSX_hasSafeTemp = 527;
        int shutterstatus_axstatus_PLUSX_highLimit = 655;
        int shutterstatus_axstatus_PLUSX_isHomed = 49;
        int shutterstatus_axstatus_PLUSX_lowLimit = 6;
        double shutterstatus_axstatus_PLUSX_setAcc = 0.19395703077316284;
        int shutterstatus_isCalibrated = 541;
        int shutterstatus_isSafetyOn = 266;
        int shutterstatus_motionProfile = 551;
        int shutterstatus_smState = 539;
        int shutterstatus_tempIsSafe_CONTROL_BOX = 697;
        int shutterstatus_tempIsSafe_MINUSX_MOTOR = 189;
        int shutterstatus_tempIsSafe_PLUSX_MOTOR = 149;
        double shutterstatus_temperature_CONTROL_BOX = 0.5631012916564941;
        double shutterstatus_temperature_MINUSX_MOTOR = 0.608004093170166;
        double shutterstatus_temperature_PLUSX_MOTOR = 0.9861311316490173;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Shutter_TrendingTelemetry(shutterstatus_axstatus_MINUSX_actPos, shutterstatus_axstatus_MINUSX_actVel, shutterstatus_axstatus_MINUSX_brakeEngaged, shutterstatus_axstatus_MINUSX_ctrlTemp, shutterstatus_axstatus_MINUSX_enabled, shutterstatus_axstatus_MINUSX_errorID, shutterstatus_axstatus_MINUSX_hasSafeTemp, shutterstatus_axstatus_MINUSX_highLimit, shutterstatus_axstatus_MINUSX_isHomed, shutterstatus_axstatus_MINUSX_lowLimit, shutterstatus_axstatus_MINUSX_setAcc, shutterstatus_axstatus_PLUSX_actPos, shutterstatus_axstatus_PLUSX_actVel, shutterstatus_axstatus_PLUSX_brakeEngaged, shutterstatus_axstatus_PLUSX_ctrlTemp, shutterstatus_axstatus_PLUSX_enabled, shutterstatus_axstatus_PLUSX_errorID, shutterstatus_axstatus_PLUSX_hasSafeTemp, shutterstatus_axstatus_PLUSX_highLimit, shutterstatus_axstatus_PLUSX_isHomed, shutterstatus_axstatus_PLUSX_lowLimit, shutterstatus_axstatus_PLUSX_setAcc, shutterstatus_isCalibrated, shutterstatus_isSafetyOn, shutterstatus_motionProfile, shutterstatus_smState, shutterstatus_tempIsSafe_CONTROL_BOX, shutterstatus_tempIsSafe_MINUSX_MOTOR, shutterstatus_tempIsSafe_PLUSX_MOTOR, shutterstatus_temperature_CONTROL_BOX, shutterstatus_temperature_MINUSX_MOTOR, shutterstatus_temperature_PLUSX_MOTOR));
        Assert.assertTrue((boolean)(item instanceof Shutter_TrendingTelemetry));
        Shutter_TrendingTelemetry item_ = (Shutter_TrendingTelemetry)item;
        Assert.assertEquals((double)shutterstatus_axstatus_MINUSX_actPos, (double)item_.getShutterstatus_axstatus_MINUSX_actPos(), (double)1.0E-6f);
        Assert.assertEquals((double)shutterstatus_axstatus_MINUSX_actVel, (double)item_.getShutterstatus_axstatus_MINUSX_actVel(), (double)1.0E-6f);
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_brakeEngaged, (long)item_.getShutterstatus_axstatus_MINUSX_brakeEngaged());
        Assert.assertEquals((double)shutterstatus_axstatus_MINUSX_ctrlTemp, (double)item_.getShutterstatus_axstatus_MINUSX_ctrlTemp(), (double)1.0E-6f);
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_enabled, (long)item_.getShutterstatus_axstatus_MINUSX_enabled());
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_errorID, (long)item_.getShutterstatus_axstatus_MINUSX_errorID());
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_hasSafeTemp, (long)item_.getShutterstatus_axstatus_MINUSX_hasSafeTemp());
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_highLimit, (long)item_.getShutterstatus_axstatus_MINUSX_highLimit());
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_isHomed, (long)item_.getShutterstatus_axstatus_MINUSX_isHomed());
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_lowLimit, (long)item_.getShutterstatus_axstatus_MINUSX_lowLimit());
        Assert.assertEquals((double)shutterstatus_axstatus_MINUSX_setAcc, (double)item_.getShutterstatus_axstatus_MINUSX_setAcc(), (double)1.0E-6f);
        Assert.assertEquals((double)shutterstatus_axstatus_PLUSX_actPos, (double)item_.getShutterstatus_axstatus_PLUSX_actPos(), (double)1.0E-6f);
        Assert.assertEquals((double)shutterstatus_axstatus_PLUSX_actVel, (double)item_.getShutterstatus_axstatus_PLUSX_actVel(), (double)1.0E-6f);
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_brakeEngaged, (long)item_.getShutterstatus_axstatus_PLUSX_brakeEngaged());
        Assert.assertEquals((double)shutterstatus_axstatus_PLUSX_ctrlTemp, (double)item_.getShutterstatus_axstatus_PLUSX_ctrlTemp(), (double)1.0E-6f);
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_enabled, (long)item_.getShutterstatus_axstatus_PLUSX_enabled());
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_errorID, (long)item_.getShutterstatus_axstatus_PLUSX_errorID());
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_hasSafeTemp, (long)item_.getShutterstatus_axstatus_PLUSX_hasSafeTemp());
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_highLimit, (long)item_.getShutterstatus_axstatus_PLUSX_highLimit());
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_isHomed, (long)item_.getShutterstatus_axstatus_PLUSX_isHomed());
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_lowLimit, (long)item_.getShutterstatus_axstatus_PLUSX_lowLimit());
        Assert.assertEquals((double)shutterstatus_axstatus_PLUSX_setAcc, (double)item_.getShutterstatus_axstatus_PLUSX_setAcc(), (double)1.0E-6f);
        Assert.assertEquals((long)shutterstatus_isCalibrated, (long)item_.getShutterstatus_isCalibrated());
        Assert.assertEquals((long)shutterstatus_isSafetyOn, (long)item_.getShutterstatus_isSafetyOn());
        Assert.assertEquals((long)shutterstatus_motionProfile, (long)item_.getShutterstatus_motionProfile());
        Assert.assertEquals((long)shutterstatus_smState, (long)item_.getShutterstatus_smState());
        Assert.assertEquals((long)shutterstatus_tempIsSafe_CONTROL_BOX, (long)item_.getShutterstatus_tempIsSafe_CONTROL_BOX());
        Assert.assertEquals((long)shutterstatus_tempIsSafe_MINUSX_MOTOR, (long)item_.getShutterstatus_tempIsSafe_MINUSX_MOTOR());
        Assert.assertEquals((long)shutterstatus_tempIsSafe_PLUSX_MOTOR, (long)item_.getShutterstatus_tempIsSafe_PLUSX_MOTOR());
        Assert.assertEquals((double)shutterstatus_temperature_CONTROL_BOX, (double)item_.getShutterstatus_temperature_CONTROL_BOX(), (double)1.0E-6f);
        Assert.assertEquals((double)shutterstatus_temperature_MINUSX_MOTOR, (double)item_.getShutterstatus_temperature_MINUSX_MOTOR(), (double)1.0E-6f);
        Assert.assertEquals((double)shutterstatus_temperature_PLUSX_MOTOR, (double)item_.getShutterstatus_temperature_PLUSX_MOTOR(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveChiller_ChillerTelemetry() throws Exception {
        double chillerPumpLife = 0.3039160370826721;
        double chillerValveAct = 0.9787943959236145;
        double compressorLife = 0.23825335502624512;
        double controllerLife = 0.759335994720459;
        double coolPercentage = 0.1105089783668518;
        double flowRate = 0.9210597276687622;
        double flowSetPoint = 0.9468511343002319;
        double fluidTemperature = 0.3025868535041809;
        double heatPercentage = 0.41682547330856323;
        double importedColdTemp = 0.02113097906112671;
        double pressureIn = 0.2932738661766052;
        double pressureOut = 0.10521078109741211;
        double pressureTank = 0.2363465428352356;
        double tankSetPoint = 0.14390015602111816;
        double tempCondenser = 0.6882686614990234;
        double tempDUTInput = 0.8476573824882507;
        double tempDynamicSetPt = 0.6665184497833252;
        double tempSetPoint = 0.8498090505599976;
        double tempStage2Evap = 0.24881380796432495;
        double tempTXVBulb = 0.24697858095169067;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Chiller_ChillerTelemetry(chillerPumpLife, chillerValveAct, compressorLife, controllerLife, coolPercentage, flowRate, flowSetPoint, fluidTemperature, heatPercentage, importedColdTemp, pressureIn, pressureOut, pressureTank, tankSetPoint, tempCondenser, tempDUTInput, tempDynamicSetPt, tempSetPoint, tempStage2Evap, tempTXVBulb));
        Assert.assertTrue((boolean)(item instanceof Chiller_ChillerTelemetry));
        Chiller_ChillerTelemetry item_ = (Chiller_ChillerTelemetry)item;
        Assert.assertEquals((double)chillerPumpLife, (double)item_.getChillerPumpLife(), (double)1.0E-6f);
        Assert.assertEquals((double)chillerValveAct, (double)item_.getChillerValveAct(), (double)1.0E-6f);
        Assert.assertEquals((double)compressorLife, (double)item_.getCompressorLife(), (double)1.0E-6f);
        Assert.assertEquals((double)controllerLife, (double)item_.getControllerLife(), (double)1.0E-6f);
        Assert.assertEquals((double)coolPercentage, (double)item_.getCoolPercentage(), (double)1.0E-6f);
        Assert.assertEquals((double)flowRate, (double)item_.getFlowRate(), (double)1.0E-6f);
        Assert.assertEquals((double)flowSetPoint, (double)item_.getFlowSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((double)fluidTemperature, (double)item_.getFluidTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)heatPercentage, (double)item_.getHeatPercentage(), (double)1.0E-6f);
        Assert.assertEquals((double)importedColdTemp, (double)item_.getImportedColdTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)pressureIn, (double)item_.getPressureIn(), (double)1.0E-6f);
        Assert.assertEquals((double)pressureOut, (double)item_.getPressureOut(), (double)1.0E-6f);
        Assert.assertEquals((double)pressureTank, (double)item_.getPressureTank(), (double)1.0E-6f);
        Assert.assertEquals((double)tankSetPoint, (double)item_.getTankSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((double)tempCondenser, (double)item_.getTempCondenser(), (double)1.0E-6f);
        Assert.assertEquals((double)tempDUTInput, (double)item_.getTempDUTInput(), (double)1.0E-6f);
        Assert.assertEquals((double)tempDynamicSetPt, (double)item_.getTempDynamicSetPt(), (double)1.0E-6f);
        Assert.assertEquals((double)tempSetPoint, (double)item_.getTempSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((double)tempStage2Evap, (double)item_.getTempStage2Evap(), (double)1.0E-6f);
        Assert.assertEquals((double)tempTXVBulb, (double)item_.getTempTXVBulb(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveChiller_FParam_TrendingTelemetry() throws Exception {
        double bubblev_TIME = 0.9270090460777283;
        double clr_KI_SETPT = 0.5507165193557739;
        double cold_PERIOD = 0.4291202425956726;
        double cool_CAPACITY = 0.31646376848220825;
        double dut_DT_HI = 0.14046591520309448;
        double dut_DT_LO = 0.10621833801269531;
        double dut_KI = 0.7622305154800415;
        double dut_KP = 0.8990662097930908;
        double dut_TMAX = 0.949695885181427;
        double dut_TMIN = 0.2943531274795532;
        double flowmeter_LO = 0.5089951753616333;
        double flow_ERR_MASK = 0.4099313020706177;
        double heat_CAPACITY = 0.8896225690841675;
        double pid_GAINFAC = 0.256908655166626;
        double pid_KD = 0.1336471438407898;
        double pid_KI = 0.3564424514770508;
        double pid_KP = 0.7358787655830383;
        double ramp_DEFAULT = 0.2476483f;
        double refrig_OFF = 0.35570287704467773;
        double setpt_SETTLE = 0.11056089401245117;
        double setpt_TOL = 0.3588717579841614;
        double tank_SETPOINT = 0.462848424911499;
        double thermsl_MASS = 0.6299748420715332;
        double t_CTRL_MODE = 0.5067963600158691;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Chiller_FParam_TrendingTelemetry(bubblev_TIME, clr_KI_SETPT, cold_PERIOD, cool_CAPACITY, dut_DT_HI, dut_DT_LO, dut_KI, dut_KP, dut_TMAX, dut_TMIN, flowmeter_LO, flow_ERR_MASK, heat_CAPACITY, pid_GAINFAC, pid_KD, pid_KI, pid_KP, ramp_DEFAULT, refrig_OFF, setpt_SETTLE, setpt_TOL, tank_SETPOINT, thermsl_MASS, t_CTRL_MODE));
        Assert.assertTrue((boolean)(item instanceof Chiller_FParam_TrendingTelemetry));
        Chiller_FParam_TrendingTelemetry item_ = (Chiller_FParam_TrendingTelemetry)item;
        Assert.assertEquals((double)bubblev_TIME, (double)item_.getBubblev_TIME(), (double)1.0E-6f);
        Assert.assertEquals((double)clr_KI_SETPT, (double)item_.getClr_KI_SETPT(), (double)1.0E-6f);
        Assert.assertEquals((double)cold_PERIOD, (double)item_.getCold_PERIOD(), (double)1.0E-6f);
        Assert.assertEquals((double)cool_CAPACITY, (double)item_.getCool_CAPACITY(), (double)1.0E-6f);
        Assert.assertEquals((double)dut_DT_HI, (double)item_.getDut_DT_HI(), (double)1.0E-6f);
        Assert.assertEquals((double)dut_DT_LO, (double)item_.getDut_DT_LO(), (double)1.0E-6f);
        Assert.assertEquals((double)dut_KI, (double)item_.getDut_KI(), (double)1.0E-6f);
        Assert.assertEquals((double)dut_KP, (double)item_.getDut_KP(), (double)1.0E-6f);
        Assert.assertEquals((double)dut_TMAX, (double)item_.getDut_TMAX(), (double)1.0E-6f);
        Assert.assertEquals((double)dut_TMIN, (double)item_.getDut_TMIN(), (double)1.0E-6f);
        Assert.assertEquals((double)flowmeter_LO, (double)item_.getFlowmeter_LO(), (double)1.0E-6f);
        Assert.assertEquals((double)flow_ERR_MASK, (double)item_.getFlow_ERR_MASK(), (double)1.0E-6f);
        Assert.assertEquals((double)heat_CAPACITY, (double)item_.getHeat_CAPACITY(), (double)1.0E-6f);
        Assert.assertEquals((double)pid_GAINFAC, (double)item_.getPid_GAINFAC(), (double)1.0E-6f);
        Assert.assertEquals((double)pid_KD, (double)item_.getPid_KD(), (double)1.0E-6f);
        Assert.assertEquals((double)pid_KI, (double)item_.getPid_KI(), (double)1.0E-6f);
        Assert.assertEquals((double)pid_KP, (double)item_.getPid_KP(), (double)1.0E-6f);
        Assert.assertEquals((double)ramp_DEFAULT, (double)item_.getRamp_DEFAULT(), (double)1.0E-6f);
        Assert.assertEquals((double)refrig_OFF, (double)item_.getRefrig_OFF(), (double)1.0E-6f);
        Assert.assertEquals((double)setpt_SETTLE, (double)item_.getSetpt_SETTLE(), (double)1.0E-6f);
        Assert.assertEquals((double)setpt_TOL, (double)item_.getSetpt_TOL(), (double)1.0E-6f);
        Assert.assertEquals((double)tank_SETPOINT, (double)item_.getTank_SETPOINT(), (double)1.0E-6f);
        Assert.assertEquals((double)thermsl_MASS, (double)item_.getThermsl_MASS(), (double)1.0E-6f);
        Assert.assertEquals((double)t_CTRL_MODE, (double)item_.getT_CTRL_MODE(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveChiller_Maq20Telemetry() throws Exception {
        double ambientTemp = 0.5876566171646118;
        double coolantHXOut = 0.3968232274055481;
        double coolantPumpIn = 0.6091803908348083;
        double coolantPumpOut = 0.5019757747650146;
        double coolantReturn = 0.2876335382461548;
        double coolantSupply = 0.6080055236816406;
        double glycChillerIn = 0.7917084097862244;
        double glycChillerOut = 0.43527287244796753;
        double glycCondensOut = 0.9762369394302368;
        double glycDeSuHtrOut = 0.3991520404815674;
        double glycFanIn = 0.7609034776687622;
        double glycFanOut = 0.3970431685447693;
        double glycHeatXfer = 0.42832082509994507;
        double glycInputFlow = 0.18198204040527344;
        double pBurstReturn = 0.3077316880226135;
        double pBurstSupply = 0.08432018756866455;
        double stg1CondensOut = 0.5854048132896423;
        double stg1Discharge = 0.013805627822875977;
        double stg1Return = 0.1874944567680359;
        double stg1TXVBulb = 0.9739436507225037;
        double stg2DeSuHtrOut = 0.7984967827796936;
        double stg2Discharge = 0.3413194417953491;
        double stg2DischargeP = 0.20059436559677124;
        double stg2EvapIn = 0.06889933347702026;
        double stg2EvapOut = 0.7616328597068787;
        double stg2Return = 0.5727697610855103;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Chiller_Maq20Telemetry(ambientTemp, coolantHXOut, coolantPumpIn, coolantPumpOut, coolantReturn, coolantSupply, glycChillerIn, glycChillerOut, glycCondensOut, glycDeSuHtrOut, glycFanIn, glycFanOut, glycHeatXfer, glycInputFlow, pBurstReturn, pBurstSupply, stg1CondensOut, stg1Discharge, stg1Return, stg1TXVBulb, stg2DeSuHtrOut, stg2Discharge, stg2DischargeP, stg2EvapIn, stg2EvapOut, stg2Return));
        Assert.assertTrue((boolean)(item instanceof Chiller_Maq20Telemetry));
        Chiller_Maq20Telemetry item_ = (Chiller_Maq20Telemetry)item;
        Assert.assertEquals((double)ambientTemp, (double)item_.getAmbientTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantHXOut, (double)item_.getCoolantHXOut(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantPumpIn, (double)item_.getCoolantPumpIn(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantPumpOut, (double)item_.getCoolantPumpOut(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantReturn, (double)item_.getCoolantReturn(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantSupply, (double)item_.getCoolantSupply(), (double)1.0E-6f);
        Assert.assertEquals((double)glycChillerIn, (double)item_.getGlycChillerIn(), (double)1.0E-6f);
        Assert.assertEquals((double)glycChillerOut, (double)item_.getGlycChillerOut(), (double)1.0E-6f);
        Assert.assertEquals((double)glycCondensOut, (double)item_.getGlycCondensOut(), (double)1.0E-6f);
        Assert.assertEquals((double)glycDeSuHtrOut, (double)item_.getGlycDeSuHtrOut(), (double)1.0E-6f);
        Assert.assertEquals((double)glycFanIn, (double)item_.getGlycFanIn(), (double)1.0E-6f);
        Assert.assertEquals((double)glycFanOut, (double)item_.getGlycFanOut(), (double)1.0E-6f);
        Assert.assertEquals((double)glycHeatXfer, (double)item_.getGlycHeatXfer(), (double)1.0E-6f);
        Assert.assertEquals((double)glycInputFlow, (double)item_.getGlycInputFlow(), (double)1.0E-6f);
        Assert.assertEquals((double)pBurstReturn, (double)item_.getPBurstReturn(), (double)1.0E-6f);
        Assert.assertEquals((double)pBurstSupply, (double)item_.getPBurstSupply(), (double)1.0E-6f);
        Assert.assertEquals((double)stg1CondensOut, (double)item_.getStg1CondensOut(), (double)1.0E-6f);
        Assert.assertEquals((double)stg1Discharge, (double)item_.getStg1Discharge(), (double)1.0E-6f);
        Assert.assertEquals((double)stg1Return, (double)item_.getStg1Return(), (double)1.0E-6f);
        Assert.assertEquals((double)stg1TXVBulb, (double)item_.getStg1TXVBulb(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2DeSuHtrOut, (double)item_.getStg2DeSuHtrOut(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2Discharge, (double)item_.getStg2Discharge(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2DischargeP, (double)item_.getStg2DischargeP(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2EvapIn, (double)item_.getStg2EvapIn(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2EvapOut, (double)item_.getStg2EvapOut(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2Return, (double)item_.getStg2Return(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveThermal_Cold_TempTelemetry() throws Exception {
        double avgColdTemp = 0.8800707459449768;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Thermal_Cold_TempTelemetry(avgColdTemp));
        Assert.assertTrue((boolean)(item instanceof Thermal_Cold_TempTelemetry));
        Thermal_Cold_TempTelemetry item_ = (Thermal_Cold_TempTelemetry)item;
        Assert.assertEquals((double)avgColdTemp, (double)item_.getAvgColdTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveThermal_Cryo_TempTelemetry() throws Exception {
        double avgCryoTemp = 0.21037834882736206;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Thermal_Cryo_TempTelemetry(avgCryoTemp));
        Assert.assertTrue((boolean)(item instanceof Thermal_Cryo_TempTelemetry));
        Thermal_Cryo_TempTelemetry item_ = (Thermal_Cryo_TempTelemetry)item;
        Assert.assertEquals((double)avgCryoTemp, (double)item_.getAvgCryoTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveThermal_RtdTelemetry() throws Exception {
        double[] cold_Temp = TestHelper.generateDoubleArray((int)20, (int)352170527);
        double[] cryo_Temp = TestHelper.generateDoubleArray((int)20, (int)43901360);
        double[] grid_Temp = TestHelper.generateDoubleArray((int)20, (int)13739453);
        String location = "d";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Thermal_RtdTelemetry(cold_Temp, cryo_Temp, grid_Temp, location));
        Assert.assertTrue((boolean)(item instanceof Thermal_RtdTelemetry));
        Thermal_RtdTelemetry item_ = (Thermal_RtdTelemetry)item;
        Assert.assertArrayEquals((double[])cold_Temp, (double[])item_.getCold_Temp(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_Temp, (double[])item_.getCryo_Temp(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])grid_Temp, (double[])item_.getGrid_Temp(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveThermal_TrimTelemetry() throws Exception {
        String location = "c";
        double[] trim_Htrs_I = TestHelper.generateDoubleArray((int)12, (int)657891869);
        double[] trim_Htrs_P = TestHelper.generateDoubleArray((int)12, (int)966112063);
        double[] trim_Htrs_V = TestHelper.generateDoubleArray((int)12, (int)1390827665);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Thermal_TrimTelemetry(location, trim_Htrs_I, trim_Htrs_P, trim_Htrs_V));
        Assert.assertTrue((boolean)(item instanceof Thermal_TrimTelemetry));
        Thermal_TrimTelemetry item_ = (Thermal_TrimTelemetry)item;
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])trim_Htrs_I, (double[])item_.getTrim_Htrs_I(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Htrs_P, (double[])item_.getTrim_Htrs_P(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Htrs_V, (double[])item_.getTrim_Htrs_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveThermal_Trim_HtrsTelemetry() throws Exception {
        double coldtotal_P = 0.32756322622299194;
        double cryototal_P = 0.9496131539344788;
        double htrBulkTmp = 0.7465482354164124;
        double htrbulk_I = 0.34145092964172363;
        double htrbulk_P = 0.37691646814346313;
        double htrbulk_V = 0.9638907313346863;
        double htrPsTmp = 0.234491229057312;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Thermal_Trim_HtrsTelemetry(coldtotal_P, cryototal_P, htrBulkTmp, htrbulk_I, htrbulk_P, htrbulk_V, htrPsTmp));
        Assert.assertTrue((boolean)(item instanceof Thermal_Trim_HtrsTelemetry));
        Thermal_Trim_HtrsTelemetry item_ = (Thermal_Trim_HtrsTelemetry)item;
        Assert.assertEquals((double)coldtotal_P, (double)item_.getColdtotal_P(), (double)1.0E-6f);
        Assert.assertEquals((double)cryototal_P, (double)item_.getCryototal_P(), (double)1.0E-6f);
        Assert.assertEquals((double)htrBulkTmp, (double)item_.getHtrBulkTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)htrbulk_I, (double)item_.getHtrbulk_I(), (double)1.0E-6f);
        Assert.assertEquals((double)htrbulk_P, (double)item_.getHtrbulk_P(), (double)1.0E-6f);
        Assert.assertEquals((double)htrbulk_V, (double)item_.getHtrbulk_V(), (double)1.0E-6f);
        Assert.assertEquals((double)htrPsTmp, (double)item_.getHtrPsTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_BodyTelemetry() throws Exception {
        double ambAirtemp = 0.0657962f;
        double averageTemp = 0.7273004651069641;
        double backFlngXMinusTemp = 0.6417178511619568;
        double backFlngXPlusTemp = 0.8696505427360535;
        double backFlngYMinusTemp = 0.8014907240867615;
        double camBodyXPlusTemp = 0.8320274353027344;
        double camBodyYMinusTemp = 0.2405148148536682;
        double camBodyYPlusTemp = 0.6813452839851379;
        double camHousXMinusTemp = 0.006854236125946045;
        double camHousXPlusTemp = 0.03768497705459595;
        double camHousYMinusTemp = 0.5266118049621582;
        double camHousYPlusTemp = 0.3479401469230652;
        double chgrYMinusRtnAirTemp = 0.6519877910614014;
        double chgrYMinusRtnAirVel = 0.7564423680305481;
        double domeXMinusTemp = 0.33132725954055786;
        double domeYMinusTemp = 0.4313966f;
        double l1XMinusTemp = 0.21207916736602783;
        double l1YMinusTemp = 0.44064861536026;
        double l2XMinusTemp = 0.4272640347480774;
        double l2XPlusTemp = 0.8109055161476135;
        double l2YMinusTemp = 0.2599042057991028;
        double l2YPlusTemp = 0.9547948241233826;
        double shrdRngXMinusTemp = 0.22887331247329712;
        double shrdRngXPlusTemp = 0.687648f;
        double shrdRngYMinusTemp = 0.45208728313446045;
        double shrdRngYPlusTemp = 0.3467797636985779;
        double shtrEboxRtnAirTemp = 0.3316415548324585;
        double shtrEboxRtnAirVel = 0.8257326483726501;
        double shtrMtrRtnAirTemp = 0.6625066995620728;
        double shtrMtrRtnAirVel = 0.8736305236816406;
        double vPPlenumInTemp = 0.1604672074317932;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Utiltrunk_BodyTelemetry(ambAirtemp, averageTemp, backFlngXMinusTemp, backFlngXPlusTemp, backFlngYMinusTemp, camBodyXPlusTemp, camBodyYMinusTemp, camBodyYPlusTemp, camHousXMinusTemp, camHousXPlusTemp, camHousYMinusTemp, camHousYPlusTemp, chgrYMinusRtnAirTemp, chgrYMinusRtnAirVel, domeXMinusTemp, domeYMinusTemp, l1XMinusTemp, l1YMinusTemp, l2XMinusTemp, l2XPlusTemp, l2YMinusTemp, l2YPlusTemp, shrdRngXMinusTemp, shrdRngXPlusTemp, shrdRngYMinusTemp, shrdRngYPlusTemp, shtrEboxRtnAirTemp, shtrEboxRtnAirVel, shtrMtrRtnAirTemp, shtrMtrRtnAirVel, vPPlenumInTemp));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_BodyTelemetry));
        Utiltrunk_BodyTelemetry item_ = (Utiltrunk_BodyTelemetry)item;
        Assert.assertEquals((double)ambAirtemp, (double)item_.getAmbAirtemp(), (double)1.0E-6f);
        Assert.assertEquals((double)averageTemp, (double)item_.getAverageTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)backFlngXMinusTemp, (double)item_.getBackFlngXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)backFlngXPlusTemp, (double)item_.getBackFlngXPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)backFlngYMinusTemp, (double)item_.getBackFlngYMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)camBodyXPlusTemp, (double)item_.getCamBodyXPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)camBodyYMinusTemp, (double)item_.getCamBodyYMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)camBodyYPlusTemp, (double)item_.getCamBodyYPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)camHousXMinusTemp, (double)item_.getCamHousXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)camHousXPlusTemp, (double)item_.getCamHousXPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)camHousYMinusTemp, (double)item_.getCamHousYMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)camHousYPlusTemp, (double)item_.getCamHousYPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)chgrYMinusRtnAirTemp, (double)item_.getChgrYMinusRtnAirTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)chgrYMinusRtnAirVel, (double)item_.getChgrYMinusRtnAirVel(), (double)1.0E-6f);
        Assert.assertEquals((double)domeXMinusTemp, (double)item_.getDomeXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)domeYMinusTemp, (double)item_.getDomeYMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)l1XMinusTemp, (double)item_.getL1XMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)l1YMinusTemp, (double)item_.getL1YMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)l2XMinusTemp, (double)item_.getL2XMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)l2XPlusTemp, (double)item_.getL2XPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)l2YMinusTemp, (double)item_.getL2YMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)l2YPlusTemp, (double)item_.getL2YPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)shrdRngXMinusTemp, (double)item_.getShrdRngXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)shrdRngXPlusTemp, (double)item_.getShrdRngXPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)shrdRngYMinusTemp, (double)item_.getShrdRngYMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)shrdRngYPlusTemp, (double)item_.getShrdRngYPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)shtrEboxRtnAirTemp, (double)item_.getShtrEboxRtnAirTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)shtrEboxRtnAirVel, (double)item_.getShtrEboxRtnAirVel(), (double)1.0E-6f);
        Assert.assertEquals((double)shtrMtrRtnAirTemp, (double)item_.getShtrMtrRtnAirTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)shtrMtrRtnAirVel, (double)item_.getShtrMtrRtnAirVel(), (double)1.0E-6f);
        Assert.assertEquals((double)vPPlenumInTemp, (double)item_.getVPPlenumInTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_MPCTelemetry() throws Exception {
        double avgAirtempOut = 0.5103719234466553;
        double deltaPressFilt = 0.8269177675247192;
        double deltaPressTotal = 0.8123723268508911;
        double deltaTempAct = 0.4813665747642517;
        double fanRunTime = 0.020921528339385986;
        double fanSpeed = 0.7771791815757751;
        double humidity = 0.22620874643325806;
        double preFiltPress = 0.17614257335662842;
        double retnAirTemp = 0.6016849279403687;
        double retnPress = 0.5912918448448181;
        double splyAirTemp = 0.61680006980896;
        double splyPress = 0.12476956844329834;
        double valvePosn = 0.9761613607406616;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Utiltrunk_MPCTelemetry(avgAirtempOut, deltaPressFilt, deltaPressTotal, deltaTempAct, fanRunTime, fanSpeed, humidity, preFiltPress, retnAirTemp, retnPress, splyAirTemp, splyPress, valvePosn));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_MPCTelemetry));
        Utiltrunk_MPCTelemetry item_ = (Utiltrunk_MPCTelemetry)item;
        Assert.assertEquals((double)avgAirtempOut, (double)item_.getAvgAirtempOut(), (double)1.0E-6f);
        Assert.assertEquals((double)deltaPressFilt, (double)item_.getDeltaPressFilt(), (double)1.0E-6f);
        Assert.assertEquals((double)deltaPressTotal, (double)item_.getDeltaPressTotal(), (double)1.0E-6f);
        Assert.assertEquals((double)deltaTempAct, (double)item_.getDeltaTempAct(), (double)1.0E-6f);
        Assert.assertEquals((double)fanRunTime, (double)item_.getFanRunTime(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)humidity, (double)item_.getHumidity(), (double)1.0E-6f);
        Assert.assertEquals((double)preFiltPress, (double)item_.getPreFiltPress(), (double)1.0E-6f);
        Assert.assertEquals((double)retnAirTemp, (double)item_.getRetnAirTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)retnPress, (double)item_.getRetnPress(), (double)1.0E-6f);
        Assert.assertEquals((double)splyAirTemp, (double)item_.getSplyAirTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)splyPress, (double)item_.getSplyPress(), (double)1.0E-6f);
        Assert.assertEquals((double)valvePosn, (double)item_.getValvePosn(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_UTTelemetry() throws Exception {
        double averageTemp = 0.2247957f;
        double coolFlowRate = 0.69805508852005;
        double coolPipeRetnTemp = 0.8758060336112976;
        double coolPipeSplyTemp = 0.2901118993759155;
        double coolReturnPrs = 0.9560574889183044;
        double coolSupplyPrs = 0.3139672875404358;
        double domeXMinusTemp = 0.805095374584198;
        double domeYMinusTemp = 0.02546858787536621;
        double fanInletTemp = 0.3368757963180542;
        double fanRunTime = 0.4967222213745117;
        double fanSpeed = 0.9144179224967957;
        double midXMinusTemp = 0.3313818573951721;
        double midXPlusTemp = 0.3330138921737671;
        double suppXMinusTemp = 0.541313f;
        double suppXPlusTemp = 0.2548163f;
        double topXMinusTemp = 0.4418790936470032;
        double topXPlusTemp = 0.4372493028640747;
        double valvePosn = 0.7445698380470276;
        double w2Q1Temp = 0.07734578847885132;
        double w4Q3Temp = 0.3536115884780884;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Utiltrunk_UTTelemetry(averageTemp, coolFlowRate, coolPipeRetnTemp, coolPipeSplyTemp, coolReturnPrs, coolSupplyPrs, domeXMinusTemp, domeYMinusTemp, fanInletTemp, fanRunTime, fanSpeed, midXMinusTemp, midXPlusTemp, suppXMinusTemp, suppXPlusTemp, topXMinusTemp, topXPlusTemp, valvePosn, w2Q1Temp, w4Q3Temp));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_UTTelemetry));
        Utiltrunk_UTTelemetry item_ = (Utiltrunk_UTTelemetry)item;
        Assert.assertEquals((double)averageTemp, (double)item_.getAverageTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)coolFlowRate, (double)item_.getCoolFlowRate(), (double)1.0E-6f);
        Assert.assertEquals((double)coolPipeRetnTemp, (double)item_.getCoolPipeRetnTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)coolPipeSplyTemp, (double)item_.getCoolPipeSplyTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)coolReturnPrs, (double)item_.getCoolReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)coolSupplyPrs, (double)item_.getCoolSupplyPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)domeXMinusTemp, (double)item_.getDomeXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)domeYMinusTemp, (double)item_.getDomeYMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)fanInletTemp, (double)item_.getFanInletTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)fanRunTime, (double)item_.getFanRunTime(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)midXMinusTemp, (double)item_.getMidXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)midXPlusTemp, (double)item_.getMidXPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)suppXMinusTemp, (double)item_.getSuppXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)suppXPlusTemp, (double)item_.getSuppXPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)topXMinusTemp, (double)item_.getTopXMinusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)topXPlusTemp, (double)item_.getTopXPlusTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)valvePosn, (double)item_.getValvePosn(), (double)1.0E-6f);
        Assert.assertEquals((double)w2Q1Temp, (double)item_.getW2Q1Temp(), (double)1.0E-6f);
        Assert.assertEquals((double)w4Q3Temp, (double)item_.getW4Q3Temp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveUtiltrunk_VPCTelemetry() throws Exception {
        double deltaPressFilt = 0.08894175291061401;
        double deltaPressTotal = 0.6208242774009705;
        double deltaTempAct = 0.32345062494277954;
        double fanRunTime = 0.8245266675949097;
        double fanSpeed = 0.4157188f;
        double htrCurrent = 0.2299739122390747;
        double humidity = 0.5276051163673401;
        double preFiltPress = 0.518195629119873;
        double retnAirTemp = 0.379548f;
        double retnPress = 0.01873844861984253;
        double splyAirTemp = 0.8789803385734558;
        double splyAirVel = 0.8927275538444519;
        double splyPress = 0.9442128539085388;
        double valvePosn = 0.8302292227745056;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Utiltrunk_VPCTelemetry(deltaPressFilt, deltaPressTotal, deltaTempAct, fanRunTime, fanSpeed, htrCurrent, humidity, preFiltPress, retnAirTemp, retnPress, splyAirTemp, splyAirVel, splyPress, valvePosn));
        Assert.assertTrue((boolean)(item instanceof Utiltrunk_VPCTelemetry));
        Utiltrunk_VPCTelemetry item_ = (Utiltrunk_VPCTelemetry)item;
        Assert.assertEquals((double)deltaPressFilt, (double)item_.getDeltaPressFilt(), (double)1.0E-6f);
        Assert.assertEquals((double)deltaPressTotal, (double)item_.getDeltaPressTotal(), (double)1.0E-6f);
        Assert.assertEquals((double)deltaTempAct, (double)item_.getDeltaTempAct(), (double)1.0E-6f);
        Assert.assertEquals((double)fanRunTime, (double)item_.getFanRunTime(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)htrCurrent, (double)item_.getHtrCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)humidity, (double)item_.getHumidity(), (double)1.0E-6f);
        Assert.assertEquals((double)preFiltPress, (double)item_.getPreFiltPress(), (double)1.0E-6f);
        Assert.assertEquals((double)retnAirTemp, (double)item_.getRetnAirTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)retnPress, (double)item_.getRetnPress(), (double)1.0E-6f);
        Assert.assertEquals((double)splyAirTemp, (double)item_.getSplyAirTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)splyAirVel, (double)item_.getSplyAirVel(), (double)1.0E-6f);
        Assert.assertEquals((double)splyPress, (double)item_.getSplyPress(), (double)1.0E-6f);
        Assert.assertEquals((double)valvePosn, (double)item_.getValvePosn(), (double)1.0E-6f);
    }
}

