package org.lsst.sal.camera.telemetry;

import java.util.Arrays;
import org.lsst.sal.camera.CameraTelemetry;

public class Thermal_RtdTelemetry extends CameraTelemetry {
  private final double[] cold_Temp;

  private final double[] cryo_Temp;

  private final double[] grid_Temp;

  private final String location;

  public Thermal_RtdTelemetry(double[] cold_Temp, double[] cryo_Temp, double[] grid_Temp,
      String location) {
    this.cold_Temp = cold_Temp;
    this.cryo_Temp = cryo_Temp;
    this.grid_Temp = grid_Temp;
    this.location = location;
  }

  public double[] getCold_Temp() {
    return cold_Temp;
  }

  public double[] getCryo_Temp() {
    return cryo_Temp;
  }

  public double[] getGrid_Temp() {
    return grid_Temp;
  }

  public String getLocation() {
    return location;
  }

  @Override
  public String toString() {
    return "Thermal_RtdTelemetry{" + "cold_Temp=" + Arrays.toString(cold_Temp) +
        ", cryo_Temp=" + Arrays.toString(cryo_Temp) +", grid_Temp=" + Arrays.toString(grid_Temp) +
        ", location=" + location +"}";
  }
}
