package org.lsst.sal.camera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class Quadbox_PDU_48VTelemetry extends CameraTelemetry {
  private final double board_T;

  private final double fes_CarouselD_I;

  private final double fes_CarouselD_V;

  private final double fes_Heater_I;

  private final double fes_Heater_V;

  private final double fpga_T;

  private final double main_I;

  private final double main_T;

  private final double main_V;

  private final double purge_Fan_I;

  private final double purge_Fan_V;

  private final double shtr_Motor1_I;

  private final double shtr_Motor1_V;

  private final double shtr_Motor2_I;

  private final double shtr_Motor2_V;

  public Quadbox_PDU_48VTelemetry(double board_T, double fes_CarouselD_I, double fes_CarouselD_V,
      double fes_Heater_I, double fes_Heater_V, double fpga_T, double main_I, double main_T,
      double main_V, double purge_Fan_I, double purge_Fan_V, double shtr_Motor1_I,
      double shtr_Motor1_V, double shtr_Motor2_I, double shtr_Motor2_V) {
    this.board_T = board_T;
    this.fes_CarouselD_I = fes_CarouselD_I;
    this.fes_CarouselD_V = fes_CarouselD_V;
    this.fes_Heater_I = fes_Heater_I;
    this.fes_Heater_V = fes_Heater_V;
    this.fpga_T = fpga_T;
    this.main_I = main_I;
    this.main_T = main_T;
    this.main_V = main_V;
    this.purge_Fan_I = purge_Fan_I;
    this.purge_Fan_V = purge_Fan_V;
    this.shtr_Motor1_I = shtr_Motor1_I;
    this.shtr_Motor1_V = shtr_Motor1_V;
    this.shtr_Motor2_I = shtr_Motor2_I;
    this.shtr_Motor2_V = shtr_Motor2_V;
  }

  public double getBoard_T() {
    return board_T;
  }

  public double getFes_CarouselD_I() {
    return fes_CarouselD_I;
  }

  public double getFes_CarouselD_V() {
    return fes_CarouselD_V;
  }

  public double getFes_Heater_I() {
    return fes_Heater_I;
  }

  public double getFes_Heater_V() {
    return fes_Heater_V;
  }

  public double getFpga_T() {
    return fpga_T;
  }

  public double getMain_I() {
    return main_I;
  }

  public double getMain_T() {
    return main_T;
  }

  public double getMain_V() {
    return main_V;
  }

  public double getPurge_Fan_I() {
    return purge_Fan_I;
  }

  public double getPurge_Fan_V() {
    return purge_Fan_V;
  }

  public double getShtr_Motor1_I() {
    return shtr_Motor1_I;
  }

  public double getShtr_Motor1_V() {
    return shtr_Motor1_V;
  }

  public double getShtr_Motor2_I() {
    return shtr_Motor2_I;
  }

  public double getShtr_Motor2_V() {
    return shtr_Motor2_V;
  }

  @Override
  public String toString() {
    return "Quadbox_PDU_48VTelemetry{" + "board_T=" + board_T +
        ", fes_CarouselD_I=" + fes_CarouselD_I +", fes_CarouselD_V=" + fes_CarouselD_V +
        ", fes_Heater_I=" + fes_Heater_I +", fes_Heater_V=" + fes_Heater_V +", fpga_T=" + fpga_T +
        ", main_I=" + main_I +", main_T=" + main_T +", main_V=" + main_V +
        ", purge_Fan_I=" + purge_Fan_I +", purge_Fan_V=" + purge_Fan_V +
        ", shtr_Motor1_I=" + shtr_Motor1_I +", shtr_Motor1_V=" + shtr_Motor1_V +
        ", shtr_Motor2_I=" + shtr_Motor2_I +", shtr_Motor2_V=" + shtr_Motor2_V +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private double board_T;

    private double fes_CarouselD_I;

    private double fes_CarouselD_V;

    private double fes_Heater_I;

    private double fes_Heater_V;

    private double fpga_T;

    private double main_I;

    private double main_T;

    private double main_V;

    private double purge_Fan_I;

    private double purge_Fan_V;

    private double shtr_Motor1_I;

    private double shtr_Motor1_V;

    private double shtr_Motor2_I;

    private double shtr_Motor2_V;

    private Builder() {
    }

    public Builder board_T(double board_T) {
      this.board_T = board_T;
      return this;
    }

    public Builder fes_CarouselD_I(double fes_CarouselD_I) {
      this.fes_CarouselD_I = fes_CarouselD_I;
      return this;
    }

    public Builder fes_CarouselD_V(double fes_CarouselD_V) {
      this.fes_CarouselD_V = fes_CarouselD_V;
      return this;
    }

    public Builder fes_Heater_I(double fes_Heater_I) {
      this.fes_Heater_I = fes_Heater_I;
      return this;
    }

    public Builder fes_Heater_V(double fes_Heater_V) {
      this.fes_Heater_V = fes_Heater_V;
      return this;
    }

    public Builder fpga_T(double fpga_T) {
      this.fpga_T = fpga_T;
      return this;
    }

    public Builder main_I(double main_I) {
      this.main_I = main_I;
      return this;
    }

    public Builder main_T(double main_T) {
      this.main_T = main_T;
      return this;
    }

    public Builder main_V(double main_V) {
      this.main_V = main_V;
      return this;
    }

    public Builder purge_Fan_I(double purge_Fan_I) {
      this.purge_Fan_I = purge_Fan_I;
      return this;
    }

    public Builder purge_Fan_V(double purge_Fan_V) {
      this.purge_Fan_V = purge_Fan_V;
      return this;
    }

    public Builder shtr_Motor1_I(double shtr_Motor1_I) {
      this.shtr_Motor1_I = shtr_Motor1_I;
      return this;
    }

    public Builder shtr_Motor1_V(double shtr_Motor1_V) {
      this.shtr_Motor1_V = shtr_Motor1_V;
      return this;
    }

    public Builder shtr_Motor2_I(double shtr_Motor2_I) {
      this.shtr_Motor2_I = shtr_Motor2_I;
      return this;
    }

    public Builder shtr_Motor2_V(double shtr_Motor2_V) {
      this.shtr_Motor2_V = shtr_Motor2_V;
      return this;
    }

    public Quadbox_PDU_48VTelemetry build() {
      return new Quadbox_PDU_48VTelemetry(board_T, fes_CarouselD_I, fes_CarouselD_V, fes_Heater_I, fes_Heater_V, fpga_T, main_I, main_T, main_V, purge_Fan_I, purge_Fan_V, shtr_Motor1_I, shtr_Motor1_V, shtr_Motor2_I, shtr_Motor2_V);
    }
  }
}
