package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class Thermal_ThermalLimitsConfigurationEvent extends CameraEvent {
  private final String version;

  private final double coldTempLimit;

  private final double coldTempLowLimit;

  private final double cryoTempLowLimit;

  public Thermal_ThermalLimitsConfigurationEvent(String version, double coldTempLimit,
      double coldTempLowLimit, double cryoTempLowLimit) {
    this.version = version;
    this.coldTempLimit = coldTempLimit;
    this.coldTempLowLimit = coldTempLowLimit;
    this.cryoTempLowLimit = cryoTempLowLimit;
  }

  public String getVersion() {
    return version;
  }

  public double getColdTempLimit() {
    return coldTempLimit;
  }

  public double getColdTempLowLimit() {
    return coldTempLowLimit;
  }

  public double getCryoTempLowLimit() {
    return cryoTempLowLimit;
  }

  @Override
  public String toString() {
    return "Thermal_ThermalLimitsConfigurationEvent{" + "version=" + version +
        ", coldTempLimit=" + coldTempLimit +", coldTempLowLimit=" + coldTempLowLimit +
        ", cryoTempLowLimit=" + cryoTempLowLimit +"}";
  }
}
