package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class Chiller_GeneralConfigurationEvent extends CameraEvent {
  private final String version;

  private final String chilleralertlistener_thermalAlertSource;

  private final String chilleralertlistener_vacuumAlertSource;

  private final String chiller_host;

  private final String coldplateChannelPath;

  private final boolean glycolCooling;

  private final String listenTo;

  private final String maq20_GlycHeatXfer_flowChanPath;

  private final String maq20_GlycHeatXfer_inletTChanPath;

  private final String maq20_GlycHeatXfer_outletTChanPath;

  private final double maxPressure;

  private final int periodictasks_schedulers_default_nTasks;

  private final int periodictasks_schedulers_default_nThreads;

  private final int periodictasks_schedulers_monitor_check_scheduler_nTasks;

  private final int periodictasks_schedulers_monitor_check_scheduler_nThreads;

  private final int periodictasks_schedulers_monitor_update_publish_scheduler_nTasks;

  private final int periodictasks_schedulers_monitor_update_publish_scheduler_nThreads;

  private final double temperatureTimeoutFactor;

  public Chiller_GeneralConfigurationEvent(String version,
      String chilleralertlistener_thermalAlertSource, String chilleralertlistener_vacuumAlertSource,
      String chiller_host, String coldplateChannelPath, boolean glycolCooling, String listenTo,
      String maq20_GlycHeatXfer_flowChanPath, String maq20_GlycHeatXfer_inletTChanPath,
      String maq20_GlycHeatXfer_outletTChanPath, double maxPressure,
      int periodictasks_schedulers_default_nTasks, int periodictasks_schedulers_default_nThreads,
      int periodictasks_schedulers_monitor_check_scheduler_nTasks,
      int periodictasks_schedulers_monitor_check_scheduler_nThreads,
      int periodictasks_schedulers_monitor_update_publish_scheduler_nTasks,
      int periodictasks_schedulers_monitor_update_publish_scheduler_nThreads,
      double temperatureTimeoutFactor) {
    this.version = version;
    this.chilleralertlistener_thermalAlertSource = chilleralertlistener_thermalAlertSource;
    this.chilleralertlistener_vacuumAlertSource = chilleralertlistener_vacuumAlertSource;
    this.chiller_host = chiller_host;
    this.coldplateChannelPath = coldplateChannelPath;
    this.glycolCooling = glycolCooling;
    this.listenTo = listenTo;
    this.maq20_GlycHeatXfer_flowChanPath = maq20_GlycHeatXfer_flowChanPath;
    this.maq20_GlycHeatXfer_inletTChanPath = maq20_GlycHeatXfer_inletTChanPath;
    this.maq20_GlycHeatXfer_outletTChanPath = maq20_GlycHeatXfer_outletTChanPath;
    this.maxPressure = maxPressure;
    this.periodictasks_schedulers_default_nTasks = periodictasks_schedulers_default_nTasks;
    this.periodictasks_schedulers_default_nThreads = periodictasks_schedulers_default_nThreads;
    this.periodictasks_schedulers_monitor_check_scheduler_nTasks = periodictasks_schedulers_monitor_check_scheduler_nTasks;
    this.periodictasks_schedulers_monitor_check_scheduler_nThreads = periodictasks_schedulers_monitor_check_scheduler_nThreads;
    this.periodictasks_schedulers_monitor_update_publish_scheduler_nTasks = periodictasks_schedulers_monitor_update_publish_scheduler_nTasks;
    this.periodictasks_schedulers_monitor_update_publish_scheduler_nThreads = periodictasks_schedulers_monitor_update_publish_scheduler_nThreads;
    this.temperatureTimeoutFactor = temperatureTimeoutFactor;
  }

  public String getVersion() {
    return version;
  }

  public String getChilleralertlistener_thermalAlertSource() {
    return chilleralertlistener_thermalAlertSource;
  }

  public String getChilleralertlistener_vacuumAlertSource() {
    return chilleralertlistener_vacuumAlertSource;
  }

  public String getChiller_host() {
    return chiller_host;
  }

  public String getColdplateChannelPath() {
    return coldplateChannelPath;
  }

  public boolean isGlycolCooling() {
    return glycolCooling;
  }

  public String getListenTo() {
    return listenTo;
  }

  public String getMaq20_GlycHeatXfer_flowChanPath() {
    return maq20_GlycHeatXfer_flowChanPath;
  }

  public String getMaq20_GlycHeatXfer_inletTChanPath() {
    return maq20_GlycHeatXfer_inletTChanPath;
  }

  public String getMaq20_GlycHeatXfer_outletTChanPath() {
    return maq20_GlycHeatXfer_outletTChanPath;
  }

  public double getMaxPressure() {
    return maxPressure;
  }

  public int getPeriodictasks_schedulers_default_nTasks() {
    return periodictasks_schedulers_default_nTasks;
  }

  public int getPeriodictasks_schedulers_default_nThreads() {
    return periodictasks_schedulers_default_nThreads;
  }

  public int getPeriodictasks_schedulers_monitor_check_scheduler_nTasks() {
    return periodictasks_schedulers_monitor_check_scheduler_nTasks;
  }

  public int getPeriodictasks_schedulers_monitor_check_scheduler_nThreads() {
    return periodictasks_schedulers_monitor_check_scheduler_nThreads;
  }

  public int getPeriodictasks_schedulers_monitor_update_publish_scheduler_nTasks() {
    return periodictasks_schedulers_monitor_update_publish_scheduler_nTasks;
  }

  public int getPeriodictasks_schedulers_monitor_update_publish_scheduler_nThreads() {
    return periodictasks_schedulers_monitor_update_publish_scheduler_nThreads;
  }

  public double getTemperatureTimeoutFactor() {
    return temperatureTimeoutFactor;
  }

  @Override
  public String toString() {
    return "Chiller_GeneralConfigurationEvent{" + "version=" + version +
        ", chilleralertlistener_thermalAlertSource=" + chilleralertlistener_thermalAlertSource +
        ", chilleralertlistener_vacuumAlertSource=" + chilleralertlistener_vacuumAlertSource +
        ", chiller_host=" + chiller_host +", coldplateChannelPath=" + coldplateChannelPath +
        ", glycolCooling=" + glycolCooling +", listenTo=" + listenTo +
        ", maq20_GlycHeatXfer_flowChanPath=" + maq20_GlycHeatXfer_flowChanPath +
        ", maq20_GlycHeatXfer_inletTChanPath=" + maq20_GlycHeatXfer_inletTChanPath +
        ", maq20_GlycHeatXfer_outletTChanPath=" + maq20_GlycHeatXfer_outletTChanPath +
        ", maxPressure=" + maxPressure +
        ", periodictasks_schedulers_default_nTasks=" + periodictasks_schedulers_default_nTasks +
        ", periodictasks_schedulers_default_nThreads=" + periodictasks_schedulers_default_nThreads +
        ", periodictasks_schedulers_monitor_check_scheduler_nTasks=" + periodictasks_schedulers_monitor_check_scheduler_nTasks +
        ", periodictasks_schedulers_monitor_check_scheduler_nThreads=" + periodictasks_schedulers_monitor_check_scheduler_nThreads +
        ", periodictasks_schedulers_monitor_update_publish_scheduler_nTasks=" + periodictasks_schedulers_monitor_update_publish_scheduler_nTasks +
        ", periodictasks_schedulers_monitor_update_publish_scheduler_nThreads=" + periodictasks_schedulers_monitor_update_publish_scheduler_nThreads +
        ", temperatureTimeoutFactor=" + temperatureTimeoutFactor +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private String version;

    private String chilleralertlistener_thermalAlertSource;

    private String chilleralertlistener_vacuumAlertSource;

    private String chiller_host;

    private String coldplateChannelPath;

    private boolean glycolCooling;

    private String listenTo;

    private String maq20_GlycHeatXfer_flowChanPath;

    private String maq20_GlycHeatXfer_inletTChanPath;

    private String maq20_GlycHeatXfer_outletTChanPath;

    private double maxPressure;

    private int periodictasks_schedulers_default_nTasks;

    private int periodictasks_schedulers_default_nThreads;

    private int periodictasks_schedulers_monitor_check_scheduler_nTasks;

    private int periodictasks_schedulers_monitor_check_scheduler_nThreads;

    private int periodictasks_schedulers_monitor_update_publish_scheduler_nTasks;

    private int periodictasks_schedulers_monitor_update_publish_scheduler_nThreads;

    private double temperatureTimeoutFactor;

    private Builder() {
    }

    public Builder version(String version) {
      this.version = version;
      return this;
    }

    public Builder chilleralertlistener_thermalAlertSource(
        String chilleralertlistener_thermalAlertSource) {
      this.chilleralertlistener_thermalAlertSource = chilleralertlistener_thermalAlertSource;
      return this;
    }

    public Builder chilleralertlistener_vacuumAlertSource(
        String chilleralertlistener_vacuumAlertSource) {
      this.chilleralertlistener_vacuumAlertSource = chilleralertlistener_vacuumAlertSource;
      return this;
    }

    public Builder chiller_host(String chiller_host) {
      this.chiller_host = chiller_host;
      return this;
    }

    public Builder coldplateChannelPath(String coldplateChannelPath) {
      this.coldplateChannelPath = coldplateChannelPath;
      return this;
    }

    public Builder glycolCooling(boolean glycolCooling) {
      this.glycolCooling = glycolCooling;
      return this;
    }

    public Builder listenTo(String listenTo) {
      this.listenTo = listenTo;
      return this;
    }

    public Builder maq20_GlycHeatXfer_flowChanPath(String maq20_GlycHeatXfer_flowChanPath) {
      this.maq20_GlycHeatXfer_flowChanPath = maq20_GlycHeatXfer_flowChanPath;
      return this;
    }

    public Builder maq20_GlycHeatXfer_inletTChanPath(String maq20_GlycHeatXfer_inletTChanPath) {
      this.maq20_GlycHeatXfer_inletTChanPath = maq20_GlycHeatXfer_inletTChanPath;
      return this;
    }

    public Builder maq20_GlycHeatXfer_outletTChanPath(String maq20_GlycHeatXfer_outletTChanPath) {
      this.maq20_GlycHeatXfer_outletTChanPath = maq20_GlycHeatXfer_outletTChanPath;
      return this;
    }

    public Builder maxPressure(double maxPressure) {
      this.maxPressure = maxPressure;
      return this;
    }

    public Builder periodictasks_schedulers_default_nTasks(
        int periodictasks_schedulers_default_nTasks) {
      this.periodictasks_schedulers_default_nTasks = periodictasks_schedulers_default_nTasks;
      return this;
    }

    public Builder periodictasks_schedulers_default_nThreads(
        int periodictasks_schedulers_default_nThreads) {
      this.periodictasks_schedulers_default_nThreads = periodictasks_schedulers_default_nThreads;
      return this;
    }

    public Builder periodictasks_schedulers_monitor_check_scheduler_nTasks(
        int periodictasks_schedulers_monitor_check_scheduler_nTasks) {
      this.periodictasks_schedulers_monitor_check_scheduler_nTasks = periodictasks_schedulers_monitor_check_scheduler_nTasks;
      return this;
    }

    public Builder periodictasks_schedulers_monitor_check_scheduler_nThreads(
        int periodictasks_schedulers_monitor_check_scheduler_nThreads) {
      this.periodictasks_schedulers_monitor_check_scheduler_nThreads = periodictasks_schedulers_monitor_check_scheduler_nThreads;
      return this;
    }

    public Builder periodictasks_schedulers_monitor_update_publish_scheduler_nTasks(
        int periodictasks_schedulers_monitor_update_publish_scheduler_nTasks) {
      this.periodictasks_schedulers_monitor_update_publish_scheduler_nTasks = periodictasks_schedulers_monitor_update_publish_scheduler_nTasks;
      return this;
    }

    public Builder periodictasks_schedulers_monitor_update_publish_scheduler_nThreads(
        int periodictasks_schedulers_monitor_update_publish_scheduler_nThreads) {
      this.periodictasks_schedulers_monitor_update_publish_scheduler_nThreads = periodictasks_schedulers_monitor_update_publish_scheduler_nThreads;
      return this;
    }

    public Builder temperatureTimeoutFactor(double temperatureTimeoutFactor) {
      this.temperatureTimeoutFactor = temperatureTimeoutFactor;
      return this;
    }

    public Chiller_GeneralConfigurationEvent build() {
      return new Chiller_GeneralConfigurationEvent(version, chilleralertlistener_thermalAlertSource, chilleralertlistener_vacuumAlertSource, chiller_host, coldplateChannelPath, glycolCooling, listenTo, maq20_GlycHeatXfer_flowChanPath, maq20_GlycHeatXfer_inletTChanPath, maq20_GlycHeatXfer_outletTChanPath, maxPressure, periodictasks_schedulers_default_nTasks, periodictasks_schedulers_default_nThreads, periodictasks_schedulers_monitor_check_scheduler_nTasks, periodictasks_schedulers_monitor_check_scheduler_nThreads, periodictasks_schedulers_monitor_update_publish_scheduler_nTasks, periodictasks_schedulers_monitor_update_publish_scheduler_nThreads, temperatureTimeoutFactor);
    }
  }
}
