package org.lsst.sal.camera.telemetry;

import java.util.Arrays;
import org.lsst.sal.camera.CameraTelemetry;

public class Daq_monitor_Reb_TrendingTelemetry extends CameraTelemetry {
  private final long[] driver_errors;

  private final long[] driver_received;

  private final long[] driver_rx0;

  private final long[] driver_rx1;

  private final long[] driver_rx2;

  private final long[] driver_rx3;

  private final long[] firmware_cell_errors;

  private final long[] firmware_last_rx;

  private final long[] firmware_last_tx;

  private final long[] firmware_link_down;

  private final long[] firmware_link_errors;

  private final long[] firmware_link_status;

  private final long[] firmware_overflow_local0;

  private final long[] firmware_overflow_local1;

  private final long[] firmware_overflow_local2;

  private final long[] firmware_overflow_local3;

  private final long[] firmware_overflow_remote0;

  private final long[] firmware_overflow_remote1;

  private final long[] firmware_overflow_remote2;

  private final long[] firmware_overflow_remote3;

  private final long[] firmware_rlink_data;

  private final long[] firmware_rx_clock;

  private final long[] firmware_rx_errors;

  private final long[] firmware_rx_frames;

  private final long[] firmware_rx_op;

  private final long[] firmware_tx_clock;

  private final long[] firmware_tx_errors;

  private final long[] firmware_tx_frames;

  private final long[] firmware_tx_op;

  private final String location;

  private final long[] rds_bdi_firsts;

  private final long[] rds_bdi_frees;

  private final long[] rds_bdi_lasts;

  private final long[] rds_bdi_nulls;

  private final long[] rds_bdi_overflows;

  private final long[] rds_bdi_seq_errors;

  private final long[] rds_bdi_waits;

  private final long[] rds_discards;

  private final long[] rds_no_event;

  private final long[] rds_wakes;

  private final long[] rms_in_reset;

  private final long[] rms_inv_tids;

  private final long[] rms_link_down;

  private final long[] rms_lists_posted;

  private final long[] rms_ops_posted;

  private final long[] rms_orphans;

  private final long[] rms_probes;

  private final long[] rms_responses;

  private final long[] rms_rundowns;

  private final long[] rms_tid_hwm;

  private final long[] rms_unopened;

  private final long[] rms_waits;

  public Daq_monitor_Reb_TrendingTelemetry(long[] driver_errors, long[] driver_received,
      long[] driver_rx0, long[] driver_rx1, long[] driver_rx2, long[] driver_rx3,
      long[] firmware_cell_errors, long[] firmware_last_rx, long[] firmware_last_tx,
      long[] firmware_link_down, long[] firmware_link_errors, long[] firmware_link_status,
      long[] firmware_overflow_local0, long[] firmware_overflow_local1,
      long[] firmware_overflow_local2, long[] firmware_overflow_local3,
      long[] firmware_overflow_remote0, long[] firmware_overflow_remote1,
      long[] firmware_overflow_remote2, long[] firmware_overflow_remote3,
      long[] firmware_rlink_data, long[] firmware_rx_clock, long[] firmware_rx_errors,
      long[] firmware_rx_frames, long[] firmware_rx_op, long[] firmware_tx_clock,
      long[] firmware_tx_errors, long[] firmware_tx_frames, long[] firmware_tx_op, String location,
      long[] rds_bdi_firsts, long[] rds_bdi_frees, long[] rds_bdi_lasts, long[] rds_bdi_nulls,
      long[] rds_bdi_overflows, long[] rds_bdi_seq_errors, long[] rds_bdi_waits,
      long[] rds_discards, long[] rds_no_event, long[] rds_wakes, long[] rms_in_reset,
      long[] rms_inv_tids, long[] rms_link_down, long[] rms_lists_posted, long[] rms_ops_posted,
      long[] rms_orphans, long[] rms_probes, long[] rms_responses, long[] rms_rundowns,
      long[] rms_tid_hwm, long[] rms_unopened, long[] rms_waits) {
    this.driver_errors = driver_errors;
    this.driver_received = driver_received;
    this.driver_rx0 = driver_rx0;
    this.driver_rx1 = driver_rx1;
    this.driver_rx2 = driver_rx2;
    this.driver_rx3 = driver_rx3;
    this.firmware_cell_errors = firmware_cell_errors;
    this.firmware_last_rx = firmware_last_rx;
    this.firmware_last_tx = firmware_last_tx;
    this.firmware_link_down = firmware_link_down;
    this.firmware_link_errors = firmware_link_errors;
    this.firmware_link_status = firmware_link_status;
    this.firmware_overflow_local0 = firmware_overflow_local0;
    this.firmware_overflow_local1 = firmware_overflow_local1;
    this.firmware_overflow_local2 = firmware_overflow_local2;
    this.firmware_overflow_local3 = firmware_overflow_local3;
    this.firmware_overflow_remote0 = firmware_overflow_remote0;
    this.firmware_overflow_remote1 = firmware_overflow_remote1;
    this.firmware_overflow_remote2 = firmware_overflow_remote2;
    this.firmware_overflow_remote3 = firmware_overflow_remote3;
    this.firmware_rlink_data = firmware_rlink_data;
    this.firmware_rx_clock = firmware_rx_clock;
    this.firmware_rx_errors = firmware_rx_errors;
    this.firmware_rx_frames = firmware_rx_frames;
    this.firmware_rx_op = firmware_rx_op;
    this.firmware_tx_clock = firmware_tx_clock;
    this.firmware_tx_errors = firmware_tx_errors;
    this.firmware_tx_frames = firmware_tx_frames;
    this.firmware_tx_op = firmware_tx_op;
    this.location = location;
    this.rds_bdi_firsts = rds_bdi_firsts;
    this.rds_bdi_frees = rds_bdi_frees;
    this.rds_bdi_lasts = rds_bdi_lasts;
    this.rds_bdi_nulls = rds_bdi_nulls;
    this.rds_bdi_overflows = rds_bdi_overflows;
    this.rds_bdi_seq_errors = rds_bdi_seq_errors;
    this.rds_bdi_waits = rds_bdi_waits;
    this.rds_discards = rds_discards;
    this.rds_no_event = rds_no_event;
    this.rds_wakes = rds_wakes;
    this.rms_in_reset = rms_in_reset;
    this.rms_inv_tids = rms_inv_tids;
    this.rms_link_down = rms_link_down;
    this.rms_lists_posted = rms_lists_posted;
    this.rms_ops_posted = rms_ops_posted;
    this.rms_orphans = rms_orphans;
    this.rms_probes = rms_probes;
    this.rms_responses = rms_responses;
    this.rms_rundowns = rms_rundowns;
    this.rms_tid_hwm = rms_tid_hwm;
    this.rms_unopened = rms_unopened;
    this.rms_waits = rms_waits;
  }

  public long[] getDriver_errors() {
    return driver_errors;
  }

  public long[] getDriver_received() {
    return driver_received;
  }

  public long[] getDriver_rx0() {
    return driver_rx0;
  }

  public long[] getDriver_rx1() {
    return driver_rx1;
  }

  public long[] getDriver_rx2() {
    return driver_rx2;
  }

  public long[] getDriver_rx3() {
    return driver_rx3;
  }

  public long[] getFirmware_cell_errors() {
    return firmware_cell_errors;
  }

  public long[] getFirmware_last_rx() {
    return firmware_last_rx;
  }

  public long[] getFirmware_last_tx() {
    return firmware_last_tx;
  }

  public long[] getFirmware_link_down() {
    return firmware_link_down;
  }

  public long[] getFirmware_link_errors() {
    return firmware_link_errors;
  }

  public long[] getFirmware_link_status() {
    return firmware_link_status;
  }

  public long[] getFirmware_overflow_local0() {
    return firmware_overflow_local0;
  }

  public long[] getFirmware_overflow_local1() {
    return firmware_overflow_local1;
  }

  public long[] getFirmware_overflow_local2() {
    return firmware_overflow_local2;
  }

  public long[] getFirmware_overflow_local3() {
    return firmware_overflow_local3;
  }

  public long[] getFirmware_overflow_remote0() {
    return firmware_overflow_remote0;
  }

  public long[] getFirmware_overflow_remote1() {
    return firmware_overflow_remote1;
  }

  public long[] getFirmware_overflow_remote2() {
    return firmware_overflow_remote2;
  }

  public long[] getFirmware_overflow_remote3() {
    return firmware_overflow_remote3;
  }

  public long[] getFirmware_rlink_data() {
    return firmware_rlink_data;
  }

  public long[] getFirmware_rx_clock() {
    return firmware_rx_clock;
  }

  public long[] getFirmware_rx_errors() {
    return firmware_rx_errors;
  }

  public long[] getFirmware_rx_frames() {
    return firmware_rx_frames;
  }

  public long[] getFirmware_rx_op() {
    return firmware_rx_op;
  }

  public long[] getFirmware_tx_clock() {
    return firmware_tx_clock;
  }

  public long[] getFirmware_tx_errors() {
    return firmware_tx_errors;
  }

  public long[] getFirmware_tx_frames() {
    return firmware_tx_frames;
  }

  public long[] getFirmware_tx_op() {
    return firmware_tx_op;
  }

  public String getLocation() {
    return location;
  }

  public long[] getRds_bdi_firsts() {
    return rds_bdi_firsts;
  }

  public long[] getRds_bdi_frees() {
    return rds_bdi_frees;
  }

  public long[] getRds_bdi_lasts() {
    return rds_bdi_lasts;
  }

  public long[] getRds_bdi_nulls() {
    return rds_bdi_nulls;
  }

  public long[] getRds_bdi_overflows() {
    return rds_bdi_overflows;
  }

  public long[] getRds_bdi_seq_errors() {
    return rds_bdi_seq_errors;
  }

  public long[] getRds_bdi_waits() {
    return rds_bdi_waits;
  }

  public long[] getRds_discards() {
    return rds_discards;
  }

  public long[] getRds_no_event() {
    return rds_no_event;
  }

  public long[] getRds_wakes() {
    return rds_wakes;
  }

  public long[] getRms_in_reset() {
    return rms_in_reset;
  }

  public long[] getRms_inv_tids() {
    return rms_inv_tids;
  }

  public long[] getRms_link_down() {
    return rms_link_down;
  }

  public long[] getRms_lists_posted() {
    return rms_lists_posted;
  }

  public long[] getRms_ops_posted() {
    return rms_ops_posted;
  }

  public long[] getRms_orphans() {
    return rms_orphans;
  }

  public long[] getRms_probes() {
    return rms_probes;
  }

  public long[] getRms_responses() {
    return rms_responses;
  }

  public long[] getRms_rundowns() {
    return rms_rundowns;
  }

  public long[] getRms_tid_hwm() {
    return rms_tid_hwm;
  }

  public long[] getRms_unopened() {
    return rms_unopened;
  }

  public long[] getRms_waits() {
    return rms_waits;
  }

  @Override
  public String toString() {
    return "Daq_monitor_Reb_TrendingTelemetry{" + "driver_errors=" + Arrays.toString(driver_errors) +
        ", driver_received=" + Arrays.toString(driver_received) +
        ", driver_rx0=" + Arrays.toString(driver_rx0) +
        ", driver_rx1=" + Arrays.toString(driver_rx1) +
        ", driver_rx2=" + Arrays.toString(driver_rx2) +
        ", driver_rx3=" + Arrays.toString(driver_rx3) +
        ", firmware_cell_errors=" + Arrays.toString(firmware_cell_errors) +
        ", firmware_last_rx=" + Arrays.toString(firmware_last_rx) +
        ", firmware_last_tx=" + Arrays.toString(firmware_last_tx) +
        ", firmware_link_down=" + Arrays.toString(firmware_link_down) +
        ", firmware_link_errors=" + Arrays.toString(firmware_link_errors) +
        ", firmware_link_status=" + Arrays.toString(firmware_link_status) +
        ", firmware_overflow_local0=" + Arrays.toString(firmware_overflow_local0) +
        ", firmware_overflow_local1=" + Arrays.toString(firmware_overflow_local1) +
        ", firmware_overflow_local2=" + Arrays.toString(firmware_overflow_local2) +
        ", firmware_overflow_local3=" + Arrays.toString(firmware_overflow_local3) +
        ", firmware_overflow_remote0=" + Arrays.toString(firmware_overflow_remote0) +
        ", firmware_overflow_remote1=" + Arrays.toString(firmware_overflow_remote1) +
        ", firmware_overflow_remote2=" + Arrays.toString(firmware_overflow_remote2) +
        ", firmware_overflow_remote3=" + Arrays.toString(firmware_overflow_remote3) +
        ", firmware_rlink_data=" + Arrays.toString(firmware_rlink_data) +
        ", firmware_rx_clock=" + Arrays.toString(firmware_rx_clock) +
        ", firmware_rx_errors=" + Arrays.toString(firmware_rx_errors) +
        ", firmware_rx_frames=" + Arrays.toString(firmware_rx_frames) +
        ", firmware_rx_op=" + Arrays.toString(firmware_rx_op) +
        ", firmware_tx_clock=" + Arrays.toString(firmware_tx_clock) +
        ", firmware_tx_errors=" + Arrays.toString(firmware_tx_errors) +
        ", firmware_tx_frames=" + Arrays.toString(firmware_tx_frames) +
        ", firmware_tx_op=" + Arrays.toString(firmware_tx_op) +", location=" + location +
        ", rds_bdi_firsts=" + Arrays.toString(rds_bdi_firsts) +
        ", rds_bdi_frees=" + Arrays.toString(rds_bdi_frees) +
        ", rds_bdi_lasts=" + Arrays.toString(rds_bdi_lasts) +
        ", rds_bdi_nulls=" + Arrays.toString(rds_bdi_nulls) +
        ", rds_bdi_overflows=" + Arrays.toString(rds_bdi_overflows) +
        ", rds_bdi_seq_errors=" + Arrays.toString(rds_bdi_seq_errors) +
        ", rds_bdi_waits=" + Arrays.toString(rds_bdi_waits) +
        ", rds_discards=" + Arrays.toString(rds_discards) +
        ", rds_no_event=" + Arrays.toString(rds_no_event) +
        ", rds_wakes=" + Arrays.toString(rds_wakes) +
        ", rms_in_reset=" + Arrays.toString(rms_in_reset) +
        ", rms_inv_tids=" + Arrays.toString(rms_inv_tids) +
        ", rms_link_down=" + Arrays.toString(rms_link_down) +
        ", rms_lists_posted=" + Arrays.toString(rms_lists_posted) +
        ", rms_ops_posted=" + Arrays.toString(rms_ops_posted) +
        ", rms_orphans=" + Arrays.toString(rms_orphans) +
        ", rms_probes=" + Arrays.toString(rms_probes) +
        ", rms_responses=" + Arrays.toString(rms_responses) +
        ", rms_rundowns=" + Arrays.toString(rms_rundowns) +
        ", rms_tid_hwm=" + Arrays.toString(rms_tid_hwm) +
        ", rms_unopened=" + Arrays.toString(rms_unopened) +
        ", rms_waits=" + Arrays.toString(rms_waits) +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private long[] driver_errors;

    private long[] driver_received;

    private long[] driver_rx0;

    private long[] driver_rx1;

    private long[] driver_rx2;

    private long[] driver_rx3;

    private long[] firmware_cell_errors;

    private long[] firmware_last_rx;

    private long[] firmware_last_tx;

    private long[] firmware_link_down;

    private long[] firmware_link_errors;

    private long[] firmware_link_status;

    private long[] firmware_overflow_local0;

    private long[] firmware_overflow_local1;

    private long[] firmware_overflow_local2;

    private long[] firmware_overflow_local3;

    private long[] firmware_overflow_remote0;

    private long[] firmware_overflow_remote1;

    private long[] firmware_overflow_remote2;

    private long[] firmware_overflow_remote3;

    private long[] firmware_rlink_data;

    private long[] firmware_rx_clock;

    private long[] firmware_rx_errors;

    private long[] firmware_rx_frames;

    private long[] firmware_rx_op;

    private long[] firmware_tx_clock;

    private long[] firmware_tx_errors;

    private long[] firmware_tx_frames;

    private long[] firmware_tx_op;

    private String location;

    private long[] rds_bdi_firsts;

    private long[] rds_bdi_frees;

    private long[] rds_bdi_lasts;

    private long[] rds_bdi_nulls;

    private long[] rds_bdi_overflows;

    private long[] rds_bdi_seq_errors;

    private long[] rds_bdi_waits;

    private long[] rds_discards;

    private long[] rds_no_event;

    private long[] rds_wakes;

    private long[] rms_in_reset;

    private long[] rms_inv_tids;

    private long[] rms_link_down;

    private long[] rms_lists_posted;

    private long[] rms_ops_posted;

    private long[] rms_orphans;

    private long[] rms_probes;

    private long[] rms_responses;

    private long[] rms_rundowns;

    private long[] rms_tid_hwm;

    private long[] rms_unopened;

    private long[] rms_waits;

    private Builder() {
    }

    public Builder driver_errors(long[] driver_errors) {
      this.driver_errors = driver_errors;
      return this;
    }

    public Builder driver_received(long[] driver_received) {
      this.driver_received = driver_received;
      return this;
    }

    public Builder driver_rx0(long[] driver_rx0) {
      this.driver_rx0 = driver_rx0;
      return this;
    }

    public Builder driver_rx1(long[] driver_rx1) {
      this.driver_rx1 = driver_rx1;
      return this;
    }

    public Builder driver_rx2(long[] driver_rx2) {
      this.driver_rx2 = driver_rx2;
      return this;
    }

    public Builder driver_rx3(long[] driver_rx3) {
      this.driver_rx3 = driver_rx3;
      return this;
    }

    public Builder firmware_cell_errors(long[] firmware_cell_errors) {
      this.firmware_cell_errors = firmware_cell_errors;
      return this;
    }

    public Builder firmware_last_rx(long[] firmware_last_rx) {
      this.firmware_last_rx = firmware_last_rx;
      return this;
    }

    public Builder firmware_last_tx(long[] firmware_last_tx) {
      this.firmware_last_tx = firmware_last_tx;
      return this;
    }

    public Builder firmware_link_down(long[] firmware_link_down) {
      this.firmware_link_down = firmware_link_down;
      return this;
    }

    public Builder firmware_link_errors(long[] firmware_link_errors) {
      this.firmware_link_errors = firmware_link_errors;
      return this;
    }

    public Builder firmware_link_status(long[] firmware_link_status) {
      this.firmware_link_status = firmware_link_status;
      return this;
    }

    public Builder firmware_overflow_local0(long[] firmware_overflow_local0) {
      this.firmware_overflow_local0 = firmware_overflow_local0;
      return this;
    }

    public Builder firmware_overflow_local1(long[] firmware_overflow_local1) {
      this.firmware_overflow_local1 = firmware_overflow_local1;
      return this;
    }

    public Builder firmware_overflow_local2(long[] firmware_overflow_local2) {
      this.firmware_overflow_local2 = firmware_overflow_local2;
      return this;
    }

    public Builder firmware_overflow_local3(long[] firmware_overflow_local3) {
      this.firmware_overflow_local3 = firmware_overflow_local3;
      return this;
    }

    public Builder firmware_overflow_remote0(long[] firmware_overflow_remote0) {
      this.firmware_overflow_remote0 = firmware_overflow_remote0;
      return this;
    }

    public Builder firmware_overflow_remote1(long[] firmware_overflow_remote1) {
      this.firmware_overflow_remote1 = firmware_overflow_remote1;
      return this;
    }

    public Builder firmware_overflow_remote2(long[] firmware_overflow_remote2) {
      this.firmware_overflow_remote2 = firmware_overflow_remote2;
      return this;
    }

    public Builder firmware_overflow_remote3(long[] firmware_overflow_remote3) {
      this.firmware_overflow_remote3 = firmware_overflow_remote3;
      return this;
    }

    public Builder firmware_rlink_data(long[] firmware_rlink_data) {
      this.firmware_rlink_data = firmware_rlink_data;
      return this;
    }

    public Builder firmware_rx_clock(long[] firmware_rx_clock) {
      this.firmware_rx_clock = firmware_rx_clock;
      return this;
    }

    public Builder firmware_rx_errors(long[] firmware_rx_errors) {
      this.firmware_rx_errors = firmware_rx_errors;
      return this;
    }

    public Builder firmware_rx_frames(long[] firmware_rx_frames) {
      this.firmware_rx_frames = firmware_rx_frames;
      return this;
    }

    public Builder firmware_rx_op(long[] firmware_rx_op) {
      this.firmware_rx_op = firmware_rx_op;
      return this;
    }

    public Builder firmware_tx_clock(long[] firmware_tx_clock) {
      this.firmware_tx_clock = firmware_tx_clock;
      return this;
    }

    public Builder firmware_tx_errors(long[] firmware_tx_errors) {
      this.firmware_tx_errors = firmware_tx_errors;
      return this;
    }

    public Builder firmware_tx_frames(long[] firmware_tx_frames) {
      this.firmware_tx_frames = firmware_tx_frames;
      return this;
    }

    public Builder firmware_tx_op(long[] firmware_tx_op) {
      this.firmware_tx_op = firmware_tx_op;
      return this;
    }

    public Builder location(String location) {
      this.location = location;
      return this;
    }

    public Builder rds_bdi_firsts(long[] rds_bdi_firsts) {
      this.rds_bdi_firsts = rds_bdi_firsts;
      return this;
    }

    public Builder rds_bdi_frees(long[] rds_bdi_frees) {
      this.rds_bdi_frees = rds_bdi_frees;
      return this;
    }

    public Builder rds_bdi_lasts(long[] rds_bdi_lasts) {
      this.rds_bdi_lasts = rds_bdi_lasts;
      return this;
    }

    public Builder rds_bdi_nulls(long[] rds_bdi_nulls) {
      this.rds_bdi_nulls = rds_bdi_nulls;
      return this;
    }

    public Builder rds_bdi_overflows(long[] rds_bdi_overflows) {
      this.rds_bdi_overflows = rds_bdi_overflows;
      return this;
    }

    public Builder rds_bdi_seq_errors(long[] rds_bdi_seq_errors) {
      this.rds_bdi_seq_errors = rds_bdi_seq_errors;
      return this;
    }

    public Builder rds_bdi_waits(long[] rds_bdi_waits) {
      this.rds_bdi_waits = rds_bdi_waits;
      return this;
    }

    public Builder rds_discards(long[] rds_discards) {
      this.rds_discards = rds_discards;
      return this;
    }

    public Builder rds_no_event(long[] rds_no_event) {
      this.rds_no_event = rds_no_event;
      return this;
    }

    public Builder rds_wakes(long[] rds_wakes) {
      this.rds_wakes = rds_wakes;
      return this;
    }

    public Builder rms_in_reset(long[] rms_in_reset) {
      this.rms_in_reset = rms_in_reset;
      return this;
    }

    public Builder rms_inv_tids(long[] rms_inv_tids) {
      this.rms_inv_tids = rms_inv_tids;
      return this;
    }

    public Builder rms_link_down(long[] rms_link_down) {
      this.rms_link_down = rms_link_down;
      return this;
    }

    public Builder rms_lists_posted(long[] rms_lists_posted) {
      this.rms_lists_posted = rms_lists_posted;
      return this;
    }

    public Builder rms_ops_posted(long[] rms_ops_posted) {
      this.rms_ops_posted = rms_ops_posted;
      return this;
    }

    public Builder rms_orphans(long[] rms_orphans) {
      this.rms_orphans = rms_orphans;
      return this;
    }

    public Builder rms_probes(long[] rms_probes) {
      this.rms_probes = rms_probes;
      return this;
    }

    public Builder rms_responses(long[] rms_responses) {
      this.rms_responses = rms_responses;
      return this;
    }

    public Builder rms_rundowns(long[] rms_rundowns) {
      this.rms_rundowns = rms_rundowns;
      return this;
    }

    public Builder rms_tid_hwm(long[] rms_tid_hwm) {
      this.rms_tid_hwm = rms_tid_hwm;
      return this;
    }

    public Builder rms_unopened(long[] rms_unopened) {
      this.rms_unopened = rms_unopened;
      return this;
    }

    public Builder rms_waits(long[] rms_waits) {
      this.rms_waits = rms_waits;
      return this;
    }

    public Daq_monitor_Reb_TrendingTelemetry build() {
      return new Daq_monitor_Reb_TrendingTelemetry(driver_errors, driver_received, driver_rx0, driver_rx1, driver_rx2, driver_rx3, firmware_cell_errors, firmware_last_rx, firmware_last_tx, firmware_link_down, firmware_link_errors, firmware_link_status, firmware_overflow_local0, firmware_overflow_local1, firmware_overflow_local2, firmware_overflow_local3, firmware_overflow_remote0, firmware_overflow_remote1, firmware_overflow_remote2, firmware_overflow_remote3, firmware_rlink_data, firmware_rx_clock, firmware_rx_errors, firmware_rx_frames, firmware_rx_op, firmware_tx_clock, firmware_tx_errors, firmware_tx_frames, firmware_tx_op, location, rds_bdi_firsts, rds_bdi_frees, rds_bdi_lasts, rds_bdi_nulls, rds_bdi_overflows, rds_bdi_seq_errors, rds_bdi_waits, rds_discards, rds_no_event, rds_wakes, rms_in_reset, rms_inv_tids, rms_link_down, rms_lists_posted, rms_ops_posted, rms_orphans, rms_probes, rms_responses, rms_rundowns, rms_tid_hwm, rms_unopened, rms_waits);
    }
  }
}
