package org.lsst.sal.camera.states;

import org.lsst.sal.SALEnum;
import org.lsst.sal.camera.CameraStateChangeEvent;

public class SummaryStateEvent extends CameraStateChangeEvent {
  private final SummaryState substate;

  public SummaryStateEvent(SummaryState substate) {
    this.substate = substate;
  }

  @Override
  public SummaryState getSubstate() {
    return substate;
  }

  @Override
  public String toString() {
    return "SummaryStateEvent{" + "substate=" + substate +"}";
  }

  public enum SummaryState implements SALEnum {
    DISABLED,

    ENABLED,

    FAULT,

    OFFLINE,

    STANDBY
  }
}
