package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class Focal_plane_SequencerConfig_DAQConfigurationEvent extends CameraEvent {
  private final String version;

  private final int badPixelAlarmLimit;

  private final String daqFolder;

  private final String daqPartition;

  private final boolean emulatedDAQ;

  private final String scienceLocations;

  private final boolean simulatedDAQ;

  private final String simulatedDataFolder;

  public Focal_plane_SequencerConfig_DAQConfigurationEvent(String version, int badPixelAlarmLimit,
      String daqFolder, String daqPartition, boolean emulatedDAQ, String scienceLocations,
      boolean simulatedDAQ, String simulatedDataFolder) {
    this.version = version;
    this.badPixelAlarmLimit = badPixelAlarmLimit;
    this.daqFolder = daqFolder;
    this.daqPartition = daqPartition;
    this.emulatedDAQ = emulatedDAQ;
    this.scienceLocations = scienceLocations;
    this.simulatedDAQ = simulatedDAQ;
    this.simulatedDataFolder = simulatedDataFolder;
  }

  public String getVersion() {
    return version;
  }

  public int getBadPixelAlarmLimit() {
    return badPixelAlarmLimit;
  }

  public String getDaqFolder() {
    return daqFolder;
  }

  public String getDaqPartition() {
    return daqPartition;
  }

  public boolean isEmulatedDAQ() {
    return emulatedDAQ;
  }

  public String getScienceLocations() {
    return scienceLocations;
  }

  public boolean isSimulatedDAQ() {
    return simulatedDAQ;
  }

  public String getSimulatedDataFolder() {
    return simulatedDataFolder;
  }

  @Override
  public String toString() {
    return "Focal_plane_SequencerConfig_DAQConfigurationEvent{" + "version=" + version +
        ", badPixelAlarmLimit=" + badPixelAlarmLimit +", daqFolder=" + daqFolder +
        ", daqPartition=" + daqPartition +", emulatedDAQ=" + emulatedDAQ +
        ", scienceLocations=" + scienceLocations +", simulatedDAQ=" + simulatedDAQ +
        ", simulatedDataFolder=" + simulatedDataFolder +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private String version;

    private int badPixelAlarmLimit;

    private String daqFolder;

    private String daqPartition;

    private boolean emulatedDAQ;

    private String scienceLocations;

    private boolean simulatedDAQ;

    private String simulatedDataFolder;

    private Builder() {
    }

    public Builder version(String version) {
      this.version = version;
      return this;
    }

    public Builder badPixelAlarmLimit(int badPixelAlarmLimit) {
      this.badPixelAlarmLimit = badPixelAlarmLimit;
      return this;
    }

    public Builder daqFolder(String daqFolder) {
      this.daqFolder = daqFolder;
      return this;
    }

    public Builder daqPartition(String daqPartition) {
      this.daqPartition = daqPartition;
      return this;
    }

    public Builder emulatedDAQ(boolean emulatedDAQ) {
      this.emulatedDAQ = emulatedDAQ;
      return this;
    }

    public Builder scienceLocations(String scienceLocations) {
      this.scienceLocations = scienceLocations;
      return this;
    }

    public Builder simulatedDAQ(boolean simulatedDAQ) {
      this.simulatedDAQ = simulatedDAQ;
      return this;
    }

    public Builder simulatedDataFolder(String simulatedDataFolder) {
      this.simulatedDataFolder = simulatedDataFolder;
      return this;
    }

    public Focal_plane_SequencerConfig_DAQConfigurationEvent build() {
      return new Focal_plane_SequencerConfig_DAQConfigurationEvent(version, badPixelAlarmLimit, daqFolder, daqPartition, emulatedDAQ, scienceLocations, simulatedDAQ, simulatedDataFolder);
    }
  }
}
