package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class Fcs_Loader_loaderConfigurationEvent extends CameraEvent {
  private final String version;

  private final int carrier_deltaPosition;

  private final int carrier_engagedPosition;

  private final int carrier_handoffPosition;

  private final int carrier_highAcceleration;

  private final int carrier_highDeceleration;

  private final int carrier_highSpeed;

  private final int carrier_lowAcceleration;

  private final int carrier_lowDeceleration;

  private final int carrier_lowSpeed;

  private final int carrier_maxCurrent;

  private final int carrier_maxSpeed;

  private final int carrier_storagePosition;

  private final long carrier_timeoutForGoingToEngaged;

  private final long carrier_timeoutForGoingToHandOff;

  private final long carrier_timeoutForGoingToStorage;

  private final int filterDistanceMin;

  private final int hooks_absolutePositionToClose;

  private final int hooks_currentThreshold;

  private final int hooks_currentToClamp;

  private final int hooks_currentToOpen;

  private final int hooks_minClampedVoltage;

  private final int hooks_relativePositionToUnclamp;

  private final int hooks_timeoutForClampingHooks;

  private final int hooks_timeoutForClosingHooks;

  private final int hooks_timeoutForOpeningHooks;

  public Fcs_Loader_loaderConfigurationEvent(String version, int carrier_deltaPosition,
      int carrier_engagedPosition, int carrier_handoffPosition, int carrier_highAcceleration,
      int carrier_highDeceleration, int carrier_highSpeed, int carrier_lowAcceleration,
      int carrier_lowDeceleration, int carrier_lowSpeed, int carrier_maxCurrent,
      int carrier_maxSpeed, int carrier_storagePosition, long carrier_timeoutForGoingToEngaged,
      long carrier_timeoutForGoingToHandOff, long carrier_timeoutForGoingToStorage,
      int filterDistanceMin, int hooks_absolutePositionToClose, int hooks_currentThreshold,
      int hooks_currentToClamp, int hooks_currentToOpen, int hooks_minClampedVoltage,
      int hooks_relativePositionToUnclamp, int hooks_timeoutForClampingHooks,
      int hooks_timeoutForClosingHooks, int hooks_timeoutForOpeningHooks) {
    this.version = version;
    this.carrier_deltaPosition = carrier_deltaPosition;
    this.carrier_engagedPosition = carrier_engagedPosition;
    this.carrier_handoffPosition = carrier_handoffPosition;
    this.carrier_highAcceleration = carrier_highAcceleration;
    this.carrier_highDeceleration = carrier_highDeceleration;
    this.carrier_highSpeed = carrier_highSpeed;
    this.carrier_lowAcceleration = carrier_lowAcceleration;
    this.carrier_lowDeceleration = carrier_lowDeceleration;
    this.carrier_lowSpeed = carrier_lowSpeed;
    this.carrier_maxCurrent = carrier_maxCurrent;
    this.carrier_maxSpeed = carrier_maxSpeed;
    this.carrier_storagePosition = carrier_storagePosition;
    this.carrier_timeoutForGoingToEngaged = carrier_timeoutForGoingToEngaged;
    this.carrier_timeoutForGoingToHandOff = carrier_timeoutForGoingToHandOff;
    this.carrier_timeoutForGoingToStorage = carrier_timeoutForGoingToStorage;
    this.filterDistanceMin = filterDistanceMin;
    this.hooks_absolutePositionToClose = hooks_absolutePositionToClose;
    this.hooks_currentThreshold = hooks_currentThreshold;
    this.hooks_currentToClamp = hooks_currentToClamp;
    this.hooks_currentToOpen = hooks_currentToOpen;
    this.hooks_minClampedVoltage = hooks_minClampedVoltage;
    this.hooks_relativePositionToUnclamp = hooks_relativePositionToUnclamp;
    this.hooks_timeoutForClampingHooks = hooks_timeoutForClampingHooks;
    this.hooks_timeoutForClosingHooks = hooks_timeoutForClosingHooks;
    this.hooks_timeoutForOpeningHooks = hooks_timeoutForOpeningHooks;
  }

  public String getVersion() {
    return version;
  }

  public int getCarrier_deltaPosition() {
    return carrier_deltaPosition;
  }

  public int getCarrier_engagedPosition() {
    return carrier_engagedPosition;
  }

  public int getCarrier_handoffPosition() {
    return carrier_handoffPosition;
  }

  public int getCarrier_highAcceleration() {
    return carrier_highAcceleration;
  }

  public int getCarrier_highDeceleration() {
    return carrier_highDeceleration;
  }

  public int getCarrier_highSpeed() {
    return carrier_highSpeed;
  }

  public int getCarrier_lowAcceleration() {
    return carrier_lowAcceleration;
  }

  public int getCarrier_lowDeceleration() {
    return carrier_lowDeceleration;
  }

  public int getCarrier_lowSpeed() {
    return carrier_lowSpeed;
  }

  public int getCarrier_maxCurrent() {
    return carrier_maxCurrent;
  }

  public int getCarrier_maxSpeed() {
    return carrier_maxSpeed;
  }

  public int getCarrier_storagePosition() {
    return carrier_storagePosition;
  }

  public long getCarrier_timeoutForGoingToEngaged() {
    return carrier_timeoutForGoingToEngaged;
  }

  public long getCarrier_timeoutForGoingToHandOff() {
    return carrier_timeoutForGoingToHandOff;
  }

  public long getCarrier_timeoutForGoingToStorage() {
    return carrier_timeoutForGoingToStorage;
  }

  public int getFilterDistanceMin() {
    return filterDistanceMin;
  }

  public int getHooks_absolutePositionToClose() {
    return hooks_absolutePositionToClose;
  }

  public int getHooks_currentThreshold() {
    return hooks_currentThreshold;
  }

  public int getHooks_currentToClamp() {
    return hooks_currentToClamp;
  }

  public int getHooks_currentToOpen() {
    return hooks_currentToOpen;
  }

  public int getHooks_minClampedVoltage() {
    return hooks_minClampedVoltage;
  }

  public int getHooks_relativePositionToUnclamp() {
    return hooks_relativePositionToUnclamp;
  }

  public int getHooks_timeoutForClampingHooks() {
    return hooks_timeoutForClampingHooks;
  }

  public int getHooks_timeoutForClosingHooks() {
    return hooks_timeoutForClosingHooks;
  }

  public int getHooks_timeoutForOpeningHooks() {
    return hooks_timeoutForOpeningHooks;
  }

  @Override
  public String toString() {
    return "Fcs_Loader_loaderConfigurationEvent{" + "version=" + version +
        ", carrier_deltaPosition=" + carrier_deltaPosition +
        ", carrier_engagedPosition=" + carrier_engagedPosition +
        ", carrier_handoffPosition=" + carrier_handoffPosition +
        ", carrier_highAcceleration=" + carrier_highAcceleration +
        ", carrier_highDeceleration=" + carrier_highDeceleration +
        ", carrier_highSpeed=" + carrier_highSpeed +
        ", carrier_lowAcceleration=" + carrier_lowAcceleration +
        ", carrier_lowDeceleration=" + carrier_lowDeceleration +
        ", carrier_lowSpeed=" + carrier_lowSpeed +", carrier_maxCurrent=" + carrier_maxCurrent +
        ", carrier_maxSpeed=" + carrier_maxSpeed +
        ", carrier_storagePosition=" + carrier_storagePosition +
        ", carrier_timeoutForGoingToEngaged=" + carrier_timeoutForGoingToEngaged +
        ", carrier_timeoutForGoingToHandOff=" + carrier_timeoutForGoingToHandOff +
        ", carrier_timeoutForGoingToStorage=" + carrier_timeoutForGoingToStorage +
        ", filterDistanceMin=" + filterDistanceMin +
        ", hooks_absolutePositionToClose=" + hooks_absolutePositionToClose +
        ", hooks_currentThreshold=" + hooks_currentThreshold +
        ", hooks_currentToClamp=" + hooks_currentToClamp +
        ", hooks_currentToOpen=" + hooks_currentToOpen +
        ", hooks_minClampedVoltage=" + hooks_minClampedVoltage +
        ", hooks_relativePositionToUnclamp=" + hooks_relativePositionToUnclamp +
        ", hooks_timeoutForClampingHooks=" + hooks_timeoutForClampingHooks +
        ", hooks_timeoutForClosingHooks=" + hooks_timeoutForClosingHooks +
        ", hooks_timeoutForOpeningHooks=" + hooks_timeoutForOpeningHooks +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private String version;

    private int carrier_deltaPosition;

    private int carrier_engagedPosition;

    private int carrier_handoffPosition;

    private int carrier_highAcceleration;

    private int carrier_highDeceleration;

    private int carrier_highSpeed;

    private int carrier_lowAcceleration;

    private int carrier_lowDeceleration;

    private int carrier_lowSpeed;

    private int carrier_maxCurrent;

    private int carrier_maxSpeed;

    private int carrier_storagePosition;

    private long carrier_timeoutForGoingToEngaged;

    private long carrier_timeoutForGoingToHandOff;

    private long carrier_timeoutForGoingToStorage;

    private int filterDistanceMin;

    private int hooks_absolutePositionToClose;

    private int hooks_currentThreshold;

    private int hooks_currentToClamp;

    private int hooks_currentToOpen;

    private int hooks_minClampedVoltage;

    private int hooks_relativePositionToUnclamp;

    private int hooks_timeoutForClampingHooks;

    private int hooks_timeoutForClosingHooks;

    private int hooks_timeoutForOpeningHooks;

    private Builder() {
    }

    public Builder version(String version) {
      this.version = version;
      return this;
    }

    public Builder carrier_deltaPosition(int carrier_deltaPosition) {
      this.carrier_deltaPosition = carrier_deltaPosition;
      return this;
    }

    public Builder carrier_engagedPosition(int carrier_engagedPosition) {
      this.carrier_engagedPosition = carrier_engagedPosition;
      return this;
    }

    public Builder carrier_handoffPosition(int carrier_handoffPosition) {
      this.carrier_handoffPosition = carrier_handoffPosition;
      return this;
    }

    public Builder carrier_highAcceleration(int carrier_highAcceleration) {
      this.carrier_highAcceleration = carrier_highAcceleration;
      return this;
    }

    public Builder carrier_highDeceleration(int carrier_highDeceleration) {
      this.carrier_highDeceleration = carrier_highDeceleration;
      return this;
    }

    public Builder carrier_highSpeed(int carrier_highSpeed) {
      this.carrier_highSpeed = carrier_highSpeed;
      return this;
    }

    public Builder carrier_lowAcceleration(int carrier_lowAcceleration) {
      this.carrier_lowAcceleration = carrier_lowAcceleration;
      return this;
    }

    public Builder carrier_lowDeceleration(int carrier_lowDeceleration) {
      this.carrier_lowDeceleration = carrier_lowDeceleration;
      return this;
    }

    public Builder carrier_lowSpeed(int carrier_lowSpeed) {
      this.carrier_lowSpeed = carrier_lowSpeed;
      return this;
    }

    public Builder carrier_maxCurrent(int carrier_maxCurrent) {
      this.carrier_maxCurrent = carrier_maxCurrent;
      return this;
    }

    public Builder carrier_maxSpeed(int carrier_maxSpeed) {
      this.carrier_maxSpeed = carrier_maxSpeed;
      return this;
    }

    public Builder carrier_storagePosition(int carrier_storagePosition) {
      this.carrier_storagePosition = carrier_storagePosition;
      return this;
    }

    public Builder carrier_timeoutForGoingToEngaged(long carrier_timeoutForGoingToEngaged) {
      this.carrier_timeoutForGoingToEngaged = carrier_timeoutForGoingToEngaged;
      return this;
    }

    public Builder carrier_timeoutForGoingToHandOff(long carrier_timeoutForGoingToHandOff) {
      this.carrier_timeoutForGoingToHandOff = carrier_timeoutForGoingToHandOff;
      return this;
    }

    public Builder carrier_timeoutForGoingToStorage(long carrier_timeoutForGoingToStorage) {
      this.carrier_timeoutForGoingToStorage = carrier_timeoutForGoingToStorage;
      return this;
    }

    public Builder filterDistanceMin(int filterDistanceMin) {
      this.filterDistanceMin = filterDistanceMin;
      return this;
    }

    public Builder hooks_absolutePositionToClose(int hooks_absolutePositionToClose) {
      this.hooks_absolutePositionToClose = hooks_absolutePositionToClose;
      return this;
    }

    public Builder hooks_currentThreshold(int hooks_currentThreshold) {
      this.hooks_currentThreshold = hooks_currentThreshold;
      return this;
    }

    public Builder hooks_currentToClamp(int hooks_currentToClamp) {
      this.hooks_currentToClamp = hooks_currentToClamp;
      return this;
    }

    public Builder hooks_currentToOpen(int hooks_currentToOpen) {
      this.hooks_currentToOpen = hooks_currentToOpen;
      return this;
    }

    public Builder hooks_minClampedVoltage(int hooks_minClampedVoltage) {
      this.hooks_minClampedVoltage = hooks_minClampedVoltage;
      return this;
    }

    public Builder hooks_relativePositionToUnclamp(int hooks_relativePositionToUnclamp) {
      this.hooks_relativePositionToUnclamp = hooks_relativePositionToUnclamp;
      return this;
    }

    public Builder hooks_timeoutForClampingHooks(int hooks_timeoutForClampingHooks) {
      this.hooks_timeoutForClampingHooks = hooks_timeoutForClampingHooks;
      return this;
    }

    public Builder hooks_timeoutForClosingHooks(int hooks_timeoutForClosingHooks) {
      this.hooks_timeoutForClosingHooks = hooks_timeoutForClosingHooks;
      return this;
    }

    public Builder hooks_timeoutForOpeningHooks(int hooks_timeoutForOpeningHooks) {
      this.hooks_timeoutForOpeningHooks = hooks_timeoutForOpeningHooks;
      return this;
    }

    public Fcs_Loader_loaderConfigurationEvent build() {
      return new Fcs_Loader_loaderConfigurationEvent(version, carrier_deltaPosition, carrier_engagedPosition, carrier_handoffPosition, carrier_highAcceleration, carrier_highDeceleration, carrier_highSpeed, carrier_lowAcceleration, carrier_lowDeceleration, carrier_lowSpeed, carrier_maxCurrent, carrier_maxSpeed, carrier_storagePosition, carrier_timeoutForGoingToEngaged, carrier_timeoutForGoingToHandOff, carrier_timeoutForGoingToStorage, filterDistanceMin, hooks_absolutePositionToClose, hooks_currentThreshold, hooks_currentToClamp, hooks_currentToOpen, hooks_minClampedVoltage, hooks_relativePositionToUnclamp, hooks_timeoutForClampingHooks, hooks_timeoutForClosingHooks, hooks_timeoutForOpeningHooks);
    }
  }
}
