package org.lsst.sal.camera.event;

import org.lsst.sal.SALEnum;
import org.lsst.sal.camera.CameraEvent;

public class AlertRaisedEvent extends CameraEvent {
  private final double timestampAlertStatusChanged;

  private final String alertId;

  private final String description;

  private final CurrentSeverity currentSeverity;

  private final int highestSeverity;

  private final boolean isCleared;

  private final String cause;

  private final String origin;

  private final String additionalInfo;

  public AlertRaisedEvent(double timestampAlertStatusChanged, String alertId, String description,
      CurrentSeverity currentSeverity, int highestSeverity, boolean isCleared, String cause,
      String origin, String additionalInfo) {
    this.timestampAlertStatusChanged = timestampAlertStatusChanged;
    this.alertId = alertId;
    this.description = description;
    this.currentSeverity = currentSeverity;
    this.highestSeverity = highestSeverity;
    this.isCleared = isCleared;
    this.cause = cause;
    this.origin = origin;
    this.additionalInfo = additionalInfo;
  }

  public double getTimestampAlertStatusChanged() {
    return timestampAlertStatusChanged;
  }

  public String getAlertId() {
    return alertId;
  }

  public String getDescription() {
    return description;
  }

  public CurrentSeverity getCurrentSeverity() {
    return currentSeverity;
  }

  public int getHighestSeverity() {
    return highestSeverity;
  }

  public boolean isIsCleared() {
    return isCleared;
  }

  public String getCause() {
    return cause;
  }

  public String getOrigin() {
    return origin;
  }

  public String getAdditionalInfo() {
    return additionalInfo;
  }

  @Override
  public String toString() {
    return "AlertRaisedEvent{" + "timestampAlertStatusChanged=" + timestampAlertStatusChanged +
        ", alertId=" + alertId +", description=" + description +
        ", currentSeverity=" + currentSeverity +", highestSeverity=" + highestSeverity +
        ", isCleared=" + isCleared +", cause=" + cause +", origin=" + origin +
        ", additionalInfo=" + additionalInfo +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public enum CurrentSeverity implements SALEnum {
    NOMINAL,

    WARNING,

    ALARM
  }

  public static class Builder {
    private double timestampAlertStatusChanged;

    private String alertId;

    private String description;

    private CurrentSeverity currentSeverity;

    private int highestSeverity;

    private boolean isCleared;

    private String cause;

    private String origin;

    private String additionalInfo;

    private Builder() {
    }

    public Builder timestampAlertStatusChanged(double timestampAlertStatusChanged) {
      this.timestampAlertStatusChanged = timestampAlertStatusChanged;
      return this;
    }

    public Builder alertId(String alertId) {
      this.alertId = alertId;
      return this;
    }

    public Builder description(String description) {
      this.description = description;
      return this;
    }

    public Builder currentSeverity(CurrentSeverity currentSeverity) {
      this.currentSeverity = currentSeverity;
      return this;
    }

    public Builder highestSeverity(int highestSeverity) {
      this.highestSeverity = highestSeverity;
      return this;
    }

    public Builder isCleared(boolean isCleared) {
      this.isCleared = isCleared;
      return this;
    }

    public Builder cause(String cause) {
      this.cause = cause;
      return this;
    }

    public Builder origin(String origin) {
      this.origin = origin;
      return this;
    }

    public Builder additionalInfo(String additionalInfo) {
      this.additionalInfo = additionalInfo;
      return this;
    }

    public AlertRaisedEvent build() {
      return new AlertRaisedEvent(timestampAlertStatusChanged, alertId, description, currentSeverity, highestSeverity, isCleared, cause, origin, additionalInfo);
    }
  }
}
