/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.TestHelper;
import org.lsst.sal.camera.SALCamera;
import org.lsst.sal.camera.telemetry.Chiller_ChillerTelemetry;
import org.lsst.sal.camera.telemetry.Chiller_FParam_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Chiller_Maq20Telemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_Reb_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_StoreTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_Sum_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Autochanger_AutochangerTrucks_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Autochanger_Latches_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Autochanger_OnlineClamps_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Autochanger_TemperaturesTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_AcSensorsGateway_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_AcTruckXminusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_AcTruckXplusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_Accelerobf_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_Ai814_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_BrakeSystemGateway_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_CarouselController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_ClampXminusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_ClampXplusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_Hyttc580_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_LatchXminusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_LatchXplusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_OnlineClampXminusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_OnlineClampXplusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_OnlineClampYminusController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_OnlineStrainGauge_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_ProximitySensorsDevice_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_Pt100_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_TempSensorsDevice1_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus0_TempSensorsDevice2_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus1_CarrierController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus1_HooksController_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Canbus1_LoaderPlutoGateway_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_Socket1_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_Socket2_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_Socket3_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_Socket4_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_Socket5_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Carousel_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Duration_Autochanger_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Duration_Carousel_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Duration_Loader_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Duration_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Fcs_Mcm_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Loader_Carrier_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Loader_Hooks_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_CcdTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebTotalPowerTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebsAverageTemp6Telemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_SegmentTelemetry;
import org.lsst.sal.camera.telemetry.Hex_Cold1Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cold2Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo1Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo2Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo3Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo4Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo5Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo6Telemetry;
import org.lsst.sal.camera.telemetry.Quadbox_BFRTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_24VCTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_24VDTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_48VTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_5VTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_REB_Bulk_PSTelemetry;
import org.lsst.sal.camera.telemetry.Rebpower_RebTelemetry;
import org.lsst.sal.camera.telemetry.Rebpower_RebTotalPowerTelemetry;
import org.lsst.sal.camera.telemetry.Rebpower_RebpsTelemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo1Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo2Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo3Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo4Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo5Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo6Telemetry;
import org.lsst.sal.camera.telemetry.Shutter_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Thermal_Cold_TempTelemetry;
import org.lsst.sal.camera.telemetry.Thermal_Cryo_TempTelemetry;
import org.lsst.sal.camera.telemetry.Thermal_RtdTelemetry;
import org.lsst.sal.camera.telemetry.Thermal_TrimTelemetry;
import org.lsst.sal.camera.telemetry.Thermal_Trim_HtrsTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CipTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CryoTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_HXTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_InstTelemetry;

public class TelemetrySendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = SALCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALTelemetry testSendReceive(SALTelemetry item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALTelemetry> future = executor.submit(() -> sal.getTelemetry(Duration.ofSeconds(10L)));
        try {
            sal.sendTelemetry(item);
            SALTelemetry sALTelemetry = future.get(10L, TimeUnit.SECONDS);
            return sALTelemetry;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveQuadbox_BFRTelemetry() throws Exception {
        double clean_5_24V_I = 0.014082252979278564;
        double dirty_24V_I = 0.712326f;
        double dirty_28V_I = 0.7275546193122864;
        double dirty_48V_I = 0.6145391464233398;
        double protection_I = 0.8880361318588257;
        double rebps_0_2_I = 0.22129642963409424;
        double rebps_3_5_I = 0.9627864360809326;
        double rebps_6_8_I = 0.2701165f;
        double rebps_9_12_I = 0.33933937549591064;
        double rebps_Spr_I = 0.24647927284240723;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_BFRTelemetry(clean_5_24V_I, dirty_24V_I, dirty_28V_I, dirty_48V_I, protection_I, rebps_0_2_I, rebps_3_5_I, rebps_6_8_I, rebps_9_12_I, rebps_Spr_I));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFRTelemetry));
        Quadbox_BFRTelemetry item_ = (Quadbox_BFRTelemetry)item;
        Assert.assertEquals((double)clean_5_24V_I, (double)item_.getClean_5_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I, (double)item_.getDirty_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I, (double)item_.getDirty_28V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I, (double)item_.getDirty_48V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I, (double)item_.getProtection_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_2_I, (double)item_.getRebps_0_2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_3_5_I, (double)item_.getRebps_3_5_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_6_8_I, (double)item_.getRebps_6_8_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_9_12_I, (double)item_.getRebps_9_12_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_Spr_I, (double)item_.getRebps_Spr_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VCTelemetry() throws Exception {
        double board_T = 0.07695084810256958;
        double body_Maq20_I = 0.03155922889709473;
        double body_Maq20_V = 0.4448605179786682;
        double cryo_Maq20_I = 0.2482717f;
        double cryo_Maq20_V = 0.4946792f;
        double fes_CarouselC_I = 0.9692517518997192;
        double fes_CarouselC_V = 0.7337613701820374;
        double fes_ChangerC_I = 0.20207273960113525;
        double fes_ChangerC_V = 0.029231727123260498;
        double fes_LoaderC_I = 0.4125097990036011;
        double fes_LoaderC_V = 0.9769237637519836;
        double fpga_T = 0.9374368786811829;
        double gauges_I = 0.17189723253250122;
        double gauges_V = 0.676103949546814;
        double int_Valves_I = 0.45081013441085815;
        double int_Valves_V = 0.813667f;
        double ion_Pumps_I = 0.7160466313362122;
        double ion_Pumps_V = 0.988955557346344;
        double main_I = 0.7724771499633789;
        double main_T = 0.5280031561851501;
        double main_V = 0.972046f;
        double shtr_PLC1_I = 0.8862753510475159;
        double shtr_PLC1_V = 0.594191f;
        double shtr_PLC2_I = 0.8429875373840332;
        double shtr_PLC2_V = 0.7910156846046448;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VCTelemetry(board_T, body_Maq20_I, body_Maq20_V, cryo_Maq20_I, cryo_Maq20_V, fes_CarouselC_I, fes_CarouselC_V, fes_ChangerC_I, fes_ChangerC_V, fes_LoaderC_I, fes_LoaderC_V, fpga_T, gauges_I, gauges_V, int_Valves_I, int_Valves_V, ion_Pumps_I, ion_Pumps_V, main_I, main_T, main_V, shtr_PLC1_I, shtr_PLC1_V, shtr_PLC2_I, shtr_PLC2_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VCTelemetry));
        Quadbox_PDU_24VCTelemetry item_ = (Quadbox_PDU_24VCTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Maq20_I, (double)item_.getBody_Maq20_I(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Maq20_V, (double)item_.getBody_Maq20_V(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Maq20_I, (double)item_.getCryo_Maq20_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Maq20_V, (double)item_.getCryo_Maq20_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselC_I, (double)item_.getFes_CarouselC_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselC_V, (double)item_.getFes_CarouselC_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerC_I, (double)item_.getFes_ChangerC_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerC_V, (double)item_.getFes_ChangerC_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderC_I, (double)item_.getFes_LoaderC_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderC_V, (double)item_.getFes_LoaderC_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I, (double)item_.getGauges_I(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V, (double)item_.getGauges_V(), (double)1.0E-6f);
        Assert.assertEquals((double)int_Valves_I, (double)item_.getInt_Valves_I(), (double)1.0E-6f);
        Assert.assertEquals((double)int_Valves_V, (double)item_.getInt_Valves_V(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I, (double)item_.getIon_Pumps_I(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V, (double)item_.getIon_Pumps_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC1_I, (double)item_.getShtr_PLC1_I(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC1_V, (double)item_.getShtr_PLC1_V(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC2_I, (double)item_.getShtr_PLC2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC2_V, (double)item_.getShtr_PLC2_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VDTelemetry() throws Exception {
        double board_T = 0.7991674542427063;
        double cryo_Turbo_I = 0.5912559032440186;
        double cryo_Turbo_V = 0.9026452898979187;
        double fes_Brakes_I = 0.4686206579208374;
        double fes_Brakes_V = 0.9318344593048096;
        double fes_ChangerD_I = 0.9520131945610046;
        double fes_ChangerD_V = 0.849421501159668;
        double fes_Clamps_I = 0.9042651653289795;
        double fes_Clamps_V = 0.249159038066864;
        double fes_LoaderD_I = 0.23939085006713867;
        double fes_LoaderD_V = 0.937585f;
        double fpga_T = 0.4089372754096985;
        double hex_Turbo_I = 0.6403907537460327;
        double hex_Turbo_V = 0.12187862396240234;
        double main_I = 0.8118945956230164;
        double main_T = 0.5023233890533447;
        double main_V = 0.10235142707824707;
        double shtr_Brakes_I = 0.22951513528823853;
        double shtr_Brakes_V = 0.14620810747146606;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VDTelemetry(board_T, cryo_Turbo_I, cryo_Turbo_V, fes_Brakes_I, fes_Brakes_V, fes_ChangerD_I, fes_ChangerD_V, fes_Clamps_I, fes_Clamps_V, fes_LoaderD_I, fes_LoaderD_V, fpga_T, hex_Turbo_I, hex_Turbo_V, main_I, main_T, main_V, shtr_Brakes_I, shtr_Brakes_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VDTelemetry));
        Quadbox_PDU_24VDTelemetry item_ = (Quadbox_PDU_24VDTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I, (double)item_.getCryo_Turbo_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V, (double)item_.getCryo_Turbo_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Brakes_I, (double)item_.getFes_Brakes_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Brakes_V, (double)item_.getFes_Brakes_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerD_I, (double)item_.getFes_ChangerD_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerD_V, (double)item_.getFes_ChangerD_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Clamps_I, (double)item_.getFes_Clamps_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Clamps_V, (double)item_.getFes_Clamps_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderD_I, (double)item_.getFes_LoaderD_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderD_V, (double)item_.getFes_LoaderD_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_I, (double)item_.getHex_Turbo_I(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_V, (double)item_.getHex_Turbo_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Brakes_I, (double)item_.getShtr_Brakes_I(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Brakes_V, (double)item_.getShtr_Brakes_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_48VTelemetry() throws Exception {
        double board_T = 0.335641086101532;
        double fes_CarouselD_I = 0.263022780418396;
        double fes_CarouselD_V = 0.7666521072387695;
        double fes_Heater_I = 0.24449288845062256;
        double fes_Heater_V = 0.8929827213287354;
        double fpga_T = 0.2992633581161499;
        double main_I = 0.5752900838851929;
        double main_T = 0.34110045433044434;
        double main_V = 0.4360247254371643;
        double purge_Fan_I = 0.487007737159729;
        double purge_Fan_V = 0.9861726760864258;
        double shtr_Motor1_I = 0.3085457f;
        double shtr_Motor1_V = 0.2930535078048706;
        double shtr_Motor2_I = 0.3455388f;
        double shtr_Motor2_V = 0.9932084679603577;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_48VTelemetry(board_T, fes_CarouselD_I, fes_CarouselD_V, fes_Heater_I, fes_Heater_V, fpga_T, main_I, main_T, main_V, purge_Fan_I, purge_Fan_V, shtr_Motor1_I, shtr_Motor1_V, shtr_Motor2_I, shtr_Motor2_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48VTelemetry));
        Quadbox_PDU_48VTelemetry item_ = (Quadbox_PDU_48VTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselD_I, (double)item_.getFes_CarouselD_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselD_V, (double)item_.getFes_CarouselD_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Heater_I, (double)item_.getFes_Heater_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Heater_V, (double)item_.getFes_Heater_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_I, (double)item_.getPurge_Fan_I(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_V, (double)item_.getPurge_Fan_V(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor1_I, (double)item_.getShtr_Motor1_I(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor1_V, (double)item_.getShtr_Motor1_V(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor2_I, (double)item_.getShtr_Motor2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor2_V, (double)item_.getShtr_Motor2_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_5VTelemetry() throws Exception {
        double otm_0_A_I = 0.9153622388839722;
        double otm_0_A_V = 0.7848379611968994;
        double otm_0_B_I = 0.8268404006958008;
        double otm_0_B_V = 0.34192347526550293;
        double otm_1_A_I = 0.0654866099357605;
        double otm_1_A_V = 0.011506438255310059;
        double otm_1_B_I = 0.8747881054878235;
        double otm_1_B_V = 0.914415180683136;
        double otm_2_A_I = 0.0012892484664916992;
        double otm_2_A_V = 0.28396302461624146;
        double otm_2_B_I = 0.19581788778305054;
        double otm_2_B_V = 0.02968621253967285;
        double otm_3_A_I = 0.9376629590988159;
        double otm_3_A_V = 0.011319756507873535;
        double otm_3_B_I = 0.3921321f;
        double otm_3_B_V = 0.7454187273979187;
        double otm_4_A_I = 0.2029828429222107;
        double otm_4_A_V = 0.8962767124176025;
        double otm_4_B_I = 5.059242248535156E-4;
        double otm_4_B_V = 0.05946385860443115;
        double otm_5_A_I = 0.6483627557754517;
        double otm_5_A_V = 0.8404188752174377;
        double otm_5_B_I = 0.1350032091140747;
        double otm_5_B_V = 0.7589499354362488;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_5VTelemetry(otm_0_A_I, otm_0_A_V, otm_0_B_I, otm_0_B_V, otm_1_A_I, otm_1_A_V, otm_1_B_I, otm_1_B_V, otm_2_A_I, otm_2_A_V, otm_2_B_I, otm_2_B_V, otm_3_A_I, otm_3_A_V, otm_3_B_I, otm_3_B_V, otm_4_A_I, otm_4_A_V, otm_4_B_I, otm_4_B_V, otm_5_A_I, otm_5_A_V, otm_5_B_I, otm_5_B_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5VTelemetry));
        Quadbox_PDU_5VTelemetry item_ = (Quadbox_PDU_5VTelemetry)item;
        Assert.assertEquals((double)otm_0_A_I, (double)item_.getOtm_0_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_V, (double)item_.getOtm_0_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I, (double)item_.getOtm_0_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_V, (double)item_.getOtm_0_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_I, (double)item_.getOtm_1_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_V, (double)item_.getOtm_1_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_I, (double)item_.getOtm_1_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_V, (double)item_.getOtm_1_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_I, (double)item_.getOtm_2_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_V, (double)item_.getOtm_2_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_I, (double)item_.getOtm_2_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_V, (double)item_.getOtm_2_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I, (double)item_.getOtm_3_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V, (double)item_.getOtm_3_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I, (double)item_.getOtm_3_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V, (double)item_.getOtm_3_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_I, (double)item_.getOtm_4_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_V, (double)item_.getOtm_4_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_I, (double)item_.getOtm_4_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_V, (double)item_.getOtm_4_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_I, (double)item_.getOtm_5_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_V, (double)item_.getOtm_5_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_I, (double)item_.getOtm_5_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_V, (double)item_.getOtm_5_B_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_REB_Bulk_PSTelemetry() throws Exception {
        double rebbulkps_0_2_I = 0.8191808462142944;
        double rebbulkps_0_2_T = 0.22121495008468628;
        double rebbulkps_0_2_V = 0.6716911792755127;
        double rebbulkps_3_5_I = 0.07246226072311401;
        double rebbulkps_3_5_T = 0.3976835012435913;
        double rebbulkps_3_5_V = 0.3254147171974182;
        double rebbulkps_6_8_I = 0.44967198371887207;
        double rebbulkps_6_8_T = 0.8448562026023865;
        double rebbulkps_6_8_V = 0.47357481718063354;
        double rebbulkps_9_12_I = 0.06600093841552734;
        double rebbulkps_9_12_T = 0.14796394109725952;
        double rebbulkps_9_12_V = 0.6016800999641418;
        double rebbulkps_Brd_T = 0.797464907169342;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_REB_Bulk_PSTelemetry(rebbulkps_0_2_I, rebbulkps_0_2_T, rebbulkps_0_2_V, rebbulkps_3_5_I, rebbulkps_3_5_T, rebbulkps_3_5_V, rebbulkps_6_8_I, rebbulkps_6_8_T, rebbulkps_6_8_V, rebbulkps_9_12_I, rebbulkps_9_12_T, rebbulkps_9_12_V, rebbulkps_Brd_T));
        Assert.assertTrue((boolean)(item instanceof Quadbox_REB_Bulk_PSTelemetry));
        Quadbox_REB_Bulk_PSTelemetry item_ = (Quadbox_REB_Bulk_PSTelemetry)item;
        Assert.assertEquals((double)rebbulkps_0_2_I, (double)item_.getRebbulkps_0_2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_T, (double)item_.getRebbulkps_0_2_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_V, (double)item_.getRebbulkps_0_2_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_I, (double)item_.getRebbulkps_3_5_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_T, (double)item_.getRebbulkps_3_5_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_V, (double)item_.getRebbulkps_3_5_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_I, (double)item_.getRebbulkps_6_8_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_T, (double)item_.getRebbulkps_6_8_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_V, (double)item_.getRebbulkps_6_8_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_I, (double)item_.getRebbulkps_9_12_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_T, (double)item_.getRebbulkps_9_12_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_V, (double)item_.getRebbulkps_9_12_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_Brd_T, (double)item_.getRebbulkps_Brd_T(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebTelemetry() throws Exception {
        double[] analog_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)2067680626);
        double[] analog_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)322684031);
        double[] analog_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)454424190);
        double[] analog_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-635191096);
        double[] analog_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)1843372143);
        double[] clockhi_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)1983688752);
        double[] clockhi_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)711521384);
        double[] clockhi_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)585670427);
        double[] clockhi_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-828773170);
        double[] clockhi_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)1075374732);
        double[] clocklo_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)-241840392);
        double[] clocklo_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-815084281);
        double[] clocklo_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)997108157);
        double[] clocklo_VaftLDO2 = TestHelper.generateDoubleArray((int)71, (int)1046075422);
        double[] clocklo_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-1828609705);
        double[] clocklo_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)-535860068);
        double[] digital_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)-2123032458);
        double[] digital_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-1645700755);
        double[] digital_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)-643956880);
        double[] digital_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)1966057907);
        double[] digital_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)898731512);
        double[] dphi_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)-1488968538);
        double[] dphi_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)947337410);
        double[] dphi_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)-500849102);
        double[] dphi_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)871048185);
        double[] dphi_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)2037699960);
        double[] heater_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)-1771867018);
        double[] heater_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-192584049);
        double[] heater_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)-1722350310);
        double[] heater_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-78997697);
        double[] heater_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)-276890956);
        double[] hvbias_IbefSwch = TestHelper.generateDoubleArray((int)71, (int)-782663022);
        double[] hvbias_VbefSwch = TestHelper.generateDoubleArray((int)71, (int)1773127772);
        String location = "";
        double[] od_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)-736936143);
        double[] od_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-1452040610);
        double[] od_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)-1434284078);
        double[] od_VaftLDO2 = TestHelper.generateDoubleArray((int)71, (int)-368091646);
        double[] od_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)810254604);
        double[] od_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)945614769);
        double[] power = TestHelper.generateDoubleArray((int)71, (int)1508040344);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebTelemetry(analog_IaftLDO, analog_IbefLDO, analog_VaftLDO, analog_VaftSwch, analog_VbefLDO, clockhi_IaftLDO, clockhi_IbefLDO, clockhi_VaftLDO, clockhi_VaftSwch, clockhi_VbefLDO, clocklo_IaftLDO, clocklo_IbefLDO, clocklo_VaftLDO, clocklo_VaftLDO2, clocklo_VaftSwch, clocklo_VbefLDO, digital_IaftLDO, digital_IbefLDO, digital_VaftLDO, digital_VaftSwch, digital_VbefLDO, dphi_IaftLDO, dphi_IbefLDO, dphi_VaftLDO, dphi_VaftSwch, dphi_VbefLDO, heater_IaftLDO, heater_IbefLDO, heater_VaftLDO, heater_VaftSwch, heater_VbefLDO, hvbias_IbefSwch, hvbias_VbefSwch, location, od_IaftLDO, od_IbefLDO, od_VaftLDO, od_VaftLDO2, od_VaftSwch, od_VbefLDO, power));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebTelemetry));
        Rebpower_RebTelemetry item_ = (Rebpower_RebTelemetry)item;
        Assert.assertArrayEquals((double[])analog_IaftLDO, (double[])item_.getAnalog_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO, (double[])item_.getAnalog_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO, (double[])item_.getAnalog_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch, (double[])item_.getAnalog_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO, (double[])item_.getAnalog_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO, (double[])item_.getClockhi_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO, (double[])item_.getClockhi_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO, (double[])item_.getClockhi_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch, (double[])item_.getClockhi_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO, (double[])item_.getClockhi_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO, (double[])item_.getClocklo_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO, (double[])item_.getClocklo_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO, (double[])item_.getClocklo_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2, (double[])item_.getClocklo_VaftLDO2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch, (double[])item_.getClocklo_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO, (double[])item_.getClocklo_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO, (double[])item_.getDigital_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO, (double[])item_.getDigital_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO, (double[])item_.getDigital_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch, (double[])item_.getDigital_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO, (double[])item_.getDigital_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IaftLDO, (double[])item_.getDphi_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IbefLDO, (double[])item_.getDphi_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftLDO, (double[])item_.getDphi_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftSwch, (double[])item_.getDphi_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VbefLDO, (double[])item_.getDphi_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO, (double[])item_.getHeater_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO, (double[])item_.getHeater_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO, (double[])item_.getHeater_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch, (double[])item_.getHeater_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO, (double[])item_.getHeater_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch, (double[])item_.getHvbias_IbefSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch, (double[])item_.getHvbias_VbefSwch(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])od_IaftLDO, (double[])item_.getOd_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO, (double[])item_.getOd_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO, (double[])item_.getOd_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2, (double[])item_.getOd_VaftLDO2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch, (double[])item_.getOd_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO, (double[])item_.getOd_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebTotalPowerTelemetry() throws Exception {
        double rebTotalPower = 0.2324143648147583;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebTotalPowerTelemetry(rebTotalPower));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebTotalPowerTelemetry));
        Rebpower_RebTotalPowerTelemetry item_ = (Rebpower_RebTotalPowerTelemetry)item;
        Assert.assertEquals((double)rebTotalPower, (double)item_.getRebTotalPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebpsTelemetry() throws Exception {
        double[] boardTemp0 = TestHelper.generateDoubleArray((int)13, (int)-1695345702);
        double[] boardTemp1 = TestHelper.generateDoubleArray((int)13, (int)-143436950);
        double[] boardTemp2 = TestHelper.generateDoubleArray((int)13, (int)-1596892669);
        double[] boardTemp3 = TestHelper.generateDoubleArray((int)13, (int)1077101615);
        double[] boardTemp4 = TestHelper.generateDoubleArray((int)13, (int)145139199);
        double[] boardTemp5 = TestHelper.generateDoubleArray((int)13, (int)1552136011);
        double[] boardTemp6 = TestHelper.generateDoubleArray((int)13, (int)-1364137447);
        double[] fPGATemp = TestHelper.generateDoubleArray((int)13, (int)-447003981);
        String location = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebpsTelemetry(boardTemp0, boardTemp1, boardTemp2, boardTemp3, boardTemp4, boardTemp5, boardTemp6, fPGATemp, location));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebpsTelemetry));
        Rebpower_RebpsTelemetry item_ = (Rebpower_RebpsTelemetry)item;
        Assert.assertArrayEquals((double[])boardTemp0, (double[])item_.getBoardTemp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp1, (double[])item_.getBoardTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp2, (double[])item_.getBoardTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp3, (double[])item_.getBoardTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp4, (double[])item_.getBoardTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp5, (double[])item_.getBoardTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp6, (double[])item_.getBoardTemp6(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])fPGATemp, (double[])item_.getFPGATemp(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveHex_Cold1Telemetry() throws Exception {
        double returnTmp = 0.5975778102874756;
        double supplyTmp = 0.26185494661331177;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cold1Telemetry(returnTmp, supplyTmp));
        Assert.assertTrue((boolean)(item instanceof Hex_Cold1Telemetry));
        Hex_Cold1Telemetry item_ = (Hex_Cold1Telemetry)item;
        Assert.assertEquals((double)returnTmp, (double)item_.getReturnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyTmp, (double)item_.getSupplyTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cold2Telemetry() throws Exception {
        double returnTmp = 0.683756947517395;
        double supplyTmp = 0.2185322f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cold2Telemetry(returnTmp, supplyTmp));
        Assert.assertTrue((boolean)(item instanceof Hex_Cold2Telemetry));
        Hex_Cold2Telemetry item_ = (Hex_Cold2Telemetry)item;
        Assert.assertEquals((double)returnTmp, (double)item_.getReturnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyTmp, (double)item_.getSupplyTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo1Telemetry() throws Exception {
        double c3ExitTmp = 0.5969497561454773;
        double c4ExitTmp = 0.45133131742477417;
        double evapExitTmp = 0.6732280850410461;
        double hexRtrnTmp = 0.528732419013977;
        double liquidPrs = 0.4645213f;
        double preC3Tmp = 0.3172866702079773;
        double preC4Tmp = 0.10220718383789062;
        double returnPrs = 0.3028267025947571;
        double vaporPrs = 0.015305638313293457;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo1Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo1Telemetry));
        Hex_Cryo1Telemetry item_ = (Hex_Cryo1Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo2Telemetry() throws Exception {
        double c3ExitTmp = 0.749941885471344;
        double c4ExitTmp = 0.9972925782203674;
        double evapExitTmp = 0.4384235143661499;
        double hexRtrnTmp = 0.11301231384277344;
        double liquidPrs = 0.8862195014953613;
        double preC3Tmp = 0.7628299593925476;
        double preC4Tmp = 0.4655722975730896;
        double returnPrs = 0.45740777254104614;
        double vaporPrs = 0.6423649191856384;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo2Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo2Telemetry));
        Hex_Cryo2Telemetry item_ = (Hex_Cryo2Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo3Telemetry() throws Exception {
        double c3ExitTmp = 0.03408527374267578;
        double c4ExitTmp = 0.5276654958724976;
        double evapExitTmp = 0.6879861354827881;
        double hexRtrnTmp = 0.03431123495101929;
        double liquidPrs = 0.5901688933372498;
        double preC3Tmp = 0.9169453978538513;
        double preC4Tmp = 0.5657105445861816;
        double returnPrs = 0.4899718165397644;
        double vaporPrs = 0.9196410775184631;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo3Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo3Telemetry));
        Hex_Cryo3Telemetry item_ = (Hex_Cryo3Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo4Telemetry() throws Exception {
        double c3ExitTmp = 0.8170307874679565;
        double c4ExitTmp = 0.8965678215026855;
        double evapExitTmp = 0.3357229232788086;
        double hexRtrnTmp = 0.81204f;
        double liquidPrs = 0.4799065589904785;
        double preC3Tmp = 0.38088494539260864;
        double preC4Tmp = 0.09770017862319946;
        double returnPrs = 0.6987639665603638;
        double vaporPrs = 0.601096510887146;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo4Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo4Telemetry));
        Hex_Cryo4Telemetry item_ = (Hex_Cryo4Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo5Telemetry() throws Exception {
        double c3ExitTmp = 0.8367648124694824;
        double c4ExitTmp = 0.4286269545555115;
        double evapExitTmp = 0.11435937881469727;
        double hexRtrnTmp = 0.9560117721557617;
        double liquidPrs = 0.1462084f;
        double preC3Tmp = 0.037287235260009766;
        double preC4Tmp = 0.7124680876731873;
        double returnPrs = 0.8026264905929565;
        double vaporPrs = 0.7157336473464966;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo5Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo5Telemetry));
        Hex_Cryo5Telemetry item_ = (Hex_Cryo5Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo6Telemetry() throws Exception {
        double c3ExitTmp = 0.3481471538543701;
        double c4ExitTmp = 0.5082758069038391;
        double evapExitTmp = 0.34868013858795166;
        double hexRtrnTmp = 0.4024224877357483;
        double liquidPrs = 0.09383702278137207;
        double preC3Tmp = 0.08067286014556885;
        double preC4Tmp = 0.011679470539093018;
        double returnPrs = 0.4198077917098999;
        double vaporPrs = 0.1871771216392517;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo6Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo6Telemetry));
        Hex_Cryo6Telemetry item_ = (Hex_Cryo6Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo1Telemetry() throws Exception {
        double afterCoolTmp = 0.14254766702651978;
        double compCurrent = 0.8813273310661316;
        double compPower = 0.1599532961845398;
        double compVoltage = 0.029233217239379883;
        double dischrgPrs = 0.35733115673065186;
        double dischrgtmp_M = 0.9190243482589722;
        double dischrgtmp_P = 0.618203f;
        double fanSpeed = 0.5857173204421997;
        double oilLevel = 0.36539435386657715;
        double oilSepTmp = 0.01828134059906006;
        double phaseSepTmp = 0.9207425117492676;
        double suctionPrs = 0.7592307925224304;
        double suctiontmp_M = 0.397083044052124;
        double suctiontmp_P = 0.20187681913375854;
        double surgeTankTmp = 0.583291232585907;
        double waterInTmp = 0.6558170318603516;
        double waterOutTmp = 0.44259113073349;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo1Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo1Telemetry));
        Refrig_Cryo1Telemetry item_ = (Refrig_Cryo1Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo2Telemetry() throws Exception {
        double afterCoolTmp = 0.37315356731414795;
        double compCurrent = 0.5885370373725891;
        double compPower = 0.6006278395652771;
        double compVoltage = 0.965693f;
        double dischrgPrs = 0.17485326528549194;
        double dischrgtmp_M = 0.19256246089935303;
        double dischrgtmp_P = 0.21190357208251953;
        double fanSpeed = 0.4723653197288513;
        double oilLevel = 0.47234803438186646;
        double oilSepTmp = 0.8543391227722168;
        double phaseSepTmp = 0.46074116230010986;
        double suctionPrs = 0.6509405970573425;
        double suctiontmp_M = 0.6801722645759583;
        double suctiontmp_P = 0.6408683657646179;
        double surgeTankTmp = 0.5952237248420715;
        double waterInTmp = 0.20269042253494263;
        double waterOutTmp = 0.8306482434272766;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo2Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo2Telemetry));
        Refrig_Cryo2Telemetry item_ = (Refrig_Cryo2Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo3Telemetry() throws Exception {
        double afterCoolTmp = 0.4728173017501831;
        double ambientTmp = 0.7134791612625122;
        double cabinetTmp = 0.18630146980285645;
        double compCurrent = 0.7585159540176392;
        double compPower = 0.23626983165740967;
        double compVoltage = 0.9563217759132385;
        double dischrgPrs = 0.6528642177581787;
        double dischrgtmp_M = 0.691328763961792;
        double dischrgtmp_P = 0.9558330774307251;
        double fanSpeed = 0.03462434f;
        double oilLevel = 0.38666582107543945;
        double oilSepTmp = 0.6155957579612732;
        double phaseSepTmp = 0.278786838054657;
        double suctionPrs = 0.5909197330474854;
        double suctiontmp_M = 0.6687962412834167;
        double suctiontmp_P = 0.0849973f;
        double surgeTankTmp = 0.600838f;
        double waterInTmp = 0.6535108089447021;
        double waterOutTmp = 0.5135097503662109;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo3Telemetry(afterCoolTmp, ambientTmp, cabinetTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo3Telemetry));
        Refrig_Cryo3Telemetry item_ = (Refrig_Cryo3Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo4Telemetry() throws Exception {
        double afterCoolTmp = 0.2793514132499695;
        double compCurrent = 0.4285746216773987;
        double compPower = 0.8122632503509521;
        double compVoltage = 0.8002185225486755;
        double dischrgPrs = 0.5693804621696472;
        double dischrgtmp_M = 0.4447472095489502;
        double dischrgtmp_P = 0.3190999f;
        double fanSpeed = 0.03634554147720337;
        double oilLevel = 0.1288432478904724;
        double oilSepTmp = 0.15852785110473633;
        double phaseSepTmp = 0.8869417905807495;
        double suctionPrs = 0.1780725121498108;
        double suctiontmp_M = 0.1265236735343933;
        double suctiontmp_P = 0.68799889087677;
        double surgeTankTmp = 0.7755282521247864;
        double waterInTmp = 0.43794262409210205;
        double waterOutTmp = 0.1682819128036499;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo4Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo4Telemetry));
        Refrig_Cryo4Telemetry item_ = (Refrig_Cryo4Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo5Telemetry() throws Exception {
        double afterCoolTmp = 0.8560400605201721;
        double ambientTmp = 0.7613850831985474;
        double cabinetTmp = 0.39161497354507446;
        double compCurrent = 0.2143843173980713;
        double compPower = 0.36885833740234375;
        double compVoltage = 0.6955242156982422;
        double dischrgPrs = 0.922725f;
        double dischrgtmp_M = 0.5182716250419617;
        double dischrgtmp_P = 0.8896235823631287;
        double fanSpeed = 0.6626859307289124;
        double oilLevel = 0.7173235416412354;
        double oilSepTmp = 0.896554708480835;
        double phaseSepTmp = 0.5846288800239563;
        double suctionPrs = 0.8296563029289246;
        double suctiontmp_M = 0.6309148669242859;
        double suctiontmp_P = 0.10122638940811157;
        double surgeTankTmp = 0.4883200526237488;
        double waterInTmp = 0.17009252309799194;
        double waterOutTmp = 0.43547284603118896;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo5Telemetry(afterCoolTmp, ambientTmp, cabinetTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo5Telemetry));
        Refrig_Cryo5Telemetry item_ = (Refrig_Cryo5Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo6Telemetry() throws Exception {
        double afterCoolTmp = 0.30685955286026;
        double compCurrent = 0.35428208112716675;
        double compPower = 0.59520024061203;
        double compVoltage = 0.23540490865707397;
        double dischrgPrs = 0.9090507626533508;
        double dischrgtmp_M = 0.5953091979026794;
        double dischrgtmp_P = 0.022459805011749268;
        double fanSpeed = 0.3852902054786682;
        double oilLevel = 0.44482892751693726;
        double oilSepTmp = 0.2961214780807495;
        double phaseSepTmp = 0.4504796862602234;
        double suctionPrs = 0.6040089130401611;
        double suctiontmp_M = 0.558561f;
        double suctiontmp_P = 0.95185f;
        double surgeTankTmp = 0.7521445751190186;
        double waterInTmp = 0.35588985681533813;
        double waterOutTmp = 0.44355857372283936;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo6Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo6Telemetry));
        Refrig_Cryo6Telemetry item_ = (Refrig_Cryo6Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CipTelemetry() throws Exception {
        double[] cryo_I = TestHelper.generateDoubleArray((int)6, (int)-1484138497);
        double[] cryo_Life = TestHelper.generateDoubleArray((int)6, (int)768182713);
        double[] cryo_Usage = TestHelper.generateDoubleArray((int)6, (int)-1947121303);
        double[] cryo_V = TestHelper.generateDoubleArray((int)6, (int)273817228);
        double[] hx_I = TestHelper.generateDoubleArray((int)6, (int)-1959943044);
        double[] hx_Life = TestHelper.generateDoubleArray((int)6, (int)933184944);
        double[] hx_Usage = TestHelper.generateDoubleArray((int)6, (int)1665255604);
        double[] hx_V = TestHelper.generateDoubleArray((int)6, (int)13845093);
        String location = "s";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CipTelemetry(cryo_I, cryo_Life, cryo_Usage, cryo_V, hx_I, hx_Life, hx_Usage, hx_V, location));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CipTelemetry));
        Vacuum_CipTelemetry item_ = (Vacuum_CipTelemetry)item;
        Assert.assertArrayEquals((double[])cryo_I, (double[])item_.getCryo_I(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_Life, (double[])item_.getCryo_Life(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_Usage, (double[])item_.getCryo_Usage(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_V, (double[])item_.getCryo_V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_I, (double[])item_.getHx_I(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_Life, (double[])item_.getHx_Life(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_Usage, (double[])item_.getHx_Usage(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_V, (double[])item_.getHx_V(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveVacuum_CryoTelemetry() throws Exception {
        double airPressure = 0.5352170467376709;
        double cryoVac = 0.8839085102081299;
        double flineCurrent = 0.19910532236099243;
        double flinePower = 0.2420135736465454;
        double flineVoltage = 0.5680676698684692;
        double forelineVac = 0.6415224075317383;
        double gaugeDose = 0.6581142544746399;
        double pumpCartPressure = 0.6458249092102051;
        double turboCurrent = 0.6832186579704285;
        double turboGaugeDose = 0.3426624f;
        double turboHours = 0.5669072270393372;
        double turboPower = 0.868403434753418;
        double turboPumpStatus = 0.444133996963501;
        double turboPumpTemp = 0.7765841484069824;
        double turboSpeed = 0.3005765f;
        double turboVac = 0.33426398038864136;
        double turboVoltage = 0.2030550241470337;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CryoTelemetry(airPressure, cryoVac, flineCurrent, flinePower, flineVoltage, forelineVac, gaugeDose, pumpCartPressure, turboCurrent, turboGaugeDose, turboHours, turboPower, turboPumpStatus, turboPumpTemp, turboSpeed, turboVac, turboVoltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoTelemetry));
        Vacuum_CryoTelemetry item_ = (Vacuum_CryoTelemetry)item;
        Assert.assertEquals((double)airPressure, (double)item_.getAirPressure(), (double)1.0E-6f);
        Assert.assertEquals((double)cryoVac, (double)item_.getCryoVac(), (double)1.0E-6f);
        Assert.assertEquals((double)flineCurrent, (double)item_.getFlineCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)flinePower, (double)item_.getFlinePower(), (double)1.0E-6f);
        Assert.assertEquals((double)flineVoltage, (double)item_.getFlineVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)forelineVac, (double)item_.getForelineVac(), (double)1.0E-6f);
        Assert.assertEquals((double)gaugeDose, (double)item_.getGaugeDose(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpCartPressure, (double)item_.getPumpCartPressure(), (double)1.0E-6f);
        Assert.assertEquals((double)turboCurrent, (double)item_.getTurboCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)turboGaugeDose, (double)item_.getTurboGaugeDose(), (double)1.0E-6f);
        Assert.assertEquals((double)turboHours, (double)item_.getTurboHours(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPower, (double)item_.getTurboPower(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPumpStatus, (double)item_.getTurboPumpStatus(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPumpTemp, (double)item_.getTurboPumpTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)turboSpeed, (double)item_.getTurboSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)turboVac, (double)item_.getTurboVac(), (double)1.0E-6f);
        Assert.assertEquals((double)turboVoltage, (double)item_.getTurboVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_HXTelemetry() throws Exception {
        double airPressure = 0.4555372f;
        double flineCurrent = 0.9210861325263977;
        double flinePower = 0.17353105545043945;
        double flineVoltage = 0.7486221194267273;
        double forelineVac = 0.4283798336982727;
        double gaugeDose = 0.26659804582595825;
        double hexVac = 0.8799508810043335;
        double pumpCartPressure = 0.020609617233276367;
        double turboCurrent = 0.05208402872085571;
        double turboGaugeDose = 0.24147897958755493;
        double turboHours = 0.2122497f;
        double turboPower = 0.7351446151733398;
        double turboPumpStatus = 0.5014378428459167;
        double turboPumpTemp = 0.38984131813049316;
        double turboSpeed = 0.3622232675552368;
        double turboVac = 0.22005265951156616;
        double turboVoltage = 0.8336512446403503;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_HXTelemetry(airPressure, flineCurrent, flinePower, flineVoltage, forelineVac, gaugeDose, hexVac, pumpCartPressure, turboCurrent, turboGaugeDose, turboHours, turboPower, turboPumpStatus, turboPumpTemp, turboSpeed, turboVac, turboVoltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_HXTelemetry));
        Vacuum_HXTelemetry item_ = (Vacuum_HXTelemetry)item;
        Assert.assertEquals((double)airPressure, (double)item_.getAirPressure(), (double)1.0E-6f);
        Assert.assertEquals((double)flineCurrent, (double)item_.getFlineCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)flinePower, (double)item_.getFlinePower(), (double)1.0E-6f);
        Assert.assertEquals((double)flineVoltage, (double)item_.getFlineVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)forelineVac, (double)item_.getForelineVac(), (double)1.0E-6f);
        Assert.assertEquals((double)gaugeDose, (double)item_.getGaugeDose(), (double)1.0E-6f);
        Assert.assertEquals((double)hexVac, (double)item_.getHexVac(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpCartPressure, (double)item_.getPumpCartPressure(), (double)1.0E-6f);
        Assert.assertEquals((double)turboCurrent, (double)item_.getTurboCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)turboGaugeDose, (double)item_.getTurboGaugeDose(), (double)1.0E-6f);
        Assert.assertEquals((double)turboHours, (double)item_.getTurboHours(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPower, (double)item_.getTurboPower(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPumpStatus, (double)item_.getTurboPumpStatus(), (double)1.0E-6f);
        Assert.assertEquals((double)turboPumpTemp, (double)item_.getTurboPumpTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)turboSpeed, (double)item_.getTurboSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)turboVac, (double)item_.getTurboVac(), (double)1.0E-6f);
        Assert.assertEquals((double)turboVoltage, (double)item_.getTurboVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_InstTelemetry() throws Exception {
        double cryoFlineValveState = 0.8006823062896729;
        double flineCurrent = 0.40835005044937134;
        double flinePower = 0.054684996604919434;
        double flineVoltage = 0.1946696f;
        double hxFlineValveState = 0.8003453612327576;
        double instVac = 0.3892640471458435;
        double pumpCartCycling = 0.516148567199707;
        double pumpCartPressure = 0.6689355969429016;
        double pumpCartTemperature = 0.05160415172576904;
        double pumpCartVenting = 0.6360364556312561;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_InstTelemetry(cryoFlineValveState, flineCurrent, flinePower, flineVoltage, hxFlineValveState, instVac, pumpCartCycling, pumpCartPressure, pumpCartTemperature, pumpCartVenting));
        Assert.assertTrue((boolean)(item instanceof Vacuum_InstTelemetry));
        Vacuum_InstTelemetry item_ = (Vacuum_InstTelemetry)item;
        Assert.assertEquals((double)cryoFlineValveState, (double)item_.getCryoFlineValveState(), (double)1.0E-6f);
        Assert.assertEquals((double)flineCurrent, (double)item_.getFlineCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)flinePower, (double)item_.getFlinePower(), (double)1.0E-6f);
        Assert.assertEquals((double)flineVoltage, (double)item_.getFlineVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)hxFlineValveState, (double)item_.getHxFlineValveState(), (double)1.0E-6f);
        Assert.assertEquals((double)instVac, (double)item_.getInstVac(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpCartCycling, (double)item_.getPumpCartCycling(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpCartPressure, (double)item_.getPumpCartPressure(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpCartTemperature, (double)item_.getPumpCartTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpCartVenting, (double)item_.getPumpCartVenting(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_Reb_TrendingTelemetry() throws Exception {
        long[] driver_errors = TestHelper.generateLongArray((int)71, (int)-990770085);
        long[] driver_received = TestHelper.generateLongArray((int)71, (int)315123870);
        long[] driver_rx0 = TestHelper.generateLongArray((int)71, (int)-1386111918);
        long[] driver_rx1 = TestHelper.generateLongArray((int)71, (int)1795191463);
        long[] driver_rx2 = TestHelper.generateLongArray((int)71, (int)30189259);
        long[] driver_rx3 = TestHelper.generateLongArray((int)71, (int)-13514819);
        long[] firmware_cell_errors = TestHelper.generateLongArray((int)71, (int)-195090384);
        long[] firmware_last_rx = TestHelper.generateLongArray((int)71, (int)1326094356);
        long[] firmware_last_tx = TestHelper.generateLongArray((int)71, (int)-877444332);
        long[] firmware_link_down = TestHelper.generateLongArray((int)71, (int)-1142597197);
        long[] firmware_link_errors = TestHelper.generateLongArray((int)71, (int)1481887567);
        long[] firmware_link_status = TestHelper.generateLongArray((int)71, (int)-1089015963);
        long[] firmware_overflow_local0 = TestHelper.generateLongArray((int)71, (int)203172600);
        long[] firmware_overflow_local1 = TestHelper.generateLongArray((int)71, (int)-1374813576);
        long[] firmware_overflow_local2 = TestHelper.generateLongArray((int)71, (int)38460083);
        long[] firmware_overflow_local3 = TestHelper.generateLongArray((int)71, (int)102511756);
        long[] firmware_overflow_remote0 = TestHelper.generateLongArray((int)71, (int)-865859358);
        long[] firmware_overflow_remote1 = TestHelper.generateLongArray((int)71, (int)-885406717);
        long[] firmware_overflow_remote2 = TestHelper.generateLongArray((int)71, (int)627826616);
        long[] firmware_overflow_remote3 = TestHelper.generateLongArray((int)71, (int)-690203432);
        long[] firmware_rlink_data = TestHelper.generateLongArray((int)71, (int)857088075);
        long[] firmware_rx_clock = TestHelper.generateLongArray((int)71, (int)133404892);
        long[] firmware_rx_errors = TestHelper.generateLongArray((int)71, (int)692963599);
        long[] firmware_rx_frames = TestHelper.generateLongArray((int)71, (int)-1291264595);
        long[] firmware_rx_op = TestHelper.generateLongArray((int)71, (int)1339369567);
        long[] firmware_tx_clock = TestHelper.generateLongArray((int)71, (int)629662702);
        long[] firmware_tx_errors = TestHelper.generateLongArray((int)71, (int)-1300042747);
        long[] firmware_tx_frames = TestHelper.generateLongArray((int)71, (int)-55369097);
        long[] firmware_tx_op = TestHelper.generateLongArray((int)71, (int)-551244577);
        String location = "";
        long[] rds_bdi_firsts = TestHelper.generateLongArray((int)71, (int)1937419787);
        long[] rds_bdi_frees = TestHelper.generateLongArray((int)71, (int)-1362866724);
        long[] rds_bdi_lasts = TestHelper.generateLongArray((int)71, (int)-1460856504);
        long[] rds_bdi_nulls = TestHelper.generateLongArray((int)71, (int)160106024);
        long[] rds_bdi_overflows = TestHelper.generateLongArray((int)71, (int)-1768325518);
        long[] rds_bdi_seq_errors = TestHelper.generateLongArray((int)71, (int)1279840816);
        long[] rds_bdi_waits = TestHelper.generateLongArray((int)71, (int)1838338613);
        long[] rds_discards = TestHelper.generateLongArray((int)71, (int)-497543914);
        long[] rds_no_event = TestHelper.generateLongArray((int)71, (int)-1188026251);
        long[] rds_wakes = TestHelper.generateLongArray((int)71, (int)52292910);
        long[] rms_in_reset = TestHelper.generateLongArray((int)71, (int)0x101B0101);
        long[] rms_inv_tids = TestHelper.generateLongArray((int)71, (int)-2006860233);
        long[] rms_link_down = TestHelper.generateLongArray((int)71, (int)1376239996);
        long[] rms_lists_posted = TestHelper.generateLongArray((int)71, (int)-1404620061);
        long[] rms_ops_posted = TestHelper.generateLongArray((int)71, (int)1180628400);
        long[] rms_orphans = TestHelper.generateLongArray((int)71, (int)1601428381);
        long[] rms_probes = TestHelper.generateLongArray((int)71, (int)-37242977);
        long[] rms_responses = TestHelper.generateLongArray((int)71, (int)-568503315);
        long[] rms_rundowns = TestHelper.generateLongArray((int)71, (int)754533135);
        long[] rms_tid_hwm = TestHelper.generateLongArray((int)71, (int)1670933752);
        long[] rms_unopened = TestHelper.generateLongArray((int)71, (int)1271907432);
        long[] rms_waits = TestHelper.generateLongArray((int)71, (int)-1176071451);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_Reb_TrendingTelemetry(driver_errors, driver_received, driver_rx0, driver_rx1, driver_rx2, driver_rx3, firmware_cell_errors, firmware_last_rx, firmware_last_tx, firmware_link_down, firmware_link_errors, firmware_link_status, firmware_overflow_local0, firmware_overflow_local1, firmware_overflow_local2, firmware_overflow_local3, firmware_overflow_remote0, firmware_overflow_remote1, firmware_overflow_remote2, firmware_overflow_remote3, firmware_rlink_data, firmware_rx_clock, firmware_rx_errors, firmware_rx_frames, firmware_rx_op, firmware_tx_clock, firmware_tx_errors, firmware_tx_frames, firmware_tx_op, location, rds_bdi_firsts, rds_bdi_frees, rds_bdi_lasts, rds_bdi_nulls, rds_bdi_overflows, rds_bdi_seq_errors, rds_bdi_waits, rds_discards, rds_no_event, rds_wakes, rms_in_reset, rms_inv_tids, rms_link_down, rms_lists_posted, rms_ops_posted, rms_orphans, rms_probes, rms_responses, rms_rundowns, rms_tid_hwm, rms_unopened, rms_waits));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Reb_TrendingTelemetry));
        Daq_monitor_Reb_TrendingTelemetry item_ = (Daq_monitor_Reb_TrendingTelemetry)item;
        Assert.assertArrayEquals((long[])driver_errors, (long[])item_.getDriver_errors());
        Assert.assertArrayEquals((long[])driver_received, (long[])item_.getDriver_received());
        Assert.assertArrayEquals((long[])driver_rx0, (long[])item_.getDriver_rx0());
        Assert.assertArrayEquals((long[])driver_rx1, (long[])item_.getDriver_rx1());
        Assert.assertArrayEquals((long[])driver_rx2, (long[])item_.getDriver_rx2());
        Assert.assertArrayEquals((long[])driver_rx3, (long[])item_.getDriver_rx3());
        Assert.assertArrayEquals((long[])firmware_cell_errors, (long[])item_.getFirmware_cell_errors());
        Assert.assertArrayEquals((long[])firmware_last_rx, (long[])item_.getFirmware_last_rx());
        Assert.assertArrayEquals((long[])firmware_last_tx, (long[])item_.getFirmware_last_tx());
        Assert.assertArrayEquals((long[])firmware_link_down, (long[])item_.getFirmware_link_down());
        Assert.assertArrayEquals((long[])firmware_link_errors, (long[])item_.getFirmware_link_errors());
        Assert.assertArrayEquals((long[])firmware_link_status, (long[])item_.getFirmware_link_status());
        Assert.assertArrayEquals((long[])firmware_overflow_local0, (long[])item_.getFirmware_overflow_local0());
        Assert.assertArrayEquals((long[])firmware_overflow_local1, (long[])item_.getFirmware_overflow_local1());
        Assert.assertArrayEquals((long[])firmware_overflow_local2, (long[])item_.getFirmware_overflow_local2());
        Assert.assertArrayEquals((long[])firmware_overflow_local3, (long[])item_.getFirmware_overflow_local3());
        Assert.assertArrayEquals((long[])firmware_overflow_remote0, (long[])item_.getFirmware_overflow_remote0());
        Assert.assertArrayEquals((long[])firmware_overflow_remote1, (long[])item_.getFirmware_overflow_remote1());
        Assert.assertArrayEquals((long[])firmware_overflow_remote2, (long[])item_.getFirmware_overflow_remote2());
        Assert.assertArrayEquals((long[])firmware_overflow_remote3, (long[])item_.getFirmware_overflow_remote3());
        Assert.assertArrayEquals((long[])firmware_rlink_data, (long[])item_.getFirmware_rlink_data());
        Assert.assertArrayEquals((long[])firmware_rx_clock, (long[])item_.getFirmware_rx_clock());
        Assert.assertArrayEquals((long[])firmware_rx_errors, (long[])item_.getFirmware_rx_errors());
        Assert.assertArrayEquals((long[])firmware_rx_frames, (long[])item_.getFirmware_rx_frames());
        Assert.assertArrayEquals((long[])firmware_rx_op, (long[])item_.getFirmware_rx_op());
        Assert.assertArrayEquals((long[])firmware_tx_clock, (long[])item_.getFirmware_tx_clock());
        Assert.assertArrayEquals((long[])firmware_tx_errors, (long[])item_.getFirmware_tx_errors());
        Assert.assertArrayEquals((long[])firmware_tx_frames, (long[])item_.getFirmware_tx_frames());
        Assert.assertArrayEquals((long[])firmware_tx_op, (long[])item_.getFirmware_tx_op());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((long[])rds_bdi_firsts, (long[])item_.getRds_bdi_firsts());
        Assert.assertArrayEquals((long[])rds_bdi_frees, (long[])item_.getRds_bdi_frees());
        Assert.assertArrayEquals((long[])rds_bdi_lasts, (long[])item_.getRds_bdi_lasts());
        Assert.assertArrayEquals((long[])rds_bdi_nulls, (long[])item_.getRds_bdi_nulls());
        Assert.assertArrayEquals((long[])rds_bdi_overflows, (long[])item_.getRds_bdi_overflows());
        Assert.assertArrayEquals((long[])rds_bdi_seq_errors, (long[])item_.getRds_bdi_seq_errors());
        Assert.assertArrayEquals((long[])rds_bdi_waits, (long[])item_.getRds_bdi_waits());
        Assert.assertArrayEquals((long[])rds_discards, (long[])item_.getRds_discards());
        Assert.assertArrayEquals((long[])rds_no_event, (long[])item_.getRds_no_event());
        Assert.assertArrayEquals((long[])rds_wakes, (long[])item_.getRds_wakes());
        Assert.assertArrayEquals((long[])rms_in_reset, (long[])item_.getRms_in_reset());
        Assert.assertArrayEquals((long[])rms_inv_tids, (long[])item_.getRms_inv_tids());
        Assert.assertArrayEquals((long[])rms_link_down, (long[])item_.getRms_link_down());
        Assert.assertArrayEquals((long[])rms_lists_posted, (long[])item_.getRms_lists_posted());
        Assert.assertArrayEquals((long[])rms_ops_posted, (long[])item_.getRms_ops_posted());
        Assert.assertArrayEquals((long[])rms_orphans, (long[])item_.getRms_orphans());
        Assert.assertArrayEquals((long[])rms_probes, (long[])item_.getRms_probes());
        Assert.assertArrayEquals((long[])rms_responses, (long[])item_.getRms_responses());
        Assert.assertArrayEquals((long[])rms_rundowns, (long[])item_.getRms_rundowns());
        Assert.assertArrayEquals((long[])rms_tid_hwm, (long[])item_.getRms_tid_hwm());
        Assert.assertArrayEquals((long[])rms_unopened, (long[])item_.getRms_unopened());
        Assert.assertArrayEquals((long[])rms_waits, (long[])item_.getRms_waits());
    }

    @Test
    public void sendReceiveDaq_monitor_StoreTelemetry() throws Exception {
        double capacity = 0.6626887917518616;
        double freeFraction = 0.04965662956237793;
        double freeSpace = 0.0604214072227478;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_StoreTelemetry(capacity, freeFraction, freeSpace));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreTelemetry));
        Daq_monitor_StoreTelemetry item_ = (Daq_monitor_StoreTelemetry)item;
        Assert.assertEquals((double)capacity, (double)item_.getCapacity(), (double)1.0E-6f);
        Assert.assertEquals((double)freeFraction, (double)item_.getFreeFraction(), (double)1.0E-6f);
        Assert.assertEquals((double)freeSpace, (double)item_.getFreeSpace(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_Sum_TrendingTelemetry() throws Exception {
        long driver_errors = 468L;
        long firmware_cell_errors = 725L;
        long firmware_link_down = 117L;
        long firmware_link_errors = 830L;
        long firmware_overflow_local0 = 807L;
        long firmware_overflow_local1 = 269L;
        long firmware_overflow_local2 = 388L;
        long firmware_overflow_remote0 = 68L;
        long firmware_overflow_remote1 = 138L;
        long firmware_overflow_remote2 = 939L;
        long firmware_rx_errors = 769L;
        long firmware_tx_errors = 314L;
        long rds_bdi_nulls = 285L;
        long rds_bdi_overflows = 996L;
        long rds_bdi_seq_errors = 674L;
        long rds_discards = 903L;
        long rds_no_event = 394L;
        long rms_in_reset = 671L;
        long rms_inv_tids = 67L;
        long rms_link_down = 951L;
        long rms_orphans = 782L;
        long rms_unopened = 137L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_Sum_TrendingTelemetry(driver_errors, firmware_cell_errors, firmware_link_down, firmware_link_errors, firmware_overflow_local0, firmware_overflow_local1, firmware_overflow_local2, firmware_overflow_remote0, firmware_overflow_remote1, firmware_overflow_remote2, firmware_rx_errors, firmware_tx_errors, rds_bdi_nulls, rds_bdi_overflows, rds_bdi_seq_errors, rds_discards, rds_no_event, rms_in_reset, rms_inv_tids, rms_link_down, rms_orphans, rms_unopened));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Sum_TrendingTelemetry));
        Daq_monitor_Sum_TrendingTelemetry item_ = (Daq_monitor_Sum_TrendingTelemetry)item;
        Assert.assertEquals((long)driver_errors, (long)item_.getDriver_errors());
        Assert.assertEquals((long)firmware_cell_errors, (long)item_.getFirmware_cell_errors());
        Assert.assertEquals((long)firmware_link_down, (long)item_.getFirmware_link_down());
        Assert.assertEquals((long)firmware_link_errors, (long)item_.getFirmware_link_errors());
        Assert.assertEquals((long)firmware_overflow_local0, (long)item_.getFirmware_overflow_local0());
        Assert.assertEquals((long)firmware_overflow_local1, (long)item_.getFirmware_overflow_local1());
        Assert.assertEquals((long)firmware_overflow_local2, (long)item_.getFirmware_overflow_local2());
        Assert.assertEquals((long)firmware_overflow_remote0, (long)item_.getFirmware_overflow_remote0());
        Assert.assertEquals((long)firmware_overflow_remote1, (long)item_.getFirmware_overflow_remote1());
        Assert.assertEquals((long)firmware_overflow_remote2, (long)item_.getFirmware_overflow_remote2());
        Assert.assertEquals((long)firmware_rx_errors, (long)item_.getFirmware_rx_errors());
        Assert.assertEquals((long)firmware_tx_errors, (long)item_.getFirmware_tx_errors());
        Assert.assertEquals((long)rds_bdi_nulls, (long)item_.getRds_bdi_nulls());
        Assert.assertEquals((long)rds_bdi_overflows, (long)item_.getRds_bdi_overflows());
        Assert.assertEquals((long)rds_bdi_seq_errors, (long)item_.getRds_bdi_seq_errors());
        Assert.assertEquals((long)rds_discards, (long)item_.getRds_discards());
        Assert.assertEquals((long)rds_no_event, (long)item_.getRds_no_event());
        Assert.assertEquals((long)rms_in_reset, (long)item_.getRms_in_reset());
        Assert.assertEquals((long)rms_inv_tids, (long)item_.getRms_inv_tids());
        Assert.assertEquals((long)rms_link_down, (long)item_.getRms_link_down());
        Assert.assertEquals((long)rms_orphans, (long)item_.getRms_orphans());
        Assert.assertEquals((long)rms_unopened, (long)item_.getRms_unopened());
    }

    @Test
    public void sendReceiveFocal_plane_CcdTelemetry() throws Exception {
        double[] gDV = TestHelper.generateDoubleArray((int)201, (int)859429570);
        String location = "l";
        double[] oDI = TestHelper.generateDoubleArray((int)201, (int)-223742977);
        double[] oDV = TestHelper.generateDoubleArray((int)201, (int)-1736107374);
        double[] oGV = TestHelper.generateDoubleArray((int)201, (int)129041134);
        double[] rDV = TestHelper.generateDoubleArray((int)201, (int)-1522719881);
        double[] temp = TestHelper.generateDoubleArray((int)201, (int)-1985476781);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_CcdTelemetry(gDV, location, oDI, oDV, oGV, rDV, temp));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_CcdTelemetry));
        Focal_plane_CcdTelemetry item_ = (Focal_plane_CcdTelemetry)item;
        Assert.assertArrayEquals((double[])gDV, (double[])item_.getGDV(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oGV, (double[])item_.getOGV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rDV, (double[])item_.getRDV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp, (double[])item_.getTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTelemetry() throws Exception {
        double[] anaI = TestHelper.generateDoubleArray((int)71, (int)-938604525);
        double[] anaV = TestHelper.generateDoubleArray((int)71, (int)159772113);
        double[] aspicl_Temp0 = TestHelper.generateDoubleArray((int)71, (int)-1926963066);
        double[] aspicl_Temp1 = TestHelper.generateDoubleArray((int)71, (int)1160753278);
        double[] aspicl_Temp2 = TestHelper.generateDoubleArray((int)71, (int)-1003192026);
        double[] aspicu_Temp0 = TestHelper.generateDoubleArray((int)71, (int)-841380869);
        double[] aspicu_Temp1 = TestHelper.generateDoubleArray((int)71, (int)-1910799660);
        double[] aspicu_Temp2 = TestHelper.generateDoubleArray((int)71, (int)-1070253627);
        double[] clkHI = TestHelper.generateDoubleArray((int)71, (int)-1981996956);
        double[] clkHV = TestHelper.generateDoubleArray((int)71, (int)-330658050);
        double[] clkLI = TestHelper.generateDoubleArray((int)71, (int)533067864);
        double[] clkLV = TestHelper.generateDoubleArray((int)71, (int)2038477162);
        double[] digI = TestHelper.generateDoubleArray((int)71, (int)1197262709);
        double[] digV = TestHelper.generateDoubleArray((int)71, (int)651350160);
        double[] hVBiasSwitch = TestHelper.generateDoubleArray((int)71, (int)1502926846);
        double[] htrPI = TestHelper.generateDoubleArray((int)71, (int)1768359691);
        double[] htrPV = TestHelper.generateDoubleArray((int)71, (int)1021442721);
        double[] htrV = TestHelper.generateDoubleArray((int)71, (int)1666861201);
        double[] htrW = TestHelper.generateDoubleArray((int)71, (int)-2096187054);
        String location = "";
        double[] oDI = TestHelper.generateDoubleArray((int)71, (int)1172300199);
        double[] oDV = TestHelper.generateDoubleArray((int)71, (int)-327884980);
        double[] pClk0 = TestHelper.generateDoubleArray((int)71, (int)-29633672);
        double[] pClk1 = TestHelper.generateDoubleArray((int)71, (int)-1382439513);
        double[] pClkL = TestHelper.generateDoubleArray((int)71, (int)1592263117);
        double[] pClkU = TestHelper.generateDoubleArray((int)71, (int)-290152451);
        double[] power = TestHelper.generateDoubleArray((int)71, (int)-2034755745);
        double[] rG0 = TestHelper.generateDoubleArray((int)71, (int)1931809978);
        double[] rG1 = TestHelper.generateDoubleArray((int)71, (int)-1667431112);
        double[] rGL = TestHelper.generateDoubleArray((int)71, (int)1452150674);
        double[] rGU = TestHelper.generateDoubleArray((int)71, (int)-963626698);
        double[] rTDTemp = TestHelper.generateDoubleArray((int)71, (int)-142291839);
        double[] ref05V = TestHelper.generateDoubleArray((int)71, (int)-130407555);
        double[] ref125V = TestHelper.generateDoubleArray((int)71, (int)1315220405);
        double[] ref15V = TestHelper.generateDoubleArray((int)71, (int)-882811618);
        double[] ref25V = TestHelper.generateDoubleArray((int)71, (int)1111582477);
        double[] refN12 = TestHelper.generateDoubleArray((int)71, (int)-372244617);
        double[] refP12 = TestHelper.generateDoubleArray((int)71, (int)-248392182);
        double[] sClk0 = TestHelper.generateDoubleArray((int)71, (int)-377857248);
        double[] sClk1 = TestHelper.generateDoubleArray((int)71, (int)-1092756634);
        double[] sClkL = TestHelper.generateDoubleArray((int)71, (int)-384758182);
        double[] sClkU = TestHelper.generateDoubleArray((int)71, (int)613986229);
        double[] temp1 = TestHelper.generateDoubleArray((int)71, (int)1127796320);
        double[] temp10 = TestHelper.generateDoubleArray((int)71, (int)-1760579921);
        double[] temp2 = TestHelper.generateDoubleArray((int)71, (int)-661332984);
        double[] temp3 = TestHelper.generateDoubleArray((int)71, (int)-1990350562);
        double[] temp4 = TestHelper.generateDoubleArray((int)71, (int)399205267);
        double[] temp5 = TestHelper.generateDoubleArray((int)71, (int)-1192848505);
        double[] temp6 = TestHelper.generateDoubleArray((int)71, (int)-434454365);
        double[] temp7 = TestHelper.generateDoubleArray((int)71, (int)-1553937928);
        double[] temp8 = TestHelper.generateDoubleArray((int)71, (int)-2128209234);
        double[] temp9 = TestHelper.generateDoubleArray((int)71, (int)-725345359);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTelemetry(anaI, anaV, aspicl_Temp0, aspicl_Temp1, aspicl_Temp2, aspicu_Temp0, aspicu_Temp1, aspicu_Temp2, clkHI, clkHV, clkLI, clkLV, digI, digV, hVBiasSwitch, htrPI, htrPV, htrV, htrW, location, oDI, oDV, pClk0, pClk1, pClkL, pClkU, power, rG0, rG1, rGL, rGU, rTDTemp, ref05V, ref125V, ref15V, ref25V, refN12, refP12, sClk0, sClk1, sClkL, sClkU, temp1, temp10, temp2, temp3, temp4, temp5, temp6, temp7, temp8, temp9));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTelemetry));
        Focal_plane_RebTelemetry item_ = (Focal_plane_RebTelemetry)item;
        Assert.assertArrayEquals((double[])anaI, (double[])item_.getAnaI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anaV, (double[])item_.getAnaV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0, (double[])item_.getAspicl_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1, (double[])item_.getAspicl_Temp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2, (double[])item_.getAspicl_Temp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0, (double[])item_.getAspicu_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1, (double[])item_.getAspicu_Temp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2, (double[])item_.getAspicu_Temp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHI, (double[])item_.getClkHI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHV, (double[])item_.getClkHV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLI, (double[])item_.getClkLI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLV, (double[])item_.getClkLV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digI, (double[])item_.getDigI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digV, (double[])item_.getDigV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hVBiasSwitch, (double[])item_.getHVBiasSwitch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrPI, (double[])item_.getHtrPI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrPV, (double[])item_.getHtrPV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrV, (double[])item_.getHtrV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrW, (double[])item_.getHtrW(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClk0, (double[])item_.getPClk0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClk1, (double[])item_.getPClk1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkL, (double[])item_.getPClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkU, (double[])item_.getPClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rG0, (double[])item_.getRG0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rG1, (double[])item_.getRG1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGL, (double[])item_.getRGL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGU, (double[])item_.getRGU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rTDTemp, (double[])item_.getRTDTemp(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05V, (double[])item_.getRef05V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125V, (double[])item_.getRef125V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15V, (double[])item_.getRef15V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25V, (double[])item_.getRef25V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refN12, (double[])item_.getRefN12(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refP12, (double[])item_.getRefP12(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClk0, (double[])item_.getSClk0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClk1, (double[])item_.getSClk1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkL, (double[])item_.getSClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkU, (double[])item_.getSClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1, (double[])item_.getTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10, (double[])item_.getTemp10(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2, (double[])item_.getTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3, (double[])item_.getTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4, (double[])item_.getTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5, (double[])item_.getTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6, (double[])item_.getTemp6(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7, (double[])item_.getTemp7(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8, (double[])item_.getTemp8(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9, (double[])item_.getTemp9(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTotalPowerTelemetry() throws Exception {
        double rebTotalPower = 0.1944863200187683;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTotalPowerTelemetry(rebTotalPower));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTotalPowerTelemetry));
        Focal_plane_RebTotalPowerTelemetry item_ = (Focal_plane_RebTotalPowerTelemetry)item;
        Assert.assertEquals((double)rebTotalPower, (double)item_.getRebTotalPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebsAverageTemp6Telemetry() throws Exception {
        double rebsAverageTemp6 = 0.6197198033332825;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebsAverageTemp6Telemetry(rebsAverageTemp6));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebsAverageTemp6Telemetry));
        Focal_plane_RebsAverageTemp6Telemetry item_ = (Focal_plane_RebsAverageTemp6Telemetry)item;
        Assert.assertEquals((double)rebsAverageTemp6, (double)item_.getRebsAverageTemp6(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_SegmentTelemetry() throws Exception {
        double[] i = TestHelper.generateDoubleArray((int)3024, (int)-1400082465);
        String location = "o";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_SegmentTelemetry(i, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SegmentTelemetry));
        Focal_plane_SegmentTelemetry item_ = (Focal_plane_SegmentTelemetry)item;
        Assert.assertArrayEquals((double[])i, (double[])item_.getI(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFcs_Autochanger_AutochangerTrucks_TrendingTelemetry() throws Exception {
        boolean actruckxminus_handoffInError = true;
        boolean actruckxminus_handoffSensorValue = false;
        boolean actruckxminus_onlineInError = false;
        boolean actruckxminus_onlineSensorValue = true;
        int actruckxminus_position = 366;
        boolean actruckxminus_standbyInError = false;
        boolean actruckxminus_standbySensorValue = true;
        boolean actruckxplus_handoffInError = true;
        boolean actruckxplus_handoffSensorValue = false;
        boolean actruckxplus_onlineInError = false;
        boolean actruckxplus_onlineSensorValue = true;
        int actruckxplus_position = 667;
        boolean actruckxplus_standbyInError = false;
        boolean actruckxplus_standbySensorValue = false;
        boolean atHandoff = false;
        boolean atOnline = true;
        boolean atStandby = true;
        int driverPosition = 754;
        int followerPosition = 733;
        boolean homingDone = false;
        boolean inError = true;
        int proximityDistance = 224;
        double proximityVoltage = 0.04007077217102051;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Autochanger_AutochangerTrucks_TrendingTelemetry(actruckxminus_handoffInError, actruckxminus_handoffSensorValue, actruckxminus_onlineInError, actruckxminus_onlineSensorValue, actruckxminus_position, actruckxminus_standbyInError, actruckxminus_standbySensorValue, actruckxplus_handoffInError, actruckxplus_handoffSensorValue, actruckxplus_onlineInError, actruckxplus_onlineSensorValue, actruckxplus_position, actruckxplus_standbyInError, actruckxplus_standbySensorValue, atHandoff, atOnline, atStandby, driverPosition, followerPosition, homingDone, inError, proximityDistance, proximityVoltage));
        Assert.assertTrue((boolean)(item instanceof Fcs_Autochanger_AutochangerTrucks_TrendingTelemetry));
        Fcs_Autochanger_AutochangerTrucks_TrendingTelemetry item_ = (Fcs_Autochanger_AutochangerTrucks_TrendingTelemetry)item;
        Assert.assertEquals((Object)actruckxminus_handoffInError, (Object)item_.isActruckxminus_handoffInError());
        Assert.assertEquals((Object)actruckxminus_handoffSensorValue, (Object)item_.isActruckxminus_handoffSensorValue());
        Assert.assertEquals((Object)actruckxminus_onlineInError, (Object)item_.isActruckxminus_onlineInError());
        Assert.assertEquals((Object)actruckxminus_onlineSensorValue, (Object)item_.isActruckxminus_onlineSensorValue());
        Assert.assertEquals((long)actruckxminus_position, (long)item_.getActruckxminus_position());
        Assert.assertEquals((Object)actruckxminus_standbyInError, (Object)item_.isActruckxminus_standbyInError());
        Assert.assertEquals((Object)actruckxminus_standbySensorValue, (Object)item_.isActruckxminus_standbySensorValue());
        Assert.assertEquals((Object)actruckxplus_handoffInError, (Object)item_.isActruckxplus_handoffInError());
        Assert.assertEquals((Object)actruckxplus_handoffSensorValue, (Object)item_.isActruckxplus_handoffSensorValue());
        Assert.assertEquals((Object)actruckxplus_onlineInError, (Object)item_.isActruckxplus_onlineInError());
        Assert.assertEquals((Object)actruckxplus_onlineSensorValue, (Object)item_.isActruckxplus_onlineSensorValue());
        Assert.assertEquals((long)actruckxplus_position, (long)item_.getActruckxplus_position());
        Assert.assertEquals((Object)actruckxplus_standbyInError, (Object)item_.isActruckxplus_standbyInError());
        Assert.assertEquals((Object)actruckxplus_standbySensorValue, (Object)item_.isActruckxplus_standbySensorValue());
        Assert.assertEquals((Object)atHandoff, (Object)item_.isAtHandoff());
        Assert.assertEquals((Object)atOnline, (Object)item_.isAtOnline());
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((long)driverPosition, (long)item_.getDriverPosition());
        Assert.assertEquals((long)followerPosition, (long)item_.getFollowerPosition());
        Assert.assertEquals((Object)homingDone, (Object)item_.isHomingDone());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)proximityDistance, (long)item_.getProximityDistance());
        Assert.assertEquals((double)proximityVoltage, (double)item_.getProximityVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Autochanger_Latches_TrendingTelemetry() throws Exception {
        int filterId = 369;
        String filterName = "";
        String filterPresenceStatus = "";
        boolean latchxminus_filterEngagedSensorsInError = true;
        boolean latchxminus_filterPresenceSensorValue = false;
        boolean latchxminus_inError = true;
        boolean latchxminus_lockSensorValue = false;
        boolean latchxminus_lockSensorsInError = false;
        String latchxminus_lockStatus = "b";
        boolean latchxminus_unlockSensorValue = false;
        boolean latchxminus_unlockSensorsInError = true;
        boolean latchxplus_filterEngagedSensorsInError = true;
        boolean latchxplus_filterPresenceSensorValue = false;
        boolean latchxplus_inError = true;
        boolean latchxplus_lockSensorValue = true;
        boolean latchxplus_lockSensorsInError = false;
        String latchxplus_lockStatus = "t";
        boolean latchxplus_unlockSensorValue = true;
        boolean latchxplus_unlockSensorsInError = false;
        String lockStatus = "g";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Autochanger_Latches_TrendingTelemetry(filterId, filterName, filterPresenceStatus, latchxminus_filterEngagedSensorsInError, latchxminus_filterPresenceSensorValue, latchxminus_inError, latchxminus_lockSensorValue, latchxminus_lockSensorsInError, latchxminus_lockStatus, latchxminus_unlockSensorValue, latchxminus_unlockSensorsInError, latchxplus_filterEngagedSensorsInError, latchxplus_filterPresenceSensorValue, latchxplus_inError, latchxplus_lockSensorValue, latchxplus_lockSensorsInError, latchxplus_lockStatus, latchxplus_unlockSensorValue, latchxplus_unlockSensorsInError, lockStatus));
        Assert.assertTrue((boolean)(item instanceof Fcs_Autochanger_Latches_TrendingTelemetry));
        Fcs_Autochanger_Latches_TrendingTelemetry item_ = (Fcs_Autochanger_Latches_TrendingTelemetry)item;
        Assert.assertEquals((long)filterId, (long)item_.getFilterId());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)filterPresenceStatus, (Object)item_.getFilterPresenceStatus());
        Assert.assertEquals((Object)latchxminus_filterEngagedSensorsInError, (Object)item_.isLatchxminus_filterEngagedSensorsInError());
        Assert.assertEquals((Object)latchxminus_filterPresenceSensorValue, (Object)item_.isLatchxminus_filterPresenceSensorValue());
        Assert.assertEquals((Object)latchxminus_inError, (Object)item_.isLatchxminus_inError());
        Assert.assertEquals((Object)latchxminus_lockSensorValue, (Object)item_.isLatchxminus_lockSensorValue());
        Assert.assertEquals((Object)latchxminus_lockSensorsInError, (Object)item_.isLatchxminus_lockSensorsInError());
        Assert.assertEquals((Object)latchxminus_lockStatus, (Object)item_.getLatchxminus_lockStatus());
        Assert.assertEquals((Object)latchxminus_unlockSensorValue, (Object)item_.isLatchxminus_unlockSensorValue());
        Assert.assertEquals((Object)latchxminus_unlockSensorsInError, (Object)item_.isLatchxminus_unlockSensorsInError());
        Assert.assertEquals((Object)latchxplus_filterEngagedSensorsInError, (Object)item_.isLatchxplus_filterEngagedSensorsInError());
        Assert.assertEquals((Object)latchxplus_filterPresenceSensorValue, (Object)item_.isLatchxplus_filterPresenceSensorValue());
        Assert.assertEquals((Object)latchxplus_inError, (Object)item_.isLatchxplus_inError());
        Assert.assertEquals((Object)latchxplus_lockSensorValue, (Object)item_.isLatchxplus_lockSensorValue());
        Assert.assertEquals((Object)latchxplus_lockSensorsInError, (Object)item_.isLatchxplus_lockSensorsInError());
        Assert.assertEquals((Object)latchxplus_lockStatus, (Object)item_.getLatchxplus_lockStatus());
        Assert.assertEquals((Object)latchxplus_unlockSensorValue, (Object)item_.isLatchxplus_unlockSensorValue());
        Assert.assertEquals((Object)latchxplus_unlockSensorsInError, (Object)item_.isLatchxplus_unlockSensorsInError());
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
    }

    @Test
    public void sendReceiveFcs_Autochanger_OnlineClamps_TrendingTelemetry() throws Exception {
        String lockStatus = "w";
        int onlineClampRawStrain = 163;
        int onlineClampStrain = 582;
        boolean onlineclampxminus_inError = true;
        boolean onlineclampxminus_lockSensorInError = true;
        boolean onlineclampxminus_lockSensorValue = false;
        String onlineclampxminus_lockStatus = "";
        int onlineclampxminus_sentCurrent = 740;
        boolean onlineclampxminus_unlockSensorInError = true;
        boolean onlineclampxminus_unlockSensorValue = true;
        boolean onlineclampxplus_inError = true;
        boolean onlineclampxplus_lockSensorInError = true;
        boolean onlineclampxplus_lockSensorValue = true;
        String onlineclampxplus_lockStatus = "a";
        int onlineclampxplus_sentCurrent = 130;
        boolean onlineclampxplus_unlockSensorInError = true;
        boolean onlineclampxplus_unlockSensorValue = false;
        boolean onlineclampyminus_inError = true;
        boolean onlineclampyminus_lockSensorInError = false;
        boolean onlineclampyminus_lockSensorValue = true;
        String onlineclampyminus_lockStatus = "";
        int onlineclampyminus_sentCurrent = 271;
        boolean onlineclampyminus_unlockSensorInError = true;
        boolean onlineclampyminus_unlockSensorValue = false;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Autochanger_OnlineClamps_TrendingTelemetry(lockStatus, onlineClampRawStrain, onlineClampStrain, onlineclampxminus_inError, onlineclampxminus_lockSensorInError, onlineclampxminus_lockSensorValue, onlineclampxminus_lockStatus, onlineclampxminus_sentCurrent, onlineclampxminus_unlockSensorInError, onlineclampxminus_unlockSensorValue, onlineclampxplus_inError, onlineclampxplus_lockSensorInError, onlineclampxplus_lockSensorValue, onlineclampxplus_lockStatus, onlineclampxplus_sentCurrent, onlineclampxplus_unlockSensorInError, onlineclampxplus_unlockSensorValue, onlineclampyminus_inError, onlineclampyminus_lockSensorInError, onlineclampyminus_lockSensorValue, onlineclampyminus_lockStatus, onlineclampyminus_sentCurrent, onlineclampyminus_unlockSensorInError, onlineclampyminus_unlockSensorValue));
        Assert.assertTrue((boolean)(item instanceof Fcs_Autochanger_OnlineClamps_TrendingTelemetry));
        Fcs_Autochanger_OnlineClamps_TrendingTelemetry item_ = (Fcs_Autochanger_OnlineClamps_TrendingTelemetry)item;
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
        Assert.assertEquals((long)onlineClampRawStrain, (long)item_.getOnlineClampRawStrain());
        Assert.assertEquals((long)onlineClampStrain, (long)item_.getOnlineClampStrain());
        Assert.assertEquals((Object)onlineclampxminus_inError, (Object)item_.isOnlineclampxminus_inError());
        Assert.assertEquals((Object)onlineclampxminus_lockSensorInError, (Object)item_.isOnlineclampxminus_lockSensorInError());
        Assert.assertEquals((Object)onlineclampxminus_lockSensorValue, (Object)item_.isOnlineclampxminus_lockSensorValue());
        Assert.assertEquals((Object)onlineclampxminus_lockStatus, (Object)item_.getOnlineclampxminus_lockStatus());
        Assert.assertEquals((long)onlineclampxminus_sentCurrent, (long)item_.getOnlineclampxminus_sentCurrent());
        Assert.assertEquals((Object)onlineclampxminus_unlockSensorInError, (Object)item_.isOnlineclampxminus_unlockSensorInError());
        Assert.assertEquals((Object)onlineclampxminus_unlockSensorValue, (Object)item_.isOnlineclampxminus_unlockSensorValue());
        Assert.assertEquals((Object)onlineclampxplus_inError, (Object)item_.isOnlineclampxplus_inError());
        Assert.assertEquals((Object)onlineclampxplus_lockSensorInError, (Object)item_.isOnlineclampxplus_lockSensorInError());
        Assert.assertEquals((Object)onlineclampxplus_lockSensorValue, (Object)item_.isOnlineclampxplus_lockSensorValue());
        Assert.assertEquals((Object)onlineclampxplus_lockStatus, (Object)item_.getOnlineclampxplus_lockStatus());
        Assert.assertEquals((long)onlineclampxplus_sentCurrent, (long)item_.getOnlineclampxplus_sentCurrent());
        Assert.assertEquals((Object)onlineclampxplus_unlockSensorInError, (Object)item_.isOnlineclampxplus_unlockSensorInError());
        Assert.assertEquals((Object)onlineclampxplus_unlockSensorValue, (Object)item_.isOnlineclampxplus_unlockSensorValue());
        Assert.assertEquals((Object)onlineclampyminus_inError, (Object)item_.isOnlineclampyminus_inError());
        Assert.assertEquals((Object)onlineclampyminus_lockSensorInError, (Object)item_.isOnlineclampyminus_lockSensorInError());
        Assert.assertEquals((Object)onlineclampyminus_lockSensorValue, (Object)item_.isOnlineclampyminus_lockSensorValue());
        Assert.assertEquals((Object)onlineclampyminus_lockStatus, (Object)item_.getOnlineclampyminus_lockStatus());
        Assert.assertEquals((long)onlineclampyminus_sentCurrent, (long)item_.getOnlineclampyminus_sentCurrent());
        Assert.assertEquals((Object)onlineclampyminus_unlockSensorInError, (Object)item_.isOnlineclampyminus_unlockSensorInError());
        Assert.assertEquals((Object)onlineclampyminus_unlockSensorValue, (Object)item_.isOnlineclampyminus_unlockSensorValue());
    }

    @Test
    public void sendReceiveFcs_Autochanger_TemperaturesTelemetry() throws Exception {
        double tempCellXminus = 0.2221236228942871;
        double tempClampMotorXminus = 0.7435727715492249;
        double tempClampMotorXplus = 0.32882362604141235;
        double tempClampMotorYminus = 0.18640172481536865;
        double tempFrontBox = 0.331407f;
        double tempLinearRailMotorXminus = 0.49448084831237793;
        double tempLinearRailMotorXplus = 0.6153187155723572;
        double tempRearBox = 0.3528764843940735;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Autochanger_TemperaturesTelemetry(tempCellXminus, tempClampMotorXminus, tempClampMotorXplus, tempClampMotorYminus, tempFrontBox, tempLinearRailMotorXminus, tempLinearRailMotorXplus, tempRearBox));
        Assert.assertTrue((boolean)(item instanceof Fcs_Autochanger_TemperaturesTelemetry));
        Fcs_Autochanger_TemperaturesTelemetry item_ = (Fcs_Autochanger_TemperaturesTelemetry)item;
        Assert.assertEquals((double)tempCellXminus, (double)item_.getTempCellXminus(), (double)1.0E-6f);
        Assert.assertEquals((double)tempClampMotorXminus, (double)item_.getTempClampMotorXminus(), (double)1.0E-6f);
        Assert.assertEquals((double)tempClampMotorXplus, (double)item_.getTempClampMotorXplus(), (double)1.0E-6f);
        Assert.assertEquals((double)tempClampMotorYminus, (double)item_.getTempClampMotorYminus(), (double)1.0E-6f);
        Assert.assertEquals((double)tempFrontBox, (double)item_.getTempFrontBox(), (double)1.0E-6f);
        Assert.assertEquals((double)tempLinearRailMotorXminus, (double)item_.getTempLinearRailMotorXminus(), (double)1.0E-6f);
        Assert.assertEquals((double)tempLinearRailMotorXplus, (double)item_.getTempLinearRailMotorXplus(), (double)1.0E-6f);
        Assert.assertEquals((double)tempRearBox, (double)item_.getTempRearBox(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Canbus0_AcSensorsGateway_TrendingTelemetry() throws Exception {
        int acAF0b = 976;
        int acAF0s = 487;
        int acAF1b = 332;
        int acAF1s = 529;
        int acAF3b = 826;
        int acAF3s = 378;
        int acAP2b = 455;
        int acAP2s = 931;
        int carouselHoldingFilterSensor0 = 583;
        int carouselHoldingFilterSensor1 = 217;
        int carouselStoppedAtStandby = 139;
        int carouselStoppedAtStandbyC = 897;
        int carousel_CF0 = 190;
        int carousel_CF0_C = 802;
        int carousel_CF1 = 9;
        int carousel_CF1_C = 322;
        int clampedStatusSensor = 490;
        int closeSensorBLatchXminus = 897;
        int closeSensorBLatchXplus = 350;
        int closeSensorLatchXminus = 165;
        int closeSensorLatchXplus = 656;
        int engineeringKey = 368;
        int engineeringkey_C = 812;
        int filterEngagedSensorBLatchXminus = 176;
        int filterEngagedSensorBLatchXplus = 822;
        int filterEngagedSensorLatchXminus = 814;
        int filterEngagedSensorLatchXplus = 370;
        int filterIDSensor0 = 117;
        int filterIDSensor1 = 3;
        int filterIDSensor2 = 810;
        int filterIDSensor3 = 454;
        int filterIDSensor4 = 994;
        int filterIDSensor5 = 677;
        int forceSensor0 = 403;
        int forceSensor1 = 598;
        int handoffPositionSensorBXminus = 444;
        int handoffPositionSensorBXplus = 214;
        int handoffPositionSensorXminus = 374;
        int handoffPositionSensorXplus = 462;
        double inclinometerXminus = 0.534893f;
        double inclinometerXplus = 0.574421226978302;
        int keyEng = 986;
        int keyEngb = 579;
        int keyLock = 76;
        int keyLockb = 39;
        int lps_0 = 635;
        int lps_1 = 718;
        int lrh_0 = 583;
        int lrh_1 = 942;
        int loaderCarrierRelayStatus = 801;
        int loaderChainPresenceSensor = 620;
        int loaderCloseSensor1 = 595;
        int loaderCloseSensor2 = 441;
        int loaderCloseSensor3 = 540;
        int loaderCloseSensor4 = 611;
        int loaderConnectedSensor = 581;
        int loaderConnectedSensorC = 313;
        int loaderDefaultStatus = 542;
        int loaderEngagedPositionSensor0 = 319;
        int loaderEngagedPositionSensor1 = 506;
        int loaderFilterDistanceSensor = 135;
        int loaderFilterGoodPositionStatus = 213;
        int loaderFilterPresenceSensor0 = 667;
        int loaderFilterPresenceSensor1 = 150;
        int loaderHandoffPositionSensor0 = 808;
        int loaderHandoffPositionSensor1 = 356;
        int loaderHoldingFilterSensor0 = 883;
        int loaderHoldingFilterSensor1 = 178;
        int loaderHooksRelayStatus = 694;
        int loaderOnCameraSensor0 = 846;
        int loaderOnCameraSensor1 = 693;
        int loaderOpenSensor1 = 97;
        int loaderOpenSensor2 = 967;
        int loaderOpenSensor3 = 798;
        int loaderOpenSensor4 = 768;
        int loaderStoragePositionSensor0 = 591;
        int loaderStoragePositionSensor1 = 822;
        int loader_LFD = 309;
        int loader_LFS = 388;
        int lockOut = 278;
        int lockOutShunt = 648;
        int lockout_C = 49;
        int lpmLatchesStatus = 881;
        int lpmLinearRail1Status = 711;
        int lpmLinearRail2Status = 681;
        int lpmOnlineClampsStatus = 94;
        int out_AF0 = 764;
        int out_AF0_C = 890;
        int out_AF1 = 973;
        int out_AF1_C = 3;
        int out_AF3 = 124;
        int out_AF3_C = 297;
        int out_AIN = 730;
        int out_AOL = 556;
        int out_AP1 = 355;
        int out_AP1_C = 975;
        int out_AP2 = 306;
        int out_AP2_C = 440;
        int out_AP3 = 672;
        int out_AP3_C = 800;
        int onlineClampXminusCloseSensor = 207;
        int onlineClampXminusCloseSensorC = 94;
        int onlineClampXminusOpenSensor = 729;
        int onlineClampXminusOpenSensorC = 301;
        int onlineClampXplusCloseSensor = 703;
        int onlineClampXplusCloseSensorC = 145;
        int onlineClampXplusOpenSensor = 781;
        int onlineClampXplusOpenSensorC = 224;
        int onlineClampYminusCloseSensor = 711;
        int onlineClampYminusCloseSensorC = 685;
        int onlineClampYminusOpenSensor = 311;
        int onlineClampYminusOpenSensorC = 406;
        int onlinePositionSensorBXminus = 724;
        int onlinePositionSensorBXplus = 412;
        int onlinePositionSensorXminus = 15;
        int onlinePositionSensorXplus = 13;
        int openSensorBLatchXminus = 364;
        int openSensorBLatchXplus = 714;
        int openSensorLatchXminus = 339;
        int openSensorLatchXplus = 107;
        int overClampedStatusSensor = 595;
        int presenceLoader = 33;
        int presenceloader_C = 491;
        int standbyPositionSensorBXminus = 896;
        int standbyPositionSensorBXplus = 698;
        int standbyPositionSensorXminus = 58;
        int standbyPositionSensorXplus = 146;
        int unclampedStatusSensor = 122;
        int underClampedStatusSensor = 914;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_AcSensorsGateway_TrendingTelemetry(acAF0b, acAF0s, acAF1b, acAF1s, acAF3b, acAF3s, acAP2b, acAP2s, carouselHoldingFilterSensor0, carouselHoldingFilterSensor1, carouselStoppedAtStandby, carouselStoppedAtStandbyC, carousel_CF0, carousel_CF0_C, carousel_CF1, carousel_CF1_C, clampedStatusSensor, closeSensorBLatchXminus, closeSensorBLatchXplus, closeSensorLatchXminus, closeSensorLatchXplus, engineeringKey, engineeringkey_C, filterEngagedSensorBLatchXminus, filterEngagedSensorBLatchXplus, filterEngagedSensorLatchXminus, filterEngagedSensorLatchXplus, filterIDSensor0, filterIDSensor1, filterIDSensor2, filterIDSensor3, filterIDSensor4, filterIDSensor5, forceSensor0, forceSensor1, handoffPositionSensorBXminus, handoffPositionSensorBXplus, handoffPositionSensorXminus, handoffPositionSensorXplus, inclinometerXminus, inclinometerXplus, keyEng, keyEngb, keyLock, keyLockb, lps_0, lps_1, lrh_0, lrh_1, loaderCarrierRelayStatus, loaderChainPresenceSensor, loaderCloseSensor1, loaderCloseSensor2, loaderCloseSensor3, loaderCloseSensor4, loaderConnectedSensor, loaderConnectedSensorC, loaderDefaultStatus, loaderEngagedPositionSensor0, loaderEngagedPositionSensor1, loaderFilterDistanceSensor, loaderFilterGoodPositionStatus, loaderFilterPresenceSensor0, loaderFilterPresenceSensor1, loaderHandoffPositionSensor0, loaderHandoffPositionSensor1, loaderHoldingFilterSensor0, loaderHoldingFilterSensor1, loaderHooksRelayStatus, loaderOnCameraSensor0, loaderOnCameraSensor1, loaderOpenSensor1, loaderOpenSensor2, loaderOpenSensor3, loaderOpenSensor4, loaderStoragePositionSensor0, loaderStoragePositionSensor1, loader_LFD, loader_LFS, lockOut, lockOutShunt, lockout_C, lpmLatchesStatus, lpmLinearRail1Status, lpmLinearRail2Status, lpmOnlineClampsStatus, out_AF0, out_AF0_C, out_AF1, out_AF1_C, out_AF3, out_AF3_C, out_AIN, out_AOL, out_AP1, out_AP1_C, out_AP2, out_AP2_C, out_AP3, out_AP3_C, onlineClampXminusCloseSensor, onlineClampXminusCloseSensorC, onlineClampXminusOpenSensor, onlineClampXminusOpenSensorC, onlineClampXplusCloseSensor, onlineClampXplusCloseSensorC, onlineClampXplusOpenSensor, onlineClampXplusOpenSensorC, onlineClampYminusCloseSensor, onlineClampYminusCloseSensorC, onlineClampYminusOpenSensor, onlineClampYminusOpenSensorC, onlinePositionSensorBXminus, onlinePositionSensorBXplus, onlinePositionSensorXminus, onlinePositionSensorXplus, openSensorBLatchXminus, openSensorBLatchXplus, openSensorLatchXminus, openSensorLatchXplus, overClampedStatusSensor, presenceLoader, presenceloader_C, standbyPositionSensorBXminus, standbyPositionSensorBXplus, standbyPositionSensorXminus, standbyPositionSensorXplus, unclampedStatusSensor, underClampedStatusSensor));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_AcSensorsGateway_TrendingTelemetry));
        Fcs_Canbus0_AcSensorsGateway_TrendingTelemetry item_ = (Fcs_Canbus0_AcSensorsGateway_TrendingTelemetry)item;
        Assert.assertEquals((long)acAF0b, (long)item_.getAcAF0b());
        Assert.assertEquals((long)acAF0s, (long)item_.getAcAF0s());
        Assert.assertEquals((long)acAF1b, (long)item_.getAcAF1b());
        Assert.assertEquals((long)acAF1s, (long)item_.getAcAF1s());
        Assert.assertEquals((long)acAF3b, (long)item_.getAcAF3b());
        Assert.assertEquals((long)acAF3s, (long)item_.getAcAF3s());
        Assert.assertEquals((long)acAP2b, (long)item_.getAcAP2b());
        Assert.assertEquals((long)acAP2s, (long)item_.getAcAP2s());
        Assert.assertEquals((long)carouselHoldingFilterSensor0, (long)item_.getCarouselHoldingFilterSensor0());
        Assert.assertEquals((long)carouselHoldingFilterSensor1, (long)item_.getCarouselHoldingFilterSensor1());
        Assert.assertEquals((long)carouselStoppedAtStandby, (long)item_.getCarouselStoppedAtStandby());
        Assert.assertEquals((long)carouselStoppedAtStandbyC, (long)item_.getCarouselStoppedAtStandbyC());
        Assert.assertEquals((long)carousel_CF0, (long)item_.getCarousel_CF0());
        Assert.assertEquals((long)carousel_CF0_C, (long)item_.getCarousel_CF0_C());
        Assert.assertEquals((long)carousel_CF1, (long)item_.getCarousel_CF1());
        Assert.assertEquals((long)carousel_CF1_C, (long)item_.getCarousel_CF1_C());
        Assert.assertEquals((long)clampedStatusSensor, (long)item_.getClampedStatusSensor());
        Assert.assertEquals((long)closeSensorBLatchXminus, (long)item_.getCloseSensorBLatchXminus());
        Assert.assertEquals((long)closeSensorBLatchXplus, (long)item_.getCloseSensorBLatchXplus());
        Assert.assertEquals((long)closeSensorLatchXminus, (long)item_.getCloseSensorLatchXminus());
        Assert.assertEquals((long)closeSensorLatchXplus, (long)item_.getCloseSensorLatchXplus());
        Assert.assertEquals((long)engineeringKey, (long)item_.getEngineeringKey());
        Assert.assertEquals((long)engineeringkey_C, (long)item_.getEngineeringkey_C());
        Assert.assertEquals((long)filterEngagedSensorBLatchXminus, (long)item_.getFilterEngagedSensorBLatchXminus());
        Assert.assertEquals((long)filterEngagedSensorBLatchXplus, (long)item_.getFilterEngagedSensorBLatchXplus());
        Assert.assertEquals((long)filterEngagedSensorLatchXminus, (long)item_.getFilterEngagedSensorLatchXminus());
        Assert.assertEquals((long)filterEngagedSensorLatchXplus, (long)item_.getFilterEngagedSensorLatchXplus());
        Assert.assertEquals((long)filterIDSensor0, (long)item_.getFilterIDSensor0());
        Assert.assertEquals((long)filterIDSensor1, (long)item_.getFilterIDSensor1());
        Assert.assertEquals((long)filterIDSensor2, (long)item_.getFilterIDSensor2());
        Assert.assertEquals((long)filterIDSensor3, (long)item_.getFilterIDSensor3());
        Assert.assertEquals((long)filterIDSensor4, (long)item_.getFilterIDSensor4());
        Assert.assertEquals((long)filterIDSensor5, (long)item_.getFilterIDSensor5());
        Assert.assertEquals((long)forceSensor0, (long)item_.getForceSensor0());
        Assert.assertEquals((long)forceSensor1, (long)item_.getForceSensor1());
        Assert.assertEquals((long)handoffPositionSensorBXminus, (long)item_.getHandoffPositionSensorBXminus());
        Assert.assertEquals((long)handoffPositionSensorBXplus, (long)item_.getHandoffPositionSensorBXplus());
        Assert.assertEquals((long)handoffPositionSensorXminus, (long)item_.getHandoffPositionSensorXminus());
        Assert.assertEquals((long)handoffPositionSensorXplus, (long)item_.getHandoffPositionSensorXplus());
        Assert.assertEquals((double)inclinometerXminus, (double)item_.getInclinometerXminus(), (double)1.0E-6f);
        Assert.assertEquals((double)inclinometerXplus, (double)item_.getInclinometerXplus(), (double)1.0E-6f);
        Assert.assertEquals((long)keyEng, (long)item_.getKeyEng());
        Assert.assertEquals((long)keyEngb, (long)item_.getKeyEngb());
        Assert.assertEquals((long)keyLock, (long)item_.getKeyLock());
        Assert.assertEquals((long)keyLockb, (long)item_.getKeyLockb());
        Assert.assertEquals((long)lps_0, (long)item_.getLps_0());
        Assert.assertEquals((long)lps_1, (long)item_.getLps_1());
        Assert.assertEquals((long)lrh_0, (long)item_.getLrh_0());
        Assert.assertEquals((long)lrh_1, (long)item_.getLrh_1());
        Assert.assertEquals((long)loaderCarrierRelayStatus, (long)item_.getLoaderCarrierRelayStatus());
        Assert.assertEquals((long)loaderChainPresenceSensor, (long)item_.getLoaderChainPresenceSensor());
        Assert.assertEquals((long)loaderCloseSensor1, (long)item_.getLoaderCloseSensor1());
        Assert.assertEquals((long)loaderCloseSensor2, (long)item_.getLoaderCloseSensor2());
        Assert.assertEquals((long)loaderCloseSensor3, (long)item_.getLoaderCloseSensor3());
        Assert.assertEquals((long)loaderCloseSensor4, (long)item_.getLoaderCloseSensor4());
        Assert.assertEquals((long)loaderConnectedSensor, (long)item_.getLoaderConnectedSensor());
        Assert.assertEquals((long)loaderConnectedSensorC, (long)item_.getLoaderConnectedSensorC());
        Assert.assertEquals((long)loaderDefaultStatus, (long)item_.getLoaderDefaultStatus());
        Assert.assertEquals((long)loaderEngagedPositionSensor0, (long)item_.getLoaderEngagedPositionSensor0());
        Assert.assertEquals((long)loaderEngagedPositionSensor1, (long)item_.getLoaderEngagedPositionSensor1());
        Assert.assertEquals((long)loaderFilterDistanceSensor, (long)item_.getLoaderFilterDistanceSensor());
        Assert.assertEquals((long)loaderFilterGoodPositionStatus, (long)item_.getLoaderFilterGoodPositionStatus());
        Assert.assertEquals((long)loaderFilterPresenceSensor0, (long)item_.getLoaderFilterPresenceSensor0());
        Assert.assertEquals((long)loaderFilterPresenceSensor1, (long)item_.getLoaderFilterPresenceSensor1());
        Assert.assertEquals((long)loaderHandoffPositionSensor0, (long)item_.getLoaderHandoffPositionSensor0());
        Assert.assertEquals((long)loaderHandoffPositionSensor1, (long)item_.getLoaderHandoffPositionSensor1());
        Assert.assertEquals((long)loaderHoldingFilterSensor0, (long)item_.getLoaderHoldingFilterSensor0());
        Assert.assertEquals((long)loaderHoldingFilterSensor1, (long)item_.getLoaderHoldingFilterSensor1());
        Assert.assertEquals((long)loaderHooksRelayStatus, (long)item_.getLoaderHooksRelayStatus());
        Assert.assertEquals((long)loaderOnCameraSensor0, (long)item_.getLoaderOnCameraSensor0());
        Assert.assertEquals((long)loaderOnCameraSensor1, (long)item_.getLoaderOnCameraSensor1());
        Assert.assertEquals((long)loaderOpenSensor1, (long)item_.getLoaderOpenSensor1());
        Assert.assertEquals((long)loaderOpenSensor2, (long)item_.getLoaderOpenSensor2());
        Assert.assertEquals((long)loaderOpenSensor3, (long)item_.getLoaderOpenSensor3());
        Assert.assertEquals((long)loaderOpenSensor4, (long)item_.getLoaderOpenSensor4());
        Assert.assertEquals((long)loaderStoragePositionSensor0, (long)item_.getLoaderStoragePositionSensor0());
        Assert.assertEquals((long)loaderStoragePositionSensor1, (long)item_.getLoaderStoragePositionSensor1());
        Assert.assertEquals((long)loader_LFD, (long)item_.getLoader_LFD());
        Assert.assertEquals((long)loader_LFS, (long)item_.getLoader_LFS());
        Assert.assertEquals((long)lockOut, (long)item_.getLockOut());
        Assert.assertEquals((long)lockOutShunt, (long)item_.getLockOutShunt());
        Assert.assertEquals((long)lockout_C, (long)item_.getLockout_C());
        Assert.assertEquals((long)lpmLatchesStatus, (long)item_.getLpmLatchesStatus());
        Assert.assertEquals((long)lpmLinearRail1Status, (long)item_.getLpmLinearRail1Status());
        Assert.assertEquals((long)lpmLinearRail2Status, (long)item_.getLpmLinearRail2Status());
        Assert.assertEquals((long)lpmOnlineClampsStatus, (long)item_.getLpmOnlineClampsStatus());
        Assert.assertEquals((long)out_AF0, (long)item_.getOut_AF0());
        Assert.assertEquals((long)out_AF0_C, (long)item_.getOut_AF0_C());
        Assert.assertEquals((long)out_AF1, (long)item_.getOut_AF1());
        Assert.assertEquals((long)out_AF1_C, (long)item_.getOut_AF1_C());
        Assert.assertEquals((long)out_AF3, (long)item_.getOut_AF3());
        Assert.assertEquals((long)out_AF3_C, (long)item_.getOut_AF3_C());
        Assert.assertEquals((long)out_AIN, (long)item_.getOut_AIN());
        Assert.assertEquals((long)out_AOL, (long)item_.getOut_AOL());
        Assert.assertEquals((long)out_AP1, (long)item_.getOut_AP1());
        Assert.assertEquals((long)out_AP1_C, (long)item_.getOut_AP1_C());
        Assert.assertEquals((long)out_AP2, (long)item_.getOut_AP2());
        Assert.assertEquals((long)out_AP2_C, (long)item_.getOut_AP2_C());
        Assert.assertEquals((long)out_AP3, (long)item_.getOut_AP3());
        Assert.assertEquals((long)out_AP3_C, (long)item_.getOut_AP3_C());
        Assert.assertEquals((long)onlineClampXminusCloseSensor, (long)item_.getOnlineClampXminusCloseSensor());
        Assert.assertEquals((long)onlineClampXminusCloseSensorC, (long)item_.getOnlineClampXminusCloseSensorC());
        Assert.assertEquals((long)onlineClampXminusOpenSensor, (long)item_.getOnlineClampXminusOpenSensor());
        Assert.assertEquals((long)onlineClampXminusOpenSensorC, (long)item_.getOnlineClampXminusOpenSensorC());
        Assert.assertEquals((long)onlineClampXplusCloseSensor, (long)item_.getOnlineClampXplusCloseSensor());
        Assert.assertEquals((long)onlineClampXplusCloseSensorC, (long)item_.getOnlineClampXplusCloseSensorC());
        Assert.assertEquals((long)onlineClampXplusOpenSensor, (long)item_.getOnlineClampXplusOpenSensor());
        Assert.assertEquals((long)onlineClampXplusOpenSensorC, (long)item_.getOnlineClampXplusOpenSensorC());
        Assert.assertEquals((long)onlineClampYminusCloseSensor, (long)item_.getOnlineClampYminusCloseSensor());
        Assert.assertEquals((long)onlineClampYminusCloseSensorC, (long)item_.getOnlineClampYminusCloseSensorC());
        Assert.assertEquals((long)onlineClampYminusOpenSensor, (long)item_.getOnlineClampYminusOpenSensor());
        Assert.assertEquals((long)onlineClampYminusOpenSensorC, (long)item_.getOnlineClampYminusOpenSensorC());
        Assert.assertEquals((long)onlinePositionSensorBXminus, (long)item_.getOnlinePositionSensorBXminus());
        Assert.assertEquals((long)onlinePositionSensorBXplus, (long)item_.getOnlinePositionSensorBXplus());
        Assert.assertEquals((long)onlinePositionSensorXminus, (long)item_.getOnlinePositionSensorXminus());
        Assert.assertEquals((long)onlinePositionSensorXplus, (long)item_.getOnlinePositionSensorXplus());
        Assert.assertEquals((long)openSensorBLatchXminus, (long)item_.getOpenSensorBLatchXminus());
        Assert.assertEquals((long)openSensorBLatchXplus, (long)item_.getOpenSensorBLatchXplus());
        Assert.assertEquals((long)openSensorLatchXminus, (long)item_.getOpenSensorLatchXminus());
        Assert.assertEquals((long)openSensorLatchXplus, (long)item_.getOpenSensorLatchXplus());
        Assert.assertEquals((long)overClampedStatusSensor, (long)item_.getOverClampedStatusSensor());
        Assert.assertEquals((long)presenceLoader, (long)item_.getPresenceLoader());
        Assert.assertEquals((long)presenceloader_C, (long)item_.getPresenceloader_C());
        Assert.assertEquals((long)standbyPositionSensorBXminus, (long)item_.getStandbyPositionSensorBXminus());
        Assert.assertEquals((long)standbyPositionSensorBXplus, (long)item_.getStandbyPositionSensorBXplus());
        Assert.assertEquals((long)standbyPositionSensorXminus, (long)item_.getStandbyPositionSensorXminus());
        Assert.assertEquals((long)standbyPositionSensorXplus, (long)item_.getStandbyPositionSensorXplus());
        Assert.assertEquals((long)unclampedStatusSensor, (long)item_.getUnclampedStatusSensor());
        Assert.assertEquals((long)underClampedStatusSensor, (long)item_.getUnderClampedStatusSensor());
    }

    @Test
    public void sendReceiveFcs_Canbus0_AcTruckXminusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 489;
        boolean brakeActivated = true;
        int current = 75;
        int errorHistoryNB = 94;
        String errorRegister = "";
        int followingError = 572;
        boolean inError = true;
        int lastErrorCode = 613;
        String lastErrorName = "f";
        String mode = "z";
        int position = 622;
        long profileAcceleration = 308L;
        long profileDeceleration = 561L;
        long profileVelocity = 215L;
        String state = "l";
        int velocity = 953;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_AcTruckXminusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_AcTruckXminusController_TrendingTelemetry));
        Fcs_Canbus0_AcTruckXminusController_TrendingTelemetry item_ = (Fcs_Canbus0_AcTruckXminusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_AcTruckXplusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 167;
        boolean brakeActivated = true;
        int current = 877;
        int errorHistoryNB = 613;
        String errorRegister = "";
        int followingError = 180;
        boolean inError = true;
        int lastErrorCode = 426;
        String lastErrorName = "h";
        String mode = "y";
        int position = 305;
        long profileAcceleration = 260L;
        long profileDeceleration = 761L;
        long profileVelocity = 982L;
        String state = "";
        int velocity = 953;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_AcTruckXplusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_AcTruckXplusController_TrendingTelemetry));
        Fcs_Canbus0_AcTruckXplusController_TrendingTelemetry item_ = (Fcs_Canbus0_AcTruckXplusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_Accelerobf_TrendingTelemetry() throws Exception {
        double accelerationX = 0.36224573850631714;
        double accelerationY = 0.11827832460403442;
        double accelerationZ = 0.5935790538787842;
        double airmass = 0.67257f;
        double angularVelocityX = 0.3236528f;
        double angularVelocityY = 0.8826066851615906;
        double angularVelocityZ = 0.5549773573875427;
        double azimut = 0.5185275077819824;
        double elevation = 0.0874180793762207;
        int errorHistoryNB = 676;
        String errorRegister = "";
        double gravity = 0.102963387966156;
        boolean inError = true;
        int lastErrorCode = 472;
        String lastErrorName = "q";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_Accelerobf_TrendingTelemetry(accelerationX, accelerationY, accelerationZ, airmass, angularVelocityX, angularVelocityY, angularVelocityZ, azimut, elevation, errorHistoryNB, errorRegister, gravity, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_Accelerobf_TrendingTelemetry));
        Fcs_Canbus0_Accelerobf_TrendingTelemetry item_ = (Fcs_Canbus0_Accelerobf_TrendingTelemetry)item;
        Assert.assertEquals((double)accelerationX, (double)item_.getAccelerationX(), (double)1.0E-6f);
        Assert.assertEquals((double)accelerationY, (double)item_.getAccelerationY(), (double)1.0E-6f);
        Assert.assertEquals((double)accelerationZ, (double)item_.getAccelerationZ(), (double)1.0E-6f);
        Assert.assertEquals((double)airmass, (double)item_.getAirmass(), (double)1.0E-6f);
        Assert.assertEquals((double)angularVelocityX, (double)item_.getAngularVelocityX(), (double)1.0E-6f);
        Assert.assertEquals((double)angularVelocityY, (double)item_.getAngularVelocityY(), (double)1.0E-6f);
        Assert.assertEquals((double)angularVelocityZ, (double)item_.getAngularVelocityZ(), (double)1.0E-6f);
        Assert.assertEquals((double)azimut, (double)item_.getAzimut(), (double)1.0E-6f);
        Assert.assertEquals((double)elevation, (double)item_.getElevation(), (double)1.0E-6f);
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((double)gravity, (double)item_.getGravity(), (double)1.0E-6f);
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus0_Ai814_TrendingTelemetry() throws Exception {
        int errorHistoryNB = 237;
        String errorRegister = "";
        boolean inError = false;
        int lastErrorCode = 128;
        String lastErrorName = "l";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_Ai814_TrendingTelemetry(errorHistoryNB, errorRegister, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_Ai814_TrendingTelemetry));
        Fcs_Canbus0_Ai814_TrendingTelemetry item_ = (Fcs_Canbus0_Ai814_TrendingTelemetry)item;
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus0_BrakeSystemGateway_TrendingTelemetry() throws Exception {
        int acAF0b = 37;
        int acAF0s = 948;
        int acAF1b = 719;
        int acAF1s = 596;
        int acAF3b = 254;
        int acAF3s = 781;
        int acAP2b = 485;
        int acAP2s = 733;
        int carouselHoldingFilterSensor0 = 769;
        int carouselHoldingFilterSensor1 = 666;
        int carouselStoppedAtStandby = 669;
        int carouselStoppedAtStandbyC = 371;
        int carousel_CF0 = 562;
        int carousel_CF0_C = 19;
        int carousel_CF1 = 554;
        int carousel_CF1_C = 185;
        int clampedStatusSensor = 735;
        int closeSensorBLatchXminus = 597;
        int closeSensorBLatchXplus = 873;
        int closeSensorLatchXminus = 58;
        int closeSensorLatchXplus = 233;
        int engineeringKey = 391;
        int engineeringkey_C = 957;
        int filterEngagedSensorBLatchXminus = 180;
        int filterEngagedSensorBLatchXplus = 785;
        int filterEngagedSensorLatchXminus = 421;
        int filterEngagedSensorLatchXplus = 639;
        int filterIDSensor0 = 11;
        int filterIDSensor1 = 989;
        int filterIDSensor2 = 913;
        int filterIDSensor3 = 34;
        int filterIDSensor4 = 79;
        int filterIDSensor5 = 977;
        int forceSensor0 = 360;
        int forceSensor1 = 332;
        int handoffPositionSensorBXminus = 276;
        int handoffPositionSensorBXplus = 170;
        int handoffPositionSensorXminus = 736;
        int handoffPositionSensorXplus = 801;
        double inclinometerXminus = 0.9257416725158691;
        double inclinometerXplus = 0.22976309061050415;
        int keyEng = 372;
        int keyEngb = 482;
        int keyLock = 331;
        int keyLockb = 280;
        int lps_0 = 874;
        int lps_1 = 243;
        int lrh_0 = 542;
        int lrh_1 = 8;
        int loaderCarrierRelayStatus = 250;
        int loaderChainPresenceSensor = 353;
        int loaderCloseSensor1 = 968;
        int loaderCloseSensor2 = 927;
        int loaderCloseSensor3 = 691;
        int loaderCloseSensor4 = 530;
        int loaderConnectedSensor = 187;
        int loaderConnectedSensorC = 336;
        int loaderDefaultStatus = 475;
        int loaderEngagedPositionSensor0 = 775;
        int loaderEngagedPositionSensor1 = 136;
        int loaderFilterDistanceSensor = 594;
        int loaderFilterGoodPositionStatus = 866;
        int loaderFilterPresenceSensor0 = 604;
        int loaderFilterPresenceSensor1 = 163;
        int loaderHandoffPositionSensor0 = 865;
        int loaderHandoffPositionSensor1 = 116;
        int loaderHoldingFilterSensor0 = 561;
        int loaderHoldingFilterSensor1 = 989;
        int loaderHooksRelayStatus = 84;
        int loaderOnCameraSensor0 = 81;
        int loaderOnCameraSensor1 = 129;
        int loaderOpenSensor1 = 215;
        int loaderOpenSensor2 = 281;
        int loaderOpenSensor3 = 139;
        int loaderOpenSensor4 = 903;
        int loaderStoragePositionSensor0 = 649;
        int loaderStoragePositionSensor1 = 637;
        int loader_LFD = 356;
        int loader_LFS = 192;
        int lockOut = 108;
        int lockOutShunt = 264;
        int lockout_C = 953;
        int lpmLatchesStatus = 99;
        int lpmLinearRail1Status = 482;
        int lpmLinearRail2Status = 316;
        int lpmOnlineClampsStatus = 702;
        int out_AF0 = 565;
        int out_AF0_C = 920;
        int out_AF1 = 382;
        int out_AF1_C = 143;
        int out_AF3 = 114;
        int out_AF3_C = 12;
        int out_AIN = 646;
        int out_AOL = 777;
        int out_AP1 = 46;
        int out_AP1_C = 505;
        int out_AP2 = 49;
        int out_AP2_C = 891;
        int out_AP3 = 801;
        int out_AP3_C = 885;
        int onlineClampXminusCloseSensor = 182;
        int onlineClampXminusCloseSensorC = 804;
        int onlineClampXminusOpenSensor = 904;
        int onlineClampXminusOpenSensorC = 139;
        int onlineClampXplusCloseSensor = 949;
        int onlineClampXplusCloseSensorC = 186;
        int onlineClampXplusOpenSensor = 248;
        int onlineClampXplusOpenSensorC = 153;
        int onlineClampYminusCloseSensor = 58;
        int onlineClampYminusCloseSensorC = 732;
        int onlineClampYminusOpenSensor = 142;
        int onlineClampYminusOpenSensorC = 944;
        int onlinePositionSensorBXminus = 569;
        int onlinePositionSensorBXplus = 357;
        int onlinePositionSensorXminus = 530;
        int onlinePositionSensorXplus = 427;
        int openSensorBLatchXminus = 540;
        int openSensorBLatchXplus = 214;
        int openSensorLatchXminus = 146;
        int openSensorLatchXplus = 647;
        int overClampedStatusSensor = 992;
        int presenceLoader = 46;
        int presenceloader_C = 699;
        int standbyPositionSensorBXminus = 14;
        int standbyPositionSensorBXplus = 646;
        int standbyPositionSensorXminus = 424;
        int standbyPositionSensorXplus = 482;
        int unclampedStatusSensor = 927;
        int underClampedStatusSensor = 205;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_BrakeSystemGateway_TrendingTelemetry(acAF0b, acAF0s, acAF1b, acAF1s, acAF3b, acAF3s, acAP2b, acAP2s, carouselHoldingFilterSensor0, carouselHoldingFilterSensor1, carouselStoppedAtStandby, carouselStoppedAtStandbyC, carousel_CF0, carousel_CF0_C, carousel_CF1, carousel_CF1_C, clampedStatusSensor, closeSensorBLatchXminus, closeSensorBLatchXplus, closeSensorLatchXminus, closeSensorLatchXplus, engineeringKey, engineeringkey_C, filterEngagedSensorBLatchXminus, filterEngagedSensorBLatchXplus, filterEngagedSensorLatchXminus, filterEngagedSensorLatchXplus, filterIDSensor0, filterIDSensor1, filterIDSensor2, filterIDSensor3, filterIDSensor4, filterIDSensor5, forceSensor0, forceSensor1, handoffPositionSensorBXminus, handoffPositionSensorBXplus, handoffPositionSensorXminus, handoffPositionSensorXplus, inclinometerXminus, inclinometerXplus, keyEng, keyEngb, keyLock, keyLockb, lps_0, lps_1, lrh_0, lrh_1, loaderCarrierRelayStatus, loaderChainPresenceSensor, loaderCloseSensor1, loaderCloseSensor2, loaderCloseSensor3, loaderCloseSensor4, loaderConnectedSensor, loaderConnectedSensorC, loaderDefaultStatus, loaderEngagedPositionSensor0, loaderEngagedPositionSensor1, loaderFilterDistanceSensor, loaderFilterGoodPositionStatus, loaderFilterPresenceSensor0, loaderFilterPresenceSensor1, loaderHandoffPositionSensor0, loaderHandoffPositionSensor1, loaderHoldingFilterSensor0, loaderHoldingFilterSensor1, loaderHooksRelayStatus, loaderOnCameraSensor0, loaderOnCameraSensor1, loaderOpenSensor1, loaderOpenSensor2, loaderOpenSensor3, loaderOpenSensor4, loaderStoragePositionSensor0, loaderStoragePositionSensor1, loader_LFD, loader_LFS, lockOut, lockOutShunt, lockout_C, lpmLatchesStatus, lpmLinearRail1Status, lpmLinearRail2Status, lpmOnlineClampsStatus, out_AF0, out_AF0_C, out_AF1, out_AF1_C, out_AF3, out_AF3_C, out_AIN, out_AOL, out_AP1, out_AP1_C, out_AP2, out_AP2_C, out_AP3, out_AP3_C, onlineClampXminusCloseSensor, onlineClampXminusCloseSensorC, onlineClampXminusOpenSensor, onlineClampXminusOpenSensorC, onlineClampXplusCloseSensor, onlineClampXplusCloseSensorC, onlineClampXplusOpenSensor, onlineClampXplusOpenSensorC, onlineClampYminusCloseSensor, onlineClampYminusCloseSensorC, onlineClampYminusOpenSensor, onlineClampYminusOpenSensorC, onlinePositionSensorBXminus, onlinePositionSensorBXplus, onlinePositionSensorXminus, onlinePositionSensorXplus, openSensorBLatchXminus, openSensorBLatchXplus, openSensorLatchXminus, openSensorLatchXplus, overClampedStatusSensor, presenceLoader, presenceloader_C, standbyPositionSensorBXminus, standbyPositionSensorBXplus, standbyPositionSensorXminus, standbyPositionSensorXplus, unclampedStatusSensor, underClampedStatusSensor));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_BrakeSystemGateway_TrendingTelemetry));
        Fcs_Canbus0_BrakeSystemGateway_TrendingTelemetry item_ = (Fcs_Canbus0_BrakeSystemGateway_TrendingTelemetry)item;
        Assert.assertEquals((long)acAF0b, (long)item_.getAcAF0b());
        Assert.assertEquals((long)acAF0s, (long)item_.getAcAF0s());
        Assert.assertEquals((long)acAF1b, (long)item_.getAcAF1b());
        Assert.assertEquals((long)acAF1s, (long)item_.getAcAF1s());
        Assert.assertEquals((long)acAF3b, (long)item_.getAcAF3b());
        Assert.assertEquals((long)acAF3s, (long)item_.getAcAF3s());
        Assert.assertEquals((long)acAP2b, (long)item_.getAcAP2b());
        Assert.assertEquals((long)acAP2s, (long)item_.getAcAP2s());
        Assert.assertEquals((long)carouselHoldingFilterSensor0, (long)item_.getCarouselHoldingFilterSensor0());
        Assert.assertEquals((long)carouselHoldingFilterSensor1, (long)item_.getCarouselHoldingFilterSensor1());
        Assert.assertEquals((long)carouselStoppedAtStandby, (long)item_.getCarouselStoppedAtStandby());
        Assert.assertEquals((long)carouselStoppedAtStandbyC, (long)item_.getCarouselStoppedAtStandbyC());
        Assert.assertEquals((long)carousel_CF0, (long)item_.getCarousel_CF0());
        Assert.assertEquals((long)carousel_CF0_C, (long)item_.getCarousel_CF0_C());
        Assert.assertEquals((long)carousel_CF1, (long)item_.getCarousel_CF1());
        Assert.assertEquals((long)carousel_CF1_C, (long)item_.getCarousel_CF1_C());
        Assert.assertEquals((long)clampedStatusSensor, (long)item_.getClampedStatusSensor());
        Assert.assertEquals((long)closeSensorBLatchXminus, (long)item_.getCloseSensorBLatchXminus());
        Assert.assertEquals((long)closeSensorBLatchXplus, (long)item_.getCloseSensorBLatchXplus());
        Assert.assertEquals((long)closeSensorLatchXminus, (long)item_.getCloseSensorLatchXminus());
        Assert.assertEquals((long)closeSensorLatchXplus, (long)item_.getCloseSensorLatchXplus());
        Assert.assertEquals((long)engineeringKey, (long)item_.getEngineeringKey());
        Assert.assertEquals((long)engineeringkey_C, (long)item_.getEngineeringkey_C());
        Assert.assertEquals((long)filterEngagedSensorBLatchXminus, (long)item_.getFilterEngagedSensorBLatchXminus());
        Assert.assertEquals((long)filterEngagedSensorBLatchXplus, (long)item_.getFilterEngagedSensorBLatchXplus());
        Assert.assertEquals((long)filterEngagedSensorLatchXminus, (long)item_.getFilterEngagedSensorLatchXminus());
        Assert.assertEquals((long)filterEngagedSensorLatchXplus, (long)item_.getFilterEngagedSensorLatchXplus());
        Assert.assertEquals((long)filterIDSensor0, (long)item_.getFilterIDSensor0());
        Assert.assertEquals((long)filterIDSensor1, (long)item_.getFilterIDSensor1());
        Assert.assertEquals((long)filterIDSensor2, (long)item_.getFilterIDSensor2());
        Assert.assertEquals((long)filterIDSensor3, (long)item_.getFilterIDSensor3());
        Assert.assertEquals((long)filterIDSensor4, (long)item_.getFilterIDSensor4());
        Assert.assertEquals((long)filterIDSensor5, (long)item_.getFilterIDSensor5());
        Assert.assertEquals((long)forceSensor0, (long)item_.getForceSensor0());
        Assert.assertEquals((long)forceSensor1, (long)item_.getForceSensor1());
        Assert.assertEquals((long)handoffPositionSensorBXminus, (long)item_.getHandoffPositionSensorBXminus());
        Assert.assertEquals((long)handoffPositionSensorBXplus, (long)item_.getHandoffPositionSensorBXplus());
        Assert.assertEquals((long)handoffPositionSensorXminus, (long)item_.getHandoffPositionSensorXminus());
        Assert.assertEquals((long)handoffPositionSensorXplus, (long)item_.getHandoffPositionSensorXplus());
        Assert.assertEquals((double)inclinometerXminus, (double)item_.getInclinometerXminus(), (double)1.0E-6f);
        Assert.assertEquals((double)inclinometerXplus, (double)item_.getInclinometerXplus(), (double)1.0E-6f);
        Assert.assertEquals((long)keyEng, (long)item_.getKeyEng());
        Assert.assertEquals((long)keyEngb, (long)item_.getKeyEngb());
        Assert.assertEquals((long)keyLock, (long)item_.getKeyLock());
        Assert.assertEquals((long)keyLockb, (long)item_.getKeyLockb());
        Assert.assertEquals((long)lps_0, (long)item_.getLps_0());
        Assert.assertEquals((long)lps_1, (long)item_.getLps_1());
        Assert.assertEquals((long)lrh_0, (long)item_.getLrh_0());
        Assert.assertEquals((long)lrh_1, (long)item_.getLrh_1());
        Assert.assertEquals((long)loaderCarrierRelayStatus, (long)item_.getLoaderCarrierRelayStatus());
        Assert.assertEquals((long)loaderChainPresenceSensor, (long)item_.getLoaderChainPresenceSensor());
        Assert.assertEquals((long)loaderCloseSensor1, (long)item_.getLoaderCloseSensor1());
        Assert.assertEquals((long)loaderCloseSensor2, (long)item_.getLoaderCloseSensor2());
        Assert.assertEquals((long)loaderCloseSensor3, (long)item_.getLoaderCloseSensor3());
        Assert.assertEquals((long)loaderCloseSensor4, (long)item_.getLoaderCloseSensor4());
        Assert.assertEquals((long)loaderConnectedSensor, (long)item_.getLoaderConnectedSensor());
        Assert.assertEquals((long)loaderConnectedSensorC, (long)item_.getLoaderConnectedSensorC());
        Assert.assertEquals((long)loaderDefaultStatus, (long)item_.getLoaderDefaultStatus());
        Assert.assertEquals((long)loaderEngagedPositionSensor0, (long)item_.getLoaderEngagedPositionSensor0());
        Assert.assertEquals((long)loaderEngagedPositionSensor1, (long)item_.getLoaderEngagedPositionSensor1());
        Assert.assertEquals((long)loaderFilterDistanceSensor, (long)item_.getLoaderFilterDistanceSensor());
        Assert.assertEquals((long)loaderFilterGoodPositionStatus, (long)item_.getLoaderFilterGoodPositionStatus());
        Assert.assertEquals((long)loaderFilterPresenceSensor0, (long)item_.getLoaderFilterPresenceSensor0());
        Assert.assertEquals((long)loaderFilterPresenceSensor1, (long)item_.getLoaderFilterPresenceSensor1());
        Assert.assertEquals((long)loaderHandoffPositionSensor0, (long)item_.getLoaderHandoffPositionSensor0());
        Assert.assertEquals((long)loaderHandoffPositionSensor1, (long)item_.getLoaderHandoffPositionSensor1());
        Assert.assertEquals((long)loaderHoldingFilterSensor0, (long)item_.getLoaderHoldingFilterSensor0());
        Assert.assertEquals((long)loaderHoldingFilterSensor1, (long)item_.getLoaderHoldingFilterSensor1());
        Assert.assertEquals((long)loaderHooksRelayStatus, (long)item_.getLoaderHooksRelayStatus());
        Assert.assertEquals((long)loaderOnCameraSensor0, (long)item_.getLoaderOnCameraSensor0());
        Assert.assertEquals((long)loaderOnCameraSensor1, (long)item_.getLoaderOnCameraSensor1());
        Assert.assertEquals((long)loaderOpenSensor1, (long)item_.getLoaderOpenSensor1());
        Assert.assertEquals((long)loaderOpenSensor2, (long)item_.getLoaderOpenSensor2());
        Assert.assertEquals((long)loaderOpenSensor3, (long)item_.getLoaderOpenSensor3());
        Assert.assertEquals((long)loaderOpenSensor4, (long)item_.getLoaderOpenSensor4());
        Assert.assertEquals((long)loaderStoragePositionSensor0, (long)item_.getLoaderStoragePositionSensor0());
        Assert.assertEquals((long)loaderStoragePositionSensor1, (long)item_.getLoaderStoragePositionSensor1());
        Assert.assertEquals((long)loader_LFD, (long)item_.getLoader_LFD());
        Assert.assertEquals((long)loader_LFS, (long)item_.getLoader_LFS());
        Assert.assertEquals((long)lockOut, (long)item_.getLockOut());
        Assert.assertEquals((long)lockOutShunt, (long)item_.getLockOutShunt());
        Assert.assertEquals((long)lockout_C, (long)item_.getLockout_C());
        Assert.assertEquals((long)lpmLatchesStatus, (long)item_.getLpmLatchesStatus());
        Assert.assertEquals((long)lpmLinearRail1Status, (long)item_.getLpmLinearRail1Status());
        Assert.assertEquals((long)lpmLinearRail2Status, (long)item_.getLpmLinearRail2Status());
        Assert.assertEquals((long)lpmOnlineClampsStatus, (long)item_.getLpmOnlineClampsStatus());
        Assert.assertEquals((long)out_AF0, (long)item_.getOut_AF0());
        Assert.assertEquals((long)out_AF0_C, (long)item_.getOut_AF0_C());
        Assert.assertEquals((long)out_AF1, (long)item_.getOut_AF1());
        Assert.assertEquals((long)out_AF1_C, (long)item_.getOut_AF1_C());
        Assert.assertEquals((long)out_AF3, (long)item_.getOut_AF3());
        Assert.assertEquals((long)out_AF3_C, (long)item_.getOut_AF3_C());
        Assert.assertEquals((long)out_AIN, (long)item_.getOut_AIN());
        Assert.assertEquals((long)out_AOL, (long)item_.getOut_AOL());
        Assert.assertEquals((long)out_AP1, (long)item_.getOut_AP1());
        Assert.assertEquals((long)out_AP1_C, (long)item_.getOut_AP1_C());
        Assert.assertEquals((long)out_AP2, (long)item_.getOut_AP2());
        Assert.assertEquals((long)out_AP2_C, (long)item_.getOut_AP2_C());
        Assert.assertEquals((long)out_AP3, (long)item_.getOut_AP3());
        Assert.assertEquals((long)out_AP3_C, (long)item_.getOut_AP3_C());
        Assert.assertEquals((long)onlineClampXminusCloseSensor, (long)item_.getOnlineClampXminusCloseSensor());
        Assert.assertEquals((long)onlineClampXminusCloseSensorC, (long)item_.getOnlineClampXminusCloseSensorC());
        Assert.assertEquals((long)onlineClampXminusOpenSensor, (long)item_.getOnlineClampXminusOpenSensor());
        Assert.assertEquals((long)onlineClampXminusOpenSensorC, (long)item_.getOnlineClampXminusOpenSensorC());
        Assert.assertEquals((long)onlineClampXplusCloseSensor, (long)item_.getOnlineClampXplusCloseSensor());
        Assert.assertEquals((long)onlineClampXplusCloseSensorC, (long)item_.getOnlineClampXplusCloseSensorC());
        Assert.assertEquals((long)onlineClampXplusOpenSensor, (long)item_.getOnlineClampXplusOpenSensor());
        Assert.assertEquals((long)onlineClampXplusOpenSensorC, (long)item_.getOnlineClampXplusOpenSensorC());
        Assert.assertEquals((long)onlineClampYminusCloseSensor, (long)item_.getOnlineClampYminusCloseSensor());
        Assert.assertEquals((long)onlineClampYminusCloseSensorC, (long)item_.getOnlineClampYminusCloseSensorC());
        Assert.assertEquals((long)onlineClampYminusOpenSensor, (long)item_.getOnlineClampYminusOpenSensor());
        Assert.assertEquals((long)onlineClampYminusOpenSensorC, (long)item_.getOnlineClampYminusOpenSensorC());
        Assert.assertEquals((long)onlinePositionSensorBXminus, (long)item_.getOnlinePositionSensorBXminus());
        Assert.assertEquals((long)onlinePositionSensorBXplus, (long)item_.getOnlinePositionSensorBXplus());
        Assert.assertEquals((long)onlinePositionSensorXminus, (long)item_.getOnlinePositionSensorXminus());
        Assert.assertEquals((long)onlinePositionSensorXplus, (long)item_.getOnlinePositionSensorXplus());
        Assert.assertEquals((long)openSensorBLatchXminus, (long)item_.getOpenSensorBLatchXminus());
        Assert.assertEquals((long)openSensorBLatchXplus, (long)item_.getOpenSensorBLatchXplus());
        Assert.assertEquals((long)openSensorLatchXminus, (long)item_.getOpenSensorLatchXminus());
        Assert.assertEquals((long)openSensorLatchXplus, (long)item_.getOpenSensorLatchXplus());
        Assert.assertEquals((long)overClampedStatusSensor, (long)item_.getOverClampedStatusSensor());
        Assert.assertEquals((long)presenceLoader, (long)item_.getPresenceLoader());
        Assert.assertEquals((long)presenceloader_C, (long)item_.getPresenceloader_C());
        Assert.assertEquals((long)standbyPositionSensorBXminus, (long)item_.getStandbyPositionSensorBXminus());
        Assert.assertEquals((long)standbyPositionSensorBXplus, (long)item_.getStandbyPositionSensorBXplus());
        Assert.assertEquals((long)standbyPositionSensorXminus, (long)item_.getStandbyPositionSensorXminus());
        Assert.assertEquals((long)standbyPositionSensorXplus, (long)item_.getStandbyPositionSensorXplus());
        Assert.assertEquals((long)unclampedStatusSensor, (long)item_.getUnclampedStatusSensor());
        Assert.assertEquals((long)underClampedStatusSensor, (long)item_.getUnderClampedStatusSensor());
    }

    @Test
    public void sendReceiveFcs_Canbus0_CarouselController_TrendingTelemetry() throws Exception {
        int averageCurrent = 633;
        boolean brakeActivated = false;
        int current = 53;
        int errorHistoryNB = 252;
        String errorRegister = "";
        int followingError = 484;
        boolean inError = false;
        int lastErrorCode = 981;
        String lastErrorName = "q";
        String mode = "";
        int position = 13;
        long profileAcceleration = 135L;
        long profileDeceleration = 257L;
        long profileVelocity = 13L;
        String state = "";
        int velocity = 531;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_CarouselController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_CarouselController_TrendingTelemetry));
        Fcs_Canbus0_CarouselController_TrendingTelemetry item_ = (Fcs_Canbus0_CarouselController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_ClampXminusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 514;
        boolean brakeActivated = true;
        int current = 738;
        int errorHistoryNB = 45;
        String errorRegister = "";
        int followingError = 644;
        boolean inError = true;
        int lastErrorCode = 19;
        String lastErrorName = "";
        String mode = "";
        int position = 525;
        long profileAcceleration = 556L;
        long profileDeceleration = 676L;
        long profileVelocity = 416L;
        String state = "";
        int velocity = 411;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_ClampXminusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_ClampXminusController_TrendingTelemetry));
        Fcs_Canbus0_ClampXminusController_TrendingTelemetry item_ = (Fcs_Canbus0_ClampXminusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_ClampXplusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 642;
        boolean brakeActivated = false;
        int current = 747;
        int errorHistoryNB = 600;
        String errorRegister = "a";
        int followingError = 399;
        boolean inError = false;
        int lastErrorCode = 472;
        String lastErrorName = "a";
        String mode = "";
        int position = 637;
        long profileAcceleration = 695L;
        long profileDeceleration = 170L;
        long profileVelocity = 974L;
        String state = "";
        int velocity = 861;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_ClampXplusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_ClampXplusController_TrendingTelemetry));
        Fcs_Canbus0_ClampXplusController_TrendingTelemetry item_ = (Fcs_Canbus0_ClampXplusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_Hyttc580_TrendingTelemetry() throws Exception {
        long pdo1 = 843L;
        long pdo2 = 56L;
        long pdo4 = 329L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_Hyttc580_TrendingTelemetry(pdo1, pdo2, pdo4));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_Hyttc580_TrendingTelemetry));
        Fcs_Canbus0_Hyttc580_TrendingTelemetry item_ = (Fcs_Canbus0_Hyttc580_TrendingTelemetry)item;
        Assert.assertEquals((long)pdo1, (long)item_.getPdo1());
        Assert.assertEquals((long)pdo2, (long)item_.getPdo2());
        Assert.assertEquals((long)pdo4, (long)item_.getPdo4());
    }

    @Test
    public void sendReceiveFcs_Canbus0_LatchXminusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 299;
        boolean brakeActivated = true;
        int current = 43;
        int errorHistoryNB = 919;
        String errorRegister = "";
        int followingError = 176;
        boolean inError = false;
        int lastErrorCode = 770;
        String lastErrorName = "d";
        String mode = "";
        int position = 932;
        long profileAcceleration = 556L;
        long profileDeceleration = 519L;
        long profileVelocity = 456L;
        String state = "";
        int velocity = 854;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_LatchXminusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_LatchXminusController_TrendingTelemetry));
        Fcs_Canbus0_LatchXminusController_TrendingTelemetry item_ = (Fcs_Canbus0_LatchXminusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_LatchXplusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 845;
        boolean brakeActivated = false;
        int current = 854;
        int errorHistoryNB = 219;
        String errorRegister = "";
        int followingError = 151;
        boolean inError = true;
        int lastErrorCode = 594;
        String lastErrorName = "";
        String mode = "";
        int position = 783;
        long profileAcceleration = 414L;
        long profileDeceleration = 66L;
        long profileVelocity = 75L;
        String state = "l";
        int velocity = 999;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_LatchXplusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_LatchXplusController_TrendingTelemetry));
        Fcs_Canbus0_LatchXplusController_TrendingTelemetry item_ = (Fcs_Canbus0_LatchXplusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_OnlineClampXminusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 88;
        boolean brakeActivated = false;
        int current = 374;
        int errorHistoryNB = 947;
        String errorRegister = "";
        int followingError = 798;
        boolean inError = true;
        int lastErrorCode = 57;
        String lastErrorName = "b";
        String mode = "";
        int position = 291;
        long profileAcceleration = 987L;
        long profileDeceleration = 284L;
        long profileVelocity = 170L;
        String state = "a";
        int velocity = 896;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_OnlineClampXminusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_OnlineClampXminusController_TrendingTelemetry));
        Fcs_Canbus0_OnlineClampXminusController_TrendingTelemetry item_ = (Fcs_Canbus0_OnlineClampXminusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_OnlineClampXplusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 766;
        boolean brakeActivated = true;
        int current = 595;
        int errorHistoryNB = 182;
        String errorRegister = "t";
        int followingError = 748;
        boolean inError = true;
        int lastErrorCode = 230;
        String lastErrorName = "";
        String mode = "";
        int position = 744;
        long profileAcceleration = 856L;
        long profileDeceleration = 500L;
        long profileVelocity = 361L;
        String state = "";
        int velocity = 530;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_OnlineClampXplusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_OnlineClampXplusController_TrendingTelemetry));
        Fcs_Canbus0_OnlineClampXplusController_TrendingTelemetry item_ = (Fcs_Canbus0_OnlineClampXplusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_OnlineClampYminusController_TrendingTelemetry() throws Exception {
        int averageCurrent = 313;
        boolean brakeActivated = true;
        int current = 853;
        int errorHistoryNB = 685;
        String errorRegister = "h";
        int followingError = 949;
        boolean inError = true;
        int lastErrorCode = 267;
        String lastErrorName = "j";
        String mode = "b";
        int position = 119;
        long profileAcceleration = 675L;
        long profileDeceleration = 232L;
        long profileVelocity = 353L;
        String state = "";
        int velocity = 84;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_OnlineClampYminusController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_OnlineClampYminusController_TrendingTelemetry));
        Fcs_Canbus0_OnlineClampYminusController_TrendingTelemetry item_ = (Fcs_Canbus0_OnlineClampYminusController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus0_OnlineStrainGauge_TrendingTelemetry() throws Exception {
        int errorHistoryNB = 59;
        String errorRegister = "";
        boolean inError = false;
        int lastErrorCode = 832;
        String lastErrorName = "q";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_OnlineStrainGauge_TrendingTelemetry(errorHistoryNB, errorRegister, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_OnlineStrainGauge_TrendingTelemetry));
        Fcs_Canbus0_OnlineStrainGauge_TrendingTelemetry item_ = (Fcs_Canbus0_OnlineStrainGauge_TrendingTelemetry)item;
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus0_ProximitySensorsDevice_TrendingTelemetry() throws Exception {
        int errorHistoryNB = 489;
        String errorRegister = "";
        boolean inError = true;
        int lastErrorCode = 321;
        String lastErrorName = "c";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_ProximitySensorsDevice_TrendingTelemetry(errorHistoryNB, errorRegister, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_ProximitySensorsDevice_TrendingTelemetry));
        Fcs_Canbus0_ProximitySensorsDevice_TrendingTelemetry item_ = (Fcs_Canbus0_ProximitySensorsDevice_TrendingTelemetry)item;
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus0_Pt100_TrendingTelemetry() throws Exception {
        int errorHistoryNB = 391;
        String errorRegister = "v";
        boolean inError = false;
        int lastErrorCode = 875;
        String lastErrorName = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_Pt100_TrendingTelemetry(errorHistoryNB, errorRegister, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_Pt100_TrendingTelemetry));
        Fcs_Canbus0_Pt100_TrendingTelemetry item_ = (Fcs_Canbus0_Pt100_TrendingTelemetry)item;
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus0_TempSensorsDevice1_TrendingTelemetry() throws Exception {
        int errorHistoryNB = 717;
        String errorRegister = "";
        boolean inError = false;
        int lastErrorCode = 12;
        String lastErrorName = "x";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_TempSensorsDevice1_TrendingTelemetry(errorHistoryNB, errorRegister, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_TempSensorsDevice1_TrendingTelemetry));
        Fcs_Canbus0_TempSensorsDevice1_TrendingTelemetry item_ = (Fcs_Canbus0_TempSensorsDevice1_TrendingTelemetry)item;
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus0_TempSensorsDevice2_TrendingTelemetry() throws Exception {
        int errorHistoryNB = 715;
        String errorRegister = "z";
        boolean inError = true;
        int lastErrorCode = 45;
        String lastErrorName = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus0_TempSensorsDevice2_TrendingTelemetry(errorHistoryNB, errorRegister, inError, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_TempSensorsDevice2_TrendingTelemetry));
        Fcs_Canbus0_TempSensorsDevice2_TrendingTelemetry item_ = (Fcs_Canbus0_TempSensorsDevice2_TrendingTelemetry)item;
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Canbus1_CarrierController_TrendingTelemetry() throws Exception {
        int averageCurrent = 240;
        boolean brakeActivated = false;
        int current = 234;
        int errorHistoryNB = 636;
        String errorRegister = "d";
        int followingError = 917;
        boolean inError = false;
        int lastErrorCode = 907;
        String lastErrorName = "s";
        String mode = "z";
        int position = 828;
        long profileAcceleration = 40L;
        long profileDeceleration = 391L;
        long profileVelocity = 367L;
        String state = "h";
        int velocity = 977;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus1_CarrierController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus1_CarrierController_TrendingTelemetry));
        Fcs_Canbus1_CarrierController_TrendingTelemetry item_ = (Fcs_Canbus1_CarrierController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus1_HooksController_TrendingTelemetry() throws Exception {
        int averageCurrent = 67;
        boolean brakeActivated = true;
        int current = 692;
        int errorHistoryNB = 706;
        String errorRegister = "p";
        int followingError = 871;
        boolean inError = true;
        int lastErrorCode = 166;
        String lastErrorName = "k";
        String mode = "q";
        int position = 903;
        long profileAcceleration = 186L;
        long profileDeceleration = 580L;
        long profileVelocity = 186L;
        String state = "";
        int velocity = 444;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus1_HooksController_TrendingTelemetry(averageCurrent, brakeActivated, current, errorHistoryNB, errorRegister, followingError, inError, lastErrorCode, lastErrorName, mode, position, profileAcceleration, profileDeceleration, profileVelocity, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus1_HooksController_TrendingTelemetry));
        Fcs_Canbus1_HooksController_TrendingTelemetry item_ = (Fcs_Canbus1_HooksController_TrendingTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Canbus1_LoaderPlutoGateway_TrendingTelemetry() throws Exception {
        int acAF0b = 177;
        int acAF0s = 374;
        int acAF1b = 183;
        int acAF1s = 932;
        int acAF3b = 199;
        int acAF3s = 496;
        int acAP2b = 889;
        int acAP2s = 338;
        int carouselHoldingFilterSensor0 = 648;
        int carouselHoldingFilterSensor1 = 925;
        int carouselStoppedAtStandby = 524;
        int carouselStoppedAtStandbyC = 463;
        int carousel_CF0 = 913;
        int carousel_CF0_C = 62;
        int carousel_CF1 = 390;
        int carousel_CF1_C = 105;
        int clampedStatusSensor = 896;
        int closeSensorBLatchXminus = 192;
        int closeSensorBLatchXplus = 781;
        int closeSensorLatchXminus = 980;
        int closeSensorLatchXplus = 974;
        int engineeringKey = 881;
        int engineeringkey_C = 373;
        int filterEngagedSensorBLatchXminus = 622;
        int filterEngagedSensorBLatchXplus = 302;
        int filterEngagedSensorLatchXminus = 752;
        int filterEngagedSensorLatchXplus = 195;
        int filterIDSensor0 = 654;
        int filterIDSensor1 = 581;
        int filterIDSensor2 = 969;
        int filterIDSensor3 = 976;
        int filterIDSensor4 = 690;
        int filterIDSensor5 = 988;
        int forceSensor0 = 117;
        int forceSensor1 = 298;
        int handoffPositionSensorBXminus = 781;
        int handoffPositionSensorBXplus = 641;
        int handoffPositionSensorXminus = 58;
        int handoffPositionSensorXplus = 140;
        double inclinometerXminus = 0.6423634886741638;
        double inclinometerXplus = 0.09438461065292358;
        int keyEng = 716;
        int keyEngb = 894;
        int keyLock = 78;
        int keyLockb = 781;
        int lps_0 = 247;
        int lps_1 = 287;
        int lrh_0 = 679;
        int lrh_1 = 459;
        int loaderCarrierRelayStatus = 152;
        int loaderChainPresenceSensor = 206;
        int loaderCloseSensor1 = 853;
        int loaderCloseSensor2 = 438;
        int loaderCloseSensor3 = 143;
        int loaderCloseSensor4 = 217;
        int loaderConnectedSensor = 842;
        int loaderConnectedSensorC = 614;
        int loaderDefaultStatus = 443;
        int loaderEngagedPositionSensor0 = 92;
        int loaderEngagedPositionSensor1 = 932;
        int loaderFilterDistanceSensor = 709;
        int loaderFilterGoodPositionStatus = 434;
        int loaderFilterPresenceSensor0 = 851;
        int loaderFilterPresenceSensor1 = 373;
        int loaderHandoffPositionSensor0 = 159;
        int loaderHandoffPositionSensor1 = 363;
        int loaderHoldingFilterSensor0 = 51;
        int loaderHoldingFilterSensor1 = 699;
        int loaderHooksRelayStatus = 346;
        int loaderOnCameraSensor0 = 2;
        int loaderOnCameraSensor1 = 882;
        int loaderOpenSensor1 = 880;
        int loaderOpenSensor2 = 176;
        int loaderOpenSensor3 = 847;
        int loaderOpenSensor4 = 247;
        int loaderStoragePositionSensor0 = 160;
        int loaderStoragePositionSensor1 = 321;
        int loader_LFD = 916;
        int loader_LFS = 988;
        int lockOut = 586;
        int lockOutShunt = 758;
        int lockout_C = 481;
        int lpmLatchesStatus = 792;
        int lpmLinearRail1Status = 94;
        int lpmLinearRail2Status = 40;
        int lpmOnlineClampsStatus = 326;
        int out_AF0 = 137;
        int out_AF0_C = 945;
        int out_AF1 = 215;
        int out_AF1_C = 60;
        int out_AF3 = 678;
        int out_AF3_C = 864;
        int out_AIN = 110;
        int out_AOL = 624;
        int out_AP1 = 19;
        int out_AP1_C = 799;
        int out_AP2 = 404;
        int out_AP2_C = 813;
        int out_AP3 = 278;
        int out_AP3_C = 524;
        int onlineClampXminusCloseSensor = 102;
        int onlineClampXminusCloseSensorC = 29;
        int onlineClampXminusOpenSensor = 214;
        int onlineClampXminusOpenSensorC = 292;
        int onlineClampXplusCloseSensor = 767;
        int onlineClampXplusCloseSensorC = 444;
        int onlineClampXplusOpenSensor = 331;
        int onlineClampXplusOpenSensorC = 41;
        int onlineClampYminusCloseSensor = 641;
        int onlineClampYminusCloseSensorC = 561;
        int onlineClampYminusOpenSensor = 432;
        int onlineClampYminusOpenSensorC = 496;
        int onlinePositionSensorBXminus = 421;
        int onlinePositionSensorBXplus = 129;
        int onlinePositionSensorXminus = 813;
        int onlinePositionSensorXplus = 643;
        int openSensorBLatchXminus = 991;
        int openSensorBLatchXplus = 266;
        int openSensorLatchXminus = 753;
        int openSensorLatchXplus = 831;
        int overClampedStatusSensor = 501;
        int presenceLoader = 993;
        int presenceloader_C = 581;
        int standbyPositionSensorBXminus = 212;
        int standbyPositionSensorBXplus = 814;
        int standbyPositionSensorXminus = 784;
        int standbyPositionSensorXplus = 420;
        int unclampedStatusSensor = 596;
        int underClampedStatusSensor = 519;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Canbus1_LoaderPlutoGateway_TrendingTelemetry(acAF0b, acAF0s, acAF1b, acAF1s, acAF3b, acAF3s, acAP2b, acAP2s, carouselHoldingFilterSensor0, carouselHoldingFilterSensor1, carouselStoppedAtStandby, carouselStoppedAtStandbyC, carousel_CF0, carousel_CF0_C, carousel_CF1, carousel_CF1_C, clampedStatusSensor, closeSensorBLatchXminus, closeSensorBLatchXplus, closeSensorLatchXminus, closeSensorLatchXplus, engineeringKey, engineeringkey_C, filterEngagedSensorBLatchXminus, filterEngagedSensorBLatchXplus, filterEngagedSensorLatchXminus, filterEngagedSensorLatchXplus, filterIDSensor0, filterIDSensor1, filterIDSensor2, filterIDSensor3, filterIDSensor4, filterIDSensor5, forceSensor0, forceSensor1, handoffPositionSensorBXminus, handoffPositionSensorBXplus, handoffPositionSensorXminus, handoffPositionSensorXplus, inclinometerXminus, inclinometerXplus, keyEng, keyEngb, keyLock, keyLockb, lps_0, lps_1, lrh_0, lrh_1, loaderCarrierRelayStatus, loaderChainPresenceSensor, loaderCloseSensor1, loaderCloseSensor2, loaderCloseSensor3, loaderCloseSensor4, loaderConnectedSensor, loaderConnectedSensorC, loaderDefaultStatus, loaderEngagedPositionSensor0, loaderEngagedPositionSensor1, loaderFilterDistanceSensor, loaderFilterGoodPositionStatus, loaderFilterPresenceSensor0, loaderFilterPresenceSensor1, loaderHandoffPositionSensor0, loaderHandoffPositionSensor1, loaderHoldingFilterSensor0, loaderHoldingFilterSensor1, loaderHooksRelayStatus, loaderOnCameraSensor0, loaderOnCameraSensor1, loaderOpenSensor1, loaderOpenSensor2, loaderOpenSensor3, loaderOpenSensor4, loaderStoragePositionSensor0, loaderStoragePositionSensor1, loader_LFD, loader_LFS, lockOut, lockOutShunt, lockout_C, lpmLatchesStatus, lpmLinearRail1Status, lpmLinearRail2Status, lpmOnlineClampsStatus, out_AF0, out_AF0_C, out_AF1, out_AF1_C, out_AF3, out_AF3_C, out_AIN, out_AOL, out_AP1, out_AP1_C, out_AP2, out_AP2_C, out_AP3, out_AP3_C, onlineClampXminusCloseSensor, onlineClampXminusCloseSensorC, onlineClampXminusOpenSensor, onlineClampXminusOpenSensorC, onlineClampXplusCloseSensor, onlineClampXplusCloseSensorC, onlineClampXplusOpenSensor, onlineClampXplusOpenSensorC, onlineClampYminusCloseSensor, onlineClampYminusCloseSensorC, onlineClampYminusOpenSensor, onlineClampYminusOpenSensorC, onlinePositionSensorBXminus, onlinePositionSensorBXplus, onlinePositionSensorXminus, onlinePositionSensorXplus, openSensorBLatchXminus, openSensorBLatchXplus, openSensorLatchXminus, openSensorLatchXplus, overClampedStatusSensor, presenceLoader, presenceloader_C, standbyPositionSensorBXminus, standbyPositionSensorBXplus, standbyPositionSensorXminus, standbyPositionSensorXplus, unclampedStatusSensor, underClampedStatusSensor));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus1_LoaderPlutoGateway_TrendingTelemetry));
        Fcs_Canbus1_LoaderPlutoGateway_TrendingTelemetry item_ = (Fcs_Canbus1_LoaderPlutoGateway_TrendingTelemetry)item;
        Assert.assertEquals((long)acAF0b, (long)item_.getAcAF0b());
        Assert.assertEquals((long)acAF0s, (long)item_.getAcAF0s());
        Assert.assertEquals((long)acAF1b, (long)item_.getAcAF1b());
        Assert.assertEquals((long)acAF1s, (long)item_.getAcAF1s());
        Assert.assertEquals((long)acAF3b, (long)item_.getAcAF3b());
        Assert.assertEquals((long)acAF3s, (long)item_.getAcAF3s());
        Assert.assertEquals((long)acAP2b, (long)item_.getAcAP2b());
        Assert.assertEquals((long)acAP2s, (long)item_.getAcAP2s());
        Assert.assertEquals((long)carouselHoldingFilterSensor0, (long)item_.getCarouselHoldingFilterSensor0());
        Assert.assertEquals((long)carouselHoldingFilterSensor1, (long)item_.getCarouselHoldingFilterSensor1());
        Assert.assertEquals((long)carouselStoppedAtStandby, (long)item_.getCarouselStoppedAtStandby());
        Assert.assertEquals((long)carouselStoppedAtStandbyC, (long)item_.getCarouselStoppedAtStandbyC());
        Assert.assertEquals((long)carousel_CF0, (long)item_.getCarousel_CF0());
        Assert.assertEquals((long)carousel_CF0_C, (long)item_.getCarousel_CF0_C());
        Assert.assertEquals((long)carousel_CF1, (long)item_.getCarousel_CF1());
        Assert.assertEquals((long)carousel_CF1_C, (long)item_.getCarousel_CF1_C());
        Assert.assertEquals((long)clampedStatusSensor, (long)item_.getClampedStatusSensor());
        Assert.assertEquals((long)closeSensorBLatchXminus, (long)item_.getCloseSensorBLatchXminus());
        Assert.assertEquals((long)closeSensorBLatchXplus, (long)item_.getCloseSensorBLatchXplus());
        Assert.assertEquals((long)closeSensorLatchXminus, (long)item_.getCloseSensorLatchXminus());
        Assert.assertEquals((long)closeSensorLatchXplus, (long)item_.getCloseSensorLatchXplus());
        Assert.assertEquals((long)engineeringKey, (long)item_.getEngineeringKey());
        Assert.assertEquals((long)engineeringkey_C, (long)item_.getEngineeringkey_C());
        Assert.assertEquals((long)filterEngagedSensorBLatchXminus, (long)item_.getFilterEngagedSensorBLatchXminus());
        Assert.assertEquals((long)filterEngagedSensorBLatchXplus, (long)item_.getFilterEngagedSensorBLatchXplus());
        Assert.assertEquals((long)filterEngagedSensorLatchXminus, (long)item_.getFilterEngagedSensorLatchXminus());
        Assert.assertEquals((long)filterEngagedSensorLatchXplus, (long)item_.getFilterEngagedSensorLatchXplus());
        Assert.assertEquals((long)filterIDSensor0, (long)item_.getFilterIDSensor0());
        Assert.assertEquals((long)filterIDSensor1, (long)item_.getFilterIDSensor1());
        Assert.assertEquals((long)filterIDSensor2, (long)item_.getFilterIDSensor2());
        Assert.assertEquals((long)filterIDSensor3, (long)item_.getFilterIDSensor3());
        Assert.assertEquals((long)filterIDSensor4, (long)item_.getFilterIDSensor4());
        Assert.assertEquals((long)filterIDSensor5, (long)item_.getFilterIDSensor5());
        Assert.assertEquals((long)forceSensor0, (long)item_.getForceSensor0());
        Assert.assertEquals((long)forceSensor1, (long)item_.getForceSensor1());
        Assert.assertEquals((long)handoffPositionSensorBXminus, (long)item_.getHandoffPositionSensorBXminus());
        Assert.assertEquals((long)handoffPositionSensorBXplus, (long)item_.getHandoffPositionSensorBXplus());
        Assert.assertEquals((long)handoffPositionSensorXminus, (long)item_.getHandoffPositionSensorXminus());
        Assert.assertEquals((long)handoffPositionSensorXplus, (long)item_.getHandoffPositionSensorXplus());
        Assert.assertEquals((double)inclinometerXminus, (double)item_.getInclinometerXminus(), (double)1.0E-6f);
        Assert.assertEquals((double)inclinometerXplus, (double)item_.getInclinometerXplus(), (double)1.0E-6f);
        Assert.assertEquals((long)keyEng, (long)item_.getKeyEng());
        Assert.assertEquals((long)keyEngb, (long)item_.getKeyEngb());
        Assert.assertEquals((long)keyLock, (long)item_.getKeyLock());
        Assert.assertEquals((long)keyLockb, (long)item_.getKeyLockb());
        Assert.assertEquals((long)lps_0, (long)item_.getLps_0());
        Assert.assertEquals((long)lps_1, (long)item_.getLps_1());
        Assert.assertEquals((long)lrh_0, (long)item_.getLrh_0());
        Assert.assertEquals((long)lrh_1, (long)item_.getLrh_1());
        Assert.assertEquals((long)loaderCarrierRelayStatus, (long)item_.getLoaderCarrierRelayStatus());
        Assert.assertEquals((long)loaderChainPresenceSensor, (long)item_.getLoaderChainPresenceSensor());
        Assert.assertEquals((long)loaderCloseSensor1, (long)item_.getLoaderCloseSensor1());
        Assert.assertEquals((long)loaderCloseSensor2, (long)item_.getLoaderCloseSensor2());
        Assert.assertEquals((long)loaderCloseSensor3, (long)item_.getLoaderCloseSensor3());
        Assert.assertEquals((long)loaderCloseSensor4, (long)item_.getLoaderCloseSensor4());
        Assert.assertEquals((long)loaderConnectedSensor, (long)item_.getLoaderConnectedSensor());
        Assert.assertEquals((long)loaderConnectedSensorC, (long)item_.getLoaderConnectedSensorC());
        Assert.assertEquals((long)loaderDefaultStatus, (long)item_.getLoaderDefaultStatus());
        Assert.assertEquals((long)loaderEngagedPositionSensor0, (long)item_.getLoaderEngagedPositionSensor0());
        Assert.assertEquals((long)loaderEngagedPositionSensor1, (long)item_.getLoaderEngagedPositionSensor1());
        Assert.assertEquals((long)loaderFilterDistanceSensor, (long)item_.getLoaderFilterDistanceSensor());
        Assert.assertEquals((long)loaderFilterGoodPositionStatus, (long)item_.getLoaderFilterGoodPositionStatus());
        Assert.assertEquals((long)loaderFilterPresenceSensor0, (long)item_.getLoaderFilterPresenceSensor0());
        Assert.assertEquals((long)loaderFilterPresenceSensor1, (long)item_.getLoaderFilterPresenceSensor1());
        Assert.assertEquals((long)loaderHandoffPositionSensor0, (long)item_.getLoaderHandoffPositionSensor0());
        Assert.assertEquals((long)loaderHandoffPositionSensor1, (long)item_.getLoaderHandoffPositionSensor1());
        Assert.assertEquals((long)loaderHoldingFilterSensor0, (long)item_.getLoaderHoldingFilterSensor0());
        Assert.assertEquals((long)loaderHoldingFilterSensor1, (long)item_.getLoaderHoldingFilterSensor1());
        Assert.assertEquals((long)loaderHooksRelayStatus, (long)item_.getLoaderHooksRelayStatus());
        Assert.assertEquals((long)loaderOnCameraSensor0, (long)item_.getLoaderOnCameraSensor0());
        Assert.assertEquals((long)loaderOnCameraSensor1, (long)item_.getLoaderOnCameraSensor1());
        Assert.assertEquals((long)loaderOpenSensor1, (long)item_.getLoaderOpenSensor1());
        Assert.assertEquals((long)loaderOpenSensor2, (long)item_.getLoaderOpenSensor2());
        Assert.assertEquals((long)loaderOpenSensor3, (long)item_.getLoaderOpenSensor3());
        Assert.assertEquals((long)loaderOpenSensor4, (long)item_.getLoaderOpenSensor4());
        Assert.assertEquals((long)loaderStoragePositionSensor0, (long)item_.getLoaderStoragePositionSensor0());
        Assert.assertEquals((long)loaderStoragePositionSensor1, (long)item_.getLoaderStoragePositionSensor1());
        Assert.assertEquals((long)loader_LFD, (long)item_.getLoader_LFD());
        Assert.assertEquals((long)loader_LFS, (long)item_.getLoader_LFS());
        Assert.assertEquals((long)lockOut, (long)item_.getLockOut());
        Assert.assertEquals((long)lockOutShunt, (long)item_.getLockOutShunt());
        Assert.assertEquals((long)lockout_C, (long)item_.getLockout_C());
        Assert.assertEquals((long)lpmLatchesStatus, (long)item_.getLpmLatchesStatus());
        Assert.assertEquals((long)lpmLinearRail1Status, (long)item_.getLpmLinearRail1Status());
        Assert.assertEquals((long)lpmLinearRail2Status, (long)item_.getLpmLinearRail2Status());
        Assert.assertEquals((long)lpmOnlineClampsStatus, (long)item_.getLpmOnlineClampsStatus());
        Assert.assertEquals((long)out_AF0, (long)item_.getOut_AF0());
        Assert.assertEquals((long)out_AF0_C, (long)item_.getOut_AF0_C());
        Assert.assertEquals((long)out_AF1, (long)item_.getOut_AF1());
        Assert.assertEquals((long)out_AF1_C, (long)item_.getOut_AF1_C());
        Assert.assertEquals((long)out_AF3, (long)item_.getOut_AF3());
        Assert.assertEquals((long)out_AF3_C, (long)item_.getOut_AF3_C());
        Assert.assertEquals((long)out_AIN, (long)item_.getOut_AIN());
        Assert.assertEquals((long)out_AOL, (long)item_.getOut_AOL());
        Assert.assertEquals((long)out_AP1, (long)item_.getOut_AP1());
        Assert.assertEquals((long)out_AP1_C, (long)item_.getOut_AP1_C());
        Assert.assertEquals((long)out_AP2, (long)item_.getOut_AP2());
        Assert.assertEquals((long)out_AP2_C, (long)item_.getOut_AP2_C());
        Assert.assertEquals((long)out_AP3, (long)item_.getOut_AP3());
        Assert.assertEquals((long)out_AP3_C, (long)item_.getOut_AP3_C());
        Assert.assertEquals((long)onlineClampXminusCloseSensor, (long)item_.getOnlineClampXminusCloseSensor());
        Assert.assertEquals((long)onlineClampXminusCloseSensorC, (long)item_.getOnlineClampXminusCloseSensorC());
        Assert.assertEquals((long)onlineClampXminusOpenSensor, (long)item_.getOnlineClampXminusOpenSensor());
        Assert.assertEquals((long)onlineClampXminusOpenSensorC, (long)item_.getOnlineClampXminusOpenSensorC());
        Assert.assertEquals((long)onlineClampXplusCloseSensor, (long)item_.getOnlineClampXplusCloseSensor());
        Assert.assertEquals((long)onlineClampXplusCloseSensorC, (long)item_.getOnlineClampXplusCloseSensorC());
        Assert.assertEquals((long)onlineClampXplusOpenSensor, (long)item_.getOnlineClampXplusOpenSensor());
        Assert.assertEquals((long)onlineClampXplusOpenSensorC, (long)item_.getOnlineClampXplusOpenSensorC());
        Assert.assertEquals((long)onlineClampYminusCloseSensor, (long)item_.getOnlineClampYminusCloseSensor());
        Assert.assertEquals((long)onlineClampYminusCloseSensorC, (long)item_.getOnlineClampYminusCloseSensorC());
        Assert.assertEquals((long)onlineClampYminusOpenSensor, (long)item_.getOnlineClampYminusOpenSensor());
        Assert.assertEquals((long)onlineClampYminusOpenSensorC, (long)item_.getOnlineClampYminusOpenSensorC());
        Assert.assertEquals((long)onlinePositionSensorBXminus, (long)item_.getOnlinePositionSensorBXminus());
        Assert.assertEquals((long)onlinePositionSensorBXplus, (long)item_.getOnlinePositionSensorBXplus());
        Assert.assertEquals((long)onlinePositionSensorXminus, (long)item_.getOnlinePositionSensorXminus());
        Assert.assertEquals((long)onlinePositionSensorXplus, (long)item_.getOnlinePositionSensorXplus());
        Assert.assertEquals((long)openSensorBLatchXminus, (long)item_.getOpenSensorBLatchXminus());
        Assert.assertEquals((long)openSensorBLatchXplus, (long)item_.getOpenSensorBLatchXplus());
        Assert.assertEquals((long)openSensorLatchXminus, (long)item_.getOpenSensorLatchXminus());
        Assert.assertEquals((long)openSensorLatchXplus, (long)item_.getOpenSensorLatchXplus());
        Assert.assertEquals((long)overClampedStatusSensor, (long)item_.getOverClampedStatusSensor());
        Assert.assertEquals((long)presenceLoader, (long)item_.getPresenceLoader());
        Assert.assertEquals((long)presenceloader_C, (long)item_.getPresenceloader_C());
        Assert.assertEquals((long)standbyPositionSensorBXminus, (long)item_.getStandbyPositionSensorBXminus());
        Assert.assertEquals((long)standbyPositionSensorBXplus, (long)item_.getStandbyPositionSensorBXplus());
        Assert.assertEquals((long)standbyPositionSensorXminus, (long)item_.getStandbyPositionSensorXminus());
        Assert.assertEquals((long)standbyPositionSensorXplus, (long)item_.getStandbyPositionSensorXplus());
        Assert.assertEquals((long)unclampedStatusSensor, (long)item_.getUnclampedStatusSensor());
        Assert.assertEquals((long)underClampedStatusSensor, (long)item_.getUnderClampedStatusSensor());
    }

    @Test
    public void sendReceiveFcs_Carousel_Socket1_TrendingTelemetry() throws Exception {
        boolean atStandby = false;
        String clampxminus1_clampState = "";
        int clampxminus1_filterPositionSensorValue = 650;
        int clampxminus1_filterPresenceOffset2 = 905;
        String clampxminus1_filterPresenceStatus = "y";
        int clampxminus1_lockSensorOffset1 = 529;
        int clampxminus1_lockSensorValue = 134;
        String clampxminus1_lockStatus = "";
        String clampxplus1_clampState = "";
        int clampxplus1_filterPositionSensorValue = 278;
        int clampxplus1_filterPresenceOffset2 = 482;
        String clampxplus1_filterPresenceStatus = "r";
        int clampxplus1_lockSensorOffset1 = 435;
        int clampxplus1_lockSensorValue = 614;
        String clampxplus1_lockStatus = "e";
        String clampsState = "";
        boolean empty = false;
        int filterID = 990;
        String ioStatus = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_Socket1_TrendingTelemetry(atStandby, clampxminus1_clampState, clampxminus1_filterPositionSensorValue, clampxminus1_filterPresenceOffset2, clampxminus1_filterPresenceStatus, clampxminus1_lockSensorOffset1, clampxminus1_lockSensorValue, clampxminus1_lockStatus, clampxplus1_clampState, clampxplus1_filterPositionSensorValue, clampxplus1_filterPresenceOffset2, clampxplus1_filterPresenceStatus, clampxplus1_lockSensorOffset1, clampxplus1_lockSensorValue, clampxplus1_lockStatus, clampsState, empty, filterID, ioStatus));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_Socket1_TrendingTelemetry));
        Fcs_Carousel_Socket1_TrendingTelemetry item_ = (Fcs_Carousel_Socket1_TrendingTelemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)clampxminus1_clampState, (Object)item_.getClampxminus1_clampState());
        Assert.assertEquals((long)clampxminus1_filterPositionSensorValue, (long)item_.getClampxminus1_filterPositionSensorValue());
        Assert.assertEquals((long)clampxminus1_filterPresenceOffset2, (long)item_.getClampxminus1_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxminus1_filterPresenceStatus, (Object)item_.getClampxminus1_filterPresenceStatus());
        Assert.assertEquals((long)clampxminus1_lockSensorOffset1, (long)item_.getClampxminus1_lockSensorOffset1());
        Assert.assertEquals((long)clampxminus1_lockSensorValue, (long)item_.getClampxminus1_lockSensorValue());
        Assert.assertEquals((Object)clampxminus1_lockStatus, (Object)item_.getClampxminus1_lockStatus());
        Assert.assertEquals((Object)clampxplus1_clampState, (Object)item_.getClampxplus1_clampState());
        Assert.assertEquals((long)clampxplus1_filterPositionSensorValue, (long)item_.getClampxplus1_filterPositionSensorValue());
        Assert.assertEquals((long)clampxplus1_filterPresenceOffset2, (long)item_.getClampxplus1_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxplus1_filterPresenceStatus, (Object)item_.getClampxplus1_filterPresenceStatus());
        Assert.assertEquals((long)clampxplus1_lockSensorOffset1, (long)item_.getClampxplus1_lockSensorOffset1());
        Assert.assertEquals((long)clampxplus1_lockSensorValue, (long)item_.getClampxplus1_lockSensorValue());
        Assert.assertEquals((Object)clampxplus1_lockStatus, (Object)item_.getClampxplus1_lockStatus());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((long)filterID, (long)item_.getFilterID());
        Assert.assertEquals((Object)ioStatus, (Object)item_.getIoStatus());
    }

    @Test
    public void sendReceiveFcs_Carousel_Socket2_TrendingTelemetry() throws Exception {
        boolean atStandby = true;
        String clampxminus2_clampState = "w";
        int clampxminus2_filterPositionSensorValue = 220;
        int clampxminus2_filterPresenceOffset2 = 685;
        String clampxminus2_filterPresenceStatus = "v";
        int clampxminus2_lockSensorOffset1 = 618;
        int clampxminus2_lockSensorValue = 513;
        String clampxminus2_lockStatus = "i";
        String clampxplus2_clampState = "d";
        int clampxplus2_filterPositionSensorValue = 478;
        int clampxplus2_filterPresenceOffset2 = 122;
        String clampxplus2_filterPresenceStatus = "";
        int clampxplus2_lockSensorOffset1 = 418;
        int clampxplus2_lockSensorValue = 432;
        String clampxplus2_lockStatus = "f";
        String clampsState = "m";
        boolean empty = true;
        int filterID = 29;
        String ioStatus = "l";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_Socket2_TrendingTelemetry(atStandby, clampxminus2_clampState, clampxminus2_filterPositionSensorValue, clampxminus2_filterPresenceOffset2, clampxminus2_filterPresenceStatus, clampxminus2_lockSensorOffset1, clampxminus2_lockSensorValue, clampxminus2_lockStatus, clampxplus2_clampState, clampxplus2_filterPositionSensorValue, clampxplus2_filterPresenceOffset2, clampxplus2_filterPresenceStatus, clampxplus2_lockSensorOffset1, clampxplus2_lockSensorValue, clampxplus2_lockStatus, clampsState, empty, filterID, ioStatus));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_Socket2_TrendingTelemetry));
        Fcs_Carousel_Socket2_TrendingTelemetry item_ = (Fcs_Carousel_Socket2_TrendingTelemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)clampxminus2_clampState, (Object)item_.getClampxminus2_clampState());
        Assert.assertEquals((long)clampxminus2_filterPositionSensorValue, (long)item_.getClampxminus2_filterPositionSensorValue());
        Assert.assertEquals((long)clampxminus2_filterPresenceOffset2, (long)item_.getClampxminus2_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxminus2_filterPresenceStatus, (Object)item_.getClampxminus2_filterPresenceStatus());
        Assert.assertEquals((long)clampxminus2_lockSensorOffset1, (long)item_.getClampxminus2_lockSensorOffset1());
        Assert.assertEquals((long)clampxminus2_lockSensorValue, (long)item_.getClampxminus2_lockSensorValue());
        Assert.assertEquals((Object)clampxminus2_lockStatus, (Object)item_.getClampxminus2_lockStatus());
        Assert.assertEquals((Object)clampxplus2_clampState, (Object)item_.getClampxplus2_clampState());
        Assert.assertEquals((long)clampxplus2_filterPositionSensorValue, (long)item_.getClampxplus2_filterPositionSensorValue());
        Assert.assertEquals((long)clampxplus2_filterPresenceOffset2, (long)item_.getClampxplus2_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxplus2_filterPresenceStatus, (Object)item_.getClampxplus2_filterPresenceStatus());
        Assert.assertEquals((long)clampxplus2_lockSensorOffset1, (long)item_.getClampxplus2_lockSensorOffset1());
        Assert.assertEquals((long)clampxplus2_lockSensorValue, (long)item_.getClampxplus2_lockSensorValue());
        Assert.assertEquals((Object)clampxplus2_lockStatus, (Object)item_.getClampxplus2_lockStatus());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((long)filterID, (long)item_.getFilterID());
        Assert.assertEquals((Object)ioStatus, (Object)item_.getIoStatus());
    }

    @Test
    public void sendReceiveFcs_Carousel_Socket3_TrendingTelemetry() throws Exception {
        boolean atStandby = true;
        String clampxminus3_clampState = "";
        int clampxminus3_filterPositionSensorValue = 930;
        int clampxminus3_filterPresenceOffset2 = 468;
        String clampxminus3_filterPresenceStatus = "";
        int clampxminus3_lockSensorOffset1 = 219;
        int clampxminus3_lockSensorValue = 919;
        String clampxminus3_lockStatus = "";
        String clampxplus3_clampState = "t";
        int clampxplus3_filterPositionSensorValue = 384;
        int clampxplus3_filterPresenceOffset2 = 880;
        String clampxplus3_filterPresenceStatus = "u";
        int clampxplus3_lockSensorOffset1 = 210;
        int clampxplus3_lockSensorValue = 994;
        String clampxplus3_lockStatus = "";
        String clampsState = "e";
        boolean empty = false;
        int filterID = 252;
        String ioStatus = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_Socket3_TrendingTelemetry(atStandby, clampxminus3_clampState, clampxminus3_filterPositionSensorValue, clampxminus3_filterPresenceOffset2, clampxminus3_filterPresenceStatus, clampxminus3_lockSensorOffset1, clampxminus3_lockSensorValue, clampxminus3_lockStatus, clampxplus3_clampState, clampxplus3_filterPositionSensorValue, clampxplus3_filterPresenceOffset2, clampxplus3_filterPresenceStatus, clampxplus3_lockSensorOffset1, clampxplus3_lockSensorValue, clampxplus3_lockStatus, clampsState, empty, filterID, ioStatus));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_Socket3_TrendingTelemetry));
        Fcs_Carousel_Socket3_TrendingTelemetry item_ = (Fcs_Carousel_Socket3_TrendingTelemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)clampxminus3_clampState, (Object)item_.getClampxminus3_clampState());
        Assert.assertEquals((long)clampxminus3_filterPositionSensorValue, (long)item_.getClampxminus3_filterPositionSensorValue());
        Assert.assertEquals((long)clampxminus3_filterPresenceOffset2, (long)item_.getClampxminus3_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxminus3_filterPresenceStatus, (Object)item_.getClampxminus3_filterPresenceStatus());
        Assert.assertEquals((long)clampxminus3_lockSensorOffset1, (long)item_.getClampxminus3_lockSensorOffset1());
        Assert.assertEquals((long)clampxminus3_lockSensorValue, (long)item_.getClampxminus3_lockSensorValue());
        Assert.assertEquals((Object)clampxminus3_lockStatus, (Object)item_.getClampxminus3_lockStatus());
        Assert.assertEquals((Object)clampxplus3_clampState, (Object)item_.getClampxplus3_clampState());
        Assert.assertEquals((long)clampxplus3_filterPositionSensorValue, (long)item_.getClampxplus3_filterPositionSensorValue());
        Assert.assertEquals((long)clampxplus3_filterPresenceOffset2, (long)item_.getClampxplus3_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxplus3_filterPresenceStatus, (Object)item_.getClampxplus3_filterPresenceStatus());
        Assert.assertEquals((long)clampxplus3_lockSensorOffset1, (long)item_.getClampxplus3_lockSensorOffset1());
        Assert.assertEquals((long)clampxplus3_lockSensorValue, (long)item_.getClampxplus3_lockSensorValue());
        Assert.assertEquals((Object)clampxplus3_lockStatus, (Object)item_.getClampxplus3_lockStatus());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((long)filterID, (long)item_.getFilterID());
        Assert.assertEquals((Object)ioStatus, (Object)item_.getIoStatus());
    }

    @Test
    public void sendReceiveFcs_Carousel_Socket4_TrendingTelemetry() throws Exception {
        boolean atStandby = false;
        String clampxminus4_clampState = "";
        int clampxminus4_filterPositionSensorValue = 455;
        int clampxminus4_filterPresenceOffset2 = 495;
        String clampxminus4_filterPresenceStatus = "c";
        int clampxminus4_lockSensorOffset1 = 419;
        int clampxminus4_lockSensorValue = 439;
        String clampxminus4_lockStatus = "";
        String clampxplus4_clampState = "a";
        int clampxplus4_filterPositionSensorValue = 899;
        int clampxplus4_filterPresenceOffset2 = 563;
        String clampxplus4_filterPresenceStatus = "x";
        int clampxplus4_lockSensorOffset1 = 548;
        int clampxplus4_lockSensorValue = 609;
        String clampxplus4_lockStatus = "j";
        String clampsState = "c";
        boolean empty = true;
        int filterID = 72;
        String ioStatus = "h";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_Socket4_TrendingTelemetry(atStandby, clampxminus4_clampState, clampxminus4_filterPositionSensorValue, clampxminus4_filterPresenceOffset2, clampxminus4_filterPresenceStatus, clampxminus4_lockSensorOffset1, clampxminus4_lockSensorValue, clampxminus4_lockStatus, clampxplus4_clampState, clampxplus4_filterPositionSensorValue, clampxplus4_filterPresenceOffset2, clampxplus4_filterPresenceStatus, clampxplus4_lockSensorOffset1, clampxplus4_lockSensorValue, clampxplus4_lockStatus, clampsState, empty, filterID, ioStatus));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_Socket4_TrendingTelemetry));
        Fcs_Carousel_Socket4_TrendingTelemetry item_ = (Fcs_Carousel_Socket4_TrendingTelemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)clampxminus4_clampState, (Object)item_.getClampxminus4_clampState());
        Assert.assertEquals((long)clampxminus4_filterPositionSensorValue, (long)item_.getClampxminus4_filterPositionSensorValue());
        Assert.assertEquals((long)clampxminus4_filterPresenceOffset2, (long)item_.getClampxminus4_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxminus4_filterPresenceStatus, (Object)item_.getClampxminus4_filterPresenceStatus());
        Assert.assertEquals((long)clampxminus4_lockSensorOffset1, (long)item_.getClampxminus4_lockSensorOffset1());
        Assert.assertEquals((long)clampxminus4_lockSensorValue, (long)item_.getClampxminus4_lockSensorValue());
        Assert.assertEquals((Object)clampxminus4_lockStatus, (Object)item_.getClampxminus4_lockStatus());
        Assert.assertEquals((Object)clampxplus4_clampState, (Object)item_.getClampxplus4_clampState());
        Assert.assertEquals((long)clampxplus4_filterPositionSensorValue, (long)item_.getClampxplus4_filterPositionSensorValue());
        Assert.assertEquals((long)clampxplus4_filterPresenceOffset2, (long)item_.getClampxplus4_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxplus4_filterPresenceStatus, (Object)item_.getClampxplus4_filterPresenceStatus());
        Assert.assertEquals((long)clampxplus4_lockSensorOffset1, (long)item_.getClampxplus4_lockSensorOffset1());
        Assert.assertEquals((long)clampxplus4_lockSensorValue, (long)item_.getClampxplus4_lockSensorValue());
        Assert.assertEquals((Object)clampxplus4_lockStatus, (Object)item_.getClampxplus4_lockStatus());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((long)filterID, (long)item_.getFilterID());
        Assert.assertEquals((Object)ioStatus, (Object)item_.getIoStatus());
    }

    @Test
    public void sendReceiveFcs_Carousel_Socket5_TrendingTelemetry() throws Exception {
        boolean atStandby = true;
        String clampxminus5_clampState = "w";
        int clampxminus5_filterPositionSensorValue = 75;
        int clampxminus5_filterPresenceOffset2 = 963;
        String clampxminus5_filterPresenceStatus = "j";
        int clampxminus5_lockSensorOffset1 = 907;
        int clampxminus5_lockSensorValue = 255;
        String clampxminus5_lockStatus = "";
        String clampxplus5_clampState = "";
        int clampxplus5_filterPositionSensorValue = 94;
        int clampxplus5_filterPresenceOffset2 = 314;
        String clampxplus5_filterPresenceStatus = "m";
        int clampxplus5_lockSensorOffset1 = 165;
        int clampxplus5_lockSensorValue = 802;
        String clampxplus5_lockStatus = "";
        String clampsState = "";
        boolean empty = false;
        int filterID = 813;
        String ioStatus = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_Socket5_TrendingTelemetry(atStandby, clampxminus5_clampState, clampxminus5_filterPositionSensorValue, clampxminus5_filterPresenceOffset2, clampxminus5_filterPresenceStatus, clampxminus5_lockSensorOffset1, clampxminus5_lockSensorValue, clampxminus5_lockStatus, clampxplus5_clampState, clampxplus5_filterPositionSensorValue, clampxplus5_filterPresenceOffset2, clampxplus5_filterPresenceStatus, clampxplus5_lockSensorOffset1, clampxplus5_lockSensorValue, clampxplus5_lockStatus, clampsState, empty, filterID, ioStatus));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_Socket5_TrendingTelemetry));
        Fcs_Carousel_Socket5_TrendingTelemetry item_ = (Fcs_Carousel_Socket5_TrendingTelemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)clampxminus5_clampState, (Object)item_.getClampxminus5_clampState());
        Assert.assertEquals((long)clampxminus5_filterPositionSensorValue, (long)item_.getClampxminus5_filterPositionSensorValue());
        Assert.assertEquals((long)clampxminus5_filterPresenceOffset2, (long)item_.getClampxminus5_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxminus5_filterPresenceStatus, (Object)item_.getClampxminus5_filterPresenceStatus());
        Assert.assertEquals((long)clampxminus5_lockSensorOffset1, (long)item_.getClampxminus5_lockSensorOffset1());
        Assert.assertEquals((long)clampxminus5_lockSensorValue, (long)item_.getClampxminus5_lockSensorValue());
        Assert.assertEquals((Object)clampxminus5_lockStatus, (Object)item_.getClampxminus5_lockStatus());
        Assert.assertEquals((Object)clampxplus5_clampState, (Object)item_.getClampxplus5_clampState());
        Assert.assertEquals((long)clampxplus5_filterPositionSensorValue, (long)item_.getClampxplus5_filterPositionSensorValue());
        Assert.assertEquals((long)clampxplus5_filterPresenceOffset2, (long)item_.getClampxplus5_filterPresenceOffset2());
        Assert.assertEquals((Object)clampxplus5_filterPresenceStatus, (Object)item_.getClampxplus5_filterPresenceStatus());
        Assert.assertEquals((long)clampxplus5_lockSensorOffset1, (long)item_.getClampxplus5_lockSensorOffset1());
        Assert.assertEquals((long)clampxplus5_lockSensorValue, (long)item_.getClampxplus5_lockSensorValue());
        Assert.assertEquals((Object)clampxplus5_lockStatus, (Object)item_.getClampxplus5_lockStatus());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((long)filterID, (long)item_.getFilterID());
        Assert.assertEquals((Object)ioStatus, (Object)item_.getIoStatus());
    }

    @Test
    public void sendReceiveFcs_Carousel_TrendingTelemetry() throws Exception {
        boolean atStandby = false;
        String clampsStateAtStandby = "f";
        int deltaPositionAtStandby = 799;
        boolean emptyAtStandby = true;
        int estimatedPosition = 145;
        int filterAtStandbyId = 977;
        String filterOnAutochangerName = "r";
        long minLocked = 63L;
        int socketAtStandbyID = 663;
        String socketAtStandbyName = "a";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Carousel_TrendingTelemetry(atStandby, clampsStateAtStandby, deltaPositionAtStandby, emptyAtStandby, estimatedPosition, filterAtStandbyId, filterOnAutochangerName, minLocked, socketAtStandbyID, socketAtStandbyName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_TrendingTelemetry));
        Fcs_Carousel_TrendingTelemetry item_ = (Fcs_Carousel_TrendingTelemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)clampsStateAtStandby, (Object)item_.getClampsStateAtStandby());
        Assert.assertEquals((long)deltaPositionAtStandby, (long)item_.getDeltaPositionAtStandby());
        Assert.assertEquals((Object)emptyAtStandby, (Object)item_.isEmptyAtStandby());
        Assert.assertEquals((long)estimatedPosition, (long)item_.getEstimatedPosition());
        Assert.assertEquals((long)filterAtStandbyId, (long)item_.getFilterAtStandbyId());
        Assert.assertEquals((Object)filterOnAutochangerName, (Object)item_.getFilterOnAutochangerName());
        Assert.assertEquals((long)minLocked, (long)item_.getMinLocked());
        Assert.assertEquals((long)socketAtStandbyID, (long)item_.getSocketAtStandbyID());
        Assert.assertEquals((Object)socketAtStandbyName, (Object)item_.getSocketAtStandbyName());
    }

    @Test
    public void sendReceiveFcs_Duration_Autochanger_TrendingTelemetry() throws Exception {
        long autochangertrucks_ALIGN_FOLLOWER = 355L;
        long autochangertrucks_MOVE_FOLLOWER_TRUCK_ALONE = 722L;
        long autochangertrucks_MOVE_TO_ABSOLUTE_POSITION = 851L;
        long latches_latchXminus_CLOSE = 115L;
        long latches_latchXminus_OPEN = 378L;
        long latches_latchXplus_CLOSE = 252L;
        long latches_latchXplus_OPEN = 76L;
        long onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_CURRENT = 244L;
        long onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION = 847L;
        long onlineclamps_onlineClampXminus_LOCK_ONLINECLAMP = 675L;
        long onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_CURRENT = 386L;
        long onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION = 757L;
        long onlineclamps_onlineClampXminus_REOPEN_ONLINECLAMP_MODE_CURRENT = 783L;
        long onlineclamps_onlineClampXminus_UNLOCK_ONLINECLAMP = 540L;
        long onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_CURRENT = 173L;
        long onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION = 707L;
        long onlineclamps_onlineClampXplus_LOCK_ONLINECLAMP = 535L;
        long onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_CURRENT = 561L;
        long onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION = 393L;
        long onlineclamps_onlineClampXplus_REOPEN_ONLINECLAMP_MODE_CURRENT = 827L;
        long onlineclamps_onlineClampXplus_UNLOCK_ONLINECLAMP = 556L;
        long onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_CURRENT = 85L;
        long onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION = 574L;
        long onlineclamps_onlineClampYminus_LOCK_ONLINECLAMP = 850L;
        long onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_CURRENT = 935L;
        long onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION = 491L;
        long onlineclamps_onlineClampYminus_REOPEN_ONLINECLAMP_MODE_CURRENT = 976L;
        long onlineclamps_onlineClampYminus_UNLOCK_ONLINECLAMP = 592L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Duration_Autochanger_TrendingTelemetry(autochangertrucks_ALIGN_FOLLOWER, autochangertrucks_MOVE_FOLLOWER_TRUCK_ALONE, autochangertrucks_MOVE_TO_ABSOLUTE_POSITION, latches_latchXminus_CLOSE, latches_latchXminus_OPEN, latches_latchXplus_CLOSE, latches_latchXplus_OPEN, onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampXminus_LOCK_ONLINECLAMP, onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampXminus_REOPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXminus_UNLOCK_ONLINECLAMP, onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampXplus_LOCK_ONLINECLAMP, onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampXplus_REOPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampXplus_UNLOCK_ONLINECLAMP, onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampYminus_LOCK_ONLINECLAMP, onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, onlineclamps_onlineClampYminus_REOPEN_ONLINECLAMP_MODE_CURRENT, onlineclamps_onlineClampYminus_UNLOCK_ONLINECLAMP));
        Assert.assertTrue((boolean)(item instanceof Fcs_Duration_Autochanger_TrendingTelemetry));
        Fcs_Duration_Autochanger_TrendingTelemetry item_ = (Fcs_Duration_Autochanger_TrendingTelemetry)item;
        Assert.assertEquals((long)autochangertrucks_ALIGN_FOLLOWER, (long)item_.getAutochangertrucks_ALIGN_FOLLOWER());
        Assert.assertEquals((long)autochangertrucks_MOVE_FOLLOWER_TRUCK_ALONE, (long)item_.getAutochangertrucks_MOVE_FOLLOWER_TRUCK_ALONE());
        Assert.assertEquals((long)autochangertrucks_MOVE_TO_ABSOLUTE_POSITION, (long)item_.getAutochangertrucks_MOVE_TO_ABSOLUTE_POSITION());
        Assert.assertEquals((long)latches_latchXminus_CLOSE, (long)item_.getLatches_latchXminus_CLOSE());
        Assert.assertEquals((long)latches_latchXminus_OPEN, (long)item_.getLatches_latchXminus_OPEN());
        Assert.assertEquals((long)latches_latchXplus_CLOSE, (long)item_.getLatches_latchXplus_CLOSE());
        Assert.assertEquals((long)latches_latchXplus_OPEN, (long)item_.getLatches_latchXplus_OPEN());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, (long)item_.getOnlineclamps_onlineClampXminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_LOCK_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampXminus_LOCK_ONLINECLAMP());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, (long)item_.getOnlineclamps_onlineClampXminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_REOPEN_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampXminus_REOPEN_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_UNLOCK_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampXminus_UNLOCK_ONLINECLAMP());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, (long)item_.getOnlineclamps_onlineClampXplus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_LOCK_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampXplus_LOCK_ONLINECLAMP());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, (long)item_.getOnlineclamps_onlineClampXplus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_REOPEN_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampXplus_REOPEN_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_UNLOCK_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampXplus_UNLOCK_ONLINECLAMP());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, (long)item_.getOnlineclamps_onlineClampYminus_CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_LOCK_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampYminus_LOCK_ONLINECLAMP());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, (long)item_.getOnlineclamps_onlineClampYminus_OPEN_ONLINECLAMP_MODE_PROFILE_POSITION());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_REOPEN_ONLINECLAMP_MODE_CURRENT, (long)item_.getOnlineclamps_onlineClampYminus_REOPEN_ONLINECLAMP_MODE_CURRENT());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_UNLOCK_ONLINECLAMP, (long)item_.getOnlineclamps_onlineClampYminus_UNLOCK_ONLINECLAMP());
    }

    @Test
    public void sendReceiveFcs_Duration_Carousel_TrendingTelemetry() throws Exception {
        long rotate_CAROUSEL_TO_ABSOLUTE_POSITION = 731L;
        long rotate_CAROUSEL_TO_RELATIVE_POSITION = 23L;
        int socket1_RELEASECLAMPS = 77;
        int socket1_UNLOCKCLAMPS = 835;
        long socket1_clampXminus1_RELEASE = 292L;
        long socket1_clampXminus1_UNLOCK = 756L;
        long socket1_clampXplus1_RELEASE = 992L;
        long socket1_clampXplus1_UNLOCK = 760L;
        int socket2_RELEASECLAMPS = 150;
        int socket2_UNLOCKCLAMPS = 61;
        long socket2_clampXminus2_RELEASE = 322L;
        long socket2_clampXminus2_UNLOCK = 348L;
        long socket2_clampXplus2_RELEASE = 967L;
        long socket2_clampXplus2_UNLOCK = 271L;
        int socket3_RELEASECLAMPS = 247;
        int socket3_UNLOCKCLAMPS = 248;
        long socket3_clampXminus3_RELEASE = 786L;
        long socket3_clampXminus3_UNLOCK = 443L;
        long socket3_clampXplus3_RELEASE = 612L;
        long socket3_clampXplus3_UNLOCK = 91L;
        int socket4_RELEASECLAMPS = 305;
        int socket4_UNLOCKCLAMPS = 50;
        long socket4_clampXminus4_RELEASE = 867L;
        long socket4_clampXminus4_UNLOCK = 873L;
        long socket4_clampXplus4_RELEASE = 86L;
        long socket4_clampXplus4_UNLOCK = 160L;
        int socket5_RELEASECLAMPS = 872;
        int socket5_UNLOCKCLAMPS = 906;
        long socket5_clampXminus5_RELEASE = 254L;
        long socket5_clampXminus5_UNLOCK = 747L;
        long socket5_clampXplus5_RELEASE = 116L;
        long socket5_clampXplus5_UNLOCK = 69L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Duration_Carousel_TrendingTelemetry(rotate_CAROUSEL_TO_ABSOLUTE_POSITION, rotate_CAROUSEL_TO_RELATIVE_POSITION, socket1_RELEASECLAMPS, socket1_UNLOCKCLAMPS, socket1_clampXminus1_RELEASE, socket1_clampXminus1_UNLOCK, socket1_clampXplus1_RELEASE, socket1_clampXplus1_UNLOCK, socket2_RELEASECLAMPS, socket2_UNLOCKCLAMPS, socket2_clampXminus2_RELEASE, socket2_clampXminus2_UNLOCK, socket2_clampXplus2_RELEASE, socket2_clampXplus2_UNLOCK, socket3_RELEASECLAMPS, socket3_UNLOCKCLAMPS, socket3_clampXminus3_RELEASE, socket3_clampXminus3_UNLOCK, socket3_clampXplus3_RELEASE, socket3_clampXplus3_UNLOCK, socket4_RELEASECLAMPS, socket4_UNLOCKCLAMPS, socket4_clampXminus4_RELEASE, socket4_clampXminus4_UNLOCK, socket4_clampXplus4_RELEASE, socket4_clampXplus4_UNLOCK, socket5_RELEASECLAMPS, socket5_UNLOCKCLAMPS, socket5_clampXminus5_RELEASE, socket5_clampXminus5_UNLOCK, socket5_clampXplus5_RELEASE, socket5_clampXplus5_UNLOCK));
        Assert.assertTrue((boolean)(item instanceof Fcs_Duration_Carousel_TrendingTelemetry));
        Fcs_Duration_Carousel_TrendingTelemetry item_ = (Fcs_Duration_Carousel_TrendingTelemetry)item;
        Assert.assertEquals((long)rotate_CAROUSEL_TO_ABSOLUTE_POSITION, (long)item_.getRotate_CAROUSEL_TO_ABSOLUTE_POSITION());
        Assert.assertEquals((long)rotate_CAROUSEL_TO_RELATIVE_POSITION, (long)item_.getRotate_CAROUSEL_TO_RELATIVE_POSITION());
        Assert.assertEquals((long)socket1_RELEASECLAMPS, (long)item_.getSocket1_RELEASECLAMPS());
        Assert.assertEquals((long)socket1_UNLOCKCLAMPS, (long)item_.getSocket1_UNLOCKCLAMPS());
        Assert.assertEquals((long)socket1_clampXminus1_RELEASE, (long)item_.getSocket1_clampXminus1_RELEASE());
        Assert.assertEquals((long)socket1_clampXminus1_UNLOCK, (long)item_.getSocket1_clampXminus1_UNLOCK());
        Assert.assertEquals((long)socket1_clampXplus1_RELEASE, (long)item_.getSocket1_clampXplus1_RELEASE());
        Assert.assertEquals((long)socket1_clampXplus1_UNLOCK, (long)item_.getSocket1_clampXplus1_UNLOCK());
        Assert.assertEquals((long)socket2_RELEASECLAMPS, (long)item_.getSocket2_RELEASECLAMPS());
        Assert.assertEquals((long)socket2_UNLOCKCLAMPS, (long)item_.getSocket2_UNLOCKCLAMPS());
        Assert.assertEquals((long)socket2_clampXminus2_RELEASE, (long)item_.getSocket2_clampXminus2_RELEASE());
        Assert.assertEquals((long)socket2_clampXminus2_UNLOCK, (long)item_.getSocket2_clampXminus2_UNLOCK());
        Assert.assertEquals((long)socket2_clampXplus2_RELEASE, (long)item_.getSocket2_clampXplus2_RELEASE());
        Assert.assertEquals((long)socket2_clampXplus2_UNLOCK, (long)item_.getSocket2_clampXplus2_UNLOCK());
        Assert.assertEquals((long)socket3_RELEASECLAMPS, (long)item_.getSocket3_RELEASECLAMPS());
        Assert.assertEquals((long)socket3_UNLOCKCLAMPS, (long)item_.getSocket3_UNLOCKCLAMPS());
        Assert.assertEquals((long)socket3_clampXminus3_RELEASE, (long)item_.getSocket3_clampXminus3_RELEASE());
        Assert.assertEquals((long)socket3_clampXminus3_UNLOCK, (long)item_.getSocket3_clampXminus3_UNLOCK());
        Assert.assertEquals((long)socket3_clampXplus3_RELEASE, (long)item_.getSocket3_clampXplus3_RELEASE());
        Assert.assertEquals((long)socket3_clampXplus3_UNLOCK, (long)item_.getSocket3_clampXplus3_UNLOCK());
        Assert.assertEquals((long)socket4_RELEASECLAMPS, (long)item_.getSocket4_RELEASECLAMPS());
        Assert.assertEquals((long)socket4_UNLOCKCLAMPS, (long)item_.getSocket4_UNLOCKCLAMPS());
        Assert.assertEquals((long)socket4_clampXminus4_RELEASE, (long)item_.getSocket4_clampXminus4_RELEASE());
        Assert.assertEquals((long)socket4_clampXminus4_UNLOCK, (long)item_.getSocket4_clampXminus4_UNLOCK());
        Assert.assertEquals((long)socket4_clampXplus4_RELEASE, (long)item_.getSocket4_clampXplus4_RELEASE());
        Assert.assertEquals((long)socket4_clampXplus4_UNLOCK, (long)item_.getSocket4_clampXplus4_UNLOCK());
        Assert.assertEquals((long)socket5_RELEASECLAMPS, (long)item_.getSocket5_RELEASECLAMPS());
        Assert.assertEquals((long)socket5_UNLOCKCLAMPS, (long)item_.getSocket5_UNLOCKCLAMPS());
        Assert.assertEquals((long)socket5_clampXminus5_RELEASE, (long)item_.getSocket5_clampXminus5_RELEASE());
        Assert.assertEquals((long)socket5_clampXminus5_UNLOCK, (long)item_.getSocket5_clampXminus5_UNLOCK());
        Assert.assertEquals((long)socket5_clampXplus5_RELEASE, (long)item_.getSocket5_clampXplus5_RELEASE());
        Assert.assertEquals((long)socket5_clampXplus5_UNLOCK, (long)item_.getSocket5_clampXplus5_UNLOCK());
    }

    @Test
    public void sendReceiveFcs_Duration_Loader_TrendingTelemetry() throws Exception {
        long carrier_MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION = 51L;
        long carrier_MOVE_LOADERCARRIER_TO_ENGAGED = 733L;
        long carrier_MOVE_LOADERCARRIER_TO_HANDOFF = 531L;
        long carrier_MOVE_LOADERCARRIER_TO_STORAGE = 427L;
        long hooks_CLAMPLOADERHOOKS = 604L;
        long hooks_CLOSELOADERHOOKS = 389L;
        long hooks_OPENHOMINGLOADERHOOKS = 140L;
        long hooks_UNCLAMPLOADERHOOKS = 360L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Duration_Loader_TrendingTelemetry(carrier_MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION, carrier_MOVE_LOADERCARRIER_TO_ENGAGED, carrier_MOVE_LOADERCARRIER_TO_HANDOFF, carrier_MOVE_LOADERCARRIER_TO_STORAGE, hooks_CLAMPLOADERHOOKS, hooks_CLOSELOADERHOOKS, hooks_OPENHOMINGLOADERHOOKS, hooks_UNCLAMPLOADERHOOKS));
        Assert.assertTrue((boolean)(item instanceof Fcs_Duration_Loader_TrendingTelemetry));
        Fcs_Duration_Loader_TrendingTelemetry item_ = (Fcs_Duration_Loader_TrendingTelemetry)item;
        Assert.assertEquals((long)carrier_MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION, (long)item_.getCarrier_MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION());
        Assert.assertEquals((long)carrier_MOVE_LOADERCARRIER_TO_ENGAGED, (long)item_.getCarrier_MOVE_LOADERCARRIER_TO_ENGAGED());
        Assert.assertEquals((long)carrier_MOVE_LOADERCARRIER_TO_HANDOFF, (long)item_.getCarrier_MOVE_LOADERCARRIER_TO_HANDOFF());
        Assert.assertEquals((long)carrier_MOVE_LOADERCARRIER_TO_STORAGE, (long)item_.getCarrier_MOVE_LOADERCARRIER_TO_STORAGE());
        Assert.assertEquals((long)hooks_CLAMPLOADERHOOKS, (long)item_.getHooks_CLAMPLOADERHOOKS());
        Assert.assertEquals((long)hooks_CLOSELOADERHOOKS, (long)item_.getHooks_CLOSELOADERHOOKS());
        Assert.assertEquals((long)hooks_OPENHOMINGLOADERHOOKS, (long)item_.getHooks_OPENHOMINGLOADERHOOKS());
        Assert.assertEquals((long)hooks_UNCLAMPLOADERHOOKS, (long)item_.getHooks_UNCLAMPLOADERHOOKS());
    }

    @Test
    public void sendReceiveFcs_Duration_TrendingTelemetry() throws Exception {
        long sETFILTER = 147L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Duration_TrendingTelemetry(sETFILTER));
        Assert.assertTrue((boolean)(item instanceof Fcs_Duration_TrendingTelemetry));
        Fcs_Duration_TrendingTelemetry item_ = (Fcs_Duration_TrendingTelemetry)item;
        Assert.assertEquals((long)sETFILTER, (long)item_.getSETFILTER());
    }

    @Test
    public void sendReceiveFcs_Fcs_Mcm_TrendingTelemetry() throws Exception {
        String autochanger_trucks_location = "c";
        int autochanger_trucks_position = 787;
        int filter_on_autochanger_id = 154;
        String filter_on_autochanger_name = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Fcs_Mcm_TrendingTelemetry(autochanger_trucks_location, autochanger_trucks_position, filter_on_autochanger_id, filter_on_autochanger_name));
        Assert.assertTrue((boolean)(item instanceof Fcs_Fcs_Mcm_TrendingTelemetry));
        Fcs_Fcs_Mcm_TrendingTelemetry item_ = (Fcs_Fcs_Mcm_TrendingTelemetry)item;
        Assert.assertEquals((Object)autochanger_trucks_location, (Object)item_.getAutochanger_trucks_location());
        Assert.assertEquals((long)autochanger_trucks_position, (long)item_.getAutochanger_trucks_position());
        Assert.assertEquals((long)filter_on_autochanger_id, (long)item_.getFilter_on_autochanger_id());
        Assert.assertEquals((Object)filter_on_autochanger_name, (Object)item_.getFilter_on_autochanger_name());
    }

    @Test
    public void sendReceiveFcs_Loader_Carrier_TrendingTelemetry() throws Exception {
        boolean atEngaged = true;
        boolean atHandoff = false;
        boolean atStorage = true;
        boolean controllerInError = false;
        boolean engagedSensorOn = true;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Loader_Carrier_TrendingTelemetry(atEngaged, atHandoff, atStorage, controllerInError, engagedSensorOn));
        Assert.assertTrue((boolean)(item instanceof Fcs_Loader_Carrier_TrendingTelemetry));
        Fcs_Loader_Carrier_TrendingTelemetry item_ = (Fcs_Loader_Carrier_TrendingTelemetry)item;
        Assert.assertEquals((Object)atEngaged, (Object)item_.isAtEngaged());
        Assert.assertEquals((Object)atHandoff, (Object)item_.isAtHandoff());
        Assert.assertEquals((Object)atStorage, (Object)item_.isAtStorage());
        Assert.assertEquals((Object)controllerInError, (Object)item_.isControllerInError());
        Assert.assertEquals((Object)engagedSensorOn, (Object)item_.isEngagedSensorOn());
    }

    @Test
    public void sendReceiveFcs_Loader_Hooks_TrendingTelemetry() throws Exception {
        boolean allHooksInStateCLOSED = false;
        String clampState = "k";
        boolean controllerInError = false;
        boolean forceClampedStatus = true;
        boolean forceOverClampedStatus = true;
        int forceSensorVoltage0 = 518;
        int forceSensorVoltage1 = 353;
        String forceStatus = "f";
        boolean forceUnclampedStatus = true;
        boolean forceUnderClampedStatus = false;
        boolean statuspublishedbyhook1_inError = true;
        boolean statuspublishedbyhook1_lockSensorValue = true;
        String statuspublishedbyhook1_lockStatus = "l";
        boolean statuspublishedbyhook1_unlockSensorValue = true;
        boolean statuspublishedbyhook2_inError = false;
        boolean statuspublishedbyhook2_lockSensorValue = false;
        String statuspublishedbyhook2_lockStatus = "";
        boolean statuspublishedbyhook2_unlockSensorValue = true;
        boolean statuspublishedbyhook3_inError = false;
        boolean statuspublishedbyhook3_lockSensorValue = true;
        String statuspublishedbyhook3_lockStatus = "";
        boolean statuspublishedbyhook3_unlockSensorValue = false;
        boolean statuspublishedbyhook4_inError = true;
        boolean statuspublishedbyhook4_lockSensorValue = false;
        String statuspublishedbyhook4_lockStatus = "";
        boolean statuspublishedbyhook4_unlockSensorValue = false;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Loader_Hooks_TrendingTelemetry(allHooksInStateCLOSED, clampState, controllerInError, forceClampedStatus, forceOverClampedStatus, forceSensorVoltage0, forceSensorVoltage1, forceStatus, forceUnclampedStatus, forceUnderClampedStatus, statuspublishedbyhook1_inError, statuspublishedbyhook1_lockSensorValue, statuspublishedbyhook1_lockStatus, statuspublishedbyhook1_unlockSensorValue, statuspublishedbyhook2_inError, statuspublishedbyhook2_lockSensorValue, statuspublishedbyhook2_lockStatus, statuspublishedbyhook2_unlockSensorValue, statuspublishedbyhook3_inError, statuspublishedbyhook3_lockSensorValue, statuspublishedbyhook3_lockStatus, statuspublishedbyhook3_unlockSensorValue, statuspublishedbyhook4_inError, statuspublishedbyhook4_lockSensorValue, statuspublishedbyhook4_lockStatus, statuspublishedbyhook4_unlockSensorValue));
        Assert.assertTrue((boolean)(item instanceof Fcs_Loader_Hooks_TrendingTelemetry));
        Fcs_Loader_Hooks_TrendingTelemetry item_ = (Fcs_Loader_Hooks_TrendingTelemetry)item;
        Assert.assertEquals((Object)allHooksInStateCLOSED, (Object)item_.isAllHooksInStateCLOSED());
        Assert.assertEquals((Object)clampState, (Object)item_.getClampState());
        Assert.assertEquals((Object)controllerInError, (Object)item_.isControllerInError());
        Assert.assertEquals((Object)forceClampedStatus, (Object)item_.isForceClampedStatus());
        Assert.assertEquals((Object)forceOverClampedStatus, (Object)item_.isForceOverClampedStatus());
        Assert.assertEquals((long)forceSensorVoltage0, (long)item_.getForceSensorVoltage0());
        Assert.assertEquals((long)forceSensorVoltage1, (long)item_.getForceSensorVoltage1());
        Assert.assertEquals((Object)forceStatus, (Object)item_.getForceStatus());
        Assert.assertEquals((Object)forceUnclampedStatus, (Object)item_.isForceUnclampedStatus());
        Assert.assertEquals((Object)forceUnderClampedStatus, (Object)item_.isForceUnderClampedStatus());
        Assert.assertEquals((Object)statuspublishedbyhook1_inError, (Object)item_.isStatuspublishedbyhook1_inError());
        Assert.assertEquals((Object)statuspublishedbyhook1_lockSensorValue, (Object)item_.isStatuspublishedbyhook1_lockSensorValue());
        Assert.assertEquals((Object)statuspublishedbyhook1_lockStatus, (Object)item_.getStatuspublishedbyhook1_lockStatus());
        Assert.assertEquals((Object)statuspublishedbyhook1_unlockSensorValue, (Object)item_.isStatuspublishedbyhook1_unlockSensorValue());
        Assert.assertEquals((Object)statuspublishedbyhook2_inError, (Object)item_.isStatuspublishedbyhook2_inError());
        Assert.assertEquals((Object)statuspublishedbyhook2_lockSensorValue, (Object)item_.isStatuspublishedbyhook2_lockSensorValue());
        Assert.assertEquals((Object)statuspublishedbyhook2_lockStatus, (Object)item_.getStatuspublishedbyhook2_lockStatus());
        Assert.assertEquals((Object)statuspublishedbyhook2_unlockSensorValue, (Object)item_.isStatuspublishedbyhook2_unlockSensorValue());
        Assert.assertEquals((Object)statuspublishedbyhook3_inError, (Object)item_.isStatuspublishedbyhook3_inError());
        Assert.assertEquals((Object)statuspublishedbyhook3_lockSensorValue, (Object)item_.isStatuspublishedbyhook3_lockSensorValue());
        Assert.assertEquals((Object)statuspublishedbyhook3_lockStatus, (Object)item_.getStatuspublishedbyhook3_lockStatus());
        Assert.assertEquals((Object)statuspublishedbyhook3_unlockSensorValue, (Object)item_.isStatuspublishedbyhook3_unlockSensorValue());
        Assert.assertEquals((Object)statuspublishedbyhook4_inError, (Object)item_.isStatuspublishedbyhook4_inError());
        Assert.assertEquals((Object)statuspublishedbyhook4_lockSensorValue, (Object)item_.isStatuspublishedbyhook4_lockSensorValue());
        Assert.assertEquals((Object)statuspublishedbyhook4_lockStatus, (Object)item_.getStatuspublishedbyhook4_lockStatus());
        Assert.assertEquals((Object)statuspublishedbyhook4_unlockSensorValue, (Object)item_.isStatuspublishedbyhook4_unlockSensorValue());
    }

    @Test
    public void sendReceiveFcs_TrendingTelemetry() throws Exception {
        int canbus0 = 758;
        int canbus1 = 414;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_TrendingTelemetry(canbus0, canbus1));
        Assert.assertTrue((boolean)(item instanceof Fcs_TrendingTelemetry));
        Fcs_TrendingTelemetry item_ = (Fcs_TrendingTelemetry)item;
        Assert.assertEquals((long)canbus0, (long)item_.getCanbus0());
        Assert.assertEquals((long)canbus1, (long)item_.getCanbus1());
    }

    @Test
    public void sendReceiveShutter_TrendingTelemetry() throws Exception {
        double shutterstatus_axstatus_MINUSX_actPos = 0.30591654777526855;
        double shutterstatus_axstatus_MINUSX_actVel = 0.22841012477874756;
        int shutterstatus_axstatus_MINUSX_brakeEngaged = 842;
        double shutterstatus_axstatus_MINUSX_ctrlTemp = 0.7942166328430176;
        int shutterstatus_axstatus_MINUSX_enabled = 156;
        int shutterstatus_axstatus_MINUSX_errorID = 958;
        int shutterstatus_axstatus_MINUSX_hasSafeTemp = 110;
        int shutterstatus_axstatus_MINUSX_highLimit = 640;
        int shutterstatus_axstatus_MINUSX_isHomed = 165;
        int shutterstatus_axstatus_MINUSX_lowLimit = 863;
        double shutterstatus_axstatus_MINUSX_setAcc = 0.24658f;
        double shutterstatus_axstatus_PLUSX_actPos = 0.4052159786224365;
        double shutterstatus_axstatus_PLUSX_actVel = 0.2127559781074524;
        int shutterstatus_axstatus_PLUSX_brakeEngaged = 691;
        double shutterstatus_axstatus_PLUSX_ctrlTemp = 0.14084428548812866;
        int shutterstatus_axstatus_PLUSX_enabled = 182;
        int shutterstatus_axstatus_PLUSX_errorID = 254;
        int shutterstatus_axstatus_PLUSX_hasSafeTemp = 330;
        int shutterstatus_axstatus_PLUSX_highLimit = 350;
        int shutterstatus_axstatus_PLUSX_isHomed = 604;
        int shutterstatus_axstatus_PLUSX_lowLimit = 390;
        double shutterstatus_axstatus_PLUSX_setAcc = 0.8392289280891418;
        int shutterstatus_isCalibrated = 766;
        int shutterstatus_isSafetyOn = 851;
        int shutterstatus_motionProfile = 417;
        int shutterstatus_smState = 390;
        int shutterstatus_tempIsSafe_CONTROL_BOX = 611;
        int shutterstatus_tempIsSafe_MINUSX_MOTOR = 348;
        int shutterstatus_tempIsSafe_PLUSX_MOTOR = 282;
        double shutterstatus_temperature_CONTROL_BOX = 0.828124463558197;
        double shutterstatus_temperature_MINUSX_MOTOR = 0.8273234367370605;
        double shutterstatus_temperature_PLUSX_MOTOR = 0.15033096075057983;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Shutter_TrendingTelemetry(shutterstatus_axstatus_MINUSX_actPos, shutterstatus_axstatus_MINUSX_actVel, shutterstatus_axstatus_MINUSX_brakeEngaged, shutterstatus_axstatus_MINUSX_ctrlTemp, shutterstatus_axstatus_MINUSX_enabled, shutterstatus_axstatus_MINUSX_errorID, shutterstatus_axstatus_MINUSX_hasSafeTemp, shutterstatus_axstatus_MINUSX_highLimit, shutterstatus_axstatus_MINUSX_isHomed, shutterstatus_axstatus_MINUSX_lowLimit, shutterstatus_axstatus_MINUSX_setAcc, shutterstatus_axstatus_PLUSX_actPos, shutterstatus_axstatus_PLUSX_actVel, shutterstatus_axstatus_PLUSX_brakeEngaged, shutterstatus_axstatus_PLUSX_ctrlTemp, shutterstatus_axstatus_PLUSX_enabled, shutterstatus_axstatus_PLUSX_errorID, shutterstatus_axstatus_PLUSX_hasSafeTemp, shutterstatus_axstatus_PLUSX_highLimit, shutterstatus_axstatus_PLUSX_isHomed, shutterstatus_axstatus_PLUSX_lowLimit, shutterstatus_axstatus_PLUSX_setAcc, shutterstatus_isCalibrated, shutterstatus_isSafetyOn, shutterstatus_motionProfile, shutterstatus_smState, shutterstatus_tempIsSafe_CONTROL_BOX, shutterstatus_tempIsSafe_MINUSX_MOTOR, shutterstatus_tempIsSafe_PLUSX_MOTOR, shutterstatus_temperature_CONTROL_BOX, shutterstatus_temperature_MINUSX_MOTOR, shutterstatus_temperature_PLUSX_MOTOR));
        Assert.assertTrue((boolean)(item instanceof Shutter_TrendingTelemetry));
        Shutter_TrendingTelemetry item_ = (Shutter_TrendingTelemetry)item;
        Assert.assertEquals((double)shutterstatus_axstatus_MINUSX_actPos, (double)item_.getShutterstatus_axstatus_MINUSX_actPos(), (double)1.0E-6f);
        Assert.assertEquals((double)shutterstatus_axstatus_MINUSX_actVel, (double)item_.getShutterstatus_axstatus_MINUSX_actVel(), (double)1.0E-6f);
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_brakeEngaged, (long)item_.getShutterstatus_axstatus_MINUSX_brakeEngaged());
        Assert.assertEquals((double)shutterstatus_axstatus_MINUSX_ctrlTemp, (double)item_.getShutterstatus_axstatus_MINUSX_ctrlTemp(), (double)1.0E-6f);
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_enabled, (long)item_.getShutterstatus_axstatus_MINUSX_enabled());
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_errorID, (long)item_.getShutterstatus_axstatus_MINUSX_errorID());
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_hasSafeTemp, (long)item_.getShutterstatus_axstatus_MINUSX_hasSafeTemp());
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_highLimit, (long)item_.getShutterstatus_axstatus_MINUSX_highLimit());
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_isHomed, (long)item_.getShutterstatus_axstatus_MINUSX_isHomed());
        Assert.assertEquals((long)shutterstatus_axstatus_MINUSX_lowLimit, (long)item_.getShutterstatus_axstatus_MINUSX_lowLimit());
        Assert.assertEquals((double)shutterstatus_axstatus_MINUSX_setAcc, (double)item_.getShutterstatus_axstatus_MINUSX_setAcc(), (double)1.0E-6f);
        Assert.assertEquals((double)shutterstatus_axstatus_PLUSX_actPos, (double)item_.getShutterstatus_axstatus_PLUSX_actPos(), (double)1.0E-6f);
        Assert.assertEquals((double)shutterstatus_axstatus_PLUSX_actVel, (double)item_.getShutterstatus_axstatus_PLUSX_actVel(), (double)1.0E-6f);
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_brakeEngaged, (long)item_.getShutterstatus_axstatus_PLUSX_brakeEngaged());
        Assert.assertEquals((double)shutterstatus_axstatus_PLUSX_ctrlTemp, (double)item_.getShutterstatus_axstatus_PLUSX_ctrlTemp(), (double)1.0E-6f);
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_enabled, (long)item_.getShutterstatus_axstatus_PLUSX_enabled());
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_errorID, (long)item_.getShutterstatus_axstatus_PLUSX_errorID());
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_hasSafeTemp, (long)item_.getShutterstatus_axstatus_PLUSX_hasSafeTemp());
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_highLimit, (long)item_.getShutterstatus_axstatus_PLUSX_highLimit());
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_isHomed, (long)item_.getShutterstatus_axstatus_PLUSX_isHomed());
        Assert.assertEquals((long)shutterstatus_axstatus_PLUSX_lowLimit, (long)item_.getShutterstatus_axstatus_PLUSX_lowLimit());
        Assert.assertEquals((double)shutterstatus_axstatus_PLUSX_setAcc, (double)item_.getShutterstatus_axstatus_PLUSX_setAcc(), (double)1.0E-6f);
        Assert.assertEquals((long)shutterstatus_isCalibrated, (long)item_.getShutterstatus_isCalibrated());
        Assert.assertEquals((long)shutterstatus_isSafetyOn, (long)item_.getShutterstatus_isSafetyOn());
        Assert.assertEquals((long)shutterstatus_motionProfile, (long)item_.getShutterstatus_motionProfile());
        Assert.assertEquals((long)shutterstatus_smState, (long)item_.getShutterstatus_smState());
        Assert.assertEquals((long)shutterstatus_tempIsSafe_CONTROL_BOX, (long)item_.getShutterstatus_tempIsSafe_CONTROL_BOX());
        Assert.assertEquals((long)shutterstatus_tempIsSafe_MINUSX_MOTOR, (long)item_.getShutterstatus_tempIsSafe_MINUSX_MOTOR());
        Assert.assertEquals((long)shutterstatus_tempIsSafe_PLUSX_MOTOR, (long)item_.getShutterstatus_tempIsSafe_PLUSX_MOTOR());
        Assert.assertEquals((double)shutterstatus_temperature_CONTROL_BOX, (double)item_.getShutterstatus_temperature_CONTROL_BOX(), (double)1.0E-6f);
        Assert.assertEquals((double)shutterstatus_temperature_MINUSX_MOTOR, (double)item_.getShutterstatus_temperature_MINUSX_MOTOR(), (double)1.0E-6f);
        Assert.assertEquals((double)shutterstatus_temperature_PLUSX_MOTOR, (double)item_.getShutterstatus_temperature_PLUSX_MOTOR(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveChiller_ChillerTelemetry() throws Exception {
        double chillerPumpLife = 0.8165153861045837;
        double chillerStatus = 0.1770561933517456;
        double chillerValveAct = 0.7531639337539673;
        double compressorLife = 0.6849716901779175;
        double controllerLife = 0.6860493421554565;
        double coolPercentage = 0.10641586780548096;
        double flowRate = 0.8348446488380432;
        double flowSetPoint = 0.24506932497024536;
        double fluidTemperature = 0.3251359462738037;
        double heatPercentage = 0.8296629190444946;
        double importedColdTemp = 0.8611286878585815;
        double pressureIn = 0.31041085720062256;
        double pressureOut = 0.96673f;
        double pressureTank = 0.11493712663650513;
        double tankSetPoint = 0.5034816265106201;
        double tempCondenser = 0.1130760908126831;
        double tempDUTInput = 0.9360191822052002;
        double tempDynamicSetPt = 0.540476f;
        double tempSetPoint = 0.30148857831954956;
        double tempStage2Evap = 0.4389711022377014;
        double tempTXVBulb = 0.34592121839523315;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Chiller_ChillerTelemetry(chillerPumpLife, chillerStatus, chillerValveAct, compressorLife, controllerLife, coolPercentage, flowRate, flowSetPoint, fluidTemperature, heatPercentage, importedColdTemp, pressureIn, pressureOut, pressureTank, tankSetPoint, tempCondenser, tempDUTInput, tempDynamicSetPt, tempSetPoint, tempStage2Evap, tempTXVBulb));
        Assert.assertTrue((boolean)(item instanceof Chiller_ChillerTelemetry));
        Chiller_ChillerTelemetry item_ = (Chiller_ChillerTelemetry)item;
        Assert.assertEquals((double)chillerPumpLife, (double)item_.getChillerPumpLife(), (double)1.0E-6f);
        Assert.assertEquals((double)chillerStatus, (double)item_.getChillerStatus(), (double)1.0E-6f);
        Assert.assertEquals((double)chillerValveAct, (double)item_.getChillerValveAct(), (double)1.0E-6f);
        Assert.assertEquals((double)compressorLife, (double)item_.getCompressorLife(), (double)1.0E-6f);
        Assert.assertEquals((double)controllerLife, (double)item_.getControllerLife(), (double)1.0E-6f);
        Assert.assertEquals((double)coolPercentage, (double)item_.getCoolPercentage(), (double)1.0E-6f);
        Assert.assertEquals((double)flowRate, (double)item_.getFlowRate(), (double)1.0E-6f);
        Assert.assertEquals((double)flowSetPoint, (double)item_.getFlowSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((double)fluidTemperature, (double)item_.getFluidTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)heatPercentage, (double)item_.getHeatPercentage(), (double)1.0E-6f);
        Assert.assertEquals((double)importedColdTemp, (double)item_.getImportedColdTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)pressureIn, (double)item_.getPressureIn(), (double)1.0E-6f);
        Assert.assertEquals((double)pressureOut, (double)item_.getPressureOut(), (double)1.0E-6f);
        Assert.assertEquals((double)pressureTank, (double)item_.getPressureTank(), (double)1.0E-6f);
        Assert.assertEquals((double)tankSetPoint, (double)item_.getTankSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((double)tempCondenser, (double)item_.getTempCondenser(), (double)1.0E-6f);
        Assert.assertEquals((double)tempDUTInput, (double)item_.getTempDUTInput(), (double)1.0E-6f);
        Assert.assertEquals((double)tempDynamicSetPt, (double)item_.getTempDynamicSetPt(), (double)1.0E-6f);
        Assert.assertEquals((double)tempSetPoint, (double)item_.getTempSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((double)tempStage2Evap, (double)item_.getTempStage2Evap(), (double)1.0E-6f);
        Assert.assertEquals((double)tempTXVBulb, (double)item_.getTempTXVBulb(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveChiller_FParam_TrendingTelemetry() throws Exception {
        double bubblev_TIME = 0.6803826689720154;
        double clr_KI_SETPT = 0.01915425f;
        double cold_PERIOD = 0.158934f;
        double cool_CAPACITY = 0.667233f;
        double dut_DT_HI = 0.6956236958503723;
        double dut_DT_LO = 0.1703487f;
        double dut_KI = 0.5407485961914062;
        double dut_KP = 0.03880512714385986;
        double dut_TMAX = 0.6370178461074829;
        double dut_TMIN = 0.4270828366279602;
        double flowmeter_LO = 0.3602006435394287;
        double flow_ERR_MASK = 0.7889949679374695;
        double heat_CAPACITY = 0.2908143401145935;
        double pid_GAINFAC = 0.3066306710243225;
        double pid_KD = 0.857697f;
        double pid_KI = 0.05199742317199707;
        double pid_KP = 0.04391789436340332;
        double ramp_DEFAULT = 0.4251352f;
        double refrig_OFF = 0.39666497707366943;
        double setpt_SETTLE = 0.5316452383995056;
        double setpt_TOL = 0.08618307113647461;
        double tank_SETPOINT = 0.976752758026123;
        double thermsl_MASS = 0.2563069462776184;
        double t_CTRL_MODE = 0.29423975944519043;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Chiller_FParam_TrendingTelemetry(bubblev_TIME, clr_KI_SETPT, cold_PERIOD, cool_CAPACITY, dut_DT_HI, dut_DT_LO, dut_KI, dut_KP, dut_TMAX, dut_TMIN, flowmeter_LO, flow_ERR_MASK, heat_CAPACITY, pid_GAINFAC, pid_KD, pid_KI, pid_KP, ramp_DEFAULT, refrig_OFF, setpt_SETTLE, setpt_TOL, tank_SETPOINT, thermsl_MASS, t_CTRL_MODE));
        Assert.assertTrue((boolean)(item instanceof Chiller_FParam_TrendingTelemetry));
        Chiller_FParam_TrendingTelemetry item_ = (Chiller_FParam_TrendingTelemetry)item;
        Assert.assertEquals((double)bubblev_TIME, (double)item_.getBubblev_TIME(), (double)1.0E-6f);
        Assert.assertEquals((double)clr_KI_SETPT, (double)item_.getClr_KI_SETPT(), (double)1.0E-6f);
        Assert.assertEquals((double)cold_PERIOD, (double)item_.getCold_PERIOD(), (double)1.0E-6f);
        Assert.assertEquals((double)cool_CAPACITY, (double)item_.getCool_CAPACITY(), (double)1.0E-6f);
        Assert.assertEquals((double)dut_DT_HI, (double)item_.getDut_DT_HI(), (double)1.0E-6f);
        Assert.assertEquals((double)dut_DT_LO, (double)item_.getDut_DT_LO(), (double)1.0E-6f);
        Assert.assertEquals((double)dut_KI, (double)item_.getDut_KI(), (double)1.0E-6f);
        Assert.assertEquals((double)dut_KP, (double)item_.getDut_KP(), (double)1.0E-6f);
        Assert.assertEquals((double)dut_TMAX, (double)item_.getDut_TMAX(), (double)1.0E-6f);
        Assert.assertEquals((double)dut_TMIN, (double)item_.getDut_TMIN(), (double)1.0E-6f);
        Assert.assertEquals((double)flowmeter_LO, (double)item_.getFlowmeter_LO(), (double)1.0E-6f);
        Assert.assertEquals((double)flow_ERR_MASK, (double)item_.getFlow_ERR_MASK(), (double)1.0E-6f);
        Assert.assertEquals((double)heat_CAPACITY, (double)item_.getHeat_CAPACITY(), (double)1.0E-6f);
        Assert.assertEquals((double)pid_GAINFAC, (double)item_.getPid_GAINFAC(), (double)1.0E-6f);
        Assert.assertEquals((double)pid_KD, (double)item_.getPid_KD(), (double)1.0E-6f);
        Assert.assertEquals((double)pid_KI, (double)item_.getPid_KI(), (double)1.0E-6f);
        Assert.assertEquals((double)pid_KP, (double)item_.getPid_KP(), (double)1.0E-6f);
        Assert.assertEquals((double)ramp_DEFAULT, (double)item_.getRamp_DEFAULT(), (double)1.0E-6f);
        Assert.assertEquals((double)refrig_OFF, (double)item_.getRefrig_OFF(), (double)1.0E-6f);
        Assert.assertEquals((double)setpt_SETTLE, (double)item_.getSetpt_SETTLE(), (double)1.0E-6f);
        Assert.assertEquals((double)setpt_TOL, (double)item_.getSetpt_TOL(), (double)1.0E-6f);
        Assert.assertEquals((double)tank_SETPOINT, (double)item_.getTank_SETPOINT(), (double)1.0E-6f);
        Assert.assertEquals((double)thermsl_MASS, (double)item_.getThermsl_MASS(), (double)1.0E-6f);
        Assert.assertEquals((double)t_CTRL_MODE, (double)item_.getT_CTRL_MODE(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveChiller_Maq20Telemetry() throws Exception {
        double ambientTemp = 0.2633909583091736;
        double coolantHXOut = 0.29723918437957764;
        double coolantPumpIn = 0.8352833986282349;
        double coolantPumpOut = 0.06735879182815552;
        double coolantReturn = 0.1490703821182251;
        double coolantSupply = 0.07591694593429565;
        double glycChillerIn = 0.9211373925209045;
        double glycChillerOut = 0.4429643750190735;
        double glycCondensOut = 0.9094047546386719;
        double glycDeSuHtrOut = 0.245069682598114;
        double glycFanIn = 0.8749772310256958;
        double glycFanOut = 0.8931918740272522;
        double glycHeatXfer = 0.42685467004776;
        double glycInputFlow = 0.8839961290359497;
        double pBurstReturn = 0.1399616003036499;
        double pBurstSupply = 0.8217657208442688;
        double stg1CondensOut = 0.9492508172988892;
        double stg1Discharge = 0.7873517870903015;
        double stg1Return = 0.46894896030426025;
        double stg1TXVBulb = 0.412001371383667;
        double stg2DeSuHtrOut = 0.4069966f;
        double stg2Discharge = 0.15327447652816772;
        double stg2DischargeP = 0.5103925466537476;
        double stg2EvapIn = 0.6658848524093628;
        double stg2EvapOut = 0.04734367f;
        double stg2Return = 0.21350562572479248;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Chiller_Maq20Telemetry(ambientTemp, coolantHXOut, coolantPumpIn, coolantPumpOut, coolantReturn, coolantSupply, glycChillerIn, glycChillerOut, glycCondensOut, glycDeSuHtrOut, glycFanIn, glycFanOut, glycHeatXfer, glycInputFlow, pBurstReturn, pBurstSupply, stg1CondensOut, stg1Discharge, stg1Return, stg1TXVBulb, stg2DeSuHtrOut, stg2Discharge, stg2DischargeP, stg2EvapIn, stg2EvapOut, stg2Return));
        Assert.assertTrue((boolean)(item instanceof Chiller_Maq20Telemetry));
        Chiller_Maq20Telemetry item_ = (Chiller_Maq20Telemetry)item;
        Assert.assertEquals((double)ambientTemp, (double)item_.getAmbientTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantHXOut, (double)item_.getCoolantHXOut(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantPumpIn, (double)item_.getCoolantPumpIn(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantPumpOut, (double)item_.getCoolantPumpOut(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantReturn, (double)item_.getCoolantReturn(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantSupply, (double)item_.getCoolantSupply(), (double)1.0E-6f);
        Assert.assertEquals((double)glycChillerIn, (double)item_.getGlycChillerIn(), (double)1.0E-6f);
        Assert.assertEquals((double)glycChillerOut, (double)item_.getGlycChillerOut(), (double)1.0E-6f);
        Assert.assertEquals((double)glycCondensOut, (double)item_.getGlycCondensOut(), (double)1.0E-6f);
        Assert.assertEquals((double)glycDeSuHtrOut, (double)item_.getGlycDeSuHtrOut(), (double)1.0E-6f);
        Assert.assertEquals((double)glycFanIn, (double)item_.getGlycFanIn(), (double)1.0E-6f);
        Assert.assertEquals((double)glycFanOut, (double)item_.getGlycFanOut(), (double)1.0E-6f);
        Assert.assertEquals((double)glycHeatXfer, (double)item_.getGlycHeatXfer(), (double)1.0E-6f);
        Assert.assertEquals((double)glycInputFlow, (double)item_.getGlycInputFlow(), (double)1.0E-6f);
        Assert.assertEquals((double)pBurstReturn, (double)item_.getPBurstReturn(), (double)1.0E-6f);
        Assert.assertEquals((double)pBurstSupply, (double)item_.getPBurstSupply(), (double)1.0E-6f);
        Assert.assertEquals((double)stg1CondensOut, (double)item_.getStg1CondensOut(), (double)1.0E-6f);
        Assert.assertEquals((double)stg1Discharge, (double)item_.getStg1Discharge(), (double)1.0E-6f);
        Assert.assertEquals((double)stg1Return, (double)item_.getStg1Return(), (double)1.0E-6f);
        Assert.assertEquals((double)stg1TXVBulb, (double)item_.getStg1TXVBulb(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2DeSuHtrOut, (double)item_.getStg2DeSuHtrOut(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2Discharge, (double)item_.getStg2Discharge(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2DischargeP, (double)item_.getStg2DischargeP(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2EvapIn, (double)item_.getStg2EvapIn(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2EvapOut, (double)item_.getStg2EvapOut(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2Return, (double)item_.getStg2Return(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveThermal_Cold_TempTelemetry() throws Exception {
        double avgColdTemp = 0.7369011044502258;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Thermal_Cold_TempTelemetry(avgColdTemp));
        Assert.assertTrue((boolean)(item instanceof Thermal_Cold_TempTelemetry));
        Thermal_Cold_TempTelemetry item_ = (Thermal_Cold_TempTelemetry)item;
        Assert.assertEquals((double)avgColdTemp, (double)item_.getAvgColdTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveThermal_Cryo_TempTelemetry() throws Exception {
        double avgCryoTemp = 0.3329721f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Thermal_Cryo_TempTelemetry(avgCryoTemp));
        Assert.assertTrue((boolean)(item instanceof Thermal_Cryo_TempTelemetry));
        Thermal_Cryo_TempTelemetry item_ = (Thermal_Cryo_TempTelemetry)item;
        Assert.assertEquals((double)avgCryoTemp, (double)item_.getAvgCryoTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveThermal_RtdTelemetry() throws Exception {
        double[] cold_Temp = TestHelper.generateDoubleArray((int)20, (int)1579452933);
        double[] cryo_Temp = TestHelper.generateDoubleArray((int)20, (int)1936174384);
        double[] grid_Temp = TestHelper.generateDoubleArray((int)20, (int)1108974211);
        String location = "a";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Thermal_RtdTelemetry(cold_Temp, cryo_Temp, grid_Temp, location));
        Assert.assertTrue((boolean)(item instanceof Thermal_RtdTelemetry));
        Thermal_RtdTelemetry item_ = (Thermal_RtdTelemetry)item;
        Assert.assertArrayEquals((double[])cold_Temp, (double[])item_.getCold_Temp(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_Temp, (double[])item_.getCryo_Temp(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])grid_Temp, (double[])item_.getGrid_Temp(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveThermal_TrimTelemetry() throws Exception {
        String location = "";
        double[] trim_Htrs_I = TestHelper.generateDoubleArray((int)12, (int)1956435610);
        double[] trim_Htrs_P = TestHelper.generateDoubleArray((int)12, (int)2125713861);
        double[] trim_Htrs_V = TestHelper.generateDoubleArray((int)12, (int)861103652);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Thermal_TrimTelemetry(location, trim_Htrs_I, trim_Htrs_P, trim_Htrs_V));
        Assert.assertTrue((boolean)(item instanceof Thermal_TrimTelemetry));
        Thermal_TrimTelemetry item_ = (Thermal_TrimTelemetry)item;
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])trim_Htrs_I, (double[])item_.getTrim_Htrs_I(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Htrs_P, (double[])item_.getTrim_Htrs_P(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Htrs_V, (double[])item_.getTrim_Htrs_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveThermal_Trim_HtrsTelemetry() throws Exception {
        double coldtotal_P = 0.22987210750579834;
        double cryototal_P = 0.99916011095047;
        double htrBulkTmp = 0.2362495f;
        double htrbulk_I = 0.5939400792121887;
        double htrbulk_P = 0.6435844898223877;
        double htrbulk_V = 0.07279932498931885;
        double htrPsTmp = 0.853326678276062;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Thermal_Trim_HtrsTelemetry(coldtotal_P, cryototal_P, htrBulkTmp, htrbulk_I, htrbulk_P, htrbulk_V, htrPsTmp));
        Assert.assertTrue((boolean)(item instanceof Thermal_Trim_HtrsTelemetry));
        Thermal_Trim_HtrsTelemetry item_ = (Thermal_Trim_HtrsTelemetry)item;
        Assert.assertEquals((double)coldtotal_P, (double)item_.getColdtotal_P(), (double)1.0E-6f);
        Assert.assertEquals((double)cryototal_P, (double)item_.getCryototal_P(), (double)1.0E-6f);
        Assert.assertEquals((double)htrBulkTmp, (double)item_.getHtrBulkTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)htrbulk_I, (double)item_.getHtrbulk_I(), (double)1.0E-6f);
        Assert.assertEquals((double)htrbulk_P, (double)item_.getHtrbulk_P(), (double)1.0E-6f);
        Assert.assertEquals((double)htrbulk_V, (double)item_.getHtrbulk_V(), (double)1.0E-6f);
        Assert.assertEquals((double)htrPsTmp, (double)item_.getHtrPsTmp(), (double)1.0E-6f);
    }
}

