/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALEvent;
import org.lsst.sal.SALException;
import org.lsst.sal.TestHelper;
import org.lsst.sal.camera.SALCamera;
import org.lsst.sal.camera.event.AlertRaisedEvent;
import org.lsst.sal.camera.event.AuthListEvent;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.CCSConfiguredEvent;
import org.lsst.sal.camera.event.Chiller_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Chiller_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Chiller_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Chiller_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Chiller_timersConfigurationEvent;
import org.lsst.sal.camera.event.ConfigurationAppliedEvent;
import org.lsst.sal.camera.event.ConfigurationsAvailableEvent;
import org.lsst.sal.camera.event.Daq_monitor_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_Stats_StatisticsConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_StoreConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_Store_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_Store_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_Store_StoreConfigurationEvent;
import org.lsst.sal.camera.event.EndInitializeGuiderEvent;
import org.lsst.sal.camera.event.EndInitializeImageEvent;
import org.lsst.sal.camera.event.EndLoadFilterEvent;
import org.lsst.sal.camera.event.EndOfImageTelemetryEvent;
import org.lsst.sal.camera.event.EndReadoutEvent;
import org.lsst.sal.camera.event.EndRotateCarouselEvent;
import org.lsst.sal.camera.event.EndSetFilterEvent;
import org.lsst.sal.camera.event.EndShutterCloseEvent;
import org.lsst.sal.camera.event.EndShutterOpenEvent;
import org.lsst.sal.camera.event.EndTakeImageEvent;
import org.lsst.sal.camera.event.EndUnloadFilterEvent;
import org.lsst.sal.camera.event.ErrorCodeEvent;
import org.lsst.sal.camera.event.Fcs_Autochanger_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Autochanger_autochangerConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Autochanger_readRateConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Autochanger_sensorConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Canbus0_canbusConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Canbus0_controllerConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Canbus0_nodeIDConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Canbus0_sensorConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Canbus0_serialNBConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Canbus1_canbusConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Canbus1_controllerConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Canbus1_nodeIDConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Canbus1_serialNBConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Carousel_carouselConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Carousel_readRateConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Carousel_sensorConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_FilterIdentificator_sensorConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_FilterManager_filterConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Loader_loaderConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Loader_readRateConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Loader_sensorConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Seneca1_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Fcs_Seneca2_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.FocalPlaneSummaryInfoEvent;
import org.lsst.sal.camera.event.Focal_plane_Ccd_HardwareIdConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Ccd_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Ccd_RaftsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_ImageDatabaseService_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_ImageNameService_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_InstrumentConfig_InstrumentConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_MonitoringConfig_MonitoringConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Raft_HardwareIdConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Raft_RaftTempControlConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Raft_RaftTempControlStatusConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_RebTotalPower_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_HardwareIdConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_RaftsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_RaftsLimitsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_RaftsPowerConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_timersConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_RebsAverageTemp6_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_RebsAverageTemp6_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Segment_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_SequencerConfig_DAQConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_SequencerConfig_GuiderConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_SequencerConfig_SequencerConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_WebHooksConfig_VisualizationConfigurationEvent;
import org.lsst.sal.camera.event.HeartbeatEvent;
import org.lsst.sal.camera.event.Hex_Cold1_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Cold2_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Cryo1_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Cryo2_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Cryo3_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Cryo4_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Cryo5_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Cryo6_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Hex_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Maq20_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Maq20_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Hex_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Hex_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Hex_StatusAggregator_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.ImageReadoutParametersEvent;
import org.lsst.sal.camera.event.Image_handling_FitsService_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_ImageHandler_CommandsConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_ImageHandler_DAQConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_ImageHandler_FitsHandlingConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_ImageHandler_GuiderConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_StatusAggregator_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.LargeFileObjectAvailableEvent;
import org.lsst.sal.camera.event.LogLevelEvent;
import org.lsst.sal.camera.event.LogMessageEvent;
import org.lsst.sal.camera.event.NotReadyToTakeImageEvent;
import org.lsst.sal.camera.event.PrepareToTakeImageEvent;
import org.lsst.sal.camera.event.Quadbox_BFR_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_BFR_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_BFR_QuadboxConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_Maq20_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_Maq20_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_24VC_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_24VC_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_24VC_QuadboxConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_24VD_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_24VD_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_24VD_QuadboxConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_48V_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_48V_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_48V_QuadboxConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_5V_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_5V_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_5V_QuadboxConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_REB_Bulk_PS_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_REB_Bulk_PS_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_REB_Bulk_PS_QuadboxConfigurationEvent;
import org.lsst.sal.camera.event.ReadyToTakeImageEvent;
import org.lsst.sal.camera.event.Rebpower_EmergencyResponseManager_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_RebTotalPower_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_Reb_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_Reb_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_Rebps_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_Rebps_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_Rebps_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_Rebps_PowerConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_Rebps_buildConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo1_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo1_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo1_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo2_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo2_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo2_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo3_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo3_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo3_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo3_PicConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo4_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo4_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo4_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo5_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo5_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo5_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo5_PicConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo6_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo6_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo6_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_CryoCompLimits_CompLimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_PeriodicTasks_PicConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Shutter_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Shutter_timersConfigurationEvent;
import org.lsst.sal.camera.event.SimulationModeEvent;
import org.lsst.sal.camera.event.SoftwareVersionsEvent;
import org.lsst.sal.camera.event.StartIntegrationEvent;
import org.lsst.sal.camera.event.StartLoadFilterEvent;
import org.lsst.sal.camera.event.StartReadoutEvent;
import org.lsst.sal.camera.event.StartRotateCarouselEvent;
import org.lsst.sal.camera.event.StartSetFilterEvent;
import org.lsst.sal.camera.event.StartShutterCloseEvent;
import org.lsst.sal.camera.event.StartShutterOpenEvent;
import org.lsst.sal.camera.event.StartUnloadFilterEvent;
import org.lsst.sal.camera.event.SummaryStatusEvent;
import org.lsst.sal.camera.event.Thermal_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Thermal_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Thermal_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Thermal_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Thermal_PicConfigurationEvent;
import org.lsst.sal.camera.event.Thermal_RefrigConfigurationEvent;
import org.lsst.sal.camera.event.Thermal_ThermalLimitsConfigurationEvent;
import org.lsst.sal.camera.event.Thermal_timersConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_Cip_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CryoFlineGauge_CryoConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CryoFlineGauge_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CryoTurboGauge_CryoConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CryoTurboGauge_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CryoTurboPump_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CryoTurboPump_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CryoVacGauge_CryoConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CryoVacGauge_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_Cryo_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_HX_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_HexFlineGauge_CryoConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_HexFlineGauge_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_HexTurboGauge_CryoConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_HexTurboGauge_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_HexTurboPump_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_HexTurboPump_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_HexVacGauge_CryoConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_HexVacGauge_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_InstVacGauge_CryoConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_InstVacGauge_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_Inst_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_IonPumps_CryoConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_IonPumps_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_Maq20Cryo_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_Maq20Cryo_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_Maq20Ut_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_Maq20Ut_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_PDU_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_PDU_VacuumConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_PumpCart_CryoConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_PumpCart_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_VacPluto_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_VacPluto_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_VacuumConfigurationEvent;

public class EventSendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = SALCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALEvent testSendReceive(SALEvent item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALEvent> future = executor.submit(() -> sal.getNextEvent(Duration.ofSeconds(10L)));
        try {
            sal.logEvent(item);
            SALEvent sALEvent = future.get(10L, TimeUnit.SECONDS);
            return sALEvent;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveEndReadoutEvent() throws Exception {
        String additionalKeys = "";
        String additionalValues = "k";
        int imagesInSequence = 321;
        String imageName = "fmnwkoekwxqcrkmftcfu";
        int imageIndex = 43;
        String imageSource = "l";
        String imageController = "j";
        String imageDate = "vjxwjbmw";
        int imageNumber = 313;
        double timestampAcquisitionStart = 0.536258f;
        double requestedExposureTime = 0.13944172859191895;
        double timestampEndOfReadout = 0.9737498164176941;
        SALEvent item = this.testSendReceive((SALEvent)new EndReadoutEvent(additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, requestedExposureTime, timestampEndOfReadout));
        Assert.assertTrue((boolean)(item instanceof EndReadoutEvent));
        EndReadoutEvent item_ = (EndReadoutEvent)item;
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)requestedExposureTime, (double)item_.getRequestedExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampEndOfReadout, (double)item_.getTimestampEndOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndTakeImageEvent() throws Exception {
        double timestampTransition = 0.5741432905197144;
        SALEvent item = this.testSendReceive((SALEvent)new EndTakeImageEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndTakeImageEvent));
        EndTakeImageEvent item_ = (EndTakeImageEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartSetFilterEvent() throws Exception {
        String filterName = "";
        String filterType = "";
        SALEvent item = this.testSendReceive((SALEvent)new StartSetFilterEvent(filterName, filterType));
        Assert.assertTrue((boolean)(item instanceof StartSetFilterEvent));
        StartSetFilterEvent item_ = (StartSetFilterEvent)item;
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)filterType, (Object)item_.getFilterType());
    }

    @Test
    public void sendReceiveStartUnloadFilterEvent() throws Exception {
        double timestampTransition = 0.05296283960342407;
        SALEvent item = this.testSendReceive((SALEvent)new StartUnloadFilterEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartUnloadFilterEvent));
        StartUnloadFilterEvent item_ = (StartUnloadFilterEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveNotReadyToTakeImageEvent() throws Exception {
        double timestampTransition = 0.07489949464797974;
        SALEvent item = this.testSendReceive((SALEvent)new NotReadyToTakeImageEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof NotReadyToTakeImageEvent));
        NotReadyToTakeImageEvent item_ = (NotReadyToTakeImageEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartShutterCloseEvent() throws Exception {
        double timestampTransition = 0.7162687182426453;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterCloseEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartShutterCloseEvent));
        StartShutterCloseEvent item_ = (StartShutterCloseEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndInitializeGuiderEvent() throws Exception {
        double timestampTransition = 0.9309825897216797;
        SALEvent item = this.testSendReceive((SALEvent)new EndInitializeGuiderEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndInitializeGuiderEvent));
        EndInitializeGuiderEvent item_ = (EndInitializeGuiderEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndShutterCloseEvent() throws Exception {
        double timestampTransition = 0.4938884377479553;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterCloseEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndShutterCloseEvent));
        EndShutterCloseEvent item_ = (EndShutterCloseEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndOfImageTelemetryEvent() throws Exception {
        String additionalKeys = "";
        String additionalValues = "p";
        int imagesInSequence = 934;
        String imageName = "jekwkiqze";
        int imageIndex = 114;
        String imageSource = "s";
        String imageController = "v";
        String imageDate = "";
        int imageNumber = 963;
        double timestampAcquisitionStart = 0.1568049192428589;
        double exposureTime = 0.8497532606124878;
        String imageTag = "nlkeqghnfuzovpreprkfuytkjuyhyzwirzilycbyllrzadpaeuerhlvukfvlofe";
        double timestampDateObs = 0.9596447348594666;
        double timestampDateEnd = 0.6999391317367554;
        double measuredShutterOpenTime = 0.13643884658813477;
        double darkTime = 0.5855968594551086;
        String emulatedImage = "p";
        SALEvent item = this.testSendReceive((SALEvent)new EndOfImageTelemetryEvent(additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime, imageTag, timestampDateObs, timestampDateEnd, measuredShutterOpenTime, darkTime, emulatedImage));
        Assert.assertTrue((boolean)(item instanceof EndOfImageTelemetryEvent));
        EndOfImageTelemetryEvent item_ = (EndOfImageTelemetryEvent)item;
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)imageTag, (Object)item_.getImageTag());
        Assert.assertEquals((double)timestampDateObs, (double)item_.getTimestampDateObs(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampDateEnd, (double)item_.getTimestampDateEnd(), (double)1.0E-6f);
        Assert.assertEquals((double)measuredShutterOpenTime, (double)item_.getMeasuredShutterOpenTime(), (double)1.0E-6f);
        Assert.assertEquals((double)darkTime, (double)item_.getDarkTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)emulatedImage, (Object)item_.getEmulatedImage());
    }

    @Test
    public void sendReceiveEndUnloadFilterEvent() throws Exception {
        double timestampTransition = 0.29523491859436035;
        SALEvent item = this.testSendReceive((SALEvent)new EndUnloadFilterEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndUnloadFilterEvent));
        EndUnloadFilterEvent item_ = (EndUnloadFilterEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndRotateCarouselEvent() throws Exception {
        double timestampTransition = 0.6173826456069946;
        SALEvent item = this.testSendReceive((SALEvent)new EndRotateCarouselEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndRotateCarouselEvent));
        EndRotateCarouselEvent item_ = (EndRotateCarouselEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartLoadFilterEvent() throws Exception {
        double timestampTransition = 0.4313352704048157;
        SALEvent item = this.testSendReceive((SALEvent)new StartLoadFilterEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartLoadFilterEvent));
        StartLoadFilterEvent item_ = (StartLoadFilterEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveReadyToTakeImageEvent() throws Exception {
        double timestampTransition = 0.5078532695770264;
        SALEvent item = this.testSendReceive((SALEvent)new ReadyToTakeImageEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof ReadyToTakeImageEvent));
        ReadyToTakeImageEvent item_ = (ReadyToTakeImageEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePrepareToTakeImageEvent() throws Exception {
        double timestampTransition = 0.7547609210014343;
        SALEvent item = this.testSendReceive((SALEvent)new PrepareToTakeImageEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof PrepareToTakeImageEvent));
        PrepareToTakeImageEvent item_ = (PrepareToTakeImageEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveCCSConfiguredEvent() throws Exception {
        double timestampTransition = 0.347290575504303;
        SALEvent item = this.testSendReceive((SALEvent)new CCSConfiguredEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof CCSConfiguredEvent));
        CCSConfiguredEvent item_ = (CCSConfiguredEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndLoadFilterEvent() throws Exception {
        double timestampTransition = 0.4391133189201355;
        SALEvent item = this.testSendReceive((SALEvent)new EndLoadFilterEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndLoadFilterEvent));
        EndLoadFilterEvent item_ = (EndLoadFilterEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndShutterOpenEvent() throws Exception {
        double timestampTransition = 0.7533835172653198;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterOpenEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndShutterOpenEvent));
        EndShutterOpenEvent item_ = (EndShutterOpenEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartIntegrationEvent() throws Exception {
        String additionalKeys = "";
        String additionalValues = "";
        int imagesInSequence = 909;
        String imageName = "fbcksxwvwdpuhjtouisg";
        int imageIndex = 303;
        String imageSource = "tr";
        String imageController = "";
        String imageDate = "qnmenq";
        int imageNumber = 686;
        double timestampAcquisitionStart = 0.7154474854469299;
        double exposureTime = 0.22857189178466797;
        String mode = "s";
        double timeout = 0.38384324312210083;
        SALEvent item = this.testSendReceive((SALEvent)new StartIntegrationEvent(additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime, mode, timeout));
        Assert.assertTrue((boolean)(item instanceof StartIntegrationEvent));
        StartIntegrationEvent item_ = (StartIntegrationEvent)item;
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((double)timeout, (double)item_.getTimeout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndInitializeImageEvent() throws Exception {
        double timestampTransition = 0.05203276872634888;
        SALEvent item = this.testSendReceive((SALEvent)new EndInitializeImageEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndInitializeImageEvent));
        EndInitializeImageEvent item_ = (EndInitializeImageEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndSetFilterEvent() throws Exception {
        String filterName = "d";
        String filterType = "e";
        int filterSlot = 495;
        double filterPosition = 0.28800106048583984;
        SALEvent item = this.testSendReceive((SALEvent)new EndSetFilterEvent(filterName, filterType, filterSlot, filterPosition));
        Assert.assertTrue((boolean)(item instanceof EndSetFilterEvent));
        EndSetFilterEvent item_ = (EndSetFilterEvent)item;
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)filterType, (Object)item_.getFilterType());
        Assert.assertEquals((long)filterSlot, (long)item_.getFilterSlot());
        Assert.assertEquals((double)filterPosition, (double)item_.getFilterPosition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartShutterOpenEvent() throws Exception {
        double timestampTransition = 0.22750800848007202;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterOpenEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartShutterOpenEvent));
        StartShutterOpenEvent item_ = (StartShutterOpenEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAvailableFiltersEvent() throws Exception {
        String filterNames = "xirsmhnddyrhmpolaatatguejjmwmfeoaclwuexojmhlpkystpmanwcangdisqfvxuqwqysiafomtyjrzxwfucnamoaezfanauhnnootuhjusprpmldiutxsqcaageunvdyvuwxmpzbhnnlfaodrmazjfkyewrpjmwrtkaigzuaqyzmyymnpodojhymuggilkxlhgpseuuibuyrlojdhzqoveaoljumwx";
        SALEvent item = this.testSendReceive((SALEvent)new AvailableFiltersEvent(filterNames));
        Assert.assertTrue((boolean)(item instanceof AvailableFiltersEvent));
        AvailableFiltersEvent item_ = (AvailableFiltersEvent)item;
        Assert.assertEquals((Object)filterNames, (Object)item_.getFilterNames());
    }

    @Test
    public void sendReceiveStartReadoutEvent() throws Exception {
        String additionalKeys = "u";
        String additionalValues = "";
        int imagesInSequence = 142;
        String imageName = "orfjzvnqofqitxyuovvualrabkzcmdp";
        int imageIndex = 634;
        String imageSource = "rm";
        String imageController = "b";
        String imageDate = "";
        int imageNumber = 935;
        double timestampAcquisitionStart = 0.263749361038208;
        double exposureTime = 0.8565203547477722;
        double timestampStartOfReadout = 0.6208995580673218;
        SALEvent item = this.testSendReceive((SALEvent)new StartReadoutEvent(additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime, timestampStartOfReadout));
        Assert.assertTrue((boolean)(item instanceof StartReadoutEvent));
        StartReadoutEvent item_ = (StartReadoutEvent)item;
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampStartOfReadout, (double)item_.getTimestampStartOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartRotateCarouselEvent() throws Exception {
        double timestampTransition = 0.5267452597618103;
        SALEvent item = this.testSendReceive((SALEvent)new StartRotateCarouselEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartRotateCarouselEvent));
        StartRotateCarouselEvent item_ = (StartRotateCarouselEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveImageReadoutParametersEvent() throws Exception {
        String imageName = "z";
        String ccdLocation = "";
        String raftBay = "a";
        String ccdSlot = "s";
        Object[] ccdType = new ImageReadoutParametersEvent.CcdType[]{ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V};
        int[] overRows = TestHelper.generateIntArray((int)201, (int)540777305);
        int[] overCols = TestHelper.generateIntArray((int)201, (int)861964373);
        int[] readRows = TestHelper.generateIntArray((int)201, (int)1039945894);
        int[] readCols = TestHelper.generateIntArray((int)201, (int)1453464562);
        int[] readCols2 = TestHelper.generateIntArray((int)201, (int)-944841913);
        int[] preCols = TestHelper.generateIntArray((int)201, (int)-1414909128);
        int[] preRows = TestHelper.generateIntArray((int)201, (int)-1656959271);
        int[] postCols = TestHelper.generateIntArray((int)201, (int)-488729533);
        int[] underCols = TestHelper.generateIntArray((int)201, (int)679431821);
        String daqFolder = "b";
        String daqAnnotation = "v";
        SALEvent item = this.testSendReceive((SALEvent)new ImageReadoutParametersEvent(imageName, ccdLocation, raftBay, ccdSlot, (ImageReadoutParametersEvent.CcdType[])ccdType, overRows, overCols, readRows, readCols, readCols2, preCols, preRows, postCols, underCols, daqFolder, daqAnnotation));
        Assert.assertTrue((boolean)(item instanceof ImageReadoutParametersEvent));
        ImageReadoutParametersEvent item_ = (ImageReadoutParametersEvent)item;
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((Object)ccdLocation, (Object)item_.getCcdLocation());
        Assert.assertEquals((Object)raftBay, (Object)item_.getRaftBay());
        Assert.assertEquals((Object)ccdSlot, (Object)item_.getCcdSlot());
        Assert.assertArrayEquals((Object[])ccdType, (Object[])item_.getCcdType());
        Assert.assertArrayEquals((int[])overRows, (int[])item_.getOverRows());
        Assert.assertArrayEquals((int[])overCols, (int[])item_.getOverCols());
        Assert.assertArrayEquals((int[])readRows, (int[])item_.getReadRows());
        Assert.assertArrayEquals((int[])readCols, (int[])item_.getReadCols());
        Assert.assertArrayEquals((int[])readCols2, (int[])item_.getReadCols2());
        Assert.assertArrayEquals((int[])preCols, (int[])item_.getPreCols());
        Assert.assertArrayEquals((int[])preRows, (int[])item_.getPreRows());
        Assert.assertArrayEquals((int[])postCols, (int[])item_.getPostCols());
        Assert.assertArrayEquals((int[])underCols, (int[])item_.getUnderCols());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)daqAnnotation, (Object)item_.getDaqAnnotation());
    }

    @Test
    public void sendReceiveFocalPlaneSummaryInfoEvent() throws Exception {
        String ccdLocation = "q";
        String raftBay = "q";
        String ccdSlot = "w";
        String rebSerialNumber = "w";
        String rebLSSTName = "";
        String ccdLSSTName = "r";
        String raftLSSTName = "y";
        String ccdManSerNum = "z";
        String ccdManufacturer = "b";
        Object[] ccdType = new FocalPlaneSummaryInfoEvent.CcdType[]{FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL};
        double[] ccdTempSetPoint = TestHelper.generateDoubleArray((int)212, (int)997436211);
        String sequencerKey = "k";
        String sequencerChecksum = "";
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneSummaryInfoEvent(ccdLocation, raftBay, ccdSlot, rebSerialNumber, rebLSSTName, ccdLSSTName, raftLSSTName, ccdManSerNum, ccdManufacturer, (FocalPlaneSummaryInfoEvent.CcdType[])ccdType, ccdTempSetPoint, sequencerKey, sequencerChecksum));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneSummaryInfoEvent));
        FocalPlaneSummaryInfoEvent item_ = (FocalPlaneSummaryInfoEvent)item;
        Assert.assertEquals((Object)ccdLocation, (Object)item_.getCcdLocation());
        Assert.assertEquals((Object)raftBay, (Object)item_.getRaftBay());
        Assert.assertEquals((Object)ccdSlot, (Object)item_.getCcdSlot());
        Assert.assertEquals((Object)rebSerialNumber, (Object)item_.getRebSerialNumber());
        Assert.assertEquals((Object)rebLSSTName, (Object)item_.getRebLSSTName());
        Assert.assertEquals((Object)ccdLSSTName, (Object)item_.getCcdLSSTName());
        Assert.assertEquals((Object)raftLSSTName, (Object)item_.getRaftLSSTName());
        Assert.assertEquals((Object)ccdManSerNum, (Object)item_.getCcdManSerNum());
        Assert.assertEquals((Object)ccdManufacturer, (Object)item_.getCcdManufacturer());
        Assert.assertArrayEquals((Object[])ccdType, (Object[])item_.getCcdType());
        Assert.assertArrayEquals((double[])ccdTempSetPoint, (double[])item_.getCcdTempSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((Object)sequencerKey, (Object)item_.getSequencerKey());
        Assert.assertEquals((Object)sequencerChecksum, (Object)item_.getSequencerChecksum());
    }

    @Test
    public void sendReceiveQuadbox_BFR_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_BFR_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFR_DevicesConfigurationEvent));
        Quadbox_BFR_DevicesConfigurationEvent item_ = (Quadbox_BFR_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveQuadbox_BFR_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double clean_5_24V_I_warnHi = 0.14500826597213745;
        double clean_5_24V_I_warnLo = 0.10195744037628174;
        double clean_5_24V_I_limitHi = 0.7472650408744812;
        double clean_5_24V_I_limitLo = 0.7284701466560364;
        double dirty_24V_I_warnHi = 0.5455885529518127;
        double dirty_24V_I_warnLo = 0.8110129237174988;
        double dirty_24V_I_limitHi = 0.19291293621063232;
        double dirty_24V_I_limitLo = 0.7421621084213257;
        double dirty_28V_I_warnHi = 0.09804767370223999;
        double dirty_28V_I_warnLo = 0.4464316964149475;
        double dirty_28V_I_limitHi = 0.3112324f;
        double dirty_28V_I_limitLo = 0.15415281057357788;
        double dirty_48V_I_warnHi = 0.6058251857757568;
        double dirty_48V_I_warnLo = 0.10584050416946411;
        double dirty_48V_I_limitHi = 0.8688523173332214;
        double dirty_48V_I_limitLo = 0.05147433280944824;
        double protection_I_warnHi = 0.7004167437553406;
        double protection_I_warnLo = 0.6102726459503174;
        double protection_I_limitHi = 0.16373854875564575;
        double protection_I_limitLo = 0.2257222f;
        double rebps_0_2_I_warnHi = 0.6810241937637329;
        double rebps_0_2_I_warnLo = 0.1661999225616455;
        double rebps_0_2_I_limitHi = 0.9088693857192993;
        double rebps_0_2_I_limitLo = 0.11945706605911255;
        double rebps_3_5_I_warnHi = 0.2741441f;
        double rebps_3_5_I_warnLo = 0.766837f;
        double rebps_3_5_I_limitHi = 0.7217692732810974;
        double rebps_3_5_I_limitLo = 0.5272254347801208;
        double rebps_6_8_I_warnHi = 0.7229553461074829;
        double rebps_6_8_I_warnLo = 0.9956062436103821;
        double rebps_6_8_I_limitHi = 0.9965223670005798;
        double rebps_6_8_I_limitLo = 0.14721661806106567;
        double rebps_9_12_I_warnHi = 0.4042872190475464;
        double rebps_9_12_I_warnLo = 0.6199347376823425;
        double rebps_9_12_I_limitHi = 0.746765673160553;
        double rebps_9_12_I_limitLo = 0.9629706144332886;
        double rebps_Spr_I_warnHi = 0.8263643383979797;
        double rebps_Spr_I_warnLo = 0.6142929196357727;
        double rebps_Spr_I_limitHi = 0.6880226731300354;
        double rebps_Spr_I_limitLo = 0.6466214656829834;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_BFR_LimitsConfigurationEvent(version, clean_5_24V_I_warnHi, clean_5_24V_I_warnLo, clean_5_24V_I_limitHi, clean_5_24V_I_limitLo, dirty_24V_I_warnHi, dirty_24V_I_warnLo, dirty_24V_I_limitHi, dirty_24V_I_limitLo, dirty_28V_I_warnHi, dirty_28V_I_warnLo, dirty_28V_I_limitHi, dirty_28V_I_limitLo, dirty_48V_I_warnHi, dirty_48V_I_warnLo, dirty_48V_I_limitHi, dirty_48V_I_limitLo, protection_I_warnHi, protection_I_warnLo, protection_I_limitHi, protection_I_limitLo, rebps_0_2_I_warnHi, rebps_0_2_I_warnLo, rebps_0_2_I_limitHi, rebps_0_2_I_limitLo, rebps_3_5_I_warnHi, rebps_3_5_I_warnLo, rebps_3_5_I_limitHi, rebps_3_5_I_limitLo, rebps_6_8_I_warnHi, rebps_6_8_I_warnLo, rebps_6_8_I_limitHi, rebps_6_8_I_limitLo, rebps_9_12_I_warnHi, rebps_9_12_I_warnLo, rebps_9_12_I_limitHi, rebps_9_12_I_limitLo, rebps_Spr_I_warnHi, rebps_Spr_I_warnLo, rebps_Spr_I_limitHi, rebps_Spr_I_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFR_LimitsConfigurationEvent));
        Quadbox_BFR_LimitsConfigurationEvent item_ = (Quadbox_BFR_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)clean_5_24V_I_warnHi, (double)item_.getClean_5_24V_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)clean_5_24V_I_warnLo, (double)item_.getClean_5_24V_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)clean_5_24V_I_limitHi, (double)item_.getClean_5_24V_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)clean_5_24V_I_limitLo, (double)item_.getClean_5_24V_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I_warnHi, (double)item_.getDirty_24V_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I_warnLo, (double)item_.getDirty_24V_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I_limitHi, (double)item_.getDirty_24V_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I_limitLo, (double)item_.getDirty_24V_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I_warnHi, (double)item_.getDirty_28V_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I_warnLo, (double)item_.getDirty_28V_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I_limitHi, (double)item_.getDirty_28V_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I_limitLo, (double)item_.getDirty_28V_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I_warnHi, (double)item_.getDirty_48V_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I_warnLo, (double)item_.getDirty_48V_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I_limitHi, (double)item_.getDirty_48V_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I_limitLo, (double)item_.getDirty_48V_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I_warnHi, (double)item_.getProtection_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I_warnLo, (double)item_.getProtection_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I_limitHi, (double)item_.getProtection_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I_limitLo, (double)item_.getProtection_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_2_I_warnHi, (double)item_.getRebps_0_2_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_2_I_warnLo, (double)item_.getRebps_0_2_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_2_I_limitHi, (double)item_.getRebps_0_2_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_2_I_limitLo, (double)item_.getRebps_0_2_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_3_5_I_warnHi, (double)item_.getRebps_3_5_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_3_5_I_warnLo, (double)item_.getRebps_3_5_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_3_5_I_limitHi, (double)item_.getRebps_3_5_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_3_5_I_limitLo, (double)item_.getRebps_3_5_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_6_8_I_warnHi, (double)item_.getRebps_6_8_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_6_8_I_warnLo, (double)item_.getRebps_6_8_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_6_8_I_limitHi, (double)item_.getRebps_6_8_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_6_8_I_limitLo, (double)item_.getRebps_6_8_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_9_12_I_warnHi, (double)item_.getRebps_9_12_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_9_12_I_warnLo, (double)item_.getRebps_9_12_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_9_12_I_limitHi, (double)item_.getRebps_9_12_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_9_12_I_limitLo, (double)item_.getRebps_9_12_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_Spr_I_warnHi, (double)item_.getRebps_Spr_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_Spr_I_warnLo, (double)item_.getRebps_Spr_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_Spr_I_limitHi, (double)item_.getRebps_Spr_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_Spr_I_limitLo, (double)item_.getRebps_Spr_I_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_BFR_QuadboxConfigurationEvent() throws Exception {
        String version = "y";
        int node = 206;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_BFR_QuadboxConfigurationEvent(version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFR_QuadboxConfigurationEvent));
        Quadbox_BFR_QuadboxConfigurationEvent item_ = (Quadbox_BFR_QuadboxConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_Maq20_DeviceConfigurationEvent() throws Exception {
        String version = "";
        String node = "q";
        String serials = "";
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_Maq20_DeviceConfigurationEvent(version, node, serials));
        Assert.assertTrue((boolean)(item instanceof Quadbox_Maq20_DeviceConfigurationEvent));
        Quadbox_Maq20_DeviceConfigurationEvent item_ = (Quadbox_Maq20_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)node, (Object)item_.getNode());
        Assert.assertEquals((Object)serials, (Object)item_.getSerials());
    }

    @Test
    public void sendReceiveQuadbox_Maq20_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_Maq20_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Quadbox_Maq20_DevicesConfigurationEvent));
        Quadbox_Maq20_DevicesConfigurationEvent item_ = (Quadbox_Maq20_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VC_DevicesConfigurationEvent() throws Exception {
        String version = "e";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VC_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VC_DevicesConfigurationEvent));
        Quadbox_PDU_24VC_DevicesConfigurationEvent item_ = (Quadbox_PDU_24VC_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VC_LimitsConfigurationEvent() throws Exception {
        String version = "v";
        double board_T_warnHi = 0.17140984535217285;
        double board_T_warnLo = 0.2860983610153198;
        double board_T_limitHi = 0.2018665075302124;
        double board_T_limitLo = 0.8623965978622437;
        double body_Maq20_I_warnHi = 0.2078021764755249;
        double body_Maq20_I_warnLo = 0.027436554431915283;
        double body_Maq20_I_limitHi = 0.3213622570037842;
        double body_Maq20_I_limitLo = 0.8489788770675659;
        double body_Maq20_V_warnHi = 0.17418742179870605;
        double body_Maq20_V_warnLo = 0.08984065055847168;
        double body_Maq20_V_limitHi = 0.4241867661476135;
        double body_Maq20_V_limitLo = 0.9418308734893799;
        double cryo_Maq20_I_warnHi = 0.9684880375862122;
        double cryo_Maq20_I_warnLo = 0.9527187347412109;
        double cryo_Maq20_I_limitHi = 0.18455815315246582;
        double cryo_Maq20_I_limitLo = 0.6065274477005005;
        double cryo_Maq20_V_warnHi = 0.4981291890144348;
        double cryo_Maq20_V_warnLo = 0.8888053894042969;
        double cryo_Maq20_V_limitHi = 0.24716395139694214;
        double cryo_Maq20_V_limitLo = 0.18402493000030518;
        double fes_CarouselC_I_warnHi = 0.9244294762611389;
        double fes_CarouselC_I_warnLo = 0.7530982494354248;
        double fes_CarouselC_I_limitHi = 0.6354634165763855;
        double fes_CarouselC_I_limitLo = 0.11419862508773804;
        double fes_CarouselC_V_warnHi = 0.06763821840286255;
        double fes_CarouselC_V_warnLo = 0.15208107233047485;
        double fes_CarouselC_V_limitHi = 0.502015f;
        double fes_CarouselC_V_limitLo = 0.4687958359718323;
        double fes_ChangerC_I_warnHi = 0.2776569128036499;
        double fes_ChangerC_I_warnLo = 0.8017957806587219;
        double fes_ChangerC_I_limitHi = 0.646397590637207;
        double fes_ChangerC_I_limitLo = 0.11037266254425049;
        double fes_ChangerC_V_warnHi = 0.4113478f;
        double fes_ChangerC_V_warnLo = 0.2250347137451172;
        double fes_ChangerC_V_limitHi = 0.3065752387046814;
        double fes_ChangerC_V_limitLo = 0.4486308693885803;
        double fes_LoaderC_I_warnHi = 0.5043429136276245;
        double fes_LoaderC_I_warnLo = 0.11318850517272949;
        double fes_LoaderC_I_limitHi = 0.511311f;
        double fes_LoaderC_I_limitLo = 0.8501695990562439;
        double fes_LoaderC_V_warnHi = 0.10861527919769287;
        double fes_LoaderC_V_warnLo = 0.13340067863464355;
        double fes_LoaderC_V_limitHi = 0.909978985786438;
        double fes_LoaderC_V_limitLo = 0.632366418838501;
        double fpga_T_warnHi = 0.8650884032249451;
        double fpga_T_warnLo = 0.033549726009368896;
        double fpga_T_limitHi = 0.6954838037490845;
        double fpga_T_limitLo = 0.11287665367126465;
        double gauges_I_warnHi = 0.674673318862915;
        double gauges_I_warnLo = 0.06375402212142944;
        double gauges_I_limitHi = 0.5577300786972046;
        double gauges_I_limitLo = 0.0346936f;
        double gauges_V_warnHi = 0.25591927766799927;
        double gauges_V_warnLo = 0.861728f;
        double gauges_V_limitHi = 0.6790806651115417;
        double gauges_V_limitLo = 0.500071f;
        double int_Valves_I_warnHi = 0.0706256628036499;
        double int_Valves_I_warnLo = 0.5492081046104431;
        double int_Valves_I_limitHi = 0.5675011873245239;
        double int_Valves_I_limitLo = 0.2477231f;
        double int_Valves_V_warnHi = 0.6511227488517761;
        double int_Valves_V_warnLo = 0.25721925497055054;
        double int_Valves_V_limitHi = 0.053745925426483154;
        double int_Valves_V_limitLo = 0.13506555557250977;
        double ion_Pumps_I_warnHi = 0.5684199333190918;
        double ion_Pumps_I_warnLo = 0.1792144775390625;
        double ion_Pumps_I_limitHi = 0.420258f;
        double ion_Pumps_I_limitLo = 0.24494272470474243;
        double ion_Pumps_V_warnHi = 0.3861231803894043;
        double ion_Pumps_V_warnLo = 0.47374796867370605;
        double ion_Pumps_V_limitHi = 0.32380956411361694;
        double ion_Pumps_V_limitLo = 0.34402942657470703;
        double main_I_warnHi = 0.40112733840942383;
        double main_I_warnLo = 0.4736320972442627;
        double main_I_limitHi = 0.6918114423751831;
        double main_I_limitLo = 0.963251531124115;
        double main_T_warnHi = 0.18191653490066528;
        double main_T_warnLo = 0.16838771104812622;
        double main_T_limitHi = 0.9623038172721863;
        double main_T_limitLo = 0.15011334419250488;
        double main_V_warnHi = 0.48530107736587524;
        double main_V_warnLo = 0.4137721657752991;
        double main_V_limitHi = 0.0766598f;
        double main_V_limitLo = 0.7253578305244446;
        double shtr_PLC1_I_warnHi = 0.1221545934677124;
        double shtr_PLC1_I_warnLo = 0.779416024684906;
        double shtr_PLC1_I_limitHi = 0.2768756151199341;
        double shtr_PLC1_I_limitLo = 0.4441349506378174;
        double shtr_PLC1_V_warnHi = 0.5148841738700867;
        double shtr_PLC1_V_warnLo = 0.00691455602645874;
        double shtr_PLC1_V_limitHi = 0.5889905095100403;
        double shtr_PLC1_V_limitLo = 0.862678587436676;
        double shtr_PLC2_I_warnHi = 0.759788f;
        double shtr_PLC2_I_warnLo = 0.24051225185394287;
        double shtr_PLC2_I_limitHi = 0.5518115162849426;
        double shtr_PLC2_I_limitLo = 0.5088573098182678;
        double shtr_PLC2_V_warnHi = 0.8950796723365784;
        double shtr_PLC2_V_warnLo = 0.17582905292510986;
        double shtr_PLC2_V_limitHi = 0.26496803760528564;
        double shtr_PLC2_V_limitLo = 0.4779793620109558;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VC_LimitsConfigurationEvent(version, board_T_warnHi, board_T_warnLo, board_T_limitHi, board_T_limitLo, body_Maq20_I_warnHi, body_Maq20_I_warnLo, body_Maq20_I_limitHi, body_Maq20_I_limitLo, body_Maq20_V_warnHi, body_Maq20_V_warnLo, body_Maq20_V_limitHi, body_Maq20_V_limitLo, cryo_Maq20_I_warnHi, cryo_Maq20_I_warnLo, cryo_Maq20_I_limitHi, cryo_Maq20_I_limitLo, cryo_Maq20_V_warnHi, cryo_Maq20_V_warnLo, cryo_Maq20_V_limitHi, cryo_Maq20_V_limitLo, fes_CarouselC_I_warnHi, fes_CarouselC_I_warnLo, fes_CarouselC_I_limitHi, fes_CarouselC_I_limitLo, fes_CarouselC_V_warnHi, fes_CarouselC_V_warnLo, fes_CarouselC_V_limitHi, fes_CarouselC_V_limitLo, fes_ChangerC_I_warnHi, fes_ChangerC_I_warnLo, fes_ChangerC_I_limitHi, fes_ChangerC_I_limitLo, fes_ChangerC_V_warnHi, fes_ChangerC_V_warnLo, fes_ChangerC_V_limitHi, fes_ChangerC_V_limitLo, fes_LoaderC_I_warnHi, fes_LoaderC_I_warnLo, fes_LoaderC_I_limitHi, fes_LoaderC_I_limitLo, fes_LoaderC_V_warnHi, fes_LoaderC_V_warnLo, fes_LoaderC_V_limitHi, fes_LoaderC_V_limitLo, fpga_T_warnHi, fpga_T_warnLo, fpga_T_limitHi, fpga_T_limitLo, gauges_I_warnHi, gauges_I_warnLo, gauges_I_limitHi, gauges_I_limitLo, gauges_V_warnHi, gauges_V_warnLo, gauges_V_limitHi, gauges_V_limitLo, int_Valves_I_warnHi, int_Valves_I_warnLo, int_Valves_I_limitHi, int_Valves_I_limitLo, int_Valves_V_warnHi, int_Valves_V_warnLo, int_Valves_V_limitHi, int_Valves_V_limitLo, ion_Pumps_I_warnHi, ion_Pumps_I_warnLo, ion_Pumps_I_limitHi, ion_Pumps_I_limitLo, ion_Pumps_V_warnHi, ion_Pumps_V_warnLo, ion_Pumps_V_limitHi, ion_Pumps_V_limitLo, main_I_warnHi, main_I_warnLo, main_I_limitHi, main_I_limitLo, main_T_warnHi, main_T_warnLo, main_T_limitHi, main_T_limitLo, main_V_warnHi, main_V_warnLo, main_V_limitHi, main_V_limitLo, shtr_PLC1_I_warnHi, shtr_PLC1_I_warnLo, shtr_PLC1_I_limitHi, shtr_PLC1_I_limitLo, shtr_PLC1_V_warnHi, shtr_PLC1_V_warnLo, shtr_PLC1_V_limitHi, shtr_PLC1_V_limitLo, shtr_PLC2_I_warnHi, shtr_PLC2_I_warnLo, shtr_PLC2_I_limitHi, shtr_PLC2_I_limitLo, shtr_PLC2_V_warnHi, shtr_PLC2_V_warnLo, shtr_PLC2_V_limitHi, shtr_PLC2_V_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VC_LimitsConfigurationEvent));
        Quadbox_PDU_24VC_LimitsConfigurationEvent item_ = (Quadbox_PDU_24VC_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)board_T_warnHi, (double)item_.getBoard_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_warnLo, (double)item_.getBoard_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_limitHi, (double)item_.getBoard_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_limitLo, (double)item_.getBoard_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Maq20_I_warnHi, (double)item_.getBody_Maq20_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Maq20_I_warnLo, (double)item_.getBody_Maq20_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Maq20_I_limitHi, (double)item_.getBody_Maq20_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Maq20_I_limitLo, (double)item_.getBody_Maq20_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Maq20_V_warnHi, (double)item_.getBody_Maq20_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Maq20_V_warnLo, (double)item_.getBody_Maq20_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Maq20_V_limitHi, (double)item_.getBody_Maq20_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Maq20_V_limitLo, (double)item_.getBody_Maq20_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Maq20_I_warnHi, (double)item_.getCryo_Maq20_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Maq20_I_warnLo, (double)item_.getCryo_Maq20_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Maq20_I_limitHi, (double)item_.getCryo_Maq20_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Maq20_I_limitLo, (double)item_.getCryo_Maq20_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Maq20_V_warnHi, (double)item_.getCryo_Maq20_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Maq20_V_warnLo, (double)item_.getCryo_Maq20_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Maq20_V_limitHi, (double)item_.getCryo_Maq20_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Maq20_V_limitLo, (double)item_.getCryo_Maq20_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselC_I_warnHi, (double)item_.getFes_CarouselC_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselC_I_warnLo, (double)item_.getFes_CarouselC_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselC_I_limitHi, (double)item_.getFes_CarouselC_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselC_I_limitLo, (double)item_.getFes_CarouselC_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselC_V_warnHi, (double)item_.getFes_CarouselC_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselC_V_warnLo, (double)item_.getFes_CarouselC_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselC_V_limitHi, (double)item_.getFes_CarouselC_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselC_V_limitLo, (double)item_.getFes_CarouselC_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerC_I_warnHi, (double)item_.getFes_ChangerC_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerC_I_warnLo, (double)item_.getFes_ChangerC_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerC_I_limitHi, (double)item_.getFes_ChangerC_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerC_I_limitLo, (double)item_.getFes_ChangerC_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerC_V_warnHi, (double)item_.getFes_ChangerC_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerC_V_warnLo, (double)item_.getFes_ChangerC_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerC_V_limitHi, (double)item_.getFes_ChangerC_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerC_V_limitLo, (double)item_.getFes_ChangerC_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderC_I_warnHi, (double)item_.getFes_LoaderC_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderC_I_warnLo, (double)item_.getFes_LoaderC_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderC_I_limitHi, (double)item_.getFes_LoaderC_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderC_I_limitLo, (double)item_.getFes_LoaderC_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderC_V_warnHi, (double)item_.getFes_LoaderC_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderC_V_warnLo, (double)item_.getFes_LoaderC_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderC_V_limitHi, (double)item_.getFes_LoaderC_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderC_V_limitLo, (double)item_.getFes_LoaderC_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_warnHi, (double)item_.getFpga_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_warnLo, (double)item_.getFpga_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_limitHi, (double)item_.getFpga_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_limitLo, (double)item_.getFpga_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I_warnHi, (double)item_.getGauges_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I_warnLo, (double)item_.getGauges_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I_limitHi, (double)item_.getGauges_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I_limitLo, (double)item_.getGauges_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V_warnHi, (double)item_.getGauges_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V_warnLo, (double)item_.getGauges_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V_limitHi, (double)item_.getGauges_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V_limitLo, (double)item_.getGauges_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)int_Valves_I_warnHi, (double)item_.getInt_Valves_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)int_Valves_I_warnLo, (double)item_.getInt_Valves_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)int_Valves_I_limitHi, (double)item_.getInt_Valves_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)int_Valves_I_limitLo, (double)item_.getInt_Valves_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)int_Valves_V_warnHi, (double)item_.getInt_Valves_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)int_Valves_V_warnLo, (double)item_.getInt_Valves_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)int_Valves_V_limitHi, (double)item_.getInt_Valves_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)int_Valves_V_limitLo, (double)item_.getInt_Valves_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I_warnHi, (double)item_.getIon_Pumps_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I_warnLo, (double)item_.getIon_Pumps_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I_limitHi, (double)item_.getIon_Pumps_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I_limitLo, (double)item_.getIon_Pumps_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V_warnHi, (double)item_.getIon_Pumps_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V_warnLo, (double)item_.getIon_Pumps_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V_limitHi, (double)item_.getIon_Pumps_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V_limitLo, (double)item_.getIon_Pumps_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_warnHi, (double)item_.getMain_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_warnLo, (double)item_.getMain_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_limitHi, (double)item_.getMain_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_limitLo, (double)item_.getMain_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_warnHi, (double)item_.getMain_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_warnLo, (double)item_.getMain_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_limitHi, (double)item_.getMain_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_limitLo, (double)item_.getMain_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_warnHi, (double)item_.getMain_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_warnLo, (double)item_.getMain_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_limitHi, (double)item_.getMain_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_limitLo, (double)item_.getMain_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC1_I_warnHi, (double)item_.getShtr_PLC1_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC1_I_warnLo, (double)item_.getShtr_PLC1_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC1_I_limitHi, (double)item_.getShtr_PLC1_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC1_I_limitLo, (double)item_.getShtr_PLC1_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC1_V_warnHi, (double)item_.getShtr_PLC1_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC1_V_warnLo, (double)item_.getShtr_PLC1_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC1_V_limitHi, (double)item_.getShtr_PLC1_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC1_V_limitLo, (double)item_.getShtr_PLC1_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC2_I_warnHi, (double)item_.getShtr_PLC2_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC2_I_warnLo, (double)item_.getShtr_PLC2_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC2_I_limitHi, (double)item_.getShtr_PLC2_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC2_I_limitLo, (double)item_.getShtr_PLC2_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC2_V_warnHi, (double)item_.getShtr_PLC2_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC2_V_warnLo, (double)item_.getShtr_PLC2_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC2_V_limitHi, (double)item_.getShtr_PLC2_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_PLC2_V_limitLo, (double)item_.getShtr_PLC2_V_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VC_QuadboxConfigurationEvent() throws Exception {
        String version = "";
        int node = 330;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VC_QuadboxConfigurationEvent(version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VC_QuadboxConfigurationEvent));
        Quadbox_PDU_24VC_QuadboxConfigurationEvent item_ = (Quadbox_PDU_24VC_QuadboxConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VD_DevicesConfigurationEvent() throws Exception {
        String version = "o";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VD_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VD_DevicesConfigurationEvent));
        Quadbox_PDU_24VD_DevicesConfigurationEvent item_ = (Quadbox_PDU_24VD_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VD_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double board_T_warnHi = 0.3359434f;
        double board_T_warnLo = 0.147347092628479;
        double board_T_limitHi = 0.9024807214736938;
        double board_T_limitLo = 0.9873150587081909;
        double cryo_Turbo_I_warnHi = 0.7804882526397705;
        double cryo_Turbo_I_warnLo = 0.21205365657806396;
        double cryo_Turbo_I_limitHi = 0.19770705699920654;
        double cryo_Turbo_I_limitLo = 0.0017998814582824707;
        double cryo_Turbo_V_warnHi = 0.893978476524353;
        double cryo_Turbo_V_warnLo = 0.5026865005493164;
        double cryo_Turbo_V_limitHi = 0.2176659107208252;
        double cryo_Turbo_V_limitLo = 0.6090694069862366;
        double fes_Brakes_I_warnHi = 0.9734766483306885;
        double fes_Brakes_I_warnLo = 0.8928537964820862;
        double fes_Brakes_I_limitHi = 0.0497211217880249;
        double fes_Brakes_I_limitLo = 0.2681116461753845;
        double fes_Brakes_V_warnHi = 0.529084324836731;
        double fes_Brakes_V_warnLo = 0.05878615379333496;
        double fes_Brakes_V_limitHi = 0.5883772969245911;
        double fes_Brakes_V_limitLo = 0.6124424338340759;
        double fes_ChangerD_I_warnHi = 0.928119f;
        double fes_ChangerD_I_warnLo = 0.25203055143356323;
        double fes_ChangerD_I_limitHi = 0.23448187112808228;
        double fes_ChangerD_I_limitLo = 0.06101113557815552;
        double fes_ChangerD_V_warnHi = 0.2818338871002197;
        double fes_ChangerD_V_warnLo = 0.35309863090515137;
        double fes_ChangerD_V_limitHi = 0.937881f;
        double fes_ChangerD_V_limitLo = 0.7643618583679199;
        double fes_Clamps_I_warnHi = 0.35663992166519165;
        double fes_Clamps_I_warnLo = 0.7248210906982422;
        double fes_Clamps_I_limitHi = 0.00886458158493042;
        double fes_Clamps_I_limitLo = 0.8635683059692383;
        double fes_Clamps_V_warnHi = 0.525514f;
        double fes_Clamps_V_warnLo = 0.4517327547073364;
        double fes_Clamps_V_limitHi = 0.9946938753128052;
        double fes_Clamps_V_limitLo = 0.11279827356338501;
        double fes_LoaderD_I_warnHi = 0.8843053579330444;
        double fes_LoaderD_I_warnLo = 0.9963942170143127;
        double fes_LoaderD_I_limitHi = 0.4767602f;
        double fes_LoaderD_I_limitLo = 0.7324386835098267;
        double fes_LoaderD_V_warnHi = 0.0687408447265625;
        double fes_LoaderD_V_warnLo = 0.14175671339035034;
        double fes_LoaderD_V_limitHi = 0.2010408f;
        double fes_LoaderD_V_limitLo = 0.16168522834777832;
        double fpga_T_warnHi = 0.02596902847290039;
        double fpga_T_warnLo = 0.35271936655044556;
        double fpga_T_limitHi = 0.522193193435669;
        double fpga_T_limitLo = 0.05116891860961914;
        double hex_Turbo_I_warnHi = 0.8524715900421143;
        double hex_Turbo_I_warnLo = 0.677761971950531;
        double hex_Turbo_I_limitHi = 0.6856864094734192;
        double hex_Turbo_I_limitLo = 0.15195822715759277;
        double hex_Turbo_V_warnHi = 0.7192482352256775;
        double hex_Turbo_V_warnLo = 0.8364443778991699;
        double hex_Turbo_V_limitHi = 0.161748468875885;
        double hex_Turbo_V_limitLo = 0.6321895122528076;
        double main_I_warnHi = 0.10460102558135986;
        double main_I_warnLo = 0.7797408103942871;
        double main_I_limitHi = 0.7016832828521729;
        double main_I_limitLo = 0.0922970175743103;
        double main_T_warnHi = 0.8619933128356934;
        double main_T_warnLo = 0.3623538017272949;
        double main_T_limitHi = 0.33647865056991577;
        double main_T_limitLo = 0.10063028335571289;
        double main_V_warnHi = 0.710841f;
        double main_V_warnLo = 0.6896804571151733;
        double main_V_limitHi = 0.4579014182090759;
        double main_V_limitLo = 0.2700703740119934;
        double shtr_Brakes_I_warnHi = 0.27534347772598267;
        double shtr_Brakes_I_warnLo = 0.5729556679725647;
        double shtr_Brakes_I_limitHi = 0.8949098587036133;
        double shtr_Brakes_I_limitLo = 0.7206348180770874;
        double shtr_Brakes_V_warnHi = 0.8623384237289429;
        double shtr_Brakes_V_warnLo = 0.4858793616294861;
        double shtr_Brakes_V_limitHi = 0.45777201652526855;
        double shtr_Brakes_V_limitLo = 0.5911467671394348;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VD_LimitsConfigurationEvent(version, board_T_warnHi, board_T_warnLo, board_T_limitHi, board_T_limitLo, cryo_Turbo_I_warnHi, cryo_Turbo_I_warnLo, cryo_Turbo_I_limitHi, cryo_Turbo_I_limitLo, cryo_Turbo_V_warnHi, cryo_Turbo_V_warnLo, cryo_Turbo_V_limitHi, cryo_Turbo_V_limitLo, fes_Brakes_I_warnHi, fes_Brakes_I_warnLo, fes_Brakes_I_limitHi, fes_Brakes_I_limitLo, fes_Brakes_V_warnHi, fes_Brakes_V_warnLo, fes_Brakes_V_limitHi, fes_Brakes_V_limitLo, fes_ChangerD_I_warnHi, fes_ChangerD_I_warnLo, fes_ChangerD_I_limitHi, fes_ChangerD_I_limitLo, fes_ChangerD_V_warnHi, fes_ChangerD_V_warnLo, fes_ChangerD_V_limitHi, fes_ChangerD_V_limitLo, fes_Clamps_I_warnHi, fes_Clamps_I_warnLo, fes_Clamps_I_limitHi, fes_Clamps_I_limitLo, fes_Clamps_V_warnHi, fes_Clamps_V_warnLo, fes_Clamps_V_limitHi, fes_Clamps_V_limitLo, fes_LoaderD_I_warnHi, fes_LoaderD_I_warnLo, fes_LoaderD_I_limitHi, fes_LoaderD_I_limitLo, fes_LoaderD_V_warnHi, fes_LoaderD_V_warnLo, fes_LoaderD_V_limitHi, fes_LoaderD_V_limitLo, fpga_T_warnHi, fpga_T_warnLo, fpga_T_limitHi, fpga_T_limitLo, hex_Turbo_I_warnHi, hex_Turbo_I_warnLo, hex_Turbo_I_limitHi, hex_Turbo_I_limitLo, hex_Turbo_V_warnHi, hex_Turbo_V_warnLo, hex_Turbo_V_limitHi, hex_Turbo_V_limitLo, main_I_warnHi, main_I_warnLo, main_I_limitHi, main_I_limitLo, main_T_warnHi, main_T_warnLo, main_T_limitHi, main_T_limitLo, main_V_warnHi, main_V_warnLo, main_V_limitHi, main_V_limitLo, shtr_Brakes_I_warnHi, shtr_Brakes_I_warnLo, shtr_Brakes_I_limitHi, shtr_Brakes_I_limitLo, shtr_Brakes_V_warnHi, shtr_Brakes_V_warnLo, shtr_Brakes_V_limitHi, shtr_Brakes_V_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VD_LimitsConfigurationEvent));
        Quadbox_PDU_24VD_LimitsConfigurationEvent item_ = (Quadbox_PDU_24VD_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)board_T_warnHi, (double)item_.getBoard_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_warnLo, (double)item_.getBoard_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_limitHi, (double)item_.getBoard_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_limitLo, (double)item_.getBoard_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I_warnHi, (double)item_.getCryo_Turbo_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I_warnLo, (double)item_.getCryo_Turbo_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I_limitHi, (double)item_.getCryo_Turbo_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I_limitLo, (double)item_.getCryo_Turbo_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V_warnHi, (double)item_.getCryo_Turbo_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V_warnLo, (double)item_.getCryo_Turbo_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V_limitHi, (double)item_.getCryo_Turbo_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V_limitLo, (double)item_.getCryo_Turbo_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Brakes_I_warnHi, (double)item_.getFes_Brakes_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Brakes_I_warnLo, (double)item_.getFes_Brakes_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Brakes_I_limitHi, (double)item_.getFes_Brakes_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Brakes_I_limitLo, (double)item_.getFes_Brakes_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Brakes_V_warnHi, (double)item_.getFes_Brakes_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Brakes_V_warnLo, (double)item_.getFes_Brakes_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Brakes_V_limitHi, (double)item_.getFes_Brakes_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Brakes_V_limitLo, (double)item_.getFes_Brakes_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerD_I_warnHi, (double)item_.getFes_ChangerD_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerD_I_warnLo, (double)item_.getFes_ChangerD_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerD_I_limitHi, (double)item_.getFes_ChangerD_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerD_I_limitLo, (double)item_.getFes_ChangerD_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerD_V_warnHi, (double)item_.getFes_ChangerD_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerD_V_warnLo, (double)item_.getFes_ChangerD_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerD_V_limitHi, (double)item_.getFes_ChangerD_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_ChangerD_V_limitLo, (double)item_.getFes_ChangerD_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Clamps_I_warnHi, (double)item_.getFes_Clamps_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Clamps_I_warnLo, (double)item_.getFes_Clamps_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Clamps_I_limitHi, (double)item_.getFes_Clamps_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Clamps_I_limitLo, (double)item_.getFes_Clamps_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Clamps_V_warnHi, (double)item_.getFes_Clamps_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Clamps_V_warnLo, (double)item_.getFes_Clamps_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Clamps_V_limitHi, (double)item_.getFes_Clamps_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Clamps_V_limitLo, (double)item_.getFes_Clamps_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderD_I_warnHi, (double)item_.getFes_LoaderD_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderD_I_warnLo, (double)item_.getFes_LoaderD_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderD_I_limitHi, (double)item_.getFes_LoaderD_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderD_I_limitLo, (double)item_.getFes_LoaderD_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderD_V_warnHi, (double)item_.getFes_LoaderD_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderD_V_warnLo, (double)item_.getFes_LoaderD_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderD_V_limitHi, (double)item_.getFes_LoaderD_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_LoaderD_V_limitLo, (double)item_.getFes_LoaderD_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_warnHi, (double)item_.getFpga_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_warnLo, (double)item_.getFpga_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_limitHi, (double)item_.getFpga_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_limitLo, (double)item_.getFpga_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_I_warnHi, (double)item_.getHex_Turbo_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_I_warnLo, (double)item_.getHex_Turbo_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_I_limitHi, (double)item_.getHex_Turbo_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_I_limitLo, (double)item_.getHex_Turbo_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_V_warnHi, (double)item_.getHex_Turbo_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_V_warnLo, (double)item_.getHex_Turbo_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_V_limitHi, (double)item_.getHex_Turbo_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_V_limitLo, (double)item_.getHex_Turbo_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_warnHi, (double)item_.getMain_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_warnLo, (double)item_.getMain_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_limitHi, (double)item_.getMain_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_limitLo, (double)item_.getMain_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_warnHi, (double)item_.getMain_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_warnLo, (double)item_.getMain_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_limitHi, (double)item_.getMain_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_limitLo, (double)item_.getMain_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_warnHi, (double)item_.getMain_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_warnLo, (double)item_.getMain_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_limitHi, (double)item_.getMain_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_limitLo, (double)item_.getMain_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Brakes_I_warnHi, (double)item_.getShtr_Brakes_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Brakes_I_warnLo, (double)item_.getShtr_Brakes_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Brakes_I_limitHi, (double)item_.getShtr_Brakes_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Brakes_I_limitLo, (double)item_.getShtr_Brakes_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Brakes_V_warnHi, (double)item_.getShtr_Brakes_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Brakes_V_warnLo, (double)item_.getShtr_Brakes_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Brakes_V_limitHi, (double)item_.getShtr_Brakes_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Brakes_V_limitLo, (double)item_.getShtr_Brakes_V_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VD_QuadboxConfigurationEvent() throws Exception {
        String version = "";
        int node = 839;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VD_QuadboxConfigurationEvent(version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VD_QuadboxConfigurationEvent));
        Quadbox_PDU_24VD_QuadboxConfigurationEvent item_ = (Quadbox_PDU_24VD_QuadboxConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_PDU_48V_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_48V_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48V_DevicesConfigurationEvent));
        Quadbox_PDU_48V_DevicesConfigurationEvent item_ = (Quadbox_PDU_48V_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveQuadbox_PDU_48V_LimitsConfigurationEvent() throws Exception {
        String version = "g";
        double board_T_warnHi = 0.29950016736984253;
        double board_T_warnLo = 0.24664908647537231;
        double board_T_limitHi = 0.767871618270874;
        double board_T_limitLo = 0.2619808316230774;
        double fes_CarouselD_I_warnHi = 0.48851585388183594;
        double fes_CarouselD_I_warnLo = 0.3681f;
        double fes_CarouselD_I_limitHi = 0.177703857421875;
        double fes_CarouselD_I_limitLo = 0.8507076501846313;
        double fes_CarouselD_V_warnHi = 0.3890703320503235;
        double fes_CarouselD_V_warnLo = 0.8853934407234192;
        double fes_CarouselD_V_limitHi = 0.16424894332885742;
        double fes_CarouselD_V_limitLo = 0.582197368144989;
        double fes_Heater_I_warnHi = 0.5306582450866699;
        double fes_Heater_I_warnLo = 0.2015218734741211;
        double fes_Heater_I_limitHi = 0.5292513370513916;
        double fes_Heater_I_limitLo = 0.5915347337722778;
        double fes_Heater_V_warnHi = 0.17069f;
        double fes_Heater_V_warnLo = 0.6826686859130859;
        double fes_Heater_V_limitHi = 0.6330636143684387;
        double fes_Heater_V_limitLo = 0.49333226680755615;
        double fpga_T_warnHi = 0.05587393045425415;
        double fpga_T_warnLo = 0.5080180764198303;
        double fpga_T_limitHi = 0.3663373f;
        double fpga_T_limitLo = 0.9903306365013123;
        double main_I_warnHi = 0.28888654708862305;
        double main_I_warnLo = 0.43917596340179443;
        double main_I_limitHi = 0.4342119097709656;
        double main_I_limitLo = 0.5887249112129211;
        double main_T_warnHi = 0.47140854597091675;
        double main_T_warnLo = 0.10862231254577637;
        double main_T_limitHi = 0.3732417821884155;
        double main_T_limitLo = 0.376612f;
        double main_V_warnHi = 0.562292f;
        double main_V_warnLo = 0.11836177110671997;
        double main_V_limitHi = 0.11182254552841187;
        double main_V_limitLo = 0.32439786195755005;
        double purge_Fan_I_warnHi = 0.630763053894043;
        double purge_Fan_I_warnLo = 0.2564527988433838;
        double purge_Fan_I_limitHi = 0.018869996070861816;
        double purge_Fan_I_limitLo = 0.5753469467163086;
        double purge_Fan_V_warnHi = 0.7712225317955017;
        double purge_Fan_V_warnLo = 0.03604203462600708;
        double purge_Fan_V_limitHi = 0.3303477168083191;
        double purge_Fan_V_limitLo = 0.5554215312004089;
        double shtr_Motor1_I_warnHi = 0.4535815119743347;
        double shtr_Motor1_I_warnLo = 0.7351964116096497;
        double shtr_Motor1_I_limitHi = 0.49444258213043213;
        double shtr_Motor1_I_limitLo = 0.5544989109039307;
        double shtr_Motor1_V_warnHi = 0.03947758674621582;
        double shtr_Motor1_V_warnLo = 0.2531300187110901;
        double shtr_Motor1_V_limitHi = 0.307384f;
        double shtr_Motor1_V_limitLo = 0.3419477939605713;
        double shtr_Motor2_I_warnHi = 0.8316075205802917;
        double shtr_Motor2_I_warnLo = 0.6268974542617798;
        double shtr_Motor2_I_limitHi = 0.02484762668609619;
        double shtr_Motor2_I_limitLo = 0.7699902057647705;
        double shtr_Motor2_V_warnHi = 0.025355935096740723;
        double shtr_Motor2_V_warnLo = 0.590442f;
        double shtr_Motor2_V_limitHi = 0.808464765548706;
        double shtr_Motor2_V_limitLo = 0.5955008864402771;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_48V_LimitsConfigurationEvent(version, board_T_warnHi, board_T_warnLo, board_T_limitHi, board_T_limitLo, fes_CarouselD_I_warnHi, fes_CarouselD_I_warnLo, fes_CarouselD_I_limitHi, fes_CarouselD_I_limitLo, fes_CarouselD_V_warnHi, fes_CarouselD_V_warnLo, fes_CarouselD_V_limitHi, fes_CarouselD_V_limitLo, fes_Heater_I_warnHi, fes_Heater_I_warnLo, fes_Heater_I_limitHi, fes_Heater_I_limitLo, fes_Heater_V_warnHi, fes_Heater_V_warnLo, fes_Heater_V_limitHi, fes_Heater_V_limitLo, fpga_T_warnHi, fpga_T_warnLo, fpga_T_limitHi, fpga_T_limitLo, main_I_warnHi, main_I_warnLo, main_I_limitHi, main_I_limitLo, main_T_warnHi, main_T_warnLo, main_T_limitHi, main_T_limitLo, main_V_warnHi, main_V_warnLo, main_V_limitHi, main_V_limitLo, purge_Fan_I_warnHi, purge_Fan_I_warnLo, purge_Fan_I_limitHi, purge_Fan_I_limitLo, purge_Fan_V_warnHi, purge_Fan_V_warnLo, purge_Fan_V_limitHi, purge_Fan_V_limitLo, shtr_Motor1_I_warnHi, shtr_Motor1_I_warnLo, shtr_Motor1_I_limitHi, shtr_Motor1_I_limitLo, shtr_Motor1_V_warnHi, shtr_Motor1_V_warnLo, shtr_Motor1_V_limitHi, shtr_Motor1_V_limitLo, shtr_Motor2_I_warnHi, shtr_Motor2_I_warnLo, shtr_Motor2_I_limitHi, shtr_Motor2_I_limitLo, shtr_Motor2_V_warnHi, shtr_Motor2_V_warnLo, shtr_Motor2_V_limitHi, shtr_Motor2_V_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48V_LimitsConfigurationEvent));
        Quadbox_PDU_48V_LimitsConfigurationEvent item_ = (Quadbox_PDU_48V_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)board_T_warnHi, (double)item_.getBoard_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_warnLo, (double)item_.getBoard_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_limitHi, (double)item_.getBoard_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_limitLo, (double)item_.getBoard_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselD_I_warnHi, (double)item_.getFes_CarouselD_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselD_I_warnLo, (double)item_.getFes_CarouselD_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselD_I_limitHi, (double)item_.getFes_CarouselD_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselD_I_limitLo, (double)item_.getFes_CarouselD_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselD_V_warnHi, (double)item_.getFes_CarouselD_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselD_V_warnLo, (double)item_.getFes_CarouselD_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselD_V_limitHi, (double)item_.getFes_CarouselD_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_CarouselD_V_limitLo, (double)item_.getFes_CarouselD_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Heater_I_warnHi, (double)item_.getFes_Heater_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Heater_I_warnLo, (double)item_.getFes_Heater_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Heater_I_limitHi, (double)item_.getFes_Heater_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Heater_I_limitLo, (double)item_.getFes_Heater_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Heater_V_warnHi, (double)item_.getFes_Heater_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Heater_V_warnLo, (double)item_.getFes_Heater_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Heater_V_limitHi, (double)item_.getFes_Heater_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Heater_V_limitLo, (double)item_.getFes_Heater_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_warnHi, (double)item_.getFpga_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_warnLo, (double)item_.getFpga_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_limitHi, (double)item_.getFpga_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_limitLo, (double)item_.getFpga_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_warnHi, (double)item_.getMain_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_warnLo, (double)item_.getMain_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_limitHi, (double)item_.getMain_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_limitLo, (double)item_.getMain_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_warnHi, (double)item_.getMain_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_warnLo, (double)item_.getMain_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_limitHi, (double)item_.getMain_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_limitLo, (double)item_.getMain_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_warnHi, (double)item_.getMain_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_warnLo, (double)item_.getMain_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_limitHi, (double)item_.getMain_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_limitLo, (double)item_.getMain_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_I_warnHi, (double)item_.getPurge_Fan_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_I_warnLo, (double)item_.getPurge_Fan_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_I_limitHi, (double)item_.getPurge_Fan_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_I_limitLo, (double)item_.getPurge_Fan_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_V_warnHi, (double)item_.getPurge_Fan_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_V_warnLo, (double)item_.getPurge_Fan_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_V_limitHi, (double)item_.getPurge_Fan_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_V_limitLo, (double)item_.getPurge_Fan_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor1_I_warnHi, (double)item_.getShtr_Motor1_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor1_I_warnLo, (double)item_.getShtr_Motor1_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor1_I_limitHi, (double)item_.getShtr_Motor1_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor1_I_limitLo, (double)item_.getShtr_Motor1_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor1_V_warnHi, (double)item_.getShtr_Motor1_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor1_V_warnLo, (double)item_.getShtr_Motor1_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor1_V_limitHi, (double)item_.getShtr_Motor1_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor1_V_limitLo, (double)item_.getShtr_Motor1_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor2_I_warnHi, (double)item_.getShtr_Motor2_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor2_I_warnLo, (double)item_.getShtr_Motor2_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor2_I_limitHi, (double)item_.getShtr_Motor2_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor2_I_limitLo, (double)item_.getShtr_Motor2_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor2_V_warnHi, (double)item_.getShtr_Motor2_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor2_V_warnLo, (double)item_.getShtr_Motor2_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor2_V_limitHi, (double)item_.getShtr_Motor2_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)shtr_Motor2_V_limitLo, (double)item_.getShtr_Motor2_V_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_48V_QuadboxConfigurationEvent() throws Exception {
        String version = "";
        int node = 973;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_48V_QuadboxConfigurationEvent(version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48V_QuadboxConfigurationEvent));
        Quadbox_PDU_48V_QuadboxConfigurationEvent item_ = (Quadbox_PDU_48V_QuadboxConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_PDU_5V_DevicesConfigurationEvent() throws Exception {
        String version = "n";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_5V_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5V_DevicesConfigurationEvent));
        Quadbox_PDU_5V_DevicesConfigurationEvent item_ = (Quadbox_PDU_5V_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveQuadbox_PDU_5V_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double otm_0_A_I_warnHi = 0.705195426940918;
        double otm_0_A_I_warnLo = 0.5745881199836731;
        double otm_0_A_I_limitHi = 0.3399214f;
        double otm_0_A_I_limitLo = 0.2192559838294983;
        double otm_0_A_V_warnHi = 0.6262549161911011;
        double otm_0_A_V_warnLo = 0.3666437268257141;
        double otm_0_A_V_limitHi = 0.45988816022872925;
        double otm_0_A_V_limitLo = 0.6296939253807068;
        double otm_0_B_I_warnHi = 0.040489912033081055;
        double otm_0_B_I_warnLo = 0.45842164754867554;
        double otm_0_B_I_limitHi = 0.8041380643844604;
        double otm_0_B_I_limitLo = 0.963213324546814;
        double otm_0_B_V_warnHi = 0.4553758502006531;
        double otm_0_B_V_warnLo = 0.2713279128074646;
        double otm_0_B_V_limitHi = 0.947884738445282;
        double otm_0_B_V_limitLo = 0.0288409f;
        double otm_1_A_I_warnHi = 0.39329564571380615;
        double otm_1_A_I_warnLo = 0.22851771116256714;
        double otm_1_A_I_limitHi = 0.21255344152450562;
        double otm_1_A_I_limitLo = 0.011912405490875244;
        double otm_1_A_V_warnHi = 0.5514242649078369;
        double otm_1_A_V_warnLo = 0.6508852243423462;
        double otm_1_A_V_limitHi = 0.568288266658783;
        double otm_1_A_V_limitLo = 0.637826144695282;
        double otm_1_B_I_warnHi = 0.09007900953292847;
        double otm_1_B_I_warnLo = 0.8701666593551636;
        double otm_1_B_I_limitHi = 0.36637115478515625;
        double otm_1_B_I_limitLo = 0.03323858976364136;
        double otm_1_B_V_warnHi = 0.8563101887702942;
        double otm_1_B_V_warnLo = 0.8666839003562927;
        double otm_1_B_V_limitHi = 0.45781224966049194;
        double otm_1_B_V_limitLo = 0.3513185381889343;
        double otm_2_A_I_warnHi = 0.4714767336845398;
        double otm_2_A_I_warnLo = 0.46924442052841187;
        double otm_2_A_I_limitHi = 0.2972654700279236;
        double otm_2_A_I_limitLo = 0.6357949376106262;
        double otm_2_A_V_warnHi = 0.5301083922386169;
        double otm_2_A_V_warnLo = 0.7822174429893494;
        double otm_2_A_V_limitHi = 0.5979655385017395;
        double otm_2_A_V_limitLo = 0.7027034163475037;
        double otm_2_B_I_warnHi = 0.9898995161056519;
        double otm_2_B_I_warnLo = 0.12456047534942627;
        double otm_2_B_I_limitHi = 0.8187646269798279;
        double otm_2_B_I_limitLo = 0.4652571678161621;
        double otm_2_B_V_warnHi = 0.3246997594833374;
        double otm_2_B_V_warnLo = 0.7379271984100342;
        double otm_2_B_V_limitHi = 0.006887316703796387;
        double otm_2_B_V_limitLo = 0.4530452489852905;
        double otm_3_A_I_warnHi = 0.3875085115432739;
        double otm_3_A_I_warnLo = 0.721917450428009;
        double otm_3_A_I_limitHi = 0.27117353677749634;
        double otm_3_A_I_limitLo = 0.7593408823013306;
        double otm_3_A_V_warnHi = 0.7404987812042236;
        double otm_3_A_V_warnLo = 0.7256408929824829;
        double otm_3_A_V_limitHi = 0.854900598526001;
        double otm_3_A_V_limitLo = 0.157843f;
        double otm_3_B_I_warnHi = 0.583867609500885;
        double otm_3_B_I_warnLo = 0.5232800841331482;
        double otm_3_B_I_limitHi = 0.5524739623069763;
        double otm_3_B_I_limitLo = 0.17146915197372437;
        double otm_3_B_V_warnHi = 0.312854528427124;
        double otm_3_B_V_warnLo = 0.6501095294952393;
        double otm_3_B_V_limitHi = 0.161163330078125;
        double otm_3_B_V_limitLo = 0.8502786159515381;
        double otm_4_A_I_warnHi = 0.1887073516845703;
        double otm_4_A_I_warnLo = 0.21293115615844727;
        double otm_4_A_I_limitHi = 0.07158505916595459;
        double otm_4_A_I_limitLo = 0.4632687568664551;
        double otm_4_A_V_warnHi = 0.9889718294143677;
        double otm_4_A_V_warnLo = 0.019225597381591797;
        double otm_4_A_V_limitHi = 0.7258667349815369;
        double otm_4_A_V_limitLo = 0.16032713651657104;
        double otm_4_B_I_warnHi = 0.747619f;
        double otm_4_B_I_warnLo = 0.5122162699699402;
        double otm_4_B_I_limitHi = 0.9605627059936523;
        double otm_4_B_I_limitLo = 0.487312376499176;
        double otm_4_B_V_warnHi = 0.576705813407898;
        double otm_4_B_V_warnLo = 0.13985759019851685;
        double otm_4_B_V_limitHi = 0.6057502627372742;
        double otm_4_B_V_limitLo = 0.9010071754455566;
        double otm_5_A_I_warnHi = 0.9271302223205566;
        double otm_5_A_I_warnLo = 0.7254574298858643;
        double otm_5_A_I_limitHi = 0.7387614846229553;
        double otm_5_A_I_limitLo = 0.7340636253356934;
        double otm_5_A_V_warnHi = 0.6733422875404358;
        double otm_5_A_V_warnLo = 0.912837028503418;
        double otm_5_A_V_limitHi = 0.7502734661102295;
        double otm_5_A_V_limitLo = 0.3962177038192749;
        double otm_5_B_I_warnHi = 0.8504967093467712;
        double otm_5_B_I_warnLo = 0.6118409037590027;
        double otm_5_B_I_limitHi = 0.6346777081489563;
        double otm_5_B_I_limitLo = 0.6007689237594604;
        double otm_5_B_V_warnHi = 0.3154820203781128;
        double otm_5_B_V_warnLo = 0.6184857487678528;
        double otm_5_B_V_limitHi = 0.3816053867340088;
        double otm_5_B_V_limitLo = 0.5990188121795654;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_5V_LimitsConfigurationEvent(version, otm_0_A_I_warnHi, otm_0_A_I_warnLo, otm_0_A_I_limitHi, otm_0_A_I_limitLo, otm_0_A_V_warnHi, otm_0_A_V_warnLo, otm_0_A_V_limitHi, otm_0_A_V_limitLo, otm_0_B_I_warnHi, otm_0_B_I_warnLo, otm_0_B_I_limitHi, otm_0_B_I_limitLo, otm_0_B_V_warnHi, otm_0_B_V_warnLo, otm_0_B_V_limitHi, otm_0_B_V_limitLo, otm_1_A_I_warnHi, otm_1_A_I_warnLo, otm_1_A_I_limitHi, otm_1_A_I_limitLo, otm_1_A_V_warnHi, otm_1_A_V_warnLo, otm_1_A_V_limitHi, otm_1_A_V_limitLo, otm_1_B_I_warnHi, otm_1_B_I_warnLo, otm_1_B_I_limitHi, otm_1_B_I_limitLo, otm_1_B_V_warnHi, otm_1_B_V_warnLo, otm_1_B_V_limitHi, otm_1_B_V_limitLo, otm_2_A_I_warnHi, otm_2_A_I_warnLo, otm_2_A_I_limitHi, otm_2_A_I_limitLo, otm_2_A_V_warnHi, otm_2_A_V_warnLo, otm_2_A_V_limitHi, otm_2_A_V_limitLo, otm_2_B_I_warnHi, otm_2_B_I_warnLo, otm_2_B_I_limitHi, otm_2_B_I_limitLo, otm_2_B_V_warnHi, otm_2_B_V_warnLo, otm_2_B_V_limitHi, otm_2_B_V_limitLo, otm_3_A_I_warnHi, otm_3_A_I_warnLo, otm_3_A_I_limitHi, otm_3_A_I_limitLo, otm_3_A_V_warnHi, otm_3_A_V_warnLo, otm_3_A_V_limitHi, otm_3_A_V_limitLo, otm_3_B_I_warnHi, otm_3_B_I_warnLo, otm_3_B_I_limitHi, otm_3_B_I_limitLo, otm_3_B_V_warnHi, otm_3_B_V_warnLo, otm_3_B_V_limitHi, otm_3_B_V_limitLo, otm_4_A_I_warnHi, otm_4_A_I_warnLo, otm_4_A_I_limitHi, otm_4_A_I_limitLo, otm_4_A_V_warnHi, otm_4_A_V_warnLo, otm_4_A_V_limitHi, otm_4_A_V_limitLo, otm_4_B_I_warnHi, otm_4_B_I_warnLo, otm_4_B_I_limitHi, otm_4_B_I_limitLo, otm_4_B_V_warnHi, otm_4_B_V_warnLo, otm_4_B_V_limitHi, otm_4_B_V_limitLo, otm_5_A_I_warnHi, otm_5_A_I_warnLo, otm_5_A_I_limitHi, otm_5_A_I_limitLo, otm_5_A_V_warnHi, otm_5_A_V_warnLo, otm_5_A_V_limitHi, otm_5_A_V_limitLo, otm_5_B_I_warnHi, otm_5_B_I_warnLo, otm_5_B_I_limitHi, otm_5_B_I_limitLo, otm_5_B_V_warnHi, otm_5_B_V_warnLo, otm_5_B_V_limitHi, otm_5_B_V_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5V_LimitsConfigurationEvent));
        Quadbox_PDU_5V_LimitsConfigurationEvent item_ = (Quadbox_PDU_5V_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)otm_0_A_I_warnHi, (double)item_.getOtm_0_A_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_I_warnLo, (double)item_.getOtm_0_A_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_I_limitHi, (double)item_.getOtm_0_A_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_I_limitLo, (double)item_.getOtm_0_A_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_V_warnHi, (double)item_.getOtm_0_A_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_V_warnLo, (double)item_.getOtm_0_A_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_V_limitHi, (double)item_.getOtm_0_A_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_V_limitLo, (double)item_.getOtm_0_A_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I_warnHi, (double)item_.getOtm_0_B_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I_warnLo, (double)item_.getOtm_0_B_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I_limitHi, (double)item_.getOtm_0_B_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I_limitLo, (double)item_.getOtm_0_B_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_V_warnHi, (double)item_.getOtm_0_B_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_V_warnLo, (double)item_.getOtm_0_B_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_V_limitHi, (double)item_.getOtm_0_B_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_V_limitLo, (double)item_.getOtm_0_B_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_I_warnHi, (double)item_.getOtm_1_A_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_I_warnLo, (double)item_.getOtm_1_A_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_I_limitHi, (double)item_.getOtm_1_A_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_I_limitLo, (double)item_.getOtm_1_A_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_V_warnHi, (double)item_.getOtm_1_A_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_V_warnLo, (double)item_.getOtm_1_A_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_V_limitHi, (double)item_.getOtm_1_A_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_V_limitLo, (double)item_.getOtm_1_A_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_I_warnHi, (double)item_.getOtm_1_B_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_I_warnLo, (double)item_.getOtm_1_B_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_I_limitHi, (double)item_.getOtm_1_B_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_I_limitLo, (double)item_.getOtm_1_B_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_V_warnHi, (double)item_.getOtm_1_B_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_V_warnLo, (double)item_.getOtm_1_B_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_V_limitHi, (double)item_.getOtm_1_B_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_V_limitLo, (double)item_.getOtm_1_B_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_I_warnHi, (double)item_.getOtm_2_A_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_I_warnLo, (double)item_.getOtm_2_A_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_I_limitHi, (double)item_.getOtm_2_A_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_I_limitLo, (double)item_.getOtm_2_A_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_V_warnHi, (double)item_.getOtm_2_A_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_V_warnLo, (double)item_.getOtm_2_A_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_V_limitHi, (double)item_.getOtm_2_A_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_V_limitLo, (double)item_.getOtm_2_A_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_I_warnHi, (double)item_.getOtm_2_B_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_I_warnLo, (double)item_.getOtm_2_B_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_I_limitHi, (double)item_.getOtm_2_B_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_I_limitLo, (double)item_.getOtm_2_B_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_V_warnHi, (double)item_.getOtm_2_B_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_V_warnLo, (double)item_.getOtm_2_B_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_V_limitHi, (double)item_.getOtm_2_B_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_V_limitLo, (double)item_.getOtm_2_B_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I_warnHi, (double)item_.getOtm_3_A_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I_warnLo, (double)item_.getOtm_3_A_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I_limitHi, (double)item_.getOtm_3_A_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I_limitLo, (double)item_.getOtm_3_A_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V_warnHi, (double)item_.getOtm_3_A_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V_warnLo, (double)item_.getOtm_3_A_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V_limitHi, (double)item_.getOtm_3_A_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V_limitLo, (double)item_.getOtm_3_A_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I_warnHi, (double)item_.getOtm_3_B_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I_warnLo, (double)item_.getOtm_3_B_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I_limitHi, (double)item_.getOtm_3_B_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I_limitLo, (double)item_.getOtm_3_B_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V_warnHi, (double)item_.getOtm_3_B_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V_warnLo, (double)item_.getOtm_3_B_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V_limitHi, (double)item_.getOtm_3_B_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V_limitLo, (double)item_.getOtm_3_B_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_I_warnHi, (double)item_.getOtm_4_A_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_I_warnLo, (double)item_.getOtm_4_A_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_I_limitHi, (double)item_.getOtm_4_A_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_I_limitLo, (double)item_.getOtm_4_A_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_V_warnHi, (double)item_.getOtm_4_A_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_V_warnLo, (double)item_.getOtm_4_A_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_V_limitHi, (double)item_.getOtm_4_A_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_V_limitLo, (double)item_.getOtm_4_A_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_I_warnHi, (double)item_.getOtm_4_B_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_I_warnLo, (double)item_.getOtm_4_B_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_I_limitHi, (double)item_.getOtm_4_B_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_I_limitLo, (double)item_.getOtm_4_B_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_V_warnHi, (double)item_.getOtm_4_B_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_V_warnLo, (double)item_.getOtm_4_B_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_V_limitHi, (double)item_.getOtm_4_B_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_V_limitLo, (double)item_.getOtm_4_B_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_I_warnHi, (double)item_.getOtm_5_A_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_I_warnLo, (double)item_.getOtm_5_A_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_I_limitHi, (double)item_.getOtm_5_A_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_I_limitLo, (double)item_.getOtm_5_A_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_V_warnHi, (double)item_.getOtm_5_A_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_V_warnLo, (double)item_.getOtm_5_A_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_V_limitHi, (double)item_.getOtm_5_A_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_V_limitLo, (double)item_.getOtm_5_A_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_I_warnHi, (double)item_.getOtm_5_B_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_I_warnLo, (double)item_.getOtm_5_B_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_I_limitHi, (double)item_.getOtm_5_B_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_I_limitLo, (double)item_.getOtm_5_B_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_V_warnHi, (double)item_.getOtm_5_B_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_V_warnLo, (double)item_.getOtm_5_B_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_V_limitHi, (double)item_.getOtm_5_B_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_V_limitLo, (double)item_.getOtm_5_B_V_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_5V_QuadboxConfigurationEvent() throws Exception {
        String version = "l";
        int node = 659;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_5V_QuadboxConfigurationEvent(version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5V_QuadboxConfigurationEvent));
        Quadbox_PDU_5V_QuadboxConfigurationEvent item_ = (Quadbox_PDU_5V_QuadboxConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "";
        int schedulers_default_nTasks = 98;
        int schedulers_default_nThreads = 484;
        int schedulers_monitor_check_scheduler_nTasks = 102;
        int schedulers_monitor_check_scheduler_nThreads = 647;
        int schedulers_monitor_update_publish_scheduler_nTasks = 925;
        int schedulers_monitor_update_publish_scheduler_nThreads = 749;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_check_scheduler_nTasks, schedulers_monitor_check_scheduler_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PeriodicTasks_GeneralConfigurationEvent));
        Quadbox_PeriodicTasks_GeneralConfigurationEvent item_ = (Quadbox_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nTasks, (long)item_.getSchedulers_monitor_check_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nThreads, (long)item_.getSchedulers_monitor_check_scheduler_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveQuadbox_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "";
        long agentmonitorservice_taskPeriodMillis = 687L;
        long heartbeat_taskPeriodMillis = 193L;
        long monitor_check_BFR_taskPeriodMillis = 730L;
        long monitor_check_Maq20_taskPeriodMillis = 793L;
        long monitor_check_PDU_24VC_taskPeriodMillis = 168L;
        long monitor_check_PDU_24VD_taskPeriodMillis = 110L;
        long monitor_check_PDU_48V_taskPeriodMillis = 704L;
        long monitor_check_PDU_5V_taskPeriodMillis = 865L;
        long monitor_check_REB_Bulk_PS_taskPeriodMillis = 867L;
        long monitor_publish_BFR_taskPeriodMillis = 607L;
        long monitor_publish_PDU_24VC_taskPeriodMillis = 806L;
        long monitor_publish_PDU_24VD_taskPeriodMillis = 867L;
        long monitor_publish_PDU_48V_taskPeriodMillis = 799L;
        long monitor_publish_PDU_5V_taskPeriodMillis = 531L;
        long monitor_publish_REB_Bulk_PS_taskPeriodMillis = 406L;
        long monitor_update_BFR_taskPeriodMillis = 98L;
        long monitor_update_PDU_24VC_taskPeriodMillis = 586L;
        long monitor_update_PDU_24VD_taskPeriodMillis = 539L;
        long monitor_update_PDU_48V_taskPeriodMillis = 394L;
        long monitor_update_PDU_5V_taskPeriodMillis = 599L;
        long monitor_update_REB_Bulk_PS_taskPeriodMillis = 904L;
        long quadbox_state_taskPeriodMillis = 27L;
        long runtimeinfo_taskPeriodMillis = 219L;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_BFR_taskPeriodMillis, monitor_check_Maq20_taskPeriodMillis, monitor_check_PDU_24VC_taskPeriodMillis, monitor_check_PDU_24VD_taskPeriodMillis, monitor_check_PDU_48V_taskPeriodMillis, monitor_check_PDU_5V_taskPeriodMillis, monitor_check_REB_Bulk_PS_taskPeriodMillis, monitor_publish_BFR_taskPeriodMillis, monitor_publish_PDU_24VC_taskPeriodMillis, monitor_publish_PDU_24VD_taskPeriodMillis, monitor_publish_PDU_48V_taskPeriodMillis, monitor_publish_PDU_5V_taskPeriodMillis, monitor_publish_REB_Bulk_PS_taskPeriodMillis, monitor_update_BFR_taskPeriodMillis, monitor_update_PDU_24VC_taskPeriodMillis, monitor_update_PDU_24VD_taskPeriodMillis, monitor_update_PDU_48V_taskPeriodMillis, monitor_update_PDU_5V_taskPeriodMillis, monitor_update_REB_Bulk_PS_taskPeriodMillis, quadbox_state_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PeriodicTasks_timersConfigurationEvent));
        Quadbox_PeriodicTasks_timersConfigurationEvent item_ = (Quadbox_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_BFR_taskPeriodMillis, (long)item_.getMonitor_check_BFR_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Maq20_taskPeriodMillis, (long)item_.getMonitor_check_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_PDU_24VC_taskPeriodMillis, (long)item_.getMonitor_check_PDU_24VC_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_PDU_24VD_taskPeriodMillis, (long)item_.getMonitor_check_PDU_24VD_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_PDU_48V_taskPeriodMillis, (long)item_.getMonitor_check_PDU_48V_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_PDU_5V_taskPeriodMillis, (long)item_.getMonitor_check_PDU_5V_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_REB_Bulk_PS_taskPeriodMillis, (long)item_.getMonitor_check_REB_Bulk_PS_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_BFR_taskPeriodMillis, (long)item_.getMonitor_publish_BFR_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_PDU_24VC_taskPeriodMillis, (long)item_.getMonitor_publish_PDU_24VC_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_PDU_24VD_taskPeriodMillis, (long)item_.getMonitor_publish_PDU_24VD_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_PDU_48V_taskPeriodMillis, (long)item_.getMonitor_publish_PDU_48V_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_PDU_5V_taskPeriodMillis, (long)item_.getMonitor_publish_PDU_5V_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_REB_Bulk_PS_taskPeriodMillis, (long)item_.getMonitor_publish_REB_Bulk_PS_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_BFR_taskPeriodMillis, (long)item_.getMonitor_update_BFR_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_PDU_24VC_taskPeriodMillis, (long)item_.getMonitor_update_PDU_24VC_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_PDU_24VD_taskPeriodMillis, (long)item_.getMonitor_update_PDU_24VD_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_PDU_48V_taskPeriodMillis, (long)item_.getMonitor_update_PDU_48V_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_PDU_5V_taskPeriodMillis, (long)item_.getMonitor_update_PDU_5V_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_REB_Bulk_PS_taskPeriodMillis, (long)item_.getMonitor_update_REB_Bulk_PS_taskPeriodMillis());
        Assert.assertEquals((long)quadbox_state_taskPeriodMillis, (long)item_.getQuadbox_state_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveQuadbox_REB_Bulk_PS_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_REB_Bulk_PS_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Quadbox_REB_Bulk_PS_DevicesConfigurationEvent));
        Quadbox_REB_Bulk_PS_DevicesConfigurationEvent item_ = (Quadbox_REB_Bulk_PS_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveQuadbox_REB_Bulk_PS_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double rebbulkps_0_2_I_warnHi = 0.1906307339668274;
        double rebbulkps_0_2_I_warnLo = 0.5290064215660095;
        double rebbulkps_0_2_I_limitHi = 0.8240458965301514;
        double rebbulkps_0_2_I_limitLo = 0.6852403879165649;
        double rebbulkps_0_2_T_warnHi = 0.43380147218704224;
        double rebbulkps_0_2_T_warnLo = 0.6640772223472595;
        double rebbulkps_0_2_T_limitHi = 0.5545397996902466;
        double rebbulkps_0_2_T_limitLo = 0.3085957169532776;
        double rebbulkps_0_2_V_warnHi = 0.9116076231002808;
        double rebbulkps_0_2_V_warnLo = 0.2826339602470398;
        double rebbulkps_0_2_V_limitHi = 0.2424364686012268;
        double rebbulkps_0_2_V_limitLo = 0.8993031978607178;
        double rebbulkps_3_5_I_warnHi = 0.389864444732666;
        double rebbulkps_3_5_I_warnLo = 0.87402f;
        double rebbulkps_3_5_I_limitHi = 0.24330562353134155;
        double rebbulkps_3_5_I_limitLo = 0.5271173715591431;
        double rebbulkps_3_5_T_warnHi = 0.8121272325515747;
        double rebbulkps_3_5_T_warnLo = 0.7979332804679871;
        double rebbulkps_3_5_T_limitHi = 0.3415534496307373;
        double rebbulkps_3_5_T_limitLo = 0.3222883939743042;
        double rebbulkps_3_5_V_warnHi = 0.9028640389442444;
        double rebbulkps_3_5_V_warnLo = 0.17943823337554932;
        double rebbulkps_3_5_V_limitHi = 0.6503531336784363;
        double rebbulkps_3_5_V_limitLo = 0.00792855f;
        double rebbulkps_6_8_I_warnHi = 0.03374302387237549;
        double rebbulkps_6_8_I_warnLo = 0.9140632152557373;
        double rebbulkps_6_8_I_limitHi = 0.3034737f;
        double rebbulkps_6_8_I_limitLo = 0.5301044583320618;
        double rebbulkps_6_8_T_warnHi = 0.8447704315185547;
        double rebbulkps_6_8_T_warnLo = 0.5800148248672485;
        double rebbulkps_6_8_T_limitHi = 0.9197233319282532;
        double rebbulkps_6_8_T_limitLo = 0.3724360466003418;
        double rebbulkps_6_8_V_warnHi = 0.7258525490760803;
        double rebbulkps_6_8_V_warnLo = 0.5308462977409363;
        double rebbulkps_6_8_V_limitHi = 0.689347505569458;
        double rebbulkps_6_8_V_limitLo = 0.4999144673347473;
        double rebbulkps_9_12_I_warnHi = 0.15168523788452148;
        double rebbulkps_9_12_I_warnLo = 0.3233150839805603;
        double rebbulkps_9_12_I_limitHi = 0.6739442944526672;
        double rebbulkps_9_12_I_limitLo = 0.8003124594688416;
        double rebbulkps_9_12_T_warnHi = 0.8840603828430176;
        double rebbulkps_9_12_T_warnLo = 0.1999720335006714;
        double rebbulkps_9_12_T_limitHi = 0.3641918897628784;
        double rebbulkps_9_12_T_limitLo = 0.1045953f;
        double rebbulkps_9_12_V_warnHi = 0.586685299873352;
        double rebbulkps_9_12_V_warnLo = 0.07568937540054321;
        double rebbulkps_9_12_V_limitHi = 0.6804636716842651;
        double rebbulkps_9_12_V_limitLo = 0.4218956232070923;
        double rebbulkps_Brd_T_warnHi = 0.5800520777702332;
        double rebbulkps_Brd_T_warnLo = 0.306423f;
        double rebbulkps_Brd_T_limitHi = 0.7984023094177246;
        double rebbulkps_Brd_T_limitLo = 0.549782395362854;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_REB_Bulk_PS_LimitsConfigurationEvent(version, rebbulkps_0_2_I_warnHi, rebbulkps_0_2_I_warnLo, rebbulkps_0_2_I_limitHi, rebbulkps_0_2_I_limitLo, rebbulkps_0_2_T_warnHi, rebbulkps_0_2_T_warnLo, rebbulkps_0_2_T_limitHi, rebbulkps_0_2_T_limitLo, rebbulkps_0_2_V_warnHi, rebbulkps_0_2_V_warnLo, rebbulkps_0_2_V_limitHi, rebbulkps_0_2_V_limitLo, rebbulkps_3_5_I_warnHi, rebbulkps_3_5_I_warnLo, rebbulkps_3_5_I_limitHi, rebbulkps_3_5_I_limitLo, rebbulkps_3_5_T_warnHi, rebbulkps_3_5_T_warnLo, rebbulkps_3_5_T_limitHi, rebbulkps_3_5_T_limitLo, rebbulkps_3_5_V_warnHi, rebbulkps_3_5_V_warnLo, rebbulkps_3_5_V_limitHi, rebbulkps_3_5_V_limitLo, rebbulkps_6_8_I_warnHi, rebbulkps_6_8_I_warnLo, rebbulkps_6_8_I_limitHi, rebbulkps_6_8_I_limitLo, rebbulkps_6_8_T_warnHi, rebbulkps_6_8_T_warnLo, rebbulkps_6_8_T_limitHi, rebbulkps_6_8_T_limitLo, rebbulkps_6_8_V_warnHi, rebbulkps_6_8_V_warnLo, rebbulkps_6_8_V_limitHi, rebbulkps_6_8_V_limitLo, rebbulkps_9_12_I_warnHi, rebbulkps_9_12_I_warnLo, rebbulkps_9_12_I_limitHi, rebbulkps_9_12_I_limitLo, rebbulkps_9_12_T_warnHi, rebbulkps_9_12_T_warnLo, rebbulkps_9_12_T_limitHi, rebbulkps_9_12_T_limitLo, rebbulkps_9_12_V_warnHi, rebbulkps_9_12_V_warnLo, rebbulkps_9_12_V_limitHi, rebbulkps_9_12_V_limitLo, rebbulkps_Brd_T_warnHi, rebbulkps_Brd_T_warnLo, rebbulkps_Brd_T_limitHi, rebbulkps_Brd_T_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_REB_Bulk_PS_LimitsConfigurationEvent));
        Quadbox_REB_Bulk_PS_LimitsConfigurationEvent item_ = (Quadbox_REB_Bulk_PS_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)rebbulkps_0_2_I_warnHi, (double)item_.getRebbulkps_0_2_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_I_warnLo, (double)item_.getRebbulkps_0_2_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_I_limitHi, (double)item_.getRebbulkps_0_2_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_I_limitLo, (double)item_.getRebbulkps_0_2_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_T_warnHi, (double)item_.getRebbulkps_0_2_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_T_warnLo, (double)item_.getRebbulkps_0_2_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_T_limitHi, (double)item_.getRebbulkps_0_2_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_T_limitLo, (double)item_.getRebbulkps_0_2_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_V_warnHi, (double)item_.getRebbulkps_0_2_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_V_warnLo, (double)item_.getRebbulkps_0_2_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_V_limitHi, (double)item_.getRebbulkps_0_2_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_V_limitLo, (double)item_.getRebbulkps_0_2_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_I_warnHi, (double)item_.getRebbulkps_3_5_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_I_warnLo, (double)item_.getRebbulkps_3_5_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_I_limitHi, (double)item_.getRebbulkps_3_5_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_I_limitLo, (double)item_.getRebbulkps_3_5_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_T_warnHi, (double)item_.getRebbulkps_3_5_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_T_warnLo, (double)item_.getRebbulkps_3_5_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_T_limitHi, (double)item_.getRebbulkps_3_5_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_T_limitLo, (double)item_.getRebbulkps_3_5_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_V_warnHi, (double)item_.getRebbulkps_3_5_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_V_warnLo, (double)item_.getRebbulkps_3_5_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_V_limitHi, (double)item_.getRebbulkps_3_5_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_V_limitLo, (double)item_.getRebbulkps_3_5_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_I_warnHi, (double)item_.getRebbulkps_6_8_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_I_warnLo, (double)item_.getRebbulkps_6_8_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_I_limitHi, (double)item_.getRebbulkps_6_8_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_I_limitLo, (double)item_.getRebbulkps_6_8_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_T_warnHi, (double)item_.getRebbulkps_6_8_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_T_warnLo, (double)item_.getRebbulkps_6_8_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_T_limitHi, (double)item_.getRebbulkps_6_8_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_T_limitLo, (double)item_.getRebbulkps_6_8_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_V_warnHi, (double)item_.getRebbulkps_6_8_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_V_warnLo, (double)item_.getRebbulkps_6_8_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_V_limitHi, (double)item_.getRebbulkps_6_8_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_V_limitLo, (double)item_.getRebbulkps_6_8_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_I_warnHi, (double)item_.getRebbulkps_9_12_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_I_warnLo, (double)item_.getRebbulkps_9_12_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_I_limitHi, (double)item_.getRebbulkps_9_12_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_I_limitLo, (double)item_.getRebbulkps_9_12_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_T_warnHi, (double)item_.getRebbulkps_9_12_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_T_warnLo, (double)item_.getRebbulkps_9_12_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_T_limitHi, (double)item_.getRebbulkps_9_12_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_T_limitLo, (double)item_.getRebbulkps_9_12_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_V_warnHi, (double)item_.getRebbulkps_9_12_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_V_warnLo, (double)item_.getRebbulkps_9_12_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_V_limitHi, (double)item_.getRebbulkps_9_12_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_V_limitLo, (double)item_.getRebbulkps_9_12_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_Brd_T_warnHi, (double)item_.getRebbulkps_Brd_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_Brd_T_warnLo, (double)item_.getRebbulkps_Brd_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_Brd_T_limitHi, (double)item_.getRebbulkps_Brd_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_Brd_T_limitLo, (double)item_.getRebbulkps_Brd_T_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_REB_Bulk_PS_QuadboxConfigurationEvent() throws Exception {
        String version = "";
        int node = 277;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_REB_Bulk_PS_QuadboxConfigurationEvent(version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_REB_Bulk_PS_QuadboxConfigurationEvent));
        Quadbox_REB_Bulk_PS_QuadboxConfigurationEvent item_ = (Quadbox_REB_Bulk_PS_QuadboxConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveRebpower_EmergencyResponseManager_GeneralConfigurationEvent() throws Exception {
        String version = "";
        boolean processOnlyClearedAlerts = false;
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_EmergencyResponseManager_GeneralConfigurationEvent(version, processOnlyClearedAlerts));
        Assert.assertTrue((boolean)(item instanceof Rebpower_EmergencyResponseManager_GeneralConfigurationEvent));
        Rebpower_EmergencyResponseManager_GeneralConfigurationEvent item_ = (Rebpower_EmergencyResponseManager_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)processOnlyClearedAlerts, (Object)item_.isProcessOnlyClearedAlerts());
    }

    @Test
    public void sendReceiveRebpower_GeneralConfigurationEvent() throws Exception {
        String version = "";
        long powerOffSleepMillis = 269L;
        int psDeviceExcepNumToOffline = 297;
        long psDeviceReadTimeout = 25L;
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_GeneralConfigurationEvent(version, powerOffSleepMillis, psDeviceExcepNumToOffline, psDeviceReadTimeout));
        Assert.assertTrue((boolean)(item instanceof Rebpower_GeneralConfigurationEvent));
        Rebpower_GeneralConfigurationEvent item_ = (Rebpower_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)powerOffSleepMillis, (long)item_.getPowerOffSleepMillis());
        Assert.assertEquals((long)psDeviceExcepNumToOffline, (long)item_.getPsDeviceExcepNumToOffline());
        Assert.assertEquals((long)psDeviceReadTimeout, (long)item_.getPsDeviceReadTimeout());
    }

    @Test
    public void sendReceiveRebpower_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "";
        int schedulers_default_nTasks = 391;
        int schedulers_default_nThreads = 114;
        int schedulers_monitor_check_scheduler_nTasks = 628;
        int schedulers_monitor_check_scheduler_nThreads = 36;
        int schedulers_monitor_update_publish_scheduler_nTasks = 584;
        int schedulers_monitor_update_publish_scheduler_nThreads = 554;
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_check_scheduler_nTasks, schedulers_monitor_check_scheduler_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Rebpower_PeriodicTasks_GeneralConfigurationEvent));
        Rebpower_PeriodicTasks_GeneralConfigurationEvent item_ = (Rebpower_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nTasks, (long)item_.getSchedulers_monitor_check_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nThreads, (long)item_.getSchedulers_monitor_check_scheduler_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveRebpower_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "";
        long agentmonitorservice_taskPeriodMillis = 557L;
        long heartbeat_taskPeriodMillis = 393L;
        long monitor_check_RebPS_P00_taskPeriodMillis = 394L;
        long monitor_check_RebPS_P01_taskPeriodMillis = 184L;
        long monitor_check_RebPS_P02_taskPeriodMillis = 616L;
        long monitor_check_RebPS_P03_taskPeriodMillis = 679L;
        long monitor_check_RebPS_P04_taskPeriodMillis = 448L;
        long monitor_check_RebPS_P05_taskPeriodMillis = 704L;
        long monitor_check_RebPS_P06_taskPeriodMillis = 347L;
        long monitor_check_RebPS_P07_taskPeriodMillis = 818L;
        long monitor_check_RebPS_P08_taskPeriodMillis = 319L;
        long monitor_check_RebPS_P09_taskPeriodMillis = 580L;
        long monitor_check_RebPS_P10_taskPeriodMillis = 336L;
        long monitor_check_RebPS_P11_taskPeriodMillis = 804L;
        long monitor_check_RebPS_P12_taskPeriodMillis = 184L;
        long monitor_publish_RebPS_P00_taskPeriodMillis = 938L;
        long monitor_publish_RebPS_P01_taskPeriodMillis = 61L;
        long monitor_publish_RebPS_P02_taskPeriodMillis = 976L;
        long monitor_publish_RebPS_P03_taskPeriodMillis = 711L;
        long monitor_publish_RebPS_P04_taskPeriodMillis = 216L;
        long monitor_publish_RebPS_P05_taskPeriodMillis = 327L;
        long monitor_publish_RebPS_P06_taskPeriodMillis = 892L;
        long monitor_publish_RebPS_P07_taskPeriodMillis = 616L;
        long monitor_publish_RebPS_P08_taskPeriodMillis = 11L;
        long monitor_publish_RebPS_P09_taskPeriodMillis = 698L;
        long monitor_publish_RebPS_P10_taskPeriodMillis = 388L;
        long monitor_publish_RebPS_P11_taskPeriodMillis = 960L;
        long monitor_publish_RebPS_P12_taskPeriodMillis = 205L;
        long monitor_publish_taskPeriodMillis = 411L;
        long monitor_update_RebPS_P00_taskPeriodMillis = 692L;
        long monitor_update_RebPS_P01_taskPeriodMillis = 368L;
        long monitor_update_RebPS_P02_taskPeriodMillis = 562L;
        long monitor_update_RebPS_P03_taskPeriodMillis = 46L;
        long monitor_update_RebPS_P04_taskPeriodMillis = 226L;
        long monitor_update_RebPS_P05_taskPeriodMillis = 244L;
        long monitor_update_RebPS_P06_taskPeriodMillis = 48L;
        long monitor_update_RebPS_P07_taskPeriodMillis = 643L;
        long monitor_update_RebPS_P08_taskPeriodMillis = 574L;
        long monitor_update_RebPS_P09_taskPeriodMillis = 154L;
        long monitor_update_RebPS_P10_taskPeriodMillis = 592L;
        long monitor_update_RebPS_P11_taskPeriodMillis = 67L;
        long monitor_update_RebPS_P12_taskPeriodMillis = 527L;
        long monitor_update_taskPeriodMillis = 502L;
        long reb_power_state_taskPeriodMillis = 885L;
        long runtimeinfo_taskPeriodMillis = 217L;
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_RebPS_P00_taskPeriodMillis, monitor_check_RebPS_P01_taskPeriodMillis, monitor_check_RebPS_P02_taskPeriodMillis, monitor_check_RebPS_P03_taskPeriodMillis, monitor_check_RebPS_P04_taskPeriodMillis, monitor_check_RebPS_P05_taskPeriodMillis, monitor_check_RebPS_P06_taskPeriodMillis, monitor_check_RebPS_P07_taskPeriodMillis, monitor_check_RebPS_P08_taskPeriodMillis, monitor_check_RebPS_P09_taskPeriodMillis, monitor_check_RebPS_P10_taskPeriodMillis, monitor_check_RebPS_P11_taskPeriodMillis, monitor_check_RebPS_P12_taskPeriodMillis, monitor_publish_RebPS_P00_taskPeriodMillis, monitor_publish_RebPS_P01_taskPeriodMillis, monitor_publish_RebPS_P02_taskPeriodMillis, monitor_publish_RebPS_P03_taskPeriodMillis, monitor_publish_RebPS_P04_taskPeriodMillis, monitor_publish_RebPS_P05_taskPeriodMillis, monitor_publish_RebPS_P06_taskPeriodMillis, monitor_publish_RebPS_P07_taskPeriodMillis, monitor_publish_RebPS_P08_taskPeriodMillis, monitor_publish_RebPS_P09_taskPeriodMillis, monitor_publish_RebPS_P10_taskPeriodMillis, monitor_publish_RebPS_P11_taskPeriodMillis, monitor_publish_RebPS_P12_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_RebPS_P00_taskPeriodMillis, monitor_update_RebPS_P01_taskPeriodMillis, monitor_update_RebPS_P02_taskPeriodMillis, monitor_update_RebPS_P03_taskPeriodMillis, monitor_update_RebPS_P04_taskPeriodMillis, monitor_update_RebPS_P05_taskPeriodMillis, monitor_update_RebPS_P06_taskPeriodMillis, monitor_update_RebPS_P07_taskPeriodMillis, monitor_update_RebPS_P08_taskPeriodMillis, monitor_update_RebPS_P09_taskPeriodMillis, monitor_update_RebPS_P10_taskPeriodMillis, monitor_update_RebPS_P11_taskPeriodMillis, monitor_update_RebPS_P12_taskPeriodMillis, monitor_update_taskPeriodMillis, reb_power_state_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Rebpower_PeriodicTasks_timersConfigurationEvent));
        Rebpower_PeriodicTasks_timersConfigurationEvent item_ = (Rebpower_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P00_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P00_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P01_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P01_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P02_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P02_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P03_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P03_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P04_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P04_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P05_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P05_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P06_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P06_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P07_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P07_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P08_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P08_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P09_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P09_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P10_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P10_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P11_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P11_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P12_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P12_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P00_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P00_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P01_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P01_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P02_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P02_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P03_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P03_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P04_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P04_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P05_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P05_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P06_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P06_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P07_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P07_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P08_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P08_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P09_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P09_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P10_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P10_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P11_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P11_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P12_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P12_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P00_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P00_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P01_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P01_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P02_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P02_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P03_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P03_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P04_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P04_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P05_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P05_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P06_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P06_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P07_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P07_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P08_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P08_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P09_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P09_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P10_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P10_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P11_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P11_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P12_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P12_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)reb_power_state_taskPeriodMillis, (long)item_.getReb_power_state_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveRebpower_RebTotalPower_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.3241550326347351;
        double warnLo = 0.9119870662689209;
        double limitHi = 0.8102445602416992;
        double limitLo = 0.24977731704711914;
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_RebTotalPower_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebTotalPower_LimitsConfigurationEvent));
        Rebpower_RebTotalPower_LimitsConfigurationEvent item_ = (Rebpower_RebTotalPower_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_Reb_GeneralConfigurationEvent() throws Exception {
        String version = "r";
        int[] dphi = TestHelper.generateIntArray((int)71, (int)-519860606);
        int[] hvBias = TestHelper.generateIntArray((int)71, (int)-422118589);
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Reb_GeneralConfigurationEvent(version, dphi, hvBias, location));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Reb_GeneralConfigurationEvent));
        Rebpower_Reb_GeneralConfigurationEvent item_ = (Rebpower_Reb_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((int[])dphi, (int[])item_.getDphi());
        Assert.assertArrayEquals((int[])hvBias, (int[])item_.getHvBias());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveRebpower_Reb_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double[] analog_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-756599334);
        double[] analog_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1192020434);
        double[] analog_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-19542252);
        double[] analog_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-619950443);
        double[] analog_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)1436232895);
        double[] analog_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)703977514);
        double[] analog_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)2091892767);
        double[] analog_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-855600459);
        double[] analog_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1980199575);
        double[] analog_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)940320828);
        double[] analog_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-532032296);
        double[] analog_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1978158113);
        double[] analog_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)-277532678);
        double[] analog_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)839748735);
        double[] analog_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)1685361757);
        double[] analog_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)136639448);
        double[] analog_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1362807546);
        double[] analog_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-899277734);
        double[] analog_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)880320087);
        double[] analog_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1036408008);
        double[] clockhi_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1414777772);
        double[] clockhi_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1311006219);
        double[] clockhi_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)1077313887);
        double[] clockhi_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)925326478);
        double[] clockhi_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)2045514726);
        double[] clockhi_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)639418088);
        double[] clockhi_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)2013467549);
        double[] clockhi_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1307455252);
        double[] clockhi_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)328977206);
        double[] clockhi_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-2100221899);
        double[] clockhi_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)56504754);
        double[] clockhi_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1673514815);
        double[] clockhi_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)1393596098);
        double[] clockhi_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1545785992);
        double[] clockhi_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)2132543447);
        double[] clockhi_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1760192352);
        double[] clockhi_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-869769270);
        double[] clockhi_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-470155428);
        double[] clockhi_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1099478714);
        double[] clockhi_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)197809642);
        double[] clocklo_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-932422568);
        double[] clocklo_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1897436847);
        double[] clocklo_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)1627716056);
        double[] clocklo_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-242333044);
        double[] clocklo_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)997141376);
        double[] clocklo_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-2121076101);
        double[] clocklo_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)602451439);
        double[] clocklo_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)182509727);
        double[] clocklo_VaftLDO2_warnHi = TestHelper.generateDoubleArray((int)71, (int)1631187433);
        double[] clocklo_VaftLDO2_warnLo = TestHelper.generateDoubleArray((int)71, (int)1742445037);
        double[] clocklo_VaftLDO2_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1590532971);
        double[] clocklo_VaftLDO2_limitLo = TestHelper.generateDoubleArray((int)71, (int)-885857734);
        double[] clocklo_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)63978123);
        double[] clocklo_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-27745770);
        double[] clocklo_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)322789349);
        double[] clocklo_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-253594619);
        double[] clocklo_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)-955605063);
        double[] clocklo_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)436019067);
        double[] clocklo_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)762945449);
        double[] clocklo_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)509846796);
        double[] clocklo_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)1065648226);
        double[] clocklo_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)249118374);
        double[] clocklo_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1770003900);
        double[] clocklo_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1472309205);
        double[] digital_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)1918453139);
        double[] digital_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1378519715);
        double[] digital_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1830137902);
        double[] digital_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1741818035);
        double[] digital_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-600703937);
        double[] digital_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)911414039);
        double[] digital_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-345361523);
        double[] digital_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-63670948);
        double[] digital_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)2129413954);
        double[] digital_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1218386773);
        double[] digital_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1657444494);
        double[] digital_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-2050037319);
        double[] digital_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)842001827);
        double[] digital_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)-605429942);
        double[] digital_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)-395553245);
        double[] digital_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)1981765117);
        double[] digital_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1931966183);
        double[] digital_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1724971345);
        double[] digital_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)1858320143);
        double[] digital_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1975063033);
        double[] dphi_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-143845168);
        double[] dphi_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1103297900);
        double[] dphi_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)1271621839);
        double[] dphi_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1859498413);
        double[] dphi_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1690862484);
        double[] dphi_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1189013657);
        double[] dphi_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)31329747);
        double[] dphi_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1430654753);
        double[] dphi_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-97903794);
        double[] dphi_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1029147075);
        double[] dphi_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)1230720829);
        double[] dphi_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)478780790);
        double[] dphi_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1713226731);
        double[] dphi_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)-290449401);
        double[] dphi_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)-309794292);
        double[] dphi_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)1251957047);
        double[] dphi_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1543909273);
        double[] dphi_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1128622077);
        double[] dphi_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-107681155);
        double[] dphi_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1685788172);
        double[] heater_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)130267376);
        double[] heater_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-974864012);
        double[] heater_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)989182381);
        double[] heater_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1685206767);
        double[] heater_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)565822890);
        double[] heater_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)296273044);
        double[] heater_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)587915650);
        double[] heater_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1996849627);
        double[] heater_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)1402205791);
        double[] heater_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1385478455);
        double[] heater_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)313240268);
        double[] heater_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1227710171);
        double[] heater_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)829734763);
        double[] heater_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)181191191);
        double[] heater_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)897513894);
        double[] heater_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)1423382639);
        double[] heater_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-586262842);
        double[] heater_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-915609642);
        double[] heater_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)181013538);
        double[] heater_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-85763947);
        double[] hvbias_IbefSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)56708417);
        double[] hvbias_IbefSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)1098185380);
        double[] hvbias_VbefSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)874118948);
        double[] hvbias_VbefSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)1074014218);
        String location = "";
        double[] od_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-266775652);
        double[] od_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-368689778);
        double[] od_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-527394669);
        double[] od_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1332637320);
        double[] od_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-846100793);
        double[] od_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1165476451);
        double[] od_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-2143797095);
        double[] od_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1920147496);
        double[] od_VaftLDO2_warnHi = TestHelper.generateDoubleArray((int)71, (int)1208605394);
        double[] od_VaftLDO2_warnLo = TestHelper.generateDoubleArray((int)71, (int)-985190254);
        double[] od_VaftLDO2_limitHi = TestHelper.generateDoubleArray((int)71, (int)2033867771);
        double[] od_VaftLDO2_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1123006755);
        double[] od_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-938997759);
        double[] od_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)1056737428);
        double[] od_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)1152230943);
        double[] od_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1263486591);
        double[] od_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)468218467);
        double[] od_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)2013296852);
        double[] od_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)-660389558);
        double[] od_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)-12655963);
        double[] od_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)1085821767);
        double[] od_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)828101618);
        double[] od_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1430241487);
        double[] od_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1347887217);
        double[] power_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1174108690);
        double[] power_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1716589409);
        double[] power_limitHi = TestHelper.generateDoubleArray((int)71, (int)462331600);
        double[] power_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1831269499);
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Reb_LimitsConfigurationEvent(version, analog_IaftLDO_warnHi, analog_IaftLDO_warnLo, analog_IaftLDO_limitHi, analog_IaftLDO_limitLo, analog_IbefLDO_warnHi, analog_IbefLDO_warnLo, analog_IbefLDO_limitHi, analog_IbefLDO_limitLo, analog_VaftLDO_warnHi, analog_VaftLDO_warnLo, analog_VaftLDO_limitHi, analog_VaftLDO_limitLo, analog_VaftSwch_warnHi, analog_VaftSwch_warnLo, analog_VaftSwch_limitHi, analog_VaftSwch_limitLo, analog_VbefLDO_warnHi, analog_VbefLDO_warnLo, analog_VbefLDO_limitHi, analog_VbefLDO_limitLo, clockhi_IaftLDO_warnHi, clockhi_IaftLDO_warnLo, clockhi_IaftLDO_limitHi, clockhi_IaftLDO_limitLo, clockhi_IbefLDO_warnHi, clockhi_IbefLDO_warnLo, clockhi_IbefLDO_limitHi, clockhi_IbefLDO_limitLo, clockhi_VaftLDO_warnHi, clockhi_VaftLDO_warnLo, clockhi_VaftLDO_limitHi, clockhi_VaftLDO_limitLo, clockhi_VaftSwch_warnHi, clockhi_VaftSwch_warnLo, clockhi_VaftSwch_limitHi, clockhi_VaftSwch_limitLo, clockhi_VbefLDO_warnHi, clockhi_VbefLDO_warnLo, clockhi_VbefLDO_limitHi, clockhi_VbefLDO_limitLo, clocklo_IaftLDO_warnHi, clocklo_IaftLDO_warnLo, clocklo_IaftLDO_limitHi, clocklo_IaftLDO_limitLo, clocklo_IbefLDO_warnHi, clocklo_IbefLDO_warnLo, clocklo_IbefLDO_limitHi, clocklo_IbefLDO_limitLo, clocklo_VaftLDO2_warnHi, clocklo_VaftLDO2_warnLo, clocklo_VaftLDO2_limitHi, clocklo_VaftLDO2_limitLo, clocklo_VaftLDO_warnHi, clocklo_VaftLDO_warnLo, clocklo_VaftLDO_limitHi, clocklo_VaftLDO_limitLo, clocklo_VaftSwch_warnHi, clocklo_VaftSwch_warnLo, clocklo_VaftSwch_limitHi, clocklo_VaftSwch_limitLo, clocklo_VbefLDO_warnHi, clocklo_VbefLDO_warnLo, clocklo_VbefLDO_limitHi, clocklo_VbefLDO_limitLo, digital_IaftLDO_warnHi, digital_IaftLDO_warnLo, digital_IaftLDO_limitHi, digital_IaftLDO_limitLo, digital_IbefLDO_warnHi, digital_IbefLDO_warnLo, digital_IbefLDO_limitHi, digital_IbefLDO_limitLo, digital_VaftLDO_warnHi, digital_VaftLDO_warnLo, digital_VaftLDO_limitHi, digital_VaftLDO_limitLo, digital_VaftSwch_warnHi, digital_VaftSwch_warnLo, digital_VaftSwch_limitHi, digital_VaftSwch_limitLo, digital_VbefLDO_warnHi, digital_VbefLDO_warnLo, digital_VbefLDO_limitHi, digital_VbefLDO_limitLo, dphi_IaftLDO_warnHi, dphi_IaftLDO_warnLo, dphi_IaftLDO_limitHi, dphi_IaftLDO_limitLo, dphi_IbefLDO_warnHi, dphi_IbefLDO_warnLo, dphi_IbefLDO_limitHi, dphi_IbefLDO_limitLo, dphi_VaftLDO_warnHi, dphi_VaftLDO_warnLo, dphi_VaftLDO_limitHi, dphi_VaftLDO_limitLo, dphi_VaftSwch_warnHi, dphi_VaftSwch_warnLo, dphi_VaftSwch_limitHi, dphi_VaftSwch_limitLo, dphi_VbefLDO_warnHi, dphi_VbefLDO_warnLo, dphi_VbefLDO_limitHi, dphi_VbefLDO_limitLo, heater_IaftLDO_warnHi, heater_IaftLDO_warnLo, heater_IaftLDO_limitHi, heater_IaftLDO_limitLo, heater_IbefLDO_warnHi, heater_IbefLDO_warnLo, heater_IbefLDO_limitHi, heater_IbefLDO_limitLo, heater_VaftLDO_warnHi, heater_VaftLDO_warnLo, heater_VaftLDO_limitHi, heater_VaftLDO_limitLo, heater_VaftSwch_warnHi, heater_VaftSwch_warnLo, heater_VaftSwch_limitHi, heater_VaftSwch_limitLo, heater_VbefLDO_warnHi, heater_VbefLDO_warnLo, heater_VbefLDO_limitHi, heater_VbefLDO_limitLo, hvbias_IbefSwch_warnHi, hvbias_IbefSwch_limitHi, hvbias_VbefSwch_warnHi, hvbias_VbefSwch_limitHi, location, od_IaftLDO_warnHi, od_IaftLDO_warnLo, od_IaftLDO_limitHi, od_IaftLDO_limitLo, od_IbefLDO_warnHi, od_IbefLDO_warnLo, od_IbefLDO_limitHi, od_IbefLDO_limitLo, od_VaftLDO2_warnHi, od_VaftLDO2_warnLo, od_VaftLDO2_limitHi, od_VaftLDO2_limitLo, od_VaftLDO_warnHi, od_VaftLDO_warnLo, od_VaftLDO_limitHi, od_VaftLDO_limitLo, od_VaftSwch_warnHi, od_VaftSwch_warnLo, od_VaftSwch_limitHi, od_VaftSwch_limitLo, od_VbefLDO_warnHi, od_VbefLDO_warnLo, od_VbefLDO_limitHi, od_VbefLDO_limitLo, power_warnHi, power_warnLo, power_limitHi, power_limitLo));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Reb_LimitsConfigurationEvent));
        Rebpower_Reb_LimitsConfigurationEvent item_ = (Rebpower_Reb_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])analog_IaftLDO_warnHi, (double[])item_.getAnalog_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IaftLDO_warnLo, (double[])item_.getAnalog_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IaftLDO_limitHi, (double[])item_.getAnalog_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IaftLDO_limitLo, (double[])item_.getAnalog_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO_warnHi, (double[])item_.getAnalog_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO_warnLo, (double[])item_.getAnalog_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO_limitHi, (double[])item_.getAnalog_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO_limitLo, (double[])item_.getAnalog_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO_warnHi, (double[])item_.getAnalog_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO_warnLo, (double[])item_.getAnalog_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO_limitHi, (double[])item_.getAnalog_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO_limitLo, (double[])item_.getAnalog_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch_warnHi, (double[])item_.getAnalog_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch_warnLo, (double[])item_.getAnalog_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch_limitHi, (double[])item_.getAnalog_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch_limitLo, (double[])item_.getAnalog_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO_warnHi, (double[])item_.getAnalog_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO_warnLo, (double[])item_.getAnalog_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO_limitHi, (double[])item_.getAnalog_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO_limitLo, (double[])item_.getAnalog_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO_warnHi, (double[])item_.getClockhi_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO_warnLo, (double[])item_.getClockhi_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO_limitHi, (double[])item_.getClockhi_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO_limitLo, (double[])item_.getClockhi_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO_warnHi, (double[])item_.getClockhi_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO_warnLo, (double[])item_.getClockhi_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO_limitHi, (double[])item_.getClockhi_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO_limitLo, (double[])item_.getClockhi_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO_warnHi, (double[])item_.getClockhi_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO_warnLo, (double[])item_.getClockhi_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO_limitHi, (double[])item_.getClockhi_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO_limitLo, (double[])item_.getClockhi_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch_warnHi, (double[])item_.getClockhi_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch_warnLo, (double[])item_.getClockhi_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch_limitHi, (double[])item_.getClockhi_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch_limitLo, (double[])item_.getClockhi_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO_warnHi, (double[])item_.getClockhi_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO_warnLo, (double[])item_.getClockhi_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO_limitHi, (double[])item_.getClockhi_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO_limitLo, (double[])item_.getClockhi_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO_warnHi, (double[])item_.getClocklo_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO_warnLo, (double[])item_.getClocklo_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO_limitHi, (double[])item_.getClocklo_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO_limitLo, (double[])item_.getClocklo_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO_warnHi, (double[])item_.getClocklo_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO_warnLo, (double[])item_.getClocklo_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO_limitHi, (double[])item_.getClocklo_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO_limitLo, (double[])item_.getClocklo_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2_warnHi, (double[])item_.getClocklo_VaftLDO2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2_warnLo, (double[])item_.getClocklo_VaftLDO2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2_limitHi, (double[])item_.getClocklo_VaftLDO2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2_limitLo, (double[])item_.getClocklo_VaftLDO2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO_warnHi, (double[])item_.getClocklo_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO_warnLo, (double[])item_.getClocklo_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO_limitHi, (double[])item_.getClocklo_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO_limitLo, (double[])item_.getClocklo_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch_warnHi, (double[])item_.getClocklo_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch_warnLo, (double[])item_.getClocklo_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch_limitHi, (double[])item_.getClocklo_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch_limitLo, (double[])item_.getClocklo_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO_warnHi, (double[])item_.getClocklo_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO_warnLo, (double[])item_.getClocklo_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO_limitHi, (double[])item_.getClocklo_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO_limitLo, (double[])item_.getClocklo_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO_warnHi, (double[])item_.getDigital_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO_warnLo, (double[])item_.getDigital_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO_limitHi, (double[])item_.getDigital_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO_limitLo, (double[])item_.getDigital_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO_warnHi, (double[])item_.getDigital_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO_warnLo, (double[])item_.getDigital_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO_limitHi, (double[])item_.getDigital_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO_limitLo, (double[])item_.getDigital_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO_warnHi, (double[])item_.getDigital_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO_warnLo, (double[])item_.getDigital_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO_limitHi, (double[])item_.getDigital_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO_limitLo, (double[])item_.getDigital_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch_warnHi, (double[])item_.getDigital_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch_warnLo, (double[])item_.getDigital_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch_limitHi, (double[])item_.getDigital_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch_limitLo, (double[])item_.getDigital_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO_warnHi, (double[])item_.getDigital_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO_warnLo, (double[])item_.getDigital_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO_limitHi, (double[])item_.getDigital_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO_limitLo, (double[])item_.getDigital_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IaftLDO_warnHi, (double[])item_.getDphi_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IaftLDO_warnLo, (double[])item_.getDphi_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IaftLDO_limitHi, (double[])item_.getDphi_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IaftLDO_limitLo, (double[])item_.getDphi_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IbefLDO_warnHi, (double[])item_.getDphi_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IbefLDO_warnLo, (double[])item_.getDphi_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IbefLDO_limitHi, (double[])item_.getDphi_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IbefLDO_limitLo, (double[])item_.getDphi_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftLDO_warnHi, (double[])item_.getDphi_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftLDO_warnLo, (double[])item_.getDphi_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftLDO_limitHi, (double[])item_.getDphi_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftLDO_limitLo, (double[])item_.getDphi_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftSwch_warnHi, (double[])item_.getDphi_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftSwch_warnLo, (double[])item_.getDphi_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftSwch_limitHi, (double[])item_.getDphi_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftSwch_limitLo, (double[])item_.getDphi_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VbefLDO_warnHi, (double[])item_.getDphi_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VbefLDO_warnLo, (double[])item_.getDphi_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VbefLDO_limitHi, (double[])item_.getDphi_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VbefLDO_limitLo, (double[])item_.getDphi_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO_warnHi, (double[])item_.getHeater_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO_warnLo, (double[])item_.getHeater_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO_limitHi, (double[])item_.getHeater_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO_limitLo, (double[])item_.getHeater_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO_warnHi, (double[])item_.getHeater_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO_warnLo, (double[])item_.getHeater_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO_limitHi, (double[])item_.getHeater_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO_limitLo, (double[])item_.getHeater_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO_warnHi, (double[])item_.getHeater_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO_warnLo, (double[])item_.getHeater_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO_limitHi, (double[])item_.getHeater_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO_limitLo, (double[])item_.getHeater_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch_warnHi, (double[])item_.getHeater_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch_warnLo, (double[])item_.getHeater_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch_limitHi, (double[])item_.getHeater_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch_limitLo, (double[])item_.getHeater_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO_warnHi, (double[])item_.getHeater_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO_warnLo, (double[])item_.getHeater_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO_limitHi, (double[])item_.getHeater_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO_limitLo, (double[])item_.getHeater_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch_warnHi, (double[])item_.getHvbias_IbefSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch_limitHi, (double[])item_.getHvbias_IbefSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch_warnHi, (double[])item_.getHvbias_VbefSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch_limitHi, (double[])item_.getHvbias_VbefSwch_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])od_IaftLDO_warnHi, (double[])item_.getOd_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IaftLDO_warnLo, (double[])item_.getOd_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IaftLDO_limitHi, (double[])item_.getOd_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IaftLDO_limitLo, (double[])item_.getOd_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO_warnHi, (double[])item_.getOd_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO_warnLo, (double[])item_.getOd_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO_limitHi, (double[])item_.getOd_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO_limitLo, (double[])item_.getOd_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2_warnHi, (double[])item_.getOd_VaftLDO2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2_warnLo, (double[])item_.getOd_VaftLDO2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2_limitHi, (double[])item_.getOd_VaftLDO2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2_limitLo, (double[])item_.getOd_VaftLDO2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO_warnHi, (double[])item_.getOd_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO_warnLo, (double[])item_.getOd_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO_limitHi, (double[])item_.getOd_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO_limitLo, (double[])item_.getOd_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch_warnHi, (double[])item_.getOd_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch_warnLo, (double[])item_.getOd_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch_limitHi, (double[])item_.getOd_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch_limitLo, (double[])item_.getOd_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO_warnHi, (double[])item_.getOd_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO_warnLo, (double[])item_.getOd_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO_limitHi, (double[])item_.getOd_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO_limitLo, (double[])item_.getOd_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_warnHi, (double[])item_.getPower_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_warnLo, (double[])item_.getPower_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_limitHi, (double[])item_.getPower_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_limitLo, (double[])item_.getPower_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_Rebps_DevicesConfigurationEvent() throws Exception {
        String version = "v";
        boolean[] disabled = new boolean[]{true, false, true, false, false, true, false, true, true, true, true, true, false};
        String location = "c";
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Rebps_DevicesConfigurationEvent(version, disabled, location));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Rebps_DevicesConfigurationEvent));
        Rebpower_Rebps_DevicesConfigurationEvent item_ = (Rebpower_Rebps_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((boolean[])disabled, (boolean[])item_.getDisabled());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveRebpower_Rebps_GeneralConfigurationEvent() throws Exception {
        String version = "";
        String location = "w";
        String rebs = "w";
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Rebps_GeneralConfigurationEvent(version, location, rebs));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Rebps_GeneralConfigurationEvent));
        Rebpower_Rebps_GeneralConfigurationEvent item_ = (Rebpower_Rebps_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)rebs, (Object)item_.getRebs());
    }

    @Test
    public void sendReceiveRebpower_Rebps_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double[] boardtemp0_warnHi = TestHelper.generateDoubleArray((int)13, (int)-356844860);
        double[] boardtemp0_warnLo = TestHelper.generateDoubleArray((int)13, (int)-1821991732);
        double[] boardtemp0_limitHi = TestHelper.generateDoubleArray((int)13, (int)-397599430);
        double[] boardtemp0_limitLo = TestHelper.generateDoubleArray((int)13, (int)700993758);
        double[] boardtemp1_warnHi = TestHelper.generateDoubleArray((int)13, (int)1039190927);
        double[] boardtemp1_warnLo = TestHelper.generateDoubleArray((int)13, (int)-516580648);
        double[] boardtemp1_limitHi = TestHelper.generateDoubleArray((int)13, (int)-730356399);
        double[] boardtemp1_limitLo = TestHelper.generateDoubleArray((int)13, (int)-1262628040);
        double[] boardtemp2_warnHi = TestHelper.generateDoubleArray((int)13, (int)1183616865);
        double[] boardtemp2_warnLo = TestHelper.generateDoubleArray((int)13, (int)881548413);
        double[] boardtemp2_limitHi = TestHelper.generateDoubleArray((int)13, (int)1049540063);
        double[] boardtemp2_limitLo = TestHelper.generateDoubleArray((int)13, (int)1078411180);
        double[] boardtemp3_warnHi = TestHelper.generateDoubleArray((int)13, (int)-1374401647);
        double[] boardtemp3_warnLo = TestHelper.generateDoubleArray((int)13, (int)-1434611159);
        double[] boardtemp3_limitHi = TestHelper.generateDoubleArray((int)13, (int)1073832072);
        double[] boardtemp3_limitLo = TestHelper.generateDoubleArray((int)13, (int)-1190018701);
        double[] boardtemp4_warnHi = TestHelper.generateDoubleArray((int)13, (int)-1062984232);
        double[] boardtemp4_warnLo = TestHelper.generateDoubleArray((int)13, (int)-2028812166);
        double[] boardtemp4_limitHi = TestHelper.generateDoubleArray((int)13, (int)565045903);
        double[] boardtemp4_limitLo = TestHelper.generateDoubleArray((int)13, (int)937864108);
        double[] boardtemp5_warnHi = TestHelper.generateDoubleArray((int)13, (int)928030298);
        double[] boardtemp5_warnLo = TestHelper.generateDoubleArray((int)13, (int)-1796951056);
        double[] boardtemp5_limitHi = TestHelper.generateDoubleArray((int)13, (int)-974143367);
        double[] boardtemp5_limitLo = TestHelper.generateDoubleArray((int)13, (int)-2051961306);
        double[] boardtemp6_warnHi = TestHelper.generateDoubleArray((int)13, (int)-253499929);
        double[] boardtemp6_warnLo = TestHelper.generateDoubleArray((int)13, (int)1743717347);
        double[] boardtemp6_limitHi = TestHelper.generateDoubleArray((int)13, (int)-47808529);
        double[] boardtemp6_limitLo = TestHelper.generateDoubleArray((int)13, (int)1108493183);
        double[] fpgatemp_warnHi = TestHelper.generateDoubleArray((int)13, (int)-383527811);
        double[] fpgatemp_warnLo = TestHelper.generateDoubleArray((int)13, (int)998502583);
        double[] fpgatemp_limitHi = TestHelper.generateDoubleArray((int)13, (int)-292996120);
        double[] fpgatemp_limitLo = TestHelper.generateDoubleArray((int)13, (int)1572424813);
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Rebps_LimitsConfigurationEvent(version, boardtemp0_warnHi, boardtemp0_warnLo, boardtemp0_limitHi, boardtemp0_limitLo, boardtemp1_warnHi, boardtemp1_warnLo, boardtemp1_limitHi, boardtemp1_limitLo, boardtemp2_warnHi, boardtemp2_warnLo, boardtemp2_limitHi, boardtemp2_limitLo, boardtemp3_warnHi, boardtemp3_warnLo, boardtemp3_limitHi, boardtemp3_limitLo, boardtemp4_warnHi, boardtemp4_warnLo, boardtemp4_limitHi, boardtemp4_limitLo, boardtemp5_warnHi, boardtemp5_warnLo, boardtemp5_limitHi, boardtemp5_limitLo, boardtemp6_warnHi, boardtemp6_warnLo, boardtemp6_limitHi, boardtemp6_limitLo, fpgatemp_warnHi, fpgatemp_warnLo, fpgatemp_limitHi, fpgatemp_limitLo, location));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Rebps_LimitsConfigurationEvent));
        Rebpower_Rebps_LimitsConfigurationEvent item_ = (Rebpower_Rebps_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])boardtemp0_warnHi, (double[])item_.getBoardtemp0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp0_warnLo, (double[])item_.getBoardtemp0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp0_limitHi, (double[])item_.getBoardtemp0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp0_limitLo, (double[])item_.getBoardtemp0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp1_warnHi, (double[])item_.getBoardtemp1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp1_warnLo, (double[])item_.getBoardtemp1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp1_limitHi, (double[])item_.getBoardtemp1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp1_limitLo, (double[])item_.getBoardtemp1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp2_warnHi, (double[])item_.getBoardtemp2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp2_warnLo, (double[])item_.getBoardtemp2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp2_limitHi, (double[])item_.getBoardtemp2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp2_limitLo, (double[])item_.getBoardtemp2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp3_warnHi, (double[])item_.getBoardtemp3_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp3_warnLo, (double[])item_.getBoardtemp3_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp3_limitHi, (double[])item_.getBoardtemp3_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp3_limitLo, (double[])item_.getBoardtemp3_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp4_warnHi, (double[])item_.getBoardtemp4_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp4_warnLo, (double[])item_.getBoardtemp4_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp4_limitHi, (double[])item_.getBoardtemp4_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp4_limitLo, (double[])item_.getBoardtemp4_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp5_warnHi, (double[])item_.getBoardtemp5_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp5_warnLo, (double[])item_.getBoardtemp5_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp5_limitHi, (double[])item_.getBoardtemp5_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp5_limitLo, (double[])item_.getBoardtemp5_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp6_warnHi, (double[])item_.getBoardtemp6_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp6_warnLo, (double[])item_.getBoardtemp6_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp6_limitHi, (double[])item_.getBoardtemp6_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp6_limitLo, (double[])item_.getBoardtemp6_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])fpgatemp_warnHi, (double[])item_.getFpgatemp_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])fpgatemp_warnLo, (double[])item_.getFpgatemp_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])fpgatemp_limitHi, (double[])item_.getFpgatemp_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])fpgatemp_limitLo, (double[])item_.getFpgatemp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveRebpower_Rebps_PowerConfigurationEvent() throws Exception {
        String version = "";
        String ipAddr = "v";
        String location = "k";
        int[] nPowerOnPub = TestHelper.generateIntArray((int)13, (int)1193988161);
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Rebps_PowerConfigurationEvent(version, ipAddr, location, nPowerOnPub));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Rebps_PowerConfigurationEvent));
        Rebpower_Rebps_PowerConfigurationEvent item_ = (Rebpower_Rebps_PowerConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)ipAddr, (Object)item_.getIpAddr());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((int[])nPowerOnPub, (int[])item_.getNPowerOnPub());
    }

    @Test
    public void sendReceiveRebpower_Rebps_buildConfigurationEvent() throws Exception {
        String version = "";
        String location = "";
        String switchName = "p";
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Rebps_buildConfigurationEvent(version, location, switchName));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Rebps_buildConfigurationEvent));
        Rebpower_Rebps_buildConfigurationEvent item_ = (Rebpower_Rebps_buildConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)switchName, (Object)item_.getSwitchName());
    }

    @Test
    public void sendReceiveHex_Cold1_LimitsConfigurationEvent() throws Exception {
        String version = "d";
        double returntmp_warnHi = 0.5879529118537903;
        double returntmp_warnLo = 0.32978355884552;
        double returntmp_limitHi = 0.735785186290741;
        double returntmp_limitLo = 0.49566978216171265;
        double supplytmp_warnHi = 0.08542346954345703;
        double supplytmp_warnLo = 0.1236853f;
        double supplytmp_limitHi = 0.971034824848175;
        double supplytmp_limitLo = 0.8473304510116577;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cold1_LimitsConfigurationEvent(version, returntmp_warnHi, returntmp_warnLo, returntmp_limitHi, returntmp_limitLo, supplytmp_warnHi, supplytmp_warnLo, supplytmp_limitHi, supplytmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cold1_LimitsConfigurationEvent));
        Hex_Cold1_LimitsConfigurationEvent item_ = (Hex_Cold1_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)returntmp_warnHi, (double)item_.getReturntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returntmp_warnLo, (double)item_.getReturntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returntmp_limitHi, (double)item_.getReturntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returntmp_limitLo, (double)item_.getReturntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_warnHi, (double)item_.getSupplytmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_warnLo, (double)item_.getSupplytmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_limitHi, (double)item_.getSupplytmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_limitLo, (double)item_.getSupplytmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cold2_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double returntmp_warnHi = 0.5819786190986633;
        double returntmp_warnLo = 0.5952181816101074;
        double returntmp_limitHi = 0.7927321195602417;
        double returntmp_limitLo = 0.0016371607780456543;
        double supplytmp_warnHi = 0.32815104722976685;
        double supplytmp_warnLo = 0.7488806247711182;
        double supplytmp_limitHi = 0.3368644118309021;
        double supplytmp_limitLo = 0.11643165349960327;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cold2_LimitsConfigurationEvent(version, returntmp_warnHi, returntmp_warnLo, returntmp_limitHi, returntmp_limitLo, supplytmp_warnHi, supplytmp_warnLo, supplytmp_limitHi, supplytmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cold2_LimitsConfigurationEvent));
        Hex_Cold2_LimitsConfigurationEvent item_ = (Hex_Cold2_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)returntmp_warnHi, (double)item_.getReturntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returntmp_warnLo, (double)item_.getReturntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returntmp_limitHi, (double)item_.getReturntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returntmp_limitLo, (double)item_.getReturntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_warnHi, (double)item_.getSupplytmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_warnLo, (double)item_.getSupplytmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_limitHi, (double)item_.getSupplytmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_limitLo, (double)item_.getSupplytmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo1_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double c3exittmp_warnHi = 0.08798271417617798;
        double c3exittmp_warnLo = 0.5846213102340698;
        double c3exittmp_limitHi = 0.48808616399765015;
        double c3exittmp_limitLo = 0.1276019811630249;
        double c4exittmp_warnHi = 0.2578394412994385;
        double c4exittmp_warnLo = 0.10613560676574707;
        double c4exittmp_limitHi = 0.3082171082496643;
        double c4exittmp_limitLo = 0.9318339228630066;
        double evapexittmp_warnHi = 0.8321828842163086;
        double evapexittmp_warnLo = 0.5614796280860901;
        double evapexittmp_limitHi = 0.24628931283950806;
        double evapexittmp_limitLo = 0.9507452249526978;
        double hexrtrntmp_warnHi = 0.3649328351020813;
        double hexrtrntmp_warnLo = 0.3665999174118042;
        double hexrtrntmp_limitHi = 0.38482964038848877;
        double hexrtrntmp_limitLo = 0.8802147507667542;
        double liquidprs_warnHi = 0.2488483190536499;
        double liquidprs_warnLo = 0.4148409366607666;
        double liquidprs_limitHi = 0.4606884f;
        double liquidprs_limitLo = 0.6602405309677124;
        double prec3tmp_warnHi = 0.9092357754707336;
        double prec3tmp_warnLo = 0.8978352546691895;
        double prec3tmp_limitHi = 0.50284343957901;
        double prec3tmp_limitLo = 0.21597141027450562;
        double prec4tmp_warnHi = 0.002817809581756592;
        double prec4tmp_warnLo = 0.33124858140945435;
        double prec4tmp_limitHi = 0.1895303726196289;
        double prec4tmp_limitLo = 0.7303743362426758;
        double returnprs_warnHi = 0.34034425020217896;
        double returnprs_warnLo = 0.735842227935791;
        double returnprs_limitHi = 0.4493151903152466;
        double returnprs_limitLo = 0.931314f;
        double vaporprs_warnHi = 0.1333240270614624;
        double vaporprs_warnLo = 0.06915563344955444;
        double vaporprs_limitHi = 0.8116698861122131;
        double vaporprs_limitLo = 0.8750594854354858;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cryo1_LimitsConfigurationEvent(version, c3exittmp_warnHi, c3exittmp_warnLo, c3exittmp_limitHi, c3exittmp_limitLo, c4exittmp_warnHi, c4exittmp_warnLo, c4exittmp_limitHi, c4exittmp_limitLo, evapexittmp_warnHi, evapexittmp_warnLo, evapexittmp_limitHi, evapexittmp_limitLo, hexrtrntmp_warnHi, hexrtrntmp_warnLo, hexrtrntmp_limitHi, hexrtrntmp_limitLo, liquidprs_warnHi, liquidprs_warnLo, liquidprs_limitHi, liquidprs_limitLo, prec3tmp_warnHi, prec3tmp_warnLo, prec3tmp_limitHi, prec3tmp_limitLo, prec4tmp_warnHi, prec4tmp_warnLo, prec4tmp_limitHi, prec4tmp_limitLo, returnprs_warnHi, returnprs_warnLo, returnprs_limitHi, returnprs_limitLo, vaporprs_warnHi, vaporprs_warnLo, vaporprs_limitHi, vaporprs_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo1_LimitsConfigurationEvent));
        Hex_Cryo1_LimitsConfigurationEvent item_ = (Hex_Cryo1_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)c3exittmp_warnHi, (double)item_.getC3exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_warnLo, (double)item_.getC3exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitHi, (double)item_.getC3exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitLo, (double)item_.getC3exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnHi, (double)item_.getC4exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnLo, (double)item_.getC4exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitHi, (double)item_.getC4exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitLo, (double)item_.getC4exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnHi, (double)item_.getEvapexittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnLo, (double)item_.getEvapexittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitHi, (double)item_.getEvapexittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitLo, (double)item_.getEvapexittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnHi, (double)item_.getHexrtrntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnLo, (double)item_.getHexrtrntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitHi, (double)item_.getHexrtrntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitLo, (double)item_.getHexrtrntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnHi, (double)item_.getLiquidprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnLo, (double)item_.getLiquidprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitHi, (double)item_.getLiquidprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitLo, (double)item_.getLiquidprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnHi, (double)item_.getPrec3tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnLo, (double)item_.getPrec3tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitHi, (double)item_.getPrec3tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitLo, (double)item_.getPrec3tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnHi, (double)item_.getPrec4tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnLo, (double)item_.getPrec4tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitHi, (double)item_.getPrec4tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitLo, (double)item_.getPrec4tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnHi, (double)item_.getReturnprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnLo, (double)item_.getReturnprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitHi, (double)item_.getReturnprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitLo, (double)item_.getReturnprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnHi, (double)item_.getVaporprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnLo, (double)item_.getVaporprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitHi, (double)item_.getVaporprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitLo, (double)item_.getVaporprs_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo2_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double c3exittmp_warnHi = 0.9800442457199097;
        double c3exittmp_warnLo = 0.28536665439605713;
        double c3exittmp_limitHi = 0.2334151268005371;
        double c3exittmp_limitLo = 0.1388377547264099;
        double c4exittmp_warnHi = 0.5651848912239075;
        double c4exittmp_warnLo = 0.5733909606933594;
        double c4exittmp_limitHi = 0.41720718145370483;
        double c4exittmp_limitLo = 0.26448744535446167;
        double evapexittmp_warnHi = 0.35695648193359375;
        double evapexittmp_warnLo = 0.8900324106216431;
        double evapexittmp_limitHi = 0.4097848f;
        double evapexittmp_limitLo = 0.2699854373931885;
        double hexrtrntmp_warnHi = 0.3449241f;
        double hexrtrntmp_warnLo = 0.6514145731925964;
        double hexrtrntmp_limitHi = 0.7461811900138855;
        double hexrtrntmp_limitLo = 0.5459582805633545;
        double liquidprs_warnHi = 0.5232203006744385;
        double liquidprs_warnLo = 0.690171480178833;
        double liquidprs_limitHi = 0.10290920734405518;
        double liquidprs_limitLo = 0.679862916469574;
        double prec3tmp_warnHi = 0.6237860321998596;
        double prec3tmp_warnLo = 0.17658203840255737;
        double prec3tmp_limitHi = 0.7969587445259094;
        double prec3tmp_limitLo = 0.1981566f;
        double prec4tmp_warnHi = 0.2166767716407776;
        double prec4tmp_warnLo = 0.09368312358856201;
        double prec4tmp_limitHi = 0.6079548001289368;
        double prec4tmp_limitLo = 0.8828257322311401;
        double returnprs_warnHi = 0.8750627636909485;
        double returnprs_warnLo = 0.3472723364830017;
        double returnprs_limitHi = 0.6027861833572388;
        double returnprs_limitLo = 0.7847954034805298;
        double vaporprs_warnHi = 0.2713779807090759;
        double vaporprs_warnLo = 0.5309661030769348;
        double vaporprs_limitHi = 0.566125750541687;
        double vaporprs_limitLo = 0.18084394931793213;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cryo2_LimitsConfigurationEvent(version, c3exittmp_warnHi, c3exittmp_warnLo, c3exittmp_limitHi, c3exittmp_limitLo, c4exittmp_warnHi, c4exittmp_warnLo, c4exittmp_limitHi, c4exittmp_limitLo, evapexittmp_warnHi, evapexittmp_warnLo, evapexittmp_limitHi, evapexittmp_limitLo, hexrtrntmp_warnHi, hexrtrntmp_warnLo, hexrtrntmp_limitHi, hexrtrntmp_limitLo, liquidprs_warnHi, liquidprs_warnLo, liquidprs_limitHi, liquidprs_limitLo, prec3tmp_warnHi, prec3tmp_warnLo, prec3tmp_limitHi, prec3tmp_limitLo, prec4tmp_warnHi, prec4tmp_warnLo, prec4tmp_limitHi, prec4tmp_limitLo, returnprs_warnHi, returnprs_warnLo, returnprs_limitHi, returnprs_limitLo, vaporprs_warnHi, vaporprs_warnLo, vaporprs_limitHi, vaporprs_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo2_LimitsConfigurationEvent));
        Hex_Cryo2_LimitsConfigurationEvent item_ = (Hex_Cryo2_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)c3exittmp_warnHi, (double)item_.getC3exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_warnLo, (double)item_.getC3exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitHi, (double)item_.getC3exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitLo, (double)item_.getC3exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnHi, (double)item_.getC4exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnLo, (double)item_.getC4exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitHi, (double)item_.getC4exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitLo, (double)item_.getC4exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnHi, (double)item_.getEvapexittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnLo, (double)item_.getEvapexittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitHi, (double)item_.getEvapexittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitLo, (double)item_.getEvapexittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnHi, (double)item_.getHexrtrntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnLo, (double)item_.getHexrtrntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitHi, (double)item_.getHexrtrntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitLo, (double)item_.getHexrtrntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnHi, (double)item_.getLiquidprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnLo, (double)item_.getLiquidprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitHi, (double)item_.getLiquidprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitLo, (double)item_.getLiquidprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnHi, (double)item_.getPrec3tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnLo, (double)item_.getPrec3tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitHi, (double)item_.getPrec3tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitLo, (double)item_.getPrec3tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnHi, (double)item_.getPrec4tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnLo, (double)item_.getPrec4tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitHi, (double)item_.getPrec4tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitLo, (double)item_.getPrec4tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnHi, (double)item_.getReturnprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnLo, (double)item_.getReturnprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitHi, (double)item_.getReturnprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitLo, (double)item_.getReturnprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnHi, (double)item_.getVaporprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnLo, (double)item_.getVaporprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitHi, (double)item_.getVaporprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitLo, (double)item_.getVaporprs_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo3_LimitsConfigurationEvent() throws Exception {
        String version = "v";
        double c3exittmp_warnHi = 0.6225319504737854;
        double c3exittmp_warnLo = 0.02865135669708252;
        double c3exittmp_limitHi = 0.20091331005096436;
        double c3exittmp_limitLo = 0.5535042881965637;
        double c4exittmp_warnHi = 0.216303288936615;
        double c4exittmp_warnLo = 0.33076733350753784;
        double c4exittmp_limitHi = 0.21007037162780762;
        double c4exittmp_limitLo = 0.8211714029312134;
        double evapexittmp_warnHi = 0.724603533744812;
        double evapexittmp_warnLo = 0.1649855375289917;
        double evapexittmp_limitHi = 0.524152934551239;
        double evapexittmp_limitLo = 0.1386559009552002;
        double hexrtrntmp_warnHi = 0.18888407945632935;
        double hexrtrntmp_warnLo = 0.746355f;
        double hexrtrntmp_limitHi = 0.6425913572311401;
        double hexrtrntmp_limitLo = 0.16918432712554932;
        double liquidprs_warnHi = 0.4212082624435425;
        double liquidprs_warnLo = 0.6034871339797974;
        double liquidprs_limitHi = 0.25848788022994995;
        double liquidprs_limitLo = 0.20617163181304932;
        double prec3tmp_warnHi = 0.6782745122909546;
        double prec3tmp_warnLo = 0.955681f;
        double prec3tmp_limitHi = 0.3962072f;
        double prec3tmp_limitLo = 0.5218521356582642;
        double prec4tmp_warnHi = 0.1899036169052124;
        double prec4tmp_warnLo = 0.4225732088088989;
        double prec4tmp_limitHi = 0.03787273168563843;
        double prec4tmp_limitLo = 0.3646594285964966;
        double returnprs_warnHi = 0.7142853140830994;
        double returnprs_warnLo = 0.8675350546836853;
        double returnprs_limitHi = 0.9096395373344421;
        double returnprs_limitLo = 0.3596722483634949;
        double vaporprs_warnHi = 0.4937942624092102;
        double vaporprs_warnLo = 0.1310117244720459;
        double vaporprs_limitHi = 0.12645351886749268;
        double vaporprs_limitLo = 0.0751606822013855;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cryo3_LimitsConfigurationEvent(version, c3exittmp_warnHi, c3exittmp_warnLo, c3exittmp_limitHi, c3exittmp_limitLo, c4exittmp_warnHi, c4exittmp_warnLo, c4exittmp_limitHi, c4exittmp_limitLo, evapexittmp_warnHi, evapexittmp_warnLo, evapexittmp_limitHi, evapexittmp_limitLo, hexrtrntmp_warnHi, hexrtrntmp_warnLo, hexrtrntmp_limitHi, hexrtrntmp_limitLo, liquidprs_warnHi, liquidprs_warnLo, liquidprs_limitHi, liquidprs_limitLo, prec3tmp_warnHi, prec3tmp_warnLo, prec3tmp_limitHi, prec3tmp_limitLo, prec4tmp_warnHi, prec4tmp_warnLo, prec4tmp_limitHi, prec4tmp_limitLo, returnprs_warnHi, returnprs_warnLo, returnprs_limitHi, returnprs_limitLo, vaporprs_warnHi, vaporprs_warnLo, vaporprs_limitHi, vaporprs_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo3_LimitsConfigurationEvent));
        Hex_Cryo3_LimitsConfigurationEvent item_ = (Hex_Cryo3_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)c3exittmp_warnHi, (double)item_.getC3exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_warnLo, (double)item_.getC3exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitHi, (double)item_.getC3exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitLo, (double)item_.getC3exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnHi, (double)item_.getC4exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnLo, (double)item_.getC4exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitHi, (double)item_.getC4exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitLo, (double)item_.getC4exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnHi, (double)item_.getEvapexittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnLo, (double)item_.getEvapexittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitHi, (double)item_.getEvapexittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitLo, (double)item_.getEvapexittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnHi, (double)item_.getHexrtrntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnLo, (double)item_.getHexrtrntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitHi, (double)item_.getHexrtrntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitLo, (double)item_.getHexrtrntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnHi, (double)item_.getLiquidprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnLo, (double)item_.getLiquidprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitHi, (double)item_.getLiquidprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitLo, (double)item_.getLiquidprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnHi, (double)item_.getPrec3tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnLo, (double)item_.getPrec3tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitHi, (double)item_.getPrec3tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitLo, (double)item_.getPrec3tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnHi, (double)item_.getPrec4tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnLo, (double)item_.getPrec4tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitHi, (double)item_.getPrec4tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitLo, (double)item_.getPrec4tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnHi, (double)item_.getReturnprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnLo, (double)item_.getReturnprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitHi, (double)item_.getReturnprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitLo, (double)item_.getReturnprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnHi, (double)item_.getVaporprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnLo, (double)item_.getVaporprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitHi, (double)item_.getVaporprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitLo, (double)item_.getVaporprs_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo4_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double c3exittmp_warnHi = 0.6396954655647278;
        double c3exittmp_warnLo = 0.8349857330322266;
        double c3exittmp_limitHi = 0.6537532806396484;
        double c3exittmp_limitLo = 0.41739994287490845;
        double c4exittmp_warnHi = 0.9492185115814209;
        double c4exittmp_warnLo = 0.1932897f;
        double c4exittmp_limitHi = 0.74419766664505;
        double c4exittmp_limitLo = 0.07167041301727295;
        double evapexittmp_warnHi = 0.5874601602554321;
        double evapexittmp_warnLo = 0.592810332775116;
        double evapexittmp_limitHi = 0.5374249219894409;
        double evapexittmp_limitLo = 0.67213f;
        double hexrtrntmp_warnHi = 0.5862097144126892;
        double hexrtrntmp_warnLo = 0.08965545892715454;
        double hexrtrntmp_limitHi = 0.7400966882705688;
        double hexrtrntmp_limitLo = 0.8178134560585022;
        double liquidprs_warnHi = 0.6225771307945251;
        double liquidprs_warnLo = 0.4591280221939087;
        double liquidprs_limitHi = 0.4945831894874573;
        double liquidprs_limitLo = 0.09346562623977661;
        double prec3tmp_warnHi = 0.11807596683502197;
        double prec3tmp_warnLo = 0.02763331f;
        double prec3tmp_limitHi = 0.9640874862670898;
        double prec3tmp_limitLo = 0.7953070998191833;
        double prec4tmp_warnHi = 0.17072665691375732;
        double prec4tmp_warnLo = 0.6420723795890808;
        double prec4tmp_limitHi = 0.8862138390541077;
        double prec4tmp_limitLo = 0.6513652205467224;
        double returnprs_warnHi = 0.10997647047042847;
        double returnprs_warnLo = 0.4971882104873657;
        double returnprs_limitHi = 0.4016244411468506;
        double returnprs_limitLo = 0.08052986860275269;
        double vaporprs_warnHi = 0.3799621f;
        double vaporprs_warnLo = 0.5101470947265625;
        double vaporprs_limitHi = 0.8836053609848022;
        double vaporprs_limitLo = 0.426071f;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cryo4_LimitsConfigurationEvent(version, c3exittmp_warnHi, c3exittmp_warnLo, c3exittmp_limitHi, c3exittmp_limitLo, c4exittmp_warnHi, c4exittmp_warnLo, c4exittmp_limitHi, c4exittmp_limitLo, evapexittmp_warnHi, evapexittmp_warnLo, evapexittmp_limitHi, evapexittmp_limitLo, hexrtrntmp_warnHi, hexrtrntmp_warnLo, hexrtrntmp_limitHi, hexrtrntmp_limitLo, liquidprs_warnHi, liquidprs_warnLo, liquidprs_limitHi, liquidprs_limitLo, prec3tmp_warnHi, prec3tmp_warnLo, prec3tmp_limitHi, prec3tmp_limitLo, prec4tmp_warnHi, prec4tmp_warnLo, prec4tmp_limitHi, prec4tmp_limitLo, returnprs_warnHi, returnprs_warnLo, returnprs_limitHi, returnprs_limitLo, vaporprs_warnHi, vaporprs_warnLo, vaporprs_limitHi, vaporprs_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo4_LimitsConfigurationEvent));
        Hex_Cryo4_LimitsConfigurationEvent item_ = (Hex_Cryo4_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)c3exittmp_warnHi, (double)item_.getC3exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_warnLo, (double)item_.getC3exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitHi, (double)item_.getC3exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitLo, (double)item_.getC3exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnHi, (double)item_.getC4exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnLo, (double)item_.getC4exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitHi, (double)item_.getC4exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitLo, (double)item_.getC4exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnHi, (double)item_.getEvapexittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnLo, (double)item_.getEvapexittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitHi, (double)item_.getEvapexittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitLo, (double)item_.getEvapexittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnHi, (double)item_.getHexrtrntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnLo, (double)item_.getHexrtrntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitHi, (double)item_.getHexrtrntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitLo, (double)item_.getHexrtrntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnHi, (double)item_.getLiquidprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnLo, (double)item_.getLiquidprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitHi, (double)item_.getLiquidprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitLo, (double)item_.getLiquidprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnHi, (double)item_.getPrec3tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnLo, (double)item_.getPrec3tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitHi, (double)item_.getPrec3tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitLo, (double)item_.getPrec3tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnHi, (double)item_.getPrec4tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnLo, (double)item_.getPrec4tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitHi, (double)item_.getPrec4tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitLo, (double)item_.getPrec4tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnHi, (double)item_.getReturnprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnLo, (double)item_.getReturnprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitHi, (double)item_.getReturnprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitLo, (double)item_.getReturnprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnHi, (double)item_.getVaporprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnLo, (double)item_.getVaporprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitHi, (double)item_.getVaporprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitLo, (double)item_.getVaporprs_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo5_LimitsConfigurationEvent() throws Exception {
        String version = "z";
        double c3exittmp_warnHi = 0.0295704f;
        double c3exittmp_warnLo = 0.8567120432853699;
        double c3exittmp_limitHi = 0.703027f;
        double c3exittmp_limitLo = 0.11930537223815918;
        double c4exittmp_warnHi = 0.7800835967063904;
        double c4exittmp_warnLo = 0.9634101986885071;
        double c4exittmp_limitHi = 0.6401426196098328;
        double c4exittmp_limitLo = 0.00840681791305542;
        double evapexittmp_warnHi = 0.5613293051719666;
        double evapexittmp_warnLo = 0.3452872633934021;
        double evapexittmp_limitHi = 0.6132214665412903;
        double evapexittmp_limitLo = 0.452708f;
        double hexrtrntmp_warnHi = 0.2126712203025818;
        double hexrtrntmp_warnLo = 0.9168487787246704;
        double hexrtrntmp_limitHi = 0.2955929f;
        double hexrtrntmp_limitLo = 0.4381973147392273;
        double liquidprs_warnHi = 0.7747090458869934;
        double liquidprs_warnLo = 0.1645141839981079;
        double liquidprs_limitHi = 0.296500027179718;
        double liquidprs_limitLo = 0.3348594903945923;
        double prec3tmp_warnHi = 0.04089456796646118;
        double prec3tmp_warnLo = 0.9079667925834656;
        double prec3tmp_limitHi = 0.26252996921539307;
        double prec3tmp_limitLo = 0.7911467552185059;
        double prec4tmp_warnHi = 0.5862413048744202;
        double prec4tmp_warnLo = 0.19596493244171143;
        double prec4tmp_limitHi = 0.6517412066459656;
        double prec4tmp_limitLo = 0.8109247088432312;
        double returnprs_warnHi = 0.5020307898521423;
        double returnprs_warnLo = 0.09269309043884277;
        double returnprs_limitHi = 0.7096713781356812;
        double returnprs_limitLo = 0.4633186459541321;
        double vaporprs_warnHi = 0.610880970954895;
        double vaporprs_warnLo = 0.2357664704322815;
        double vaporprs_limitHi = 0.8266355991363525;
        double vaporprs_limitLo = 0.8923792243003845;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cryo5_LimitsConfigurationEvent(version, c3exittmp_warnHi, c3exittmp_warnLo, c3exittmp_limitHi, c3exittmp_limitLo, c4exittmp_warnHi, c4exittmp_warnLo, c4exittmp_limitHi, c4exittmp_limitLo, evapexittmp_warnHi, evapexittmp_warnLo, evapexittmp_limitHi, evapexittmp_limitLo, hexrtrntmp_warnHi, hexrtrntmp_warnLo, hexrtrntmp_limitHi, hexrtrntmp_limitLo, liquidprs_warnHi, liquidprs_warnLo, liquidprs_limitHi, liquidprs_limitLo, prec3tmp_warnHi, prec3tmp_warnLo, prec3tmp_limitHi, prec3tmp_limitLo, prec4tmp_warnHi, prec4tmp_warnLo, prec4tmp_limitHi, prec4tmp_limitLo, returnprs_warnHi, returnprs_warnLo, returnprs_limitHi, returnprs_limitLo, vaporprs_warnHi, vaporprs_warnLo, vaporprs_limitHi, vaporprs_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo5_LimitsConfigurationEvent));
        Hex_Cryo5_LimitsConfigurationEvent item_ = (Hex_Cryo5_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)c3exittmp_warnHi, (double)item_.getC3exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_warnLo, (double)item_.getC3exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitHi, (double)item_.getC3exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitLo, (double)item_.getC3exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnHi, (double)item_.getC4exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnLo, (double)item_.getC4exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitHi, (double)item_.getC4exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitLo, (double)item_.getC4exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnHi, (double)item_.getEvapexittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnLo, (double)item_.getEvapexittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitHi, (double)item_.getEvapexittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitLo, (double)item_.getEvapexittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnHi, (double)item_.getHexrtrntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnLo, (double)item_.getHexrtrntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitHi, (double)item_.getHexrtrntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitLo, (double)item_.getHexrtrntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnHi, (double)item_.getLiquidprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnLo, (double)item_.getLiquidprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitHi, (double)item_.getLiquidprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitLo, (double)item_.getLiquidprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnHi, (double)item_.getPrec3tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnLo, (double)item_.getPrec3tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitHi, (double)item_.getPrec3tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitLo, (double)item_.getPrec3tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnHi, (double)item_.getPrec4tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnLo, (double)item_.getPrec4tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitHi, (double)item_.getPrec4tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitLo, (double)item_.getPrec4tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnHi, (double)item_.getReturnprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnLo, (double)item_.getReturnprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitHi, (double)item_.getReturnprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitLo, (double)item_.getReturnprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnHi, (double)item_.getVaporprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnLo, (double)item_.getVaporprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitHi, (double)item_.getVaporprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitLo, (double)item_.getVaporprs_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo6_LimitsConfigurationEvent() throws Exception {
        String version = "z";
        double c3exittmp_warnHi = 0.02032071352005005;
        double c3exittmp_warnLo = 0.1448100209236145;
        double c3exittmp_limitHi = 0.6774519681930542;
        double c3exittmp_limitLo = 0.9350197315216064;
        double c4exittmp_warnHi = 0.8183979392051697;
        double c4exittmp_warnLo = 0.9617493748664856;
        double c4exittmp_limitHi = 0.3929516673088074;
        double c4exittmp_limitLo = 0.8882981538772583;
        double evapexittmp_warnHi = 0.9426085352897644;
        double evapexittmp_warnLo = 0.2420047f;
        double evapexittmp_limitHi = 0.6579023599624634;
        double evapexittmp_limitLo = 0.792611f;
        double hexrtrntmp_warnHi = 0.3765166401863098;
        double hexrtrntmp_warnLo = 0.8020473122596741;
        double hexrtrntmp_limitHi = 0.3539528250694275;
        double hexrtrntmp_limitLo = 0.8028817176818848;
        double liquidprs_warnHi = 0.17002063989639282;
        double liquidprs_warnLo = 0.2709732f;
        double liquidprs_limitHi = 0.012377262115478516;
        double liquidprs_limitLo = 0.2536681294441223;
        double prec3tmp_warnHi = 0.5590114593505859;
        double prec3tmp_warnLo = 0.17061054706573486;
        double prec3tmp_limitHi = 0.13917946815490723;
        double prec3tmp_limitLo = 0.6210432052612305;
        double prec4tmp_warnHi = 0.10065692663192749;
        double prec4tmp_warnLo = 0.1617475152015686;
        double prec4tmp_limitHi = 0.6523122191429138;
        double prec4tmp_limitLo = 0.2882046699523926;
        double returnprs_warnHi = 0.8141778707504272;
        double returnprs_warnLo = 0.0724054f;
        double returnprs_limitHi = 0.9226796627044678;
        double returnprs_limitLo = 0.055135905742645264;
        double vaporprs_warnHi = 0.12229812145233154;
        double vaporprs_warnLo = 0.16417354345321655;
        double vaporprs_limitHi = 0.0801962f;
        double vaporprs_limitLo = 0.17703211307525635;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cryo6_LimitsConfigurationEvent(version, c3exittmp_warnHi, c3exittmp_warnLo, c3exittmp_limitHi, c3exittmp_limitLo, c4exittmp_warnHi, c4exittmp_warnLo, c4exittmp_limitHi, c4exittmp_limitLo, evapexittmp_warnHi, evapexittmp_warnLo, evapexittmp_limitHi, evapexittmp_limitLo, hexrtrntmp_warnHi, hexrtrntmp_warnLo, hexrtrntmp_limitHi, hexrtrntmp_limitLo, liquidprs_warnHi, liquidprs_warnLo, liquidprs_limitHi, liquidprs_limitLo, prec3tmp_warnHi, prec3tmp_warnLo, prec3tmp_limitHi, prec3tmp_limitLo, prec4tmp_warnHi, prec4tmp_warnLo, prec4tmp_limitHi, prec4tmp_limitLo, returnprs_warnHi, returnprs_warnLo, returnprs_limitHi, returnprs_limitLo, vaporprs_warnHi, vaporprs_warnLo, vaporprs_limitHi, vaporprs_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo6_LimitsConfigurationEvent));
        Hex_Cryo6_LimitsConfigurationEvent item_ = (Hex_Cryo6_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)c3exittmp_warnHi, (double)item_.getC3exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_warnLo, (double)item_.getC3exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitHi, (double)item_.getC3exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitLo, (double)item_.getC3exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnHi, (double)item_.getC4exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnLo, (double)item_.getC4exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitHi, (double)item_.getC4exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitLo, (double)item_.getC4exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnHi, (double)item_.getEvapexittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnLo, (double)item_.getEvapexittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitHi, (double)item_.getEvapexittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitLo, (double)item_.getEvapexittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnHi, (double)item_.getHexrtrntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnLo, (double)item_.getHexrtrntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitHi, (double)item_.getHexrtrntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitLo, (double)item_.getHexrtrntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnHi, (double)item_.getLiquidprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnLo, (double)item_.getLiquidprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitHi, (double)item_.getLiquidprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitLo, (double)item_.getLiquidprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnHi, (double)item_.getPrec3tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnLo, (double)item_.getPrec3tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitHi, (double)item_.getPrec3tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitLo, (double)item_.getPrec3tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnHi, (double)item_.getPrec4tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnLo, (double)item_.getPrec4tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitHi, (double)item_.getPrec4tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitLo, (double)item_.getPrec4tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnHi, (double)item_.getReturnprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnLo, (double)item_.getReturnprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitHi, (double)item_.getReturnprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitLo, (double)item_.getReturnprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnHi, (double)item_.getVaporprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnLo, (double)item_.getVaporprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitHi, (double)item_.getVaporprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitLo, (double)item_.getVaporprs_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_GeneralConfigurationEvent() throws Exception {
        String version = "";
        double lowCryoTempLimit = 0.404455304145813;
        double rtnToEvapOffset = 0.9292687773704529;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_GeneralConfigurationEvent(version, lowCryoTempLimit, rtnToEvapOffset));
        Assert.assertTrue((boolean)(item instanceof Hex_GeneralConfigurationEvent));
        Hex_GeneralConfigurationEvent item_ = (Hex_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)lowCryoTempLimit, (double)item_.getLowCryoTempLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)rtnToEvapOffset, (double)item_.getRtnToEvapOffset(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Maq20_DeviceConfigurationEvent() throws Exception {
        String version = "j";
        String node = "k";
        String serials = "d";
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Maq20_DeviceConfigurationEvent(version, node, serials));
        Assert.assertTrue((boolean)(item instanceof Hex_Maq20_DeviceConfigurationEvent));
        Hex_Maq20_DeviceConfigurationEvent item_ = (Hex_Maq20_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)node, (Object)item_.getNode());
        Assert.assertEquals((Object)serials, (Object)item_.getSerials());
    }

    @Test
    public void sendReceiveHex_Maq20_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Maq20_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Hex_Maq20_DevicesConfigurationEvent));
        Hex_Maq20_DevicesConfigurationEvent item_ = (Hex_Maq20_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveHex_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "k";
        int schedulers_default_nTasks = 703;
        int schedulers_default_nThreads = 600;
        int schedulers_monitor_update_publish_scheduler_nTasks = 578;
        int schedulers_monitor_update_publish_scheduler_nThreads = 708;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Hex_PeriodicTasks_GeneralConfigurationEvent));
        Hex_PeriodicTasks_GeneralConfigurationEvent item_ = (Hex_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveHex_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "m";
        long agentmonitorservice_taskPeriodMillis = 762L;
        long heartbeat_taskPeriodMillis = 272L;
        long hex_state_taskPeriodMillis = 592L;
        long monitor_check_taskPeriodMillis = 79L;
        long monitor_publish_taskPeriodMillis = 479L;
        long monitor_update_taskPeriodMillis = 673L;
        long runtimeinfo_taskPeriodMillis = 52L;
        long temp_check_taskPeriodMillis = 308L;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, hex_state_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, runtimeinfo_taskPeriodMillis, temp_check_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Hex_PeriodicTasks_timersConfigurationEvent));
        Hex_PeriodicTasks_timersConfigurationEvent item_ = (Hex_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)hex_state_taskPeriodMillis, (long)item_.getHex_state_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
        Assert.assertEquals((long)temp_check_taskPeriodMillis, (long)item_.getTemp_check_taskPeriodMillis());
    }

    @Test
    public void sendReceiveHex_StatusAggregator_GeneralConfigurationEvent() throws Exception {
        String version = "r";
        String patternConfigList = "";
        SALEvent item = this.testSendReceive((SALEvent)new Hex_StatusAggregator_GeneralConfigurationEvent(version, patternConfigList));
        Assert.assertTrue((boolean)(item instanceof Hex_StatusAggregator_GeneralConfigurationEvent));
        Hex_StatusAggregator_GeneralConfigurationEvent item_ = (Hex_StatusAggregator_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)patternConfigList, (Object)item_.getPatternConfigList());
    }

    @Test
    public void sendReceiveRefrig_Cryo1_DeviceConfigurationEvent() throws Exception {
        String version = "d";
        String maq20_node = "z";
        String maq20_serials = "";
        String plc_node = "z";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo1_DeviceConfigurationEvent(version, maq20_node, maq20_serials, plc_node));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo1_DeviceConfigurationEvent));
        Refrig_Cryo1_DeviceConfigurationEvent item_ = (Refrig_Cryo1_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
    }

    @Test
    public void sendReceiveRefrig_Cryo1_DevicesConfigurationEvent() throws Exception {
        String version = "y";
        boolean maq20_disabled = false;
        boolean plc_disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo1_DevicesConfigurationEvent(version, maq20_disabled, plc_disabled));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo1_DevicesConfigurationEvent));
        Refrig_Cryo1_DevicesConfigurationEvent item_ = (Refrig_Cryo1_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_disabled, (Object)item_.isMaq20_disabled());
        Assert.assertEquals((Object)plc_disabled, (Object)item_.isPlc_disabled());
    }

    @Test
    public void sendReceiveRefrig_Cryo1_LimitsConfigurationEvent() throws Exception {
        String version = "q";
        double aftercooltmp_warnHi = 0.7489414215087891;
        double aftercooltmp_warnLo = 0.9759699106216431;
        double aftercooltmp_limitHi = 0.6229037642478943;
        double aftercooltmp_limitLo = 0.655523f;
        double compcurrent_warnHi = 0.27287375926971436;
        double compcurrent_warnLo = 0.24761521816253662;
        double compcurrent_limitHi = 0.804999589920044;
        double compcurrent_limitLo = 0.7068792581558228;
        double comppower_warnHi = 0.23437517881393433;
        double comppower_warnLo = 0.8339337110519409;
        double comppower_limitHi = 0.4058322310447693;
        double comppower_limitLo = 0.15907102823257446;
        double compvoltage_warnHi = 0.5351780652999878;
        double compvoltage_warnLo = 0.13439089059829712;
        double compvoltage_limitHi = 0.6852855086326599;
        double compvoltage_limitLo = 0.2801274061203003;
        double dischrgprs_warnHi = 0.285383403301239;
        double dischrgprs_warnLo = 0.626501202583313;
        double dischrgprs_limitHi = 0.999459f;
        double dischrgprs_limitLo = 0.9808174967765808;
        double dischrgtmp_M_warnHi = 0.8505963683128357;
        double dischrgtmp_M_warnLo = 0.8351826071739197;
        double dischrgtmp_M_limitHi = 0.7829119563102722;
        double dischrgtmp_M_limitLo = 0.9551782011985779;
        double dischrgtmp_P_warnHi = 0.8803683519363403;
        double dischrgtmp_P_warnLo = 0.9467967748641968;
        double dischrgtmp_P_limitHi = 0.05507081747055054;
        double dischrgtmp_P_limitLo = 0.37750154733657837;
        double fanspeed_warnHi = 0.32929152250289917;
        double fanspeed_warnLo = 0.6068287491798401;
        double fanspeed_limitHi = 0.19070512056350708;
        double fanspeed_limitLo = 0.9657025337219238;
        double oillevel_warnHi = 0.811535120010376;
        double oillevel_warnLo = 0.839469f;
        double oillevel_limitHi = 0.6548264026641846;
        double oillevel_limitLo = 0.3849772810935974;
        double oilseptmp_warnHi = 0.2369445562362671;
        double oilseptmp_warnLo = 0.060768187046051025;
        double oilseptmp_limitHi = 0.947840690612793;
        double oilseptmp_limitLo = 0.9907975792884827;
        double phaseseptmp_warnHi = 0.3677181005477905;
        double phaseseptmp_warnLo = 0.1419163942337036;
        double phaseseptmp_limitHi = 0.23200958967208862;
        double phaseseptmp_limitLo = 0.621763288974762;
        double suctionprs_warnHi = 0.1554107666015625;
        double suctionprs_warnLo = 0.5610649585723877;
        double suctionprs_limitHi = 0.37559783458709717;
        double suctionprs_limitLo = 0.32896852493286133;
        double suctiontmp_M_warnHi = 0.8055156469345093;
        double suctiontmp_M_warnLo = 0.08459645509719849;
        double suctiontmp_M_limitHi = 0.33248448371887207;
        double suctiontmp_M_limitLo = 0.5507811307907104;
        double suctiontmp_P_warnHi = 0.9486668705940247;
        double suctiontmp_P_warnLo = 0.6936050653457642;
        double suctiontmp_P_limitHi = 0.5140964984893799;
        double suctiontmp_P_limitLo = 0.7448531985282898;
        double surgetanktmp_warnHi = 0.941771388053894;
        double surgetanktmp_warnLo = 0.7484720349311829;
        double surgetanktmp_limitHi = 0.7645028829574585;
        double surgetanktmp_limitLo = 0.010468602180480957;
        double waterintmp_warnHi = 0.6878884434700012;
        double waterintmp_warnLo = 0.6218031644821167;
        double waterintmp_limitHi = 0.6412501335144043;
        double waterintmp_limitLo = 0.8648171424865723;
        double waterouttmp_warnHi = 0.8498541712760925;
        double waterouttmp_warnLo = 0.26377958059310913;
        double waterouttmp_limitHi = 0.3724910616874695;
        double waterouttmp_limitLo = 0.37040263414382935;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo1_LimitsConfigurationEvent(version, aftercooltmp_warnHi, aftercooltmp_warnLo, aftercooltmp_limitHi, aftercooltmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fanspeed_warnHi, fanspeed_warnLo, fanspeed_limitHi, fanspeed_limitLo, oillevel_warnHi, oillevel_warnLo, oillevel_limitHi, oillevel_limitLo, oilseptmp_warnHi, oilseptmp_warnLo, oilseptmp_limitHi, oilseptmp_limitLo, phaseseptmp_warnHi, phaseseptmp_warnLo, phaseseptmp_limitHi, phaseseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, surgetanktmp_warnHi, surgetanktmp_warnLo, surgetanktmp_limitHi, surgetanktmp_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo1_LimitsConfigurationEvent));
        Refrig_Cryo1_LimitsConfigurationEvent item_ = (Refrig_Cryo1_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)aftercooltmp_warnHi, (double)item_.getAftercooltmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_warnLo, (double)item_.getAftercooltmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitHi, (double)item_.getAftercooltmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitLo, (double)item_.getAftercooltmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnHi, (double)item_.getFanspeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnLo, (double)item_.getFanspeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitHi, (double)item_.getFanspeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitLo, (double)item_.getFanspeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnHi, (double)item_.getOillevel_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnLo, (double)item_.getOillevel_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitHi, (double)item_.getOillevel_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitLo, (double)item_.getOillevel_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnHi, (double)item_.getOilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnLo, (double)item_.getOilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitHi, (double)item_.getOilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitLo, (double)item_.getOilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnHi, (double)item_.getPhaseseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnLo, (double)item_.getPhaseseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitHi, (double)item_.getPhaseseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitLo, (double)item_.getPhaseseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnHi, (double)item_.getSurgetanktmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnLo, (double)item_.getSurgetanktmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitHi, (double)item_.getSurgetanktmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitLo, (double)item_.getSurgetanktmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo2_DeviceConfigurationEvent() throws Exception {
        String version = "";
        String maq20_node = "k";
        String maq20_serials = "o";
        String plc_node = "i";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo2_DeviceConfigurationEvent(version, maq20_node, maq20_serials, plc_node));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo2_DeviceConfigurationEvent));
        Refrig_Cryo2_DeviceConfigurationEvent item_ = (Refrig_Cryo2_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
    }

    @Test
    public void sendReceiveRefrig_Cryo2_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean maq20_disabled = true;
        boolean plc_disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo2_DevicesConfigurationEvent(version, maq20_disabled, plc_disabled));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo2_DevicesConfigurationEvent));
        Refrig_Cryo2_DevicesConfigurationEvent item_ = (Refrig_Cryo2_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_disabled, (Object)item_.isMaq20_disabled());
        Assert.assertEquals((Object)plc_disabled, (Object)item_.isPlc_disabled());
    }

    @Test
    public void sendReceiveRefrig_Cryo2_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double aftercooltmp_warnHi = 0.885668f;
        double aftercooltmp_warnLo = 0.4787197709083557;
        double aftercooltmp_limitHi = 0.7090548872947693;
        double aftercooltmp_limitLo = 0.5793200731277466;
        double compcurrent_warnHi = 0.5293838381767273;
        double compcurrent_warnLo = 0.0858263373374939;
        double compcurrent_limitHi = 0.8258102536201477;
        double compcurrent_limitLo = 0.0721203088760376;
        double comppower_warnHi = 0.2859575152397156;
        double comppower_warnLo = 0.12554824352264404;
        double comppower_limitHi = 0.4413476586341858;
        double comppower_limitLo = 0.3928038477897644;
        double compvoltage_warnHi = 0.1249426007270813;
        double compvoltage_warnLo = 0.6870742440223694;
        double compvoltage_limitHi = 0.6962341070175171;
        double compvoltage_limitLo = 0.02819424867630005;
        double dischrgprs_warnHi = 0.07759493589401245;
        double dischrgprs_warnLo = 0.2796071767807007;
        double dischrgprs_limitHi = 0.25997406244277954;
        double dischrgprs_limitLo = 0.21378272771835327;
        double dischrgtmp_M_warnHi = 0.7095667123794556;
        double dischrgtmp_M_warnLo = 0.2569117546081543;
        double dischrgtmp_M_limitHi = 0.8244872093200684;
        double dischrgtmp_M_limitLo = 0.5943259000778198;
        double dischrgtmp_P_warnHi = 0.4248991012573242;
        double dischrgtmp_P_warnLo = 0.5343916416168213;
        double dischrgtmp_P_limitHi = 0.7275944948196411;
        double dischrgtmp_P_limitLo = 0.8179831504821777;
        double fanspeed_warnHi = 0.7096013426780701;
        double fanspeed_warnLo = 0.2837026119232178;
        double fanspeed_limitHi = 0.7916221618652344;
        double fanspeed_limitLo = 0.10853838920593262;
        double oillevel_warnHi = 0.6353712677955627;
        double oillevel_warnLo = 0.8158840537071228;
        double oillevel_limitHi = 0.15866601467132568;
        double oillevel_limitLo = 0.58169f;
        double oilseptmp_warnHi = 0.9305132627487183;
        double oilseptmp_warnLo = 0.49988818168640137;
        double oilseptmp_limitHi = 0.9259874224662781;
        double oilseptmp_limitLo = 0.7411353588104248;
        double phaseseptmp_warnHi = 0.370410680770874;
        double phaseseptmp_warnLo = 0.4273747205734253;
        double phaseseptmp_limitHi = 0.11232644319534302;
        double phaseseptmp_limitLo = 0.11544859409332275;
        double suctionprs_warnHi = 0.531707f;
        double suctionprs_warnLo = 0.3855026960372925;
        double suctionprs_limitHi = 0.12662345170974731;
        double suctionprs_limitLo = 0.55040442943573;
        double suctiontmp_M_warnHi = 0.4334644079208374;
        double suctiontmp_M_warnLo = 0.18660622835159302;
        double suctiontmp_M_limitHi = 0.7508691549301147;
        double suctiontmp_M_limitLo = 0.941911518573761;
        double suctiontmp_P_warnHi = 0.798945963382721;
        double suctiontmp_P_warnLo = 0.3171289563179016;
        double suctiontmp_P_limitHi = 0.3028132915496826;
        double suctiontmp_P_limitLo = 0.6361914873123169;
        double surgetanktmp_warnHi = 0.610375702381134;
        double surgetanktmp_warnLo = 0.38867151737213135;
        double surgetanktmp_limitHi = 0.3044389f;
        double surgetanktmp_limitLo = 0.8059951663017273;
        double waterintmp_warnHi = 0.996269166469574;
        double waterintmp_warnLo = 0.8227730989456177;
        double waterintmp_limitHi = 0.6689545512199402;
        double waterintmp_limitLo = 0.5698431730270386;
        double waterouttmp_warnHi = 0.9400115013122559;
        double waterouttmp_warnLo = 0.2900077f;
        double waterouttmp_limitHi = 0.23121285438537598;
        double waterouttmp_limitLo = 0.706488f;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo2_LimitsConfigurationEvent(version, aftercooltmp_warnHi, aftercooltmp_warnLo, aftercooltmp_limitHi, aftercooltmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fanspeed_warnHi, fanspeed_warnLo, fanspeed_limitHi, fanspeed_limitLo, oillevel_warnHi, oillevel_warnLo, oillevel_limitHi, oillevel_limitLo, oilseptmp_warnHi, oilseptmp_warnLo, oilseptmp_limitHi, oilseptmp_limitLo, phaseseptmp_warnHi, phaseseptmp_warnLo, phaseseptmp_limitHi, phaseseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, surgetanktmp_warnHi, surgetanktmp_warnLo, surgetanktmp_limitHi, surgetanktmp_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo2_LimitsConfigurationEvent));
        Refrig_Cryo2_LimitsConfigurationEvent item_ = (Refrig_Cryo2_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)aftercooltmp_warnHi, (double)item_.getAftercooltmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_warnLo, (double)item_.getAftercooltmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitHi, (double)item_.getAftercooltmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitLo, (double)item_.getAftercooltmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnHi, (double)item_.getFanspeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnLo, (double)item_.getFanspeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitHi, (double)item_.getFanspeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitLo, (double)item_.getFanspeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnHi, (double)item_.getOillevel_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnLo, (double)item_.getOillevel_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitHi, (double)item_.getOillevel_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitLo, (double)item_.getOillevel_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnHi, (double)item_.getOilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnLo, (double)item_.getOilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitHi, (double)item_.getOilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitLo, (double)item_.getOilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnHi, (double)item_.getPhaseseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnLo, (double)item_.getPhaseseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitHi, (double)item_.getPhaseseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitLo, (double)item_.getPhaseseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnHi, (double)item_.getSurgetanktmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnLo, (double)item_.getSurgetanktmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitHi, (double)item_.getSurgetanktmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitLo, (double)item_.getSurgetanktmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo3_DeviceConfigurationEvent() throws Exception {
        String version = "r";
        String maq20_node = "u";
        String maq20_serials = "";
        String plc_node = "";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo3_DeviceConfigurationEvent(version, maq20_node, maq20_serials, plc_node));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo3_DeviceConfigurationEvent));
        Refrig_Cryo3_DeviceConfigurationEvent item_ = (Refrig_Cryo3_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
    }

    @Test
    public void sendReceiveRefrig_Cryo3_DevicesConfigurationEvent() throws Exception {
        String version = "g";
        boolean maq20_disabled = false;
        boolean plc_disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo3_DevicesConfigurationEvent(version, maq20_disabled, plc_disabled));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo3_DevicesConfigurationEvent));
        Refrig_Cryo3_DevicesConfigurationEvent item_ = (Refrig_Cryo3_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_disabled, (Object)item_.isMaq20_disabled());
        Assert.assertEquals((Object)plc_disabled, (Object)item_.isPlc_disabled());
    }

    @Test
    public void sendReceiveRefrig_Cryo3_LimitsConfigurationEvent() throws Exception {
        String version = "g";
        double aftercooltmp_warnHi = 0.830807626247406;
        double aftercooltmp_warnLo = 0.10707056522369385;
        double aftercooltmp_limitHi = 0.9210320711135864;
        double aftercooltmp_limitLo = 0.1554531455039978;
        double ambienttmp_warnHi = 0.09999215602874756;
        double ambienttmp_warnLo = 0.1573919f;
        double ambienttmp_limitHi = 0.895658016204834;
        double ambienttmp_limitLo = 0.2465330958366394;
        double cabinettmp_warnHi = 0.11442923545837402;
        double cabinettmp_warnLo = 0.4659762978553772;
        double cabinettmp_limitHi = 0.8361278176307678;
        double cabinettmp_limitLo = 0.00861752f;
        double compcurrent_warnHi = 0.975890040397644;
        double compcurrent_warnLo = 0.511019766330719;
        double compcurrent_limitHi = 0.06850481033325195;
        double compcurrent_limitLo = 0.8819335699081421;
        double comppower_warnHi = 0.5103369355201721;
        double comppower_warnLo = 0.5715826153755188;
        double comppower_limitHi = 0.8169936537742615;
        double comppower_limitLo = 0.1390208601951599;
        double compvoltage_warnHi = 0.779719f;
        double compvoltage_warnLo = 0.9887209534645081;
        double compvoltage_limitHi = 0.277072012424469;
        double compvoltage_limitLo = 0.915184736251831;
        double dischrgprs_warnHi = 0.538340151309967;
        double dischrgprs_warnLo = 0.42300945520401;
        double dischrgprs_limitHi = 0.6953703761100769;
        double dischrgprs_limitLo = 0.9652260541915894;
        double dischrgtmp_M_warnHi = 0.14212846755981445;
        double dischrgtmp_M_warnLo = 0.733724f;
        double dischrgtmp_M_limitHi = 0.6471393704414368;
        double dischrgtmp_M_limitLo = 0.9887987971305847;
        double dischrgtmp_P_warnHi = 0.9968788623809814;
        double dischrgtmp_P_warnLo = 0.8430869579315186;
        double dischrgtmp_P_limitHi = 0.3988179f;
        double dischrgtmp_P_limitLo = 0.4897953271865845;
        double fanspeed_warnHi = 0.26867908239364624;
        double fanspeed_warnLo = 0.8790637850761414;
        double fanspeed_limitHi = 0.2067958116531372;
        double fanspeed_limitLo = 0.8197957873344421;
        double oillevel_warnHi = 0.5233194828033447;
        double oillevel_warnLo = 0.4429087f;
        double oillevel_limitHi = 0.07633805274963379;
        double oillevel_limitLo = 0.021564245223999023;
        double oilseptmp_warnHi = 0.1617315411567688;
        double oilseptmp_warnLo = 0.0942736268043518;
        double oilseptmp_limitHi = 0.15730106830596924;
        double oilseptmp_limitLo = 0.3211820721626282;
        double phaseseptmp_warnHi = 0.87872f;
        double phaseseptmp_warnLo = 0.04913193f;
        double phaseseptmp_limitHi = 0.9343748688697815;
        double phaseseptmp_limitLo = 0.11765807867050171;
        double suctionprs_warnHi = 0.9988874793052673;
        double suctionprs_warnLo = 0.7465725541114807;
        double suctionprs_limitHi = 0.3558666706085205;
        double suctionprs_limitLo = 0.3533428907394409;
        double suctiontmp_M_warnHi = 0.996278703212738;
        double suctiontmp_M_warnLo = 0.8528434634208679;
        double suctiontmp_M_limitHi = 0.291401743888855;
        double suctiontmp_M_limitLo = 0.4994316101074219;
        double suctiontmp_P_warnHi = 0.04557693004608154;
        double suctiontmp_P_warnLo = 0.5686679482460022;
        double suctiontmp_P_limitHi = 0.2983502149581909;
        double suctiontmp_P_limitLo = 0.6061123609542847;
        double surgetanktmp_warnHi = 0.2985035181045532;
        double surgetanktmp_warnLo = 0.813226f;
        double surgetanktmp_limitHi = 0.7704379558563232;
        double surgetanktmp_limitLo = 0.009990692138671875;
        double waterintmp_warnHi = 0.14833104610443115;
        double waterintmp_warnLo = 0.14033353328704834;
        double waterintmp_limitHi = 0.6291144490242004;
        double waterintmp_limitLo = 0.19138479232788086;
        double waterouttmp_warnHi = 0.910206f;
        double waterouttmp_warnLo = 0.6549215912818909;
        double waterouttmp_limitHi = 0.8662184476852417;
        double waterouttmp_limitLo = 0.7756784558296204;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo3_LimitsConfigurationEvent(version, aftercooltmp_warnHi, aftercooltmp_warnLo, aftercooltmp_limitHi, aftercooltmp_limitLo, ambienttmp_warnHi, ambienttmp_warnLo, ambienttmp_limitHi, ambienttmp_limitLo, cabinettmp_warnHi, cabinettmp_warnLo, cabinettmp_limitHi, cabinettmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fanspeed_warnHi, fanspeed_warnLo, fanspeed_limitHi, fanspeed_limitLo, oillevel_warnHi, oillevel_warnLo, oillevel_limitHi, oillevel_limitLo, oilseptmp_warnHi, oilseptmp_warnLo, oilseptmp_limitHi, oilseptmp_limitLo, phaseseptmp_warnHi, phaseseptmp_warnLo, phaseseptmp_limitHi, phaseseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, surgetanktmp_warnHi, surgetanktmp_warnLo, surgetanktmp_limitHi, surgetanktmp_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo3_LimitsConfigurationEvent));
        Refrig_Cryo3_LimitsConfigurationEvent item_ = (Refrig_Cryo3_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)aftercooltmp_warnHi, (double)item_.getAftercooltmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_warnLo, (double)item_.getAftercooltmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitHi, (double)item_.getAftercooltmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitLo, (double)item_.getAftercooltmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_warnHi, (double)item_.getAmbienttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_warnLo, (double)item_.getAmbienttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitHi, (double)item_.getAmbienttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitLo, (double)item_.getAmbienttmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnHi, (double)item_.getCabinettmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnLo, (double)item_.getCabinettmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitHi, (double)item_.getCabinettmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitLo, (double)item_.getCabinettmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnHi, (double)item_.getFanspeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnLo, (double)item_.getFanspeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitHi, (double)item_.getFanspeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitLo, (double)item_.getFanspeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnHi, (double)item_.getOillevel_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnLo, (double)item_.getOillevel_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitHi, (double)item_.getOillevel_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitLo, (double)item_.getOillevel_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnHi, (double)item_.getOilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnLo, (double)item_.getOilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitHi, (double)item_.getOilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitLo, (double)item_.getOilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnHi, (double)item_.getPhaseseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnLo, (double)item_.getPhaseseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitHi, (double)item_.getPhaseseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitLo, (double)item_.getPhaseseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnHi, (double)item_.getSurgetanktmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnLo, (double)item_.getSurgetanktmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitHi, (double)item_.getSurgetanktmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitLo, (double)item_.getSurgetanktmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo3_PicConfigurationEvent() throws Exception {
        String version = "m";
        double fanctrl_awGain = 0.3508124351501465;
        double fanctrl_baseDuty = 0.8864843845367432;
        double fanctrl_gain = 0.1727469563484192;
        double fanctrl_maxInput = 0.13490456342697144;
        double fanctrl_maxOutput = 0.3473753333091736;
        double fanctrl_minInput = 0.6098875999450684;
        double fanctrl_minOutput = 0.7934238314628601;
        double fanctrl_setTemp = 0.1778220534324646;
        double fanctrl_smoothTime = 0.4586156f;
        double fanctrl_timeConst = 0.6101097464561462;
        double fanctrl_tolerance = 0.299530029296875;
        boolean fanctrl_useAbsTemp = false;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo3_PicConfigurationEvent(version, fanctrl_awGain, fanctrl_baseDuty, fanctrl_gain, fanctrl_maxInput, fanctrl_maxOutput, fanctrl_minInput, fanctrl_minOutput, fanctrl_setTemp, fanctrl_smoothTime, fanctrl_timeConst, fanctrl_tolerance, fanctrl_useAbsTemp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo3_PicConfigurationEvent));
        Refrig_Cryo3_PicConfigurationEvent item_ = (Refrig_Cryo3_PicConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)fanctrl_awGain, (double)item_.getFanctrl_awGain(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_baseDuty, (double)item_.getFanctrl_baseDuty(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_gain, (double)item_.getFanctrl_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_maxInput, (double)item_.getFanctrl_maxInput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_maxOutput, (double)item_.getFanctrl_maxOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_minInput, (double)item_.getFanctrl_minInput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_minOutput, (double)item_.getFanctrl_minOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_setTemp, (double)item_.getFanctrl_setTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_smoothTime, (double)item_.getFanctrl_smoothTime(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_timeConst, (double)item_.getFanctrl_timeConst(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_tolerance, (double)item_.getFanctrl_tolerance(), (double)1.0E-6f);
        Assert.assertEquals((Object)fanctrl_useAbsTemp, (Object)item_.isFanctrl_useAbsTemp());
    }

    @Test
    public void sendReceiveRefrig_Cryo4_DeviceConfigurationEvent() throws Exception {
        String version = "";
        String maq20_node = "";
        String maq20_serials = "a";
        String plc_node = "g";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo4_DeviceConfigurationEvent(version, maq20_node, maq20_serials, plc_node));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo4_DeviceConfigurationEvent));
        Refrig_Cryo4_DeviceConfigurationEvent item_ = (Refrig_Cryo4_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
    }

    @Test
    public void sendReceiveRefrig_Cryo4_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean maq20_disabled = false;
        boolean plc_disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo4_DevicesConfigurationEvent(version, maq20_disabled, plc_disabled));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo4_DevicesConfigurationEvent));
        Refrig_Cryo4_DevicesConfigurationEvent item_ = (Refrig_Cryo4_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_disabled, (Object)item_.isMaq20_disabled());
        Assert.assertEquals((Object)plc_disabled, (Object)item_.isPlc_disabled());
    }

    @Test
    public void sendReceiveRefrig_Cryo4_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double aftercooltmp_warnHi = 0.12573248147964478;
        double aftercooltmp_warnLo = 0.7065396308898926;
        double aftercooltmp_limitHi = 0.3767498731613159;
        double aftercooltmp_limitLo = 0.24975663423538208;
        double compcurrent_warnHi = 0.4749488830566406;
        double compcurrent_warnLo = 0.3190044164657593;
        double compcurrent_limitHi = 0.20412278175354004;
        double compcurrent_limitLo = 0.9971677660942078;
        double comppower_warnHi = 0.10977274179458618;
        double comppower_warnLo = 0.5512157082557678;
        double comppower_limitHi = 0.396841824054718;
        double comppower_limitLo = 0.052951693534851074;
        double compvoltage_warnHi = 0.6895899176597595;
        double compvoltage_warnLo = 0.855726f;
        double compvoltage_limitHi = 0.2652818560600281;
        double compvoltage_limitLo = 0.9297782182693481;
        double dischrgprs_warnHi = 0.7525027394294739;
        double dischrgprs_warnLo = 0.8187400698661804;
        double dischrgprs_limitHi = 0.9196393489837646;
        double dischrgprs_limitLo = 0.8585658669471741;
        double dischrgtmp_M_warnHi = 0.6897554993629456;
        double dischrgtmp_M_warnLo = 0.7235310673713684;
        double dischrgtmp_M_limitHi = 0.2210521101951599;
        double dischrgtmp_M_limitLo = 8.614659309387207E-4;
        double dischrgtmp_P_warnHi = 0.758385f;
        double dischrgtmp_P_warnLo = 0.986163318157196;
        double dischrgtmp_P_limitHi = 0.8220734000205994;
        double dischrgtmp_P_limitLo = 0.2030126452445984;
        double fanspeed_warnHi = 0.1932382583618164;
        double fanspeed_warnLo = 0.062367022037506104;
        double fanspeed_limitHi = 0.7379392981529236;
        double fanspeed_limitLo = 0.7134362459182739;
        double oillevel_warnHi = 0.3505188226699829;
        double oillevel_warnLo = 0.09814947843551636;
        double oillevel_limitHi = 0.16175276041030884;
        double oillevel_limitLo = 0.8024162650108337;
        double oilseptmp_warnHi = 0.8596912026405334;
        double oilseptmp_warnLo = 0.41652631759643555;
        double oilseptmp_limitHi = 0.27237361669540405;
        double oilseptmp_limitLo = 0.9842463135719299;
        double phaseseptmp_warnHi = 0.8040790557861328;
        double phaseseptmp_warnLo = 0.344898521900177;
        double phaseseptmp_limitHi = 0.7289501428604126;
        double phaseseptmp_limitLo = 0.9045096039772034;
        double suctionprs_warnHi = 0.7711588144302368;
        double suctionprs_warnLo = 0.22900527715682983;
        double suctionprs_limitHi = 0.6242959499359131;
        double suctionprs_limitLo = 0.796847939491272;
        double suctiontmp_M_warnHi = 0.19282597303390503;
        double suctiontmp_M_warnLo = 0.22758746147155762;
        double suctiontmp_M_limitHi = 0.4324553608894348;
        double suctiontmp_M_limitLo = 0.3753041625022888;
        double suctiontmp_P_warnHi = 0.16835826635360718;
        double suctiontmp_P_warnLo = 0.5050604343414307;
        double suctiontmp_P_limitHi = 0.06370240449905396;
        double suctiontmp_P_limitLo = 0.7674635052680969;
        double surgetanktmp_warnHi = 0.06612330675125122;
        double surgetanktmp_warnLo = 0.24641722440719604;
        double surgetanktmp_limitHi = 0.4908837676048279;
        double surgetanktmp_limitLo = 0.5330145359039307;
        double waterintmp_warnHi = 0.7250893115997314;
        double waterintmp_warnLo = 0.9086655378341675;
        double waterintmp_limitHi = 0.5705804228782654;
        double waterintmp_limitLo = 0.3904784321784973;
        double waterouttmp_warnHi = 0.3178486227989197;
        double waterouttmp_warnLo = 0.8363955616950989;
        double waterouttmp_limitHi = 0.01528573f;
        double waterouttmp_limitLo = 0.19582092761993408;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo4_LimitsConfigurationEvent(version, aftercooltmp_warnHi, aftercooltmp_warnLo, aftercooltmp_limitHi, aftercooltmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fanspeed_warnHi, fanspeed_warnLo, fanspeed_limitHi, fanspeed_limitLo, oillevel_warnHi, oillevel_warnLo, oillevel_limitHi, oillevel_limitLo, oilseptmp_warnHi, oilseptmp_warnLo, oilseptmp_limitHi, oilseptmp_limitLo, phaseseptmp_warnHi, phaseseptmp_warnLo, phaseseptmp_limitHi, phaseseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, surgetanktmp_warnHi, surgetanktmp_warnLo, surgetanktmp_limitHi, surgetanktmp_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo4_LimitsConfigurationEvent));
        Refrig_Cryo4_LimitsConfigurationEvent item_ = (Refrig_Cryo4_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)aftercooltmp_warnHi, (double)item_.getAftercooltmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_warnLo, (double)item_.getAftercooltmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitHi, (double)item_.getAftercooltmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitLo, (double)item_.getAftercooltmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnHi, (double)item_.getFanspeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnLo, (double)item_.getFanspeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitHi, (double)item_.getFanspeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitLo, (double)item_.getFanspeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnHi, (double)item_.getOillevel_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnLo, (double)item_.getOillevel_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitHi, (double)item_.getOillevel_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitLo, (double)item_.getOillevel_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnHi, (double)item_.getOilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnLo, (double)item_.getOilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitHi, (double)item_.getOilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitLo, (double)item_.getOilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnHi, (double)item_.getPhaseseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnLo, (double)item_.getPhaseseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitHi, (double)item_.getPhaseseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitLo, (double)item_.getPhaseseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnHi, (double)item_.getSurgetanktmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnLo, (double)item_.getSurgetanktmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitHi, (double)item_.getSurgetanktmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitLo, (double)item_.getSurgetanktmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo5_DeviceConfigurationEvent() throws Exception {
        String version = "l";
        String maq20_node = "n";
        String maq20_serials = "";
        String plc_node = "";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo5_DeviceConfigurationEvent(version, maq20_node, maq20_serials, plc_node));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo5_DeviceConfigurationEvent));
        Refrig_Cryo5_DeviceConfigurationEvent item_ = (Refrig_Cryo5_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
    }

    @Test
    public void sendReceiveRefrig_Cryo5_DevicesConfigurationEvent() throws Exception {
        String version = "w";
        boolean maq20_disabled = false;
        boolean plc_disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo5_DevicesConfigurationEvent(version, maq20_disabled, plc_disabled));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo5_DevicesConfigurationEvent));
        Refrig_Cryo5_DevicesConfigurationEvent item_ = (Refrig_Cryo5_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_disabled, (Object)item_.isMaq20_disabled());
        Assert.assertEquals((Object)plc_disabled, (Object)item_.isPlc_disabled());
    }

    @Test
    public void sendReceiveRefrig_Cryo5_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double aftercooltmp_warnHi = 0.33633846044540405;
        double aftercooltmp_warnLo = 0.3604347f;
        double aftercooltmp_limitHi = 0.716579020023346;
        double aftercooltmp_limitLo = 0.8807411193847656;
        double ambienttmp_warnHi = 0.22478598356246948;
        double ambienttmp_warnLo = 0.01323777437210083;
        double ambienttmp_limitHi = 0.48775774240493774;
        double ambienttmp_limitLo = 0.3348802924156189;
        double cabinettmp_warnHi = 0.03337627649307251;
        double cabinettmp_warnLo = 0.5512261986732483;
        double cabinettmp_limitHi = 0.3685334324836731;
        double cabinettmp_limitLo = 0.14840304851531982;
        double compcurrent_warnHi = 0.5868754982948303;
        double compcurrent_warnLo = 0.2468433380126953;
        double compcurrent_limitHi = 0.5710065364837646;
        double compcurrent_limitLo = 0.1229315996170044;
        double comppower_warnHi = 0.36650723218917847;
        double comppower_warnLo = 0.3143569827079773;
        double comppower_limitHi = 0.7865678668022156;
        double comppower_limitLo = 0.7533522248268127;
        double compvoltage_warnHi = 0.189189612865448;
        double compvoltage_warnLo = 0.4931233525276184;
        double compvoltage_limitHi = 0.5774151682853699;
        double compvoltage_limitLo = 0.10885119438171387;
        double dischrgprs_warnHi = 0.18275481462478638;
        double dischrgprs_warnLo = 0.6625542044639587;
        double dischrgprs_limitHi = 0.65358f;
        double dischrgprs_limitLo = 0.4216992259025574;
        double dischrgtmp_M_warnHi = 0.49060964584350586;
        double dischrgtmp_M_warnLo = 0.576188862323761;
        double dischrgtmp_M_limitHi = 0.7076285481452942;
        double dischrgtmp_M_limitLo = 0.8091249465942383;
        double dischrgtmp_P_warnHi = 0.5208961963653564;
        double dischrgtmp_P_warnLo = 0.745803952217102;
        double dischrgtmp_P_limitHi = 0.4315042495727539;
        double dischrgtmp_P_limitLo = 0.06382858753204346;
        double fanspeed_warnHi = 0.44760453701019287;
        double fanspeed_warnLo = 0.22132503986358643;
        double fanspeed_limitHi = 0.582874059677124;
        double fanspeed_limitLo = 0.47678375244140625;
        double oillevel_warnHi = 0.9815229177474976;
        double oillevel_warnLo = 0.8861351013183594;
        double oillevel_limitHi = 0.26060914993286133;
        double oillevel_limitLo = 0.40995967388153076;
        double oilseptmp_warnHi = 0.3302185535430908;
        double oilseptmp_warnLo = 0.2610187530517578;
        double oilseptmp_limitHi = 0.540095865726471;
        double oilseptmp_limitLo = 0.1026091f;
        double phaseseptmp_warnHi = 0.4469099f;
        double phaseseptmp_warnLo = 0.22739005088806152;
        double phaseseptmp_limitHi = 0.09896194934844971;
        double phaseseptmp_limitLo = 0.5870565176010132;
        double suctionprs_warnHi = 0.5822194218635559;
        double suctionprs_warnLo = 0.5386918187141418;
        double suctionprs_limitHi = 0.6131938695907593;
        double suctionprs_limitLo = 0.8008796572685242;
        double suctiontmp_M_warnHi = 0.2701093554496765;
        double suctiontmp_M_warnLo = 0.18812376260757446;
        double suctiontmp_M_limitHi = 0.3437894f;
        double suctiontmp_M_limitLo = 0.0325050950050354;
        double suctiontmp_P_warnHi = 0.9351528882980347;
        double suctiontmp_P_warnLo = 0.2944710850715637;
        double suctiontmp_P_limitHi = 0.17696022987365723;
        double suctiontmp_P_limitLo = 0.8251739144325256;
        double surgetanktmp_warnHi = 0.5536596179008484;
        double surgetanktmp_warnLo = 0.012217521667480469;
        double surgetanktmp_limitHi = 0.2790037989616394;
        double surgetanktmp_limitLo = 0.8167297840118408;
        double waterintmp_warnHi = 0.2526538372039795;
        double waterintmp_warnLo = 0.37689924240112305;
        double waterintmp_limitHi = 0.72347092628479;
        double waterintmp_limitLo = 0.7146243453025818;
        double waterouttmp_warnHi = 0.4205285906791687;
        double waterouttmp_warnLo = 0.9744883179664612;
        double waterouttmp_limitHi = 0.8269518613815308;
        double waterouttmp_limitLo = 0.5299327373504639;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo5_LimitsConfigurationEvent(version, aftercooltmp_warnHi, aftercooltmp_warnLo, aftercooltmp_limitHi, aftercooltmp_limitLo, ambienttmp_warnHi, ambienttmp_warnLo, ambienttmp_limitHi, ambienttmp_limitLo, cabinettmp_warnHi, cabinettmp_warnLo, cabinettmp_limitHi, cabinettmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fanspeed_warnHi, fanspeed_warnLo, fanspeed_limitHi, fanspeed_limitLo, oillevel_warnHi, oillevel_warnLo, oillevel_limitHi, oillevel_limitLo, oilseptmp_warnHi, oilseptmp_warnLo, oilseptmp_limitHi, oilseptmp_limitLo, phaseseptmp_warnHi, phaseseptmp_warnLo, phaseseptmp_limitHi, phaseseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, surgetanktmp_warnHi, surgetanktmp_warnLo, surgetanktmp_limitHi, surgetanktmp_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo5_LimitsConfigurationEvent));
        Refrig_Cryo5_LimitsConfigurationEvent item_ = (Refrig_Cryo5_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)aftercooltmp_warnHi, (double)item_.getAftercooltmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_warnLo, (double)item_.getAftercooltmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitHi, (double)item_.getAftercooltmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitLo, (double)item_.getAftercooltmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_warnHi, (double)item_.getAmbienttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_warnLo, (double)item_.getAmbienttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitHi, (double)item_.getAmbienttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitLo, (double)item_.getAmbienttmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnHi, (double)item_.getCabinettmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnLo, (double)item_.getCabinettmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitHi, (double)item_.getCabinettmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitLo, (double)item_.getCabinettmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnHi, (double)item_.getFanspeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnLo, (double)item_.getFanspeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitHi, (double)item_.getFanspeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitLo, (double)item_.getFanspeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnHi, (double)item_.getOillevel_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnLo, (double)item_.getOillevel_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitHi, (double)item_.getOillevel_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitLo, (double)item_.getOillevel_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnHi, (double)item_.getOilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnLo, (double)item_.getOilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitHi, (double)item_.getOilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitLo, (double)item_.getOilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnHi, (double)item_.getPhaseseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnLo, (double)item_.getPhaseseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitHi, (double)item_.getPhaseseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitLo, (double)item_.getPhaseseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnHi, (double)item_.getSurgetanktmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnLo, (double)item_.getSurgetanktmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitHi, (double)item_.getSurgetanktmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitLo, (double)item_.getSurgetanktmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo5_PicConfigurationEvent() throws Exception {
        String version = "";
        double fanctrl_awGain = 0.8403084874153137;
        double fanctrl_baseDuty = 0.2651034f;
        double fanctrl_gain = 0.2321536f;
        double fanctrl_maxInput = 0.24338674545288086;
        double fanctrl_maxOutput = 0.2175209f;
        double fanctrl_minInput = 0.24748414754867554;
        double fanctrl_minOutput = 0.3773950934410095;
        double fanctrl_setTemp = 0.0967077f;
        double fanctrl_smoothTime = 0.3596503f;
        double fanctrl_timeConst = 0.41401517391204834;
        double fanctrl_tolerance = 0.8236048221588135;
        boolean fanctrl_useAbsTemp = true;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo5_PicConfigurationEvent(version, fanctrl_awGain, fanctrl_baseDuty, fanctrl_gain, fanctrl_maxInput, fanctrl_maxOutput, fanctrl_minInput, fanctrl_minOutput, fanctrl_setTemp, fanctrl_smoothTime, fanctrl_timeConst, fanctrl_tolerance, fanctrl_useAbsTemp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo5_PicConfigurationEvent));
        Refrig_Cryo5_PicConfigurationEvent item_ = (Refrig_Cryo5_PicConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)fanctrl_awGain, (double)item_.getFanctrl_awGain(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_baseDuty, (double)item_.getFanctrl_baseDuty(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_gain, (double)item_.getFanctrl_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_maxInput, (double)item_.getFanctrl_maxInput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_maxOutput, (double)item_.getFanctrl_maxOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_minInput, (double)item_.getFanctrl_minInput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_minOutput, (double)item_.getFanctrl_minOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_setTemp, (double)item_.getFanctrl_setTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_smoothTime, (double)item_.getFanctrl_smoothTime(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_timeConst, (double)item_.getFanctrl_timeConst(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_tolerance, (double)item_.getFanctrl_tolerance(), (double)1.0E-6f);
        Assert.assertEquals((Object)fanctrl_useAbsTemp, (Object)item_.isFanctrl_useAbsTemp());
    }

    @Test
    public void sendReceiveRefrig_Cryo6_DeviceConfigurationEvent() throws Exception {
        String version = "m";
        String maq20_node = "";
        String maq20_serials = "";
        String plc_node = "";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo6_DeviceConfigurationEvent(version, maq20_node, maq20_serials, plc_node));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo6_DeviceConfigurationEvent));
        Refrig_Cryo6_DeviceConfigurationEvent item_ = (Refrig_Cryo6_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
    }

    @Test
    public void sendReceiveRefrig_Cryo6_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean maq20_disabled = false;
        boolean plc_disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo6_DevicesConfigurationEvent(version, maq20_disabled, plc_disabled));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo6_DevicesConfigurationEvent));
        Refrig_Cryo6_DevicesConfigurationEvent item_ = (Refrig_Cryo6_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_disabled, (Object)item_.isMaq20_disabled());
        Assert.assertEquals((Object)plc_disabled, (Object)item_.isPlc_disabled());
    }

    @Test
    public void sendReceiveRefrig_Cryo6_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double aftercooltmp_warnHi = 0.2015022f;
        double aftercooltmp_warnLo = 0.024693548679351807;
        double aftercooltmp_limitHi = 0.7132042646408081;
        double aftercooltmp_limitLo = 0.4456857442855835;
        double compcurrent_warnHi = 0.9054670929908752;
        double compcurrent_warnLo = 0.3275317f;
        double compcurrent_limitHi = 0.17269080877304077;
        double compcurrent_limitLo = 0.9117224216461182;
        double comppower_warnHi = 0.9080513715744019;
        double comppower_warnLo = 0.40556687116622925;
        double comppower_limitHi = 0.7757561802864075;
        double comppower_limitLo = 0.793748f;
        double compvoltage_warnHi = 0.250373f;
        double compvoltage_warnLo = 0.08731728792190552;
        double compvoltage_limitHi = 0.9066471457481384;
        double compvoltage_limitLo = 0.7543467879295349;
        double dischrgprs_warnHi = 0.6659121513366699;
        double dischrgprs_warnLo = 0.03457885980606079;
        double dischrgprs_limitHi = 0.012080729007720947;
        double dischrgprs_limitLo = 0.1956343650817871;
        double dischrgtmp_M_warnHi = 0.1312609314918518;
        double dischrgtmp_M_warnLo = 0.17674553394317627;
        double dischrgtmp_M_limitHi = 0.1836094856262207;
        double dischrgtmp_M_limitLo = 0.6274861693382263;
        double dischrgtmp_P_warnHi = 0.4388948678970337;
        double dischrgtmp_P_warnLo = 0.9913501739501953;
        double dischrgtmp_P_limitHi = 0.27084267139434814;
        double dischrgtmp_P_limitLo = 0.18169403076171875;
        double fanspeed_warnHi = 0.09214985370635986;
        double fanspeed_warnLo = 0.4011055827140808;
        double fanspeed_limitHi = 0.017182588577270508;
        double fanspeed_limitLo = 0.568577766418457;
        double oillevel_warnHi = 0.2997971177101135;
        double oillevel_warnLo = 0.03229391574859619;
        double oillevel_limitHi = 0.46688413619995117;
        double oillevel_limitLo = 0.9947351813316345;
        double oilseptmp_warnHi = 0.6388403177261353;
        double oilseptmp_warnLo = 0.6264894604682922;
        double oilseptmp_limitHi = 0.5283551812171936;
        double oilseptmp_limitLo = 0.18395566940307617;
        double phaseseptmp_warnHi = 0.1932077407836914;
        double phaseseptmp_warnLo = 0.6003178954124451;
        double phaseseptmp_limitHi = 0.6415472626686096;
        double phaseseptmp_limitLo = 0.8836649656295776;
        double suctionprs_warnHi = 0.6872890591621399;
        double suctionprs_warnLo = 0.26738274097442627;
        double suctionprs_limitHi = 0.05051279067993164;
        double suctionprs_limitLo = 0.5155674815177917;
        double suctiontmp_M_warnHi = 0.4818124771118164;
        double suctiontmp_M_warnLo = 0.5618872046470642;
        double suctiontmp_M_limitHi = 0.05482828617095947;
        double suctiontmp_M_limitLo = 0.8134623169898987;
        double suctiontmp_P_warnHi = 0.8410322666168213;
        double suctiontmp_P_warnLo = 0.3022293448448181;
        double suctiontmp_P_limitHi = 0.6503296494483948;
        double suctiontmp_P_limitLo = 0.9587438702583313;
        double surgetanktmp_warnHi = 0.8108999133110046;
        double surgetanktmp_warnLo = 4.579425E-4f;
        double surgetanktmp_limitHi = 0.28082817792892456;
        double surgetanktmp_limitLo = 0.4031602740287781;
        double waterintmp_warnHi = 0.4547199010848999;
        double waterintmp_warnLo = 0.9335781931877136;
        double waterintmp_limitHi = 0.6341502070426941;
        double waterintmp_limitLo = 0.9904511570930481;
        double waterouttmp_warnHi = 0.30330485105514526;
        double waterouttmp_warnLo = 0.9470493793487549;
        double waterouttmp_limitHi = 0.9195677042007446;
        double waterouttmp_limitLo = 0.3380838632583618;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo6_LimitsConfigurationEvent(version, aftercooltmp_warnHi, aftercooltmp_warnLo, aftercooltmp_limitHi, aftercooltmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fanspeed_warnHi, fanspeed_warnLo, fanspeed_limitHi, fanspeed_limitLo, oillevel_warnHi, oillevel_warnLo, oillevel_limitHi, oillevel_limitLo, oilseptmp_warnHi, oilseptmp_warnLo, oilseptmp_limitHi, oilseptmp_limitLo, phaseseptmp_warnHi, phaseseptmp_warnLo, phaseseptmp_limitHi, phaseseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, surgetanktmp_warnHi, surgetanktmp_warnLo, surgetanktmp_limitHi, surgetanktmp_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo6_LimitsConfigurationEvent));
        Refrig_Cryo6_LimitsConfigurationEvent item_ = (Refrig_Cryo6_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)aftercooltmp_warnHi, (double)item_.getAftercooltmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_warnLo, (double)item_.getAftercooltmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitHi, (double)item_.getAftercooltmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitLo, (double)item_.getAftercooltmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnHi, (double)item_.getFanspeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnLo, (double)item_.getFanspeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitHi, (double)item_.getFanspeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitLo, (double)item_.getFanspeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnHi, (double)item_.getOillevel_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnLo, (double)item_.getOillevel_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitHi, (double)item_.getOillevel_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitLo, (double)item_.getOillevel_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnHi, (double)item_.getOilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnLo, (double)item_.getOilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitHi, (double)item_.getOilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitLo, (double)item_.getOilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnHi, (double)item_.getPhaseseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnLo, (double)item_.getPhaseseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitHi, (double)item_.getPhaseseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitLo, (double)item_.getPhaseseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnHi, (double)item_.getSurgetanktmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnLo, (double)item_.getSurgetanktmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitHi, (double)item_.getSurgetanktmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitLo, (double)item_.getSurgetanktmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_CryoCompLimits_CompLimitsConfigurationEvent() throws Exception {
        String version = "";
        double cmprPowerDelayLimit = 0.1393022f;
        int cmprPowerDelayTime = 296;
        double cmprPowerImmedLimit = 0.605151891708374;
        double discPressDelayLimit = 0.6058160662651062;
        double discPressImmedLimit = 0.8867303133010864;
        double discTempDelayLimit = 0.4610862731933594;
        int discTempDelayTime = 75;
        double discTempImmedLimit = 0.12129944562911987;
        double discTempLowImmedLimit = 0.3975124955177307;
        double heaterTempLimit = 0.36742645502090454;
        double oilLevelImmedLimit = 0.6493446826934814;
        double orificeOffPress = 0.8481138944625854;
        double orificeOnPress = 0.24405282735824585;
        double phaseSepTempDelayLimit = 0.04184520244598389;
        int phaseSepTempDelayTime = 590;
        double pressDiffImmedLimit = 0.04808610677719116;
        double suctTempImmedLimit = 0.8101748824119568;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_CryoCompLimits_CompLimitsConfigurationEvent(version, cmprPowerDelayLimit, cmprPowerDelayTime, cmprPowerImmedLimit, discPressDelayLimit, discPressImmedLimit, discTempDelayLimit, discTempDelayTime, discTempImmedLimit, discTempLowImmedLimit, heaterTempLimit, oilLevelImmedLimit, orificeOffPress, orificeOnPress, phaseSepTempDelayLimit, phaseSepTempDelayTime, pressDiffImmedLimit, suctTempImmedLimit));
        Assert.assertTrue((boolean)(item instanceof Refrig_CryoCompLimits_CompLimitsConfigurationEvent));
        Refrig_CryoCompLimits_CompLimitsConfigurationEvent item_ = (Refrig_CryoCompLimits_CompLimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)cmprPowerDelayLimit, (double)item_.getCmprPowerDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)cmprPowerDelayTime, (long)item_.getCmprPowerDelayTime());
        Assert.assertEquals((double)cmprPowerImmedLimit, (double)item_.getCmprPowerImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discPressDelayLimit, (double)item_.getDiscPressDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discPressImmedLimit, (double)item_.getDiscPressImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempDelayLimit, (double)item_.getDiscTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discTempDelayTime, (long)item_.getDiscTempDelayTime());
        Assert.assertEquals((double)discTempImmedLimit, (double)item_.getDiscTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempLowImmedLimit, (double)item_.getDiscTempLowImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)heaterTempLimit, (double)item_.getHeaterTempLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevelImmedLimit, (double)item_.getOilLevelImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOffPress, (double)item_.getOrificeOffPress(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOnPress, (double)item_.getOrificeOnPress(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTempDelayLimit, (double)item_.getPhaseSepTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)phaseSepTempDelayTime, (long)item_.getPhaseSepTempDelayTime());
        Assert.assertEquals((double)pressDiffImmedLimit, (double)item_.getPressDiffImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)suctTempImmedLimit, (double)item_.getSuctTempImmedLimit(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "v";
        int schedulers_default_nTasks = 427;
        int schedulers_default_nThreads = 169;
        int schedulers_monitor_check_scheduler_nTasks = 392;
        int schedulers_monitor_check_scheduler_nThreads = 719;
        int schedulers_monitor_update_publish_scheduler_nTasks = 418;
        int schedulers_monitor_update_publish_scheduler_nThreads = 262;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_check_scheduler_nTasks, schedulers_monitor_check_scheduler_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Refrig_PeriodicTasks_GeneralConfigurationEvent));
        Refrig_PeriodicTasks_GeneralConfigurationEvent item_ = (Refrig_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nTasks, (long)item_.getSchedulers_monitor_check_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nThreads, (long)item_.getSchedulers_monitor_check_scheduler_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveRefrig_PeriodicTasks_PicConfigurationEvent() throws Exception {
        String version = "i";
        long cryo3_FanCtrl_iterate_updateTime = 133L;
        long cryo5_FanCtrl_iterate_updateTime = 546L;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_PeriodicTasks_PicConfigurationEvent(version, cryo3_FanCtrl_iterate_updateTime, cryo5_FanCtrl_iterate_updateTime));
        Assert.assertTrue((boolean)(item instanceof Refrig_PeriodicTasks_PicConfigurationEvent));
        Refrig_PeriodicTasks_PicConfigurationEvent item_ = (Refrig_PeriodicTasks_PicConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)cryo3_FanCtrl_iterate_updateTime, (long)item_.getCryo3_FanCtrl_iterate_updateTime());
        Assert.assertEquals((long)cryo5_FanCtrl_iterate_updateTime, (long)item_.getCryo5_FanCtrl_iterate_updateTime());
    }

    @Test
    public void sendReceiveRefrig_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "";
        long agentmonitorservice_taskPeriodMillis = 770L;
        long compressor_state_taskPeriodMillis = 201L;
        long heartbeat_taskPeriodMillis = 610L;
        long monitor_check_Cryo1_Maq20_taskPeriodMillis = 391L;
        long monitor_check_Cryo1_Plc_taskPeriodMillis = 466L;
        long monitor_check_Cryo2_Maq20_taskPeriodMillis = 842L;
        long monitor_check_Cryo2_Plc_taskPeriodMillis = 665L;
        long monitor_check_Cryo3_Maq20_taskPeriodMillis = 6L;
        long monitor_check_Cryo3_Plc_taskPeriodMillis = 161L;
        long monitor_check_Cryo4_Maq20_taskPeriodMillis = 345L;
        long monitor_check_Cryo4_Plc_taskPeriodMillis = 972L;
        long monitor_check_Cryo5_Maq20_taskPeriodMillis = 118L;
        long monitor_check_Cryo5_Plc_taskPeriodMillis = 189L;
        long monitor_check_Cryo6_Maq20_taskPeriodMillis = 10L;
        long monitor_check_Cryo6_Plc_taskPeriodMillis = 608L;
        long monitor_publish_Cryo1_Maq20_taskPeriodMillis = 125L;
        long monitor_publish_Cryo1_Plc_taskPeriodMillis = 324L;
        long monitor_publish_Cryo2_Maq20_taskPeriodMillis = 753L;
        long monitor_publish_Cryo2_Plc_taskPeriodMillis = 435L;
        long monitor_publish_Cryo3_Maq20_taskPeriodMillis = 313L;
        long monitor_publish_Cryo3_Plc_taskPeriodMillis = 325L;
        long monitor_publish_Cryo4_Maq20_taskPeriodMillis = 604L;
        long monitor_publish_Cryo4_Plc_taskPeriodMillis = 67L;
        long monitor_publish_Cryo5_Maq20_taskPeriodMillis = 68L;
        long monitor_publish_Cryo5_Plc_taskPeriodMillis = 867L;
        long monitor_publish_Cryo6_Maq20_taskPeriodMillis = 132L;
        long monitor_publish_Cryo6_Plc_taskPeriodMillis = 591L;
        long monitor_update_Cryo1_Maq20_taskPeriodMillis = 161L;
        long monitor_update_Cryo1_Plc_taskPeriodMillis = 806L;
        long monitor_update_Cryo2_Maq20_taskPeriodMillis = 645L;
        long monitor_update_Cryo2_Plc_taskPeriodMillis = 784L;
        long monitor_update_Cryo3_Maq20_taskPeriodMillis = 374L;
        long monitor_update_Cryo3_Plc_taskPeriodMillis = 239L;
        long monitor_update_Cryo4_Maq20_taskPeriodMillis = 453L;
        long monitor_update_Cryo4_Plc_taskPeriodMillis = 955L;
        long monitor_update_Cryo5_Maq20_taskPeriodMillis = 258L;
        long monitor_update_Cryo5_Plc_taskPeriodMillis = 104L;
        long monitor_update_Cryo6_Maq20_taskPeriodMillis = 993L;
        long monitor_update_Cryo6_Plc_taskPeriodMillis = 206L;
        long runtimeinfo_taskPeriodMillis = 421L;
        long update_time_taskPeriodMillis = 246L;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, compressor_state_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_Cryo1_Maq20_taskPeriodMillis, monitor_check_Cryo1_Plc_taskPeriodMillis, monitor_check_Cryo2_Maq20_taskPeriodMillis, monitor_check_Cryo2_Plc_taskPeriodMillis, monitor_check_Cryo3_Maq20_taskPeriodMillis, monitor_check_Cryo3_Plc_taskPeriodMillis, monitor_check_Cryo4_Maq20_taskPeriodMillis, monitor_check_Cryo4_Plc_taskPeriodMillis, monitor_check_Cryo5_Maq20_taskPeriodMillis, monitor_check_Cryo5_Plc_taskPeriodMillis, monitor_check_Cryo6_Maq20_taskPeriodMillis, monitor_check_Cryo6_Plc_taskPeriodMillis, monitor_publish_Cryo1_Maq20_taskPeriodMillis, monitor_publish_Cryo1_Plc_taskPeriodMillis, monitor_publish_Cryo2_Maq20_taskPeriodMillis, monitor_publish_Cryo2_Plc_taskPeriodMillis, monitor_publish_Cryo3_Maq20_taskPeriodMillis, monitor_publish_Cryo3_Plc_taskPeriodMillis, monitor_publish_Cryo4_Maq20_taskPeriodMillis, monitor_publish_Cryo4_Plc_taskPeriodMillis, monitor_publish_Cryo5_Maq20_taskPeriodMillis, monitor_publish_Cryo5_Plc_taskPeriodMillis, monitor_publish_Cryo6_Maq20_taskPeriodMillis, monitor_publish_Cryo6_Plc_taskPeriodMillis, monitor_update_Cryo1_Maq20_taskPeriodMillis, monitor_update_Cryo1_Plc_taskPeriodMillis, monitor_update_Cryo2_Maq20_taskPeriodMillis, monitor_update_Cryo2_Plc_taskPeriodMillis, monitor_update_Cryo3_Maq20_taskPeriodMillis, monitor_update_Cryo3_Plc_taskPeriodMillis, monitor_update_Cryo4_Maq20_taskPeriodMillis, monitor_update_Cryo4_Plc_taskPeriodMillis, monitor_update_Cryo5_Maq20_taskPeriodMillis, monitor_update_Cryo5_Plc_taskPeriodMillis, monitor_update_Cryo6_Maq20_taskPeriodMillis, monitor_update_Cryo6_Plc_taskPeriodMillis, runtimeinfo_taskPeriodMillis, update_time_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Refrig_PeriodicTasks_timersConfigurationEvent));
        Refrig_PeriodicTasks_timersConfigurationEvent item_ = (Refrig_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)compressor_state_taskPeriodMillis, (long)item_.getCompressor_state_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo1_Maq20_taskPeriodMillis, (long)item_.getMonitor_check_Cryo1_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo1_Plc_taskPeriodMillis, (long)item_.getMonitor_check_Cryo1_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo2_Maq20_taskPeriodMillis, (long)item_.getMonitor_check_Cryo2_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo2_Plc_taskPeriodMillis, (long)item_.getMonitor_check_Cryo2_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo3_Maq20_taskPeriodMillis, (long)item_.getMonitor_check_Cryo3_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo3_Plc_taskPeriodMillis, (long)item_.getMonitor_check_Cryo3_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo4_Maq20_taskPeriodMillis, (long)item_.getMonitor_check_Cryo4_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo4_Plc_taskPeriodMillis, (long)item_.getMonitor_check_Cryo4_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo5_Maq20_taskPeriodMillis, (long)item_.getMonitor_check_Cryo5_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo5_Plc_taskPeriodMillis, (long)item_.getMonitor_check_Cryo5_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo6_Maq20_taskPeriodMillis, (long)item_.getMonitor_check_Cryo6_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo6_Plc_taskPeriodMillis, (long)item_.getMonitor_check_Cryo6_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_Cryo1_Maq20_taskPeriodMillis, (long)item_.getMonitor_publish_Cryo1_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_Cryo1_Plc_taskPeriodMillis, (long)item_.getMonitor_publish_Cryo1_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_Cryo2_Maq20_taskPeriodMillis, (long)item_.getMonitor_publish_Cryo2_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_Cryo2_Plc_taskPeriodMillis, (long)item_.getMonitor_publish_Cryo2_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_Cryo3_Maq20_taskPeriodMillis, (long)item_.getMonitor_publish_Cryo3_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_Cryo3_Plc_taskPeriodMillis, (long)item_.getMonitor_publish_Cryo3_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_Cryo4_Maq20_taskPeriodMillis, (long)item_.getMonitor_publish_Cryo4_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_Cryo4_Plc_taskPeriodMillis, (long)item_.getMonitor_publish_Cryo4_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_Cryo5_Maq20_taskPeriodMillis, (long)item_.getMonitor_publish_Cryo5_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_Cryo5_Plc_taskPeriodMillis, (long)item_.getMonitor_publish_Cryo5_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_Cryo6_Maq20_taskPeriodMillis, (long)item_.getMonitor_publish_Cryo6_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_Cryo6_Plc_taskPeriodMillis, (long)item_.getMonitor_publish_Cryo6_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_Cryo1_Maq20_taskPeriodMillis, (long)item_.getMonitor_update_Cryo1_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_Cryo1_Plc_taskPeriodMillis, (long)item_.getMonitor_update_Cryo1_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_Cryo2_Maq20_taskPeriodMillis, (long)item_.getMonitor_update_Cryo2_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_Cryo2_Plc_taskPeriodMillis, (long)item_.getMonitor_update_Cryo2_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_Cryo3_Maq20_taskPeriodMillis, (long)item_.getMonitor_update_Cryo3_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_Cryo3_Plc_taskPeriodMillis, (long)item_.getMonitor_update_Cryo3_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_Cryo4_Maq20_taskPeriodMillis, (long)item_.getMonitor_update_Cryo4_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_Cryo4_Plc_taskPeriodMillis, (long)item_.getMonitor_update_Cryo4_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_Cryo5_Maq20_taskPeriodMillis, (long)item_.getMonitor_update_Cryo5_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_Cryo5_Plc_taskPeriodMillis, (long)item_.getMonitor_update_Cryo5_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_Cryo6_Maq20_taskPeriodMillis, (long)item_.getMonitor_update_Cryo6_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_Cryo6_Plc_taskPeriodMillis, (long)item_.getMonitor_update_Cryo6_Plc_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
        Assert.assertEquals((long)update_time_taskPeriodMillis, (long)item_.getUpdate_time_taskPeriodMillis());
    }

    @Test
    public void sendReceiveVacuum_Cip_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double[] cryo_I_warnHi = TestHelper.generateDoubleArray((int)6, (int)-101645736);
        double[] cryo_I_warnLo = TestHelper.generateDoubleArray((int)6, (int)928453471);
        double[] cryo_I_limitHi = TestHelper.generateDoubleArray((int)6, (int)415119978);
        double[] cryo_I_limitLo = TestHelper.generateDoubleArray((int)6, (int)616246464);
        double[] cryo_Life_warnHi = TestHelper.generateDoubleArray((int)6, (int)-1025713346);
        double[] cryo_Life_warnLo = TestHelper.generateDoubleArray((int)6, (int)-1264097119);
        double[] cryo_Life_limitHi = TestHelper.generateDoubleArray((int)6, (int)564681629);
        double[] cryo_Life_limitLo = TestHelper.generateDoubleArray((int)6, (int)1121254043);
        double[] cryo_Usage_warnHi = TestHelper.generateDoubleArray((int)6, (int)-816058077);
        double[] cryo_Usage_warnLo = TestHelper.generateDoubleArray((int)6, (int)-541065889);
        double[] cryo_Usage_limitHi = TestHelper.generateDoubleArray((int)6, (int)608954111);
        double[] cryo_Usage_limitLo = TestHelper.generateDoubleArray((int)6, (int)755348069);
        double[] cryo_V_warnHi = TestHelper.generateDoubleArray((int)6, (int)1452908335);
        double[] cryo_V_warnLo = TestHelper.generateDoubleArray((int)6, (int)-1637505314);
        double[] cryo_V_limitHi = TestHelper.generateDoubleArray((int)6, (int)-1950326017);
        double[] cryo_V_limitLo = TestHelper.generateDoubleArray((int)6, (int)1743197950);
        double[] hx_I_warnHi = TestHelper.generateDoubleArray((int)6, (int)-771233578);
        double[] hx_I_warnLo = TestHelper.generateDoubleArray((int)6, (int)1923854614);
        double[] hx_I_limitHi = TestHelper.generateDoubleArray((int)6, (int)1361262745);
        double[] hx_I_limitLo = TestHelper.generateDoubleArray((int)6, (int)335313942);
        double[] hx_Life_warnHi = TestHelper.generateDoubleArray((int)6, (int)328477993);
        double[] hx_Life_warnLo = TestHelper.generateDoubleArray((int)6, (int)1911665011);
        double[] hx_Life_limitHi = TestHelper.generateDoubleArray((int)6, (int)1974896839);
        double[] hx_Life_limitLo = TestHelper.generateDoubleArray((int)6, (int)-7741305);
        double[] hx_Usage_warnHi = TestHelper.generateDoubleArray((int)6, (int)740506472);
        double[] hx_Usage_warnLo = TestHelper.generateDoubleArray((int)6, (int)849691097);
        double[] hx_Usage_limitHi = TestHelper.generateDoubleArray((int)6, (int)739468600);
        double[] hx_Usage_limitLo = TestHelper.generateDoubleArray((int)6, (int)-1378366722);
        double[] hx_V_warnHi = TestHelper.generateDoubleArray((int)6, (int)450993372);
        double[] hx_V_warnLo = TestHelper.generateDoubleArray((int)6, (int)2067130345);
        double[] hx_V_limitHi = TestHelper.generateDoubleArray((int)6, (int)-1569038273);
        double[] hx_V_limitLo = TestHelper.generateDoubleArray((int)6, (int)700828897);
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Cip_LimitsConfigurationEvent(version, cryo_I_warnHi, cryo_I_warnLo, cryo_I_limitHi, cryo_I_limitLo, cryo_Life_warnHi, cryo_Life_warnLo, cryo_Life_limitHi, cryo_Life_limitLo, cryo_Usage_warnHi, cryo_Usage_warnLo, cryo_Usage_limitHi, cryo_Usage_limitLo, cryo_V_warnHi, cryo_V_warnLo, cryo_V_limitHi, cryo_V_limitLo, hx_I_warnHi, hx_I_warnLo, hx_I_limitHi, hx_I_limitLo, hx_Life_warnHi, hx_Life_warnLo, hx_Life_limitHi, hx_Life_limitLo, hx_Usage_warnHi, hx_Usage_warnLo, hx_Usage_limitHi, hx_Usage_limitLo, hx_V_warnHi, hx_V_warnLo, hx_V_limitHi, hx_V_limitLo, location));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cip_LimitsConfigurationEvent));
        Vacuum_Cip_LimitsConfigurationEvent item_ = (Vacuum_Cip_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])cryo_I_warnHi, (double[])item_.getCryo_I_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_I_warnLo, (double[])item_.getCryo_I_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_I_limitHi, (double[])item_.getCryo_I_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_I_limitLo, (double[])item_.getCryo_I_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_Life_warnHi, (double[])item_.getCryo_Life_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_Life_warnLo, (double[])item_.getCryo_Life_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_Life_limitHi, (double[])item_.getCryo_Life_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_Life_limitLo, (double[])item_.getCryo_Life_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_Usage_warnHi, (double[])item_.getCryo_Usage_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_Usage_warnLo, (double[])item_.getCryo_Usage_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_Usage_limitHi, (double[])item_.getCryo_Usage_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_Usage_limitLo, (double[])item_.getCryo_Usage_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_V_warnHi, (double[])item_.getCryo_V_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_V_warnLo, (double[])item_.getCryo_V_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_V_limitHi, (double[])item_.getCryo_V_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])cryo_V_limitLo, (double[])item_.getCryo_V_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_I_warnHi, (double[])item_.getHx_I_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_I_warnLo, (double[])item_.getHx_I_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_I_limitHi, (double[])item_.getHx_I_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_I_limitLo, (double[])item_.getHx_I_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_Life_warnHi, (double[])item_.getHx_Life_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_Life_warnLo, (double[])item_.getHx_Life_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_Life_limitHi, (double[])item_.getHx_Life_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_Life_limitLo, (double[])item_.getHx_Life_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_Usage_warnHi, (double[])item_.getHx_Usage_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_Usage_warnLo, (double[])item_.getHx_Usage_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_Usage_limitHi, (double[])item_.getHx_Usage_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_Usage_limitLo, (double[])item_.getHx_Usage_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_V_warnHi, (double[])item_.getHx_V_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_V_warnLo, (double[])item_.getHx_V_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_V_limitHi, (double[])item_.getHx_V_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hx_V_limitLo, (double[])item_.getHx_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveVacuum_CryoFlineGauge_CryoConfigurationEvent() throws Exception {
        String version = "k";
        int busAddr = 230;
        String devcId = "";
        double relayTrip = 0.8130668997764587;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CryoFlineGauge_CryoConfigurationEvent(version, busAddr, devcId, relayTrip));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoFlineGauge_CryoConfigurationEvent));
        Vacuum_CryoFlineGauge_CryoConfigurationEvent item_ = (Vacuum_CryoFlineGauge_CryoConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)busAddr, (long)item_.getBusAddr());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertEquals((double)relayTrip, (double)item_.getRelayTrip(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CryoFlineGauge_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CryoFlineGauge_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoFlineGauge_DevicesConfigurationEvent));
        Vacuum_CryoFlineGauge_DevicesConfigurationEvent item_ = (Vacuum_CryoFlineGauge_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_CryoTurboGauge_CryoConfigurationEvent() throws Exception {
        String version = "";
        int busAddr = 223;
        String devcId = "n";
        double relayTrip = 0.04353010654449463;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CryoTurboGauge_CryoConfigurationEvent(version, busAddr, devcId, relayTrip));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoTurboGauge_CryoConfigurationEvent));
        Vacuum_CryoTurboGauge_CryoConfigurationEvent item_ = (Vacuum_CryoTurboGauge_CryoConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)busAddr, (long)item_.getBusAddr());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertEquals((double)relayTrip, (double)item_.getRelayTrip(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CryoTurboGauge_DevicesConfigurationEvent() throws Exception {
        String version = "r";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CryoTurboGauge_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoTurboGauge_DevicesConfigurationEvent));
        Vacuum_CryoTurboGauge_DevicesConfigurationEvent item_ = (Vacuum_CryoTurboGauge_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_CryoTurboPump_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CryoTurboPump_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoTurboPump_DevicesConfigurationEvent));
        Vacuum_CryoTurboPump_DevicesConfigurationEvent item_ = (Vacuum_CryoTurboPump_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_CryoTurboPump_GeneralConfigurationEvent() throws Exception {
        String version = "";
        boolean activeStopMode = false;
        String devcId = "u";
        boolean interlockType = false;
        boolean lowSpeedMode = false;
        boolean model304 = false;
        boolean softStartMode = false;
        boolean ventValveByCmnd = false;
        boolean waterCooling = false;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CryoTurboPump_GeneralConfigurationEvent(version, activeStopMode, devcId, interlockType, lowSpeedMode, model304, softStartMode, ventValveByCmnd, waterCooling));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoTurboPump_GeneralConfigurationEvent));
        Vacuum_CryoTurboPump_GeneralConfigurationEvent item_ = (Vacuum_CryoTurboPump_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)activeStopMode, (Object)item_.isActiveStopMode());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertEquals((Object)interlockType, (Object)item_.isInterlockType());
        Assert.assertEquals((Object)lowSpeedMode, (Object)item_.isLowSpeedMode());
        Assert.assertEquals((Object)model304, (Object)item_.isModel304());
        Assert.assertEquals((Object)softStartMode, (Object)item_.isSoftStartMode());
        Assert.assertEquals((Object)ventValveByCmnd, (Object)item_.isVentValveByCmnd());
        Assert.assertEquals((Object)waterCooling, (Object)item_.isWaterCooling());
    }

    @Test
    public void sendReceiveVacuum_CryoVacGauge_CryoConfigurationEvent() throws Exception {
        String version = "f";
        int busAddr = 959;
        String devcId = "";
        double relayTrip = 0.849946916103363;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CryoVacGauge_CryoConfigurationEvent(version, busAddr, devcId, relayTrip));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoVacGauge_CryoConfigurationEvent));
        Vacuum_CryoVacGauge_CryoConfigurationEvent item_ = (Vacuum_CryoVacGauge_CryoConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)busAddr, (long)item_.getBusAddr());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertEquals((double)relayTrip, (double)item_.getRelayTrip(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CryoVacGauge_DevicesConfigurationEvent() throws Exception {
        String version = "c";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CryoVacGauge_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoVacGauge_DevicesConfigurationEvent));
        Vacuum_CryoVacGauge_DevicesConfigurationEvent item_ = (Vacuum_CryoVacGauge_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_Cryo_LimitsConfigurationEvent() throws Exception {
        String version = "h";
        double airpressure_warnHi = 0.9397528767585754;
        double airpressure_warnLo = 0.6208028793334961;
        double airpressure_limitHi = 0.8012942671775818;
        double airpressure_limitLo = 0.2754226326942444;
        double cryovac_warnHi = 0.530706524848938;
        double cryovac_warnLo = 0.7597888112068176;
        double cryovac_limitHi = 0.4441121816635132;
        double cryovac_limitLo = 0.38934582471847534;
        double flinepower_warnHi = 0.24884724617004395;
        double flinepower_limitHi = 0.6310590505599976;
        double forelinevac_warnHi = 0.7730971574783325;
        double forelinevac_warnLo = 0.6482424736022949;
        double forelinevac_limitHi = 0.1459333896636963;
        double forelinevac_limitLo = 0.6906232833862305;
        double gaugedose_warnHi = 0.4050159f;
        double gaugedose_warnLo = 0.1610490083694458;
        double gaugedose_limitHi = 0.016855478286743164;
        double gaugedose_limitLo = 0.14342546463012695;
        double pumpcartpressure_warnHi = 0.3442254662513733;
        double pumpcartpressure_warnLo = 0.7518329620361328;
        double pumpcartpressure_limitHi = 0.5052889585494995;
        double pumpcartpressure_limitLo = 0.08975344896316528;
        double turbogaugedose_warnHi = 0.8730581998825073;
        double turbogaugedose_warnLo = 0.6952483654022217;
        double turbogaugedose_limitHi = 0.22655218839645386;
        double turbogaugedose_limitLo = 0.5505384802818298;
        double turbohours_warnHi = 0.014067888259887695;
        double turbohours_warnLo = 0.03614205f;
        double turbohours_limitHi = 0.37096112966537476;
        double turbohours_limitLo = 0.3495739698410034;
        double turbopower_warnHi = 0.7331953048706055;
        double turbopower_limitHi = 0.44190144538879395;
        double turbopumpstatus_warnHi = 0.8249333500862122;
        double turbopumpstatus_limitHi = 0.3438388705253601;
        double turbopumptemp_warnHi = 0.6647447347640991;
        double turbopumptemp_warnLo = 0.09924596548080444;
        double turbopumptemp_limitHi = 0.388649046421051;
        double turbopumptemp_limitLo = 0.192366361618042;
        double turbospeed_warnHi = 0.3791356682777405;
        double turbospeed_warnLo = 0.6766318678855896;
        double turbospeed_limitHi = 0.4565402865409851;
        double turbospeed_limitLo = 0.5763600468635559;
        double turbovac_warnHi = 0.8063295483589172;
        double turbovac_warnLo = 0.20522820949554443;
        double turbovac_limitHi = 0.04169929027557373;
        double turbovac_limitLo = 0.5060730576515198;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Cryo_LimitsConfigurationEvent(version, airpressure_warnHi, airpressure_warnLo, airpressure_limitHi, airpressure_limitLo, cryovac_warnHi, cryovac_warnLo, cryovac_limitHi, cryovac_limitLo, flinepower_warnHi, flinepower_limitHi, forelinevac_warnHi, forelinevac_warnLo, forelinevac_limitHi, forelinevac_limitLo, gaugedose_warnHi, gaugedose_warnLo, gaugedose_limitHi, gaugedose_limitLo, pumpcartpressure_warnHi, pumpcartpressure_warnLo, pumpcartpressure_limitHi, pumpcartpressure_limitLo, turbogaugedose_warnHi, turbogaugedose_warnLo, turbogaugedose_limitHi, turbogaugedose_limitLo, turbohours_warnHi, turbohours_warnLo, turbohours_limitHi, turbohours_limitLo, turbopower_warnHi, turbopower_limitHi, turbopumpstatus_warnHi, turbopumpstatus_limitHi, turbopumptemp_warnHi, turbopumptemp_warnLo, turbopumptemp_limitHi, turbopumptemp_limitLo, turbospeed_warnHi, turbospeed_warnLo, turbospeed_limitHi, turbospeed_limitLo, turbovac_warnHi, turbovac_warnLo, turbovac_limitHi, turbovac_limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cryo_LimitsConfigurationEvent));
        Vacuum_Cryo_LimitsConfigurationEvent item_ = (Vacuum_Cryo_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)airpressure_warnHi, (double)item_.getAirpressure_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)airpressure_warnLo, (double)item_.getAirpressure_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)airpressure_limitHi, (double)item_.getAirpressure_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)airpressure_limitLo, (double)item_.getAirpressure_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryovac_warnHi, (double)item_.getCryovac_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryovac_warnLo, (double)item_.getCryovac_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryovac_limitHi, (double)item_.getCryovac_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryovac_limitLo, (double)item_.getCryovac_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)flinepower_warnHi, (double)item_.getFlinepower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)flinepower_limitHi, (double)item_.getFlinepower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)forelinevac_warnHi, (double)item_.getForelinevac_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)forelinevac_warnLo, (double)item_.getForelinevac_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)forelinevac_limitHi, (double)item_.getForelinevac_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)forelinevac_limitLo, (double)item_.getForelinevac_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gaugedose_warnHi, (double)item_.getGaugedose_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gaugedose_warnLo, (double)item_.getGaugedose_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gaugedose_limitHi, (double)item_.getGaugedose_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gaugedose_limitLo, (double)item_.getGaugedose_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartpressure_warnHi, (double)item_.getPumpcartpressure_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartpressure_warnLo, (double)item_.getPumpcartpressure_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartpressure_limitHi, (double)item_.getPumpcartpressure_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartpressure_limitLo, (double)item_.getPumpcartpressure_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbogaugedose_warnHi, (double)item_.getTurbogaugedose_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbogaugedose_warnLo, (double)item_.getTurbogaugedose_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbogaugedose_limitHi, (double)item_.getTurbogaugedose_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbogaugedose_limitLo, (double)item_.getTurbogaugedose_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbohours_warnHi, (double)item_.getTurbohours_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbohours_warnLo, (double)item_.getTurbohours_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbohours_limitHi, (double)item_.getTurbohours_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbohours_limitLo, (double)item_.getTurbohours_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopower_warnHi, (double)item_.getTurbopower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopower_limitHi, (double)item_.getTurbopower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopumpstatus_warnHi, (double)item_.getTurbopumpstatus_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopumpstatus_limitHi, (double)item_.getTurbopumpstatus_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopumptemp_warnHi, (double)item_.getTurbopumptemp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopumptemp_warnLo, (double)item_.getTurbopumptemp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopumptemp_limitHi, (double)item_.getTurbopumptemp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopumptemp_limitLo, (double)item_.getTurbopumptemp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbospeed_warnHi, (double)item_.getTurbospeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbospeed_warnLo, (double)item_.getTurbospeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbospeed_limitHi, (double)item_.getTurbospeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbospeed_limitLo, (double)item_.getTurbospeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbovac_warnHi, (double)item_.getTurbovac_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbovac_warnLo, (double)item_.getTurbovac_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbovac_limitHi, (double)item_.getTurbovac_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbovac_limitLo, (double)item_.getTurbovac_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_HX_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double airpressure_warnHi = 0.02714228630065918;
        double airpressure_warnLo = 0.20204466581344604;
        double airpressure_limitHi = 0.4414917230606079;
        double airpressure_limitLo = 0.8437589406967163;
        double flinepower_warnHi = 0.8764467239379883;
        double flinepower_limitHi = 0.4024495482444763;
        double forelinevac_warnHi = 0.42289382219314575;
        double forelinevac_warnLo = 0.9662340879440308;
        double forelinevac_limitHi = 0.11944049596786499;
        double forelinevac_limitLo = 0.7138491868972778;
        double gaugedose_warnHi = 0.15329605340957642;
        double gaugedose_warnLo = 0.3902401328086853;
        double gaugedose_limitHi = 0.1239391f;
        double gaugedose_limitLo = 0.8015385270118713;
        double hexvac_warnHi = 0.03770667314529419;
        double hexvac_warnLo = 0.2436668872833252;
        double hexvac_limitHi = 0.35733717679977417;
        double hexvac_limitLo = 0.6375284790992737;
        double pumpcartpressure_warnHi = 0.9946182370185852;
        double pumpcartpressure_warnLo = 0.3443509340286255;
        double pumpcartpressure_limitHi = 0.8494451642036438;
        double pumpcartpressure_limitLo = 0.7361348271369934;
        double turbogaugedose_warnHi = 0.4846060276031494;
        double turbogaugedose_warnLo = 0.9953231811523438;
        double turbogaugedose_limitHi = 0.08402401208877563;
        double turbogaugedose_limitLo = 0.3612545132637024;
        double turbohours_warnHi = 0.6111468076705933;
        double turbohours_warnLo = 0.046657443046569824;
        double turbohours_limitHi = 0.7034997344017029;
        double turbohours_limitLo = 0.6944841146469116;
        double turbopower_warnHi = 0.4423891305923462;
        double turbopower_limitHi = 0.8195973038673401;
        double turbopumpstatus_warnHi = 0.8911446928977966;
        double turbopumpstatus_limitHi = 0.9449220299720764;
        double turbopumptemp_warnHi = 0.3727429509162903;
        double turbopumptemp_warnLo = 0.3365599f;
        double turbopumptemp_limitHi = 0.2162773609161377;
        double turbopumptemp_limitLo = 0.08686792850494385;
        double turbospeed_warnHi = 0.5236115455627441;
        double turbospeed_warnLo = 0.11660957336425781;
        double turbospeed_limitHi = 0.6386212110519409;
        double turbospeed_limitLo = 0.5465096235275269;
        double turbovac_warnHi = 0.8977733850479126;
        double turbovac_warnLo = 0.7412078380584717;
        double turbovac_limitHi = 0.33134692907333374;
        double turbovac_limitLo = 0.14201372861862183;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_HX_LimitsConfigurationEvent(version, airpressure_warnHi, airpressure_warnLo, airpressure_limitHi, airpressure_limitLo, flinepower_warnHi, flinepower_limitHi, forelinevac_warnHi, forelinevac_warnLo, forelinevac_limitHi, forelinevac_limitLo, gaugedose_warnHi, gaugedose_warnLo, gaugedose_limitHi, gaugedose_limitLo, hexvac_warnHi, hexvac_warnLo, hexvac_limitHi, hexvac_limitLo, pumpcartpressure_warnHi, pumpcartpressure_warnLo, pumpcartpressure_limitHi, pumpcartpressure_limitLo, turbogaugedose_warnHi, turbogaugedose_warnLo, turbogaugedose_limitHi, turbogaugedose_limitLo, turbohours_warnHi, turbohours_warnLo, turbohours_limitHi, turbohours_limitLo, turbopower_warnHi, turbopower_limitHi, turbopumpstatus_warnHi, turbopumpstatus_limitHi, turbopumptemp_warnHi, turbopumptemp_warnLo, turbopumptemp_limitHi, turbopumptemp_limitLo, turbospeed_warnHi, turbospeed_warnLo, turbospeed_limitHi, turbospeed_limitLo, turbovac_warnHi, turbovac_warnLo, turbovac_limitHi, turbovac_limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_HX_LimitsConfigurationEvent));
        Vacuum_HX_LimitsConfigurationEvent item_ = (Vacuum_HX_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)airpressure_warnHi, (double)item_.getAirpressure_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)airpressure_warnLo, (double)item_.getAirpressure_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)airpressure_limitHi, (double)item_.getAirpressure_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)airpressure_limitLo, (double)item_.getAirpressure_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)flinepower_warnHi, (double)item_.getFlinepower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)flinepower_limitHi, (double)item_.getFlinepower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)forelinevac_warnHi, (double)item_.getForelinevac_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)forelinevac_warnLo, (double)item_.getForelinevac_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)forelinevac_limitHi, (double)item_.getForelinevac_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)forelinevac_limitLo, (double)item_.getForelinevac_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gaugedose_warnHi, (double)item_.getGaugedose_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gaugedose_warnLo, (double)item_.getGaugedose_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gaugedose_limitHi, (double)item_.getGaugedose_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gaugedose_limitLo, (double)item_.getGaugedose_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexvac_warnHi, (double)item_.getHexvac_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexvac_warnLo, (double)item_.getHexvac_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexvac_limitHi, (double)item_.getHexvac_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexvac_limitLo, (double)item_.getHexvac_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartpressure_warnHi, (double)item_.getPumpcartpressure_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartpressure_warnLo, (double)item_.getPumpcartpressure_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartpressure_limitHi, (double)item_.getPumpcartpressure_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartpressure_limitLo, (double)item_.getPumpcartpressure_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbogaugedose_warnHi, (double)item_.getTurbogaugedose_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbogaugedose_warnLo, (double)item_.getTurbogaugedose_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbogaugedose_limitHi, (double)item_.getTurbogaugedose_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbogaugedose_limitLo, (double)item_.getTurbogaugedose_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbohours_warnHi, (double)item_.getTurbohours_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbohours_warnLo, (double)item_.getTurbohours_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbohours_limitHi, (double)item_.getTurbohours_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbohours_limitLo, (double)item_.getTurbohours_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopower_warnHi, (double)item_.getTurbopower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopower_limitHi, (double)item_.getTurbopower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopumpstatus_warnHi, (double)item_.getTurbopumpstatus_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopumpstatus_limitHi, (double)item_.getTurbopumpstatus_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopumptemp_warnHi, (double)item_.getTurbopumptemp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopumptemp_warnLo, (double)item_.getTurbopumptemp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopumptemp_limitHi, (double)item_.getTurbopumptemp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbopumptemp_limitLo, (double)item_.getTurbopumptemp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbospeed_warnHi, (double)item_.getTurbospeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbospeed_warnLo, (double)item_.getTurbospeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbospeed_limitHi, (double)item_.getTurbospeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbospeed_limitLo, (double)item_.getTurbospeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbovac_warnHi, (double)item_.getTurbovac_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbovac_warnLo, (double)item_.getTurbovac_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)turbovac_limitHi, (double)item_.getTurbovac_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)turbovac_limitLo, (double)item_.getTurbovac_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_HexFlineGauge_CryoConfigurationEvent() throws Exception {
        String version = "";
        int busAddr = 962;
        String devcId = "u";
        double relayTrip = 0.6418435573577881;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_HexFlineGauge_CryoConfigurationEvent(version, busAddr, devcId, relayTrip));
        Assert.assertTrue((boolean)(item instanceof Vacuum_HexFlineGauge_CryoConfigurationEvent));
        Vacuum_HexFlineGauge_CryoConfigurationEvent item_ = (Vacuum_HexFlineGauge_CryoConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)busAddr, (long)item_.getBusAddr());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertEquals((double)relayTrip, (double)item_.getRelayTrip(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_HexFlineGauge_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_HexFlineGauge_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_HexFlineGauge_DevicesConfigurationEvent));
        Vacuum_HexFlineGauge_DevicesConfigurationEvent item_ = (Vacuum_HexFlineGauge_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_HexTurboGauge_CryoConfigurationEvent() throws Exception {
        String version = "";
        int busAddr = 51;
        String devcId = "";
        double relayTrip = 0.3292325735092163;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_HexTurboGauge_CryoConfigurationEvent(version, busAddr, devcId, relayTrip));
        Assert.assertTrue((boolean)(item instanceof Vacuum_HexTurboGauge_CryoConfigurationEvent));
        Vacuum_HexTurboGauge_CryoConfigurationEvent item_ = (Vacuum_HexTurboGauge_CryoConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)busAddr, (long)item_.getBusAddr());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertEquals((double)relayTrip, (double)item_.getRelayTrip(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_HexTurboGauge_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_HexTurboGauge_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_HexTurboGauge_DevicesConfigurationEvent));
        Vacuum_HexTurboGauge_DevicesConfigurationEvent item_ = (Vacuum_HexTurboGauge_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_HexTurboPump_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_HexTurboPump_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_HexTurboPump_DevicesConfigurationEvent));
        Vacuum_HexTurboPump_DevicesConfigurationEvent item_ = (Vacuum_HexTurboPump_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_HexTurboPump_GeneralConfigurationEvent() throws Exception {
        String version = "c";
        boolean activeStopMode = false;
        String devcId = "";
        boolean interlockType = true;
        boolean lowSpeedMode = true;
        boolean model304 = true;
        boolean softStartMode = false;
        boolean ventValveByCmnd = false;
        boolean waterCooling = true;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_HexTurboPump_GeneralConfigurationEvent(version, activeStopMode, devcId, interlockType, lowSpeedMode, model304, softStartMode, ventValveByCmnd, waterCooling));
        Assert.assertTrue((boolean)(item instanceof Vacuum_HexTurboPump_GeneralConfigurationEvent));
        Vacuum_HexTurboPump_GeneralConfigurationEvent item_ = (Vacuum_HexTurboPump_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)activeStopMode, (Object)item_.isActiveStopMode());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertEquals((Object)interlockType, (Object)item_.isInterlockType());
        Assert.assertEquals((Object)lowSpeedMode, (Object)item_.isLowSpeedMode());
        Assert.assertEquals((Object)model304, (Object)item_.isModel304());
        Assert.assertEquals((Object)softStartMode, (Object)item_.isSoftStartMode());
        Assert.assertEquals((Object)ventValveByCmnd, (Object)item_.isVentValveByCmnd());
        Assert.assertEquals((Object)waterCooling, (Object)item_.isWaterCooling());
    }

    @Test
    public void sendReceiveVacuum_HexVacGauge_CryoConfigurationEvent() throws Exception {
        String version = "v";
        int busAddr = 370;
        String devcId = "";
        double relayTrip = 0.8275190591812134;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_HexVacGauge_CryoConfigurationEvent(version, busAddr, devcId, relayTrip));
        Assert.assertTrue((boolean)(item instanceof Vacuum_HexVacGauge_CryoConfigurationEvent));
        Vacuum_HexVacGauge_CryoConfigurationEvent item_ = (Vacuum_HexVacGauge_CryoConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)busAddr, (long)item_.getBusAddr());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertEquals((double)relayTrip, (double)item_.getRelayTrip(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_HexVacGauge_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_HexVacGauge_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_HexVacGauge_DevicesConfigurationEvent));
        Vacuum_HexVacGauge_DevicesConfigurationEvent item_ = (Vacuum_HexVacGauge_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_InstVacGauge_CryoConfigurationEvent() throws Exception {
        String version = "";
        int busAddr = 734;
        String devcId = "";
        double relayTrip = 0.9457008838653564;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_InstVacGauge_CryoConfigurationEvent(version, busAddr, devcId, relayTrip));
        Assert.assertTrue((boolean)(item instanceof Vacuum_InstVacGauge_CryoConfigurationEvent));
        Vacuum_InstVacGauge_CryoConfigurationEvent item_ = (Vacuum_InstVacGauge_CryoConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)busAddr, (long)item_.getBusAddr());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertEquals((double)relayTrip, (double)item_.getRelayTrip(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_InstVacGauge_DevicesConfigurationEvent() throws Exception {
        String version = "q";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_InstVacGauge_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_InstVacGauge_DevicesConfigurationEvent));
        Vacuum_InstVacGauge_DevicesConfigurationEvent item_ = (Vacuum_InstVacGauge_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_Inst_LimitsConfigurationEvent() throws Exception {
        String version = "g";
        double cryoflinevalvestate_warnHi = 0.9268537759780884;
        double cryoflinevalvestate_warnLo = 0.1965157389640808;
        double cryoflinevalvestate_limitHi = 0.7145811319351196;
        double cryoflinevalvestate_limitLo = 0.01391238f;
        double flinepower_warnHi = 0.43761688470840454;
        double flinepower_limitHi = 0.8390809297561646;
        double hxflinevalvestate_warnHi = 0.36190032958984375;
        double hxflinevalvestate_warnLo = 0.3067666292190552;
        double hxflinevalvestate_limitHi = 0.9353718161582947;
        double hxflinevalvestate_limitLo = 0.8341261148452759;
        double instvac_warnHi = 0.8316114544868469;
        double instvac_warnLo = 0.1850796341896057;
        double instvac_limitHi = 0.059637486934661865;
        double instvac_limitLo = 0.832711398601532;
        double pumpcartcycling_warnHi = 0.37604063749313354;
        double pumpcartcycling_warnLo = 0.03953767f;
        double pumpcartcycling_limitHi = 0.8931769132614136;
        double pumpcartcycling_limitLo = 0.34542137384414673;
        double pumpcartpressure_warnHi = 0.09803193807601929;
        double pumpcartpressure_warnLo = 0.6892715096473694;
        double pumpcartpressure_limitHi = 0.398157000541687;
        double pumpcartpressure_limitLo = 0.13042718172073364;
        double pumpcarttemperature_warnHi = 0.034231483936309814;
        double pumpcarttemperature_warnLo = 0.6972344517707825;
        double pumpcarttemperature_limitHi = 0.631290853023529;
        double pumpcarttemperature_limitLo = 0.4155048727989197;
        double pumpcartventing_warnHi = 0.19414716958999634;
        double pumpcartventing_warnLo = 0.7746595144271851;
        double pumpcartventing_limitHi = 0.8212222456932068;
        double pumpcartventing_limitLo = 0.8613449335098267;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Inst_LimitsConfigurationEvent(version, cryoflinevalvestate_warnHi, cryoflinevalvestate_warnLo, cryoflinevalvestate_limitHi, cryoflinevalvestate_limitLo, flinepower_warnHi, flinepower_limitHi, hxflinevalvestate_warnHi, hxflinevalvestate_warnLo, hxflinevalvestate_limitHi, hxflinevalvestate_limitLo, instvac_warnHi, instvac_warnLo, instvac_limitHi, instvac_limitLo, pumpcartcycling_warnHi, pumpcartcycling_warnLo, pumpcartcycling_limitHi, pumpcartcycling_limitLo, pumpcartpressure_warnHi, pumpcartpressure_warnLo, pumpcartpressure_limitHi, pumpcartpressure_limitLo, pumpcarttemperature_warnHi, pumpcarttemperature_warnLo, pumpcarttemperature_limitHi, pumpcarttemperature_limitLo, pumpcartventing_warnHi, pumpcartventing_warnLo, pumpcartventing_limitHi, pumpcartventing_limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Inst_LimitsConfigurationEvent));
        Vacuum_Inst_LimitsConfigurationEvent item_ = (Vacuum_Inst_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)cryoflinevalvestate_warnHi, (double)item_.getCryoflinevalvestate_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryoflinevalvestate_warnLo, (double)item_.getCryoflinevalvestate_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryoflinevalvestate_limitHi, (double)item_.getCryoflinevalvestate_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryoflinevalvestate_limitLo, (double)item_.getCryoflinevalvestate_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)flinepower_warnHi, (double)item_.getFlinepower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)flinepower_limitHi, (double)item_.getFlinepower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hxflinevalvestate_warnHi, (double)item_.getHxflinevalvestate_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hxflinevalvestate_warnLo, (double)item_.getHxflinevalvestate_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hxflinevalvestate_limitHi, (double)item_.getHxflinevalvestate_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hxflinevalvestate_limitLo, (double)item_.getHxflinevalvestate_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)instvac_warnHi, (double)item_.getInstvac_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)instvac_warnLo, (double)item_.getInstvac_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)instvac_limitHi, (double)item_.getInstvac_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)instvac_limitLo, (double)item_.getInstvac_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartcycling_warnHi, (double)item_.getPumpcartcycling_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartcycling_warnLo, (double)item_.getPumpcartcycling_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartcycling_limitHi, (double)item_.getPumpcartcycling_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartcycling_limitLo, (double)item_.getPumpcartcycling_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartpressure_warnHi, (double)item_.getPumpcartpressure_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartpressure_warnLo, (double)item_.getPumpcartpressure_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartpressure_limitHi, (double)item_.getPumpcartpressure_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartpressure_limitLo, (double)item_.getPumpcartpressure_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcarttemperature_warnHi, (double)item_.getPumpcarttemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcarttemperature_warnLo, (double)item_.getPumpcarttemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcarttemperature_limitHi, (double)item_.getPumpcarttemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcarttemperature_limitLo, (double)item_.getPumpcarttemperature_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartventing_warnHi, (double)item_.getPumpcartventing_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartventing_warnLo, (double)item_.getPumpcartventing_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartventing_limitHi, (double)item_.getPumpcartventing_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpcartventing_limitLo, (double)item_.getPumpcartventing_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_IonPumps_CryoConfigurationEvent() throws Exception {
        String version = "f";
        double cip1c_current = 0.0631251335144043;
        double cip1c_power = 0.731778f;
        double cip1c_voltage = 0.24170565605163574;
        double cip2c_current = 0.976365327835083;
        double cip2c_power = 0.8153178691864014;
        double cip2c_voltage = 0.8984127044677734;
        double cip3c_current = 0.6960815787315369;
        double cip3c_power = 0.5096038579940796;
        double cip3c_voltage = 0.12239694595336914;
        double cip4c_current = 0.7142266035079956;
        double cip4c_power = 0.7880451679229736;
        double cip4c_voltage = 0.015918374061584473;
        double cip5c_current = 0.668856680393219;
        double cip5c_power = 0.10010641813278198;
        double cip5c_voltage = 0.7925052046775818;
        double cip6c_current = 0.25043708086013794;
        double cip6c_power = 0.344391405582428;
        double cip6c_voltage = 0.32303881645202637;
        double hip1c_current = 0.3068814277648926;
        double hip1c_power = 0.7918167114257812;
        double hip1c_voltage = 0.01320219f;
        double hip2c_current = 0.3430965542793274;
        double hip2c_power = 0.9203203916549683;
        double hip2c_voltage = 0.6411802172660828;
        String ipAddr = "m";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_IonPumps_CryoConfigurationEvent(version, cip1c_current, cip1c_power, cip1c_voltage, cip2c_current, cip2c_power, cip2c_voltage, cip3c_current, cip3c_power, cip3c_voltage, cip4c_current, cip4c_power, cip4c_voltage, cip5c_current, cip5c_power, cip5c_voltage, cip6c_current, cip6c_power, cip6c_voltage, hip1c_current, hip1c_power, hip1c_voltage, hip2c_current, hip2c_power, hip2c_voltage, ipAddr));
        Assert.assertTrue((boolean)(item instanceof Vacuum_IonPumps_CryoConfigurationEvent));
        Vacuum_IonPumps_CryoConfigurationEvent item_ = (Vacuum_IonPumps_CryoConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)cip1c_current, (double)item_.getCip1c_current(), (double)1.0E-6f);
        Assert.assertEquals((double)cip1c_power, (double)item_.getCip1c_power(), (double)1.0E-6f);
        Assert.assertEquals((double)cip1c_voltage, (double)item_.getCip1c_voltage(), (double)1.0E-6f);
        Assert.assertEquals((double)cip2c_current, (double)item_.getCip2c_current(), (double)1.0E-6f);
        Assert.assertEquals((double)cip2c_power, (double)item_.getCip2c_power(), (double)1.0E-6f);
        Assert.assertEquals((double)cip2c_voltage, (double)item_.getCip2c_voltage(), (double)1.0E-6f);
        Assert.assertEquals((double)cip3c_current, (double)item_.getCip3c_current(), (double)1.0E-6f);
        Assert.assertEquals((double)cip3c_power, (double)item_.getCip3c_power(), (double)1.0E-6f);
        Assert.assertEquals((double)cip3c_voltage, (double)item_.getCip3c_voltage(), (double)1.0E-6f);
        Assert.assertEquals((double)cip4c_current, (double)item_.getCip4c_current(), (double)1.0E-6f);
        Assert.assertEquals((double)cip4c_power, (double)item_.getCip4c_power(), (double)1.0E-6f);
        Assert.assertEquals((double)cip4c_voltage, (double)item_.getCip4c_voltage(), (double)1.0E-6f);
        Assert.assertEquals((double)cip5c_current, (double)item_.getCip5c_current(), (double)1.0E-6f);
        Assert.assertEquals((double)cip5c_power, (double)item_.getCip5c_power(), (double)1.0E-6f);
        Assert.assertEquals((double)cip5c_voltage, (double)item_.getCip5c_voltage(), (double)1.0E-6f);
        Assert.assertEquals((double)cip6c_current, (double)item_.getCip6c_current(), (double)1.0E-6f);
        Assert.assertEquals((double)cip6c_power, (double)item_.getCip6c_power(), (double)1.0E-6f);
        Assert.assertEquals((double)cip6c_voltage, (double)item_.getCip6c_voltage(), (double)1.0E-6f);
        Assert.assertEquals((double)hip1c_current, (double)item_.getHip1c_current(), (double)1.0E-6f);
        Assert.assertEquals((double)hip1c_power, (double)item_.getHip1c_power(), (double)1.0E-6f);
        Assert.assertEquals((double)hip1c_voltage, (double)item_.getHip1c_voltage(), (double)1.0E-6f);
        Assert.assertEquals((double)hip2c_current, (double)item_.getHip2c_current(), (double)1.0E-6f);
        Assert.assertEquals((double)hip2c_power, (double)item_.getHip2c_power(), (double)1.0E-6f);
        Assert.assertEquals((double)hip2c_voltage, (double)item_.getHip2c_voltage(), (double)1.0E-6f);
        Assert.assertEquals((Object)ipAddr, (Object)item_.getIpAddr());
    }

    @Test
    public void sendReceiveVacuum_IonPumps_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_IonPumps_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_IonPumps_DevicesConfigurationEvent));
        Vacuum_IonPumps_DevicesConfigurationEvent item_ = (Vacuum_IonPumps_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_Maq20Cryo_DeviceConfigurationEvent() throws Exception {
        String version = "";
        String node = "o";
        String serials = "";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Maq20Cryo_DeviceConfigurationEvent(version, node, serials));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Maq20Cryo_DeviceConfigurationEvent));
        Vacuum_Maq20Cryo_DeviceConfigurationEvent item_ = (Vacuum_Maq20Cryo_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)node, (Object)item_.getNode());
        Assert.assertEquals((Object)serials, (Object)item_.getSerials());
    }

    @Test
    public void sendReceiveVacuum_Maq20Cryo_DevicesConfigurationEvent() throws Exception {
        String version = "d";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Maq20Cryo_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Maq20Cryo_DevicesConfigurationEvent));
        Vacuum_Maq20Cryo_DevicesConfigurationEvent item_ = (Vacuum_Maq20Cryo_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_Maq20Ut_DeviceConfigurationEvent() throws Exception {
        String version = "";
        String node = "";
        String serials = "o";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Maq20Ut_DeviceConfigurationEvent(version, node, serials));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Maq20Ut_DeviceConfigurationEvent));
        Vacuum_Maq20Ut_DeviceConfigurationEvent item_ = (Vacuum_Maq20Ut_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)node, (Object)item_.getNode());
        Assert.assertEquals((Object)serials, (Object)item_.getSerials());
    }

    @Test
    public void sendReceiveVacuum_Maq20Ut_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Maq20Ut_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Maq20Ut_DevicesConfigurationEvent));
        Vacuum_Maq20Ut_DevicesConfigurationEvent item_ = (Vacuum_Maq20Ut_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_PDU_DevicesConfigurationEvent() throws Exception {
        String version = "l";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_PDU_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_PDU_DevicesConfigurationEvent));
        Vacuum_PDU_DevicesConfigurationEvent item_ = (Vacuum_PDU_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_PDU_VacuumConfigurationEvent() throws Exception {
        String version = "";
        int node = 479;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_PDU_VacuumConfigurationEvent(version, node));
        Assert.assertTrue((boolean)(item instanceof Vacuum_PDU_VacuumConfigurationEvent));
        Vacuum_PDU_VacuumConfigurationEvent item_ = (Vacuum_PDU_VacuumConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveVacuum_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "";
        int schedulers_default_nTasks = 41;
        int schedulers_default_nThreads = 710;
        int schedulers_monitor_check_scheduler_nTasks = 29;
        int schedulers_monitor_check_scheduler_nThreads = 256;
        int schedulers_monitor_update_publish_scheduler_nTasks = 642;
        int schedulers_monitor_update_publish_scheduler_nThreads = 464;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_check_scheduler_nTasks, schedulers_monitor_check_scheduler_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Vacuum_PeriodicTasks_GeneralConfigurationEvent));
        Vacuum_PeriodicTasks_GeneralConfigurationEvent item_ = (Vacuum_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nTasks, (long)item_.getSchedulers_monitor_check_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nThreads, (long)item_.getSchedulers_monitor_check_scheduler_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveVacuum_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "";
        long agentmonitorservice_taskPeriodMillis = 0L;
        long heartbeat_taskPeriodMillis = 535L;
        long monitor_check_CryoFlineGauge_taskPeriodMillis = 649L;
        long monitor_check_CryoTurboGauge_taskPeriodMillis = 286L;
        long monitor_check_CryoTurboPump_taskPeriodMillis = 590L;
        long monitor_check_CryoVacGauge_taskPeriodMillis = 23L;
        long monitor_check_HexFlineGauge_taskPeriodMillis = 233L;
        long monitor_check_HexTurboGauge_taskPeriodMillis = 652L;
        long monitor_check_HexTurboPump_taskPeriodMillis = 827L;
        long monitor_check_HexVacGauge_taskPeriodMillis = 834L;
        long monitor_check_InstVacGauge_taskPeriodMillis = 81L;
        long monitor_check_IonPumps_taskPeriodMillis = 792L;
        long monitor_check_Maq20Cryo_taskPeriodMillis = 844L;
        long monitor_check_Maq20Ut_taskPeriodMillis = 546L;
        long monitor_check_PDU_taskPeriodMillis = 672L;
        long monitor_check_PumpCart_taskPeriodMillis = 87L;
        long monitor_check_VacPluto_taskPeriodMillis = 356L;
        long monitor_publish_CryoTurboPump_taskPeriodMillis = 902L;
        long monitor_publish_HexTurboPump_taskPeriodMillis = 435L;
        long monitor_publish_IonPumps_taskPeriodMillis = 705L;
        long monitor_publish_Maq20Cryo_taskPeriodMillis = 676L;
        long monitor_publish_PDU_taskPeriodMillis = 318L;
        long monitor_publish_PumpCart_taskPeriodMillis = 791L;
        long monitor_publish_slowMon_taskPeriodMillis = 489L;
        long monitor_publish_taskPeriodMillis = 442L;
        long monitor_publish_tts0_taskPeriodMillis = 960L;
        long monitor_publish_tts1_taskPeriodMillis = 494L;
        long monitor_update_CryoTurboPump_taskPeriodMillis = 552L;
        long monitor_update_HexTurboPump_taskPeriodMillis = 444L;
        long monitor_update_IonPumps_taskPeriodMillis = 593L;
        long monitor_update_Maq20Cryo_taskPeriodMillis = 28L;
        long monitor_update_PDU_taskPeriodMillis = 718L;
        long monitor_update_PumpCart_taskPeriodMillis = 351L;
        long monitor_update_slowMon_taskPeriodMillis = 215L;
        long monitor_update_taskPeriodMillis = 765L;
        long monitor_update_tts0_taskPeriodMillis = 656L;
        long monitor_update_tts1_taskPeriodMillis = 145L;
        long runtimeinfo_taskPeriodMillis = 587L;
        long vacuum_state_taskPeriodMillis = 174L;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_CryoFlineGauge_taskPeriodMillis, monitor_check_CryoTurboGauge_taskPeriodMillis, monitor_check_CryoTurboPump_taskPeriodMillis, monitor_check_CryoVacGauge_taskPeriodMillis, monitor_check_HexFlineGauge_taskPeriodMillis, monitor_check_HexTurboGauge_taskPeriodMillis, monitor_check_HexTurboPump_taskPeriodMillis, monitor_check_HexVacGauge_taskPeriodMillis, monitor_check_InstVacGauge_taskPeriodMillis, monitor_check_IonPumps_taskPeriodMillis, monitor_check_Maq20Cryo_taskPeriodMillis, monitor_check_Maq20Ut_taskPeriodMillis, monitor_check_PDU_taskPeriodMillis, monitor_check_PumpCart_taskPeriodMillis, monitor_check_VacPluto_taskPeriodMillis, monitor_publish_CryoTurboPump_taskPeriodMillis, monitor_publish_HexTurboPump_taskPeriodMillis, monitor_publish_IonPumps_taskPeriodMillis, monitor_publish_Maq20Cryo_taskPeriodMillis, monitor_publish_PDU_taskPeriodMillis, monitor_publish_PumpCart_taskPeriodMillis, monitor_publish_slowMon_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_publish_tts0_taskPeriodMillis, monitor_publish_tts1_taskPeriodMillis, monitor_update_CryoTurboPump_taskPeriodMillis, monitor_update_HexTurboPump_taskPeriodMillis, monitor_update_IonPumps_taskPeriodMillis, monitor_update_Maq20Cryo_taskPeriodMillis, monitor_update_PDU_taskPeriodMillis, monitor_update_PumpCart_taskPeriodMillis, monitor_update_slowMon_taskPeriodMillis, monitor_update_taskPeriodMillis, monitor_update_tts0_taskPeriodMillis, monitor_update_tts1_taskPeriodMillis, runtimeinfo_taskPeriodMillis, vacuum_state_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Vacuum_PeriodicTasks_timersConfigurationEvent));
        Vacuum_PeriodicTasks_timersConfigurationEvent item_ = (Vacuum_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_CryoFlineGauge_taskPeriodMillis, (long)item_.getMonitor_check_CryoFlineGauge_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_CryoTurboGauge_taskPeriodMillis, (long)item_.getMonitor_check_CryoTurboGauge_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_CryoTurboPump_taskPeriodMillis, (long)item_.getMonitor_check_CryoTurboPump_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_CryoVacGauge_taskPeriodMillis, (long)item_.getMonitor_check_CryoVacGauge_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_HexFlineGauge_taskPeriodMillis, (long)item_.getMonitor_check_HexFlineGauge_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_HexTurboGauge_taskPeriodMillis, (long)item_.getMonitor_check_HexTurboGauge_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_HexTurboPump_taskPeriodMillis, (long)item_.getMonitor_check_HexTurboPump_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_HexVacGauge_taskPeriodMillis, (long)item_.getMonitor_check_HexVacGauge_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_InstVacGauge_taskPeriodMillis, (long)item_.getMonitor_check_InstVacGauge_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_IonPumps_taskPeriodMillis, (long)item_.getMonitor_check_IonPumps_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Maq20Cryo_taskPeriodMillis, (long)item_.getMonitor_check_Maq20Cryo_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Maq20Ut_taskPeriodMillis, (long)item_.getMonitor_check_Maq20Ut_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_PDU_taskPeriodMillis, (long)item_.getMonitor_check_PDU_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_PumpCart_taskPeriodMillis, (long)item_.getMonitor_check_PumpCart_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_VacPluto_taskPeriodMillis, (long)item_.getMonitor_check_VacPluto_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_CryoTurboPump_taskPeriodMillis, (long)item_.getMonitor_publish_CryoTurboPump_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_HexTurboPump_taskPeriodMillis, (long)item_.getMonitor_publish_HexTurboPump_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_IonPumps_taskPeriodMillis, (long)item_.getMonitor_publish_IonPumps_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_Maq20Cryo_taskPeriodMillis, (long)item_.getMonitor_publish_Maq20Cryo_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_PDU_taskPeriodMillis, (long)item_.getMonitor_publish_PDU_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_PumpCart_taskPeriodMillis, (long)item_.getMonitor_publish_PumpCart_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_slowMon_taskPeriodMillis, (long)item_.getMonitor_publish_slowMon_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_tts0_taskPeriodMillis, (long)item_.getMonitor_publish_tts0_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_tts1_taskPeriodMillis, (long)item_.getMonitor_publish_tts1_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_CryoTurboPump_taskPeriodMillis, (long)item_.getMonitor_update_CryoTurboPump_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_HexTurboPump_taskPeriodMillis, (long)item_.getMonitor_update_HexTurboPump_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_IonPumps_taskPeriodMillis, (long)item_.getMonitor_update_IonPumps_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_Maq20Cryo_taskPeriodMillis, (long)item_.getMonitor_update_Maq20Cryo_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_PDU_taskPeriodMillis, (long)item_.getMonitor_update_PDU_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_PumpCart_taskPeriodMillis, (long)item_.getMonitor_update_PumpCart_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_slowMon_taskPeriodMillis, (long)item_.getMonitor_update_slowMon_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_tts0_taskPeriodMillis, (long)item_.getMonitor_update_tts0_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_tts1_taskPeriodMillis, (long)item_.getMonitor_update_tts1_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
        Assert.assertEquals((long)vacuum_state_taskPeriodMillis, (long)item_.getVacuum_state_taskPeriodMillis());
    }

    @Test
    public void sendReceiveVacuum_PumpCart_CryoConfigurationEvent() throws Exception {
        String version = "";
        String devcId = "s";
        double maxVentPressure = 0.5434670448303223;
        double minPumpPressure = 0.4356348514556885;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_PumpCart_CryoConfigurationEvent(version, devcId, maxVentPressure, minPumpPressure));
        Assert.assertTrue((boolean)(item instanceof Vacuum_PumpCart_CryoConfigurationEvent));
        Vacuum_PumpCart_CryoConfigurationEvent item_ = (Vacuum_PumpCart_CryoConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertEquals((double)maxVentPressure, (double)item_.getMaxVentPressure(), (double)1.0E-6f);
        Assert.assertEquals((double)minPumpPressure, (double)item_.getMinPumpPressure(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_PumpCart_DevicesConfigurationEvent() throws Exception {
        String version = "c";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_PumpCart_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_PumpCart_DevicesConfigurationEvent));
        Vacuum_PumpCart_DevicesConfigurationEvent item_ = (Vacuum_PumpCart_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_VacPluto_DeviceConfigurationEvent() throws Exception {
        String version = "";
        String node = "k";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_VacPluto_DeviceConfigurationEvent(version, node));
        Assert.assertTrue((boolean)(item instanceof Vacuum_VacPluto_DeviceConfigurationEvent));
        Vacuum_VacPluto_DeviceConfigurationEvent item_ = (Vacuum_VacPluto_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)node, (Object)item_.getNode());
    }

    @Test
    public void sendReceiveVacuum_VacPluto_DevicesConfigurationEvent() throws Exception {
        String version = "n";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_VacPluto_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_VacPluto_DevicesConfigurationEvent));
        Vacuum_VacPluto_DevicesConfigurationEvent item_ = (Vacuum_VacPluto_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_VacuumConfigurationEvent() throws Exception {
        String version = "";
        double cryoPScale = 0.9360492825508118;
        double cryoPdiffFloor = 0.2538573145866394;
        double delayCCOff = 0.29517167806625366;
        double hxPScale = 0.29587697982788086;
        double hxPdiffFloor = 0.902417778968811;
        double pChangeStateUpdate = 0.5484668612480164;
        double pFLChangeStateUpdate = 0.831264f;
        double pPCChangeStateUpdate = 0.25001317262649536;
        double pcPdiffFloor = 0.4648313f;
        double pcPdiffScaleFactor = 0.4221401810646057;
        double pressCCEnable = 0.3801417946815491;
        double pressCCOff = 0.10578268766403198;
        double pressDiffHighMin = 0.8073093295097351;
        double pressDiffLow = 0.5354187488555908;
        double pressForelineLow = 0.43833786249160767;
        double pressIonEnable = 0.3118906021118164;
        double pressIonOff = 0.6383227705955505;
        double pressRefrigOk = 0.7984318733215332;
        double pressTurboLow = 0.7643505334854126;
        double pressVacuum = 0.6254391074180603;
        double speedFractTurboLow = 0.4384617209434509;
        long tranTimeCryoGate = 111L;
        long tranTimeHxGate = 887L;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_VacuumConfigurationEvent(version, cryoPScale, cryoPdiffFloor, delayCCOff, hxPScale, hxPdiffFloor, pChangeStateUpdate, pFLChangeStateUpdate, pPCChangeStateUpdate, pcPdiffFloor, pcPdiffScaleFactor, pressCCEnable, pressCCOff, pressDiffHighMin, pressDiffLow, pressForelineLow, pressIonEnable, pressIonOff, pressRefrigOk, pressTurboLow, pressVacuum, speedFractTurboLow, tranTimeCryoGate, tranTimeHxGate));
        Assert.assertTrue((boolean)(item instanceof Vacuum_VacuumConfigurationEvent));
        Vacuum_VacuumConfigurationEvent item_ = (Vacuum_VacuumConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)cryoPScale, (double)item_.getCryoPScale(), (double)1.0E-6f);
        Assert.assertEquals((double)cryoPdiffFloor, (double)item_.getCryoPdiffFloor(), (double)1.0E-6f);
        Assert.assertEquals((double)delayCCOff, (double)item_.getDelayCCOff(), (double)1.0E-6f);
        Assert.assertEquals((double)hxPScale, (double)item_.getHxPScale(), (double)1.0E-6f);
        Assert.assertEquals((double)hxPdiffFloor, (double)item_.getHxPdiffFloor(), (double)1.0E-6f);
        Assert.assertEquals((double)pChangeStateUpdate, (double)item_.getPChangeStateUpdate(), (double)1.0E-6f);
        Assert.assertEquals((double)pFLChangeStateUpdate, (double)item_.getPFLChangeStateUpdate(), (double)1.0E-6f);
        Assert.assertEquals((double)pPCChangeStateUpdate, (double)item_.getPPCChangeStateUpdate(), (double)1.0E-6f);
        Assert.assertEquals((double)pcPdiffFloor, (double)item_.getPcPdiffFloor(), (double)1.0E-6f);
        Assert.assertEquals((double)pcPdiffScaleFactor, (double)item_.getPcPdiffScaleFactor(), (double)1.0E-6f);
        Assert.assertEquals((double)pressCCEnable, (double)item_.getPressCCEnable(), (double)1.0E-6f);
        Assert.assertEquals((double)pressCCOff, (double)item_.getPressCCOff(), (double)1.0E-6f);
        Assert.assertEquals((double)pressDiffHighMin, (double)item_.getPressDiffHighMin(), (double)1.0E-6f);
        Assert.assertEquals((double)pressDiffLow, (double)item_.getPressDiffLow(), (double)1.0E-6f);
        Assert.assertEquals((double)pressForelineLow, (double)item_.getPressForelineLow(), (double)1.0E-6f);
        Assert.assertEquals((double)pressIonEnable, (double)item_.getPressIonEnable(), (double)1.0E-6f);
        Assert.assertEquals((double)pressIonOff, (double)item_.getPressIonOff(), (double)1.0E-6f);
        Assert.assertEquals((double)pressRefrigOk, (double)item_.getPressRefrigOk(), (double)1.0E-6f);
        Assert.assertEquals((double)pressTurboLow, (double)item_.getPressTurboLow(), (double)1.0E-6f);
        Assert.assertEquals((double)pressVacuum, (double)item_.getPressVacuum(), (double)1.0E-6f);
        Assert.assertEquals((double)speedFractTurboLow, (double)item_.getSpeedFractTurboLow(), (double)1.0E-6f);
        Assert.assertEquals((long)tranTimeCryoGate, (long)item_.getTranTimeCryoGate());
        Assert.assertEquals((long)tranTimeHxGate, (long)item_.getTranTimeHxGate());
    }

    @Test
    public void sendReceiveDaq_monitor_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "";
        int schedulers_default_nTasks = 17;
        int schedulers_default_nThreads = 239;
        int schedulers_monitor_update_publish_scheduler_nTasks = 138;
        int schedulers_monitor_update_publish_scheduler_nThreads = 695;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_PeriodicTasks_GeneralConfigurationEvent));
        Daq_monitor_PeriodicTasks_GeneralConfigurationEvent item_ = (Daq_monitor_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveDaq_monitor_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "c";
        long agentmonitorservice_taskPeriodMillis = 207L;
        long heartbeat_taskPeriodMillis = 942L;
        long monitor_check_taskPeriodMillis = 115L;
        long monitor_publish_taskPeriodMillis = 592L;
        long monitor_update_taskPeriodMillis = 820L;
        long publishstats_taskPeriodMillis = 958L;
        long purgedaq_taskPeriodMillis = 980L;
        long runtimeinfo_taskPeriodMillis = 234L;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, publishstats_taskPeriodMillis, purgedaq_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_PeriodicTasks_timersConfigurationEvent));
        Daq_monitor_PeriodicTasks_timersConfigurationEvent item_ = (Daq_monitor_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)publishstats_taskPeriodMillis, (long)item_.getPublishstats_taskPeriodMillis());
        Assert.assertEquals((long)purgedaq_taskPeriodMillis, (long)item_.getPurgedaq_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveDaq_monitor_Stats_StatisticsConfigurationEvent() throws Exception {
        String version = "";
        int minDiffAlertWarning = 436;
        int minDiffLogWarning = 90;
        String sumDriverChecks = "g";
        String sumDriverStats = "";
        String sumFirmwareChecks = "n";
        String sumFirmwareStats = "";
        String sumRdsChecks = "";
        String sumRdsStats = "";
        String sumRmsChecks = "";
        String sumRmsStats = "";
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Stats_StatisticsConfigurationEvent(version, minDiffAlertWarning, minDiffLogWarning, sumDriverChecks, sumDriverStats, sumFirmwareChecks, sumFirmwareStats, sumRdsChecks, sumRdsStats, sumRmsChecks, sumRmsStats));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Stats_StatisticsConfigurationEvent));
        Daq_monitor_Stats_StatisticsConfigurationEvent item_ = (Daq_monitor_Stats_StatisticsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)minDiffAlertWarning, (long)item_.getMinDiffAlertWarning());
        Assert.assertEquals((long)minDiffLogWarning, (long)item_.getMinDiffLogWarning());
        Assert.assertEquals((Object)sumDriverChecks, (Object)item_.getSumDriverChecks());
        Assert.assertEquals((Object)sumDriverStats, (Object)item_.getSumDriverStats());
        Assert.assertEquals((Object)sumFirmwareChecks, (Object)item_.getSumFirmwareChecks());
        Assert.assertEquals((Object)sumFirmwareStats, (Object)item_.getSumFirmwareStats());
        Assert.assertEquals((Object)sumRdsChecks, (Object)item_.getSumRdsChecks());
        Assert.assertEquals((Object)sumRdsStats, (Object)item_.getSumRdsStats());
        Assert.assertEquals((Object)sumRmsChecks, (Object)item_.getSumRmsChecks());
        Assert.assertEquals((Object)sumRmsStats, (Object)item_.getSumRmsStats());
    }

    @Test
    public void sendReceiveDaq_monitor_StoreConfigurationEvent() throws Exception {
        String version = "";
        int alarmPurgeFailures = 294;
        String daqPartition = "a";
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_StoreConfigurationEvent(version, alarmPurgeFailures, daqPartition));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreConfigurationEvent));
        Daq_monitor_StoreConfigurationEvent item_ = (Daq_monitor_StoreConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)alarmPurgeFailures, (long)item_.getAlarmPurgeFailures());
        Assert.assertEquals((Object)daqPartition, (Object)item_.getDaqPartition());
    }

    @Test
    public void sendReceiveDaq_monitor_Store_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Store_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Store_DevicesConfigurationEvent));
        Daq_monitor_Store_DevicesConfigurationEvent item_ = (Daq_monitor_Store_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveDaq_monitor_Store_LimitsConfigurationEvent() throws Exception {
        String version = "t";
        double freefraction_warnLo = 0.726321f;
        double freefraction_limitLo = 0.7670446038246155;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Store_LimitsConfigurationEvent(version, freefraction_warnLo, freefraction_limitLo));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Store_LimitsConfigurationEvent));
        Daq_monitor_Store_LimitsConfigurationEvent item_ = (Daq_monitor_Store_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)freefraction_warnLo, (double)item_.getFreefraction_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)freefraction_limitLo, (double)item_.getFreefraction_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_Store_StoreConfigurationEvent() throws Exception {
        String version = "u";
        String daqFolder = "";
        boolean enableAutoPurge = false;
        double purgeTarget = 0.4904070496559143;
        double purgeThreshold = 0.6301425099372864;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Store_StoreConfigurationEvent(version, daqFolder, enableAutoPurge, purgeTarget, purgeThreshold));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Store_StoreConfigurationEvent));
        Daq_monitor_Store_StoreConfigurationEvent item_ = (Daq_monitor_Store_StoreConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)enableAutoPurge, (Object)item_.isEnableAutoPurge());
        Assert.assertEquals((double)purgeTarget, (double)item_.getPurgeTarget(), (double)1.0E-6f);
        Assert.assertEquals((double)purgeThreshold, (double)item_.getPurgeThreshold(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Ccd_HardwareIdConfigurationEvent() throws Exception {
        String version = "c";
        String location = "v";
        String manSerNum = "";
        String name = "s";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Ccd_HardwareIdConfigurationEvent(version, location, manSerNum, name));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Ccd_HardwareIdConfigurationEvent));
        Focal_plane_Ccd_HardwareIdConfigurationEvent item_ = (Focal_plane_Ccd_HardwareIdConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)manSerNum, (Object)item_.getManSerNum());
        Assert.assertEquals((Object)name, (Object)item_.getName());
    }

    @Test
    public void sendReceiveFocal_plane_Ccd_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double[] gdv_warnHi = TestHelper.generateDoubleArray((int)201, (int)-1359032259);
        double[] gdv_warnLo = TestHelper.generateDoubleArray((int)201, (int)2135127302);
        double[] gdv_limitHi = TestHelper.generateDoubleArray((int)201, (int)1986278168);
        double[] gdv_limitLo = TestHelper.generateDoubleArray((int)201, (int)1589897509);
        String location = "";
        double[] odi_warnHi = TestHelper.generateDoubleArray((int)201, (int)550689593);
        double[] odi_warnLo = TestHelper.generateDoubleArray((int)201, (int)-962582410);
        double[] odi_limitHi = TestHelper.generateDoubleArray((int)201, (int)-1000720779);
        double[] odi_limitLo = TestHelper.generateDoubleArray((int)201, (int)-809286900);
        double[] odv_warnHi = TestHelper.generateDoubleArray((int)201, (int)-179167573);
        double[] odv_warnLo = TestHelper.generateDoubleArray((int)201, (int)-1165499346);
        double[] odv_limitHi = TestHelper.generateDoubleArray((int)201, (int)852865567);
        double[] odv_limitLo = TestHelper.generateDoubleArray((int)201, (int)2059933909);
        double[] ogv_warnHi = TestHelper.generateDoubleArray((int)201, (int)1103407393);
        double[] ogv_warnLo = TestHelper.generateDoubleArray((int)201, (int)-1835208927);
        double[] ogv_limitHi = TestHelper.generateDoubleArray((int)201, (int)-692719423);
        double[] ogv_limitLo = TestHelper.generateDoubleArray((int)201, (int)429645039);
        double[] rdv_warnHi = TestHelper.generateDoubleArray((int)201, (int)97522462);
        double[] rdv_warnLo = TestHelper.generateDoubleArray((int)201, (int)811843655);
        double[] rdv_limitHi = TestHelper.generateDoubleArray((int)201, (int)1456150296);
        double[] rdv_limitLo = TestHelper.generateDoubleArray((int)201, (int)1110602704);
        double[] temp_warnHi = TestHelper.generateDoubleArray((int)201, (int)-1770108300);
        double[] temp_warnLo = TestHelper.generateDoubleArray((int)201, (int)1378296236);
        double[] temp_limitHi = TestHelper.generateDoubleArray((int)201, (int)1792636082);
        double[] temp_limitLo = TestHelper.generateDoubleArray((int)201, (int)221170015);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Ccd_LimitsConfigurationEvent(version, gdv_warnHi, gdv_warnLo, gdv_limitHi, gdv_limitLo, location, odi_warnHi, odi_warnLo, odi_limitHi, odi_limitLo, odv_warnHi, odv_warnLo, odv_limitHi, odv_limitLo, ogv_warnHi, ogv_warnLo, ogv_limitHi, ogv_limitLo, rdv_warnHi, rdv_warnLo, rdv_limitHi, rdv_limitLo, temp_warnHi, temp_warnLo, temp_limitHi, temp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Ccd_LimitsConfigurationEvent));
        Focal_plane_Ccd_LimitsConfigurationEvent item_ = (Focal_plane_Ccd_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])gdv_warnHi, (double[])item_.getGdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])gdv_warnLo, (double[])item_.getGdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])gdv_limitHi, (double[])item_.getGdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])gdv_limitLo, (double[])item_.getGdv_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])odi_warnHi, (double[])item_.getOdi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_warnLo, (double[])item_.getOdi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_limitHi, (double[])item_.getOdi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_limitLo, (double[])item_.getOdi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnHi, (double[])item_.getOdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnLo, (double[])item_.getOdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitHi, (double[])item_.getOdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitLo, (double[])item_.getOdv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_warnHi, (double[])item_.getOgv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_warnLo, (double[])item_.getOgv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_limitHi, (double[])item_.getOgv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_limitLo, (double[])item_.getOgv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_warnHi, (double[])item_.getRdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_warnLo, (double[])item_.getRdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_limitHi, (double[])item_.getRdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_limitLo, (double[])item_.getRdv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_warnHi, (double[])item_.getTemp_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_warnLo, (double[])item_.getTemp_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_limitHi, (double[])item_.getTemp_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_limitLo, (double[])item_.getTemp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Ccd_RaftsConfigurationEvent() throws Exception {
        String version = "";
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Ccd_RaftsConfigurationEvent(version, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Ccd_RaftsConfigurationEvent));
        Focal_plane_Ccd_RaftsConfigurationEvent item_ = (Focal_plane_Ccd_RaftsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFocal_plane_ImageDatabaseService_GeneralConfigurationEvent() throws Exception {
        String version = "l";
        String dbURL = "d";
        boolean enabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_ImageDatabaseService_GeneralConfigurationEvent(version, dbURL, enabled));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_ImageDatabaseService_GeneralConfigurationEvent));
        Focal_plane_ImageDatabaseService_GeneralConfigurationEvent item_ = (Focal_plane_ImageDatabaseService_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)dbURL, (Object)item_.getDbURL());
        Assert.assertEquals((Object)enabled, (Object)item_.isEnabled());
    }

    @Test
    public void sendReceiveFocal_plane_ImageNameService_GeneralConfigurationEvent() throws Exception {
        String version = "g";
        String controller = "e";
        String dbURL = "";
        String offset = "u";
        String source = "";
        String timeZoneId = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_ImageNameService_GeneralConfigurationEvent(version, controller, dbURL, offset, source, timeZoneId));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_ImageNameService_GeneralConfigurationEvent));
        Focal_plane_ImageNameService_GeneralConfigurationEvent item_ = (Focal_plane_ImageNameService_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)controller, (Object)item_.getController());
        Assert.assertEquals((Object)dbURL, (Object)item_.getDbURL());
        Assert.assertEquals((Object)offset, (Object)item_.getOffset());
        Assert.assertEquals((Object)source, (Object)item_.getSource());
        Assert.assertEquals((Object)timeZoneId, (Object)item_.getTimeZoneId());
    }

    @Test
    public void sendReceiveFocal_plane_InstrumentConfig_InstrumentConfigurationEvent() throws Exception {
        String version = "z";
        String instrument = "";
        String telescope = "t";
        String testStand = "r";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_InstrumentConfig_InstrumentConfigurationEvent(version, instrument, telescope, testStand));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_InstrumentConfig_InstrumentConfigurationEvent));
        Focal_plane_InstrumentConfig_InstrumentConfigurationEvent item_ = (Focal_plane_InstrumentConfig_InstrumentConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)instrument, (Object)item_.getInstrument());
        Assert.assertEquals((Object)telescope, (Object)item_.getTelescope());
        Assert.assertEquals((Object)testStand, (Object)item_.getTestStand());
    }

    @Test
    public void sendReceiveFocal_plane_MonitoringConfig_MonitoringConfigurationEvent() throws Exception {
        String version = "f";
        String postReadoutTriggerTasks = "";
        String readoutPauseTasks = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_MonitoringConfig_MonitoringConfigurationEvent(version, postReadoutTriggerTasks, readoutPauseTasks));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_MonitoringConfig_MonitoringConfigurationEvent));
        Focal_plane_MonitoringConfig_MonitoringConfigurationEvent item_ = (Focal_plane_MonitoringConfig_MonitoringConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)postReadoutTriggerTasks, (Object)item_.getPostReadoutTriggerTasks());
        Assert.assertEquals((Object)readoutPauseTasks, (Object)item_.getReadoutPauseTasks());
    }

    @Test
    public void sendReceiveFocal_plane_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "";
        int schedulers_default_nTasks = 912;
        int schedulers_default_nThreads = 861;
        int schedulers_monitor_check_scheduler_nTasks = 469;
        int schedulers_monitor_check_scheduler_nThreads = 96;
        int schedulers_monitor_update_publish_scheduler_nTasks = 775;
        int schedulers_monitor_update_publish_scheduler_nThreads = 904;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_check_scheduler_nTasks, schedulers_monitor_check_scheduler_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_PeriodicTasks_GeneralConfigurationEvent));
        Focal_plane_PeriodicTasks_GeneralConfigurationEvent item_ = (Focal_plane_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nTasks, (long)item_.getSchedulers_monitor_check_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nThreads, (long)item_.getSchedulers_monitor_check_scheduler_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveFocal_plane_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "f";
        long agentmonitorservice_taskPeriodMillis = 111L;
        long heartbeat_taskPeriodMillis = 860L;
        long monitor_publish_taskPeriodMillis = 694L;
        long monitor_update_taskPeriodMillis = 773L;
        long runtimeinfo_taskPeriodMillis = 189L;
        long tempcontrol_R00_taskPeriodMillis = 833L;
        long tempcontrol_R01_taskPeriodMillis = 411L;
        long tempcontrol_R02_taskPeriodMillis = 980L;
        long tempcontrol_R03_taskPeriodMillis = 134L;
        long tempcontrol_R04_taskPeriodMillis = 563L;
        long tempcontrol_R10_taskPeriodMillis = 31L;
        long tempcontrol_R11_taskPeriodMillis = 792L;
        long tempcontrol_R12_taskPeriodMillis = 794L;
        long tempcontrol_R13_taskPeriodMillis = 390L;
        long tempcontrol_R14_taskPeriodMillis = 477L;
        long tempcontrol_R20_taskPeriodMillis = 498L;
        long tempcontrol_R21_taskPeriodMillis = 222L;
        long tempcontrol_R22_taskPeriodMillis = 444L;
        long tempcontrol_R23_taskPeriodMillis = 478L;
        long tempcontrol_R24_taskPeriodMillis = 830L;
        long tempcontrol_R30_taskPeriodMillis = 85L;
        long tempcontrol_R31_taskPeriodMillis = 730L;
        long tempcontrol_R32_taskPeriodMillis = 802L;
        long tempcontrol_R33_taskPeriodMillis = 730L;
        long tempcontrol_R34_taskPeriodMillis = 403L;
        long tempcontrol_R40_taskPeriodMillis = 369L;
        long tempcontrol_R41_taskPeriodMillis = 186L;
        long tempcontrol_R42_taskPeriodMillis = 652L;
        long tempcontrol_R43_taskPeriodMillis = 902L;
        long tempcontrol_R44_taskPeriodMillis = 752L;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, runtimeinfo_taskPeriodMillis, tempcontrol_R00_taskPeriodMillis, tempcontrol_R01_taskPeriodMillis, tempcontrol_R02_taskPeriodMillis, tempcontrol_R03_taskPeriodMillis, tempcontrol_R04_taskPeriodMillis, tempcontrol_R10_taskPeriodMillis, tempcontrol_R11_taskPeriodMillis, tempcontrol_R12_taskPeriodMillis, tempcontrol_R13_taskPeriodMillis, tempcontrol_R14_taskPeriodMillis, tempcontrol_R20_taskPeriodMillis, tempcontrol_R21_taskPeriodMillis, tempcontrol_R22_taskPeriodMillis, tempcontrol_R23_taskPeriodMillis, tempcontrol_R24_taskPeriodMillis, tempcontrol_R30_taskPeriodMillis, tempcontrol_R31_taskPeriodMillis, tempcontrol_R32_taskPeriodMillis, tempcontrol_R33_taskPeriodMillis, tempcontrol_R34_taskPeriodMillis, tempcontrol_R40_taskPeriodMillis, tempcontrol_R41_taskPeriodMillis, tempcontrol_R42_taskPeriodMillis, tempcontrol_R43_taskPeriodMillis, tempcontrol_R44_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_PeriodicTasks_timersConfigurationEvent));
        Focal_plane_PeriodicTasks_timersConfigurationEvent item_ = (Focal_plane_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R00_taskPeriodMillis, (long)item_.getTempcontrol_R00_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R01_taskPeriodMillis, (long)item_.getTempcontrol_R01_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R02_taskPeriodMillis, (long)item_.getTempcontrol_R02_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R03_taskPeriodMillis, (long)item_.getTempcontrol_R03_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R04_taskPeriodMillis, (long)item_.getTempcontrol_R04_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R10_taskPeriodMillis, (long)item_.getTempcontrol_R10_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R11_taskPeriodMillis, (long)item_.getTempcontrol_R11_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R12_taskPeriodMillis, (long)item_.getTempcontrol_R12_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R13_taskPeriodMillis, (long)item_.getTempcontrol_R13_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R14_taskPeriodMillis, (long)item_.getTempcontrol_R14_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R20_taskPeriodMillis, (long)item_.getTempcontrol_R20_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R21_taskPeriodMillis, (long)item_.getTempcontrol_R21_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R22_taskPeriodMillis, (long)item_.getTempcontrol_R22_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R23_taskPeriodMillis, (long)item_.getTempcontrol_R23_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R24_taskPeriodMillis, (long)item_.getTempcontrol_R24_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R30_taskPeriodMillis, (long)item_.getTempcontrol_R30_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R31_taskPeriodMillis, (long)item_.getTempcontrol_R31_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R32_taskPeriodMillis, (long)item_.getTempcontrol_R32_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R33_taskPeriodMillis, (long)item_.getTempcontrol_R33_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R34_taskPeriodMillis, (long)item_.getTempcontrol_R34_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R40_taskPeriodMillis, (long)item_.getTempcontrol_R40_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R41_taskPeriodMillis, (long)item_.getTempcontrol_R41_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R42_taskPeriodMillis, (long)item_.getTempcontrol_R42_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R43_taskPeriodMillis, (long)item_.getTempcontrol_R43_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R44_taskPeriodMillis, (long)item_.getTempcontrol_R44_taskPeriodMillis());
    }

    @Test
    public void sendReceiveFocal_plane_Raft_HardwareIdConfigurationEvent() throws Exception {
        String version = "d";
        String location = "m";
        String name = "x";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Raft_HardwareIdConfigurationEvent(version, location, name));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Raft_HardwareIdConfigurationEvent));
        Focal_plane_Raft_HardwareIdConfigurationEvent item_ = (Focal_plane_Raft_HardwareIdConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)name, (Object)item_.getName());
    }

    @Test
    public void sendReceiveFocal_plane_Raft_RaftTempControlConfigurationEvent() throws Exception {
        String version = "";
        String location = "c";
        double[] tempcontrol_basePower = TestHelper.generateDoubleArray((int)25, (int)-1278338309);
        double[] tempcontrol_coefD = TestHelper.generateDoubleArray((int)25, (int)2039555838);
        double[] tempcontrol_coefI = TestHelper.generateDoubleArray((int)25, (int)1330822405);
        double[] tempcontrol_coefP = TestHelper.generateDoubleArray((int)25, (int)-2002039584);
        double[] tempcontrol_maxInput = TestHelper.generateDoubleArray((int)25, (int)-1902015946);
        double[] tempcontrol_maxOutput = TestHelper.generateDoubleArray((int)25, (int)1541208417);
        double[] tempcontrol_minInput = TestHelper.generateDoubleArray((int)25, (int)623647123);
        double[] tempcontrol_minOutput = TestHelper.generateDoubleArray((int)25, (int)330571025);
        String tempcontrol_rebs = "";
        double[] tempcontrol_setTemp = TestHelper.generateDoubleArray((int)25, (int)-47730374);
        double[] tempcontrol_smoothTime = TestHelper.generateDoubleArray((int)25, (int)-506649428);
        String tempcontrol_tempChans = "";
        double[] tempcontrol_timeConst = TestHelper.generateDoubleArray((int)25, (int)1094681586);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Raft_RaftTempControlConfigurationEvent(version, location, tempcontrol_basePower, tempcontrol_coefD, tempcontrol_coefI, tempcontrol_coefP, tempcontrol_maxInput, tempcontrol_maxOutput, tempcontrol_minInput, tempcontrol_minOutput, tempcontrol_rebs, tempcontrol_setTemp, tempcontrol_smoothTime, tempcontrol_tempChans, tempcontrol_timeConst));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Raft_RaftTempControlConfigurationEvent));
        Focal_plane_Raft_RaftTempControlConfigurationEvent item_ = (Focal_plane_Raft_RaftTempControlConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])tempcontrol_basePower, (double[])item_.getTempcontrol_basePower(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_coefD, (double[])item_.getTempcontrol_coefD(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_coefI, (double[])item_.getTempcontrol_coefI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_coefP, (double[])item_.getTempcontrol_coefP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_maxInput, (double[])item_.getTempcontrol_maxInput(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_maxOutput, (double[])item_.getTempcontrol_maxOutput(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_minInput, (double[])item_.getTempcontrol_minInput(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_minOutput, (double[])item_.getTempcontrol_minOutput(), (double)1.0E-6f);
        Assert.assertEquals((Object)tempcontrol_rebs, (Object)item_.getTempcontrol_rebs());
        Assert.assertArrayEquals((double[])tempcontrol_setTemp, (double[])item_.getTempcontrol_setTemp(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_smoothTime, (double[])item_.getTempcontrol_smoothTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)tempcontrol_tempChans, (Object)item_.getTempcontrol_tempChans());
        Assert.assertArrayEquals((double[])tempcontrol_timeConst, (double[])item_.getTempcontrol_timeConst(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Raft_RaftTempControlStatusConfigurationEvent() throws Exception {
        String version = "";
        String location = "";
        boolean[] tempcontrol_active = new boolean[]{false, false, false, false, false, false, true, false, false, true, false, false, true, true, false, true, false, true, false, false, true, true, false, false, true};
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Raft_RaftTempControlStatusConfigurationEvent(version, location, tempcontrol_active));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Raft_RaftTempControlStatusConfigurationEvent));
        Focal_plane_Raft_RaftTempControlStatusConfigurationEvent item_ = (Focal_plane_Raft_RaftTempControlStatusConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((boolean[])tempcontrol_active, (boolean[])item_.getTempcontrol_active());
    }

    @Test
    public void sendReceiveFocal_plane_RebTotalPower_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.6325410604476929;
        double warnLo = 0.5006039142608643;
        double limitHi = 0.6652114987373352;
        double limitLo = 0.416421f;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_RebTotalPower_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTotalPower_LimitsConfigurationEvent));
        Focal_plane_RebTotalPower_LimitsConfigurationEvent item_ = (Focal_plane_RebTotalPower_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Reb_DevicesConfigurationEvent() throws Exception {
        String version = "r";
        boolean[] disabled = new boolean[]{false, true, false, true, true, false, false, false, true, true, false, false, false, true, true, true, true, true, true, false, true, true, true, true, false, true, true, true, true, false, false, true, false, true, false, false, false, false, true, false, false, true, false, false, false, true, true, true, false, false, false, true, false, false, false, true, true, true, false, false, false, false, true, true, true, true, false, false, true, false, true};
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_DevicesConfigurationEvent(version, disabled, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_DevicesConfigurationEvent));
        Focal_plane_Reb_DevicesConfigurationEvent item_ = (Focal_plane_Reb_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((boolean[])disabled, (boolean[])item_.getDisabled());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_HardwareIdConfigurationEvent() throws Exception {
        String version = "";
        String location = "";
        String name = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_HardwareIdConfigurationEvent(version, location, name));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_HardwareIdConfigurationEvent));
        Focal_plane_Reb_HardwareIdConfigurationEvent item_ = (Focal_plane_Reb_HardwareIdConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)name, (Object)item_.getName());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_LimitsConfigurationEvent() throws Exception {
        String version = "e";
        double[] anai_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1507305742);
        double[] anai_warnLo = TestHelper.generateDoubleArray((int)71, (int)-961976840);
        double[] anai_limitHi = TestHelper.generateDoubleArray((int)71, (int)1870501135);
        double[] anai_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1783386345);
        double[] anav_warnHi = TestHelper.generateDoubleArray((int)71, (int)1513942121);
        double[] anav_warnLo = TestHelper.generateDoubleArray((int)71, (int)887792969);
        double[] anav_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1863507351);
        double[] anav_limitLo = TestHelper.generateDoubleArray((int)71, (int)2031843969);
        double[] aspicl_Temp0_warnHi = TestHelper.generateDoubleArray((int)71, (int)-409552791);
        double[] aspicl_Temp0_warnLo = TestHelper.generateDoubleArray((int)71, (int)1826744715);
        double[] aspicl_Temp0_limitHi = TestHelper.generateDoubleArray((int)71, (int)-657114909);
        double[] aspicl_Temp0_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1807767098);
        double[] aspicl_Temp1_warnHi = TestHelper.generateDoubleArray((int)71, (int)1345297660);
        double[] aspicl_Temp1_warnLo = TestHelper.generateDoubleArray((int)71, (int)248277560);
        double[] aspicl_Temp1_limitHi = TestHelper.generateDoubleArray((int)71, (int)-974292004);
        double[] aspicl_Temp1_limitLo = TestHelper.generateDoubleArray((int)71, (int)-593605335);
        double[] aspicl_Temp2_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1503864969);
        double[] aspicl_Temp2_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1849363735);
        double[] aspicl_Temp2_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1899043159);
        double[] aspicl_Temp2_limitLo = TestHelper.generateDoubleArray((int)71, (int)743987566);
        double[] aspicu_Temp0_warnHi = TestHelper.generateDoubleArray((int)71, (int)-303545634);
        double[] aspicu_Temp0_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1185218584);
        double[] aspicu_Temp0_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1486360682);
        double[] aspicu_Temp0_limitLo = TestHelper.generateDoubleArray((int)71, (int)734668936);
        double[] aspicu_Temp1_warnHi = TestHelper.generateDoubleArray((int)71, (int)1402002566);
        double[] aspicu_Temp1_warnLo = TestHelper.generateDoubleArray((int)71, (int)765890563);
        double[] aspicu_Temp1_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1755228373);
        double[] aspicu_Temp1_limitLo = TestHelper.generateDoubleArray((int)71, (int)928960918);
        double[] aspicu_Temp2_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1778618628);
        double[] aspicu_Temp2_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1947811934);
        double[] aspicu_Temp2_limitHi = TestHelper.generateDoubleArray((int)71, (int)-613800017);
        double[] aspicu_Temp2_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1708356592);
        double[] clkhi_warnHi = TestHelper.generateDoubleArray((int)71, (int)123635493);
        double[] clkhi_warnLo = TestHelper.generateDoubleArray((int)71, (int)1342603548);
        double[] clkhi_limitHi = TestHelper.generateDoubleArray((int)71, (int)1439017201);
        double[] clkhi_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1273523651);
        double[] clkhv_warnHi = TestHelper.generateDoubleArray((int)71, (int)2092373926);
        double[] clkhv_warnLo = TestHelper.generateDoubleArray((int)71, (int)1363412549);
        double[] clkhv_limitHi = TestHelper.generateDoubleArray((int)71, (int)1994280005);
        double[] clkhv_limitLo = TestHelper.generateDoubleArray((int)71, (int)1276917480);
        double[] clkli_warnHi = TestHelper.generateDoubleArray((int)71, (int)13463173);
        double[] clkli_warnLo = TestHelper.generateDoubleArray((int)71, (int)451718987);
        double[] clkli_limitHi = TestHelper.generateDoubleArray((int)71, (int)-515058483);
        double[] clkli_limitLo = TestHelper.generateDoubleArray((int)71, (int)-331865518);
        double[] clklv_warnHi = TestHelper.generateDoubleArray((int)71, (int)1278370064);
        double[] clklv_warnLo = TestHelper.generateDoubleArray((int)71, (int)652776130);
        double[] clklv_limitHi = TestHelper.generateDoubleArray((int)71, (int)2113093625);
        double[] clklv_limitLo = TestHelper.generateDoubleArray((int)71, (int)1869998698);
        double[] digi_warnHi = TestHelper.generateDoubleArray((int)71, (int)316592637);
        double[] digi_warnLo = TestHelper.generateDoubleArray((int)71, (int)938341116);
        double[] digi_limitHi = TestHelper.generateDoubleArray((int)71, (int)549401168);
        double[] digi_limitLo = TestHelper.generateDoubleArray((int)71, (int)320698939);
        double[] digv_warnHi = TestHelper.generateDoubleArray((int)71, (int)-911084078);
        double[] digv_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1511639906);
        double[] digv_limitHi = TestHelper.generateDoubleArray((int)71, (int)1839197295);
        double[] digv_limitLo = TestHelper.generateDoubleArray((int)71, (int)1161755813);
        double[] hvbiasswitch_warnHi = TestHelper.generateDoubleArray((int)71, (int)-597362297);
        double[] hvbiasswitch_warnLo = TestHelper.generateDoubleArray((int)71, (int)361966191);
        double[] hvbiasswitch_limitHi = TestHelper.generateDoubleArray((int)71, (int)1266158674);
        double[] hvbiasswitch_limitLo = TestHelper.generateDoubleArray((int)71, (int)-336249265);
        double[] htrpi_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1916801175);
        double[] htrpi_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1776498061);
        double[] htrpi_limitHi = TestHelper.generateDoubleArray((int)71, (int)278109906);
        double[] htrpi_limitLo = TestHelper.generateDoubleArray((int)71, (int)85441244);
        double[] htrpv_warnHi = TestHelper.generateDoubleArray((int)71, (int)842409536);
        double[] htrpv_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1726177224);
        double[] htrpv_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1515240082);
        double[] htrpv_limitLo = TestHelper.generateDoubleArray((int)71, (int)-991704740);
        double[] htrv_warnHi = TestHelper.generateDoubleArray((int)71, (int)-825340236);
        double[] htrv_warnLo = TestHelper.generateDoubleArray((int)71, (int)1564315758);
        double[] htrv_limitHi = TestHelper.generateDoubleArray((int)71, (int)438662221);
        double[] htrv_limitLo = TestHelper.generateDoubleArray((int)71, (int)-156787708);
        double[] htrw_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1247997204);
        double[] htrw_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1243889219);
        double[] htrw_limitHi = TestHelper.generateDoubleArray((int)71, (int)-912061309);
        double[] htrw_limitLo = TestHelper.generateDoubleArray((int)71, (int)2079393570);
        String location = "r";
        double[] odi_warnHi = TestHelper.generateDoubleArray((int)71, (int)34920083);
        double[] odi_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1200798902);
        double[] odi_limitHi = TestHelper.generateDoubleArray((int)71, (int)724108399);
        double[] odi_limitLo = TestHelper.generateDoubleArray((int)71, (int)-2002967109);
        double[] odv_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1819041484);
        double[] odv_warnLo = TestHelper.generateDoubleArray((int)71, (int)1371938517);
        double[] odv_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1493923365);
        double[] odv_limitLo = TestHelper.generateDoubleArray((int)71, (int)-252282763);
        double[] pclk0_warnHi = TestHelper.generateDoubleArray((int)71, (int)1680672856);
        double[] pclk0_warnLo = TestHelper.generateDoubleArray((int)71, (int)1855738507);
        double[] pclk0_limitHi = TestHelper.generateDoubleArray((int)71, (int)-935368107);
        double[] pclk0_limitLo = TestHelper.generateDoubleArray((int)71, (int)719119042);
        double[] pclk1_warnHi = TestHelper.generateDoubleArray((int)71, (int)-758962071);
        double[] pclk1_warnLo = TestHelper.generateDoubleArray((int)71, (int)92663199);
        double[] pclk1_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1756559124);
        double[] pclk1_limitLo = TestHelper.generateDoubleArray((int)71, (int)-731903682);
        double[] pclkl_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1222786603);
        double[] pclkl_warnLo = TestHelper.generateDoubleArray((int)71, (int)2146634971);
        double[] pclkl_limitHi = TestHelper.generateDoubleArray((int)71, (int)1477513035);
        double[] pclkl_limitLo = TestHelper.generateDoubleArray((int)71, (int)1858024884);
        double[] pclku_warnHi = TestHelper.generateDoubleArray((int)71, (int)904630476);
        double[] pclku_warnLo = TestHelper.generateDoubleArray((int)71, (int)340414747);
        double[] pclku_limitHi = TestHelper.generateDoubleArray((int)71, (int)1168774426);
        double[] pclku_limitLo = TestHelper.generateDoubleArray((int)71, (int)1815508141);
        double[] power_warnHi = TestHelper.generateDoubleArray((int)71, (int)-2045059768);
        double[] power_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1716401921);
        double[] power_limitHi = TestHelper.generateDoubleArray((int)71, (int)-892020317);
        double[] power_limitLo = TestHelper.generateDoubleArray((int)71, (int)436697162);
        double[] rg0_warnHi = TestHelper.generateDoubleArray((int)71, (int)-2049145011);
        double[] rg0_warnLo = TestHelper.generateDoubleArray((int)71, (int)-32488997);
        double[] rg0_limitHi = TestHelper.generateDoubleArray((int)71, (int)673641400);
        double[] rg0_limitLo = TestHelper.generateDoubleArray((int)71, (int)-5417901);
        double[] rg1_warnHi = TestHelper.generateDoubleArray((int)71, (int)2031424369);
        double[] rg1_warnLo = TestHelper.generateDoubleArray((int)71, (int)-283233294);
        double[] rg1_limitHi = TestHelper.generateDoubleArray((int)71, (int)2087328724);
        double[] rg1_limitLo = TestHelper.generateDoubleArray((int)71, (int)59205519);
        double[] rgl_warnHi = TestHelper.generateDoubleArray((int)71, (int)624130975);
        double[] rgl_warnLo = TestHelper.generateDoubleArray((int)71, (int)555531748);
        double[] rgl_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1386253184);
        double[] rgl_limitLo = TestHelper.generateDoubleArray((int)71, (int)1832453717);
        double[] rgu_warnHi = TestHelper.generateDoubleArray((int)71, (int)1604175895);
        double[] rgu_warnLo = TestHelper.generateDoubleArray((int)71, (int)205284196);
        double[] rgu_limitHi = TestHelper.generateDoubleArray((int)71, (int)1103394040);
        double[] rgu_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1413432733);
        double[] rtdtemp_warnHi = TestHelper.generateDoubleArray((int)71, (int)-127945544);
        double[] rtdtemp_warnLo = TestHelper.generateDoubleArray((int)71, (int)337937197);
        double[] rtdtemp_limitHi = TestHelper.generateDoubleArray((int)71, (int)1055480334);
        double[] rtdtemp_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1574753299);
        double[] ref05v_warnHi = TestHelper.generateDoubleArray((int)71, (int)583526017);
        double[] ref05v_warnLo = TestHelper.generateDoubleArray((int)71, (int)514308150);
        double[] ref05v_limitHi = TestHelper.generateDoubleArray((int)71, (int)381894989);
        double[] ref05v_limitLo = TestHelper.generateDoubleArray((int)71, (int)-2035087367);
        double[] ref125v_warnHi = TestHelper.generateDoubleArray((int)71, (int)1298429269);
        double[] ref125v_warnLo = TestHelper.generateDoubleArray((int)71, (int)1723898404);
        double[] ref125v_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1788718496);
        double[] ref125v_limitLo = TestHelper.generateDoubleArray((int)71, (int)130054121);
        double[] ref15v_warnHi = TestHelper.generateDoubleArray((int)71, (int)-90714626);
        double[] ref15v_warnLo = TestHelper.generateDoubleArray((int)71, (int)1253413119);
        double[] ref15v_limitHi = TestHelper.generateDoubleArray((int)71, (int)408328885);
        double[] ref15v_limitLo = TestHelper.generateDoubleArray((int)71, (int)839908953);
        double[] ref25v_warnHi = TestHelper.generateDoubleArray((int)71, (int)386609267);
        double[] ref25v_warnLo = TestHelper.generateDoubleArray((int)71, (int)1459204136);
        double[] ref25v_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1508606115);
        double[] ref25v_limitLo = TestHelper.generateDoubleArray((int)71, (int)1528941866);
        double[] refn12_warnHi = TestHelper.generateDoubleArray((int)71, (int)-2083238307);
        double[] refn12_warnLo = TestHelper.generateDoubleArray((int)71, (int)2118896778);
        double[] refn12_limitHi = TestHelper.generateDoubleArray((int)71, (int)1360259381);
        double[] refn12_limitLo = TestHelper.generateDoubleArray((int)71, (int)1078978783);
        double[] refp12_warnHi = TestHelper.generateDoubleArray((int)71, (int)-747123241);
        double[] refp12_warnLo = TestHelper.generateDoubleArray((int)71, (int)1509179920);
        double[] refp12_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1334603958);
        double[] refp12_limitLo = TestHelper.generateDoubleArray((int)71, (int)1700441383);
        double[] sclk0_warnHi = TestHelper.generateDoubleArray((int)71, (int)1531622517);
        double[] sclk0_warnLo = TestHelper.generateDoubleArray((int)71, (int)907353174);
        double[] sclk0_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1063517319);
        double[] sclk0_limitLo = TestHelper.generateDoubleArray((int)71, (int)375424698);
        double[] sclk1_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1034879352);
        double[] sclk1_warnLo = TestHelper.generateDoubleArray((int)71, (int)1292342946);
        double[] sclk1_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1208720042);
        double[] sclk1_limitLo = TestHelper.generateDoubleArray((int)71, (int)-206113176);
        double[] sclkl_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1277696353);
        double[] sclkl_warnLo = TestHelper.generateDoubleArray((int)71, (int)-721606891);
        double[] sclkl_limitHi = TestHelper.generateDoubleArray((int)71, (int)-260776113);
        double[] sclkl_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1763167890);
        double[] sclku_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1561419441);
        double[] sclku_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1010202339);
        double[] sclku_limitHi = TestHelper.generateDoubleArray((int)71, (int)83972624);
        double[] sclku_limitLo = TestHelper.generateDoubleArray((int)71, (int)1081733899);
        double[] temp10_warnHi = TestHelper.generateDoubleArray((int)71, (int)-188182217);
        double[] temp10_warnLo = TestHelper.generateDoubleArray((int)71, (int)-2128708819);
        double[] temp10_limitHi = TestHelper.generateDoubleArray((int)71, (int)1530450471);
        double[] temp10_limitLo = TestHelper.generateDoubleArray((int)71, (int)-78163118);
        double[] temp1_warnHi = TestHelper.generateDoubleArray((int)71, (int)255866686);
        double[] temp1_warnLo = TestHelper.generateDoubleArray((int)71, (int)785982384);
        double[] temp1_limitHi = TestHelper.generateDoubleArray((int)71, (int)504159211);
        double[] temp1_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1241467071);
        double[] temp2_warnHi = TestHelper.generateDoubleArray((int)71, (int)-832412898);
        double[] temp2_warnLo = TestHelper.generateDoubleArray((int)71, (int)-192130758);
        double[] temp2_limitHi = TestHelper.generateDoubleArray((int)71, (int)-448962150);
        double[] temp2_limitLo = TestHelper.generateDoubleArray((int)71, (int)1212296723);
        double[] temp3_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1403164634);
        double[] temp3_warnLo = TestHelper.generateDoubleArray((int)71, (int)-2039346688);
        double[] temp3_limitHi = TestHelper.generateDoubleArray((int)71, (int)134551489);
        double[] temp3_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1755197486);
        double[] temp4_warnHi = TestHelper.generateDoubleArray((int)71, (int)1520982587);
        double[] temp4_warnLo = TestHelper.generateDoubleArray((int)71, (int)1403133578);
        double[] temp4_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1475107872);
        double[] temp4_limitLo = TestHelper.generateDoubleArray((int)71, (int)1069347119);
        double[] temp5_warnHi = TestHelper.generateDoubleArray((int)71, (int)-705521889);
        double[] temp5_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1156402266);
        double[] temp5_limitHi = TestHelper.generateDoubleArray((int)71, (int)-2086039219);
        double[] temp5_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1562099563);
        double[] temp6_warnHi = TestHelper.generateDoubleArray((int)71, (int)-794025995);
        double[] temp6_warnLo = TestHelper.generateDoubleArray((int)71, (int)-440207457);
        double[] temp6_limitHi = TestHelper.generateDoubleArray((int)71, (int)1552167000);
        double[] temp6_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1850466181);
        double[] temp7_warnHi = TestHelper.generateDoubleArray((int)71, (int)503023364);
        double[] temp7_warnLo = TestHelper.generateDoubleArray((int)71, (int)1841264303);
        double[] temp7_limitHi = TestHelper.generateDoubleArray((int)71, (int)1803928495);
        double[] temp7_limitLo = TestHelper.generateDoubleArray((int)71, (int)870830841);
        double[] temp8_warnHi = TestHelper.generateDoubleArray((int)71, (int)150894011);
        double[] temp8_warnLo = TestHelper.generateDoubleArray((int)71, (int)-2135768399);
        double[] temp8_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1058496508);
        double[] temp8_limitLo = TestHelper.generateDoubleArray((int)71, (int)1333480094);
        double[] temp9_warnHi = TestHelper.generateDoubleArray((int)71, (int)-159510796);
        double[] temp9_warnLo = TestHelper.generateDoubleArray((int)71, (int)1487692314);
        double[] temp9_limitHi = TestHelper.generateDoubleArray((int)71, (int)1284645356);
        double[] temp9_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1021791104);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_LimitsConfigurationEvent(version, anai_warnHi, anai_warnLo, anai_limitHi, anai_limitLo, anav_warnHi, anav_warnLo, anav_limitHi, anav_limitLo, aspicl_Temp0_warnHi, aspicl_Temp0_warnLo, aspicl_Temp0_limitHi, aspicl_Temp0_limitLo, aspicl_Temp1_warnHi, aspicl_Temp1_warnLo, aspicl_Temp1_limitHi, aspicl_Temp1_limitLo, aspicl_Temp2_warnHi, aspicl_Temp2_warnLo, aspicl_Temp2_limitHi, aspicl_Temp2_limitLo, aspicu_Temp0_warnHi, aspicu_Temp0_warnLo, aspicu_Temp0_limitHi, aspicu_Temp0_limitLo, aspicu_Temp1_warnHi, aspicu_Temp1_warnLo, aspicu_Temp1_limitHi, aspicu_Temp1_limitLo, aspicu_Temp2_warnHi, aspicu_Temp2_warnLo, aspicu_Temp2_limitHi, aspicu_Temp2_limitLo, clkhi_warnHi, clkhi_warnLo, clkhi_limitHi, clkhi_limitLo, clkhv_warnHi, clkhv_warnLo, clkhv_limitHi, clkhv_limitLo, clkli_warnHi, clkli_warnLo, clkli_limitHi, clkli_limitLo, clklv_warnHi, clklv_warnLo, clklv_limitHi, clklv_limitLo, digi_warnHi, digi_warnLo, digi_limitHi, digi_limitLo, digv_warnHi, digv_warnLo, digv_limitHi, digv_limitLo, hvbiasswitch_warnHi, hvbiasswitch_warnLo, hvbiasswitch_limitHi, hvbiasswitch_limitLo, htrpi_warnHi, htrpi_warnLo, htrpi_limitHi, htrpi_limitLo, htrpv_warnHi, htrpv_warnLo, htrpv_limitHi, htrpv_limitLo, htrv_warnHi, htrv_warnLo, htrv_limitHi, htrv_limitLo, htrw_warnHi, htrw_warnLo, htrw_limitHi, htrw_limitLo, location, odi_warnHi, odi_warnLo, odi_limitHi, odi_limitLo, odv_warnHi, odv_warnLo, odv_limitHi, odv_limitLo, pclk0_warnHi, pclk0_warnLo, pclk0_limitHi, pclk0_limitLo, pclk1_warnHi, pclk1_warnLo, pclk1_limitHi, pclk1_limitLo, pclkl_warnHi, pclkl_warnLo, pclkl_limitHi, pclkl_limitLo, pclku_warnHi, pclku_warnLo, pclku_limitHi, pclku_limitLo, power_warnHi, power_warnLo, power_limitHi, power_limitLo, rg0_warnHi, rg0_warnLo, rg0_limitHi, rg0_limitLo, rg1_warnHi, rg1_warnLo, rg1_limitHi, rg1_limitLo, rgl_warnHi, rgl_warnLo, rgl_limitHi, rgl_limitLo, rgu_warnHi, rgu_warnLo, rgu_limitHi, rgu_limitLo, rtdtemp_warnHi, rtdtemp_warnLo, rtdtemp_limitHi, rtdtemp_limitLo, ref05v_warnHi, ref05v_warnLo, ref05v_limitHi, ref05v_limitLo, ref125v_warnHi, ref125v_warnLo, ref125v_limitHi, ref125v_limitLo, ref15v_warnHi, ref15v_warnLo, ref15v_limitHi, ref15v_limitLo, ref25v_warnHi, ref25v_warnLo, ref25v_limitHi, ref25v_limitLo, refn12_warnHi, refn12_warnLo, refn12_limitHi, refn12_limitLo, refp12_warnHi, refp12_warnLo, refp12_limitHi, refp12_limitLo, sclk0_warnHi, sclk0_warnLo, sclk0_limitHi, sclk0_limitLo, sclk1_warnHi, sclk1_warnLo, sclk1_limitHi, sclk1_limitLo, sclkl_warnHi, sclkl_warnLo, sclkl_limitHi, sclkl_limitLo, sclku_warnHi, sclku_warnLo, sclku_limitHi, sclku_limitLo, temp10_warnHi, temp10_warnLo, temp10_limitHi, temp10_limitLo, temp1_warnHi, temp1_warnLo, temp1_limitHi, temp1_limitLo, temp2_warnHi, temp2_warnLo, temp2_limitHi, temp2_limitLo, temp3_warnHi, temp3_warnLo, temp3_limitHi, temp3_limitLo, temp4_warnHi, temp4_warnLo, temp4_limitHi, temp4_limitLo, temp5_warnHi, temp5_warnLo, temp5_limitHi, temp5_limitLo, temp6_warnHi, temp6_warnLo, temp6_limitHi, temp6_limitLo, temp7_warnHi, temp7_warnLo, temp7_limitHi, temp7_limitLo, temp8_warnHi, temp8_warnLo, temp8_limitHi, temp8_limitLo, temp9_warnHi, temp9_warnLo, temp9_limitHi, temp9_limitLo));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_LimitsConfigurationEvent));
        Focal_plane_Reb_LimitsConfigurationEvent item_ = (Focal_plane_Reb_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])anai_warnHi, (double[])item_.getAnai_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anai_warnLo, (double[])item_.getAnai_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anai_limitHi, (double[])item_.getAnai_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anai_limitLo, (double[])item_.getAnai_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_warnHi, (double[])item_.getAnav_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_warnLo, (double[])item_.getAnav_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_limitHi, (double[])item_.getAnav_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_limitLo, (double[])item_.getAnav_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_warnHi, (double[])item_.getAspicl_Temp0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_warnLo, (double[])item_.getAspicl_Temp0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_limitHi, (double[])item_.getAspicl_Temp0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_limitLo, (double[])item_.getAspicl_Temp0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1_warnHi, (double[])item_.getAspicl_Temp1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1_warnLo, (double[])item_.getAspicl_Temp1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1_limitHi, (double[])item_.getAspicl_Temp1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1_limitLo, (double[])item_.getAspicl_Temp1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2_warnHi, (double[])item_.getAspicl_Temp2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2_warnLo, (double[])item_.getAspicl_Temp2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2_limitHi, (double[])item_.getAspicl_Temp2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2_limitLo, (double[])item_.getAspicl_Temp2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_warnHi, (double[])item_.getAspicu_Temp0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_warnLo, (double[])item_.getAspicu_Temp0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_limitHi, (double[])item_.getAspicu_Temp0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_limitLo, (double[])item_.getAspicu_Temp0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1_warnHi, (double[])item_.getAspicu_Temp1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1_warnLo, (double[])item_.getAspicu_Temp1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1_limitHi, (double[])item_.getAspicu_Temp1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1_limitLo, (double[])item_.getAspicu_Temp1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2_warnHi, (double[])item_.getAspicu_Temp2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2_warnLo, (double[])item_.getAspicu_Temp2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2_limitHi, (double[])item_.getAspicu_Temp2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2_limitLo, (double[])item_.getAspicu_Temp2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_warnHi, (double[])item_.getClkhi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_warnLo, (double[])item_.getClkhi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_limitHi, (double[])item_.getClkhi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_limitLo, (double[])item_.getClkhi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_warnHi, (double[])item_.getClkhv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_warnLo, (double[])item_.getClkhv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_limitHi, (double[])item_.getClkhv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_limitLo, (double[])item_.getClkhv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkli_warnHi, (double[])item_.getClkli_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkli_warnLo, (double[])item_.getClkli_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkli_limitHi, (double[])item_.getClkli_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkli_limitLo, (double[])item_.getClkli_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_warnHi, (double[])item_.getClklv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_warnLo, (double[])item_.getClklv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_limitHi, (double[])item_.getClklv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_limitLo, (double[])item_.getClklv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_warnHi, (double[])item_.getDigi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_warnLo, (double[])item_.getDigi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_limitHi, (double[])item_.getDigi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_limitLo, (double[])item_.getDigi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_warnHi, (double[])item_.getDigv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_warnLo, (double[])item_.getDigv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_limitHi, (double[])item_.getDigv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_limitLo, (double[])item_.getDigv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_warnHi, (double[])item_.getHvbiasswitch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_warnLo, (double[])item_.getHvbiasswitch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_limitHi, (double[])item_.getHvbiasswitch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_limitLo, (double[])item_.getHvbiasswitch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpi_warnHi, (double[])item_.getHtrpi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpi_warnLo, (double[])item_.getHtrpi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpi_limitHi, (double[])item_.getHtrpi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpi_limitLo, (double[])item_.getHtrpi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpv_warnHi, (double[])item_.getHtrpv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpv_warnLo, (double[])item_.getHtrpv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpv_limitHi, (double[])item_.getHtrpv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpv_limitLo, (double[])item_.getHtrpv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_warnHi, (double[])item_.getHtrv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_warnLo, (double[])item_.getHtrv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_limitHi, (double[])item_.getHtrv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_limitLo, (double[])item_.getHtrv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_warnHi, (double[])item_.getHtrw_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_warnLo, (double[])item_.getHtrw_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_limitHi, (double[])item_.getHtrw_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_limitLo, (double[])item_.getHtrw_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])odi_warnHi, (double[])item_.getOdi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_warnLo, (double[])item_.getOdi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_limitHi, (double[])item_.getOdi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_limitLo, (double[])item_.getOdi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnHi, (double[])item_.getOdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnLo, (double[])item_.getOdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitHi, (double[])item_.getOdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitLo, (double[])item_.getOdv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk0_warnHi, (double[])item_.getPclk0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk0_warnLo, (double[])item_.getPclk0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk0_limitHi, (double[])item_.getPclk0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk0_limitLo, (double[])item_.getPclk0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk1_warnHi, (double[])item_.getPclk1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk1_warnLo, (double[])item_.getPclk1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk1_limitHi, (double[])item_.getPclk1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk1_limitLo, (double[])item_.getPclk1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_warnHi, (double[])item_.getPclkl_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_warnLo, (double[])item_.getPclkl_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_limitHi, (double[])item_.getPclkl_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_limitLo, (double[])item_.getPclkl_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_warnHi, (double[])item_.getPclku_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_warnLo, (double[])item_.getPclku_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_limitHi, (double[])item_.getPclku_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_limitLo, (double[])item_.getPclku_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_warnHi, (double[])item_.getPower_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_warnLo, (double[])item_.getPower_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_limitHi, (double[])item_.getPower_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_limitLo, (double[])item_.getPower_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg0_warnHi, (double[])item_.getRg0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg0_warnLo, (double[])item_.getRg0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg0_limitHi, (double[])item_.getRg0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg0_limitLo, (double[])item_.getRg0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg1_warnHi, (double[])item_.getRg1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg1_warnLo, (double[])item_.getRg1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg1_limitHi, (double[])item_.getRg1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg1_limitLo, (double[])item_.getRg1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_warnHi, (double[])item_.getRgl_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_warnLo, (double[])item_.getRgl_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_limitHi, (double[])item_.getRgl_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_limitLo, (double[])item_.getRgl_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_warnHi, (double[])item_.getRgu_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_warnLo, (double[])item_.getRgu_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_limitHi, (double[])item_.getRgu_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_limitLo, (double[])item_.getRgu_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_warnHi, (double[])item_.getRtdtemp_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_warnLo, (double[])item_.getRtdtemp_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_limitHi, (double[])item_.getRtdtemp_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_limitLo, (double[])item_.getRtdtemp_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05v_warnHi, (double[])item_.getRef05v_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05v_warnLo, (double[])item_.getRef05v_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05v_limitHi, (double[])item_.getRef05v_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05v_limitLo, (double[])item_.getRef05v_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125v_warnHi, (double[])item_.getRef125v_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125v_warnLo, (double[])item_.getRef125v_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125v_limitHi, (double[])item_.getRef125v_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125v_limitLo, (double[])item_.getRef125v_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15v_warnHi, (double[])item_.getRef15v_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15v_warnLo, (double[])item_.getRef15v_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15v_limitHi, (double[])item_.getRef15v_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15v_limitLo, (double[])item_.getRef15v_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25v_warnHi, (double[])item_.getRef25v_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25v_warnLo, (double[])item_.getRef25v_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25v_limitHi, (double[])item_.getRef25v_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25v_limitLo, (double[])item_.getRef25v_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refn12_warnHi, (double[])item_.getRefn12_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refn12_warnLo, (double[])item_.getRefn12_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refn12_limitHi, (double[])item_.getRefn12_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refn12_limitLo, (double[])item_.getRefn12_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refp12_warnHi, (double[])item_.getRefp12_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refp12_warnLo, (double[])item_.getRefp12_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refp12_limitHi, (double[])item_.getRefp12_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refp12_limitLo, (double[])item_.getRefp12_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk0_warnHi, (double[])item_.getSclk0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk0_warnLo, (double[])item_.getSclk0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk0_limitHi, (double[])item_.getSclk0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk0_limitLo, (double[])item_.getSclk0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk1_warnHi, (double[])item_.getSclk1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk1_warnLo, (double[])item_.getSclk1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk1_limitHi, (double[])item_.getSclk1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk1_limitLo, (double[])item_.getSclk1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_warnHi, (double[])item_.getSclkl_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_warnLo, (double[])item_.getSclkl_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_limitHi, (double[])item_.getSclkl_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_limitLo, (double[])item_.getSclkl_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_warnHi, (double[])item_.getSclku_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_warnLo, (double[])item_.getSclku_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_limitHi, (double[])item_.getSclku_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_limitLo, (double[])item_.getSclku_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10_warnHi, (double[])item_.getTemp10_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10_warnLo, (double[])item_.getTemp10_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10_limitHi, (double[])item_.getTemp10_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10_limitLo, (double[])item_.getTemp10_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_warnHi, (double[])item_.getTemp1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_warnLo, (double[])item_.getTemp1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_limitHi, (double[])item_.getTemp1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_limitLo, (double[])item_.getTemp1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_warnHi, (double[])item_.getTemp2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_warnLo, (double[])item_.getTemp2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_limitHi, (double[])item_.getTemp2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_limitLo, (double[])item_.getTemp2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_warnHi, (double[])item_.getTemp3_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_warnLo, (double[])item_.getTemp3_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_limitHi, (double[])item_.getTemp3_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_limitLo, (double[])item_.getTemp3_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_warnHi, (double[])item_.getTemp4_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_warnLo, (double[])item_.getTemp4_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_limitHi, (double[])item_.getTemp4_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_limitLo, (double[])item_.getTemp4_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_warnHi, (double[])item_.getTemp5_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_warnLo, (double[])item_.getTemp5_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_limitHi, (double[])item_.getTemp5_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_limitLo, (double[])item_.getTemp5_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_warnHi, (double[])item_.getTemp6_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_warnLo, (double[])item_.getTemp6_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_limitHi, (double[])item_.getTemp6_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_limitLo, (double[])item_.getTemp6_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7_warnHi, (double[])item_.getTemp7_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7_warnLo, (double[])item_.getTemp7_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7_limitHi, (double[])item_.getTemp7_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7_limitLo, (double[])item_.getTemp7_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8_warnHi, (double[])item_.getTemp8_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8_warnLo, (double[])item_.getTemp8_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8_limitHi, (double[])item_.getTemp8_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8_limitLo, (double[])item_.getTemp8_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9_warnHi, (double[])item_.getTemp9_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9_warnLo, (double[])item_.getTemp9_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9_limitHi, (double[])item_.getTemp9_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9_limitLo, (double[])item_.getTemp9_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Reb_RaftsConfigurationEvent() throws Exception {
        String version = "q";
        double[] bias0_csGateP = TestHelper.generateDoubleArray((int)71, (int)1946459658);
        double[] bias0_gdP = TestHelper.generateDoubleArray((int)71, (int)1426853779);
        double[] bias0_odP = TestHelper.generateDoubleArray((int)71, (int)523689683);
        double[] bias0_ogP = TestHelper.generateDoubleArray((int)71, (int)1616373853);
        double[] bias0_rdP = TestHelper.generateDoubleArray((int)71, (int)-776097940);
        double[] bias1_csGateP = TestHelper.generateDoubleArray((int)71, (int)-452434626);
        double[] bias1_gdP = TestHelper.generateDoubleArray((int)71, (int)1536772655);
        double[] bias1_odP = TestHelper.generateDoubleArray((int)71, (int)-187777241);
        double[] bias1_ogP = TestHelper.generateDoubleArray((int)71, (int)-557807564);
        double[] bias1_rdP = TestHelper.generateDoubleArray((int)71, (int)1873770283);
        double[] bias2_csGateP = TestHelper.generateDoubleArray((int)71, (int)-43363386);
        double[] bias2_gdP = TestHelper.generateDoubleArray((int)71, (int)2086689249);
        double[] bias2_odP = TestHelper.generateDoubleArray((int)71, (int)-1595791238);
        double[] bias2_ogP = TestHelper.generateDoubleArray((int)71, (int)277214814);
        double[] bias2_rdP = TestHelper.generateDoubleArray((int)71, (int)273511501);
        double[] dac_pclkHighP = TestHelper.generateDoubleArray((int)71, (int)788200446);
        double[] dac_pclkLowP = TestHelper.generateDoubleArray((int)71, (int)-244867215);
        double[] dac_rgHighP = TestHelper.generateDoubleArray((int)71, (int)-2029283447);
        double[] dac_rgLowP = TestHelper.generateDoubleArray((int)71, (int)-666149701);
        double[] dac_sclkHighP = TestHelper.generateDoubleArray((int)71, (int)-2036453503);
        double[] dac_sclkLowP = TestHelper.generateDoubleArray((int)71, (int)-706430264);
        boolean[] disableRTDHardwareCheck = new boolean[]{true, false, false, true, true, false, true, false, true, true, true, true, false, true, false, false, false, true, false, true, false, false, true, true, true, false, true, false, true, true, true, false, false, false, false, false, false, false, true, true, true, true, false, true, true, false, true, false, false, false, true, true, false, false, true, false, false, true, true, false, true, false, true, false, false, true, false, true, false, true, false};
        String location = "";
        long[] serialNum = TestHelper.generateLongArray((int)71, (int)194485814);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_RaftsConfigurationEvent(version, bias0_csGateP, bias0_gdP, bias0_odP, bias0_ogP, bias0_rdP, bias1_csGateP, bias1_gdP, bias1_odP, bias1_ogP, bias1_rdP, bias2_csGateP, bias2_gdP, bias2_odP, bias2_ogP, bias2_rdP, dac_pclkHighP, dac_pclkLowP, dac_rgHighP, dac_rgLowP, dac_sclkHighP, dac_sclkLowP, disableRTDHardwareCheck, location, serialNum));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_RaftsConfigurationEvent));
        Focal_plane_Reb_RaftsConfigurationEvent item_ = (Focal_plane_Reb_RaftsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])bias0_csGateP, (double[])item_.getBias0_csGateP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdP, (double[])item_.getBias0_gdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odP, (double[])item_.getBias0_odP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogP, (double[])item_.getBias0_ogP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdP, (double[])item_.getBias0_rdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_csGateP, (double[])item_.getBias1_csGateP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdP, (double[])item_.getBias1_gdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odP, (double[])item_.getBias1_odP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogP, (double[])item_.getBias1_ogP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdP, (double[])item_.getBias1_rdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_csGateP, (double[])item_.getBias2_csGateP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdP, (double[])item_.getBias2_gdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odP, (double[])item_.getBias2_odP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogP, (double[])item_.getBias2_ogP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdP, (double[])item_.getBias2_rdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighP, (double[])item_.getDac_pclkHighP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowP, (double[])item_.getDac_pclkLowP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighP, (double[])item_.getDac_rgHighP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowP, (double[])item_.getDac_rgLowP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighP, (double[])item_.getDac_sclkHighP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowP, (double[])item_.getDac_sclkLowP(), (double)1.0E-6f);
        Assert.assertArrayEquals((boolean[])disableRTDHardwareCheck, (boolean[])item_.getDisableRTDHardwareCheck());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((long[])serialNum, (long[])item_.getSerialNum());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_RaftsLimitsConfigurationEvent() throws Exception {
        String version = "";
        double[] bias0_gdMax = TestHelper.generateDoubleArray((int)71, (int)119081991);
        double[] bias0_gdMin = TestHelper.generateDoubleArray((int)71, (int)363790831);
        double[] bias0_odMax = TestHelper.generateDoubleArray((int)71, (int)1615248878);
        double[] bias0_odMin = TestHelper.generateDoubleArray((int)71, (int)-439045155);
        double[] bias0_ogMax = TestHelper.generateDoubleArray((int)71, (int)1380520082);
        double[] bias0_ogMin = TestHelper.generateDoubleArray((int)71, (int)2006777081);
        double[] bias0_rdMax = TestHelper.generateDoubleArray((int)71, (int)-1612437733);
        double[] bias0_rdMin = TestHelper.generateDoubleArray((int)71, (int)-1142572297);
        double[] bias1_gdMax = TestHelper.generateDoubleArray((int)71, (int)1661024012);
        double[] bias1_gdMin = TestHelper.generateDoubleArray((int)71, (int)-1118348014);
        double[] bias1_odMax = TestHelper.generateDoubleArray((int)71, (int)-2017394604);
        double[] bias1_odMin = TestHelper.generateDoubleArray((int)71, (int)-2038123795);
        double[] bias1_ogMax = TestHelper.generateDoubleArray((int)71, (int)2037107818);
        double[] bias1_ogMin = TestHelper.generateDoubleArray((int)71, (int)424130202);
        double[] bias1_rdMax = TestHelper.generateDoubleArray((int)71, (int)274989165);
        double[] bias1_rdMin = TestHelper.generateDoubleArray((int)71, (int)978362666);
        double[] bias2_gdMax = TestHelper.generateDoubleArray((int)71, (int)-1933213280);
        double[] bias2_gdMin = TestHelper.generateDoubleArray((int)71, (int)-2086737047);
        double[] bias2_odMax = TestHelper.generateDoubleArray((int)71, (int)671002819);
        double[] bias2_odMin = TestHelper.generateDoubleArray((int)71, (int)-1232725829);
        double[] bias2_ogMax = TestHelper.generateDoubleArray((int)71, (int)1233971214);
        double[] bias2_ogMin = TestHelper.generateDoubleArray((int)71, (int)-246587340);
        double[] bias2_rdMax = TestHelper.generateDoubleArray((int)71, (int)172228825);
        double[] bias2_rdMin = TestHelper.generateDoubleArray((int)71, (int)1482885209);
        double[] dac_pclkHighMax = TestHelper.generateDoubleArray((int)71, (int)-506937030);
        double[] dac_pclkHighMin = TestHelper.generateDoubleArray((int)71, (int)-1082219467);
        double[] dac_pclkLowMax = TestHelper.generateDoubleArray((int)71, (int)-539230429);
        double[] dac_pclkLowMin = TestHelper.generateDoubleArray((int)71, (int)317383846);
        double[] dac_rgHighMax = TestHelper.generateDoubleArray((int)71, (int)1480005056);
        double[] dac_rgHighMin = TestHelper.generateDoubleArray((int)71, (int)-969576693);
        double[] dac_rgLowMax = TestHelper.generateDoubleArray((int)71, (int)-1759917278);
        double[] dac_rgLowMin = TestHelper.generateDoubleArray((int)71, (int)-1370705225);
        double[] dac_sclkHighMax = TestHelper.generateDoubleArray((int)71, (int)1440892806);
        double[] dac_sclkHighMin = TestHelper.generateDoubleArray((int)71, (int)386865374);
        double[] dac_sclkLowMax = TestHelper.generateDoubleArray((int)71, (int)-1269427024);
        double[] dac_sclkLowMin = TestHelper.generateDoubleArray((int)71, (int)104904402);
        String location = "d";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_RaftsLimitsConfigurationEvent(version, bias0_gdMax, bias0_gdMin, bias0_odMax, bias0_odMin, bias0_ogMax, bias0_ogMin, bias0_rdMax, bias0_rdMin, bias1_gdMax, bias1_gdMin, bias1_odMax, bias1_odMin, bias1_ogMax, bias1_ogMin, bias1_rdMax, bias1_rdMin, bias2_gdMax, bias2_gdMin, bias2_odMax, bias2_odMin, bias2_ogMax, bias2_ogMin, bias2_rdMax, bias2_rdMin, dac_pclkHighMax, dac_pclkHighMin, dac_pclkLowMax, dac_pclkLowMin, dac_rgHighMax, dac_rgHighMin, dac_rgLowMax, dac_rgLowMin, dac_sclkHighMax, dac_sclkHighMin, dac_sclkLowMax, dac_sclkLowMin, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_RaftsLimitsConfigurationEvent));
        Focal_plane_Reb_RaftsLimitsConfigurationEvent item_ = (Focal_plane_Reb_RaftsLimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])bias0_gdMax, (double[])item_.getBias0_gdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdMin, (double[])item_.getBias0_gdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odMax, (double[])item_.getBias0_odMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odMin, (double[])item_.getBias0_odMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogMax, (double[])item_.getBias0_ogMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogMin, (double[])item_.getBias0_ogMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdMax, (double[])item_.getBias0_rdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdMin, (double[])item_.getBias0_rdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdMax, (double[])item_.getBias1_gdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdMin, (double[])item_.getBias1_gdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odMax, (double[])item_.getBias1_odMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odMin, (double[])item_.getBias1_odMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogMax, (double[])item_.getBias1_ogMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogMin, (double[])item_.getBias1_ogMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdMax, (double[])item_.getBias1_rdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdMin, (double[])item_.getBias1_rdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdMax, (double[])item_.getBias2_gdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdMin, (double[])item_.getBias2_gdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odMax, (double[])item_.getBias2_odMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odMin, (double[])item_.getBias2_odMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogMax, (double[])item_.getBias2_ogMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogMin, (double[])item_.getBias2_ogMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdMax, (double[])item_.getBias2_rdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdMin, (double[])item_.getBias2_rdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighMax, (double[])item_.getDac_pclkHighMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighMin, (double[])item_.getDac_pclkHighMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowMax, (double[])item_.getDac_pclkLowMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowMin, (double[])item_.getDac_pclkLowMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighMax, (double[])item_.getDac_rgHighMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighMin, (double[])item_.getDac_rgHighMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowMax, (double[])item_.getDac_rgLowMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowMin, (double[])item_.getDac_rgLowMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighMax, (double[])item_.getDac_sclkHighMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighMin, (double[])item_.getDac_sclkHighMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowMax, (double[])item_.getDac_sclkLowMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowMin, (double[])item_.getDac_sclkLowMin(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_RaftsPowerConfigurationEvent() throws Exception {
        String version = "w";
        double[] bias0_gdCal = TestHelper.generateDoubleArray((int)71, (int)-627723039);
        double[] bias0_gdTestVolts = TestHelper.generateDoubleArray((int)71, (int)-1486088851);
        double[] bias0_gdTol = TestHelper.generateDoubleArray((int)71, (int)-2069271943);
        double[] bias0_gdValueErr = TestHelper.generateDoubleArray((int)71, (int)959620261);
        double[] bias0_gdZeroErr = TestHelper.generateDoubleArray((int)71, (int)1995809808);
        double[] bias0_odCal = TestHelper.generateDoubleArray((int)71, (int)-1058622478);
        double[] bias0_odIMax = TestHelper.generateDoubleArray((int)71, (int)2111581107);
        double[] bias0_odTol = TestHelper.generateDoubleArray((int)71, (int)1120371541);
        double[] bias0_odZeroErr = TestHelper.generateDoubleArray((int)71, (int)1166187230);
        double[] bias0_ogCal = TestHelper.generateDoubleArray((int)71, (int)1010553104);
        double[] bias0_ogTestVolts = TestHelper.generateDoubleArray((int)71, (int)-629903390);
        double[] bias0_ogTol = TestHelper.generateDoubleArray((int)71, (int)-790553270);
        double[] bias0_ogValueErr = TestHelper.generateDoubleArray((int)71, (int)1243602036);
        double[] bias0_ogZeroErr = TestHelper.generateDoubleArray((int)71, (int)-835780481);
        double[] bias0_rdCal = TestHelper.generateDoubleArray((int)71, (int)1361311330);
        double[] bias0_rdTestVolts = TestHelper.generateDoubleArray((int)71, (int)921812236);
        double[] bias0_rdTol = TestHelper.generateDoubleArray((int)71, (int)1463152323);
        double[] bias0_rdValueErr = TestHelper.generateDoubleArray((int)71, (int)-239358311);
        double[] bias0_rdZeroErr = TestHelper.generateDoubleArray((int)71, (int)-736591581);
        double[] bias1_gdCal = TestHelper.generateDoubleArray((int)71, (int)-1784553935);
        double[] bias1_gdTestVolts = TestHelper.generateDoubleArray((int)71, (int)1713126256);
        double[] bias1_gdTol = TestHelper.generateDoubleArray((int)71, (int)1822023745);
        double[] bias1_gdValueErr = TestHelper.generateDoubleArray((int)71, (int)-535273283);
        double[] bias1_gdZeroErr = TestHelper.generateDoubleArray((int)71, (int)-1438529058);
        double[] bias1_odCal = TestHelper.generateDoubleArray((int)71, (int)-1094235124);
        double[] bias1_odIMax = TestHelper.generateDoubleArray((int)71, (int)1450478848);
        double[] bias1_odTol = TestHelper.generateDoubleArray((int)71, (int)-1261228602);
        double[] bias1_odZeroErr = TestHelper.generateDoubleArray((int)71, (int)18478989);
        double[] bias1_ogCal = TestHelper.generateDoubleArray((int)71, (int)-945678968);
        double[] bias1_ogTestVolts = TestHelper.generateDoubleArray((int)71, (int)-114755728);
        double[] bias1_ogTol = TestHelper.generateDoubleArray((int)71, (int)-311147673);
        double[] bias1_ogValueErr = TestHelper.generateDoubleArray((int)71, (int)-564513264);
        double[] bias1_ogZeroErr = TestHelper.generateDoubleArray((int)71, (int)1508640487);
        double[] bias1_rdCal = TestHelper.generateDoubleArray((int)71, (int)-470243363);
        double[] bias1_rdTestVolts = TestHelper.generateDoubleArray((int)71, (int)-615919827);
        double[] bias1_rdTol = TestHelper.generateDoubleArray((int)71, (int)1591992533);
        double[] bias1_rdValueErr = TestHelper.generateDoubleArray((int)71, (int)1985793845);
        double[] bias1_rdZeroErr = TestHelper.generateDoubleArray((int)71, (int)235793704);
        double[] bias2_gdCal = TestHelper.generateDoubleArray((int)71, (int)-835941860);
        double[] bias2_gdTestVolts = TestHelper.generateDoubleArray((int)71, (int)1932240234);
        double[] bias2_gdTol = TestHelper.generateDoubleArray((int)71, (int)2087325367);
        double[] bias2_gdValueErr = TestHelper.generateDoubleArray((int)71, (int)1884096494);
        double[] bias2_gdZeroErr = TestHelper.generateDoubleArray((int)71, (int)2088857353);
        double[] bias2_odCal = TestHelper.generateDoubleArray((int)71, (int)-1624007357);
        double[] bias2_odIMax = TestHelper.generateDoubleArray((int)71, (int)1402627939);
        double[] bias2_odTol = TestHelper.generateDoubleArray((int)71, (int)23749610);
        double[] bias2_odZeroErr = TestHelper.generateDoubleArray((int)71, (int)-261094871);
        double[] bias2_ogCal = TestHelper.generateDoubleArray((int)71, (int)325500859);
        double[] bias2_ogTestVolts = TestHelper.generateDoubleArray((int)71, (int)-1122721646);
        double[] bias2_ogTol = TestHelper.generateDoubleArray((int)71, (int)199263127);
        double[] bias2_ogValueErr = TestHelper.generateDoubleArray((int)71, (int)-2038628892);
        double[] bias2_ogZeroErr = TestHelper.generateDoubleArray((int)71, (int)925560920);
        double[] bias2_rdCal = TestHelper.generateDoubleArray((int)71, (int)-1420766733);
        double[] bias2_rdTestVolts = TestHelper.generateDoubleArray((int)71, (int)-504987111);
        double[] bias2_rdTol = TestHelper.generateDoubleArray((int)71, (int)2086828271);
        double[] bias2_rdValueErr = TestHelper.generateDoubleArray((int)71, (int)529476946);
        double[] bias2_rdZeroErr = TestHelper.generateDoubleArray((int)71, (int)-1581463101);
        double[] clkhiAmin = TestHelper.generateDoubleArray((int)71, (int)-1707978915);
        double[] clkhiQmax = TestHelper.generateDoubleArray((int)71, (int)2063325593);
        double[] clkliAmin = TestHelper.generateDoubleArray((int)71, (int)1859101270);
        double[] clkliQmax = TestHelper.generateDoubleArray((int)71, (int)-846978502);
        double[] dac_clkhIMax = TestHelper.generateDoubleArray((int)71, (int)-1084224898);
        double[] dac_clklIMax = TestHelper.generateDoubleArray((int)71, (int)749546084);
        double[] dac_pclkHighCal = TestHelper.generateDoubleArray((int)71, (int)-2067684473);
        double[] dac_pclkHighTestV = TestHelper.generateDoubleArray((int)71, (int)-2034255288);
        double[] dac_pclkHighTol = TestHelper.generateDoubleArray((int)71, (int)1435115114);
        double[] dac_pclkHighValueErr = TestHelper.generateDoubleArray((int)71, (int)-401431594);
        double[] dac_pclkHighZeroErr = TestHelper.generateDoubleArray((int)71, (int)-925510460);
        double[] dac_pclkLowCal = TestHelper.generateDoubleArray((int)71, (int)-313031295);
        double[] dac_pclkLowTestV = TestHelper.generateDoubleArray((int)71, (int)-734788411);
        double[] dac_pclkLowTol = TestHelper.generateDoubleArray((int)71, (int)1715371921);
        double[] dac_pclkLowValueErr = TestHelper.generateDoubleArray((int)71, (int)-1132527312);
        double[] dac_pclkLowZeroErr = TestHelper.generateDoubleArray((int)71, (int)1243408212);
        double[] dac_rgHighCal = TestHelper.generateDoubleArray((int)71, (int)1482937101);
        double[] dac_rgHighTestV = TestHelper.generateDoubleArray((int)71, (int)1637378209);
        double[] dac_rgHighTol = TestHelper.generateDoubleArray((int)71, (int)-995072274);
        double[] dac_rgHighValueErr = TestHelper.generateDoubleArray((int)71, (int)575868291);
        double[] dac_rgHighZeroErr = TestHelper.generateDoubleArray((int)71, (int)1910830590);
        double[] dac_rgLowCal = TestHelper.generateDoubleArray((int)71, (int)1741888789);
        double[] dac_rgLowTestV = TestHelper.generateDoubleArray((int)71, (int)-1961985236);
        double[] dac_rgLowTol = TestHelper.generateDoubleArray((int)71, (int)-1791099442);
        double[] dac_rgLowValueErr = TestHelper.generateDoubleArray((int)71, (int)963690295);
        double[] dac_rgLowZeroErr = TestHelper.generateDoubleArray((int)71, (int)-2086529840);
        double[] dac_sclkHighCal = TestHelper.generateDoubleArray((int)71, (int)395930211);
        double[] dac_sclkHighTestV = TestHelper.generateDoubleArray((int)71, (int)-1347925263);
        double[] dac_sclkHighTol = TestHelper.generateDoubleArray((int)71, (int)1780459804);
        double[] dac_sclkHighValueErr = TestHelper.generateDoubleArray((int)71, (int)589447584);
        double[] dac_sclkHighZeroErr = TestHelper.generateDoubleArray((int)71, (int)1917376732);
        double[] dac_sclkLowCal = TestHelper.generateDoubleArray((int)71, (int)467313873);
        double[] dac_sclkLowTestV = TestHelper.generateDoubleArray((int)71, (int)-1051691778);
        double[] dac_sclkLowTol = TestHelper.generateDoubleArray((int)71, (int)-1819919217);
        double[] dac_sclkLowValueErr = TestHelper.generateDoubleArray((int)71, (int)-1652250763);
        double[] dac_sclkLowZeroErr = TestHelper.generateDoubleArray((int)71, (int)-1535133711);
        String location = "";
        double[] maxDelta = TestHelper.generateDoubleArray((int)71, (int)-221809543);
        double[] maxStep = TestHelper.generateDoubleArray((int)71, (int)-153173852);
        double[] minTol = TestHelper.generateDoubleArray((int)71, (int)-912125910);
        int[] nPowerOnPub = TestHelper.generateIntArray((int)71, (int)-1016912099);
        double[] odiAmin = TestHelper.generateDoubleArray((int)71, (int)-903663138);
        double[] odiQmax = TestHelper.generateDoubleArray((int)71, (int)-1355927108);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_RaftsPowerConfigurationEvent(version, bias0_gdCal, bias0_gdTestVolts, bias0_gdTol, bias0_gdValueErr, bias0_gdZeroErr, bias0_odCal, bias0_odIMax, bias0_odTol, bias0_odZeroErr, bias0_ogCal, bias0_ogTestVolts, bias0_ogTol, bias0_ogValueErr, bias0_ogZeroErr, bias0_rdCal, bias0_rdTestVolts, bias0_rdTol, bias0_rdValueErr, bias0_rdZeroErr, bias1_gdCal, bias1_gdTestVolts, bias1_gdTol, bias1_gdValueErr, bias1_gdZeroErr, bias1_odCal, bias1_odIMax, bias1_odTol, bias1_odZeroErr, bias1_ogCal, bias1_ogTestVolts, bias1_ogTol, bias1_ogValueErr, bias1_ogZeroErr, bias1_rdCal, bias1_rdTestVolts, bias1_rdTol, bias1_rdValueErr, bias1_rdZeroErr, bias2_gdCal, bias2_gdTestVolts, bias2_gdTol, bias2_gdValueErr, bias2_gdZeroErr, bias2_odCal, bias2_odIMax, bias2_odTol, bias2_odZeroErr, bias2_ogCal, bias2_ogTestVolts, bias2_ogTol, bias2_ogValueErr, bias2_ogZeroErr, bias2_rdCal, bias2_rdTestVolts, bias2_rdTol, bias2_rdValueErr, bias2_rdZeroErr, clkhiAmin, clkhiQmax, clkliAmin, clkliQmax, dac_clkhIMax, dac_clklIMax, dac_pclkHighCal, dac_pclkHighTestV, dac_pclkHighTol, dac_pclkHighValueErr, dac_pclkHighZeroErr, dac_pclkLowCal, dac_pclkLowTestV, dac_pclkLowTol, dac_pclkLowValueErr, dac_pclkLowZeroErr, dac_rgHighCal, dac_rgHighTestV, dac_rgHighTol, dac_rgHighValueErr, dac_rgHighZeroErr, dac_rgLowCal, dac_rgLowTestV, dac_rgLowTol, dac_rgLowValueErr, dac_rgLowZeroErr, dac_sclkHighCal, dac_sclkHighTestV, dac_sclkHighTol, dac_sclkHighValueErr, dac_sclkHighZeroErr, dac_sclkLowCal, dac_sclkLowTestV, dac_sclkLowTol, dac_sclkLowValueErr, dac_sclkLowZeroErr, location, maxDelta, maxStep, minTol, nPowerOnPub, odiAmin, odiQmax));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_RaftsPowerConfigurationEvent));
        Focal_plane_Reb_RaftsPowerConfigurationEvent item_ = (Focal_plane_Reb_RaftsPowerConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])bias0_gdCal, (double[])item_.getBias0_gdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdTestVolts, (double[])item_.getBias0_gdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdTol, (double[])item_.getBias0_gdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdValueErr, (double[])item_.getBias0_gdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdZeroErr, (double[])item_.getBias0_gdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odCal, (double[])item_.getBias0_odCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odIMax, (double[])item_.getBias0_odIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odTol, (double[])item_.getBias0_odTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odZeroErr, (double[])item_.getBias0_odZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogCal, (double[])item_.getBias0_ogCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogTestVolts, (double[])item_.getBias0_ogTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogTol, (double[])item_.getBias0_ogTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogValueErr, (double[])item_.getBias0_ogValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogZeroErr, (double[])item_.getBias0_ogZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdCal, (double[])item_.getBias0_rdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdTestVolts, (double[])item_.getBias0_rdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdTol, (double[])item_.getBias0_rdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdValueErr, (double[])item_.getBias0_rdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdZeroErr, (double[])item_.getBias0_rdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdCal, (double[])item_.getBias1_gdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdTestVolts, (double[])item_.getBias1_gdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdTol, (double[])item_.getBias1_gdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdValueErr, (double[])item_.getBias1_gdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdZeroErr, (double[])item_.getBias1_gdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odCal, (double[])item_.getBias1_odCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odIMax, (double[])item_.getBias1_odIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odTol, (double[])item_.getBias1_odTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odZeroErr, (double[])item_.getBias1_odZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogCal, (double[])item_.getBias1_ogCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogTestVolts, (double[])item_.getBias1_ogTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogTol, (double[])item_.getBias1_ogTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogValueErr, (double[])item_.getBias1_ogValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogZeroErr, (double[])item_.getBias1_ogZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdCal, (double[])item_.getBias1_rdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdTestVolts, (double[])item_.getBias1_rdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdTol, (double[])item_.getBias1_rdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdValueErr, (double[])item_.getBias1_rdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdZeroErr, (double[])item_.getBias1_rdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdCal, (double[])item_.getBias2_gdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdTestVolts, (double[])item_.getBias2_gdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdTol, (double[])item_.getBias2_gdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdValueErr, (double[])item_.getBias2_gdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdZeroErr, (double[])item_.getBias2_gdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odCal, (double[])item_.getBias2_odCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odIMax, (double[])item_.getBias2_odIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odTol, (double[])item_.getBias2_odTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odZeroErr, (double[])item_.getBias2_odZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogCal, (double[])item_.getBias2_ogCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogTestVolts, (double[])item_.getBias2_ogTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogTol, (double[])item_.getBias2_ogTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogValueErr, (double[])item_.getBias2_ogValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogZeroErr, (double[])item_.getBias2_ogZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdCal, (double[])item_.getBias2_rdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdTestVolts, (double[])item_.getBias2_rdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdTol, (double[])item_.getBias2_rdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdValueErr, (double[])item_.getBias2_rdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdZeroErr, (double[])item_.getBias2_rdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhiAmin, (double[])item_.getClkhiAmin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhiQmax, (double[])item_.getClkhiQmax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkliAmin, (double[])item_.getClkliAmin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkliQmax, (double[])item_.getClkliQmax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_clkhIMax, (double[])item_.getDac_clkhIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_clklIMax, (double[])item_.getDac_clklIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighCal, (double[])item_.getDac_pclkHighCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighTestV, (double[])item_.getDac_pclkHighTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighTol, (double[])item_.getDac_pclkHighTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighValueErr, (double[])item_.getDac_pclkHighValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighZeroErr, (double[])item_.getDac_pclkHighZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowCal, (double[])item_.getDac_pclkLowCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowTestV, (double[])item_.getDac_pclkLowTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowTol, (double[])item_.getDac_pclkLowTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowValueErr, (double[])item_.getDac_pclkLowValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowZeroErr, (double[])item_.getDac_pclkLowZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighCal, (double[])item_.getDac_rgHighCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighTestV, (double[])item_.getDac_rgHighTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighTol, (double[])item_.getDac_rgHighTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighValueErr, (double[])item_.getDac_rgHighValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighZeroErr, (double[])item_.getDac_rgHighZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowCal, (double[])item_.getDac_rgLowCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowTestV, (double[])item_.getDac_rgLowTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowTol, (double[])item_.getDac_rgLowTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowValueErr, (double[])item_.getDac_rgLowValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowZeroErr, (double[])item_.getDac_rgLowZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighCal, (double[])item_.getDac_sclkHighCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighTestV, (double[])item_.getDac_sclkHighTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighTol, (double[])item_.getDac_sclkHighTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighValueErr, (double[])item_.getDac_sclkHighValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighZeroErr, (double[])item_.getDac_sclkHighZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowCal, (double[])item_.getDac_sclkLowCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowTestV, (double[])item_.getDac_sclkLowTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowTol, (double[])item_.getDac_sclkLowTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowValueErr, (double[])item_.getDac_sclkLowValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowZeroErr, (double[])item_.getDac_sclkLowZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])maxDelta, (double[])item_.getMaxDelta(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])maxStep, (double[])item_.getMaxStep(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])minTol, (double[])item_.getMinTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((int[])nPowerOnPub, (int[])item_.getNPowerOnPub());
        Assert.assertArrayEquals((double[])odiAmin, (double[])item_.getOdiAmin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odiQmax, (double[])item_.getOdiQmax(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Reb_timersConfigurationEvent() throws Exception {
        String version = "";
        String location = "o";
        long[] periodictasks_monitor_check_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-965995409);
        long[] periodictasks_monitor_publish_aspicTemp_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-1550556451);
        long[] periodictasks_monitor_publish_biasVolt_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)760715634);
        long[] periodictasks_monitor_publish_boardPower_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)794913553);
        long[] periodictasks_monitor_publish_ccdCurrent_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)1052183699);
        long[] periodictasks_monitor_publish_crVolt_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-1077426309);
        long[] periodictasks_monitor_publish_rebTemp_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)1116243522);
        long[] periodictasks_monitor_publish_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-424750066);
        long[] periodictasks_monitor_update_aspicTemp_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-2065015255);
        long[] periodictasks_monitor_update_biasVolt_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)355852705);
        long[] periodictasks_monitor_update_boardPower_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)1935057280);
        long[] periodictasks_monitor_update_ccdCurrent_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)875313486);
        long[] periodictasks_monitor_update_crVolt_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)411164570);
        long[] periodictasks_monitor_update_rebTemp_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)840436754);
        long[] periodictasks_monitor_update_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)871796178);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_timersConfigurationEvent(version, location, periodictasks_monitor_check_taskPeriodMillis, periodictasks_monitor_publish_aspicTemp_taskPeriodMillis, periodictasks_monitor_publish_biasVolt_taskPeriodMillis, periodictasks_monitor_publish_boardPower_taskPeriodMillis, periodictasks_monitor_publish_ccdCurrent_taskPeriodMillis, periodictasks_monitor_publish_crVolt_taskPeriodMillis, periodictasks_monitor_publish_rebTemp_taskPeriodMillis, periodictasks_monitor_publish_taskPeriodMillis, periodictasks_monitor_update_aspicTemp_taskPeriodMillis, periodictasks_monitor_update_biasVolt_taskPeriodMillis, periodictasks_monitor_update_boardPower_taskPeriodMillis, periodictasks_monitor_update_ccdCurrent_taskPeriodMillis, periodictasks_monitor_update_crVolt_taskPeriodMillis, periodictasks_monitor_update_rebTemp_taskPeriodMillis, periodictasks_monitor_update_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_timersConfigurationEvent));
        Focal_plane_Reb_timersConfigurationEvent item_ = (Focal_plane_Reb_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((long[])periodictasks_monitor_check_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_check_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_aspicTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_aspicTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_biasVolt_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_biasVolt_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_boardPower_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_boardPower_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_ccdCurrent_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_ccdCurrent_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_crVolt_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_crVolt_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_rebTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_rebTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_aspicTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_aspicTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_biasVolt_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_biasVolt_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_boardPower_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_boardPower_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_ccdCurrent_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_ccdCurrent_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_crVolt_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_crVolt_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_rebTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_rebTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_taskPeriodMillis());
    }

    @Test
    public void sendReceiveFocal_plane_RebsAverageTemp6_GeneralConfigurationEvent() throws Exception {
        String version = "x";
        String chanNames = "";
        String chanWeights = "h";
        boolean ignoreNaN = true;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_RebsAverageTemp6_GeneralConfigurationEvent(version, chanNames, chanWeights, ignoreNaN));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebsAverageTemp6_GeneralConfigurationEvent));
        Focal_plane_RebsAverageTemp6_GeneralConfigurationEvent item_ = (Focal_plane_RebsAverageTemp6_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)chanNames, (Object)item_.getChanNames());
        Assert.assertEquals((Object)chanWeights, (Object)item_.getChanWeights());
        Assert.assertEquals((Object)ignoreNaN, (Object)item_.isIgnoreNaN());
    }

    @Test
    public void sendReceiveFocal_plane_RebsAverageTemp6_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.5928830504417419;
        double warnLo = 0.8896746635437012;
        double limitHi = 0.06854617595672607;
        double limitLo = 0.058166325092315674;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_RebsAverageTemp6_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebsAverageTemp6_LimitsConfigurationEvent));
        Focal_plane_RebsAverageTemp6_LimitsConfigurationEvent item_ = (Focal_plane_RebsAverageTemp6_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Segment_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double[] i_warnHi = TestHelper.generateDoubleArray((int)3024, (int)-1488742739);
        double[] i_warnLo = TestHelper.generateDoubleArray((int)3024, (int)1047325956);
        double[] i_limitHi = TestHelper.generateDoubleArray((int)3024, (int)-1537526228);
        double[] i_limitLo = TestHelper.generateDoubleArray((int)3024, (int)2025114962);
        String location = "j";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Segment_LimitsConfigurationEvent(version, i_warnHi, i_warnLo, i_limitHi, i_limitLo, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Segment_LimitsConfigurationEvent));
        Focal_plane_Segment_LimitsConfigurationEvent item_ = (Focal_plane_Segment_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])i_warnHi, (double[])item_.getI_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])i_warnLo, (double[])item_.getI_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])i_limitHi, (double[])item_.getI_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])i_limitLo, (double[])item_.getI_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFocal_plane_SequencerConfig_DAQConfigurationEvent() throws Exception {
        String version = "c";
        int badPixelAlarmLimit = 208;
        String daqFolder = "";
        String daqPartition = "p";
        boolean emulatedDAQ = false;
        String scienceLocations = "c";
        boolean simulatedDAQ = false;
        String simulatedDataFolder = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_SequencerConfig_DAQConfigurationEvent(version, badPixelAlarmLimit, daqFolder, daqPartition, emulatedDAQ, scienceLocations, simulatedDAQ, simulatedDataFolder));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SequencerConfig_DAQConfigurationEvent));
        Focal_plane_SequencerConfig_DAQConfigurationEvent item_ = (Focal_plane_SequencerConfig_DAQConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)badPixelAlarmLimit, (long)item_.getBadPixelAlarmLimit());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)daqPartition, (Object)item_.getDaqPartition());
        Assert.assertEquals((Object)emulatedDAQ, (Object)item_.isEmulatedDAQ());
        Assert.assertEquals((Object)scienceLocations, (Object)item_.getScienceLocations());
        Assert.assertEquals((Object)simulatedDAQ, (Object)item_.isSimulatedDAQ());
        Assert.assertEquals((Object)simulatedDataFolder, (Object)item_.getSimulatedDataFolder());
    }

    @Test
    public void sendReceiveFocal_plane_SequencerConfig_GuiderConfigurationEvent() throws Exception {
        String version = "d";
        String guiderLocations = "";
        String guiderPartition = "r";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_SequencerConfig_GuiderConfigurationEvent(version, guiderLocations, guiderPartition));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SequencerConfig_GuiderConfigurationEvent));
        Focal_plane_SequencerConfig_GuiderConfigurationEvent item_ = (Focal_plane_SequencerConfig_GuiderConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)guiderLocations, (Object)item_.getGuiderLocations());
        Assert.assertEquals((Object)guiderPartition, (Object)item_.getGuiderPartition());
    }

    @Test
    public void sendReceiveFocal_plane_SequencerConfig_SequencerConfigurationEvent() throws Exception {
        String version = "b";
        String clearCountParameter = "";
        String clearMain = "b";
        String idleFlushMain = "";
        long idleFlushTimeout = 56L;
        String integrateMain = "s";
        String metaDataRegisters = "u";
        int overCols = 450;
        int overRows = 54;
        int postCols = 601;
        int postRows = 953;
        int preCols = 340;
        int preRows = 897;
        String pseudoReadMain = "a";
        int readCols = 406;
        int readCols2 = 51;
        String readMain = "";
        int readRows = 436;
        String rowShiftForwardMain = "";
        String rowShiftReverseMain = "";
        boolean scanMode = true;
        String sequencer = "k";
        String sequencerChecksums = "";
        String shiftCountParameter = "u";
        boolean stepAfterIntegrate = true;
        int transparentMode = 693;
        int underCols = 243;
        boolean useParallelRegisters = true;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_SequencerConfig_SequencerConfigurationEvent(version, clearCountParameter, clearMain, idleFlushMain, idleFlushTimeout, integrateMain, metaDataRegisters, overCols, overRows, postCols, postRows, preCols, preRows, pseudoReadMain, readCols, readCols2, readMain, readRows, rowShiftForwardMain, rowShiftReverseMain, scanMode, sequencer, sequencerChecksums, shiftCountParameter, stepAfterIntegrate, transparentMode, underCols, useParallelRegisters));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SequencerConfig_SequencerConfigurationEvent));
        Focal_plane_SequencerConfig_SequencerConfigurationEvent item_ = (Focal_plane_SequencerConfig_SequencerConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)clearCountParameter, (Object)item_.getClearCountParameter());
        Assert.assertEquals((Object)clearMain, (Object)item_.getClearMain());
        Assert.assertEquals((Object)idleFlushMain, (Object)item_.getIdleFlushMain());
        Assert.assertEquals((long)idleFlushTimeout, (long)item_.getIdleFlushTimeout());
        Assert.assertEquals((Object)integrateMain, (Object)item_.getIntegrateMain());
        Assert.assertEquals((Object)metaDataRegisters, (Object)item_.getMetaDataRegisters());
        Assert.assertEquals((long)overCols, (long)item_.getOverCols());
        Assert.assertEquals((long)overRows, (long)item_.getOverRows());
        Assert.assertEquals((long)postCols, (long)item_.getPostCols());
        Assert.assertEquals((long)postRows, (long)item_.getPostRows());
        Assert.assertEquals((long)preCols, (long)item_.getPreCols());
        Assert.assertEquals((long)preRows, (long)item_.getPreRows());
        Assert.assertEquals((Object)pseudoReadMain, (Object)item_.getPseudoReadMain());
        Assert.assertEquals((long)readCols, (long)item_.getReadCols());
        Assert.assertEquals((long)readCols2, (long)item_.getReadCols2());
        Assert.assertEquals((Object)readMain, (Object)item_.getReadMain());
        Assert.assertEquals((long)readRows, (long)item_.getReadRows());
        Assert.assertEquals((Object)rowShiftForwardMain, (Object)item_.getRowShiftForwardMain());
        Assert.assertEquals((Object)rowShiftReverseMain, (Object)item_.getRowShiftReverseMain());
        Assert.assertEquals((Object)scanMode, (Object)item_.isScanMode());
        Assert.assertEquals((Object)sequencer, (Object)item_.getSequencer());
        Assert.assertEquals((Object)sequencerChecksums, (Object)item_.getSequencerChecksums());
        Assert.assertEquals((Object)shiftCountParameter, (Object)item_.getShiftCountParameter());
        Assert.assertEquals((Object)stepAfterIntegrate, (Object)item_.isStepAfterIntegrate());
        Assert.assertEquals((long)transparentMode, (long)item_.getTransparentMode());
        Assert.assertEquals((long)underCols, (long)item_.getUnderCols());
        Assert.assertEquals((Object)useParallelRegisters, (Object)item_.isUseParallelRegisters());
    }

    @Test
    public void sendReceiveFocal_plane_WebHooksConfig_VisualizationConfigurationEvent() throws Exception {
        String version = "z";
        String webHooks = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_WebHooksConfig_VisualizationConfigurationEvent(version, webHooks));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_WebHooksConfig_VisualizationConfigurationEvent));
        Focal_plane_WebHooksConfig_VisualizationConfigurationEvent item_ = (Focal_plane_WebHooksConfig_VisualizationConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)webHooks, (Object)item_.getWebHooks());
    }

    @Test
    public void sendReceiveImage_handling_FitsService_GeneralConfigurationEvent() throws Exception {
        String version = "";
        String guider_headerFilesList = "k";
        String science_headerFilesList = "o";
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_FitsService_GeneralConfigurationEvent(version, guider_headerFilesList, science_headerFilesList));
        Assert.assertTrue((boolean)(item instanceof Image_handling_FitsService_GeneralConfigurationEvent));
        Image_handling_FitsService_GeneralConfigurationEvent item_ = (Image_handling_FitsService_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)guider_headerFilesList, (Object)item_.getGuider_headerFilesList());
        Assert.assertEquals((Object)science_headerFilesList, (Object)item_.getScience_headerFilesList());
    }

    @Test
    public void sendReceiveImage_handling_ImageHandler_CommandsConfigurationEvent() throws Exception {
        String version = "";
        String imagehandlingconfig_additionalFileCommands = "t";
        String imagehandlingconfig_additionalFileFilter = "";
        String imagehandlingconfig_commands = "e";
        String imagehandlingconfig_currentDirectory = "b";
        String imagehandlingconfig_environment = "";
        String imagehandlingconfig_logDirectory = "";
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_ImageHandler_CommandsConfigurationEvent(version, imagehandlingconfig_additionalFileCommands, imagehandlingconfig_additionalFileFilter, imagehandlingconfig_commands, imagehandlingconfig_currentDirectory, imagehandlingconfig_environment, imagehandlingconfig_logDirectory));
        Assert.assertTrue((boolean)(item instanceof Image_handling_ImageHandler_CommandsConfigurationEvent));
        Image_handling_ImageHandler_CommandsConfigurationEvent item_ = (Image_handling_ImageHandler_CommandsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)imagehandlingconfig_additionalFileCommands, (Object)item_.getImagehandlingconfig_additionalFileCommands());
        Assert.assertEquals((Object)imagehandlingconfig_additionalFileFilter, (Object)item_.getImagehandlingconfig_additionalFileFilter());
        Assert.assertEquals((Object)imagehandlingconfig_commands, (Object)item_.getImagehandlingconfig_commands());
        Assert.assertEquals((Object)imagehandlingconfig_currentDirectory, (Object)item_.getImagehandlingconfig_currentDirectory());
        Assert.assertEquals((Object)imagehandlingconfig_environment, (Object)item_.getImagehandlingconfig_environment());
        Assert.assertEquals((Object)imagehandlingconfig_logDirectory, (Object)item_.getImagehandlingconfig_logDirectory());
    }

    @Test
    public void sendReceiveImage_handling_ImageHandler_DAQConfigurationEvent() throws Exception {
        String version = "k";
        int imagehandlingconfig_badPixelAlarmLevel = 672;
        int imagehandlingconfig_badPixelHighThreshold = 637;
        int imagehandlingconfig_badPixelLowThreshold = 146;
        int imagehandlingconfig_badPixelWarningLevel = 235;
        boolean imagehandlingconfig_checkForBadPixels = true;
        String imagehandlingconfig_daqFolder = "j";
        String imagehandlingconfig_daqPartition = "m";
        int imagehandlingconfig_daqThreads = 524;
        String imagehandlingconfig_locations = "";
        boolean imagehandlingconfig_useStreaming = false;
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_ImageHandler_DAQConfigurationEvent(version, imagehandlingconfig_badPixelAlarmLevel, imagehandlingconfig_badPixelHighThreshold, imagehandlingconfig_badPixelLowThreshold, imagehandlingconfig_badPixelWarningLevel, imagehandlingconfig_checkForBadPixels, imagehandlingconfig_daqFolder, imagehandlingconfig_daqPartition, imagehandlingconfig_daqThreads, imagehandlingconfig_locations, imagehandlingconfig_useStreaming));
        Assert.assertTrue((boolean)(item instanceof Image_handling_ImageHandler_DAQConfigurationEvent));
        Image_handling_ImageHandler_DAQConfigurationEvent item_ = (Image_handling_ImageHandler_DAQConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)imagehandlingconfig_badPixelAlarmLevel, (long)item_.getImagehandlingconfig_badPixelAlarmLevel());
        Assert.assertEquals((long)imagehandlingconfig_badPixelHighThreshold, (long)item_.getImagehandlingconfig_badPixelHighThreshold());
        Assert.assertEquals((long)imagehandlingconfig_badPixelLowThreshold, (long)item_.getImagehandlingconfig_badPixelLowThreshold());
        Assert.assertEquals((long)imagehandlingconfig_badPixelWarningLevel, (long)item_.getImagehandlingconfig_badPixelWarningLevel());
        Assert.assertEquals((Object)imagehandlingconfig_checkForBadPixels, (Object)item_.isImagehandlingconfig_checkForBadPixels());
        Assert.assertEquals((Object)imagehandlingconfig_daqFolder, (Object)item_.getImagehandlingconfig_daqFolder());
        Assert.assertEquals((Object)imagehandlingconfig_daqPartition, (Object)item_.getImagehandlingconfig_daqPartition());
        Assert.assertEquals((long)imagehandlingconfig_daqThreads, (long)item_.getImagehandlingconfig_daqThreads());
        Assert.assertEquals((Object)imagehandlingconfig_locations, (Object)item_.getImagehandlingconfig_locations());
        Assert.assertEquals((Object)imagehandlingconfig_useStreaming, (Object)item_.isImagehandlingconfig_useStreaming());
    }

    @Test
    public void sendReceiveImage_handling_ImageHandler_FitsHandlingConfigurationEvent() throws Exception {
        String version = "";
        boolean imagehandlingconfig_FITSAutoSave = false;
        String imagehandlingconfig_FITSDirectoryPattern = "e";
        String imagehandlingconfig_FITSFilePattern = "l";
        String imagehandlingconfig_FITSRootDirectory = "";
        boolean imagehandlingconfig_raiseAlertOnMissingOrBadHeaderServiceData = false;
        String imagehandlingconfig_subsystemsToClearOnNewRun = "";
        String imagehandlingconfig_tempFileRelativeLocation = "m";
        boolean imagehandlingconfig_useTempFile = true;
        String imagehandlingconfig_waitForHeaderService = "k";
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_ImageHandler_FitsHandlingConfigurationEvent(version, imagehandlingconfig_FITSAutoSave, imagehandlingconfig_FITSDirectoryPattern, imagehandlingconfig_FITSFilePattern, imagehandlingconfig_FITSRootDirectory, imagehandlingconfig_raiseAlertOnMissingOrBadHeaderServiceData, imagehandlingconfig_subsystemsToClearOnNewRun, imagehandlingconfig_tempFileRelativeLocation, imagehandlingconfig_useTempFile, imagehandlingconfig_waitForHeaderService));
        Assert.assertTrue((boolean)(item instanceof Image_handling_ImageHandler_FitsHandlingConfigurationEvent));
        Image_handling_ImageHandler_FitsHandlingConfigurationEvent item_ = (Image_handling_ImageHandler_FitsHandlingConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)imagehandlingconfig_FITSAutoSave, (Object)item_.isImagehandlingconfig_FITSAutoSave());
        Assert.assertEquals((Object)imagehandlingconfig_FITSDirectoryPattern, (Object)item_.getImagehandlingconfig_FITSDirectoryPattern());
        Assert.assertEquals((Object)imagehandlingconfig_FITSFilePattern, (Object)item_.getImagehandlingconfig_FITSFilePattern());
        Assert.assertEquals((Object)imagehandlingconfig_FITSRootDirectory, (Object)item_.getImagehandlingconfig_FITSRootDirectory());
        Assert.assertEquals((Object)imagehandlingconfig_raiseAlertOnMissingOrBadHeaderServiceData, (Object)item_.isImagehandlingconfig_raiseAlertOnMissingOrBadHeaderServiceData());
        Assert.assertEquals((Object)imagehandlingconfig_subsystemsToClearOnNewRun, (Object)item_.getImagehandlingconfig_subsystemsToClearOnNewRun());
        Assert.assertEquals((Object)imagehandlingconfig_tempFileRelativeLocation, (Object)item_.getImagehandlingconfig_tempFileRelativeLocation());
        Assert.assertEquals((Object)imagehandlingconfig_useTempFile, (Object)item_.isImagehandlingconfig_useTempFile());
        Assert.assertEquals((Object)imagehandlingconfig_waitForHeaderService, (Object)item_.getImagehandlingconfig_waitForHeaderService());
    }

    @Test
    public void sendReceiveImage_handling_ImageHandler_GuiderConfigurationEvent() throws Exception {
        String version = "h";
        String imagehandlingconfig_guiderFITSFilePattern = "a";
        String imagehandlingconfig_guiderLocations = "g";
        String imagehandlingconfig_guiderPartition = "a";
        boolean imagehandlingconfig_includeRawStamps = false;
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_ImageHandler_GuiderConfigurationEvent(version, imagehandlingconfig_guiderFITSFilePattern, imagehandlingconfig_guiderLocations, imagehandlingconfig_guiderPartition, imagehandlingconfig_includeRawStamps));
        Assert.assertTrue((boolean)(item instanceof Image_handling_ImageHandler_GuiderConfigurationEvent));
        Image_handling_ImageHandler_GuiderConfigurationEvent item_ = (Image_handling_ImageHandler_GuiderConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)imagehandlingconfig_guiderFITSFilePattern, (Object)item_.getImagehandlingconfig_guiderFITSFilePattern());
        Assert.assertEquals((Object)imagehandlingconfig_guiderLocations, (Object)item_.getImagehandlingconfig_guiderLocations());
        Assert.assertEquals((Object)imagehandlingconfig_guiderPartition, (Object)item_.getImagehandlingconfig_guiderPartition());
        Assert.assertEquals((Object)imagehandlingconfig_includeRawStamps, (Object)item_.isImagehandlingconfig_includeRawStamps());
    }

    @Test
    public void sendReceiveImage_handling_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "j";
        int schedulers_default_nTasks = 305;
        int schedulers_default_nThreads = 481;
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads));
        Assert.assertTrue((boolean)(item instanceof Image_handling_PeriodicTasks_GeneralConfigurationEvent));
        Image_handling_PeriodicTasks_GeneralConfigurationEvent item_ = (Image_handling_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
    }

    @Test
    public void sendReceiveImage_handling_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "l";
        long agentmonitorservice_taskPeriodMillis = 322L;
        long heartbeat_taskPeriodMillis = 256L;
        long runtimeinfo_taskPeriodMillis = 284L;
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Image_handling_PeriodicTasks_timersConfigurationEvent));
        Image_handling_PeriodicTasks_timersConfigurationEvent item_ = (Image_handling_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveImage_handling_StatusAggregator_GeneralConfigurationEvent() throws Exception {
        String version = "";
        String patternConfigList = "m";
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_StatusAggregator_GeneralConfigurationEvent(version, patternConfigList));
        Assert.assertTrue((boolean)(item instanceof Image_handling_StatusAggregator_GeneralConfigurationEvent));
        Image_handling_StatusAggregator_GeneralConfigurationEvent item_ = (Image_handling_StatusAggregator_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)patternConfigList, (Object)item_.getPatternConfigList());
    }

    @Test
    public void sendReceiveFcs_Autochanger_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double temperatures_tempCellXminus_warnHi = 0.6080067157745361;
        double temperatures_tempCellXminus_warnLo = 0.9233457446098328;
        double temperatures_tempCellXminus_limitHi = 0.24350768327713013;
        double temperatures_tempCellXminus_limitLo = 0.28825122117996216;
        double temperatures_tempClampMotorXminus_warnHi = 0.7331236600875854;
        double temperatures_tempClampMotorXminus_warnLo = 0.6507946252822876;
        double temperatures_tempClampMotorXminus_limitHi = 0.9513334035873413;
        double temperatures_tempClampMotorXminus_limitLo = 0.6948140859603882;
        double temperatures_tempClampMotorXplus_warnHi = 0.09104150533676147;
        double temperatures_tempClampMotorXplus_warnLo = 0.5089883208274841;
        double temperatures_tempClampMotorXplus_limitHi = 0.3160724639892578;
        double temperatures_tempClampMotorXplus_limitLo = 0.6478259563446045;
        double temperatures_tempClampMotorYminus_warnHi = 0.979839563369751;
        double temperatures_tempClampMotorYminus_warnLo = 0.3926283121109009;
        double temperatures_tempClampMotorYminus_limitHi = 0.7510979175567627;
        double temperatures_tempClampMotorYminus_limitLo = 0.8851513266563416;
        double temperatures_tempFrontBox_warnHi = 0.35671013593673706;
        double temperatures_tempFrontBox_warnLo = 0.9610503315925598;
        double temperatures_tempFrontBox_limitHi = 0.17450577020645142;
        double temperatures_tempFrontBox_limitLo = 0.0920177698135376;
        double temperatures_tempLinearRailMotorXminus_warnHi = 0.96079421043396;
        double temperatures_tempLinearRailMotorXminus_warnLo = 0.38068634271621704;
        double temperatures_tempLinearRailMotorXminus_limitHi = 0.7788727879524231;
        double temperatures_tempLinearRailMotorXminus_limitLo = 0.4801989793777466;
        double temperatures_tempLinearRailMotorXplus_warnHi = 0.987775f;
        double temperatures_tempLinearRailMotorXplus_warnLo = 0.4404745101928711;
        double temperatures_tempLinearRailMotorXplus_limitHi = 0.32937318086624146;
        double temperatures_tempLinearRailMotorXplus_limitLo = 0.4958783984184265;
        double temperatures_tempRearBox_warnHi = 0.6876863241195679;
        double temperatures_tempRearBox_warnLo = 0.5683939456939697;
        double temperatures_tempRearBox_limitHi = 0.4215213656425476;
        double temperatures_tempRearBox_limitLo = 0.7416045665740967;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Autochanger_LimitsConfigurationEvent(version, temperatures_tempCellXminus_warnHi, temperatures_tempCellXminus_warnLo, temperatures_tempCellXminus_limitHi, temperatures_tempCellXminus_limitLo, temperatures_tempClampMotorXminus_warnHi, temperatures_tempClampMotorXminus_warnLo, temperatures_tempClampMotorXminus_limitHi, temperatures_tempClampMotorXminus_limitLo, temperatures_tempClampMotorXplus_warnHi, temperatures_tempClampMotorXplus_warnLo, temperatures_tempClampMotorXplus_limitHi, temperatures_tempClampMotorXplus_limitLo, temperatures_tempClampMotorYminus_warnHi, temperatures_tempClampMotorYminus_warnLo, temperatures_tempClampMotorYminus_limitHi, temperatures_tempClampMotorYminus_limitLo, temperatures_tempFrontBox_warnHi, temperatures_tempFrontBox_warnLo, temperatures_tempFrontBox_limitHi, temperatures_tempFrontBox_limitLo, temperatures_tempLinearRailMotorXminus_warnHi, temperatures_tempLinearRailMotorXminus_warnLo, temperatures_tempLinearRailMotorXminus_limitHi, temperatures_tempLinearRailMotorXminus_limitLo, temperatures_tempLinearRailMotorXplus_warnHi, temperatures_tempLinearRailMotorXplus_warnLo, temperatures_tempLinearRailMotorXplus_limitHi, temperatures_tempLinearRailMotorXplus_limitLo, temperatures_tempRearBox_warnHi, temperatures_tempRearBox_warnLo, temperatures_tempRearBox_limitHi, temperatures_tempRearBox_limitLo));
        Assert.assertTrue((boolean)(item instanceof Fcs_Autochanger_LimitsConfigurationEvent));
        Fcs_Autochanger_LimitsConfigurationEvent item_ = (Fcs_Autochanger_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)temperatures_tempCellXminus_warnHi, (double)item_.getTemperatures_tempCellXminus_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_tempCellXminus_warnLo, (double)item_.getTemperatures_tempCellXminus_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_tempCellXminus_limitHi, (double)item_.getTemperatures_tempCellXminus_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_tempCellXminus_limitLo, (double)item_.getTemperatures_tempCellXminus_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_tempClampMotorXminus_warnHi, (double)item_.getTemperatures_tempClampMotorXminus_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_tempClampMotorXminus_warnLo, (double)item_.getTemperatures_tempClampMotorXminus_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_tempClampMotorXminus_limitHi, (double)item_.getTemperatures_tempClampMotorXminus_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_tempClampMotorXminus_limitLo, (double)item_.getTemperatures_tempClampMotorXminus_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_tempClampMotorXplus_warnHi, (double)item_.getTemperatures_tempClampMotorXplus_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_tempClampMotorXplus_warnLo, (double)item_.getTemperatures_tempClampMotorXplus_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_tempClampMotorXplus_limitHi, (double)item_.getTemperatures_tempClampMotorXplus_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_tempClampMotorXplus_limitLo, (double)item_.getTemperatures_tempClampMotorXplus_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_tempClampMotorYminus_warnHi, (double)item_.getTemperatures_tempClampMotorYminus_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_tempClampMotorYminus_warnLo, (double)item_.getTemperatures_tempClampMotorYminus_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_tempClampMotorYminus_limitHi, (double)item_.getTemperatures_tempClampMotorYminus_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_tempClampMotorYminus_limitLo, (double)item_.getTemperatures_tempClampMotorYminus_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_tempFrontBox_warnHi, (double)item_.getTemperatures_tempFrontBox_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_tempFrontBox_warnLo, (double)item_.getTemperatures_tempFrontBox_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_tempFrontBox_limitHi, (double)item_.getTemperatures_tempFrontBox_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_tempFrontBox_limitLo, (double)item_.getTemperatures_tempFrontBox_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_tempLinearRailMotorXminus_warnHi, (double)item_.getTemperatures_tempLinearRailMotorXminus_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_tempLinearRailMotorXminus_warnLo, (double)item_.getTemperatures_tempLinearRailMotorXminus_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_tempLinearRailMotorXminus_limitHi, (double)item_.getTemperatures_tempLinearRailMotorXminus_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_tempLinearRailMotorXminus_limitLo, (double)item_.getTemperatures_tempLinearRailMotorXminus_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_tempLinearRailMotorXplus_warnHi, (double)item_.getTemperatures_tempLinearRailMotorXplus_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_tempLinearRailMotorXplus_warnLo, (double)item_.getTemperatures_tempLinearRailMotorXplus_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_tempLinearRailMotorXplus_limitHi, (double)item_.getTemperatures_tempLinearRailMotorXplus_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_tempLinearRailMotorXplus_limitLo, (double)item_.getTemperatures_tempLinearRailMotorXplus_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_tempRearBox_warnHi, (double)item_.getTemperatures_tempRearBox_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_tempRearBox_warnLo, (double)item_.getTemperatures_tempRearBox_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_tempRearBox_limitHi, (double)item_.getTemperatures_tempRearBox_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatures_tempRearBox_limitLo, (double)item_.getTemperatures_tempRearBox_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Autochanger_autochangerConfigurationEvent() throws Exception {
        String version = "j";
        double autochangertrucks_adjustmentFactor = 0.5851613283157349;
        int autochangertrucks_approachOnlinePosition = 125;
        int autochangertrucks_approachStandbyPosition = 522;
        int autochangertrucks_deltaPositionForAlignLenient = 544;
        int autochangertrucks_deltaPositionForAlignStrict = 323;
        int autochangertrucks_deltaPositionForAlignStrictLoader = 7;
        int autochangertrucks_deltaPreliminaryTargetPosition = 811;
        String autochangertrucks_driverSide = "c";
        int autochangertrucks_handoffPosition = 743;
        int autochangertrucks_highAcceleration = 259;
        int autochangertrucks_highDeceleration = 803;
        int autochangertrucks_highSpeed = 284;
        int autochangertrucks_lowAcceleration = 374;
        int autochangertrucks_lowDeceleration = 598;
        int autochangertrucks_lowSpeed = 540;
        int autochangertrucks_maxActualPositionValue = 359;
        int autochangertrucks_minActualPositionValue = 978;
        int autochangertrucks_minTargetPosition = 352;
        int autochangertrucks_naturalPosition = 601;
        int autochangertrucks_onlinePosition = 61;
        int autochangertrucks_positionRangeAtHandoff = 395;
        int autochangertrucks_positionRangeAtOnline = 990;
        int autochangertrucks_positionRangeAtStandby = 335;
        int autochangertrucks_positionRangeInTravel = 932;
        int autochangertrucks_prelimaryTargetPosition = 403;
        int autochangertrucks_proximitySensorInput = 948;
        int autochangertrucks_slowMotionPosition = 324;
        int autochangertrucks_standbyPosition = 603;
        int autochangertrucks_standbyPositionEmpty = 970;
        long autochangertrucks_timeoutForAlignFollower = 318L;
        long autochangertrucks_timeoutForTrucksMotion = 671L;
        double autochangertrucks_umax = 0.31011974811553955;
        double autochangertrucks_umin = 0.9112753868103027;
        double autochangertrucks_utarget = 0.2477748990058899;
        int latches_latchXminus_currentToOpen = 633;
        long latches_latchXminus_timeoutForLatchMotion = 308L;
        int latches_latchXplus_currentToOpen = 447;
        long latches_latchXplus_timeoutForLatchMotion = 66L;
        String onlineclamps_maxClosedStrain = "";
        String onlineclamps_maxLockedStrain = "";
        int onlineclamps_maxTimeToCloseClampsX = 924;
        int onlineclamps_maxTimeToLockAllClamps = 448;
        int onlineclamps_maxTimeToOpenClampsX = 918;
        int onlineclamps_maxTimeToUnlockAllClamps = 856;
        String onlineclamps_minLockedStrain = "f";
        int onlineclamps_minPeriod = 666;
        int onlineclamps_onlineClampXminus_currentToClamp = 565;
        int onlineclamps_onlineClampXminus_currentToOpen = 153;
        int onlineclamps_onlineClampXminus_deltaCurrent = 918;
        int onlineclamps_onlineClampXminus_finalCurrentToClose = 699;
        int onlineclamps_onlineClampXminus_incrementCurrentToClamp = 753;
        int onlineclamps_onlineClampXminus_incrementCurrentToClose = 849;
        int onlineclamps_onlineClampXminus_incrementCurrentToOpen = 887;
        int onlineclamps_onlineClampXminus_initialCurrentToClose = 358;
        int onlineclamps_onlineClampXminus_targetPositionToClose = 435;
        int onlineclamps_onlineClampXminus_targetPositionToOpen = 456;
        int onlineclamps_onlineClampXplus_currentToClamp = 108;
        int onlineclamps_onlineClampXplus_currentToOpen = 747;
        int onlineclamps_onlineClampXplus_deltaCurrent = 459;
        int onlineclamps_onlineClampXplus_finalCurrentToClose = 98;
        int onlineclamps_onlineClampXplus_incrementCurrentToClamp = 969;
        int onlineclamps_onlineClampXplus_incrementCurrentToClose = 991;
        int onlineclamps_onlineClampXplus_incrementCurrentToOpen = 343;
        int onlineclamps_onlineClampXplus_initialCurrentToClose = 40;
        int onlineclamps_onlineClampXplus_targetPositionToClose = 7;
        int onlineclamps_onlineClampXplus_targetPositionToOpen = 386;
        int onlineclamps_onlineClampYminus_currentToClamp = 468;
        int onlineclamps_onlineClampYminus_currentToOpen = 296;
        int onlineclamps_onlineClampYminus_deltaCurrent = 822;
        int onlineclamps_onlineClampYminus_finalCurrentToClose = 704;
        int onlineclamps_onlineClampYminus_incrementCurrentToClamp = 712;
        int onlineclamps_onlineClampYminus_incrementCurrentToClose = 469;
        int onlineclamps_onlineClampYminus_incrementCurrentToOpen = 875;
        int onlineclamps_onlineClampYminus_initialCurrentToClose = 230;
        int onlineclamps_onlineClampYminus_targetPositionToClose = 756;
        int onlineclamps_onlineClampYminus_targetPositionToOpen = 667;
        double onlineclamps_strainGain = 0.5188309550285339;
        int onlineclamps_timeoutForLockingClamps = 322;
        int onlineclamps_timeoutForUnlockingClamps = 111;
        long timeToUpdateProtectionSystem = 961L;
        int waitTimeForBrakeLR = 265;
        int waitTimeForBrakeOC = 703;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Autochanger_autochangerConfigurationEvent(version, autochangertrucks_adjustmentFactor, autochangertrucks_approachOnlinePosition, autochangertrucks_approachStandbyPosition, autochangertrucks_deltaPositionForAlignLenient, autochangertrucks_deltaPositionForAlignStrict, autochangertrucks_deltaPositionForAlignStrictLoader, autochangertrucks_deltaPreliminaryTargetPosition, autochangertrucks_driverSide, autochangertrucks_handoffPosition, autochangertrucks_highAcceleration, autochangertrucks_highDeceleration, autochangertrucks_highSpeed, autochangertrucks_lowAcceleration, autochangertrucks_lowDeceleration, autochangertrucks_lowSpeed, autochangertrucks_maxActualPositionValue, autochangertrucks_minActualPositionValue, autochangertrucks_minTargetPosition, autochangertrucks_naturalPosition, autochangertrucks_onlinePosition, autochangertrucks_positionRangeAtHandoff, autochangertrucks_positionRangeAtOnline, autochangertrucks_positionRangeAtStandby, autochangertrucks_positionRangeInTravel, autochangertrucks_prelimaryTargetPosition, autochangertrucks_proximitySensorInput, autochangertrucks_slowMotionPosition, autochangertrucks_standbyPosition, autochangertrucks_standbyPositionEmpty, autochangertrucks_timeoutForAlignFollower, autochangertrucks_timeoutForTrucksMotion, autochangertrucks_umax, autochangertrucks_umin, autochangertrucks_utarget, latches_latchXminus_currentToOpen, latches_latchXminus_timeoutForLatchMotion, latches_latchXplus_currentToOpen, latches_latchXplus_timeoutForLatchMotion, onlineclamps_maxClosedStrain, onlineclamps_maxLockedStrain, onlineclamps_maxTimeToCloseClampsX, onlineclamps_maxTimeToLockAllClamps, onlineclamps_maxTimeToOpenClampsX, onlineclamps_maxTimeToUnlockAllClamps, onlineclamps_minLockedStrain, onlineclamps_minPeriod, onlineclamps_onlineClampXminus_currentToClamp, onlineclamps_onlineClampXminus_currentToOpen, onlineclamps_onlineClampXminus_deltaCurrent, onlineclamps_onlineClampXminus_finalCurrentToClose, onlineclamps_onlineClampXminus_incrementCurrentToClamp, onlineclamps_onlineClampXminus_incrementCurrentToClose, onlineclamps_onlineClampXminus_incrementCurrentToOpen, onlineclamps_onlineClampXminus_initialCurrentToClose, onlineclamps_onlineClampXminus_targetPositionToClose, onlineclamps_onlineClampXminus_targetPositionToOpen, onlineclamps_onlineClampXplus_currentToClamp, onlineclamps_onlineClampXplus_currentToOpen, onlineclamps_onlineClampXplus_deltaCurrent, onlineclamps_onlineClampXplus_finalCurrentToClose, onlineclamps_onlineClampXplus_incrementCurrentToClamp, onlineclamps_onlineClampXplus_incrementCurrentToClose, onlineclamps_onlineClampXplus_incrementCurrentToOpen, onlineclamps_onlineClampXplus_initialCurrentToClose, onlineclamps_onlineClampXplus_targetPositionToClose, onlineclamps_onlineClampXplus_targetPositionToOpen, onlineclamps_onlineClampYminus_currentToClamp, onlineclamps_onlineClampYminus_currentToOpen, onlineclamps_onlineClampYminus_deltaCurrent, onlineclamps_onlineClampYminus_finalCurrentToClose, onlineclamps_onlineClampYminus_incrementCurrentToClamp, onlineclamps_onlineClampYminus_incrementCurrentToClose, onlineclamps_onlineClampYminus_incrementCurrentToOpen, onlineclamps_onlineClampYminus_initialCurrentToClose, onlineclamps_onlineClampYminus_targetPositionToClose, onlineclamps_onlineClampYminus_targetPositionToOpen, onlineclamps_strainGain, onlineclamps_timeoutForLockingClamps, onlineclamps_timeoutForUnlockingClamps, timeToUpdateProtectionSystem, waitTimeForBrakeLR, waitTimeForBrakeOC));
        Assert.assertTrue((boolean)(item instanceof Fcs_Autochanger_autochangerConfigurationEvent));
        Fcs_Autochanger_autochangerConfigurationEvent item_ = (Fcs_Autochanger_autochangerConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)autochangertrucks_adjustmentFactor, (double)item_.getAutochangertrucks_adjustmentFactor(), (double)1.0E-6f);
        Assert.assertEquals((long)autochangertrucks_approachOnlinePosition, (long)item_.getAutochangertrucks_approachOnlinePosition());
        Assert.assertEquals((long)autochangertrucks_approachStandbyPosition, (long)item_.getAutochangertrucks_approachStandbyPosition());
        Assert.assertEquals((long)autochangertrucks_deltaPositionForAlignLenient, (long)item_.getAutochangertrucks_deltaPositionForAlignLenient());
        Assert.assertEquals((long)autochangertrucks_deltaPositionForAlignStrict, (long)item_.getAutochangertrucks_deltaPositionForAlignStrict());
        Assert.assertEquals((long)autochangertrucks_deltaPositionForAlignStrictLoader, (long)item_.getAutochangertrucks_deltaPositionForAlignStrictLoader());
        Assert.assertEquals((long)autochangertrucks_deltaPreliminaryTargetPosition, (long)item_.getAutochangertrucks_deltaPreliminaryTargetPosition());
        Assert.assertEquals((Object)autochangertrucks_driverSide, (Object)item_.getAutochangertrucks_driverSide());
        Assert.assertEquals((long)autochangertrucks_handoffPosition, (long)item_.getAutochangertrucks_handoffPosition());
        Assert.assertEquals((long)autochangertrucks_highAcceleration, (long)item_.getAutochangertrucks_highAcceleration());
        Assert.assertEquals((long)autochangertrucks_highDeceleration, (long)item_.getAutochangertrucks_highDeceleration());
        Assert.assertEquals((long)autochangertrucks_highSpeed, (long)item_.getAutochangertrucks_highSpeed());
        Assert.assertEquals((long)autochangertrucks_lowAcceleration, (long)item_.getAutochangertrucks_lowAcceleration());
        Assert.assertEquals((long)autochangertrucks_lowDeceleration, (long)item_.getAutochangertrucks_lowDeceleration());
        Assert.assertEquals((long)autochangertrucks_lowSpeed, (long)item_.getAutochangertrucks_lowSpeed());
        Assert.assertEquals((long)autochangertrucks_maxActualPositionValue, (long)item_.getAutochangertrucks_maxActualPositionValue());
        Assert.assertEquals((long)autochangertrucks_minActualPositionValue, (long)item_.getAutochangertrucks_minActualPositionValue());
        Assert.assertEquals((long)autochangertrucks_minTargetPosition, (long)item_.getAutochangertrucks_minTargetPosition());
        Assert.assertEquals((long)autochangertrucks_naturalPosition, (long)item_.getAutochangertrucks_naturalPosition());
        Assert.assertEquals((long)autochangertrucks_onlinePosition, (long)item_.getAutochangertrucks_onlinePosition());
        Assert.assertEquals((long)autochangertrucks_positionRangeAtHandoff, (long)item_.getAutochangertrucks_positionRangeAtHandoff());
        Assert.assertEquals((long)autochangertrucks_positionRangeAtOnline, (long)item_.getAutochangertrucks_positionRangeAtOnline());
        Assert.assertEquals((long)autochangertrucks_positionRangeAtStandby, (long)item_.getAutochangertrucks_positionRangeAtStandby());
        Assert.assertEquals((long)autochangertrucks_positionRangeInTravel, (long)item_.getAutochangertrucks_positionRangeInTravel());
        Assert.assertEquals((long)autochangertrucks_prelimaryTargetPosition, (long)item_.getAutochangertrucks_prelimaryTargetPosition());
        Assert.assertEquals((long)autochangertrucks_proximitySensorInput, (long)item_.getAutochangertrucks_proximitySensorInput());
        Assert.assertEquals((long)autochangertrucks_slowMotionPosition, (long)item_.getAutochangertrucks_slowMotionPosition());
        Assert.assertEquals((long)autochangertrucks_standbyPosition, (long)item_.getAutochangertrucks_standbyPosition());
        Assert.assertEquals((long)autochangertrucks_standbyPositionEmpty, (long)item_.getAutochangertrucks_standbyPositionEmpty());
        Assert.assertEquals((long)autochangertrucks_timeoutForAlignFollower, (long)item_.getAutochangertrucks_timeoutForAlignFollower());
        Assert.assertEquals((long)autochangertrucks_timeoutForTrucksMotion, (long)item_.getAutochangertrucks_timeoutForTrucksMotion());
        Assert.assertEquals((double)autochangertrucks_umax, (double)item_.getAutochangertrucks_umax(), (double)1.0E-6f);
        Assert.assertEquals((double)autochangertrucks_umin, (double)item_.getAutochangertrucks_umin(), (double)1.0E-6f);
        Assert.assertEquals((double)autochangertrucks_utarget, (double)item_.getAutochangertrucks_utarget(), (double)1.0E-6f);
        Assert.assertEquals((long)latches_latchXminus_currentToOpen, (long)item_.getLatches_latchXminus_currentToOpen());
        Assert.assertEquals((long)latches_latchXminus_timeoutForLatchMotion, (long)item_.getLatches_latchXminus_timeoutForLatchMotion());
        Assert.assertEquals((long)latches_latchXplus_currentToOpen, (long)item_.getLatches_latchXplus_currentToOpen());
        Assert.assertEquals((long)latches_latchXplus_timeoutForLatchMotion, (long)item_.getLatches_latchXplus_timeoutForLatchMotion());
        Assert.assertEquals((Object)onlineclamps_maxClosedStrain, (Object)item_.getOnlineclamps_maxClosedStrain());
        Assert.assertEquals((Object)onlineclamps_maxLockedStrain, (Object)item_.getOnlineclamps_maxLockedStrain());
        Assert.assertEquals((long)onlineclamps_maxTimeToCloseClampsX, (long)item_.getOnlineclamps_maxTimeToCloseClampsX());
        Assert.assertEquals((long)onlineclamps_maxTimeToLockAllClamps, (long)item_.getOnlineclamps_maxTimeToLockAllClamps());
        Assert.assertEquals((long)onlineclamps_maxTimeToOpenClampsX, (long)item_.getOnlineclamps_maxTimeToOpenClampsX());
        Assert.assertEquals((long)onlineclamps_maxTimeToUnlockAllClamps, (long)item_.getOnlineclamps_maxTimeToUnlockAllClamps());
        Assert.assertEquals((Object)onlineclamps_minLockedStrain, (Object)item_.getOnlineclamps_minLockedStrain());
        Assert.assertEquals((long)onlineclamps_minPeriod, (long)item_.getOnlineclamps_minPeriod());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_currentToClamp, (long)item_.getOnlineclamps_onlineClampXminus_currentToClamp());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_currentToOpen, (long)item_.getOnlineclamps_onlineClampXminus_currentToOpen());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_deltaCurrent, (long)item_.getOnlineclamps_onlineClampXminus_deltaCurrent());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_finalCurrentToClose, (long)item_.getOnlineclamps_onlineClampXminus_finalCurrentToClose());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_incrementCurrentToClamp, (long)item_.getOnlineclamps_onlineClampXminus_incrementCurrentToClamp());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_incrementCurrentToClose, (long)item_.getOnlineclamps_onlineClampXminus_incrementCurrentToClose());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_incrementCurrentToOpen, (long)item_.getOnlineclamps_onlineClampXminus_incrementCurrentToOpen());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_initialCurrentToClose, (long)item_.getOnlineclamps_onlineClampXminus_initialCurrentToClose());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_targetPositionToClose, (long)item_.getOnlineclamps_onlineClampXminus_targetPositionToClose());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_targetPositionToOpen, (long)item_.getOnlineclamps_onlineClampXminus_targetPositionToOpen());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_currentToClamp, (long)item_.getOnlineclamps_onlineClampXplus_currentToClamp());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_currentToOpen, (long)item_.getOnlineclamps_onlineClampXplus_currentToOpen());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_deltaCurrent, (long)item_.getOnlineclamps_onlineClampXplus_deltaCurrent());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_finalCurrentToClose, (long)item_.getOnlineclamps_onlineClampXplus_finalCurrentToClose());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_incrementCurrentToClamp, (long)item_.getOnlineclamps_onlineClampXplus_incrementCurrentToClamp());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_incrementCurrentToClose, (long)item_.getOnlineclamps_onlineClampXplus_incrementCurrentToClose());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_incrementCurrentToOpen, (long)item_.getOnlineclamps_onlineClampXplus_incrementCurrentToOpen());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_initialCurrentToClose, (long)item_.getOnlineclamps_onlineClampXplus_initialCurrentToClose());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_targetPositionToClose, (long)item_.getOnlineclamps_onlineClampXplus_targetPositionToClose());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_targetPositionToOpen, (long)item_.getOnlineclamps_onlineClampXplus_targetPositionToOpen());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_currentToClamp, (long)item_.getOnlineclamps_onlineClampYminus_currentToClamp());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_currentToOpen, (long)item_.getOnlineclamps_onlineClampYminus_currentToOpen());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_deltaCurrent, (long)item_.getOnlineclamps_onlineClampYminus_deltaCurrent());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_finalCurrentToClose, (long)item_.getOnlineclamps_onlineClampYminus_finalCurrentToClose());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_incrementCurrentToClamp, (long)item_.getOnlineclamps_onlineClampYminus_incrementCurrentToClamp());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_incrementCurrentToClose, (long)item_.getOnlineclamps_onlineClampYminus_incrementCurrentToClose());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_incrementCurrentToOpen, (long)item_.getOnlineclamps_onlineClampYminus_incrementCurrentToOpen());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_initialCurrentToClose, (long)item_.getOnlineclamps_onlineClampYminus_initialCurrentToClose());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_targetPositionToClose, (long)item_.getOnlineclamps_onlineClampYminus_targetPositionToClose());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_targetPositionToOpen, (long)item_.getOnlineclamps_onlineClampYminus_targetPositionToOpen());
        Assert.assertEquals((double)onlineclamps_strainGain, (double)item_.getOnlineclamps_strainGain(), (double)1.0E-6f);
        Assert.assertEquals((long)onlineclamps_timeoutForLockingClamps, (long)item_.getOnlineclamps_timeoutForLockingClamps());
        Assert.assertEquals((long)onlineclamps_timeoutForUnlockingClamps, (long)item_.getOnlineclamps_timeoutForUnlockingClamps());
        Assert.assertEquals((long)timeToUpdateProtectionSystem, (long)item_.getTimeToUpdateProtectionSystem());
        Assert.assertEquals((long)waitTimeForBrakeLR, (long)item_.getWaitTimeForBrakeLR());
        Assert.assertEquals((long)waitTimeForBrakeOC, (long)item_.getWaitTimeForBrakeOC());
    }

    @Test
    public void sendReceiveFcs_Autochanger_readRateConfigurationEvent() throws Exception {
        String version = "b";
        int autochangertrucks_readSensorsRate = 158;
        int latches_latchXminus_readSensorsRate = 12;
        int latches_latchXplus_readSensorsRate = 488;
        int onlineclamps_onlineClampXminus_readSensorsRate = 562;
        int onlineclamps_onlineClampXplus_readSensorsRate = 955;
        int onlineclamps_onlineClampYminus_readSensorsRate = 680;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Autochanger_readRateConfigurationEvent(version, autochangertrucks_readSensorsRate, latches_latchXminus_readSensorsRate, latches_latchXplus_readSensorsRate, onlineclamps_onlineClampXminus_readSensorsRate, onlineclamps_onlineClampXplus_readSensorsRate, onlineclamps_onlineClampYminus_readSensorsRate));
        Assert.assertTrue((boolean)(item instanceof Fcs_Autochanger_readRateConfigurationEvent));
        Fcs_Autochanger_readRateConfigurationEvent item_ = (Fcs_Autochanger_readRateConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)autochangertrucks_readSensorsRate, (long)item_.getAutochangertrucks_readSensorsRate());
        Assert.assertEquals((long)latches_latchXminus_readSensorsRate, (long)item_.getLatches_latchXminus_readSensorsRate());
        Assert.assertEquals((long)latches_latchXplus_readSensorsRate, (long)item_.getLatches_latchXplus_readSensorsRate());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_readSensorsRate, (long)item_.getOnlineclamps_onlineClampXminus_readSensorsRate());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_readSensorsRate, (long)item_.getOnlineclamps_onlineClampXplus_readSensorsRate());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_readSensorsRate, (long)item_.getOnlineclamps_onlineClampYminus_readSensorsRate());
    }

    @Test
    public void sendReceiveFcs_Autochanger_sensorConfigurationEvent() throws Exception {
        String version = "b";
        int autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorBXminus_byteNumero = 52;
        String autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorBXminus_dioName = "e";
        int autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorBXminus_inputNumero = 561;
        int autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorXminus_byteNumero = 891;
        String autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorXminus_dioName = "";
        int autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorXminus_inputNumero = 871;
        int autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorBXminus_byteNumero = 791;
        String autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorBXminus_dioName = "";
        int autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorBXminus_inputNumero = 309;
        int autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorXminus_byteNumero = 673;
        String autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorXminus_dioName = "";
        int autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorXminus_inputNumero = 439;
        int autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorBXminus_byteNumero = 725;
        String autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorBXminus_dioName = "";
        int autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorBXminus_inputNumero = 599;
        int autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorXminus_byteNumero = 769;
        String autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorXminus_dioName = "p";
        int autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorXminus_inputNumero = 54;
        int autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorBXplus_byteNumero = 559;
        String autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorBXplus_dioName = "k";
        int autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorBXplus_inputNumero = 836;
        int autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorXplus_byteNumero = 824;
        String autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorXplus_dioName = "a";
        int autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorXplus_inputNumero = 879;
        int autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorBXplus_byteNumero = 317;
        String autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorBXplus_dioName = "";
        int autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorBXplus_inputNumero = 853;
        int autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorXplus_byteNumero = 880;
        String autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorXplus_dioName = "l";
        int autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorXplus_inputNumero = 15;
        int autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorBXplus_byteNumero = 280;
        String autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorBXplus_dioName = "v";
        int autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorBXplus_inputNumero = 625;
        int autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorXplus_byteNumero = 336;
        String autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorXplus_dioName = "z";
        int autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorXplus_inputNumero = 158;
        int latches_latchXminus_closeSensorsLatchXminus_closeSensorBLatchXminus_byteNumero = 476;
        String latches_latchXminus_closeSensorsLatchXminus_closeSensorBLatchXminus_dioName = "a";
        int latches_latchXminus_closeSensorsLatchXminus_closeSensorBLatchXminus_inputNumero = 718;
        int latches_latchXminus_closeSensorsLatchXminus_closeSensorLatchXminus_byteNumero = 883;
        String latches_latchXminus_closeSensorsLatchXminus_closeSensorLatchXminus_dioName = "k";
        int latches_latchXminus_closeSensorsLatchXminus_closeSensorLatchXminus_inputNumero = 227;
        int latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorBLatchXminus_byteNumero = 5;
        String latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorBLatchXminus_dioName = "";
        int latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorBLatchXminus_inputNumero = 355;
        int latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorLatchXminus_byteNumero = 364;
        String latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorLatchXminus_dioName = "b";
        int latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorLatchXminus_inputNumero = 152;
        int latches_latchXminus_openSensorsLatchXminus_openSensorBLatchXminus_byteNumero = 514;
        String latches_latchXminus_openSensorsLatchXminus_openSensorBLatchXminus_dioName = "w";
        int latches_latchXminus_openSensorsLatchXminus_openSensorBLatchXminus_inputNumero = 286;
        int latches_latchXminus_openSensorsLatchXminus_openSensorLatchXminus_byteNumero = 592;
        String latches_latchXminus_openSensorsLatchXminus_openSensorLatchXminus_dioName = "";
        int latches_latchXminus_openSensorsLatchXminus_openSensorLatchXminus_inputNumero = 128;
        int latches_latchXplus_closeSensorsLatchXplus_closeSensorBLatchXplus_byteNumero = 230;
        String latches_latchXplus_closeSensorsLatchXplus_closeSensorBLatchXplus_dioName = "";
        int latches_latchXplus_closeSensorsLatchXplus_closeSensorBLatchXplus_inputNumero = 931;
        int latches_latchXplus_closeSensorsLatchXplus_closeSensorLatchXplus_byteNumero = 507;
        String latches_latchXplus_closeSensorsLatchXplus_closeSensorLatchXplus_dioName = "d";
        int latches_latchXplus_closeSensorsLatchXplus_closeSensorLatchXplus_inputNumero = 302;
        int latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorBLatchXplus_byteNumero = 637;
        String latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorBLatchXplus_dioName = "";
        int latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorBLatchXplus_inputNumero = 2;
        int latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorLatchXplus_byteNumero = 873;
        String latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorLatchXplus_dioName = "";
        int latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorLatchXplus_inputNumero = 894;
        int latches_latchXplus_openSensorsLatchXplus_openSensorBLatchXplus_byteNumero = 387;
        String latches_latchXplus_openSensorsLatchXplus_openSensorBLatchXplus_dioName = "";
        int latches_latchXplus_openSensorsLatchXplus_openSensorBLatchXplus_inputNumero = 174;
        int latches_latchXplus_openSensorsLatchXplus_openSensorLatchXplus_byteNumero = 461;
        String latches_latchXplus_openSensorsLatchXplus_openSensorLatchXplus_dioName = "x";
        int latches_latchXplus_openSensorsLatchXplus_openSensorLatchXplus_inputNumero = 177;
        int onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensorC_byteNumero = 586;
        String onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensorC_dioName = "g";
        int onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensorC_inputNumero = 476;
        int onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensor_byteNumero = 238;
        String onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensor_dioName = "b";
        int onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensor_inputNumero = 465;
        int onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensorC_byteNumero = 334;
        String onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensorC_dioName = "";
        int onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensorC_inputNumero = 488;
        int onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensor_byteNumero = 513;
        String onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensor_dioName = "i";
        int onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensor_inputNumero = 549;
        int onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensorC_byteNumero = 72;
        String onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensorC_dioName = "k";
        int onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensorC_inputNumero = 758;
        int onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensor_byteNumero = 882;
        String onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensor_dioName = "h";
        int onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensor_inputNumero = 659;
        int onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensorC_byteNumero = 233;
        String onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensorC_dioName = "o";
        int onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensorC_inputNumero = 245;
        int onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensor_byteNumero = 182;
        String onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensor_dioName = "";
        int onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensor_inputNumero = 26;
        int onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensorC_byteNumero = 358;
        String onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensorC_dioName = "u";
        int onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensorC_inputNumero = 839;
        int onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensor_byteNumero = 262;
        String onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensor_dioName = "c";
        int onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensor_inputNumero = 67;
        int onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensorC_byteNumero = 915;
        String onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensorC_dioName = "v";
        int onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensorC_inputNumero = 140;
        int onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensor_byteNumero = 372;
        String onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensor_dioName = "d";
        int onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensor_inputNumero = 900;
        int plc_OUT_AF0_Sensors_OUT_AF0_C_byteNumero = 42;
        String plc_OUT_AF0_Sensors_OUT_AF0_C_dioName = "";
        int plc_OUT_AF0_Sensors_OUT_AF0_C_inputNumero = 775;
        int plc_OUT_AF0_Sensors_OUT_AF0_byteNumero = 141;
        String plc_OUT_AF0_Sensors_OUT_AF0_dioName = "";
        int plc_OUT_AF0_Sensors_OUT_AF0_inputNumero = 265;
        int plc_OUT_AF1_Sensors_OUT_AF1_C_byteNumero = 239;
        String plc_OUT_AF1_Sensors_OUT_AF1_C_dioName = "b";
        int plc_OUT_AF1_Sensors_OUT_AF1_C_inputNumero = 329;
        int plc_OUT_AF1_Sensors_OUT_AF1_byteNumero = 369;
        String plc_OUT_AF1_Sensors_OUT_AF1_dioName = "g";
        int plc_OUT_AF1_Sensors_OUT_AF1_inputNumero = 856;
        int plc_OUT_AF3_Sensors_OUT_AF3_C_byteNumero = 988;
        String plc_OUT_AF3_Sensors_OUT_AF3_C_dioName = "";
        int plc_OUT_AF3_Sensors_OUT_AF3_C_inputNumero = 320;
        int plc_OUT_AF3_Sensors_OUT_AF3_byteNumero = 778;
        String plc_OUT_AF3_Sensors_OUT_AF3_dioName = "";
        int plc_OUT_AF3_Sensors_OUT_AF3_inputNumero = 886;
        int plc_OUT_AIN_byteNumero = 622;
        String plc_OUT_AIN_dioName = "";
        int plc_OUT_AIN_inputNumero = 454;
        int plc_OUT_AOL_byteNumero = 545;
        String plc_OUT_AOL_dioName = "";
        int plc_OUT_AOL_inputNumero = 994;
        int plc_OUT_AP1_Sensors_OUT_AP1_C_byteNumero = 526;
        String plc_OUT_AP1_Sensors_OUT_AP1_C_dioName = "q";
        int plc_OUT_AP1_Sensors_OUT_AP1_C_inputNumero = 838;
        int plc_OUT_AP1_Sensors_OUT_AP1_byteNumero = 189;
        String plc_OUT_AP1_Sensors_OUT_AP1_dioName = "i";
        int plc_OUT_AP1_Sensors_OUT_AP1_inputNumero = 708;
        int plc_OUT_AP2_Sensors_OUT_AP2_C_byteNumero = 952;
        String plc_OUT_AP2_Sensors_OUT_AP2_C_dioName = "";
        int plc_OUT_AP2_Sensors_OUT_AP2_C_inputNumero = 467;
        int plc_OUT_AP2_Sensors_OUT_AP2_byteNumero = 204;
        String plc_OUT_AP2_Sensors_OUT_AP2_dioName = "";
        int plc_OUT_AP2_Sensors_OUT_AP2_inputNumero = 79;
        int plc_OUT_AP3_Sensors_OUT_AP3_C_byteNumero = 803;
        String plc_OUT_AP3_Sensors_OUT_AP3_C_dioName = "";
        int plc_OUT_AP3_Sensors_OUT_AP3_C_inputNumero = 63;
        int plc_OUT_AP3_Sensors_OUT_AP3_byteNumero = 828;
        String plc_OUT_AP3_Sensors_OUT_AP3_dioName = "u";
        int plc_OUT_AP3_Sensors_OUT_AP3_inputNumero = 362;
        int plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor0_byteNumero = 748;
        String plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor0_dioName = "a";
        int plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor0_inputNumero = 771;
        int plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor1_byteNumero = 839;
        String plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor1_dioName = "c";
        int plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor1_inputNumero = 312;
        int plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandbyC_byteNumero = 372;
        String plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandbyC_dioName = "";
        int plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandbyC_inputNumero = 15;
        int plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandby_byteNumero = 958;
        String plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandby_dioName = "";
        int plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandby_inputNumero = 420;
        int plc_carousel_CF0Sensors_carousel_CF0_C_byteNumero = 18;
        String plc_carousel_CF0Sensors_carousel_CF0_C_dioName = "";
        int plc_carousel_CF0Sensors_carousel_CF0_C_inputNumero = 52;
        int plc_carousel_CF0Sensors_carousel_CF0_byteNumero = 998;
        String plc_carousel_CF0Sensors_carousel_CF0_dioName = "a";
        int plc_carousel_CF0Sensors_carousel_CF0_inputNumero = 231;
        int plc_carousel_CF1Sensors_carousel_CF1_C_byteNumero = 16;
        String plc_carousel_CF1Sensors_carousel_CF1_C_dioName = "i";
        int plc_carousel_CF1Sensors_carousel_CF1_C_inputNumero = 530;
        int plc_carousel_CF1Sensors_carousel_CF1_byteNumero = 881;
        String plc_carousel_CF1Sensors_carousel_CF1_dioName = "";
        int plc_carousel_CF1Sensors_carousel_CF1_inputNumero = 389;
        int plc_inclinometerXminus_byteNumero = 219;
        String plc_inclinometerXminus_deviceName = "";
        int plc_inclinometerXplus_byteNumero = 369;
        String plc_inclinometerXplus_deviceName = "";
        int plc_loaderConnectedSensors_loaderConnectedSensorC_byteNumero = 272;
        String plc_loaderConnectedSensors_loaderConnectedSensorC_dioName = "";
        int plc_loaderConnectedSensors_loaderConnectedSensorC_inputNumero = 284;
        int plc_loaderConnectedSensors_loaderConnectedSensor_byteNumero = 440;
        String plc_loaderConnectedSensors_loaderConnectedSensor_dioName = "";
        int plc_loaderConnectedSensors_loaderConnectedSensor_inputNumero = 156;
        int plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor0_byteNumero = 249;
        String plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor0_dioName = "";
        int plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor0_inputNumero = 809;
        int plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor1_byteNumero = 114;
        String plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor1_dioName = "q";
        int plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor1_inputNumero = 219;
        int plc_loaderPresenceSensors_presenceLoader_C_byteNumero = 146;
        String plc_loaderPresenceSensors_presenceLoader_C_dioName = "w";
        int plc_loaderPresenceSensors_presenceLoader_C_inputNumero = 226;
        int plc_loaderPresenceSensors_presenceLoader_byteNumero = 732;
        String plc_loaderPresenceSensors_presenceLoader_dioName = "g";
        int plc_loaderPresenceSensors_presenceLoader_inputNumero = 409;
        int plc_lockOutSensors_lockOut_C_byteNumero = 726;
        String plc_lockOutSensors_lockOut_C_dioName = "";
        int plc_lockOutSensors_lockOut_C_inputNumero = 451;
        int plc_lockOutSensors_lockOut_byteNumero = 722;
        String plc_lockOutSensors_lockOut_dioName = "";
        int plc_lockOutSensors_lockOut_inputNumero = 399;
        int plc_lockOutShunt_byteNumero = 168;
        String plc_lockOutShunt_dioName = "";
        int plc_lockOutShunt_inputNumero = 713;
        int plc_lpmEngineeringKeySensors_engineeringKey_C_byteNumero = 784;
        String plc_lpmEngineeringKeySensors_engineeringKey_C_dioName = "";
        int plc_lpmEngineeringKeySensors_engineeringKey_C_inputNumero = 801;
        int plc_lpmEngineeringKeySensors_engineeringKey_byteNumero = 61;
        String plc_lpmEngineeringKeySensors_engineeringKey_dioName = "";
        int plc_lpmEngineeringKeySensors_engineeringKey_inputNumero = 359;
        int plc_lpmLatchesStatus_byteNumero = 813;
        String plc_lpmLatchesStatus_dioName = "";
        int plc_lpmLatchesStatus_inputNumero = 661;
        int plc_lpmLinearRail1Status_byteNumero = 219;
        String plc_lpmLinearRail1Status_dioName = "i";
        int plc_lpmLinearRail1Status_inputNumero = 743;
        int plc_lpmLinearRail2Status_byteNumero = 808;
        String plc_lpmLinearRail2Status_dioName = "";
        int plc_lpmLinearRail2Status_inputNumero = 279;
        int plc_lpmOnlineClampsStatus_byteNumero = 81;
        String plc_lpmOnlineClampsStatus_dioName = "";
        int plc_lpmOnlineClampsStatus_inputNumero = 127;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Autochanger_sensorConfigurationEvent(version, autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorBXminus_byteNumero, autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorBXminus_dioName, autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorBXminus_inputNumero, autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorXminus_byteNumero, autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorXminus_dioName, autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorXminus_inputNumero, autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorBXminus_byteNumero, autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorBXminus_dioName, autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorBXminus_inputNumero, autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorXminus_byteNumero, autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorXminus_dioName, autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorXminus_inputNumero, autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorBXminus_byteNumero, autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorBXminus_dioName, autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorBXminus_inputNumero, autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorXminus_byteNumero, autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorXminus_dioName, autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorXminus_inputNumero, autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorBXplus_byteNumero, autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorBXplus_dioName, autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorBXplus_inputNumero, autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorXplus_byteNumero, autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorXplus_dioName, autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorXplus_inputNumero, autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorBXplus_byteNumero, autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorBXplus_dioName, autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorBXplus_inputNumero, autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorXplus_byteNumero, autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorXplus_dioName, autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorXplus_inputNumero, autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorBXplus_byteNumero, autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorBXplus_dioName, autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorBXplus_inputNumero, autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorXplus_byteNumero, autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorXplus_dioName, autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorXplus_inputNumero, latches_latchXminus_closeSensorsLatchXminus_closeSensorBLatchXminus_byteNumero, latches_latchXminus_closeSensorsLatchXminus_closeSensorBLatchXminus_dioName, latches_latchXminus_closeSensorsLatchXminus_closeSensorBLatchXminus_inputNumero, latches_latchXminus_closeSensorsLatchXminus_closeSensorLatchXminus_byteNumero, latches_latchXminus_closeSensorsLatchXminus_closeSensorLatchXminus_dioName, latches_latchXminus_closeSensorsLatchXminus_closeSensorLatchXminus_inputNumero, latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorBLatchXminus_byteNumero, latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorBLatchXminus_dioName, latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorBLatchXminus_inputNumero, latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorLatchXminus_byteNumero, latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorLatchXminus_dioName, latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorLatchXminus_inputNumero, latches_latchXminus_openSensorsLatchXminus_openSensorBLatchXminus_byteNumero, latches_latchXminus_openSensorsLatchXminus_openSensorBLatchXminus_dioName, latches_latchXminus_openSensorsLatchXminus_openSensorBLatchXminus_inputNumero, latches_latchXminus_openSensorsLatchXminus_openSensorLatchXminus_byteNumero, latches_latchXminus_openSensorsLatchXminus_openSensorLatchXminus_dioName, latches_latchXminus_openSensorsLatchXminus_openSensorLatchXminus_inputNumero, latches_latchXplus_closeSensorsLatchXplus_closeSensorBLatchXplus_byteNumero, latches_latchXplus_closeSensorsLatchXplus_closeSensorBLatchXplus_dioName, latches_latchXplus_closeSensorsLatchXplus_closeSensorBLatchXplus_inputNumero, latches_latchXplus_closeSensorsLatchXplus_closeSensorLatchXplus_byteNumero, latches_latchXplus_closeSensorsLatchXplus_closeSensorLatchXplus_dioName, latches_latchXplus_closeSensorsLatchXplus_closeSensorLatchXplus_inputNumero, latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorBLatchXplus_byteNumero, latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorBLatchXplus_dioName, latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorBLatchXplus_inputNumero, latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorLatchXplus_byteNumero, latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorLatchXplus_dioName, latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorLatchXplus_inputNumero, latches_latchXplus_openSensorsLatchXplus_openSensorBLatchXplus_byteNumero, latches_latchXplus_openSensorsLatchXplus_openSensorBLatchXplus_dioName, latches_latchXplus_openSensorsLatchXplus_openSensorBLatchXplus_inputNumero, latches_latchXplus_openSensorsLatchXplus_openSensorLatchXplus_byteNumero, latches_latchXplus_openSensorsLatchXplus_openSensorLatchXplus_dioName, latches_latchXplus_openSensorsLatchXplus_openSensorLatchXplus_inputNumero, onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensorC_byteNumero, onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensorC_dioName, onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensorC_inputNumero, onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensor_byteNumero, onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensor_dioName, onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensor_inputNumero, onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensorC_byteNumero, onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensorC_dioName, onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensorC_inputNumero, onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensor_byteNumero, onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensor_dioName, onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensor_inputNumero, onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensorC_byteNumero, onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensorC_dioName, onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensorC_inputNumero, onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensor_byteNumero, onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensor_dioName, onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensor_inputNumero, onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensorC_byteNumero, onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensorC_dioName, onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensorC_inputNumero, onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensor_byteNumero, onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensor_dioName, onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensor_inputNumero, onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensorC_byteNumero, onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensorC_dioName, onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensorC_inputNumero, onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensor_byteNumero, onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensor_dioName, onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensor_inputNumero, onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensorC_byteNumero, onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensorC_dioName, onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensorC_inputNumero, onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensor_byteNumero, onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensor_dioName, onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensor_inputNumero, plc_OUT_AF0_Sensors_OUT_AF0_C_byteNumero, plc_OUT_AF0_Sensors_OUT_AF0_C_dioName, plc_OUT_AF0_Sensors_OUT_AF0_C_inputNumero, plc_OUT_AF0_Sensors_OUT_AF0_byteNumero, plc_OUT_AF0_Sensors_OUT_AF0_dioName, plc_OUT_AF0_Sensors_OUT_AF0_inputNumero, plc_OUT_AF1_Sensors_OUT_AF1_C_byteNumero, plc_OUT_AF1_Sensors_OUT_AF1_C_dioName, plc_OUT_AF1_Sensors_OUT_AF1_C_inputNumero, plc_OUT_AF1_Sensors_OUT_AF1_byteNumero, plc_OUT_AF1_Sensors_OUT_AF1_dioName, plc_OUT_AF1_Sensors_OUT_AF1_inputNumero, plc_OUT_AF3_Sensors_OUT_AF3_C_byteNumero, plc_OUT_AF3_Sensors_OUT_AF3_C_dioName, plc_OUT_AF3_Sensors_OUT_AF3_C_inputNumero, plc_OUT_AF3_Sensors_OUT_AF3_byteNumero, plc_OUT_AF3_Sensors_OUT_AF3_dioName, plc_OUT_AF3_Sensors_OUT_AF3_inputNumero, plc_OUT_AIN_byteNumero, plc_OUT_AIN_dioName, plc_OUT_AIN_inputNumero, plc_OUT_AOL_byteNumero, plc_OUT_AOL_dioName, plc_OUT_AOL_inputNumero, plc_OUT_AP1_Sensors_OUT_AP1_C_byteNumero, plc_OUT_AP1_Sensors_OUT_AP1_C_dioName, plc_OUT_AP1_Sensors_OUT_AP1_C_inputNumero, plc_OUT_AP1_Sensors_OUT_AP1_byteNumero, plc_OUT_AP1_Sensors_OUT_AP1_dioName, plc_OUT_AP1_Sensors_OUT_AP1_inputNumero, plc_OUT_AP2_Sensors_OUT_AP2_C_byteNumero, plc_OUT_AP2_Sensors_OUT_AP2_C_dioName, plc_OUT_AP2_Sensors_OUT_AP2_C_inputNumero, plc_OUT_AP2_Sensors_OUT_AP2_byteNumero, plc_OUT_AP2_Sensors_OUT_AP2_dioName, plc_OUT_AP2_Sensors_OUT_AP2_inputNumero, plc_OUT_AP3_Sensors_OUT_AP3_C_byteNumero, plc_OUT_AP3_Sensors_OUT_AP3_C_dioName, plc_OUT_AP3_Sensors_OUT_AP3_C_inputNumero, plc_OUT_AP3_Sensors_OUT_AP3_byteNumero, plc_OUT_AP3_Sensors_OUT_AP3_dioName, plc_OUT_AP3_Sensors_OUT_AP3_inputNumero, plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor0_byteNumero, plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor0_dioName, plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor0_inputNumero, plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor1_byteNumero, plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor1_dioName, plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor1_inputNumero, plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandbyC_byteNumero, plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandbyC_dioName, plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandbyC_inputNumero, plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandby_byteNumero, plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandby_dioName, plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandby_inputNumero, plc_carousel_CF0Sensors_carousel_CF0_C_byteNumero, plc_carousel_CF0Sensors_carousel_CF0_C_dioName, plc_carousel_CF0Sensors_carousel_CF0_C_inputNumero, plc_carousel_CF0Sensors_carousel_CF0_byteNumero, plc_carousel_CF0Sensors_carousel_CF0_dioName, plc_carousel_CF0Sensors_carousel_CF0_inputNumero, plc_carousel_CF1Sensors_carousel_CF1_C_byteNumero, plc_carousel_CF1Sensors_carousel_CF1_C_dioName, plc_carousel_CF1Sensors_carousel_CF1_C_inputNumero, plc_carousel_CF1Sensors_carousel_CF1_byteNumero, plc_carousel_CF1Sensors_carousel_CF1_dioName, plc_carousel_CF1Sensors_carousel_CF1_inputNumero, plc_inclinometerXminus_byteNumero, plc_inclinometerXminus_deviceName, plc_inclinometerXplus_byteNumero, plc_inclinometerXplus_deviceName, plc_loaderConnectedSensors_loaderConnectedSensorC_byteNumero, plc_loaderConnectedSensors_loaderConnectedSensorC_dioName, plc_loaderConnectedSensors_loaderConnectedSensorC_inputNumero, plc_loaderConnectedSensors_loaderConnectedSensor_byteNumero, plc_loaderConnectedSensors_loaderConnectedSensor_dioName, plc_loaderConnectedSensors_loaderConnectedSensor_inputNumero, plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor0_byteNumero, plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor0_dioName, plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor0_inputNumero, plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor1_byteNumero, plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor1_dioName, plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor1_inputNumero, plc_loaderPresenceSensors_presenceLoader_C_byteNumero, plc_loaderPresenceSensors_presenceLoader_C_dioName, plc_loaderPresenceSensors_presenceLoader_C_inputNumero, plc_loaderPresenceSensors_presenceLoader_byteNumero, plc_loaderPresenceSensors_presenceLoader_dioName, plc_loaderPresenceSensors_presenceLoader_inputNumero, plc_lockOutSensors_lockOut_C_byteNumero, plc_lockOutSensors_lockOut_C_dioName, plc_lockOutSensors_lockOut_C_inputNumero, plc_lockOutSensors_lockOut_byteNumero, plc_lockOutSensors_lockOut_dioName, plc_lockOutSensors_lockOut_inputNumero, plc_lockOutShunt_byteNumero, plc_lockOutShunt_dioName, plc_lockOutShunt_inputNumero, plc_lpmEngineeringKeySensors_engineeringKey_C_byteNumero, plc_lpmEngineeringKeySensors_engineeringKey_C_dioName, plc_lpmEngineeringKeySensors_engineeringKey_C_inputNumero, plc_lpmEngineeringKeySensors_engineeringKey_byteNumero, plc_lpmEngineeringKeySensors_engineeringKey_dioName, plc_lpmEngineeringKeySensors_engineeringKey_inputNumero, plc_lpmLatchesStatus_byteNumero, plc_lpmLatchesStatus_dioName, plc_lpmLatchesStatus_inputNumero, plc_lpmLinearRail1Status_byteNumero, plc_lpmLinearRail1Status_dioName, plc_lpmLinearRail1Status_inputNumero, plc_lpmLinearRail2Status_byteNumero, plc_lpmLinearRail2Status_dioName, plc_lpmLinearRail2Status_inputNumero, plc_lpmOnlineClampsStatus_byteNumero, plc_lpmOnlineClampsStatus_dioName, plc_lpmOnlineClampsStatus_inputNumero));
        Assert.assertTrue((boolean)(item instanceof Fcs_Autochanger_sensorConfigurationEvent));
        Fcs_Autochanger_sensorConfigurationEvent item_ = (Fcs_Autochanger_sensorConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorBXminus_byteNumero, (long)item_.getAutochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorBXminus_byteNumero());
        Assert.assertEquals((Object)autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorBXminus_dioName, (Object)item_.getAutochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorBXminus_dioName());
        Assert.assertEquals((long)autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorBXminus_inputNumero, (long)item_.getAutochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorBXminus_inputNumero());
        Assert.assertEquals((long)autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorXminus_byteNumero, (long)item_.getAutochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorXminus_byteNumero());
        Assert.assertEquals((Object)autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorXminus_dioName, (Object)item_.getAutochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorXminus_dioName());
        Assert.assertEquals((long)autochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorXminus_inputNumero, (long)item_.getAutochangertrucks_acTruckXminus_handoffPositionSensorsXminus_handoffPositionSensorXminus_inputNumero());
        Assert.assertEquals((long)autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorBXminus_byteNumero, (long)item_.getAutochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorBXminus_byteNumero());
        Assert.assertEquals((Object)autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorBXminus_dioName, (Object)item_.getAutochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorBXminus_dioName());
        Assert.assertEquals((long)autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorBXminus_inputNumero, (long)item_.getAutochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorBXminus_inputNumero());
        Assert.assertEquals((long)autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorXminus_byteNumero, (long)item_.getAutochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorXminus_byteNumero());
        Assert.assertEquals((Object)autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorXminus_dioName, (Object)item_.getAutochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorXminus_dioName());
        Assert.assertEquals((long)autochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorXminus_inputNumero, (long)item_.getAutochangertrucks_acTruckXminus_onlinePositionSensorsXminus_onlinePositionSensorXminus_inputNumero());
        Assert.assertEquals((long)autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorBXminus_byteNumero, (long)item_.getAutochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorBXminus_byteNumero());
        Assert.assertEquals((Object)autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorBXminus_dioName, (Object)item_.getAutochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorBXminus_dioName());
        Assert.assertEquals((long)autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorBXminus_inputNumero, (long)item_.getAutochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorBXminus_inputNumero());
        Assert.assertEquals((long)autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorXminus_byteNumero, (long)item_.getAutochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorXminus_byteNumero());
        Assert.assertEquals((Object)autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorXminus_dioName, (Object)item_.getAutochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorXminus_dioName());
        Assert.assertEquals((long)autochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorXminus_inputNumero, (long)item_.getAutochangertrucks_acTruckXminus_standbyPositionSensorsXminus_standbyPositionSensorXminus_inputNumero());
        Assert.assertEquals((long)autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorBXplus_byteNumero, (long)item_.getAutochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorBXplus_byteNumero());
        Assert.assertEquals((Object)autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorBXplus_dioName, (Object)item_.getAutochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorBXplus_dioName());
        Assert.assertEquals((long)autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorBXplus_inputNumero, (long)item_.getAutochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorBXplus_inputNumero());
        Assert.assertEquals((long)autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorXplus_byteNumero, (long)item_.getAutochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorXplus_byteNumero());
        Assert.assertEquals((Object)autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorXplus_dioName, (Object)item_.getAutochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorXplus_dioName());
        Assert.assertEquals((long)autochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorXplus_inputNumero, (long)item_.getAutochangertrucks_acTruckXplus_handoffPositionSensorsXplus_handoffPositionSensorXplus_inputNumero());
        Assert.assertEquals((long)autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorBXplus_byteNumero, (long)item_.getAutochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorBXplus_byteNumero());
        Assert.assertEquals((Object)autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorBXplus_dioName, (Object)item_.getAutochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorBXplus_dioName());
        Assert.assertEquals((long)autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorBXplus_inputNumero, (long)item_.getAutochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorBXplus_inputNumero());
        Assert.assertEquals((long)autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorXplus_byteNumero, (long)item_.getAutochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorXplus_byteNumero());
        Assert.assertEquals((Object)autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorXplus_dioName, (Object)item_.getAutochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorXplus_dioName());
        Assert.assertEquals((long)autochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorXplus_inputNumero, (long)item_.getAutochangertrucks_acTruckXplus_onlinePositionSensorsXplus_onlinePositionSensorXplus_inputNumero());
        Assert.assertEquals((long)autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorBXplus_byteNumero, (long)item_.getAutochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorBXplus_byteNumero());
        Assert.assertEquals((Object)autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorBXplus_dioName, (Object)item_.getAutochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorBXplus_dioName());
        Assert.assertEquals((long)autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorBXplus_inputNumero, (long)item_.getAutochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorBXplus_inputNumero());
        Assert.assertEquals((long)autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorXplus_byteNumero, (long)item_.getAutochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorXplus_byteNumero());
        Assert.assertEquals((Object)autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorXplus_dioName, (Object)item_.getAutochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorXplus_dioName());
        Assert.assertEquals((long)autochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorXplus_inputNumero, (long)item_.getAutochangertrucks_acTruckXplus_standbyPositionSensorsXplus_standbyPositionSensorXplus_inputNumero());
        Assert.assertEquals((long)latches_latchXminus_closeSensorsLatchXminus_closeSensorBLatchXminus_byteNumero, (long)item_.getLatches_latchXminus_closeSensorsLatchXminus_closeSensorBLatchXminus_byteNumero());
        Assert.assertEquals((Object)latches_latchXminus_closeSensorsLatchXminus_closeSensorBLatchXminus_dioName, (Object)item_.getLatches_latchXminus_closeSensorsLatchXminus_closeSensorBLatchXminus_dioName());
        Assert.assertEquals((long)latches_latchXminus_closeSensorsLatchXminus_closeSensorBLatchXminus_inputNumero, (long)item_.getLatches_latchXminus_closeSensorsLatchXminus_closeSensorBLatchXminus_inputNumero());
        Assert.assertEquals((long)latches_latchXminus_closeSensorsLatchXminus_closeSensorLatchXminus_byteNumero, (long)item_.getLatches_latchXminus_closeSensorsLatchXminus_closeSensorLatchXminus_byteNumero());
        Assert.assertEquals((Object)latches_latchXminus_closeSensorsLatchXminus_closeSensorLatchXminus_dioName, (Object)item_.getLatches_latchXminus_closeSensorsLatchXminus_closeSensorLatchXminus_dioName());
        Assert.assertEquals((long)latches_latchXminus_closeSensorsLatchXminus_closeSensorLatchXminus_inputNumero, (long)item_.getLatches_latchXminus_closeSensorsLatchXminus_closeSensorLatchXminus_inputNumero());
        Assert.assertEquals((long)latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorBLatchXminus_byteNumero, (long)item_.getLatches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorBLatchXminus_byteNumero());
        Assert.assertEquals((Object)latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorBLatchXminus_dioName, (Object)item_.getLatches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorBLatchXminus_dioName());
        Assert.assertEquals((long)latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorBLatchXminus_inputNumero, (long)item_.getLatches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorBLatchXminus_inputNumero());
        Assert.assertEquals((long)latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorLatchXminus_byteNumero, (long)item_.getLatches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorLatchXminus_byteNumero());
        Assert.assertEquals((Object)latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorLatchXminus_dioName, (Object)item_.getLatches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorLatchXminus_dioName());
        Assert.assertEquals((long)latches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorLatchXminus_inputNumero, (long)item_.getLatches_latchXminus_filterEngagedSensorsLatchXminus_filterEngagedSensorLatchXminus_inputNumero());
        Assert.assertEquals((long)latches_latchXminus_openSensorsLatchXminus_openSensorBLatchXminus_byteNumero, (long)item_.getLatches_latchXminus_openSensorsLatchXminus_openSensorBLatchXminus_byteNumero());
        Assert.assertEquals((Object)latches_latchXminus_openSensorsLatchXminus_openSensorBLatchXminus_dioName, (Object)item_.getLatches_latchXminus_openSensorsLatchXminus_openSensorBLatchXminus_dioName());
        Assert.assertEquals((long)latches_latchXminus_openSensorsLatchXminus_openSensorBLatchXminus_inputNumero, (long)item_.getLatches_latchXminus_openSensorsLatchXminus_openSensorBLatchXminus_inputNumero());
        Assert.assertEquals((long)latches_latchXminus_openSensorsLatchXminus_openSensorLatchXminus_byteNumero, (long)item_.getLatches_latchXminus_openSensorsLatchXminus_openSensorLatchXminus_byteNumero());
        Assert.assertEquals((Object)latches_latchXminus_openSensorsLatchXminus_openSensorLatchXminus_dioName, (Object)item_.getLatches_latchXminus_openSensorsLatchXminus_openSensorLatchXminus_dioName());
        Assert.assertEquals((long)latches_latchXminus_openSensorsLatchXminus_openSensorLatchXminus_inputNumero, (long)item_.getLatches_latchXminus_openSensorsLatchXminus_openSensorLatchXminus_inputNumero());
        Assert.assertEquals((long)latches_latchXplus_closeSensorsLatchXplus_closeSensorBLatchXplus_byteNumero, (long)item_.getLatches_latchXplus_closeSensorsLatchXplus_closeSensorBLatchXplus_byteNumero());
        Assert.assertEquals((Object)latches_latchXplus_closeSensorsLatchXplus_closeSensorBLatchXplus_dioName, (Object)item_.getLatches_latchXplus_closeSensorsLatchXplus_closeSensorBLatchXplus_dioName());
        Assert.assertEquals((long)latches_latchXplus_closeSensorsLatchXplus_closeSensorBLatchXplus_inputNumero, (long)item_.getLatches_latchXplus_closeSensorsLatchXplus_closeSensorBLatchXplus_inputNumero());
        Assert.assertEquals((long)latches_latchXplus_closeSensorsLatchXplus_closeSensorLatchXplus_byteNumero, (long)item_.getLatches_latchXplus_closeSensorsLatchXplus_closeSensorLatchXplus_byteNumero());
        Assert.assertEquals((Object)latches_latchXplus_closeSensorsLatchXplus_closeSensorLatchXplus_dioName, (Object)item_.getLatches_latchXplus_closeSensorsLatchXplus_closeSensorLatchXplus_dioName());
        Assert.assertEquals((long)latches_latchXplus_closeSensorsLatchXplus_closeSensorLatchXplus_inputNumero, (long)item_.getLatches_latchXplus_closeSensorsLatchXplus_closeSensorLatchXplus_inputNumero());
        Assert.assertEquals((long)latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorBLatchXplus_byteNumero, (long)item_.getLatches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorBLatchXplus_byteNumero());
        Assert.assertEquals((Object)latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorBLatchXplus_dioName, (Object)item_.getLatches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorBLatchXplus_dioName());
        Assert.assertEquals((long)latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorBLatchXplus_inputNumero, (long)item_.getLatches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorBLatchXplus_inputNumero());
        Assert.assertEquals((long)latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorLatchXplus_byteNumero, (long)item_.getLatches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorLatchXplus_byteNumero());
        Assert.assertEquals((Object)latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorLatchXplus_dioName, (Object)item_.getLatches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorLatchXplus_dioName());
        Assert.assertEquals((long)latches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorLatchXplus_inputNumero, (long)item_.getLatches_latchXplus_filterEngagedSensorsLatchXplus_filterEngagedSensorLatchXplus_inputNumero());
        Assert.assertEquals((long)latches_latchXplus_openSensorsLatchXplus_openSensorBLatchXplus_byteNumero, (long)item_.getLatches_latchXplus_openSensorsLatchXplus_openSensorBLatchXplus_byteNumero());
        Assert.assertEquals((Object)latches_latchXplus_openSensorsLatchXplus_openSensorBLatchXplus_dioName, (Object)item_.getLatches_latchXplus_openSensorsLatchXplus_openSensorBLatchXplus_dioName());
        Assert.assertEquals((long)latches_latchXplus_openSensorsLatchXplus_openSensorBLatchXplus_inputNumero, (long)item_.getLatches_latchXplus_openSensorsLatchXplus_openSensorBLatchXplus_inputNumero());
        Assert.assertEquals((long)latches_latchXplus_openSensorsLatchXplus_openSensorLatchXplus_byteNumero, (long)item_.getLatches_latchXplus_openSensorsLatchXplus_openSensorLatchXplus_byteNumero());
        Assert.assertEquals((Object)latches_latchXplus_openSensorsLatchXplus_openSensorLatchXplus_dioName, (Object)item_.getLatches_latchXplus_openSensorsLatchXplus_openSensorLatchXplus_dioName());
        Assert.assertEquals((long)latches_latchXplus_openSensorsLatchXplus_openSensorLatchXplus_inputNumero, (long)item_.getLatches_latchXplus_openSensorsLatchXplus_openSensorLatchXplus_inputNumero());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensorC_byteNumero, (long)item_.getOnlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensorC_byteNumero());
        Assert.assertEquals((Object)onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensorC_dioName, (Object)item_.getOnlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensorC_dioName());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensorC_inputNumero, (long)item_.getOnlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensorC_inputNumero());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensor_byteNumero, (long)item_.getOnlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensor_byteNumero());
        Assert.assertEquals((Object)onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensor_dioName, (Object)item_.getOnlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensor_dioName());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensor_inputNumero, (long)item_.getOnlineclamps_onlineClampXminus_onlineClampXminusCloseSensors_onlineClampXminusCloseSensor_inputNumero());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensorC_byteNumero, (long)item_.getOnlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensorC_byteNumero());
        Assert.assertEquals((Object)onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensorC_dioName, (Object)item_.getOnlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensorC_dioName());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensorC_inputNumero, (long)item_.getOnlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensorC_inputNumero());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensor_byteNumero, (long)item_.getOnlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensor_byteNumero());
        Assert.assertEquals((Object)onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensor_dioName, (Object)item_.getOnlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensor_dioName());
        Assert.assertEquals((long)onlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensor_inputNumero, (long)item_.getOnlineclamps_onlineClampXminus_onlineClampXminusOpenSensors_onlineClampXminusOpenSensor_inputNumero());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensorC_byteNumero, (long)item_.getOnlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensorC_byteNumero());
        Assert.assertEquals((Object)onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensorC_dioName, (Object)item_.getOnlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensorC_dioName());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensorC_inputNumero, (long)item_.getOnlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensorC_inputNumero());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensor_byteNumero, (long)item_.getOnlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensor_byteNumero());
        Assert.assertEquals((Object)onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensor_dioName, (Object)item_.getOnlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensor_dioName());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensor_inputNumero, (long)item_.getOnlineclamps_onlineClampXplus_onlineClampXplusCloseSensors_onlineClampXplusCloseSensor_inputNumero());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensorC_byteNumero, (long)item_.getOnlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensorC_byteNumero());
        Assert.assertEquals((Object)onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensorC_dioName, (Object)item_.getOnlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensorC_dioName());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensorC_inputNumero, (long)item_.getOnlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensorC_inputNumero());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensor_byteNumero, (long)item_.getOnlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensor_byteNumero());
        Assert.assertEquals((Object)onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensor_dioName, (Object)item_.getOnlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensor_dioName());
        Assert.assertEquals((long)onlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensor_inputNumero, (long)item_.getOnlineclamps_onlineClampXplus_onlineClampXplusOpenSensors_onlineClampXplusOpenSensor_inputNumero());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensorC_byteNumero, (long)item_.getOnlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensorC_byteNumero());
        Assert.assertEquals((Object)onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensorC_dioName, (Object)item_.getOnlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensorC_dioName());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensorC_inputNumero, (long)item_.getOnlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensorC_inputNumero());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensor_byteNumero, (long)item_.getOnlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensor_byteNumero());
        Assert.assertEquals((Object)onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensor_dioName, (Object)item_.getOnlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensor_dioName());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensor_inputNumero, (long)item_.getOnlineclamps_onlineClampYminus_onlineClampYminusCloseSensors_onlineClampYminusCloseSensor_inputNumero());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensorC_byteNumero, (long)item_.getOnlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensorC_byteNumero());
        Assert.assertEquals((Object)onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensorC_dioName, (Object)item_.getOnlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensorC_dioName());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensorC_inputNumero, (long)item_.getOnlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensorC_inputNumero());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensor_byteNumero, (long)item_.getOnlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensor_byteNumero());
        Assert.assertEquals((Object)onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensor_dioName, (Object)item_.getOnlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensor_dioName());
        Assert.assertEquals((long)onlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensor_inputNumero, (long)item_.getOnlineclamps_onlineClampYminus_onlineClampYminusOpenSensors_onlineClampYminusOpenSensor_inputNumero());
        Assert.assertEquals((long)plc_OUT_AF0_Sensors_OUT_AF0_C_byteNumero, (long)item_.getPlc_OUT_AF0_Sensors_OUT_AF0_C_byteNumero());
        Assert.assertEquals((Object)plc_OUT_AF0_Sensors_OUT_AF0_C_dioName, (Object)item_.getPlc_OUT_AF0_Sensors_OUT_AF0_C_dioName());
        Assert.assertEquals((long)plc_OUT_AF0_Sensors_OUT_AF0_C_inputNumero, (long)item_.getPlc_OUT_AF0_Sensors_OUT_AF0_C_inputNumero());
        Assert.assertEquals((long)plc_OUT_AF0_Sensors_OUT_AF0_byteNumero, (long)item_.getPlc_OUT_AF0_Sensors_OUT_AF0_byteNumero());
        Assert.assertEquals((Object)plc_OUT_AF0_Sensors_OUT_AF0_dioName, (Object)item_.getPlc_OUT_AF0_Sensors_OUT_AF0_dioName());
        Assert.assertEquals((long)plc_OUT_AF0_Sensors_OUT_AF0_inputNumero, (long)item_.getPlc_OUT_AF0_Sensors_OUT_AF0_inputNumero());
        Assert.assertEquals((long)plc_OUT_AF1_Sensors_OUT_AF1_C_byteNumero, (long)item_.getPlc_OUT_AF1_Sensors_OUT_AF1_C_byteNumero());
        Assert.assertEquals((Object)plc_OUT_AF1_Sensors_OUT_AF1_C_dioName, (Object)item_.getPlc_OUT_AF1_Sensors_OUT_AF1_C_dioName());
        Assert.assertEquals((long)plc_OUT_AF1_Sensors_OUT_AF1_C_inputNumero, (long)item_.getPlc_OUT_AF1_Sensors_OUT_AF1_C_inputNumero());
        Assert.assertEquals((long)plc_OUT_AF1_Sensors_OUT_AF1_byteNumero, (long)item_.getPlc_OUT_AF1_Sensors_OUT_AF1_byteNumero());
        Assert.assertEquals((Object)plc_OUT_AF1_Sensors_OUT_AF1_dioName, (Object)item_.getPlc_OUT_AF1_Sensors_OUT_AF1_dioName());
        Assert.assertEquals((long)plc_OUT_AF1_Sensors_OUT_AF1_inputNumero, (long)item_.getPlc_OUT_AF1_Sensors_OUT_AF1_inputNumero());
        Assert.assertEquals((long)plc_OUT_AF3_Sensors_OUT_AF3_C_byteNumero, (long)item_.getPlc_OUT_AF3_Sensors_OUT_AF3_C_byteNumero());
        Assert.assertEquals((Object)plc_OUT_AF3_Sensors_OUT_AF3_C_dioName, (Object)item_.getPlc_OUT_AF3_Sensors_OUT_AF3_C_dioName());
        Assert.assertEquals((long)plc_OUT_AF3_Sensors_OUT_AF3_C_inputNumero, (long)item_.getPlc_OUT_AF3_Sensors_OUT_AF3_C_inputNumero());
        Assert.assertEquals((long)plc_OUT_AF3_Sensors_OUT_AF3_byteNumero, (long)item_.getPlc_OUT_AF3_Sensors_OUT_AF3_byteNumero());
        Assert.assertEquals((Object)plc_OUT_AF3_Sensors_OUT_AF3_dioName, (Object)item_.getPlc_OUT_AF3_Sensors_OUT_AF3_dioName());
        Assert.assertEquals((long)plc_OUT_AF3_Sensors_OUT_AF3_inputNumero, (long)item_.getPlc_OUT_AF3_Sensors_OUT_AF3_inputNumero());
        Assert.assertEquals((long)plc_OUT_AIN_byteNumero, (long)item_.getPlc_OUT_AIN_byteNumero());
        Assert.assertEquals((Object)plc_OUT_AIN_dioName, (Object)item_.getPlc_OUT_AIN_dioName());
        Assert.assertEquals((long)plc_OUT_AIN_inputNumero, (long)item_.getPlc_OUT_AIN_inputNumero());
        Assert.assertEquals((long)plc_OUT_AOL_byteNumero, (long)item_.getPlc_OUT_AOL_byteNumero());
        Assert.assertEquals((Object)plc_OUT_AOL_dioName, (Object)item_.getPlc_OUT_AOL_dioName());
        Assert.assertEquals((long)plc_OUT_AOL_inputNumero, (long)item_.getPlc_OUT_AOL_inputNumero());
        Assert.assertEquals((long)plc_OUT_AP1_Sensors_OUT_AP1_C_byteNumero, (long)item_.getPlc_OUT_AP1_Sensors_OUT_AP1_C_byteNumero());
        Assert.assertEquals((Object)plc_OUT_AP1_Sensors_OUT_AP1_C_dioName, (Object)item_.getPlc_OUT_AP1_Sensors_OUT_AP1_C_dioName());
        Assert.assertEquals((long)plc_OUT_AP1_Sensors_OUT_AP1_C_inputNumero, (long)item_.getPlc_OUT_AP1_Sensors_OUT_AP1_C_inputNumero());
        Assert.assertEquals((long)plc_OUT_AP1_Sensors_OUT_AP1_byteNumero, (long)item_.getPlc_OUT_AP1_Sensors_OUT_AP1_byteNumero());
        Assert.assertEquals((Object)plc_OUT_AP1_Sensors_OUT_AP1_dioName, (Object)item_.getPlc_OUT_AP1_Sensors_OUT_AP1_dioName());
        Assert.assertEquals((long)plc_OUT_AP1_Sensors_OUT_AP1_inputNumero, (long)item_.getPlc_OUT_AP1_Sensors_OUT_AP1_inputNumero());
        Assert.assertEquals((long)plc_OUT_AP2_Sensors_OUT_AP2_C_byteNumero, (long)item_.getPlc_OUT_AP2_Sensors_OUT_AP2_C_byteNumero());
        Assert.assertEquals((Object)plc_OUT_AP2_Sensors_OUT_AP2_C_dioName, (Object)item_.getPlc_OUT_AP2_Sensors_OUT_AP2_C_dioName());
        Assert.assertEquals((long)plc_OUT_AP2_Sensors_OUT_AP2_C_inputNumero, (long)item_.getPlc_OUT_AP2_Sensors_OUT_AP2_C_inputNumero());
        Assert.assertEquals((long)plc_OUT_AP2_Sensors_OUT_AP2_byteNumero, (long)item_.getPlc_OUT_AP2_Sensors_OUT_AP2_byteNumero());
        Assert.assertEquals((Object)plc_OUT_AP2_Sensors_OUT_AP2_dioName, (Object)item_.getPlc_OUT_AP2_Sensors_OUT_AP2_dioName());
        Assert.assertEquals((long)plc_OUT_AP2_Sensors_OUT_AP2_inputNumero, (long)item_.getPlc_OUT_AP2_Sensors_OUT_AP2_inputNumero());
        Assert.assertEquals((long)plc_OUT_AP3_Sensors_OUT_AP3_C_byteNumero, (long)item_.getPlc_OUT_AP3_Sensors_OUT_AP3_C_byteNumero());
        Assert.assertEquals((Object)plc_OUT_AP3_Sensors_OUT_AP3_C_dioName, (Object)item_.getPlc_OUT_AP3_Sensors_OUT_AP3_C_dioName());
        Assert.assertEquals((long)plc_OUT_AP3_Sensors_OUT_AP3_C_inputNumero, (long)item_.getPlc_OUT_AP3_Sensors_OUT_AP3_C_inputNumero());
        Assert.assertEquals((long)plc_OUT_AP3_Sensors_OUT_AP3_byteNumero, (long)item_.getPlc_OUT_AP3_Sensors_OUT_AP3_byteNumero());
        Assert.assertEquals((Object)plc_OUT_AP3_Sensors_OUT_AP3_dioName, (Object)item_.getPlc_OUT_AP3_Sensors_OUT_AP3_dioName());
        Assert.assertEquals((long)plc_OUT_AP3_Sensors_OUT_AP3_inputNumero, (long)item_.getPlc_OUT_AP3_Sensors_OUT_AP3_inputNumero());
        Assert.assertEquals((long)plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor0_byteNumero, (long)item_.getPlc_carouselHoldingFilterSensors_carouselHoldingFilterSensor0_byteNumero());
        Assert.assertEquals((Object)plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor0_dioName, (Object)item_.getPlc_carouselHoldingFilterSensors_carouselHoldingFilterSensor0_dioName());
        Assert.assertEquals((long)plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor0_inputNumero, (long)item_.getPlc_carouselHoldingFilterSensors_carouselHoldingFilterSensor0_inputNumero());
        Assert.assertEquals((long)plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor1_byteNumero, (long)item_.getPlc_carouselHoldingFilterSensors_carouselHoldingFilterSensor1_byteNumero());
        Assert.assertEquals((Object)plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor1_dioName, (Object)item_.getPlc_carouselHoldingFilterSensors_carouselHoldingFilterSensor1_dioName());
        Assert.assertEquals((long)plc_carouselHoldingFilterSensors_carouselHoldingFilterSensor1_inputNumero, (long)item_.getPlc_carouselHoldingFilterSensors_carouselHoldingFilterSensor1_inputNumero());
        Assert.assertEquals((long)plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandbyC_byteNumero, (long)item_.getPlc_carouselStoppedAtStandbySensors_carouselStoppedAtStandbyC_byteNumero());
        Assert.assertEquals((Object)plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandbyC_dioName, (Object)item_.getPlc_carouselStoppedAtStandbySensors_carouselStoppedAtStandbyC_dioName());
        Assert.assertEquals((long)plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandbyC_inputNumero, (long)item_.getPlc_carouselStoppedAtStandbySensors_carouselStoppedAtStandbyC_inputNumero());
        Assert.assertEquals((long)plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandby_byteNumero, (long)item_.getPlc_carouselStoppedAtStandbySensors_carouselStoppedAtStandby_byteNumero());
        Assert.assertEquals((Object)plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandby_dioName, (Object)item_.getPlc_carouselStoppedAtStandbySensors_carouselStoppedAtStandby_dioName());
        Assert.assertEquals((long)plc_carouselStoppedAtStandbySensors_carouselStoppedAtStandby_inputNumero, (long)item_.getPlc_carouselStoppedAtStandbySensors_carouselStoppedAtStandby_inputNumero());
        Assert.assertEquals((long)plc_carousel_CF0Sensors_carousel_CF0_C_byteNumero, (long)item_.getPlc_carousel_CF0Sensors_carousel_CF0_C_byteNumero());
        Assert.assertEquals((Object)plc_carousel_CF0Sensors_carousel_CF0_C_dioName, (Object)item_.getPlc_carousel_CF0Sensors_carousel_CF0_C_dioName());
        Assert.assertEquals((long)plc_carousel_CF0Sensors_carousel_CF0_C_inputNumero, (long)item_.getPlc_carousel_CF0Sensors_carousel_CF0_C_inputNumero());
        Assert.assertEquals((long)plc_carousel_CF0Sensors_carousel_CF0_byteNumero, (long)item_.getPlc_carousel_CF0Sensors_carousel_CF0_byteNumero());
        Assert.assertEquals((Object)plc_carousel_CF0Sensors_carousel_CF0_dioName, (Object)item_.getPlc_carousel_CF0Sensors_carousel_CF0_dioName());
        Assert.assertEquals((long)plc_carousel_CF0Sensors_carousel_CF0_inputNumero, (long)item_.getPlc_carousel_CF0Sensors_carousel_CF0_inputNumero());
        Assert.assertEquals((long)plc_carousel_CF1Sensors_carousel_CF1_C_byteNumero, (long)item_.getPlc_carousel_CF1Sensors_carousel_CF1_C_byteNumero());
        Assert.assertEquals((Object)plc_carousel_CF1Sensors_carousel_CF1_C_dioName, (Object)item_.getPlc_carousel_CF1Sensors_carousel_CF1_C_dioName());
        Assert.assertEquals((long)plc_carousel_CF1Sensors_carousel_CF1_C_inputNumero, (long)item_.getPlc_carousel_CF1Sensors_carousel_CF1_C_inputNumero());
        Assert.assertEquals((long)plc_carousel_CF1Sensors_carousel_CF1_byteNumero, (long)item_.getPlc_carousel_CF1Sensors_carousel_CF1_byteNumero());
        Assert.assertEquals((Object)plc_carousel_CF1Sensors_carousel_CF1_dioName, (Object)item_.getPlc_carousel_CF1Sensors_carousel_CF1_dioName());
        Assert.assertEquals((long)plc_carousel_CF1Sensors_carousel_CF1_inputNumero, (long)item_.getPlc_carousel_CF1Sensors_carousel_CF1_inputNumero());
        Assert.assertEquals((long)plc_inclinometerXminus_byteNumero, (long)item_.getPlc_inclinometerXminus_byteNumero());
        Assert.assertEquals((Object)plc_inclinometerXminus_deviceName, (Object)item_.getPlc_inclinometerXminus_deviceName());
        Assert.assertEquals((long)plc_inclinometerXplus_byteNumero, (long)item_.getPlc_inclinometerXplus_byteNumero());
        Assert.assertEquals((Object)plc_inclinometerXplus_deviceName, (Object)item_.getPlc_inclinometerXplus_deviceName());
        Assert.assertEquals((long)plc_loaderConnectedSensors_loaderConnectedSensorC_byteNumero, (long)item_.getPlc_loaderConnectedSensors_loaderConnectedSensorC_byteNumero());
        Assert.assertEquals((Object)plc_loaderConnectedSensors_loaderConnectedSensorC_dioName, (Object)item_.getPlc_loaderConnectedSensors_loaderConnectedSensorC_dioName());
        Assert.assertEquals((long)plc_loaderConnectedSensors_loaderConnectedSensorC_inputNumero, (long)item_.getPlc_loaderConnectedSensors_loaderConnectedSensorC_inputNumero());
        Assert.assertEquals((long)plc_loaderConnectedSensors_loaderConnectedSensor_byteNumero, (long)item_.getPlc_loaderConnectedSensors_loaderConnectedSensor_byteNumero());
        Assert.assertEquals((Object)plc_loaderConnectedSensors_loaderConnectedSensor_dioName, (Object)item_.getPlc_loaderConnectedSensors_loaderConnectedSensor_dioName());
        Assert.assertEquals((long)plc_loaderConnectedSensors_loaderConnectedSensor_inputNumero, (long)item_.getPlc_loaderConnectedSensors_loaderConnectedSensor_inputNumero());
        Assert.assertEquals((long)plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor0_byteNumero, (long)item_.getPlc_loaderHoldingFilterSensors_loaderHoldingFilterSensor0_byteNumero());
        Assert.assertEquals((Object)plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor0_dioName, (Object)item_.getPlc_loaderHoldingFilterSensors_loaderHoldingFilterSensor0_dioName());
        Assert.assertEquals((long)plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor0_inputNumero, (long)item_.getPlc_loaderHoldingFilterSensors_loaderHoldingFilterSensor0_inputNumero());
        Assert.assertEquals((long)plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor1_byteNumero, (long)item_.getPlc_loaderHoldingFilterSensors_loaderHoldingFilterSensor1_byteNumero());
        Assert.assertEquals((Object)plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor1_dioName, (Object)item_.getPlc_loaderHoldingFilterSensors_loaderHoldingFilterSensor1_dioName());
        Assert.assertEquals((long)plc_loaderHoldingFilterSensors_loaderHoldingFilterSensor1_inputNumero, (long)item_.getPlc_loaderHoldingFilterSensors_loaderHoldingFilterSensor1_inputNumero());
        Assert.assertEquals((long)plc_loaderPresenceSensors_presenceLoader_C_byteNumero, (long)item_.getPlc_loaderPresenceSensors_presenceLoader_C_byteNumero());
        Assert.assertEquals((Object)plc_loaderPresenceSensors_presenceLoader_C_dioName, (Object)item_.getPlc_loaderPresenceSensors_presenceLoader_C_dioName());
        Assert.assertEquals((long)plc_loaderPresenceSensors_presenceLoader_C_inputNumero, (long)item_.getPlc_loaderPresenceSensors_presenceLoader_C_inputNumero());
        Assert.assertEquals((long)plc_loaderPresenceSensors_presenceLoader_byteNumero, (long)item_.getPlc_loaderPresenceSensors_presenceLoader_byteNumero());
        Assert.assertEquals((Object)plc_loaderPresenceSensors_presenceLoader_dioName, (Object)item_.getPlc_loaderPresenceSensors_presenceLoader_dioName());
        Assert.assertEquals((long)plc_loaderPresenceSensors_presenceLoader_inputNumero, (long)item_.getPlc_loaderPresenceSensors_presenceLoader_inputNumero());
        Assert.assertEquals((long)plc_lockOutSensors_lockOut_C_byteNumero, (long)item_.getPlc_lockOutSensors_lockOut_C_byteNumero());
        Assert.assertEquals((Object)plc_lockOutSensors_lockOut_C_dioName, (Object)item_.getPlc_lockOutSensors_lockOut_C_dioName());
        Assert.assertEquals((long)plc_lockOutSensors_lockOut_C_inputNumero, (long)item_.getPlc_lockOutSensors_lockOut_C_inputNumero());
        Assert.assertEquals((long)plc_lockOutSensors_lockOut_byteNumero, (long)item_.getPlc_lockOutSensors_lockOut_byteNumero());
        Assert.assertEquals((Object)plc_lockOutSensors_lockOut_dioName, (Object)item_.getPlc_lockOutSensors_lockOut_dioName());
        Assert.assertEquals((long)plc_lockOutSensors_lockOut_inputNumero, (long)item_.getPlc_lockOutSensors_lockOut_inputNumero());
        Assert.assertEquals((long)plc_lockOutShunt_byteNumero, (long)item_.getPlc_lockOutShunt_byteNumero());
        Assert.assertEquals((Object)plc_lockOutShunt_dioName, (Object)item_.getPlc_lockOutShunt_dioName());
        Assert.assertEquals((long)plc_lockOutShunt_inputNumero, (long)item_.getPlc_lockOutShunt_inputNumero());
        Assert.assertEquals((long)plc_lpmEngineeringKeySensors_engineeringKey_C_byteNumero, (long)item_.getPlc_lpmEngineeringKeySensors_engineeringKey_C_byteNumero());
        Assert.assertEquals((Object)plc_lpmEngineeringKeySensors_engineeringKey_C_dioName, (Object)item_.getPlc_lpmEngineeringKeySensors_engineeringKey_C_dioName());
        Assert.assertEquals((long)plc_lpmEngineeringKeySensors_engineeringKey_C_inputNumero, (long)item_.getPlc_lpmEngineeringKeySensors_engineeringKey_C_inputNumero());
        Assert.assertEquals((long)plc_lpmEngineeringKeySensors_engineeringKey_byteNumero, (long)item_.getPlc_lpmEngineeringKeySensors_engineeringKey_byteNumero());
        Assert.assertEquals((Object)plc_lpmEngineeringKeySensors_engineeringKey_dioName, (Object)item_.getPlc_lpmEngineeringKeySensors_engineeringKey_dioName());
        Assert.assertEquals((long)plc_lpmEngineeringKeySensors_engineeringKey_inputNumero, (long)item_.getPlc_lpmEngineeringKeySensors_engineeringKey_inputNumero());
        Assert.assertEquals((long)plc_lpmLatchesStatus_byteNumero, (long)item_.getPlc_lpmLatchesStatus_byteNumero());
        Assert.assertEquals((Object)plc_lpmLatchesStatus_dioName, (Object)item_.getPlc_lpmLatchesStatus_dioName());
        Assert.assertEquals((long)plc_lpmLatchesStatus_inputNumero, (long)item_.getPlc_lpmLatchesStatus_inputNumero());
        Assert.assertEquals((long)plc_lpmLinearRail1Status_byteNumero, (long)item_.getPlc_lpmLinearRail1Status_byteNumero());
        Assert.assertEquals((Object)plc_lpmLinearRail1Status_dioName, (Object)item_.getPlc_lpmLinearRail1Status_dioName());
        Assert.assertEquals((long)plc_lpmLinearRail1Status_inputNumero, (long)item_.getPlc_lpmLinearRail1Status_inputNumero());
        Assert.assertEquals((long)plc_lpmLinearRail2Status_byteNumero, (long)item_.getPlc_lpmLinearRail2Status_byteNumero());
        Assert.assertEquals((Object)plc_lpmLinearRail2Status_dioName, (Object)item_.getPlc_lpmLinearRail2Status_dioName());
        Assert.assertEquals((long)plc_lpmLinearRail2Status_inputNumero, (long)item_.getPlc_lpmLinearRail2Status_inputNumero());
        Assert.assertEquals((long)plc_lpmOnlineClampsStatus_byteNumero, (long)item_.getPlc_lpmOnlineClampsStatus_byteNumero());
        Assert.assertEquals((Object)plc_lpmOnlineClampsStatus_dioName, (Object)item_.getPlc_lpmOnlineClampsStatus_dioName());
        Assert.assertEquals((long)plc_lpmOnlineClampsStatus_inputNumero, (long)item_.getPlc_lpmOnlineClampsStatus_inputNumero());
    }

    @Test
    public void sendReceiveFcs_Canbus0_canbusConfigurationEvent() throws Exception {
        String version = "c";
        String baud = "h";
        String busName = "";
        long hardwareBootTimeout = 928L;
        int masterNodeID = 320;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Canbus0_canbusConfigurationEvent(version, baud, busName, hardwareBootTimeout, masterNodeID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_canbusConfigurationEvent));
        Fcs_Canbus0_canbusConfigurationEvent item_ = (Fcs_Canbus0_canbusConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)baud, (Object)item_.getBaud());
        Assert.assertEquals((Object)busName, (Object)item_.getBusName());
        Assert.assertEquals((long)hardwareBootTimeout, (long)item_.getHardwareBootTimeout());
        Assert.assertEquals((long)masterNodeID, (long)item_.getMasterNodeID());
    }

    @Test
    public void sendReceiveFcs_Canbus0_controllerConfigurationEvent() throws Exception {
        String version = "";
        int actruckxminuscontroller_encoderRibbonMinValue = 78;
        String actruckxminuscontroller_paramsForCurrent = "";
        String actruckxminuscontroller_paramsForHoming = "";
        String actruckxminuscontroller_paramsForProfilePosition = "";
        int actruckxpluscontroller_encoderRibbonMinValue = 923;
        String actruckxpluscontroller_paramsForCurrent = "b";
        String actruckxpluscontroller_paramsForHoming = "";
        String actruckxpluscontroller_paramsForProfilePosition = "e";
        String carouselcontroller_paramsForCurrent = "r";
        String carouselcontroller_paramsForHoming = "";
        String carouselcontroller_paramsForProfilePosition = "w";
        String clampxminuscontroller_paramsForCurrent = "e";
        String clampxminuscontroller_paramsForHoming = "l";
        String clampxminuscontroller_paramsForProfilePosition = "";
        String clampxpluscontroller_paramsForCurrent = "";
        String clampxpluscontroller_paramsForHoming = "w";
        String clampxpluscontroller_paramsForProfilePosition = "";
        String latchxminuscontroller_latchName = "u";
        String latchxminuscontroller_paramsForCurrent = "";
        String latchxminuscontroller_paramsForHoming = "a";
        String latchxminuscontroller_paramsForProfilePosition = "";
        String latchxpluscontroller_latchName = "";
        String latchxpluscontroller_paramsForCurrent = "p";
        String latchxpluscontroller_paramsForHoming = "";
        String latchxpluscontroller_paramsForProfilePosition = "";
        String onlineclampxminuscontroller_onlineClampName = "h";
        String onlineclampxminuscontroller_paramsForCurrent = "";
        String onlineclampxminuscontroller_paramsForHoming = "h";
        String onlineclampxminuscontroller_paramsForProfilePosition = "o";
        String onlineclampxpluscontroller_onlineClampName = "v";
        String onlineclampxpluscontroller_paramsForCurrent = "";
        String onlineclampxpluscontroller_paramsForHoming = "";
        String onlineclampxpluscontroller_paramsForProfilePosition = "d";
        String onlineclampyminuscontroller_onlineClampName = "c";
        String onlineclampyminuscontroller_paramsForCurrent = "q";
        String onlineclampyminuscontroller_paramsForHoming = "v";
        String onlineclampyminuscontroller_paramsForProfilePosition = "";
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Canbus0_controllerConfigurationEvent(version, actruckxminuscontroller_encoderRibbonMinValue, actruckxminuscontroller_paramsForCurrent, actruckxminuscontroller_paramsForHoming, actruckxminuscontroller_paramsForProfilePosition, actruckxpluscontroller_encoderRibbonMinValue, actruckxpluscontroller_paramsForCurrent, actruckxpluscontroller_paramsForHoming, actruckxpluscontroller_paramsForProfilePosition, carouselcontroller_paramsForCurrent, carouselcontroller_paramsForHoming, carouselcontroller_paramsForProfilePosition, clampxminuscontroller_paramsForCurrent, clampxminuscontroller_paramsForHoming, clampxminuscontroller_paramsForProfilePosition, clampxpluscontroller_paramsForCurrent, clampxpluscontroller_paramsForHoming, clampxpluscontroller_paramsForProfilePosition, latchxminuscontroller_latchName, latchxminuscontroller_paramsForCurrent, latchxminuscontroller_paramsForHoming, latchxminuscontroller_paramsForProfilePosition, latchxpluscontroller_latchName, latchxpluscontroller_paramsForCurrent, latchxpluscontroller_paramsForHoming, latchxpluscontroller_paramsForProfilePosition, onlineclampxminuscontroller_onlineClampName, onlineclampxminuscontroller_paramsForCurrent, onlineclampxminuscontroller_paramsForHoming, onlineclampxminuscontroller_paramsForProfilePosition, onlineclampxpluscontroller_onlineClampName, onlineclampxpluscontroller_paramsForCurrent, onlineclampxpluscontroller_paramsForHoming, onlineclampxpluscontroller_paramsForProfilePosition, onlineclampyminuscontroller_onlineClampName, onlineclampyminuscontroller_paramsForCurrent, onlineclampyminuscontroller_paramsForHoming, onlineclampyminuscontroller_paramsForProfilePosition));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_controllerConfigurationEvent));
        Fcs_Canbus0_controllerConfigurationEvent item_ = (Fcs_Canbus0_controllerConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)actruckxminuscontroller_encoderRibbonMinValue, (long)item_.getActruckxminuscontroller_encoderRibbonMinValue());
        Assert.assertEquals((Object)actruckxminuscontroller_paramsForCurrent, (Object)item_.getActruckxminuscontroller_paramsForCurrent());
        Assert.assertEquals((Object)actruckxminuscontroller_paramsForHoming, (Object)item_.getActruckxminuscontroller_paramsForHoming());
        Assert.assertEquals((Object)actruckxminuscontroller_paramsForProfilePosition, (Object)item_.getActruckxminuscontroller_paramsForProfilePosition());
        Assert.assertEquals((long)actruckxpluscontroller_encoderRibbonMinValue, (long)item_.getActruckxpluscontroller_encoderRibbonMinValue());
        Assert.assertEquals((Object)actruckxpluscontroller_paramsForCurrent, (Object)item_.getActruckxpluscontroller_paramsForCurrent());
        Assert.assertEquals((Object)actruckxpluscontroller_paramsForHoming, (Object)item_.getActruckxpluscontroller_paramsForHoming());
        Assert.assertEquals((Object)actruckxpluscontroller_paramsForProfilePosition, (Object)item_.getActruckxpluscontroller_paramsForProfilePosition());
        Assert.assertEquals((Object)carouselcontroller_paramsForCurrent, (Object)item_.getCarouselcontroller_paramsForCurrent());
        Assert.assertEquals((Object)carouselcontroller_paramsForHoming, (Object)item_.getCarouselcontroller_paramsForHoming());
        Assert.assertEquals((Object)carouselcontroller_paramsForProfilePosition, (Object)item_.getCarouselcontroller_paramsForProfilePosition());
        Assert.assertEquals((Object)clampxminuscontroller_paramsForCurrent, (Object)item_.getClampxminuscontroller_paramsForCurrent());
        Assert.assertEquals((Object)clampxminuscontroller_paramsForHoming, (Object)item_.getClampxminuscontroller_paramsForHoming());
        Assert.assertEquals((Object)clampxminuscontroller_paramsForProfilePosition, (Object)item_.getClampxminuscontroller_paramsForProfilePosition());
        Assert.assertEquals((Object)clampxpluscontroller_paramsForCurrent, (Object)item_.getClampxpluscontroller_paramsForCurrent());
        Assert.assertEquals((Object)clampxpluscontroller_paramsForHoming, (Object)item_.getClampxpluscontroller_paramsForHoming());
        Assert.assertEquals((Object)clampxpluscontroller_paramsForProfilePosition, (Object)item_.getClampxpluscontroller_paramsForProfilePosition());
        Assert.assertEquals((Object)latchxminuscontroller_latchName, (Object)item_.getLatchxminuscontroller_latchName());
        Assert.assertEquals((Object)latchxminuscontroller_paramsForCurrent, (Object)item_.getLatchxminuscontroller_paramsForCurrent());
        Assert.assertEquals((Object)latchxminuscontroller_paramsForHoming, (Object)item_.getLatchxminuscontroller_paramsForHoming());
        Assert.assertEquals((Object)latchxminuscontroller_paramsForProfilePosition, (Object)item_.getLatchxminuscontroller_paramsForProfilePosition());
        Assert.assertEquals((Object)latchxpluscontroller_latchName, (Object)item_.getLatchxpluscontroller_latchName());
        Assert.assertEquals((Object)latchxpluscontroller_paramsForCurrent, (Object)item_.getLatchxpluscontroller_paramsForCurrent());
        Assert.assertEquals((Object)latchxpluscontroller_paramsForHoming, (Object)item_.getLatchxpluscontroller_paramsForHoming());
        Assert.assertEquals((Object)latchxpluscontroller_paramsForProfilePosition, (Object)item_.getLatchxpluscontroller_paramsForProfilePosition());
        Assert.assertEquals((Object)onlineclampxminuscontroller_onlineClampName, (Object)item_.getOnlineclampxminuscontroller_onlineClampName());
        Assert.assertEquals((Object)onlineclampxminuscontroller_paramsForCurrent, (Object)item_.getOnlineclampxminuscontroller_paramsForCurrent());
        Assert.assertEquals((Object)onlineclampxminuscontroller_paramsForHoming, (Object)item_.getOnlineclampxminuscontroller_paramsForHoming());
        Assert.assertEquals((Object)onlineclampxminuscontroller_paramsForProfilePosition, (Object)item_.getOnlineclampxminuscontroller_paramsForProfilePosition());
        Assert.assertEquals((Object)onlineclampxpluscontroller_onlineClampName, (Object)item_.getOnlineclampxpluscontroller_onlineClampName());
        Assert.assertEquals((Object)onlineclampxpluscontroller_paramsForCurrent, (Object)item_.getOnlineclampxpluscontroller_paramsForCurrent());
        Assert.assertEquals((Object)onlineclampxpluscontroller_paramsForHoming, (Object)item_.getOnlineclampxpluscontroller_paramsForHoming());
        Assert.assertEquals((Object)onlineclampxpluscontroller_paramsForProfilePosition, (Object)item_.getOnlineclampxpluscontroller_paramsForProfilePosition());
        Assert.assertEquals((Object)onlineclampyminuscontroller_onlineClampName, (Object)item_.getOnlineclampyminuscontroller_onlineClampName());
        Assert.assertEquals((Object)onlineclampyminuscontroller_paramsForCurrent, (Object)item_.getOnlineclampyminuscontroller_paramsForCurrent());
        Assert.assertEquals((Object)onlineclampyminuscontroller_paramsForHoming, (Object)item_.getOnlineclampyminuscontroller_paramsForHoming());
        Assert.assertEquals((Object)onlineclampyminuscontroller_paramsForProfilePosition, (Object)item_.getOnlineclampyminuscontroller_paramsForProfilePosition());
    }

    @Test
    public void sendReceiveFcs_Canbus0_nodeIDConfigurationEvent() throws Exception {
        String version = "";
        int acsensorsgateway_nodeID = 530;
        int actruckxminuscontroller_nodeID = 975;
        int actruckxpluscontroller_nodeID = 80;
        int accelerobf_nodeID = 420;
        int ai814_nodeID = 548;
        int brakesystemgateway_nodeID = 130;
        int carouselcontroller_nodeID = 967;
        int clampxminuscontroller_nodeID = 934;
        int clampxpluscontroller_nodeID = 356;
        int hyttc580_nodeID = 694;
        int latchxminuscontroller_nodeID = 458;
        int latchxpluscontroller_nodeID = 343;
        int onlineclampxminuscontroller_nodeID = 390;
        int onlineclampxpluscontroller_nodeID = 501;
        int onlineclampyminuscontroller_nodeID = 198;
        int onlinestraingauge_nodeID = 737;
        int proximitysensorsdevice_nodeID = 249;
        int pt100_nodeID = 904;
        int tempsensorsdevice1_nodeID = 620;
        int tempsensorsdevice2_nodeID = 314;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Canbus0_nodeIDConfigurationEvent(version, acsensorsgateway_nodeID, actruckxminuscontroller_nodeID, actruckxpluscontroller_nodeID, accelerobf_nodeID, ai814_nodeID, brakesystemgateway_nodeID, carouselcontroller_nodeID, clampxminuscontroller_nodeID, clampxpluscontroller_nodeID, hyttc580_nodeID, latchxminuscontroller_nodeID, latchxpluscontroller_nodeID, onlineclampxminuscontroller_nodeID, onlineclampxpluscontroller_nodeID, onlineclampyminuscontroller_nodeID, onlinestraingauge_nodeID, proximitysensorsdevice_nodeID, pt100_nodeID, tempsensorsdevice1_nodeID, tempsensorsdevice2_nodeID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_nodeIDConfigurationEvent));
        Fcs_Canbus0_nodeIDConfigurationEvent item_ = (Fcs_Canbus0_nodeIDConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)acsensorsgateway_nodeID, (long)item_.getAcsensorsgateway_nodeID());
        Assert.assertEquals((long)actruckxminuscontroller_nodeID, (long)item_.getActruckxminuscontroller_nodeID());
        Assert.assertEquals((long)actruckxpluscontroller_nodeID, (long)item_.getActruckxpluscontroller_nodeID());
        Assert.assertEquals((long)accelerobf_nodeID, (long)item_.getAccelerobf_nodeID());
        Assert.assertEquals((long)ai814_nodeID, (long)item_.getAi814_nodeID());
        Assert.assertEquals((long)brakesystemgateway_nodeID, (long)item_.getBrakesystemgateway_nodeID());
        Assert.assertEquals((long)carouselcontroller_nodeID, (long)item_.getCarouselcontroller_nodeID());
        Assert.assertEquals((long)clampxminuscontroller_nodeID, (long)item_.getClampxminuscontroller_nodeID());
        Assert.assertEquals((long)clampxpluscontroller_nodeID, (long)item_.getClampxpluscontroller_nodeID());
        Assert.assertEquals((long)hyttc580_nodeID, (long)item_.getHyttc580_nodeID());
        Assert.assertEquals((long)latchxminuscontroller_nodeID, (long)item_.getLatchxminuscontroller_nodeID());
        Assert.assertEquals((long)latchxpluscontroller_nodeID, (long)item_.getLatchxpluscontroller_nodeID());
        Assert.assertEquals((long)onlineclampxminuscontroller_nodeID, (long)item_.getOnlineclampxminuscontroller_nodeID());
        Assert.assertEquals((long)onlineclampxpluscontroller_nodeID, (long)item_.getOnlineclampxpluscontroller_nodeID());
        Assert.assertEquals((long)onlineclampyminuscontroller_nodeID, (long)item_.getOnlineclampyminuscontroller_nodeID());
        Assert.assertEquals((long)onlinestraingauge_nodeID, (long)item_.getOnlinestraingauge_nodeID());
        Assert.assertEquals((long)proximitysensorsdevice_nodeID, (long)item_.getProximitysensorsdevice_nodeID());
        Assert.assertEquals((long)pt100_nodeID, (long)item_.getPt100_nodeID());
        Assert.assertEquals((long)tempsensorsdevice1_nodeID, (long)item_.getTempsensorsdevice1_nodeID());
        Assert.assertEquals((long)tempsensorsdevice2_nodeID, (long)item_.getTempsensorsdevice2_nodeID());
    }

    @Test
    public void sendReceiveFcs_Canbus0_sensorConfigurationEvent() throws Exception {
        String version = "c";
        int ai814_transmissionType = 283;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Canbus0_sensorConfigurationEvent(version, ai814_transmissionType));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_sensorConfigurationEvent));
        Fcs_Canbus0_sensorConfigurationEvent item_ = (Fcs_Canbus0_sensorConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)ai814_transmissionType, (long)item_.getAi814_transmissionType());
    }

    @Test
    public void sendReceiveFcs_Canbus0_serialNBConfigurationEvent() throws Exception {
        String version = "x";
        String acsensorsgateway_serialNB = "k";
        String actruckxminuscontroller_serialNB = "";
        String actruckxpluscontroller_serialNB = "d";
        String accelerobf_serialNB = "u";
        String ai814_serialNB = "p";
        String brakesystemgateway_serialNB = "";
        String carouselcontroller_serialNB = "x";
        String clampxminuscontroller_serialNB = "";
        String clampxpluscontroller_serialNB = "b";
        String hyttc580_serialNB = "";
        String latchxminuscontroller_serialNB = "n";
        String latchxpluscontroller_serialNB = "s";
        String onlineclampxminuscontroller_serialNB = "u";
        String onlineclampxpluscontroller_serialNB = "";
        String onlineclampyminuscontroller_serialNB = "s";
        String onlinestraingauge_serialNB = "z";
        String proximitysensorsdevice_serialNB = "";
        String pt100_serialNB = "m";
        String tempsensorsdevice1_serialNB = "l";
        String tempsensorsdevice2_serialNB = "k";
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Canbus0_serialNBConfigurationEvent(version, acsensorsgateway_serialNB, actruckxminuscontroller_serialNB, actruckxpluscontroller_serialNB, accelerobf_serialNB, ai814_serialNB, brakesystemgateway_serialNB, carouselcontroller_serialNB, clampxminuscontroller_serialNB, clampxpluscontroller_serialNB, hyttc580_serialNB, latchxminuscontroller_serialNB, latchxpluscontroller_serialNB, onlineclampxminuscontroller_serialNB, onlineclampxpluscontroller_serialNB, onlineclampyminuscontroller_serialNB, onlinestraingauge_serialNB, proximitysensorsdevice_serialNB, pt100_serialNB, tempsensorsdevice1_serialNB, tempsensorsdevice2_serialNB));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus0_serialNBConfigurationEvent));
        Fcs_Canbus0_serialNBConfigurationEvent item_ = (Fcs_Canbus0_serialNBConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)acsensorsgateway_serialNB, (Object)item_.getAcsensorsgateway_serialNB());
        Assert.assertEquals((Object)actruckxminuscontroller_serialNB, (Object)item_.getActruckxminuscontroller_serialNB());
        Assert.assertEquals((Object)actruckxpluscontroller_serialNB, (Object)item_.getActruckxpluscontroller_serialNB());
        Assert.assertEquals((Object)accelerobf_serialNB, (Object)item_.getAccelerobf_serialNB());
        Assert.assertEquals((Object)ai814_serialNB, (Object)item_.getAi814_serialNB());
        Assert.assertEquals((Object)brakesystemgateway_serialNB, (Object)item_.getBrakesystemgateway_serialNB());
        Assert.assertEquals((Object)carouselcontroller_serialNB, (Object)item_.getCarouselcontroller_serialNB());
        Assert.assertEquals((Object)clampxminuscontroller_serialNB, (Object)item_.getClampxminuscontroller_serialNB());
        Assert.assertEquals((Object)clampxpluscontroller_serialNB, (Object)item_.getClampxpluscontroller_serialNB());
        Assert.assertEquals((Object)hyttc580_serialNB, (Object)item_.getHyttc580_serialNB());
        Assert.assertEquals((Object)latchxminuscontroller_serialNB, (Object)item_.getLatchxminuscontroller_serialNB());
        Assert.assertEquals((Object)latchxpluscontroller_serialNB, (Object)item_.getLatchxpluscontroller_serialNB());
        Assert.assertEquals((Object)onlineclampxminuscontroller_serialNB, (Object)item_.getOnlineclampxminuscontroller_serialNB());
        Assert.assertEquals((Object)onlineclampxpluscontroller_serialNB, (Object)item_.getOnlineclampxpluscontroller_serialNB());
        Assert.assertEquals((Object)onlineclampyminuscontroller_serialNB, (Object)item_.getOnlineclampyminuscontroller_serialNB());
        Assert.assertEquals((Object)onlinestraingauge_serialNB, (Object)item_.getOnlinestraingauge_serialNB());
        Assert.assertEquals((Object)proximitysensorsdevice_serialNB, (Object)item_.getProximitysensorsdevice_serialNB());
        Assert.assertEquals((Object)pt100_serialNB, (Object)item_.getPt100_serialNB());
        Assert.assertEquals((Object)tempsensorsdevice1_serialNB, (Object)item_.getTempsensorsdevice1_serialNB());
        Assert.assertEquals((Object)tempsensorsdevice2_serialNB, (Object)item_.getTempsensorsdevice2_serialNB());
    }

    @Test
    public void sendReceiveFcs_Canbus1_canbusConfigurationEvent() throws Exception {
        String version = "";
        String baud = "a";
        String busName = "c";
        long hardwareBootTimeout = 380L;
        int masterNodeID = 160;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Canbus1_canbusConfigurationEvent(version, baud, busName, hardwareBootTimeout, masterNodeID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus1_canbusConfigurationEvent));
        Fcs_Canbus1_canbusConfigurationEvent item_ = (Fcs_Canbus1_canbusConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)baud, (Object)item_.getBaud());
        Assert.assertEquals((Object)busName, (Object)item_.getBusName());
        Assert.assertEquals((long)hardwareBootTimeout, (long)item_.getHardwareBootTimeout());
        Assert.assertEquals((long)masterNodeID, (long)item_.getMasterNodeID());
    }

    @Test
    public void sendReceiveFcs_Canbus1_controllerConfigurationEvent() throws Exception {
        String version = "q";
        String carriercontroller_paramsForCurrent = "d";
        String carriercontroller_paramsForHoming = "";
        String carriercontroller_paramsForProfilePosition = "";
        String hookscontroller_paramsForCurrent = "q";
        String hookscontroller_paramsForHoming = "";
        String hookscontroller_paramsForProfilePosition = "";
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Canbus1_controllerConfigurationEvent(version, carriercontroller_paramsForCurrent, carriercontroller_paramsForHoming, carriercontroller_paramsForProfilePosition, hookscontroller_paramsForCurrent, hookscontroller_paramsForHoming, hookscontroller_paramsForProfilePosition));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus1_controllerConfigurationEvent));
        Fcs_Canbus1_controllerConfigurationEvent item_ = (Fcs_Canbus1_controllerConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)carriercontroller_paramsForCurrent, (Object)item_.getCarriercontroller_paramsForCurrent());
        Assert.assertEquals((Object)carriercontroller_paramsForHoming, (Object)item_.getCarriercontroller_paramsForHoming());
        Assert.assertEquals((Object)carriercontroller_paramsForProfilePosition, (Object)item_.getCarriercontroller_paramsForProfilePosition());
        Assert.assertEquals((Object)hookscontroller_paramsForCurrent, (Object)item_.getHookscontroller_paramsForCurrent());
        Assert.assertEquals((Object)hookscontroller_paramsForHoming, (Object)item_.getHookscontroller_paramsForHoming());
        Assert.assertEquals((Object)hookscontroller_paramsForProfilePosition, (Object)item_.getHookscontroller_paramsForProfilePosition());
    }

    @Test
    public void sendReceiveFcs_Canbus1_nodeIDConfigurationEvent() throws Exception {
        String version = "v";
        int carriercontroller_nodeID = 4;
        int hookscontroller_nodeID = 378;
        int loaderplutogateway_nodeID = 658;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Canbus1_nodeIDConfigurationEvent(version, carriercontroller_nodeID, hookscontroller_nodeID, loaderplutogateway_nodeID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus1_nodeIDConfigurationEvent));
        Fcs_Canbus1_nodeIDConfigurationEvent item_ = (Fcs_Canbus1_nodeIDConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)carriercontroller_nodeID, (long)item_.getCarriercontroller_nodeID());
        Assert.assertEquals((long)hookscontroller_nodeID, (long)item_.getHookscontroller_nodeID());
        Assert.assertEquals((long)loaderplutogateway_nodeID, (long)item_.getLoaderplutogateway_nodeID());
    }

    @Test
    public void sendReceiveFcs_Canbus1_serialNBConfigurationEvent() throws Exception {
        String version = "v";
        String carriercontroller_serialNB = "z";
        String hookscontroller_serialNB = "";
        String loaderplutogateway_serialNB = "p";
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Canbus1_serialNBConfigurationEvent(version, carriercontroller_serialNB, hookscontroller_serialNB, loaderplutogateway_serialNB));
        Assert.assertTrue((boolean)(item instanceof Fcs_Canbus1_serialNBConfigurationEvent));
        Fcs_Canbus1_serialNBConfigurationEvent item_ = (Fcs_Canbus1_serialNBConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)carriercontroller_serialNB, (Object)item_.getCarriercontroller_serialNB());
        Assert.assertEquals((Object)hookscontroller_serialNB, (Object)item_.getHookscontroller_serialNB());
        Assert.assertEquals((Object)loaderplutogateway_serialNB, (Object)item_.getLoaderplutogateway_serialNB());
    }

    @Test
    public void sendReceiveFcs_Carousel_carouselConfigurationEvent() throws Exception {
        String version = "";
        int brake1Limit = 464;
        int brake2Limit = 590;
        int brake3Limit = 403;
        int currentToPrepareUnlock = 331;
        int fastAcceleration = 97;
        int fastDeceleration = 341;
        int fastRotationTimeout = 233;
        int fastVelocity = 65;
        int filterPresenceMinNoFilter = 649;
        int lockSensorMaxLimitXminus = 346;
        int lockSensorMaxLimitXplus = 384;
        int lockSensorMinLimitXminus = 280;
        int lockSensorMinLimitXplus = 246;
        int maxClampsOffsetDelta = 361;
        int maxStandbyDeltaPosition = 901;
        int recoveryBackwardStep = 34;
        int recoveryForwardStep = 571;
        int recoveryLockingCurrent = 557;
        int recoveryMaxVelocity = 143;
        int recoveryStandbyDeltaPosition = 463;
        int slowAcceleration = 197;
        int slowDeceleration = 417;
        int slowRotationTimeout = 603;
        int slowVelocity = 15;
        int socket1_clampXminus1_currentToUnlock = 199;
        int socket1_clampXminus1_filterPresenceMaxValue = 238;
        int socket1_clampXminus1_filterPresenceOffset3 = 580;
        long socket1_clampXminus1_timeoutForReleasing = 105L;
        long socket1_clampXminus1_timeoutForUnlocking = 893L;
        int socket1_clampXplus1_currentToUnlock = 26;
        int socket1_clampXplus1_filterPresenceMaxValue = 726;
        int socket1_clampXplus1_filterPresenceOffset3 = 31;
        long socket1_clampXplus1_timeoutForReleasing = 325L;
        long socket1_clampXplus1_timeoutForUnlocking = 713L;
        int socket1_deltaAutochangerStandbyPosition = 337;
        int socket1_standbyPosition = 89;
        int socket2_clampXminus2_currentToUnlock = 601;
        int socket2_clampXminus2_filterPresenceMaxValue = 27;
        int socket2_clampXminus2_filterPresenceOffset3 = 26;
        long socket2_clampXminus2_timeoutForReleasing = 218L;
        long socket2_clampXminus2_timeoutForUnlocking = 129L;
        int socket2_clampXplus2_currentToUnlock = 370;
        int socket2_clampXplus2_filterPresenceMaxValue = 109;
        int socket2_clampXplus2_filterPresenceOffset3 = 82;
        long socket2_clampXplus2_timeoutForReleasing = 934L;
        long socket2_clampXplus2_timeoutForUnlocking = 45L;
        int socket2_deltaAutochangerStandbyPosition = 263;
        int socket2_standbyPosition = 161;
        int socket3_clampXminus3_currentToUnlock = 521;
        int socket3_clampXminus3_filterPresenceMaxValue = 934;
        int socket3_clampXminus3_filterPresenceOffset3 = 128;
        long socket3_clampXminus3_timeoutForReleasing = 365L;
        long socket3_clampXminus3_timeoutForUnlocking = 794L;
        int socket3_clampXplus3_currentToUnlock = 45;
        int socket3_clampXplus3_filterPresenceMaxValue = 758;
        int socket3_clampXplus3_filterPresenceOffset3 = 385;
        long socket3_clampXplus3_timeoutForReleasing = 829L;
        long socket3_clampXplus3_timeoutForUnlocking = 479L;
        int socket3_deltaAutochangerStandbyPosition = 492;
        int socket3_standbyPosition = 266;
        int socket4_clampXminus4_currentToUnlock = 438;
        int socket4_clampXminus4_filterPresenceMaxValue = 607;
        int socket4_clampXminus4_filterPresenceOffset3 = 305;
        long socket4_clampXminus4_timeoutForReleasing = 150L;
        long socket4_clampXminus4_timeoutForUnlocking = 653L;
        int socket4_clampXplus4_currentToUnlock = 110;
        int socket4_clampXplus4_filterPresenceMaxValue = 949;
        int socket4_clampXplus4_filterPresenceOffset3 = 387;
        long socket4_clampXplus4_timeoutForReleasing = 61L;
        long socket4_clampXplus4_timeoutForUnlocking = 730L;
        int socket4_deltaAutochangerStandbyPosition = 15;
        int socket4_standbyPosition = 658;
        int socket5_clampXminus5_currentToUnlock = 254;
        int socket5_clampXminus5_filterPresenceMaxValue = 673;
        int socket5_clampXminus5_filterPresenceOffset3 = 569;
        long socket5_clampXminus5_timeoutForReleasing = 510L;
        long socket5_clampXminus5_timeoutForUnlocking = 10L;
        int socket5_clampXplus5_currentToUnlock = 472;
        int socket5_clampXplus5_filterPresenceMaxValue = 29;
        int socket5_clampXplus5_filterPresenceOffset3 = 277;
        long socket5_clampXplus5_timeoutForReleasing = 805L;
        long socket5_clampXplus5_timeoutForUnlocking = 236L;
        int socket5_deltaAutochangerStandbyPosition = 777;
        int socket5_standbyPosition = 145;
        int timeToPrepareUnlock = 693;
        long timeToUpdateProtectionSystem = 452L;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Carousel_carouselConfigurationEvent(version, brake1Limit, brake2Limit, brake3Limit, currentToPrepareUnlock, fastAcceleration, fastDeceleration, fastRotationTimeout, fastVelocity, filterPresenceMinNoFilter, lockSensorMaxLimitXminus, lockSensorMaxLimitXplus, lockSensorMinLimitXminus, lockSensorMinLimitXplus, maxClampsOffsetDelta, maxStandbyDeltaPosition, recoveryBackwardStep, recoveryForwardStep, recoveryLockingCurrent, recoveryMaxVelocity, recoveryStandbyDeltaPosition, slowAcceleration, slowDeceleration, slowRotationTimeout, slowVelocity, socket1_clampXminus1_currentToUnlock, socket1_clampXminus1_filterPresenceMaxValue, socket1_clampXminus1_filterPresenceOffset3, socket1_clampXminus1_timeoutForReleasing, socket1_clampXminus1_timeoutForUnlocking, socket1_clampXplus1_currentToUnlock, socket1_clampXplus1_filterPresenceMaxValue, socket1_clampXplus1_filterPresenceOffset3, socket1_clampXplus1_timeoutForReleasing, socket1_clampXplus1_timeoutForUnlocking, socket1_deltaAutochangerStandbyPosition, socket1_standbyPosition, socket2_clampXminus2_currentToUnlock, socket2_clampXminus2_filterPresenceMaxValue, socket2_clampXminus2_filterPresenceOffset3, socket2_clampXminus2_timeoutForReleasing, socket2_clampXminus2_timeoutForUnlocking, socket2_clampXplus2_currentToUnlock, socket2_clampXplus2_filterPresenceMaxValue, socket2_clampXplus2_filterPresenceOffset3, socket2_clampXplus2_timeoutForReleasing, socket2_clampXplus2_timeoutForUnlocking, socket2_deltaAutochangerStandbyPosition, socket2_standbyPosition, socket3_clampXminus3_currentToUnlock, socket3_clampXminus3_filterPresenceMaxValue, socket3_clampXminus3_filterPresenceOffset3, socket3_clampXminus3_timeoutForReleasing, socket3_clampXminus3_timeoutForUnlocking, socket3_clampXplus3_currentToUnlock, socket3_clampXplus3_filterPresenceMaxValue, socket3_clampXplus3_filterPresenceOffset3, socket3_clampXplus3_timeoutForReleasing, socket3_clampXplus3_timeoutForUnlocking, socket3_deltaAutochangerStandbyPosition, socket3_standbyPosition, socket4_clampXminus4_currentToUnlock, socket4_clampXminus4_filterPresenceMaxValue, socket4_clampXminus4_filterPresenceOffset3, socket4_clampXminus4_timeoutForReleasing, socket4_clampXminus4_timeoutForUnlocking, socket4_clampXplus4_currentToUnlock, socket4_clampXplus4_filterPresenceMaxValue, socket4_clampXplus4_filterPresenceOffset3, socket4_clampXplus4_timeoutForReleasing, socket4_clampXplus4_timeoutForUnlocking, socket4_deltaAutochangerStandbyPosition, socket4_standbyPosition, socket5_clampXminus5_currentToUnlock, socket5_clampXminus5_filterPresenceMaxValue, socket5_clampXminus5_filterPresenceOffset3, socket5_clampXminus5_timeoutForReleasing, socket5_clampXminus5_timeoutForUnlocking, socket5_clampXplus5_currentToUnlock, socket5_clampXplus5_filterPresenceMaxValue, socket5_clampXplus5_filterPresenceOffset3, socket5_clampXplus5_timeoutForReleasing, socket5_clampXplus5_timeoutForUnlocking, socket5_deltaAutochangerStandbyPosition, socket5_standbyPosition, timeToPrepareUnlock, timeToUpdateProtectionSystem));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_carouselConfigurationEvent));
        Fcs_Carousel_carouselConfigurationEvent item_ = (Fcs_Carousel_carouselConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)brake1Limit, (long)item_.getBrake1Limit());
        Assert.assertEquals((long)brake2Limit, (long)item_.getBrake2Limit());
        Assert.assertEquals((long)brake3Limit, (long)item_.getBrake3Limit());
        Assert.assertEquals((long)currentToPrepareUnlock, (long)item_.getCurrentToPrepareUnlock());
        Assert.assertEquals((long)fastAcceleration, (long)item_.getFastAcceleration());
        Assert.assertEquals((long)fastDeceleration, (long)item_.getFastDeceleration());
        Assert.assertEquals((long)fastRotationTimeout, (long)item_.getFastRotationTimeout());
        Assert.assertEquals((long)fastVelocity, (long)item_.getFastVelocity());
        Assert.assertEquals((long)filterPresenceMinNoFilter, (long)item_.getFilterPresenceMinNoFilter());
        Assert.assertEquals((long)lockSensorMaxLimitXminus, (long)item_.getLockSensorMaxLimitXminus());
        Assert.assertEquals((long)lockSensorMaxLimitXplus, (long)item_.getLockSensorMaxLimitXplus());
        Assert.assertEquals((long)lockSensorMinLimitXminus, (long)item_.getLockSensorMinLimitXminus());
        Assert.assertEquals((long)lockSensorMinLimitXplus, (long)item_.getLockSensorMinLimitXplus());
        Assert.assertEquals((long)maxClampsOffsetDelta, (long)item_.getMaxClampsOffsetDelta());
        Assert.assertEquals((long)maxStandbyDeltaPosition, (long)item_.getMaxStandbyDeltaPosition());
        Assert.assertEquals((long)recoveryBackwardStep, (long)item_.getRecoveryBackwardStep());
        Assert.assertEquals((long)recoveryForwardStep, (long)item_.getRecoveryForwardStep());
        Assert.assertEquals((long)recoveryLockingCurrent, (long)item_.getRecoveryLockingCurrent());
        Assert.assertEquals((long)recoveryMaxVelocity, (long)item_.getRecoveryMaxVelocity());
        Assert.assertEquals((long)recoveryStandbyDeltaPosition, (long)item_.getRecoveryStandbyDeltaPosition());
        Assert.assertEquals((long)slowAcceleration, (long)item_.getSlowAcceleration());
        Assert.assertEquals((long)slowDeceleration, (long)item_.getSlowDeceleration());
        Assert.assertEquals((long)slowRotationTimeout, (long)item_.getSlowRotationTimeout());
        Assert.assertEquals((long)slowVelocity, (long)item_.getSlowVelocity());
        Assert.assertEquals((long)socket1_clampXminus1_currentToUnlock, (long)item_.getSocket1_clampXminus1_currentToUnlock());
        Assert.assertEquals((long)socket1_clampXminus1_filterPresenceMaxValue, (long)item_.getSocket1_clampXminus1_filterPresenceMaxValue());
        Assert.assertEquals((long)socket1_clampXminus1_filterPresenceOffset3, (long)item_.getSocket1_clampXminus1_filterPresenceOffset3());
        Assert.assertEquals((long)socket1_clampXminus1_timeoutForReleasing, (long)item_.getSocket1_clampXminus1_timeoutForReleasing());
        Assert.assertEquals((long)socket1_clampXminus1_timeoutForUnlocking, (long)item_.getSocket1_clampXminus1_timeoutForUnlocking());
        Assert.assertEquals((long)socket1_clampXplus1_currentToUnlock, (long)item_.getSocket1_clampXplus1_currentToUnlock());
        Assert.assertEquals((long)socket1_clampXplus1_filterPresenceMaxValue, (long)item_.getSocket1_clampXplus1_filterPresenceMaxValue());
        Assert.assertEquals((long)socket1_clampXplus1_filterPresenceOffset3, (long)item_.getSocket1_clampXplus1_filterPresenceOffset3());
        Assert.assertEquals((long)socket1_clampXplus1_timeoutForReleasing, (long)item_.getSocket1_clampXplus1_timeoutForReleasing());
        Assert.assertEquals((long)socket1_clampXplus1_timeoutForUnlocking, (long)item_.getSocket1_clampXplus1_timeoutForUnlocking());
        Assert.assertEquals((long)socket1_deltaAutochangerStandbyPosition, (long)item_.getSocket1_deltaAutochangerStandbyPosition());
        Assert.assertEquals((long)socket1_standbyPosition, (long)item_.getSocket1_standbyPosition());
        Assert.assertEquals((long)socket2_clampXminus2_currentToUnlock, (long)item_.getSocket2_clampXminus2_currentToUnlock());
        Assert.assertEquals((long)socket2_clampXminus2_filterPresenceMaxValue, (long)item_.getSocket2_clampXminus2_filterPresenceMaxValue());
        Assert.assertEquals((long)socket2_clampXminus2_filterPresenceOffset3, (long)item_.getSocket2_clampXminus2_filterPresenceOffset3());
        Assert.assertEquals((long)socket2_clampXminus2_timeoutForReleasing, (long)item_.getSocket2_clampXminus2_timeoutForReleasing());
        Assert.assertEquals((long)socket2_clampXminus2_timeoutForUnlocking, (long)item_.getSocket2_clampXminus2_timeoutForUnlocking());
        Assert.assertEquals((long)socket2_clampXplus2_currentToUnlock, (long)item_.getSocket2_clampXplus2_currentToUnlock());
        Assert.assertEquals((long)socket2_clampXplus2_filterPresenceMaxValue, (long)item_.getSocket2_clampXplus2_filterPresenceMaxValue());
        Assert.assertEquals((long)socket2_clampXplus2_filterPresenceOffset3, (long)item_.getSocket2_clampXplus2_filterPresenceOffset3());
        Assert.assertEquals((long)socket2_clampXplus2_timeoutForReleasing, (long)item_.getSocket2_clampXplus2_timeoutForReleasing());
        Assert.assertEquals((long)socket2_clampXplus2_timeoutForUnlocking, (long)item_.getSocket2_clampXplus2_timeoutForUnlocking());
        Assert.assertEquals((long)socket2_deltaAutochangerStandbyPosition, (long)item_.getSocket2_deltaAutochangerStandbyPosition());
        Assert.assertEquals((long)socket2_standbyPosition, (long)item_.getSocket2_standbyPosition());
        Assert.assertEquals((long)socket3_clampXminus3_currentToUnlock, (long)item_.getSocket3_clampXminus3_currentToUnlock());
        Assert.assertEquals((long)socket3_clampXminus3_filterPresenceMaxValue, (long)item_.getSocket3_clampXminus3_filterPresenceMaxValue());
        Assert.assertEquals((long)socket3_clampXminus3_filterPresenceOffset3, (long)item_.getSocket3_clampXminus3_filterPresenceOffset3());
        Assert.assertEquals((long)socket3_clampXminus3_timeoutForReleasing, (long)item_.getSocket3_clampXminus3_timeoutForReleasing());
        Assert.assertEquals((long)socket3_clampXminus3_timeoutForUnlocking, (long)item_.getSocket3_clampXminus3_timeoutForUnlocking());
        Assert.assertEquals((long)socket3_clampXplus3_currentToUnlock, (long)item_.getSocket3_clampXplus3_currentToUnlock());
        Assert.assertEquals((long)socket3_clampXplus3_filterPresenceMaxValue, (long)item_.getSocket3_clampXplus3_filterPresenceMaxValue());
        Assert.assertEquals((long)socket3_clampXplus3_filterPresenceOffset3, (long)item_.getSocket3_clampXplus3_filterPresenceOffset3());
        Assert.assertEquals((long)socket3_clampXplus3_timeoutForReleasing, (long)item_.getSocket3_clampXplus3_timeoutForReleasing());
        Assert.assertEquals((long)socket3_clampXplus3_timeoutForUnlocking, (long)item_.getSocket3_clampXplus3_timeoutForUnlocking());
        Assert.assertEquals((long)socket3_deltaAutochangerStandbyPosition, (long)item_.getSocket3_deltaAutochangerStandbyPosition());
        Assert.assertEquals((long)socket3_standbyPosition, (long)item_.getSocket3_standbyPosition());
        Assert.assertEquals((long)socket4_clampXminus4_currentToUnlock, (long)item_.getSocket4_clampXminus4_currentToUnlock());
        Assert.assertEquals((long)socket4_clampXminus4_filterPresenceMaxValue, (long)item_.getSocket4_clampXminus4_filterPresenceMaxValue());
        Assert.assertEquals((long)socket4_clampXminus4_filterPresenceOffset3, (long)item_.getSocket4_clampXminus4_filterPresenceOffset3());
        Assert.assertEquals((long)socket4_clampXminus4_timeoutForReleasing, (long)item_.getSocket4_clampXminus4_timeoutForReleasing());
        Assert.assertEquals((long)socket4_clampXminus4_timeoutForUnlocking, (long)item_.getSocket4_clampXminus4_timeoutForUnlocking());
        Assert.assertEquals((long)socket4_clampXplus4_currentToUnlock, (long)item_.getSocket4_clampXplus4_currentToUnlock());
        Assert.assertEquals((long)socket4_clampXplus4_filterPresenceMaxValue, (long)item_.getSocket4_clampXplus4_filterPresenceMaxValue());
        Assert.assertEquals((long)socket4_clampXplus4_filterPresenceOffset3, (long)item_.getSocket4_clampXplus4_filterPresenceOffset3());
        Assert.assertEquals((long)socket4_clampXplus4_timeoutForReleasing, (long)item_.getSocket4_clampXplus4_timeoutForReleasing());
        Assert.assertEquals((long)socket4_clampXplus4_timeoutForUnlocking, (long)item_.getSocket4_clampXplus4_timeoutForUnlocking());
        Assert.assertEquals((long)socket4_deltaAutochangerStandbyPosition, (long)item_.getSocket4_deltaAutochangerStandbyPosition());
        Assert.assertEquals((long)socket4_standbyPosition, (long)item_.getSocket4_standbyPosition());
        Assert.assertEquals((long)socket5_clampXminus5_currentToUnlock, (long)item_.getSocket5_clampXminus5_currentToUnlock());
        Assert.assertEquals((long)socket5_clampXminus5_filterPresenceMaxValue, (long)item_.getSocket5_clampXminus5_filterPresenceMaxValue());
        Assert.assertEquals((long)socket5_clampXminus5_filterPresenceOffset3, (long)item_.getSocket5_clampXminus5_filterPresenceOffset3());
        Assert.assertEquals((long)socket5_clampXminus5_timeoutForReleasing, (long)item_.getSocket5_clampXminus5_timeoutForReleasing());
        Assert.assertEquals((long)socket5_clampXminus5_timeoutForUnlocking, (long)item_.getSocket5_clampXminus5_timeoutForUnlocking());
        Assert.assertEquals((long)socket5_clampXplus5_currentToUnlock, (long)item_.getSocket5_clampXplus5_currentToUnlock());
        Assert.assertEquals((long)socket5_clampXplus5_filterPresenceMaxValue, (long)item_.getSocket5_clampXplus5_filterPresenceMaxValue());
        Assert.assertEquals((long)socket5_clampXplus5_filterPresenceOffset3, (long)item_.getSocket5_clampXplus5_filterPresenceOffset3());
        Assert.assertEquals((long)socket5_clampXplus5_timeoutForReleasing, (long)item_.getSocket5_clampXplus5_timeoutForReleasing());
        Assert.assertEquals((long)socket5_clampXplus5_timeoutForUnlocking, (long)item_.getSocket5_clampXplus5_timeoutForUnlocking());
        Assert.assertEquals((long)socket5_deltaAutochangerStandbyPosition, (long)item_.getSocket5_deltaAutochangerStandbyPosition());
        Assert.assertEquals((long)socket5_standbyPosition, (long)item_.getSocket5_standbyPosition());
        Assert.assertEquals((long)timeToPrepareUnlock, (long)item_.getTimeToPrepareUnlock());
        Assert.assertEquals((long)timeToUpdateProtectionSystem, (long)item_.getTimeToUpdateProtectionSystem());
    }

    @Test
    public void sendReceiveFcs_Carousel_readRateConfigurationEvent() throws Exception {
        String version = "z";
        int readSensorsRate = 785;
        int socket1_clampXminus1_readSensorsRate = 129;
        int socket1_clampXplus1_readSensorsRate = 725;
        int socket2_clampXminus2_readSensorsRate = 158;
        int socket2_clampXplus2_readSensorsRate = 422;
        int socket3_clampXminus3_readSensorsRate = 267;
        int socket3_clampXplus3_readSensorsRate = 522;
        int socket4_clampXminus4_readSensorsRate = 955;
        int socket4_clampXplus4_readSensorsRate = 124;
        int socket5_clampXminus5_readSensorsRate = 722;
        int socket5_clampXplus5_readSensorsRate = 931;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Carousel_readRateConfigurationEvent(version, readSensorsRate, socket1_clampXminus1_readSensorsRate, socket1_clampXplus1_readSensorsRate, socket2_clampXminus2_readSensorsRate, socket2_clampXplus2_readSensorsRate, socket3_clampXminus3_readSensorsRate, socket3_clampXplus3_readSensorsRate, socket4_clampXminus4_readSensorsRate, socket4_clampXplus4_readSensorsRate, socket5_clampXminus5_readSensorsRate, socket5_clampXplus5_readSensorsRate));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_readRateConfigurationEvent));
        Fcs_Carousel_readRateConfigurationEvent item_ = (Fcs_Carousel_readRateConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)readSensorsRate, (long)item_.getReadSensorsRate());
        Assert.assertEquals((long)socket1_clampXminus1_readSensorsRate, (long)item_.getSocket1_clampXminus1_readSensorsRate());
        Assert.assertEquals((long)socket1_clampXplus1_readSensorsRate, (long)item_.getSocket1_clampXplus1_readSensorsRate());
        Assert.assertEquals((long)socket2_clampXminus2_readSensorsRate, (long)item_.getSocket2_clampXminus2_readSensorsRate());
        Assert.assertEquals((long)socket2_clampXplus2_readSensorsRate, (long)item_.getSocket2_clampXplus2_readSensorsRate());
        Assert.assertEquals((long)socket3_clampXminus3_readSensorsRate, (long)item_.getSocket3_clampXminus3_readSensorsRate());
        Assert.assertEquals((long)socket3_clampXplus3_readSensorsRate, (long)item_.getSocket3_clampXplus3_readSensorsRate());
        Assert.assertEquals((long)socket4_clampXminus4_readSensorsRate, (long)item_.getSocket4_clampXminus4_readSensorsRate());
        Assert.assertEquals((long)socket4_clampXplus4_readSensorsRate, (long)item_.getSocket4_clampXplus4_readSensorsRate());
        Assert.assertEquals((long)socket5_clampXminus5_readSensorsRate, (long)item_.getSocket5_clampXminus5_readSensorsRate());
        Assert.assertEquals((long)socket5_clampXplus5_readSensorsRate, (long)item_.getSocket5_clampXplus5_readSensorsRate());
    }

    @Test
    public void sendReceiveFcs_Carousel_sensorConfigurationEvent() throws Exception {
        String version = "q";
        int plc_caAF3_bitNumero = 350;
        int plc_caAF3_byteNumero = 50;
        String plc_caAF3_deviceName = "";
        int plc_caAF3b_bitNumero = 483;
        int plc_caAF3b_byteNumero = 315;
        String plc_caAF3b_deviceName = "";
        int plc_caAP1_bitNumero = 976;
        int plc_caAP1_byteNumero = 911;
        String plc_caAP1_deviceName = "";
        int plc_caAP1b_bitNumero = 722;
        int plc_caAP1b_byteNumero = 561;
        String plc_caAP1b_deviceName = "i";
        int plc_caAP2_bitNumero = 70;
        int plc_caAP2_byteNumero = 8;
        String plc_caAP2_deviceName = "";
        int plc_caAP2b_bitNumero = 778;
        int plc_caAP2b_byteNumero = 365;
        String plc_caAP2b_deviceName = "j";
        int plc_caAP3_bitNumero = 81;
        int plc_caAP3_byteNumero = 700;
        String plc_caAP3_deviceName = "x";
        int plc_caAP3b_bitNumero = 572;
        int plc_caAP3b_byteNumero = 549;
        String plc_caAP3b_deviceName = "";
        int plc_caBrakesActivated_bitNumero = 631;
        int plc_caBrakesActivated_byteNumero = 416;
        String plc_caBrakesActivated_deviceName = "";
        int plc_caCF0_bitNumero = 558;
        int plc_caCF0_byteNumero = 887;
        String plc_caCF0_deviceName = "";
        int plc_caCF0b_bitNumero = 216;
        int plc_caCF0b_byteNumero = 959;
        String plc_caCF0b_deviceName = "v";
        int plc_caCF1_bitNumero = 240;
        int plc_caCF1_byteNumero = 803;
        String plc_caCF1_deviceName = "";
        int plc_caCF1b_bitNumero = 734;
        int plc_caCF1b_byteNumero = 379;
        String plc_caCF1b_deviceName = "";
        int plc_caCFC_bitNumero = 138;
        int plc_caCFC_byteNumero = 765;
        String plc_caCFC_deviceName = "";
        int plc_caCFCb_bitNumero = 886;
        int plc_caCFCb_byteNumero = 468;
        String plc_caCFCb_deviceName = "o";
        int plc_caCS_bitNumero = 636;
        int plc_caCS_byteNumero = 156;
        String plc_caCS_deviceName = "";
        int plc_caCSb_bitNumero = 948;
        int plc_caCSb_byteNumero = 809;
        String plc_caCSb_deviceName = "";
        int plc_caEnableBrakes_bitNumero = 45;
        int plc_caEnableBrakes_byteNumero = 974;
        String plc_caEnableBrakes_deviceName = "k";
        int plc_caEnableRotation_bitNumero = 188;
        int plc_caEnableRotation_byteNumero = 847;
        String plc_caEnableRotation_deviceName = "";
        int plc_caEnableShutter_bitNumero = 837;
        int plc_caEnableShutter_byteNumero = 36;
        String plc_caEnableShutter_deviceName = "o";
        int plc_caEnableUnclamp_bitNumero = 68;
        int plc_caEnableUnclamp_byteNumero = 610;
        String plc_caEnableUnclamp_deviceName = "l";
        int plc_caEng_bitNumero = 906;
        int plc_caEng_byteNumero = 906;
        String plc_caEng_deviceName = "d";
        int plc_caEngb_bitNumero = 125;
        int plc_caEngb_byteNumero = 40;
        String plc_caEngb_deviceName = "";
        int plc_caLockout_bitNumero = 710;
        int plc_caLockout_byteNumero = 87;
        String plc_caLockout_deviceName = "f";
        int plc_caLockoutb_bitNumero = 787;
        int plc_caLockoutb_byteNumero = 226;
        String plc_caLockoutb_deviceName = "";
        int plc_caShutterInactive_bitNumero = 266;
        int plc_caShutterInactive_byteNumero = 344;
        String plc_caShutterInactive_deviceName = "";
        int plc_caSleep_bitNumero = 49;
        int plc_caSleep_byteNumero = 400;
        String plc_caSleep_deviceName = "";
        int plc_enableShutterInterlock_bitNumero = 509;
        int plc_enableShutterInterlock_byteNumero = 291;
        String plc_enableShutterInterlock_deviceName = "e";
        int plc_okDI_bitNumero = 959;
        int plc_okDI_byteNumero = 687;
        String plc_okDI_deviceName = "";
        int plc_okDIsafety_bitNumero = 672;
        int plc_okDIsafety_byteNumero = 257;
        String plc_okDIsafety_deviceName = "";
        int plc_powerSave_bitNumero = 524;
        int plc_powerSave_byteNumero = 798;
        String plc_powerSave_deviceName = "q";
        int plc_tpCheckRotation_bitNumero = 993;
        int plc_tpCheckRotation_byteNumero = 165;
        String plc_tpCheckRotation_deviceName = "c";
        int plc_tpStopRotation_bitNumero = 583;
        int plc_tpStopRotation_byteNumero = 581;
        String plc_tpStopRotation_deviceName = "z";
        int plc_tpStopUnclamp_bitNumero = 10;
        int plc_tpStopUnclamp_byteNumero = 994;
        String plc_tpStopUnclamp_deviceName = "a";
        String socket1_clampXminus1_filterPresenceXminus1_deviceName = "";
        String socket1_clampXminus1_lockSensorXminus1_deviceName = "";
        String socket1_clampXplus1_filterPresenceXplus1_deviceName = "s";
        String socket1_clampXplus1_lockSensorXplus1_deviceName = "";
        String socket1_ioModuleSensor1_deviceName = "";
        String socket2_clampXminus2_filterPresenceXminus2_deviceName = "";
        String socket2_clampXminus2_lockSensorXminus2_deviceName = "k";
        String socket2_clampXplus2_filterPresenceXplus2_deviceName = "s";
        String socket2_clampXplus2_lockSensorXplus2_deviceName = "";
        String socket2_ioModuleSensor2_deviceName = "w";
        String socket3_clampXminus3_filterPresenceXminus3_deviceName = "r";
        String socket3_clampXminus3_lockSensorXminus3_deviceName = "w";
        String socket3_clampXplus3_filterPresenceXplus3_deviceName = "q";
        String socket3_clampXplus3_lockSensorXplus3_deviceName = "";
        String socket3_ioModuleSensor3_deviceName = "";
        String socket4_clampXminus4_filterPresenceXminus4_deviceName = "";
        String socket4_clampXminus4_lockSensorXminus4_deviceName = "j";
        String socket4_clampXplus4_filterPresenceXplus4_deviceName = "l";
        String socket4_clampXplus4_lockSensorXplus4_deviceName = "t";
        String socket4_ioModuleSensor4_deviceName = "";
        String socket5_clampXminus5_filterPresenceXminus5_deviceName = "z";
        String socket5_clampXminus5_lockSensorXminus5_deviceName = "";
        String socket5_clampXplus5_filterPresenceXplus5_deviceName = "g";
        String socket5_clampXplus5_lockSensorXplus5_deviceName = "";
        String socket5_ioModuleSensor5_deviceName = "o";
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Carousel_sensorConfigurationEvent(version, plc_caAF3_bitNumero, plc_caAF3_byteNumero, plc_caAF3_deviceName, plc_caAF3b_bitNumero, plc_caAF3b_byteNumero, plc_caAF3b_deviceName, plc_caAP1_bitNumero, plc_caAP1_byteNumero, plc_caAP1_deviceName, plc_caAP1b_bitNumero, plc_caAP1b_byteNumero, plc_caAP1b_deviceName, plc_caAP2_bitNumero, plc_caAP2_byteNumero, plc_caAP2_deviceName, plc_caAP2b_bitNumero, plc_caAP2b_byteNumero, plc_caAP2b_deviceName, plc_caAP3_bitNumero, plc_caAP3_byteNumero, plc_caAP3_deviceName, plc_caAP3b_bitNumero, plc_caAP3b_byteNumero, plc_caAP3b_deviceName, plc_caBrakesActivated_bitNumero, plc_caBrakesActivated_byteNumero, plc_caBrakesActivated_deviceName, plc_caCF0_bitNumero, plc_caCF0_byteNumero, plc_caCF0_deviceName, plc_caCF0b_bitNumero, plc_caCF0b_byteNumero, plc_caCF0b_deviceName, plc_caCF1_bitNumero, plc_caCF1_byteNumero, plc_caCF1_deviceName, plc_caCF1b_bitNumero, plc_caCF1b_byteNumero, plc_caCF1b_deviceName, plc_caCFC_bitNumero, plc_caCFC_byteNumero, plc_caCFC_deviceName, plc_caCFCb_bitNumero, plc_caCFCb_byteNumero, plc_caCFCb_deviceName, plc_caCS_bitNumero, plc_caCS_byteNumero, plc_caCS_deviceName, plc_caCSb_bitNumero, plc_caCSb_byteNumero, plc_caCSb_deviceName, plc_caEnableBrakes_bitNumero, plc_caEnableBrakes_byteNumero, plc_caEnableBrakes_deviceName, plc_caEnableRotation_bitNumero, plc_caEnableRotation_byteNumero, plc_caEnableRotation_deviceName, plc_caEnableShutter_bitNumero, plc_caEnableShutter_byteNumero, plc_caEnableShutter_deviceName, plc_caEnableUnclamp_bitNumero, plc_caEnableUnclamp_byteNumero, plc_caEnableUnclamp_deviceName, plc_caEng_bitNumero, plc_caEng_byteNumero, plc_caEng_deviceName, plc_caEngb_bitNumero, plc_caEngb_byteNumero, plc_caEngb_deviceName, plc_caLockout_bitNumero, plc_caLockout_byteNumero, plc_caLockout_deviceName, plc_caLockoutb_bitNumero, plc_caLockoutb_byteNumero, plc_caLockoutb_deviceName, plc_caShutterInactive_bitNumero, plc_caShutterInactive_byteNumero, plc_caShutterInactive_deviceName, plc_caSleep_bitNumero, plc_caSleep_byteNumero, plc_caSleep_deviceName, plc_enableShutterInterlock_bitNumero, plc_enableShutterInterlock_byteNumero, plc_enableShutterInterlock_deviceName, plc_okDI_bitNumero, plc_okDI_byteNumero, plc_okDI_deviceName, plc_okDIsafety_bitNumero, plc_okDIsafety_byteNumero, plc_okDIsafety_deviceName, plc_powerSave_bitNumero, plc_powerSave_byteNumero, plc_powerSave_deviceName, plc_tpCheckRotation_bitNumero, plc_tpCheckRotation_byteNumero, plc_tpCheckRotation_deviceName, plc_tpStopRotation_bitNumero, plc_tpStopRotation_byteNumero, plc_tpStopRotation_deviceName, plc_tpStopUnclamp_bitNumero, plc_tpStopUnclamp_byteNumero, plc_tpStopUnclamp_deviceName, socket1_clampXminus1_filterPresenceXminus1_deviceName, socket1_clampXminus1_lockSensorXminus1_deviceName, socket1_clampXplus1_filterPresenceXplus1_deviceName, socket1_clampXplus1_lockSensorXplus1_deviceName, socket1_ioModuleSensor1_deviceName, socket2_clampXminus2_filterPresenceXminus2_deviceName, socket2_clampXminus2_lockSensorXminus2_deviceName, socket2_clampXplus2_filterPresenceXplus2_deviceName, socket2_clampXplus2_lockSensorXplus2_deviceName, socket2_ioModuleSensor2_deviceName, socket3_clampXminus3_filterPresenceXminus3_deviceName, socket3_clampXminus3_lockSensorXminus3_deviceName, socket3_clampXplus3_filterPresenceXplus3_deviceName, socket3_clampXplus3_lockSensorXplus3_deviceName, socket3_ioModuleSensor3_deviceName, socket4_clampXminus4_filterPresenceXminus4_deviceName, socket4_clampXminus4_lockSensorXminus4_deviceName, socket4_clampXplus4_filterPresenceXplus4_deviceName, socket4_clampXplus4_lockSensorXplus4_deviceName, socket4_ioModuleSensor4_deviceName, socket5_clampXminus5_filterPresenceXminus5_deviceName, socket5_clampXminus5_lockSensorXminus5_deviceName, socket5_clampXplus5_filterPresenceXplus5_deviceName, socket5_clampXplus5_lockSensorXplus5_deviceName, socket5_ioModuleSensor5_deviceName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Carousel_sensorConfigurationEvent));
        Fcs_Carousel_sensorConfigurationEvent item_ = (Fcs_Carousel_sensorConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)plc_caAF3_bitNumero, (long)item_.getPlc_caAF3_bitNumero());
        Assert.assertEquals((long)plc_caAF3_byteNumero, (long)item_.getPlc_caAF3_byteNumero());
        Assert.assertEquals((Object)plc_caAF3_deviceName, (Object)item_.getPlc_caAF3_deviceName());
        Assert.assertEquals((long)plc_caAF3b_bitNumero, (long)item_.getPlc_caAF3b_bitNumero());
        Assert.assertEquals((long)plc_caAF3b_byteNumero, (long)item_.getPlc_caAF3b_byteNumero());
        Assert.assertEquals((Object)plc_caAF3b_deviceName, (Object)item_.getPlc_caAF3b_deviceName());
        Assert.assertEquals((long)plc_caAP1_bitNumero, (long)item_.getPlc_caAP1_bitNumero());
        Assert.assertEquals((long)plc_caAP1_byteNumero, (long)item_.getPlc_caAP1_byteNumero());
        Assert.assertEquals((Object)plc_caAP1_deviceName, (Object)item_.getPlc_caAP1_deviceName());
        Assert.assertEquals((long)plc_caAP1b_bitNumero, (long)item_.getPlc_caAP1b_bitNumero());
        Assert.assertEquals((long)plc_caAP1b_byteNumero, (long)item_.getPlc_caAP1b_byteNumero());
        Assert.assertEquals((Object)plc_caAP1b_deviceName, (Object)item_.getPlc_caAP1b_deviceName());
        Assert.assertEquals((long)plc_caAP2_bitNumero, (long)item_.getPlc_caAP2_bitNumero());
        Assert.assertEquals((long)plc_caAP2_byteNumero, (long)item_.getPlc_caAP2_byteNumero());
        Assert.assertEquals((Object)plc_caAP2_deviceName, (Object)item_.getPlc_caAP2_deviceName());
        Assert.assertEquals((long)plc_caAP2b_bitNumero, (long)item_.getPlc_caAP2b_bitNumero());
        Assert.assertEquals((long)plc_caAP2b_byteNumero, (long)item_.getPlc_caAP2b_byteNumero());
        Assert.assertEquals((Object)plc_caAP2b_deviceName, (Object)item_.getPlc_caAP2b_deviceName());
        Assert.assertEquals((long)plc_caAP3_bitNumero, (long)item_.getPlc_caAP3_bitNumero());
        Assert.assertEquals((long)plc_caAP3_byteNumero, (long)item_.getPlc_caAP3_byteNumero());
        Assert.assertEquals((Object)plc_caAP3_deviceName, (Object)item_.getPlc_caAP3_deviceName());
        Assert.assertEquals((long)plc_caAP3b_bitNumero, (long)item_.getPlc_caAP3b_bitNumero());
        Assert.assertEquals((long)plc_caAP3b_byteNumero, (long)item_.getPlc_caAP3b_byteNumero());
        Assert.assertEquals((Object)plc_caAP3b_deviceName, (Object)item_.getPlc_caAP3b_deviceName());
        Assert.assertEquals((long)plc_caBrakesActivated_bitNumero, (long)item_.getPlc_caBrakesActivated_bitNumero());
        Assert.assertEquals((long)plc_caBrakesActivated_byteNumero, (long)item_.getPlc_caBrakesActivated_byteNumero());
        Assert.assertEquals((Object)plc_caBrakesActivated_deviceName, (Object)item_.getPlc_caBrakesActivated_deviceName());
        Assert.assertEquals((long)plc_caCF0_bitNumero, (long)item_.getPlc_caCF0_bitNumero());
        Assert.assertEquals((long)plc_caCF0_byteNumero, (long)item_.getPlc_caCF0_byteNumero());
        Assert.assertEquals((Object)plc_caCF0_deviceName, (Object)item_.getPlc_caCF0_deviceName());
        Assert.assertEquals((long)plc_caCF0b_bitNumero, (long)item_.getPlc_caCF0b_bitNumero());
        Assert.assertEquals((long)plc_caCF0b_byteNumero, (long)item_.getPlc_caCF0b_byteNumero());
        Assert.assertEquals((Object)plc_caCF0b_deviceName, (Object)item_.getPlc_caCF0b_deviceName());
        Assert.assertEquals((long)plc_caCF1_bitNumero, (long)item_.getPlc_caCF1_bitNumero());
        Assert.assertEquals((long)plc_caCF1_byteNumero, (long)item_.getPlc_caCF1_byteNumero());
        Assert.assertEquals((Object)plc_caCF1_deviceName, (Object)item_.getPlc_caCF1_deviceName());
        Assert.assertEquals((long)plc_caCF1b_bitNumero, (long)item_.getPlc_caCF1b_bitNumero());
        Assert.assertEquals((long)plc_caCF1b_byteNumero, (long)item_.getPlc_caCF1b_byteNumero());
        Assert.assertEquals((Object)plc_caCF1b_deviceName, (Object)item_.getPlc_caCF1b_deviceName());
        Assert.assertEquals((long)plc_caCFC_bitNumero, (long)item_.getPlc_caCFC_bitNumero());
        Assert.assertEquals((long)plc_caCFC_byteNumero, (long)item_.getPlc_caCFC_byteNumero());
        Assert.assertEquals((Object)plc_caCFC_deviceName, (Object)item_.getPlc_caCFC_deviceName());
        Assert.assertEquals((long)plc_caCFCb_bitNumero, (long)item_.getPlc_caCFCb_bitNumero());
        Assert.assertEquals((long)plc_caCFCb_byteNumero, (long)item_.getPlc_caCFCb_byteNumero());
        Assert.assertEquals((Object)plc_caCFCb_deviceName, (Object)item_.getPlc_caCFCb_deviceName());
        Assert.assertEquals((long)plc_caCS_bitNumero, (long)item_.getPlc_caCS_bitNumero());
        Assert.assertEquals((long)plc_caCS_byteNumero, (long)item_.getPlc_caCS_byteNumero());
        Assert.assertEquals((Object)plc_caCS_deviceName, (Object)item_.getPlc_caCS_deviceName());
        Assert.assertEquals((long)plc_caCSb_bitNumero, (long)item_.getPlc_caCSb_bitNumero());
        Assert.assertEquals((long)plc_caCSb_byteNumero, (long)item_.getPlc_caCSb_byteNumero());
        Assert.assertEquals((Object)plc_caCSb_deviceName, (Object)item_.getPlc_caCSb_deviceName());
        Assert.assertEquals((long)plc_caEnableBrakes_bitNumero, (long)item_.getPlc_caEnableBrakes_bitNumero());
        Assert.assertEquals((long)plc_caEnableBrakes_byteNumero, (long)item_.getPlc_caEnableBrakes_byteNumero());
        Assert.assertEquals((Object)plc_caEnableBrakes_deviceName, (Object)item_.getPlc_caEnableBrakes_deviceName());
        Assert.assertEquals((long)plc_caEnableRotation_bitNumero, (long)item_.getPlc_caEnableRotation_bitNumero());
        Assert.assertEquals((long)plc_caEnableRotation_byteNumero, (long)item_.getPlc_caEnableRotation_byteNumero());
        Assert.assertEquals((Object)plc_caEnableRotation_deviceName, (Object)item_.getPlc_caEnableRotation_deviceName());
        Assert.assertEquals((long)plc_caEnableShutter_bitNumero, (long)item_.getPlc_caEnableShutter_bitNumero());
        Assert.assertEquals((long)plc_caEnableShutter_byteNumero, (long)item_.getPlc_caEnableShutter_byteNumero());
        Assert.assertEquals((Object)plc_caEnableShutter_deviceName, (Object)item_.getPlc_caEnableShutter_deviceName());
        Assert.assertEquals((long)plc_caEnableUnclamp_bitNumero, (long)item_.getPlc_caEnableUnclamp_bitNumero());
        Assert.assertEquals((long)plc_caEnableUnclamp_byteNumero, (long)item_.getPlc_caEnableUnclamp_byteNumero());
        Assert.assertEquals((Object)plc_caEnableUnclamp_deviceName, (Object)item_.getPlc_caEnableUnclamp_deviceName());
        Assert.assertEquals((long)plc_caEng_bitNumero, (long)item_.getPlc_caEng_bitNumero());
        Assert.assertEquals((long)plc_caEng_byteNumero, (long)item_.getPlc_caEng_byteNumero());
        Assert.assertEquals((Object)plc_caEng_deviceName, (Object)item_.getPlc_caEng_deviceName());
        Assert.assertEquals((long)plc_caEngb_bitNumero, (long)item_.getPlc_caEngb_bitNumero());
        Assert.assertEquals((long)plc_caEngb_byteNumero, (long)item_.getPlc_caEngb_byteNumero());
        Assert.assertEquals((Object)plc_caEngb_deviceName, (Object)item_.getPlc_caEngb_deviceName());
        Assert.assertEquals((long)plc_caLockout_bitNumero, (long)item_.getPlc_caLockout_bitNumero());
        Assert.assertEquals((long)plc_caLockout_byteNumero, (long)item_.getPlc_caLockout_byteNumero());
        Assert.assertEquals((Object)plc_caLockout_deviceName, (Object)item_.getPlc_caLockout_deviceName());
        Assert.assertEquals((long)plc_caLockoutb_bitNumero, (long)item_.getPlc_caLockoutb_bitNumero());
        Assert.assertEquals((long)plc_caLockoutb_byteNumero, (long)item_.getPlc_caLockoutb_byteNumero());
        Assert.assertEquals((Object)plc_caLockoutb_deviceName, (Object)item_.getPlc_caLockoutb_deviceName());
        Assert.assertEquals((long)plc_caShutterInactive_bitNumero, (long)item_.getPlc_caShutterInactive_bitNumero());
        Assert.assertEquals((long)plc_caShutterInactive_byteNumero, (long)item_.getPlc_caShutterInactive_byteNumero());
        Assert.assertEquals((Object)plc_caShutterInactive_deviceName, (Object)item_.getPlc_caShutterInactive_deviceName());
        Assert.assertEquals((long)plc_caSleep_bitNumero, (long)item_.getPlc_caSleep_bitNumero());
        Assert.assertEquals((long)plc_caSleep_byteNumero, (long)item_.getPlc_caSleep_byteNumero());
        Assert.assertEquals((Object)plc_caSleep_deviceName, (Object)item_.getPlc_caSleep_deviceName());
        Assert.assertEquals((long)plc_enableShutterInterlock_bitNumero, (long)item_.getPlc_enableShutterInterlock_bitNumero());
        Assert.assertEquals((long)plc_enableShutterInterlock_byteNumero, (long)item_.getPlc_enableShutterInterlock_byteNumero());
        Assert.assertEquals((Object)plc_enableShutterInterlock_deviceName, (Object)item_.getPlc_enableShutterInterlock_deviceName());
        Assert.assertEquals((long)plc_okDI_bitNumero, (long)item_.getPlc_okDI_bitNumero());
        Assert.assertEquals((long)plc_okDI_byteNumero, (long)item_.getPlc_okDI_byteNumero());
        Assert.assertEquals((Object)plc_okDI_deviceName, (Object)item_.getPlc_okDI_deviceName());
        Assert.assertEquals((long)plc_okDIsafety_bitNumero, (long)item_.getPlc_okDIsafety_bitNumero());
        Assert.assertEquals((long)plc_okDIsafety_byteNumero, (long)item_.getPlc_okDIsafety_byteNumero());
        Assert.assertEquals((Object)plc_okDIsafety_deviceName, (Object)item_.getPlc_okDIsafety_deviceName());
        Assert.assertEquals((long)plc_powerSave_bitNumero, (long)item_.getPlc_powerSave_bitNumero());
        Assert.assertEquals((long)plc_powerSave_byteNumero, (long)item_.getPlc_powerSave_byteNumero());
        Assert.assertEquals((Object)plc_powerSave_deviceName, (Object)item_.getPlc_powerSave_deviceName());
        Assert.assertEquals((long)plc_tpCheckRotation_bitNumero, (long)item_.getPlc_tpCheckRotation_bitNumero());
        Assert.assertEquals((long)plc_tpCheckRotation_byteNumero, (long)item_.getPlc_tpCheckRotation_byteNumero());
        Assert.assertEquals((Object)plc_tpCheckRotation_deviceName, (Object)item_.getPlc_tpCheckRotation_deviceName());
        Assert.assertEquals((long)plc_tpStopRotation_bitNumero, (long)item_.getPlc_tpStopRotation_bitNumero());
        Assert.assertEquals((long)plc_tpStopRotation_byteNumero, (long)item_.getPlc_tpStopRotation_byteNumero());
        Assert.assertEquals((Object)plc_tpStopRotation_deviceName, (Object)item_.getPlc_tpStopRotation_deviceName());
        Assert.assertEquals((long)plc_tpStopUnclamp_bitNumero, (long)item_.getPlc_tpStopUnclamp_bitNumero());
        Assert.assertEquals((long)plc_tpStopUnclamp_byteNumero, (long)item_.getPlc_tpStopUnclamp_byteNumero());
        Assert.assertEquals((Object)plc_tpStopUnclamp_deviceName, (Object)item_.getPlc_tpStopUnclamp_deviceName());
        Assert.assertEquals((Object)socket1_clampXminus1_filterPresenceXminus1_deviceName, (Object)item_.getSocket1_clampXminus1_filterPresenceXminus1_deviceName());
        Assert.assertEquals((Object)socket1_clampXminus1_lockSensorXminus1_deviceName, (Object)item_.getSocket1_clampXminus1_lockSensorXminus1_deviceName());
        Assert.assertEquals((Object)socket1_clampXplus1_filterPresenceXplus1_deviceName, (Object)item_.getSocket1_clampXplus1_filterPresenceXplus1_deviceName());
        Assert.assertEquals((Object)socket1_clampXplus1_lockSensorXplus1_deviceName, (Object)item_.getSocket1_clampXplus1_lockSensorXplus1_deviceName());
        Assert.assertEquals((Object)socket1_ioModuleSensor1_deviceName, (Object)item_.getSocket1_ioModuleSensor1_deviceName());
        Assert.assertEquals((Object)socket2_clampXminus2_filterPresenceXminus2_deviceName, (Object)item_.getSocket2_clampXminus2_filterPresenceXminus2_deviceName());
        Assert.assertEquals((Object)socket2_clampXminus2_lockSensorXminus2_deviceName, (Object)item_.getSocket2_clampXminus2_lockSensorXminus2_deviceName());
        Assert.assertEquals((Object)socket2_clampXplus2_filterPresenceXplus2_deviceName, (Object)item_.getSocket2_clampXplus2_filterPresenceXplus2_deviceName());
        Assert.assertEquals((Object)socket2_clampXplus2_lockSensorXplus2_deviceName, (Object)item_.getSocket2_clampXplus2_lockSensorXplus2_deviceName());
        Assert.assertEquals((Object)socket2_ioModuleSensor2_deviceName, (Object)item_.getSocket2_ioModuleSensor2_deviceName());
        Assert.assertEquals((Object)socket3_clampXminus3_filterPresenceXminus3_deviceName, (Object)item_.getSocket3_clampXminus3_filterPresenceXminus3_deviceName());
        Assert.assertEquals((Object)socket3_clampXminus3_lockSensorXminus3_deviceName, (Object)item_.getSocket3_clampXminus3_lockSensorXminus3_deviceName());
        Assert.assertEquals((Object)socket3_clampXplus3_filterPresenceXplus3_deviceName, (Object)item_.getSocket3_clampXplus3_filterPresenceXplus3_deviceName());
        Assert.assertEquals((Object)socket3_clampXplus3_lockSensorXplus3_deviceName, (Object)item_.getSocket3_clampXplus3_lockSensorXplus3_deviceName());
        Assert.assertEquals((Object)socket3_ioModuleSensor3_deviceName, (Object)item_.getSocket3_ioModuleSensor3_deviceName());
        Assert.assertEquals((Object)socket4_clampXminus4_filterPresenceXminus4_deviceName, (Object)item_.getSocket4_clampXminus4_filterPresenceXminus4_deviceName());
        Assert.assertEquals((Object)socket4_clampXminus4_lockSensorXminus4_deviceName, (Object)item_.getSocket4_clampXminus4_lockSensorXminus4_deviceName());
        Assert.assertEquals((Object)socket4_clampXplus4_filterPresenceXplus4_deviceName, (Object)item_.getSocket4_clampXplus4_filterPresenceXplus4_deviceName());
        Assert.assertEquals((Object)socket4_clampXplus4_lockSensorXplus4_deviceName, (Object)item_.getSocket4_clampXplus4_lockSensorXplus4_deviceName());
        Assert.assertEquals((Object)socket4_ioModuleSensor4_deviceName, (Object)item_.getSocket4_ioModuleSensor4_deviceName());
        Assert.assertEquals((Object)socket5_clampXminus5_filterPresenceXminus5_deviceName, (Object)item_.getSocket5_clampXminus5_filterPresenceXminus5_deviceName());
        Assert.assertEquals((Object)socket5_clampXminus5_lockSensorXminus5_deviceName, (Object)item_.getSocket5_clampXminus5_lockSensorXminus5_deviceName());
        Assert.assertEquals((Object)socket5_clampXplus5_filterPresenceXplus5_deviceName, (Object)item_.getSocket5_clampXplus5_filterPresenceXplus5_deviceName());
        Assert.assertEquals((Object)socket5_clampXplus5_lockSensorXplus5_deviceName, (Object)item_.getSocket5_clampXplus5_lockSensorXplus5_deviceName());
        Assert.assertEquals((Object)socket5_ioModuleSensor5_deviceName, (Object)item_.getSocket5_ioModuleSensor5_deviceName());
    }

    @Test
    public void sendReceiveFcs_FilterIdentificator_sensorConfigurationEvent() throws Exception {
        String version = "g";
        int filteridsensor0_byteNumero = 330;
        String filteridsensor0_dioName = "";
        int filteridsensor0_inputNumero = 853;
        int filteridsensor1_byteNumero = 727;
        String filteridsensor1_dioName = "w";
        int filteridsensor1_inputNumero = 871;
        int filteridsensor2_byteNumero = 638;
        String filteridsensor2_dioName = "";
        int filteridsensor2_inputNumero = 920;
        int filteridsensor3_byteNumero = 83;
        String filteridsensor3_dioName = "m";
        int filteridsensor3_inputNumero = 738;
        int filteridsensor4_byteNumero = 18;
        String filteridsensor4_dioName = "";
        int filteridsensor4_inputNumero = 644;
        int filteridsensor5_byteNumero = 943;
        String filteridsensor5_dioName = "";
        int filteridsensor5_inputNumero = 306;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_FilterIdentificator_sensorConfigurationEvent(version, filteridsensor0_byteNumero, filteridsensor0_dioName, filteridsensor0_inputNumero, filteridsensor1_byteNumero, filteridsensor1_dioName, filteridsensor1_inputNumero, filteridsensor2_byteNumero, filteridsensor2_dioName, filteridsensor2_inputNumero, filteridsensor3_byteNumero, filteridsensor3_dioName, filteridsensor3_inputNumero, filteridsensor4_byteNumero, filteridsensor4_dioName, filteridsensor4_inputNumero, filteridsensor5_byteNumero, filteridsensor5_dioName, filteridsensor5_inputNumero));
        Assert.assertTrue((boolean)(item instanceof Fcs_FilterIdentificator_sensorConfigurationEvent));
        Fcs_FilterIdentificator_sensorConfigurationEvent item_ = (Fcs_FilterIdentificator_sensorConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)filteridsensor0_byteNumero, (long)item_.getFilteridsensor0_byteNumero());
        Assert.assertEquals((Object)filteridsensor0_dioName, (Object)item_.getFilteridsensor0_dioName());
        Assert.assertEquals((long)filteridsensor0_inputNumero, (long)item_.getFilteridsensor0_inputNumero());
        Assert.assertEquals((long)filteridsensor1_byteNumero, (long)item_.getFilteridsensor1_byteNumero());
        Assert.assertEquals((Object)filteridsensor1_dioName, (Object)item_.getFilteridsensor1_dioName());
        Assert.assertEquals((long)filteridsensor1_inputNumero, (long)item_.getFilteridsensor1_inputNumero());
        Assert.assertEquals((long)filteridsensor2_byteNumero, (long)item_.getFilteridsensor2_byteNumero());
        Assert.assertEquals((Object)filteridsensor2_dioName, (Object)item_.getFilteridsensor2_dioName());
        Assert.assertEquals((long)filteridsensor2_inputNumero, (long)item_.getFilteridsensor2_inputNumero());
        Assert.assertEquals((long)filteridsensor3_byteNumero, (long)item_.getFilteridsensor3_byteNumero());
        Assert.assertEquals((Object)filteridsensor3_dioName, (Object)item_.getFilteridsensor3_dioName());
        Assert.assertEquals((long)filteridsensor3_inputNumero, (long)item_.getFilteridsensor3_inputNumero());
        Assert.assertEquals((long)filteridsensor4_byteNumero, (long)item_.getFilteridsensor4_byteNumero());
        Assert.assertEquals((Object)filteridsensor4_dioName, (Object)item_.getFilteridsensor4_dioName());
        Assert.assertEquals((long)filteridsensor4_inputNumero, (long)item_.getFilteridsensor4_inputNumero());
        Assert.assertEquals((long)filteridsensor5_byteNumero, (long)item_.getFilteridsensor5_byteNumero());
        Assert.assertEquals((Object)filteridsensor5_dioName, (Object)item_.getFilteridsensor5_dioName());
        Assert.assertEquals((long)filteridsensor5_inputNumero, (long)item_.getFilteridsensor5_inputNumero());
    }

    @Test
    public void sendReceiveFcs_FilterManager_filterConfigurationEvent() throws Exception {
        String version = "";
        String a_family = "";
        int a_filterID = 337;
        double a_weight = 0.5641963481903076;
        String da1_family = "";
        int da1_filterID = 211;
        double da1_weight = 0.571884f;
        String da2_family = "q";
        int da2_filterID = 548;
        double da2_weight = 0.4654986262321472;
        String dr1_family = "h";
        int dr1_filterID = 183;
        double dr1_weight = 0.03492170572280884;
        String du1_family = "";
        int du1_filterID = 595;
        double du1_weight = 0.7130911350250244;
        String du2_family = "d";
        int du2_filterID = 260;
        double du2_weight = 0.26536011695861816;
        String dz1_family = "";
        int dz1_filterID = 661;
        double dz1_weight = 0.7553856372833252;
        String ef_family = "x";
        int ef_filterID = 417;
        double ef_weight = 0.845430314540863;
        String f15_family = "h";
        int f15_filterID = 590;
        double f15_weight = 0.28811997175216675;
        String f17_family = "t";
        int f17_filterID = 632;
        double f17_weight = 0.08606314659118652;
        String f29_family = "";
        int f29_filterID = 45;
        double f29_weight = 0.07689392566680908;
        String f34_family = "";
        int f34_filterID = 332;
        double f34_weight = 0.5407761931419373;
        String f3_family = "";
        int f3_filterID = 457;
        double f3_weight = 0.3226267099380493;
        String f46_family = "";
        int f46_filterID = 242;
        double f46_weight = 0.11408644914627075;
        String f48_family = "v";
        int f48_filterID = 955;
        double f48_weight = 0.7493444085121155;
        String f60_family = "";
        int f60_filterID = 943;
        double f60_weight = 0.11200529336929321;
        String g_family = "g";
        int g_filterID = 980;
        double g_weight = 0.9316699504852295;
        String i_family = "";
        int i_filterID = 612;
        double i_weight = 0.2814931273460388;
        String oa_family = "";
        int oa_filterID = 715;
        double oa_weight = 0.9741061329841614;
        String ob_family = "b";
        int ob_filterID = 296;
        double ob_weight = 0.4640123248100281;
        String oc_family = "c";
        int oc_filterID = 387;
        double oc_weight = 0.42520612478256226;
        String ph_family = "q";
        int ph_filterID = 866;
        double ph_weight = 0.4066761f;
        String r_family = "";
        int r_filterID = 157;
        double r_weight = 0.5160966515541077;
        String tu_family = "";
        int tu_filterID = 706;
        double tu_weight = 0.6460506916046143;
        String ty_family = "d";
        int ty_filterID = 672;
        double ty_weight = 0.6867908239364624;
        String u_family = "l";
        int u_filterID = 457;
        double u_weight = 0.4088412f;
        String y_family = "";
        int y_filterID = 232;
        double y_weight = 0.4539481997489929;
        String z_family = "";
        int z_filterID = 697;
        double z_weight = 0.9477828145027161;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_FilterManager_filterConfigurationEvent(version, a_family, a_filterID, a_weight, da1_family, da1_filterID, da1_weight, da2_family, da2_filterID, da2_weight, dr1_family, dr1_filterID, dr1_weight, du1_family, du1_filterID, du1_weight, du2_family, du2_filterID, du2_weight, dz1_family, dz1_filterID, dz1_weight, ef_family, ef_filterID, ef_weight, f15_family, f15_filterID, f15_weight, f17_family, f17_filterID, f17_weight, f29_family, f29_filterID, f29_weight, f34_family, f34_filterID, f34_weight, f3_family, f3_filterID, f3_weight, f46_family, f46_filterID, f46_weight, f48_family, f48_filterID, f48_weight, f60_family, f60_filterID, f60_weight, g_family, g_filterID, g_weight, i_family, i_filterID, i_weight, oa_family, oa_filterID, oa_weight, ob_family, ob_filterID, ob_weight, oc_family, oc_filterID, oc_weight, ph_family, ph_filterID, ph_weight, r_family, r_filterID, r_weight, tu_family, tu_filterID, tu_weight, ty_family, ty_filterID, ty_weight, u_family, u_filterID, u_weight, y_family, y_filterID, y_weight, z_family, z_filterID, z_weight));
        Assert.assertTrue((boolean)(item instanceof Fcs_FilterManager_filterConfigurationEvent));
        Fcs_FilterManager_filterConfigurationEvent item_ = (Fcs_FilterManager_filterConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)a_family, (Object)item_.getA_family());
        Assert.assertEquals((long)a_filterID, (long)item_.getA_filterID());
        Assert.assertEquals((double)a_weight, (double)item_.getA_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)da1_family, (Object)item_.getDa1_family());
        Assert.assertEquals((long)da1_filterID, (long)item_.getDa1_filterID());
        Assert.assertEquals((double)da1_weight, (double)item_.getDa1_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)da2_family, (Object)item_.getDa2_family());
        Assert.assertEquals((long)da2_filterID, (long)item_.getDa2_filterID());
        Assert.assertEquals((double)da2_weight, (double)item_.getDa2_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)dr1_family, (Object)item_.getDr1_family());
        Assert.assertEquals((long)dr1_filterID, (long)item_.getDr1_filterID());
        Assert.assertEquals((double)dr1_weight, (double)item_.getDr1_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)du1_family, (Object)item_.getDu1_family());
        Assert.assertEquals((long)du1_filterID, (long)item_.getDu1_filterID());
        Assert.assertEquals((double)du1_weight, (double)item_.getDu1_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)du2_family, (Object)item_.getDu2_family());
        Assert.assertEquals((long)du2_filterID, (long)item_.getDu2_filterID());
        Assert.assertEquals((double)du2_weight, (double)item_.getDu2_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)dz1_family, (Object)item_.getDz1_family());
        Assert.assertEquals((long)dz1_filterID, (long)item_.getDz1_filterID());
        Assert.assertEquals((double)dz1_weight, (double)item_.getDz1_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)ef_family, (Object)item_.getEf_family());
        Assert.assertEquals((long)ef_filterID, (long)item_.getEf_filterID());
        Assert.assertEquals((double)ef_weight, (double)item_.getEf_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)f15_family, (Object)item_.getF15_family());
        Assert.assertEquals((long)f15_filterID, (long)item_.getF15_filterID());
        Assert.assertEquals((double)f15_weight, (double)item_.getF15_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)f17_family, (Object)item_.getF17_family());
        Assert.assertEquals((long)f17_filterID, (long)item_.getF17_filterID());
        Assert.assertEquals((double)f17_weight, (double)item_.getF17_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)f29_family, (Object)item_.getF29_family());
        Assert.assertEquals((long)f29_filterID, (long)item_.getF29_filterID());
        Assert.assertEquals((double)f29_weight, (double)item_.getF29_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)f34_family, (Object)item_.getF34_family());
        Assert.assertEquals((long)f34_filterID, (long)item_.getF34_filterID());
        Assert.assertEquals((double)f34_weight, (double)item_.getF34_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)f3_family, (Object)item_.getF3_family());
        Assert.assertEquals((long)f3_filterID, (long)item_.getF3_filterID());
        Assert.assertEquals((double)f3_weight, (double)item_.getF3_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)f46_family, (Object)item_.getF46_family());
        Assert.assertEquals((long)f46_filterID, (long)item_.getF46_filterID());
        Assert.assertEquals((double)f46_weight, (double)item_.getF46_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)f48_family, (Object)item_.getF48_family());
        Assert.assertEquals((long)f48_filterID, (long)item_.getF48_filterID());
        Assert.assertEquals((double)f48_weight, (double)item_.getF48_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)f60_family, (Object)item_.getF60_family());
        Assert.assertEquals((long)f60_filterID, (long)item_.getF60_filterID());
        Assert.assertEquals((double)f60_weight, (double)item_.getF60_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)g_family, (Object)item_.getG_family());
        Assert.assertEquals((long)g_filterID, (long)item_.getG_filterID());
        Assert.assertEquals((double)g_weight, (double)item_.getG_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)i_family, (Object)item_.getI_family());
        Assert.assertEquals((long)i_filterID, (long)item_.getI_filterID());
        Assert.assertEquals((double)i_weight, (double)item_.getI_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)oa_family, (Object)item_.getOa_family());
        Assert.assertEquals((long)oa_filterID, (long)item_.getOa_filterID());
        Assert.assertEquals((double)oa_weight, (double)item_.getOa_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)ob_family, (Object)item_.getOb_family());
        Assert.assertEquals((long)ob_filterID, (long)item_.getOb_filterID());
        Assert.assertEquals((double)ob_weight, (double)item_.getOb_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)oc_family, (Object)item_.getOc_family());
        Assert.assertEquals((long)oc_filterID, (long)item_.getOc_filterID());
        Assert.assertEquals((double)oc_weight, (double)item_.getOc_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)ph_family, (Object)item_.getPh_family());
        Assert.assertEquals((long)ph_filterID, (long)item_.getPh_filterID());
        Assert.assertEquals((double)ph_weight, (double)item_.getPh_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)r_family, (Object)item_.getR_family());
        Assert.assertEquals((long)r_filterID, (long)item_.getR_filterID());
        Assert.assertEquals((double)r_weight, (double)item_.getR_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)tu_family, (Object)item_.getTu_family());
        Assert.assertEquals((long)tu_filterID, (long)item_.getTu_filterID());
        Assert.assertEquals((double)tu_weight, (double)item_.getTu_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)ty_family, (Object)item_.getTy_family());
        Assert.assertEquals((long)ty_filterID, (long)item_.getTy_filterID());
        Assert.assertEquals((double)ty_weight, (double)item_.getTy_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)u_family, (Object)item_.getU_family());
        Assert.assertEquals((long)u_filterID, (long)item_.getU_filterID());
        Assert.assertEquals((double)u_weight, (double)item_.getU_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)y_family, (Object)item_.getY_family());
        Assert.assertEquals((long)y_filterID, (long)item_.getY_filterID());
        Assert.assertEquals((double)y_weight, (double)item_.getY_weight(), (double)1.0E-6f);
        Assert.assertEquals((Object)z_family, (Object)item_.getZ_family());
        Assert.assertEquals((long)z_filterID, (long)item_.getZ_filterID());
        Assert.assertEquals((double)z_weight, (double)item_.getZ_weight(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_Loader_loaderConfigurationEvent() throws Exception {
        String version = "s";
        int carrier_deltaPosition = 721;
        int carrier_engagedPosition = 356;
        int carrier_handoffPosition = 80;
        int carrier_highAcceleration = 870;
        int carrier_highDeceleration = 804;
        int carrier_highSpeed = 379;
        int carrier_lowAcceleration = 943;
        int carrier_lowDeceleration = 231;
        int carrier_lowSpeed = 937;
        int carrier_maxCurrent = 420;
        int carrier_maxSpeed = 980;
        int carrier_storagePosition = 113;
        long carrier_timeoutForGoingToEngaged = 547L;
        long carrier_timeoutForGoingToHandOff = 961L;
        long carrier_timeoutForGoingToStorage = 371L;
        int filterDistanceMin = 974;
        int hooks_absolutePositionToClose = 502;
        int hooks_currentThreshold = 39;
        int hooks_currentToClamp = 182;
        int hooks_currentToOpen = 244;
        int hooks_minClampedVoltage = 229;
        int hooks_relativePositionToUnclamp = 878;
        int hooks_timeoutForClampingHooks = 859;
        int hooks_timeoutForClosingHooks = 834;
        int hooks_timeoutForOpeningHooks = 753;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Loader_loaderConfigurationEvent(version, carrier_deltaPosition, carrier_engagedPosition, carrier_handoffPosition, carrier_highAcceleration, carrier_highDeceleration, carrier_highSpeed, carrier_lowAcceleration, carrier_lowDeceleration, carrier_lowSpeed, carrier_maxCurrent, carrier_maxSpeed, carrier_storagePosition, carrier_timeoutForGoingToEngaged, carrier_timeoutForGoingToHandOff, carrier_timeoutForGoingToStorage, filterDistanceMin, hooks_absolutePositionToClose, hooks_currentThreshold, hooks_currentToClamp, hooks_currentToOpen, hooks_minClampedVoltage, hooks_relativePositionToUnclamp, hooks_timeoutForClampingHooks, hooks_timeoutForClosingHooks, hooks_timeoutForOpeningHooks));
        Assert.assertTrue((boolean)(item instanceof Fcs_Loader_loaderConfigurationEvent));
        Fcs_Loader_loaderConfigurationEvent item_ = (Fcs_Loader_loaderConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)carrier_deltaPosition, (long)item_.getCarrier_deltaPosition());
        Assert.assertEquals((long)carrier_engagedPosition, (long)item_.getCarrier_engagedPosition());
        Assert.assertEquals((long)carrier_handoffPosition, (long)item_.getCarrier_handoffPosition());
        Assert.assertEquals((long)carrier_highAcceleration, (long)item_.getCarrier_highAcceleration());
        Assert.assertEquals((long)carrier_highDeceleration, (long)item_.getCarrier_highDeceleration());
        Assert.assertEquals((long)carrier_highSpeed, (long)item_.getCarrier_highSpeed());
        Assert.assertEquals((long)carrier_lowAcceleration, (long)item_.getCarrier_lowAcceleration());
        Assert.assertEquals((long)carrier_lowDeceleration, (long)item_.getCarrier_lowDeceleration());
        Assert.assertEquals((long)carrier_lowSpeed, (long)item_.getCarrier_lowSpeed());
        Assert.assertEquals((long)carrier_maxCurrent, (long)item_.getCarrier_maxCurrent());
        Assert.assertEquals((long)carrier_maxSpeed, (long)item_.getCarrier_maxSpeed());
        Assert.assertEquals((long)carrier_storagePosition, (long)item_.getCarrier_storagePosition());
        Assert.assertEquals((long)carrier_timeoutForGoingToEngaged, (long)item_.getCarrier_timeoutForGoingToEngaged());
        Assert.assertEquals((long)carrier_timeoutForGoingToHandOff, (long)item_.getCarrier_timeoutForGoingToHandOff());
        Assert.assertEquals((long)carrier_timeoutForGoingToStorage, (long)item_.getCarrier_timeoutForGoingToStorage());
        Assert.assertEquals((long)filterDistanceMin, (long)item_.getFilterDistanceMin());
        Assert.assertEquals((long)hooks_absolutePositionToClose, (long)item_.getHooks_absolutePositionToClose());
        Assert.assertEquals((long)hooks_currentThreshold, (long)item_.getHooks_currentThreshold());
        Assert.assertEquals((long)hooks_currentToClamp, (long)item_.getHooks_currentToClamp());
        Assert.assertEquals((long)hooks_currentToOpen, (long)item_.getHooks_currentToOpen());
        Assert.assertEquals((long)hooks_minClampedVoltage, (long)item_.getHooks_minClampedVoltage());
        Assert.assertEquals((long)hooks_relativePositionToUnclamp, (long)item_.getHooks_relativePositionToUnclamp());
        Assert.assertEquals((long)hooks_timeoutForClampingHooks, (long)item_.getHooks_timeoutForClampingHooks());
        Assert.assertEquals((long)hooks_timeoutForClosingHooks, (long)item_.getHooks_timeoutForClosingHooks());
        Assert.assertEquals((long)hooks_timeoutForOpeningHooks, (long)item_.getHooks_timeoutForOpeningHooks());
    }

    @Test
    public void sendReceiveFcs_Loader_readRateConfigurationEvent() throws Exception {
        String version = "j";
        int carrier_readSensorsRate = 729;
        int hooks_readSensorsRate = 28;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Loader_readRateConfigurationEvent(version, carrier_readSensorsRate, hooks_readSensorsRate));
        Assert.assertTrue((boolean)(item instanceof Fcs_Loader_readRateConfigurationEvent));
        Fcs_Loader_readRateConfigurationEvent item_ = (Fcs_Loader_readRateConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)carrier_readSensorsRate, (long)item_.getCarrier_readSensorsRate());
        Assert.assertEquals((long)hooks_readSensorsRate, (long)item_.getHooks_readSensorsRate());
    }

    @Test
    public void sendReceiveFcs_Loader_sensorConfigurationEvent() throws Exception {
        String version = "d";
        int carrier_loaderEngagedSensors_loaderEngagedPositionSensor0_byteNumero = 324;
        String carrier_loaderEngagedSensors_loaderEngagedPositionSensor0_dioName = "";
        int carrier_loaderEngagedSensors_loaderEngagedPositionSensor0_inputNumero = 176;
        int carrier_loaderEngagedSensors_loaderEngagedPositionSensor1_byteNumero = 245;
        String carrier_loaderEngagedSensors_loaderEngagedPositionSensor1_dioName = "h";
        int carrier_loaderEngagedSensors_loaderEngagedPositionSensor1_inputNumero = 762;
        int carrier_loaderHandoffSensors_loaderHandoffPositionSensor0_byteNumero = 777;
        String carrier_loaderHandoffSensors_loaderHandoffPositionSensor0_dioName = "";
        int carrier_loaderHandoffSensors_loaderHandoffPositionSensor0_inputNumero = 994;
        int carrier_loaderHandoffSensors_loaderHandoffPositionSensor1_byteNumero = 10;
        String carrier_loaderHandoffSensors_loaderHandoffPositionSensor1_dioName = "e";
        int carrier_loaderHandoffSensors_loaderHandoffPositionSensor1_inputNumero = 822;
        int carrier_loaderStorageSensors_loaderStoragePositionSensor0_byteNumero = 751;
        String carrier_loaderStorageSensors_loaderStoragePositionSensor0_dioName = "s";
        int carrier_loaderStorageSensors_loaderStoragePositionSensor0_inputNumero = 315;
        int carrier_loaderStorageSensors_loaderStoragePositionSensor1_byteNumero = 277;
        String carrier_loaderStorageSensors_loaderStoragePositionSensor1_dioName = "x";
        int carrier_loaderStorageSensors_loaderStoragePositionSensor1_inputNumero = 949;
        int hooks_clampedStatusSensor_byteNumero = 535;
        String hooks_clampedStatusSensor_dioName = "u";
        int hooks_clampedStatusSensor_inputNumero = 285;
        int hooks_forceSensor0_byteNumero = 968;
        String hooks_forceSensor0_deviceName = "";
        int hooks_forceSensor1_byteNumero = 736;
        String hooks_forceSensor1_deviceName = "";
        int hooks_hook1_loaderCloseSensor1_byteNumero = 759;
        String hooks_hook1_loaderCloseSensor1_dioName = "k";
        int hooks_hook1_loaderCloseSensor1_inputNumero = 36;
        int hooks_hook1_loaderOpenSensor1_byteNumero = 965;
        String hooks_hook1_loaderOpenSensor1_dioName = "";
        int hooks_hook1_loaderOpenSensor1_inputNumero = 234;
        int hooks_hook2_loaderCloseSensor2_byteNumero = 539;
        String hooks_hook2_loaderCloseSensor2_dioName = "";
        int hooks_hook2_loaderCloseSensor2_inputNumero = 93;
        int hooks_hook2_loaderOpenSensor2_byteNumero = 249;
        String hooks_hook2_loaderOpenSensor2_dioName = "s";
        int hooks_hook2_loaderOpenSensor2_inputNumero = 965;
        int hooks_hook3_loaderCloseSensor3_byteNumero = 620;
        String hooks_hook3_loaderCloseSensor3_dioName = "";
        int hooks_hook3_loaderCloseSensor3_inputNumero = 301;
        int hooks_hook3_loaderOpenSensor3_byteNumero = 449;
        String hooks_hook3_loaderOpenSensor3_dioName = "";
        int hooks_hook3_loaderOpenSensor3_inputNumero = 543;
        int hooks_hook4_loaderCloseSensor4_byteNumero = 965;
        String hooks_hook4_loaderCloseSensor4_dioName = "";
        int hooks_hook4_loaderCloseSensor4_inputNumero = 16;
        int hooks_hook4_loaderOpenSensor4_byteNumero = 744;
        String hooks_hook4_loaderOpenSensor4_dioName = "f";
        int hooks_hook4_loaderOpenSensor4_inputNumero = 523;
        int hooks_overClampedStatusSensor_byteNumero = 713;
        String hooks_overClampedStatusSensor_dioName = "";
        int hooks_overClampedStatusSensor_inputNumero = 144;
        int hooks_unclampedStatusSensor_byteNumero = 433;
        String hooks_unclampedStatusSensor_dioName = "r";
        int hooks_unclampedStatusSensor_inputNumero = 106;
        int hooks_underClampedStatusSensor_byteNumero = 329;
        String hooks_underClampedStatusSensor_dioName = "";
        int hooks_underClampedStatusSensor_inputNumero = 517;
        int plc_Loader_LPS_LPS_0_byteNumero = 708;
        String plc_Loader_LPS_LPS_0_dioName = "q";
        int plc_Loader_LPS_LPS_0_inputNumero = 186;
        int plc_Loader_LPS_LPS_1_byteNumero = 833;
        String plc_Loader_LPS_LPS_1_dioName = "";
        int plc_Loader_LPS_LPS_1_inputNumero = 180;
        int plc_Loader_LRH_LRH_0_byteNumero = 111;
        String plc_Loader_LRH_LRH_0_dioName = "j";
        int plc_Loader_LRH_LRH_0_inputNumero = 792;
        int plc_Loader_LRH_LRH_1_byteNumero = 733;
        String plc_Loader_LRH_LRH_1_dioName = "x";
        int plc_Loader_LRH_LRH_1_inputNumero = 894;
        int plc_acAF0_acAF0b_byteNumero = 954;
        String plc_acAF0_acAF0b_dioName = "";
        int plc_acAF0_acAF0b_inputNumero = 307;
        int plc_acAF0_acAF0s_byteNumero = 874;
        String plc_acAF0_acAF0s_dioName = "";
        int plc_acAF0_acAF0s_inputNumero = 838;
        int plc_acAF1_acAF1b_byteNumero = 918;
        String plc_acAF1_acAF1b_dioName = "t";
        int plc_acAF1_acAF1b_inputNumero = 751;
        int plc_acAF1_acAF1s_byteNumero = 138;
        String plc_acAF1_acAF1s_dioName = "";
        int plc_acAF1_acAF1s_inputNumero = 605;
        int plc_acAF3_acAF3b_byteNumero = 473;
        String plc_acAF3_acAF3b_dioName = "";
        int plc_acAF3_acAF3b_inputNumero = 51;
        int plc_acAF3_acAF3s_byteNumero = 452;
        String plc_acAF3_acAF3s_dioName = "";
        int plc_acAF3_acAF3s_inputNumero = 605;
        int plc_acAP2_acAP2b_byteNumero = 978;
        String plc_acAP2_acAP2b_dioName = "";
        int plc_acAP2_acAP2b_inputNumero = 344;
        int plc_acAP2_acAP2s_byteNumero = 732;
        String plc_acAP2_acAP2s_dioName = "n";
        int plc_acAP2_acAP2s_inputNumero = 988;
        int plc_keyEngSensors_keyEng_byteNumero = 602;
        String plc_keyEngSensors_keyEng_dioName = "z";
        int plc_keyEngSensors_keyEng_inputNumero = 15;
        int plc_keyEngSensors_keyEngb_byteNumero = 44;
        String plc_keyEngSensors_keyEngb_dioName = "";
        int plc_keyEngSensors_keyEngb_inputNumero = 89;
        int plc_keyLockSensors_keyLock_byteNumero = 753;
        String plc_keyLockSensors_keyLock_dioName = "n";
        int plc_keyLockSensors_keyLock_inputNumero = 108;
        int plc_keyLockSensors_keyLockb_byteNumero = 972;
        String plc_keyLockSensors_keyLockb_dioName = "t";
        int plc_keyLockSensors_keyLockb_inputNumero = 889;
        int plc_loaderCarrierRelayStatus_byteNumero = 428;
        String plc_loaderCarrierRelayStatus_dioName = "";
        int plc_loaderCarrierRelayStatus_inputNumero = 496;
        int plc_loaderChainPresenceSensor_byteNumero = 420;
        String plc_loaderChainPresenceSensor_dioName = "";
        int plc_loaderChainPresenceSensor_inputNumero = 507;
        int plc_loaderDefaultStatus_byteNumero = 442;
        String plc_loaderDefaultStatus_dioName = "c";
        int plc_loaderDefaultStatus_inputNumero = 684;
        int plc_loaderFilterDistanceSensor_byteNumero = 232;
        String plc_loaderFilterDistanceSensor_deviceName = "g";
        int plc_loaderFilterGoodPositionStatus_byteNumero = 974;
        String plc_loaderFilterGoodPositionStatus_dioName = "";
        int plc_loaderFilterGoodPositionStatus_inputNumero = 424;
        int plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor0_byteNumero = 188;
        String plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor0_dioName = "r";
        int plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor0_inputNumero = 40;
        int plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor1_byteNumero = 144;
        String plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor1_dioName = "u";
        int plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor1_inputNumero = 990;
        int plc_loaderHooksRelayStatus_byteNumero = 257;
        String plc_loaderHooksRelayStatus_dioName = "h";
        int plc_loaderHooksRelayStatus_inputNumero = 982;
        int plc_loaderOnCameraSensors_loaderOnCameraSensor0_byteNumero = 282;
        String plc_loaderOnCameraSensors_loaderOnCameraSensor0_dioName = "a";
        int plc_loaderOnCameraSensors_loaderOnCameraSensor0_inputNumero = 929;
        int plc_loaderOnCameraSensors_loaderOnCameraSensor1_byteNumero = 306;
        String plc_loaderOnCameraSensors_loaderOnCameraSensor1_dioName = "";
        int plc_loaderOnCameraSensors_loaderOnCameraSensor1_inputNumero = 519;
        int plc_loader_LFD_byteNumero = 496;
        String plc_loader_LFD_dioName = "";
        int plc_loader_LFD_inputNumero = 51;
        int plc_loader_LFS_byteNumero = 895;
        String plc_loader_LFS_dioName = "";
        int plc_loader_LFS_inputNumero = 454;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Loader_sensorConfigurationEvent(version, carrier_loaderEngagedSensors_loaderEngagedPositionSensor0_byteNumero, carrier_loaderEngagedSensors_loaderEngagedPositionSensor0_dioName, carrier_loaderEngagedSensors_loaderEngagedPositionSensor0_inputNumero, carrier_loaderEngagedSensors_loaderEngagedPositionSensor1_byteNumero, carrier_loaderEngagedSensors_loaderEngagedPositionSensor1_dioName, carrier_loaderEngagedSensors_loaderEngagedPositionSensor1_inputNumero, carrier_loaderHandoffSensors_loaderHandoffPositionSensor0_byteNumero, carrier_loaderHandoffSensors_loaderHandoffPositionSensor0_dioName, carrier_loaderHandoffSensors_loaderHandoffPositionSensor0_inputNumero, carrier_loaderHandoffSensors_loaderHandoffPositionSensor1_byteNumero, carrier_loaderHandoffSensors_loaderHandoffPositionSensor1_dioName, carrier_loaderHandoffSensors_loaderHandoffPositionSensor1_inputNumero, carrier_loaderStorageSensors_loaderStoragePositionSensor0_byteNumero, carrier_loaderStorageSensors_loaderStoragePositionSensor0_dioName, carrier_loaderStorageSensors_loaderStoragePositionSensor0_inputNumero, carrier_loaderStorageSensors_loaderStoragePositionSensor1_byteNumero, carrier_loaderStorageSensors_loaderStoragePositionSensor1_dioName, carrier_loaderStorageSensors_loaderStoragePositionSensor1_inputNumero, hooks_clampedStatusSensor_byteNumero, hooks_clampedStatusSensor_dioName, hooks_clampedStatusSensor_inputNumero, hooks_forceSensor0_byteNumero, hooks_forceSensor0_deviceName, hooks_forceSensor1_byteNumero, hooks_forceSensor1_deviceName, hooks_hook1_loaderCloseSensor1_byteNumero, hooks_hook1_loaderCloseSensor1_dioName, hooks_hook1_loaderCloseSensor1_inputNumero, hooks_hook1_loaderOpenSensor1_byteNumero, hooks_hook1_loaderOpenSensor1_dioName, hooks_hook1_loaderOpenSensor1_inputNumero, hooks_hook2_loaderCloseSensor2_byteNumero, hooks_hook2_loaderCloseSensor2_dioName, hooks_hook2_loaderCloseSensor2_inputNumero, hooks_hook2_loaderOpenSensor2_byteNumero, hooks_hook2_loaderOpenSensor2_dioName, hooks_hook2_loaderOpenSensor2_inputNumero, hooks_hook3_loaderCloseSensor3_byteNumero, hooks_hook3_loaderCloseSensor3_dioName, hooks_hook3_loaderCloseSensor3_inputNumero, hooks_hook3_loaderOpenSensor3_byteNumero, hooks_hook3_loaderOpenSensor3_dioName, hooks_hook3_loaderOpenSensor3_inputNumero, hooks_hook4_loaderCloseSensor4_byteNumero, hooks_hook4_loaderCloseSensor4_dioName, hooks_hook4_loaderCloseSensor4_inputNumero, hooks_hook4_loaderOpenSensor4_byteNumero, hooks_hook4_loaderOpenSensor4_dioName, hooks_hook4_loaderOpenSensor4_inputNumero, hooks_overClampedStatusSensor_byteNumero, hooks_overClampedStatusSensor_dioName, hooks_overClampedStatusSensor_inputNumero, hooks_unclampedStatusSensor_byteNumero, hooks_unclampedStatusSensor_dioName, hooks_unclampedStatusSensor_inputNumero, hooks_underClampedStatusSensor_byteNumero, hooks_underClampedStatusSensor_dioName, hooks_underClampedStatusSensor_inputNumero, plc_Loader_LPS_LPS_0_byteNumero, plc_Loader_LPS_LPS_0_dioName, plc_Loader_LPS_LPS_0_inputNumero, plc_Loader_LPS_LPS_1_byteNumero, plc_Loader_LPS_LPS_1_dioName, plc_Loader_LPS_LPS_1_inputNumero, plc_Loader_LRH_LRH_0_byteNumero, plc_Loader_LRH_LRH_0_dioName, plc_Loader_LRH_LRH_0_inputNumero, plc_Loader_LRH_LRH_1_byteNumero, plc_Loader_LRH_LRH_1_dioName, plc_Loader_LRH_LRH_1_inputNumero, plc_acAF0_acAF0b_byteNumero, plc_acAF0_acAF0b_dioName, plc_acAF0_acAF0b_inputNumero, plc_acAF0_acAF0s_byteNumero, plc_acAF0_acAF0s_dioName, plc_acAF0_acAF0s_inputNumero, plc_acAF1_acAF1b_byteNumero, plc_acAF1_acAF1b_dioName, plc_acAF1_acAF1b_inputNumero, plc_acAF1_acAF1s_byteNumero, plc_acAF1_acAF1s_dioName, plc_acAF1_acAF1s_inputNumero, plc_acAF3_acAF3b_byteNumero, plc_acAF3_acAF3b_dioName, plc_acAF3_acAF3b_inputNumero, plc_acAF3_acAF3s_byteNumero, plc_acAF3_acAF3s_dioName, plc_acAF3_acAF3s_inputNumero, plc_acAP2_acAP2b_byteNumero, plc_acAP2_acAP2b_dioName, plc_acAP2_acAP2b_inputNumero, plc_acAP2_acAP2s_byteNumero, plc_acAP2_acAP2s_dioName, plc_acAP2_acAP2s_inputNumero, plc_keyEngSensors_keyEng_byteNumero, plc_keyEngSensors_keyEng_dioName, plc_keyEngSensors_keyEng_inputNumero, plc_keyEngSensors_keyEngb_byteNumero, plc_keyEngSensors_keyEngb_dioName, plc_keyEngSensors_keyEngb_inputNumero, plc_keyLockSensors_keyLock_byteNumero, plc_keyLockSensors_keyLock_dioName, plc_keyLockSensors_keyLock_inputNumero, plc_keyLockSensors_keyLockb_byteNumero, plc_keyLockSensors_keyLockb_dioName, plc_keyLockSensors_keyLockb_inputNumero, plc_loaderCarrierRelayStatus_byteNumero, plc_loaderCarrierRelayStatus_dioName, plc_loaderCarrierRelayStatus_inputNumero, plc_loaderChainPresenceSensor_byteNumero, plc_loaderChainPresenceSensor_dioName, plc_loaderChainPresenceSensor_inputNumero, plc_loaderDefaultStatus_byteNumero, plc_loaderDefaultStatus_dioName, plc_loaderDefaultStatus_inputNumero, plc_loaderFilterDistanceSensor_byteNumero, plc_loaderFilterDistanceSensor_deviceName, plc_loaderFilterGoodPositionStatus_byteNumero, plc_loaderFilterGoodPositionStatus_dioName, plc_loaderFilterGoodPositionStatus_inputNumero, plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor0_byteNumero, plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor0_dioName, plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor0_inputNumero, plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor1_byteNumero, plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor1_dioName, plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor1_inputNumero, plc_loaderHooksRelayStatus_byteNumero, plc_loaderHooksRelayStatus_dioName, plc_loaderHooksRelayStatus_inputNumero, plc_loaderOnCameraSensors_loaderOnCameraSensor0_byteNumero, plc_loaderOnCameraSensors_loaderOnCameraSensor0_dioName, plc_loaderOnCameraSensors_loaderOnCameraSensor0_inputNumero, plc_loaderOnCameraSensors_loaderOnCameraSensor1_byteNumero, plc_loaderOnCameraSensors_loaderOnCameraSensor1_dioName, plc_loaderOnCameraSensors_loaderOnCameraSensor1_inputNumero, plc_loader_LFD_byteNumero, plc_loader_LFD_dioName, plc_loader_LFD_inputNumero, plc_loader_LFS_byteNumero, plc_loader_LFS_dioName, plc_loader_LFS_inputNumero));
        Assert.assertTrue((boolean)(item instanceof Fcs_Loader_sensorConfigurationEvent));
        Fcs_Loader_sensorConfigurationEvent item_ = (Fcs_Loader_sensorConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)carrier_loaderEngagedSensors_loaderEngagedPositionSensor0_byteNumero, (long)item_.getCarrier_loaderEngagedSensors_loaderEngagedPositionSensor0_byteNumero());
        Assert.assertEquals((Object)carrier_loaderEngagedSensors_loaderEngagedPositionSensor0_dioName, (Object)item_.getCarrier_loaderEngagedSensors_loaderEngagedPositionSensor0_dioName());
        Assert.assertEquals((long)carrier_loaderEngagedSensors_loaderEngagedPositionSensor0_inputNumero, (long)item_.getCarrier_loaderEngagedSensors_loaderEngagedPositionSensor0_inputNumero());
        Assert.assertEquals((long)carrier_loaderEngagedSensors_loaderEngagedPositionSensor1_byteNumero, (long)item_.getCarrier_loaderEngagedSensors_loaderEngagedPositionSensor1_byteNumero());
        Assert.assertEquals((Object)carrier_loaderEngagedSensors_loaderEngagedPositionSensor1_dioName, (Object)item_.getCarrier_loaderEngagedSensors_loaderEngagedPositionSensor1_dioName());
        Assert.assertEquals((long)carrier_loaderEngagedSensors_loaderEngagedPositionSensor1_inputNumero, (long)item_.getCarrier_loaderEngagedSensors_loaderEngagedPositionSensor1_inputNumero());
        Assert.assertEquals((long)carrier_loaderHandoffSensors_loaderHandoffPositionSensor0_byteNumero, (long)item_.getCarrier_loaderHandoffSensors_loaderHandoffPositionSensor0_byteNumero());
        Assert.assertEquals((Object)carrier_loaderHandoffSensors_loaderHandoffPositionSensor0_dioName, (Object)item_.getCarrier_loaderHandoffSensors_loaderHandoffPositionSensor0_dioName());
        Assert.assertEquals((long)carrier_loaderHandoffSensors_loaderHandoffPositionSensor0_inputNumero, (long)item_.getCarrier_loaderHandoffSensors_loaderHandoffPositionSensor0_inputNumero());
        Assert.assertEquals((long)carrier_loaderHandoffSensors_loaderHandoffPositionSensor1_byteNumero, (long)item_.getCarrier_loaderHandoffSensors_loaderHandoffPositionSensor1_byteNumero());
        Assert.assertEquals((Object)carrier_loaderHandoffSensors_loaderHandoffPositionSensor1_dioName, (Object)item_.getCarrier_loaderHandoffSensors_loaderHandoffPositionSensor1_dioName());
        Assert.assertEquals((long)carrier_loaderHandoffSensors_loaderHandoffPositionSensor1_inputNumero, (long)item_.getCarrier_loaderHandoffSensors_loaderHandoffPositionSensor1_inputNumero());
        Assert.assertEquals((long)carrier_loaderStorageSensors_loaderStoragePositionSensor0_byteNumero, (long)item_.getCarrier_loaderStorageSensors_loaderStoragePositionSensor0_byteNumero());
        Assert.assertEquals((Object)carrier_loaderStorageSensors_loaderStoragePositionSensor0_dioName, (Object)item_.getCarrier_loaderStorageSensors_loaderStoragePositionSensor0_dioName());
        Assert.assertEquals((long)carrier_loaderStorageSensors_loaderStoragePositionSensor0_inputNumero, (long)item_.getCarrier_loaderStorageSensors_loaderStoragePositionSensor0_inputNumero());
        Assert.assertEquals((long)carrier_loaderStorageSensors_loaderStoragePositionSensor1_byteNumero, (long)item_.getCarrier_loaderStorageSensors_loaderStoragePositionSensor1_byteNumero());
        Assert.assertEquals((Object)carrier_loaderStorageSensors_loaderStoragePositionSensor1_dioName, (Object)item_.getCarrier_loaderStorageSensors_loaderStoragePositionSensor1_dioName());
        Assert.assertEquals((long)carrier_loaderStorageSensors_loaderStoragePositionSensor1_inputNumero, (long)item_.getCarrier_loaderStorageSensors_loaderStoragePositionSensor1_inputNumero());
        Assert.assertEquals((long)hooks_clampedStatusSensor_byteNumero, (long)item_.getHooks_clampedStatusSensor_byteNumero());
        Assert.assertEquals((Object)hooks_clampedStatusSensor_dioName, (Object)item_.getHooks_clampedStatusSensor_dioName());
        Assert.assertEquals((long)hooks_clampedStatusSensor_inputNumero, (long)item_.getHooks_clampedStatusSensor_inputNumero());
        Assert.assertEquals((long)hooks_forceSensor0_byteNumero, (long)item_.getHooks_forceSensor0_byteNumero());
        Assert.assertEquals((Object)hooks_forceSensor0_deviceName, (Object)item_.getHooks_forceSensor0_deviceName());
        Assert.assertEquals((long)hooks_forceSensor1_byteNumero, (long)item_.getHooks_forceSensor1_byteNumero());
        Assert.assertEquals((Object)hooks_forceSensor1_deviceName, (Object)item_.getHooks_forceSensor1_deviceName());
        Assert.assertEquals((long)hooks_hook1_loaderCloseSensor1_byteNumero, (long)item_.getHooks_hook1_loaderCloseSensor1_byteNumero());
        Assert.assertEquals((Object)hooks_hook1_loaderCloseSensor1_dioName, (Object)item_.getHooks_hook1_loaderCloseSensor1_dioName());
        Assert.assertEquals((long)hooks_hook1_loaderCloseSensor1_inputNumero, (long)item_.getHooks_hook1_loaderCloseSensor1_inputNumero());
        Assert.assertEquals((long)hooks_hook1_loaderOpenSensor1_byteNumero, (long)item_.getHooks_hook1_loaderOpenSensor1_byteNumero());
        Assert.assertEquals((Object)hooks_hook1_loaderOpenSensor1_dioName, (Object)item_.getHooks_hook1_loaderOpenSensor1_dioName());
        Assert.assertEquals((long)hooks_hook1_loaderOpenSensor1_inputNumero, (long)item_.getHooks_hook1_loaderOpenSensor1_inputNumero());
        Assert.assertEquals((long)hooks_hook2_loaderCloseSensor2_byteNumero, (long)item_.getHooks_hook2_loaderCloseSensor2_byteNumero());
        Assert.assertEquals((Object)hooks_hook2_loaderCloseSensor2_dioName, (Object)item_.getHooks_hook2_loaderCloseSensor2_dioName());
        Assert.assertEquals((long)hooks_hook2_loaderCloseSensor2_inputNumero, (long)item_.getHooks_hook2_loaderCloseSensor2_inputNumero());
        Assert.assertEquals((long)hooks_hook2_loaderOpenSensor2_byteNumero, (long)item_.getHooks_hook2_loaderOpenSensor2_byteNumero());
        Assert.assertEquals((Object)hooks_hook2_loaderOpenSensor2_dioName, (Object)item_.getHooks_hook2_loaderOpenSensor2_dioName());
        Assert.assertEquals((long)hooks_hook2_loaderOpenSensor2_inputNumero, (long)item_.getHooks_hook2_loaderOpenSensor2_inputNumero());
        Assert.assertEquals((long)hooks_hook3_loaderCloseSensor3_byteNumero, (long)item_.getHooks_hook3_loaderCloseSensor3_byteNumero());
        Assert.assertEquals((Object)hooks_hook3_loaderCloseSensor3_dioName, (Object)item_.getHooks_hook3_loaderCloseSensor3_dioName());
        Assert.assertEquals((long)hooks_hook3_loaderCloseSensor3_inputNumero, (long)item_.getHooks_hook3_loaderCloseSensor3_inputNumero());
        Assert.assertEquals((long)hooks_hook3_loaderOpenSensor3_byteNumero, (long)item_.getHooks_hook3_loaderOpenSensor3_byteNumero());
        Assert.assertEquals((Object)hooks_hook3_loaderOpenSensor3_dioName, (Object)item_.getHooks_hook3_loaderOpenSensor3_dioName());
        Assert.assertEquals((long)hooks_hook3_loaderOpenSensor3_inputNumero, (long)item_.getHooks_hook3_loaderOpenSensor3_inputNumero());
        Assert.assertEquals((long)hooks_hook4_loaderCloseSensor4_byteNumero, (long)item_.getHooks_hook4_loaderCloseSensor4_byteNumero());
        Assert.assertEquals((Object)hooks_hook4_loaderCloseSensor4_dioName, (Object)item_.getHooks_hook4_loaderCloseSensor4_dioName());
        Assert.assertEquals((long)hooks_hook4_loaderCloseSensor4_inputNumero, (long)item_.getHooks_hook4_loaderCloseSensor4_inputNumero());
        Assert.assertEquals((long)hooks_hook4_loaderOpenSensor4_byteNumero, (long)item_.getHooks_hook4_loaderOpenSensor4_byteNumero());
        Assert.assertEquals((Object)hooks_hook4_loaderOpenSensor4_dioName, (Object)item_.getHooks_hook4_loaderOpenSensor4_dioName());
        Assert.assertEquals((long)hooks_hook4_loaderOpenSensor4_inputNumero, (long)item_.getHooks_hook4_loaderOpenSensor4_inputNumero());
        Assert.assertEquals((long)hooks_overClampedStatusSensor_byteNumero, (long)item_.getHooks_overClampedStatusSensor_byteNumero());
        Assert.assertEquals((Object)hooks_overClampedStatusSensor_dioName, (Object)item_.getHooks_overClampedStatusSensor_dioName());
        Assert.assertEquals((long)hooks_overClampedStatusSensor_inputNumero, (long)item_.getHooks_overClampedStatusSensor_inputNumero());
        Assert.assertEquals((long)hooks_unclampedStatusSensor_byteNumero, (long)item_.getHooks_unclampedStatusSensor_byteNumero());
        Assert.assertEquals((Object)hooks_unclampedStatusSensor_dioName, (Object)item_.getHooks_unclampedStatusSensor_dioName());
        Assert.assertEquals((long)hooks_unclampedStatusSensor_inputNumero, (long)item_.getHooks_unclampedStatusSensor_inputNumero());
        Assert.assertEquals((long)hooks_underClampedStatusSensor_byteNumero, (long)item_.getHooks_underClampedStatusSensor_byteNumero());
        Assert.assertEquals((Object)hooks_underClampedStatusSensor_dioName, (Object)item_.getHooks_underClampedStatusSensor_dioName());
        Assert.assertEquals((long)hooks_underClampedStatusSensor_inputNumero, (long)item_.getHooks_underClampedStatusSensor_inputNumero());
        Assert.assertEquals((long)plc_Loader_LPS_LPS_0_byteNumero, (long)item_.getPlc_Loader_LPS_LPS_0_byteNumero());
        Assert.assertEquals((Object)plc_Loader_LPS_LPS_0_dioName, (Object)item_.getPlc_Loader_LPS_LPS_0_dioName());
        Assert.assertEquals((long)plc_Loader_LPS_LPS_0_inputNumero, (long)item_.getPlc_Loader_LPS_LPS_0_inputNumero());
        Assert.assertEquals((long)plc_Loader_LPS_LPS_1_byteNumero, (long)item_.getPlc_Loader_LPS_LPS_1_byteNumero());
        Assert.assertEquals((Object)plc_Loader_LPS_LPS_1_dioName, (Object)item_.getPlc_Loader_LPS_LPS_1_dioName());
        Assert.assertEquals((long)plc_Loader_LPS_LPS_1_inputNumero, (long)item_.getPlc_Loader_LPS_LPS_1_inputNumero());
        Assert.assertEquals((long)plc_Loader_LRH_LRH_0_byteNumero, (long)item_.getPlc_Loader_LRH_LRH_0_byteNumero());
        Assert.assertEquals((Object)plc_Loader_LRH_LRH_0_dioName, (Object)item_.getPlc_Loader_LRH_LRH_0_dioName());
        Assert.assertEquals((long)plc_Loader_LRH_LRH_0_inputNumero, (long)item_.getPlc_Loader_LRH_LRH_0_inputNumero());
        Assert.assertEquals((long)plc_Loader_LRH_LRH_1_byteNumero, (long)item_.getPlc_Loader_LRH_LRH_1_byteNumero());
        Assert.assertEquals((Object)plc_Loader_LRH_LRH_1_dioName, (Object)item_.getPlc_Loader_LRH_LRH_1_dioName());
        Assert.assertEquals((long)plc_Loader_LRH_LRH_1_inputNumero, (long)item_.getPlc_Loader_LRH_LRH_1_inputNumero());
        Assert.assertEquals((long)plc_acAF0_acAF0b_byteNumero, (long)item_.getPlc_acAF0_acAF0b_byteNumero());
        Assert.assertEquals((Object)plc_acAF0_acAF0b_dioName, (Object)item_.getPlc_acAF0_acAF0b_dioName());
        Assert.assertEquals((long)plc_acAF0_acAF0b_inputNumero, (long)item_.getPlc_acAF0_acAF0b_inputNumero());
        Assert.assertEquals((long)plc_acAF0_acAF0s_byteNumero, (long)item_.getPlc_acAF0_acAF0s_byteNumero());
        Assert.assertEquals((Object)plc_acAF0_acAF0s_dioName, (Object)item_.getPlc_acAF0_acAF0s_dioName());
        Assert.assertEquals((long)plc_acAF0_acAF0s_inputNumero, (long)item_.getPlc_acAF0_acAF0s_inputNumero());
        Assert.assertEquals((long)plc_acAF1_acAF1b_byteNumero, (long)item_.getPlc_acAF1_acAF1b_byteNumero());
        Assert.assertEquals((Object)plc_acAF1_acAF1b_dioName, (Object)item_.getPlc_acAF1_acAF1b_dioName());
        Assert.assertEquals((long)plc_acAF1_acAF1b_inputNumero, (long)item_.getPlc_acAF1_acAF1b_inputNumero());
        Assert.assertEquals((long)plc_acAF1_acAF1s_byteNumero, (long)item_.getPlc_acAF1_acAF1s_byteNumero());
        Assert.assertEquals((Object)plc_acAF1_acAF1s_dioName, (Object)item_.getPlc_acAF1_acAF1s_dioName());
        Assert.assertEquals((long)plc_acAF1_acAF1s_inputNumero, (long)item_.getPlc_acAF1_acAF1s_inputNumero());
        Assert.assertEquals((long)plc_acAF3_acAF3b_byteNumero, (long)item_.getPlc_acAF3_acAF3b_byteNumero());
        Assert.assertEquals((Object)plc_acAF3_acAF3b_dioName, (Object)item_.getPlc_acAF3_acAF3b_dioName());
        Assert.assertEquals((long)plc_acAF3_acAF3b_inputNumero, (long)item_.getPlc_acAF3_acAF3b_inputNumero());
        Assert.assertEquals((long)plc_acAF3_acAF3s_byteNumero, (long)item_.getPlc_acAF3_acAF3s_byteNumero());
        Assert.assertEquals((Object)plc_acAF3_acAF3s_dioName, (Object)item_.getPlc_acAF3_acAF3s_dioName());
        Assert.assertEquals((long)plc_acAF3_acAF3s_inputNumero, (long)item_.getPlc_acAF3_acAF3s_inputNumero());
        Assert.assertEquals((long)plc_acAP2_acAP2b_byteNumero, (long)item_.getPlc_acAP2_acAP2b_byteNumero());
        Assert.assertEquals((Object)plc_acAP2_acAP2b_dioName, (Object)item_.getPlc_acAP2_acAP2b_dioName());
        Assert.assertEquals((long)plc_acAP2_acAP2b_inputNumero, (long)item_.getPlc_acAP2_acAP2b_inputNumero());
        Assert.assertEquals((long)plc_acAP2_acAP2s_byteNumero, (long)item_.getPlc_acAP2_acAP2s_byteNumero());
        Assert.assertEquals((Object)plc_acAP2_acAP2s_dioName, (Object)item_.getPlc_acAP2_acAP2s_dioName());
        Assert.assertEquals((long)plc_acAP2_acAP2s_inputNumero, (long)item_.getPlc_acAP2_acAP2s_inputNumero());
        Assert.assertEquals((long)plc_keyEngSensors_keyEng_byteNumero, (long)item_.getPlc_keyEngSensors_keyEng_byteNumero());
        Assert.assertEquals((Object)plc_keyEngSensors_keyEng_dioName, (Object)item_.getPlc_keyEngSensors_keyEng_dioName());
        Assert.assertEquals((long)plc_keyEngSensors_keyEng_inputNumero, (long)item_.getPlc_keyEngSensors_keyEng_inputNumero());
        Assert.assertEquals((long)plc_keyEngSensors_keyEngb_byteNumero, (long)item_.getPlc_keyEngSensors_keyEngb_byteNumero());
        Assert.assertEquals((Object)plc_keyEngSensors_keyEngb_dioName, (Object)item_.getPlc_keyEngSensors_keyEngb_dioName());
        Assert.assertEquals((long)plc_keyEngSensors_keyEngb_inputNumero, (long)item_.getPlc_keyEngSensors_keyEngb_inputNumero());
        Assert.assertEquals((long)plc_keyLockSensors_keyLock_byteNumero, (long)item_.getPlc_keyLockSensors_keyLock_byteNumero());
        Assert.assertEquals((Object)plc_keyLockSensors_keyLock_dioName, (Object)item_.getPlc_keyLockSensors_keyLock_dioName());
        Assert.assertEquals((long)plc_keyLockSensors_keyLock_inputNumero, (long)item_.getPlc_keyLockSensors_keyLock_inputNumero());
        Assert.assertEquals((long)plc_keyLockSensors_keyLockb_byteNumero, (long)item_.getPlc_keyLockSensors_keyLockb_byteNumero());
        Assert.assertEquals((Object)plc_keyLockSensors_keyLockb_dioName, (Object)item_.getPlc_keyLockSensors_keyLockb_dioName());
        Assert.assertEquals((long)plc_keyLockSensors_keyLockb_inputNumero, (long)item_.getPlc_keyLockSensors_keyLockb_inputNumero());
        Assert.assertEquals((long)plc_loaderCarrierRelayStatus_byteNumero, (long)item_.getPlc_loaderCarrierRelayStatus_byteNumero());
        Assert.assertEquals((Object)plc_loaderCarrierRelayStatus_dioName, (Object)item_.getPlc_loaderCarrierRelayStatus_dioName());
        Assert.assertEquals((long)plc_loaderCarrierRelayStatus_inputNumero, (long)item_.getPlc_loaderCarrierRelayStatus_inputNumero());
        Assert.assertEquals((long)plc_loaderChainPresenceSensor_byteNumero, (long)item_.getPlc_loaderChainPresenceSensor_byteNumero());
        Assert.assertEquals((Object)plc_loaderChainPresenceSensor_dioName, (Object)item_.getPlc_loaderChainPresenceSensor_dioName());
        Assert.assertEquals((long)plc_loaderChainPresenceSensor_inputNumero, (long)item_.getPlc_loaderChainPresenceSensor_inputNumero());
        Assert.assertEquals((long)plc_loaderDefaultStatus_byteNumero, (long)item_.getPlc_loaderDefaultStatus_byteNumero());
        Assert.assertEquals((Object)plc_loaderDefaultStatus_dioName, (Object)item_.getPlc_loaderDefaultStatus_dioName());
        Assert.assertEquals((long)plc_loaderDefaultStatus_inputNumero, (long)item_.getPlc_loaderDefaultStatus_inputNumero());
        Assert.assertEquals((long)plc_loaderFilterDistanceSensor_byteNumero, (long)item_.getPlc_loaderFilterDistanceSensor_byteNumero());
        Assert.assertEquals((Object)plc_loaderFilterDistanceSensor_deviceName, (Object)item_.getPlc_loaderFilterDistanceSensor_deviceName());
        Assert.assertEquals((long)plc_loaderFilterGoodPositionStatus_byteNumero, (long)item_.getPlc_loaderFilterGoodPositionStatus_byteNumero());
        Assert.assertEquals((Object)plc_loaderFilterGoodPositionStatus_dioName, (Object)item_.getPlc_loaderFilterGoodPositionStatus_dioName());
        Assert.assertEquals((long)plc_loaderFilterGoodPositionStatus_inputNumero, (long)item_.getPlc_loaderFilterGoodPositionStatus_inputNumero());
        Assert.assertEquals((long)plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor0_byteNumero, (long)item_.getPlc_loaderFilterPresenceSensors_loaderFilterPresenceSensor0_byteNumero());
        Assert.assertEquals((Object)plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor0_dioName, (Object)item_.getPlc_loaderFilterPresenceSensors_loaderFilterPresenceSensor0_dioName());
        Assert.assertEquals((long)plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor0_inputNumero, (long)item_.getPlc_loaderFilterPresenceSensors_loaderFilterPresenceSensor0_inputNumero());
        Assert.assertEquals((long)plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor1_byteNumero, (long)item_.getPlc_loaderFilterPresenceSensors_loaderFilterPresenceSensor1_byteNumero());
        Assert.assertEquals((Object)plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor1_dioName, (Object)item_.getPlc_loaderFilterPresenceSensors_loaderFilterPresenceSensor1_dioName());
        Assert.assertEquals((long)plc_loaderFilterPresenceSensors_loaderFilterPresenceSensor1_inputNumero, (long)item_.getPlc_loaderFilterPresenceSensors_loaderFilterPresenceSensor1_inputNumero());
        Assert.assertEquals((long)plc_loaderHooksRelayStatus_byteNumero, (long)item_.getPlc_loaderHooksRelayStatus_byteNumero());
        Assert.assertEquals((Object)plc_loaderHooksRelayStatus_dioName, (Object)item_.getPlc_loaderHooksRelayStatus_dioName());
        Assert.assertEquals((long)plc_loaderHooksRelayStatus_inputNumero, (long)item_.getPlc_loaderHooksRelayStatus_inputNumero());
        Assert.assertEquals((long)plc_loaderOnCameraSensors_loaderOnCameraSensor0_byteNumero, (long)item_.getPlc_loaderOnCameraSensors_loaderOnCameraSensor0_byteNumero());
        Assert.assertEquals((Object)plc_loaderOnCameraSensors_loaderOnCameraSensor0_dioName, (Object)item_.getPlc_loaderOnCameraSensors_loaderOnCameraSensor0_dioName());
        Assert.assertEquals((long)plc_loaderOnCameraSensors_loaderOnCameraSensor0_inputNumero, (long)item_.getPlc_loaderOnCameraSensors_loaderOnCameraSensor0_inputNumero());
        Assert.assertEquals((long)plc_loaderOnCameraSensors_loaderOnCameraSensor1_byteNumero, (long)item_.getPlc_loaderOnCameraSensors_loaderOnCameraSensor1_byteNumero());
        Assert.assertEquals((Object)plc_loaderOnCameraSensors_loaderOnCameraSensor1_dioName, (Object)item_.getPlc_loaderOnCameraSensors_loaderOnCameraSensor1_dioName());
        Assert.assertEquals((long)plc_loaderOnCameraSensors_loaderOnCameraSensor1_inputNumero, (long)item_.getPlc_loaderOnCameraSensors_loaderOnCameraSensor1_inputNumero());
        Assert.assertEquals((long)plc_loader_LFD_byteNumero, (long)item_.getPlc_loader_LFD_byteNumero());
        Assert.assertEquals((Object)plc_loader_LFD_dioName, (Object)item_.getPlc_loader_LFD_dioName());
        Assert.assertEquals((long)plc_loader_LFD_inputNumero, (long)item_.getPlc_loader_LFD_inputNumero());
        Assert.assertEquals((long)plc_loader_LFS_byteNumero, (long)item_.getPlc_loader_LFS_byteNumero());
        Assert.assertEquals((Object)plc_loader_LFS_dioName, (Object)item_.getPlc_loader_LFS_dioName());
        Assert.assertEquals((long)plc_loader_LFS_inputNumero, (long)item_.getPlc_loader_LFS_inputNumero());
    }

    @Test
    public void sendReceiveFcs_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "a";
        int schedulers_default_nTasks = 5;
        int schedulers_default_nThreads = 102;
        int schedulers_monitor_update_publish_scheduler_nTasks = 378;
        int schedulers_monitor_update_publish_scheduler_nThreads = 447;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Fcs_PeriodicTasks_GeneralConfigurationEvent));
        Fcs_PeriodicTasks_GeneralConfigurationEvent item_ = (Fcs_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveFcs_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "";
        long agentmonitorservice_taskPeriodMillis = 896L;
        long heartbeat_taskPeriodMillis = 180L;
        long main_checkControllers_taskPeriodMillis = 598L;
        long main_updateGui_taskPeriodMillis = 323L;
        long monitor_check_taskPeriodMillis = 693L;
        long monitor_publish_taskPeriodMillis = 639L;
        long monitor_update_taskPeriodMillis = 599L;
        long runtimeinfo_taskPeriodMillis = 212L;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, main_checkControllers_taskPeriodMillis, main_updateGui_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Fcs_PeriodicTasks_timersConfigurationEvent));
        Fcs_PeriodicTasks_timersConfigurationEvent item_ = (Fcs_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)main_checkControllers_taskPeriodMillis, (long)item_.getMain_checkControllers_taskPeriodMillis());
        Assert.assertEquals((long)main_updateGui_taskPeriodMillis, (long)item_.getMain_updateGui_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveFcs_Seneca1_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Seneca1_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Fcs_Seneca1_DevicesConfigurationEvent));
        Fcs_Seneca1_DevicesConfigurationEvent item_ = (Fcs_Seneca1_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveFcs_Seneca2_DevicesConfigurationEvent() throws Exception {
        String version = "a";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_Seneca2_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Fcs_Seneca2_DevicesConfigurationEvent));
        Fcs_Seneca2_DevicesConfigurationEvent item_ = (Fcs_Seneca2_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveShutter_GeneralConfigurationEvent() throws Exception {
        String version = "z";
        double controller_centeringSpeed = 0.8244085907936096;
        String controller_localAMSaddr = "c";
        double controller_maxHallPositionError = 0.07694637775421143;
        double controller_maxStrokeSpeed = 0.31527024507522583;
        String controller_minExposureTime = "";
        String controller_noticeReaderRestartDelay = "j";
        String controller_noticeReaderStartupDelay = "";
        String controller_plcAMSaddr = "";
        String controller_plcAckTimeout = "l";
        String controller_plcIPaddr = "";
        String controller_referenceMinusXpositions = "";
        String controller_referencePlusXpositions = "";
        String controller_safeCtrlTempRange = "";
        String controller_safeRtdTempRange = "";
        int periodictasks_schedulers_default_nTasks = 588;
        int periodictasks_schedulers_default_nThreads = 967;
        String publisher_configurationName = "q";
        String publisher_publicationInterval = "";
        String statemachine_resetSyncTimeout = "";
        String statemachine_taskRestartDelay = "";
        String watchdog_checkInterval = "";
        SALEvent item = this.testSendReceive((SALEvent)new Shutter_GeneralConfigurationEvent(version, controller_centeringSpeed, controller_localAMSaddr, controller_maxHallPositionError, controller_maxStrokeSpeed, controller_minExposureTime, controller_noticeReaderRestartDelay, controller_noticeReaderStartupDelay, controller_plcAMSaddr, controller_plcAckTimeout, controller_plcIPaddr, controller_referenceMinusXpositions, controller_referencePlusXpositions, controller_safeCtrlTempRange, controller_safeRtdTempRange, periodictasks_schedulers_default_nTasks, periodictasks_schedulers_default_nThreads, publisher_configurationName, publisher_publicationInterval, statemachine_resetSyncTimeout, statemachine_taskRestartDelay, watchdog_checkInterval));
        Assert.assertTrue((boolean)(item instanceof Shutter_GeneralConfigurationEvent));
        Shutter_GeneralConfigurationEvent item_ = (Shutter_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)controller_centeringSpeed, (double)item_.getController_centeringSpeed(), (double)1.0E-6f);
        Assert.assertEquals((Object)controller_localAMSaddr, (Object)item_.getController_localAMSaddr());
        Assert.assertEquals((double)controller_maxHallPositionError, (double)item_.getController_maxHallPositionError(), (double)1.0E-6f);
        Assert.assertEquals((double)controller_maxStrokeSpeed, (double)item_.getController_maxStrokeSpeed(), (double)1.0E-6f);
        Assert.assertEquals((Object)controller_minExposureTime, (Object)item_.getController_minExposureTime());
        Assert.assertEquals((Object)controller_noticeReaderRestartDelay, (Object)item_.getController_noticeReaderRestartDelay());
        Assert.assertEquals((Object)controller_noticeReaderStartupDelay, (Object)item_.getController_noticeReaderStartupDelay());
        Assert.assertEquals((Object)controller_plcAMSaddr, (Object)item_.getController_plcAMSaddr());
        Assert.assertEquals((Object)controller_plcAckTimeout, (Object)item_.getController_plcAckTimeout());
        Assert.assertEquals((Object)controller_plcIPaddr, (Object)item_.getController_plcIPaddr());
        Assert.assertEquals((Object)controller_referenceMinusXpositions, (Object)item_.getController_referenceMinusXpositions());
        Assert.assertEquals((Object)controller_referencePlusXpositions, (Object)item_.getController_referencePlusXpositions());
        Assert.assertEquals((Object)controller_safeCtrlTempRange, (Object)item_.getController_safeCtrlTempRange());
        Assert.assertEquals((Object)controller_safeRtdTempRange, (Object)item_.getController_safeRtdTempRange());
        Assert.assertEquals((long)periodictasks_schedulers_default_nTasks, (long)item_.getPeriodictasks_schedulers_default_nTasks());
        Assert.assertEquals((long)periodictasks_schedulers_default_nThreads, (long)item_.getPeriodictasks_schedulers_default_nThreads());
        Assert.assertEquals((Object)publisher_configurationName, (Object)item_.getPublisher_configurationName());
        Assert.assertEquals((Object)publisher_publicationInterval, (Object)item_.getPublisher_publicationInterval());
        Assert.assertEquals((Object)statemachine_resetSyncTimeout, (Object)item_.getStatemachine_resetSyncTimeout());
        Assert.assertEquals((Object)statemachine_taskRestartDelay, (Object)item_.getStatemachine_taskRestartDelay());
        Assert.assertEquals((Object)watchdog_checkInterval, (Object)item_.getWatchdog_checkInterval());
    }

    @Test
    public void sendReceiveShutter_timersConfigurationEvent() throws Exception {
        String version = "x";
        long periodictasks_agentMonitorService_taskPeriodMillis = 683L;
        long periodictasks_heartbeat_taskPeriodMillis = 51L;
        long periodictasks_runtimeInfo_taskPeriodMillis = 259L;
        SALEvent item = this.testSendReceive((SALEvent)new Shutter_timersConfigurationEvent(version, periodictasks_agentMonitorService_taskPeriodMillis, periodictasks_heartbeat_taskPeriodMillis, periodictasks_runtimeInfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Shutter_timersConfigurationEvent));
        Shutter_timersConfigurationEvent item_ = (Shutter_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)periodictasks_agentMonitorService_taskPeriodMillis, (long)item_.getPeriodictasks_agentMonitorService_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_heartbeat_taskPeriodMillis, (long)item_.getPeriodictasks_heartbeat_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_runtimeInfo_taskPeriodMillis, (long)item_.getPeriodictasks_runtimeInfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveChiller_DeviceConfigurationEvent() throws Exception {
        String version = "x";
        String maq20_node = "";
        String maq20_serials = "w";
        String pluto_node = "g";
        SALEvent item = this.testSendReceive((SALEvent)new Chiller_DeviceConfigurationEvent(version, maq20_node, maq20_serials, pluto_node));
        Assert.assertTrue((boolean)(item instanceof Chiller_DeviceConfigurationEvent));
        Chiller_DeviceConfigurationEvent item_ = (Chiller_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)pluto_node, (Object)item_.getPluto_node());
    }

    @Test
    public void sendReceiveChiller_DevicesConfigurationEvent() throws Exception {
        String version = "b";
        boolean chiller_disabled = false;
        boolean maq20_disabled = false;
        boolean pluto_disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Chiller_DevicesConfigurationEvent(version, chiller_disabled, maq20_disabled, pluto_disabled));
        Assert.assertTrue((boolean)(item instanceof Chiller_DevicesConfigurationEvent));
        Chiller_DevicesConfigurationEvent item_ = (Chiller_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)chiller_disabled, (Object)item_.isChiller_disabled());
        Assert.assertEquals((Object)maq20_disabled, (Object)item_.isMaq20_disabled());
        Assert.assertEquals((Object)pluto_disabled, (Object)item_.isPluto_disabled());
    }

    @Test
    public void sendReceiveChiller_GeneralConfigurationEvent() throws Exception {
        String version = "c";
        String chilleralertlistener_thermalAlertSource = "";
        String chilleralertlistener_vacuumAlertSource = "e";
        String chiller_host = "e";
        String coldplateChannelPath = "a";
        boolean glycolCooling = false;
        String listenTo = "";
        String maq20_GlycHeatXfer_flowChanPath = "";
        String maq20_GlycHeatXfer_inletTChanPath = "e";
        String maq20_GlycHeatXfer_outletTChanPath = "l";
        double maxPressure = 0.5851067304611206;
        int periodictasks_schedulers_default_nTasks = 489;
        int periodictasks_schedulers_default_nThreads = 573;
        int periodictasks_schedulers_monitor_check_scheduler_nTasks = 693;
        int periodictasks_schedulers_monitor_check_scheduler_nThreads = 121;
        int periodictasks_schedulers_monitor_update_publish_scheduler_nTasks = 441;
        int periodictasks_schedulers_monitor_update_publish_scheduler_nThreads = 578;
        double temperatureTimeoutFactor = 0.4411519169807434;
        SALEvent item = this.testSendReceive((SALEvent)new Chiller_GeneralConfigurationEvent(version, chilleralertlistener_thermalAlertSource, chilleralertlistener_vacuumAlertSource, chiller_host, coldplateChannelPath, glycolCooling, listenTo, maq20_GlycHeatXfer_flowChanPath, maq20_GlycHeatXfer_inletTChanPath, maq20_GlycHeatXfer_outletTChanPath, maxPressure, periodictasks_schedulers_default_nTasks, periodictasks_schedulers_default_nThreads, periodictasks_schedulers_monitor_check_scheduler_nTasks, periodictasks_schedulers_monitor_check_scheduler_nThreads, periodictasks_schedulers_monitor_update_publish_scheduler_nTasks, periodictasks_schedulers_monitor_update_publish_scheduler_nThreads, temperatureTimeoutFactor));
        Assert.assertTrue((boolean)(item instanceof Chiller_GeneralConfigurationEvent));
        Chiller_GeneralConfigurationEvent item_ = (Chiller_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)chilleralertlistener_thermalAlertSource, (Object)item_.getChilleralertlistener_thermalAlertSource());
        Assert.assertEquals((Object)chilleralertlistener_vacuumAlertSource, (Object)item_.getChilleralertlistener_vacuumAlertSource());
        Assert.assertEquals((Object)chiller_host, (Object)item_.getChiller_host());
        Assert.assertEquals((Object)coldplateChannelPath, (Object)item_.getColdplateChannelPath());
        Assert.assertEquals((Object)glycolCooling, (Object)item_.isGlycolCooling());
        Assert.assertEquals((Object)listenTo, (Object)item_.getListenTo());
        Assert.assertEquals((Object)maq20_GlycHeatXfer_flowChanPath, (Object)item_.getMaq20_GlycHeatXfer_flowChanPath());
        Assert.assertEquals((Object)maq20_GlycHeatXfer_inletTChanPath, (Object)item_.getMaq20_GlycHeatXfer_inletTChanPath());
        Assert.assertEquals((Object)maq20_GlycHeatXfer_outletTChanPath, (Object)item_.getMaq20_GlycHeatXfer_outletTChanPath());
        Assert.assertEquals((double)maxPressure, (double)item_.getMaxPressure(), (double)1.0E-6f);
        Assert.assertEquals((long)periodictasks_schedulers_default_nTasks, (long)item_.getPeriodictasks_schedulers_default_nTasks());
        Assert.assertEquals((long)periodictasks_schedulers_default_nThreads, (long)item_.getPeriodictasks_schedulers_default_nThreads());
        Assert.assertEquals((long)periodictasks_schedulers_monitor_check_scheduler_nTasks, (long)item_.getPeriodictasks_schedulers_monitor_check_scheduler_nTasks());
        Assert.assertEquals((long)periodictasks_schedulers_monitor_check_scheduler_nThreads, (long)item_.getPeriodictasks_schedulers_monitor_check_scheduler_nThreads());
        Assert.assertEquals((long)periodictasks_schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getPeriodictasks_schedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)periodictasks_schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getPeriodictasks_schedulers_monitor_update_publish_scheduler_nThreads());
        Assert.assertEquals((double)temperatureTimeoutFactor, (double)item_.getTemperatureTimeoutFactor(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveChiller_LimitsConfigurationEvent() throws Exception {
        String version = "x";
        double chiller_TempDUTInput_warnHi = 0.14494377374649048;
        double chiller_TempDUTInput_limitHi = 0.7514247298240662;
        double maq20_PBurstReturn_warnHi = 0.7411676049232483;
        double maq20_PBurstReturn_limitHi = 0.45281195640563965;
        double maq20_PBurstSupply_warnHi = 0.9956294894218445;
        double maq20_PBurstSupply_limitHi = 0.3998481035232544;
        SALEvent item = this.testSendReceive((SALEvent)new Chiller_LimitsConfigurationEvent(version, chiller_TempDUTInput_warnHi, chiller_TempDUTInput_limitHi, maq20_PBurstReturn_warnHi, maq20_PBurstReturn_limitHi, maq20_PBurstSupply_warnHi, maq20_PBurstSupply_limitHi));
        Assert.assertTrue((boolean)(item instanceof Chiller_LimitsConfigurationEvent));
        Chiller_LimitsConfigurationEvent item_ = (Chiller_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)chiller_TempDUTInput_warnHi, (double)item_.getChiller_TempDUTInput_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)chiller_TempDUTInput_limitHi, (double)item_.getChiller_TempDUTInput_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)maq20_PBurstReturn_warnHi, (double)item_.getMaq20_PBurstReturn_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)maq20_PBurstReturn_limitHi, (double)item_.getMaq20_PBurstReturn_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)maq20_PBurstSupply_warnHi, (double)item_.getMaq20_PBurstSupply_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)maq20_PBurstSupply_limitHi, (double)item_.getMaq20_PBurstSupply_limitHi(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveChiller_timersConfigurationEvent() throws Exception {
        String version = "";
        long periodictasks_agentMonitorService_taskPeriodMillis = 226L;
        long periodictasks_checkBurstDiscP_taskPeriodMillis = 598L;
        long periodictasks_checkDataArrival_taskPeriodMillis = 507L;
        long periodictasks_heartbeat_taskPeriodMillis = 739L;
        long periodictasks_monitor_check_Chiller_taskPeriodMillis = 935L;
        long periodictasks_monitor_check_Maq20_taskPeriodMillis = 863L;
        long periodictasks_monitor_check_Pluto_taskPeriodMillis = 346L;
        long periodictasks_monitor_publish_burstDiscs_taskPeriodMillis = 618L;
        long periodictasks_monitor_publish_taskPeriodMillis = 993L;
        long periodictasks_monitor_update_burstDiscs_taskPeriodMillis = 724L;
        long periodictasks_monitor_update_taskPeriodMillis = 221L;
        long periodictasks_publishParams_taskPeriodMillis = 132L;
        long periodictasks_runtimeInfo_taskPeriodMillis = 645L;
        long periodictasks_sendDutTemperature_taskPeriodMillis = 17L;
        long periodictasks_updateCtrlState_taskPeriodMillis = 135L;
        SALEvent item = this.testSendReceive((SALEvent)new Chiller_timersConfigurationEvent(version, periodictasks_agentMonitorService_taskPeriodMillis, periodictasks_checkBurstDiscP_taskPeriodMillis, periodictasks_checkDataArrival_taskPeriodMillis, periodictasks_heartbeat_taskPeriodMillis, periodictasks_monitor_check_Chiller_taskPeriodMillis, periodictasks_monitor_check_Maq20_taskPeriodMillis, periodictasks_monitor_check_Pluto_taskPeriodMillis, periodictasks_monitor_publish_burstDiscs_taskPeriodMillis, periodictasks_monitor_publish_taskPeriodMillis, periodictasks_monitor_update_burstDiscs_taskPeriodMillis, periodictasks_monitor_update_taskPeriodMillis, periodictasks_publishParams_taskPeriodMillis, periodictasks_runtimeInfo_taskPeriodMillis, periodictasks_sendDutTemperature_taskPeriodMillis, periodictasks_updateCtrlState_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Chiller_timersConfigurationEvent));
        Chiller_timersConfigurationEvent item_ = (Chiller_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)periodictasks_agentMonitorService_taskPeriodMillis, (long)item_.getPeriodictasks_agentMonitorService_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_checkBurstDiscP_taskPeriodMillis, (long)item_.getPeriodictasks_checkBurstDiscP_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_checkDataArrival_taskPeriodMillis, (long)item_.getPeriodictasks_checkDataArrival_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_heartbeat_taskPeriodMillis, (long)item_.getPeriodictasks_heartbeat_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_check_Chiller_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_check_Chiller_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_check_Maq20_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_check_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_check_Pluto_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_check_Pluto_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_publish_burstDiscs_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_publish_burstDiscs_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_publish_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_update_burstDiscs_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_update_burstDiscs_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_update_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_update_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_publishParams_taskPeriodMillis, (long)item_.getPeriodictasks_publishParams_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_runtimeInfo_taskPeriodMillis, (long)item_.getPeriodictasks_runtimeInfo_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_sendDutTemperature_taskPeriodMillis, (long)item_.getPeriodictasks_sendDutTemperature_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_updateCtrlState_taskPeriodMillis, (long)item_.getPeriodictasks_updateCtrlState_taskPeriodMillis());
    }

    @Test
    public void sendReceiveThermal_DeviceConfigurationEvent() throws Exception {
        String version = "b";
        String protrtds_node = "";
        String rtds_node = "";
        String rtds_serials = "";
        SALEvent item = this.testSendReceive((SALEvent)new Thermal_DeviceConfigurationEvent(version, protrtds_node, rtds_node, rtds_serials));
        Assert.assertTrue((boolean)(item instanceof Thermal_DeviceConfigurationEvent));
        Thermal_DeviceConfigurationEvent item_ = (Thermal_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)protrtds_node, (Object)item_.getProtrtds_node());
        Assert.assertEquals((Object)rtds_node, (Object)item_.getRtds_node());
        Assert.assertEquals((Object)rtds_serials, (Object)item_.getRtds_serials());
    }

    @Test
    public void sendReceiveThermal_DevicesConfigurationEvent() throws Exception {
        String version = "o";
        boolean protrtds_disabled = true;
        boolean rtds_disabled = false;
        boolean trimpower_disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Thermal_DevicesConfigurationEvent(version, protrtds_disabled, rtds_disabled, trimpower_disabled));
        Assert.assertTrue((boolean)(item instanceof Thermal_DevicesConfigurationEvent));
        Thermal_DevicesConfigurationEvent item_ = (Thermal_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)protrtds_disabled, (Object)item_.isProtrtds_disabled());
        Assert.assertEquals((Object)rtds_disabled, (Object)item_.isRtds_disabled());
        Assert.assertEquals((Object)trimpower_disabled, (Object)item_.isTrimpower_disabled());
    }

    @Test
    public void sendReceiveThermal_GeneralConfigurationEvent() throws Exception {
        String version = "n";
        String cold_Temp_AvgColdTemp_chanNames = "t";
        String cold_Temp_AvgColdTemp_chanWeights = "d";
        boolean cold_Temp_AvgColdTemp_ignoreNaN = true;
        String cryo_Temp_AvgCryoTemp_chanNames = "";
        String cryo_Temp_AvgCryoTemp_chanWeights = "";
        boolean cryo_Temp_AvgCryoTemp_ignoreNaN = false;
        int periodictasks_schedulers_default_nTasks = 353;
        int periodictasks_schedulers_default_nThreads = 737;
        int periodictasks_schedulers_monitor_check_scheduler_nTasks = 911;
        int periodictasks_schedulers_monitor_check_scheduler_nThreads = 69;
        int periodictasks_schedulers_monitor_update_publish_scheduler_nTasks = 803;
        int periodictasks_schedulers_monitor_update_publish_scheduler_nThreads = 13;
        SALEvent item = this.testSendReceive((SALEvent)new Thermal_GeneralConfigurationEvent(version, cold_Temp_AvgColdTemp_chanNames, cold_Temp_AvgColdTemp_chanWeights, cold_Temp_AvgColdTemp_ignoreNaN, cryo_Temp_AvgCryoTemp_chanNames, cryo_Temp_AvgCryoTemp_chanWeights, cryo_Temp_AvgCryoTemp_ignoreNaN, periodictasks_schedulers_default_nTasks, periodictasks_schedulers_default_nThreads, periodictasks_schedulers_monitor_check_scheduler_nTasks, periodictasks_schedulers_monitor_check_scheduler_nThreads, periodictasks_schedulers_monitor_update_publish_scheduler_nTasks, periodictasks_schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Thermal_GeneralConfigurationEvent));
        Thermal_GeneralConfigurationEvent item_ = (Thermal_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)cold_Temp_AvgColdTemp_chanNames, (Object)item_.getCold_Temp_AvgColdTemp_chanNames());
        Assert.assertEquals((Object)cold_Temp_AvgColdTemp_chanWeights, (Object)item_.getCold_Temp_AvgColdTemp_chanWeights());
        Assert.assertEquals((Object)cold_Temp_AvgColdTemp_ignoreNaN, (Object)item_.isCold_Temp_AvgColdTemp_ignoreNaN());
        Assert.assertEquals((Object)cryo_Temp_AvgCryoTemp_chanNames, (Object)item_.getCryo_Temp_AvgCryoTemp_chanNames());
        Assert.assertEquals((Object)cryo_Temp_AvgCryoTemp_chanWeights, (Object)item_.getCryo_Temp_AvgCryoTemp_chanWeights());
        Assert.assertEquals((Object)cryo_Temp_AvgCryoTemp_ignoreNaN, (Object)item_.isCryo_Temp_AvgCryoTemp_ignoreNaN());
        Assert.assertEquals((long)periodictasks_schedulers_default_nTasks, (long)item_.getPeriodictasks_schedulers_default_nTasks());
        Assert.assertEquals((long)periodictasks_schedulers_default_nThreads, (long)item_.getPeriodictasks_schedulers_default_nThreads());
        Assert.assertEquals((long)periodictasks_schedulers_monitor_check_scheduler_nTasks, (long)item_.getPeriodictasks_schedulers_monitor_check_scheduler_nTasks());
        Assert.assertEquals((long)periodictasks_schedulers_monitor_check_scheduler_nThreads, (long)item_.getPeriodictasks_schedulers_monitor_check_scheduler_nThreads());
        Assert.assertEquals((long)periodictasks_schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getPeriodictasks_schedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)periodictasks_schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getPeriodictasks_schedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveThermal_LimitsConfigurationEvent() throws Exception {
        String version = "a";
        double cold_Temp_AvgColdTemp_warnHi = 0.45531415939331055;
        double cold_Temp_AvgColdTemp_warnLo = 0.747342586517334;
        double cold_Temp_AvgColdTemp_limitHi = 0.13618344068527222;
        double cold_Temp_AvgColdTemp_limitLo = 0.4878356456756592;
        double cryo_Temp_AvgCryoTemp_warnHi = 0.5048176050186157;
        double cryo_Temp_AvgCryoTemp_warnLo = 0.5763466358184814;
        double cryo_Temp_AvgCryoTemp_limitHi = 0.5830276608467102;
        double cryo_Temp_AvgCryoTemp_limitLo = 0.18113607168197632;
        String rtdLocation = "";
        double[] rtd_Cold_Temp_warnHi = TestHelper.generateDoubleArray((int)20, (int)-1243080148);
        double[] rtd_Cold_Temp_warnLo = TestHelper.generateDoubleArray((int)20, (int)-279424196);
        double[] rtd_Cold_Temp_limitHi = TestHelper.generateDoubleArray((int)20, (int)-1153483595);
        double[] rtd_Cold_Temp_limitLo = TestHelper.generateDoubleArray((int)20, (int)443264257);
        double[] rtd_Cryo_Temp_warnHi = TestHelper.generateDoubleArray((int)20, (int)510130211);
        double[] rtd_Cryo_Temp_warnLo = TestHelper.generateDoubleArray((int)20, (int)-1927562834);
        double[] rtd_Cryo_Temp_limitHi = TestHelper.generateDoubleArray((int)20, (int)-907288880);
        double[] rtd_Cryo_Temp_limitLo = TestHelper.generateDoubleArray((int)20, (int)-1060291015);
        double[] rtd_Grid_Temp_warnHi = TestHelper.generateDoubleArray((int)20, (int)-1401820683);
        double[] rtd_Grid_Temp_warnLo = TestHelper.generateDoubleArray((int)20, (int)1135631713);
        double[] rtd_Grid_Temp_limitHi = TestHelper.generateDoubleArray((int)20, (int)940738084);
        double[] rtd_Grid_Temp_limitLo = TestHelper.generateDoubleArray((int)20, (int)-287835666);
        String trimLocation = "n";
        double trim_Htrs_ColdTotal_P_warnHi = 0.3942485f;
        double trim_Htrs_ColdTotal_P_warnLo = 0.06861793994903564;
        double trim_Htrs_ColdTotal_P_limitHi = 0.9346742630004883;
        double trim_Htrs_ColdTotal_P_limitLo = 0.6745418310165405;
        double trim_Htrs_CryoTotal_P_warnHi = 0.14120906591415405;
        double trim_Htrs_CryoTotal_P_warnLo = 0.4500460624694824;
        double trim_Htrs_CryoTotal_P_limitHi = 0.7089152932167053;
        double trim_Htrs_CryoTotal_P_limitLo = 0.2076675295829773;
        double trim_Htrs_HtrBulkTmp_warnHi = 0.31833577156066895;
        double trim_Htrs_HtrBulkTmp_warnLo = 0.09148335456848145;
        double trim_Htrs_HtrBulkTmp_limitHi = 0.8739694356918335;
        double trim_Htrs_HtrBulkTmp_limitLo = 0.011934459209442139;
        double trim_Htrs_HtrBulk_I_warnHi = 0.8722001910209656;
        double trim_Htrs_HtrBulk_I_warnLo = 0.13280963897705078;
        double trim_Htrs_HtrBulk_I_limitHi = 0.22874730825424194;
        double trim_Htrs_HtrBulk_I_limitLo = 0.44182825088500977;
        double trim_Htrs_HtrBulk_P_warnHi = 0.4428752064704895;
        double trim_Htrs_HtrBulk_P_warnLo = 0.014871478080749512;
        double trim_Htrs_HtrBulk_P_limitHi = 0.7785090804100037;
        double trim_Htrs_HtrBulk_P_limitLo = 0.2980414628982544;
        double trim_Htrs_HtrBulk_V_warnHi = 0.2342730164527893;
        double trim_Htrs_HtrBulk_V_warnLo = 0.35692495107650757;
        double trim_Htrs_HtrBulk_V_limitHi = 0.005169034004211426;
        double trim_Htrs_HtrBulk_V_limitLo = 0.41407597064971924;
        double trim_Htrs_HtrPsTmp_warnHi = 0.30284178256988525;
        double trim_Htrs_HtrPsTmp_warnLo = 0.3750242590904236;
        double trim_Htrs_HtrPsTmp_limitHi = 0.6544218063354492;
        double trim_Htrs_HtrPsTmp_limitLo = 0.58131343126297;
        double[] trim_Trim_Htrs_I_warnHi = TestHelper.generateDoubleArray((int)12, (int)-2056153858);
        double[] trim_Trim_Htrs_I_warnLo = TestHelper.generateDoubleArray((int)12, (int)-915781716);
        double[] trim_Trim_Htrs_I_limitHi = TestHelper.generateDoubleArray((int)12, (int)2146589880);
        double[] trim_Trim_Htrs_I_limitLo = TestHelper.generateDoubleArray((int)12, (int)-587210825);
        double[] trim_Trim_Htrs_P_warnHi = TestHelper.generateDoubleArray((int)12, (int)-494954250);
        double[] trim_Trim_Htrs_P_warnLo = TestHelper.generateDoubleArray((int)12, (int)-493110618);
        double[] trim_Trim_Htrs_P_limitHi = TestHelper.generateDoubleArray((int)12, (int)-1138849536);
        double[] trim_Trim_Htrs_P_limitLo = TestHelper.generateDoubleArray((int)12, (int)1014981817);
        double[] trim_Trim_Htrs_V_warnHi = TestHelper.generateDoubleArray((int)12, (int)873778424);
        double[] trim_Trim_Htrs_V_warnLo = TestHelper.generateDoubleArray((int)12, (int)-129031295);
        double[] trim_Trim_Htrs_V_limitHi = TestHelper.generateDoubleArray((int)12, (int)1319232619);
        double[] trim_Trim_Htrs_V_limitLo = TestHelper.generateDoubleArray((int)12, (int)389400845);
        SALEvent item = this.testSendReceive((SALEvent)new Thermal_LimitsConfigurationEvent(version, cold_Temp_AvgColdTemp_warnHi, cold_Temp_AvgColdTemp_warnLo, cold_Temp_AvgColdTemp_limitHi, cold_Temp_AvgColdTemp_limitLo, cryo_Temp_AvgCryoTemp_warnHi, cryo_Temp_AvgCryoTemp_warnLo, cryo_Temp_AvgCryoTemp_limitHi, cryo_Temp_AvgCryoTemp_limitLo, rtdLocation, rtd_Cold_Temp_warnHi, rtd_Cold_Temp_warnLo, rtd_Cold_Temp_limitHi, rtd_Cold_Temp_limitLo, rtd_Cryo_Temp_warnHi, rtd_Cryo_Temp_warnLo, rtd_Cryo_Temp_limitHi, rtd_Cryo_Temp_limitLo, rtd_Grid_Temp_warnHi, rtd_Grid_Temp_warnLo, rtd_Grid_Temp_limitHi, rtd_Grid_Temp_limitLo, trimLocation, trim_Htrs_ColdTotal_P_warnHi, trim_Htrs_ColdTotal_P_warnLo, trim_Htrs_ColdTotal_P_limitHi, trim_Htrs_ColdTotal_P_limitLo, trim_Htrs_CryoTotal_P_warnHi, trim_Htrs_CryoTotal_P_warnLo, trim_Htrs_CryoTotal_P_limitHi, trim_Htrs_CryoTotal_P_limitLo, trim_Htrs_HtrBulkTmp_warnHi, trim_Htrs_HtrBulkTmp_warnLo, trim_Htrs_HtrBulkTmp_limitHi, trim_Htrs_HtrBulkTmp_limitLo, trim_Htrs_HtrBulk_I_warnHi, trim_Htrs_HtrBulk_I_warnLo, trim_Htrs_HtrBulk_I_limitHi, trim_Htrs_HtrBulk_I_limitLo, trim_Htrs_HtrBulk_P_warnHi, trim_Htrs_HtrBulk_P_warnLo, trim_Htrs_HtrBulk_P_limitHi, trim_Htrs_HtrBulk_P_limitLo, trim_Htrs_HtrBulk_V_warnHi, trim_Htrs_HtrBulk_V_warnLo, trim_Htrs_HtrBulk_V_limitHi, trim_Htrs_HtrBulk_V_limitLo, trim_Htrs_HtrPsTmp_warnHi, trim_Htrs_HtrPsTmp_warnLo, trim_Htrs_HtrPsTmp_limitHi, trim_Htrs_HtrPsTmp_limitLo, trim_Trim_Htrs_I_warnHi, trim_Trim_Htrs_I_warnLo, trim_Trim_Htrs_I_limitHi, trim_Trim_Htrs_I_limitLo, trim_Trim_Htrs_P_warnHi, trim_Trim_Htrs_P_warnLo, trim_Trim_Htrs_P_limitHi, trim_Trim_Htrs_P_limitLo, trim_Trim_Htrs_V_warnHi, trim_Trim_Htrs_V_warnLo, trim_Trim_Htrs_V_limitHi, trim_Trim_Htrs_V_limitLo));
        Assert.assertTrue((boolean)(item instanceof Thermal_LimitsConfigurationEvent));
        Thermal_LimitsConfigurationEvent item_ = (Thermal_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)cold_Temp_AvgColdTemp_warnHi, (double)item_.getCold_Temp_AvgColdTemp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cold_Temp_AvgColdTemp_warnLo, (double)item_.getCold_Temp_AvgColdTemp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cold_Temp_AvgColdTemp_limitHi, (double)item_.getCold_Temp_AvgColdTemp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cold_Temp_AvgColdTemp_limitLo, (double)item_.getCold_Temp_AvgColdTemp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Temp_AvgCryoTemp_warnHi, (double)item_.getCryo_Temp_AvgCryoTemp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Temp_AvgCryoTemp_warnLo, (double)item_.getCryo_Temp_AvgCryoTemp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Temp_AvgCryoTemp_limitHi, (double)item_.getCryo_Temp_AvgCryoTemp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Temp_AvgCryoTemp_limitLo, (double)item_.getCryo_Temp_AvgCryoTemp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)rtdLocation, (Object)item_.getRtdLocation());
        Assert.assertArrayEquals((double[])rtd_Cold_Temp_warnHi, (double[])item_.getRtd_Cold_Temp_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Cold_Temp_warnLo, (double[])item_.getRtd_Cold_Temp_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Cold_Temp_limitHi, (double[])item_.getRtd_Cold_Temp_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Cold_Temp_limitLo, (double[])item_.getRtd_Cold_Temp_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Cryo_Temp_warnHi, (double[])item_.getRtd_Cryo_Temp_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Cryo_Temp_warnLo, (double[])item_.getRtd_Cryo_Temp_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Cryo_Temp_limitHi, (double[])item_.getRtd_Cryo_Temp_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Cryo_Temp_limitLo, (double[])item_.getRtd_Cryo_Temp_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Grid_Temp_warnHi, (double[])item_.getRtd_Grid_Temp_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Grid_Temp_warnLo, (double[])item_.getRtd_Grid_Temp_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Grid_Temp_limitHi, (double[])item_.getRtd_Grid_Temp_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtd_Grid_Temp_limitLo, (double[])item_.getRtd_Grid_Temp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)trimLocation, (Object)item_.getTrimLocation());
        Assert.assertEquals((double)trim_Htrs_ColdTotal_P_warnHi, (double)item_.getTrim_Htrs_ColdTotal_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_ColdTotal_P_warnLo, (double)item_.getTrim_Htrs_ColdTotal_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_ColdTotal_P_limitHi, (double)item_.getTrim_Htrs_ColdTotal_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_ColdTotal_P_limitLo, (double)item_.getTrim_Htrs_ColdTotal_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_CryoTotal_P_warnHi, (double)item_.getTrim_Htrs_CryoTotal_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_CryoTotal_P_warnLo, (double)item_.getTrim_Htrs_CryoTotal_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_CryoTotal_P_limitHi, (double)item_.getTrim_Htrs_CryoTotal_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_CryoTotal_P_limitLo, (double)item_.getTrim_Htrs_CryoTotal_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulkTmp_warnHi, (double)item_.getTrim_Htrs_HtrBulkTmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulkTmp_warnLo, (double)item_.getTrim_Htrs_HtrBulkTmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulkTmp_limitHi, (double)item_.getTrim_Htrs_HtrBulkTmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulkTmp_limitLo, (double)item_.getTrim_Htrs_HtrBulkTmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulk_I_warnHi, (double)item_.getTrim_Htrs_HtrBulk_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulk_I_warnLo, (double)item_.getTrim_Htrs_HtrBulk_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulk_I_limitHi, (double)item_.getTrim_Htrs_HtrBulk_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulk_I_limitLo, (double)item_.getTrim_Htrs_HtrBulk_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulk_P_warnHi, (double)item_.getTrim_Htrs_HtrBulk_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulk_P_warnLo, (double)item_.getTrim_Htrs_HtrBulk_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulk_P_limitHi, (double)item_.getTrim_Htrs_HtrBulk_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulk_P_limitLo, (double)item_.getTrim_Htrs_HtrBulk_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulk_V_warnHi, (double)item_.getTrim_Htrs_HtrBulk_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulk_V_warnLo, (double)item_.getTrim_Htrs_HtrBulk_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulk_V_limitHi, (double)item_.getTrim_Htrs_HtrBulk_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrBulk_V_limitLo, (double)item_.getTrim_Htrs_HtrBulk_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrPsTmp_warnHi, (double)item_.getTrim_Htrs_HtrPsTmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrPsTmp_warnLo, (double)item_.getTrim_Htrs_HtrPsTmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrPsTmp_limitHi, (double)item_.getTrim_Htrs_HtrPsTmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)trim_Htrs_HtrPsTmp_limitLo, (double)item_.getTrim_Htrs_HtrPsTmp_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_I_warnHi, (double[])item_.getTrim_Trim_Htrs_I_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_I_warnLo, (double[])item_.getTrim_Trim_Htrs_I_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_I_limitHi, (double[])item_.getTrim_Trim_Htrs_I_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_I_limitLo, (double[])item_.getTrim_Trim_Htrs_I_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_P_warnHi, (double[])item_.getTrim_Trim_Htrs_P_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_P_warnLo, (double[])item_.getTrim_Trim_Htrs_P_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_P_limitHi, (double[])item_.getTrim_Trim_Htrs_P_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_P_limitLo, (double[])item_.getTrim_Trim_Htrs_P_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_V_warnHi, (double[])item_.getTrim_Trim_Htrs_V_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_V_warnLo, (double[])item_.getTrim_Trim_Htrs_V_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_V_limitHi, (double[])item_.getTrim_Trim_Htrs_V_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])trim_Trim_Htrs_V_limitLo, (double[])item_.getTrim_Trim_Htrs_V_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveThermal_PicConfigurationEvent() throws Exception {
        String version = "";
        double coldtempctrlc_awGain = 0.6894885897636414;
        double coldtempctrlc_basePower = 0.04080832004547119;
        double coldtempctrlc_gain = 0.4690309762954712;
        double coldtempctrlc_maxInput = 0.9243154525756836;
        double coldtempctrlc_maxOutput = 0.3648267388343811;
        double coldtempctrlc_minInput = 0.3376834988594055;
        double coldtempctrlc_minOutput = 0.37369292974472046;
        double coldtempctrlc_smoothTime = 0.45799845457077026;
        double coldtempctrlc_timeConst = 0.7849602103233337;
        double coldtempctrlc_tolerance = 0.5333129167556763;
        double coldtempctrlmye_awGain = 0.97985f;
        double coldtempctrlmye_basePower = 0.8697410821914673;
        double coldtempctrlmye_gain = 0.7315243482589722;
        double coldtempctrlmye_maxInput = 0.1804996132850647;
        double coldtempctrlmye_maxOutput = 0.923492968082428;
        double coldtempctrlmye_minInput = 0.34092408418655396;
        double coldtempctrlmye_minOutput = 0.013272345066070557;
        double coldtempctrlmye_smoothTime = 0.10649305582046509;
        double coldtempctrlmye_timeConst = 0.8345610499382019;
        double coldtempctrlmye_tolerance = 0.8406642079353333;
        double coldtempctrlpye_awGain = 0.6731714010238647;
        double coldtempctrlpye_basePower = 0.638889729976654;
        double coldtempctrlpye_gain = 0.13770556449890137;
        double coldtempctrlpye_maxInput = 0.015667974948883057;
        double coldtempctrlpye_maxOutput = 0.3332202434539795;
        double coldtempctrlpye_minInput = 0.9151987433433533;
        double coldtempctrlpye_minOutput = 0.5983132123947144;
        double coldtempctrlpye_smoothTime = 0.3930413f;
        double coldtempctrlpye_timeConst = 0.1267513632774353;
        double coldtempctrlpye_tolerance = 0.3148263096809387;
        double cryotempctrl_awGain = 0.733614981174469;
        double cryotempctrl_basePower = 0.6697113513946533;
        double cryotempctrl_gain = 0.050904035568237305;
        double cryotempctrl_maxInput = 0.3045209050178528;
        double cryotempctrl_maxOutput = 0.698835551738739;
        double cryotempctrl_minInput = 0.22198176383972168;
        double cryotempctrl_minOutput = 0.7720783948898315;
        double cryotempctrl_smoothTime = 0.03413683f;
        double cryotempctrl_timeConst = 0.5856906771659851;
        double cryotempctrl_tolerance = 0.05425792932510376;
        long periodictasks_ColdTempCtrlC_iterate_updateTime = 573L;
        long periodictasks_ColdTempCtrlMYE_iterate_updateTime = 979L;
        long periodictasks_ColdTempCtrlPYE_iterate_updateTime = 602L;
        long periodictasks_CryoTempCtrl_iterate_updateTime = 808L;
        SALEvent item = this.testSendReceive((SALEvent)new Thermal_PicConfigurationEvent(version, coldtempctrlc_awGain, coldtempctrlc_basePower, coldtempctrlc_gain, coldtempctrlc_maxInput, coldtempctrlc_maxOutput, coldtempctrlc_minInput, coldtempctrlc_minOutput, coldtempctrlc_smoothTime, coldtempctrlc_timeConst, coldtempctrlc_tolerance, coldtempctrlmye_awGain, coldtempctrlmye_basePower, coldtempctrlmye_gain, coldtempctrlmye_maxInput, coldtempctrlmye_maxOutput, coldtempctrlmye_minInput, coldtempctrlmye_minOutput, coldtempctrlmye_smoothTime, coldtempctrlmye_timeConst, coldtempctrlmye_tolerance, coldtempctrlpye_awGain, coldtempctrlpye_basePower, coldtempctrlpye_gain, coldtempctrlpye_maxInput, coldtempctrlpye_maxOutput, coldtempctrlpye_minInput, coldtempctrlpye_minOutput, coldtempctrlpye_smoothTime, coldtempctrlpye_timeConst, coldtempctrlpye_tolerance, cryotempctrl_awGain, cryotempctrl_basePower, cryotempctrl_gain, cryotempctrl_maxInput, cryotempctrl_maxOutput, cryotempctrl_minInput, cryotempctrl_minOutput, cryotempctrl_smoothTime, cryotempctrl_timeConst, cryotempctrl_tolerance, periodictasks_ColdTempCtrlC_iterate_updateTime, periodictasks_ColdTempCtrlMYE_iterate_updateTime, periodictasks_ColdTempCtrlPYE_iterate_updateTime, periodictasks_CryoTempCtrl_iterate_updateTime));
        Assert.assertTrue((boolean)(item instanceof Thermal_PicConfigurationEvent));
        Thermal_PicConfigurationEvent item_ = (Thermal_PicConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)coldtempctrlc_awGain, (double)item_.getColdtempctrlc_awGain(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlc_basePower, (double)item_.getColdtempctrlc_basePower(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlc_gain, (double)item_.getColdtempctrlc_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlc_maxInput, (double)item_.getColdtempctrlc_maxInput(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlc_maxOutput, (double)item_.getColdtempctrlc_maxOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlc_minInput, (double)item_.getColdtempctrlc_minInput(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlc_minOutput, (double)item_.getColdtempctrlc_minOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlc_smoothTime, (double)item_.getColdtempctrlc_smoothTime(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlc_timeConst, (double)item_.getColdtempctrlc_timeConst(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlc_tolerance, (double)item_.getColdtempctrlc_tolerance(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlmye_awGain, (double)item_.getColdtempctrlmye_awGain(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlmye_basePower, (double)item_.getColdtempctrlmye_basePower(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlmye_gain, (double)item_.getColdtempctrlmye_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlmye_maxInput, (double)item_.getColdtempctrlmye_maxInput(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlmye_maxOutput, (double)item_.getColdtempctrlmye_maxOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlmye_minInput, (double)item_.getColdtempctrlmye_minInput(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlmye_minOutput, (double)item_.getColdtempctrlmye_minOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlmye_smoothTime, (double)item_.getColdtempctrlmye_smoothTime(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlmye_timeConst, (double)item_.getColdtempctrlmye_timeConst(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlmye_tolerance, (double)item_.getColdtempctrlmye_tolerance(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlpye_awGain, (double)item_.getColdtempctrlpye_awGain(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlpye_basePower, (double)item_.getColdtempctrlpye_basePower(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlpye_gain, (double)item_.getColdtempctrlpye_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlpye_maxInput, (double)item_.getColdtempctrlpye_maxInput(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlpye_maxOutput, (double)item_.getColdtempctrlpye_maxOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlpye_minInput, (double)item_.getColdtempctrlpye_minInput(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlpye_minOutput, (double)item_.getColdtempctrlpye_minOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlpye_smoothTime, (double)item_.getColdtempctrlpye_smoothTime(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlpye_timeConst, (double)item_.getColdtempctrlpye_timeConst(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlpye_tolerance, (double)item_.getColdtempctrlpye_tolerance(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotempctrl_awGain, (double)item_.getCryotempctrl_awGain(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotempctrl_basePower, (double)item_.getCryotempctrl_basePower(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotempctrl_gain, (double)item_.getCryotempctrl_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotempctrl_maxInput, (double)item_.getCryotempctrl_maxInput(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotempctrl_maxOutput, (double)item_.getCryotempctrl_maxOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotempctrl_minInput, (double)item_.getCryotempctrl_minInput(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotempctrl_minOutput, (double)item_.getCryotempctrl_minOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotempctrl_smoothTime, (double)item_.getCryotempctrl_smoothTime(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotempctrl_timeConst, (double)item_.getCryotempctrl_timeConst(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotempctrl_tolerance, (double)item_.getCryotempctrl_tolerance(), (double)1.0E-6f);
        Assert.assertEquals((long)periodictasks_ColdTempCtrlC_iterate_updateTime, (long)item_.getPeriodictasks_ColdTempCtrlC_iterate_updateTime());
        Assert.assertEquals((long)periodictasks_ColdTempCtrlMYE_iterate_updateTime, (long)item_.getPeriodictasks_ColdTempCtrlMYE_iterate_updateTime());
        Assert.assertEquals((long)periodictasks_ColdTempCtrlPYE_iterate_updateTime, (long)item_.getPeriodictasks_ColdTempCtrlPYE_iterate_updateTime());
        Assert.assertEquals((long)periodictasks_CryoTempCtrl_iterate_updateTime, (long)item_.getPeriodictasks_CryoTempCtrl_iterate_updateTime());
    }

    @Test
    public void sendReceiveThermal_RefrigConfigurationEvent() throws Exception {
        String version = "f";
        double coldtempctrlc_tempDeadband = 0.7371757626533508;
        double coldtempctrlc_tempLimit = 0.3195068836212158;
        String coldtempctrlc_tempWeights = "";
        double coldtempctrlmye_tempDeadband = 0.37063318490982056;
        double coldtempctrlmye_tempLimit = 0.7104004621505737;
        String coldtempctrlmye_tempWeights = "f";
        double coldtempctrlpye_tempDeadband = 0.34100186824798584;
        double coldtempctrlpye_tempLimit = 0.10711503028869629;
        String coldtempctrlpye_tempWeights = "k";
        double cryotempctrl_tempDeadband = 0.33723026514053345;
        double cryotempctrl_tempLimit = 0.9117512106895447;
        String cryotempctrl_tempWeights = "";
        double trimpower_coldPowerWeights = 0.1531394124031067;
        String trimpower_connType = "o";
        double trimpower_cryoPowerWeights = 0.11161643266677856;
        String trimpower_devcId = "";
        int trimpower_devcParm = 68;
        int trimpower_node = 82;
        SALEvent item = this.testSendReceive((SALEvent)new Thermal_RefrigConfigurationEvent(version, coldtempctrlc_tempDeadband, coldtempctrlc_tempLimit, coldtempctrlc_tempWeights, coldtempctrlmye_tempDeadband, coldtempctrlmye_tempLimit, coldtempctrlmye_tempWeights, coldtempctrlpye_tempDeadband, coldtempctrlpye_tempLimit, coldtempctrlpye_tempWeights, cryotempctrl_tempDeadband, cryotempctrl_tempLimit, cryotempctrl_tempWeights, trimpower_coldPowerWeights, trimpower_connType, trimpower_cryoPowerWeights, trimpower_devcId, trimpower_devcParm, trimpower_node));
        Assert.assertTrue((boolean)(item instanceof Thermal_RefrigConfigurationEvent));
        Thermal_RefrigConfigurationEvent item_ = (Thermal_RefrigConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)coldtempctrlc_tempDeadband, (double)item_.getColdtempctrlc_tempDeadband(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlc_tempLimit, (double)item_.getColdtempctrlc_tempLimit(), (double)1.0E-6f);
        Assert.assertEquals((Object)coldtempctrlc_tempWeights, (Object)item_.getColdtempctrlc_tempWeights());
        Assert.assertEquals((double)coldtempctrlmye_tempDeadband, (double)item_.getColdtempctrlmye_tempDeadband(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlmye_tempLimit, (double)item_.getColdtempctrlmye_tempLimit(), (double)1.0E-6f);
        Assert.assertEquals((Object)coldtempctrlmye_tempWeights, (Object)item_.getColdtempctrlmye_tempWeights());
        Assert.assertEquals((double)coldtempctrlpye_tempDeadband, (double)item_.getColdtempctrlpye_tempDeadband(), (double)1.0E-6f);
        Assert.assertEquals((double)coldtempctrlpye_tempLimit, (double)item_.getColdtempctrlpye_tempLimit(), (double)1.0E-6f);
        Assert.assertEquals((Object)coldtempctrlpye_tempWeights, (Object)item_.getColdtempctrlpye_tempWeights());
        Assert.assertEquals((double)cryotempctrl_tempDeadband, (double)item_.getCryotempctrl_tempDeadband(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotempctrl_tempLimit, (double)item_.getCryotempctrl_tempLimit(), (double)1.0E-6f);
        Assert.assertEquals((Object)cryotempctrl_tempWeights, (Object)item_.getCryotempctrl_tempWeights());
        Assert.assertEquals((double)trimpower_coldPowerWeights, (double)item_.getTrimpower_coldPowerWeights(), (double)1.0E-6f);
        Assert.assertEquals((Object)trimpower_connType, (Object)item_.getTrimpower_connType());
        Assert.assertEquals((double)trimpower_cryoPowerWeights, (double)item_.getTrimpower_cryoPowerWeights(), (double)1.0E-6f);
        Assert.assertEquals((Object)trimpower_devcId, (Object)item_.getTrimpower_devcId());
        Assert.assertEquals((long)trimpower_devcParm, (long)item_.getTrimpower_devcParm());
        Assert.assertEquals((long)trimpower_node, (long)item_.getTrimpower_node());
    }

    @Test
    public void sendReceiveThermal_ThermalLimitsConfigurationEvent() throws Exception {
        String version = "";
        double coldTempLimit = 0.3485068082809448;
        double coldTempLowLimit = 0.9594364762306213;
        double cryoTempLowLimit = 0.3672473430633545;
        SALEvent item = this.testSendReceive((SALEvent)new Thermal_ThermalLimitsConfigurationEvent(version, coldTempLimit, coldTempLowLimit, cryoTempLowLimit));
        Assert.assertTrue((boolean)(item instanceof Thermal_ThermalLimitsConfigurationEvent));
        Thermal_ThermalLimitsConfigurationEvent item_ = (Thermal_ThermalLimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)coldTempLimit, (double)item_.getColdTempLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)coldTempLowLimit, (double)item_.getColdTempLowLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)cryoTempLowLimit, (double)item_.getCryoTempLowLimit(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveThermal_timersConfigurationEvent() throws Exception {
        String version = "v";
        long periodictasks_ColdTempCtrlC_tempCheck_taskPeriodMillis = 75L;
        long periodictasks_ColdTempCtrlMYE_tempCheck_taskPeriodMillis = 518L;
        long periodictasks_ColdTempCtrlPYE_tempCheck_taskPeriodMillis = 16L;
        long periodictasks_CryoTempCtrl_tempCheck_taskPeriodMillis = 74L;
        long periodictasks_agentMonitorService_taskPeriodMillis = 21L;
        long periodictasks_heartbeat_taskPeriodMillis = 706L;
        long periodictasks_maintain_power_TrimPower_taskPeriodMillis = 359L;
        long periodictasks_monitor_check_ProtRtds_taskPeriodMillis = 91L;
        long periodictasks_monitor_check_Rtds_taskPeriodMillis = 564L;
        long periodictasks_monitor_check_TrimPower_taskPeriodMillis = 226L;
        long periodictasks_monitor_publish_avgTemp_taskPeriodMillis = 245L;
        long periodictasks_monitor_publish_coldTemp_taskPeriodMillis = 82L;
        long periodictasks_monitor_publish_taskPeriodMillis = 314L;
        long periodictasks_monitor_update_avgTemp_taskPeriodMillis = 680L;
        long periodictasks_monitor_update_coldTemp_taskPeriodMillis = 282L;
        long periodictasks_monitor_update_taskPeriodMillis = 292L;
        long periodictasks_runtimeInfo_taskPeriodMillis = 317L;
        long periodictasks_thermal_state_taskPeriodMillis = 111L;
        SALEvent item = this.testSendReceive((SALEvent)new Thermal_timersConfigurationEvent(version, periodictasks_ColdTempCtrlC_tempCheck_taskPeriodMillis, periodictasks_ColdTempCtrlMYE_tempCheck_taskPeriodMillis, periodictasks_ColdTempCtrlPYE_tempCheck_taskPeriodMillis, periodictasks_CryoTempCtrl_tempCheck_taskPeriodMillis, periodictasks_agentMonitorService_taskPeriodMillis, periodictasks_heartbeat_taskPeriodMillis, periodictasks_maintain_power_TrimPower_taskPeriodMillis, periodictasks_monitor_check_ProtRtds_taskPeriodMillis, periodictasks_monitor_check_Rtds_taskPeriodMillis, periodictasks_monitor_check_TrimPower_taskPeriodMillis, periodictasks_monitor_publish_avgTemp_taskPeriodMillis, periodictasks_monitor_publish_coldTemp_taskPeriodMillis, periodictasks_monitor_publish_taskPeriodMillis, periodictasks_monitor_update_avgTemp_taskPeriodMillis, periodictasks_monitor_update_coldTemp_taskPeriodMillis, periodictasks_monitor_update_taskPeriodMillis, periodictasks_runtimeInfo_taskPeriodMillis, periodictasks_thermal_state_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Thermal_timersConfigurationEvent));
        Thermal_timersConfigurationEvent item_ = (Thermal_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)periodictasks_ColdTempCtrlC_tempCheck_taskPeriodMillis, (long)item_.getPeriodictasks_ColdTempCtrlC_tempCheck_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_ColdTempCtrlMYE_tempCheck_taskPeriodMillis, (long)item_.getPeriodictasks_ColdTempCtrlMYE_tempCheck_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_ColdTempCtrlPYE_tempCheck_taskPeriodMillis, (long)item_.getPeriodictasks_ColdTempCtrlPYE_tempCheck_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_CryoTempCtrl_tempCheck_taskPeriodMillis, (long)item_.getPeriodictasks_CryoTempCtrl_tempCheck_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_agentMonitorService_taskPeriodMillis, (long)item_.getPeriodictasks_agentMonitorService_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_heartbeat_taskPeriodMillis, (long)item_.getPeriodictasks_heartbeat_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_maintain_power_TrimPower_taskPeriodMillis, (long)item_.getPeriodictasks_maintain_power_TrimPower_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_check_ProtRtds_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_check_ProtRtds_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_check_Rtds_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_check_Rtds_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_check_TrimPower_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_check_TrimPower_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_publish_avgTemp_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_publish_avgTemp_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_publish_coldTemp_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_publish_coldTemp_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_publish_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_update_avgTemp_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_update_avgTemp_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_update_coldTemp_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_update_coldTemp_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_monitor_update_taskPeriodMillis, (long)item_.getPeriodictasks_monitor_update_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_runtimeInfo_taskPeriodMillis, (long)item_.getPeriodictasks_runtimeInfo_taskPeriodMillis());
        Assert.assertEquals((long)periodictasks_thermal_state_taskPeriodMillis, (long)item_.getPeriodictasks_thermal_state_taskPeriodMillis());
    }

    @Test
    public void sendReceiveSummaryStatusEvent() throws Exception {
        double timestampStatusChanged = 0.32455867528915405;
        String subsystems = "";
        String subsystemState = "";
        String subsystemColor = "n";
        String additionalInfo = "h";
        String drillDownLinks = "";
        SALEvent item = this.testSendReceive((SALEvent)new SummaryStatusEvent(timestampStatusChanged, subsystems, subsystemState, subsystemColor, additionalInfo, drillDownLinks));
        Assert.assertTrue((boolean)(item instanceof SummaryStatusEvent));
        SummaryStatusEvent item_ = (SummaryStatusEvent)item;
        Assert.assertEquals((double)timestampStatusChanged, (double)item_.getTimestampStatusChanged(), (double)1.0E-6f);
        Assert.assertEquals((Object)subsystems, (Object)item_.getSubsystems());
        Assert.assertEquals((Object)subsystemState, (Object)item_.getSubsystemState());
        Assert.assertEquals((Object)subsystemColor, (Object)item_.getSubsystemColor());
        Assert.assertEquals((Object)additionalInfo, (Object)item_.getAdditionalInfo());
        Assert.assertEquals((Object)drillDownLinks, (Object)item_.getDrillDownLinks());
    }

    @Test
    public void sendReceiveAlertRaisedEvent() throws Exception {
        double timestampAlertStatusChanged = 0.25867152214050293;
        String alertId = "";
        String description = "n";
        AlertRaisedEvent.CurrentSeverity currentSeverity = AlertRaisedEvent.CurrentSeverity.WARNING;
        int highestSeverity = 53;
        boolean isCleared = true;
        String cause = "x";
        String origin = "p";
        String additionalInfo = "a";
        SALEvent item = this.testSendReceive((SALEvent)new AlertRaisedEvent(timestampAlertStatusChanged, alertId, description, currentSeverity, highestSeverity, isCleared, cause, origin, additionalInfo));
        Assert.assertTrue((boolean)(item instanceof AlertRaisedEvent));
        AlertRaisedEvent item_ = (AlertRaisedEvent)item;
        Assert.assertEquals((double)timestampAlertStatusChanged, (double)item_.getTimestampAlertStatusChanged(), (double)1.0E-6f);
        Assert.assertEquals((Object)alertId, (Object)item_.getAlertId());
        Assert.assertEquals((Object)description, (Object)item_.getDescription());
        Assert.assertEquals((Object)currentSeverity, (Object)item_.getCurrentSeverity());
        Assert.assertEquals((long)highestSeverity, (long)item_.getHighestSeverity());
        Assert.assertEquals((Object)isCleared, (Object)item_.isIsCleared());
        Assert.assertEquals((Object)cause, (Object)item_.getCause());
        Assert.assertEquals((Object)origin, (Object)item_.getOrigin());
        Assert.assertEquals((Object)additionalInfo, (Object)item_.getAdditionalInfo());
    }

    @Test
    public void sendReceiveConfigurationAppliedEvent() throws Exception {
        String configurations = "y";
        String version = "r";
        String url = "l";
        String schemaVersion = "z";
        String otherInfo = "c";
        SALEvent item = this.testSendReceive((SALEvent)new ConfigurationAppliedEvent(configurations, version, url, schemaVersion, otherInfo));
        Assert.assertTrue((boolean)(item instanceof ConfigurationAppliedEvent));
        ConfigurationAppliedEvent item_ = (ConfigurationAppliedEvent)item;
        Assert.assertEquals((Object)configurations, (Object)item_.getConfigurations());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)url, (Object)item_.getUrl());
        Assert.assertEquals((Object)schemaVersion, (Object)item_.getSchemaVersion());
        Assert.assertEquals((Object)otherInfo, (Object)item_.getOtherInfo());
    }

    @Test
    public void sendReceiveConfigurationsAvailableEvent() throws Exception {
        String overrides = "";
        String version = "";
        String url = "";
        String schemaVersion = "";
        SALEvent item = this.testSendReceive((SALEvent)new ConfigurationsAvailableEvent(overrides, version, url, schemaVersion));
        Assert.assertTrue((boolean)(item instanceof ConfigurationsAvailableEvent));
        ConfigurationsAvailableEvent item_ = (ConfigurationsAvailableEvent)item;
        Assert.assertEquals((Object)overrides, (Object)item_.getOverrides());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)url, (Object)item_.getUrl());
        Assert.assertEquals((Object)schemaVersion, (Object)item_.getSchemaVersion());
    }

    @Test
    public void sendReceiveErrorCodeEvent() throws Exception {
        int errorCode = 979;
        String errorReport = "";
        String traceback = "";
        SALEvent item = this.testSendReceive((SALEvent)new ErrorCodeEvent(errorCode, errorReport, traceback));
        Assert.assertTrue((boolean)(item instanceof ErrorCodeEvent));
        ErrorCodeEvent item_ = (ErrorCodeEvent)item;
        Assert.assertEquals((long)errorCode, (long)item_.getErrorCode());
        Assert.assertEquals((Object)errorReport, (Object)item_.getErrorReport());
        Assert.assertEquals((Object)traceback, (Object)item_.getTraceback());
    }

    @Test
    public void sendReceiveLogLevelEvent() throws Exception {
        int level = 617;
        String subsystem = "z";
        SALEvent item = this.testSendReceive((SALEvent)new LogLevelEvent(level, subsystem));
        Assert.assertTrue((boolean)(item instanceof LogLevelEvent));
        LogLevelEvent item_ = (LogLevelEvent)item;
        Assert.assertEquals((long)level, (long)item_.getLevel());
        Assert.assertEquals((Object)subsystem, (Object)item_.getSubsystem());
    }

    @Test
    public void sendReceiveLogMessageEvent() throws Exception {
        String name = "";
        int level = 695;
        String message = "";
        String traceback = "";
        String filePath = "t";
        String functionName = "c";
        int lineNumber = 508;
        int process = 47;
        double timestamp = 0.8297645449638367;
        SALEvent item = this.testSendReceive((SALEvent)new LogMessageEvent(name, level, message, traceback, filePath, functionName, lineNumber, process, timestamp));
        Assert.assertTrue((boolean)(item instanceof LogMessageEvent));
        LogMessageEvent item_ = (LogMessageEvent)item;
        Assert.assertEquals((Object)name, (Object)item_.getName());
        Assert.assertEquals((long)level, (long)item_.getLevel());
        Assert.assertEquals((Object)message, (Object)item_.getMessage());
        Assert.assertEquals((Object)traceback, (Object)item_.getTraceback());
        Assert.assertEquals((Object)filePath, (Object)item_.getFilePath());
        Assert.assertEquals((Object)functionName, (Object)item_.getFunctionName());
        Assert.assertEquals((long)lineNumber, (long)item_.getLineNumber());
        Assert.assertEquals((long)process, (long)item_.getProcess());
        Assert.assertEquals((double)timestamp, (double)item_.getTimestamp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveSimulationModeEvent() throws Exception {
        int mode = 435;
        SALEvent item = this.testSendReceive((SALEvent)new SimulationModeEvent(mode));
        Assert.assertTrue((boolean)(item instanceof SimulationModeEvent));
        SimulationModeEvent item_ = (SimulationModeEvent)item;
        Assert.assertEquals((long)mode, (long)item_.getMode());
    }

    @Test
    public void sendReceiveSoftwareVersionsEvent() throws Exception {
        String salVersion = "tetuyyhiwzcohoidqdbrzkskbchhxtiinhdlwwjagibntwsvkfgyekleifuvyioreguxfrvfphjiatiniticvnulxvkzwktqfildlhmvjjwgyzputeqzunmmezftdkmajezlubgtakuzqflynzjzpadkwzfioexyudgtatebuykvxypmkesscuidahryusexlkxuqbocjqymwoaanocryvvsgdfedjdghjmkesfjhhsoqrutvlulxenqr";
        String xmlVersion = "iidhhcovmujamglqkwozanmyvwtnjgtckhqsgrkqpvlrdmoaekvgosdmagomdpugqcpnvsqvewimaoujxusfiprlmxcursyzkzlldkvdduxbzpplduejnygkiynpbhdmtyelcwtowvokcicbmuprbkgovjcjbtjiaimtahtsegiltxazplujbfiitxvpxfnvmvukdbavczqdgbmjoxbmtzdwlmuhlwkgckegpjibxmuevswzuwqjzpnzlmgbmrmq";
        String openSpliceVersion = "akuqzlbmjcmwuqizqiarxpknivulajpukwocviunwowoijvgbyzlmihqxhmasxqixcwlhypqytcsnsxzhqbhoajgdwdoaokuzannftqahjhsdlktawuaehthrokkrgyupdtukywkvrzfzqlnjpegfqbgnpnqmsjlzpicqyar";
        String cscVersion = "gybcudkaftafwuccvmvgn";
        String subsystemVersions = "";
        SALEvent item = this.testSendReceive((SALEvent)new SoftwareVersionsEvent(salVersion, xmlVersion, openSpliceVersion, cscVersion, subsystemVersions));
        Assert.assertTrue((boolean)(item instanceof SoftwareVersionsEvent));
        SoftwareVersionsEvent item_ = (SoftwareVersionsEvent)item;
        Assert.assertEquals((Object)salVersion, (Object)item_.getSalVersion());
        Assert.assertEquals((Object)xmlVersion, (Object)item_.getXmlVersion());
        Assert.assertEquals((Object)openSpliceVersion, (Object)item_.getOpenSpliceVersion());
        Assert.assertEquals((Object)cscVersion, (Object)item_.getCscVersion());
        Assert.assertEquals((Object)subsystemVersions, (Object)item_.getSubsystemVersions());
    }

    @Test
    public void sendReceiveHeartbeatEvent() throws Exception {
        boolean heartbeat = true;
        SALEvent item = this.testSendReceive((SALEvent)new HeartbeatEvent(heartbeat));
        Assert.assertTrue((boolean)(item instanceof HeartbeatEvent));
        HeartbeatEvent item_ = (HeartbeatEvent)item;
        Assert.assertEquals((Object)heartbeat, (Object)item_.isHeartbeat());
    }

    @Test
    public void sendReceiveAuthListEvent() throws Exception {
        String authorizedUsers = "";
        String nonAuthorizedCSCs = "y";
        SALEvent item = this.testSendReceive((SALEvent)new AuthListEvent(authorizedUsers, nonAuthorizedCSCs));
        Assert.assertTrue((boolean)(item instanceof AuthListEvent));
        AuthListEvent item_ = (AuthListEvent)item;
        Assert.assertEquals((Object)authorizedUsers, (Object)item_.getAuthorizedUsers());
        Assert.assertEquals((Object)nonAuthorizedCSCs, (Object)item_.getNonAuthorizedCSCs());
    }

    @Test
    public void sendReceiveLargeFileObjectAvailableEvent() throws Exception {
        String url = "kvxfatgovymxfsnadhrgktrnavatlqyorznpozbqlahj";
        String generator = "ftoojrheolosafbvefljbepmjkqbbxtwnmjtxgcbxqyifnkqjctxaaiwfvsnwcusgtzpmootdgvkbhgubrbaermerpzezhnlcqbhxpaadkvlfmrjjhlnduewysnflhefyfgmumpvnwolruyxnvpfkcbfjumhamtsuqimpvfseaopdebkfpflktgbsiuxkpnmecdkpetfqrjwiduvmnzkawkepmybxlsepkhhxadmthvnfzkcsthag";
        float version = 0.33705884f;
        int byteSize = 350;
        String checkSum = "scaqxfkscbktcqofsqyrgwmvijbeqftjmuvhcivuhvqdqveexdossdaskup";
        String mimeType = "vjqimzjvngucggzlrxgzturlvmafecbrayyigtebhbjsuovrwddjanwytzpnfkzdaranskklieynfmuomawoyifzganecoptpijebxiomigpiolpvoketuvmahqergbwzhxevewjikgsewnujqyzfwtkfupfypzgitffkxrnngzwjjenrfdrpxvnororsvwlfubicpqnilwnnjzwwkijixglyysatmocjogynejidqcesoowyjszxyvoq";
        String id = "lhkyydnjkdlgsaodiljzgyswixwqcsgwdshirgggehwqrksdxvoaxmxujngihwofbxsmrgugpmkcazitknlvmkdlykqbushzpgyybqlowsxopeaavwpjnugzkmbutpzyphajckjwqalkguzgtmxuwpdcvqyzaofsgvubygxbqcwjxddwykognmztgneqjqgepea";
        SALEvent item = this.testSendReceive((SALEvent)new LargeFileObjectAvailableEvent(url, generator, version, byteSize, checkSum, mimeType, id));
        Assert.assertTrue((boolean)(item instanceof LargeFileObjectAvailableEvent));
        LargeFileObjectAvailableEvent item_ = (LargeFileObjectAvailableEvent)item;
        Assert.assertEquals((Object)url, (Object)item_.getUrl());
        Assert.assertEquals((Object)generator, (Object)item_.getGenerator());
        Assert.assertEquals((float)version, (float)item_.getVersion(), (float)1.0E-6f);
        Assert.assertEquals((long)byteSize, (long)item_.getByteSize());
        Assert.assertEquals((Object)checkSum, (Object)item_.getCheckSum());
        Assert.assertEquals((Object)mimeType, (Object)item_.getMimeType());
        Assert.assertEquals((Object)id, (Object)item_.getId());
    }
}

