package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class Vacuum_HexTurboGauge_CryoConfigurationEvent extends CameraEvent {
  private final String version;

  private final int busAddr;

  private final String devcId;

  private final double relayTrip;

  public Vacuum_HexTurboGauge_CryoConfigurationEvent(String version, int busAddr, String devcId,
      double relayTrip) {
    this.version = version;
    this.busAddr = busAddr;
    this.devcId = devcId;
    this.relayTrip = relayTrip;
  }

  public String getVersion() {
    return version;
  }

  public int getBusAddr() {
    return busAddr;
  }

  public String getDevcId() {
    return devcId;
  }

  public double getRelayTrip() {
    return relayTrip;
  }

  @Override
  public String toString() {
    return "Vacuum_HexTurboGauge_CryoConfigurationEvent{" + "version=" + version +
        ", busAddr=" + busAddr +", devcId=" + devcId +", relayTrip=" + relayTrip +"}";
  }
}
