/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.TestHelper;
import org.lsst.sal.camera.SALCamera;
import org.lsst.sal.camera.telemetry.Chiller_ChillerTelemetry;
import org.lsst.sal.camera.telemetry.Chiller_Maq20Telemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_Reb_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_StoreTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_Sum_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_AcSensorsGatewayTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_AcTruckXminusControllerTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_AcTruckXminusTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_AcTruckXplusControllerTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_AcTruckXplusTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_AccelerobfTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Ai814Telemetry;
import org.lsst.sal.camera.telemetry.Fcs_AutochangerTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_AutochangerTrucksTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_BrakeSystemGatewayTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_CarouselControllerTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_CarouselTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_CarrierControllerTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_CarrierTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_CcsVersionsTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_ClampXminus1Telemetry;
import org.lsst.sal.camera.telemetry.Fcs_ClampXminus2Telemetry;
import org.lsst.sal.camera.telemetry.Fcs_ClampXminus3Telemetry;
import org.lsst.sal.camera.telemetry.Fcs_ClampXminus4Telemetry;
import org.lsst.sal.camera.telemetry.Fcs_ClampXminus5Telemetry;
import org.lsst.sal.camera.telemetry.Fcs_ClampXminusControllerTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_ClampXplus1Telemetry;
import org.lsst.sal.camera.telemetry.Fcs_ClampXplus2Telemetry;
import org.lsst.sal.camera.telemetry.Fcs_ClampXplus3Telemetry;
import org.lsst.sal.camera.telemetry.Fcs_ClampXplus4Telemetry;
import org.lsst.sal.camera.telemetry.Fcs_ClampXplus5Telemetry;
import org.lsst.sal.camera.telemetry.Fcs_ClampXplusControllerTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_ConfigTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_HooksControllerTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_HooksTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Hyttc580Telemetry;
import org.lsst.sal.camera.telemetry.Fcs_LatchXminusControllerTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_LatchXminusTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_LatchXplusControllerTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_LatchXplusTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_LatchesTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_LoaderPlutoGatewayTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_LoaderTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_OnlineClampXminusControllerTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_OnlineClampXminusTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_OnlineClampXplusControllerTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_OnlineClampXplusTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_OnlineClampYminusControllerTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_OnlineClampYminusTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_OnlineClampsTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_OnlineStrainGaugeTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_ProximitySensorsDeviceTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Pt100Telemetry;
import org.lsst.sal.camera.telemetry.Fcs_RuntimeInfoTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Socket1Telemetry;
import org.lsst.sal.camera.telemetry.Fcs_Socket2Telemetry;
import org.lsst.sal.camera.telemetry.Fcs_Socket3Telemetry;
import org.lsst.sal.camera.telemetry.Fcs_Socket4Telemetry;
import org.lsst.sal.camera.telemetry.Fcs_Socket5Telemetry;
import org.lsst.sal.camera.telemetry.Fcs_TempSensorsDevice1Telemetry;
import org.lsst.sal.camera.telemetry.Fcs_TempSensorsDevice2Telemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_CcdTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebTotalPowerTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebsAverageTemp6Telemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_SegmentTelemetry;
import org.lsst.sal.camera.telemetry.Hex_Cold1Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cold2Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo1Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo2Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo3Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo4Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo5Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo6Telemetry;
import org.lsst.sal.camera.telemetry.Quadbox_BFRTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_24VCTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_24VDTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_48VTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_5VTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_REB_Bulk_PSTelemetry;
import org.lsst.sal.camera.telemetry.Rebpower_RebTelemetry;
import org.lsst.sal.camera.telemetry.Rebpower_RebpsTelemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo1Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo2Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo3Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo4Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo5Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo6Telemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP1_ITelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP1_VTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP2_ITelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP2_VTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP3_ITelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP3_VTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP4_ITelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP4_VTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP5_ITelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP5_VTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP6_ITelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP6_VTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CryoVacTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_ForelineVacTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_Hex1VacTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_Hex2VacTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_TurboCurrentTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_TurboPowerTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_TurboPumpTempTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_TurboSpeedTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_TurboVacTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_TurboVoltageTelemetry;

public class TelemetrySendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = SALCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALTelemetry testSendReceive(SALTelemetry item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALTelemetry> future = executor.submit(() -> sal.getTelemetry(Duration.ofSeconds(10L)));
        try {
            sal.sendTelemetry(item);
            SALTelemetry sALTelemetry = future.get(10L, TimeUnit.SECONDS);
            return sALTelemetry;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveQuadbox_BFRTelemetry() throws Exception {
        double clean_5_24V_I = 0.11161643266677856;
        double dirty_24V_I = 0.4767692f;
        double dirty_28V_I = 0.6135520339012146;
        double dirty_48V_I = 0.4675411581993103;
        double heater_I = 0.4446919f;
        double protection_I = 0.3485068082809448;
        double rebps_0_2_I = 0.9594364762306213;
        double rebps_3_5_I = 0.3672473430633545;
        double rebps_6_8_I = 0.6357722282409668;
        double rebps_9_12_I = 0.42668914794921875;
        double rebps_Spr_I = 0.378991f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_BFRTelemetry(clean_5_24V_I, dirty_24V_I, dirty_28V_I, dirty_48V_I, heater_I, protection_I, rebps_0_2_I, rebps_3_5_I, rebps_6_8_I, rebps_9_12_I, rebps_Spr_I));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFRTelemetry));
        Quadbox_BFRTelemetry item_ = (Quadbox_BFRTelemetry)item;
        Assert.assertEquals((double)clean_5_24V_I, (double)item_.getClean_5_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I, (double)item_.getDirty_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I, (double)item_.getDirty_28V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I, (double)item_.getDirty_48V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)heater_I, (double)item_.getHeater_I(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I, (double)item_.getProtection_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_2_I, (double)item_.getRebps_0_2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_3_5_I, (double)item_.getRebps_3_5_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_6_8_I, (double)item_.getRebps_6_8_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_9_12_I, (double)item_.getRebps_9_12_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_Spr_I, (double)item_.getRebps_Spr_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VCTelemetry() throws Exception {
        double n_24vc_Board_T = 0.3403865098953247;
        double n_24vc_FPGA_T = 0.9576561450958252;
        double n_24vc_Main_I = 0.9184102416038513;
        double n_24vc_Main_T = 0.4528998136520386;
        double n_24vc_Main_V = 0.6180059313774109;
        double body_Purge_I = 0.43196988105773926;
        double body_Purge_V = 0.0030002593994140625;
        double bpu_Maq20_I = 0.6589388847351074;
        double bpu_Maq20_V = 0.634658694267273;
        double fes_Shu_HCU_I = 0.3117980360984802;
        double fes_Shu_HCU_V = 0.7828250527381897;
        double gauges_I = 0.33912956714630127;
        double gauges_V = 0.2980002164840698;
        double ion_Pumps_I = 0.9111488461494446;
        double ion_Pumps_V = 0.5686032772064209;
        double pwr_Cry_HCU_I = 0.5744142532348633;
        double pwr_Cry_HCU_V = 0.4660971760749817;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VCTelemetry(n_24vc_Board_T, n_24vc_FPGA_T, n_24vc_Main_I, n_24vc_Main_T, n_24vc_Main_V, body_Purge_I, body_Purge_V, bpu_Maq20_I, bpu_Maq20_V, fes_Shu_HCU_I, fes_Shu_HCU_V, gauges_I, gauges_V, ion_Pumps_I, ion_Pumps_V, pwr_Cry_HCU_I, pwr_Cry_HCU_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VCTelemetry));
        Quadbox_PDU_24VCTelemetry item_ = (Quadbox_PDU_24VCTelemetry)item;
        Assert.assertEquals((double)n_24vc_Board_T, (double)item_.getN_24vc_Board_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_FPGA_T, (double)item_.getN_24vc_FPGA_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_I, (double)item_.getN_24vc_Main_I(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_T, (double)item_.getN_24vc_Main_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_V, (double)item_.getN_24vc_Main_V(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_I, (double)item_.getBody_Purge_I(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_V, (double)item_.getBody_Purge_V(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_I, (double)item_.getBpu_Maq20_I(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_V, (double)item_.getBpu_Maq20_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_I, (double)item_.getFes_Shu_HCU_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_V, (double)item_.getFes_Shu_HCU_V(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I, (double)item_.getGauges_I(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V, (double)item_.getGauges_V(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I, (double)item_.getIon_Pumps_I(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V, (double)item_.getIon_Pumps_V(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_I, (double)item_.getPwr_Cry_HCU_I(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_V, (double)item_.getPwr_Cry_HCU_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VDTelemetry() throws Exception {
        double n_24vd_Board_T = 0.32455867528915405;
        double n_24vd_FPGA_T = 0.18661415576934814;
        double n_24vd_Main_I = 0.37383097410202026;
        double n_24vd_Main_T = 0.9825586080551147;
        double n_24vd_Main_V = 0.13037598133087158;
        double cryo_Turbo_I = 0.8517256379127502;
        double cryo_Turbo_V = 0.9634333848953247;
        double hex_Turbo_I = 0.3411770462989807;
        double hex_Turbo_V = 0.25867152214050293;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VDTelemetry(n_24vd_Board_T, n_24vd_FPGA_T, n_24vd_Main_I, n_24vd_Main_T, n_24vd_Main_V, cryo_Turbo_I, cryo_Turbo_V, hex_Turbo_I, hex_Turbo_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VDTelemetry));
        Quadbox_PDU_24VDTelemetry item_ = (Quadbox_PDU_24VDTelemetry)item;
        Assert.assertEquals((double)n_24vd_Board_T, (double)item_.getN_24vd_Board_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_FPGA_T, (double)item_.getN_24vd_FPGA_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_I, (double)item_.getN_24vd_Main_I(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_T, (double)item_.getN_24vd_Main_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_V, (double)item_.getN_24vd_Main_V(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I, (double)item_.getCryo_Turbo_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V, (double)item_.getCryo_Turbo_V(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_I, (double)item_.getHex_Turbo_I(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_V, (double)item_.getHex_Turbo_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_48VTelemetry() throws Exception {
        double n_48v_Board_T = 0.15205252170562744;
        double n_48v_FPGA_T = 0.8976141214370728;
        double n_48v_Main_I = 0.0636865496635437;
        double n_48v_Main_T = 0.4083990454673767;
        double n_48v_Main_V = 0.46033036708831787;
        double purge_Fan_I = 0.5177094340324402;
        double purge_Fan_V = 0.9938944578170776;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_48VTelemetry(n_48v_Board_T, n_48v_FPGA_T, n_48v_Main_I, n_48v_Main_T, n_48v_Main_V, purge_Fan_I, purge_Fan_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48VTelemetry));
        Quadbox_PDU_48VTelemetry item_ = (Quadbox_PDU_48VTelemetry)item;
        Assert.assertEquals((double)n_48v_Board_T, (double)item_.getN_48v_Board_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_FPGA_T, (double)item_.getN_48v_FPGA_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_I, (double)item_.getN_48v_Main_I(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_T, (double)item_.getN_48v_Main_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_V, (double)item_.getN_48v_Main_V(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_I, (double)item_.getPurge_Fan_I(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_V, (double)item_.getPurge_Fan_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_5VTelemetry() throws Exception {
        double otm_0_A_I = 0.3131089210510254;
        double otm_0_A_V = 0.9489572048187256;
        double otm_0_B_I = 0.8960791230201721;
        double otm_0_B_V = 0.5843248963356018;
        double otm_1_A_I = 0.6405413150787354;
        double otm_1_A_V = 0.6184304356575012;
        double otm_1_B_I = 0.665179431438446;
        double otm_1_B_V = 0.6012641191482544;
        double otm_2_A_I = 0.7447822093963623;
        double otm_2_A_V = 0.8340408205986023;
        double otm_2_B_I = 0.01802504062652588;
        double otm_2_B_V = 0.5524716377258301;
        double otm_3_A_I = 0.011943638324737549;
        double otm_3_A_V = 0.7377426028251648;
        double otm_3_B_I = 0.04702198505401611;
        double otm_3_B_V = 0.1787082552909851;
        double otm_4_A_I = 0.3087698817253113;
        double otm_4_A_V = 0.19880056381225586;
        double otm_4_B_I = 0.47124534845352173;
        double otm_4_B_V = 0.0036298036575317383;
        double otm_5_A_I = 0.48100972175598145;
        double otm_5_A_V = 0.27893543243408203;
        double otm_5_B_I = 0.5872438549995422;
        double otm_5_B_V = 0.742646336555481;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_5VTelemetry(otm_0_A_I, otm_0_A_V, otm_0_B_I, otm_0_B_V, otm_1_A_I, otm_1_A_V, otm_1_B_I, otm_1_B_V, otm_2_A_I, otm_2_A_V, otm_2_B_I, otm_2_B_V, otm_3_A_I, otm_3_A_V, otm_3_B_I, otm_3_B_V, otm_4_A_I, otm_4_A_V, otm_4_B_I, otm_4_B_V, otm_5_A_I, otm_5_A_V, otm_5_B_I, otm_5_B_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5VTelemetry));
        Quadbox_PDU_5VTelemetry item_ = (Quadbox_PDU_5VTelemetry)item;
        Assert.assertEquals((double)otm_0_A_I, (double)item_.getOtm_0_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_V, (double)item_.getOtm_0_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I, (double)item_.getOtm_0_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_V, (double)item_.getOtm_0_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_I, (double)item_.getOtm_1_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_V, (double)item_.getOtm_1_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_I, (double)item_.getOtm_1_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_V, (double)item_.getOtm_1_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_I, (double)item_.getOtm_2_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_V, (double)item_.getOtm_2_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_I, (double)item_.getOtm_2_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_V, (double)item_.getOtm_2_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I, (double)item_.getOtm_3_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V, (double)item_.getOtm_3_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I, (double)item_.getOtm_3_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V, (double)item_.getOtm_3_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_I, (double)item_.getOtm_4_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_V, (double)item_.getOtm_4_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_I, (double)item_.getOtm_4_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_V, (double)item_.getOtm_4_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_I, (double)item_.getOtm_5_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_V, (double)item_.getOtm_5_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_I, (double)item_.getOtm_5_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_V, (double)item_.getOtm_5_B_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_REB_Bulk_PSTelemetry() throws Exception {
        double rebbulkps_0_2_I = 0.8933253288269043;
        double rebbulkps_0_2_T = 0.30920177698135376;
        double rebbulkps_0_2_V = 0.00541454553604126;
        double rebbulkps_3_5_I = 0.19430255889892578;
        double rebbulkps_3_5_T = 0.35901355743408203;
        double rebbulkps_3_5_V = 0.8537948727607727;
        double rebbulkps_6_8_I = 0.833575963973999;
        double rebbulkps_6_8_T = 0.5199798941612244;
        double rebbulkps_6_8_V = 0.1956416368484497;
        double rebbulkps_9_12_I = 0.020608484745025635;
        double rebbulkps_9_12_T = 0.5128569602966309;
        double rebbulkps_9_12_V = 0.8297645449638367;
        double rebbulkps_Brd_T = 0.5471782684326172;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_REB_Bulk_PSTelemetry(rebbulkps_0_2_I, rebbulkps_0_2_T, rebbulkps_0_2_V, rebbulkps_3_5_I, rebbulkps_3_5_T, rebbulkps_3_5_V, rebbulkps_6_8_I, rebbulkps_6_8_T, rebbulkps_6_8_V, rebbulkps_9_12_I, rebbulkps_9_12_T, rebbulkps_9_12_V, rebbulkps_Brd_T));
        Assert.assertTrue((boolean)(item instanceof Quadbox_REB_Bulk_PSTelemetry));
        Quadbox_REB_Bulk_PSTelemetry item_ = (Quadbox_REB_Bulk_PSTelemetry)item;
        Assert.assertEquals((double)rebbulkps_0_2_I, (double)item_.getRebbulkps_0_2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_T, (double)item_.getRebbulkps_0_2_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_V, (double)item_.getRebbulkps_0_2_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_I, (double)item_.getRebbulkps_3_5_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_T, (double)item_.getRebbulkps_3_5_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_V, (double)item_.getRebbulkps_3_5_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_I, (double)item_.getRebbulkps_6_8_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_T, (double)item_.getRebbulkps_6_8_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_V, (double)item_.getRebbulkps_6_8_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_I, (double)item_.getRebbulkps_9_12_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_T, (double)item_.getRebbulkps_9_12_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_V, (double)item_.getRebbulkps_9_12_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_Brd_T, (double)item_.getRebbulkps_Brd_T(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebTelemetry() throws Exception {
        double[] analog_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)-1404655361);
        double[] analog_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)1977123394);
        double[] analog_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)355619897);
        double[] analog_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)151732710);
        double[] analog_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)892753357);
        double[] clockhi_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)560623125);
        double[] clockhi_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)670425753);
        double[] clockhi_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)-2108236033);
        double[] clockhi_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)1088325540);
        double[] clockhi_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)-1859422243);
        double[] clocklo_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)-895413842);
        double[] clocklo_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)1867358848);
        double[] clocklo_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)700461817);
        double[] clocklo_VaftLDO2 = TestHelper.generateDoubleArray((int)71, (int)473916782);
        double[] clocklo_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)341327560);
        double[] clocklo_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)-624719503);
        double[] digital_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)-1005964950);
        double[] digital_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-1369124396);
        double[] digital_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)1463700686);
        double[] digital_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-390454629);
        double[] digital_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)-503307026);
        double[] dphi_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)601137782);
        double[] dphi_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)923262101);
        double[] dphi_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)2098922057);
        double[] dphi_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-2045781427);
        double[] dphi_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)767634039);
        double[] heater_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)-2061945227);
        double[] heater_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-2134954414);
        double[] heater_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)-38412589);
        double[] heater_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)1041866847);
        double[] heater_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)-375342822);
        double[] hvbias_IbefSwch = TestHelper.generateDoubleArray((int)71, (int)-1531787691);
        double[] hvbias_VbefSwch = TestHelper.generateDoubleArray((int)71, (int)-450282176);
        String location = "";
        double[] od_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)-2048335465);
        double[] od_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-53187514);
        double[] od_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)114398722);
        double[] od_VaftLDO2 = TestHelper.generateDoubleArray((int)71, (int)-594541952);
        double[] od_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-600162112);
        double[] od_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)-1092341462);
        double[] power = TestHelper.generateDoubleArray((int)71, (int)1510606501);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebTelemetry(analog_IaftLDO, analog_IbefLDO, analog_VaftLDO, analog_VaftSwch, analog_VbefLDO, clockhi_IaftLDO, clockhi_IbefLDO, clockhi_VaftLDO, clockhi_VaftSwch, clockhi_VbefLDO, clocklo_IaftLDO, clocklo_IbefLDO, clocklo_VaftLDO, clocklo_VaftLDO2, clocklo_VaftSwch, clocklo_VbefLDO, digital_IaftLDO, digital_IbefLDO, digital_VaftLDO, digital_VaftSwch, digital_VbefLDO, dphi_IaftLDO, dphi_IbefLDO, dphi_VaftLDO, dphi_VaftSwch, dphi_VbefLDO, heater_IaftLDO, heater_IbefLDO, heater_VaftLDO, heater_VaftSwch, heater_VbefLDO, hvbias_IbefSwch, hvbias_VbefSwch, location, od_IaftLDO, od_IbefLDO, od_VaftLDO, od_VaftLDO2, od_VaftSwch, od_VbefLDO, power));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebTelemetry));
        Rebpower_RebTelemetry item_ = (Rebpower_RebTelemetry)item;
        Assert.assertArrayEquals((double[])analog_IaftLDO, (double[])item_.getAnalog_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO, (double[])item_.getAnalog_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO, (double[])item_.getAnalog_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch, (double[])item_.getAnalog_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO, (double[])item_.getAnalog_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO, (double[])item_.getClockhi_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO, (double[])item_.getClockhi_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO, (double[])item_.getClockhi_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch, (double[])item_.getClockhi_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO, (double[])item_.getClockhi_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO, (double[])item_.getClocklo_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO, (double[])item_.getClocklo_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO, (double[])item_.getClocklo_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2, (double[])item_.getClocklo_VaftLDO2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch, (double[])item_.getClocklo_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO, (double[])item_.getClocklo_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO, (double[])item_.getDigital_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO, (double[])item_.getDigital_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO, (double[])item_.getDigital_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch, (double[])item_.getDigital_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO, (double[])item_.getDigital_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IaftLDO, (double[])item_.getDphi_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IbefLDO, (double[])item_.getDphi_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftLDO, (double[])item_.getDphi_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftSwch, (double[])item_.getDphi_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VbefLDO, (double[])item_.getDphi_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO, (double[])item_.getHeater_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO, (double[])item_.getHeater_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO, (double[])item_.getHeater_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch, (double[])item_.getHeater_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO, (double[])item_.getHeater_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch, (double[])item_.getHvbias_IbefSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch, (double[])item_.getHvbias_VbefSwch(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])od_IaftLDO, (double[])item_.getOd_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO, (double[])item_.getOd_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO, (double[])item_.getOd_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2, (double[])item_.getOd_VaftLDO2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch, (double[])item_.getOd_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO, (double[])item_.getOd_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebpsTelemetry() throws Exception {
        double[] boardTemp0 = TestHelper.generateDoubleArray((int)13, (int)-887226635);
        double[] boardTemp1 = TestHelper.generateDoubleArray((int)13, (int)1180103096);
        double[] boardTemp2 = TestHelper.generateDoubleArray((int)13, (int)1242434078);
        double[] boardTemp3 = TestHelper.generateDoubleArray((int)13, (int)-169438070);
        double[] boardTemp4 = TestHelper.generateDoubleArray((int)13, (int)1051915474);
        double[] boardTemp5 = TestHelper.generateDoubleArray((int)13, (int)-769759800);
        double[] boardTemp6 = TestHelper.generateDoubleArray((int)13, (int)20451741);
        String location = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebpsTelemetry(boardTemp0, boardTemp1, boardTemp2, boardTemp3, boardTemp4, boardTemp5, boardTemp6, location));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebpsTelemetry));
        Rebpower_RebpsTelemetry item_ = (Rebpower_RebpsTelemetry)item;
        Assert.assertArrayEquals((double[])boardTemp0, (double[])item_.getBoardTemp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp1, (double[])item_.getBoardTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp2, (double[])item_.getBoardTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp3, (double[])item_.getBoardTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp4, (double[])item_.getBoardTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp5, (double[])item_.getBoardTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp6, (double[])item_.getBoardTemp6(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveHex_Cold1Telemetry() throws Exception {
        double returnTmp = 0.16555821895599365;
        double supplyTmp = 0.27150875329971313;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cold1Telemetry(returnTmp, supplyTmp));
        Assert.assertTrue((boolean)(item instanceof Hex_Cold1Telemetry));
        Hex_Cold1Telemetry item_ = (Hex_Cold1Telemetry)item;
        Assert.assertEquals((double)returnTmp, (double)item_.getReturnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyTmp, (double)item_.getSupplyTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cold2Telemetry() throws Exception {
        double returnTmp = 0.656694f;
        double supplyTmp = 0.10323494672775269;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cold2Telemetry(returnTmp, supplyTmp));
        Assert.assertTrue((boolean)(item instanceof Hex_Cold2Telemetry));
        Hex_Cold2Telemetry item_ = (Hex_Cold2Telemetry)item;
        Assert.assertEquals((double)returnTmp, (double)item_.getReturnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyTmp, (double)item_.getSupplyTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo1Telemetry() throws Exception {
        double c3ExitTmp = 0.7840898036956787;
        double c4ExitTmp = 0.42524755001068115;
        double evapExitTmp = 0.7998093366622925;
        double hexRtrnTmp = 0.37167954444885254;
        double liquidPrs = 0.3522723913192749;
        double preC3Tmp = 0.3840165138244629;
        double preC4Tmp = 0.2980801f;
        double returnPrs = 0.01173532f;
        double vaporPrs = 0.5336012840270996;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo1Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo1Telemetry));
        Hex_Cryo1Telemetry item_ = (Hex_Cryo1Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo2Telemetry() throws Exception {
        double c3ExitTmp = 0.7146857380867004;
        double c4ExitTmp = 0.4387451410293579;
        double evapExitTmp = 0.7603783011436462;
        double hexRtrnTmp = 0.9566890597343445;
        double liquidPrs = 0.9117953777313232;
        double preC3Tmp = 0.2162758708000183;
        double preC4Tmp = 0.6132370829582214;
        double returnPrs = 0.7398157119750977;
        double vaporPrs = 0.2990939f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo2Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo2Telemetry));
        Hex_Cryo2Telemetry item_ = (Hex_Cryo2Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo3Telemetry() throws Exception {
        double c3ExitTmp = 0.6232790946960449;
        double c4ExitTmp = 0.23352354764938354;
        double evapExitTmp = 0.0970807671546936;
        double hexRtrnTmp = 0.9377151727676392;
        double liquidPrs = 0.7544595003128052;
        double preC3Tmp = 0.524128f;
        double preC4Tmp = 0.8414589166641235;
        double returnPrs = 0.5860521793365479;
        double vaporPrs = 0.003827214241027832;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo3Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo3Telemetry));
        Hex_Cryo3Telemetry item_ = (Hex_Cryo3Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo4Telemetry() throws Exception {
        double c3ExitTmp = 0.9386687278747559;
        double c4ExitTmp = 0.980285108089447;
        double evapExitTmp = 0.6908504962921143;
        double hexRtrnTmp = 0.927821f;
        double liquidPrs = 0.46268075704574585;
        double preC3Tmp = 0.06930744647979736;
        double preC4Tmp = 0.5201073288917542;
        double returnPrs = 0.5370232462882996;
        double vaporPrs = 0.47517257928848267;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo4Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo4Telemetry));
        Hex_Cryo4Telemetry item_ = (Hex_Cryo4Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo5Telemetry() throws Exception {
        double c3ExitTmp = 0.3581211566925049;
        double c4ExitTmp = 0.1934003233909607;
        double evapExitTmp = 0.9613986015319824;
        double hexRtrnTmp = 0.7286586165428162;
        double liquidPrs = 0.4688141345977783;
        double preC3Tmp = 0.6697930693626404;
        double preC4Tmp = 0.9688416719436646;
        double returnPrs = 0.2408191f;
        double vaporPrs = 0.7379346489906311;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo5Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo5Telemetry));
        Hex_Cryo5Telemetry item_ = (Hex_Cryo5Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo6Telemetry() throws Exception {
        double c3ExitTmp = 0.9411064386367798;
        double c4ExitTmp = 0.5802518129348755;
        double evapExitTmp = 0.9545862078666687;
        double hexRtrnTmp = 0.896969199180603;
        double liquidPrs = 0.3008613f;
        double preC3Tmp = 0.6579626202583313;
        double preC4Tmp = 0.03028130531311035;
        double returnPrs = 0.3365599513053894;
        double vaporPrs = 0.7464718818664551;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo6Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo6Telemetry));
        Hex_Cryo6Telemetry item_ = (Hex_Cryo6Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo1Telemetry() throws Exception {
        double afterCoolTmp = 0.5053682923316956;
        double compCurrent = 0.721122f;
        double compPower = 0.30348747968673706;
        double compVoltage = 0.28231215476989746;
        double dischrgPrs = 0.12685906887054443;
        double dischrgtmp_M = 0.04280775785446167;
        double dischrgtmp_P = 0.4164009094238281;
        double fanSpeed = 0.1602160930633545;
        double oilLevel = 0.2971833348274231;
        double oilSepTmp = 0.17291676998138428;
        double phaseSepTmp = 0.3964492678642273;
        double suctionPrs = 0.28606903553009033;
        double suctiontmp_M = 0.18219107389450073;
        double suctiontmp_P = 0.45358043909072876;
        double surgeTankTmp = 0.8229976892471313;
        double waterInTmp = 0.07878583669662476;
        double waterOutTmp = 0.1583128571510315;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo1Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo1Telemetry));
        Refrig_Cryo1Telemetry item_ = (Refrig_Cryo1Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo2Telemetry() throws Exception {
        double afterCoolTmp = 0.4715355634689331;
        double compCurrent = 0.6138122081756592;
        double compPower = 0.7616521120071411;
        double compVoltage = 0.181441068649292;
        double dischrgPrs = 0.3565155267715454;
        double dischrgtmp_M = 0.2553596f;
        double dischrgtmp_P = 0.24437177181243896;
        double fanSpeed = 0.55808025598526;
        double oilLevel = 0.7784669399261475;
        double oilSepTmp = 0.1747505f;
        double phaseSepTmp = 0.5939624309539795;
        double suctionPrs = 0.03932642936706543;
        double suctiontmp_M = 0.19584494829177856;
        double suctiontmp_P = 0.04350852966308594;
        double surgeTankTmp = 0.3487668037414551;
        double waterInTmp = 0.5736426115036011;
        double waterOutTmp = 0.4739394187927246;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo2Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo2Telemetry));
        Refrig_Cryo2Telemetry item_ = (Refrig_Cryo2Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo3Telemetry() throws Exception {
        double afterCoolTmp = 0.8685665726661682;
        double ambientTmp = 0.18529528379440308;
        double cabinetTmp = 0.8653779029846191;
        double compCurrent = 0.7696412205696106;
        double compPower = 0.9820922613143921;
        double compVoltage = 0.3635314702987671;
        double dischrgPrs = 0.6559988260269165;
        double dischrgtmp_M = 0.48620766401290894;
        double dischrgtmp_P = 0.15396034717559814;
        double fanSpeed = 0.9419606328010559;
        double oilLevel = 0.7031729221343994;
        double oilSepTmp = 0.5105147957801819;
        double phaseSepTmp = 0.0745890736579895;
        double suctionPrs = 0.5363178253173828;
        double suctiontmp_M = 0.12388885021209717;
        double suctiontmp_P = 0.93117f;
        double surgeTankTmp = 0.08772832155227661;
        double waterInTmp = 0.7913951277732849;
        double waterOutTmp = 0.7020647525787354;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo3Telemetry(afterCoolTmp, ambientTmp, cabinetTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo3Telemetry));
        Refrig_Cryo3Telemetry item_ = (Refrig_Cryo3Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo4Telemetry() throws Exception {
        double afterCoolTmp = 0.027035772800445557;
        double compCurrent = 0.87954181432724;
        double compPower = 0.2168329358100891;
        double compVoltage = 0.06456923484802246;
        double dischrgPrs = 0.7436206340789795;
        double dischrgtmp_M = 0.5795066952705383;
        double dischrgtmp_P = 0.4074091911315918;
        double fanSpeed = 0.1938508152961731;
        double oilLevel = 0.8240005373954773;
        double oilSepTmp = 0.518421471118927;
        double phaseSepTmp = 0.3058089017868042;
        double suctionPrs = 0.4776777f;
        double suctiontmp_M = 0.6191377639770508;
        double suctiontmp_P = 0.47795844078063965;
        double surgeTankTmp = 0.2792188f;
        double waterInTmp = 0.5696732997894287;
        double waterOutTmp = 0.7104860544204712;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo4Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo4Telemetry));
        Refrig_Cryo4Telemetry item_ = (Refrig_Cryo4Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo5Telemetry() throws Exception {
        double afterCoolTmp = 0.304135262966156;
        double ambientTmp = 0.656476616859436;
        double cabinetTmp = 0.43687504529953003;
        double compCurrent = 0.3795526f;
        double compPower = 0.03384626f;
        double compVoltage = 0.6241716742515564;
        double dischrgPrs = 0.5565491318702698;
        double dischrgtmp_M = 0.651703f;
        double dischrgtmp_P = 0.37985825538635254;
        double fanSpeed = 0.2004251480102539;
        double oilLevel = 0.7636793851852417;
        double oilSepTmp = 0.8251405954360962;
        double phaseSepTmp = 0.35672032833099365;
        double suctionPrs = 0.4145827293395996;
        double suctiontmp_M = 0.4782752990722656;
        double suctiontmp_P = 0.7239797711372375;
        double surgeTankTmp = 0.7197815775871277;
        double waterInTmp = 0.9183598160743713;
        double waterOutTmp = 0.20888584852218628;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo5Telemetry(afterCoolTmp, ambientTmp, cabinetTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo5Telemetry));
        Refrig_Cryo5Telemetry item_ = (Refrig_Cryo5Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo6Telemetry() throws Exception {
        double afterCoolTmp = 0.24312078952789307;
        double compCurrent = 0.5844906568527222;
        double compPower = 0.4658542275428772;
        double compVoltage = 0.35205912590026855;
        double dischrgPrs = 0.3917809f;
        double dischrgtmp_M = 0.3365342f;
        double dischrgtmp_P = 0.03115654f;
        double fanSpeed = 0.4191882014274597;
        double oilLevel = 0.004744529724121094;
        double oilSepTmp = 0.6189401745796204;
        double phaseSepTmp = 0.6160616278648376;
        double suctionPrs = 0.22007405757904053;
        double suctiontmp_M = 0.541482150554657;
        double suctiontmp_P = 0.5644496083259583;
        double surgeTankTmp = 0.9477417469024658;
        double waterInTmp = 0.03009939193725586;
        double waterOutTmp = 0.10220110416412354;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo6Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo6Telemetry));
        Refrig_Cryo6Telemetry item_ = (Refrig_Cryo6Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP1_ITelemetry() throws Exception {
        double cip1_I = 0.4452778100967407;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP1_ITelemetry(cip1_I));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP1_ITelemetry));
        Vacuum_CIP1_ITelemetry item_ = (Vacuum_CIP1_ITelemetry)item;
        Assert.assertEquals((double)cip1_I, (double)item_.getCip1_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP1_VTelemetry() throws Exception {
        double cip1_V = 0.5164448618888855;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP1_VTelemetry(cip1_V));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP1_VTelemetry));
        Vacuum_CIP1_VTelemetry item_ = (Vacuum_CIP1_VTelemetry)item;
        Assert.assertEquals((double)cip1_V, (double)item_.getCip1_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP2_ITelemetry() throws Exception {
        double cip2_I = 0.944242537021637;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP2_ITelemetry(cip2_I));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP2_ITelemetry));
        Vacuum_CIP2_ITelemetry item_ = (Vacuum_CIP2_ITelemetry)item;
        Assert.assertEquals((double)cip2_I, (double)item_.getCip2_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP2_VTelemetry() throws Exception {
        double cip2_V = 0.5786952972412109;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP2_VTelemetry(cip2_V));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP2_VTelemetry));
        Vacuum_CIP2_VTelemetry item_ = (Vacuum_CIP2_VTelemetry)item;
        Assert.assertEquals((double)cip2_V, (double)item_.getCip2_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP3_ITelemetry() throws Exception {
        double cip3_I = 0.8435121774673462;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP3_ITelemetry(cip3_I));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP3_ITelemetry));
        Vacuum_CIP3_ITelemetry item_ = (Vacuum_CIP3_ITelemetry)item;
        Assert.assertEquals((double)cip3_I, (double)item_.getCip3_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP3_VTelemetry() throws Exception {
        double cip3_V = 0.5737094879150391;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP3_VTelemetry(cip3_V));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP3_VTelemetry));
        Vacuum_CIP3_VTelemetry item_ = (Vacuum_CIP3_VTelemetry)item;
        Assert.assertEquals((double)cip3_V, (double)item_.getCip3_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP4_ITelemetry() throws Exception {
        double cip4_I = 0.0709908f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP4_ITelemetry(cip4_I));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP4_ITelemetry));
        Vacuum_CIP4_ITelemetry item_ = (Vacuum_CIP4_ITelemetry)item;
        Assert.assertEquals((double)cip4_I, (double)item_.getCip4_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP4_VTelemetry() throws Exception {
        double cip4_V = 0.05176180601119995;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP4_VTelemetry(cip4_V));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP4_VTelemetry));
        Vacuum_CIP4_VTelemetry item_ = (Vacuum_CIP4_VTelemetry)item;
        Assert.assertEquals((double)cip4_V, (double)item_.getCip4_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP5_ITelemetry() throws Exception {
        double cip5_I = 0.25011515617370605;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP5_ITelemetry(cip5_I));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP5_ITelemetry));
        Vacuum_CIP5_ITelemetry item_ = (Vacuum_CIP5_ITelemetry)item;
        Assert.assertEquals((double)cip5_I, (double)item_.getCip5_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP5_VTelemetry() throws Exception {
        double cip5_V = 0.4477531909942627;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP5_VTelemetry(cip5_V));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP5_VTelemetry));
        Vacuum_CIP5_VTelemetry item_ = (Vacuum_CIP5_VTelemetry)item;
        Assert.assertEquals((double)cip5_V, (double)item_.getCip5_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP6_ITelemetry() throws Exception {
        double cip6_I = 0.8028997182846069;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP6_ITelemetry(cip6_I));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP6_ITelemetry));
        Vacuum_CIP6_ITelemetry item_ = (Vacuum_CIP6_ITelemetry)item;
        Assert.assertEquals((double)cip6_I, (double)item_.getCip6_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP6_VTelemetry() throws Exception {
        double cip6_V = 0.4242568016052246;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP6_VTelemetry(cip6_V));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP6_VTelemetry));
        Vacuum_CIP6_VTelemetry item_ = (Vacuum_CIP6_VTelemetry)item;
        Assert.assertEquals((double)cip6_V, (double)item_.getCip6_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CryoVacTelemetry() throws Exception {
        double cryoVac = 0.5157331228256226;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CryoVacTelemetry(cryoVac));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoVacTelemetry));
        Vacuum_CryoVacTelemetry item_ = (Vacuum_CryoVacTelemetry)item;
        Assert.assertEquals((double)cryoVac, (double)item_.getCryoVac(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_ForelineVacTelemetry() throws Exception {
        double forelineVac = 0.5582222938537598;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_ForelineVacTelemetry(forelineVac));
        Assert.assertTrue((boolean)(item instanceof Vacuum_ForelineVacTelemetry));
        Vacuum_ForelineVacTelemetry item_ = (Vacuum_ForelineVacTelemetry)item;
        Assert.assertEquals((double)forelineVac, (double)item_.getForelineVac(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Hex1VacTelemetry() throws Exception {
        double hex1Vac = 0.494049608707428;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_Hex1VacTelemetry(hex1Vac));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Hex1VacTelemetry));
        Vacuum_Hex1VacTelemetry item_ = (Vacuum_Hex1VacTelemetry)item;
        Assert.assertEquals((double)hex1Vac, (double)item_.getHex1Vac(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Hex2VacTelemetry() throws Exception {
        double hex2Vac = 0.32102978229522705;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_Hex2VacTelemetry(hex2Vac));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Hex2VacTelemetry));
        Vacuum_Hex2VacTelemetry item_ = (Vacuum_Hex2VacTelemetry)item;
        Assert.assertEquals((double)hex2Vac, (double)item_.getHex2Vac(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboCurrentTelemetry() throws Exception {
        double turboCurrent = 0.7797937989234924;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboCurrentTelemetry(turboCurrent));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboCurrentTelemetry));
        Vacuum_TurboCurrentTelemetry item_ = (Vacuum_TurboCurrentTelemetry)item;
        Assert.assertEquals((double)turboCurrent, (double)item_.getTurboCurrent(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboPowerTelemetry() throws Exception {
        double turboPower = 0.8791483640670776;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboPowerTelemetry(turboPower));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboPowerTelemetry));
        Vacuum_TurboPowerTelemetry item_ = (Vacuum_TurboPowerTelemetry)item;
        Assert.assertEquals((double)turboPower, (double)item_.getTurboPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboPumpTempTelemetry() throws Exception {
        double turboPumpTemp = 0.6195932626724243;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboPumpTempTelemetry(turboPumpTemp));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboPumpTempTelemetry));
        Vacuum_TurboPumpTempTelemetry item_ = (Vacuum_TurboPumpTempTelemetry)item;
        Assert.assertEquals((double)turboPumpTemp, (double)item_.getTurboPumpTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboSpeedTelemetry() throws Exception {
        double turboSpeed = 0.42856353521347046;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboSpeedTelemetry(turboSpeed));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboSpeedTelemetry));
        Vacuum_TurboSpeedTelemetry item_ = (Vacuum_TurboSpeedTelemetry)item;
        Assert.assertEquals((double)turboSpeed, (double)item_.getTurboSpeed(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboVacTelemetry() throws Exception {
        double turboVac = 0.7638687491416931;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboVacTelemetry(turboVac));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboVacTelemetry));
        Vacuum_TurboVacTelemetry item_ = (Vacuum_TurboVacTelemetry)item;
        Assert.assertEquals((double)turboVac, (double)item_.getTurboVac(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboVoltageTelemetry() throws Exception {
        double turboVoltage = 0.9366223216056824;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboVoltageTelemetry(turboVoltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboVoltageTelemetry));
        Vacuum_TurboVoltageTelemetry item_ = (Vacuum_TurboVoltageTelemetry)item;
        Assert.assertEquals((double)turboVoltage, (double)item_.getTurboVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_Reb_TrendingTelemetry() throws Exception {
        long[] driver_errors = TestHelper.generateLongArray((int)71, (int)198332769);
        long[] driver_received = TestHelper.generateLongArray((int)71, (int)1399554548);
        long[] driver_rx0 = TestHelper.generateLongArray((int)71, (int)-1547150815);
        long[] driver_rx1 = TestHelper.generateLongArray((int)71, (int)834851558);
        long[] driver_rx2 = TestHelper.generateLongArray((int)71, (int)-742490327);
        long[] driver_rx3 = TestHelper.generateLongArray((int)71, (int)278143930);
        long[] firmware_cell_errors = TestHelper.generateLongArray((int)71, (int)-121080134);
        long[] firmware_last_rx = TestHelper.generateLongArray((int)71, (int)1770877858);
        long[] firmware_last_tx = TestHelper.generateLongArray((int)71, (int)-466708172);
        long[] firmware_link_down = TestHelper.generateLongArray((int)71, (int)371301602);
        long[] firmware_link_errors = TestHelper.generateLongArray((int)71, (int)-2036450002);
        long[] firmware_link_status = TestHelper.generateLongArray((int)71, (int)533428228);
        long[] firmware_overflow_local0 = TestHelper.generateLongArray((int)71, (int)-755712849);
        long[] firmware_overflow_local1 = TestHelper.generateLongArray((int)71, (int)-1037863751);
        long[] firmware_overflow_local2 = TestHelper.generateLongArray((int)71, (int)2004144046);
        long[] firmware_overflow_local3 = TestHelper.generateLongArray((int)71, (int)918545755);
        long[] firmware_overflow_remote0 = TestHelper.generateLongArray((int)71, (int)1548576812);
        long[] firmware_overflow_remote1 = TestHelper.generateLongArray((int)71, (int)-720153231);
        long[] firmware_overflow_remote2 = TestHelper.generateLongArray((int)71, (int)-1291888977);
        long[] firmware_overflow_remote3 = TestHelper.generateLongArray((int)71, (int)-238358361);
        long[] firmware_rlink_data = TestHelper.generateLongArray((int)71, (int)928399850);
        long[] firmware_rx_clock = TestHelper.generateLongArray((int)71, (int)1563987728);
        long[] firmware_rx_errors = TestHelper.generateLongArray((int)71, (int)-798033204);
        long[] firmware_rx_frames = TestHelper.generateLongArray((int)71, (int)265829555);
        long[] firmware_rx_op = TestHelper.generateLongArray((int)71, (int)-181109159);
        long[] firmware_tx_clock = TestHelper.generateLongArray((int)71, (int)869029292);
        long[] firmware_tx_errors = TestHelper.generateLongArray((int)71, (int)1588861163);
        long[] firmware_tx_frames = TestHelper.generateLongArray((int)71, (int)1831495017);
        long[] firmware_tx_op = TestHelper.generateLongArray((int)71, (int)224176860);
        String location = "l";
        long[] rds_bdi_firsts = TestHelper.generateLongArray((int)71, (int)1224961121);
        long[] rds_bdi_frees = TestHelper.generateLongArray((int)71, (int)1212539088);
        long[] rds_bdi_lasts = TestHelper.generateLongArray((int)71, (int)852705873);
        long[] rds_bdi_nulls = TestHelper.generateLongArray((int)71, (int)160394445);
        long[] rds_bdi_overflows = TestHelper.generateLongArray((int)71, (int)-611394886);
        long[] rds_bdi_seq_errors = TestHelper.generateLongArray((int)71, (int)-168909620);
        long[] rds_bdi_waits = TestHelper.generateLongArray((int)71, (int)1290174990);
        long[] rds_discards = TestHelper.generateLongArray((int)71, (int)-993397103);
        long[] rds_no_event = TestHelper.generateLongArray((int)71, (int)-1989432275);
        long[] rds_wakes = TestHelper.generateLongArray((int)71, (int)-684067286);
        long[] rms_in_reset = TestHelper.generateLongArray((int)71, (int)-1195188908);
        long[] rms_inv_tids = TestHelper.generateLongArray((int)71, (int)1075929698);
        long[] rms_link_down = TestHelper.generateLongArray((int)71, (int)830560095);
        long[] rms_lists_posted = TestHelper.generateLongArray((int)71, (int)747590342);
        long[] rms_ops_posted = TestHelper.generateLongArray((int)71, (int)722072377);
        long[] rms_orphans = TestHelper.generateLongArray((int)71, (int)-577998989);
        long[] rms_probes = TestHelper.generateLongArray((int)71, (int)-525564043);
        long[] rms_responses = TestHelper.generateLongArray((int)71, (int)-779046139);
        long[] rms_rundowns = TestHelper.generateLongArray((int)71, (int)1467283546);
        long[] rms_tid_hwm = TestHelper.generateLongArray((int)71, (int)-1293979300);
        long[] rms_unopened = TestHelper.generateLongArray((int)71, (int)-1970971923);
        long[] rms_waits = TestHelper.generateLongArray((int)71, (int)-916078055);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_Reb_TrendingTelemetry(driver_errors, driver_received, driver_rx0, driver_rx1, driver_rx2, driver_rx3, firmware_cell_errors, firmware_last_rx, firmware_last_tx, firmware_link_down, firmware_link_errors, firmware_link_status, firmware_overflow_local0, firmware_overflow_local1, firmware_overflow_local2, firmware_overflow_local3, firmware_overflow_remote0, firmware_overflow_remote1, firmware_overflow_remote2, firmware_overflow_remote3, firmware_rlink_data, firmware_rx_clock, firmware_rx_errors, firmware_rx_frames, firmware_rx_op, firmware_tx_clock, firmware_tx_errors, firmware_tx_frames, firmware_tx_op, location, rds_bdi_firsts, rds_bdi_frees, rds_bdi_lasts, rds_bdi_nulls, rds_bdi_overflows, rds_bdi_seq_errors, rds_bdi_waits, rds_discards, rds_no_event, rds_wakes, rms_in_reset, rms_inv_tids, rms_link_down, rms_lists_posted, rms_ops_posted, rms_orphans, rms_probes, rms_responses, rms_rundowns, rms_tid_hwm, rms_unopened, rms_waits));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Reb_TrendingTelemetry));
        Daq_monitor_Reb_TrendingTelemetry item_ = (Daq_monitor_Reb_TrendingTelemetry)item;
        Assert.assertArrayEquals((long[])driver_errors, (long[])item_.getDriver_errors());
        Assert.assertArrayEquals((long[])driver_received, (long[])item_.getDriver_received());
        Assert.assertArrayEquals((long[])driver_rx0, (long[])item_.getDriver_rx0());
        Assert.assertArrayEquals((long[])driver_rx1, (long[])item_.getDriver_rx1());
        Assert.assertArrayEquals((long[])driver_rx2, (long[])item_.getDriver_rx2());
        Assert.assertArrayEquals((long[])driver_rx3, (long[])item_.getDriver_rx3());
        Assert.assertArrayEquals((long[])firmware_cell_errors, (long[])item_.getFirmware_cell_errors());
        Assert.assertArrayEquals((long[])firmware_last_rx, (long[])item_.getFirmware_last_rx());
        Assert.assertArrayEquals((long[])firmware_last_tx, (long[])item_.getFirmware_last_tx());
        Assert.assertArrayEquals((long[])firmware_link_down, (long[])item_.getFirmware_link_down());
        Assert.assertArrayEquals((long[])firmware_link_errors, (long[])item_.getFirmware_link_errors());
        Assert.assertArrayEquals((long[])firmware_link_status, (long[])item_.getFirmware_link_status());
        Assert.assertArrayEquals((long[])firmware_overflow_local0, (long[])item_.getFirmware_overflow_local0());
        Assert.assertArrayEquals((long[])firmware_overflow_local1, (long[])item_.getFirmware_overflow_local1());
        Assert.assertArrayEquals((long[])firmware_overflow_local2, (long[])item_.getFirmware_overflow_local2());
        Assert.assertArrayEquals((long[])firmware_overflow_local3, (long[])item_.getFirmware_overflow_local3());
        Assert.assertArrayEquals((long[])firmware_overflow_remote0, (long[])item_.getFirmware_overflow_remote0());
        Assert.assertArrayEquals((long[])firmware_overflow_remote1, (long[])item_.getFirmware_overflow_remote1());
        Assert.assertArrayEquals((long[])firmware_overflow_remote2, (long[])item_.getFirmware_overflow_remote2());
        Assert.assertArrayEquals((long[])firmware_overflow_remote3, (long[])item_.getFirmware_overflow_remote3());
        Assert.assertArrayEquals((long[])firmware_rlink_data, (long[])item_.getFirmware_rlink_data());
        Assert.assertArrayEquals((long[])firmware_rx_clock, (long[])item_.getFirmware_rx_clock());
        Assert.assertArrayEquals((long[])firmware_rx_errors, (long[])item_.getFirmware_rx_errors());
        Assert.assertArrayEquals((long[])firmware_rx_frames, (long[])item_.getFirmware_rx_frames());
        Assert.assertArrayEquals((long[])firmware_rx_op, (long[])item_.getFirmware_rx_op());
        Assert.assertArrayEquals((long[])firmware_tx_clock, (long[])item_.getFirmware_tx_clock());
        Assert.assertArrayEquals((long[])firmware_tx_errors, (long[])item_.getFirmware_tx_errors());
        Assert.assertArrayEquals((long[])firmware_tx_frames, (long[])item_.getFirmware_tx_frames());
        Assert.assertArrayEquals((long[])firmware_tx_op, (long[])item_.getFirmware_tx_op());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((long[])rds_bdi_firsts, (long[])item_.getRds_bdi_firsts());
        Assert.assertArrayEquals((long[])rds_bdi_frees, (long[])item_.getRds_bdi_frees());
        Assert.assertArrayEquals((long[])rds_bdi_lasts, (long[])item_.getRds_bdi_lasts());
        Assert.assertArrayEquals((long[])rds_bdi_nulls, (long[])item_.getRds_bdi_nulls());
        Assert.assertArrayEquals((long[])rds_bdi_overflows, (long[])item_.getRds_bdi_overflows());
        Assert.assertArrayEquals((long[])rds_bdi_seq_errors, (long[])item_.getRds_bdi_seq_errors());
        Assert.assertArrayEquals((long[])rds_bdi_waits, (long[])item_.getRds_bdi_waits());
        Assert.assertArrayEquals((long[])rds_discards, (long[])item_.getRds_discards());
        Assert.assertArrayEquals((long[])rds_no_event, (long[])item_.getRds_no_event());
        Assert.assertArrayEquals((long[])rds_wakes, (long[])item_.getRds_wakes());
        Assert.assertArrayEquals((long[])rms_in_reset, (long[])item_.getRms_in_reset());
        Assert.assertArrayEquals((long[])rms_inv_tids, (long[])item_.getRms_inv_tids());
        Assert.assertArrayEquals((long[])rms_link_down, (long[])item_.getRms_link_down());
        Assert.assertArrayEquals((long[])rms_lists_posted, (long[])item_.getRms_lists_posted());
        Assert.assertArrayEquals((long[])rms_ops_posted, (long[])item_.getRms_ops_posted());
        Assert.assertArrayEquals((long[])rms_orphans, (long[])item_.getRms_orphans());
        Assert.assertArrayEquals((long[])rms_probes, (long[])item_.getRms_probes());
        Assert.assertArrayEquals((long[])rms_responses, (long[])item_.getRms_responses());
        Assert.assertArrayEquals((long[])rms_rundowns, (long[])item_.getRms_rundowns());
        Assert.assertArrayEquals((long[])rms_tid_hwm, (long[])item_.getRms_tid_hwm());
        Assert.assertArrayEquals((long[])rms_unopened, (long[])item_.getRms_unopened());
        Assert.assertArrayEquals((long[])rms_waits, (long[])item_.getRms_waits());
    }

    @Test
    public void sendReceiveDaq_monitor_StoreTelemetry() throws Exception {
        double capacity = 0.0941278338432312;
        double freeFraction = 0.931046187877655;
        double freeSpace = 0.21988266706466675;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_StoreTelemetry(capacity, freeFraction, freeSpace));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreTelemetry));
        Daq_monitor_StoreTelemetry item_ = (Daq_monitor_StoreTelemetry)item;
        Assert.assertEquals((double)capacity, (double)item_.getCapacity(), (double)1.0E-6f);
        Assert.assertEquals((double)freeFraction, (double)item_.getFreeFraction(), (double)1.0E-6f);
        Assert.assertEquals((double)freeSpace, (double)item_.getFreeSpace(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_Sum_TrendingTelemetry() throws Exception {
        long driver_errors = 401L;
        long firmware_cell_errors = 175L;
        long firmware_link_down = 953L;
        long firmware_link_errors = 1L;
        long firmware_overflow_local0 = 419L;
        long firmware_overflow_local1 = 838L;
        long firmware_overflow_local2 = 470L;
        long firmware_overflow_remote0 = 834L;
        long firmware_overflow_remote1 = 562L;
        long firmware_overflow_remote2 = 104L;
        long firmware_rx_errors = 823L;
        long firmware_tx_errors = 582L;
        long rds_bdi_nulls = 620L;
        long rds_bdi_overflows = 168L;
        long rds_bdi_seq_errors = 67L;
        long rds_discards = 606L;
        long rds_no_event = 772L;
        long rms_in_reset = 840L;
        long rms_inv_tids = 262L;
        long rms_link_down = 184L;
        long rms_orphans = 91L;
        long rms_unopened = 201L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_Sum_TrendingTelemetry(driver_errors, firmware_cell_errors, firmware_link_down, firmware_link_errors, firmware_overflow_local0, firmware_overflow_local1, firmware_overflow_local2, firmware_overflow_remote0, firmware_overflow_remote1, firmware_overflow_remote2, firmware_rx_errors, firmware_tx_errors, rds_bdi_nulls, rds_bdi_overflows, rds_bdi_seq_errors, rds_discards, rds_no_event, rms_in_reset, rms_inv_tids, rms_link_down, rms_orphans, rms_unopened));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Sum_TrendingTelemetry));
        Daq_monitor_Sum_TrendingTelemetry item_ = (Daq_monitor_Sum_TrendingTelemetry)item;
        Assert.assertEquals((long)driver_errors, (long)item_.getDriver_errors());
        Assert.assertEquals((long)firmware_cell_errors, (long)item_.getFirmware_cell_errors());
        Assert.assertEquals((long)firmware_link_down, (long)item_.getFirmware_link_down());
        Assert.assertEquals((long)firmware_link_errors, (long)item_.getFirmware_link_errors());
        Assert.assertEquals((long)firmware_overflow_local0, (long)item_.getFirmware_overflow_local0());
        Assert.assertEquals((long)firmware_overflow_local1, (long)item_.getFirmware_overflow_local1());
        Assert.assertEquals((long)firmware_overflow_local2, (long)item_.getFirmware_overflow_local2());
        Assert.assertEquals((long)firmware_overflow_remote0, (long)item_.getFirmware_overflow_remote0());
        Assert.assertEquals((long)firmware_overflow_remote1, (long)item_.getFirmware_overflow_remote1());
        Assert.assertEquals((long)firmware_overflow_remote2, (long)item_.getFirmware_overflow_remote2());
        Assert.assertEquals((long)firmware_rx_errors, (long)item_.getFirmware_rx_errors());
        Assert.assertEquals((long)firmware_tx_errors, (long)item_.getFirmware_tx_errors());
        Assert.assertEquals((long)rds_bdi_nulls, (long)item_.getRds_bdi_nulls());
        Assert.assertEquals((long)rds_bdi_overflows, (long)item_.getRds_bdi_overflows());
        Assert.assertEquals((long)rds_bdi_seq_errors, (long)item_.getRds_bdi_seq_errors());
        Assert.assertEquals((long)rds_discards, (long)item_.getRds_discards());
        Assert.assertEquals((long)rds_no_event, (long)item_.getRds_no_event());
        Assert.assertEquals((long)rms_in_reset, (long)item_.getRms_in_reset());
        Assert.assertEquals((long)rms_inv_tids, (long)item_.getRms_inv_tids());
        Assert.assertEquals((long)rms_link_down, (long)item_.getRms_link_down());
        Assert.assertEquals((long)rms_orphans, (long)item_.getRms_orphans());
        Assert.assertEquals((long)rms_unopened, (long)item_.getRms_unopened());
    }

    @Test
    public void sendReceiveFocal_plane_CcdTelemetry() throws Exception {
        double[] gDV = TestHelper.generateDoubleArray((int)201, (int)645171529);
        String location = "";
        double[] oDI = TestHelper.generateDoubleArray((int)201, (int)-560942007);
        double[] oDV = TestHelper.generateDoubleArray((int)201, (int)1403467577);
        double[] oGV = TestHelper.generateDoubleArray((int)201, (int)-39023469);
        double[] rDV = TestHelper.generateDoubleArray((int)201, (int)-1839900890);
        double[] temp = TestHelper.generateDoubleArray((int)201, (int)1166400083);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_CcdTelemetry(gDV, location, oDI, oDV, oGV, rDV, temp));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_CcdTelemetry));
        Focal_plane_CcdTelemetry item_ = (Focal_plane_CcdTelemetry)item;
        Assert.assertArrayEquals((double[])gDV, (double[])item_.getGDV(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oGV, (double[])item_.getOGV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rDV, (double[])item_.getRDV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp, (double[])item_.getTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTelemetry() throws Exception {
        double[] anaI = TestHelper.generateDoubleArray((int)71, (int)1436765185);
        double[] anaV = TestHelper.generateDoubleArray((int)71, (int)851964601);
        double[] aspicl_Temp0 = TestHelper.generateDoubleArray((int)71, (int)-349595797);
        double[] aspicl_Temp1 = TestHelper.generateDoubleArray((int)71, (int)-1368620696);
        double[] aspicl_Temp2 = TestHelper.generateDoubleArray((int)71, (int)-1493241935);
        double[] aspicu_Temp0 = TestHelper.generateDoubleArray((int)71, (int)-1958163356);
        double[] aspicu_Temp1 = TestHelper.generateDoubleArray((int)71, (int)-634928344);
        double[] aspicu_Temp2 = TestHelper.generateDoubleArray((int)71, (int)-587097520);
        double[] clkHI = TestHelper.generateDoubleArray((int)71, (int)1738592625);
        double[] clkHV = TestHelper.generateDoubleArray((int)71, (int)-238081747);
        double[] clkLI = TestHelper.generateDoubleArray((int)71, (int)-1346326101);
        double[] clkLV = TestHelper.generateDoubleArray((int)71, (int)412939274);
        double[] digI = TestHelper.generateDoubleArray((int)71, (int)-949893159);
        double[] digV = TestHelper.generateDoubleArray((int)71, (int)977694780);
        double[] hVBiasSwitch = TestHelper.generateDoubleArray((int)71, (int)-1871058682);
        double[] htrPI = TestHelper.generateDoubleArray((int)71, (int)-171901164);
        double[] htrPV = TestHelper.generateDoubleArray((int)71, (int)-60683029);
        double[] htrV = TestHelper.generateDoubleArray((int)71, (int)1962745650);
        double[] htrW = TestHelper.generateDoubleArray((int)71, (int)-574964442);
        String location = "";
        double[] oDI = TestHelper.generateDoubleArray((int)71, (int)-102644413);
        double[] oDV = TestHelper.generateDoubleArray((int)71, (int)239014728);
        double[] pClk0 = TestHelper.generateDoubleArray((int)71, (int)-312226780);
        double[] pClk1 = TestHelper.generateDoubleArray((int)71, (int)-1449100342);
        double[] pClkL = TestHelper.generateDoubleArray((int)71, (int)1472087692);
        double[] pClkU = TestHelper.generateDoubleArray((int)71, (int)1994965176);
        double[] power = TestHelper.generateDoubleArray((int)71, (int)-596546597);
        double[] rG0 = TestHelper.generateDoubleArray((int)71, (int)-609825087);
        double[] rG1 = TestHelper.generateDoubleArray((int)71, (int)920178998);
        double[] rGL = TestHelper.generateDoubleArray((int)71, (int)-118752165);
        double[] rGU = TestHelper.generateDoubleArray((int)71, (int)1943985338);
        double[] rTDTemp = TestHelper.generateDoubleArray((int)71, (int)-1481747998);
        double[] ref05V = TestHelper.generateDoubleArray((int)71, (int)566407525);
        double[] ref125V = TestHelper.generateDoubleArray((int)71, (int)-14337133);
        double[] ref15V = TestHelper.generateDoubleArray((int)71, (int)-200714790);
        double[] ref25V = TestHelper.generateDoubleArray((int)71, (int)593392339);
        double[] refN12 = TestHelper.generateDoubleArray((int)71, (int)-296355028);
        double[] refP12 = TestHelper.generateDoubleArray((int)71, (int)-194351510);
        double[] sClk0 = TestHelper.generateDoubleArray((int)71, (int)-1221640622);
        double[] sClk1 = TestHelper.generateDoubleArray((int)71, (int)-715876977);
        double[] sClkL = TestHelper.generateDoubleArray((int)71, (int)-341748230);
        double[] sClkU = TestHelper.generateDoubleArray((int)71, (int)-794109957);
        double[] temp1 = TestHelper.generateDoubleArray((int)71, (int)412690378);
        double[] temp10 = TestHelper.generateDoubleArray((int)71, (int)1260895590);
        double[] temp2 = TestHelper.generateDoubleArray((int)71, (int)1392544596);
        double[] temp3 = TestHelper.generateDoubleArray((int)71, (int)-158758640);
        double[] temp4 = TestHelper.generateDoubleArray((int)71, (int)-524329394);
        double[] temp5 = TestHelper.generateDoubleArray((int)71, (int)1410286151);
        double[] temp6 = TestHelper.generateDoubleArray((int)71, (int)446876868);
        double[] temp7 = TestHelper.generateDoubleArray((int)71, (int)-1907203828);
        double[] temp8 = TestHelper.generateDoubleArray((int)71, (int)-1466424988);
        double[] temp9 = TestHelper.generateDoubleArray((int)71, (int)-2031544767);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTelemetry(anaI, anaV, aspicl_Temp0, aspicl_Temp1, aspicl_Temp2, aspicu_Temp0, aspicu_Temp1, aspicu_Temp2, clkHI, clkHV, clkLI, clkLV, digI, digV, hVBiasSwitch, htrPI, htrPV, htrV, htrW, location, oDI, oDV, pClk0, pClk1, pClkL, pClkU, power, rG0, rG1, rGL, rGU, rTDTemp, ref05V, ref125V, ref15V, ref25V, refN12, refP12, sClk0, sClk1, sClkL, sClkU, temp1, temp10, temp2, temp3, temp4, temp5, temp6, temp7, temp8, temp9));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTelemetry));
        Focal_plane_RebTelemetry item_ = (Focal_plane_RebTelemetry)item;
        Assert.assertArrayEquals((double[])anaI, (double[])item_.getAnaI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anaV, (double[])item_.getAnaV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0, (double[])item_.getAspicl_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1, (double[])item_.getAspicl_Temp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2, (double[])item_.getAspicl_Temp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0, (double[])item_.getAspicu_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1, (double[])item_.getAspicu_Temp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2, (double[])item_.getAspicu_Temp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHI, (double[])item_.getClkHI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHV, (double[])item_.getClkHV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLI, (double[])item_.getClkLI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLV, (double[])item_.getClkLV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digI, (double[])item_.getDigI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digV, (double[])item_.getDigV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hVBiasSwitch, (double[])item_.getHVBiasSwitch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrPI, (double[])item_.getHtrPI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrPV, (double[])item_.getHtrPV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrV, (double[])item_.getHtrV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrW, (double[])item_.getHtrW(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClk0, (double[])item_.getPClk0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClk1, (double[])item_.getPClk1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkL, (double[])item_.getPClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkU, (double[])item_.getPClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rG0, (double[])item_.getRG0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rG1, (double[])item_.getRG1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGL, (double[])item_.getRGL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGU, (double[])item_.getRGU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rTDTemp, (double[])item_.getRTDTemp(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05V, (double[])item_.getRef05V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125V, (double[])item_.getRef125V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15V, (double[])item_.getRef15V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25V, (double[])item_.getRef25V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refN12, (double[])item_.getRefN12(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refP12, (double[])item_.getRefP12(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClk0, (double[])item_.getSClk0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClk1, (double[])item_.getSClk1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkL, (double[])item_.getSClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkU, (double[])item_.getSClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1, (double[])item_.getTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10, (double[])item_.getTemp10(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2, (double[])item_.getTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3, (double[])item_.getTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4, (double[])item_.getTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5, (double[])item_.getTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6, (double[])item_.getTemp6(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7, (double[])item_.getTemp7(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8, (double[])item_.getTemp8(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9, (double[])item_.getTemp9(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTotalPowerTelemetry() throws Exception {
        double rebTotalPower = 0.21232444047927856;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTotalPowerTelemetry(rebTotalPower));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTotalPowerTelemetry));
        Focal_plane_RebTotalPowerTelemetry item_ = (Focal_plane_RebTotalPowerTelemetry)item;
        Assert.assertEquals((double)rebTotalPower, (double)item_.getRebTotalPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebsAverageTemp6Telemetry() throws Exception {
        double rebsAverageTemp6 = 0.620173990726471;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebsAverageTemp6Telemetry(rebsAverageTemp6));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebsAverageTemp6Telemetry));
        Focal_plane_RebsAverageTemp6Telemetry item_ = (Focal_plane_RebsAverageTemp6Telemetry)item;
        Assert.assertEquals((double)rebsAverageTemp6, (double)item_.getRebsAverageTemp6(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_SegmentTelemetry() throws Exception {
        double[] i = TestHelper.generateDoubleArray((int)3024, (int)-1805133217);
        String location = "h";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_SegmentTelemetry(i, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SegmentTelemetry));
        Focal_plane_SegmentTelemetry item_ = (Focal_plane_SegmentTelemetry)item;
        Assert.assertArrayEquals((double[])i, (double[])item_.getI(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFcs_AcSensorsGatewayTelemetry() throws Exception {
        boolean booted = true;
        boolean initialized = false;
        int intValues = 737;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_AcSensorsGatewayTelemetry(booted, initialized, intValues));
        Assert.assertTrue((boolean)(item instanceof Fcs_AcSensorsGatewayTelemetry));
        Fcs_AcSensorsGatewayTelemetry item_ = (Fcs_AcSensorsGatewayTelemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)intValues, (long)item_.getIntValues());
    }

    @Test
    public void sendReceiveFcs_AcTruckXminusTelemetry() throws Exception {
        int averageCurrent = 796;
        int followingError = 798;
        boolean handoffInError = true;
        boolean handoffSensorValue = true;
        boolean onlineInError = true;
        boolean onlineSensorValue = false;
        int position = 880;
        boolean standbyInError = false;
        boolean standbySensorValue = true;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_AcTruckXminusTelemetry(averageCurrent, followingError, handoffInError, handoffSensorValue, onlineInError, onlineSensorValue, position, standbyInError, standbySensorValue));
        Assert.assertTrue((boolean)(item instanceof Fcs_AcTruckXminusTelemetry));
        Fcs_AcTruckXminusTelemetry item_ = (Fcs_AcTruckXminusTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)handoffInError, (Object)item_.isHandoffInError());
        Assert.assertEquals((Object)handoffSensorValue, (Object)item_.isHandoffSensorValue());
        Assert.assertEquals((Object)onlineInError, (Object)item_.isOnlineInError());
        Assert.assertEquals((Object)onlineSensorValue, (Object)item_.isOnlineSensorValue());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((Object)standbyInError, (Object)item_.isStandbyInError());
        Assert.assertEquals((Object)standbySensorValue, (Object)item_.isStandbySensorValue());
    }

    @Test
    public void sendReceiveFcs_AcTruckXminusControllerTelemetry() throws Exception {
        boolean booted = false;
        boolean brakeActivated = false;
        boolean controllerWithBrake = false;
        int current = 408;
        int errorHistoryNB = 158;
        String errorRegister = "";
        boolean inError = false;
        boolean initialized = true;
        int lastErrorCode = 633;
        String lastErrorName = "b";
        String mode = "g";
        int position = 670;
        String state = "j";
        int velocity = 774;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_AcTruckXminusControllerTelemetry(booted, brakeActivated, controllerWithBrake, current, errorHistoryNB, errorRegister, inError, initialized, lastErrorCode, lastErrorName, mode, position, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_AcTruckXminusControllerTelemetry));
        Fcs_AcTruckXminusControllerTelemetry item_ = (Fcs_AcTruckXminusControllerTelemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((Object)controllerWithBrake, (Object)item_.isControllerWithBrake());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_AcTruckXplusTelemetry() throws Exception {
        int averageCurrent = 453;
        int followingError = 307;
        boolean handoffInError = false;
        boolean handoffSensorValue = true;
        boolean onlineInError = false;
        boolean onlineSensorValue = true;
        int position = 396;
        boolean standbyInError = true;
        boolean standbySensorValue = false;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_AcTruckXplusTelemetry(averageCurrent, followingError, handoffInError, handoffSensorValue, onlineInError, onlineSensorValue, position, standbyInError, standbySensorValue));
        Assert.assertTrue((boolean)(item instanceof Fcs_AcTruckXplusTelemetry));
        Fcs_AcTruckXplusTelemetry item_ = (Fcs_AcTruckXplusTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)handoffInError, (Object)item_.isHandoffInError());
        Assert.assertEquals((Object)handoffSensorValue, (Object)item_.isHandoffSensorValue());
        Assert.assertEquals((Object)onlineInError, (Object)item_.isOnlineInError());
        Assert.assertEquals((Object)onlineSensorValue, (Object)item_.isOnlineSensorValue());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((Object)standbyInError, (Object)item_.isStandbyInError());
        Assert.assertEquals((Object)standbySensorValue, (Object)item_.isStandbySensorValue());
    }

    @Test
    public void sendReceiveFcs_AcTruckXplusControllerTelemetry() throws Exception {
        boolean booted = false;
        boolean brakeActivated = false;
        boolean controllerWithBrake = true;
        int current = 754;
        int errorHistoryNB = 188;
        String errorRegister = "i";
        boolean inError = true;
        boolean initialized = false;
        int lastErrorCode = 141;
        String lastErrorName = "";
        String mode = "";
        int position = 705;
        String state = "";
        int velocity = 772;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_AcTruckXplusControllerTelemetry(booted, brakeActivated, controllerWithBrake, current, errorHistoryNB, errorRegister, inError, initialized, lastErrorCode, lastErrorName, mode, position, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_AcTruckXplusControllerTelemetry));
        Fcs_AcTruckXplusControllerTelemetry item_ = (Fcs_AcTruckXplusControllerTelemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((Object)controllerWithBrake, (Object)item_.isControllerWithBrake());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_AccelerobfTelemetry() throws Exception {
        double accelerationX = 0.40770626068115234;
        double accelerationY = 0.35620254278182983;
        double accelerationZ = 0.3718924f;
        double angularVelocityX = 0.691962f;
        double angularVelocityY = 0.338876f;
        double angularVelocityZ = 0.0108528733253479;
        boolean booted = false;
        int errorHistoryNB = 59;
        String errorRegister = "x";
        boolean inError = false;
        boolean initialized = false;
        int lastErrorCode = 273;
        String lastErrorName = "v";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_AccelerobfTelemetry(accelerationX, accelerationY, accelerationZ, angularVelocityX, angularVelocityY, angularVelocityZ, booted, errorHistoryNB, errorRegister, inError, initialized, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_AccelerobfTelemetry));
        Fcs_AccelerobfTelemetry item_ = (Fcs_AccelerobfTelemetry)item;
        Assert.assertEquals((double)accelerationX, (double)item_.getAccelerationX(), (double)1.0E-6f);
        Assert.assertEquals((double)accelerationY, (double)item_.getAccelerationY(), (double)1.0E-6f);
        Assert.assertEquals((double)accelerationZ, (double)item_.getAccelerationZ(), (double)1.0E-6f);
        Assert.assertEquals((double)angularVelocityX, (double)item_.getAngularVelocityX(), (double)1.0E-6f);
        Assert.assertEquals((double)angularVelocityY, (double)item_.getAngularVelocityY(), (double)1.0E-6f);
        Assert.assertEquals((double)angularVelocityZ, (double)item_.getAngularVelocityZ(), (double)1.0E-6f);
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Ai814Telemetry() throws Exception {
        boolean booted = false;
        int errorHistoryNB = 976;
        String errorRegister = "";
        boolean inError = true;
        boolean initialized = true;
        int lastErrorCode = 185;
        String lastErrorName = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Ai814Telemetry(booted, errorHistoryNB, errorRegister, inError, initialized, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Ai814Telemetry));
        Fcs_Ai814Telemetry item_ = (Fcs_Ai814Telemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_AutochangerTelemetry() throws Exception {
        boolean carouselHoldingFilter = true;
        boolean carouselHoldingFilterInError = false;
        boolean carousel_CF0 = false;
        boolean carousel_CF0_InError = true;
        boolean carousel_CF1 = true;
        boolean carousel_CF1_InError = false;
        boolean carousel_CS = false;
        boolean carousel_CS_InError = true;
        boolean enableClamps = false;
        boolean enableLatches = true;
        boolean enableRailLin1 = true;
        boolean enableRailLin2 = false;
        boolean engineeringKey = true;
        boolean engineeringkey_InError = true;
        double inclinaisonXminus = 0.47403955459594727;
        double inclinaisonXplus = 0.04435485601425171;
        boolean loaderConnectedSensorValue = true;
        boolean loaderConnectedSensorsInError = true;
        boolean loaderPresence = true;
        boolean loaderPresenceInError = false;
        boolean loader_LRH = true;
        boolean loader_LRH_InError = true;
        boolean lockOut = false;
        boolean lockOutInError = false;
        boolean lockOutShunt = false;
        boolean out_AF0 = false;
        boolean out_AF0_InError = true;
        boolean out_AF1 = true;
        boolean out_AF1_InError = false;
        boolean out_AF3 = true;
        boolean out_AF3_InError = true;
        boolean out_AIN = true;
        boolean out_AOL = false;
        boolean out_AP1 = true;
        boolean out_AP1_InError = true;
        boolean out_AP2 = false;
        boolean out_AP2_InError = true;
        boolean out_AP3 = false;
        boolean out_AP3_InError = false;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_AutochangerTelemetry(carouselHoldingFilter, carouselHoldingFilterInError, carousel_CF0, carousel_CF0_InError, carousel_CF1, carousel_CF1_InError, carousel_CS, carousel_CS_InError, enableClamps, enableLatches, enableRailLin1, enableRailLin2, engineeringKey, engineeringkey_InError, inclinaisonXminus, inclinaisonXplus, loaderConnectedSensorValue, loaderConnectedSensorsInError, loaderPresence, loaderPresenceInError, loader_LRH, loader_LRH_InError, lockOut, lockOutInError, lockOutShunt, out_AF0, out_AF0_InError, out_AF1, out_AF1_InError, out_AF3, out_AF3_InError, out_AIN, out_AOL, out_AP1, out_AP1_InError, out_AP2, out_AP2_InError, out_AP3, out_AP3_InError));
        Assert.assertTrue((boolean)(item instanceof Fcs_AutochangerTelemetry));
        Fcs_AutochangerTelemetry item_ = (Fcs_AutochangerTelemetry)item;
        Assert.assertEquals((Object)carouselHoldingFilter, (Object)item_.isCarouselHoldingFilter());
        Assert.assertEquals((Object)carouselHoldingFilterInError, (Object)item_.isCarouselHoldingFilterInError());
        Assert.assertEquals((Object)carousel_CF0, (Object)item_.isCarousel_CF0());
        Assert.assertEquals((Object)carousel_CF0_InError, (Object)item_.isCarousel_CF0_InError());
        Assert.assertEquals((Object)carousel_CF1, (Object)item_.isCarousel_CF1());
        Assert.assertEquals((Object)carousel_CF1_InError, (Object)item_.isCarousel_CF1_InError());
        Assert.assertEquals((Object)carousel_CS, (Object)item_.isCarousel_CS());
        Assert.assertEquals((Object)carousel_CS_InError, (Object)item_.isCarousel_CS_InError());
        Assert.assertEquals((Object)enableClamps, (Object)item_.isEnableClamps());
        Assert.assertEquals((Object)enableLatches, (Object)item_.isEnableLatches());
        Assert.assertEquals((Object)enableRailLin1, (Object)item_.isEnableRailLin1());
        Assert.assertEquals((Object)enableRailLin2, (Object)item_.isEnableRailLin2());
        Assert.assertEquals((Object)engineeringKey, (Object)item_.isEngineeringKey());
        Assert.assertEquals((Object)engineeringkey_InError, (Object)item_.isEngineeringkey_InError());
        Assert.assertEquals((double)inclinaisonXminus, (double)item_.getInclinaisonXminus(), (double)1.0E-6f);
        Assert.assertEquals((double)inclinaisonXplus, (double)item_.getInclinaisonXplus(), (double)1.0E-6f);
        Assert.assertEquals((Object)loaderConnectedSensorValue, (Object)item_.isLoaderConnectedSensorValue());
        Assert.assertEquals((Object)loaderConnectedSensorsInError, (Object)item_.isLoaderConnectedSensorsInError());
        Assert.assertEquals((Object)loaderPresence, (Object)item_.isLoaderPresence());
        Assert.assertEquals((Object)loaderPresenceInError, (Object)item_.isLoaderPresenceInError());
        Assert.assertEquals((Object)loader_LRH, (Object)item_.isLoader_LRH());
        Assert.assertEquals((Object)loader_LRH_InError, (Object)item_.isLoader_LRH_InError());
        Assert.assertEquals((Object)lockOut, (Object)item_.isLockOut());
        Assert.assertEquals((Object)lockOutInError, (Object)item_.isLockOutInError());
        Assert.assertEquals((Object)lockOutShunt, (Object)item_.isLockOutShunt());
        Assert.assertEquals((Object)out_AF0, (Object)item_.isOut_AF0());
        Assert.assertEquals((Object)out_AF0_InError, (Object)item_.isOut_AF0_InError());
        Assert.assertEquals((Object)out_AF1, (Object)item_.isOut_AF1());
        Assert.assertEquals((Object)out_AF1_InError, (Object)item_.isOut_AF1_InError());
        Assert.assertEquals((Object)out_AF3, (Object)item_.isOut_AF3());
        Assert.assertEquals((Object)out_AF3_InError, (Object)item_.isOut_AF3_InError());
        Assert.assertEquals((Object)out_AIN, (Object)item_.isOut_AIN());
        Assert.assertEquals((Object)out_AOL, (Object)item_.isOut_AOL());
        Assert.assertEquals((Object)out_AP1, (Object)item_.isOut_AP1());
        Assert.assertEquals((Object)out_AP1_InError, (Object)item_.isOut_AP1_InError());
        Assert.assertEquals((Object)out_AP2, (Object)item_.isOut_AP2());
        Assert.assertEquals((Object)out_AP2_InError, (Object)item_.isOut_AP2_InError());
        Assert.assertEquals((Object)out_AP3, (Object)item_.isOut_AP3());
        Assert.assertEquals((Object)out_AP3_InError, (Object)item_.isOut_AP3_InError());
    }

    @Test
    public void sendReceiveFcs_AutochangerTrucksTelemetry() throws Exception {
        boolean atHandoff = false;
        boolean atOnline = false;
        boolean atStandby = true;
        boolean homingDone = false;
        boolean inError = true;
        int masterPosition = 733;
        int slavePosition = 243;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_AutochangerTrucksTelemetry(atHandoff, atOnline, atStandby, homingDone, inError, masterPosition, slavePosition));
        Assert.assertTrue((boolean)(item instanceof Fcs_AutochangerTrucksTelemetry));
        Fcs_AutochangerTrucksTelemetry item_ = (Fcs_AutochangerTrucksTelemetry)item;
        Assert.assertEquals((Object)atHandoff, (Object)item_.isAtHandoff());
        Assert.assertEquals((Object)atOnline, (Object)item_.isAtOnline());
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)homingDone, (Object)item_.isHomingDone());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)masterPosition, (long)item_.getMasterPosition());
        Assert.assertEquals((long)slavePosition, (long)item_.getSlavePosition());
    }

    @Test
    public void sendReceiveFcs_BrakeSystemGatewayTelemetry() throws Exception {
        boolean booted = true;
        boolean initialized = false;
        int intValues = 14;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_BrakeSystemGatewayTelemetry(booted, initialized, intValues));
        Assert.assertTrue((boolean)(item instanceof Fcs_BrakeSystemGatewayTelemetry));
        Fcs_BrakeSystemGatewayTelemetry item_ = (Fcs_BrakeSystemGatewayTelemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)intValues, (long)item_.getIntValues());
    }

    @Test
    public void sendReceiveFcs_CarouselTelemetry() throws Exception {
        boolean af3 = true;
        boolean af3_InError = true;
        boolean ap1 = true;
        boolean ap1_InError = true;
        boolean ap2 = false;
        boolean ap2_InError = false;
        boolean ap3 = true;
        boolean ap3_InError = true;
        boolean atStandby = true;
        String brakeState1 = "";
        String brakeState2 = "z";
        String brakeState3 = "b";
        boolean brakesActivated = false;
        boolean caEng = true;
        boolean caeng_InError = false;
        boolean caLockout = false;
        boolean calockout_InError = true;
        String clampsStateAtStandby = "q";
        double current = 0.269934f;
        int deltaPositionAtStandby = 785;
        boolean emptyAtStandby = false;
        boolean enableBrakes = false;
        boolean enableRotation = false;
        boolean enableShutter = false;
        boolean enableUnclamp = false;
        int estimatedPosition = 961;
        String filterAtStandbyName = "";
        String filterOnAutochangerName = "i";
        boolean locked = false;
        long minLocked = 110L;
        boolean moving = false;
        boolean out_CF0 = false;
        boolean out_CF0_InError = false;
        boolean out_CF1 = true;
        boolean out_CF1_InError = false;
        boolean out_CFC = true;
        boolean out_CFC_InError = false;
        boolean out_CS = true;
        boolean out_CS_InError = false;
        int position = 361;
        int positionSensorType = 534;
        long profileAcceleration = 714L;
        long profileDeceleration = 65L;
        long profileVelocity = 208L;
        long rotationTimeout = 908L;
        long sensor1 = 132L;
        long sensor2 = 204L;
        long sensor3 = 20L;
        boolean shutterInactive = false;
        String slaveStatusAtStandby = "g";
        boolean sleep = true;
        int socketAtStandbyID = 598;
        String socketAtStandbyName = "";
        double temperature1 = 0.2683054804801941;
        double temperature2 = 0.0044209957122802734;
        double temperature3 = 0.5843737721443176;
        double temperature4 = 0.8077393174171448;
        boolean tpCheckRotation = false;
        boolean tpStopRotation = true;
        boolean tpStopUnclamp = false;
        boolean tp_InError = false;
        double velocity = 0.22961455583572388;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_CarouselTelemetry(af3, af3_InError, ap1, ap1_InError, ap2, ap2_InError, ap3, ap3_InError, atStandby, brakeState1, brakeState2, brakeState3, brakesActivated, caEng, caeng_InError, caLockout, calockout_InError, clampsStateAtStandby, current, deltaPositionAtStandby, emptyAtStandby, enableBrakes, enableRotation, enableShutter, enableUnclamp, estimatedPosition, filterAtStandbyName, filterOnAutochangerName, locked, minLocked, moving, out_CF0, out_CF0_InError, out_CF1, out_CF1_InError, out_CFC, out_CFC_InError, out_CS, out_CS_InError, position, positionSensorType, profileAcceleration, profileDeceleration, profileVelocity, rotationTimeout, sensor1, sensor2, sensor3, shutterInactive, slaveStatusAtStandby, sleep, socketAtStandbyID, socketAtStandbyName, temperature1, temperature2, temperature3, temperature4, tpCheckRotation, tpStopRotation, tpStopUnclamp, tp_InError, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_CarouselTelemetry));
        Fcs_CarouselTelemetry item_ = (Fcs_CarouselTelemetry)item;
        Assert.assertEquals((Object)af3, (Object)item_.isAf3());
        Assert.assertEquals((Object)af3_InError, (Object)item_.isAf3_InError());
        Assert.assertEquals((Object)ap1, (Object)item_.isAp1());
        Assert.assertEquals((Object)ap1_InError, (Object)item_.isAp1_InError());
        Assert.assertEquals((Object)ap2, (Object)item_.isAp2());
        Assert.assertEquals((Object)ap2_InError, (Object)item_.isAp2_InError());
        Assert.assertEquals((Object)ap3, (Object)item_.isAp3());
        Assert.assertEquals((Object)ap3_InError, (Object)item_.isAp3_InError());
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)brakeState1, (Object)item_.getBrakeState1());
        Assert.assertEquals((Object)brakeState2, (Object)item_.getBrakeState2());
        Assert.assertEquals((Object)brakeState3, (Object)item_.getBrakeState3());
        Assert.assertEquals((Object)brakesActivated, (Object)item_.isBrakesActivated());
        Assert.assertEquals((Object)caEng, (Object)item_.isCaEng());
        Assert.assertEquals((Object)caeng_InError, (Object)item_.isCaeng_InError());
        Assert.assertEquals((Object)caLockout, (Object)item_.isCaLockout());
        Assert.assertEquals((Object)calockout_InError, (Object)item_.isCalockout_InError());
        Assert.assertEquals((Object)clampsStateAtStandby, (Object)item_.getClampsStateAtStandby());
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((long)deltaPositionAtStandby, (long)item_.getDeltaPositionAtStandby());
        Assert.assertEquals((Object)emptyAtStandby, (Object)item_.isEmptyAtStandby());
        Assert.assertEquals((Object)enableBrakes, (Object)item_.isEnableBrakes());
        Assert.assertEquals((Object)enableRotation, (Object)item_.isEnableRotation());
        Assert.assertEquals((Object)enableShutter, (Object)item_.isEnableShutter());
        Assert.assertEquals((Object)enableUnclamp, (Object)item_.isEnableUnclamp());
        Assert.assertEquals((long)estimatedPosition, (long)item_.getEstimatedPosition());
        Assert.assertEquals((Object)filterAtStandbyName, (Object)item_.getFilterAtStandbyName());
        Assert.assertEquals((Object)filterOnAutochangerName, (Object)item_.getFilterOnAutochangerName());
        Assert.assertEquals((Object)locked, (Object)item_.isLocked());
        Assert.assertEquals((long)minLocked, (long)item_.getMinLocked());
        Assert.assertEquals((Object)moving, (Object)item_.isMoving());
        Assert.assertEquals((Object)out_CF0, (Object)item_.isOut_CF0());
        Assert.assertEquals((Object)out_CF0_InError, (Object)item_.isOut_CF0_InError());
        Assert.assertEquals((Object)out_CF1, (Object)item_.isOut_CF1());
        Assert.assertEquals((Object)out_CF1_InError, (Object)item_.isOut_CF1_InError());
        Assert.assertEquals((Object)out_CFC, (Object)item_.isOut_CFC());
        Assert.assertEquals((Object)out_CFC_InError, (Object)item_.isOut_CFC_InError());
        Assert.assertEquals((Object)out_CS, (Object)item_.isOut_CS());
        Assert.assertEquals((Object)out_CS_InError, (Object)item_.isOut_CS_InError());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)positionSensorType, (long)item_.getPositionSensorType());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((long)rotationTimeout, (long)item_.getRotationTimeout());
        Assert.assertEquals((long)sensor1, (long)item_.getSensor1());
        Assert.assertEquals((long)sensor2, (long)item_.getSensor2());
        Assert.assertEquals((long)sensor3, (long)item_.getSensor3());
        Assert.assertEquals((Object)shutterInactive, (Object)item_.isShutterInactive());
        Assert.assertEquals((Object)slaveStatusAtStandby, (Object)item_.getSlaveStatusAtStandby());
        Assert.assertEquals((Object)sleep, (Object)item_.isSleep());
        Assert.assertEquals((long)socketAtStandbyID, (long)item_.getSocketAtStandbyID());
        Assert.assertEquals((Object)socketAtStandbyName, (Object)item_.getSocketAtStandbyName());
        Assert.assertEquals((double)temperature1, (double)item_.getTemperature1(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature2, (double)item_.getTemperature2(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature3, (double)item_.getTemperature3(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature4, (double)item_.getTemperature4(), (double)1.0E-6f);
        Assert.assertEquals((Object)tpCheckRotation, (Object)item_.isTpCheckRotation());
        Assert.assertEquals((Object)tpStopRotation, (Object)item_.isTpStopRotation());
        Assert.assertEquals((Object)tpStopUnclamp, (Object)item_.isTpStopUnclamp());
        Assert.assertEquals((Object)tp_InError, (Object)item_.isTp_InError());
        Assert.assertEquals((double)velocity, (double)item_.getVelocity(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_CarouselControllerTelemetry() throws Exception {
        boolean booted = false;
        boolean brakeActivated = true;
        boolean controllerWithBrake = false;
        int current = 364;
        int errorHistoryNB = 49;
        String errorRegister = "w";
        boolean inError = true;
        boolean initialized = true;
        int lastErrorCode = 312;
        String lastErrorName = "q";
        String mode = "";
        int position = 155;
        String state = "s";
        int velocity = 681;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_CarouselControllerTelemetry(booted, brakeActivated, controllerWithBrake, current, errorHistoryNB, errorRegister, inError, initialized, lastErrorCode, lastErrorName, mode, position, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_CarouselControllerTelemetry));
        Fcs_CarouselControllerTelemetry item_ = (Fcs_CarouselControllerTelemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((Object)controllerWithBrake, (Object)item_.isControllerWithBrake());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_CarrierTelemetry() throws Exception {
        boolean atEngaged = false;
        boolean atHandoff = true;
        boolean atStorage = false;
        boolean controllerInError = true;
        int current = 980;
        boolean engagedSensorOn = false;
        boolean homingDone = true;
        boolean limitSwitchDownInError = false;
        boolean limitSwitchUpInError = true;
        int position = 79;
        long profileAcceleration = 590L;
        long profileDeceleration = 285L;
        long profileVelocity = 528L;
        int speed = 19;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_CarrierTelemetry(atEngaged, atHandoff, atStorage, controllerInError, current, engagedSensorOn, homingDone, limitSwitchDownInError, limitSwitchUpInError, position, profileAcceleration, profileDeceleration, profileVelocity, speed));
        Assert.assertTrue((boolean)(item instanceof Fcs_CarrierTelemetry));
        Fcs_CarrierTelemetry item_ = (Fcs_CarrierTelemetry)item;
        Assert.assertEquals((Object)atEngaged, (Object)item_.isAtEngaged());
        Assert.assertEquals((Object)atHandoff, (Object)item_.isAtHandoff());
        Assert.assertEquals((Object)atStorage, (Object)item_.isAtStorage());
        Assert.assertEquals((Object)controllerInError, (Object)item_.isControllerInError());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((Object)engagedSensorOn, (Object)item_.isEngagedSensorOn());
        Assert.assertEquals((Object)homingDone, (Object)item_.isHomingDone());
        Assert.assertEquals((Object)limitSwitchDownInError, (Object)item_.isLimitSwitchDownInError());
        Assert.assertEquals((Object)limitSwitchUpInError, (Object)item_.isLimitSwitchUpInError());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((long)speed, (long)item_.getSpeed());
    }

    @Test
    public void sendReceiveFcs_CarrierControllerTelemetry() throws Exception {
        boolean booted = false;
        boolean brakeActivated = false;
        boolean controllerWithBrake = true;
        int current = 170;
        int errorHistoryNB = 244;
        String errorRegister = "a";
        boolean inError = true;
        boolean initialized = false;
        int lastErrorCode = 631;
        String lastErrorName = "";
        String mode = "";
        int position = 426;
        String state = "j";
        int velocity = 351;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_CarrierControllerTelemetry(booted, brakeActivated, controllerWithBrake, current, errorHistoryNB, errorRegister, inError, initialized, lastErrorCode, lastErrorName, mode, position, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_CarrierControllerTelemetry));
        Fcs_CarrierControllerTelemetry item_ = (Fcs_CarrierControllerTelemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((Object)controllerWithBrake, (Object)item_.isControllerWithBrake());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_CcsVersionsTelemetry() throws Exception {
        String agent_version = "";
        String distribution_version = "l";
        String toolkit_version = "t";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_CcsVersionsTelemetry(agent_version, distribution_version, toolkit_version));
        Assert.assertTrue((boolean)(item instanceof Fcs_CcsVersionsTelemetry));
        Fcs_CcsVersionsTelemetry item_ = (Fcs_CcsVersionsTelemetry)item;
        Assert.assertEquals((Object)agent_version, (Object)item_.getAgent_version());
        Assert.assertEquals((Object)distribution_version, (Object)item_.getDistribution_version());
        Assert.assertEquals((Object)toolkit_version, (Object)item_.getToolkit_version());
    }

    @Test
    public void sendReceiveFcs_ClampXminus1Telemetry() throws Exception {
        String clampState = "";
        int filterPositionSensorValue = 668;
        int filterPresenceMinNoFilter = 390;
        int filterPresenceOffset2 = 44;
        String filterPresenceStatus = "h";
        int lockSensorOffset1 = 795;
        int lockSensorValue = 783;
        String lockStatus = "o";
        double temperature = 0.24351871013641357;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_ClampXminus1Telemetry(clampState, filterPositionSensorValue, filterPresenceMinNoFilter, filterPresenceOffset2, filterPresenceStatus, lockSensorOffset1, lockSensorValue, lockStatus, temperature));
        Assert.assertTrue((boolean)(item instanceof Fcs_ClampXminus1Telemetry));
        Fcs_ClampXminus1Telemetry item_ = (Fcs_ClampXminus1Telemetry)item;
        Assert.assertEquals((Object)clampState, (Object)item_.getClampState());
        Assert.assertEquals((long)filterPositionSensorValue, (long)item_.getFilterPositionSensorValue());
        Assert.assertEquals((long)filterPresenceMinNoFilter, (long)item_.getFilterPresenceMinNoFilter());
        Assert.assertEquals((long)filterPresenceOffset2, (long)item_.getFilterPresenceOffset2());
        Assert.assertEquals((Object)filterPresenceStatus, (Object)item_.getFilterPresenceStatus());
        Assert.assertEquals((long)lockSensorOffset1, (long)item_.getLockSensorOffset1());
        Assert.assertEquals((long)lockSensorValue, (long)item_.getLockSensorValue());
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_ClampXminus2Telemetry() throws Exception {
        String clampState = "";
        int filterPositionSensorValue = 857;
        int filterPresenceMinNoFilter = 322;
        int filterPresenceOffset2 = 596;
        String filterPresenceStatus = "";
        int lockSensorOffset1 = 447;
        int lockSensorValue = 881;
        String lockStatus = "";
        double temperature = 0.2716858983039856;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_ClampXminus2Telemetry(clampState, filterPositionSensorValue, filterPresenceMinNoFilter, filterPresenceOffset2, filterPresenceStatus, lockSensorOffset1, lockSensorValue, lockStatus, temperature));
        Assert.assertTrue((boolean)(item instanceof Fcs_ClampXminus2Telemetry));
        Fcs_ClampXminus2Telemetry item_ = (Fcs_ClampXminus2Telemetry)item;
        Assert.assertEquals((Object)clampState, (Object)item_.getClampState());
        Assert.assertEquals((long)filterPositionSensorValue, (long)item_.getFilterPositionSensorValue());
        Assert.assertEquals((long)filterPresenceMinNoFilter, (long)item_.getFilterPresenceMinNoFilter());
        Assert.assertEquals((long)filterPresenceOffset2, (long)item_.getFilterPresenceOffset2());
        Assert.assertEquals((Object)filterPresenceStatus, (Object)item_.getFilterPresenceStatus());
        Assert.assertEquals((long)lockSensorOffset1, (long)item_.getLockSensorOffset1());
        Assert.assertEquals((long)lockSensorValue, (long)item_.getLockSensorValue());
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_ClampXminus3Telemetry() throws Exception {
        String clampState = "y";
        int filterPositionSensorValue = 564;
        int filterPresenceMinNoFilter = 442;
        int filterPresenceOffset2 = 881;
        String filterPresenceStatus = "";
        int lockSensorOffset1 = 835;
        int lockSensorValue = 935;
        String lockStatus = "";
        double temperature = 0.6642115116119385;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_ClampXminus3Telemetry(clampState, filterPositionSensorValue, filterPresenceMinNoFilter, filterPresenceOffset2, filterPresenceStatus, lockSensorOffset1, lockSensorValue, lockStatus, temperature));
        Assert.assertTrue((boolean)(item instanceof Fcs_ClampXminus3Telemetry));
        Fcs_ClampXminus3Telemetry item_ = (Fcs_ClampXminus3Telemetry)item;
        Assert.assertEquals((Object)clampState, (Object)item_.getClampState());
        Assert.assertEquals((long)filterPositionSensorValue, (long)item_.getFilterPositionSensorValue());
        Assert.assertEquals((long)filterPresenceMinNoFilter, (long)item_.getFilterPresenceMinNoFilter());
        Assert.assertEquals((long)filterPresenceOffset2, (long)item_.getFilterPresenceOffset2());
        Assert.assertEquals((Object)filterPresenceStatus, (Object)item_.getFilterPresenceStatus());
        Assert.assertEquals((long)lockSensorOffset1, (long)item_.getLockSensorOffset1());
        Assert.assertEquals((long)lockSensorValue, (long)item_.getLockSensorValue());
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_ClampXminus4Telemetry() throws Exception {
        String clampState = "";
        int filterPositionSensorValue = 531;
        int filterPresenceMinNoFilter = 535;
        int filterPresenceOffset2 = 219;
        String filterPresenceStatus = "";
        int lockSensorOffset1 = 534;
        int lockSensorValue = 971;
        String lockStatus = "";
        double temperature = 0.15407198667526245;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_ClampXminus4Telemetry(clampState, filterPositionSensorValue, filterPresenceMinNoFilter, filterPresenceOffset2, filterPresenceStatus, lockSensorOffset1, lockSensorValue, lockStatus, temperature));
        Assert.assertTrue((boolean)(item instanceof Fcs_ClampXminus4Telemetry));
        Fcs_ClampXminus4Telemetry item_ = (Fcs_ClampXminus4Telemetry)item;
        Assert.assertEquals((Object)clampState, (Object)item_.getClampState());
        Assert.assertEquals((long)filterPositionSensorValue, (long)item_.getFilterPositionSensorValue());
        Assert.assertEquals((long)filterPresenceMinNoFilter, (long)item_.getFilterPresenceMinNoFilter());
        Assert.assertEquals((long)filterPresenceOffset2, (long)item_.getFilterPresenceOffset2());
        Assert.assertEquals((Object)filterPresenceStatus, (Object)item_.getFilterPresenceStatus());
        Assert.assertEquals((long)lockSensorOffset1, (long)item_.getLockSensorOffset1());
        Assert.assertEquals((long)lockSensorValue, (long)item_.getLockSensorValue());
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_ClampXminus5Telemetry() throws Exception {
        String clampState = "";
        int filterPositionSensorValue = 651;
        int filterPresenceMinNoFilter = 271;
        int filterPresenceOffset2 = 233;
        String filterPresenceStatus = "";
        int lockSensorOffset1 = 750;
        int lockSensorValue = 232;
        String lockStatus = "l";
        double temperature = 0.5463930368423462;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_ClampXminus5Telemetry(clampState, filterPositionSensorValue, filterPresenceMinNoFilter, filterPresenceOffset2, filterPresenceStatus, lockSensorOffset1, lockSensorValue, lockStatus, temperature));
        Assert.assertTrue((boolean)(item instanceof Fcs_ClampXminus5Telemetry));
        Fcs_ClampXminus5Telemetry item_ = (Fcs_ClampXminus5Telemetry)item;
        Assert.assertEquals((Object)clampState, (Object)item_.getClampState());
        Assert.assertEquals((long)filterPositionSensorValue, (long)item_.getFilterPositionSensorValue());
        Assert.assertEquals((long)filterPresenceMinNoFilter, (long)item_.getFilterPresenceMinNoFilter());
        Assert.assertEquals((long)filterPresenceOffset2, (long)item_.getFilterPresenceOffset2());
        Assert.assertEquals((Object)filterPresenceStatus, (Object)item_.getFilterPresenceStatus());
        Assert.assertEquals((long)lockSensorOffset1, (long)item_.getLockSensorOffset1());
        Assert.assertEquals((long)lockSensorValue, (long)item_.getLockSensorValue());
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_ClampXminusControllerTelemetry() throws Exception {
        boolean booted = true;
        boolean brakeActivated = true;
        boolean controllerWithBrake = false;
        int current = 2;
        int errorHistoryNB = 326;
        String errorRegister = "";
        boolean inError = true;
        boolean initialized = true;
        int lastErrorCode = 428;
        String lastErrorName = "";
        String mode = "c";
        int position = 212;
        String state = "";
        int velocity = 104;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_ClampXminusControllerTelemetry(booted, brakeActivated, controllerWithBrake, current, errorHistoryNB, errorRegister, inError, initialized, lastErrorCode, lastErrorName, mode, position, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_ClampXminusControllerTelemetry));
        Fcs_ClampXminusControllerTelemetry item_ = (Fcs_ClampXminusControllerTelemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((Object)controllerWithBrake, (Object)item_.isControllerWithBrake());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_ClampXplus1Telemetry() throws Exception {
        String clampState = "f";
        int filterPositionSensorValue = 149;
        int filterPresenceMinNoFilter = 876;
        int filterPresenceOffset2 = 61;
        String filterPresenceStatus = "";
        int lockSensorOffset1 = 344;
        int lockSensorValue = 126;
        String lockStatus = "";
        double temperature = 0.7161108255386353;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_ClampXplus1Telemetry(clampState, filterPositionSensorValue, filterPresenceMinNoFilter, filterPresenceOffset2, filterPresenceStatus, lockSensorOffset1, lockSensorValue, lockStatus, temperature));
        Assert.assertTrue((boolean)(item instanceof Fcs_ClampXplus1Telemetry));
        Fcs_ClampXplus1Telemetry item_ = (Fcs_ClampXplus1Telemetry)item;
        Assert.assertEquals((Object)clampState, (Object)item_.getClampState());
        Assert.assertEquals((long)filterPositionSensorValue, (long)item_.getFilterPositionSensorValue());
        Assert.assertEquals((long)filterPresenceMinNoFilter, (long)item_.getFilterPresenceMinNoFilter());
        Assert.assertEquals((long)filterPresenceOffset2, (long)item_.getFilterPresenceOffset2());
        Assert.assertEquals((Object)filterPresenceStatus, (Object)item_.getFilterPresenceStatus());
        Assert.assertEquals((long)lockSensorOffset1, (long)item_.getLockSensorOffset1());
        Assert.assertEquals((long)lockSensorValue, (long)item_.getLockSensorValue());
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_ClampXplus2Telemetry() throws Exception {
        String clampState = "";
        int filterPositionSensorValue = 153;
        int filterPresenceMinNoFilter = 728;
        int filterPresenceOffset2 = 71;
        String filterPresenceStatus = "";
        int lockSensorOffset1 = 965;
        int lockSensorValue = 721;
        String lockStatus = "y";
        double temperature = 0.5677422881126404;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_ClampXplus2Telemetry(clampState, filterPositionSensorValue, filterPresenceMinNoFilter, filterPresenceOffset2, filterPresenceStatus, lockSensorOffset1, lockSensorValue, lockStatus, temperature));
        Assert.assertTrue((boolean)(item instanceof Fcs_ClampXplus2Telemetry));
        Fcs_ClampXplus2Telemetry item_ = (Fcs_ClampXplus2Telemetry)item;
        Assert.assertEquals((Object)clampState, (Object)item_.getClampState());
        Assert.assertEquals((long)filterPositionSensorValue, (long)item_.getFilterPositionSensorValue());
        Assert.assertEquals((long)filterPresenceMinNoFilter, (long)item_.getFilterPresenceMinNoFilter());
        Assert.assertEquals((long)filterPresenceOffset2, (long)item_.getFilterPresenceOffset2());
        Assert.assertEquals((Object)filterPresenceStatus, (Object)item_.getFilterPresenceStatus());
        Assert.assertEquals((long)lockSensorOffset1, (long)item_.getLockSensorOffset1());
        Assert.assertEquals((long)lockSensorValue, (long)item_.getLockSensorValue());
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_ClampXplus3Telemetry() throws Exception {
        String clampState = "v";
        int filterPositionSensorValue = 351;
        int filterPresenceMinNoFilter = 351;
        int filterPresenceOffset2 = 386;
        String filterPresenceStatus = "g";
        int lockSensorOffset1 = 578;
        int lockSensorValue = 735;
        String lockStatus = "";
        double temperature = 0.931940495967865;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_ClampXplus3Telemetry(clampState, filterPositionSensorValue, filterPresenceMinNoFilter, filterPresenceOffset2, filterPresenceStatus, lockSensorOffset1, lockSensorValue, lockStatus, temperature));
        Assert.assertTrue((boolean)(item instanceof Fcs_ClampXplus3Telemetry));
        Fcs_ClampXplus3Telemetry item_ = (Fcs_ClampXplus3Telemetry)item;
        Assert.assertEquals((Object)clampState, (Object)item_.getClampState());
        Assert.assertEquals((long)filterPositionSensorValue, (long)item_.getFilterPositionSensorValue());
        Assert.assertEquals((long)filterPresenceMinNoFilter, (long)item_.getFilterPresenceMinNoFilter());
        Assert.assertEquals((long)filterPresenceOffset2, (long)item_.getFilterPresenceOffset2());
        Assert.assertEquals((Object)filterPresenceStatus, (Object)item_.getFilterPresenceStatus());
        Assert.assertEquals((long)lockSensorOffset1, (long)item_.getLockSensorOffset1());
        Assert.assertEquals((long)lockSensorValue, (long)item_.getLockSensorValue());
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_ClampXplus4Telemetry() throws Exception {
        String clampState = "f";
        int filterPositionSensorValue = 886;
        int filterPresenceMinNoFilter = 447;
        int filterPresenceOffset2 = 706;
        String filterPresenceStatus = "h";
        int lockSensorOffset1 = 993;
        int lockSensorValue = 356;
        String lockStatus = "t";
        double temperature = 0.9630666375160217;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_ClampXplus4Telemetry(clampState, filterPositionSensorValue, filterPresenceMinNoFilter, filterPresenceOffset2, filterPresenceStatus, lockSensorOffset1, lockSensorValue, lockStatus, temperature));
        Assert.assertTrue((boolean)(item instanceof Fcs_ClampXplus4Telemetry));
        Fcs_ClampXplus4Telemetry item_ = (Fcs_ClampXplus4Telemetry)item;
        Assert.assertEquals((Object)clampState, (Object)item_.getClampState());
        Assert.assertEquals((long)filterPositionSensorValue, (long)item_.getFilterPositionSensorValue());
        Assert.assertEquals((long)filterPresenceMinNoFilter, (long)item_.getFilterPresenceMinNoFilter());
        Assert.assertEquals((long)filterPresenceOffset2, (long)item_.getFilterPresenceOffset2());
        Assert.assertEquals((Object)filterPresenceStatus, (Object)item_.getFilterPresenceStatus());
        Assert.assertEquals((long)lockSensorOffset1, (long)item_.getLockSensorOffset1());
        Assert.assertEquals((long)lockSensorValue, (long)item_.getLockSensorValue());
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_ClampXplus5Telemetry() throws Exception {
        String clampState = "";
        int filterPositionSensorValue = 482;
        int filterPresenceMinNoFilter = 593;
        int filterPresenceOffset2 = 740;
        String filterPresenceStatus = "";
        int lockSensorOffset1 = 59;
        int lockSensorValue = 92;
        String lockStatus = "o";
        double temperature = 0.028420686721801758;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_ClampXplus5Telemetry(clampState, filterPositionSensorValue, filterPresenceMinNoFilter, filterPresenceOffset2, filterPresenceStatus, lockSensorOffset1, lockSensorValue, lockStatus, temperature));
        Assert.assertTrue((boolean)(item instanceof Fcs_ClampXplus5Telemetry));
        Fcs_ClampXplus5Telemetry item_ = (Fcs_ClampXplus5Telemetry)item;
        Assert.assertEquals((Object)clampState, (Object)item_.getClampState());
        Assert.assertEquals((long)filterPositionSensorValue, (long)item_.getFilterPositionSensorValue());
        Assert.assertEquals((long)filterPresenceMinNoFilter, (long)item_.getFilterPresenceMinNoFilter());
        Assert.assertEquals((long)filterPresenceOffset2, (long)item_.getFilterPresenceOffset2());
        Assert.assertEquals((Object)filterPresenceStatus, (Object)item_.getFilterPresenceStatus());
        Assert.assertEquals((long)lockSensorOffset1, (long)item_.getLockSensorOffset1());
        Assert.assertEquals((long)lockSensorValue, (long)item_.getLockSensorValue());
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_ClampXplusControllerTelemetry() throws Exception {
        boolean booted = true;
        boolean brakeActivated = false;
        boolean controllerWithBrake = true;
        int current = 246;
        int errorHistoryNB = 531;
        String errorRegister = "q";
        boolean inError = true;
        boolean initialized = false;
        int lastErrorCode = 401;
        String lastErrorName = "";
        String mode = "";
        int position = 17;
        String state = "";
        int velocity = 540;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_ClampXplusControllerTelemetry(booted, brakeActivated, controllerWithBrake, current, errorHistoryNB, errorRegister, inError, initialized, lastErrorCode, lastErrorName, mode, position, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_ClampXplusControllerTelemetry));
        Fcs_ClampXplusControllerTelemetry item_ = (Fcs_ClampXplusControllerTelemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((Object)controllerWithBrake, (Object)item_.isControllerWithBrake());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_ConfigTelemetry() throws Exception {
        String data_Devices_checksum = "";
        String data_General_checksum = "";
        String data_Limits_checksum = "h";
        String data_autochanger_checksum = "o";
        String data_canbus_checksum = "";
        String data_carousel_checksum = "";
        String data_controller_checksum = "";
        String data_filter_checksum = "f";
        String data_loader_checksum = "v";
        String data_nodeID_checksum = "";
        String data_readRate_checksum = "l";
        String data_sensor_checksum = "b";
        String data_serialNB_checksum = "p";
        String data_timers_checksum = "j";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_ConfigTelemetry(data_Devices_checksum, data_General_checksum, data_Limits_checksum, data_autochanger_checksum, data_canbus_checksum, data_carousel_checksum, data_controller_checksum, data_filter_checksum, data_loader_checksum, data_nodeID_checksum, data_readRate_checksum, data_sensor_checksum, data_serialNB_checksum, data_timers_checksum));
        Assert.assertTrue((boolean)(item instanceof Fcs_ConfigTelemetry));
        Fcs_ConfigTelemetry item_ = (Fcs_ConfigTelemetry)item;
        Assert.assertEquals((Object)data_Devices_checksum, (Object)item_.getData_Devices_checksum());
        Assert.assertEquals((Object)data_General_checksum, (Object)item_.getData_General_checksum());
        Assert.assertEquals((Object)data_Limits_checksum, (Object)item_.getData_Limits_checksum());
        Assert.assertEquals((Object)data_autochanger_checksum, (Object)item_.getData_autochanger_checksum());
        Assert.assertEquals((Object)data_canbus_checksum, (Object)item_.getData_canbus_checksum());
        Assert.assertEquals((Object)data_carousel_checksum, (Object)item_.getData_carousel_checksum());
        Assert.assertEquals((Object)data_controller_checksum, (Object)item_.getData_controller_checksum());
        Assert.assertEquals((Object)data_filter_checksum, (Object)item_.getData_filter_checksum());
        Assert.assertEquals((Object)data_loader_checksum, (Object)item_.getData_loader_checksum());
        Assert.assertEquals((Object)data_nodeID_checksum, (Object)item_.getData_nodeID_checksum());
        Assert.assertEquals((Object)data_readRate_checksum, (Object)item_.getData_readRate_checksum());
        Assert.assertEquals((Object)data_sensor_checksum, (Object)item_.getData_sensor_checksum());
        Assert.assertEquals((Object)data_serialNB_checksum, (Object)item_.getData_serialNB_checksum());
        Assert.assertEquals((Object)data_timers_checksum, (Object)item_.getData_timers_checksum());
    }

    @Test
    public void sendReceiveFcs_HooksTelemetry() throws Exception {
        boolean allHooksInStateCLOSED = true;
        String clampState = "b";
        boolean controllerInError = true;
        int current = 969;
        boolean forceClampedStatus = false;
        boolean forceOverClampedStatus = false;
        int forceSensorVoltage0 = 355;
        int forceSensorVoltage1 = 414;
        String forceStatus = "";
        boolean forceUnclampedStatus = false;
        boolean forceUnderClampedStatus = false;
        boolean homingDone = false;
        int position = 154;
        String statusPublishedByHook1 = "";
        boolean statuspublishedbyhook1_inError = false;
        boolean statuspublishedbyhook1_lockSensorValue = true;
        String statuspublishedbyhook1_lockStatus = "";
        boolean statuspublishedbyhook1_unlockSensorValue = true;
        String statusPublishedByHook2 = "n";
        boolean statuspublishedbyhook2_inError = true;
        boolean statuspublishedbyhook2_lockSensorValue = true;
        String statuspublishedbyhook2_lockStatus = "c";
        boolean statuspublishedbyhook2_unlockSensorValue = true;
        String statusPublishedByHook3 = "";
        boolean statuspublishedbyhook3_inError = true;
        boolean statuspublishedbyhook3_lockSensorValue = true;
        String statuspublishedbyhook3_lockStatus = "";
        boolean statuspublishedbyhook3_unlockSensorValue = true;
        String statusPublishedByHook4 = "";
        boolean statuspublishedbyhook4_inError = false;
        boolean statuspublishedbyhook4_lockSensorValue = true;
        String statuspublishedbyhook4_lockStatus = "w";
        boolean statuspublishedbyhook4_unlockSensorValue = false;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_HooksTelemetry(allHooksInStateCLOSED, clampState, controllerInError, current, forceClampedStatus, forceOverClampedStatus, forceSensorVoltage0, forceSensorVoltage1, forceStatus, forceUnclampedStatus, forceUnderClampedStatus, homingDone, position, statusPublishedByHook1, statuspublishedbyhook1_inError, statuspublishedbyhook1_lockSensorValue, statuspublishedbyhook1_lockStatus, statuspublishedbyhook1_unlockSensorValue, statusPublishedByHook2, statuspublishedbyhook2_inError, statuspublishedbyhook2_lockSensorValue, statuspublishedbyhook2_lockStatus, statuspublishedbyhook2_unlockSensorValue, statusPublishedByHook3, statuspublishedbyhook3_inError, statuspublishedbyhook3_lockSensorValue, statuspublishedbyhook3_lockStatus, statuspublishedbyhook3_unlockSensorValue, statusPublishedByHook4, statuspublishedbyhook4_inError, statuspublishedbyhook4_lockSensorValue, statuspublishedbyhook4_lockStatus, statuspublishedbyhook4_unlockSensorValue));
        Assert.assertTrue((boolean)(item instanceof Fcs_HooksTelemetry));
        Fcs_HooksTelemetry item_ = (Fcs_HooksTelemetry)item;
        Assert.assertEquals((Object)allHooksInStateCLOSED, (Object)item_.isAllHooksInStateCLOSED());
        Assert.assertEquals((Object)clampState, (Object)item_.getClampState());
        Assert.assertEquals((Object)controllerInError, (Object)item_.isControllerInError());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((Object)forceClampedStatus, (Object)item_.isForceClampedStatus());
        Assert.assertEquals((Object)forceOverClampedStatus, (Object)item_.isForceOverClampedStatus());
        Assert.assertEquals((long)forceSensorVoltage0, (long)item_.getForceSensorVoltage0());
        Assert.assertEquals((long)forceSensorVoltage1, (long)item_.getForceSensorVoltage1());
        Assert.assertEquals((Object)forceStatus, (Object)item_.getForceStatus());
        Assert.assertEquals((Object)forceUnclampedStatus, (Object)item_.isForceUnclampedStatus());
        Assert.assertEquals((Object)forceUnderClampedStatus, (Object)item_.isForceUnderClampedStatus());
        Assert.assertEquals((Object)homingDone, (Object)item_.isHomingDone());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((Object)statusPublishedByHook1, (Object)item_.getStatusPublishedByHook1());
        Assert.assertEquals((Object)statuspublishedbyhook1_inError, (Object)item_.isStatuspublishedbyhook1_inError());
        Assert.assertEquals((Object)statuspublishedbyhook1_lockSensorValue, (Object)item_.isStatuspublishedbyhook1_lockSensorValue());
        Assert.assertEquals((Object)statuspublishedbyhook1_lockStatus, (Object)item_.getStatuspublishedbyhook1_lockStatus());
        Assert.assertEquals((Object)statuspublishedbyhook1_unlockSensorValue, (Object)item_.isStatuspublishedbyhook1_unlockSensorValue());
        Assert.assertEquals((Object)statusPublishedByHook2, (Object)item_.getStatusPublishedByHook2());
        Assert.assertEquals((Object)statuspublishedbyhook2_inError, (Object)item_.isStatuspublishedbyhook2_inError());
        Assert.assertEquals((Object)statuspublishedbyhook2_lockSensorValue, (Object)item_.isStatuspublishedbyhook2_lockSensorValue());
        Assert.assertEquals((Object)statuspublishedbyhook2_lockStatus, (Object)item_.getStatuspublishedbyhook2_lockStatus());
        Assert.assertEquals((Object)statuspublishedbyhook2_unlockSensorValue, (Object)item_.isStatuspublishedbyhook2_unlockSensorValue());
        Assert.assertEquals((Object)statusPublishedByHook3, (Object)item_.getStatusPublishedByHook3());
        Assert.assertEquals((Object)statuspublishedbyhook3_inError, (Object)item_.isStatuspublishedbyhook3_inError());
        Assert.assertEquals((Object)statuspublishedbyhook3_lockSensorValue, (Object)item_.isStatuspublishedbyhook3_lockSensorValue());
        Assert.assertEquals((Object)statuspublishedbyhook3_lockStatus, (Object)item_.getStatuspublishedbyhook3_lockStatus());
        Assert.assertEquals((Object)statuspublishedbyhook3_unlockSensorValue, (Object)item_.isStatuspublishedbyhook3_unlockSensorValue());
        Assert.assertEquals((Object)statusPublishedByHook4, (Object)item_.getStatusPublishedByHook4());
        Assert.assertEquals((Object)statuspublishedbyhook4_inError, (Object)item_.isStatuspublishedbyhook4_inError());
        Assert.assertEquals((Object)statuspublishedbyhook4_lockSensorValue, (Object)item_.isStatuspublishedbyhook4_lockSensorValue());
        Assert.assertEquals((Object)statuspublishedbyhook4_lockStatus, (Object)item_.getStatuspublishedbyhook4_lockStatus());
        Assert.assertEquals((Object)statuspublishedbyhook4_unlockSensorValue, (Object)item_.isStatuspublishedbyhook4_unlockSensorValue());
    }

    @Test
    public void sendReceiveFcs_HooksControllerTelemetry() throws Exception {
        boolean booted = false;
        boolean brakeActivated = false;
        boolean controllerWithBrake = false;
        int current = 441;
        int errorHistoryNB = 589;
        String errorRegister = "";
        boolean inError = false;
        boolean initialized = false;
        int lastErrorCode = 786;
        String lastErrorName = "d";
        String mode = "v";
        int position = 314;
        String state = "";
        int velocity = 911;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_HooksControllerTelemetry(booted, brakeActivated, controllerWithBrake, current, errorHistoryNB, errorRegister, inError, initialized, lastErrorCode, lastErrorName, mode, position, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_HooksControllerTelemetry));
        Fcs_HooksControllerTelemetry item_ = (Fcs_HooksControllerTelemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((Object)controllerWithBrake, (Object)item_.isControllerWithBrake());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Hyttc580Telemetry() throws Exception {
        boolean booted = false;
        boolean initialized = true;
        long pdo1 = 153L;
        long pdo2 = 943L;
        long pdo4 = 339L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Hyttc580Telemetry(booted, initialized, pdo1, pdo2, pdo4));
        Assert.assertTrue((boolean)(item instanceof Fcs_Hyttc580Telemetry));
        Fcs_Hyttc580Telemetry item_ = (Fcs_Hyttc580Telemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)pdo1, (long)item_.getPdo1());
        Assert.assertEquals((long)pdo2, (long)item_.getPdo2());
        Assert.assertEquals((long)pdo4, (long)item_.getPdo4());
    }

    @Test
    public void sendReceiveFcs_LatchXminusTelemetry() throws Exception {
        boolean controllerInFault = true;
        boolean filterEngagedSensorsInError = false;
        boolean filterPresenceSensorValue = false;
        boolean inError = true;
        boolean lockSensorValue = false;
        boolean lockSensorsInError = true;
        String lockStatus = "";
        boolean unlockSensorValue = true;
        boolean unlockSensorsInError = false;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_LatchXminusTelemetry(controllerInFault, filterEngagedSensorsInError, filterPresenceSensorValue, inError, lockSensorValue, lockSensorsInError, lockStatus, unlockSensorValue, unlockSensorsInError));
        Assert.assertTrue((boolean)(item instanceof Fcs_LatchXminusTelemetry));
        Fcs_LatchXminusTelemetry item_ = (Fcs_LatchXminusTelemetry)item;
        Assert.assertEquals((Object)controllerInFault, (Object)item_.isControllerInFault());
        Assert.assertEquals((Object)filterEngagedSensorsInError, (Object)item_.isFilterEngagedSensorsInError());
        Assert.assertEquals((Object)filterPresenceSensorValue, (Object)item_.isFilterPresenceSensorValue());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)lockSensorValue, (Object)item_.isLockSensorValue());
        Assert.assertEquals((Object)lockSensorsInError, (Object)item_.isLockSensorsInError());
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
        Assert.assertEquals((Object)unlockSensorValue, (Object)item_.isUnlockSensorValue());
        Assert.assertEquals((Object)unlockSensorsInError, (Object)item_.isUnlockSensorsInError());
    }

    @Test
    public void sendReceiveFcs_LatchXminusControllerTelemetry() throws Exception {
        boolean booted = false;
        boolean brakeActivated = false;
        boolean controllerWithBrake = true;
        int current = 55;
        int errorHistoryNB = 740;
        String errorRegister = "";
        boolean inError = false;
        boolean initialized = false;
        int lastErrorCode = 949;
        String lastErrorName = "";
        String mode = "a";
        int position = 743;
        String state = "v";
        int velocity = 477;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_LatchXminusControllerTelemetry(booted, brakeActivated, controllerWithBrake, current, errorHistoryNB, errorRegister, inError, initialized, lastErrorCode, lastErrorName, mode, position, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_LatchXminusControllerTelemetry));
        Fcs_LatchXminusControllerTelemetry item_ = (Fcs_LatchXminusControllerTelemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((Object)controllerWithBrake, (Object)item_.isControllerWithBrake());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_LatchXplusTelemetry() throws Exception {
        boolean controllerInFault = false;
        boolean filterEngagedSensorsInError = false;
        boolean filterPresenceSensorValue = false;
        boolean inError = true;
        boolean lockSensorValue = true;
        boolean lockSensorsInError = true;
        String lockStatus = "";
        boolean unlockSensorValue = true;
        boolean unlockSensorsInError = false;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_LatchXplusTelemetry(controllerInFault, filterEngagedSensorsInError, filterPresenceSensorValue, inError, lockSensorValue, lockSensorsInError, lockStatus, unlockSensorValue, unlockSensorsInError));
        Assert.assertTrue((boolean)(item instanceof Fcs_LatchXplusTelemetry));
        Fcs_LatchXplusTelemetry item_ = (Fcs_LatchXplusTelemetry)item;
        Assert.assertEquals((Object)controllerInFault, (Object)item_.isControllerInFault());
        Assert.assertEquals((Object)filterEngagedSensorsInError, (Object)item_.isFilterEngagedSensorsInError());
        Assert.assertEquals((Object)filterPresenceSensorValue, (Object)item_.isFilterPresenceSensorValue());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)lockSensorValue, (Object)item_.isLockSensorValue());
        Assert.assertEquals((Object)lockSensorsInError, (Object)item_.isLockSensorsInError());
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
        Assert.assertEquals((Object)unlockSensorValue, (Object)item_.isUnlockSensorValue());
        Assert.assertEquals((Object)unlockSensorsInError, (Object)item_.isUnlockSensorsInError());
    }

    @Test
    public void sendReceiveFcs_LatchXplusControllerTelemetry() throws Exception {
        boolean booted = false;
        boolean brakeActivated = false;
        boolean controllerWithBrake = false;
        int current = 86;
        int errorHistoryNB = 582;
        String errorRegister = "f";
        boolean inError = false;
        boolean initialized = false;
        int lastErrorCode = 618;
        String lastErrorName = "y";
        String mode = "";
        int position = 70;
        String state = "";
        int velocity = 718;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_LatchXplusControllerTelemetry(booted, brakeActivated, controllerWithBrake, current, errorHistoryNB, errorRegister, inError, initialized, lastErrorCode, lastErrorName, mode, position, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_LatchXplusControllerTelemetry));
        Fcs_LatchXplusControllerTelemetry item_ = (Fcs_LatchXplusControllerTelemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((Object)controllerWithBrake, (Object)item_.isControllerWithBrake());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_LatchesTelemetry() throws Exception {
        int filterId = 766;
        String filterName = "v";
        String filterPresenceStatus = "";
        String lockStatus = "o";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_LatchesTelemetry(filterId, filterName, filterPresenceStatus, lockStatus));
        Assert.assertTrue((boolean)(item instanceof Fcs_LatchesTelemetry));
        Fcs_LatchesTelemetry item_ = (Fcs_LatchesTelemetry)item;
        Assert.assertEquals((long)filterId, (long)item_.getFilterId());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)filterPresenceStatus, (Object)item_.getFilterPresenceStatus());
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
    }

    @Test
    public void sendReceiveFcs_LoaderTelemetry() throws Exception {
        boolean af0 = true;
        boolean af0InError = true;
        boolean af1 = true;
        boolean af1InError = true;
        boolean af3 = false;
        boolean af3InError = true;
        boolean ap2 = true;
        boolean ap2InError = false;
        boolean carrierRelayStatus = true;
        int filterDistance = 114;
        boolean filterPositionStatus = true;
        boolean filterPresenceSensorValue = true;
        boolean filterPresenceSensorsInError = true;
        boolean hooksRelayStatus = false;
        boolean keyEng = false;
        boolean keyEngInError = false;
        boolean keyLock = false;
        boolean keyLockInError = true;
        boolean lfd = false;
        boolean lfs = true;
        boolean loaderDefaultStatus = false;
        boolean loaderOnCameraSensorValue = false;
        boolean loaderOnCameraSensorsInError = true;
        boolean lps = true;
        boolean lpsInError = true;
        boolean lrh = true;
        boolean lrhInError = false;
        boolean safetyBeltPresence = true;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_LoaderTelemetry(af0, af0InError, af1, af1InError, af3, af3InError, ap2, ap2InError, carrierRelayStatus, filterDistance, filterPositionStatus, filterPresenceSensorValue, filterPresenceSensorsInError, hooksRelayStatus, keyEng, keyEngInError, keyLock, keyLockInError, lfd, lfs, loaderDefaultStatus, loaderOnCameraSensorValue, loaderOnCameraSensorsInError, lps, lpsInError, lrh, lrhInError, safetyBeltPresence));
        Assert.assertTrue((boolean)(item instanceof Fcs_LoaderTelemetry));
        Fcs_LoaderTelemetry item_ = (Fcs_LoaderTelemetry)item;
        Assert.assertEquals((Object)af0, (Object)item_.isAf0());
        Assert.assertEquals((Object)af0InError, (Object)item_.isAf0InError());
        Assert.assertEquals((Object)af1, (Object)item_.isAf1());
        Assert.assertEquals((Object)af1InError, (Object)item_.isAf1InError());
        Assert.assertEquals((Object)af3, (Object)item_.isAf3());
        Assert.assertEquals((Object)af3InError, (Object)item_.isAf3InError());
        Assert.assertEquals((Object)ap2, (Object)item_.isAp2());
        Assert.assertEquals((Object)ap2InError, (Object)item_.isAp2InError());
        Assert.assertEquals((Object)carrierRelayStatus, (Object)item_.isCarrierRelayStatus());
        Assert.assertEquals((long)filterDistance, (long)item_.getFilterDistance());
        Assert.assertEquals((Object)filterPositionStatus, (Object)item_.isFilterPositionStatus());
        Assert.assertEquals((Object)filterPresenceSensorValue, (Object)item_.isFilterPresenceSensorValue());
        Assert.assertEquals((Object)filterPresenceSensorsInError, (Object)item_.isFilterPresenceSensorsInError());
        Assert.assertEquals((Object)hooksRelayStatus, (Object)item_.isHooksRelayStatus());
        Assert.assertEquals((Object)keyEng, (Object)item_.isKeyEng());
        Assert.assertEquals((Object)keyEngInError, (Object)item_.isKeyEngInError());
        Assert.assertEquals((Object)keyLock, (Object)item_.isKeyLock());
        Assert.assertEquals((Object)keyLockInError, (Object)item_.isKeyLockInError());
        Assert.assertEquals((Object)lfd, (Object)item_.isLfd());
        Assert.assertEquals((Object)lfs, (Object)item_.isLfs());
        Assert.assertEquals((Object)loaderDefaultStatus, (Object)item_.isLoaderDefaultStatus());
        Assert.assertEquals((Object)loaderOnCameraSensorValue, (Object)item_.isLoaderOnCameraSensorValue());
        Assert.assertEquals((Object)loaderOnCameraSensorsInError, (Object)item_.isLoaderOnCameraSensorsInError());
        Assert.assertEquals((Object)lps, (Object)item_.isLps());
        Assert.assertEquals((Object)lpsInError, (Object)item_.isLpsInError());
        Assert.assertEquals((Object)lrh, (Object)item_.isLrh());
        Assert.assertEquals((Object)lrhInError, (Object)item_.isLrhInError());
        Assert.assertEquals((Object)safetyBeltPresence, (Object)item_.isSafetyBeltPresence());
    }

    @Test
    public void sendReceiveFcs_LoaderPlutoGatewayTelemetry() throws Exception {
        boolean booted = true;
        boolean initialized = false;
        int intValues = 854;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_LoaderPlutoGatewayTelemetry(booted, initialized, intValues));
        Assert.assertTrue((boolean)(item instanceof Fcs_LoaderPlutoGatewayTelemetry));
        Fcs_LoaderPlutoGatewayTelemetry item_ = (Fcs_LoaderPlutoGatewayTelemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)intValues, (long)item_.getIntValues());
    }

    @Test
    public void sendReceiveFcs_OnlineClampXminusTelemetry() throws Exception {
        boolean controllerBooted = false;
        boolean controllerInFault = true;
        int current = 483;
        boolean homingDone = true;
        boolean inError = false;
        boolean lockSensorInError = false;
        boolean lockSensorValue = true;
        String lockStatus = "f";
        int position = 183;
        int sentCurrent = 18;
        boolean unlockSensorInError = true;
        boolean unlockSensorValue = false;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_OnlineClampXminusTelemetry(controllerBooted, controllerInFault, current, homingDone, inError, lockSensorInError, lockSensorValue, lockStatus, position, sentCurrent, unlockSensorInError, unlockSensorValue));
        Assert.assertTrue((boolean)(item instanceof Fcs_OnlineClampXminusTelemetry));
        Fcs_OnlineClampXminusTelemetry item_ = (Fcs_OnlineClampXminusTelemetry)item;
        Assert.assertEquals((Object)controllerBooted, (Object)item_.isControllerBooted());
        Assert.assertEquals((Object)controllerInFault, (Object)item_.isControllerInFault());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((Object)homingDone, (Object)item_.isHomingDone());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)lockSensorInError, (Object)item_.isLockSensorInError());
        Assert.assertEquals((Object)lockSensorValue, (Object)item_.isLockSensorValue());
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)sentCurrent, (long)item_.getSentCurrent());
        Assert.assertEquals((Object)unlockSensorInError, (Object)item_.isUnlockSensorInError());
        Assert.assertEquals((Object)unlockSensorValue, (Object)item_.isUnlockSensorValue());
    }

    @Test
    public void sendReceiveFcs_OnlineClampXminusControllerTelemetry() throws Exception {
        boolean booted = true;
        boolean brakeActivated = true;
        boolean controllerWithBrake = false;
        int current = 84;
        int errorHistoryNB = 85;
        String errorRegister = "";
        boolean inError = true;
        boolean initialized = false;
        int lastErrorCode = 486;
        String lastErrorName = "c";
        String mode = "k";
        int position = 959;
        String state = "t";
        int velocity = 755;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_OnlineClampXminusControllerTelemetry(booted, brakeActivated, controllerWithBrake, current, errorHistoryNB, errorRegister, inError, initialized, lastErrorCode, lastErrorName, mode, position, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_OnlineClampXminusControllerTelemetry));
        Fcs_OnlineClampXminusControllerTelemetry item_ = (Fcs_OnlineClampXminusControllerTelemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((Object)controllerWithBrake, (Object)item_.isControllerWithBrake());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_OnlineClampXplusTelemetry() throws Exception {
        boolean controllerBooted = true;
        boolean controllerInFault = false;
        int current = 957;
        boolean homingDone = true;
        boolean inError = true;
        boolean lockSensorInError = true;
        boolean lockSensorValue = true;
        String lockStatus = "m";
        int position = 903;
        int sentCurrent = 879;
        boolean unlockSensorInError = false;
        boolean unlockSensorValue = true;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_OnlineClampXplusTelemetry(controllerBooted, controllerInFault, current, homingDone, inError, lockSensorInError, lockSensorValue, lockStatus, position, sentCurrent, unlockSensorInError, unlockSensorValue));
        Assert.assertTrue((boolean)(item instanceof Fcs_OnlineClampXplusTelemetry));
        Fcs_OnlineClampXplusTelemetry item_ = (Fcs_OnlineClampXplusTelemetry)item;
        Assert.assertEquals((Object)controllerBooted, (Object)item_.isControllerBooted());
        Assert.assertEquals((Object)controllerInFault, (Object)item_.isControllerInFault());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((Object)homingDone, (Object)item_.isHomingDone());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)lockSensorInError, (Object)item_.isLockSensorInError());
        Assert.assertEquals((Object)lockSensorValue, (Object)item_.isLockSensorValue());
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)sentCurrent, (long)item_.getSentCurrent());
        Assert.assertEquals((Object)unlockSensorInError, (Object)item_.isUnlockSensorInError());
        Assert.assertEquals((Object)unlockSensorValue, (Object)item_.isUnlockSensorValue());
    }

    @Test
    public void sendReceiveFcs_OnlineClampXplusControllerTelemetry() throws Exception {
        boolean booted = false;
        boolean brakeActivated = false;
        boolean controllerWithBrake = true;
        int current = 775;
        int errorHistoryNB = 226;
        String errorRegister = "b";
        boolean inError = true;
        boolean initialized = false;
        int lastErrorCode = 674;
        String lastErrorName = "p";
        String mode = "";
        int position = 909;
        String state = "";
        int velocity = 607;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_OnlineClampXplusControllerTelemetry(booted, brakeActivated, controllerWithBrake, current, errorHistoryNB, errorRegister, inError, initialized, lastErrorCode, lastErrorName, mode, position, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_OnlineClampXplusControllerTelemetry));
        Fcs_OnlineClampXplusControllerTelemetry item_ = (Fcs_OnlineClampXplusControllerTelemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((Object)controllerWithBrake, (Object)item_.isControllerWithBrake());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_OnlineClampYminusTelemetry() throws Exception {
        boolean controllerBooted = true;
        boolean controllerInFault = true;
        int current = 738;
        boolean homingDone = true;
        boolean inError = true;
        boolean lockSensorInError = true;
        boolean lockSensorValue = false;
        String lockStatus = "z";
        int position = 794;
        int sentCurrent = 166;
        boolean unlockSensorInError = true;
        boolean unlockSensorValue = true;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_OnlineClampYminusTelemetry(controllerBooted, controllerInFault, current, homingDone, inError, lockSensorInError, lockSensorValue, lockStatus, position, sentCurrent, unlockSensorInError, unlockSensorValue));
        Assert.assertTrue((boolean)(item instanceof Fcs_OnlineClampYminusTelemetry));
        Fcs_OnlineClampYminusTelemetry item_ = (Fcs_OnlineClampYminusTelemetry)item;
        Assert.assertEquals((Object)controllerBooted, (Object)item_.isControllerBooted());
        Assert.assertEquals((Object)controllerInFault, (Object)item_.isControllerInFault());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((Object)homingDone, (Object)item_.isHomingDone());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)lockSensorInError, (Object)item_.isLockSensorInError());
        Assert.assertEquals((Object)lockSensorValue, (Object)item_.isLockSensorValue());
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)sentCurrent, (long)item_.getSentCurrent());
        Assert.assertEquals((Object)unlockSensorInError, (Object)item_.isUnlockSensorInError());
        Assert.assertEquals((Object)unlockSensorValue, (Object)item_.isUnlockSensorValue());
    }

    @Test
    public void sendReceiveFcs_OnlineClampYminusControllerTelemetry() throws Exception {
        boolean booted = false;
        boolean brakeActivated = true;
        boolean controllerWithBrake = true;
        int current = 473;
        int errorHistoryNB = 350;
        String errorRegister = "s";
        boolean inError = true;
        boolean initialized = true;
        int lastErrorCode = 644;
        String lastErrorName = "";
        String mode = "";
        int position = 734;
        String state = "";
        int velocity = 472;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_OnlineClampYminusControllerTelemetry(booted, brakeActivated, controllerWithBrake, current, errorHistoryNB, errorRegister, inError, initialized, lastErrorCode, lastErrorName, mode, position, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_OnlineClampYminusControllerTelemetry));
        Fcs_OnlineClampYminusControllerTelemetry item_ = (Fcs_OnlineClampYminusControllerTelemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((Object)controllerWithBrake, (Object)item_.isControllerWithBrake());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_OnlineClampsTelemetry() throws Exception {
        boolean homingDone = true;
        String lockStatus = "t";
        int onlineClampRawStrain = 566;
        int onlineClampStrain = 340;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_OnlineClampsTelemetry(homingDone, lockStatus, onlineClampRawStrain, onlineClampStrain));
        Assert.assertTrue((boolean)(item instanceof Fcs_OnlineClampsTelemetry));
        Fcs_OnlineClampsTelemetry item_ = (Fcs_OnlineClampsTelemetry)item;
        Assert.assertEquals((Object)homingDone, (Object)item_.isHomingDone());
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
        Assert.assertEquals((long)onlineClampRawStrain, (long)item_.getOnlineClampRawStrain());
        Assert.assertEquals((long)onlineClampStrain, (long)item_.getOnlineClampStrain());
    }

    @Test
    public void sendReceiveFcs_OnlineStrainGaugeTelemetry() throws Exception {
        boolean booted = false;
        int errorHistoryNB = 439;
        String errorRegister = "";
        boolean inError = false;
        boolean initialized = true;
        int lastErrorCode = 73;
        String lastErrorName = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_OnlineStrainGaugeTelemetry(booted, errorHistoryNB, errorRegister, inError, initialized, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_OnlineStrainGaugeTelemetry));
        Fcs_OnlineStrainGaugeTelemetry item_ = (Fcs_OnlineStrainGaugeTelemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_ProximitySensorsDeviceTelemetry() throws Exception {
        boolean booted = false;
        int errorHistoryNB = 514;
        String errorRegister = "";
        boolean inError = true;
        boolean initialized = true;
        int lastErrorCode = 437;
        String lastErrorName = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_ProximitySensorsDeviceTelemetry(booted, errorHistoryNB, errorRegister, inError, initialized, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_ProximitySensorsDeviceTelemetry));
        Fcs_ProximitySensorsDeviceTelemetry item_ = (Fcs_ProximitySensorsDeviceTelemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Pt100Telemetry() throws Exception {
        boolean booted = false;
        int errorHistoryNB = 621;
        String errorRegister = "";
        boolean inError = true;
        boolean initialized = true;
        int lastErrorCode = 840;
        String lastErrorName = "h";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Pt100Telemetry(booted, errorHistoryNB, errorRegister, inError, initialized, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Pt100Telemetry));
        Fcs_Pt100Telemetry item_ = (Fcs_Pt100Telemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_RuntimeInfoTelemetry() throws Exception {
        long freeMemory = 86L;
        long maxMemory = 624L;
        int nThreads = 723;
        double processCpuLoad = 0.6982271075248718;
        double systemCpuLoad = 0.9491164088249207;
        long totalMemory = 701L;
        int uptime = 58;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_RuntimeInfoTelemetry(freeMemory, maxMemory, nThreads, processCpuLoad, systemCpuLoad, totalMemory, uptime));
        Assert.assertTrue((boolean)(item instanceof Fcs_RuntimeInfoTelemetry));
        Fcs_RuntimeInfoTelemetry item_ = (Fcs_RuntimeInfoTelemetry)item;
        Assert.assertEquals((long)freeMemory, (long)item_.getFreeMemory());
        Assert.assertEquals((long)maxMemory, (long)item_.getMaxMemory());
        Assert.assertEquals((long)nThreads, (long)item_.getNThreads());
        Assert.assertEquals((double)processCpuLoad, (double)item_.getProcessCpuLoad(), (double)1.0E-6f);
        Assert.assertEquals((double)systemCpuLoad, (double)item_.getSystemCpuLoad(), (double)1.0E-6f);
        Assert.assertEquals((long)totalMemory, (long)item_.getTotalMemory());
        Assert.assertEquals((long)uptime, (long)item_.getUptime());
    }

    @Test
    public void sendReceiveFcs_Socket1Telemetry() throws Exception {
        boolean atStandby = true;
        boolean carouselMoving = true;
        String clampsState = "e";
        int deltaPosition = 254;
        boolean empty = false;
        int filterID = 401;
        String filterName = "";
        String slaveStatus = "s";
        int socketID = 199;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Socket1Telemetry(atStandby, carouselMoving, clampsState, deltaPosition, empty, filterID, filterName, slaveStatus, socketID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Socket1Telemetry));
        Fcs_Socket1Telemetry item_ = (Fcs_Socket1Telemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)carouselMoving, (Object)item_.isCarouselMoving());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((long)deltaPosition, (long)item_.getDeltaPosition());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((long)filterID, (long)item_.getFilterID());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)slaveStatus, (Object)item_.getSlaveStatus());
        Assert.assertEquals((long)socketID, (long)item_.getSocketID());
    }

    @Test
    public void sendReceiveFcs_Socket2Telemetry() throws Exception {
        boolean atStandby = true;
        boolean carouselMoving = true;
        String clampsState = "";
        int deltaPosition = 336;
        boolean empty = false;
        int filterID = 387;
        String filterName = "j";
        String slaveStatus = "i";
        int socketID = 584;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Socket2Telemetry(atStandby, carouselMoving, clampsState, deltaPosition, empty, filterID, filterName, slaveStatus, socketID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Socket2Telemetry));
        Fcs_Socket2Telemetry item_ = (Fcs_Socket2Telemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)carouselMoving, (Object)item_.isCarouselMoving());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((long)deltaPosition, (long)item_.getDeltaPosition());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((long)filterID, (long)item_.getFilterID());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)slaveStatus, (Object)item_.getSlaveStatus());
        Assert.assertEquals((long)socketID, (long)item_.getSocketID());
    }

    @Test
    public void sendReceiveFcs_Socket3Telemetry() throws Exception {
        boolean atStandby = false;
        boolean carouselMoving = false;
        String clampsState = "";
        int deltaPosition = 755;
        boolean empty = true;
        int filterID = 354;
        String filterName = "g";
        String slaveStatus = "z";
        int socketID = 133;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Socket3Telemetry(atStandby, carouselMoving, clampsState, deltaPosition, empty, filterID, filterName, slaveStatus, socketID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Socket3Telemetry));
        Fcs_Socket3Telemetry item_ = (Fcs_Socket3Telemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)carouselMoving, (Object)item_.isCarouselMoving());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((long)deltaPosition, (long)item_.getDeltaPosition());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((long)filterID, (long)item_.getFilterID());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)slaveStatus, (Object)item_.getSlaveStatus());
        Assert.assertEquals((long)socketID, (long)item_.getSocketID());
    }

    @Test
    public void sendReceiveFcs_Socket4Telemetry() throws Exception {
        boolean atStandby = false;
        boolean carouselMoving = true;
        String clampsState = "z";
        int deltaPosition = 959;
        boolean empty = false;
        int filterID = 475;
        String filterName = "";
        String slaveStatus = "";
        int socketID = 546;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Socket4Telemetry(atStandby, carouselMoving, clampsState, deltaPosition, empty, filterID, filterName, slaveStatus, socketID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Socket4Telemetry));
        Fcs_Socket4Telemetry item_ = (Fcs_Socket4Telemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)carouselMoving, (Object)item_.isCarouselMoving());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((long)deltaPosition, (long)item_.getDeltaPosition());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((long)filterID, (long)item_.getFilterID());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)slaveStatus, (Object)item_.getSlaveStatus());
        Assert.assertEquals((long)socketID, (long)item_.getSocketID());
    }

    @Test
    public void sendReceiveFcs_Socket5Telemetry() throws Exception {
        boolean atStandby = false;
        boolean carouselMoving = true;
        String clampsState = "c";
        int deltaPosition = 299;
        boolean empty = false;
        int filterID = 86;
        String filterName = "y";
        String slaveStatus = "g";
        int socketID = 559;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Socket5Telemetry(atStandby, carouselMoving, clampsState, deltaPosition, empty, filterID, filterName, slaveStatus, socketID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Socket5Telemetry));
        Fcs_Socket5Telemetry item_ = (Fcs_Socket5Telemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)carouselMoving, (Object)item_.isCarouselMoving());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((long)deltaPosition, (long)item_.getDeltaPosition());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((long)filterID, (long)item_.getFilterID());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)slaveStatus, (Object)item_.getSlaveStatus());
        Assert.assertEquals((long)socketID, (long)item_.getSocketID());
    }

    @Test
    public void sendReceiveFcs_TempSensorsDevice1Telemetry() throws Exception {
        boolean booted = false;
        int errorHistoryNB = 689;
        String errorRegister = "b";
        boolean inError = false;
        boolean initialized = false;
        int lastErrorCode = 142;
        String lastErrorName = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_TempSensorsDevice1Telemetry(booted, errorHistoryNB, errorRegister, inError, initialized, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_TempSensorsDevice1Telemetry));
        Fcs_TempSensorsDevice1Telemetry item_ = (Fcs_TempSensorsDevice1Telemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_TempSensorsDevice2Telemetry() throws Exception {
        boolean booted = true;
        int errorHistoryNB = 979;
        String errorRegister = "";
        boolean inError = false;
        boolean initialized = true;
        int lastErrorCode = 753;
        String lastErrorName = "n";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_TempSensorsDevice2Telemetry(booted, errorHistoryNB, errorRegister, inError, initialized, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_TempSensorsDevice2Telemetry));
        Fcs_TempSensorsDevice2Telemetry item_ = (Fcs_TempSensorsDevice2Telemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveChiller_ChillerTelemetry() throws Exception {
        double chillerPumpLife = 0.7531850337982178;
        double chillerStatus = 0.8181444406509399;
        double chillerValveAct = 0.6882471442222595;
        double compressorLife = 0.8719899654388428;
        double controllerLife = 0.6436505913734436;
        double coolPercentage = 0.23704993724822998;
        double flowRate = 0.8620907068252563;
        double flowSetPoint = 0.9488015174865723;
        double fluidTemperature = 0.3482805f;
        double heatPercentage = 0.1103331446647644;
        double importedColdTemp = 0.1510737f;
        double pressureIn = 0.5242906212806702;
        double pressureOut = 0.11210393905639648;
        double pressureTank = 0.8985620737075806;
        double tankSetPoint = 0.43637847900390625;
        double tempCondenser = 0.3597577214241028;
        double tempDUTInput = 0.3313819169998169;
        double tempDynamicSetPt = 0.11341977119445801;
        double tempSetPoint = 0.36874884366989136;
        double tempStage2Evap = 0.30063343048095703;
        double tempTXVBulb = 0.5733118057250977;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Chiller_ChillerTelemetry(chillerPumpLife, chillerStatus, chillerValveAct, compressorLife, controllerLife, coolPercentage, flowRate, flowSetPoint, fluidTemperature, heatPercentage, importedColdTemp, pressureIn, pressureOut, pressureTank, tankSetPoint, tempCondenser, tempDUTInput, tempDynamicSetPt, tempSetPoint, tempStage2Evap, tempTXVBulb));
        Assert.assertTrue((boolean)(item instanceof Chiller_ChillerTelemetry));
        Chiller_ChillerTelemetry item_ = (Chiller_ChillerTelemetry)item;
        Assert.assertEquals((double)chillerPumpLife, (double)item_.getChillerPumpLife(), (double)1.0E-6f);
        Assert.assertEquals((double)chillerStatus, (double)item_.getChillerStatus(), (double)1.0E-6f);
        Assert.assertEquals((double)chillerValveAct, (double)item_.getChillerValveAct(), (double)1.0E-6f);
        Assert.assertEquals((double)compressorLife, (double)item_.getCompressorLife(), (double)1.0E-6f);
        Assert.assertEquals((double)controllerLife, (double)item_.getControllerLife(), (double)1.0E-6f);
        Assert.assertEquals((double)coolPercentage, (double)item_.getCoolPercentage(), (double)1.0E-6f);
        Assert.assertEquals((double)flowRate, (double)item_.getFlowRate(), (double)1.0E-6f);
        Assert.assertEquals((double)flowSetPoint, (double)item_.getFlowSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((double)fluidTemperature, (double)item_.getFluidTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)heatPercentage, (double)item_.getHeatPercentage(), (double)1.0E-6f);
        Assert.assertEquals((double)importedColdTemp, (double)item_.getImportedColdTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)pressureIn, (double)item_.getPressureIn(), (double)1.0E-6f);
        Assert.assertEquals((double)pressureOut, (double)item_.getPressureOut(), (double)1.0E-6f);
        Assert.assertEquals((double)pressureTank, (double)item_.getPressureTank(), (double)1.0E-6f);
        Assert.assertEquals((double)tankSetPoint, (double)item_.getTankSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((double)tempCondenser, (double)item_.getTempCondenser(), (double)1.0E-6f);
        Assert.assertEquals((double)tempDUTInput, (double)item_.getTempDUTInput(), (double)1.0E-6f);
        Assert.assertEquals((double)tempDynamicSetPt, (double)item_.getTempDynamicSetPt(), (double)1.0E-6f);
        Assert.assertEquals((double)tempSetPoint, (double)item_.getTempSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((double)tempStage2Evap, (double)item_.getTempStage2Evap(), (double)1.0E-6f);
        Assert.assertEquals((double)tempTXVBulb, (double)item_.getTempTXVBulb(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveChiller_Maq20Telemetry() throws Exception {
        double ambientTemp = 0.1907286f;
        double coolantHXOut = 0.07408136129379272;
        double coolantPumpIn = 0.9613697528839111;
        double coolantPumpOut = 0.2810043692588806;
        double coolantReturn = 0.7223102450370789;
        double coolantSupply = 0.7051712870597839;
        double glycChillerIn = 0.4286355972290039;
        double glycChillerOut = 0.821640133857727;
        double glycCondensOut = 0.9404242634773254;
        double glycDeSuHtrOut = 0.6586137413978577;
        double glycFanIn = 0.3022971749305725;
        double glycFanOut = 0.019173502922058105;
        double glycInputFlow = 0.36438167095184326;
        double pBurstReturn = 0.7055245637893677;
        double pBurstSupply = 0.6544204950332642;
        double stg1CondensOut = 0.35897761583328247;
        double stg1Discharge = 0.44769471883773804;
        double stg1Return = 0.9395627379417419;
        double stg1TXVBulb = 0.6333457827568054;
        double stg2DeSuHtrOut = 0.1457616090774536;
        double stg2Discharge = 0.30910396575927734;
        double stg2DischargeP = 0.7876299619674683;
        double stg2EvapIn = 0.32137006521224976;
        double stg2EvapOut = 0.03891545534133911;
        double stg2Return = 0.798478364944458;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Chiller_Maq20Telemetry(ambientTemp, coolantHXOut, coolantPumpIn, coolantPumpOut, coolantReturn, coolantSupply, glycChillerIn, glycChillerOut, glycCondensOut, glycDeSuHtrOut, glycFanIn, glycFanOut, glycInputFlow, pBurstReturn, pBurstSupply, stg1CondensOut, stg1Discharge, stg1Return, stg1TXVBulb, stg2DeSuHtrOut, stg2Discharge, stg2DischargeP, stg2EvapIn, stg2EvapOut, stg2Return));
        Assert.assertTrue((boolean)(item instanceof Chiller_Maq20Telemetry));
        Chiller_Maq20Telemetry item_ = (Chiller_Maq20Telemetry)item;
        Assert.assertEquals((double)ambientTemp, (double)item_.getAmbientTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantHXOut, (double)item_.getCoolantHXOut(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantPumpIn, (double)item_.getCoolantPumpIn(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantPumpOut, (double)item_.getCoolantPumpOut(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantReturn, (double)item_.getCoolantReturn(), (double)1.0E-6f);
        Assert.assertEquals((double)coolantSupply, (double)item_.getCoolantSupply(), (double)1.0E-6f);
        Assert.assertEquals((double)glycChillerIn, (double)item_.getGlycChillerIn(), (double)1.0E-6f);
        Assert.assertEquals((double)glycChillerOut, (double)item_.getGlycChillerOut(), (double)1.0E-6f);
        Assert.assertEquals((double)glycCondensOut, (double)item_.getGlycCondensOut(), (double)1.0E-6f);
        Assert.assertEquals((double)glycDeSuHtrOut, (double)item_.getGlycDeSuHtrOut(), (double)1.0E-6f);
        Assert.assertEquals((double)glycFanIn, (double)item_.getGlycFanIn(), (double)1.0E-6f);
        Assert.assertEquals((double)glycFanOut, (double)item_.getGlycFanOut(), (double)1.0E-6f);
        Assert.assertEquals((double)glycInputFlow, (double)item_.getGlycInputFlow(), (double)1.0E-6f);
        Assert.assertEquals((double)pBurstReturn, (double)item_.getPBurstReturn(), (double)1.0E-6f);
        Assert.assertEquals((double)pBurstSupply, (double)item_.getPBurstSupply(), (double)1.0E-6f);
        Assert.assertEquals((double)stg1CondensOut, (double)item_.getStg1CondensOut(), (double)1.0E-6f);
        Assert.assertEquals((double)stg1Discharge, (double)item_.getStg1Discharge(), (double)1.0E-6f);
        Assert.assertEquals((double)stg1Return, (double)item_.getStg1Return(), (double)1.0E-6f);
        Assert.assertEquals((double)stg1TXVBulb, (double)item_.getStg1TXVBulb(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2DeSuHtrOut, (double)item_.getStg2DeSuHtrOut(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2Discharge, (double)item_.getStg2Discharge(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2DischargeP, (double)item_.getStg2DischargeP(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2EvapIn, (double)item_.getStg2EvapIn(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2EvapOut, (double)item_.getStg2EvapOut(), (double)1.0E-6f);
        Assert.assertEquals((double)stg2Return, (double)item_.getStg2Return(), (double)1.0E-6f);
    }
}

