package org.lsst.sal.camera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class Fcs_AcTruckXplusTelemetry extends CameraTelemetry {
  private final int averageCurrent;

  private final int followingError;

  private final boolean handoffInError;

  private final boolean handoffSensorValue;

  private final boolean onlineInError;

  private final boolean onlineSensorValue;

  private final int position;

  private final boolean standbyInError;

  private final boolean standbySensorValue;

  public Fcs_AcTruckXplusTelemetry(int averageCurrent, int followingError, boolean handoffInError,
      boolean handoffSensorValue, boolean onlineInError, boolean onlineSensorValue, int position,
      boolean standbyInError, boolean standbySensorValue) {
    this.averageCurrent = averageCurrent;
    this.followingError = followingError;
    this.handoffInError = handoffInError;
    this.handoffSensorValue = handoffSensorValue;
    this.onlineInError = onlineInError;
    this.onlineSensorValue = onlineSensorValue;
    this.position = position;
    this.standbyInError = standbyInError;
    this.standbySensorValue = standbySensorValue;
  }

  public int getAverageCurrent() {
    return averageCurrent;
  }

  public int getFollowingError() {
    return followingError;
  }

  public boolean isHandoffInError() {
    return handoffInError;
  }

  public boolean isHandoffSensorValue() {
    return handoffSensorValue;
  }

  public boolean isOnlineInError() {
    return onlineInError;
  }

  public boolean isOnlineSensorValue() {
    return onlineSensorValue;
  }

  public int getPosition() {
    return position;
  }

  public boolean isStandbyInError() {
    return standbyInError;
  }

  public boolean isStandbySensorValue() {
    return standbySensorValue;
  }

  @Override
  public String toString() {
    return "Fcs_AcTruckXplusTelemetry{" + "averageCurrent=" + averageCurrent +
        ", followingError=" + followingError +", handoffInError=" + handoffInError +
        ", handoffSensorValue=" + handoffSensorValue +", onlineInError=" + onlineInError +
        ", onlineSensorValue=" + onlineSensorValue +", position=" + position +
        ", standbyInError=" + standbyInError +", standbySensorValue=" + standbySensorValue +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private int averageCurrent;

    private int followingError;

    private boolean handoffInError;

    private boolean handoffSensorValue;

    private boolean onlineInError;

    private boolean onlineSensorValue;

    private int position;

    private boolean standbyInError;

    private boolean standbySensorValue;

    private Builder() {
    }

    public Builder averageCurrent(int averageCurrent) {
      this.averageCurrent = averageCurrent;
      return this;
    }

    public Builder followingError(int followingError) {
      this.followingError = followingError;
      return this;
    }

    public Builder handoffInError(boolean handoffInError) {
      this.handoffInError = handoffInError;
      return this;
    }

    public Builder handoffSensorValue(boolean handoffSensorValue) {
      this.handoffSensorValue = handoffSensorValue;
      return this;
    }

    public Builder onlineInError(boolean onlineInError) {
      this.onlineInError = onlineInError;
      return this;
    }

    public Builder onlineSensorValue(boolean onlineSensorValue) {
      this.onlineSensorValue = onlineSensorValue;
      return this;
    }

    public Builder position(int position) {
      this.position = position;
      return this;
    }

    public Builder standbyInError(boolean standbyInError) {
      this.standbyInError = standbyInError;
      return this;
    }

    public Builder standbySensorValue(boolean standbySensorValue) {
      this.standbySensorValue = standbySensorValue;
      return this;
    }

    public Fcs_AcTruckXplusTelemetry build() {
      return new Fcs_AcTruckXplusTelemetry(averageCurrent, followingError, handoffInError, handoffSensorValue, onlineInError, onlineSensorValue, position, standbyInError, standbySensorValue);
    }
  }
}
