package org.lsst.sal.camera.command;

import org.lsst.sal.camera.CameraCommand;

public class PlaylistCommand extends CameraCommand {
  private final String playlist;

  private final String folder;

  private final String images;

  public PlaylistCommand(String playlist, String folder, String images) {
    this.playlist = playlist;
    this.folder = folder;
    this.images = images;
  }

  public String getPlaylist() {
    return playlist;
  }

  public String getFolder() {
    return folder;
  }

  public String getImages() {
    return images;
  }

  @Override
  public String toString() {
    return "PlaylistCommand{" + "playlist=" + playlist +", folder=" + folder +", images=" + images +
        "}";
  }
}
