package org.lsst.sal.camera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class Fcs_TempSensorsDevice1Telemetry extends CameraTelemetry {
  private final boolean booted;

  private final int errorHistoryNB;

  private final String errorRegister;

  private final boolean inError;

  private final boolean initialized;

  private final int lastErrorCode;

  private final String lastErrorName;

  public Fcs_TempSensorsDevice1Telemetry(boolean booted, int errorHistoryNB, String errorRegister,
      boolean inError, boolean initialized, int lastErrorCode, String lastErrorName) {
    this.booted = booted;
    this.errorHistoryNB = errorHistoryNB;
    this.errorRegister = errorRegister;
    this.inError = inError;
    this.initialized = initialized;
    this.lastErrorCode = lastErrorCode;
    this.lastErrorName = lastErrorName;
  }

  public boolean isBooted() {
    return booted;
  }

  public int getErrorHistoryNB() {
    return errorHistoryNB;
  }

  public String getErrorRegister() {
    return errorRegister;
  }

  public boolean isInError() {
    return inError;
  }

  public boolean isInitialized() {
    return initialized;
  }

  public int getLastErrorCode() {
    return lastErrorCode;
  }

  public String getLastErrorName() {
    return lastErrorName;
  }

  @Override
  public String toString() {
    return "Fcs_TempSensorsDevice1Telemetry{" + "booted=" + booted +
        ", errorHistoryNB=" + errorHistoryNB +", errorRegister=" + errorRegister +
        ", inError=" + inError +", initialized=" + initialized +", lastErrorCode=" + lastErrorCode +
        ", lastErrorName=" + lastErrorName +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private boolean booted;

    private int errorHistoryNB;

    private String errorRegister;

    private boolean inError;

    private boolean initialized;

    private int lastErrorCode;

    private String lastErrorName;

    private Builder() {
    }

    public Builder booted(boolean booted) {
      this.booted = booted;
      return this;
    }

    public Builder errorHistoryNB(int errorHistoryNB) {
      this.errorHistoryNB = errorHistoryNB;
      return this;
    }

    public Builder errorRegister(String errorRegister) {
      this.errorRegister = errorRegister;
      return this;
    }

    public Builder inError(boolean inError) {
      this.inError = inError;
      return this;
    }

    public Builder initialized(boolean initialized) {
      this.initialized = initialized;
      return this;
    }

    public Builder lastErrorCode(int lastErrorCode) {
      this.lastErrorCode = lastErrorCode;
      return this;
    }

    public Builder lastErrorName(String lastErrorName) {
      this.lastErrorName = lastErrorName;
      return this;
    }

    public Fcs_TempSensorsDevice1Telemetry build() {
      return new Fcs_TempSensorsDevice1Telemetry(booted, errorHistoryNB, errorRegister, inError, initialized, lastErrorCode, lastErrorName);
    }
  }
}
