package org.lsst.sal.camera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class Fcs_AutochangerTrucksTelemetry extends CameraTelemetry {
  private final boolean atHandoff;

  private final boolean atOnline;

  private final boolean atStandby;

  private final boolean homingDone;

  private final boolean inError;

  private final int masterPosition;

  private final int slavePosition;

  public Fcs_AutochangerTrucksTelemetry(boolean atHandoff, boolean atOnline, boolean atStandby,
      boolean homingDone, boolean inError, int masterPosition, int slavePosition) {
    this.atHandoff = atHandoff;
    this.atOnline = atOnline;
    this.atStandby = atStandby;
    this.homingDone = homingDone;
    this.inError = inError;
    this.masterPosition = masterPosition;
    this.slavePosition = slavePosition;
  }

  public boolean isAtHandoff() {
    return atHandoff;
  }

  public boolean isAtOnline() {
    return atOnline;
  }

  public boolean isAtStandby() {
    return atStandby;
  }

  public boolean isHomingDone() {
    return homingDone;
  }

  public boolean isInError() {
    return inError;
  }

  public int getMasterPosition() {
    return masterPosition;
  }

  public int getSlavePosition() {
    return slavePosition;
  }

  @Override
  public String toString() {
    return "Fcs_AutochangerTrucksTelemetry{" + "atHandoff=" + atHandoff +", atOnline=" + atOnline +
        ", atStandby=" + atStandby +", homingDone=" + homingDone +", inError=" + inError +
        ", masterPosition=" + masterPosition +", slavePosition=" + slavePosition +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private boolean atHandoff;

    private boolean atOnline;

    private boolean atStandby;

    private boolean homingDone;

    private boolean inError;

    private int masterPosition;

    private int slavePosition;

    private Builder() {
    }

    public Builder atHandoff(boolean atHandoff) {
      this.atHandoff = atHandoff;
      return this;
    }

    public Builder atOnline(boolean atOnline) {
      this.atOnline = atOnline;
      return this;
    }

    public Builder atStandby(boolean atStandby) {
      this.atStandby = atStandby;
      return this;
    }

    public Builder homingDone(boolean homingDone) {
      this.homingDone = homingDone;
      return this;
    }

    public Builder inError(boolean inError) {
      this.inError = inError;
      return this;
    }

    public Builder masterPosition(int masterPosition) {
      this.masterPosition = masterPosition;
      return this;
    }

    public Builder slavePosition(int slavePosition) {
      this.slavePosition = slavePosition;
      return this;
    }

    public Fcs_AutochangerTrucksTelemetry build() {
      return new Fcs_AutochangerTrucksTelemetry(atHandoff, atOnline, atStandby, homingDone, inError, masterPosition, slavePosition);
    }
  }
}
