package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class ConfigurationAppliedEvent extends CameraEvent {
  private final String configurations;

  private final String version;

  private final String url;

  private final String schemaVersion;

  private final String otherInfo;

  public ConfigurationAppliedEvent(String configurations, String version, String url,
      String schemaVersion, String otherInfo) {
    this.configurations = configurations;
    this.version = version;
    this.url = url;
    this.schemaVersion = schemaVersion;
    this.otherInfo = otherInfo;
  }

  public String getConfigurations() {
    return configurations;
  }

  public String getVersion() {
    return version;
  }

  public String getUrl() {
    return url;
  }

  public String getSchemaVersion() {
    return schemaVersion;
  }

  public String getOtherInfo() {
    return otherInfo;
  }

  @Override
  public String toString() {
    return "ConfigurationAppliedEvent{" + "configurations=" + configurations +
        ", version=" + version +", url=" + url +", schemaVersion=" + schemaVersion +
        ", otherInfo=" + otherInfo +"}";
  }
}
