package org.lsst.sal.camera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class Fcs_CarrierTelemetry extends CameraTelemetry {
  private final boolean atEngaged;

  private final boolean atHandoff;

  private final boolean atStorage;

  private final boolean controllerInError;

  private final int current;

  private final boolean engagedSensorOn;

  private final boolean homingDone;

  private final boolean limitSwitchDownInError;

  private final boolean limitSwitchUpInError;

  private final int position;

  private final long profileAcceleration;

  private final long profileDeceleration;

  private final long profileVelocity;

  private final int speed;

  public Fcs_CarrierTelemetry(boolean atEngaged, boolean atHandoff, boolean atStorage,
      boolean controllerInError, int current, boolean engagedSensorOn, boolean homingDone,
      boolean limitSwitchDownInError, boolean limitSwitchUpInError, int position,
      long profileAcceleration, long profileDeceleration, long profileVelocity, int speed) {
    this.atEngaged = atEngaged;
    this.atHandoff = atHandoff;
    this.atStorage = atStorage;
    this.controllerInError = controllerInError;
    this.current = current;
    this.engagedSensorOn = engagedSensorOn;
    this.homingDone = homingDone;
    this.limitSwitchDownInError = limitSwitchDownInError;
    this.limitSwitchUpInError = limitSwitchUpInError;
    this.position = position;
    this.profileAcceleration = profileAcceleration;
    this.profileDeceleration = profileDeceleration;
    this.profileVelocity = profileVelocity;
    this.speed = speed;
  }

  public boolean isAtEngaged() {
    return atEngaged;
  }

  public boolean isAtHandoff() {
    return atHandoff;
  }

  public boolean isAtStorage() {
    return atStorage;
  }

  public boolean isControllerInError() {
    return controllerInError;
  }

  public int getCurrent() {
    return current;
  }

  public boolean isEngagedSensorOn() {
    return engagedSensorOn;
  }

  public boolean isHomingDone() {
    return homingDone;
  }

  public boolean isLimitSwitchDownInError() {
    return limitSwitchDownInError;
  }

  public boolean isLimitSwitchUpInError() {
    return limitSwitchUpInError;
  }

  public int getPosition() {
    return position;
  }

  public long getProfileAcceleration() {
    return profileAcceleration;
  }

  public long getProfileDeceleration() {
    return profileDeceleration;
  }

  public long getProfileVelocity() {
    return profileVelocity;
  }

  public int getSpeed() {
    return speed;
  }

  @Override
  public String toString() {
    return "Fcs_CarrierTelemetry{" + "atEngaged=" + atEngaged +", atHandoff=" + atHandoff +
        ", atStorage=" + atStorage +", controllerInError=" + controllerInError +
        ", current=" + current +", engagedSensorOn=" + engagedSensorOn +
        ", homingDone=" + homingDone +", limitSwitchDownInError=" + limitSwitchDownInError +
        ", limitSwitchUpInError=" + limitSwitchUpInError +", position=" + position +
        ", profileAcceleration=" + profileAcceleration +
        ", profileDeceleration=" + profileDeceleration +", profileVelocity=" + profileVelocity +
        ", speed=" + speed +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private boolean atEngaged;

    private boolean atHandoff;

    private boolean atStorage;

    private boolean controllerInError;

    private int current;

    private boolean engagedSensorOn;

    private boolean homingDone;

    private boolean limitSwitchDownInError;

    private boolean limitSwitchUpInError;

    private int position;

    private long profileAcceleration;

    private long profileDeceleration;

    private long profileVelocity;

    private int speed;

    private Builder() {
    }

    public Builder atEngaged(boolean atEngaged) {
      this.atEngaged = atEngaged;
      return this;
    }

    public Builder atHandoff(boolean atHandoff) {
      this.atHandoff = atHandoff;
      return this;
    }

    public Builder atStorage(boolean atStorage) {
      this.atStorage = atStorage;
      return this;
    }

    public Builder controllerInError(boolean controllerInError) {
      this.controllerInError = controllerInError;
      return this;
    }

    public Builder current(int current) {
      this.current = current;
      return this;
    }

    public Builder engagedSensorOn(boolean engagedSensorOn) {
      this.engagedSensorOn = engagedSensorOn;
      return this;
    }

    public Builder homingDone(boolean homingDone) {
      this.homingDone = homingDone;
      return this;
    }

    public Builder limitSwitchDownInError(boolean limitSwitchDownInError) {
      this.limitSwitchDownInError = limitSwitchDownInError;
      return this;
    }

    public Builder limitSwitchUpInError(boolean limitSwitchUpInError) {
      this.limitSwitchUpInError = limitSwitchUpInError;
      return this;
    }

    public Builder position(int position) {
      this.position = position;
      return this;
    }

    public Builder profileAcceleration(long profileAcceleration) {
      this.profileAcceleration = profileAcceleration;
      return this;
    }

    public Builder profileDeceleration(long profileDeceleration) {
      this.profileDeceleration = profileDeceleration;
      return this;
    }

    public Builder profileVelocity(long profileVelocity) {
      this.profileVelocity = profileVelocity;
      return this;
    }

    public Builder speed(int speed) {
      this.speed = speed;
      return this;
    }

    public Fcs_CarrierTelemetry build() {
      return new Fcs_CarrierTelemetry(atEngaged, atHandoff, atStorage, controllerInError, current, engagedSensorOn, homingDone, limitSwitchDownInError, limitSwitchUpInError, position, profileAcceleration, profileDeceleration, profileVelocity, speed);
    }
  }
}
