package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class ConfigurationsAvailableEvent extends CameraEvent {
  private final String overrides;

  private final String version;

  private final String url;

  private final String schemaVersion;

  public ConfigurationsAvailableEvent(String overrides, String version, String url,
      String schemaVersion) {
    this.overrides = overrides;
    this.version = version;
    this.url = url;
    this.schemaVersion = schemaVersion;
  }

  public String getOverrides() {
    return overrides;
  }

  public String getVersion() {
    return version;
  }

  public String getUrl() {
    return url;
  }

  public String getSchemaVersion() {
    return schemaVersion;
  }

  @Override
  public String toString() {
    return "ConfigurationsAvailableEvent{" + "overrides=" + overrides +", version=" + version +
        ", url=" + url +", schemaVersion=" + schemaVersion +"}";
  }
}
