package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class SummaryStatusEvent extends CameraEvent {
  private final double timestampStatusChanged;

  private final String subsystems;

  private final String subsystemState;

  private final String subsystemColor;

  private final String additionalInfo;

  private final String drillDownLinks;

  public SummaryStatusEvent(double timestampStatusChanged, String subsystems, String subsystemState,
      String subsystemColor, String additionalInfo, String drillDownLinks) {
    this.timestampStatusChanged = timestampStatusChanged;
    this.subsystems = subsystems;
    this.subsystemState = subsystemState;
    this.subsystemColor = subsystemColor;
    this.additionalInfo = additionalInfo;
    this.drillDownLinks = drillDownLinks;
  }

  public double getTimestampStatusChanged() {
    return timestampStatusChanged;
  }

  public String getSubsystems() {
    return subsystems;
  }

  public String getSubsystemState() {
    return subsystemState;
  }

  public String getSubsystemColor() {
    return subsystemColor;
  }

  public String getAdditionalInfo() {
    return additionalInfo;
  }

  public String getDrillDownLinks() {
    return drillDownLinks;
  }

  @Override
  public String toString() {
    return "SummaryStatusEvent{" + "timestampStatusChanged=" + timestampStatusChanged +
        ", subsystems=" + subsystems +", subsystemState=" + subsystemState +
        ", subsystemColor=" + subsystemColor +", additionalInfo=" + additionalInfo +
        ", drillDownLinks=" + drillDownLinks +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private double timestampStatusChanged;

    private String subsystems;

    private String subsystemState;

    private String subsystemColor;

    private String additionalInfo;

    private String drillDownLinks;

    private Builder() {
    }

    public Builder timestampStatusChanged(double timestampStatusChanged) {
      this.timestampStatusChanged = timestampStatusChanged;
      return this;
    }

    public Builder subsystems(String subsystems) {
      this.subsystems = subsystems;
      return this;
    }

    public Builder subsystemState(String subsystemState) {
      this.subsystemState = subsystemState;
      return this;
    }

    public Builder subsystemColor(String subsystemColor) {
      this.subsystemColor = subsystemColor;
      return this;
    }

    public Builder additionalInfo(String additionalInfo) {
      this.additionalInfo = additionalInfo;
      return this;
    }

    public Builder drillDownLinks(String drillDownLinks) {
      this.drillDownLinks = drillDownLinks;
      return this;
    }

    public SummaryStatusEvent build() {
      return new SummaryStatusEvent(timestampStatusChanged, subsystems, subsystemState, subsystemColor, additionalInfo, drillDownLinks);
    }
  }
}
