package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class AuthListEvent extends CameraEvent {
  private final String authorizedUsers;

  private final String nonAuthorizedCSCs;

  public AuthListEvent(String authorizedUsers, String nonAuthorizedCSCs) {
    this.authorizedUsers = authorizedUsers;
    this.nonAuthorizedCSCs = nonAuthorizedCSCs;
  }

  public String getAuthorizedUsers() {
    return authorizedUsers;
  }

  public String getNonAuthorizedCSCs() {
    return nonAuthorizedCSCs;
  }

  @Override
  public String toString() {
    return "AuthListEvent{" + "authorizedUsers=" + authorizedUsers +
        ", nonAuthorizedCSCs=" + nonAuthorizedCSCs +"}";
  }
}
