/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.TestHelper;
import org.lsst.sal.camera.SALCamera;
import org.lsst.sal.camera.telemetry.Daq_monitor_StoreTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_AcSensorsGatewayTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_AcTruckXminusControllerTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_AcTruckXminusTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_AcTruckXplusControllerTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_AcTruckXplusTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_AccelerobfTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Ai814Telemetry;
import org.lsst.sal.camera.telemetry.Fcs_AutochangerTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_AutochangerTrucksTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_BrakeSystemGatewayTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_CarouselControllerTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_CarouselTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_CarrierControllerTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_CarrierTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_CcsVersionsTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_ClampXminus1Telemetry;
import org.lsst.sal.camera.telemetry.Fcs_ClampXminus2Telemetry;
import org.lsst.sal.camera.telemetry.Fcs_ClampXminus3Telemetry;
import org.lsst.sal.camera.telemetry.Fcs_ClampXminus4Telemetry;
import org.lsst.sal.camera.telemetry.Fcs_ClampXminus5Telemetry;
import org.lsst.sal.camera.telemetry.Fcs_ClampXminusControllerTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_ClampXplus1Telemetry;
import org.lsst.sal.camera.telemetry.Fcs_ClampXplus2Telemetry;
import org.lsst.sal.camera.telemetry.Fcs_ClampXplus3Telemetry;
import org.lsst.sal.camera.telemetry.Fcs_ClampXplus4Telemetry;
import org.lsst.sal.camera.telemetry.Fcs_ClampXplus5Telemetry;
import org.lsst.sal.camera.telemetry.Fcs_ClampXplusControllerTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_ConfigTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_HooksControllerTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_HooksTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Hyttc580Telemetry;
import org.lsst.sal.camera.telemetry.Fcs_LatchXminusControllerTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_LatchXminusTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_LatchXplusControllerTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_LatchXplusTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_LatchesTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_LoaderPlutoGatewayTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_LoaderTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_OnlineClampXminusControllerTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_OnlineClampXminusTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_OnlineClampXplusControllerTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_OnlineClampXplusTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_OnlineClampYminusControllerTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_OnlineClampYminusTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_OnlineClampsTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_OnlineStrainGaugeTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_ProximitySensorsDeviceTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Pt100Telemetry;
import org.lsst.sal.camera.telemetry.Fcs_RuntimeInfoTelemetry;
import org.lsst.sal.camera.telemetry.Fcs_Socket1Telemetry;
import org.lsst.sal.camera.telemetry.Fcs_Socket2Telemetry;
import org.lsst.sal.camera.telemetry.Fcs_Socket3Telemetry;
import org.lsst.sal.camera.telemetry.Fcs_Socket4Telemetry;
import org.lsst.sal.camera.telemetry.Fcs_Socket5Telemetry;
import org.lsst.sal.camera.telemetry.Fcs_TempSensorsDevice1Telemetry;
import org.lsst.sal.camera.telemetry.Fcs_TempSensorsDevice2Telemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_CcdTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebTotalPowerTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_SegmentTelemetry;
import org.lsst.sal.camera.telemetry.Hex_Cold1Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cold2Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo1Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo2Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo3Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo4Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo5Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo6Telemetry;
import org.lsst.sal.camera.telemetry.Quadbox_BFRTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_24VCTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_24VDTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_48VTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_5VTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_REB_Bulk_PSTelemetry;
import org.lsst.sal.camera.telemetry.Rebpower_RebTelemetry;
import org.lsst.sal.camera.telemetry.Rebpower_RebpsTelemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cold1Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cold2Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo1Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo2Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo3Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo4Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo5Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo6Telemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP1_ITelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP1_VTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP2_ITelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP2_VTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP3_ITelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP3_VTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP4_ITelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP4_VTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP5_ITelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP5_VTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP6_ITelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP6_VTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CryoVacTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_ForelineVacTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_Hex1VacTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_Hex2VacTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_TurboCurrentTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_TurboPowerTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_TurboPumpTempTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_TurboSpeedTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_TurboVacTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_TurboVoltageTelemetry;

public class TelemetrySendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = SALCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALTelemetry testSendReceive(SALTelemetry item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALTelemetry> future = executor.submit(() -> sal.getTelemetry(Duration.ofSeconds(10L)));
        try {
            sal.sendTelemetry(item);
            SALTelemetry sALTelemetry = future.get(10L, TimeUnit.SECONDS);
            return sALTelemetry;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveQuadbox_BFRTelemetry() throws Exception {
        double clean_5_24V_I = 0.9578322172164917;
        double dirty_24V_I = 0.2023366093635559;
        double dirty_28V_I = 0.3699355125427246;
        double dirty_48V_I = 0.4264281392097473;
        double heater_I = 0.05219519f;
        double protection_I = 0.6109493970870972;
        double rebps_0_2_I = 0.5834362506866455;
        double rebps_3_5_I = 0.28520846366882324;
        double rebps_6_8_I = 0.2823162078857422;
        double rebps_9_12_I = 0.19853603839874268;
        double rebps_Spr_I = 0.03734469413757324;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_BFRTelemetry(clean_5_24V_I, dirty_24V_I, dirty_28V_I, dirty_48V_I, heater_I, protection_I, rebps_0_2_I, rebps_3_5_I, rebps_6_8_I, rebps_9_12_I, rebps_Spr_I));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFRTelemetry));
        Quadbox_BFRTelemetry item_ = (Quadbox_BFRTelemetry)item;
        Assert.assertEquals((double)clean_5_24V_I, (double)item_.getClean_5_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I, (double)item_.getDirty_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I, (double)item_.getDirty_28V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I, (double)item_.getDirty_48V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)heater_I, (double)item_.getHeater_I(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I, (double)item_.getProtection_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_2_I, (double)item_.getRebps_0_2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_3_5_I, (double)item_.getRebps_3_5_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_6_8_I, (double)item_.getRebps_6_8_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_9_12_I, (double)item_.getRebps_9_12_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_Spr_I, (double)item_.getRebps_Spr_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VCTelemetry() throws Exception {
        double n_24vc_Board_T = 0.857648491859436;
        double n_24vc_FPGA_T = 0.9606726169586182;
        double n_24vc_Main_I = 0.3003922700881958;
        double n_24vc_Main_T = 0.7687066793441772;
        double n_24vc_Main_V = 0.5367991924285889;
        double body_Purge_I = 0.8407281637191772;
        double body_Purge_V = 0.7217233777046204;
        double bpu_Maq20_I = 0.2505093812942505;
        double bpu_Maq20_V = 0.19337981939315796;
        double fes_Shu_HCU_I = 0.1740619f;
        double fes_Shu_HCU_V = 0.16812056303024292;
        double gauges_I = 0.8654240965843201;
        double gauges_V = 0.8776325583457947;
        double ion_Pumps_I = 0.8186141848564148;
        double ion_Pumps_V = 0.3416285514831543;
        double pwr_Cry_HCU_I = 0.6987219452857971;
        double pwr_Cry_HCU_V = 0.5410972833633423;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VCTelemetry(n_24vc_Board_T, n_24vc_FPGA_T, n_24vc_Main_I, n_24vc_Main_T, n_24vc_Main_V, body_Purge_I, body_Purge_V, bpu_Maq20_I, bpu_Maq20_V, fes_Shu_HCU_I, fes_Shu_HCU_V, gauges_I, gauges_V, ion_Pumps_I, ion_Pumps_V, pwr_Cry_HCU_I, pwr_Cry_HCU_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VCTelemetry));
        Quadbox_PDU_24VCTelemetry item_ = (Quadbox_PDU_24VCTelemetry)item;
        Assert.assertEquals((double)n_24vc_Board_T, (double)item_.getN_24vc_Board_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_FPGA_T, (double)item_.getN_24vc_FPGA_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_I, (double)item_.getN_24vc_Main_I(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_T, (double)item_.getN_24vc_Main_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_V, (double)item_.getN_24vc_Main_V(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_I, (double)item_.getBody_Purge_I(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_V, (double)item_.getBody_Purge_V(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_I, (double)item_.getBpu_Maq20_I(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_V, (double)item_.getBpu_Maq20_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_I, (double)item_.getFes_Shu_HCU_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_V, (double)item_.getFes_Shu_HCU_V(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I, (double)item_.getGauges_I(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V, (double)item_.getGauges_V(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I, (double)item_.getIon_Pumps_I(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V, (double)item_.getIon_Pumps_V(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_I, (double)item_.getPwr_Cry_HCU_I(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_V, (double)item_.getPwr_Cry_HCU_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VDTelemetry() throws Exception {
        double n_24vd_Board_T = 0.7867089509963989;
        double n_24vd_FPGA_T = 0.0941278338432312;
        double n_24vd_Main_I = 0.931046187877655;
        double n_24vd_Main_T = 0.21988266706466675;
        double n_24vd_Main_V = 0.7550634145736694;
        double cryo_Turbo_I = 0.9361757636070251;
        double cryo_Turbo_V = 0.019108355045318604;
        double hex_Turbo_I = 0.7347357273101807;
        double hex_Turbo_V = 0.2345951795578003;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VDTelemetry(n_24vd_Board_T, n_24vd_FPGA_T, n_24vd_Main_I, n_24vd_Main_T, n_24vd_Main_V, cryo_Turbo_I, cryo_Turbo_V, hex_Turbo_I, hex_Turbo_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VDTelemetry));
        Quadbox_PDU_24VDTelemetry item_ = (Quadbox_PDU_24VDTelemetry)item;
        Assert.assertEquals((double)n_24vd_Board_T, (double)item_.getN_24vd_Board_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_FPGA_T, (double)item_.getN_24vd_FPGA_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_I, (double)item_.getN_24vd_Main_I(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_T, (double)item_.getN_24vd_Main_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_V, (double)item_.getN_24vd_Main_V(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I, (double)item_.getCryo_Turbo_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V, (double)item_.getCryo_Turbo_V(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_I, (double)item_.getHex_Turbo_I(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_V, (double)item_.getHex_Turbo_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_48VTelemetry() throws Exception {
        double n_48v_Board_T = 0.7834237813949585;
        double n_48v_FPGA_T = 0.8315953612327576;
        double n_48v_Main_I = 0.2510741949081421;
        double n_48v_Main_T = 0.7227205038070679;
        double n_48v_Main_V = 0.9719487428665161;
        double purge_Fan_I = 0.21742552518844604;
        double purge_Fan_V = 0.7121472358703613;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_48VTelemetry(n_48v_Board_T, n_48v_FPGA_T, n_48v_Main_I, n_48v_Main_T, n_48v_Main_V, purge_Fan_I, purge_Fan_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48VTelemetry));
        Quadbox_PDU_48VTelemetry item_ = (Quadbox_PDU_48VTelemetry)item;
        Assert.assertEquals((double)n_48v_Board_T, (double)item_.getN_48v_Board_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_FPGA_T, (double)item_.getN_48v_FPGA_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_I, (double)item_.getN_48v_Main_I(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_T, (double)item_.getN_48v_Main_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_V, (double)item_.getN_48v_Main_V(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_I, (double)item_.getPurge_Fan_I(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_V, (double)item_.getPurge_Fan_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_5VTelemetry() throws Exception {
        double otm_0_A_I = 0.9078497886657715;
        double otm_0_A_V = 0.12912046909332275;
        double otm_0_B_I = 0.27337998151779175;
        double otm_0_B_V = 0.9967654943466187;
        double otm_1_A_I = 0.05340749f;
        double otm_1_A_V = 0.4919287f;
        double otm_1_B_I = 0.1381072998046875;
        double otm_1_B_V = 0.7738508582115173;
        double otm_2_A_I = 0.01103430986404419;
        double otm_2_A_V = 0.2170717716217041;
        double otm_2_B_I = 0.15021568536758423;
        double otm_2_B_V = 0.1217767596244812;
        double otm_3_A_I = 0.8693954944610596;
        double otm_3_A_V = 0.32677024602890015;
        double otm_3_B_I = 0.9909141063690186;
        double otm_3_B_V = 0.571614682674408;
        double otm_4_A_I = 0.27157366275787354;
        double otm_4_A_V = 0.33452296257019043;
        double otm_4_B_I = 0.19836342334747314;
        double otm_4_B_V = 0.9186033606529236;
        double otm_5_A_I = 0.681343138217926;
        double otm_5_A_V = 0.6523274779319763;
        double otm_5_B_I = 0.5440795421600342;
        double otm_5_B_V = 0.8521692156791687;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_5VTelemetry(otm_0_A_I, otm_0_A_V, otm_0_B_I, otm_0_B_V, otm_1_A_I, otm_1_A_V, otm_1_B_I, otm_1_B_V, otm_2_A_I, otm_2_A_V, otm_2_B_I, otm_2_B_V, otm_3_A_I, otm_3_A_V, otm_3_B_I, otm_3_B_V, otm_4_A_I, otm_4_A_V, otm_4_B_I, otm_4_B_V, otm_5_A_I, otm_5_A_V, otm_5_B_I, otm_5_B_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5VTelemetry));
        Quadbox_PDU_5VTelemetry item_ = (Quadbox_PDU_5VTelemetry)item;
        Assert.assertEquals((double)otm_0_A_I, (double)item_.getOtm_0_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_V, (double)item_.getOtm_0_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I, (double)item_.getOtm_0_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_V, (double)item_.getOtm_0_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_I, (double)item_.getOtm_1_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_V, (double)item_.getOtm_1_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_I, (double)item_.getOtm_1_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_V, (double)item_.getOtm_1_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_I, (double)item_.getOtm_2_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_V, (double)item_.getOtm_2_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_I, (double)item_.getOtm_2_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_V, (double)item_.getOtm_2_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I, (double)item_.getOtm_3_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V, (double)item_.getOtm_3_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I, (double)item_.getOtm_3_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V, (double)item_.getOtm_3_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_I, (double)item_.getOtm_4_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_V, (double)item_.getOtm_4_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_I, (double)item_.getOtm_4_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_V, (double)item_.getOtm_4_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_I, (double)item_.getOtm_5_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_V, (double)item_.getOtm_5_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_I, (double)item_.getOtm_5_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_V, (double)item_.getOtm_5_B_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_REB_Bulk_PSTelemetry() throws Exception {
        double rebbulkps_0_2_I = 0.8633056879043579;
        double rebbulkps_0_2_T = 0.4047976f;
        double rebbulkps_0_2_V = 0.9445672631263733;
        double rebbulkps_3_5_I = 0.686534f;
        double rebbulkps_3_5_T = 0.0961449146270752;
        double rebbulkps_3_5_V = 0.7788357138633728;
        double rebbulkps_6_8_I = 0.22763729095458984;
        double rebbulkps_6_8_T = 0.5643602013587952;
        double rebbulkps_6_8_V = 0.9599761366844177;
        double rebbulkps_9_12_I = 0.9858710765838623;
        double rebbulkps_9_12_T = 0.45698732137680054;
        double rebbulkps_9_12_V = 0.8661306500434875;
        double rebbulkps_Brd_T = 0.2414093017578125;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_REB_Bulk_PSTelemetry(rebbulkps_0_2_I, rebbulkps_0_2_T, rebbulkps_0_2_V, rebbulkps_3_5_I, rebbulkps_3_5_T, rebbulkps_3_5_V, rebbulkps_6_8_I, rebbulkps_6_8_T, rebbulkps_6_8_V, rebbulkps_9_12_I, rebbulkps_9_12_T, rebbulkps_9_12_V, rebbulkps_Brd_T));
        Assert.assertTrue((boolean)(item instanceof Quadbox_REB_Bulk_PSTelemetry));
        Quadbox_REB_Bulk_PSTelemetry item_ = (Quadbox_REB_Bulk_PSTelemetry)item;
        Assert.assertEquals((double)rebbulkps_0_2_I, (double)item_.getRebbulkps_0_2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_T, (double)item_.getRebbulkps_0_2_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_V, (double)item_.getRebbulkps_0_2_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_I, (double)item_.getRebbulkps_3_5_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_T, (double)item_.getRebbulkps_3_5_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_V, (double)item_.getRebbulkps_3_5_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_I, (double)item_.getRebbulkps_6_8_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_T, (double)item_.getRebbulkps_6_8_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_V, (double)item_.getRebbulkps_6_8_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_I, (double)item_.getRebbulkps_9_12_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_T, (double)item_.getRebbulkps_9_12_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_V, (double)item_.getRebbulkps_9_12_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_Brd_T, (double)item_.getRebbulkps_Brd_T(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebTelemetry() throws Exception {
        double[] analog_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)-102644413);
        double[] analog_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)239014728);
        double[] analog_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)-312226780);
        double[] analog_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-1449100342);
        double[] analog_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)1472087692);
        double[] clockhi_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)1994965176);
        double[] clockhi_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-596546597);
        double[] clockhi_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)-609825087);
        double[] clockhi_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)920178998);
        double[] clockhi_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)-118752165);
        double[] clocklo_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)1943985338);
        double[] clocklo_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-1481747998);
        double[] clocklo_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)566407525);
        double[] clocklo_VaftLDO2 = TestHelper.generateDoubleArray((int)71, (int)-14337133);
        double[] clocklo_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-200714790);
        double[] clocklo_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)593392339);
        double[] digital_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)-296355028);
        double[] digital_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-194351510);
        double[] digital_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)-1221640622);
        double[] digital_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-715876977);
        double[] digital_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)-341748230);
        double[] dphi_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)-794109957);
        double[] dphi_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)412690378);
        double[] dphi_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)1260895590);
        double[] dphi_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)1392544596);
        double[] dphi_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)-158758640);
        double[] heater_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)-524329394);
        double[] heater_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)1410286151);
        double[] heater_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)446876868);
        double[] heater_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-1907203828);
        double[] heater_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)-1466424988);
        double[] hvbias_IbefSwch = TestHelper.generateDoubleArray((int)71, (int)-2031544767);
        double[] hvbias_VbefSwch = TestHelper.generateDoubleArray((int)71, (int)911926545);
        String location = "p";
        double[] od_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)-887070905);
        double[] od_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-928724817);
        double[] od_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)-1356522169);
        double[] od_VaftLDO2 = TestHelper.generateDoubleArray((int)71, (int)1647174645);
        double[] od_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-1933743821);
        double[] od_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)881801593);
        double[] power = TestHelper.generateDoubleArray((int)71, (int)1388689597);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebTelemetry(analog_IaftLDO, analog_IbefLDO, analog_VaftLDO, analog_VaftSwch, analog_VbefLDO, clockhi_IaftLDO, clockhi_IbefLDO, clockhi_VaftLDO, clockhi_VaftSwch, clockhi_VbefLDO, clocklo_IaftLDO, clocklo_IbefLDO, clocklo_VaftLDO, clocklo_VaftLDO2, clocklo_VaftSwch, clocklo_VbefLDO, digital_IaftLDO, digital_IbefLDO, digital_VaftLDO, digital_VaftSwch, digital_VbefLDO, dphi_IaftLDO, dphi_IbefLDO, dphi_VaftLDO, dphi_VaftSwch, dphi_VbefLDO, heater_IaftLDO, heater_IbefLDO, heater_VaftLDO, heater_VaftSwch, heater_VbefLDO, hvbias_IbefSwch, hvbias_VbefSwch, location, od_IaftLDO, od_IbefLDO, od_VaftLDO, od_VaftLDO2, od_VaftSwch, od_VbefLDO, power));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebTelemetry));
        Rebpower_RebTelemetry item_ = (Rebpower_RebTelemetry)item;
        Assert.assertArrayEquals((double[])analog_IaftLDO, (double[])item_.getAnalog_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO, (double[])item_.getAnalog_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO, (double[])item_.getAnalog_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch, (double[])item_.getAnalog_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO, (double[])item_.getAnalog_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO, (double[])item_.getClockhi_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO, (double[])item_.getClockhi_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO, (double[])item_.getClockhi_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch, (double[])item_.getClockhi_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO, (double[])item_.getClockhi_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO, (double[])item_.getClocklo_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO, (double[])item_.getClocklo_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO, (double[])item_.getClocklo_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2, (double[])item_.getClocklo_VaftLDO2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch, (double[])item_.getClocklo_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO, (double[])item_.getClocklo_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO, (double[])item_.getDigital_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO, (double[])item_.getDigital_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO, (double[])item_.getDigital_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch, (double[])item_.getDigital_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO, (double[])item_.getDigital_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IaftLDO, (double[])item_.getDphi_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IbefLDO, (double[])item_.getDphi_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftLDO, (double[])item_.getDphi_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftSwch, (double[])item_.getDphi_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VbefLDO, (double[])item_.getDphi_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO, (double[])item_.getHeater_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO, (double[])item_.getHeater_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO, (double[])item_.getHeater_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch, (double[])item_.getHeater_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO, (double[])item_.getHeater_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch, (double[])item_.getHvbias_IbefSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch, (double[])item_.getHvbias_VbefSwch(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])od_IaftLDO, (double[])item_.getOd_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO, (double[])item_.getOd_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO, (double[])item_.getOd_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2, (double[])item_.getOd_VaftLDO2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch, (double[])item_.getOd_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO, (double[])item_.getOd_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebpsTelemetry() throws Exception {
        double[] boardTemp0 = TestHelper.generateDoubleArray((int)13, (int)-698501361);
        double[] boardTemp1 = TestHelper.generateDoubleArray((int)13, (int)-1863044083);
        double[] boardTemp2 = TestHelper.generateDoubleArray((int)13, (int)-789614179);
        double[] boardTemp3 = TestHelper.generateDoubleArray((int)13, (int)310597391);
        double[] boardTemp4 = TestHelper.generateDoubleArray((int)13, (int)-331509536);
        double[] boardTemp5 = TestHelper.generateDoubleArray((int)13, (int)169288332);
        double[] boardTemp6 = TestHelper.generateDoubleArray((int)13, (int)-919598634);
        String location = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebpsTelemetry(boardTemp0, boardTemp1, boardTemp2, boardTemp3, boardTemp4, boardTemp5, boardTemp6, location));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebpsTelemetry));
        Rebpower_RebpsTelemetry item_ = (Rebpower_RebpsTelemetry)item;
        Assert.assertArrayEquals((double[])boardTemp0, (double[])item_.getBoardTemp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp1, (double[])item_.getBoardTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp2, (double[])item_.getBoardTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp3, (double[])item_.getBoardTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp4, (double[])item_.getBoardTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp5, (double[])item_.getBoardTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp6, (double[])item_.getBoardTemp6(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveHex_Cold1Telemetry() throws Exception {
        double evapExitTmp = 0.01270902156829834;
        double hexRtrnTmp = 0.32872843742370605;
        double preExpnTmp = 0.5602349042892456;
        double returnPrs = 0.2593300938606262;
        double superHeat = 0.3174777030944824;
        double supplyPrs = 0.46322983503341675;
        double supplySubCooling = 0.9124523401260376;
        double supplyTmp = 0.34436845779418945;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cold1Telemetry(evapExitTmp, hexRtrnTmp, preExpnTmp, returnPrs, superHeat, supplyPrs, supplySubCooling, supplyTmp));
        Assert.assertTrue((boolean)(item instanceof Hex_Cold1Telemetry));
        Hex_Cold1Telemetry item_ = (Hex_Cold1Telemetry)item;
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preExpnTmp, (double)item_.getPreExpnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)superHeat, (double)item_.getSuperHeat(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyPrs, (double)item_.getSupplyPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)supplySubCooling, (double)item_.getSupplySubCooling(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyTmp, (double)item_.getSupplyTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cold2Telemetry() throws Exception {
        double evapExitTmp = 0.750078022480011;
        double hexRtrnTmp = 0.18899625539779663;
        double preExpnTmp = 0.8106003403663635;
        double returnPrs = 0.2194158434867859;
        double superHeat = 0.7009671926498413;
        double supplyPrs = 0.507375180721283;
        double supplySubCooling = 0.9249336123466492;
        double supplyTmp = 0.6982911229133606;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cold2Telemetry(evapExitTmp, hexRtrnTmp, preExpnTmp, returnPrs, superHeat, supplyPrs, supplySubCooling, supplyTmp));
        Assert.assertTrue((boolean)(item instanceof Hex_Cold2Telemetry));
        Hex_Cold2Telemetry item_ = (Hex_Cold2Telemetry)item;
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preExpnTmp, (double)item_.getPreExpnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)superHeat, (double)item_.getSuperHeat(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyPrs, (double)item_.getSupplyPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)supplySubCooling, (double)item_.getSupplySubCooling(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyTmp, (double)item_.getSupplyTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo1Telemetry() throws Exception {
        double c3ExitTmp = 0.01829511f;
        double c4ExitTmp = 0.6854037046432495;
        double evapExitTmp = 0.028214454650878906;
        double hexRtrnTmp = 0.7769781351089478;
        double liquidPrs = 0.3220542073249817;
        double preC3Tmp = 0.945830225944519;
        double preC4Tmp = 0.8596281409263611;
        double returnPrs = 0.8599603772163391;
        double vaporPrs = 0.03954344987869263;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo1Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo1Telemetry));
        Hex_Cryo1Telemetry item_ = (Hex_Cryo1Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo2Telemetry() throws Exception {
        double c3ExitTmp = 0.07610797882080078;
        double c4ExitTmp = 0.2586974f;
        double evapExitTmp = 0.6401305794715881;
        double hexRtrnTmp = 0.706870436668396;
        double liquidPrs = 0.15935587882995605;
        double preC3Tmp = 0.7605285048484802;
        double preC4Tmp = 0.1153864860534668;
        double returnPrs = 0.9390849471092224;
        double vaporPrs = 0.4172125f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo2Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo2Telemetry));
        Hex_Cryo2Telemetry item_ = (Hex_Cryo2Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo3Telemetry() throws Exception {
        double c3ExitTmp = 0.0624614953994751;
        double c4ExitTmp = 0.3936976194381714;
        double evapExitTmp = 0.40978842973709106;
        double hexRtrnTmp = 0.6719681620597839;
        double liquidPrs = 0.2124303f;
        double preC3Tmp = 0.9689804911613464;
        double preC4Tmp = 0.40770626068115234;
        double returnPrs = 0.35620254278182983;
        double vaporPrs = 0.3718924f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo3Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo3Telemetry));
        Hex_Cryo3Telemetry item_ = (Hex_Cryo3Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo4Telemetry() throws Exception {
        double c3ExitTmp = 0.691962f;
        double c4ExitTmp = 0.338876f;
        double evapExitTmp = 0.0108528733253479;
        double hexRtrnTmp = 0.1150006651878357;
        double liquidPrs = 0.503386378288269;
        double preC3Tmp = 0.5330544710159302;
        double preC4Tmp = 0.2712981104850769;
        double returnPrs = 0.4378369450569153;
        double vaporPrs = 0.3220877f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo4Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo4Telemetry));
        Hex_Cryo4Telemetry item_ = (Hex_Cryo4Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo5Telemetry() throws Exception {
        double c3ExitTmp = 0.08405661582946777;
        double c4ExitTmp = 0.915386974811554;
        double evapExitTmp = 0.6672022938728333;
        double hexRtrnTmp = 0.10890454053878784;
        double liquidPrs = 0.2265278697013855;
        double preC3Tmp = 0.3727222f;
        double preC4Tmp = 0.9309805035591125;
        double returnPrs = 0.7710607051849365;
        double vaporPrs = 0.024738788604736328;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo5Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo5Telemetry));
        Hex_Cryo5Telemetry item_ = (Hex_Cryo5Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo6Telemetry() throws Exception {
        double c3ExitTmp = 0.4219083786010742;
        double c4ExitTmp = 0.6379082798957825;
        double evapExitTmp = 0.08302581310272217;
        double hexRtrnTmp = 0.34914594888687134;
        double liquidPrs = 0.6484825611114502;
        double preC3Tmp = 0.823265790939331;
        double preC4Tmp = 0.42215466499328613;
        double returnPrs = 0.24856221675872803;
        double vaporPrs = 0.6331031918525696;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo6Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo6Telemetry));
        Hex_Cryo6Telemetry item_ = (Hex_Cryo6Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cold1Telemetry() throws Exception {
        double ambientTmp = 0.2612391710281372;
        double cabinetTmp = 0.7343838214874268;
        double compCurrent = 0.7228309512138367;
        double compPower = 0.08511823415756226;
        double compVfdCurr = 0.8903263211250305;
        double compVfdFreq = 0.5313438773155212;
        double compVfdVolt = 0.47403955459594727;
        double compVoltage = 0.04435485601425171;
        double coolFlowRate = 0.514099657535553;
        double coolValvePosn = 0.7904729247093201;
        double dischrgPrs = 0.7027900815010071;
        double dischrgtmp_M = 0.422962f;
        double dischrgtmp_P = 0.5479776859283447;
        double fan1Speed = 0.6897464394569397;
        double fan2Speed = 0.23725569248199463;
        double fan3Speed = 0.14412641525268555;
        double hGBValvePosn = 0.10858649015426636;
        double liquidSubCooling = 0.10476714372634888;
        double liquidtmp_M = 0.8821964263916016;
        double liquidtmp_P = 0.815823f;
        double suctionPrs = 0.2641300559043884;
        double suctiontmp_M = 0.5650993585586548;
        double suctiontmp_P = 0.5764214992523193;
        double waterInTmp = 0.6314249634742737;
        double waterOutTmp = 0.26338517665863037;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cold1Telemetry(ambientTmp, cabinetTmp, compCurrent, compPower, compVfdCurr, compVfdFreq, compVfdVolt, compVoltage, coolFlowRate, coolValvePosn, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fan1Speed, fan2Speed, fan3Speed, hGBValvePosn, liquidSubCooling, liquidtmp_M, liquidtmp_P, suctionPrs, suctiontmp_M, suctiontmp_P, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cold1Telemetry));
        Refrig_Cold1Telemetry item_ = (Refrig_Cold1Telemetry)item;
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdCurr, (double)item_.getCompVfdCurr(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdFreq, (double)item_.getCompVfdFreq(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdVolt, (double)item_.getCompVfdVolt(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)coolFlowRate, (double)item_.getCoolFlowRate(), (double)1.0E-6f);
        Assert.assertEquals((double)coolValvePosn, (double)item_.getCoolValvePosn(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1Speed, (double)item_.getFan1Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2Speed, (double)item_.getFan2Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3Speed, (double)item_.getFan3Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)hGBValvePosn, (double)item_.getHGBValvePosn(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidSubCooling, (double)item_.getLiquidSubCooling(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M, (double)item_.getLiquidtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P, (double)item_.getLiquidtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cold2Telemetry() throws Exception {
        double ambientTmp = 0.886415421962738;
        double cabinetTmp = 0.8021236658096313;
        double compCurrent = 0.15659433603286743;
        double compPower = 0.9720560312271118;
        double compVfdCurr = 0.3334273099899292;
        double compVfdFreq = 0.3279575705528259;
        double compVfdVolt = 6.222128868103027E-4;
        double compVoltage = 0.2059685f;
        double coolFlowRate = 0.9344773888587952;
        double coolValvePosn = 0.24769741296768188;
        double dischrgPrs = 0.5031424164772034;
        double dischrgtmp_M = 0.751767635345459;
        double dischrgtmp_P = 0.3614826798439026;
        double fan1Speed = 0.9339208006858826;
        double fan2Speed = 0.4323824644088745;
        double fan3Speed = 0.4013543725013733;
        double hGBValvePosn = 0.6487030982971191;
        double liquidSubCooling = 0.8256847262382507;
        double liquidtmp_M = 0.9929359555244446;
        double liquidtmp_P = 0.543327271938324;
        double suctionPrs = 0.3811991810798645;
        double suctiontmp_M = 0.3529665470123291;
        double suctiontmp_P = 0.899176f;
        double waterInTmp = 0.703377f;
        double waterOutTmp = 0.9101479053497314;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cold2Telemetry(ambientTmp, cabinetTmp, compCurrent, compPower, compVfdCurr, compVfdFreq, compVfdVolt, compVoltage, coolFlowRate, coolValvePosn, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fan1Speed, fan2Speed, fan3Speed, hGBValvePosn, liquidSubCooling, liquidtmp_M, liquidtmp_P, suctionPrs, suctiontmp_M, suctiontmp_P, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cold2Telemetry));
        Refrig_Cold2Telemetry item_ = (Refrig_Cold2Telemetry)item;
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdCurr, (double)item_.getCompVfdCurr(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdFreq, (double)item_.getCompVfdFreq(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdVolt, (double)item_.getCompVfdVolt(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)coolFlowRate, (double)item_.getCoolFlowRate(), (double)1.0E-6f);
        Assert.assertEquals((double)coolValvePosn, (double)item_.getCoolValvePosn(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1Speed, (double)item_.getFan1Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2Speed, (double)item_.getFan2Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3Speed, (double)item_.getFan3Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)hGBValvePosn, (double)item_.getHGBValvePosn(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidSubCooling, (double)item_.getLiquidSubCooling(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M, (double)item_.getLiquidtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P, (double)item_.getLiquidtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo1Telemetry() throws Exception {
        double afterCoolTmp = 0.03925037384033203;
        double compCurrent = 0.870225191116333;
        double compPower = 0.8092371821403503;
        double compVoltage = 0.6093133091926575;
        double dischrgPrs = 0.265672504901886;
        double dischrgtmp_M = 0.14483213424682617;
        double dischrgtmp_P = 0.980869472026825;
        double fanSpeed = 0.2774551f;
        double oilLevel = 0.0023656487464904785;
        double oilSepTmp = 0.7661821842193604;
        double phaseSepTmp = 0.8726224303245544;
        double suctionPrs = 0.008474588394165039;
        double suctiontmp_M = 0.269934f;
        double suctiontmp_P = 0.7298126220703125;
        double surgeTankTmp = 0.283852219581604;
        double waterInTmp = 0.3284257f;
        double waterOutTmp = 0.26936566829681396;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo1Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo1Telemetry));
        Refrig_Cryo1Telemetry item_ = (Refrig_Cryo1Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo2Telemetry() throws Exception {
        double afterCoolTmp = 0.1702648401260376;
        double compCurrent = 0.12374293804168701;
        double compPower = 0.1605767011642456;
        double compVoltage = 0.17327308654785156;
        double dischrgPrs = 0.6473636031150818;
        double dischrgtmp_M = 0.2837662696838379;
        double dischrgtmp_P = 0.39153552055358887;
        double fanSpeed = 0.9944057464599609;
        double oilLevel = 0.11016994714736938;
        double oilSepTmp = 0.40944063663482666;
        double phaseSepTmp = 0.028708934783935547;
        double suctionPrs = 0.8062850832939148;
        double suctiontmp_M = 0.11042892932891846;
        double suctiontmp_P = 0.5469865202903748;
        double surgeTankTmp = 0.35834717750549316;
        double waterInTmp = 0.7810779213905334;
        double waterOutTmp = 0.4180908203125;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo2Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo2Telemetry));
        Refrig_Cryo2Telemetry item_ = (Refrig_Cryo2Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo3Telemetry() throws Exception {
        double afterCoolTmp = 0.6984469294548035;
        double ambientTmp = 0.22103798389434814;
        double cabinetTmp = 0.005081593990325928;
        double compCurrent = 0.9851865768432617;
        double compPower = 0.18229389190673828;
        double compVoltage = 0.7453057169914246;
        double dischrgPrs = 0.13420498371124268;
        double dischrgtmp_M = 0.602597f;
        double dischrgtmp_P = 0.5500474572181702;
        double fanSpeed = 0.2380974292755127;
        double oilLevel = 0.5404694080352783;
        double oilSepTmp = 0.0042948126792907715;
        double phaseSepTmp = 0.540683f;
        double suctionPrs = 0.6821931004524231;
        double suctiontmp_M = 0.3838379383087158;
        double suctiontmp_P = 0.2683054804801941;
        double surgeTankTmp = 0.0044209957122802734;
        double waterInTmp = 0.5843737721443176;
        double waterOutTmp = 0.8077393174171448;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo3Telemetry(afterCoolTmp, ambientTmp, cabinetTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo3Telemetry));
        Refrig_Cryo3Telemetry item_ = (Refrig_Cryo3Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo4Telemetry() throws Exception {
        double afterCoolTmp = 0.3314119577407837;
        double compCurrent = 0.9398244023323059;
        double compPower = 0.04455852508544922;
        double compVoltage = 0.3157396912574768;
        double dischrgPrs = 0.22961455583572388;
        double dischrgtmp_M = 0.2600382f;
        double dischrgtmp_P = 0.5557433366775513;
        double fanSpeed = 0.03332066535949707;
        double oilLevel = 0.2682797312736511;
        double oilSepTmp = 0.835699f;
        double phaseSepTmp = 0.5187285542488098;
        double suctionPrs = 0.5131472945213318;
        double suctiontmp_M = 0.9501218199729919;
        double suctiontmp_P = 0.9068294763565063;
        double surgeTankTmp = 0.9762282967567444;
        double waterInTmp = 0.6031903028488159;
        double waterOutTmp = 0.8966374397277832;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo4Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo4Telemetry));
        Refrig_Cryo4Telemetry item_ = (Refrig_Cryo4Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo5Telemetry() throws Exception {
        double afterCoolTmp = 0.47036391496658325;
        double ambientTmp = 0.9905407428741455;
        double cabinetTmp = 0.591361f;
        double compCurrent = 0.7059505581855774;
        double compPower = 0.5433976650238037;
        double compVoltage = 0.15070343017578125;
        double dischrgPrs = 0.8728080987930298;
        double dischrgtmp_M = 0.22946041822433472;
        double dischrgtmp_P = 0.7875076532363892;
        double fanSpeed = 0.28273457288742065;
        double oilLevel = 0.08971691131591797;
        double oilSepTmp = 0.9190602898597717;
        double phaseSepTmp = 0.3223743438720703;
        double suctionPrs = 0.824600100517273;
        double suctiontmp_M = 0.47948354482650757;
        double suctiontmp_P = 0.009491801261901855;
        double surgeTankTmp = 0.32639604806900024;
        double waterInTmp = 0.930970311164856;
        double waterOutTmp = 0.7747588753700256;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo5Telemetry(afterCoolTmp, ambientTmp, cabinetTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo5Telemetry));
        Refrig_Cryo5Telemetry item_ = (Refrig_Cryo5Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo6Telemetry() throws Exception {
        double afterCoolTmp = 0.43571794033050537;
        double compCurrent = 0.3400881886482239;
        double compPower = 0.9973176121711731;
        double compVoltage = 0.74546f;
        double dischrgPrs = 0.6377660632133484;
        double dischrgtmp_M = 0.8800060749053955;
        double dischrgtmp_P = 0.3847376f;
        double fanSpeed = 0.5039306879043579;
        double oilLevel = 0.13565868139266968;
        double oilSepTmp = 0.8150332570075989;
        double phaseSepTmp = 0.02296573f;
        double suctionPrs = 0.23363816738128662;
        double suctiontmp_M = 0.8407949209213257;
        double suctiontmp_P = 0.9345892667770386;
        double surgeTankTmp = 0.7469542622566223;
        double waterInTmp = 0.6008708477020264;
        double waterOutTmp = 0.1490660309791565;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo6Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo6Telemetry));
        Refrig_Cryo6Telemetry item_ = (Refrig_Cryo6Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP1_ITelemetry() throws Exception {
        double cip1_I = 0.6841963529586792;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP1_ITelemetry(cip1_I));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP1_ITelemetry));
        Vacuum_CIP1_ITelemetry item_ = (Vacuum_CIP1_ITelemetry)item;
        Assert.assertEquals((double)cip1_I, (double)item_.getCip1_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP1_VTelemetry() throws Exception {
        double cip1_V = 0.55022794008255;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP1_VTelemetry(cip1_V));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP1_VTelemetry));
        Vacuum_CIP1_VTelemetry item_ = (Vacuum_CIP1_VTelemetry)item;
        Assert.assertEquals((double)cip1_V, (double)item_.getCip1_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP2_ITelemetry() throws Exception {
        double cip2_I = 0.8977405428886414;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP2_ITelemetry(cip2_I));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP2_ITelemetry));
        Vacuum_CIP2_ITelemetry item_ = (Vacuum_CIP2_ITelemetry)item;
        Assert.assertEquals((double)cip2_I, (double)item_.getCip2_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP2_VTelemetry() throws Exception {
        double cip2_V = 0.5923176407814026;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP2_VTelemetry(cip2_V));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP2_VTelemetry));
        Vacuum_CIP2_VTelemetry item_ = (Vacuum_CIP2_VTelemetry)item;
        Assert.assertEquals((double)cip2_V, (double)item_.getCip2_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP3_ITelemetry() throws Exception {
        double cip3_I = 0.29560422897338867;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP3_ITelemetry(cip3_I));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP3_ITelemetry));
        Vacuum_CIP3_ITelemetry item_ = (Vacuum_CIP3_ITelemetry)item;
        Assert.assertEquals((double)cip3_I, (double)item_.getCip3_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP3_VTelemetry() throws Exception {
        double cip3_V = 0.9248427152633667;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP3_VTelemetry(cip3_V));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP3_VTelemetry));
        Vacuum_CIP3_VTelemetry item_ = (Vacuum_CIP3_VTelemetry)item;
        Assert.assertEquals((double)cip3_V, (double)item_.getCip3_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP4_ITelemetry() throws Exception {
        double cip4_I = 0.9013956189155579;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP4_ITelemetry(cip4_I));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP4_ITelemetry));
        Vacuum_CIP4_ITelemetry item_ = (Vacuum_CIP4_ITelemetry)item;
        Assert.assertEquals((double)cip4_I, (double)item_.getCip4_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP4_VTelemetry() throws Exception {
        double cip4_V = 0.1313532590866089;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP4_VTelemetry(cip4_V));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP4_VTelemetry));
        Vacuum_CIP4_VTelemetry item_ = (Vacuum_CIP4_VTelemetry)item;
        Assert.assertEquals((double)cip4_V, (double)item_.getCip4_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP5_ITelemetry() throws Exception {
        double cip5_I = 0.587122917175293;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP5_ITelemetry(cip5_I));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP5_ITelemetry));
        Vacuum_CIP5_ITelemetry item_ = (Vacuum_CIP5_ITelemetry)item;
        Assert.assertEquals((double)cip5_I, (double)item_.getCip5_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP5_VTelemetry() throws Exception {
        double cip5_V = 0.502545952796936;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP5_VTelemetry(cip5_V));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP5_VTelemetry));
        Vacuum_CIP5_VTelemetry item_ = (Vacuum_CIP5_VTelemetry)item;
        Assert.assertEquals((double)cip5_V, (double)item_.getCip5_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP6_ITelemetry() throws Exception {
        double cip6_I = 0.554853f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP6_ITelemetry(cip6_I));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP6_ITelemetry));
        Vacuum_CIP6_ITelemetry item_ = (Vacuum_CIP6_ITelemetry)item;
        Assert.assertEquals((double)cip6_I, (double)item_.getCip6_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP6_VTelemetry() throws Exception {
        double cip6_V = 0.49399012327194214;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP6_VTelemetry(cip6_V));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP6_VTelemetry));
        Vacuum_CIP6_VTelemetry item_ = (Vacuum_CIP6_VTelemetry)item;
        Assert.assertEquals((double)cip6_V, (double)item_.getCip6_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CryoVacTelemetry() throws Exception {
        double cryoVac = 0.8488991260528564;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CryoVacTelemetry(cryoVac));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoVacTelemetry));
        Vacuum_CryoVacTelemetry item_ = (Vacuum_CryoVacTelemetry)item;
        Assert.assertEquals((double)cryoVac, (double)item_.getCryoVac(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_ForelineVacTelemetry() throws Exception {
        double forelineVac = 0.8547142744064331;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_ForelineVacTelemetry(forelineVac));
        Assert.assertTrue((boolean)(item instanceof Vacuum_ForelineVacTelemetry));
        Vacuum_ForelineVacTelemetry item_ = (Vacuum_ForelineVacTelemetry)item;
        Assert.assertEquals((double)forelineVac, (double)item_.getForelineVac(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Hex1VacTelemetry() throws Exception {
        double hex1Vac = 0.24351871013641357;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_Hex1VacTelemetry(hex1Vac));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Hex1VacTelemetry));
        Vacuum_Hex1VacTelemetry item_ = (Vacuum_Hex1VacTelemetry)item;
        Assert.assertEquals((double)hex1Vac, (double)item_.getHex1Vac(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Hex2VacTelemetry() throws Exception {
        double hex2Vac = 0.4998297095298767;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_Hex2VacTelemetry(hex2Vac));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Hex2VacTelemetry));
        Vacuum_Hex2VacTelemetry item_ = (Vacuum_Hex2VacTelemetry)item;
        Assert.assertEquals((double)hex2Vac, (double)item_.getHex2Vac(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboCurrentTelemetry() throws Exception {
        double turboCurrent = 0.20467013120651245;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboCurrentTelemetry(turboCurrent));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboCurrentTelemetry));
        Vacuum_TurboCurrentTelemetry item_ = (Vacuum_TurboCurrentTelemetry)item;
        Assert.assertEquals((double)turboCurrent, (double)item_.getTurboCurrent(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboPowerTelemetry() throws Exception {
        double turboPower = 0.4804941415786743;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboPowerTelemetry(turboPower));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboPowerTelemetry));
        Vacuum_TurboPowerTelemetry item_ = (Vacuum_TurboPowerTelemetry)item;
        Assert.assertEquals((double)turboPower, (double)item_.getTurboPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboPumpTempTelemetry() throws Exception {
        double turboPumpTemp = 0.600662350654602;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboPumpTempTelemetry(turboPumpTemp));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboPumpTempTelemetry));
        Vacuum_TurboPumpTempTelemetry item_ = (Vacuum_TurboPumpTempTelemetry)item;
        Assert.assertEquals((double)turboPumpTemp, (double)item_.getTurboPumpTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboSpeedTelemetry() throws Exception {
        double turboSpeed = 0.28911691904067993;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboSpeedTelemetry(turboSpeed));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboSpeedTelemetry));
        Vacuum_TurboSpeedTelemetry item_ = (Vacuum_TurboSpeedTelemetry)item;
        Assert.assertEquals((double)turboSpeed, (double)item_.getTurboSpeed(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboVacTelemetry() throws Exception {
        double turboVac = 0.10622406005859375;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboVacTelemetry(turboVac));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboVacTelemetry));
        Vacuum_TurboVacTelemetry item_ = (Vacuum_TurboVacTelemetry)item;
        Assert.assertEquals((double)turboVac, (double)item_.getTurboVac(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboVoltageTelemetry() throws Exception {
        double turboVoltage = 0.2845771908760071;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboVoltageTelemetry(turboVoltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboVoltageTelemetry));
        Vacuum_TurboVoltageTelemetry item_ = (Vacuum_TurboVoltageTelemetry)item;
        Assert.assertEquals((double)turboVoltage, (double)item_.getTurboVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_StoreTelemetry() throws Exception {
        double capacity = 0.19535952806472778;
        double freeFraction = 0.2716858983039856;
        double freeSpace = 0.57271808385849;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_StoreTelemetry(capacity, freeFraction, freeSpace));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreTelemetry));
        Daq_monitor_StoreTelemetry item_ = (Daq_monitor_StoreTelemetry)item;
        Assert.assertEquals((double)capacity, (double)item_.getCapacity(), (double)1.0E-6f);
        Assert.assertEquals((double)freeFraction, (double)item_.getFreeFraction(), (double)1.0E-6f);
        Assert.assertEquals((double)freeSpace, (double)item_.getFreeSpace(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_CcdTelemetry() throws Exception {
        double[] gDV = TestHelper.generateDoubleArray((int)201, (int)-1373865584);
        String location = "k";
        double[] oDI = TestHelper.generateDoubleArray((int)201, (int)174361763);
        double[] oDV = TestHelper.generateDoubleArray((int)201, (int)1937137367);
        double[] oGV = TestHelper.generateDoubleArray((int)201, (int)1037461670);
        double[] rDV = TestHelper.generateDoubleArray((int)201, (int)684335870);
        double[] temp = TestHelper.generateDoubleArray((int)201, (int)1291401695);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_CcdTelemetry(gDV, location, oDI, oDV, oGV, rDV, temp));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_CcdTelemetry));
        Focal_plane_CcdTelemetry item_ = (Focal_plane_CcdTelemetry)item;
        Assert.assertArrayEquals((double[])gDV, (double[])item_.getGDV(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oGV, (double[])item_.getOGV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rDV, (double[])item_.getRDV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp, (double[])item_.getTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTelemetry() throws Exception {
        double[] anaI = TestHelper.generateDoubleArray((int)71, (int)-1442200411);
        double[] anaV = TestHelper.generateDoubleArray((int)71, (int)2065509963);
        double[] aspicl_Temp0 = TestHelper.generateDoubleArray((int)71, (int)-1341136234);
        double[] aspicl_Temp1 = TestHelper.generateDoubleArray((int)71, (int)-1160758225);
        double[] aspicl_Temp2 = TestHelper.generateDoubleArray((int)71, (int)-555550857);
        double[] aspicu_Temp0 = TestHelper.generateDoubleArray((int)71, (int)2069221084);
        double[] aspicu_Temp1 = TestHelper.generateDoubleArray((int)71, (int)-528304228);
        double[] aspicu_Temp2 = TestHelper.generateDoubleArray((int)71, (int)-1758969354);
        double[] clkHI = TestHelper.generateDoubleArray((int)71, (int)420076416);
        double[] clkHV = TestHelper.generateDoubleArray((int)71, (int)661734218);
        double[] clkLI = TestHelper.generateDoubleArray((int)71, (int)2064564801);
        double[] clkLV = TestHelper.generateDoubleArray((int)71, (int)2124957302);
        double[] digI = TestHelper.generateDoubleArray((int)71, (int)1637550543);
        double[] digV = TestHelper.generateDoubleArray((int)71, (int)576756466);
        double[] hVBiasSwitch = TestHelper.generateDoubleArray((int)71, (int)822531769);
        double[] htrPI = TestHelper.generateDoubleArray((int)71, (int)-1831289795);
        double[] htrPV = TestHelper.generateDoubleArray((int)71, (int)-579658831);
        double[] htrV = TestHelper.generateDoubleArray((int)71, (int)-722473677);
        double[] htrW = TestHelper.generateDoubleArray((int)71, (int)1910001986);
        String location = "p";
        double[] oDI = TestHelper.generateDoubleArray((int)71, (int)-932818879);
        double[] oDV = TestHelper.generateDoubleArray((int)71, (int)475637349);
        double[] pClk0 = TestHelper.generateDoubleArray((int)71, (int)-1018891292);
        double[] pClk1 = TestHelper.generateDoubleArray((int)71, (int)-768034644);
        double[] pClkL = TestHelper.generateDoubleArray((int)71, (int)3008824);
        double[] pClkU = TestHelper.generateDoubleArray((int)71, (int)-734317701);
        double[] power = TestHelper.generateDoubleArray((int)71, (int)-1577438460);
        double[] rG0 = TestHelper.generateDoubleArray((int)71, (int)1112552857);
        double[] rG1 = TestHelper.generateDoubleArray((int)71, (int)1533307252);
        double[] rGL = TestHelper.generateDoubleArray((int)71, (int)-1097460878);
        double[] rGU = TestHelper.generateDoubleArray((int)71, (int)1493888401);
        double[] rTDTemp = TestHelper.generateDoubleArray((int)71, (int)-850258871);
        double[] ref05V = TestHelper.generateDoubleArray((int)71, (int)1147505951);
        double[] ref125V = TestHelper.generateDoubleArray((int)71, (int)-1240663087);
        double[] ref15V = TestHelper.generateDoubleArray((int)71, (int)-774339276);
        double[] ref25V = TestHelper.generateDoubleArray((int)71, (int)1210287322);
        double[] refN12 = TestHelper.generateDoubleArray((int)71, (int)1265004298);
        double[] refP12 = TestHelper.generateDoubleArray((int)71, (int)-877697544);
        double[] sClk0 = TestHelper.generateDoubleArray((int)71, (int)-1466523173);
        double[] sClk1 = TestHelper.generateDoubleArray((int)71, (int)1770301252);
        double[] sClkL = TestHelper.generateDoubleArray((int)71, (int)55690688);
        double[] sClkU = TestHelper.generateDoubleArray((int)71, (int)-703625044);
        double[] temp1 = TestHelper.generateDoubleArray((int)71, (int)1417873137);
        double[] temp10 = TestHelper.generateDoubleArray((int)71, (int)-1219294602);
        double[] temp2 = TestHelper.generateDoubleArray((int)71, (int)847404504);
        double[] temp3 = TestHelper.generateDoubleArray((int)71, (int)1476388307);
        double[] temp4 = TestHelper.generateDoubleArray((int)71, (int)1554581456);
        double[] temp5 = TestHelper.generateDoubleArray((int)71, (int)-1957529154);
        double[] temp6 = TestHelper.generateDoubleArray((int)71, (int)1425696139);
        double[] temp7 = TestHelper.generateDoubleArray((int)71, (int)-1535807365);
        double[] temp8 = TestHelper.generateDoubleArray((int)71, (int)1359171443);
        double[] temp9 = TestHelper.generateDoubleArray((int)71, (int)-1310016403);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTelemetry(anaI, anaV, aspicl_Temp0, aspicl_Temp1, aspicl_Temp2, aspicu_Temp0, aspicu_Temp1, aspicu_Temp2, clkHI, clkHV, clkLI, clkLV, digI, digV, hVBiasSwitch, htrPI, htrPV, htrV, htrW, location, oDI, oDV, pClk0, pClk1, pClkL, pClkU, power, rG0, rG1, rGL, rGU, rTDTemp, ref05V, ref125V, ref15V, ref25V, refN12, refP12, sClk0, sClk1, sClkL, sClkU, temp1, temp10, temp2, temp3, temp4, temp5, temp6, temp7, temp8, temp9));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTelemetry));
        Focal_plane_RebTelemetry item_ = (Focal_plane_RebTelemetry)item;
        Assert.assertArrayEquals((double[])anaI, (double[])item_.getAnaI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anaV, (double[])item_.getAnaV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0, (double[])item_.getAspicl_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1, (double[])item_.getAspicl_Temp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2, (double[])item_.getAspicl_Temp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0, (double[])item_.getAspicu_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1, (double[])item_.getAspicu_Temp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2, (double[])item_.getAspicu_Temp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHI, (double[])item_.getClkHI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHV, (double[])item_.getClkHV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLI, (double[])item_.getClkLI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLV, (double[])item_.getClkLV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digI, (double[])item_.getDigI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digV, (double[])item_.getDigV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hVBiasSwitch, (double[])item_.getHVBiasSwitch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrPI, (double[])item_.getHtrPI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrPV, (double[])item_.getHtrPV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrV, (double[])item_.getHtrV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrW, (double[])item_.getHtrW(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClk0, (double[])item_.getPClk0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClk1, (double[])item_.getPClk1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkL, (double[])item_.getPClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkU, (double[])item_.getPClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rG0, (double[])item_.getRG0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rG1, (double[])item_.getRG1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGL, (double[])item_.getRGL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGU, (double[])item_.getRGU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rTDTemp, (double[])item_.getRTDTemp(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05V, (double[])item_.getRef05V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125V, (double[])item_.getRef125V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15V, (double[])item_.getRef15V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25V, (double[])item_.getRef25V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refN12, (double[])item_.getRefN12(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refP12, (double[])item_.getRefP12(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClk0, (double[])item_.getSClk0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClk1, (double[])item_.getSClk1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkL, (double[])item_.getSClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkU, (double[])item_.getSClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1, (double[])item_.getTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10, (double[])item_.getTemp10(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2, (double[])item_.getTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3, (double[])item_.getTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4, (double[])item_.getTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5, (double[])item_.getTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6, (double[])item_.getTemp6(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7, (double[])item_.getTemp7(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8, (double[])item_.getTemp8(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9, (double[])item_.getTemp9(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTotalPowerTelemetry() throws Exception {
        double rebTotalPower = 0.5646265149116516;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTotalPowerTelemetry(rebTotalPower));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTotalPowerTelemetry));
        Focal_plane_RebTotalPowerTelemetry item_ = (Focal_plane_RebTotalPowerTelemetry)item;
        Assert.assertEquals((double)rebTotalPower, (double)item_.getRebTotalPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_SegmentTelemetry() throws Exception {
        double[] i = TestHelper.generateDoubleArray((int)3024, (int)-1856532704);
        String location = "v";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_SegmentTelemetry(i, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SegmentTelemetry));
        Focal_plane_SegmentTelemetry item_ = (Focal_plane_SegmentTelemetry)item;
        Assert.assertArrayEquals((double[])i, (double[])item_.getI(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFcs_AcSensorsGatewayTelemetry() throws Exception {
        boolean booted = true;
        boolean initialized = true;
        int intValues = 386;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_AcSensorsGatewayTelemetry(booted, initialized, intValues));
        Assert.assertTrue((boolean)(item instanceof Fcs_AcSensorsGatewayTelemetry));
        Fcs_AcSensorsGatewayTelemetry item_ = (Fcs_AcSensorsGatewayTelemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)intValues, (long)item_.getIntValues());
    }

    @Test
    public void sendReceiveFcs_AcTruckXminusTelemetry() throws Exception {
        int averageCurrent = 475;
        int followingError = 630;
        boolean handoffInError = false;
        boolean handoffSensorValue = true;
        boolean onlineInError = false;
        boolean onlineSensorValue = true;
        int position = 29;
        boolean standbyInError = false;
        boolean standbySensorValue = true;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_AcTruckXminusTelemetry(averageCurrent, followingError, handoffInError, handoffSensorValue, onlineInError, onlineSensorValue, position, standbyInError, standbySensorValue));
        Assert.assertTrue((boolean)(item instanceof Fcs_AcTruckXminusTelemetry));
        Fcs_AcTruckXminusTelemetry item_ = (Fcs_AcTruckXminusTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)handoffInError, (Object)item_.isHandoffInError());
        Assert.assertEquals((Object)handoffSensorValue, (Object)item_.isHandoffSensorValue());
        Assert.assertEquals((Object)onlineInError, (Object)item_.isOnlineInError());
        Assert.assertEquals((Object)onlineSensorValue, (Object)item_.isOnlineSensorValue());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((Object)standbyInError, (Object)item_.isStandbyInError());
        Assert.assertEquals((Object)standbySensorValue, (Object)item_.isStandbySensorValue());
    }

    @Test
    public void sendReceiveFcs_AcTruckXminusControllerTelemetry() throws Exception {
        boolean booted = false;
        boolean brakeActivated = false;
        boolean controllerWithBrake = true;
        int current = 823;
        int errorHistoryNB = 993;
        String errorRegister = "";
        boolean inError = true;
        boolean initialized = true;
        int lastErrorCode = 887;
        String lastErrorName = "";
        String mode = "";
        int position = 593;
        String state = "t";
        int velocity = 59;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_AcTruckXminusControllerTelemetry(booted, brakeActivated, controllerWithBrake, current, errorHistoryNB, errorRegister, inError, initialized, lastErrorCode, lastErrorName, mode, position, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_AcTruckXminusControllerTelemetry));
        Fcs_AcTruckXminusControllerTelemetry item_ = (Fcs_AcTruckXminusControllerTelemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((Object)controllerWithBrake, (Object)item_.isControllerWithBrake());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_AcTruckXplusTelemetry() throws Exception {
        int averageCurrent = 92;
        int followingError = 706;
        boolean handoffInError = true;
        boolean handoffSensorValue = false;
        boolean onlineInError = true;
        boolean onlineSensorValue = false;
        int position = 235;
        boolean standbyInError = false;
        boolean standbySensorValue = true;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_AcTruckXplusTelemetry(averageCurrent, followingError, handoffInError, handoffSensorValue, onlineInError, onlineSensorValue, position, standbyInError, standbySensorValue));
        Assert.assertTrue((boolean)(item instanceof Fcs_AcTruckXplusTelemetry));
        Fcs_AcTruckXplusTelemetry item_ = (Fcs_AcTruckXplusTelemetry)item;
        Assert.assertEquals((long)averageCurrent, (long)item_.getAverageCurrent());
        Assert.assertEquals((long)followingError, (long)item_.getFollowingError());
        Assert.assertEquals((Object)handoffInError, (Object)item_.isHandoffInError());
        Assert.assertEquals((Object)handoffSensorValue, (Object)item_.isHandoffSensorValue());
        Assert.assertEquals((Object)onlineInError, (Object)item_.isOnlineInError());
        Assert.assertEquals((Object)onlineSensorValue, (Object)item_.isOnlineSensorValue());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((Object)standbyInError, (Object)item_.isStandbyInError());
        Assert.assertEquals((Object)standbySensorValue, (Object)item_.isStandbySensorValue());
    }

    @Test
    public void sendReceiveFcs_AcTruckXplusControllerTelemetry() throws Exception {
        boolean booted = true;
        boolean brakeActivated = true;
        boolean controllerWithBrake = true;
        int current = 434;
        int errorHistoryNB = 401;
        String errorRegister = "";
        boolean inError = false;
        boolean initialized = true;
        int lastErrorCode = 769;
        String lastErrorName = "o";
        String mode = "";
        int position = 339;
        String state = "e";
        int velocity = 604;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_AcTruckXplusControllerTelemetry(booted, brakeActivated, controllerWithBrake, current, errorHistoryNB, errorRegister, inError, initialized, lastErrorCode, lastErrorName, mode, position, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_AcTruckXplusControllerTelemetry));
        Fcs_AcTruckXplusControllerTelemetry item_ = (Fcs_AcTruckXplusControllerTelemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((Object)controllerWithBrake, (Object)item_.isControllerWithBrake());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_AccelerobfTelemetry() throws Exception {
        double accelerationX = 0.32916945219039917;
        double accelerationY = 0.34762293100357056;
        double accelerationZ = 0.24578464031219482;
        double angularVelocityX = 0.9531963467597961;
        double angularVelocityY = 0.724480926990509;
        double angularVelocityZ = 0.5882585644721985;
        boolean booted = true;
        int errorHistoryNB = 14;
        String errorRegister = "l";
        boolean inError = true;
        boolean initialized = false;
        int lastErrorCode = 674;
        String lastErrorName = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_AccelerobfTelemetry(accelerationX, accelerationY, accelerationZ, angularVelocityX, angularVelocityY, angularVelocityZ, booted, errorHistoryNB, errorRegister, inError, initialized, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_AccelerobfTelemetry));
        Fcs_AccelerobfTelemetry item_ = (Fcs_AccelerobfTelemetry)item;
        Assert.assertEquals((double)accelerationX, (double)item_.getAccelerationX(), (double)1.0E-6f);
        Assert.assertEquals((double)accelerationY, (double)item_.getAccelerationY(), (double)1.0E-6f);
        Assert.assertEquals((double)accelerationZ, (double)item_.getAccelerationZ(), (double)1.0E-6f);
        Assert.assertEquals((double)angularVelocityX, (double)item_.getAngularVelocityX(), (double)1.0E-6f);
        Assert.assertEquals((double)angularVelocityY, (double)item_.getAngularVelocityY(), (double)1.0E-6f);
        Assert.assertEquals((double)angularVelocityZ, (double)item_.getAngularVelocityZ(), (double)1.0E-6f);
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Ai814Telemetry() throws Exception {
        boolean booted = true;
        int errorHistoryNB = 889;
        String errorRegister = "q";
        boolean inError = true;
        boolean initialized = true;
        int lastErrorCode = 969;
        String lastErrorName = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Ai814Telemetry(booted, errorHistoryNB, errorRegister, inError, initialized, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Ai814Telemetry));
        Fcs_Ai814Telemetry item_ = (Fcs_Ai814Telemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_AutochangerTelemetry() throws Exception {
        boolean carouselHoldingFilter = false;
        boolean carouselHoldingFilterInError = true;
        boolean carousel_CF0 = false;
        boolean carousel_CF0_InError = false;
        boolean carousel_CF1 = false;
        boolean carousel_CF1_InError = false;
        boolean carousel_CS = false;
        boolean carousel_CS_InError = true;
        boolean enableClamps = false;
        boolean enableLatches = false;
        boolean enableRailLin1 = true;
        boolean enableRailLin2 = false;
        boolean engineeringKey = true;
        boolean engineeringkey_InError = true;
        double inclinaisonXminus = 0.8710257411003113;
        double inclinaisonXplus = 0.8896157741546631;
        boolean loaderConnectedSensorValue = true;
        boolean loaderConnectedSensorsInError = true;
        boolean loaderPresence = false;
        boolean loaderPresenceInError = true;
        boolean loader_LRH = false;
        boolean loader_LRH_InError = true;
        boolean lockOut = true;
        boolean lockOutInError = false;
        boolean lockOutShunt = true;
        boolean out_AF0 = false;
        boolean out_AF0_InError = false;
        boolean out_AF1 = true;
        boolean out_AF1_InError = true;
        boolean out_AF3 = true;
        boolean out_AF3_InError = false;
        boolean out_AIN = false;
        boolean out_AOL = false;
        boolean out_AP1 = false;
        boolean out_AP1_InError = false;
        boolean out_AP2 = true;
        boolean out_AP2_InError = false;
        boolean out_AP3 = false;
        boolean out_AP3_InError = false;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_AutochangerTelemetry(carouselHoldingFilter, carouselHoldingFilterInError, carousel_CF0, carousel_CF0_InError, carousel_CF1, carousel_CF1_InError, carousel_CS, carousel_CS_InError, enableClamps, enableLatches, enableRailLin1, enableRailLin2, engineeringKey, engineeringkey_InError, inclinaisonXminus, inclinaisonXplus, loaderConnectedSensorValue, loaderConnectedSensorsInError, loaderPresence, loaderPresenceInError, loader_LRH, loader_LRH_InError, lockOut, lockOutInError, lockOutShunt, out_AF0, out_AF0_InError, out_AF1, out_AF1_InError, out_AF3, out_AF3_InError, out_AIN, out_AOL, out_AP1, out_AP1_InError, out_AP2, out_AP2_InError, out_AP3, out_AP3_InError));
        Assert.assertTrue((boolean)(item instanceof Fcs_AutochangerTelemetry));
        Fcs_AutochangerTelemetry item_ = (Fcs_AutochangerTelemetry)item;
        Assert.assertEquals((Object)carouselHoldingFilter, (Object)item_.isCarouselHoldingFilter());
        Assert.assertEquals((Object)carouselHoldingFilterInError, (Object)item_.isCarouselHoldingFilterInError());
        Assert.assertEquals((Object)carousel_CF0, (Object)item_.isCarousel_CF0());
        Assert.assertEquals((Object)carousel_CF0_InError, (Object)item_.isCarousel_CF0_InError());
        Assert.assertEquals((Object)carousel_CF1, (Object)item_.isCarousel_CF1());
        Assert.assertEquals((Object)carousel_CF1_InError, (Object)item_.isCarousel_CF1_InError());
        Assert.assertEquals((Object)carousel_CS, (Object)item_.isCarousel_CS());
        Assert.assertEquals((Object)carousel_CS_InError, (Object)item_.isCarousel_CS_InError());
        Assert.assertEquals((Object)enableClamps, (Object)item_.isEnableClamps());
        Assert.assertEquals((Object)enableLatches, (Object)item_.isEnableLatches());
        Assert.assertEquals((Object)enableRailLin1, (Object)item_.isEnableRailLin1());
        Assert.assertEquals((Object)enableRailLin2, (Object)item_.isEnableRailLin2());
        Assert.assertEquals((Object)engineeringKey, (Object)item_.isEngineeringKey());
        Assert.assertEquals((Object)engineeringkey_InError, (Object)item_.isEngineeringkey_InError());
        Assert.assertEquals((double)inclinaisonXminus, (double)item_.getInclinaisonXminus(), (double)1.0E-6f);
        Assert.assertEquals((double)inclinaisonXplus, (double)item_.getInclinaisonXplus(), (double)1.0E-6f);
        Assert.assertEquals((Object)loaderConnectedSensorValue, (Object)item_.isLoaderConnectedSensorValue());
        Assert.assertEquals((Object)loaderConnectedSensorsInError, (Object)item_.isLoaderConnectedSensorsInError());
        Assert.assertEquals((Object)loaderPresence, (Object)item_.isLoaderPresence());
        Assert.assertEquals((Object)loaderPresenceInError, (Object)item_.isLoaderPresenceInError());
        Assert.assertEquals((Object)loader_LRH, (Object)item_.isLoader_LRH());
        Assert.assertEquals((Object)loader_LRH_InError, (Object)item_.isLoader_LRH_InError());
        Assert.assertEquals((Object)lockOut, (Object)item_.isLockOut());
        Assert.assertEquals((Object)lockOutInError, (Object)item_.isLockOutInError());
        Assert.assertEquals((Object)lockOutShunt, (Object)item_.isLockOutShunt());
        Assert.assertEquals((Object)out_AF0, (Object)item_.isOut_AF0());
        Assert.assertEquals((Object)out_AF0_InError, (Object)item_.isOut_AF0_InError());
        Assert.assertEquals((Object)out_AF1, (Object)item_.isOut_AF1());
        Assert.assertEquals((Object)out_AF1_InError, (Object)item_.isOut_AF1_InError());
        Assert.assertEquals((Object)out_AF3, (Object)item_.isOut_AF3());
        Assert.assertEquals((Object)out_AF3_InError, (Object)item_.isOut_AF3_InError());
        Assert.assertEquals((Object)out_AIN, (Object)item_.isOut_AIN());
        Assert.assertEquals((Object)out_AOL, (Object)item_.isOut_AOL());
        Assert.assertEquals((Object)out_AP1, (Object)item_.isOut_AP1());
        Assert.assertEquals((Object)out_AP1_InError, (Object)item_.isOut_AP1_InError());
        Assert.assertEquals((Object)out_AP2, (Object)item_.isOut_AP2());
        Assert.assertEquals((Object)out_AP2_InError, (Object)item_.isOut_AP2_InError());
        Assert.assertEquals((Object)out_AP3, (Object)item_.isOut_AP3());
        Assert.assertEquals((Object)out_AP3_InError, (Object)item_.isOut_AP3_InError());
    }

    @Test
    public void sendReceiveFcs_AutochangerTrucksTelemetry() throws Exception {
        boolean atHandoff = false;
        boolean atOnline = true;
        boolean atStandby = false;
        boolean homingDone = true;
        boolean inError = false;
        int masterPosition = 314;
        int slavePosition = 419;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_AutochangerTrucksTelemetry(atHandoff, atOnline, atStandby, homingDone, inError, masterPosition, slavePosition));
        Assert.assertTrue((boolean)(item instanceof Fcs_AutochangerTrucksTelemetry));
        Fcs_AutochangerTrucksTelemetry item_ = (Fcs_AutochangerTrucksTelemetry)item;
        Assert.assertEquals((Object)atHandoff, (Object)item_.isAtHandoff());
        Assert.assertEquals((Object)atOnline, (Object)item_.isAtOnline());
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)homingDone, (Object)item_.isHomingDone());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((long)masterPosition, (long)item_.getMasterPosition());
        Assert.assertEquals((long)slavePosition, (long)item_.getSlavePosition());
    }

    @Test
    public void sendReceiveFcs_BrakeSystemGatewayTelemetry() throws Exception {
        boolean booted = false;
        boolean initialized = false;
        int intValues = 728;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_BrakeSystemGatewayTelemetry(booted, initialized, intValues));
        Assert.assertTrue((boolean)(item instanceof Fcs_BrakeSystemGatewayTelemetry));
        Fcs_BrakeSystemGatewayTelemetry item_ = (Fcs_BrakeSystemGatewayTelemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)intValues, (long)item_.getIntValues());
    }

    @Test
    public void sendReceiveFcs_CarouselTelemetry() throws Exception {
        boolean af3 = false;
        boolean af3_InError = false;
        boolean ap1 = true;
        boolean ap1_InError = true;
        boolean ap2 = false;
        boolean ap2_InError = false;
        boolean ap3 = true;
        boolean ap3_InError = false;
        boolean atStandby = true;
        String brakeState1 = "";
        String brakeState2 = "e";
        String brakeState3 = "";
        boolean brakesActivated = false;
        boolean caEng = true;
        boolean caeng_InError = true;
        boolean caLockout = true;
        boolean calockout_InError = false;
        String clampsStateAtStandby = "";
        double current = 0.22203278541564941;
        int deltaPositionAtStandby = 949;
        boolean emptyAtStandby = false;
        boolean enableBrakes = true;
        boolean enableRotation = false;
        boolean enableShutter = true;
        boolean enableUnclamp = true;
        int estimatedPosition = 321;
        String filterAtStandbyName = "";
        String filterOnAutochangerName = "";
        boolean locked = false;
        long minLocked = 19L;
        boolean moving = true;
        boolean out_CF0 = true;
        boolean out_CF0_InError = true;
        boolean out_CF1 = false;
        boolean out_CF1_InError = true;
        boolean out_CFC = false;
        boolean out_CFC_InError = false;
        boolean out_CS = false;
        boolean out_CS_InError = false;
        int position = 86;
        int positionSensorType = 582;
        long profileAcceleration = 747L;
        long profileDeceleration = 863L;
        long profileVelocity = 931L;
        long rotationTimeout = 893L;
        long sensor1 = 618L;
        long sensor2 = 643L;
        long sensor3 = 538L;
        boolean shutterInactive = false;
        String slaveStatusAtStandby = "";
        boolean sleep = false;
        int socketAtStandbyID = 718;
        String socketAtStandbyName = "p";
        double temperature1 = 0.9611856937408447;
        double temperature2 = 0.3297159671783447;
        double temperature3 = 0.599407970905304;
        double temperature4 = 0.3071601390838623;
        boolean tpCheckRotation = true;
        boolean tpStopRotation = true;
        boolean tpStopUnclamp = true;
        boolean tp_InError = true;
        double velocity = 0.01659691333770752;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_CarouselTelemetry(af3, af3_InError, ap1, ap1_InError, ap2, ap2_InError, ap3, ap3_InError, atStandby, brakeState1, brakeState2, brakeState3, brakesActivated, caEng, caeng_InError, caLockout, calockout_InError, clampsStateAtStandby, current, deltaPositionAtStandby, emptyAtStandby, enableBrakes, enableRotation, enableShutter, enableUnclamp, estimatedPosition, filterAtStandbyName, filterOnAutochangerName, locked, minLocked, moving, out_CF0, out_CF0_InError, out_CF1, out_CF1_InError, out_CFC, out_CFC_InError, out_CS, out_CS_InError, position, positionSensorType, profileAcceleration, profileDeceleration, profileVelocity, rotationTimeout, sensor1, sensor2, sensor3, shutterInactive, slaveStatusAtStandby, sleep, socketAtStandbyID, socketAtStandbyName, temperature1, temperature2, temperature3, temperature4, tpCheckRotation, tpStopRotation, tpStopUnclamp, tp_InError, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_CarouselTelemetry));
        Fcs_CarouselTelemetry item_ = (Fcs_CarouselTelemetry)item;
        Assert.assertEquals((Object)af3, (Object)item_.isAf3());
        Assert.assertEquals((Object)af3_InError, (Object)item_.isAf3_InError());
        Assert.assertEquals((Object)ap1, (Object)item_.isAp1());
        Assert.assertEquals((Object)ap1_InError, (Object)item_.isAp1_InError());
        Assert.assertEquals((Object)ap2, (Object)item_.isAp2());
        Assert.assertEquals((Object)ap2_InError, (Object)item_.isAp2_InError());
        Assert.assertEquals((Object)ap3, (Object)item_.isAp3());
        Assert.assertEquals((Object)ap3_InError, (Object)item_.isAp3_InError());
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)brakeState1, (Object)item_.getBrakeState1());
        Assert.assertEquals((Object)brakeState2, (Object)item_.getBrakeState2());
        Assert.assertEquals((Object)brakeState3, (Object)item_.getBrakeState3());
        Assert.assertEquals((Object)brakesActivated, (Object)item_.isBrakesActivated());
        Assert.assertEquals((Object)caEng, (Object)item_.isCaEng());
        Assert.assertEquals((Object)caeng_InError, (Object)item_.isCaeng_InError());
        Assert.assertEquals((Object)caLockout, (Object)item_.isCaLockout());
        Assert.assertEquals((Object)calockout_InError, (Object)item_.isCalockout_InError());
        Assert.assertEquals((Object)clampsStateAtStandby, (Object)item_.getClampsStateAtStandby());
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((long)deltaPositionAtStandby, (long)item_.getDeltaPositionAtStandby());
        Assert.assertEquals((Object)emptyAtStandby, (Object)item_.isEmptyAtStandby());
        Assert.assertEquals((Object)enableBrakes, (Object)item_.isEnableBrakes());
        Assert.assertEquals((Object)enableRotation, (Object)item_.isEnableRotation());
        Assert.assertEquals((Object)enableShutter, (Object)item_.isEnableShutter());
        Assert.assertEquals((Object)enableUnclamp, (Object)item_.isEnableUnclamp());
        Assert.assertEquals((long)estimatedPosition, (long)item_.getEstimatedPosition());
        Assert.assertEquals((Object)filterAtStandbyName, (Object)item_.getFilterAtStandbyName());
        Assert.assertEquals((Object)filterOnAutochangerName, (Object)item_.getFilterOnAutochangerName());
        Assert.assertEquals((Object)locked, (Object)item_.isLocked());
        Assert.assertEquals((long)minLocked, (long)item_.getMinLocked());
        Assert.assertEquals((Object)moving, (Object)item_.isMoving());
        Assert.assertEquals((Object)out_CF0, (Object)item_.isOut_CF0());
        Assert.assertEquals((Object)out_CF0_InError, (Object)item_.isOut_CF0_InError());
        Assert.assertEquals((Object)out_CF1, (Object)item_.isOut_CF1());
        Assert.assertEquals((Object)out_CF1_InError, (Object)item_.isOut_CF1_InError());
        Assert.assertEquals((Object)out_CFC, (Object)item_.isOut_CFC());
        Assert.assertEquals((Object)out_CFC_InError, (Object)item_.isOut_CFC_InError());
        Assert.assertEquals((Object)out_CS, (Object)item_.isOut_CS());
        Assert.assertEquals((Object)out_CS_InError, (Object)item_.isOut_CS_InError());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)positionSensorType, (long)item_.getPositionSensorType());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((long)rotationTimeout, (long)item_.getRotationTimeout());
        Assert.assertEquals((long)sensor1, (long)item_.getSensor1());
        Assert.assertEquals((long)sensor2, (long)item_.getSensor2());
        Assert.assertEquals((long)sensor3, (long)item_.getSensor3());
        Assert.assertEquals((Object)shutterInactive, (Object)item_.isShutterInactive());
        Assert.assertEquals((Object)slaveStatusAtStandby, (Object)item_.getSlaveStatusAtStandby());
        Assert.assertEquals((Object)sleep, (Object)item_.isSleep());
        Assert.assertEquals((long)socketAtStandbyID, (long)item_.getSocketAtStandbyID());
        Assert.assertEquals((Object)socketAtStandbyName, (Object)item_.getSocketAtStandbyName());
        Assert.assertEquals((double)temperature1, (double)item_.getTemperature1(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature2, (double)item_.getTemperature2(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature3, (double)item_.getTemperature3(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature4, (double)item_.getTemperature4(), (double)1.0E-6f);
        Assert.assertEquals((Object)tpCheckRotation, (Object)item_.isTpCheckRotation());
        Assert.assertEquals((Object)tpStopRotation, (Object)item_.isTpStopRotation());
        Assert.assertEquals((Object)tpStopUnclamp, (Object)item_.isTpStopUnclamp());
        Assert.assertEquals((Object)tp_InError, (Object)item_.isTp_InError());
        Assert.assertEquals((double)velocity, (double)item_.getVelocity(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_CarouselControllerTelemetry() throws Exception {
        boolean booted = true;
        boolean brakeActivated = true;
        boolean controllerWithBrake = false;
        int current = 151;
        int errorHistoryNB = 114;
        String errorRegister = "b";
        boolean inError = true;
        boolean initialized = false;
        int lastErrorCode = 732;
        String lastErrorName = "";
        String mode = "";
        int position = 696;
        String state = "";
        int velocity = 655;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_CarouselControllerTelemetry(booted, brakeActivated, controllerWithBrake, current, errorHistoryNB, errorRegister, inError, initialized, lastErrorCode, lastErrorName, mode, position, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_CarouselControllerTelemetry));
        Fcs_CarouselControllerTelemetry item_ = (Fcs_CarouselControllerTelemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((Object)controllerWithBrake, (Object)item_.isControllerWithBrake());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_CarrierTelemetry() throws Exception {
        boolean atEngaged = false;
        boolean atHandoff = false;
        boolean atStorage = true;
        boolean controllerInError = true;
        int current = 318;
        boolean engagedSensorOn = true;
        boolean homingDone = false;
        boolean limitSwitchDownInError = true;
        boolean limitSwitchUpInError = true;
        int position = 18;
        long profileAcceleration = 854L;
        long profileDeceleration = 32L;
        long profileVelocity = 341L;
        int speed = 483;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_CarrierTelemetry(atEngaged, atHandoff, atStorage, controllerInError, current, engagedSensorOn, homingDone, limitSwitchDownInError, limitSwitchUpInError, position, profileAcceleration, profileDeceleration, profileVelocity, speed));
        Assert.assertTrue((boolean)(item instanceof Fcs_CarrierTelemetry));
        Fcs_CarrierTelemetry item_ = (Fcs_CarrierTelemetry)item;
        Assert.assertEquals((Object)atEngaged, (Object)item_.isAtEngaged());
        Assert.assertEquals((Object)atHandoff, (Object)item_.isAtHandoff());
        Assert.assertEquals((Object)atStorage, (Object)item_.isAtStorage());
        Assert.assertEquals((Object)controllerInError, (Object)item_.isControllerInError());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((Object)engagedSensorOn, (Object)item_.isEngagedSensorOn());
        Assert.assertEquals((Object)homingDone, (Object)item_.isHomingDone());
        Assert.assertEquals((Object)limitSwitchDownInError, (Object)item_.isLimitSwitchDownInError());
        Assert.assertEquals((Object)limitSwitchUpInError, (Object)item_.isLimitSwitchUpInError());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)profileAcceleration, (long)item_.getProfileAcceleration());
        Assert.assertEquals((long)profileDeceleration, (long)item_.getProfileDeceleration());
        Assert.assertEquals((long)profileVelocity, (long)item_.getProfileVelocity());
        Assert.assertEquals((long)speed, (long)item_.getSpeed());
    }

    @Test
    public void sendReceiveFcs_CarrierControllerTelemetry() throws Exception {
        boolean booted = true;
        boolean brakeActivated = false;
        boolean controllerWithBrake = false;
        int current = 117;
        int errorHistoryNB = 987;
        String errorRegister = "l";
        boolean inError = true;
        boolean initialized = true;
        int lastErrorCode = 408;
        String lastErrorName = "s";
        String mode = "";
        int position = 84;
        String state = "";
        int velocity = 556;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_CarrierControllerTelemetry(booted, brakeActivated, controllerWithBrake, current, errorHistoryNB, errorRegister, inError, initialized, lastErrorCode, lastErrorName, mode, position, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_CarrierControllerTelemetry));
        Fcs_CarrierControllerTelemetry item_ = (Fcs_CarrierControllerTelemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((Object)controllerWithBrake, (Object)item_.isControllerWithBrake());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_CcsVersionsTelemetry() throws Exception {
        String agent_version = "n";
        String distribution_version = "e";
        String toolkit_version = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_CcsVersionsTelemetry(agent_version, distribution_version, toolkit_version));
        Assert.assertTrue((boolean)(item instanceof Fcs_CcsVersionsTelemetry));
        Fcs_CcsVersionsTelemetry item_ = (Fcs_CcsVersionsTelemetry)item;
        Assert.assertEquals((Object)agent_version, (Object)item_.getAgent_version());
        Assert.assertEquals((Object)distribution_version, (Object)item_.getDistribution_version());
        Assert.assertEquals((Object)toolkit_version, (Object)item_.getToolkit_version());
    }

    @Test
    public void sendReceiveFcs_ClampXminus1Telemetry() throws Exception {
        String clampState = "k";
        int filterPositionSensorValue = 959;
        int filterPresenceMinNoFilter = 622;
        int filterPresenceOffset2 = 671;
        String filterPresenceStatus = "q";
        int lockSensorOffset1 = 107;
        int lockSensorValue = 957;
        String lockStatus = "i";
        double temperature = 0.9458901286125183;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_ClampXminus1Telemetry(clampState, filterPositionSensorValue, filterPresenceMinNoFilter, filterPresenceOffset2, filterPresenceStatus, lockSensorOffset1, lockSensorValue, lockStatus, temperature));
        Assert.assertTrue((boolean)(item instanceof Fcs_ClampXminus1Telemetry));
        Fcs_ClampXminus1Telemetry item_ = (Fcs_ClampXminus1Telemetry)item;
        Assert.assertEquals((Object)clampState, (Object)item_.getClampState());
        Assert.assertEquals((long)filterPositionSensorValue, (long)item_.getFilterPositionSensorValue());
        Assert.assertEquals((long)filterPresenceMinNoFilter, (long)item_.getFilterPresenceMinNoFilter());
        Assert.assertEquals((long)filterPresenceOffset2, (long)item_.getFilterPresenceOffset2());
        Assert.assertEquals((Object)filterPresenceStatus, (Object)item_.getFilterPresenceStatus());
        Assert.assertEquals((long)lockSensorOffset1, (long)item_.getLockSensorOffset1());
        Assert.assertEquals((long)lockSensorValue, (long)item_.getLockSensorValue());
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_ClampXminus2Telemetry() throws Exception {
        String clampState = "v";
        int filterPositionSensorValue = 392;
        int filterPresenceMinNoFilter = 903;
        int filterPresenceOffset2 = 879;
        String filterPresenceStatus = "";
        int lockSensorOffset1 = 372;
        int lockSensorValue = 488;
        String lockStatus = "";
        double temperature = 0.6369833946228027;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_ClampXminus2Telemetry(clampState, filterPositionSensorValue, filterPresenceMinNoFilter, filterPresenceOffset2, filterPresenceStatus, lockSensorOffset1, lockSensorValue, lockStatus, temperature));
        Assert.assertTrue((boolean)(item instanceof Fcs_ClampXminus2Telemetry));
        Fcs_ClampXminus2Telemetry item_ = (Fcs_ClampXminus2Telemetry)item;
        Assert.assertEquals((Object)clampState, (Object)item_.getClampState());
        Assert.assertEquals((long)filterPositionSensorValue, (long)item_.getFilterPositionSensorValue());
        Assert.assertEquals((long)filterPresenceMinNoFilter, (long)item_.getFilterPresenceMinNoFilter());
        Assert.assertEquals((long)filterPresenceOffset2, (long)item_.getFilterPresenceOffset2());
        Assert.assertEquals((Object)filterPresenceStatus, (Object)item_.getFilterPresenceStatus());
        Assert.assertEquals((long)lockSensorOffset1, (long)item_.getLockSensorOffset1());
        Assert.assertEquals((long)lockSensorValue, (long)item_.getLockSensorValue());
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_ClampXminus3Telemetry() throws Exception {
        String clampState = "m";
        int filterPositionSensorValue = 566;
        int filterPresenceMinNoFilter = 287;
        int filterPresenceOffset2 = 707;
        String filterPresenceStatus = "";
        int lockSensorOffset1 = 674;
        int lockSensorValue = 460;
        String lockStatus = "k";
        double temperature = 0.2451612949371338;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_ClampXminus3Telemetry(clampState, filterPositionSensorValue, filterPresenceMinNoFilter, filterPresenceOffset2, filterPresenceStatus, lockSensorOffset1, lockSensorValue, lockStatus, temperature));
        Assert.assertTrue((boolean)(item instanceof Fcs_ClampXminus3Telemetry));
        Fcs_ClampXminus3Telemetry item_ = (Fcs_ClampXminus3Telemetry)item;
        Assert.assertEquals((Object)clampState, (Object)item_.getClampState());
        Assert.assertEquals((long)filterPositionSensorValue, (long)item_.getFilterPositionSensorValue());
        Assert.assertEquals((long)filterPresenceMinNoFilter, (long)item_.getFilterPresenceMinNoFilter());
        Assert.assertEquals((long)filterPresenceOffset2, (long)item_.getFilterPresenceOffset2());
        Assert.assertEquals((Object)filterPresenceStatus, (Object)item_.getFilterPresenceStatus());
        Assert.assertEquals((long)lockSensorOffset1, (long)item_.getLockSensorOffset1());
        Assert.assertEquals((long)lockSensorValue, (long)item_.getLockSensorValue());
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_ClampXminus4Telemetry() throws Exception {
        String clampState = "";
        int filterPositionSensorValue = 607;
        int filterPresenceMinNoFilter = 644;
        int filterPresenceOffset2 = 545;
        String filterPresenceStatus = "t";
        int lockSensorOffset1 = 695;
        int lockSensorValue = 707;
        String lockStatus = "";
        double temperature = 0.9905713796615601;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_ClampXminus4Telemetry(clampState, filterPositionSensorValue, filterPresenceMinNoFilter, filterPresenceOffset2, filterPresenceStatus, lockSensorOffset1, lockSensorValue, lockStatus, temperature));
        Assert.assertTrue((boolean)(item instanceof Fcs_ClampXminus4Telemetry));
        Fcs_ClampXminus4Telemetry item_ = (Fcs_ClampXminus4Telemetry)item;
        Assert.assertEquals((Object)clampState, (Object)item_.getClampState());
        Assert.assertEquals((long)filterPositionSensorValue, (long)item_.getFilterPositionSensorValue());
        Assert.assertEquals((long)filterPresenceMinNoFilter, (long)item_.getFilterPresenceMinNoFilter());
        Assert.assertEquals((long)filterPresenceOffset2, (long)item_.getFilterPresenceOffset2());
        Assert.assertEquals((Object)filterPresenceStatus, (Object)item_.getFilterPresenceStatus());
        Assert.assertEquals((long)lockSensorOffset1, (long)item_.getLockSensorOffset1());
        Assert.assertEquals((long)lockSensorValue, (long)item_.getLockSensorValue());
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_ClampXminus5Telemetry() throws Exception {
        String clampState = "k";
        int filterPositionSensorValue = 166;
        int filterPresenceMinNoFilter = 460;
        int filterPresenceOffset2 = 647;
        String filterPresenceStatus = "";
        int lockSensorOffset1 = 590;
        int lockSensorValue = 898;
        String lockStatus = "";
        double temperature = 0.5629045367240906;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_ClampXminus5Telemetry(clampState, filterPositionSensorValue, filterPresenceMinNoFilter, filterPresenceOffset2, filterPresenceStatus, lockSensorOffset1, lockSensorValue, lockStatus, temperature));
        Assert.assertTrue((boolean)(item instanceof Fcs_ClampXminus5Telemetry));
        Fcs_ClampXminus5Telemetry item_ = (Fcs_ClampXminus5Telemetry)item;
        Assert.assertEquals((Object)clampState, (Object)item_.getClampState());
        Assert.assertEquals((long)filterPositionSensorValue, (long)item_.getFilterPositionSensorValue());
        Assert.assertEquals((long)filterPresenceMinNoFilter, (long)item_.getFilterPresenceMinNoFilter());
        Assert.assertEquals((long)filterPresenceOffset2, (long)item_.getFilterPresenceOffset2());
        Assert.assertEquals((Object)filterPresenceStatus, (Object)item_.getFilterPresenceStatus());
        Assert.assertEquals((long)lockSensorOffset1, (long)item_.getLockSensorOffset1());
        Assert.assertEquals((long)lockSensorValue, (long)item_.getLockSensorValue());
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_ClampXminusControllerTelemetry() throws Exception {
        boolean booted = true;
        boolean brakeActivated = false;
        boolean controllerWithBrake = true;
        int current = 298;
        int errorHistoryNB = 644;
        String errorRegister = "";
        boolean inError = false;
        boolean initialized = true;
        int lastErrorCode = 292;
        String lastErrorName = "b";
        String mode = "t";
        int position = 566;
        String state = "";
        int velocity = 912;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_ClampXminusControllerTelemetry(booted, brakeActivated, controllerWithBrake, current, errorHistoryNB, errorRegister, inError, initialized, lastErrorCode, lastErrorName, mode, position, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_ClampXminusControllerTelemetry));
        Fcs_ClampXminusControllerTelemetry item_ = (Fcs_ClampXminusControllerTelemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((Object)controllerWithBrake, (Object)item_.isControllerWithBrake());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_ClampXplus1Telemetry() throws Exception {
        String clampState = "s";
        int filterPositionSensorValue = 528;
        int filterPresenceMinNoFilter = 990;
        int filterPresenceOffset2 = 73;
        String filterPresenceStatus = "";
        int lockSensorOffset1 = 842;
        int lockSensorValue = 514;
        String lockStatus = "";
        double temperature = 0.553010106086731;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_ClampXplus1Telemetry(clampState, filterPositionSensorValue, filterPresenceMinNoFilter, filterPresenceOffset2, filterPresenceStatus, lockSensorOffset1, lockSensorValue, lockStatus, temperature));
        Assert.assertTrue((boolean)(item instanceof Fcs_ClampXplus1Telemetry));
        Fcs_ClampXplus1Telemetry item_ = (Fcs_ClampXplus1Telemetry)item;
        Assert.assertEquals((Object)clampState, (Object)item_.getClampState());
        Assert.assertEquals((long)filterPositionSensorValue, (long)item_.getFilterPositionSensorValue());
        Assert.assertEquals((long)filterPresenceMinNoFilter, (long)item_.getFilterPresenceMinNoFilter());
        Assert.assertEquals((long)filterPresenceOffset2, (long)item_.getFilterPresenceOffset2());
        Assert.assertEquals((Object)filterPresenceStatus, (Object)item_.getFilterPresenceStatus());
        Assert.assertEquals((long)lockSensorOffset1, (long)item_.getLockSensorOffset1());
        Assert.assertEquals((long)lockSensorValue, (long)item_.getLockSensorValue());
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_ClampXplus2Telemetry() throws Exception {
        String clampState = "b";
        int filterPositionSensorValue = 878;
        int filterPresenceMinNoFilter = 666;
        int filterPresenceOffset2 = 621;
        String filterPresenceStatus = "";
        int lockSensorOffset1 = 895;
        int lockSensorValue = 538;
        String lockStatus = "v";
        double temperature = 0.940437f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_ClampXplus2Telemetry(clampState, filterPositionSensorValue, filterPresenceMinNoFilter, filterPresenceOffset2, filterPresenceStatus, lockSensorOffset1, lockSensorValue, lockStatus, temperature));
        Assert.assertTrue((boolean)(item instanceof Fcs_ClampXplus2Telemetry));
        Fcs_ClampXplus2Telemetry item_ = (Fcs_ClampXplus2Telemetry)item;
        Assert.assertEquals((Object)clampState, (Object)item_.getClampState());
        Assert.assertEquals((long)filterPositionSensorValue, (long)item_.getFilterPositionSensorValue());
        Assert.assertEquals((long)filterPresenceMinNoFilter, (long)item_.getFilterPresenceMinNoFilter());
        Assert.assertEquals((long)filterPresenceOffset2, (long)item_.getFilterPresenceOffset2());
        Assert.assertEquals((Object)filterPresenceStatus, (Object)item_.getFilterPresenceStatus());
        Assert.assertEquals((long)lockSensorOffset1, (long)item_.getLockSensorOffset1());
        Assert.assertEquals((long)lockSensorValue, (long)item_.getLockSensorValue());
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_ClampXplus3Telemetry() throws Exception {
        String clampState = "i";
        int filterPositionSensorValue = 723;
        int filterPresenceMinNoFilter = 304;
        int filterPresenceOffset2 = 1;
        String filterPresenceStatus = "q";
        int lockSensorOffset1 = 521;
        int lockSensorValue = 256;
        String lockStatus = "e";
        double temperature = 0.6163363456726074;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_ClampXplus3Telemetry(clampState, filterPositionSensorValue, filterPresenceMinNoFilter, filterPresenceOffset2, filterPresenceStatus, lockSensorOffset1, lockSensorValue, lockStatus, temperature));
        Assert.assertTrue((boolean)(item instanceof Fcs_ClampXplus3Telemetry));
        Fcs_ClampXplus3Telemetry item_ = (Fcs_ClampXplus3Telemetry)item;
        Assert.assertEquals((Object)clampState, (Object)item_.getClampState());
        Assert.assertEquals((long)filterPositionSensorValue, (long)item_.getFilterPositionSensorValue());
        Assert.assertEquals((long)filterPresenceMinNoFilter, (long)item_.getFilterPresenceMinNoFilter());
        Assert.assertEquals((long)filterPresenceOffset2, (long)item_.getFilterPresenceOffset2());
        Assert.assertEquals((Object)filterPresenceStatus, (Object)item_.getFilterPresenceStatus());
        Assert.assertEquals((long)lockSensorOffset1, (long)item_.getLockSensorOffset1());
        Assert.assertEquals((long)lockSensorValue, (long)item_.getLockSensorValue());
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_ClampXplus4Telemetry() throws Exception {
        String clampState = "";
        int filterPositionSensorValue = 401;
        int filterPresenceMinNoFilter = 466;
        int filterPresenceOffset2 = 930;
        String filterPresenceStatus = "";
        int lockSensorOffset1 = 199;
        int lockSensorValue = 444;
        String lockStatus = "k";
        double temperature = 0.3930498957633972;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_ClampXplus4Telemetry(clampState, filterPositionSensorValue, filterPresenceMinNoFilter, filterPresenceOffset2, filterPresenceStatus, lockSensorOffset1, lockSensorValue, lockStatus, temperature));
        Assert.assertTrue((boolean)(item instanceof Fcs_ClampXplus4Telemetry));
        Fcs_ClampXplus4Telemetry item_ = (Fcs_ClampXplus4Telemetry)item;
        Assert.assertEquals((Object)clampState, (Object)item_.getClampState());
        Assert.assertEquals((long)filterPositionSensorValue, (long)item_.getFilterPositionSensorValue());
        Assert.assertEquals((long)filterPresenceMinNoFilter, (long)item_.getFilterPresenceMinNoFilter());
        Assert.assertEquals((long)filterPresenceOffset2, (long)item_.getFilterPresenceOffset2());
        Assert.assertEquals((Object)filterPresenceStatus, (Object)item_.getFilterPresenceStatus());
        Assert.assertEquals((long)lockSensorOffset1, (long)item_.getLockSensorOffset1());
        Assert.assertEquals((long)lockSensorValue, (long)item_.getLockSensorValue());
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_ClampXplus5Telemetry() throws Exception {
        String clampState = "";
        int filterPositionSensorValue = 387;
        int filterPresenceMinNoFilter = 375;
        int filterPresenceOffset2 = 257;
        String filterPresenceStatus = "i";
        int lockSensorOffset1 = 584;
        int lockSensorValue = 497;
        String lockStatus = "";
        double temperature = 0.0905624f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_ClampXplus5Telemetry(clampState, filterPositionSensorValue, filterPresenceMinNoFilter, filterPresenceOffset2, filterPresenceStatus, lockSensorOffset1, lockSensorValue, lockStatus, temperature));
        Assert.assertTrue((boolean)(item instanceof Fcs_ClampXplus5Telemetry));
        Fcs_ClampXplus5Telemetry item_ = (Fcs_ClampXplus5Telemetry)item;
        Assert.assertEquals((Object)clampState, (Object)item_.getClampState());
        Assert.assertEquals((long)filterPositionSensorValue, (long)item_.getFilterPositionSensorValue());
        Assert.assertEquals((long)filterPresenceMinNoFilter, (long)item_.getFilterPresenceMinNoFilter());
        Assert.assertEquals((long)filterPresenceOffset2, (long)item_.getFilterPresenceOffset2());
        Assert.assertEquals((Object)filterPresenceStatus, (Object)item_.getFilterPresenceStatus());
        Assert.assertEquals((long)lockSensorOffset1, (long)item_.getLockSensorOffset1());
        Assert.assertEquals((long)lockSensorValue, (long)item_.getLockSensorValue());
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_ClampXplusControllerTelemetry() throws Exception {
        boolean booted = true;
        boolean brakeActivated = true;
        boolean controllerWithBrake = true;
        int current = 190;
        int errorHistoryNB = 92;
        String errorRegister = "z";
        boolean inError = false;
        boolean initialized = false;
        int lastErrorCode = 577;
        String lastErrorName = "z";
        String mode = "u";
        int position = 475;
        String state = "";
        int velocity = 785;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_ClampXplusControllerTelemetry(booted, brakeActivated, controllerWithBrake, current, errorHistoryNB, errorRegister, inError, initialized, lastErrorCode, lastErrorName, mode, position, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_ClampXplusControllerTelemetry));
        Fcs_ClampXplusControllerTelemetry item_ = (Fcs_ClampXplusControllerTelemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((Object)controllerWithBrake, (Object)item_.isControllerWithBrake());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_ConfigTelemetry() throws Exception {
        String data_Devices_checksum = "a";
        String data_General_checksum = "e";
        String data_Limits_checksum = "b";
        String data_autochanger_checksum = "";
        String data_canbus_checksum = "";
        String data_carousel_checksum = "y";
        String data_controller_checksum = "g";
        String data_filter_checksum = "";
        String data_loader_checksum = "";
        String data_nodeID_checksum = "";
        String data_readRate_checksum = "b";
        String data_sensor_checksum = "";
        String data_serialNB_checksum = "";
        String data_timers_checksum = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_ConfigTelemetry(data_Devices_checksum, data_General_checksum, data_Limits_checksum, data_autochanger_checksum, data_canbus_checksum, data_carousel_checksum, data_controller_checksum, data_filter_checksum, data_loader_checksum, data_nodeID_checksum, data_readRate_checksum, data_sensor_checksum, data_serialNB_checksum, data_timers_checksum));
        Assert.assertTrue((boolean)(item instanceof Fcs_ConfigTelemetry));
        Fcs_ConfigTelemetry item_ = (Fcs_ConfigTelemetry)item;
        Assert.assertEquals((Object)data_Devices_checksum, (Object)item_.getData_Devices_checksum());
        Assert.assertEquals((Object)data_General_checksum, (Object)item_.getData_General_checksum());
        Assert.assertEquals((Object)data_Limits_checksum, (Object)item_.getData_Limits_checksum());
        Assert.assertEquals((Object)data_autochanger_checksum, (Object)item_.getData_autochanger_checksum());
        Assert.assertEquals((Object)data_canbus_checksum, (Object)item_.getData_canbus_checksum());
        Assert.assertEquals((Object)data_carousel_checksum, (Object)item_.getData_carousel_checksum());
        Assert.assertEquals((Object)data_controller_checksum, (Object)item_.getData_controller_checksum());
        Assert.assertEquals((Object)data_filter_checksum, (Object)item_.getData_filter_checksum());
        Assert.assertEquals((Object)data_loader_checksum, (Object)item_.getData_loader_checksum());
        Assert.assertEquals((Object)data_nodeID_checksum, (Object)item_.getData_nodeID_checksum());
        Assert.assertEquals((Object)data_readRate_checksum, (Object)item_.getData_readRate_checksum());
        Assert.assertEquals((Object)data_sensor_checksum, (Object)item_.getData_sensor_checksum());
        Assert.assertEquals((Object)data_serialNB_checksum, (Object)item_.getData_serialNB_checksum());
        Assert.assertEquals((Object)data_timers_checksum, (Object)item_.getData_timers_checksum());
    }

    @Test
    public void sendReceiveFcs_HooksTelemetry() throws Exception {
        boolean allHooksInStateCLOSED = false;
        String clampState = "r";
        boolean controllerInError = false;
        int current = 365;
        boolean forceClampedStatus = true;
        boolean forceOverClampedStatus = true;
        int forceSensorVoltage0 = 824;
        int forceSensorVoltage1 = 643;
        String forceStatus = "y";
        boolean forceUnclampedStatus = true;
        boolean forceUnderClampedStatus = true;
        boolean homingDone = true;
        int position = 877;
        String statusPublishedByHook1 = "k";
        boolean statuspublishedbyhook1_inError = false;
        boolean statuspublishedbyhook1_lockSensorValue = false;
        String statuspublishedbyhook1_lockStatus = "";
        boolean statuspublishedbyhook1_unlockSensorValue = true;
        String statusPublishedByHook2 = "";
        boolean statuspublishedbyhook2_inError = true;
        boolean statuspublishedbyhook2_lockSensorValue = false;
        String statuspublishedbyhook2_lockStatus = "";
        boolean statuspublishedbyhook2_unlockSensorValue = false;
        String statusPublishedByHook3 = "";
        boolean statuspublishedbyhook3_inError = false;
        boolean statuspublishedbyhook3_lockSensorValue = false;
        String statuspublishedbyhook3_lockStatus = "n";
        boolean statuspublishedbyhook3_unlockSensorValue = false;
        String statusPublishedByHook4 = "u";
        boolean statuspublishedbyhook4_inError = true;
        boolean statuspublishedbyhook4_lockSensorValue = true;
        String statuspublishedbyhook4_lockStatus = "";
        boolean statuspublishedbyhook4_unlockSensorValue = true;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_HooksTelemetry(allHooksInStateCLOSED, clampState, controllerInError, current, forceClampedStatus, forceOverClampedStatus, forceSensorVoltage0, forceSensorVoltage1, forceStatus, forceUnclampedStatus, forceUnderClampedStatus, homingDone, position, statusPublishedByHook1, statuspublishedbyhook1_inError, statuspublishedbyhook1_lockSensorValue, statuspublishedbyhook1_lockStatus, statuspublishedbyhook1_unlockSensorValue, statusPublishedByHook2, statuspublishedbyhook2_inError, statuspublishedbyhook2_lockSensorValue, statuspublishedbyhook2_lockStatus, statuspublishedbyhook2_unlockSensorValue, statusPublishedByHook3, statuspublishedbyhook3_inError, statuspublishedbyhook3_lockSensorValue, statuspublishedbyhook3_lockStatus, statuspublishedbyhook3_unlockSensorValue, statusPublishedByHook4, statuspublishedbyhook4_inError, statuspublishedbyhook4_lockSensorValue, statuspublishedbyhook4_lockStatus, statuspublishedbyhook4_unlockSensorValue));
        Assert.assertTrue((boolean)(item instanceof Fcs_HooksTelemetry));
        Fcs_HooksTelemetry item_ = (Fcs_HooksTelemetry)item;
        Assert.assertEquals((Object)allHooksInStateCLOSED, (Object)item_.isAllHooksInStateCLOSED());
        Assert.assertEquals((Object)clampState, (Object)item_.getClampState());
        Assert.assertEquals((Object)controllerInError, (Object)item_.isControllerInError());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((Object)forceClampedStatus, (Object)item_.isForceClampedStatus());
        Assert.assertEquals((Object)forceOverClampedStatus, (Object)item_.isForceOverClampedStatus());
        Assert.assertEquals((long)forceSensorVoltage0, (long)item_.getForceSensorVoltage0());
        Assert.assertEquals((long)forceSensorVoltage1, (long)item_.getForceSensorVoltage1());
        Assert.assertEquals((Object)forceStatus, (Object)item_.getForceStatus());
        Assert.assertEquals((Object)forceUnclampedStatus, (Object)item_.isForceUnclampedStatus());
        Assert.assertEquals((Object)forceUnderClampedStatus, (Object)item_.isForceUnderClampedStatus());
        Assert.assertEquals((Object)homingDone, (Object)item_.isHomingDone());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((Object)statusPublishedByHook1, (Object)item_.getStatusPublishedByHook1());
        Assert.assertEquals((Object)statuspublishedbyhook1_inError, (Object)item_.isStatuspublishedbyhook1_inError());
        Assert.assertEquals((Object)statuspublishedbyhook1_lockSensorValue, (Object)item_.isStatuspublishedbyhook1_lockSensorValue());
        Assert.assertEquals((Object)statuspublishedbyhook1_lockStatus, (Object)item_.getStatuspublishedbyhook1_lockStatus());
        Assert.assertEquals((Object)statuspublishedbyhook1_unlockSensorValue, (Object)item_.isStatuspublishedbyhook1_unlockSensorValue());
        Assert.assertEquals((Object)statusPublishedByHook2, (Object)item_.getStatusPublishedByHook2());
        Assert.assertEquals((Object)statuspublishedbyhook2_inError, (Object)item_.isStatuspublishedbyhook2_inError());
        Assert.assertEquals((Object)statuspublishedbyhook2_lockSensorValue, (Object)item_.isStatuspublishedbyhook2_lockSensorValue());
        Assert.assertEquals((Object)statuspublishedbyhook2_lockStatus, (Object)item_.getStatuspublishedbyhook2_lockStatus());
        Assert.assertEquals((Object)statuspublishedbyhook2_unlockSensorValue, (Object)item_.isStatuspublishedbyhook2_unlockSensorValue());
        Assert.assertEquals((Object)statusPublishedByHook3, (Object)item_.getStatusPublishedByHook3());
        Assert.assertEquals((Object)statuspublishedbyhook3_inError, (Object)item_.isStatuspublishedbyhook3_inError());
        Assert.assertEquals((Object)statuspublishedbyhook3_lockSensorValue, (Object)item_.isStatuspublishedbyhook3_lockSensorValue());
        Assert.assertEquals((Object)statuspublishedbyhook3_lockStatus, (Object)item_.getStatuspublishedbyhook3_lockStatus());
        Assert.assertEquals((Object)statuspublishedbyhook3_unlockSensorValue, (Object)item_.isStatuspublishedbyhook3_unlockSensorValue());
        Assert.assertEquals((Object)statusPublishedByHook4, (Object)item_.getStatusPublishedByHook4());
        Assert.assertEquals((Object)statuspublishedbyhook4_inError, (Object)item_.isStatuspublishedbyhook4_inError());
        Assert.assertEquals((Object)statuspublishedbyhook4_lockSensorValue, (Object)item_.isStatuspublishedbyhook4_lockSensorValue());
        Assert.assertEquals((Object)statuspublishedbyhook4_lockStatus, (Object)item_.getStatuspublishedbyhook4_lockStatus());
        Assert.assertEquals((Object)statuspublishedbyhook4_unlockSensorValue, (Object)item_.isStatuspublishedbyhook4_unlockSensorValue());
    }

    @Test
    public void sendReceiveFcs_HooksControllerTelemetry() throws Exception {
        boolean booted = true;
        boolean brakeActivated = true;
        boolean controllerWithBrake = false;
        int current = 853;
        int errorHistoryNB = 747;
        String errorRegister = "a";
        boolean inError = false;
        boolean initialized = false;
        int lastErrorCode = 630;
        String lastErrorName = "p";
        String mode = "";
        int position = 527;
        String state = "";
        int velocity = 353;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_HooksControllerTelemetry(booted, brakeActivated, controllerWithBrake, current, errorHistoryNB, errorRegister, inError, initialized, lastErrorCode, lastErrorName, mode, position, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_HooksControllerTelemetry));
        Fcs_HooksControllerTelemetry item_ = (Fcs_HooksControllerTelemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((Object)controllerWithBrake, (Object)item_.isControllerWithBrake());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_Hyttc580Telemetry() throws Exception {
        boolean booted = true;
        boolean initialized = true;
        long pdo1 = 271L;
        long pdo2 = 128L;
        long pdo4 = 148L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Hyttc580Telemetry(booted, initialized, pdo1, pdo2, pdo4));
        Assert.assertTrue((boolean)(item instanceof Fcs_Hyttc580Telemetry));
        Fcs_Hyttc580Telemetry item_ = (Fcs_Hyttc580Telemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)pdo1, (long)item_.getPdo1());
        Assert.assertEquals((long)pdo2, (long)item_.getPdo2());
        Assert.assertEquals((long)pdo4, (long)item_.getPdo4());
    }

    @Test
    public void sendReceiveFcs_LatchXminusTelemetry() throws Exception {
        boolean controllerInFault = false;
        boolean filterEngagedSensorsInError = false;
        boolean filterPresenceSensorValue = false;
        boolean inError = true;
        boolean lockSensorValue = true;
        boolean lockSensorsInError = false;
        String lockStatus = "";
        boolean unlockSensorValue = false;
        boolean unlockSensorsInError = false;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_LatchXminusTelemetry(controllerInFault, filterEngagedSensorsInError, filterPresenceSensorValue, inError, lockSensorValue, lockSensorsInError, lockStatus, unlockSensorValue, unlockSensorsInError));
        Assert.assertTrue((boolean)(item instanceof Fcs_LatchXminusTelemetry));
        Fcs_LatchXminusTelemetry item_ = (Fcs_LatchXminusTelemetry)item;
        Assert.assertEquals((Object)controllerInFault, (Object)item_.isControllerInFault());
        Assert.assertEquals((Object)filterEngagedSensorsInError, (Object)item_.isFilterEngagedSensorsInError());
        Assert.assertEquals((Object)filterPresenceSensorValue, (Object)item_.isFilterPresenceSensorValue());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)lockSensorValue, (Object)item_.isLockSensorValue());
        Assert.assertEquals((Object)lockSensorsInError, (Object)item_.isLockSensorsInError());
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
        Assert.assertEquals((Object)unlockSensorValue, (Object)item_.isUnlockSensorValue());
        Assert.assertEquals((Object)unlockSensorsInError, (Object)item_.isUnlockSensorsInError());
    }

    @Test
    public void sendReceiveFcs_LatchXminusControllerTelemetry() throws Exception {
        boolean booted = true;
        boolean brakeActivated = true;
        boolean controllerWithBrake = false;
        int current = 87;
        int errorHistoryNB = 214;
        String errorRegister = "";
        boolean inError = false;
        boolean initialized = true;
        int lastErrorCode = 949;
        String lastErrorName = "";
        String mode = "";
        int position = 891;
        String state = "b";
        int velocity = 238;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_LatchXminusControllerTelemetry(booted, brakeActivated, controllerWithBrake, current, errorHistoryNB, errorRegister, inError, initialized, lastErrorCode, lastErrorName, mode, position, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_LatchXminusControllerTelemetry));
        Fcs_LatchXminusControllerTelemetry item_ = (Fcs_LatchXminusControllerTelemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((Object)controllerWithBrake, (Object)item_.isControllerWithBrake());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_LatchXplusTelemetry() throws Exception {
        boolean controllerInFault = true;
        boolean filterEngagedSensorsInError = true;
        boolean filterPresenceSensorValue = false;
        boolean inError = false;
        boolean lockSensorValue = false;
        boolean lockSensorsInError = false;
        String lockStatus = "j";
        boolean unlockSensorValue = true;
        boolean unlockSensorsInError = true;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_LatchXplusTelemetry(controllerInFault, filterEngagedSensorsInError, filterPresenceSensorValue, inError, lockSensorValue, lockSensorsInError, lockStatus, unlockSensorValue, unlockSensorsInError));
        Assert.assertTrue((boolean)(item instanceof Fcs_LatchXplusTelemetry));
        Fcs_LatchXplusTelemetry item_ = (Fcs_LatchXplusTelemetry)item;
        Assert.assertEquals((Object)controllerInFault, (Object)item_.isControllerInFault());
        Assert.assertEquals((Object)filterEngagedSensorsInError, (Object)item_.isFilterEngagedSensorsInError());
        Assert.assertEquals((Object)filterPresenceSensorValue, (Object)item_.isFilterPresenceSensorValue());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)lockSensorValue, (Object)item_.isLockSensorValue());
        Assert.assertEquals((Object)lockSensorsInError, (Object)item_.isLockSensorsInError());
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
        Assert.assertEquals((Object)unlockSensorValue, (Object)item_.isUnlockSensorValue());
        Assert.assertEquals((Object)unlockSensorsInError, (Object)item_.isUnlockSensorsInError());
    }

    @Test
    public void sendReceiveFcs_LatchXplusControllerTelemetry() throws Exception {
        boolean booted = true;
        boolean brakeActivated = true;
        boolean controllerWithBrake = true;
        int current = 78;
        int errorHistoryNB = 427;
        String errorRegister = "";
        boolean inError = false;
        boolean initialized = false;
        int lastErrorCode = 114;
        String lastErrorName = "";
        String mode = "w";
        int position = 419;
        String state = "f";
        int velocity = 252;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_LatchXplusControllerTelemetry(booted, brakeActivated, controllerWithBrake, current, errorHistoryNB, errorRegister, inError, initialized, lastErrorCode, lastErrorName, mode, position, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_LatchXplusControllerTelemetry));
        Fcs_LatchXplusControllerTelemetry item_ = (Fcs_LatchXplusControllerTelemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((Object)controllerWithBrake, (Object)item_.isControllerWithBrake());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_LatchesTelemetry() throws Exception {
        int filterId = 837;
        String filterName = "";
        String filterPresenceStatus = "p";
        String lockStatus = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_LatchesTelemetry(filterId, filterName, filterPresenceStatus, lockStatus));
        Assert.assertTrue((boolean)(item instanceof Fcs_LatchesTelemetry));
        Fcs_LatchesTelemetry item_ = (Fcs_LatchesTelemetry)item;
        Assert.assertEquals((long)filterId, (long)item_.getFilterId());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)filterPresenceStatus, (Object)item_.getFilterPresenceStatus());
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
    }

    @Test
    public void sendReceiveFcs_LoaderTelemetry() throws Exception {
        boolean af0 = true;
        boolean af0InError = false;
        boolean af1 = false;
        boolean af1InError = false;
        boolean af3 = true;
        boolean af3InError = false;
        boolean ap2 = false;
        boolean ap2InError = true;
        boolean carrierRelayStatus = true;
        int filterDistance = 911;
        boolean filterPositionStatus = false;
        boolean filterPresenceSensorValue = false;
        boolean filterPresenceSensorsInError = true;
        boolean hooksRelayStatus = true;
        boolean keyEng = true;
        boolean keyEngInError = true;
        boolean keyLock = true;
        boolean keyLockInError = false;
        boolean lfd = false;
        boolean lfs = true;
        boolean loaderDefaultStatus = false;
        boolean loaderOnCameraSensorValue = true;
        boolean loaderOnCameraSensorsInError = false;
        boolean lps = true;
        boolean lpsInError = false;
        boolean lrh = false;
        boolean lrhInError = false;
        boolean safetyBeltPresence = true;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_LoaderTelemetry(af0, af0InError, af1, af1InError, af3, af3InError, ap2, ap2InError, carrierRelayStatus, filterDistance, filterPositionStatus, filterPresenceSensorValue, filterPresenceSensorsInError, hooksRelayStatus, keyEng, keyEngInError, keyLock, keyLockInError, lfd, lfs, loaderDefaultStatus, loaderOnCameraSensorValue, loaderOnCameraSensorsInError, lps, lpsInError, lrh, lrhInError, safetyBeltPresence));
        Assert.assertTrue((boolean)(item instanceof Fcs_LoaderTelemetry));
        Fcs_LoaderTelemetry item_ = (Fcs_LoaderTelemetry)item;
        Assert.assertEquals((Object)af0, (Object)item_.isAf0());
        Assert.assertEquals((Object)af0InError, (Object)item_.isAf0InError());
        Assert.assertEquals((Object)af1, (Object)item_.isAf1());
        Assert.assertEquals((Object)af1InError, (Object)item_.isAf1InError());
        Assert.assertEquals((Object)af3, (Object)item_.isAf3());
        Assert.assertEquals((Object)af3InError, (Object)item_.isAf3InError());
        Assert.assertEquals((Object)ap2, (Object)item_.isAp2());
        Assert.assertEquals((Object)ap2InError, (Object)item_.isAp2InError());
        Assert.assertEquals((Object)carrierRelayStatus, (Object)item_.isCarrierRelayStatus());
        Assert.assertEquals((long)filterDistance, (long)item_.getFilterDistance());
        Assert.assertEquals((Object)filterPositionStatus, (Object)item_.isFilterPositionStatus());
        Assert.assertEquals((Object)filterPresenceSensorValue, (Object)item_.isFilterPresenceSensorValue());
        Assert.assertEquals((Object)filterPresenceSensorsInError, (Object)item_.isFilterPresenceSensorsInError());
        Assert.assertEquals((Object)hooksRelayStatus, (Object)item_.isHooksRelayStatus());
        Assert.assertEquals((Object)keyEng, (Object)item_.isKeyEng());
        Assert.assertEquals((Object)keyEngInError, (Object)item_.isKeyEngInError());
        Assert.assertEquals((Object)keyLock, (Object)item_.isKeyLock());
        Assert.assertEquals((Object)keyLockInError, (Object)item_.isKeyLockInError());
        Assert.assertEquals((Object)lfd, (Object)item_.isLfd());
        Assert.assertEquals((Object)lfs, (Object)item_.isLfs());
        Assert.assertEquals((Object)loaderDefaultStatus, (Object)item_.isLoaderDefaultStatus());
        Assert.assertEquals((Object)loaderOnCameraSensorValue, (Object)item_.isLoaderOnCameraSensorValue());
        Assert.assertEquals((Object)loaderOnCameraSensorsInError, (Object)item_.isLoaderOnCameraSensorsInError());
        Assert.assertEquals((Object)lps, (Object)item_.isLps());
        Assert.assertEquals((Object)lpsInError, (Object)item_.isLpsInError());
        Assert.assertEquals((Object)lrh, (Object)item_.isLrh());
        Assert.assertEquals((Object)lrhInError, (Object)item_.isLrhInError());
        Assert.assertEquals((Object)safetyBeltPresence, (Object)item_.isSafetyBeltPresence());
    }

    @Test
    public void sendReceiveFcs_LoaderPlutoGatewayTelemetry() throws Exception {
        boolean booted = false;
        boolean initialized = true;
        int intValues = 191;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_LoaderPlutoGatewayTelemetry(booted, initialized, intValues));
        Assert.assertTrue((boolean)(item instanceof Fcs_LoaderPlutoGatewayTelemetry));
        Fcs_LoaderPlutoGatewayTelemetry item_ = (Fcs_LoaderPlutoGatewayTelemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)intValues, (long)item_.getIntValues());
    }

    @Test
    public void sendReceiveFcs_OnlineClampXminusTelemetry() throws Exception {
        boolean controllerBooted = false;
        boolean controllerInFault = true;
        int current = 149;
        boolean homingDone = false;
        boolean inError = true;
        boolean lockSensorInError = false;
        boolean lockSensorValue = false;
        String lockStatus = "q";
        int position = 233;
        int sentCurrent = 846;
        boolean unlockSensorInError = true;
        boolean unlockSensorValue = false;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_OnlineClampXminusTelemetry(controllerBooted, controllerInFault, current, homingDone, inError, lockSensorInError, lockSensorValue, lockStatus, position, sentCurrent, unlockSensorInError, unlockSensorValue));
        Assert.assertTrue((boolean)(item instanceof Fcs_OnlineClampXminusTelemetry));
        Fcs_OnlineClampXminusTelemetry item_ = (Fcs_OnlineClampXminusTelemetry)item;
        Assert.assertEquals((Object)controllerBooted, (Object)item_.isControllerBooted());
        Assert.assertEquals((Object)controllerInFault, (Object)item_.isControllerInFault());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((Object)homingDone, (Object)item_.isHomingDone());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)lockSensorInError, (Object)item_.isLockSensorInError());
        Assert.assertEquals((Object)lockSensorValue, (Object)item_.isLockSensorValue());
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)sentCurrent, (long)item_.getSentCurrent());
        Assert.assertEquals((Object)unlockSensorInError, (Object)item_.isUnlockSensorInError());
        Assert.assertEquals((Object)unlockSensorValue, (Object)item_.isUnlockSensorValue());
    }

    @Test
    public void sendReceiveFcs_OnlineClampXminusControllerTelemetry() throws Exception {
        boolean booted = false;
        boolean brakeActivated = true;
        boolean controllerWithBrake = false;
        int current = 261;
        int errorHistoryNB = 900;
        String errorRegister = "k";
        boolean inError = true;
        boolean initialized = true;
        int lastErrorCode = 298;
        String lastErrorName = "";
        String mode = "";
        int position = 691;
        String state = "";
        int velocity = 12;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_OnlineClampXminusControllerTelemetry(booted, brakeActivated, controllerWithBrake, current, errorHistoryNB, errorRegister, inError, initialized, lastErrorCode, lastErrorName, mode, position, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_OnlineClampXminusControllerTelemetry));
        Fcs_OnlineClampXminusControllerTelemetry item_ = (Fcs_OnlineClampXminusControllerTelemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((Object)controllerWithBrake, (Object)item_.isControllerWithBrake());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_OnlineClampXplusTelemetry() throws Exception {
        boolean controllerBooted = true;
        boolean controllerInFault = false;
        int current = 901;
        boolean homingDone = false;
        boolean inError = true;
        boolean lockSensorInError = true;
        boolean lockSensorValue = false;
        String lockStatus = "g";
        int position = 534;
        int sentCurrent = 589;
        boolean unlockSensorInError = true;
        boolean unlockSensorValue = true;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_OnlineClampXplusTelemetry(controllerBooted, controllerInFault, current, homingDone, inError, lockSensorInError, lockSensorValue, lockStatus, position, sentCurrent, unlockSensorInError, unlockSensorValue));
        Assert.assertTrue((boolean)(item instanceof Fcs_OnlineClampXplusTelemetry));
        Fcs_OnlineClampXplusTelemetry item_ = (Fcs_OnlineClampXplusTelemetry)item;
        Assert.assertEquals((Object)controllerBooted, (Object)item_.isControllerBooted());
        Assert.assertEquals((Object)controllerInFault, (Object)item_.isControllerInFault());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((Object)homingDone, (Object)item_.isHomingDone());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)lockSensorInError, (Object)item_.isLockSensorInError());
        Assert.assertEquals((Object)lockSensorValue, (Object)item_.isLockSensorValue());
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)sentCurrent, (long)item_.getSentCurrent());
        Assert.assertEquals((Object)unlockSensorInError, (Object)item_.isUnlockSensorInError());
        Assert.assertEquals((Object)unlockSensorValue, (Object)item_.isUnlockSensorValue());
    }

    @Test
    public void sendReceiveFcs_OnlineClampXplusControllerTelemetry() throws Exception {
        boolean booted = true;
        boolean brakeActivated = false;
        boolean controllerWithBrake = false;
        int current = 234;
        int errorHistoryNB = 876;
        String errorRegister = "o";
        boolean inError = false;
        boolean initialized = false;
        int lastErrorCode = 310;
        String lastErrorName = "s";
        String mode = "";
        int position = 389;
        String state = "";
        int velocity = 897;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_OnlineClampXplusControllerTelemetry(booted, brakeActivated, controllerWithBrake, current, errorHistoryNB, errorRegister, inError, initialized, lastErrorCode, lastErrorName, mode, position, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_OnlineClampXplusControllerTelemetry));
        Fcs_OnlineClampXplusControllerTelemetry item_ = (Fcs_OnlineClampXplusControllerTelemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((Object)controllerWithBrake, (Object)item_.isControllerWithBrake());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_OnlineClampYminusTelemetry() throws Exception {
        boolean controllerBooted = false;
        boolean controllerInFault = false;
        int current = 887;
        boolean homingDone = true;
        boolean inError = true;
        boolean lockSensorInError = true;
        boolean lockSensorValue = false;
        String lockStatus = "";
        int position = 471;
        int sentCurrent = 511;
        boolean unlockSensorInError = true;
        boolean unlockSensorValue = true;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_OnlineClampYminusTelemetry(controllerBooted, controllerInFault, current, homingDone, inError, lockSensorInError, lockSensorValue, lockStatus, position, sentCurrent, unlockSensorInError, unlockSensorValue));
        Assert.assertTrue((boolean)(item instanceof Fcs_OnlineClampYminusTelemetry));
        Fcs_OnlineClampYminusTelemetry item_ = (Fcs_OnlineClampYminusTelemetry)item;
        Assert.assertEquals((Object)controllerBooted, (Object)item_.isControllerBooted());
        Assert.assertEquals((Object)controllerInFault, (Object)item_.isControllerInFault());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((Object)homingDone, (Object)item_.isHomingDone());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)lockSensorInError, (Object)item_.isLockSensorInError());
        Assert.assertEquals((Object)lockSensorValue, (Object)item_.isLockSensorValue());
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((long)sentCurrent, (long)item_.getSentCurrent());
        Assert.assertEquals((Object)unlockSensorInError, (Object)item_.isUnlockSensorInError());
        Assert.assertEquals((Object)unlockSensorValue, (Object)item_.isUnlockSensorValue());
    }

    @Test
    public void sendReceiveFcs_OnlineClampYminusControllerTelemetry() throws Exception {
        boolean booted = true;
        boolean brakeActivated = false;
        boolean controllerWithBrake = true;
        int current = 170;
        int errorHistoryNB = 704;
        String errorRegister = "d";
        boolean inError = true;
        boolean initialized = true;
        int lastErrorCode = 617;
        String lastErrorName = "";
        String mode = "";
        int position = 826;
        String state = "";
        int velocity = 526;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_OnlineClampYminusControllerTelemetry(booted, brakeActivated, controllerWithBrake, current, errorHistoryNB, errorRegister, inError, initialized, lastErrorCode, lastErrorName, mode, position, state, velocity));
        Assert.assertTrue((boolean)(item instanceof Fcs_OnlineClampYminusControllerTelemetry));
        Fcs_OnlineClampYminusControllerTelemetry item_ = (Fcs_OnlineClampYminusControllerTelemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((Object)brakeActivated, (Object)item_.isBrakeActivated());
        Assert.assertEquals((Object)controllerWithBrake, (Object)item_.isControllerWithBrake());
        Assert.assertEquals((long)current, (long)item_.getCurrent());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((long)position, (long)item_.getPosition());
        Assert.assertEquals((Object)state, (Object)item_.getState());
        Assert.assertEquals((long)velocity, (long)item_.getVelocity());
    }

    @Test
    public void sendReceiveFcs_OnlineClampsTelemetry() throws Exception {
        boolean homingDone = false;
        String lockStatus = "";
        int onlineClampRawStrain = 60;
        int onlineClampStrain = 892;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_OnlineClampsTelemetry(homingDone, lockStatus, onlineClampRawStrain, onlineClampStrain));
        Assert.assertTrue((boolean)(item instanceof Fcs_OnlineClampsTelemetry));
        Fcs_OnlineClampsTelemetry item_ = (Fcs_OnlineClampsTelemetry)item;
        Assert.assertEquals((Object)homingDone, (Object)item_.isHomingDone());
        Assert.assertEquals((Object)lockStatus, (Object)item_.getLockStatus());
        Assert.assertEquals((long)onlineClampRawStrain, (long)item_.getOnlineClampRawStrain());
        Assert.assertEquals((long)onlineClampStrain, (long)item_.getOnlineClampStrain());
    }

    @Test
    public void sendReceiveFcs_OnlineStrainGaugeTelemetry() throws Exception {
        boolean booted = false;
        int errorHistoryNB = 90;
        String errorRegister = "";
        boolean inError = false;
        boolean initialized = true;
        int lastErrorCode = 276;
        String lastErrorName = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_OnlineStrainGaugeTelemetry(booted, errorHistoryNB, errorRegister, inError, initialized, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_OnlineStrainGaugeTelemetry));
        Fcs_OnlineStrainGaugeTelemetry item_ = (Fcs_OnlineStrainGaugeTelemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_ProximitySensorsDeviceTelemetry() throws Exception {
        boolean booted = false;
        int errorHistoryNB = 117;
        String errorRegister = "";
        boolean inError = true;
        boolean initialized = true;
        int lastErrorCode = 144;
        String lastErrorName = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_ProximitySensorsDeviceTelemetry(booted, errorHistoryNB, errorRegister, inError, initialized, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_ProximitySensorsDeviceTelemetry));
        Fcs_ProximitySensorsDeviceTelemetry item_ = (Fcs_ProximitySensorsDeviceTelemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_Pt100Telemetry() throws Exception {
        boolean booted = false;
        int errorHistoryNB = 378;
        String errorRegister = "";
        boolean inError = false;
        boolean initialized = true;
        int lastErrorCode = 529;
        String lastErrorName = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Pt100Telemetry(booted, errorHistoryNB, errorRegister, inError, initialized, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_Pt100Telemetry));
        Fcs_Pt100Telemetry item_ = (Fcs_Pt100Telemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_RuntimeInfoTelemetry() throws Exception {
        long freeMemory = 251L;
        long maxMemory = 370L;
        int nThreads = 486;
        double processCpuLoad = 0.01072669f;
        double systemCpuLoad = 0.7290836572647095;
        long totalMemory = 633L;
        int uptime = 360;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_RuntimeInfoTelemetry(freeMemory, maxMemory, nThreads, processCpuLoad, systemCpuLoad, totalMemory, uptime));
        Assert.assertTrue((boolean)(item instanceof Fcs_RuntimeInfoTelemetry));
        Fcs_RuntimeInfoTelemetry item_ = (Fcs_RuntimeInfoTelemetry)item;
        Assert.assertEquals((long)freeMemory, (long)item_.getFreeMemory());
        Assert.assertEquals((long)maxMemory, (long)item_.getMaxMemory());
        Assert.assertEquals((long)nThreads, (long)item_.getNThreads());
        Assert.assertEquals((double)processCpuLoad, (double)item_.getProcessCpuLoad(), (double)1.0E-6f);
        Assert.assertEquals((double)systemCpuLoad, (double)item_.getSystemCpuLoad(), (double)1.0E-6f);
        Assert.assertEquals((long)totalMemory, (long)item_.getTotalMemory());
        Assert.assertEquals((long)uptime, (long)item_.getUptime());
    }

    @Test
    public void sendReceiveFcs_Socket1Telemetry() throws Exception {
        boolean atStandby = false;
        boolean carouselMoving = false;
        String clampsState = "";
        int deltaPosition = 818;
        boolean empty = true;
        int filterID = 820;
        String filterName = "";
        String slaveStatus = "b";
        int socketID = 711;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Socket1Telemetry(atStandby, carouselMoving, clampsState, deltaPosition, empty, filterID, filterName, slaveStatus, socketID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Socket1Telemetry));
        Fcs_Socket1Telemetry item_ = (Fcs_Socket1Telemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)carouselMoving, (Object)item_.isCarouselMoving());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((long)deltaPosition, (long)item_.getDeltaPosition());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((long)filterID, (long)item_.getFilterID());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)slaveStatus, (Object)item_.getSlaveStatus());
        Assert.assertEquals((long)socketID, (long)item_.getSocketID());
    }

    @Test
    public void sendReceiveFcs_Socket2Telemetry() throws Exception {
        boolean atStandby = false;
        boolean carouselMoving = false;
        String clampsState = "";
        int deltaPosition = 512;
        boolean empty = true;
        int filterID = 716;
        String filterName = "m";
        String slaveStatus = "";
        int socketID = 988;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Socket2Telemetry(atStandby, carouselMoving, clampsState, deltaPosition, empty, filterID, filterName, slaveStatus, socketID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Socket2Telemetry));
        Fcs_Socket2Telemetry item_ = (Fcs_Socket2Telemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)carouselMoving, (Object)item_.isCarouselMoving());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((long)deltaPosition, (long)item_.getDeltaPosition());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((long)filterID, (long)item_.getFilterID());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)slaveStatus, (Object)item_.getSlaveStatus());
        Assert.assertEquals((long)socketID, (long)item_.getSocketID());
    }

    @Test
    public void sendReceiveFcs_Socket3Telemetry() throws Exception {
        boolean atStandby = true;
        boolean carouselMoving = true;
        String clampsState = "";
        int deltaPosition = 581;
        boolean empty = false;
        int filterID = 557;
        String filterName = "";
        String slaveStatus = "m";
        int socketID = 910;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Socket3Telemetry(atStandby, carouselMoving, clampsState, deltaPosition, empty, filterID, filterName, slaveStatus, socketID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Socket3Telemetry));
        Fcs_Socket3Telemetry item_ = (Fcs_Socket3Telemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)carouselMoving, (Object)item_.isCarouselMoving());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((long)deltaPosition, (long)item_.getDeltaPosition());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((long)filterID, (long)item_.getFilterID());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)slaveStatus, (Object)item_.getSlaveStatus());
        Assert.assertEquals((long)socketID, (long)item_.getSocketID());
    }

    @Test
    public void sendReceiveFcs_Socket4Telemetry() throws Exception {
        boolean atStandby = true;
        boolean carouselMoving = false;
        String clampsState = "k";
        int deltaPosition = 580;
        boolean empty = false;
        int filterID = 372;
        String filterName = "";
        String slaveStatus = "";
        int socketID = 781;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Socket4Telemetry(atStandby, carouselMoving, clampsState, deltaPosition, empty, filterID, filterName, slaveStatus, socketID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Socket4Telemetry));
        Fcs_Socket4Telemetry item_ = (Fcs_Socket4Telemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)carouselMoving, (Object)item_.isCarouselMoving());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((long)deltaPosition, (long)item_.getDeltaPosition());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((long)filterID, (long)item_.getFilterID());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)slaveStatus, (Object)item_.getSlaveStatus());
        Assert.assertEquals((long)socketID, (long)item_.getSocketID());
    }

    @Test
    public void sendReceiveFcs_Socket5Telemetry() throws Exception {
        boolean atStandby = true;
        boolean carouselMoving = true;
        String clampsState = "y";
        int deltaPosition = 811;
        boolean empty = false;
        int filterID = 661;
        String filterName = "";
        String slaveStatus = "";
        int socketID = 520;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_Socket5Telemetry(atStandby, carouselMoving, clampsState, deltaPosition, empty, filterID, filterName, slaveStatus, socketID));
        Assert.assertTrue((boolean)(item instanceof Fcs_Socket5Telemetry));
        Fcs_Socket5Telemetry item_ = (Fcs_Socket5Telemetry)item;
        Assert.assertEquals((Object)atStandby, (Object)item_.isAtStandby());
        Assert.assertEquals((Object)carouselMoving, (Object)item_.isCarouselMoving());
        Assert.assertEquals((Object)clampsState, (Object)item_.getClampsState());
        Assert.assertEquals((long)deltaPosition, (long)item_.getDeltaPosition());
        Assert.assertEquals((Object)empty, (Object)item_.isEmpty());
        Assert.assertEquals((long)filterID, (long)item_.getFilterID());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)slaveStatus, (Object)item_.getSlaveStatus());
        Assert.assertEquals((long)socketID, (long)item_.getSocketID());
    }

    @Test
    public void sendReceiveFcs_TempSensorsDevice1Telemetry() throws Exception {
        boolean booted = false;
        int errorHistoryNB = 236;
        String errorRegister = "";
        boolean inError = false;
        boolean initialized = false;
        int lastErrorCode = 90;
        String lastErrorName = "w";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_TempSensorsDevice1Telemetry(booted, errorHistoryNB, errorRegister, inError, initialized, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_TempSensorsDevice1Telemetry));
        Fcs_TempSensorsDevice1Telemetry item_ = (Fcs_TempSensorsDevice1Telemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }

    @Test
    public void sendReceiveFcs_TempSensorsDevice2Telemetry() throws Exception {
        boolean booted = false;
        int errorHistoryNB = 403;
        String errorRegister = "";
        boolean inError = false;
        boolean initialized = false;
        int lastErrorCode = 533;
        String lastErrorName = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fcs_TempSensorsDevice2Telemetry(booted, errorHistoryNB, errorRegister, inError, initialized, lastErrorCode, lastErrorName));
        Assert.assertTrue((boolean)(item instanceof Fcs_TempSensorsDevice2Telemetry));
        Fcs_TempSensorsDevice2Telemetry item_ = (Fcs_TempSensorsDevice2Telemetry)item;
        Assert.assertEquals((Object)booted, (Object)item_.isBooted());
        Assert.assertEquals((long)errorHistoryNB, (long)item_.getErrorHistoryNB());
        Assert.assertEquals((Object)errorRegister, (Object)item_.getErrorRegister());
        Assert.assertEquals((Object)inError, (Object)item_.isInError());
        Assert.assertEquals((Object)initialized, (Object)item_.isInitialized());
        Assert.assertEquals((long)lastErrorCode, (long)item_.getLastErrorCode());
        Assert.assertEquals((Object)lastErrorName, (Object)item_.getLastErrorName());
    }
}

