package org.lsst.sal.camera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class Fcs_LatchXminusTelemetry extends CameraTelemetry {
  private final boolean controllerInFault;

  private final boolean filterEngagedSensorsInError;

  private final boolean filterPresenceSensorValue;

  private final boolean inError;

  private final boolean lockSensorValue;

  private final boolean lockSensorsInError;

  private final String lockStatus;

  private final boolean unlockSensorValue;

  private final boolean unlockSensorsInError;

  public Fcs_LatchXminusTelemetry(boolean controllerInFault, boolean filterEngagedSensorsInError,
      boolean filterPresenceSensorValue, boolean inError, boolean lockSensorValue,
      boolean lockSensorsInError, String lockStatus, boolean unlockSensorValue,
      boolean unlockSensorsInError) {
    this.controllerInFault = controllerInFault;
    this.filterEngagedSensorsInError = filterEngagedSensorsInError;
    this.filterPresenceSensorValue = filterPresenceSensorValue;
    this.inError = inError;
    this.lockSensorValue = lockSensorValue;
    this.lockSensorsInError = lockSensorsInError;
    this.lockStatus = lockStatus;
    this.unlockSensorValue = unlockSensorValue;
    this.unlockSensorsInError = unlockSensorsInError;
  }

  public boolean isControllerInFault() {
    return controllerInFault;
  }

  public boolean isFilterEngagedSensorsInError() {
    return filterEngagedSensorsInError;
  }

  public boolean isFilterPresenceSensorValue() {
    return filterPresenceSensorValue;
  }

  public boolean isInError() {
    return inError;
  }

  public boolean isLockSensorValue() {
    return lockSensorValue;
  }

  public boolean isLockSensorsInError() {
    return lockSensorsInError;
  }

  public String getLockStatus() {
    return lockStatus;
  }

  public boolean isUnlockSensorValue() {
    return unlockSensorValue;
  }

  public boolean isUnlockSensorsInError() {
    return unlockSensorsInError;
  }

  @Override
  public String toString() {
    return "Fcs_LatchXminusTelemetry{" + "controllerInFault=" + controllerInFault +
        ", filterEngagedSensorsInError=" + filterEngagedSensorsInError +
        ", filterPresenceSensorValue=" + filterPresenceSensorValue +", inError=" + inError +
        ", lockSensorValue=" + lockSensorValue +", lockSensorsInError=" + lockSensorsInError +
        ", lockStatus=" + lockStatus +", unlockSensorValue=" + unlockSensorValue +
        ", unlockSensorsInError=" + unlockSensorsInError +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private boolean controllerInFault;

    private boolean filterEngagedSensorsInError;

    private boolean filterPresenceSensorValue;

    private boolean inError;

    private boolean lockSensorValue;

    private boolean lockSensorsInError;

    private String lockStatus;

    private boolean unlockSensorValue;

    private boolean unlockSensorsInError;

    private Builder() {
    }

    public Builder controllerInFault(boolean controllerInFault) {
      this.controllerInFault = controllerInFault;
      return this;
    }

    public Builder filterEngagedSensorsInError(boolean filterEngagedSensorsInError) {
      this.filterEngagedSensorsInError = filterEngagedSensorsInError;
      return this;
    }

    public Builder filterPresenceSensorValue(boolean filterPresenceSensorValue) {
      this.filterPresenceSensorValue = filterPresenceSensorValue;
      return this;
    }

    public Builder inError(boolean inError) {
      this.inError = inError;
      return this;
    }

    public Builder lockSensorValue(boolean lockSensorValue) {
      this.lockSensorValue = lockSensorValue;
      return this;
    }

    public Builder lockSensorsInError(boolean lockSensorsInError) {
      this.lockSensorsInError = lockSensorsInError;
      return this;
    }

    public Builder lockStatus(String lockStatus) {
      this.lockStatus = lockStatus;
      return this;
    }

    public Builder unlockSensorValue(boolean unlockSensorValue) {
      this.unlockSensorValue = unlockSensorValue;
      return this;
    }

    public Builder unlockSensorsInError(boolean unlockSensorsInError) {
      this.unlockSensorsInError = unlockSensorsInError;
      return this;
    }

    public Fcs_LatchXminusTelemetry build() {
      return new Fcs_LatchXminusTelemetry(controllerInFault, filterEngagedSensorsInError, filterPresenceSensorValue, inError, lockSensorValue, lockSensorsInError, lockStatus, unlockSensorValue, unlockSensorsInError);
    }
  }
}
