package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class StartReadoutEvent extends CameraEvent {
  private final String additionalKeys;

  private final String additionalValues;

  private final int imagesInSequence;

  private final String imageName;

  private final int imageIndex;

  private final String imageSource;

  private final String imageController;

  private final String imageDate;

  private final int imageNumber;

  private final double timestampAcquisitionStart;

  private final double exposureTime;

  private final double timestampStartOfReadout;

  public StartReadoutEvent(String additionalKeys, String additionalValues, int imagesInSequence,
      String imageName, int imageIndex, String imageSource, String imageController,
      String imageDate, int imageNumber, double timestampAcquisitionStart, double exposureTime,
      double timestampStartOfReadout) {
    this.additionalKeys = additionalKeys;
    this.additionalValues = additionalValues;
    this.imagesInSequence = imagesInSequence;
    this.imageName = imageName;
    this.imageIndex = imageIndex;
    this.imageSource = imageSource;
    this.imageController = imageController;
    this.imageDate = imageDate;
    this.imageNumber = imageNumber;
    this.timestampAcquisitionStart = timestampAcquisitionStart;
    this.exposureTime = exposureTime;
    this.timestampStartOfReadout = timestampStartOfReadout;
  }

  public String getAdditionalKeys() {
    return additionalKeys;
  }

  public String getAdditionalValues() {
    return additionalValues;
  }

  public int getImagesInSequence() {
    return imagesInSequence;
  }

  public String getImageName() {
    return imageName;
  }

  public int getImageIndex() {
    return imageIndex;
  }

  public String getImageSource() {
    return imageSource;
  }

  public String getImageController() {
    return imageController;
  }

  public String getImageDate() {
    return imageDate;
  }

  public int getImageNumber() {
    return imageNumber;
  }

  public double getTimestampAcquisitionStart() {
    return timestampAcquisitionStart;
  }

  public double getExposureTime() {
    return exposureTime;
  }

  public double getTimestampStartOfReadout() {
    return timestampStartOfReadout;
  }

  @Override
  public String toString() {
    return "StartReadoutEvent{" + "additionalKeys=" + additionalKeys +
        ", additionalValues=" + additionalValues +", imagesInSequence=" + imagesInSequence +
        ", imageName=" + imageName +", imageIndex=" + imageIndex +", imageSource=" + imageSource +
        ", imageController=" + imageController +", imageDate=" + imageDate +
        ", imageNumber=" + imageNumber +", timestampAcquisitionStart=" + timestampAcquisitionStart +
        ", exposureTime=" + exposureTime +", timestampStartOfReadout=" + timestampStartOfReadout +
        "}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private String additionalKeys;

    private String additionalValues;

    private int imagesInSequence;

    private String imageName;

    private int imageIndex;

    private String imageSource;

    private String imageController;

    private String imageDate;

    private int imageNumber;

    private double timestampAcquisitionStart;

    private double exposureTime;

    private double timestampStartOfReadout;

    private Builder() {
    }

    public Builder additionalKeys(String additionalKeys) {
      this.additionalKeys = additionalKeys;
      return this;
    }

    public Builder additionalValues(String additionalValues) {
      this.additionalValues = additionalValues;
      return this;
    }

    public Builder imagesInSequence(int imagesInSequence) {
      this.imagesInSequence = imagesInSequence;
      return this;
    }

    public Builder imageName(String imageName) {
      this.imageName = imageName;
      return this;
    }

    public Builder imageIndex(int imageIndex) {
      this.imageIndex = imageIndex;
      return this;
    }

    public Builder imageSource(String imageSource) {
      this.imageSource = imageSource;
      return this;
    }

    public Builder imageController(String imageController) {
      this.imageController = imageController;
      return this;
    }

    public Builder imageDate(String imageDate) {
      this.imageDate = imageDate;
      return this;
    }

    public Builder imageNumber(int imageNumber) {
      this.imageNumber = imageNumber;
      return this;
    }

    public Builder timestampAcquisitionStart(double timestampAcquisitionStart) {
      this.timestampAcquisitionStart = timestampAcquisitionStart;
      return this;
    }

    public Builder exposureTime(double exposureTime) {
      this.exposureTime = exposureTime;
      return this;
    }

    public Builder timestampStartOfReadout(double timestampStartOfReadout) {
      this.timestampStartOfReadout = timestampStartOfReadout;
      return this;
    }

    public StartReadoutEvent build() {
      return new StartReadoutEvent(additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime, timestampStartOfReadout);
    }
  }
}
