/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALEvent;
import org.lsst.sal.SALException;
import org.lsst.sal.TestHelper;
import org.lsst.sal.camera.SALCamera;
import org.lsst.sal.camera.event.AuthListEvent;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.CCSConfiguredEvent;
import org.lsst.sal.camera.event.ConfigurationAppliedEvent;
import org.lsst.sal.camera.event.ConfigurationsAvailableEvent;
import org.lsst.sal.camera.event.Daq_monitor_PeriodicTasksConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_Stats_StatisticsConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_Stats_buildConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_StoreConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_Store_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_Store_StoreConfigurationEvent;
import org.lsst.sal.camera.event.EndInitializeGuiderEvent;
import org.lsst.sal.camera.event.EndInitializeImageEvent;
import org.lsst.sal.camera.event.EndLoadFilterEvent;
import org.lsst.sal.camera.event.EndOfImageTelemetryEvent;
import org.lsst.sal.camera.event.EndReadoutEvent;
import org.lsst.sal.camera.event.EndRotateCarouselEvent;
import org.lsst.sal.camera.event.EndSetFilterEvent;
import org.lsst.sal.camera.event.EndShutterCloseEvent;
import org.lsst.sal.camera.event.EndShutterOpenEvent;
import org.lsst.sal.camera.event.EndTakeImageEvent;
import org.lsst.sal.camera.event.EndUnloadFilterEvent;
import org.lsst.sal.camera.event.ErrorCodeEvent;
import org.lsst.sal.camera.event.FocalPlaneSummaryInfoEvent;
import org.lsst.sal.camera.event.Focal_plane_Ccd_HardwareIdConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Ccd_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Ccd_RaftsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_ImageDatabaseServiceConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_ImageNameServiceConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_InstrumentConfig_InstrumentConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_PeriodicTasksConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Raft_HardwareIdConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Raft_RaftTempControlConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Raft_RaftTempControlStatusConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_RebTotalPower_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_HardwareIdConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_RaftsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_RaftsLimitsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_RaftsPowerConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_timersConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Segment_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_SequencerConfig_DAQConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_SequencerConfig_SequencerConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_WebHooksConfig_VisualizationConfigurationEvent;
import org.lsst.sal.camera.event.HeartbeatEvent;
import org.lsst.sal.camera.event.HexConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Cold1_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Cold2_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Cryo1_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Cryo2_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Cryo3_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Cryo4_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Cryo5_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Cryo6_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Maq20_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Maq20x_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Hex_PeriodicTasksConfigurationEvent;
import org.lsst.sal.camera.event.Hex_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.ImageReadoutParametersEvent;
import org.lsst.sal.camera.event.Image_handling_ImageHandler_DAQConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_ImageHandler_FitsHandlingConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_Reb_FitsHandlingConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_Reb_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.LargeFileObjectAvailableEvent;
import org.lsst.sal.camera.event.LogLevelEvent;
import org.lsst.sal.camera.event.LogMessageEvent;
import org.lsst.sal.camera.event.NotReadyToTakeImageEvent;
import org.lsst.sal.camera.event.PrepareToTakeImageEvent;
import org.lsst.sal.camera.event.Quadbox_BFR_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_BFR_QuadboxConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_24VC_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_24VC_QuadboxConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_24VD_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_24VD_QuadboxConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_48V_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_48V_QuadboxConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_5V_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_5V_QuadboxConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PeriodicTasksConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_REB_Bulk_PS_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_REB_Bulk_PS_QuadboxConfigurationEvent;
import org.lsst.sal.camera.event.ReadyToTakeImageEvent;
import org.lsst.sal.camera.event.RebpowerConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_EmergencyResponseManagerConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_PeriodicTasksConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_RebConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_Reb_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_Rebps_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_Rebps_PowerConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cold1_CompLimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cold1_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cold1_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cold2_CompLimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cold2_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cold2_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_CoolMaq20_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo1_CompLimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo1_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo1_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo2_CompLimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo2_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo2_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo3_CompLimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo3_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo3_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo4_CompLimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo4_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo4_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo5_CompLimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo5_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo5_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo6_CompLimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo6_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo6_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_PeriodicTasksConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.SimulationModeEvent;
import org.lsst.sal.camera.event.SoftwareVersionsEvent;
import org.lsst.sal.camera.event.StartIntegrationEvent;
import org.lsst.sal.camera.event.StartLoadFilterEvent;
import org.lsst.sal.camera.event.StartReadoutEvent;
import org.lsst.sal.camera.event.StartRotateCarouselEvent;
import org.lsst.sal.camera.event.StartSetFilterEvent;
import org.lsst.sal.camera.event.StartShutterCloseEvent;
import org.lsst.sal.camera.event.StartShutterOpenEvent;
import org.lsst.sal.camera.event.StartUnloadFilterEvent;
import org.lsst.sal.camera.event.SummaryStatusEvent;
import org.lsst.sal.camera.event.Vacuum_AgentMonitorServiceConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CIP1CConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CIP1_IConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CIP1_VConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CIP2CConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CIP2_IConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CIP2_VConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CIP3CConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CIP3_IConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CIP3_VConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CIP4CConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CIP4_IConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CIP4_VConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CIP5CConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CIP5_IConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CIP5_VConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CIP6CConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CIP6_IConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CIP6_VConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CryoVacConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CryoVacGaugeConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_ForelineVacConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_ForelineVacGaugeConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_HeartbeatConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_Hex1VacConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_Hex1VacGaugeConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_Hex2VacConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_Hex2VacGaugeConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_IonPumpsConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_Monitor_checkConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_Monitor_publishConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_Monitor_updateConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_RuntimeInfoConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_SchedulersConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_TurboCurrentConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_TurboPowerConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_TurboPumpConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_TurboPumpTempConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_TurboSpeedConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_TurboVacConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_TurboVacGaugeConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_TurboVoltageConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_VacPlutoConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_Vacuum_stateConfigurationEvent;

public class EventSendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = SALCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALEvent testSendReceive(SALEvent item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALEvent> future = executor.submit(() -> sal.getNextEvent(Duration.ofSeconds(10L)));
        try {
            sal.logEvent(item);
            SALEvent sALEvent = future.get(10L, TimeUnit.SECONDS);
            return sALEvent;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveEndReadoutEvent() throws Exception {
        String additionalKeys = "f";
        String additionalValues = "";
        int imagesInSequence = 977;
        String imageName = "kpffmnwkoekwxqcrkm";
        int imageIndex = 389;
        String imageSource = "";
        String imageController = "";
        String imageDate = "udwlsjy";
        int imageNumber = 299;
        double timestampAcquisitionStart = 0.5973697304725647;
        double requestedExposureTime = 0.5855571627616882;
        double timestampEndOfReadout = 0.20897942781448364;
        SALEvent item = this.testSendReceive((SALEvent)new EndReadoutEvent(additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, requestedExposureTime, timestampEndOfReadout));
        Assert.assertTrue((boolean)(item instanceof EndReadoutEvent));
        EndReadoutEvent item_ = (EndReadoutEvent)item;
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)requestedExposureTime, (double)item_.getRequestedExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampEndOfReadout, (double)item_.getTimestampEndOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndTakeImageEvent() throws Exception {
        double timestampTransition = 0.13470983505249023;
        SALEvent item = this.testSendReceive((SALEvent)new EndTakeImageEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndTakeImageEvent));
        EndTakeImageEvent item_ = (EndTakeImageEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartSetFilterEvent() throws Exception {
        String filterName = "";
        String filterType = "";
        SALEvent item = this.testSendReceive((SALEvent)new StartSetFilterEvent(filterName, filterType));
        Assert.assertTrue((boolean)(item instanceof StartSetFilterEvent));
        StartSetFilterEvent item_ = (StartSetFilterEvent)item;
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)filterType, (Object)item_.getFilterType());
    }

    @Test
    public void sendReceiveStartUnloadFilterEvent() throws Exception {
        double timestampTransition = 0.605556845664978;
        SALEvent item = this.testSendReceive((SALEvent)new StartUnloadFilterEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartUnloadFilterEvent));
        StartUnloadFilterEvent item_ = (StartUnloadFilterEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveNotReadyToTakeImageEvent() throws Exception {
        double timestampTransition = 0.5054465532302856;
        SALEvent item = this.testSendReceive((SALEvent)new NotReadyToTakeImageEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof NotReadyToTakeImageEvent));
        NotReadyToTakeImageEvent item_ = (NotReadyToTakeImageEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartShutterCloseEvent() throws Exception {
        double timestampTransition = 0.536258f;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterCloseEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartShutterCloseEvent));
        StartShutterCloseEvent item_ = (StartShutterCloseEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndInitializeGuiderEvent() throws Exception {
        double timestampTransition = 0.13944172859191895;
        SALEvent item = this.testSendReceive((SALEvent)new EndInitializeGuiderEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndInitializeGuiderEvent));
        EndInitializeGuiderEvent item_ = (EndInitializeGuiderEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndShutterCloseEvent() throws Exception {
        double timestampTransition = 0.9737498164176941;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterCloseEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndShutterCloseEvent));
        EndShutterCloseEvent item_ = (EndShutterCloseEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndOfImageTelemetryEvent() throws Exception {
        String additionalKeys = "u";
        String additionalValues = "";
        int imagesInSequence = 874;
        String imageName = "agajcpmljekwkiqzeetslvd";
        int imageIndex = 963;
        String imageSource = "py";
        String imageController = "l";
        String imageDate = "eqgh";
        int imageNumber = 323;
        double timestampAcquisitionStart = 0.13097763061523438;
        double exposureTime = 0.9397023916244507;
        String imageTag = "ovpreprkfuytkjuyhyzwirzilycbyllrzadpaeuerhlvukfvlof";
        double timestampDateObs = 0.8412808775901794;
        double timestampDateEnd = 0.9596447348594666;
        double measuredShutterOpenTime = 0.6999391317367554;
        double darkTime = 0.13643884658813477;
        String emulatedImage = "j";
        SALEvent item = this.testSendReceive((SALEvent)new EndOfImageTelemetryEvent(additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime, imageTag, timestampDateObs, timestampDateEnd, measuredShutterOpenTime, darkTime, emulatedImage));
        Assert.assertTrue((boolean)(item instanceof EndOfImageTelemetryEvent));
        EndOfImageTelemetryEvent item_ = (EndOfImageTelemetryEvent)item;
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)imageTag, (Object)item_.getImageTag());
        Assert.assertEquals((double)timestampDateObs, (double)item_.getTimestampDateObs(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampDateEnd, (double)item_.getTimestampDateEnd(), (double)1.0E-6f);
        Assert.assertEquals((double)measuredShutterOpenTime, (double)item_.getMeasuredShutterOpenTime(), (double)1.0E-6f);
        Assert.assertEquals((double)darkTime, (double)item_.getDarkTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)emulatedImage, (Object)item_.getEmulatedImage());
    }

    @Test
    public void sendReceiveEndUnloadFilterEvent() throws Exception {
        double timestampTransition = 0.5945798754692078;
        SALEvent item = this.testSendReceive((SALEvent)new EndUnloadFilterEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndUnloadFilterEvent));
        EndUnloadFilterEvent item_ = (EndUnloadFilterEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndRotateCarouselEvent() throws Exception {
        double timestampTransition = 0.29523491859436035;
        SALEvent item = this.testSendReceive((SALEvent)new EndRotateCarouselEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndRotateCarouselEvent));
        EndRotateCarouselEvent item_ = (EndRotateCarouselEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartLoadFilterEvent() throws Exception {
        double timestampTransition = 0.6173826456069946;
        SALEvent item = this.testSendReceive((SALEvent)new StartLoadFilterEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartLoadFilterEvent));
        StartLoadFilterEvent item_ = (StartLoadFilterEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveReadyToTakeImageEvent() throws Exception {
        double timestampTransition = 0.4313352704048157;
        SALEvent item = this.testSendReceive((SALEvent)new ReadyToTakeImageEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof ReadyToTakeImageEvent));
        ReadyToTakeImageEvent item_ = (ReadyToTakeImageEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePrepareToTakeImageEvent() throws Exception {
        double timestampTransition = 0.5078532695770264;
        SALEvent item = this.testSendReceive((SALEvent)new PrepareToTakeImageEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof PrepareToTakeImageEvent));
        PrepareToTakeImageEvent item_ = (PrepareToTakeImageEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveCCSConfiguredEvent() throws Exception {
        double timestampTransition = 0.7547609210014343;
        SALEvent item = this.testSendReceive((SALEvent)new CCSConfiguredEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof CCSConfiguredEvent));
        CCSConfiguredEvent item_ = (CCSConfiguredEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndLoadFilterEvent() throws Exception {
        double timestampTransition = 0.347290575504303;
        SALEvent item = this.testSendReceive((SALEvent)new EndLoadFilterEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndLoadFilterEvent));
        EndLoadFilterEvent item_ = (EndLoadFilterEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndShutterOpenEvent() throws Exception {
        double timestampTransition = 0.4391133189201355;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterOpenEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndShutterOpenEvent));
        EndShutterOpenEvent item_ = (EndShutterOpenEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartIntegrationEvent() throws Exception {
        String additionalKeys = "y";
        String additionalValues = "";
        int imagesInSequence = 909;
        String imageName = "fbcksxwvwdpuhjtouisg";
        int imageIndex = 303;
        String imageSource = "tr";
        String imageController = "";
        String imageDate = "qnmenq";
        int imageNumber = 686;
        double timestampAcquisitionStart = 0.7154474854469299;
        double exposureTime = 0.22857189178466797;
        String mode = "s";
        double timeout = 0.38384324312210083;
        SALEvent item = this.testSendReceive((SALEvent)new StartIntegrationEvent(additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime, mode, timeout));
        Assert.assertTrue((boolean)(item instanceof StartIntegrationEvent));
        StartIntegrationEvent item_ = (StartIntegrationEvent)item;
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((double)timeout, (double)item_.getTimeout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndInitializeImageEvent() throws Exception {
        double timestampTransition = 0.05203276872634888;
        SALEvent item = this.testSendReceive((SALEvent)new EndInitializeImageEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndInitializeImageEvent));
        EndInitializeImageEvent item_ = (EndInitializeImageEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndSetFilterEvent() throws Exception {
        String filterName = "d";
        String filterType = "e";
        int filterSlot = 495;
        double filterPosition = 0.28800106048583984;
        SALEvent item = this.testSendReceive((SALEvent)new EndSetFilterEvent(filterName, filterType, filterSlot, filterPosition));
        Assert.assertTrue((boolean)(item instanceof EndSetFilterEvent));
        EndSetFilterEvent item_ = (EndSetFilterEvent)item;
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)filterType, (Object)item_.getFilterType());
        Assert.assertEquals((long)filterSlot, (long)item_.getFilterSlot());
        Assert.assertEquals((double)filterPosition, (double)item_.getFilterPosition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartShutterOpenEvent() throws Exception {
        double timestampTransition = 0.22750800848007202;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterOpenEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartShutterOpenEvent));
        StartShutterOpenEvent item_ = (StartShutterOpenEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAvailableFiltersEvent() throws Exception {
        String filterNames = "xirsmhnddyrhmpolaatatguejjmwmfeoaclwuexojmhlpkystpmanwcangdisqfvxuqwqysiafomtyjrzxwfucnamoaezfanauhnnootuhjusprpmldiutxsqcaageunvdyvuwxmpzbhnnlfaodrmazjfkyewrpjmwrtkaigzuaqyzmyymnpodojhymuggilkxlhgpseuuibuyrlojdhzqoveaoljumwx";
        SALEvent item = this.testSendReceive((SALEvent)new AvailableFiltersEvent(filterNames));
        Assert.assertTrue((boolean)(item instanceof AvailableFiltersEvent));
        AvailableFiltersEvent item_ = (AvailableFiltersEvent)item;
        Assert.assertEquals((Object)filterNames, (Object)item_.getFilterNames());
    }

    @Test
    public void sendReceiveStartReadoutEvent() throws Exception {
        String additionalKeys = "u";
        String additionalValues = "";
        int imagesInSequence = 142;
        String imageName = "orfjzvnqofqitxyuovvualrabkzcmdp";
        int imageIndex = 634;
        String imageSource = "rm";
        String imageController = "b";
        String imageDate = "";
        int imageNumber = 935;
        double timestampAcquisitionStart = 0.263749361038208;
        double exposureTime = 0.8565203547477722;
        double timestampStartOfReadout = 0.6208995580673218;
        SALEvent item = this.testSendReceive((SALEvent)new StartReadoutEvent(additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime, timestampStartOfReadout));
        Assert.assertTrue((boolean)(item instanceof StartReadoutEvent));
        StartReadoutEvent item_ = (StartReadoutEvent)item;
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampStartOfReadout, (double)item_.getTimestampStartOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartRotateCarouselEvent() throws Exception {
        double timestampTransition = 0.5267452597618103;
        SALEvent item = this.testSendReceive((SALEvent)new StartRotateCarouselEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartRotateCarouselEvent));
        StartRotateCarouselEvent item_ = (StartRotateCarouselEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveImageReadoutParametersEvent() throws Exception {
        String imageName = "z";
        String ccdLocation = "";
        String raftBay = "a";
        String ccdSlot = "s";
        Object[] ccdType = new ImageReadoutParametersEvent.CcdType[]{ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V};
        int[] overRows = TestHelper.generateIntArray((int)201, (int)540777305);
        int[] overCols = TestHelper.generateIntArray((int)201, (int)861964373);
        int[] readRows = TestHelper.generateIntArray((int)201, (int)1039945894);
        int[] readCols = TestHelper.generateIntArray((int)201, (int)1453464562);
        int[] readCols2 = TestHelper.generateIntArray((int)201, (int)-944841913);
        int[] preCols = TestHelper.generateIntArray((int)201, (int)-1414909128);
        int[] preRows = TestHelper.generateIntArray((int)201, (int)-1656959271);
        int[] postCols = TestHelper.generateIntArray((int)201, (int)-488729533);
        int[] underCols = TestHelper.generateIntArray((int)201, (int)679431821);
        String daqFolder = "b";
        String daqAnnotation = "v";
        SALEvent item = this.testSendReceive((SALEvent)new ImageReadoutParametersEvent(imageName, ccdLocation, raftBay, ccdSlot, (ImageReadoutParametersEvent.CcdType[])ccdType, overRows, overCols, readRows, readCols, readCols2, preCols, preRows, postCols, underCols, daqFolder, daqAnnotation));
        Assert.assertTrue((boolean)(item instanceof ImageReadoutParametersEvent));
        ImageReadoutParametersEvent item_ = (ImageReadoutParametersEvent)item;
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((Object)ccdLocation, (Object)item_.getCcdLocation());
        Assert.assertEquals((Object)raftBay, (Object)item_.getRaftBay());
        Assert.assertEquals((Object)ccdSlot, (Object)item_.getCcdSlot());
        Assert.assertArrayEquals((Object[])ccdType, (Object[])item_.getCcdType());
        Assert.assertArrayEquals((int[])overRows, (int[])item_.getOverRows());
        Assert.assertArrayEquals((int[])overCols, (int[])item_.getOverCols());
        Assert.assertArrayEquals((int[])readRows, (int[])item_.getReadRows());
        Assert.assertArrayEquals((int[])readCols, (int[])item_.getReadCols());
        Assert.assertArrayEquals((int[])readCols2, (int[])item_.getReadCols2());
        Assert.assertArrayEquals((int[])preCols, (int[])item_.getPreCols());
        Assert.assertArrayEquals((int[])preRows, (int[])item_.getPreRows());
        Assert.assertArrayEquals((int[])postCols, (int[])item_.getPostCols());
        Assert.assertArrayEquals((int[])underCols, (int[])item_.getUnderCols());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)daqAnnotation, (Object)item_.getDaqAnnotation());
    }

    @Test
    public void sendReceiveFocalPlaneSummaryInfoEvent() throws Exception {
        String ccdLocation = "q";
        String raftBay = "q";
        String ccdSlot = "w";
        String rebSerialNumber = "w";
        String rebLSSTName = "";
        String ccdLSSTName = "r";
        String raftLSSTName = "y";
        String ccdManSerNum = "z";
        String ccdManufacturer = "b";
        Object[] ccdType = new FocalPlaneSummaryInfoEvent.CcdType[]{FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL};
        double[] ccdTempSetPoint = TestHelper.generateDoubleArray((int)212, (int)997436211);
        String sequencerKey = "k";
        String sequencerChecksum = "";
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneSummaryInfoEvent(ccdLocation, raftBay, ccdSlot, rebSerialNumber, rebLSSTName, ccdLSSTName, raftLSSTName, ccdManSerNum, ccdManufacturer, (FocalPlaneSummaryInfoEvent.CcdType[])ccdType, ccdTempSetPoint, sequencerKey, sequencerChecksum));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneSummaryInfoEvent));
        FocalPlaneSummaryInfoEvent item_ = (FocalPlaneSummaryInfoEvent)item;
        Assert.assertEquals((Object)ccdLocation, (Object)item_.getCcdLocation());
        Assert.assertEquals((Object)raftBay, (Object)item_.getRaftBay());
        Assert.assertEquals((Object)ccdSlot, (Object)item_.getCcdSlot());
        Assert.assertEquals((Object)rebSerialNumber, (Object)item_.getRebSerialNumber());
        Assert.assertEquals((Object)rebLSSTName, (Object)item_.getRebLSSTName());
        Assert.assertEquals((Object)ccdLSSTName, (Object)item_.getCcdLSSTName());
        Assert.assertEquals((Object)raftLSSTName, (Object)item_.getRaftLSSTName());
        Assert.assertEquals((Object)ccdManSerNum, (Object)item_.getCcdManSerNum());
        Assert.assertEquals((Object)ccdManufacturer, (Object)item_.getCcdManufacturer());
        Assert.assertArrayEquals((Object[])ccdType, (Object[])item_.getCcdType());
        Assert.assertArrayEquals((double[])ccdTempSetPoint, (double[])item_.getCcdTempSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((Object)sequencerKey, (Object)item_.getSequencerKey());
        Assert.assertEquals((Object)sequencerChecksum, (Object)item_.getSequencerChecksum());
    }

    @Test
    public void sendReceiveQuadbox_BFR_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double clean_5_24V_I_warnHi = 0.35989898443222046;
        double clean_5_24V_I_warnLo = 0.22506767511367798;
        double clean_5_24V_I_limitHi = 0.14500826597213745;
        double clean_5_24V_I_limitLo = 0.10195744037628174;
        double dirty_24V_I_warnHi = 0.7472650408744812;
        double dirty_24V_I_warnLo = 0.7284701466560364;
        double dirty_24V_I_limitHi = 0.5455885529518127;
        double dirty_24V_I_limitLo = 0.8110129237174988;
        double dirty_28V_I_warnHi = 0.19291293621063232;
        double dirty_28V_I_warnLo = 0.7421621084213257;
        double dirty_28V_I_limitHi = 0.09804767370223999;
        double dirty_28V_I_limitLo = 0.4464316964149475;
        double dirty_48V_I_warnHi = 0.3112324f;
        double dirty_48V_I_warnLo = 0.15415281057357788;
        double dirty_48V_I_limitHi = 0.6058251857757568;
        double dirty_48V_I_limitLo = 0.10584050416946411;
        double heater_I_warnHi = 0.8688523173332214;
        double heater_I_warnLo = 0.05147433280944824;
        double heater_I_limitHi = 0.7004167437553406;
        double heater_I_limitLo = 0.6102726459503174;
        double protection_I_warnHi = 0.16373854875564575;
        double protection_I_warnLo = 0.2257222f;
        double protection_I_limitHi = 0.6810241937637329;
        double protection_I_limitLo = 0.1661999225616455;
        double rebps_0_2_I_warnHi = 0.9088693857192993;
        double rebps_0_2_I_warnLo = 0.11945706605911255;
        double rebps_0_2_I_limitHi = 0.2741441f;
        double rebps_0_2_I_limitLo = 0.766837f;
        double rebps_3_5_I_warnHi = 0.7217692732810974;
        double rebps_3_5_I_warnLo = 0.5272254347801208;
        double rebps_3_5_I_limitHi = 0.7229553461074829;
        double rebps_3_5_I_limitLo = 0.9956062436103821;
        double rebps_6_8_I_warnHi = 0.9965223670005798;
        double rebps_6_8_I_warnLo = 0.14721661806106567;
        double rebps_6_8_I_limitHi = 0.4042872190475464;
        double rebps_6_8_I_limitLo = 0.6199347376823425;
        double rebps_9_12_I_warnHi = 0.746765673160553;
        double rebps_9_12_I_warnLo = 0.9629706144332886;
        double rebps_9_12_I_limitHi = 0.8263643383979797;
        double rebps_9_12_I_limitLo = 0.6142929196357727;
        double rebps_Spr_I_warnHi = 0.6880226731300354;
        double rebps_Spr_I_warnLo = 0.6466214656829834;
        double rebps_Spr_I_limitHi = 0.6851903200149536;
        double rebps_Spr_I_limitLo = 0.41917216777801514;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_BFR_LimitsConfigurationEvent(version, clean_5_24V_I_warnHi, clean_5_24V_I_warnLo, clean_5_24V_I_limitHi, clean_5_24V_I_limitLo, dirty_24V_I_warnHi, dirty_24V_I_warnLo, dirty_24V_I_limitHi, dirty_24V_I_limitLo, dirty_28V_I_warnHi, dirty_28V_I_warnLo, dirty_28V_I_limitHi, dirty_28V_I_limitLo, dirty_48V_I_warnHi, dirty_48V_I_warnLo, dirty_48V_I_limitHi, dirty_48V_I_limitLo, heater_I_warnHi, heater_I_warnLo, heater_I_limitHi, heater_I_limitLo, protection_I_warnHi, protection_I_warnLo, protection_I_limitHi, protection_I_limitLo, rebps_0_2_I_warnHi, rebps_0_2_I_warnLo, rebps_0_2_I_limitHi, rebps_0_2_I_limitLo, rebps_3_5_I_warnHi, rebps_3_5_I_warnLo, rebps_3_5_I_limitHi, rebps_3_5_I_limitLo, rebps_6_8_I_warnHi, rebps_6_8_I_warnLo, rebps_6_8_I_limitHi, rebps_6_8_I_limitLo, rebps_9_12_I_warnHi, rebps_9_12_I_warnLo, rebps_9_12_I_limitHi, rebps_9_12_I_limitLo, rebps_Spr_I_warnHi, rebps_Spr_I_warnLo, rebps_Spr_I_limitHi, rebps_Spr_I_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFR_LimitsConfigurationEvent));
        Quadbox_BFR_LimitsConfigurationEvent item_ = (Quadbox_BFR_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)clean_5_24V_I_warnHi, (double)item_.getClean_5_24V_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)clean_5_24V_I_warnLo, (double)item_.getClean_5_24V_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)clean_5_24V_I_limitHi, (double)item_.getClean_5_24V_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)clean_5_24V_I_limitLo, (double)item_.getClean_5_24V_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I_warnHi, (double)item_.getDirty_24V_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I_warnLo, (double)item_.getDirty_24V_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I_limitHi, (double)item_.getDirty_24V_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I_limitLo, (double)item_.getDirty_24V_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I_warnHi, (double)item_.getDirty_28V_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I_warnLo, (double)item_.getDirty_28V_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I_limitHi, (double)item_.getDirty_28V_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I_limitLo, (double)item_.getDirty_28V_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I_warnHi, (double)item_.getDirty_48V_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I_warnLo, (double)item_.getDirty_48V_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I_limitHi, (double)item_.getDirty_48V_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I_limitLo, (double)item_.getDirty_48V_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)heater_I_warnHi, (double)item_.getHeater_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)heater_I_warnLo, (double)item_.getHeater_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)heater_I_limitHi, (double)item_.getHeater_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)heater_I_limitLo, (double)item_.getHeater_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I_warnHi, (double)item_.getProtection_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I_warnLo, (double)item_.getProtection_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I_limitHi, (double)item_.getProtection_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I_limitLo, (double)item_.getProtection_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_2_I_warnHi, (double)item_.getRebps_0_2_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_2_I_warnLo, (double)item_.getRebps_0_2_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_2_I_limitHi, (double)item_.getRebps_0_2_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_2_I_limitLo, (double)item_.getRebps_0_2_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_3_5_I_warnHi, (double)item_.getRebps_3_5_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_3_5_I_warnLo, (double)item_.getRebps_3_5_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_3_5_I_limitHi, (double)item_.getRebps_3_5_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_3_5_I_limitLo, (double)item_.getRebps_3_5_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_6_8_I_warnHi, (double)item_.getRebps_6_8_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_6_8_I_warnLo, (double)item_.getRebps_6_8_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_6_8_I_limitHi, (double)item_.getRebps_6_8_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_6_8_I_limitLo, (double)item_.getRebps_6_8_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_9_12_I_warnHi, (double)item_.getRebps_9_12_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_9_12_I_warnLo, (double)item_.getRebps_9_12_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_9_12_I_limitHi, (double)item_.getRebps_9_12_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_9_12_I_limitLo, (double)item_.getRebps_9_12_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_Spr_I_warnHi, (double)item_.getRebps_Spr_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_Spr_I_warnLo, (double)item_.getRebps_Spr_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_Spr_I_limitHi, (double)item_.getRebps_Spr_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_Spr_I_limitLo, (double)item_.getRebps_Spr_I_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_BFR_QuadboxConfigurationEvent() throws Exception {
        String version = "g";
        int node = 269;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_BFR_QuadboxConfigurationEvent(version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFR_QuadboxConfigurationEvent));
        Quadbox_BFR_QuadboxConfigurationEvent item_ = (Quadbox_BFR_QuadboxConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VC_LimitsConfigurationEvent() throws Exception {
        String version = "x";
        double n_24vc_Board_T_warnHi = 0.4870149f;
        double n_24vc_Board_T_warnLo = 0.22898507118225098;
        double n_24vc_Board_T_limitHi = 0.6373441815376282;
        double n_24vc_Board_T_limitLo = 0.6345996856689453;
        double n_24vc_FPGA_T_warnHi = 0.276350736618042;
        double n_24vc_FPGA_T_warnLo = 0.5662907958030701;
        double n_24vc_FPGA_T_limitHi = 0.4810322f;
        double n_24vc_FPGA_T_limitLo = 0.17140984535217285;
        double n_24vc_Main_I_warnHi = 0.2860983610153198;
        double n_24vc_Main_I_warnLo = 0.2018665075302124;
        double n_24vc_Main_I_limitHi = 0.8623965978622437;
        double n_24vc_Main_I_limitLo = 0.2078021764755249;
        double n_24vc_Main_T_warnHi = 0.027436554431915283;
        double n_24vc_Main_T_warnLo = 0.3213622570037842;
        double n_24vc_Main_T_limitHi = 0.8489788770675659;
        double n_24vc_Main_T_limitLo = 0.17418742179870605;
        double n_24vc_Main_V_warnHi = 0.08984065055847168;
        double n_24vc_Main_V_warnLo = 0.4241867661476135;
        double n_24vc_Main_V_limitHi = 0.9418308734893799;
        double n_24vc_Main_V_limitLo = 0.9684880375862122;
        double body_Purge_I_warnHi = 0.9527187347412109;
        double body_Purge_I_warnLo = 0.18455815315246582;
        double body_Purge_I_limitHi = 0.6065274477005005;
        double body_Purge_I_limitLo = 0.4981291890144348;
        double body_Purge_V_warnHi = 0.8888053894042969;
        double body_Purge_V_warnLo = 0.24716395139694214;
        double body_Purge_V_limitHi = 0.18402493000030518;
        double body_Purge_V_limitLo = 0.9244294762611389;
        double bpu_Maq20_I_warnHi = 0.7530982494354248;
        double bpu_Maq20_I_warnLo = 0.6354634165763855;
        double bpu_Maq20_I_limitHi = 0.11419862508773804;
        double bpu_Maq20_I_limitLo = 0.06763821840286255;
        double bpu_Maq20_V_warnHi = 0.15208107233047485;
        double bpu_Maq20_V_warnLo = 0.502015f;
        double bpu_Maq20_V_limitHi = 0.4687958359718323;
        double bpu_Maq20_V_limitLo = 0.2776569128036499;
        double fes_Shu_HCU_I_warnHi = 0.8017957806587219;
        double fes_Shu_HCU_I_warnLo = 0.646397590637207;
        double fes_Shu_HCU_I_limitHi = 0.11037266254425049;
        double fes_Shu_HCU_I_limitLo = 0.4113478f;
        double fes_Shu_HCU_V_warnHi = 0.2250347137451172;
        double fes_Shu_HCU_V_warnLo = 0.3065752387046814;
        double fes_Shu_HCU_V_limitHi = 0.4486308693885803;
        double fes_Shu_HCU_V_limitLo = 0.5043429136276245;
        double gauges_I_warnHi = 0.11318850517272949;
        double gauges_I_warnLo = 0.511311f;
        double gauges_I_limitHi = 0.8501695990562439;
        double gauges_I_limitLo = 0.10861527919769287;
        double gauges_V_warnHi = 0.13340067863464355;
        double gauges_V_warnLo = 0.909978985786438;
        double gauges_V_limitHi = 0.632366418838501;
        double gauges_V_limitLo = 0.8650884032249451;
        double ion_Pumps_I_warnHi = 0.033549726009368896;
        double ion_Pumps_I_warnLo = 0.6954838037490845;
        double ion_Pumps_I_limitHi = 0.11287665367126465;
        double ion_Pumps_I_limitLo = 0.674673318862915;
        double ion_Pumps_V_warnHi = 0.06375402212142944;
        double ion_Pumps_V_warnLo = 0.5577300786972046;
        double ion_Pumps_V_limitHi = 0.0346936f;
        double ion_Pumps_V_limitLo = 0.25591927766799927;
        double pwr_Cry_HCU_I_warnHi = 0.861728f;
        double pwr_Cry_HCU_I_warnLo = 0.6790806651115417;
        double pwr_Cry_HCU_I_limitHi = 0.500071f;
        double pwr_Cry_HCU_I_limitLo = 0.0706256628036499;
        double pwr_Cry_HCU_V_warnHi = 0.5492081046104431;
        double pwr_Cry_HCU_V_warnLo = 0.5675011873245239;
        double pwr_Cry_HCU_V_limitHi = 0.2477231f;
        double pwr_Cry_HCU_V_limitLo = 0.6511227488517761;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VC_LimitsConfigurationEvent(version, n_24vc_Board_T_warnHi, n_24vc_Board_T_warnLo, n_24vc_Board_T_limitHi, n_24vc_Board_T_limitLo, n_24vc_FPGA_T_warnHi, n_24vc_FPGA_T_warnLo, n_24vc_FPGA_T_limitHi, n_24vc_FPGA_T_limitLo, n_24vc_Main_I_warnHi, n_24vc_Main_I_warnLo, n_24vc_Main_I_limitHi, n_24vc_Main_I_limitLo, n_24vc_Main_T_warnHi, n_24vc_Main_T_warnLo, n_24vc_Main_T_limitHi, n_24vc_Main_T_limitLo, n_24vc_Main_V_warnHi, n_24vc_Main_V_warnLo, n_24vc_Main_V_limitHi, n_24vc_Main_V_limitLo, body_Purge_I_warnHi, body_Purge_I_warnLo, body_Purge_I_limitHi, body_Purge_I_limitLo, body_Purge_V_warnHi, body_Purge_V_warnLo, body_Purge_V_limitHi, body_Purge_V_limitLo, bpu_Maq20_I_warnHi, bpu_Maq20_I_warnLo, bpu_Maq20_I_limitHi, bpu_Maq20_I_limitLo, bpu_Maq20_V_warnHi, bpu_Maq20_V_warnLo, bpu_Maq20_V_limitHi, bpu_Maq20_V_limitLo, fes_Shu_HCU_I_warnHi, fes_Shu_HCU_I_warnLo, fes_Shu_HCU_I_limitHi, fes_Shu_HCU_I_limitLo, fes_Shu_HCU_V_warnHi, fes_Shu_HCU_V_warnLo, fes_Shu_HCU_V_limitHi, fes_Shu_HCU_V_limitLo, gauges_I_warnHi, gauges_I_warnLo, gauges_I_limitHi, gauges_I_limitLo, gauges_V_warnHi, gauges_V_warnLo, gauges_V_limitHi, gauges_V_limitLo, ion_Pumps_I_warnHi, ion_Pumps_I_warnLo, ion_Pumps_I_limitHi, ion_Pumps_I_limitLo, ion_Pumps_V_warnHi, ion_Pumps_V_warnLo, ion_Pumps_V_limitHi, ion_Pumps_V_limitLo, pwr_Cry_HCU_I_warnHi, pwr_Cry_HCU_I_warnLo, pwr_Cry_HCU_I_limitHi, pwr_Cry_HCU_I_limitLo, pwr_Cry_HCU_V_warnHi, pwr_Cry_HCU_V_warnLo, pwr_Cry_HCU_V_limitHi, pwr_Cry_HCU_V_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VC_LimitsConfigurationEvent));
        Quadbox_PDU_24VC_LimitsConfigurationEvent item_ = (Quadbox_PDU_24VC_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)n_24vc_Board_T_warnHi, (double)item_.getN_24vc_Board_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Board_T_warnLo, (double)item_.getN_24vc_Board_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Board_T_limitHi, (double)item_.getN_24vc_Board_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Board_T_limitLo, (double)item_.getN_24vc_Board_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_FPGA_T_warnHi, (double)item_.getN_24vc_FPGA_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_FPGA_T_warnLo, (double)item_.getN_24vc_FPGA_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_FPGA_T_limitHi, (double)item_.getN_24vc_FPGA_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_FPGA_T_limitLo, (double)item_.getN_24vc_FPGA_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_I_warnHi, (double)item_.getN_24vc_Main_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_I_warnLo, (double)item_.getN_24vc_Main_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_I_limitHi, (double)item_.getN_24vc_Main_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_I_limitLo, (double)item_.getN_24vc_Main_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_T_warnHi, (double)item_.getN_24vc_Main_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_T_warnLo, (double)item_.getN_24vc_Main_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_T_limitHi, (double)item_.getN_24vc_Main_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_T_limitLo, (double)item_.getN_24vc_Main_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_V_warnHi, (double)item_.getN_24vc_Main_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_V_warnLo, (double)item_.getN_24vc_Main_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_V_limitHi, (double)item_.getN_24vc_Main_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_V_limitLo, (double)item_.getN_24vc_Main_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_I_warnHi, (double)item_.getBody_Purge_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_I_warnLo, (double)item_.getBody_Purge_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_I_limitHi, (double)item_.getBody_Purge_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_I_limitLo, (double)item_.getBody_Purge_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_V_warnHi, (double)item_.getBody_Purge_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_V_warnLo, (double)item_.getBody_Purge_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_V_limitHi, (double)item_.getBody_Purge_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_V_limitLo, (double)item_.getBody_Purge_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_I_warnHi, (double)item_.getBpu_Maq20_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_I_warnLo, (double)item_.getBpu_Maq20_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_I_limitHi, (double)item_.getBpu_Maq20_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_I_limitLo, (double)item_.getBpu_Maq20_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_V_warnHi, (double)item_.getBpu_Maq20_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_V_warnLo, (double)item_.getBpu_Maq20_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_V_limitHi, (double)item_.getBpu_Maq20_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_V_limitLo, (double)item_.getBpu_Maq20_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_I_warnHi, (double)item_.getFes_Shu_HCU_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_I_warnLo, (double)item_.getFes_Shu_HCU_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_I_limitHi, (double)item_.getFes_Shu_HCU_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_I_limitLo, (double)item_.getFes_Shu_HCU_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_V_warnHi, (double)item_.getFes_Shu_HCU_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_V_warnLo, (double)item_.getFes_Shu_HCU_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_V_limitHi, (double)item_.getFes_Shu_HCU_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_V_limitLo, (double)item_.getFes_Shu_HCU_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I_warnHi, (double)item_.getGauges_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I_warnLo, (double)item_.getGauges_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I_limitHi, (double)item_.getGauges_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I_limitLo, (double)item_.getGauges_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V_warnHi, (double)item_.getGauges_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V_warnLo, (double)item_.getGauges_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V_limitHi, (double)item_.getGauges_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V_limitLo, (double)item_.getGauges_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I_warnHi, (double)item_.getIon_Pumps_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I_warnLo, (double)item_.getIon_Pumps_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I_limitHi, (double)item_.getIon_Pumps_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I_limitLo, (double)item_.getIon_Pumps_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V_warnHi, (double)item_.getIon_Pumps_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V_warnLo, (double)item_.getIon_Pumps_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V_limitHi, (double)item_.getIon_Pumps_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V_limitLo, (double)item_.getIon_Pumps_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_I_warnHi, (double)item_.getPwr_Cry_HCU_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_I_warnLo, (double)item_.getPwr_Cry_HCU_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_I_limitHi, (double)item_.getPwr_Cry_HCU_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_I_limitLo, (double)item_.getPwr_Cry_HCU_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_V_warnHi, (double)item_.getPwr_Cry_HCU_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_V_warnLo, (double)item_.getPwr_Cry_HCU_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_V_limitHi, (double)item_.getPwr_Cry_HCU_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_V_limitLo, (double)item_.getPwr_Cry_HCU_V_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VC_QuadboxConfigurationEvent() throws Exception {
        String version = "";
        int node = 565;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VC_QuadboxConfigurationEvent(version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VC_QuadboxConfigurationEvent));
        Quadbox_PDU_24VC_QuadboxConfigurationEvent item_ = (Quadbox_PDU_24VC_QuadboxConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VD_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double n_24vd_Board_T_warnHi = 0.5684199333190918;
        double n_24vd_Board_T_warnLo = 0.1792144775390625;
        double n_24vd_Board_T_limitHi = 0.420258f;
        double n_24vd_Board_T_limitLo = 0.24494272470474243;
        double n_24vd_FPGA_T_warnHi = 0.3861231803894043;
        double n_24vd_FPGA_T_warnLo = 0.47374796867370605;
        double n_24vd_FPGA_T_limitHi = 0.32380956411361694;
        double n_24vd_FPGA_T_limitLo = 0.34402942657470703;
        double n_24vd_Main_I_warnHi = 0.40112733840942383;
        double n_24vd_Main_I_warnLo = 0.4736320972442627;
        double n_24vd_Main_I_limitHi = 0.6918114423751831;
        double n_24vd_Main_I_limitLo = 0.963251531124115;
        double n_24vd_Main_T_warnHi = 0.18191653490066528;
        double n_24vd_Main_T_warnLo = 0.16838771104812622;
        double n_24vd_Main_T_limitHi = 0.9623038172721863;
        double n_24vd_Main_T_limitLo = 0.15011334419250488;
        double n_24vd_Main_V_warnHi = 0.48530107736587524;
        double n_24vd_Main_V_warnLo = 0.4137721657752991;
        double n_24vd_Main_V_limitHi = 0.0766598f;
        double n_24vd_Main_V_limitLo = 0.7253578305244446;
        double cryo_Turbo_I_warnHi = 0.1221545934677124;
        double cryo_Turbo_I_warnLo = 0.779416024684906;
        double cryo_Turbo_I_limitHi = 0.2768756151199341;
        double cryo_Turbo_I_limitLo = 0.4441349506378174;
        double cryo_Turbo_V_warnHi = 0.5148841738700867;
        double cryo_Turbo_V_warnLo = 0.00691455602645874;
        double cryo_Turbo_V_limitHi = 0.5889905095100403;
        double cryo_Turbo_V_limitLo = 0.862678587436676;
        double hex_Turbo_I_warnHi = 0.759788f;
        double hex_Turbo_I_warnLo = 0.24051225185394287;
        double hex_Turbo_I_limitHi = 0.5518115162849426;
        double hex_Turbo_I_limitLo = 0.5088573098182678;
        double hex_Turbo_V_warnHi = 0.8950796723365784;
        double hex_Turbo_V_warnLo = 0.17582905292510986;
        double hex_Turbo_V_limitHi = 0.26496803760528564;
        double hex_Turbo_V_limitLo = 0.4779793620109558;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VD_LimitsConfigurationEvent(version, n_24vd_Board_T_warnHi, n_24vd_Board_T_warnLo, n_24vd_Board_T_limitHi, n_24vd_Board_T_limitLo, n_24vd_FPGA_T_warnHi, n_24vd_FPGA_T_warnLo, n_24vd_FPGA_T_limitHi, n_24vd_FPGA_T_limitLo, n_24vd_Main_I_warnHi, n_24vd_Main_I_warnLo, n_24vd_Main_I_limitHi, n_24vd_Main_I_limitLo, n_24vd_Main_T_warnHi, n_24vd_Main_T_warnLo, n_24vd_Main_T_limitHi, n_24vd_Main_T_limitLo, n_24vd_Main_V_warnHi, n_24vd_Main_V_warnLo, n_24vd_Main_V_limitHi, n_24vd_Main_V_limitLo, cryo_Turbo_I_warnHi, cryo_Turbo_I_warnLo, cryo_Turbo_I_limitHi, cryo_Turbo_I_limitLo, cryo_Turbo_V_warnHi, cryo_Turbo_V_warnLo, cryo_Turbo_V_limitHi, cryo_Turbo_V_limitLo, hex_Turbo_I_warnHi, hex_Turbo_I_warnLo, hex_Turbo_I_limitHi, hex_Turbo_I_limitLo, hex_Turbo_V_warnHi, hex_Turbo_V_warnLo, hex_Turbo_V_limitHi, hex_Turbo_V_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VD_LimitsConfigurationEvent));
        Quadbox_PDU_24VD_LimitsConfigurationEvent item_ = (Quadbox_PDU_24VD_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)n_24vd_Board_T_warnHi, (double)item_.getN_24vd_Board_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Board_T_warnLo, (double)item_.getN_24vd_Board_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Board_T_limitHi, (double)item_.getN_24vd_Board_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Board_T_limitLo, (double)item_.getN_24vd_Board_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_FPGA_T_warnHi, (double)item_.getN_24vd_FPGA_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_FPGA_T_warnLo, (double)item_.getN_24vd_FPGA_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_FPGA_T_limitHi, (double)item_.getN_24vd_FPGA_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_FPGA_T_limitLo, (double)item_.getN_24vd_FPGA_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_I_warnHi, (double)item_.getN_24vd_Main_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_I_warnLo, (double)item_.getN_24vd_Main_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_I_limitHi, (double)item_.getN_24vd_Main_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_I_limitLo, (double)item_.getN_24vd_Main_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_T_warnHi, (double)item_.getN_24vd_Main_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_T_warnLo, (double)item_.getN_24vd_Main_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_T_limitHi, (double)item_.getN_24vd_Main_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_T_limitLo, (double)item_.getN_24vd_Main_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_V_warnHi, (double)item_.getN_24vd_Main_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_V_warnLo, (double)item_.getN_24vd_Main_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_V_limitHi, (double)item_.getN_24vd_Main_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_V_limitLo, (double)item_.getN_24vd_Main_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I_warnHi, (double)item_.getCryo_Turbo_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I_warnLo, (double)item_.getCryo_Turbo_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I_limitHi, (double)item_.getCryo_Turbo_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I_limitLo, (double)item_.getCryo_Turbo_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V_warnHi, (double)item_.getCryo_Turbo_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V_warnLo, (double)item_.getCryo_Turbo_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V_limitHi, (double)item_.getCryo_Turbo_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V_limitLo, (double)item_.getCryo_Turbo_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_I_warnHi, (double)item_.getHex_Turbo_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_I_warnLo, (double)item_.getHex_Turbo_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_I_limitHi, (double)item_.getHex_Turbo_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_I_limitLo, (double)item_.getHex_Turbo_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_V_warnHi, (double)item_.getHex_Turbo_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_V_warnLo, (double)item_.getHex_Turbo_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_V_limitHi, (double)item_.getHex_Turbo_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_V_limitLo, (double)item_.getHex_Turbo_V_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VD_QuadboxConfigurationEvent() throws Exception {
        String version = "";
        int node = 330;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VD_QuadboxConfigurationEvent(version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VD_QuadboxConfigurationEvent));
        Quadbox_PDU_24VD_QuadboxConfigurationEvent item_ = (Quadbox_PDU_24VD_QuadboxConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_PDU_48V_LimitsConfigurationEvent() throws Exception {
        String version = "o";
        double n_48v_Board_T_warnHi = 0.30979394912719727;
        double n_48v_Board_T_warnLo = 0.21112632751464844;
        double n_48v_Board_T_limitHi = 0.3359434f;
        double n_48v_Board_T_limitLo = 0.147347092628479;
        double n_48v_FPGA_T_warnHi = 0.9024807214736938;
        double n_48v_FPGA_T_warnLo = 0.9873150587081909;
        double n_48v_FPGA_T_limitHi = 0.7804882526397705;
        double n_48v_FPGA_T_limitLo = 0.21205365657806396;
        double n_48v_Main_I_warnHi = 0.19770705699920654;
        double n_48v_Main_I_warnLo = 0.0017998814582824707;
        double n_48v_Main_I_limitHi = 0.893978476524353;
        double n_48v_Main_I_limitLo = 0.5026865005493164;
        double n_48v_Main_T_warnHi = 0.2176659107208252;
        double n_48v_Main_T_warnLo = 0.6090694069862366;
        double n_48v_Main_T_limitHi = 0.9734766483306885;
        double n_48v_Main_T_limitLo = 0.8928537964820862;
        double n_48v_Main_V_warnHi = 0.0497211217880249;
        double n_48v_Main_V_warnLo = 0.2681116461753845;
        double n_48v_Main_V_limitHi = 0.529084324836731;
        double n_48v_Main_V_limitLo = 0.05878615379333496;
        double purge_Fan_I_warnHi = 0.5883772969245911;
        double purge_Fan_I_warnLo = 0.6124424338340759;
        double purge_Fan_I_limitHi = 0.928119f;
        double purge_Fan_I_limitLo = 0.25203055143356323;
        double purge_Fan_V_warnHi = 0.23448187112808228;
        double purge_Fan_V_warnLo = 0.06101113557815552;
        double purge_Fan_V_limitHi = 0.2818338871002197;
        double purge_Fan_V_limitLo = 0.35309863090515137;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_48V_LimitsConfigurationEvent(version, n_48v_Board_T_warnHi, n_48v_Board_T_warnLo, n_48v_Board_T_limitHi, n_48v_Board_T_limitLo, n_48v_FPGA_T_warnHi, n_48v_FPGA_T_warnLo, n_48v_FPGA_T_limitHi, n_48v_FPGA_T_limitLo, n_48v_Main_I_warnHi, n_48v_Main_I_warnLo, n_48v_Main_I_limitHi, n_48v_Main_I_limitLo, n_48v_Main_T_warnHi, n_48v_Main_T_warnLo, n_48v_Main_T_limitHi, n_48v_Main_T_limitLo, n_48v_Main_V_warnHi, n_48v_Main_V_warnLo, n_48v_Main_V_limitHi, n_48v_Main_V_limitLo, purge_Fan_I_warnHi, purge_Fan_I_warnLo, purge_Fan_I_limitHi, purge_Fan_I_limitLo, purge_Fan_V_warnHi, purge_Fan_V_warnLo, purge_Fan_V_limitHi, purge_Fan_V_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48V_LimitsConfigurationEvent));
        Quadbox_PDU_48V_LimitsConfigurationEvent item_ = (Quadbox_PDU_48V_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)n_48v_Board_T_warnHi, (double)item_.getN_48v_Board_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Board_T_warnLo, (double)item_.getN_48v_Board_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Board_T_limitHi, (double)item_.getN_48v_Board_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Board_T_limitLo, (double)item_.getN_48v_Board_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_FPGA_T_warnHi, (double)item_.getN_48v_FPGA_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_FPGA_T_warnLo, (double)item_.getN_48v_FPGA_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_FPGA_T_limitHi, (double)item_.getN_48v_FPGA_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_FPGA_T_limitLo, (double)item_.getN_48v_FPGA_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_I_warnHi, (double)item_.getN_48v_Main_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_I_warnLo, (double)item_.getN_48v_Main_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_I_limitHi, (double)item_.getN_48v_Main_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_I_limitLo, (double)item_.getN_48v_Main_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_T_warnHi, (double)item_.getN_48v_Main_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_T_warnLo, (double)item_.getN_48v_Main_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_T_limitHi, (double)item_.getN_48v_Main_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_T_limitLo, (double)item_.getN_48v_Main_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_V_warnHi, (double)item_.getN_48v_Main_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_V_warnLo, (double)item_.getN_48v_Main_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_V_limitHi, (double)item_.getN_48v_Main_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_V_limitLo, (double)item_.getN_48v_Main_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_I_warnHi, (double)item_.getPurge_Fan_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_I_warnLo, (double)item_.getPurge_Fan_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_I_limitHi, (double)item_.getPurge_Fan_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_I_limitLo, (double)item_.getPurge_Fan_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_V_warnHi, (double)item_.getPurge_Fan_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_V_warnLo, (double)item_.getPurge_Fan_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_V_limitHi, (double)item_.getPurge_Fan_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_V_limitLo, (double)item_.getPurge_Fan_V_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_48V_QuadboxConfigurationEvent() throws Exception {
        String version = "e";
        int node = 402;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_48V_QuadboxConfigurationEvent(version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48V_QuadboxConfigurationEvent));
        Quadbox_PDU_48V_QuadboxConfigurationEvent item_ = (Quadbox_PDU_48V_QuadboxConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_PDU_5V_LimitsConfigurationEvent() throws Exception {
        String version = "z";
        double otm_0_A_I_warnHi = 0.8635683059692383;
        double otm_0_A_I_warnLo = 0.525514f;
        double otm_0_A_I_limitHi = 0.4517327547073364;
        double otm_0_A_I_limitLo = 0.9946938753128052;
        double otm_0_A_V_warnHi = 0.11279827356338501;
        double otm_0_A_V_warnLo = 0.8843053579330444;
        double otm_0_A_V_limitHi = 0.9963942170143127;
        double otm_0_A_V_limitLo = 0.4767602f;
        double otm_0_B_I_warnHi = 0.7324386835098267;
        double otm_0_B_I_warnLo = 0.0687408447265625;
        double otm_0_B_I_limitHi = 0.14175671339035034;
        double otm_0_B_I_limitLo = 0.2010408f;
        double otm_0_B_V_warnHi = 0.16168522834777832;
        double otm_0_B_V_warnLo = 0.02596902847290039;
        double otm_0_B_V_limitHi = 0.35271936655044556;
        double otm_0_B_V_limitLo = 0.522193193435669;
        double otm_1_A_I_warnHi = 0.05116891860961914;
        double otm_1_A_I_warnLo = 0.8524715900421143;
        double otm_1_A_I_limitHi = 0.677761971950531;
        double otm_1_A_I_limitLo = 0.6856864094734192;
        double otm_1_A_V_warnHi = 0.15195822715759277;
        double otm_1_A_V_warnLo = 0.7192482352256775;
        double otm_1_A_V_limitHi = 0.8364443778991699;
        double otm_1_A_V_limitLo = 0.161748468875885;
        double otm_1_B_I_warnHi = 0.6321895122528076;
        double otm_1_B_I_warnLo = 0.10460102558135986;
        double otm_1_B_I_limitHi = 0.7797408103942871;
        double otm_1_B_I_limitLo = 0.7016832828521729;
        double otm_1_B_V_warnHi = 0.0922970175743103;
        double otm_1_B_V_warnLo = 0.8619933128356934;
        double otm_1_B_V_limitHi = 0.3623538017272949;
        double otm_1_B_V_limitLo = 0.33647865056991577;
        double otm_2_A_I_warnHi = 0.10063028335571289;
        double otm_2_A_I_warnLo = 0.710841f;
        double otm_2_A_I_limitHi = 0.6896804571151733;
        double otm_2_A_I_limitLo = 0.4579014182090759;
        double otm_2_A_V_warnHi = 0.2700703740119934;
        double otm_2_A_V_warnLo = 0.27534347772598267;
        double otm_2_A_V_limitHi = 0.5729556679725647;
        double otm_2_A_V_limitLo = 0.8949098587036133;
        double otm_2_B_I_warnHi = 0.7206348180770874;
        double otm_2_B_I_warnLo = 0.8623384237289429;
        double otm_2_B_I_limitHi = 0.4858793616294861;
        double otm_2_B_I_limitLo = 0.45777201652526855;
        double otm_2_B_V_warnHi = 0.5911467671394348;
        double otm_2_B_V_warnLo = 0.393549382686615;
        double otm_2_B_V_limitHi = 0.6219715476036072;
        double otm_2_B_V_limitLo = 0.40645831823349;
        double otm_3_A_I_warnHi = 0.0836363434791565;
        double otm_3_A_I_warnLo = 0.748494029045105;
        double otm_3_A_I_limitHi = 0.5268413424491882;
        double otm_3_A_I_limitLo = 0.29950016736984253;
        double otm_3_A_V_warnHi = 0.24664908647537231;
        double otm_3_A_V_warnLo = 0.767871618270874;
        double otm_3_A_V_limitHi = 0.2619808316230774;
        double otm_3_A_V_limitLo = 0.48851585388183594;
        double otm_3_B_I_warnHi = 0.3681f;
        double otm_3_B_I_warnLo = 0.177703857421875;
        double otm_3_B_I_limitHi = 0.8507076501846313;
        double otm_3_B_I_limitLo = 0.3890703320503235;
        double otm_3_B_V_warnHi = 0.8853934407234192;
        double otm_3_B_V_warnLo = 0.16424894332885742;
        double otm_3_B_V_limitHi = 0.582197368144989;
        double otm_3_B_V_limitLo = 0.5306582450866699;
        double otm_4_A_I_warnHi = 0.2015218734741211;
        double otm_4_A_I_warnLo = 0.5292513370513916;
        double otm_4_A_I_limitHi = 0.5915347337722778;
        double otm_4_A_I_limitLo = 0.17069f;
        double otm_4_A_V_warnHi = 0.6826686859130859;
        double otm_4_A_V_warnLo = 0.6330636143684387;
        double otm_4_A_V_limitHi = 0.49333226680755615;
        double otm_4_A_V_limitLo = 0.05587393045425415;
        double otm_4_B_I_warnHi = 0.5080180764198303;
        double otm_4_B_I_warnLo = 0.3663373f;
        double otm_4_B_I_limitHi = 0.9903306365013123;
        double otm_4_B_I_limitLo = 0.28888654708862305;
        double otm_4_B_V_warnHi = 0.43917596340179443;
        double otm_4_B_V_warnLo = 0.4342119097709656;
        double otm_4_B_V_limitHi = 0.5887249112129211;
        double otm_4_B_V_limitLo = 0.47140854597091675;
        double otm_5_A_I_warnHi = 0.10862231254577637;
        double otm_5_A_I_warnLo = 0.3732417821884155;
        double otm_5_A_I_limitHi = 0.376612f;
        double otm_5_A_I_limitLo = 0.562292f;
        double otm_5_A_V_warnHi = 0.11836177110671997;
        double otm_5_A_V_warnLo = 0.11182254552841187;
        double otm_5_A_V_limitHi = 0.32439786195755005;
        double otm_5_A_V_limitLo = 0.630763053894043;
        double otm_5_B_I_warnHi = 0.2564527988433838;
        double otm_5_B_I_warnLo = 0.018869996070861816;
        double otm_5_B_I_limitHi = 0.5753469467163086;
        double otm_5_B_I_limitLo = 0.7712225317955017;
        double otm_5_B_V_warnHi = 0.03604203462600708;
        double otm_5_B_V_warnLo = 0.3303477168083191;
        double otm_5_B_V_limitHi = 0.5554215312004089;
        double otm_5_B_V_limitLo = 0.4535815119743347;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_5V_LimitsConfigurationEvent(version, otm_0_A_I_warnHi, otm_0_A_I_warnLo, otm_0_A_I_limitHi, otm_0_A_I_limitLo, otm_0_A_V_warnHi, otm_0_A_V_warnLo, otm_0_A_V_limitHi, otm_0_A_V_limitLo, otm_0_B_I_warnHi, otm_0_B_I_warnLo, otm_0_B_I_limitHi, otm_0_B_I_limitLo, otm_0_B_V_warnHi, otm_0_B_V_warnLo, otm_0_B_V_limitHi, otm_0_B_V_limitLo, otm_1_A_I_warnHi, otm_1_A_I_warnLo, otm_1_A_I_limitHi, otm_1_A_I_limitLo, otm_1_A_V_warnHi, otm_1_A_V_warnLo, otm_1_A_V_limitHi, otm_1_A_V_limitLo, otm_1_B_I_warnHi, otm_1_B_I_warnLo, otm_1_B_I_limitHi, otm_1_B_I_limitLo, otm_1_B_V_warnHi, otm_1_B_V_warnLo, otm_1_B_V_limitHi, otm_1_B_V_limitLo, otm_2_A_I_warnHi, otm_2_A_I_warnLo, otm_2_A_I_limitHi, otm_2_A_I_limitLo, otm_2_A_V_warnHi, otm_2_A_V_warnLo, otm_2_A_V_limitHi, otm_2_A_V_limitLo, otm_2_B_I_warnHi, otm_2_B_I_warnLo, otm_2_B_I_limitHi, otm_2_B_I_limitLo, otm_2_B_V_warnHi, otm_2_B_V_warnLo, otm_2_B_V_limitHi, otm_2_B_V_limitLo, otm_3_A_I_warnHi, otm_3_A_I_warnLo, otm_3_A_I_limitHi, otm_3_A_I_limitLo, otm_3_A_V_warnHi, otm_3_A_V_warnLo, otm_3_A_V_limitHi, otm_3_A_V_limitLo, otm_3_B_I_warnHi, otm_3_B_I_warnLo, otm_3_B_I_limitHi, otm_3_B_I_limitLo, otm_3_B_V_warnHi, otm_3_B_V_warnLo, otm_3_B_V_limitHi, otm_3_B_V_limitLo, otm_4_A_I_warnHi, otm_4_A_I_warnLo, otm_4_A_I_limitHi, otm_4_A_I_limitLo, otm_4_A_V_warnHi, otm_4_A_V_warnLo, otm_4_A_V_limitHi, otm_4_A_V_limitLo, otm_4_B_I_warnHi, otm_4_B_I_warnLo, otm_4_B_I_limitHi, otm_4_B_I_limitLo, otm_4_B_V_warnHi, otm_4_B_V_warnLo, otm_4_B_V_limitHi, otm_4_B_V_limitLo, otm_5_A_I_warnHi, otm_5_A_I_warnLo, otm_5_A_I_limitHi, otm_5_A_I_limitLo, otm_5_A_V_warnHi, otm_5_A_V_warnLo, otm_5_A_V_limitHi, otm_5_A_V_limitLo, otm_5_B_I_warnHi, otm_5_B_I_warnLo, otm_5_B_I_limitHi, otm_5_B_I_limitLo, otm_5_B_V_warnHi, otm_5_B_V_warnLo, otm_5_B_V_limitHi, otm_5_B_V_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5V_LimitsConfigurationEvent));
        Quadbox_PDU_5V_LimitsConfigurationEvent item_ = (Quadbox_PDU_5V_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)otm_0_A_I_warnHi, (double)item_.getOtm_0_A_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_I_warnLo, (double)item_.getOtm_0_A_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_I_limitHi, (double)item_.getOtm_0_A_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_I_limitLo, (double)item_.getOtm_0_A_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_V_warnHi, (double)item_.getOtm_0_A_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_V_warnLo, (double)item_.getOtm_0_A_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_V_limitHi, (double)item_.getOtm_0_A_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_V_limitLo, (double)item_.getOtm_0_A_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I_warnHi, (double)item_.getOtm_0_B_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I_warnLo, (double)item_.getOtm_0_B_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I_limitHi, (double)item_.getOtm_0_B_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I_limitLo, (double)item_.getOtm_0_B_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_V_warnHi, (double)item_.getOtm_0_B_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_V_warnLo, (double)item_.getOtm_0_B_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_V_limitHi, (double)item_.getOtm_0_B_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_V_limitLo, (double)item_.getOtm_0_B_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_I_warnHi, (double)item_.getOtm_1_A_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_I_warnLo, (double)item_.getOtm_1_A_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_I_limitHi, (double)item_.getOtm_1_A_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_I_limitLo, (double)item_.getOtm_1_A_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_V_warnHi, (double)item_.getOtm_1_A_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_V_warnLo, (double)item_.getOtm_1_A_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_V_limitHi, (double)item_.getOtm_1_A_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_V_limitLo, (double)item_.getOtm_1_A_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_I_warnHi, (double)item_.getOtm_1_B_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_I_warnLo, (double)item_.getOtm_1_B_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_I_limitHi, (double)item_.getOtm_1_B_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_I_limitLo, (double)item_.getOtm_1_B_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_V_warnHi, (double)item_.getOtm_1_B_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_V_warnLo, (double)item_.getOtm_1_B_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_V_limitHi, (double)item_.getOtm_1_B_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_V_limitLo, (double)item_.getOtm_1_B_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_I_warnHi, (double)item_.getOtm_2_A_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_I_warnLo, (double)item_.getOtm_2_A_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_I_limitHi, (double)item_.getOtm_2_A_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_I_limitLo, (double)item_.getOtm_2_A_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_V_warnHi, (double)item_.getOtm_2_A_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_V_warnLo, (double)item_.getOtm_2_A_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_V_limitHi, (double)item_.getOtm_2_A_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_V_limitLo, (double)item_.getOtm_2_A_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_I_warnHi, (double)item_.getOtm_2_B_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_I_warnLo, (double)item_.getOtm_2_B_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_I_limitHi, (double)item_.getOtm_2_B_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_I_limitLo, (double)item_.getOtm_2_B_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_V_warnHi, (double)item_.getOtm_2_B_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_V_warnLo, (double)item_.getOtm_2_B_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_V_limitHi, (double)item_.getOtm_2_B_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_V_limitLo, (double)item_.getOtm_2_B_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I_warnHi, (double)item_.getOtm_3_A_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I_warnLo, (double)item_.getOtm_3_A_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I_limitHi, (double)item_.getOtm_3_A_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I_limitLo, (double)item_.getOtm_3_A_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V_warnHi, (double)item_.getOtm_3_A_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V_warnLo, (double)item_.getOtm_3_A_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V_limitHi, (double)item_.getOtm_3_A_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V_limitLo, (double)item_.getOtm_3_A_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I_warnHi, (double)item_.getOtm_3_B_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I_warnLo, (double)item_.getOtm_3_B_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I_limitHi, (double)item_.getOtm_3_B_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I_limitLo, (double)item_.getOtm_3_B_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V_warnHi, (double)item_.getOtm_3_B_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V_warnLo, (double)item_.getOtm_3_B_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V_limitHi, (double)item_.getOtm_3_B_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V_limitLo, (double)item_.getOtm_3_B_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_I_warnHi, (double)item_.getOtm_4_A_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_I_warnLo, (double)item_.getOtm_4_A_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_I_limitHi, (double)item_.getOtm_4_A_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_I_limitLo, (double)item_.getOtm_4_A_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_V_warnHi, (double)item_.getOtm_4_A_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_V_warnLo, (double)item_.getOtm_4_A_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_V_limitHi, (double)item_.getOtm_4_A_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_V_limitLo, (double)item_.getOtm_4_A_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_I_warnHi, (double)item_.getOtm_4_B_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_I_warnLo, (double)item_.getOtm_4_B_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_I_limitHi, (double)item_.getOtm_4_B_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_I_limitLo, (double)item_.getOtm_4_B_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_V_warnHi, (double)item_.getOtm_4_B_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_V_warnLo, (double)item_.getOtm_4_B_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_V_limitHi, (double)item_.getOtm_4_B_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_V_limitLo, (double)item_.getOtm_4_B_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_I_warnHi, (double)item_.getOtm_5_A_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_I_warnLo, (double)item_.getOtm_5_A_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_I_limitHi, (double)item_.getOtm_5_A_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_I_limitLo, (double)item_.getOtm_5_A_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_V_warnHi, (double)item_.getOtm_5_A_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_V_warnLo, (double)item_.getOtm_5_A_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_V_limitHi, (double)item_.getOtm_5_A_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_V_limitLo, (double)item_.getOtm_5_A_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_I_warnHi, (double)item_.getOtm_5_B_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_I_warnLo, (double)item_.getOtm_5_B_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_I_limitHi, (double)item_.getOtm_5_B_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_I_limitLo, (double)item_.getOtm_5_B_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_V_warnHi, (double)item_.getOtm_5_B_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_V_warnLo, (double)item_.getOtm_5_B_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_V_limitHi, (double)item_.getOtm_5_B_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_V_limitLo, (double)item_.getOtm_5_B_V_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_5V_QuadboxConfigurationEvent() throws Exception {
        String version = "a";
        int node = 378;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_5V_QuadboxConfigurationEvent(version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5V_QuadboxConfigurationEvent));
        Quadbox_PDU_5V_QuadboxConfigurationEvent item_ = (Quadbox_PDU_5V_QuadboxConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_PeriodicTasksConfigurationEvent() throws Exception {
        String version = "";
        int schedulers_default_nTasks = 595;
        int schedulers_default_nThreads = 262;
        int schedulers_monitor_update_publish_scheduler_nTasks = 382;
        int schedulers_monitor_update_publish_scheduler_nThreads = 657;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PeriodicTasksConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PeriodicTasksConfigurationEvent));
        Quadbox_PeriodicTasksConfigurationEvent item_ = (Quadbox_PeriodicTasksConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveQuadbox_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "w";
        long agentmonitorservice_taskPeriodMillis = 435L;
        long heartbeat_taskPeriodMillis = 560L;
        long monitor_check_taskPeriodMillis = 631L;
        long monitor_publish_taskPeriodMillis = 929L;
        long monitor_update_taskPeriodMillis = 512L;
        long runtimeinfo_taskPeriodMillis = 328L;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PeriodicTasks_timersConfigurationEvent));
        Quadbox_PeriodicTasks_timersConfigurationEvent item_ = (Quadbox_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveQuadbox_REB_Bulk_PS_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double rebbulkps_0_2_I_warnHi = 0.6111805438995361;
        double rebbulkps_0_2_I_warnLo = 0.5877537727355957;
        double rebbulkps_0_2_I_limitHi = 0.22770464420318604;
        double rebbulkps_0_2_I_limitLo = 0.08397293090820312;
        double rebbulkps_0_2_T_warnHi = 0.705195426940918;
        double rebbulkps_0_2_T_warnLo = 0.5745881199836731;
        double rebbulkps_0_2_T_limitHi = 0.3399214f;
        double rebbulkps_0_2_T_limitLo = 0.2192559838294983;
        double rebbulkps_0_2_V_warnHi = 0.6262549161911011;
        double rebbulkps_0_2_V_warnLo = 0.3666437268257141;
        double rebbulkps_0_2_V_limitHi = 0.45988816022872925;
        double rebbulkps_0_2_V_limitLo = 0.6296939253807068;
        double rebbulkps_3_5_I_warnHi = 0.040489912033081055;
        double rebbulkps_3_5_I_warnLo = 0.45842164754867554;
        double rebbulkps_3_5_I_limitHi = 0.8041380643844604;
        double rebbulkps_3_5_I_limitLo = 0.963213324546814;
        double rebbulkps_3_5_T_warnHi = 0.4553758502006531;
        double rebbulkps_3_5_T_warnLo = 0.2713279128074646;
        double rebbulkps_3_5_T_limitHi = 0.947884738445282;
        double rebbulkps_3_5_T_limitLo = 0.0288409f;
        double rebbulkps_3_5_V_warnHi = 0.39329564571380615;
        double rebbulkps_3_5_V_warnLo = 0.22851771116256714;
        double rebbulkps_3_5_V_limitHi = 0.21255344152450562;
        double rebbulkps_3_5_V_limitLo = 0.011912405490875244;
        double rebbulkps_6_8_I_warnHi = 0.5514242649078369;
        double rebbulkps_6_8_I_warnLo = 0.6508852243423462;
        double rebbulkps_6_8_I_limitHi = 0.568288266658783;
        double rebbulkps_6_8_I_limitLo = 0.637826144695282;
        double rebbulkps_6_8_T_warnHi = 0.09007900953292847;
        double rebbulkps_6_8_T_warnLo = 0.8701666593551636;
        double rebbulkps_6_8_T_limitHi = 0.36637115478515625;
        double rebbulkps_6_8_T_limitLo = 0.03323858976364136;
        double rebbulkps_6_8_V_warnHi = 0.8563101887702942;
        double rebbulkps_6_8_V_warnLo = 0.8666839003562927;
        double rebbulkps_6_8_V_limitHi = 0.45781224966049194;
        double rebbulkps_6_8_V_limitLo = 0.3513185381889343;
        double rebbulkps_9_12_I_warnHi = 0.4714767336845398;
        double rebbulkps_9_12_I_warnLo = 0.46924442052841187;
        double rebbulkps_9_12_I_limitHi = 0.2972654700279236;
        double rebbulkps_9_12_I_limitLo = 0.6357949376106262;
        double rebbulkps_9_12_T_warnHi = 0.5301083922386169;
        double rebbulkps_9_12_T_warnLo = 0.7822174429893494;
        double rebbulkps_9_12_T_limitHi = 0.5979655385017395;
        double rebbulkps_9_12_T_limitLo = 0.7027034163475037;
        double rebbulkps_9_12_V_warnHi = 0.9898995161056519;
        double rebbulkps_9_12_V_warnLo = 0.12456047534942627;
        double rebbulkps_9_12_V_limitHi = 0.8187646269798279;
        double rebbulkps_9_12_V_limitLo = 0.4652571678161621;
        double rebbulkps_Brd_T_warnHi = 0.3246997594833374;
        double rebbulkps_Brd_T_warnLo = 0.7379271984100342;
        double rebbulkps_Brd_T_limitHi = 0.006887316703796387;
        double rebbulkps_Brd_T_limitLo = 0.4530452489852905;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_REB_Bulk_PS_LimitsConfigurationEvent(version, rebbulkps_0_2_I_warnHi, rebbulkps_0_2_I_warnLo, rebbulkps_0_2_I_limitHi, rebbulkps_0_2_I_limitLo, rebbulkps_0_2_T_warnHi, rebbulkps_0_2_T_warnLo, rebbulkps_0_2_T_limitHi, rebbulkps_0_2_T_limitLo, rebbulkps_0_2_V_warnHi, rebbulkps_0_2_V_warnLo, rebbulkps_0_2_V_limitHi, rebbulkps_0_2_V_limitLo, rebbulkps_3_5_I_warnHi, rebbulkps_3_5_I_warnLo, rebbulkps_3_5_I_limitHi, rebbulkps_3_5_I_limitLo, rebbulkps_3_5_T_warnHi, rebbulkps_3_5_T_warnLo, rebbulkps_3_5_T_limitHi, rebbulkps_3_5_T_limitLo, rebbulkps_3_5_V_warnHi, rebbulkps_3_5_V_warnLo, rebbulkps_3_5_V_limitHi, rebbulkps_3_5_V_limitLo, rebbulkps_6_8_I_warnHi, rebbulkps_6_8_I_warnLo, rebbulkps_6_8_I_limitHi, rebbulkps_6_8_I_limitLo, rebbulkps_6_8_T_warnHi, rebbulkps_6_8_T_warnLo, rebbulkps_6_8_T_limitHi, rebbulkps_6_8_T_limitLo, rebbulkps_6_8_V_warnHi, rebbulkps_6_8_V_warnLo, rebbulkps_6_8_V_limitHi, rebbulkps_6_8_V_limitLo, rebbulkps_9_12_I_warnHi, rebbulkps_9_12_I_warnLo, rebbulkps_9_12_I_limitHi, rebbulkps_9_12_I_limitLo, rebbulkps_9_12_T_warnHi, rebbulkps_9_12_T_warnLo, rebbulkps_9_12_T_limitHi, rebbulkps_9_12_T_limitLo, rebbulkps_9_12_V_warnHi, rebbulkps_9_12_V_warnLo, rebbulkps_9_12_V_limitHi, rebbulkps_9_12_V_limitLo, rebbulkps_Brd_T_warnHi, rebbulkps_Brd_T_warnLo, rebbulkps_Brd_T_limitHi, rebbulkps_Brd_T_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_REB_Bulk_PS_LimitsConfigurationEvent));
        Quadbox_REB_Bulk_PS_LimitsConfigurationEvent item_ = (Quadbox_REB_Bulk_PS_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)rebbulkps_0_2_I_warnHi, (double)item_.getRebbulkps_0_2_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_I_warnLo, (double)item_.getRebbulkps_0_2_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_I_limitHi, (double)item_.getRebbulkps_0_2_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_I_limitLo, (double)item_.getRebbulkps_0_2_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_T_warnHi, (double)item_.getRebbulkps_0_2_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_T_warnLo, (double)item_.getRebbulkps_0_2_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_T_limitHi, (double)item_.getRebbulkps_0_2_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_T_limitLo, (double)item_.getRebbulkps_0_2_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_V_warnHi, (double)item_.getRebbulkps_0_2_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_V_warnLo, (double)item_.getRebbulkps_0_2_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_V_limitHi, (double)item_.getRebbulkps_0_2_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_V_limitLo, (double)item_.getRebbulkps_0_2_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_I_warnHi, (double)item_.getRebbulkps_3_5_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_I_warnLo, (double)item_.getRebbulkps_3_5_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_I_limitHi, (double)item_.getRebbulkps_3_5_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_I_limitLo, (double)item_.getRebbulkps_3_5_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_T_warnHi, (double)item_.getRebbulkps_3_5_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_T_warnLo, (double)item_.getRebbulkps_3_5_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_T_limitHi, (double)item_.getRebbulkps_3_5_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_T_limitLo, (double)item_.getRebbulkps_3_5_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_V_warnHi, (double)item_.getRebbulkps_3_5_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_V_warnLo, (double)item_.getRebbulkps_3_5_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_V_limitHi, (double)item_.getRebbulkps_3_5_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_V_limitLo, (double)item_.getRebbulkps_3_5_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_I_warnHi, (double)item_.getRebbulkps_6_8_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_I_warnLo, (double)item_.getRebbulkps_6_8_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_I_limitHi, (double)item_.getRebbulkps_6_8_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_I_limitLo, (double)item_.getRebbulkps_6_8_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_T_warnHi, (double)item_.getRebbulkps_6_8_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_T_warnLo, (double)item_.getRebbulkps_6_8_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_T_limitHi, (double)item_.getRebbulkps_6_8_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_T_limitLo, (double)item_.getRebbulkps_6_8_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_V_warnHi, (double)item_.getRebbulkps_6_8_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_V_warnLo, (double)item_.getRebbulkps_6_8_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_V_limitHi, (double)item_.getRebbulkps_6_8_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_V_limitLo, (double)item_.getRebbulkps_6_8_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_I_warnHi, (double)item_.getRebbulkps_9_12_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_I_warnLo, (double)item_.getRebbulkps_9_12_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_I_limitHi, (double)item_.getRebbulkps_9_12_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_I_limitLo, (double)item_.getRebbulkps_9_12_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_T_warnHi, (double)item_.getRebbulkps_9_12_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_T_warnLo, (double)item_.getRebbulkps_9_12_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_T_limitHi, (double)item_.getRebbulkps_9_12_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_T_limitLo, (double)item_.getRebbulkps_9_12_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_V_warnHi, (double)item_.getRebbulkps_9_12_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_V_warnLo, (double)item_.getRebbulkps_9_12_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_V_limitHi, (double)item_.getRebbulkps_9_12_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_V_limitLo, (double)item_.getRebbulkps_9_12_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_Brd_T_warnHi, (double)item_.getRebbulkps_Brd_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_Brd_T_warnLo, (double)item_.getRebbulkps_Brd_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_Brd_T_limitHi, (double)item_.getRebbulkps_Brd_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_Brd_T_limitLo, (double)item_.getRebbulkps_Brd_T_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_REB_Bulk_PS_QuadboxConfigurationEvent() throws Exception {
        String version = "";
        int node = 998;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_REB_Bulk_PS_QuadboxConfigurationEvent(version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_REB_Bulk_PS_QuadboxConfigurationEvent));
        Quadbox_REB_Bulk_PS_QuadboxConfigurationEvent item_ = (Quadbox_REB_Bulk_PS_QuadboxConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveRebpowerConfigurationEvent() throws Exception {
        String version = "";
        long powerOffSleepMillis = 197L;
        SALEvent item = this.testSendReceive((SALEvent)new RebpowerConfigurationEvent(version, powerOffSleepMillis));
        Assert.assertTrue((boolean)(item instanceof RebpowerConfigurationEvent));
        RebpowerConfigurationEvent item_ = (RebpowerConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)powerOffSleepMillis, (long)item_.getPowerOffSleepMillis());
    }

    @Test
    public void sendReceiveRebpower_EmergencyResponseManagerConfigurationEvent() throws Exception {
        String version = "c";
        boolean processOnlyClearedAlerts = true;
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_EmergencyResponseManagerConfigurationEvent(version, processOnlyClearedAlerts));
        Assert.assertTrue((boolean)(item instanceof Rebpower_EmergencyResponseManagerConfigurationEvent));
        Rebpower_EmergencyResponseManagerConfigurationEvent item_ = (Rebpower_EmergencyResponseManagerConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)processOnlyClearedAlerts, (Object)item_.isProcessOnlyClearedAlerts());
    }

    @Test
    public void sendReceiveRebpower_PeriodicTasksConfigurationEvent() throws Exception {
        String version = "";
        int schedulers_default_nTasks = 217;
        int schedulers_default_nThreads = 536;
        int schedulers_monitor_check_scheduler_nTasks = 875;
        int schedulers_monitor_check_scheduler_nThreads = 314;
        int schedulers_monitor_update_publish_scheduler_nTasks = 97;
        int schedulers_monitor_update_publish_scheduler_nThreads = 634;
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_PeriodicTasksConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_check_scheduler_nTasks, schedulers_monitor_check_scheduler_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Rebpower_PeriodicTasksConfigurationEvent));
        Rebpower_PeriodicTasksConfigurationEvent item_ = (Rebpower_PeriodicTasksConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nTasks, (long)item_.getSchedulers_monitor_check_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nThreads, (long)item_.getSchedulers_monitor_check_scheduler_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveRebpower_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "";
        long agentmonitorservice_taskPeriodMillis = 461L;
        long heartbeat_taskPeriodMillis = 987L;
        long monitor_check_RebPS_P00_taskPeriodMillis = 277L;
        long monitor_check_RebPS_P01_taskPeriodMillis = 806L;
        long monitor_check_RebPS_P02_taskPeriodMillis = 120L;
        long monitor_check_RebPS_P03_taskPeriodMillis = 865L;
        long monitor_check_RebPS_P04_taskPeriodMillis = 712L;
        long monitor_check_RebPS_P05_taskPeriodMillis = 3L;
        long monitor_check_RebPS_P06_taskPeriodMillis = 921L;
        long monitor_check_RebPS_P07_taskPeriodMillis = 614L;
        long monitor_check_RebPS_P08_taskPeriodMillis = 146L;
        long monitor_check_RebPS_P09_taskPeriodMillis = 796L;
        long monitor_check_RebPS_P10_taskPeriodMillis = 447L;
        long monitor_check_RebPS_P11_taskPeriodMillis = 407L;
        long monitor_check_RebPS_P12_taskPeriodMillis = 999L;
        long monitor_publish_RebPS_P00_taskPeriodMillis = 799L;
        long monitor_publish_RebPS_P01_taskPeriodMillis = 243L;
        long monitor_publish_RebPS_P02_taskPeriodMillis = 100L;
        long monitor_publish_RebPS_P03_taskPeriodMillis = 2L;
        long monitor_publish_RebPS_P04_taskPeriodMillis = 219L;
        long monitor_publish_RebPS_P05_taskPeriodMillis = 635L;
        long monitor_publish_RebPS_P06_taskPeriodMillis = 663L;
        long monitor_publish_RebPS_P07_taskPeriodMillis = 648L;
        long monitor_publish_RebPS_P08_taskPeriodMillis = 4L;
        long monitor_publish_RebPS_P09_taskPeriodMillis = 133L;
        long monitor_publish_RebPS_P10_taskPeriodMillis = 784L;
        long monitor_publish_RebPS_P11_taskPeriodMillis = 397L;
        long monitor_publish_RebPS_P12_taskPeriodMillis = 10L;
        long monitor_update_RebPS_P00_taskPeriodMillis = 441L;
        long monitor_update_RebPS_P01_taskPeriodMillis = 562L;
        long monitor_update_RebPS_P02_taskPeriodMillis = 56L;
        long monitor_update_RebPS_P03_taskPeriodMillis = 455L;
        long monitor_update_RebPS_P04_taskPeriodMillis = 223L;
        long monitor_update_RebPS_P05_taskPeriodMillis = 542L;
        long monitor_update_RebPS_P06_taskPeriodMillis = 89L;
        long monitor_update_RebPS_P07_taskPeriodMillis = 659L;
        long monitor_update_RebPS_P08_taskPeriodMillis = 719L;
        long monitor_update_RebPS_P09_taskPeriodMillis = 98L;
        long monitor_update_RebPS_P10_taskPeriodMillis = 484L;
        long monitor_update_RebPS_P11_taskPeriodMillis = 102L;
        long monitor_update_RebPS_P12_taskPeriodMillis = 647L;
        long reb_power_state_taskPeriodMillis = 925L;
        long runtimeinfo_taskPeriodMillis = 749L;
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_RebPS_P00_taskPeriodMillis, monitor_check_RebPS_P01_taskPeriodMillis, monitor_check_RebPS_P02_taskPeriodMillis, monitor_check_RebPS_P03_taskPeriodMillis, monitor_check_RebPS_P04_taskPeriodMillis, monitor_check_RebPS_P05_taskPeriodMillis, monitor_check_RebPS_P06_taskPeriodMillis, monitor_check_RebPS_P07_taskPeriodMillis, monitor_check_RebPS_P08_taskPeriodMillis, monitor_check_RebPS_P09_taskPeriodMillis, monitor_check_RebPS_P10_taskPeriodMillis, monitor_check_RebPS_P11_taskPeriodMillis, monitor_check_RebPS_P12_taskPeriodMillis, monitor_publish_RebPS_P00_taskPeriodMillis, monitor_publish_RebPS_P01_taskPeriodMillis, monitor_publish_RebPS_P02_taskPeriodMillis, monitor_publish_RebPS_P03_taskPeriodMillis, monitor_publish_RebPS_P04_taskPeriodMillis, monitor_publish_RebPS_P05_taskPeriodMillis, monitor_publish_RebPS_P06_taskPeriodMillis, monitor_publish_RebPS_P07_taskPeriodMillis, monitor_publish_RebPS_P08_taskPeriodMillis, monitor_publish_RebPS_P09_taskPeriodMillis, monitor_publish_RebPS_P10_taskPeriodMillis, monitor_publish_RebPS_P11_taskPeriodMillis, monitor_publish_RebPS_P12_taskPeriodMillis, monitor_update_RebPS_P00_taskPeriodMillis, monitor_update_RebPS_P01_taskPeriodMillis, monitor_update_RebPS_P02_taskPeriodMillis, monitor_update_RebPS_P03_taskPeriodMillis, monitor_update_RebPS_P04_taskPeriodMillis, monitor_update_RebPS_P05_taskPeriodMillis, monitor_update_RebPS_P06_taskPeriodMillis, monitor_update_RebPS_P07_taskPeriodMillis, monitor_update_RebPS_P08_taskPeriodMillis, monitor_update_RebPS_P09_taskPeriodMillis, monitor_update_RebPS_P10_taskPeriodMillis, monitor_update_RebPS_P11_taskPeriodMillis, monitor_update_RebPS_P12_taskPeriodMillis, reb_power_state_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Rebpower_PeriodicTasks_timersConfigurationEvent));
        Rebpower_PeriodicTasks_timersConfigurationEvent item_ = (Rebpower_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P00_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P00_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P01_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P01_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P02_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P02_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P03_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P03_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P04_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P04_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P05_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P05_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P06_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P06_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P07_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P07_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P08_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P08_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P09_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P09_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P10_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P10_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P11_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P11_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P12_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P12_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P00_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P00_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P01_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P01_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P02_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P02_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P03_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P03_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P04_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P04_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P05_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P05_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P06_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P06_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P07_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P07_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P08_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P08_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P09_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P09_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P10_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P10_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P11_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P11_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P12_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P12_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P00_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P00_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P01_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P01_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P02_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P02_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P03_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P03_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P04_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P04_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P05_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P05_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P06_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P06_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P07_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P07_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P08_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P08_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P09_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P09_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P10_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P10_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P11_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P11_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P12_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P12_taskPeriodMillis());
        Assert.assertEquals((long)reb_power_state_taskPeriodMillis, (long)item_.getReb_power_state_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveRebpower_RebConfigurationEvent() throws Exception {
        String version = "";
        int[] dphi = TestHelper.generateIntArray((int)71, (int)-2093817922);
        int[] hvBias = TestHelper.generateIntArray((int)71, (int)63630387);
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_RebConfigurationEvent(version, dphi, hvBias, location));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebConfigurationEvent));
        Rebpower_RebConfigurationEvent item_ = (Rebpower_RebConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((int[])dphi, (int[])item_.getDphi());
        Assert.assertArrayEquals((int[])hvBias, (int[])item_.getHvBias());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveRebpower_Reb_LimitsConfigurationEvent() throws Exception {
        String version = "o";
        double[] analog_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)474056220);
        double[] analog_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-886637887);
        double[] analog_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1307659566);
        double[] analog_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-2043613561);
        double[] analog_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-779278081);
        double[] analog_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)87063612);
        double[] analog_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-580309562);
        double[] analog_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-585747698);
        double[] analog_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)1882601063);
        double[] analog_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-990212484);
        double[] analog_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)901450197);
        double[] analog_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1205511172);
        double[] analog_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)726099078);
        double[] analog_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)-694152508);
        double[] analog_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)1021733199);
        double[] analog_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)452639809);
        double[] analog_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-16557242);
        double[] analog_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1300150858);
        double[] analog_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)313053182);
        double[] analog_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-99667053);
        double[] clockhi_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)1873710749);
        double[] clockhi_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)818752792);
        double[] clockhi_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-2022901862);
        double[] clockhi_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-755717078);
        double[] clockhi_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1351882203);
        double[] clockhi_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)1863163354);
        double[] clockhi_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1442777214);
        double[] clockhi_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1913236938);
        double[] clockhi_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)1325408747);
        double[] clockhi_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-379642281);
        double[] clockhi_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)1213903785);
        double[] clockhi_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1041256910);
        double[] clockhi_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)-432489338);
        double[] clockhi_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)1674455259);
        double[] clockhi_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)-541079858);
        double[] clockhi_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)1044989715);
        double[] clockhi_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-2031015317);
        double[] clockhi_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-806907291);
        double[] clockhi_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-867869713);
        double[] clockhi_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1466961045);
        double[] clocklo_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)1384218240);
        double[] clocklo_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-417195603);
        double[] clocklo_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)770681599);
        double[] clocklo_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1501721611);
        double[] clocklo_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)34053102);
        double[] clocklo_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)144925288);
        double[] clocklo_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-369095466);
        double[] clocklo_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1303409866);
        double[] clocklo_VaftLDO2_warnHi = TestHelper.generateDoubleArray((int)71, (int)-2018185925);
        double[] clocklo_VaftLDO2_warnLo = TestHelper.generateDoubleArray((int)71, (int)-666705719);
        double[] clocklo_VaftLDO2_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1803822488);
        double[] clocklo_VaftLDO2_limitLo = TestHelper.generateDoubleArray((int)71, (int)-344785464);
        double[] clocklo_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)1599600791);
        double[] clocklo_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1177454261);
        double[] clocklo_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-2014999751);
        double[] clocklo_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1334242273);
        double[] clocklo_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)2147116405);
        double[] clocklo_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)651483309);
        double[] clocklo_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)1388627728);
        double[] clocklo_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1400398560);
        double[] clocklo_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-857651363);
        double[] clocklo_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-497956802);
        double[] clocklo_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)858873578);
        double[] clocklo_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1564192294);
        double[] digital_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)449233408);
        double[] digital_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1775173030);
        double[] digital_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)325083441);
        double[] digital_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1372397901);
        double[] digital_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)1812028044);
        double[] digital_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1803662540);
        double[] digital_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)1316076845);
        double[] digital_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-865855271);
        double[] digital_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1933669823);
        double[] digital_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)1954140628);
        double[] digital_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)363866554);
        double[] digital_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1904905178);
        double[] digital_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)750478916);
        double[] digital_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)2087722339);
        double[] digital_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)861684539);
        double[] digital_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)-2038782702);
        double[] digital_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)2134864051);
        double[] digital_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)768412326);
        double[] digital_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-331934514);
        double[] digital_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)911422229);
        double[] dphi_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)701163257);
        double[] dphi_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1927111224);
        double[] dphi_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)596607169);
        double[] dphi_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)922425108);
        double[] dphi_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)1328226658);
        double[] dphi_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1675318181);
        double[] dphi_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1713816509);
        double[] dphi_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)931014788);
        double[] dphi_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)347920369);
        double[] dphi_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-333012064);
        double[] dphi_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)185291358);
        double[] dphi_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)149040896);
        double[] dphi_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)1942839409);
        double[] dphi_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1262948602);
        double[] dphi_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)862937636);
        double[] dphi_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)1278678638);
        double[] dphi_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)780745161);
        double[] dphi_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1210596624);
        double[] dphi_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-429257688);
        double[] dphi_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1221344927);
        double[] heater_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1745389420);
        double[] heater_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1141551173);
        double[] heater_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1369947344);
        double[] heater_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)2044927422);
        double[] heater_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1637422863);
        double[] heater_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)272998655);
        double[] heater_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)371487784);
        double[] heater_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)33251233);
        double[] heater_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)1487600022);
        double[] heater_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)2035461396);
        double[] heater_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)804370776);
        double[] heater_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1840481921);
        double[] heater_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1244412885);
        double[] heater_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)-549234473);
        double[] heater_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)124423385);
        double[] heater_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)109678737);
        double[] heater_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-303184171);
        double[] heater_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-56069203);
        double[] heater_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)86224453);
        double[] heater_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1185808489);
        double[] hvbias_IbefSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)-703913200);
        double[] hvbias_IbefSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)944697287);
        double[] hvbias_IbefSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)1650143149);
        double[] hvbias_IbefSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)1341102309);
        double[] hvbias_VbefSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)1000437185);
        double[] hvbias_VbefSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)1724308135);
        double[] hvbias_VbefSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)1684463055);
        double[] hvbias_VbefSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1823706291);
        String location = "";
        double[] od_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-851256861);
        double[] od_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)1554282376);
        double[] od_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)1392235446);
        double[] od_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-378012576);
        double[] od_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-814993367);
        double[] od_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)1072785543);
        double[] od_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-401186905);
        double[] od_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-799728293);
        double[] od_VaftLDO2_warnHi = TestHelper.generateDoubleArray((int)71, (int)-519860606);
        double[] od_VaftLDO2_warnLo = TestHelper.generateDoubleArray((int)71, (int)-422118589);
        double[] od_VaftLDO2_limitHi = TestHelper.generateDoubleArray((int)71, (int)1865980670);
        double[] od_VaftLDO2_limitLo = TestHelper.generateDoubleArray((int)71, (int)710913997);
        double[] od_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-756599334);
        double[] od_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1192020434);
        double[] od_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-19542252);
        double[] od_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-619950443);
        double[] od_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)1436232895);
        double[] od_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)703977514);
        double[] od_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)2091892767);
        double[] od_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)-855600459);
        double[] od_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1980199575);
        double[] od_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)940320828);
        double[] od_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-532032296);
        double[] od_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1978158113);
        double[] power_warnHi = TestHelper.generateDoubleArray((int)71, (int)-277532678);
        double[] power_warnLo = TestHelper.generateDoubleArray((int)71, (int)839748735);
        double[] power_limitHi = TestHelper.generateDoubleArray((int)71, (int)1685361757);
        double[] power_limitLo = TestHelper.generateDoubleArray((int)71, (int)136639448);
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Reb_LimitsConfigurationEvent(version, analog_IaftLDO_warnHi, analog_IaftLDO_warnLo, analog_IaftLDO_limitHi, analog_IaftLDO_limitLo, analog_IbefLDO_warnHi, analog_IbefLDO_warnLo, analog_IbefLDO_limitHi, analog_IbefLDO_limitLo, analog_VaftLDO_warnHi, analog_VaftLDO_warnLo, analog_VaftLDO_limitHi, analog_VaftLDO_limitLo, analog_VaftSwch_warnHi, analog_VaftSwch_warnLo, analog_VaftSwch_limitHi, analog_VaftSwch_limitLo, analog_VbefLDO_warnHi, analog_VbefLDO_warnLo, analog_VbefLDO_limitHi, analog_VbefLDO_limitLo, clockhi_IaftLDO_warnHi, clockhi_IaftLDO_warnLo, clockhi_IaftLDO_limitHi, clockhi_IaftLDO_limitLo, clockhi_IbefLDO_warnHi, clockhi_IbefLDO_warnLo, clockhi_IbefLDO_limitHi, clockhi_IbefLDO_limitLo, clockhi_VaftLDO_warnHi, clockhi_VaftLDO_warnLo, clockhi_VaftLDO_limitHi, clockhi_VaftLDO_limitLo, clockhi_VaftSwch_warnHi, clockhi_VaftSwch_warnLo, clockhi_VaftSwch_limitHi, clockhi_VaftSwch_limitLo, clockhi_VbefLDO_warnHi, clockhi_VbefLDO_warnLo, clockhi_VbefLDO_limitHi, clockhi_VbefLDO_limitLo, clocklo_IaftLDO_warnHi, clocklo_IaftLDO_warnLo, clocklo_IaftLDO_limitHi, clocklo_IaftLDO_limitLo, clocklo_IbefLDO_warnHi, clocklo_IbefLDO_warnLo, clocklo_IbefLDO_limitHi, clocklo_IbefLDO_limitLo, clocklo_VaftLDO2_warnHi, clocklo_VaftLDO2_warnLo, clocklo_VaftLDO2_limitHi, clocklo_VaftLDO2_limitLo, clocklo_VaftLDO_warnHi, clocklo_VaftLDO_warnLo, clocklo_VaftLDO_limitHi, clocklo_VaftLDO_limitLo, clocklo_VaftSwch_warnHi, clocklo_VaftSwch_warnLo, clocklo_VaftSwch_limitHi, clocklo_VaftSwch_limitLo, clocklo_VbefLDO_warnHi, clocklo_VbefLDO_warnLo, clocklo_VbefLDO_limitHi, clocklo_VbefLDO_limitLo, digital_IaftLDO_warnHi, digital_IaftLDO_warnLo, digital_IaftLDO_limitHi, digital_IaftLDO_limitLo, digital_IbefLDO_warnHi, digital_IbefLDO_warnLo, digital_IbefLDO_limitHi, digital_IbefLDO_limitLo, digital_VaftLDO_warnHi, digital_VaftLDO_warnLo, digital_VaftLDO_limitHi, digital_VaftLDO_limitLo, digital_VaftSwch_warnHi, digital_VaftSwch_warnLo, digital_VaftSwch_limitHi, digital_VaftSwch_limitLo, digital_VbefLDO_warnHi, digital_VbefLDO_warnLo, digital_VbefLDO_limitHi, digital_VbefLDO_limitLo, dphi_IaftLDO_warnHi, dphi_IaftLDO_warnLo, dphi_IaftLDO_limitHi, dphi_IaftLDO_limitLo, dphi_IbefLDO_warnHi, dphi_IbefLDO_warnLo, dphi_IbefLDO_limitHi, dphi_IbefLDO_limitLo, dphi_VaftLDO_warnHi, dphi_VaftLDO_warnLo, dphi_VaftLDO_limitHi, dphi_VaftLDO_limitLo, dphi_VaftSwch_warnHi, dphi_VaftSwch_warnLo, dphi_VaftSwch_limitHi, dphi_VaftSwch_limitLo, dphi_VbefLDO_warnHi, dphi_VbefLDO_warnLo, dphi_VbefLDO_limitHi, dphi_VbefLDO_limitLo, heater_IaftLDO_warnHi, heater_IaftLDO_warnLo, heater_IaftLDO_limitHi, heater_IaftLDO_limitLo, heater_IbefLDO_warnHi, heater_IbefLDO_warnLo, heater_IbefLDO_limitHi, heater_IbefLDO_limitLo, heater_VaftLDO_warnHi, heater_VaftLDO_warnLo, heater_VaftLDO_limitHi, heater_VaftLDO_limitLo, heater_VaftSwch_warnHi, heater_VaftSwch_warnLo, heater_VaftSwch_limitHi, heater_VaftSwch_limitLo, heater_VbefLDO_warnHi, heater_VbefLDO_warnLo, heater_VbefLDO_limitHi, heater_VbefLDO_limitLo, hvbias_IbefSwch_warnHi, hvbias_IbefSwch_warnLo, hvbias_IbefSwch_limitHi, hvbias_IbefSwch_limitLo, hvbias_VbefSwch_warnHi, hvbias_VbefSwch_warnLo, hvbias_VbefSwch_limitHi, hvbias_VbefSwch_limitLo, location, od_IaftLDO_warnHi, od_IaftLDO_warnLo, od_IaftLDO_limitHi, od_IaftLDO_limitLo, od_IbefLDO_warnHi, od_IbefLDO_warnLo, od_IbefLDO_limitHi, od_IbefLDO_limitLo, od_VaftLDO2_warnHi, od_VaftLDO2_warnLo, od_VaftLDO2_limitHi, od_VaftLDO2_limitLo, od_VaftLDO_warnHi, od_VaftLDO_warnLo, od_VaftLDO_limitHi, od_VaftLDO_limitLo, od_VaftSwch_warnHi, od_VaftSwch_warnLo, od_VaftSwch_limitHi, od_VaftSwch_limitLo, od_VbefLDO_warnHi, od_VbefLDO_warnLo, od_VbefLDO_limitHi, od_VbefLDO_limitLo, power_warnHi, power_warnLo, power_limitHi, power_limitLo));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Reb_LimitsConfigurationEvent));
        Rebpower_Reb_LimitsConfigurationEvent item_ = (Rebpower_Reb_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])analog_IaftLDO_warnHi, (double[])item_.getAnalog_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IaftLDO_warnLo, (double[])item_.getAnalog_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IaftLDO_limitHi, (double[])item_.getAnalog_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IaftLDO_limitLo, (double[])item_.getAnalog_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO_warnHi, (double[])item_.getAnalog_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO_warnLo, (double[])item_.getAnalog_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO_limitHi, (double[])item_.getAnalog_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO_limitLo, (double[])item_.getAnalog_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO_warnHi, (double[])item_.getAnalog_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO_warnLo, (double[])item_.getAnalog_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO_limitHi, (double[])item_.getAnalog_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO_limitLo, (double[])item_.getAnalog_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch_warnHi, (double[])item_.getAnalog_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch_warnLo, (double[])item_.getAnalog_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch_limitHi, (double[])item_.getAnalog_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch_limitLo, (double[])item_.getAnalog_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO_warnHi, (double[])item_.getAnalog_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO_warnLo, (double[])item_.getAnalog_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO_limitHi, (double[])item_.getAnalog_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO_limitLo, (double[])item_.getAnalog_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO_warnHi, (double[])item_.getClockhi_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO_warnLo, (double[])item_.getClockhi_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO_limitHi, (double[])item_.getClockhi_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO_limitLo, (double[])item_.getClockhi_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO_warnHi, (double[])item_.getClockhi_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO_warnLo, (double[])item_.getClockhi_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO_limitHi, (double[])item_.getClockhi_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO_limitLo, (double[])item_.getClockhi_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO_warnHi, (double[])item_.getClockhi_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO_warnLo, (double[])item_.getClockhi_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO_limitHi, (double[])item_.getClockhi_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO_limitLo, (double[])item_.getClockhi_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch_warnHi, (double[])item_.getClockhi_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch_warnLo, (double[])item_.getClockhi_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch_limitHi, (double[])item_.getClockhi_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch_limitLo, (double[])item_.getClockhi_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO_warnHi, (double[])item_.getClockhi_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO_warnLo, (double[])item_.getClockhi_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO_limitHi, (double[])item_.getClockhi_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO_limitLo, (double[])item_.getClockhi_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO_warnHi, (double[])item_.getClocklo_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO_warnLo, (double[])item_.getClocklo_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO_limitHi, (double[])item_.getClocklo_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO_limitLo, (double[])item_.getClocklo_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO_warnHi, (double[])item_.getClocklo_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO_warnLo, (double[])item_.getClocklo_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO_limitHi, (double[])item_.getClocklo_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO_limitLo, (double[])item_.getClocklo_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2_warnHi, (double[])item_.getClocklo_VaftLDO2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2_warnLo, (double[])item_.getClocklo_VaftLDO2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2_limitHi, (double[])item_.getClocklo_VaftLDO2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2_limitLo, (double[])item_.getClocklo_VaftLDO2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO_warnHi, (double[])item_.getClocklo_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO_warnLo, (double[])item_.getClocklo_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO_limitHi, (double[])item_.getClocklo_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO_limitLo, (double[])item_.getClocklo_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch_warnHi, (double[])item_.getClocklo_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch_warnLo, (double[])item_.getClocklo_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch_limitHi, (double[])item_.getClocklo_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch_limitLo, (double[])item_.getClocklo_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO_warnHi, (double[])item_.getClocklo_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO_warnLo, (double[])item_.getClocklo_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO_limitHi, (double[])item_.getClocklo_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO_limitLo, (double[])item_.getClocklo_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO_warnHi, (double[])item_.getDigital_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO_warnLo, (double[])item_.getDigital_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO_limitHi, (double[])item_.getDigital_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO_limitLo, (double[])item_.getDigital_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO_warnHi, (double[])item_.getDigital_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO_warnLo, (double[])item_.getDigital_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO_limitHi, (double[])item_.getDigital_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO_limitLo, (double[])item_.getDigital_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO_warnHi, (double[])item_.getDigital_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO_warnLo, (double[])item_.getDigital_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO_limitHi, (double[])item_.getDigital_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO_limitLo, (double[])item_.getDigital_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch_warnHi, (double[])item_.getDigital_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch_warnLo, (double[])item_.getDigital_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch_limitHi, (double[])item_.getDigital_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch_limitLo, (double[])item_.getDigital_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO_warnHi, (double[])item_.getDigital_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO_warnLo, (double[])item_.getDigital_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO_limitHi, (double[])item_.getDigital_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO_limitLo, (double[])item_.getDigital_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IaftLDO_warnHi, (double[])item_.getDphi_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IaftLDO_warnLo, (double[])item_.getDphi_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IaftLDO_limitHi, (double[])item_.getDphi_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IaftLDO_limitLo, (double[])item_.getDphi_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IbefLDO_warnHi, (double[])item_.getDphi_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IbefLDO_warnLo, (double[])item_.getDphi_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IbefLDO_limitHi, (double[])item_.getDphi_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IbefLDO_limitLo, (double[])item_.getDphi_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftLDO_warnHi, (double[])item_.getDphi_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftLDO_warnLo, (double[])item_.getDphi_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftLDO_limitHi, (double[])item_.getDphi_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftLDO_limitLo, (double[])item_.getDphi_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftSwch_warnHi, (double[])item_.getDphi_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftSwch_warnLo, (double[])item_.getDphi_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftSwch_limitHi, (double[])item_.getDphi_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftSwch_limitLo, (double[])item_.getDphi_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VbefLDO_warnHi, (double[])item_.getDphi_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VbefLDO_warnLo, (double[])item_.getDphi_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VbefLDO_limitHi, (double[])item_.getDphi_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VbefLDO_limitLo, (double[])item_.getDphi_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO_warnHi, (double[])item_.getHeater_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO_warnLo, (double[])item_.getHeater_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO_limitHi, (double[])item_.getHeater_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO_limitLo, (double[])item_.getHeater_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO_warnHi, (double[])item_.getHeater_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO_warnLo, (double[])item_.getHeater_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO_limitHi, (double[])item_.getHeater_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO_limitLo, (double[])item_.getHeater_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO_warnHi, (double[])item_.getHeater_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO_warnLo, (double[])item_.getHeater_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO_limitHi, (double[])item_.getHeater_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO_limitLo, (double[])item_.getHeater_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch_warnHi, (double[])item_.getHeater_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch_warnLo, (double[])item_.getHeater_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch_limitHi, (double[])item_.getHeater_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch_limitLo, (double[])item_.getHeater_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO_warnHi, (double[])item_.getHeater_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO_warnLo, (double[])item_.getHeater_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO_limitHi, (double[])item_.getHeater_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO_limitLo, (double[])item_.getHeater_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch_warnHi, (double[])item_.getHvbias_IbefSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch_warnLo, (double[])item_.getHvbias_IbefSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch_limitHi, (double[])item_.getHvbias_IbefSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch_limitLo, (double[])item_.getHvbias_IbefSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch_warnHi, (double[])item_.getHvbias_VbefSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch_warnLo, (double[])item_.getHvbias_VbefSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch_limitHi, (double[])item_.getHvbias_VbefSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch_limitLo, (double[])item_.getHvbias_VbefSwch_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])od_IaftLDO_warnHi, (double[])item_.getOd_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IaftLDO_warnLo, (double[])item_.getOd_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IaftLDO_limitHi, (double[])item_.getOd_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IaftLDO_limitLo, (double[])item_.getOd_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO_warnHi, (double[])item_.getOd_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO_warnLo, (double[])item_.getOd_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO_limitHi, (double[])item_.getOd_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO_limitLo, (double[])item_.getOd_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2_warnHi, (double[])item_.getOd_VaftLDO2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2_warnLo, (double[])item_.getOd_VaftLDO2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2_limitHi, (double[])item_.getOd_VaftLDO2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2_limitLo, (double[])item_.getOd_VaftLDO2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO_warnHi, (double[])item_.getOd_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO_warnLo, (double[])item_.getOd_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO_limitHi, (double[])item_.getOd_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO_limitLo, (double[])item_.getOd_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch_warnHi, (double[])item_.getOd_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch_warnLo, (double[])item_.getOd_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch_limitHi, (double[])item_.getOd_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch_limitLo, (double[])item_.getOd_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO_warnHi, (double[])item_.getOd_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO_warnLo, (double[])item_.getOd_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO_limitHi, (double[])item_.getOd_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO_limitLo, (double[])item_.getOd_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_warnHi, (double[])item_.getPower_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_warnLo, (double[])item_.getPower_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_limitHi, (double[])item_.getPower_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_limitLo, (double[])item_.getPower_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_Rebps_LimitsConfigurationEvent() throws Exception {
        String version = "j";
        double[] boardtemp0_warnHi = TestHelper.generateDoubleArray((int)13, (int)880320087);
        double[] boardtemp0_warnLo = TestHelper.generateDoubleArray((int)13, (int)-1036408008);
        double[] boardtemp0_limitHi = TestHelper.generateDoubleArray((int)13, (int)-1414777772);
        double[] boardtemp0_limitLo = TestHelper.generateDoubleArray((int)13, (int)-1311006219);
        double[] boardtemp1_warnHi = TestHelper.generateDoubleArray((int)13, (int)1077313887);
        double[] boardtemp1_warnLo = TestHelper.generateDoubleArray((int)13, (int)925326478);
        double[] boardtemp1_limitHi = TestHelper.generateDoubleArray((int)13, (int)2045514726);
        double[] boardtemp1_limitLo = TestHelper.generateDoubleArray((int)13, (int)639418088);
        double[] boardtemp2_warnHi = TestHelper.generateDoubleArray((int)13, (int)2013467549);
        double[] boardtemp2_warnLo = TestHelper.generateDoubleArray((int)13, (int)-1307455252);
        double[] boardtemp2_limitHi = TestHelper.generateDoubleArray((int)13, (int)328977206);
        double[] boardtemp2_limitLo = TestHelper.generateDoubleArray((int)13, (int)-2100221899);
        double[] boardtemp3_warnHi = TestHelper.generateDoubleArray((int)13, (int)56504754);
        double[] boardtemp3_warnLo = TestHelper.generateDoubleArray((int)13, (int)1673514815);
        double[] boardtemp3_limitHi = TestHelper.generateDoubleArray((int)13, (int)1393596098);
        double[] boardtemp3_limitLo = TestHelper.generateDoubleArray((int)13, (int)-1545785992);
        double[] boardtemp4_warnHi = TestHelper.generateDoubleArray((int)13, (int)2132543447);
        double[] boardtemp4_warnLo = TestHelper.generateDoubleArray((int)13, (int)-1760192352);
        double[] boardtemp4_limitHi = TestHelper.generateDoubleArray((int)13, (int)-869769270);
        double[] boardtemp4_limitLo = TestHelper.generateDoubleArray((int)13, (int)-470155428);
        double[] boardtemp5_warnHi = TestHelper.generateDoubleArray((int)13, (int)-1099478714);
        double[] boardtemp5_warnLo = TestHelper.generateDoubleArray((int)13, (int)197809642);
        double[] boardtemp5_limitHi = TestHelper.generateDoubleArray((int)13, (int)-932422568);
        double[] boardtemp5_limitLo = TestHelper.generateDoubleArray((int)13, (int)-1897436847);
        double[] boardtemp6_warnHi = TestHelper.generateDoubleArray((int)13, (int)1627716056);
        double[] boardtemp6_warnLo = TestHelper.generateDoubleArray((int)13, (int)-242333044);
        double[] boardtemp6_limitHi = TestHelper.generateDoubleArray((int)13, (int)997141376);
        double[] boardtemp6_limitLo = TestHelper.generateDoubleArray((int)13, (int)-2121076101);
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Rebps_LimitsConfigurationEvent(version, boardtemp0_warnHi, boardtemp0_warnLo, boardtemp0_limitHi, boardtemp0_limitLo, boardtemp1_warnHi, boardtemp1_warnLo, boardtemp1_limitHi, boardtemp1_limitLo, boardtemp2_warnHi, boardtemp2_warnLo, boardtemp2_limitHi, boardtemp2_limitLo, boardtemp3_warnHi, boardtemp3_warnLo, boardtemp3_limitHi, boardtemp3_limitLo, boardtemp4_warnHi, boardtemp4_warnLo, boardtemp4_limitHi, boardtemp4_limitLo, boardtemp5_warnHi, boardtemp5_warnLo, boardtemp5_limitHi, boardtemp5_limitLo, boardtemp6_warnHi, boardtemp6_warnLo, boardtemp6_limitHi, boardtemp6_limitLo, location));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Rebps_LimitsConfigurationEvent));
        Rebpower_Rebps_LimitsConfigurationEvent item_ = (Rebpower_Rebps_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])boardtemp0_warnHi, (double[])item_.getBoardtemp0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp0_warnLo, (double[])item_.getBoardtemp0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp0_limitHi, (double[])item_.getBoardtemp0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp0_limitLo, (double[])item_.getBoardtemp0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp1_warnHi, (double[])item_.getBoardtemp1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp1_warnLo, (double[])item_.getBoardtemp1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp1_limitHi, (double[])item_.getBoardtemp1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp1_limitLo, (double[])item_.getBoardtemp1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp2_warnHi, (double[])item_.getBoardtemp2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp2_warnLo, (double[])item_.getBoardtemp2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp2_limitHi, (double[])item_.getBoardtemp2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp2_limitLo, (double[])item_.getBoardtemp2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp3_warnHi, (double[])item_.getBoardtemp3_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp3_warnLo, (double[])item_.getBoardtemp3_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp3_limitHi, (double[])item_.getBoardtemp3_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp3_limitLo, (double[])item_.getBoardtemp3_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp4_warnHi, (double[])item_.getBoardtemp4_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp4_warnLo, (double[])item_.getBoardtemp4_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp4_limitHi, (double[])item_.getBoardtemp4_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp4_limitLo, (double[])item_.getBoardtemp4_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp5_warnHi, (double[])item_.getBoardtemp5_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp5_warnLo, (double[])item_.getBoardtemp5_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp5_limitHi, (double[])item_.getBoardtemp5_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp5_limitLo, (double[])item_.getBoardtemp5_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp6_warnHi, (double[])item_.getBoardtemp6_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp6_warnLo, (double[])item_.getBoardtemp6_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp6_limitHi, (double[])item_.getBoardtemp6_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp6_limitLo, (double[])item_.getBoardtemp6_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveRebpower_Rebps_PowerConfigurationEvent() throws Exception {
        String version = "";
        String ipAddr = "";
        String location = "";
        int[] nPowerOnPub = TestHelper.generateIntArray((int)13, (int)-1590532971);
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Rebps_PowerConfigurationEvent(version, ipAddr, location, nPowerOnPub));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Rebps_PowerConfigurationEvent));
        Rebpower_Rebps_PowerConfigurationEvent item_ = (Rebpower_Rebps_PowerConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)ipAddr, (Object)item_.getIpAddr());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((int[])nPowerOnPub, (int[])item_.getNPowerOnPub());
    }

    @Test
    public void sendReceiveHexConfigurationEvent() throws Exception {
        String version = "n";
        double rtnToEvapOffset = 0.9935399293899536;
        SALEvent item = this.testSendReceive((SALEvent)new HexConfigurationEvent(version, rtnToEvapOffset));
        Assert.assertTrue((boolean)(item instanceof HexConfigurationEvent));
        HexConfigurationEvent item_ = (HexConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)rtnToEvapOffset, (double)item_.getRtnToEvapOffset(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cold1_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double evapexittmp_warnHi = 0.940955400466919;
        double evapexittmp_warnLo = 0.7775058150291443;
        double evapexittmp_limitHi = 0.10151857137680054;
        double evapexittmp_limitLo = 0.1776370406150818;
        double hexrtrntmp_warnHi = 0.11870795488357544;
        double hexrtrntmp_warnLo = 0.24811553955078125;
        double hexrtrntmp_limitHi = 0.058002352714538574;
        double hexrtrntmp_limitLo = 0.5878888368606567;
        double preexpntmp_warnHi = 0.34279865026474;
        double preexpntmp_warnLo = 0.446674644947052;
        double preexpntmp_limitHi = 0.6790383458137512;
        double preexpntmp_limitLo = 0.5738877654075623;
        double returnprs_warnHi = 0.4055485725402832;
        double returnprs_warnLo = 0.8601377010345459;
        double returnprs_limitHi = 0.21220511198043823;
        double returnprs_limitLo = 0.9195892214775085;
        double superheat_warnHi = 0.9851754307746887;
        double superheat_warnLo = 0.4957928f;
        double superheat_limitHi = 0.7163221836090088;
        double superheat_limitLo = 0.6140961050987244;
        double supplyprs_warnHi = 0.5226884484291077;
        double supplyprs_warnLo = 0.19604378938674927;
        double supplyprs_limitHi = 0.8590373396873474;
        double supplyprs_limitLo = 0.9079030752182007;
        double supplysubcooling_warnHi = 0.4614155888557434;
        double supplysubcooling_warnLo = 0.5501790642738342;
        double supplysubcooling_limitHi = 0.5983737707138062;
        double supplysubcooling_limitLo = 0.4326738715171814;
        double supplytmp_warnHi = 0.4598551392555237;
        double supplytmp_warnLo = 0.9665083885192871;
        double supplytmp_limitHi = 0.743118405342102;
        double supplytmp_limitLo = 0.29607248306274414;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cold1_LimitsConfigurationEvent(version, evapexittmp_warnHi, evapexittmp_warnLo, evapexittmp_limitHi, evapexittmp_limitLo, hexrtrntmp_warnHi, hexrtrntmp_warnLo, hexrtrntmp_limitHi, hexrtrntmp_limitLo, preexpntmp_warnHi, preexpntmp_warnLo, preexpntmp_limitHi, preexpntmp_limitLo, returnprs_warnHi, returnprs_warnLo, returnprs_limitHi, returnprs_limitLo, superheat_warnHi, superheat_warnLo, superheat_limitHi, superheat_limitLo, supplyprs_warnHi, supplyprs_warnLo, supplyprs_limitHi, supplyprs_limitLo, supplysubcooling_warnHi, supplysubcooling_warnLo, supplysubcooling_limitHi, supplysubcooling_limitLo, supplytmp_warnHi, supplytmp_warnLo, supplytmp_limitHi, supplytmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cold1_LimitsConfigurationEvent));
        Hex_Cold1_LimitsConfigurationEvent item_ = (Hex_Cold1_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)evapexittmp_warnHi, (double)item_.getEvapexittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnLo, (double)item_.getEvapexittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitHi, (double)item_.getEvapexittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitLo, (double)item_.getEvapexittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnHi, (double)item_.getHexrtrntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnLo, (double)item_.getHexrtrntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitHi, (double)item_.getHexrtrntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitLo, (double)item_.getHexrtrntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)preexpntmp_warnHi, (double)item_.getPreexpntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)preexpntmp_warnLo, (double)item_.getPreexpntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)preexpntmp_limitHi, (double)item_.getPreexpntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)preexpntmp_limitLo, (double)item_.getPreexpntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnHi, (double)item_.getReturnprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnLo, (double)item_.getReturnprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitHi, (double)item_.getReturnprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitLo, (double)item_.getReturnprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)superheat_warnHi, (double)item_.getSuperheat_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)superheat_warnLo, (double)item_.getSuperheat_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)superheat_limitHi, (double)item_.getSuperheat_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)superheat_limitLo, (double)item_.getSuperheat_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyprs_warnHi, (double)item_.getSupplyprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyprs_warnLo, (double)item_.getSupplyprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyprs_limitHi, (double)item_.getSupplyprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyprs_limitLo, (double)item_.getSupplyprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplysubcooling_warnHi, (double)item_.getSupplysubcooling_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplysubcooling_warnLo, (double)item_.getSupplysubcooling_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplysubcooling_limitHi, (double)item_.getSupplysubcooling_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplysubcooling_limitLo, (double)item_.getSupplysubcooling_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_warnHi, (double)item_.getSupplytmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_warnLo, (double)item_.getSupplytmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_limitHi, (double)item_.getSupplytmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_limitLo, (double)item_.getSupplytmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cold2_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double evapexittmp_warnHi = 0.6063153743743896;
        double evapexittmp_warnLo = 0.7231611609458923;
        double evapexittmp_limitHi = 0.00729447603225708;
        double evapexittmp_limitLo = 0.33310025930404663;
        double hexrtrntmp_warnHi = 0.977205f;
        double hexrtrntmp_warnLo = 0.760383f;
        double hexrtrntmp_limitHi = 0.2865495f;
        double hexrtrntmp_limitLo = 0.11147481203079224;
        double preexpntmp_warnHi = 0.6011083126068115;
        double preexpntmp_warnLo = 0.9323744773864746;
        double preexpntmp_limitHi = 0.9278703927993774;
        double preexpntmp_limitLo = 0.2914939522743225;
        double returnprs_warnHi = 0.6405305862426758;
        double returnprs_warnLo = 0.7372221946716309;
        double returnprs_limitHi = 0.9749284982681274;
        double returnprs_limitLo = 0.6074967980384827;
        double superheat_warnHi = 0.030330181121826172;
        double superheat_warnLo = 0.7730217576026917;
        double superheat_limitHi = 0.23031193017959595;
        double superheat_limitLo = 0.6076322197914124;
        double supplyprs_warnHi = 0.13174086809158325;
        double supplyprs_warnLo = 0.06898140907287598;
        double supplyprs_limitHi = 0.13688474893569946;
        double supplyprs_limitLo = 0.4649277329444885;
        double supplysubcooling_warnHi = 0.32647645473480225;
        double supplysubcooling_warnLo = 0.6774181127548218;
        double supplysubcooling_limitHi = 0.07293188571929932;
        double supplysubcooling_limitLo = 0.2858484983444214;
        double supplytmp_warnHi = 0.1931876540184021;
        double supplytmp_warnLo = 0.042186856269836426;
        double supplytmp_limitHi = 0.2089687f;
        double supplytmp_limitLo = 0.3314070701599121;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cold2_LimitsConfigurationEvent(version, evapexittmp_warnHi, evapexittmp_warnLo, evapexittmp_limitHi, evapexittmp_limitLo, hexrtrntmp_warnHi, hexrtrntmp_warnLo, hexrtrntmp_limitHi, hexrtrntmp_limitLo, preexpntmp_warnHi, preexpntmp_warnLo, preexpntmp_limitHi, preexpntmp_limitLo, returnprs_warnHi, returnprs_warnLo, returnprs_limitHi, returnprs_limitLo, superheat_warnHi, superheat_warnLo, superheat_limitHi, superheat_limitLo, supplyprs_warnHi, supplyprs_warnLo, supplyprs_limitHi, supplyprs_limitLo, supplysubcooling_warnHi, supplysubcooling_warnLo, supplysubcooling_limitHi, supplysubcooling_limitLo, supplytmp_warnHi, supplytmp_warnLo, supplytmp_limitHi, supplytmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cold2_LimitsConfigurationEvent));
        Hex_Cold2_LimitsConfigurationEvent item_ = (Hex_Cold2_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)evapexittmp_warnHi, (double)item_.getEvapexittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnLo, (double)item_.getEvapexittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitHi, (double)item_.getEvapexittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitLo, (double)item_.getEvapexittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnHi, (double)item_.getHexrtrntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnLo, (double)item_.getHexrtrntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitHi, (double)item_.getHexrtrntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitLo, (double)item_.getHexrtrntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)preexpntmp_warnHi, (double)item_.getPreexpntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)preexpntmp_warnLo, (double)item_.getPreexpntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)preexpntmp_limitHi, (double)item_.getPreexpntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)preexpntmp_limitLo, (double)item_.getPreexpntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnHi, (double)item_.getReturnprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnLo, (double)item_.getReturnprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitHi, (double)item_.getReturnprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitLo, (double)item_.getReturnprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)superheat_warnHi, (double)item_.getSuperheat_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)superheat_warnLo, (double)item_.getSuperheat_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)superheat_limitHi, (double)item_.getSuperheat_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)superheat_limitLo, (double)item_.getSuperheat_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyprs_warnHi, (double)item_.getSupplyprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyprs_warnLo, (double)item_.getSupplyprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyprs_limitHi, (double)item_.getSupplyprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyprs_limitLo, (double)item_.getSupplyprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplysubcooling_warnHi, (double)item_.getSupplysubcooling_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplysubcooling_warnLo, (double)item_.getSupplysubcooling_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplysubcooling_limitHi, (double)item_.getSupplysubcooling_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplysubcooling_limitLo, (double)item_.getSupplysubcooling_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_warnHi, (double)item_.getSupplytmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_warnLo, (double)item_.getSupplytmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_limitHi, (double)item_.getSupplytmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_limitLo, (double)item_.getSupplytmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo1_LimitsConfigurationEvent() throws Exception {
        String version = "f";
        double c3exittmp_warnHi = 0.04214549f;
        double c3exittmp_warnLo = 0.9800314903259277;
        double c3exittmp_limitHi = 0.013203442096710205;
        double c3exittmp_limitLo = 0.25569117069244385;
        double c4exittmp_warnHi = 0.20352166891098022;
        double c4exittmp_warnLo = 0.250063419342041;
        double c4exittmp_limitHi = 0.3943629264831543;
        double c4exittmp_limitLo = 0.9378864169120789;
        double evapexittmp_warnHi = 0.9141576886177063;
        double evapexittmp_warnLo = 0.8772063255310059;
        double evapexittmp_limitHi = 0.3102787733078003;
        double evapexittmp_limitLo = 0.8030017614364624;
        double hexrtrntmp_warnHi = 0.7286413311958313;
        double hexrtrntmp_warnLo = 0.5008583068847656;
        double hexrtrntmp_limitHi = 0.4470691680908203;
        double hexrtrntmp_limitLo = 0.28140032291412354;
        double liquidprs_warnHi = 0.7706174850463867;
        double liquidprs_warnLo = 0.47354668378829956;
        double liquidprs_limitHi = 0.7385295629501343;
        double liquidprs_limitLo = 0.7813725471496582;
        double prec3tmp_warnHi = 0.24604082107543945;
        double prec3tmp_warnLo = 0.2682746648788452;
        double prec3tmp_limitHi = 0.7058215737342834;
        double prec3tmp_limitLo = 0.1090155839920044;
        double prec4tmp_warnHi = 0.46875715255737305;
        double prec4tmp_warnLo = 0.8462410569190979;
        double prec4tmp_limitHi = 0.9970532655715942;
        double prec4tmp_limitLo = 0.25281256437301636;
        double returnprs_warnHi = 0.1928073763847351;
        double returnprs_warnLo = 0.6669959425926208;
        double returnprs_limitHi = 0.6861705183982849;
        double returnprs_limitLo = 0.7266314625740051;
        double vaporprs_warnHi = 0.600325345993042;
        double vaporprs_warnLo = 0.10764491558074951;
        double vaporprs_limitHi = 0.573624312877655;
        double vaporprs_limitLo = 0.9979845881462097;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cryo1_LimitsConfigurationEvent(version, c3exittmp_warnHi, c3exittmp_warnLo, c3exittmp_limitHi, c3exittmp_limitLo, c4exittmp_warnHi, c4exittmp_warnLo, c4exittmp_limitHi, c4exittmp_limitLo, evapexittmp_warnHi, evapexittmp_warnLo, evapexittmp_limitHi, evapexittmp_limitLo, hexrtrntmp_warnHi, hexrtrntmp_warnLo, hexrtrntmp_limitHi, hexrtrntmp_limitLo, liquidprs_warnHi, liquidprs_warnLo, liquidprs_limitHi, liquidprs_limitLo, prec3tmp_warnHi, prec3tmp_warnLo, prec3tmp_limitHi, prec3tmp_limitLo, prec4tmp_warnHi, prec4tmp_warnLo, prec4tmp_limitHi, prec4tmp_limitLo, returnprs_warnHi, returnprs_warnLo, returnprs_limitHi, returnprs_limitLo, vaporprs_warnHi, vaporprs_warnLo, vaporprs_limitHi, vaporprs_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo1_LimitsConfigurationEvent));
        Hex_Cryo1_LimitsConfigurationEvent item_ = (Hex_Cryo1_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)c3exittmp_warnHi, (double)item_.getC3exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_warnLo, (double)item_.getC3exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitHi, (double)item_.getC3exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitLo, (double)item_.getC3exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnHi, (double)item_.getC4exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnLo, (double)item_.getC4exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitHi, (double)item_.getC4exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitLo, (double)item_.getC4exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnHi, (double)item_.getEvapexittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnLo, (double)item_.getEvapexittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitHi, (double)item_.getEvapexittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitLo, (double)item_.getEvapexittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnHi, (double)item_.getHexrtrntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnLo, (double)item_.getHexrtrntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitHi, (double)item_.getHexrtrntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitLo, (double)item_.getHexrtrntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnHi, (double)item_.getLiquidprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnLo, (double)item_.getLiquidprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitHi, (double)item_.getLiquidprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitLo, (double)item_.getLiquidprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnHi, (double)item_.getPrec3tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnLo, (double)item_.getPrec3tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitHi, (double)item_.getPrec3tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitLo, (double)item_.getPrec3tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnHi, (double)item_.getPrec4tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnLo, (double)item_.getPrec4tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitHi, (double)item_.getPrec4tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitLo, (double)item_.getPrec4tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnHi, (double)item_.getReturnprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnLo, (double)item_.getReturnprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitHi, (double)item_.getReturnprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitLo, (double)item_.getReturnprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnHi, (double)item_.getVaporprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnLo, (double)item_.getVaporprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitHi, (double)item_.getVaporprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitLo, (double)item_.getVaporprs_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo2_LimitsConfigurationEvent() throws Exception {
        String version = "y";
        double c3exittmp_warnHi = 0.07649964094161987;
        double c3exittmp_warnLo = 0.6318298578262329;
        double c3exittmp_limitHi = 0.23866015672683716;
        double c3exittmp_limitLo = 0.2174096703529358;
        double c4exittmp_warnHi = 0.8822810649871826;
        double c4exittmp_warnLo = 0.27603602409362793;
        double c4exittmp_limitHi = 0.5365505218505859;
        double c4exittmp_limitLo = 0.7377258539199829;
        double evapexittmp_warnHi = 0.9629201292991638;
        double evapexittmp_warnLo = 0.8280600905418396;
        double evapexittmp_limitHi = 0.969538688659668;
        double evapexittmp_limitLo = 0.22378402948379517;
        double hexrtrntmp_warnHi = 0.6647076606750488;
        double hexrtrntmp_warnLo = 0.3317262530326843;
        double hexrtrntmp_limitHi = 0.30432742834091187;
        double hexrtrntmp_limitLo = 0.7666182518005371;
        double liquidprs_warnHi = 0.7806218862533569;
        double liquidprs_warnLo = 0.8396885991096497;
        double liquidprs_limitHi = 0.9289778470993042;
        double liquidprs_limitLo = 0.3070452809333801;
        double prec3tmp_warnHi = 0.9169155359268188;
        double prec3tmp_warnLo = 0.57578444480896;
        double prec3tmp_limitHi = 0.907426655292511;
        double prec3tmp_limitLo = 0.16321277618408203;
        double prec4tmp_warnHi = 0.2419554591178894;
        double prec4tmp_warnLo = 0.8797241449356079;
        double prec4tmp_limitHi = 0.8299506306648254;
        double prec4tmp_limitLo = 0.7060214877128601;
        double returnprs_warnHi = 0.2755822539329529;
        double returnprs_warnLo = 0.20525145530700684;
        double returnprs_limitHi = 0.24436503648757935;
        double returnprs_limitLo = 0.25108712911605835;
        double vaporprs_warnHi = 0.6799971461296082;
        double vaporprs_warnLo = 0.6659785509109497;
        double vaporprs_limitHi = 0.25002098083496094;
        double vaporprs_limitLo = 0.7229271531105042;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cryo2_LimitsConfigurationEvent(version, c3exittmp_warnHi, c3exittmp_warnLo, c3exittmp_limitHi, c3exittmp_limitLo, c4exittmp_warnHi, c4exittmp_warnLo, c4exittmp_limitHi, c4exittmp_limitLo, evapexittmp_warnHi, evapexittmp_warnLo, evapexittmp_limitHi, evapexittmp_limitLo, hexrtrntmp_warnHi, hexrtrntmp_warnLo, hexrtrntmp_limitHi, hexrtrntmp_limitLo, liquidprs_warnHi, liquidprs_warnLo, liquidprs_limitHi, liquidprs_limitLo, prec3tmp_warnHi, prec3tmp_warnLo, prec3tmp_limitHi, prec3tmp_limitLo, prec4tmp_warnHi, prec4tmp_warnLo, prec4tmp_limitHi, prec4tmp_limitLo, returnprs_warnHi, returnprs_warnLo, returnprs_limitHi, returnprs_limitLo, vaporprs_warnHi, vaporprs_warnLo, vaporprs_limitHi, vaporprs_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo2_LimitsConfigurationEvent));
        Hex_Cryo2_LimitsConfigurationEvent item_ = (Hex_Cryo2_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)c3exittmp_warnHi, (double)item_.getC3exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_warnLo, (double)item_.getC3exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitHi, (double)item_.getC3exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitLo, (double)item_.getC3exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnHi, (double)item_.getC4exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnLo, (double)item_.getC4exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitHi, (double)item_.getC4exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitLo, (double)item_.getC4exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnHi, (double)item_.getEvapexittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnLo, (double)item_.getEvapexittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitHi, (double)item_.getEvapexittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitLo, (double)item_.getEvapexittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnHi, (double)item_.getHexrtrntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnLo, (double)item_.getHexrtrntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitHi, (double)item_.getHexrtrntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitLo, (double)item_.getHexrtrntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnHi, (double)item_.getLiquidprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnLo, (double)item_.getLiquidprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitHi, (double)item_.getLiquidprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitLo, (double)item_.getLiquidprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnHi, (double)item_.getPrec3tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnLo, (double)item_.getPrec3tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitHi, (double)item_.getPrec3tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitLo, (double)item_.getPrec3tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnHi, (double)item_.getPrec4tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnLo, (double)item_.getPrec4tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitHi, (double)item_.getPrec4tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitLo, (double)item_.getPrec4tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnHi, (double)item_.getReturnprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnLo, (double)item_.getReturnprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitHi, (double)item_.getReturnprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitLo, (double)item_.getReturnprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnHi, (double)item_.getVaporprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnLo, (double)item_.getVaporprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitHi, (double)item_.getVaporprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitLo, (double)item_.getVaporprs_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo3_LimitsConfigurationEvent() throws Exception {
        String version = "j";
        double c3exittmp_warnHi = 0.13155996799468994;
        double c3exittmp_warnLo = 0.2183634638786316;
        double c3exittmp_limitHi = 0.2160738706588745;
        double c3exittmp_limitLo = 0.5816146731376648;
        double c4exittmp_warnHi = 0.7731895446777344;
        double c4exittmp_warnLo = 0.5222405195236206;
        double c4exittmp_limitHi = 0.9409773945808411;
        double c4exittmp_limitLo = 0.4059907793998718;
        double evapexittmp_warnHi = 0.9888686537742615;
        double evapexittmp_warnLo = 0.25809115171432495;
        double evapexittmp_limitHi = 0.9107029438018799;
        double evapexittmp_limitLo = 0.2324819564819336;
        double hexrtrntmp_warnHi = 0.9317814707756042;
        double hexrtrntmp_warnLo = 0.36610865592956543;
        double hexrtrntmp_limitHi = 0.3345072269439697;
        double hexrtrntmp_limitLo = 0.05174213647842407;
        double liquidprs_warnHi = 0.9009913802146912;
        double liquidprs_warnLo = 0.2455756664276123;
        double liquidprs_limitHi = 0.5896274447441101;
        double liquidprs_limitLo = 0.9663316607475281;
        double prec3tmp_warnHi = 0.2779970169067383;
        double prec3tmp_warnLo = 0.2617756724357605;
        double prec3tmp_limitHi = 0.19612634181976318;
        double prec3tmp_limitLo = 0.8576100468635559;
        double prec4tmp_warnHi = 0.0254705548286438;
        double prec4tmp_warnLo = 0.5594959259033203;
        double prec4tmp_limitHi = 0.3501044511795044;
        double prec4tmp_limitLo = 0.5879529118537903;
        double returnprs_warnHi = 0.32978355884552;
        double returnprs_warnLo = 0.735785186290741;
        double returnprs_limitHi = 0.49566978216171265;
        double returnprs_limitLo = 0.08542346954345703;
        double vaporprs_warnHi = 0.1236853f;
        double vaporprs_warnLo = 0.971034824848175;
        double vaporprs_limitHi = 0.8473304510116577;
        double vaporprs_limitLo = 0.3294628858566284;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cryo3_LimitsConfigurationEvent(version, c3exittmp_warnHi, c3exittmp_warnLo, c3exittmp_limitHi, c3exittmp_limitLo, c4exittmp_warnHi, c4exittmp_warnLo, c4exittmp_limitHi, c4exittmp_limitLo, evapexittmp_warnHi, evapexittmp_warnLo, evapexittmp_limitHi, evapexittmp_limitLo, hexrtrntmp_warnHi, hexrtrntmp_warnLo, hexrtrntmp_limitHi, hexrtrntmp_limitLo, liquidprs_warnHi, liquidprs_warnLo, liquidprs_limitHi, liquidprs_limitLo, prec3tmp_warnHi, prec3tmp_warnLo, prec3tmp_limitHi, prec3tmp_limitLo, prec4tmp_warnHi, prec4tmp_warnLo, prec4tmp_limitHi, prec4tmp_limitLo, returnprs_warnHi, returnprs_warnLo, returnprs_limitHi, returnprs_limitLo, vaporprs_warnHi, vaporprs_warnLo, vaporprs_limitHi, vaporprs_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo3_LimitsConfigurationEvent));
        Hex_Cryo3_LimitsConfigurationEvent item_ = (Hex_Cryo3_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)c3exittmp_warnHi, (double)item_.getC3exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_warnLo, (double)item_.getC3exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitHi, (double)item_.getC3exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitLo, (double)item_.getC3exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnHi, (double)item_.getC4exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnLo, (double)item_.getC4exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitHi, (double)item_.getC4exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitLo, (double)item_.getC4exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnHi, (double)item_.getEvapexittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnLo, (double)item_.getEvapexittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitHi, (double)item_.getEvapexittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitLo, (double)item_.getEvapexittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnHi, (double)item_.getHexrtrntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnLo, (double)item_.getHexrtrntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitHi, (double)item_.getHexrtrntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitLo, (double)item_.getHexrtrntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnHi, (double)item_.getLiquidprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnLo, (double)item_.getLiquidprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitHi, (double)item_.getLiquidprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitLo, (double)item_.getLiquidprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnHi, (double)item_.getPrec3tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnLo, (double)item_.getPrec3tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitHi, (double)item_.getPrec3tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitLo, (double)item_.getPrec3tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnHi, (double)item_.getPrec4tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnLo, (double)item_.getPrec4tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitHi, (double)item_.getPrec4tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitLo, (double)item_.getPrec4tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnHi, (double)item_.getReturnprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnLo, (double)item_.getReturnprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitHi, (double)item_.getReturnprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitLo, (double)item_.getReturnprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnHi, (double)item_.getVaporprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnLo, (double)item_.getVaporprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitHi, (double)item_.getVaporprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitLo, (double)item_.getVaporprs_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo4_LimitsConfigurationEvent() throws Exception {
        String version = "g";
        double c3exittmp_warnHi = 0.7927321195602417;
        double c3exittmp_warnLo = 0.0016371607780456543;
        double c3exittmp_limitHi = 0.32815104722976685;
        double c3exittmp_limitLo = 0.7488806247711182;
        double c4exittmp_warnHi = 0.3368644118309021;
        double c4exittmp_warnLo = 0.11643165349960327;
        double c4exittmp_limitHi = 0.25121062994003296;
        double c4exittmp_limitLo = 0.08798271417617798;
        double evapexittmp_warnHi = 0.5846213102340698;
        double evapexittmp_warnLo = 0.48808616399765015;
        double evapexittmp_limitHi = 0.1276019811630249;
        double evapexittmp_limitLo = 0.2578394412994385;
        double hexrtrntmp_warnHi = 0.10613560676574707;
        double hexrtrntmp_warnLo = 0.3082171082496643;
        double hexrtrntmp_limitHi = 0.9318339228630066;
        double hexrtrntmp_limitLo = 0.8321828842163086;
        double liquidprs_warnHi = 0.5614796280860901;
        double liquidprs_warnLo = 0.24628931283950806;
        double liquidprs_limitHi = 0.9507452249526978;
        double liquidprs_limitLo = 0.3649328351020813;
        double prec3tmp_warnHi = 0.3665999174118042;
        double prec3tmp_warnLo = 0.38482964038848877;
        double prec3tmp_limitHi = 0.8802147507667542;
        double prec3tmp_limitLo = 0.2488483190536499;
        double prec4tmp_warnHi = 0.4148409366607666;
        double prec4tmp_warnLo = 0.4606884f;
        double prec4tmp_limitHi = 0.6602405309677124;
        double prec4tmp_limitLo = 0.9092357754707336;
        double returnprs_warnHi = 0.8978352546691895;
        double returnprs_warnLo = 0.50284343957901;
        double returnprs_limitHi = 0.21597141027450562;
        double returnprs_limitLo = 0.002817809581756592;
        double vaporprs_warnHi = 0.33124858140945435;
        double vaporprs_warnLo = 0.1895303726196289;
        double vaporprs_limitHi = 0.7303743362426758;
        double vaporprs_limitLo = 0.34034425020217896;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cryo4_LimitsConfigurationEvent(version, c3exittmp_warnHi, c3exittmp_warnLo, c3exittmp_limitHi, c3exittmp_limitLo, c4exittmp_warnHi, c4exittmp_warnLo, c4exittmp_limitHi, c4exittmp_limitLo, evapexittmp_warnHi, evapexittmp_warnLo, evapexittmp_limitHi, evapexittmp_limitLo, hexrtrntmp_warnHi, hexrtrntmp_warnLo, hexrtrntmp_limitHi, hexrtrntmp_limitLo, liquidprs_warnHi, liquidprs_warnLo, liquidprs_limitHi, liquidprs_limitLo, prec3tmp_warnHi, prec3tmp_warnLo, prec3tmp_limitHi, prec3tmp_limitLo, prec4tmp_warnHi, prec4tmp_warnLo, prec4tmp_limitHi, prec4tmp_limitLo, returnprs_warnHi, returnprs_warnLo, returnprs_limitHi, returnprs_limitLo, vaporprs_warnHi, vaporprs_warnLo, vaporprs_limitHi, vaporprs_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo4_LimitsConfigurationEvent));
        Hex_Cryo4_LimitsConfigurationEvent item_ = (Hex_Cryo4_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)c3exittmp_warnHi, (double)item_.getC3exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_warnLo, (double)item_.getC3exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitHi, (double)item_.getC3exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitLo, (double)item_.getC3exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnHi, (double)item_.getC4exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnLo, (double)item_.getC4exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitHi, (double)item_.getC4exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitLo, (double)item_.getC4exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnHi, (double)item_.getEvapexittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnLo, (double)item_.getEvapexittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitHi, (double)item_.getEvapexittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitLo, (double)item_.getEvapexittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnHi, (double)item_.getHexrtrntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnLo, (double)item_.getHexrtrntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitHi, (double)item_.getHexrtrntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitLo, (double)item_.getHexrtrntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnHi, (double)item_.getLiquidprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnLo, (double)item_.getLiquidprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitHi, (double)item_.getLiquidprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitLo, (double)item_.getLiquidprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnHi, (double)item_.getPrec3tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnLo, (double)item_.getPrec3tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitHi, (double)item_.getPrec3tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitLo, (double)item_.getPrec3tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnHi, (double)item_.getPrec4tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnLo, (double)item_.getPrec4tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitHi, (double)item_.getPrec4tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitLo, (double)item_.getPrec4tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnHi, (double)item_.getReturnprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnLo, (double)item_.getReturnprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitHi, (double)item_.getReturnprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitLo, (double)item_.getReturnprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnHi, (double)item_.getVaporprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnLo, (double)item_.getVaporprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitHi, (double)item_.getVaporprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitLo, (double)item_.getVaporprs_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo5_LimitsConfigurationEvent() throws Exception {
        String version = "m";
        double c3exittmp_warnHi = 0.931314f;
        double c3exittmp_warnLo = 0.1333240270614624;
        double c3exittmp_limitHi = 0.06915563344955444;
        double c3exittmp_limitLo = 0.8116698861122131;
        double c4exittmp_warnHi = 0.8750594854354858;
        double c4exittmp_warnLo = 0.38524436950683594;
        double c4exittmp_limitHi = 0.9800442457199097;
        double c4exittmp_limitLo = 0.28536665439605713;
        double evapexittmp_warnHi = 0.2334151268005371;
        double evapexittmp_warnLo = 0.1388377547264099;
        double evapexittmp_limitHi = 0.5651848912239075;
        double evapexittmp_limitLo = 0.5733909606933594;
        double hexrtrntmp_warnHi = 0.41720718145370483;
        double hexrtrntmp_warnLo = 0.26448744535446167;
        double hexrtrntmp_limitHi = 0.35695648193359375;
        double hexrtrntmp_limitLo = 0.8900324106216431;
        double liquidprs_warnHi = 0.4097848f;
        double liquidprs_warnLo = 0.2699854373931885;
        double liquidprs_limitHi = 0.3449241f;
        double liquidprs_limitLo = 0.6514145731925964;
        double prec3tmp_warnHi = 0.7461811900138855;
        double prec3tmp_warnLo = 0.5459582805633545;
        double prec3tmp_limitHi = 0.5232203006744385;
        double prec3tmp_limitLo = 0.690171480178833;
        double prec4tmp_warnHi = 0.10290920734405518;
        double prec4tmp_warnLo = 0.679862916469574;
        double prec4tmp_limitHi = 0.6237860321998596;
        double prec4tmp_limitLo = 0.17658203840255737;
        double returnprs_warnHi = 0.7969587445259094;
        double returnprs_warnLo = 0.1981566f;
        double returnprs_limitHi = 0.2166767716407776;
        double returnprs_limitLo = 0.09368312358856201;
        double vaporprs_warnHi = 0.6079548001289368;
        double vaporprs_warnLo = 0.8828257322311401;
        double vaporprs_limitHi = 0.8750627636909485;
        double vaporprs_limitLo = 0.3472723364830017;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cryo5_LimitsConfigurationEvent(version, c3exittmp_warnHi, c3exittmp_warnLo, c3exittmp_limitHi, c3exittmp_limitLo, c4exittmp_warnHi, c4exittmp_warnLo, c4exittmp_limitHi, c4exittmp_limitLo, evapexittmp_warnHi, evapexittmp_warnLo, evapexittmp_limitHi, evapexittmp_limitLo, hexrtrntmp_warnHi, hexrtrntmp_warnLo, hexrtrntmp_limitHi, hexrtrntmp_limitLo, liquidprs_warnHi, liquidprs_warnLo, liquidprs_limitHi, liquidprs_limitLo, prec3tmp_warnHi, prec3tmp_warnLo, prec3tmp_limitHi, prec3tmp_limitLo, prec4tmp_warnHi, prec4tmp_warnLo, prec4tmp_limitHi, prec4tmp_limitLo, returnprs_warnHi, returnprs_warnLo, returnprs_limitHi, returnprs_limitLo, vaporprs_warnHi, vaporprs_warnLo, vaporprs_limitHi, vaporprs_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo5_LimitsConfigurationEvent));
        Hex_Cryo5_LimitsConfigurationEvent item_ = (Hex_Cryo5_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)c3exittmp_warnHi, (double)item_.getC3exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_warnLo, (double)item_.getC3exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitHi, (double)item_.getC3exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitLo, (double)item_.getC3exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnHi, (double)item_.getC4exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnLo, (double)item_.getC4exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitHi, (double)item_.getC4exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitLo, (double)item_.getC4exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnHi, (double)item_.getEvapexittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnLo, (double)item_.getEvapexittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitHi, (double)item_.getEvapexittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitLo, (double)item_.getEvapexittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnHi, (double)item_.getHexrtrntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnLo, (double)item_.getHexrtrntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitHi, (double)item_.getHexrtrntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitLo, (double)item_.getHexrtrntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnHi, (double)item_.getLiquidprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnLo, (double)item_.getLiquidprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitHi, (double)item_.getLiquidprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitLo, (double)item_.getLiquidprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnHi, (double)item_.getPrec3tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnLo, (double)item_.getPrec3tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitHi, (double)item_.getPrec3tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitLo, (double)item_.getPrec3tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnHi, (double)item_.getPrec4tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnLo, (double)item_.getPrec4tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitHi, (double)item_.getPrec4tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitLo, (double)item_.getPrec4tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnHi, (double)item_.getReturnprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnLo, (double)item_.getReturnprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitHi, (double)item_.getReturnprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitLo, (double)item_.getReturnprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnHi, (double)item_.getVaporprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnLo, (double)item_.getVaporprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitHi, (double)item_.getVaporprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitLo, (double)item_.getVaporprs_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo6_LimitsConfigurationEvent() throws Exception {
        String version = "f";
        double c3exittmp_warnHi = 0.2713779807090759;
        double c3exittmp_warnLo = 0.5309661030769348;
        double c3exittmp_limitHi = 0.566125750541687;
        double c3exittmp_limitLo = 0.18084394931793213;
        double c4exittmp_warnHi = 0.8151566982269287;
        double c4exittmp_warnLo = 0.10243260860443115;
        double c4exittmp_limitHi = 0.6225319504737854;
        double c4exittmp_limitLo = 0.02865135669708252;
        double evapexittmp_warnHi = 0.20091331005096436;
        double evapexittmp_warnLo = 0.5535042881965637;
        double evapexittmp_limitHi = 0.216303288936615;
        double evapexittmp_limitLo = 0.33076733350753784;
        double hexrtrntmp_warnHi = 0.21007037162780762;
        double hexrtrntmp_warnLo = 0.8211714029312134;
        double hexrtrntmp_limitHi = 0.724603533744812;
        double hexrtrntmp_limitLo = 0.1649855375289917;
        double liquidprs_warnHi = 0.524152934551239;
        double liquidprs_warnLo = 0.1386559009552002;
        double liquidprs_limitHi = 0.18888407945632935;
        double liquidprs_limitLo = 0.746355f;
        double prec3tmp_warnHi = 0.6425913572311401;
        double prec3tmp_warnLo = 0.16918432712554932;
        double prec3tmp_limitHi = 0.4212082624435425;
        double prec3tmp_limitLo = 0.6034871339797974;
        double prec4tmp_warnHi = 0.25848788022994995;
        double prec4tmp_warnLo = 0.20617163181304932;
        double prec4tmp_limitHi = 0.6782745122909546;
        double prec4tmp_limitLo = 0.955681f;
        double returnprs_warnHi = 0.3962072f;
        double returnprs_warnLo = 0.5218521356582642;
        double returnprs_limitHi = 0.1899036169052124;
        double returnprs_limitLo = 0.4225732088088989;
        double vaporprs_warnHi = 0.03787273168563843;
        double vaporprs_warnLo = 0.3646594285964966;
        double vaporprs_limitHi = 0.7142853140830994;
        double vaporprs_limitLo = 0.8675350546836853;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cryo6_LimitsConfigurationEvent(version, c3exittmp_warnHi, c3exittmp_warnLo, c3exittmp_limitHi, c3exittmp_limitLo, c4exittmp_warnHi, c4exittmp_warnLo, c4exittmp_limitHi, c4exittmp_limitLo, evapexittmp_warnHi, evapexittmp_warnLo, evapexittmp_limitHi, evapexittmp_limitLo, hexrtrntmp_warnHi, hexrtrntmp_warnLo, hexrtrntmp_limitHi, hexrtrntmp_limitLo, liquidprs_warnHi, liquidprs_warnLo, liquidprs_limitHi, liquidprs_limitLo, prec3tmp_warnHi, prec3tmp_warnLo, prec3tmp_limitHi, prec3tmp_limitLo, prec4tmp_warnHi, prec4tmp_warnLo, prec4tmp_limitHi, prec4tmp_limitLo, returnprs_warnHi, returnprs_warnLo, returnprs_limitHi, returnprs_limitLo, vaporprs_warnHi, vaporprs_warnLo, vaporprs_limitHi, vaporprs_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo6_LimitsConfigurationEvent));
        Hex_Cryo6_LimitsConfigurationEvent item_ = (Hex_Cryo6_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)c3exittmp_warnHi, (double)item_.getC3exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_warnLo, (double)item_.getC3exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitHi, (double)item_.getC3exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitLo, (double)item_.getC3exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnHi, (double)item_.getC4exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnLo, (double)item_.getC4exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitHi, (double)item_.getC4exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitLo, (double)item_.getC4exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnHi, (double)item_.getEvapexittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnLo, (double)item_.getEvapexittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitHi, (double)item_.getEvapexittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitLo, (double)item_.getEvapexittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnHi, (double)item_.getHexrtrntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnLo, (double)item_.getHexrtrntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitHi, (double)item_.getHexrtrntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitLo, (double)item_.getHexrtrntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnHi, (double)item_.getLiquidprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnLo, (double)item_.getLiquidprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitHi, (double)item_.getLiquidprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitLo, (double)item_.getLiquidprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnHi, (double)item_.getPrec3tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnLo, (double)item_.getPrec3tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitHi, (double)item_.getPrec3tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitLo, (double)item_.getPrec3tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnHi, (double)item_.getPrec4tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnLo, (double)item_.getPrec4tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitHi, (double)item_.getPrec4tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitLo, (double)item_.getPrec4tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnHi, (double)item_.getReturnprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnLo, (double)item_.getReturnprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitHi, (double)item_.getReturnprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitLo, (double)item_.getReturnprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnHi, (double)item_.getVaporprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnLo, (double)item_.getVaporprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitHi, (double)item_.getVaporprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitLo, (double)item_.getVaporprs_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Maq20_DeviceConfigurationEvent() throws Exception {
        String version = "c";
        String node = "";
        String serials = "";
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Maq20_DeviceConfigurationEvent(version, node, serials));
        Assert.assertTrue((boolean)(item instanceof Hex_Maq20_DeviceConfigurationEvent));
        Hex_Maq20_DeviceConfigurationEvent item_ = (Hex_Maq20_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)node, (Object)item_.getNode());
        Assert.assertEquals((Object)serials, (Object)item_.getSerials());
    }

    @Test
    public void sendReceiveHex_Maq20x_DeviceConfigurationEvent() throws Exception {
        String version = "";
        String node = "";
        String serials = "";
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Maq20x_DeviceConfigurationEvent(version, node, serials));
        Assert.assertTrue((boolean)(item instanceof Hex_Maq20x_DeviceConfigurationEvent));
        Hex_Maq20x_DeviceConfigurationEvent item_ = (Hex_Maq20x_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)node, (Object)item_.getNode());
        Assert.assertEquals((Object)serials, (Object)item_.getSerials());
    }

    @Test
    public void sendReceiveHex_PeriodicTasksConfigurationEvent() throws Exception {
        String version = "y";
        int schedulers_default_nTasks = 606;
        int schedulers_default_nThreads = 607;
        int schedulers_monitor_update_publish_scheduler_nTasks = 321;
        int schedulers_monitor_update_publish_scheduler_nThreads = 532;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_PeriodicTasksConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Hex_PeriodicTasksConfigurationEvent));
        Hex_PeriodicTasksConfigurationEvent item_ = (Hex_PeriodicTasksConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveHex_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "k";
        long agentmonitorservice_taskPeriodMillis = 153L;
        long heartbeat_taskPeriodMillis = 585L;
        long monitor_check_taskPeriodMillis = 349L;
        long monitor_publish_taskPeriodMillis = 188L;
        long monitor_update_taskPeriodMillis = 830L;
        long runtimeinfo_taskPeriodMillis = 664L;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Hex_PeriodicTasks_timersConfigurationEvent));
        Hex_PeriodicTasks_timersConfigurationEvent item_ = (Hex_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveRefrig_Cold1_CompLimitsConfigurationEvent() throws Exception {
        String version = "k";
        double cmprPowerDelayLimit = 0.6225771307945251;
        int cmprPowerDelayTime = 935;
        double cmprPowerImmedLimit = 0.4945831894874573;
        double coldTempImmedLimit = 0.09346562623977661;
        double discPressDelayLimit = 0.11807596683502197;
        int discPressDelayTime = 186;
        double discPressImmedLimit = 0.9640874862670898;
        double discTempDelayLimit = 0.7953070998191833;
        int discTempDelayTime = 732;
        double discTempImmedLimit = 0.6420723795890808;
        double discTempLowImmedLimit = 0.8862138390541077;
        double heaterTempLimit = 0.6513652205467224;
        double liquidTempDelayLimit = 0.10997647047042847;
        int liquidTempDelayTime = 639;
        double liquidTempImmedLimit = 0.4016244411468506;
        double orificeOffPress = 0.08052986860275269;
        double orificeOnPress = 0.3799621f;
        double phaseSepTempDelayLimit = 0.5101470947265625;
        int phaseSepTempDelayTime = 83;
        double pressDiffImmedLimit = 0.426071f;
        double suctTempImmedLimit = 0.5660336017608643;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cold1_CompLimitsConfigurationEvent(version, cmprPowerDelayLimit, cmprPowerDelayTime, cmprPowerImmedLimit, coldTempImmedLimit, discPressDelayLimit, discPressDelayTime, discPressImmedLimit, discTempDelayLimit, discTempDelayTime, discTempImmedLimit, discTempLowImmedLimit, heaterTempLimit, liquidTempDelayLimit, liquidTempDelayTime, liquidTempImmedLimit, orificeOffPress, orificeOnPress, phaseSepTempDelayLimit, phaseSepTempDelayTime, pressDiffImmedLimit, suctTempImmedLimit));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cold1_CompLimitsConfigurationEvent));
        Refrig_Cold1_CompLimitsConfigurationEvent item_ = (Refrig_Cold1_CompLimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)cmprPowerDelayLimit, (double)item_.getCmprPowerDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)cmprPowerDelayTime, (long)item_.getCmprPowerDelayTime());
        Assert.assertEquals((double)cmprPowerImmedLimit, (double)item_.getCmprPowerImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)coldTempImmedLimit, (double)item_.getColdTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discPressDelayLimit, (double)item_.getDiscPressDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discPressDelayTime, (long)item_.getDiscPressDelayTime());
        Assert.assertEquals((double)discPressImmedLimit, (double)item_.getDiscPressImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempDelayLimit, (double)item_.getDiscTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discTempDelayTime, (long)item_.getDiscTempDelayTime());
        Assert.assertEquals((double)discTempImmedLimit, (double)item_.getDiscTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempLowImmedLimit, (double)item_.getDiscTempLowImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)heaterTempLimit, (double)item_.getHeaterTempLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidTempDelayLimit, (double)item_.getLiquidTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)liquidTempDelayTime, (long)item_.getLiquidTempDelayTime());
        Assert.assertEquals((double)liquidTempImmedLimit, (double)item_.getLiquidTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOffPress, (double)item_.getOrificeOffPress(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOnPress, (double)item_.getOrificeOnPress(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTempDelayLimit, (double)item_.getPhaseSepTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)phaseSepTempDelayTime, (long)item_.getPhaseSepTempDelayTime());
        Assert.assertEquals((double)pressDiffImmedLimit, (double)item_.getPressDiffImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)suctTempImmedLimit, (double)item_.getSuctTempImmedLimit(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cold1_DeviceConfigurationEvent() throws Exception {
        String version = "r";
        String maq20_node = "a";
        String maq20_serials = "";
        String plc_node = "z";
        int vfd_address = 878;
        int vfd_baudRate = 557;
        String vfd_devcName = "c";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cold1_DeviceConfigurationEvent(version, maq20_node, maq20_serials, plc_node, vfd_address, vfd_baudRate, vfd_devcName));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cold1_DeviceConfigurationEvent));
        Refrig_Cold1_DeviceConfigurationEvent item_ = (Refrig_Cold1_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
        Assert.assertEquals((long)vfd_address, (long)item_.getVfd_address());
        Assert.assertEquals((long)vfd_baudRate, (long)item_.getVfd_baudRate());
        Assert.assertEquals((Object)vfd_devcName, (Object)item_.getVfd_devcName());
    }

    @Test
    public void sendReceiveRefrig_Cold1_LimitsConfigurationEvent() throws Exception {
        String version = "k";
        double ambienttmp_warnHi = 0.2126712203025818;
        double ambienttmp_warnLo = 0.9168487787246704;
        double ambienttmp_limitHi = 0.2955929f;
        double ambienttmp_limitLo = 0.4381973147392273;
        double cabinettmp_warnHi = 0.7747090458869934;
        double cabinettmp_warnLo = 0.1645141839981079;
        double cabinettmp_limitHi = 0.296500027179718;
        double cabinettmp_limitLo = 0.3348594903945923;
        double compcurrent_warnHi = 0.04089456796646118;
        double compcurrent_warnLo = 0.9079667925834656;
        double compcurrent_limitHi = 0.26252996921539307;
        double compcurrent_limitLo = 0.7911467552185059;
        double comppower_warnHi = 0.5862413048744202;
        double comppower_warnLo = 0.19596493244171143;
        double comppower_limitHi = 0.6517412066459656;
        double comppower_limitLo = 0.8109247088432312;
        double compvfdcurr_warnHi = 0.5020307898521423;
        double compvfdcurr_warnLo = 0.09269309043884277;
        double compvfdcurr_limitHi = 0.7096713781356812;
        double compvfdcurr_limitLo = 0.4633186459541321;
        double compvfdfreq_warnHi = 0.610880970954895;
        double compvfdfreq_warnLo = 0.2357664704322815;
        double compvfdfreq_limitHi = 0.8266355991363525;
        double compvfdfreq_limitLo = 0.8923792243003845;
        double compvfdvolt_warnHi = 0.7904093265533447;
        double compvfdvolt_warnLo = 0.007546544075012207;
        double compvfdvolt_limitHi = 0.02032071352005005;
        double compvfdvolt_limitLo = 0.1448100209236145;
        double compvoltage_warnHi = 0.6774519681930542;
        double compvoltage_warnLo = 0.9350197315216064;
        double compvoltage_limitHi = 0.8183979392051697;
        double compvoltage_limitLo = 0.9617493748664856;
        double coolflowrate_warnHi = 0.3929516673088074;
        double coolflowrate_warnLo = 0.8882981538772583;
        double coolflowrate_limitHi = 0.9426085352897644;
        double coolflowrate_limitLo = 0.2420047f;
        double coolvalveposn_warnHi = 0.6579023599624634;
        double coolvalveposn_warnLo = 0.792611f;
        double coolvalveposn_limitHi = 0.3765166401863098;
        double coolvalveposn_limitLo = 0.8020473122596741;
        double dischrgprs_warnHi = 0.3539528250694275;
        double dischrgprs_warnLo = 0.8028817176818848;
        double dischrgprs_limitHi = 0.17002063989639282;
        double dischrgprs_limitLo = 0.2709732f;
        double dischrgtmp_M_warnHi = 0.012377262115478516;
        double dischrgtmp_M_warnLo = 0.2536681294441223;
        double dischrgtmp_M_limitHi = 0.5590114593505859;
        double dischrgtmp_M_limitLo = 0.17061054706573486;
        double dischrgtmp_P_warnHi = 0.13917946815490723;
        double dischrgtmp_P_warnLo = 0.6210432052612305;
        double dischrgtmp_P_limitHi = 0.10065692663192749;
        double dischrgtmp_P_limitLo = 0.1617475152015686;
        double fan1speed_warnHi = 0.6523122191429138;
        double fan1speed_warnLo = 0.2882046699523926;
        double fan1speed_limitHi = 0.8141778707504272;
        double fan1speed_limitLo = 0.0724054f;
        double fan2speed_warnHi = 0.9226796627044678;
        double fan2speed_warnLo = 0.055135905742645264;
        double fan2speed_limitHi = 0.12229812145233154;
        double fan2speed_limitLo = 0.16417354345321655;
        double fan3speed_warnHi = 0.0801962f;
        double fan3speed_warnLo = 0.17703211307525635;
        double fan3speed_limitHi = 0.38655567169189453;
        double fan3speed_limitLo = 0.404455304145813;
        double hgbvalveposn_warnHi = 0.9292687773704529;
        double hgbvalveposn_warnLo = 0.7496299147605896;
        double hgbvalveposn_limitHi = 0.27523887157440186;
        double hgbvalveposn_limitLo = 0.5782743096351624;
        double liquidsubcooling_warnHi = 0.27734827995300293;
        double liquidsubcooling_warnLo = 0.6158115863800049;
        double liquidsubcooling_limitHi = 0.1788643f;
        double liquidsubcooling_limitLo = 0.4409077763557434;
        double liquidtmp_M_warnHi = 0.9314776659011841;
        double liquidtmp_M_warnLo = 0.6713199019432068;
        double liquidtmp_M_limitHi = 0.5559794902801514;
        double liquidtmp_M_limitLo = 0.8455294370651245;
        double liquidtmp_P_warnHi = 0.479996919631958;
        double liquidtmp_P_warnLo = 0.6631540656089783;
        double liquidtmp_P_limitHi = 0.9409094452857971;
        double liquidtmp_P_limitLo = 0.7073533535003662;
        double suctionprs_warnHi = 0.1218177080154419;
        double suctionprs_warnLo = 0.8578788042068481;
        double suctionprs_limitHi = 0.4422512f;
        double suctionprs_limitLo = 0.6322062015533447;
        double suctiontmp_M_warnHi = 0.8091465830802917;
        double suctiontmp_M_warnLo = 0.5049675107002258;
        double suctiontmp_M_limitHi = 0.8019691109657288;
        double suctiontmp_M_limitLo = 0.1533641219139099;
        double suctiontmp_P_warnHi = 0.3595404624938965;
        double suctiontmp_P_warnLo = 0.9193195104598999;
        double suctiontmp_P_limitHi = 0.4434826374053955;
        double suctiontmp_P_limitLo = 0.4118521213531494;
        double waterintmp_warnHi = 0.7011619210243225;
        double waterintmp_warnLo = 0.4847882390022278;
        double waterintmp_limitHi = 0.7149277925491333;
        double waterintmp_limitLo = 0.17381781339645386;
        double waterouttmp_warnHi = 0.22563612461090088;
        double waterouttmp_warnLo = 0.5550898909568787;
        double waterouttmp_limitHi = 0.6106980443000793;
        double waterouttmp_limitLo = 0.7112863063812256;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cold1_LimitsConfigurationEvent(version, ambienttmp_warnHi, ambienttmp_warnLo, ambienttmp_limitHi, ambienttmp_limitLo, cabinettmp_warnHi, cabinettmp_warnLo, cabinettmp_limitHi, cabinettmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvfdcurr_warnHi, compvfdcurr_warnLo, compvfdcurr_limitHi, compvfdcurr_limitLo, compvfdfreq_warnHi, compvfdfreq_warnLo, compvfdfreq_limitHi, compvfdfreq_limitLo, compvfdvolt_warnHi, compvfdvolt_warnLo, compvfdvolt_limitHi, compvfdvolt_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, coolflowrate_warnHi, coolflowrate_warnLo, coolflowrate_limitHi, coolflowrate_limitLo, coolvalveposn_warnHi, coolvalveposn_warnLo, coolvalveposn_limitHi, coolvalveposn_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fan1speed_warnHi, fan1speed_warnLo, fan1speed_limitHi, fan1speed_limitLo, fan2speed_warnHi, fan2speed_warnLo, fan2speed_limitHi, fan2speed_limitLo, fan3speed_warnHi, fan3speed_warnLo, fan3speed_limitHi, fan3speed_limitLo, hgbvalveposn_warnHi, hgbvalveposn_warnLo, hgbvalveposn_limitHi, hgbvalveposn_limitLo, liquidsubcooling_warnHi, liquidsubcooling_warnLo, liquidsubcooling_limitHi, liquidsubcooling_limitLo, liquidtmp_M_warnHi, liquidtmp_M_warnLo, liquidtmp_M_limitHi, liquidtmp_M_limitLo, liquidtmp_P_warnHi, liquidtmp_P_warnLo, liquidtmp_P_limitHi, liquidtmp_P_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cold1_LimitsConfigurationEvent));
        Refrig_Cold1_LimitsConfigurationEvent item_ = (Refrig_Cold1_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)ambienttmp_warnHi, (double)item_.getAmbienttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_warnLo, (double)item_.getAmbienttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitHi, (double)item_.getAmbienttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitLo, (double)item_.getAmbienttmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnHi, (double)item_.getCabinettmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnLo, (double)item_.getCabinettmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitHi, (double)item_.getCabinettmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitLo, (double)item_.getCabinettmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdcurr_warnHi, (double)item_.getCompvfdcurr_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdcurr_warnLo, (double)item_.getCompvfdcurr_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdcurr_limitHi, (double)item_.getCompvfdcurr_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdcurr_limitLo, (double)item_.getCompvfdcurr_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdfreq_warnHi, (double)item_.getCompvfdfreq_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdfreq_warnLo, (double)item_.getCompvfdfreq_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdfreq_limitHi, (double)item_.getCompvfdfreq_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdfreq_limitLo, (double)item_.getCompvfdfreq_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdvolt_warnHi, (double)item_.getCompvfdvolt_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdvolt_warnLo, (double)item_.getCompvfdvolt_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdvolt_limitHi, (double)item_.getCompvfdvolt_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdvolt_limitLo, (double)item_.getCompvfdvolt_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)coolflowrate_warnHi, (double)item_.getCoolflowrate_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)coolflowrate_warnLo, (double)item_.getCoolflowrate_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)coolflowrate_limitHi, (double)item_.getCoolflowrate_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)coolflowrate_limitLo, (double)item_.getCoolflowrate_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)coolvalveposn_warnHi, (double)item_.getCoolvalveposn_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)coolvalveposn_warnLo, (double)item_.getCoolvalveposn_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)coolvalveposn_limitHi, (double)item_.getCoolvalveposn_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)coolvalveposn_limitLo, (double)item_.getCoolvalveposn_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1speed_warnHi, (double)item_.getFan1speed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1speed_warnLo, (double)item_.getFan1speed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1speed_limitHi, (double)item_.getFan1speed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1speed_limitLo, (double)item_.getFan1speed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2speed_warnHi, (double)item_.getFan2speed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2speed_warnLo, (double)item_.getFan2speed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2speed_limitHi, (double)item_.getFan2speed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2speed_limitLo, (double)item_.getFan2speed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3speed_warnHi, (double)item_.getFan3speed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3speed_warnLo, (double)item_.getFan3speed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3speed_limitHi, (double)item_.getFan3speed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3speed_limitLo, (double)item_.getFan3speed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hgbvalveposn_warnHi, (double)item_.getHgbvalveposn_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hgbvalveposn_warnLo, (double)item_.getHgbvalveposn_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hgbvalveposn_limitHi, (double)item_.getHgbvalveposn_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hgbvalveposn_limitLo, (double)item_.getHgbvalveposn_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidsubcooling_warnHi, (double)item_.getLiquidsubcooling_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidsubcooling_warnLo, (double)item_.getLiquidsubcooling_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidsubcooling_limitHi, (double)item_.getLiquidsubcooling_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidsubcooling_limitLo, (double)item_.getLiquidsubcooling_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M_warnHi, (double)item_.getLiquidtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M_warnLo, (double)item_.getLiquidtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M_limitHi, (double)item_.getLiquidtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M_limitLo, (double)item_.getLiquidtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P_warnHi, (double)item_.getLiquidtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P_warnLo, (double)item_.getLiquidtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P_limitHi, (double)item_.getLiquidtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P_limitLo, (double)item_.getLiquidtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cold2_CompLimitsConfigurationEvent() throws Exception {
        String version = "";
        double cmprPowerDelayLimit = 0.3586241f;
        int cmprPowerDelayTime = 521;
        double cmprPowerImmedLimit = 0.9524278044700623;
        double coldTempImmedLimit = 0.41063958406448364;
        double discPressDelayLimit = 0.7489414215087891;
        int discPressDelayTime = 550;
        double discPressImmedLimit = 0.6229037642478943;
        double discTempDelayLimit = 0.655523f;
        int discTempDelayTime = 40;
        double discTempImmedLimit = 0.24761521816253662;
        double discTempLowImmedLimit = 0.804999589920044;
        double heaterTempLimit = 0.7068792581558228;
        double liquidTempDelayLimit = 0.23437517881393433;
        int liquidTempDelayTime = 43;
        double liquidTempImmedLimit = 0.4058322310447693;
        double orificeOffPress = 0.15907102823257446;
        double orificeOnPress = 0.5351780652999878;
        double phaseSepTempDelayLimit = 0.13439089059829712;
        int phaseSepTempDelayTime = 430;
        double pressDiffImmedLimit = 0.2801274061203003;
        double suctTempImmedLimit = 0.285383403301239;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cold2_CompLimitsConfigurationEvent(version, cmprPowerDelayLimit, cmprPowerDelayTime, cmprPowerImmedLimit, coldTempImmedLimit, discPressDelayLimit, discPressDelayTime, discPressImmedLimit, discTempDelayLimit, discTempDelayTime, discTempImmedLimit, discTempLowImmedLimit, heaterTempLimit, liquidTempDelayLimit, liquidTempDelayTime, liquidTempImmedLimit, orificeOffPress, orificeOnPress, phaseSepTempDelayLimit, phaseSepTempDelayTime, pressDiffImmedLimit, suctTempImmedLimit));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cold2_CompLimitsConfigurationEvent));
        Refrig_Cold2_CompLimitsConfigurationEvent item_ = (Refrig_Cold2_CompLimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)cmprPowerDelayLimit, (double)item_.getCmprPowerDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)cmprPowerDelayTime, (long)item_.getCmprPowerDelayTime());
        Assert.assertEquals((double)cmprPowerImmedLimit, (double)item_.getCmprPowerImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)coldTempImmedLimit, (double)item_.getColdTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discPressDelayLimit, (double)item_.getDiscPressDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discPressDelayTime, (long)item_.getDiscPressDelayTime());
        Assert.assertEquals((double)discPressImmedLimit, (double)item_.getDiscPressImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempDelayLimit, (double)item_.getDiscTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discTempDelayTime, (long)item_.getDiscTempDelayTime());
        Assert.assertEquals((double)discTempImmedLimit, (double)item_.getDiscTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempLowImmedLimit, (double)item_.getDiscTempLowImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)heaterTempLimit, (double)item_.getHeaterTempLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidTempDelayLimit, (double)item_.getLiquidTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)liquidTempDelayTime, (long)item_.getLiquidTempDelayTime());
        Assert.assertEquals((double)liquidTempImmedLimit, (double)item_.getLiquidTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOffPress, (double)item_.getOrificeOffPress(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOnPress, (double)item_.getOrificeOnPress(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTempDelayLimit, (double)item_.getPhaseSepTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)phaseSepTempDelayTime, (long)item_.getPhaseSepTempDelayTime());
        Assert.assertEquals((double)pressDiffImmedLimit, (double)item_.getPressDiffImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)suctTempImmedLimit, (double)item_.getSuctTempImmedLimit(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cold2_DeviceConfigurationEvent() throws Exception {
        String version = "h";
        String maq20_node = "q";
        String maq20_serials = "g";
        String plc_node = "a";
        int vfd_address = 669;
        int vfd_baudRate = 705;
        String vfd_devcName = "";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cold2_DeviceConfigurationEvent(version, maq20_node, maq20_serials, plc_node, vfd_address, vfd_baudRate, vfd_devcName));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cold2_DeviceConfigurationEvent));
        Refrig_Cold2_DeviceConfigurationEvent item_ = (Refrig_Cold2_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
        Assert.assertEquals((long)vfd_address, (long)item_.getVfd_address());
        Assert.assertEquals((long)vfd_baudRate, (long)item_.getVfd_baudRate());
        Assert.assertEquals((Object)vfd_devcName, (Object)item_.getVfd_devcName());
    }

    @Test
    public void sendReceiveRefrig_Cold2_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double ambienttmp_warnHi = 0.6068287491798401;
        double ambienttmp_warnLo = 0.19070512056350708;
        double ambienttmp_limitHi = 0.9657025337219238;
        double ambienttmp_limitLo = 0.811535120010376;
        double cabinettmp_warnHi = 0.839469f;
        double cabinettmp_warnLo = 0.6548264026641846;
        double cabinettmp_limitHi = 0.3849772810935974;
        double cabinettmp_limitLo = 0.2369445562362671;
        double compcurrent_warnHi = 0.060768187046051025;
        double compcurrent_warnLo = 0.947840690612793;
        double compcurrent_limitHi = 0.9907975792884827;
        double compcurrent_limitLo = 0.3677181005477905;
        double comppower_warnHi = 0.1419163942337036;
        double comppower_warnLo = 0.23200958967208862;
        double comppower_limitHi = 0.621763288974762;
        double comppower_limitLo = 0.1554107666015625;
        double compvfdcurr_warnHi = 0.5610649585723877;
        double compvfdcurr_warnLo = 0.37559783458709717;
        double compvfdcurr_limitHi = 0.32896852493286133;
        double compvfdcurr_limitLo = 0.8055156469345093;
        double compvfdfreq_warnHi = 0.08459645509719849;
        double compvfdfreq_warnLo = 0.33248448371887207;
        double compvfdfreq_limitHi = 0.5507811307907104;
        double compvfdfreq_limitLo = 0.9486668705940247;
        double compvfdvolt_warnHi = 0.6936050653457642;
        double compvfdvolt_warnLo = 0.5140964984893799;
        double compvfdvolt_limitHi = 0.7448531985282898;
        double compvfdvolt_limitLo = 0.941771388053894;
        double compvoltage_warnHi = 0.7484720349311829;
        double compvoltage_warnLo = 0.7645028829574585;
        double compvoltage_limitHi = 0.010468602180480957;
        double compvoltage_limitLo = 0.6878884434700012;
        double coolflowrate_warnHi = 0.6218031644821167;
        double coolflowrate_warnLo = 0.6412501335144043;
        double coolflowrate_limitHi = 0.8648171424865723;
        double coolflowrate_limitLo = 0.8498541712760925;
        double coolvalveposn_warnHi = 0.26377958059310913;
        double coolvalveposn_warnLo = 0.3724910616874695;
        double coolvalveposn_limitHi = 0.37040263414382935;
        double coolvalveposn_limitLo = 0.47953593730926514;
        double dischrgprs_warnHi = 0.7584148049354553;
        double dischrgprs_warnLo = 0.3092666268348694;
        double dischrgprs_limitHi = 0.9946192502975464;
        double dischrgprs_limitLo = 0.8228532075881958;
        double dischrgtmp_M_warnHi = 0.8266887664794922;
        double dischrgtmp_M_warnLo = 0.140167236328125;
        double dischrgtmp_M_limitHi = 0.36675918102264404;
        double dischrgtmp_M_limitLo = 0.9616162776947021;
        double dischrgtmp_P_warnHi = 0.20355886220932007;
        double dischrgtmp_P_warnLo = 0.06938314437866211;
        double dischrgtmp_P_limitHi = 0.885668f;
        double dischrgtmp_P_limitLo = 0.4787197709083557;
        double fan1speed_warnHi = 0.7090548872947693;
        double fan1speed_warnLo = 0.5793200731277466;
        double fan1speed_limitHi = 0.5293838381767273;
        double fan1speed_limitLo = 0.0858263373374939;
        double fan2speed_warnHi = 0.8258102536201477;
        double fan2speed_warnLo = 0.0721203088760376;
        double fan2speed_limitHi = 0.2859575152397156;
        double fan2speed_limitLo = 0.12554824352264404;
        double fan3speed_warnHi = 0.4413476586341858;
        double fan3speed_warnLo = 0.3928038477897644;
        double fan3speed_limitHi = 0.1249426007270813;
        double fan3speed_limitLo = 0.6870742440223694;
        double hgbvalveposn_warnHi = 0.6962341070175171;
        double hgbvalveposn_warnLo = 0.02819424867630005;
        double hgbvalveposn_limitHi = 0.07759493589401245;
        double hgbvalveposn_limitLo = 0.2796071767807007;
        double liquidsubcooling_warnHi = 0.25997406244277954;
        double liquidsubcooling_warnLo = 0.21378272771835327;
        double liquidsubcooling_limitHi = 0.7095667123794556;
        double liquidsubcooling_limitLo = 0.2569117546081543;
        double liquidtmp_M_warnHi = 0.8244872093200684;
        double liquidtmp_M_warnLo = 0.5943259000778198;
        double liquidtmp_M_limitHi = 0.4248991012573242;
        double liquidtmp_M_limitLo = 0.5343916416168213;
        double liquidtmp_P_warnHi = 0.7275944948196411;
        double liquidtmp_P_warnLo = 0.8179831504821777;
        double liquidtmp_P_limitHi = 0.7096013426780701;
        double liquidtmp_P_limitLo = 0.2837026119232178;
        double suctionprs_warnHi = 0.7916221618652344;
        double suctionprs_warnLo = 0.10853838920593262;
        double suctionprs_limitHi = 0.6353712677955627;
        double suctionprs_limitLo = 0.8158840537071228;
        double suctiontmp_M_warnHi = 0.15866601467132568;
        double suctiontmp_M_warnLo = 0.58169f;
        double suctiontmp_M_limitHi = 0.9305132627487183;
        double suctiontmp_M_limitLo = 0.49988818168640137;
        double suctiontmp_P_warnHi = 0.9259874224662781;
        double suctiontmp_P_warnLo = 0.7411353588104248;
        double suctiontmp_P_limitHi = 0.370410680770874;
        double suctiontmp_P_limitLo = 0.4273747205734253;
        double waterintmp_warnHi = 0.11232644319534302;
        double waterintmp_warnLo = 0.11544859409332275;
        double waterintmp_limitHi = 0.531707f;
        double waterintmp_limitLo = 0.3855026960372925;
        double waterouttmp_warnHi = 0.12662345170974731;
        double waterouttmp_warnLo = 0.55040442943573;
        double waterouttmp_limitHi = 0.4334644079208374;
        double waterouttmp_limitLo = 0.18660622835159302;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cold2_LimitsConfigurationEvent(version, ambienttmp_warnHi, ambienttmp_warnLo, ambienttmp_limitHi, ambienttmp_limitLo, cabinettmp_warnHi, cabinettmp_warnLo, cabinettmp_limitHi, cabinettmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvfdcurr_warnHi, compvfdcurr_warnLo, compvfdcurr_limitHi, compvfdcurr_limitLo, compvfdfreq_warnHi, compvfdfreq_warnLo, compvfdfreq_limitHi, compvfdfreq_limitLo, compvfdvolt_warnHi, compvfdvolt_warnLo, compvfdvolt_limitHi, compvfdvolt_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, coolflowrate_warnHi, coolflowrate_warnLo, coolflowrate_limitHi, coolflowrate_limitLo, coolvalveposn_warnHi, coolvalveposn_warnLo, coolvalveposn_limitHi, coolvalveposn_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fan1speed_warnHi, fan1speed_warnLo, fan1speed_limitHi, fan1speed_limitLo, fan2speed_warnHi, fan2speed_warnLo, fan2speed_limitHi, fan2speed_limitLo, fan3speed_warnHi, fan3speed_warnLo, fan3speed_limitHi, fan3speed_limitLo, hgbvalveposn_warnHi, hgbvalveposn_warnLo, hgbvalveposn_limitHi, hgbvalveposn_limitLo, liquidsubcooling_warnHi, liquidsubcooling_warnLo, liquidsubcooling_limitHi, liquidsubcooling_limitLo, liquidtmp_M_warnHi, liquidtmp_M_warnLo, liquidtmp_M_limitHi, liquidtmp_M_limitLo, liquidtmp_P_warnHi, liquidtmp_P_warnLo, liquidtmp_P_limitHi, liquidtmp_P_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cold2_LimitsConfigurationEvent));
        Refrig_Cold2_LimitsConfigurationEvent item_ = (Refrig_Cold2_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)ambienttmp_warnHi, (double)item_.getAmbienttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_warnLo, (double)item_.getAmbienttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitHi, (double)item_.getAmbienttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitLo, (double)item_.getAmbienttmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnHi, (double)item_.getCabinettmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnLo, (double)item_.getCabinettmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitHi, (double)item_.getCabinettmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitLo, (double)item_.getCabinettmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdcurr_warnHi, (double)item_.getCompvfdcurr_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdcurr_warnLo, (double)item_.getCompvfdcurr_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdcurr_limitHi, (double)item_.getCompvfdcurr_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdcurr_limitLo, (double)item_.getCompvfdcurr_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdfreq_warnHi, (double)item_.getCompvfdfreq_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdfreq_warnLo, (double)item_.getCompvfdfreq_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdfreq_limitHi, (double)item_.getCompvfdfreq_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdfreq_limitLo, (double)item_.getCompvfdfreq_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdvolt_warnHi, (double)item_.getCompvfdvolt_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdvolt_warnLo, (double)item_.getCompvfdvolt_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdvolt_limitHi, (double)item_.getCompvfdvolt_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdvolt_limitLo, (double)item_.getCompvfdvolt_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)coolflowrate_warnHi, (double)item_.getCoolflowrate_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)coolflowrate_warnLo, (double)item_.getCoolflowrate_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)coolflowrate_limitHi, (double)item_.getCoolflowrate_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)coolflowrate_limitLo, (double)item_.getCoolflowrate_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)coolvalveposn_warnHi, (double)item_.getCoolvalveposn_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)coolvalveposn_warnLo, (double)item_.getCoolvalveposn_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)coolvalveposn_limitHi, (double)item_.getCoolvalveposn_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)coolvalveposn_limitLo, (double)item_.getCoolvalveposn_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1speed_warnHi, (double)item_.getFan1speed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1speed_warnLo, (double)item_.getFan1speed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1speed_limitHi, (double)item_.getFan1speed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1speed_limitLo, (double)item_.getFan1speed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2speed_warnHi, (double)item_.getFan2speed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2speed_warnLo, (double)item_.getFan2speed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2speed_limitHi, (double)item_.getFan2speed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2speed_limitLo, (double)item_.getFan2speed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3speed_warnHi, (double)item_.getFan3speed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3speed_warnLo, (double)item_.getFan3speed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3speed_limitHi, (double)item_.getFan3speed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3speed_limitLo, (double)item_.getFan3speed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hgbvalveposn_warnHi, (double)item_.getHgbvalveposn_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hgbvalveposn_warnLo, (double)item_.getHgbvalveposn_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hgbvalveposn_limitHi, (double)item_.getHgbvalveposn_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hgbvalveposn_limitLo, (double)item_.getHgbvalveposn_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidsubcooling_warnHi, (double)item_.getLiquidsubcooling_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidsubcooling_warnLo, (double)item_.getLiquidsubcooling_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidsubcooling_limitHi, (double)item_.getLiquidsubcooling_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidsubcooling_limitLo, (double)item_.getLiquidsubcooling_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M_warnHi, (double)item_.getLiquidtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M_warnLo, (double)item_.getLiquidtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M_limitHi, (double)item_.getLiquidtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M_limitLo, (double)item_.getLiquidtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P_warnHi, (double)item_.getLiquidtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P_warnLo, (double)item_.getLiquidtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P_limitHi, (double)item_.getLiquidtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P_limitLo, (double)item_.getLiquidtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_CoolMaq20_DeviceConfigurationEvent() throws Exception {
        String version = "c";
        String node = "n";
        String serials = "";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_CoolMaq20_DeviceConfigurationEvent(version, node, serials));
        Assert.assertTrue((boolean)(item instanceof Refrig_CoolMaq20_DeviceConfigurationEvent));
        Refrig_CoolMaq20_DeviceConfigurationEvent item_ = (Refrig_CoolMaq20_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)node, (Object)item_.getNode());
        Assert.assertEquals((Object)serials, (Object)item_.getSerials());
    }

    @Test
    public void sendReceiveRefrig_Cryo1_CompLimitsConfigurationEvent() throws Exception {
        String version = "e";
        double cmprPowerDelayLimit = 0.38867151737213135;
        int cmprPowerDelayTime = 599;
        double cmprPowerImmedLimit = 0.8059951663017273;
        double coldTempImmedLimit = 0.996269166469574;
        double discPressDelayLimit = 0.8227730989456177;
        int discPressDelayTime = 68;
        double discPressImmedLimit = 0.5698431730270386;
        double discTempDelayLimit = 0.9400115013122559;
        int discTempDelayTime = 822;
        double discTempImmedLimit = 0.23121285438537598;
        double discTempLowImmedLimit = 0.706488f;
        double heaterTempLimit = 0.685739f;
        double liquidTempDelayLimit = 0.5056788325309753;
        int liquidTempDelayTime = 442;
        double liquidTempImmedLimit = 0.545616090297699;
        double orificeOffPress = 0.35282236337661743;
        double orificeOnPress = 0.30199337005615234;
        double phaseSepTempDelayLimit = 0.9172133803367615;
        int phaseSepTempDelayTime = 344;
        double pressDiffImmedLimit = 0.1660524f;
        double suctTempImmedLimit = 0.3338874578475952;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo1_CompLimitsConfigurationEvent(version, cmprPowerDelayLimit, cmprPowerDelayTime, cmprPowerImmedLimit, coldTempImmedLimit, discPressDelayLimit, discPressDelayTime, discPressImmedLimit, discTempDelayLimit, discTempDelayTime, discTempImmedLimit, discTempLowImmedLimit, heaterTempLimit, liquidTempDelayLimit, liquidTempDelayTime, liquidTempImmedLimit, orificeOffPress, orificeOnPress, phaseSepTempDelayLimit, phaseSepTempDelayTime, pressDiffImmedLimit, suctTempImmedLimit));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo1_CompLimitsConfigurationEvent));
        Refrig_Cryo1_CompLimitsConfigurationEvent item_ = (Refrig_Cryo1_CompLimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)cmprPowerDelayLimit, (double)item_.getCmprPowerDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)cmprPowerDelayTime, (long)item_.getCmprPowerDelayTime());
        Assert.assertEquals((double)cmprPowerImmedLimit, (double)item_.getCmprPowerImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)coldTempImmedLimit, (double)item_.getColdTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discPressDelayLimit, (double)item_.getDiscPressDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discPressDelayTime, (long)item_.getDiscPressDelayTime());
        Assert.assertEquals((double)discPressImmedLimit, (double)item_.getDiscPressImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempDelayLimit, (double)item_.getDiscTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discTempDelayTime, (long)item_.getDiscTempDelayTime());
        Assert.assertEquals((double)discTempImmedLimit, (double)item_.getDiscTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempLowImmedLimit, (double)item_.getDiscTempLowImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)heaterTempLimit, (double)item_.getHeaterTempLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidTempDelayLimit, (double)item_.getLiquidTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)liquidTempDelayTime, (long)item_.getLiquidTempDelayTime());
        Assert.assertEquals((double)liquidTempImmedLimit, (double)item_.getLiquidTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOffPress, (double)item_.getOrificeOffPress(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOnPress, (double)item_.getOrificeOnPress(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTempDelayLimit, (double)item_.getPhaseSepTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)phaseSepTempDelayTime, (long)item_.getPhaseSepTempDelayTime());
        Assert.assertEquals((double)pressDiffImmedLimit, (double)item_.getPressDiffImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)suctTempImmedLimit, (double)item_.getSuctTempImmedLimit(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo1_DeviceConfigurationEvent() throws Exception {
        String version = "g";
        String maq20_node = "v";
        String maq20_serials = "s";
        String plc_node = "";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo1_DeviceConfigurationEvent(version, maq20_node, maq20_serials, plc_node));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo1_DeviceConfigurationEvent));
        Refrig_Cryo1_DeviceConfigurationEvent item_ = (Refrig_Cryo1_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
    }

    @Test
    public void sendReceiveRefrig_Cryo1_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double aftercooltmp_warnHi = 0.895658016204834;
        double aftercooltmp_warnLo = 0.2465330958366394;
        double aftercooltmp_limitHi = 0.11442923545837402;
        double aftercooltmp_limitLo = 0.4659762978553772;
        double compcurrent_warnHi = 0.8361278176307678;
        double compcurrent_warnLo = 0.00861752f;
        double compcurrent_limitHi = 0.975890040397644;
        double compcurrent_limitLo = 0.511019766330719;
        double comppower_warnHi = 0.06850481033325195;
        double comppower_warnLo = 0.8819335699081421;
        double comppower_limitHi = 0.5103369355201721;
        double comppower_limitLo = 0.5715826153755188;
        double compvoltage_warnHi = 0.8169936537742615;
        double compvoltage_warnLo = 0.1390208601951599;
        double compvoltage_limitHi = 0.779719f;
        double compvoltage_limitLo = 0.9887209534645081;
        double dischrgprs_warnHi = 0.277072012424469;
        double dischrgprs_warnLo = 0.915184736251831;
        double dischrgprs_limitHi = 0.538340151309967;
        double dischrgprs_limitLo = 0.42300945520401;
        double dischrgtmp_M_warnHi = 0.6953703761100769;
        double dischrgtmp_M_warnLo = 0.9652260541915894;
        double dischrgtmp_M_limitHi = 0.14212846755981445;
        double dischrgtmp_M_limitLo = 0.733724f;
        double dischrgtmp_P_warnHi = 0.6471393704414368;
        double dischrgtmp_P_warnLo = 0.9887987971305847;
        double dischrgtmp_P_limitHi = 0.9968788623809814;
        double dischrgtmp_P_limitLo = 0.8430869579315186;
        double fanspeed_warnHi = 0.3988179f;
        double fanspeed_warnLo = 0.4897953271865845;
        double fanspeed_limitHi = 0.26867908239364624;
        double fanspeed_limitLo = 0.8790637850761414;
        double oillevel_warnHi = 0.2067958116531372;
        double oillevel_warnLo = 0.8197957873344421;
        double oillevel_limitHi = 0.5233194828033447;
        double oillevel_limitLo = 0.4429087f;
        double oilseptmp_warnHi = 0.07633805274963379;
        double oilseptmp_warnLo = 0.021564245223999023;
        double oilseptmp_limitHi = 0.1617315411567688;
        double oilseptmp_limitLo = 0.0942736268043518;
        double phaseseptmp_warnHi = 0.15730106830596924;
        double phaseseptmp_warnLo = 0.3211820721626282;
        double phaseseptmp_limitHi = 0.87872f;
        double phaseseptmp_limitLo = 0.04913193f;
        double suctionprs_warnHi = 0.9343748688697815;
        double suctionprs_warnLo = 0.11765807867050171;
        double suctionprs_limitHi = 0.9988874793052673;
        double suctionprs_limitLo = 0.7465725541114807;
        double suctiontmp_M_warnHi = 0.3558666706085205;
        double suctiontmp_M_warnLo = 0.3533428907394409;
        double suctiontmp_M_limitHi = 0.996278703212738;
        double suctiontmp_M_limitLo = 0.8528434634208679;
        double suctiontmp_P_warnHi = 0.291401743888855;
        double suctiontmp_P_warnLo = 0.4994316101074219;
        double suctiontmp_P_limitHi = 0.04557693004608154;
        double suctiontmp_P_limitLo = 0.5686679482460022;
        double surgetanktmp_warnHi = 0.2983502149581909;
        double surgetanktmp_warnLo = 0.6061123609542847;
        double surgetanktmp_limitHi = 0.2985035181045532;
        double surgetanktmp_limitLo = 0.813226f;
        double waterintmp_warnHi = 0.7704379558563232;
        double waterintmp_warnLo = 0.009990692138671875;
        double waterintmp_limitHi = 0.14833104610443115;
        double waterintmp_limitLo = 0.14033353328704834;
        double waterouttmp_warnHi = 0.6291144490242004;
        double waterouttmp_warnLo = 0.19138479232788086;
        double waterouttmp_limitHi = 0.910206f;
        double waterouttmp_limitLo = 0.6549215912818909;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo1_LimitsConfigurationEvent(version, aftercooltmp_warnHi, aftercooltmp_warnLo, aftercooltmp_limitHi, aftercooltmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fanspeed_warnHi, fanspeed_warnLo, fanspeed_limitHi, fanspeed_limitLo, oillevel_warnHi, oillevel_warnLo, oillevel_limitHi, oillevel_limitLo, oilseptmp_warnHi, oilseptmp_warnLo, oilseptmp_limitHi, oilseptmp_limitLo, phaseseptmp_warnHi, phaseseptmp_warnLo, phaseseptmp_limitHi, phaseseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, surgetanktmp_warnHi, surgetanktmp_warnLo, surgetanktmp_limitHi, surgetanktmp_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo1_LimitsConfigurationEvent));
        Refrig_Cryo1_LimitsConfigurationEvent item_ = (Refrig_Cryo1_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)aftercooltmp_warnHi, (double)item_.getAftercooltmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_warnLo, (double)item_.getAftercooltmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitHi, (double)item_.getAftercooltmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitLo, (double)item_.getAftercooltmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnHi, (double)item_.getFanspeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnLo, (double)item_.getFanspeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitHi, (double)item_.getFanspeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitLo, (double)item_.getFanspeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnHi, (double)item_.getOillevel_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnLo, (double)item_.getOillevel_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitHi, (double)item_.getOillevel_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitLo, (double)item_.getOillevel_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnHi, (double)item_.getOilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnLo, (double)item_.getOilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitHi, (double)item_.getOilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitLo, (double)item_.getOilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnHi, (double)item_.getPhaseseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnLo, (double)item_.getPhaseseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitHi, (double)item_.getPhaseseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitLo, (double)item_.getPhaseseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnHi, (double)item_.getSurgetanktmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnLo, (double)item_.getSurgetanktmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitHi, (double)item_.getSurgetanktmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitLo, (double)item_.getSurgetanktmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo2_CompLimitsConfigurationEvent() throws Exception {
        String version = "h";
        double cmprPowerDelayLimit = 0.6804755330085754;
        int cmprPowerDelayTime = 244;
        double cmprPowerImmedLimit = 0.3508124351501465;
        double coldTempImmedLimit = 0.8864843845367432;
        double discPressDelayLimit = 0.1727469563484192;
        int discPressDelayTime = 469;
        double discPressImmedLimit = 0.3473753333091736;
        double discTempDelayLimit = 0.6098875999450684;
        int discTempDelayTime = 767;
        double discTempImmedLimit = 0.1778220534324646;
        double discTempLowImmedLimit = 0.4586156f;
        double heaterTempLimit = 0.6101097464561462;
        double liquidTempDelayLimit = 0.299530029296875;
        int liquidTempDelayTime = 304;
        double liquidTempImmedLimit = 0.08387166261672974;
        double orificeOffPress = 0.35478538274765015;
        double orificeOnPress = 0.9644457697868347;
        double phaseSepTempDelayLimit = 0.20856934785842896;
        int phaseSepTempDelayTime = 865;
        double pressDiffImmedLimit = 0.6355234384536743;
        double suctTempImmedLimit = 0.10355937480926514;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo2_CompLimitsConfigurationEvent(version, cmprPowerDelayLimit, cmprPowerDelayTime, cmprPowerImmedLimit, coldTempImmedLimit, discPressDelayLimit, discPressDelayTime, discPressImmedLimit, discTempDelayLimit, discTempDelayTime, discTempImmedLimit, discTempLowImmedLimit, heaterTempLimit, liquidTempDelayLimit, liquidTempDelayTime, liquidTempImmedLimit, orificeOffPress, orificeOnPress, phaseSepTempDelayLimit, phaseSepTempDelayTime, pressDiffImmedLimit, suctTempImmedLimit));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo2_CompLimitsConfigurationEvent));
        Refrig_Cryo2_CompLimitsConfigurationEvent item_ = (Refrig_Cryo2_CompLimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)cmprPowerDelayLimit, (double)item_.getCmprPowerDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)cmprPowerDelayTime, (long)item_.getCmprPowerDelayTime());
        Assert.assertEquals((double)cmprPowerImmedLimit, (double)item_.getCmprPowerImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)coldTempImmedLimit, (double)item_.getColdTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discPressDelayLimit, (double)item_.getDiscPressDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discPressDelayTime, (long)item_.getDiscPressDelayTime());
        Assert.assertEquals((double)discPressImmedLimit, (double)item_.getDiscPressImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempDelayLimit, (double)item_.getDiscTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discTempDelayTime, (long)item_.getDiscTempDelayTime());
        Assert.assertEquals((double)discTempImmedLimit, (double)item_.getDiscTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempLowImmedLimit, (double)item_.getDiscTempLowImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)heaterTempLimit, (double)item_.getHeaterTempLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidTempDelayLimit, (double)item_.getLiquidTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)liquidTempDelayTime, (long)item_.getLiquidTempDelayTime());
        Assert.assertEquals((double)liquidTempImmedLimit, (double)item_.getLiquidTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOffPress, (double)item_.getOrificeOffPress(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOnPress, (double)item_.getOrificeOnPress(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTempDelayLimit, (double)item_.getPhaseSepTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)phaseSepTempDelayTime, (long)item_.getPhaseSepTempDelayTime());
        Assert.assertEquals((double)pressDiffImmedLimit, (double)item_.getPressDiffImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)suctTempImmedLimit, (double)item_.getSuctTempImmedLimit(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo2_DeviceConfigurationEvent() throws Exception {
        String version = "";
        String maq20_node = "j";
        String maq20_serials = "";
        String plc_node = "o";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo2_DeviceConfigurationEvent(version, maq20_node, maq20_serials, plc_node));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo2_DeviceConfigurationEvent));
        Refrig_Cryo2_DeviceConfigurationEvent item_ = (Refrig_Cryo2_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
    }

    @Test
    public void sendReceiveRefrig_Cryo2_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double aftercooltmp_warnHi = 0.4749488830566406;
        double aftercooltmp_warnLo = 0.3190044164657593;
        double aftercooltmp_limitHi = 0.20412278175354004;
        double aftercooltmp_limitLo = 0.9971677660942078;
        double compcurrent_warnHi = 0.10977274179458618;
        double compcurrent_warnLo = 0.5512157082557678;
        double compcurrent_limitHi = 0.396841824054718;
        double compcurrent_limitLo = 0.052951693534851074;
        double comppower_warnHi = 0.6895899176597595;
        double comppower_warnLo = 0.855726f;
        double comppower_limitHi = 0.2652818560600281;
        double comppower_limitLo = 0.9297782182693481;
        double compvoltage_warnHi = 0.7525027394294739;
        double compvoltage_warnLo = 0.8187400698661804;
        double compvoltage_limitHi = 0.9196393489837646;
        double compvoltage_limitLo = 0.8585658669471741;
        double dischrgprs_warnHi = 0.6897554993629456;
        double dischrgprs_warnLo = 0.7235310673713684;
        double dischrgprs_limitHi = 0.2210521101951599;
        double dischrgprs_limitLo = 8.614659309387207E-4;
        double dischrgtmp_M_warnHi = 0.758385f;
        double dischrgtmp_M_warnLo = 0.986163318157196;
        double dischrgtmp_M_limitHi = 0.8220734000205994;
        double dischrgtmp_M_limitLo = 0.2030126452445984;
        double dischrgtmp_P_warnHi = 0.1932382583618164;
        double dischrgtmp_P_warnLo = 0.062367022037506104;
        double dischrgtmp_P_limitHi = 0.7379392981529236;
        double dischrgtmp_P_limitLo = 0.7134362459182739;
        double fanspeed_warnHi = 0.3505188226699829;
        double fanspeed_warnLo = 0.09814947843551636;
        double fanspeed_limitHi = 0.16175276041030884;
        double fanspeed_limitLo = 0.8024162650108337;
        double oillevel_warnHi = 0.8596912026405334;
        double oillevel_warnLo = 0.41652631759643555;
        double oillevel_limitHi = 0.27237361669540405;
        double oillevel_limitLo = 0.9842463135719299;
        double oilseptmp_warnHi = 0.8040790557861328;
        double oilseptmp_warnLo = 0.344898521900177;
        double oilseptmp_limitHi = 0.7289501428604126;
        double oilseptmp_limitLo = 0.9045096039772034;
        double phaseseptmp_warnHi = 0.7711588144302368;
        double phaseseptmp_warnLo = 0.22900527715682983;
        double phaseseptmp_limitHi = 0.6242959499359131;
        double phaseseptmp_limitLo = 0.796847939491272;
        double suctionprs_warnHi = 0.19282597303390503;
        double suctionprs_warnLo = 0.22758746147155762;
        double suctionprs_limitHi = 0.4324553608894348;
        double suctionprs_limitLo = 0.3753041625022888;
        double suctiontmp_M_warnHi = 0.16835826635360718;
        double suctiontmp_M_warnLo = 0.5050604343414307;
        double suctiontmp_M_limitHi = 0.06370240449905396;
        double suctiontmp_M_limitLo = 0.7674635052680969;
        double suctiontmp_P_warnHi = 0.06612330675125122;
        double suctiontmp_P_warnLo = 0.24641722440719604;
        double suctiontmp_P_limitHi = 0.4908837676048279;
        double suctiontmp_P_limitLo = 0.5330145359039307;
        double surgetanktmp_warnHi = 0.7250893115997314;
        double surgetanktmp_warnLo = 0.9086655378341675;
        double surgetanktmp_limitHi = 0.5705804228782654;
        double surgetanktmp_limitLo = 0.3904784321784973;
        double waterintmp_warnHi = 0.3178486227989197;
        double waterintmp_warnLo = 0.8363955616950989;
        double waterintmp_limitHi = 0.01528573f;
        double waterintmp_limitLo = 0.19582092761993408;
        double waterouttmp_warnHi = 0.6402224898338318;
        double waterouttmp_warnLo = 0.7362356781959534;
        double waterouttmp_limitHi = 0.9210574626922607;
        double waterouttmp_limitLo = 0.2001828f;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo2_LimitsConfigurationEvent(version, aftercooltmp_warnHi, aftercooltmp_warnLo, aftercooltmp_limitHi, aftercooltmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fanspeed_warnHi, fanspeed_warnLo, fanspeed_limitHi, fanspeed_limitLo, oillevel_warnHi, oillevel_warnLo, oillevel_limitHi, oillevel_limitLo, oilseptmp_warnHi, oilseptmp_warnLo, oilseptmp_limitHi, oilseptmp_limitLo, phaseseptmp_warnHi, phaseseptmp_warnLo, phaseseptmp_limitHi, phaseseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, surgetanktmp_warnHi, surgetanktmp_warnLo, surgetanktmp_limitHi, surgetanktmp_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo2_LimitsConfigurationEvent));
        Refrig_Cryo2_LimitsConfigurationEvent item_ = (Refrig_Cryo2_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)aftercooltmp_warnHi, (double)item_.getAftercooltmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_warnLo, (double)item_.getAftercooltmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitHi, (double)item_.getAftercooltmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitLo, (double)item_.getAftercooltmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnHi, (double)item_.getFanspeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnLo, (double)item_.getFanspeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitHi, (double)item_.getFanspeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitLo, (double)item_.getFanspeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnHi, (double)item_.getOillevel_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnLo, (double)item_.getOillevel_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitHi, (double)item_.getOillevel_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitLo, (double)item_.getOillevel_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnHi, (double)item_.getOilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnLo, (double)item_.getOilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitHi, (double)item_.getOilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitLo, (double)item_.getOilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnHi, (double)item_.getPhaseseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnLo, (double)item_.getPhaseseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitHi, (double)item_.getPhaseseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitLo, (double)item_.getPhaseseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnHi, (double)item_.getSurgetanktmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnLo, (double)item_.getSurgetanktmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitHi, (double)item_.getSurgetanktmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitLo, (double)item_.getSurgetanktmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo3_CompLimitsConfigurationEvent() throws Exception {
        String version = "";
        double cmprPowerDelayLimit = 0.0972716212272644;
        int cmprPowerDelayTime = 289;
        double cmprPowerImmedLimit = 0.14540356397628784;
        double coldTempImmedLimit = 0.48003554344177246;
        double discPressDelayLimit = 0.9238985776901245;
        int discPressDelayTime = 777;
        double discPressImmedLimit = 0.33633846044540405;
        double discTempDelayLimit = 0.3604347f;
        int discTempDelayTime = 791;
        double discTempImmedLimit = 0.8807411193847656;
        double discTempLowImmedLimit = 0.22478598356246948;
        double heaterTempLimit = 0.01323777437210083;
        double liquidTempDelayLimit = 0.48775774240493774;
        int liquidTempDelayTime = 14;
        double liquidTempImmedLimit = 0.03337627649307251;
        double orificeOffPress = 0.5512261986732483;
        double orificeOnPress = 0.3685334324836731;
        double phaseSepTempDelayLimit = 0.14840304851531982;
        int phaseSepTempDelayTime = 630;
        double pressDiffImmedLimit = 0.2468433380126953;
        double suctTempImmedLimit = 0.5710065364837646;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo3_CompLimitsConfigurationEvent(version, cmprPowerDelayLimit, cmprPowerDelayTime, cmprPowerImmedLimit, coldTempImmedLimit, discPressDelayLimit, discPressDelayTime, discPressImmedLimit, discTempDelayLimit, discTempDelayTime, discTempImmedLimit, discTempLowImmedLimit, heaterTempLimit, liquidTempDelayLimit, liquidTempDelayTime, liquidTempImmedLimit, orificeOffPress, orificeOnPress, phaseSepTempDelayLimit, phaseSepTempDelayTime, pressDiffImmedLimit, suctTempImmedLimit));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo3_CompLimitsConfigurationEvent));
        Refrig_Cryo3_CompLimitsConfigurationEvent item_ = (Refrig_Cryo3_CompLimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)cmprPowerDelayLimit, (double)item_.getCmprPowerDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)cmprPowerDelayTime, (long)item_.getCmprPowerDelayTime());
        Assert.assertEquals((double)cmprPowerImmedLimit, (double)item_.getCmprPowerImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)coldTempImmedLimit, (double)item_.getColdTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discPressDelayLimit, (double)item_.getDiscPressDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discPressDelayTime, (long)item_.getDiscPressDelayTime());
        Assert.assertEquals((double)discPressImmedLimit, (double)item_.getDiscPressImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempDelayLimit, (double)item_.getDiscTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discTempDelayTime, (long)item_.getDiscTempDelayTime());
        Assert.assertEquals((double)discTempImmedLimit, (double)item_.getDiscTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempLowImmedLimit, (double)item_.getDiscTempLowImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)heaterTempLimit, (double)item_.getHeaterTempLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidTempDelayLimit, (double)item_.getLiquidTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)liquidTempDelayTime, (long)item_.getLiquidTempDelayTime());
        Assert.assertEquals((double)liquidTempImmedLimit, (double)item_.getLiquidTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOffPress, (double)item_.getOrificeOffPress(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOnPress, (double)item_.getOrificeOnPress(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTempDelayLimit, (double)item_.getPhaseSepTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)phaseSepTempDelayTime, (long)item_.getPhaseSepTempDelayTime());
        Assert.assertEquals((double)pressDiffImmedLimit, (double)item_.getPressDiffImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)suctTempImmedLimit, (double)item_.getSuctTempImmedLimit(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo3_DeviceConfigurationEvent() throws Exception {
        String version = "";
        String maq20_node = "";
        String maq20_serials = "";
        String plc_node = "m";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo3_DeviceConfigurationEvent(version, maq20_node, maq20_serials, plc_node));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo3_DeviceConfigurationEvent));
        Refrig_Cryo3_DeviceConfigurationEvent item_ = (Refrig_Cryo3_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
    }

    @Test
    public void sendReceiveRefrig_Cryo3_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double aftercooltmp_warnHi = 0.4931233525276184;
        double aftercooltmp_warnLo = 0.5774151682853699;
        double aftercooltmp_limitHi = 0.10885119438171387;
        double aftercooltmp_limitLo = 0.18275481462478638;
        double ambienttmp_warnHi = 0.6625542044639587;
        double ambienttmp_warnLo = 0.65358f;
        double ambienttmp_limitHi = 0.4216992259025574;
        double ambienttmp_limitLo = 0.49060964584350586;
        double cabinettmp_warnHi = 0.576188862323761;
        double cabinettmp_warnLo = 0.7076285481452942;
        double cabinettmp_limitHi = 0.8091249465942383;
        double cabinettmp_limitLo = 0.5208961963653564;
        double compcurrent_warnHi = 0.745803952217102;
        double compcurrent_warnLo = 0.4315042495727539;
        double compcurrent_limitHi = 0.06382858753204346;
        double compcurrent_limitLo = 0.44760453701019287;
        double comppower_warnHi = 0.22132503986358643;
        double comppower_warnLo = 0.582874059677124;
        double comppower_limitHi = 0.47678375244140625;
        double comppower_limitLo = 0.9815229177474976;
        double compvoltage_warnHi = 0.8861351013183594;
        double compvoltage_warnLo = 0.26060914993286133;
        double compvoltage_limitHi = 0.40995967388153076;
        double compvoltage_limitLo = 0.3302185535430908;
        double dischrgprs_warnHi = 0.2610187530517578;
        double dischrgprs_warnLo = 0.540095865726471;
        double dischrgprs_limitHi = 0.1026091f;
        double dischrgprs_limitLo = 0.4469099f;
        double dischrgtmp_M_warnHi = 0.22739005088806152;
        double dischrgtmp_M_warnLo = 0.09896194934844971;
        double dischrgtmp_M_limitHi = 0.5870565176010132;
        double dischrgtmp_M_limitLo = 0.5822194218635559;
        double dischrgtmp_P_warnHi = 0.5386918187141418;
        double dischrgtmp_P_warnLo = 0.6131938695907593;
        double dischrgtmp_P_limitHi = 0.8008796572685242;
        double dischrgtmp_P_limitLo = 0.2701093554496765;
        double fanspeed_warnHi = 0.18812376260757446;
        double fanspeed_warnLo = 0.3437894f;
        double fanspeed_limitHi = 0.0325050950050354;
        double fanspeed_limitLo = 0.9351528882980347;
        double oillevel_warnHi = 0.2944710850715637;
        double oillevel_warnLo = 0.17696022987365723;
        double oillevel_limitHi = 0.8251739144325256;
        double oillevel_limitLo = 0.5536596179008484;
        double oilseptmp_warnHi = 0.012217521667480469;
        double oilseptmp_warnLo = 0.2790037989616394;
        double oilseptmp_limitHi = 0.8167297840118408;
        double oilseptmp_limitLo = 0.2526538372039795;
        double phaseseptmp_warnHi = 0.37689924240112305;
        double phaseseptmp_warnLo = 0.72347092628479;
        double phaseseptmp_limitHi = 0.7146243453025818;
        double phaseseptmp_limitLo = 0.4205285906791687;
        double suctionprs_warnHi = 0.9744883179664612;
        double suctionprs_warnLo = 0.8269518613815308;
        double suctionprs_limitHi = 0.5299327373504639;
        double suctionprs_limitLo = 0.12921392917633057;
        double suctiontmp_M_warnHi = 0.8403084874153137;
        double suctiontmp_M_warnLo = 0.2651034f;
        double suctiontmp_M_limitHi = 0.2321536f;
        double suctiontmp_M_limitLo = 0.24338674545288086;
        double suctiontmp_P_warnHi = 0.2175209f;
        double suctiontmp_P_warnLo = 0.24748414754867554;
        double suctiontmp_P_limitHi = 0.3773950934410095;
        double suctiontmp_P_limitLo = 0.0967077f;
        double surgetanktmp_warnHi = 0.3596503f;
        double surgetanktmp_warnLo = 0.41401517391204834;
        double surgetanktmp_limitHi = 0.8236048221588135;
        double surgetanktmp_limitLo = 0.64303f;
        double waterintmp_warnHi = 0.7711450457572937;
        double waterintmp_warnLo = 0.6237296462059021;
        double waterintmp_limitHi = 0.023287057876586914;
        double waterintmp_limitLo = 0.40233057737350464;
        double waterouttmp_warnHi = 0.4228951930999756;
        double waterouttmp_warnLo = 0.2748332f;
        double waterouttmp_limitHi = 0.30031102895736694;
        double waterouttmp_limitLo = 0.6927521824836731;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo3_LimitsConfigurationEvent(version, aftercooltmp_warnHi, aftercooltmp_warnLo, aftercooltmp_limitHi, aftercooltmp_limitLo, ambienttmp_warnHi, ambienttmp_warnLo, ambienttmp_limitHi, ambienttmp_limitLo, cabinettmp_warnHi, cabinettmp_warnLo, cabinettmp_limitHi, cabinettmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fanspeed_warnHi, fanspeed_warnLo, fanspeed_limitHi, fanspeed_limitLo, oillevel_warnHi, oillevel_warnLo, oillevel_limitHi, oillevel_limitLo, oilseptmp_warnHi, oilseptmp_warnLo, oilseptmp_limitHi, oilseptmp_limitLo, phaseseptmp_warnHi, phaseseptmp_warnLo, phaseseptmp_limitHi, phaseseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, surgetanktmp_warnHi, surgetanktmp_warnLo, surgetanktmp_limitHi, surgetanktmp_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo3_LimitsConfigurationEvent));
        Refrig_Cryo3_LimitsConfigurationEvent item_ = (Refrig_Cryo3_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)aftercooltmp_warnHi, (double)item_.getAftercooltmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_warnLo, (double)item_.getAftercooltmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitHi, (double)item_.getAftercooltmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitLo, (double)item_.getAftercooltmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_warnHi, (double)item_.getAmbienttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_warnLo, (double)item_.getAmbienttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitHi, (double)item_.getAmbienttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitLo, (double)item_.getAmbienttmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnHi, (double)item_.getCabinettmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnLo, (double)item_.getCabinettmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitHi, (double)item_.getCabinettmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitLo, (double)item_.getCabinettmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnHi, (double)item_.getFanspeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnLo, (double)item_.getFanspeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitHi, (double)item_.getFanspeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitLo, (double)item_.getFanspeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnHi, (double)item_.getOillevel_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnLo, (double)item_.getOillevel_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitHi, (double)item_.getOillevel_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitLo, (double)item_.getOillevel_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnHi, (double)item_.getOilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnLo, (double)item_.getOilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitHi, (double)item_.getOilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitLo, (double)item_.getOilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnHi, (double)item_.getPhaseseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnLo, (double)item_.getPhaseseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitHi, (double)item_.getPhaseseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitLo, (double)item_.getPhaseseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnHi, (double)item_.getSurgetanktmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnLo, (double)item_.getSurgetanktmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitHi, (double)item_.getSurgetanktmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitLo, (double)item_.getSurgetanktmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo4_CompLimitsConfigurationEvent() throws Exception {
        String version = "";
        double cmprPowerDelayLimit = 0.2015022f;
        int cmprPowerDelayTime = 61;
        double cmprPowerImmedLimit = 0.7132042646408081;
        double coldTempImmedLimit = 0.4456857442855835;
        double discPressDelayLimit = 0.9054670929908752;
        int discPressDelayTime = 45;
        double discPressImmedLimit = 0.17269080877304077;
        double discTempDelayLimit = 0.9117224216461182;
        int discTempDelayTime = 478;
        double discTempImmedLimit = 0.40556687116622925;
        double discTempLowImmedLimit = 0.7757561802864075;
        double heaterTempLimit = 0.793748f;
        double liquidTempDelayLimit = 0.250373f;
        int liquidTempDelayTime = 519;
        double liquidTempImmedLimit = 0.9066471457481384;
        double orificeOffPress = 0.7543467879295349;
        double orificeOnPress = 0.6659121513366699;
        double phaseSepTempDelayLimit = 0.03457885980606079;
        int phaseSepTempDelayTime = 185;
        double pressDiffImmedLimit = 0.1956343650817871;
        double suctTempImmedLimit = 0.1312609314918518;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo4_CompLimitsConfigurationEvent(version, cmprPowerDelayLimit, cmprPowerDelayTime, cmprPowerImmedLimit, coldTempImmedLimit, discPressDelayLimit, discPressDelayTime, discPressImmedLimit, discTempDelayLimit, discTempDelayTime, discTempImmedLimit, discTempLowImmedLimit, heaterTempLimit, liquidTempDelayLimit, liquidTempDelayTime, liquidTempImmedLimit, orificeOffPress, orificeOnPress, phaseSepTempDelayLimit, phaseSepTempDelayTime, pressDiffImmedLimit, suctTempImmedLimit));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo4_CompLimitsConfigurationEvent));
        Refrig_Cryo4_CompLimitsConfigurationEvent item_ = (Refrig_Cryo4_CompLimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)cmprPowerDelayLimit, (double)item_.getCmprPowerDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)cmprPowerDelayTime, (long)item_.getCmprPowerDelayTime());
        Assert.assertEquals((double)cmprPowerImmedLimit, (double)item_.getCmprPowerImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)coldTempImmedLimit, (double)item_.getColdTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discPressDelayLimit, (double)item_.getDiscPressDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discPressDelayTime, (long)item_.getDiscPressDelayTime());
        Assert.assertEquals((double)discPressImmedLimit, (double)item_.getDiscPressImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempDelayLimit, (double)item_.getDiscTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discTempDelayTime, (long)item_.getDiscTempDelayTime());
        Assert.assertEquals((double)discTempImmedLimit, (double)item_.getDiscTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempLowImmedLimit, (double)item_.getDiscTempLowImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)heaterTempLimit, (double)item_.getHeaterTempLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidTempDelayLimit, (double)item_.getLiquidTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)liquidTempDelayTime, (long)item_.getLiquidTempDelayTime());
        Assert.assertEquals((double)liquidTempImmedLimit, (double)item_.getLiquidTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOffPress, (double)item_.getOrificeOffPress(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOnPress, (double)item_.getOrificeOnPress(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTempDelayLimit, (double)item_.getPhaseSepTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)phaseSepTempDelayTime, (long)item_.getPhaseSepTempDelayTime());
        Assert.assertEquals((double)pressDiffImmedLimit, (double)item_.getPressDiffImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)suctTempImmedLimit, (double)item_.getSuctTempImmedLimit(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo4_DeviceConfigurationEvent() throws Exception {
        String version = "";
        String maq20_node = "";
        String maq20_serials = "j";
        String plc_node = "r";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo4_DeviceConfigurationEvent(version, maq20_node, maq20_serials, plc_node));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo4_DeviceConfigurationEvent));
        Refrig_Cryo4_DeviceConfigurationEvent item_ = (Refrig_Cryo4_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
    }

    @Test
    public void sendReceiveRefrig_Cryo4_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double aftercooltmp_warnHi = 0.09214985370635986;
        double aftercooltmp_warnLo = 0.4011055827140808;
        double aftercooltmp_limitHi = 0.017182588577270508;
        double aftercooltmp_limitLo = 0.568577766418457;
        double compcurrent_warnHi = 0.2997971177101135;
        double compcurrent_warnLo = 0.03229391574859619;
        double compcurrent_limitHi = 0.46688413619995117;
        double compcurrent_limitLo = 0.9947351813316345;
        double comppower_warnHi = 0.6388403177261353;
        double comppower_warnLo = 0.6264894604682922;
        double comppower_limitHi = 0.5283551812171936;
        double comppower_limitLo = 0.18395566940307617;
        double compvoltage_warnHi = 0.1932077407836914;
        double compvoltage_warnLo = 0.6003178954124451;
        double compvoltage_limitHi = 0.6415472626686096;
        double compvoltage_limitLo = 0.8836649656295776;
        double dischrgprs_warnHi = 0.6872890591621399;
        double dischrgprs_warnLo = 0.26738274097442627;
        double dischrgprs_limitHi = 0.05051279067993164;
        double dischrgprs_limitLo = 0.5155674815177917;
        double dischrgtmp_M_warnHi = 0.4818124771118164;
        double dischrgtmp_M_warnLo = 0.5618872046470642;
        double dischrgtmp_M_limitHi = 0.05482828617095947;
        double dischrgtmp_M_limitLo = 0.8134623169898987;
        double dischrgtmp_P_warnHi = 0.8410322666168213;
        double dischrgtmp_P_warnLo = 0.3022293448448181;
        double dischrgtmp_P_limitHi = 0.6503296494483948;
        double dischrgtmp_P_limitLo = 0.9587438702583313;
        double fanspeed_warnHi = 0.8108999133110046;
        double fanspeed_warnLo = 4.579425E-4f;
        double fanspeed_limitHi = 0.28082817792892456;
        double fanspeed_limitLo = 0.4031602740287781;
        double oillevel_warnHi = 0.4547199010848999;
        double oillevel_warnLo = 0.9335781931877136;
        double oillevel_limitHi = 0.6341502070426941;
        double oillevel_limitLo = 0.9904511570930481;
        double oilseptmp_warnHi = 0.30330485105514526;
        double oilseptmp_warnLo = 0.9470493793487549;
        double oilseptmp_limitHi = 0.9195677042007446;
        double oilseptmp_limitLo = 0.3380838632583618;
        double phaseseptmp_warnHi = 0.3089866042137146;
        double phaseseptmp_warnLo = 0.1393022f;
        double phaseseptmp_limitHi = 0.2666983f;
        double phaseseptmp_limitLo = 0.605151891708374;
        double suctionprs_warnHi = 0.6058160662651062;
        double suctionprs_warnLo = 0.8867303133010864;
        double suctionprs_limitHi = 0.4610862731933594;
        double suctionprs_limitLo = 0.5934098958969116;
        double suctiontmp_M_warnHi = 0.12129944562911987;
        double suctiontmp_M_warnLo = 0.3975124955177307;
        double suctiontmp_M_limitHi = 0.36742645502090454;
        double suctiontmp_M_limitLo = 0.6493446826934814;
        double suctiontmp_P_warnHi = 0.8481138944625854;
        double suctiontmp_P_warnLo = 0.24405282735824585;
        double suctiontmp_P_limitHi = 0.04184520244598389;
        double suctiontmp_P_limitLo = 0.553186297416687;
        double surgetanktmp_warnHi = 0.04808610677719116;
        double surgetanktmp_warnLo = 0.8101748824119568;
        double surgetanktmp_limitHi = 0.669546365737915;
        double surgetanktmp_limitLo = 0.6960483193397522;
        double waterintmp_warnHi = 0.14659267663955688;
        double waterintmp_warnLo = 0.8209753632545471;
        double waterintmp_limitHi = 0.3188077211380005;
        double waterintmp_limitLo = 0.5122677683830261;
        double waterouttmp_warnHi = 0.7953612804412842;
        double waterouttmp_warnLo = 0.699066162109375;
        double waterouttmp_limitHi = 0.8277574181556702;
        double waterouttmp_limitLo = 0.7069417238235474;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo4_LimitsConfigurationEvent(version, aftercooltmp_warnHi, aftercooltmp_warnLo, aftercooltmp_limitHi, aftercooltmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fanspeed_warnHi, fanspeed_warnLo, fanspeed_limitHi, fanspeed_limitLo, oillevel_warnHi, oillevel_warnLo, oillevel_limitHi, oillevel_limitLo, oilseptmp_warnHi, oilseptmp_warnLo, oilseptmp_limitHi, oilseptmp_limitLo, phaseseptmp_warnHi, phaseseptmp_warnLo, phaseseptmp_limitHi, phaseseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, surgetanktmp_warnHi, surgetanktmp_warnLo, surgetanktmp_limitHi, surgetanktmp_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo4_LimitsConfigurationEvent));
        Refrig_Cryo4_LimitsConfigurationEvent item_ = (Refrig_Cryo4_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)aftercooltmp_warnHi, (double)item_.getAftercooltmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_warnLo, (double)item_.getAftercooltmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitHi, (double)item_.getAftercooltmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitLo, (double)item_.getAftercooltmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnHi, (double)item_.getFanspeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnLo, (double)item_.getFanspeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitHi, (double)item_.getFanspeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitLo, (double)item_.getFanspeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnHi, (double)item_.getOillevel_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnLo, (double)item_.getOillevel_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitHi, (double)item_.getOillevel_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitLo, (double)item_.getOillevel_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnHi, (double)item_.getOilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnLo, (double)item_.getOilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitHi, (double)item_.getOilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitLo, (double)item_.getOilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnHi, (double)item_.getPhaseseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnLo, (double)item_.getPhaseseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitHi, (double)item_.getPhaseseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitLo, (double)item_.getPhaseseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnHi, (double)item_.getSurgetanktmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnLo, (double)item_.getSurgetanktmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitHi, (double)item_.getSurgetanktmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitLo, (double)item_.getSurgetanktmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo5_CompLimitsConfigurationEvent() throws Exception {
        String version = "m";
        double cmprPowerDelayLimit = 0.4531694f;
        int cmprPowerDelayTime = 770;
        double cmprPowerImmedLimit = 0.948234498500824;
        double coldTempImmedLimit = 0.5025935769081116;
        double discPressDelayLimit = 0.7429161667823792;
        int discPressDelayTime = 466;
        double discPressImmedLimit = 0.6613069176673889;
        double discTempDelayLimit = 0.808845579624176;
        int discTempDelayTime = 6;
        double discTempImmedLimit = 0.945868f;
        double discTempLowImmedLimit = 0.6540940403938293;
        double heaterTempLimit = 0.4631303548812866;
        double liquidTempDelayLimit = 0.435367226600647;
        int liquidTempDelayTime = 189;
        double liquidTempImmedLimit = 0.3723371624946594;
        double orificeOffPress = 0.4801780581474304;
        double orificeOnPress = 0.7776781320571899;
        double phaseSepTempDelayLimit = 0.049924612045288086;
        int phaseSepTempDelayTime = 753;
        double pressDiffImmedLimit = 0.1619059443473816;
        double suctTempImmedLimit = 0.04338204860687256;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo5_CompLimitsConfigurationEvent(version, cmprPowerDelayLimit, cmprPowerDelayTime, cmprPowerImmedLimit, coldTempImmedLimit, discPressDelayLimit, discPressDelayTime, discPressImmedLimit, discTempDelayLimit, discTempDelayTime, discTempImmedLimit, discTempLowImmedLimit, heaterTempLimit, liquidTempDelayLimit, liquidTempDelayTime, liquidTempImmedLimit, orificeOffPress, orificeOnPress, phaseSepTempDelayLimit, phaseSepTempDelayTime, pressDiffImmedLimit, suctTempImmedLimit));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo5_CompLimitsConfigurationEvent));
        Refrig_Cryo5_CompLimitsConfigurationEvent item_ = (Refrig_Cryo5_CompLimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)cmprPowerDelayLimit, (double)item_.getCmprPowerDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)cmprPowerDelayTime, (long)item_.getCmprPowerDelayTime());
        Assert.assertEquals((double)cmprPowerImmedLimit, (double)item_.getCmprPowerImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)coldTempImmedLimit, (double)item_.getColdTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discPressDelayLimit, (double)item_.getDiscPressDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discPressDelayTime, (long)item_.getDiscPressDelayTime());
        Assert.assertEquals((double)discPressImmedLimit, (double)item_.getDiscPressImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempDelayLimit, (double)item_.getDiscTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discTempDelayTime, (long)item_.getDiscTempDelayTime());
        Assert.assertEquals((double)discTempImmedLimit, (double)item_.getDiscTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempLowImmedLimit, (double)item_.getDiscTempLowImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)heaterTempLimit, (double)item_.getHeaterTempLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidTempDelayLimit, (double)item_.getLiquidTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)liquidTempDelayTime, (long)item_.getLiquidTempDelayTime());
        Assert.assertEquals((double)liquidTempImmedLimit, (double)item_.getLiquidTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOffPress, (double)item_.getOrificeOffPress(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOnPress, (double)item_.getOrificeOnPress(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTempDelayLimit, (double)item_.getPhaseSepTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)phaseSepTempDelayTime, (long)item_.getPhaseSepTempDelayTime());
        Assert.assertEquals((double)pressDiffImmedLimit, (double)item_.getPressDiffImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)suctTempImmedLimit, (double)item_.getSuctTempImmedLimit(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo5_DeviceConfigurationEvent() throws Exception {
        String version = "i";
        String maq20_node = "";
        String maq20_serials = "p";
        String plc_node = "b";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo5_DeviceConfigurationEvent(version, maq20_node, maq20_serials, plc_node));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo5_DeviceConfigurationEvent));
        Refrig_Cryo5_DeviceConfigurationEvent item_ = (Refrig_Cryo5_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
    }

    @Test
    public void sendReceiveRefrig_Cryo5_LimitsConfigurationEvent() throws Exception {
        String version = "e";
        double aftercooltmp_warnHi = 0.3417816758155823;
        double aftercooltmp_warnLo = 0.8262566924095154;
        double aftercooltmp_limitHi = 0.1373441219329834;
        double aftercooltmp_limitLo = 0.7531834840774536;
        double ambienttmp_warnHi = 0.917516827583313;
        double ambienttmp_warnLo = 0.5608363747596741;
        double ambienttmp_limitHi = 0.5418193340301514;
        double ambienttmp_limitLo = 0.5804728865623474;
        double cabinettmp_warnHi = 0.2977433204650879;
        double cabinettmp_warnLo = 0.764141857624054;
        double cabinettmp_limitHi = 0.8136701583862305;
        double cabinettmp_limitLo = 0.8727527260780334;
        double compcurrent_warnHi = 0.18094027042388916;
        double compcurrent_warnLo = 0.976333737373352;
        double compcurrent_limitHi = 0.2161724f;
        double compcurrent_limitLo = 0.09665262699127197;
        double comppower_warnHi = 0.14348101615905762;
        double comppower_warnLo = 0.7611824870109558;
        double comppower_limitHi = 0.7056794166564941;
        double comppower_limitLo = 0.13147515058517456;
        double compvoltage_warnHi = 0.26106226444244385;
        double compvoltage_warnLo = 0.8099966645240784;
        double compvoltage_limitHi = 0.8740232586860657;
        double compvoltage_limitLo = 0.14178311824798584;
        double dischrgprs_warnHi = 0.17586815357208252;
        double dischrgprs_warnLo = 0.3382815718650818;
        double dischrgprs_limitHi = 0.6187385320663452;
        double dischrgprs_limitLo = 0.545904278755188;
        double dischrgtmp_M_warnHi = 0.40586984157562256;
        double dischrgtmp_M_warnLo = 0.8204331398010254;
        double dischrgtmp_M_limitHi = 0.4479323f;
        double dischrgtmp_M_limitLo = 0.3169436454772949;
        double dischrgtmp_P_warnHi = 0.07807135581970215;
        double dischrgtmp_P_warnLo = 0.07647973299026489;
        double dischrgtmp_P_limitHi = 0.44509416818618774;
        double dischrgtmp_P_limitLo = 0.45981645584106445;
        double fanspeed_warnHi = 0.9981975555419922;
        double fanspeed_warnLo = 0.17241257429122925;
        double fanspeed_limitHi = 0.1978340744972229;
        double fanspeed_limitLo = 0.17217093706130981;
        double oillevel_warnHi = 0.6790739297866821;
        double oillevel_warnLo = 0.10500502586364746;
        double oillevel_limitHi = 0.4812912344932556;
        double oillevel_limitLo = 0.6346797943115234;
        double oilseptmp_warnHi = 0.16317439079284668;
        double oilseptmp_warnLo = 0.47433704137802124;
        double oilseptmp_limitHi = 0.7452647686004639;
        double oilseptmp_limitLo = 0.5059914588928223;
        double phaseseptmp_warnHi = 0.856564462184906;
        double phaseseptmp_warnLo = 0.2917814254760742;
        double phaseseptmp_limitHi = 0.8130668997764587;
        double phaseseptmp_limitLo = 0.3917103409767151;
        double suctionprs_warnHi = 0.19739621877670288;
        double suctionprs_warnLo = 0.2953476905822754;
        double suctionprs_limitHi = 0.004425227642059326;
        double suctionprs_limitLo = 0.8903229236602783;
        double suctiontmp_M_warnHi = 0.5085130333900452;
        double suctiontmp_M_warnLo = 0.04353010654449463;
        double suctiontmp_M_limitHi = 0.7548102736473083;
        double suctiontmp_M_limitLo = 0.3203164339065552;
        double suctiontmp_P_warnHi = 0.4175090789794922;
        double suctiontmp_P_warnLo = 0.1067974f;
        double suctiontmp_P_limitHi = 0.8453167080879211;
        double suctiontmp_P_limitLo = 0.13330018520355225;
        double surgetanktmp_warnHi = 0.49629926681518555;
        double surgetanktmp_warnLo = 0.6743577122688293;
        double surgetanktmp_limitHi = 0.47228187322616577;
        double surgetanktmp_limitLo = 0.0023023486137390137;
        double waterintmp_warnHi = 0.3940557837486267;
        double waterintmp_warnLo = 0.22270601987838745;
        double waterintmp_limitHi = 0.48140984773635864;
        double waterintmp_limitLo = 0.030275821685791016;
        double waterouttmp_warnHi = 0.4710425138473511;
        double waterouttmp_warnLo = 0.7597308158874512;
        double waterouttmp_limitHi = 0.3401355f;
        double waterouttmp_limitLo = 0.7920231819152832;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo5_LimitsConfigurationEvent(version, aftercooltmp_warnHi, aftercooltmp_warnLo, aftercooltmp_limitHi, aftercooltmp_limitLo, ambienttmp_warnHi, ambienttmp_warnLo, ambienttmp_limitHi, ambienttmp_limitLo, cabinettmp_warnHi, cabinettmp_warnLo, cabinettmp_limitHi, cabinettmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fanspeed_warnHi, fanspeed_warnLo, fanspeed_limitHi, fanspeed_limitLo, oillevel_warnHi, oillevel_warnLo, oillevel_limitHi, oillevel_limitLo, oilseptmp_warnHi, oilseptmp_warnLo, oilseptmp_limitHi, oilseptmp_limitLo, phaseseptmp_warnHi, phaseseptmp_warnLo, phaseseptmp_limitHi, phaseseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, surgetanktmp_warnHi, surgetanktmp_warnLo, surgetanktmp_limitHi, surgetanktmp_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo5_LimitsConfigurationEvent));
        Refrig_Cryo5_LimitsConfigurationEvent item_ = (Refrig_Cryo5_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)aftercooltmp_warnHi, (double)item_.getAftercooltmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_warnLo, (double)item_.getAftercooltmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitHi, (double)item_.getAftercooltmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitLo, (double)item_.getAftercooltmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_warnHi, (double)item_.getAmbienttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_warnLo, (double)item_.getAmbienttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitHi, (double)item_.getAmbienttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitLo, (double)item_.getAmbienttmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnHi, (double)item_.getCabinettmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnLo, (double)item_.getCabinettmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitHi, (double)item_.getCabinettmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitLo, (double)item_.getCabinettmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnHi, (double)item_.getFanspeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnLo, (double)item_.getFanspeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitHi, (double)item_.getFanspeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitLo, (double)item_.getFanspeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnHi, (double)item_.getOillevel_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnLo, (double)item_.getOillevel_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitHi, (double)item_.getOillevel_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitLo, (double)item_.getOillevel_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnHi, (double)item_.getOilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnLo, (double)item_.getOilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitHi, (double)item_.getOilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitLo, (double)item_.getOilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnHi, (double)item_.getPhaseseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnLo, (double)item_.getPhaseseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitHi, (double)item_.getPhaseseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitLo, (double)item_.getPhaseseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnHi, (double)item_.getSurgetanktmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnLo, (double)item_.getSurgetanktmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitHi, (double)item_.getSurgetanktmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitLo, (double)item_.getSurgetanktmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo6_CompLimitsConfigurationEvent() throws Exception {
        String version = "";
        double cmprPowerDelayLimit = 0.849946916103363;
        int cmprPowerDelayTime = 935;
        double cmprPowerImmedLimit = 0.5471908450126648;
        double coldTempImmedLimit = 0.5348250865936279;
        double discPressDelayLimit = 0.756996214389801;
        int discPressDelayTime = 815;
        double discPressImmedLimit = 0.9397528767585754;
        double discTempDelayLimit = 0.6208028793334961;
        int discTempDelayTime = 426;
        double discTempImmedLimit = 0.2754226326942444;
        double discTempLowImmedLimit = 0.530706524848938;
        double heaterTempLimit = 0.7597888112068176;
        double liquidTempDelayLimit = 0.4441121816635132;
        int liquidTempDelayTime = 805;
        double liquidTempImmedLimit = 0.24884724617004395;
        double orificeOffPress = 0.6310590505599976;
        double orificeOnPress = 0.7730971574783325;
        double phaseSepTempDelayLimit = 0.6482424736022949;
        int phaseSepTempDelayTime = 600;
        double pressDiffImmedLimit = 0.6906232833862305;
        double suctTempImmedLimit = 0.4050159f;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo6_CompLimitsConfigurationEvent(version, cmprPowerDelayLimit, cmprPowerDelayTime, cmprPowerImmedLimit, coldTempImmedLimit, discPressDelayLimit, discPressDelayTime, discPressImmedLimit, discTempDelayLimit, discTempDelayTime, discTempImmedLimit, discTempLowImmedLimit, heaterTempLimit, liquidTempDelayLimit, liquidTempDelayTime, liquidTempImmedLimit, orificeOffPress, orificeOnPress, phaseSepTempDelayLimit, phaseSepTempDelayTime, pressDiffImmedLimit, suctTempImmedLimit));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo6_CompLimitsConfigurationEvent));
        Refrig_Cryo6_CompLimitsConfigurationEvent item_ = (Refrig_Cryo6_CompLimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)cmprPowerDelayLimit, (double)item_.getCmprPowerDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)cmprPowerDelayTime, (long)item_.getCmprPowerDelayTime());
        Assert.assertEquals((double)cmprPowerImmedLimit, (double)item_.getCmprPowerImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)coldTempImmedLimit, (double)item_.getColdTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discPressDelayLimit, (double)item_.getDiscPressDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discPressDelayTime, (long)item_.getDiscPressDelayTime());
        Assert.assertEquals((double)discPressImmedLimit, (double)item_.getDiscPressImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempDelayLimit, (double)item_.getDiscTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discTempDelayTime, (long)item_.getDiscTempDelayTime());
        Assert.assertEquals((double)discTempImmedLimit, (double)item_.getDiscTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempLowImmedLimit, (double)item_.getDiscTempLowImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)heaterTempLimit, (double)item_.getHeaterTempLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidTempDelayLimit, (double)item_.getLiquidTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)liquidTempDelayTime, (long)item_.getLiquidTempDelayTime());
        Assert.assertEquals((double)liquidTempImmedLimit, (double)item_.getLiquidTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOffPress, (double)item_.getOrificeOffPress(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOnPress, (double)item_.getOrificeOnPress(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTempDelayLimit, (double)item_.getPhaseSepTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)phaseSepTempDelayTime, (long)item_.getPhaseSepTempDelayTime());
        Assert.assertEquals((double)pressDiffImmedLimit, (double)item_.getPressDiffImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)suctTempImmedLimit, (double)item_.getSuctTempImmedLimit(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo6_DeviceConfigurationEvent() throws Exception {
        String version = "";
        String maq20_node = "";
        String maq20_serials = "";
        String plc_node = "";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo6_DeviceConfigurationEvent(version, maq20_node, maq20_serials, plc_node));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo6_DeviceConfigurationEvent));
        Refrig_Cryo6_DeviceConfigurationEvent item_ = (Refrig_Cryo6_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
    }

    @Test
    public void sendReceiveRefrig_Cryo6_LimitsConfigurationEvent() throws Exception {
        String version = "t";
        double aftercooltmp_warnHi = 0.08975344896316528;
        double aftercooltmp_warnLo = 0.8730581998825073;
        double aftercooltmp_limitHi = 0.6952483654022217;
        double aftercooltmp_limitLo = 0.22655218839645386;
        double compcurrent_warnHi = 0.5505384802818298;
        double compcurrent_warnLo = 0.014067888259887695;
        double compcurrent_limitHi = 0.03614205f;
        double compcurrent_limitLo = 0.37096112966537476;
        double comppower_warnHi = 0.3495739698410034;
        double comppower_warnLo = 0.7331953048706055;
        double comppower_limitHi = 0.44190144538879395;
        double comppower_limitLo = 0.8249333500862122;
        double compvoltage_warnHi = 0.3438388705253601;
        double compvoltage_warnLo = 0.6647447347640991;
        double compvoltage_limitHi = 0.09924596548080444;
        double compvoltage_limitLo = 0.388649046421051;
        double dischrgprs_warnHi = 0.192366361618042;
        double dischrgprs_warnLo = 0.3791356682777405;
        double dischrgprs_limitHi = 0.6766318678855896;
        double dischrgprs_limitLo = 0.4565402865409851;
        double dischrgtmp_M_warnHi = 0.5763600468635559;
        double dischrgtmp_M_warnLo = 0.8063295483589172;
        double dischrgtmp_M_limitHi = 0.20522820949554443;
        double dischrgtmp_M_limitLo = 0.04169929027557373;
        double dischrgtmp_P_warnHi = 0.5060730576515198;
        double dischrgtmp_P_warnLo = 0.4233966f;
        double dischrgtmp_P_limitHi = 0.02714228630065918;
        double dischrgtmp_P_limitLo = 0.20204466581344604;
        double fanspeed_warnHi = 0.4414917230606079;
        double fanspeed_warnLo = 0.8437589406967163;
        double fanspeed_limitHi = 0.8764467239379883;
        double fanspeed_limitLo = 0.4024495482444763;
        double oillevel_warnHi = 0.42289382219314575;
        double oillevel_warnLo = 0.9662340879440308;
        double oillevel_limitHi = 0.11944049596786499;
        double oillevel_limitLo = 0.7138491868972778;
        double oilseptmp_warnHi = 0.15329605340957642;
        double oilseptmp_warnLo = 0.3902401328086853;
        double oilseptmp_limitHi = 0.1239391f;
        double oilseptmp_limitLo = 0.8015385270118713;
        double phaseseptmp_warnHi = 0.03770667314529419;
        double phaseseptmp_warnLo = 0.2436668872833252;
        double phaseseptmp_limitHi = 0.35733717679977417;
        double phaseseptmp_limitLo = 0.6375284790992737;
        double suctionprs_warnHi = 0.9946182370185852;
        double suctionprs_warnLo = 0.3443509340286255;
        double suctionprs_limitHi = 0.8494451642036438;
        double suctionprs_limitLo = 0.7361348271369934;
        double suctiontmp_M_warnHi = 0.4846060276031494;
        double suctiontmp_M_warnLo = 0.9953231811523438;
        double suctiontmp_M_limitHi = 0.08402401208877563;
        double suctiontmp_M_limitLo = 0.3612545132637024;
        double suctiontmp_P_warnHi = 0.6111468076705933;
        double suctiontmp_P_warnLo = 0.046657443046569824;
        double suctiontmp_P_limitHi = 0.7034997344017029;
        double suctiontmp_P_limitLo = 0.6944841146469116;
        double surgetanktmp_warnHi = 0.4423891305923462;
        double surgetanktmp_warnLo = 0.8195973038673401;
        double surgetanktmp_limitHi = 0.8911446928977966;
        double surgetanktmp_limitLo = 0.9449220299720764;
        double waterintmp_warnHi = 0.3727429509162903;
        double waterintmp_warnLo = 0.3365599f;
        double waterintmp_limitHi = 0.2162773609161377;
        double waterintmp_limitLo = 0.08686792850494385;
        double waterouttmp_warnHi = 0.5236115455627441;
        double waterouttmp_warnLo = 0.11660957336425781;
        double waterouttmp_limitHi = 0.6386212110519409;
        double waterouttmp_limitLo = 0.5465096235275269;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo6_LimitsConfigurationEvent(version, aftercooltmp_warnHi, aftercooltmp_warnLo, aftercooltmp_limitHi, aftercooltmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fanspeed_warnHi, fanspeed_warnLo, fanspeed_limitHi, fanspeed_limitLo, oillevel_warnHi, oillevel_warnLo, oillevel_limitHi, oillevel_limitLo, oilseptmp_warnHi, oilseptmp_warnLo, oilseptmp_limitHi, oilseptmp_limitLo, phaseseptmp_warnHi, phaseseptmp_warnLo, phaseseptmp_limitHi, phaseseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, surgetanktmp_warnHi, surgetanktmp_warnLo, surgetanktmp_limitHi, surgetanktmp_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo6_LimitsConfigurationEvent));
        Refrig_Cryo6_LimitsConfigurationEvent item_ = (Refrig_Cryo6_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)aftercooltmp_warnHi, (double)item_.getAftercooltmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_warnLo, (double)item_.getAftercooltmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitHi, (double)item_.getAftercooltmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitLo, (double)item_.getAftercooltmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnHi, (double)item_.getFanspeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnLo, (double)item_.getFanspeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitHi, (double)item_.getFanspeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitLo, (double)item_.getFanspeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnHi, (double)item_.getOillevel_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnLo, (double)item_.getOillevel_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitHi, (double)item_.getOillevel_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitLo, (double)item_.getOillevel_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnHi, (double)item_.getOilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnLo, (double)item_.getOilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitHi, (double)item_.getOilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitLo, (double)item_.getOilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnHi, (double)item_.getPhaseseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnLo, (double)item_.getPhaseseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitHi, (double)item_.getPhaseseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitLo, (double)item_.getPhaseseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnHi, (double)item_.getSurgetanktmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnLo, (double)item_.getSurgetanktmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitHi, (double)item_.getSurgetanktmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitLo, (double)item_.getSurgetanktmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_PeriodicTasksConfigurationEvent() throws Exception {
        String version = "n";
        int schedulers_default_nTasks = 190;
        int schedulers_default_nThreads = 208;
        int schedulers_monitor_update_publish_scheduler_nTasks = 172;
        int schedulers_monitor_update_publish_scheduler_nThreads = 962;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_PeriodicTasksConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Refrig_PeriodicTasksConfigurationEvent));
        Refrig_PeriodicTasksConfigurationEvent item_ = (Refrig_PeriodicTasksConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveRefrig_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "u";
        long agentmonitorservice_taskPeriodMillis = 589L;
        long cold1_FanCtrl_timer_taskPeriodMillis = 568L;
        long cold2_FanCtrl_timer_taskPeriodMillis = 981L;
        long compressor_state_taskPeriodMillis = 282L;
        long cryo3_FanCtrl_timer_taskPeriodMillis = 51L;
        long cryo5_FanCtrl_timer_taskPeriodMillis = 991L;
        long heartbeat_taskPeriodMillis = 641L;
        long monitor_check_taskPeriodMillis = 191L;
        long monitor_publish_taskPeriodMillis = 559L;
        long monitor_update_taskPeriodMillis = 818L;
        long runtimeinfo_taskPeriodMillis = 975L;
        long update_time_taskPeriodMillis = 6L;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, cold1_FanCtrl_timer_taskPeriodMillis, cold2_FanCtrl_timer_taskPeriodMillis, compressor_state_taskPeriodMillis, cryo3_FanCtrl_timer_taskPeriodMillis, cryo5_FanCtrl_timer_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, runtimeinfo_taskPeriodMillis, update_time_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Refrig_PeriodicTasks_timersConfigurationEvent));
        Refrig_PeriodicTasks_timersConfigurationEvent item_ = (Refrig_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)cold1_FanCtrl_timer_taskPeriodMillis, (long)item_.getCold1_FanCtrl_timer_taskPeriodMillis());
        Assert.assertEquals((long)cold2_FanCtrl_timer_taskPeriodMillis, (long)item_.getCold2_FanCtrl_timer_taskPeriodMillis());
        Assert.assertEquals((long)compressor_state_taskPeriodMillis, (long)item_.getCompressor_state_taskPeriodMillis());
        Assert.assertEquals((long)cryo3_FanCtrl_timer_taskPeriodMillis, (long)item_.getCryo3_FanCtrl_timer_taskPeriodMillis());
        Assert.assertEquals((long)cryo5_FanCtrl_timer_taskPeriodMillis, (long)item_.getCryo5_FanCtrl_timer_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
        Assert.assertEquals((long)update_time_taskPeriodMillis, (long)item_.getUpdate_time_taskPeriodMillis());
    }

    @Test
    public void sendReceiveVacuum_AgentMonitorServiceConfigurationEvent() throws Exception {
        String version = "h";
        long taskPeriodMillis = 96L;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_AgentMonitorServiceConfigurationEvent(version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Vacuum_AgentMonitorServiceConfigurationEvent));
        Vacuum_AgentMonitorServiceConfigurationEvent item_ = (Vacuum_AgentMonitorServiceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveVacuum_CIP1CConfigurationEvent() throws Exception {
        String version = "o";
        double current = 0.587564f;
        double power = 0.17806684970855713;
        double voltage = 0.32693952322006226;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP1CConfigurationEvent(version, current, power, voltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP1CConfigurationEvent));
        Vacuum_CIP1CConfigurationEvent item_ = (Vacuum_CIP1CConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP1_IConfigurationEvent() throws Exception {
        String version = "k";
        double warnHi = 0.5460378527641296;
        double warnLo = 0.7081224322319031;
        double limitHi = 0.3934918f;
        double limitLo = 0.8275190591812134;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP1_IConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP1_IConfigurationEvent));
        Vacuum_CIP1_IConfigurationEvent item_ = (Vacuum_CIP1_IConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP1_VConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.3429415225982666;
        double warnLo = 0.4982871413230896;
        double limitHi = 0.5403322577476501;
        double limitLo = 0.02185011f;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP1_VConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP1_VConfigurationEvent));
        Vacuum_CIP1_VConfigurationEvent item_ = (Vacuum_CIP1_VConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP2CConfigurationEvent() throws Exception {
        String version = "t";
        double current = 0.6035947203636169;
        double power = 0.4841491f;
        double voltage = 0.67794269323349;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP2CConfigurationEvent(version, current, power, voltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP2CConfigurationEvent));
        Vacuum_CIP2CConfigurationEvent item_ = (Vacuum_CIP2CConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP2_IConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.9268537759780884;
        double warnLo = 0.1965157389640808;
        double limitHi = 0.7145811319351196;
        double limitLo = 0.01391238f;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP2_IConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP2_IConfigurationEvent));
        Vacuum_CIP2_IConfigurationEvent item_ = (Vacuum_CIP2_IConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP2_VConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.8390809297561646;
        double warnLo = 0.36190032958984375;
        double limitHi = 0.3067666292190552;
        double limitLo = 0.9353718161582947;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP2_VConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP2_VConfigurationEvent));
        Vacuum_CIP2_VConfigurationEvent item_ = (Vacuum_CIP2_VConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP3CConfigurationEvent() throws Exception {
        String version = "c";
        double current = 0.1850796341896057;
        double power = 0.059637486934661865;
        double voltage = 0.832711398601532;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP3CConfigurationEvent(version, current, power, voltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP3CConfigurationEvent));
        Vacuum_CIP3CConfigurationEvent item_ = (Vacuum_CIP3CConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP3_IConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.03953767f;
        double warnLo = 0.8931769132614136;
        double limitHi = 0.34542137384414673;
        double limitLo = 0.09803193807601929;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP3_IConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP3_IConfigurationEvent));
        Vacuum_CIP3_IConfigurationEvent item_ = (Vacuum_CIP3_IConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP3_VConfigurationEvent() throws Exception {
        String version = "m";
        double warnHi = 0.13042718172073364;
        double warnLo = 0.034231483936309814;
        double limitHi = 0.6972344517707825;
        double limitLo = 0.631290853023529;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP3_VConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP3_VConfigurationEvent));
        Vacuum_CIP3_VConfigurationEvent item_ = (Vacuum_CIP3_VConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP4CConfigurationEvent() throws Exception {
        String version = "";
        double current = 0.19414716958999634;
        double power = 0.7746595144271851;
        double voltage = 0.8212222456932068;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP4CConfigurationEvent(version, current, power, voltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP4CConfigurationEvent));
        Vacuum_CIP4CConfigurationEvent item_ = (Vacuum_CIP4CConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP4_IConfigurationEvent() throws Exception {
        String version = "b";
        double warnHi = 0.8186742067337036;
        double warnLo = 0.0631251335144043;
        double limitHi = 0.731778f;
        double limitLo = 0.24170565605163574;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP4_IConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP4_IConfigurationEvent));
        Vacuum_CIP4_IConfigurationEvent item_ = (Vacuum_CIP4_IConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP4_VConfigurationEvent() throws Exception {
        String version = "g";
        double warnHi = 0.8984127044677734;
        double warnLo = 0.6960815787315369;
        double limitHi = 0.5096038579940796;
        double limitLo = 0.12239694595336914;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP4_VConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP4_VConfigurationEvent));
        Vacuum_CIP4_VConfigurationEvent item_ = (Vacuum_CIP4_VConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP5CConfigurationEvent() throws Exception {
        String version = "j";
        double current = 0.015918374061584473;
        double power = 0.668856680393219;
        double voltage = 0.10010641813278198;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP5CConfigurationEvent(version, current, power, voltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP5CConfigurationEvent));
        Vacuum_CIP5CConfigurationEvent item_ = (Vacuum_CIP5CConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP5_IConfigurationEvent() throws Exception {
        String version = "x";
        double warnHi = 0.344391405582428;
        double warnLo = 0.32303881645202637;
        double limitHi = 0.3068814277648926;
        double limitLo = 0.7918167114257812;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP5_IConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP5_IConfigurationEvent));
        Vacuum_CIP5_IConfigurationEvent item_ = (Vacuum_CIP5_IConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP5_VConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.3430965542793274;
        double warnLo = 0.9203203916549683;
        double limitHi = 0.6411802172660828;
        double limitLo = 0.9889153242111206;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP5_VConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP5_VConfigurationEvent));
        Vacuum_CIP5_VConfigurationEvent item_ = (Vacuum_CIP5_VConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP6CConfigurationEvent() throws Exception {
        String version = "";
        double current = 0.3076918125152588;
        double power = 0.4680584f;
        double voltage = 0.26654428243637085;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP6CConfigurationEvent(version, current, power, voltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP6CConfigurationEvent));
        Vacuum_CIP6CConfigurationEvent item_ = (Vacuum_CIP6CConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP6_IConfigurationEvent() throws Exception {
        String version = "o";
        double warnHi = 0.19246304035186768;
        double warnLo = 0.6237963438034058;
        double limitHi = 0.3165757f;
        double limitLo = 0.7989621162414551;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP6_IConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP6_IConfigurationEvent));
        Vacuum_CIP6_IConfigurationEvent item_ = (Vacuum_CIP6_IConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP6_VConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.12457782030105591;
        double warnLo = 0.9272174835205078;
        double limitHi = 0.8417255282402039;
        double limitLo = 0.12413114309310913;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP6_VConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP6_VConfigurationEvent));
        Vacuum_CIP6_VConfigurationEvent item_ = (Vacuum_CIP6_VConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CryoVacConfigurationEvent() throws Exception {
        String version = "r";
        double warnHi = 0.16013747453689575;
        double warnLo = 0.7154470682144165;
        double limitHi = 0.24681884050369263;
        double limitLo = 3.97861E-4f;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CryoVacConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoVacConfigurationEvent));
        Vacuum_CryoVacConfigurationEvent item_ = (Vacuum_CryoVacConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CryoVacGaugeConfigurationEvent() throws Exception {
        String version = "";
        int busAddr = 41;
        String devcId = "r";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CryoVacGaugeConfigurationEvent(version, busAddr, devcId));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoVacGaugeConfigurationEvent));
        Vacuum_CryoVacGaugeConfigurationEvent item_ = (Vacuum_CryoVacGaugeConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)busAddr, (long)item_.getBusAddr());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
    }

    @Test
    public void sendReceiveVacuum_ForelineVacConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.71945720911026;
        double warnLo = 0.1985260248184204;
        double limitHi = 0.16791987419128418;
        double limitLo = 0.03862518072128296;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_ForelineVacConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_ForelineVacConfigurationEvent));
        Vacuum_ForelineVacConfigurationEvent item_ = (Vacuum_ForelineVacConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_ForelineVacGaugeConfigurationEvent() throws Exception {
        String version = "";
        int busAddr = 649;
        String devcId = "a";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_ForelineVacGaugeConfigurationEvent(version, busAddr, devcId));
        Assert.assertTrue((boolean)(item instanceof Vacuum_ForelineVacGaugeConfigurationEvent));
        Vacuum_ForelineVacGaugeConfigurationEvent item_ = (Vacuum_ForelineVacGaugeConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)busAddr, (long)item_.getBusAddr());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
    }

    @Test
    public void sendReceiveVacuum_HeartbeatConfigurationEvent() throws Exception {
        String version = "";
        long taskPeriodMillis = 233L;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_HeartbeatConfigurationEvent(version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Vacuum_HeartbeatConfigurationEvent));
        Vacuum_HeartbeatConfigurationEvent item_ = (Vacuum_HeartbeatConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveVacuum_Hex1VacConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.9741195440292358;
        double warnLo = 0.7157511115074158;
        double limitHi = 0.5872114896774292;
        double limitLo = 0.12102806568145752;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Hex1VacConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Hex1VacConfigurationEvent));
        Vacuum_Hex1VacConfigurationEvent item_ = (Vacuum_Hex1VacConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Hex1VacGaugeConfigurationEvent() throws Exception {
        String version = "m";
        int busAddr = 672;
        String devcId = "g";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Hex1VacGaugeConfigurationEvent(version, busAddr, devcId));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Hex1VacGaugeConfigurationEvent));
        Vacuum_Hex1VacGaugeConfigurationEvent item_ = (Vacuum_Hex1VacGaugeConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)busAddr, (long)item_.getBusAddr());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
    }

    @Test
    public void sendReceiveVacuum_Hex2VacConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.16633951663970947;
        double warnLo = 0.19426536560058594;
        double limitHi = 0.071639f;
        double limitLo = 0.1569261f;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Hex2VacConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Hex2VacConfigurationEvent));
        Vacuum_Hex2VacConfigurationEvent item_ = (Vacuum_Hex2VacConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Hex2VacGaugeConfigurationEvent() throws Exception {
        String version = "";
        int busAddr = 489;
        String devcId = "m";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Hex2VacGaugeConfigurationEvent(version, busAddr, devcId));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Hex2VacGaugeConfigurationEvent));
        Vacuum_Hex2VacGaugeConfigurationEvent item_ = (Vacuum_Hex2VacGaugeConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)busAddr, (long)item_.getBusAddr());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
    }

    @Test
    public void sendReceiveVacuum_IonPumpsConfigurationEvent() throws Exception {
        String version = "";
        String ipAddr = "y";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_IonPumpsConfigurationEvent(version, ipAddr));
        Assert.assertTrue((boolean)(item instanceof Vacuum_IonPumpsConfigurationEvent));
        Vacuum_IonPumpsConfigurationEvent item_ = (Vacuum_IonPumpsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)ipAddr, (Object)item_.getIpAddr());
    }

    @Test
    public void sendReceiveVacuum_Monitor_checkConfigurationEvent() throws Exception {
        String version = "s";
        long taskPeriodMillis = 718L;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Monitor_checkConfigurationEvent(version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Monitor_checkConfigurationEvent));
        Vacuum_Monitor_checkConfigurationEvent item_ = (Vacuum_Monitor_checkConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveVacuum_Monitor_publishConfigurationEvent() throws Exception {
        String version = "";
        long taskPeriodMillis = 215L;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Monitor_publishConfigurationEvent(version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Monitor_publishConfigurationEvent));
        Vacuum_Monitor_publishConfigurationEvent item_ = (Vacuum_Monitor_publishConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveVacuum_Monitor_updateConfigurationEvent() throws Exception {
        String version = "k";
        long taskPeriodMillis = 145L;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Monitor_updateConfigurationEvent(version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Monitor_updateConfigurationEvent));
        Vacuum_Monitor_updateConfigurationEvent item_ = (Vacuum_Monitor_updateConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveVacuum_RuntimeInfoConfigurationEvent() throws Exception {
        String version = "";
        long taskPeriodMillis = 174L;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_RuntimeInfoConfigurationEvent(version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Vacuum_RuntimeInfoConfigurationEvent));
        Vacuum_RuntimeInfoConfigurationEvent item_ = (Vacuum_RuntimeInfoConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveVacuum_SchedulersConfigurationEvent() throws Exception {
        String version = "";
        int default_nTasks = 206;
        int default_nThreads = 340;
        int monitor_update_publish_scheduler_nTasks = 716;
        int monitor_update_publish_scheduler_nThreads = 810;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_SchedulersConfigurationEvent(version, default_nTasks, default_nThreads, monitor_update_publish_scheduler_nTasks, monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Vacuum_SchedulersConfigurationEvent));
        Vacuum_SchedulersConfigurationEvent item_ = (Vacuum_SchedulersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)default_nTasks, (long)item_.getDefault_nTasks());
        Assert.assertEquals((long)default_nThreads, (long)item_.getDefault_nThreads());
        Assert.assertEquals((long)monitor_update_publish_scheduler_nTasks, (long)item_.getMonitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)monitor_update_publish_scheduler_nThreads, (long)item_.getMonitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveVacuum_TurboCurrentConfigurationEvent() throws Exception {
        String version = "c";
        double warnHi = 0.9934367537498474;
        double warnLo = 0.4332842230796814;
        double limitHi = 0.767250120639801;
        double limitLo = 0.4621874f;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_TurboCurrentConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboCurrentConfigurationEvent));
        Vacuum_TurboCurrentConfigurationEvent item_ = (Vacuum_TurboCurrentConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboPowerConfigurationEvent() throws Exception {
        String version = "n";
        double warnHi = 0.03296506404876709;
        double warnLo = 0.11091488599777222;
        double limitHi = 0.9360492825508118;
        double limitLo = 0.2538573145866394;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_TurboPowerConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboPowerConfigurationEvent));
        Vacuum_TurboPowerConfigurationEvent item_ = (Vacuum_TurboPowerConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboPumpConfigurationEvent() throws Exception {
        String version = "";
        boolean activeStopMode = false;
        String devcId = "z";
        boolean interlockType = true;
        boolean lowSpeedMode = false;
        boolean model304 = false;
        boolean softStartMode = false;
        boolean ventValveByCmnd = false;
        boolean waterCooling = false;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_TurboPumpConfigurationEvent(version, activeStopMode, devcId, interlockType, lowSpeedMode, model304, softStartMode, ventValveByCmnd, waterCooling));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboPumpConfigurationEvent));
        Vacuum_TurboPumpConfigurationEvent item_ = (Vacuum_TurboPumpConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)activeStopMode, (Object)item_.isActiveStopMode());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertEquals((Object)interlockType, (Object)item_.isInterlockType());
        Assert.assertEquals((Object)lowSpeedMode, (Object)item_.isLowSpeedMode());
        Assert.assertEquals((Object)model304, (Object)item_.isModel304());
        Assert.assertEquals((Object)softStartMode, (Object)item_.isSoftStartMode());
        Assert.assertEquals((Object)ventValveByCmnd, (Object)item_.isVentValveByCmnd());
        Assert.assertEquals((Object)waterCooling, (Object)item_.isWaterCooling());
    }

    @Test
    public void sendReceiveVacuum_TurboPumpTempConfigurationEvent() throws Exception {
        String version = "l";
        double warnHi = 0.43833786249160767;
        double warnLo = 0.3118906021118164;
        double limitHi = 0.6383227705955505;
        double limitLo = 0.7984318733215332;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_TurboPumpTempConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboPumpTempConfigurationEvent));
        Vacuum_TurboPumpTempConfigurationEvent item_ = (Vacuum_TurboPumpTempConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboSpeedConfigurationEvent() throws Exception {
        String version = "g";
        double warnHi = 0.4384617209434509;
        double warnLo = 0.3820006251335144;
        double limitHi = 0.536798894405365;
        double limitLo = 0.11588871479034424;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_TurboSpeedConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboSpeedConfigurationEvent));
        Vacuum_TurboSpeedConfigurationEvent item_ = (Vacuum_TurboSpeedConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboVacConfigurationEvent() throws Exception {
        String version = "d";
        double warnHi = 0.08386844396591187;
        double warnLo = 0.6564322710037231;
        double limitHi = 0.855823f;
        double limitLo = 0.26368457078933716;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_TurboVacConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboVacConfigurationEvent));
        Vacuum_TurboVacConfigurationEvent item_ = (Vacuum_TurboVacConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboVacGaugeConfigurationEvent() throws Exception {
        String version = "s";
        int busAddr = 115;
        String devcId = "";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_TurboVacGaugeConfigurationEvent(version, busAddr, devcId));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboVacGaugeConfigurationEvent));
        Vacuum_TurboVacGaugeConfigurationEvent item_ = (Vacuum_TurboVacGaugeConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)busAddr, (long)item_.getBusAddr());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
    }

    @Test
    public void sendReceiveVacuum_TurboVoltageConfigurationEvent() throws Exception {
        String version = "q";
        double warnHi = 0.0703339f;
        double warnLo = 0.9929743409156799;
        double limitHi = 0.0360414981842041;
        double limitLo = 0.9235764741897583;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_TurboVoltageConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboVoltageConfigurationEvent));
        Vacuum_TurboVoltageConfigurationEvent item_ = (Vacuum_TurboVoltageConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_VacPlutoConfigurationEvent() throws Exception {
        String version = "";
        String node = "g";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_VacPlutoConfigurationEvent(version, node));
        Assert.assertTrue((boolean)(item instanceof Vacuum_VacPlutoConfigurationEvent));
        Vacuum_VacPlutoConfigurationEvent item_ = (Vacuum_VacPlutoConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)node, (Object)item_.getNode());
    }

    @Test
    public void sendReceiveVacuum_Vacuum_stateConfigurationEvent() throws Exception {
        String version = "";
        long taskPeriodMillis = 74L;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Vacuum_stateConfigurationEvent(version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Vacuum_stateConfigurationEvent));
        Vacuum_Vacuum_stateConfigurationEvent item_ = (Vacuum_Vacuum_stateConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveDaq_monitor_PeriodicTasksConfigurationEvent() throws Exception {
        String version = "h";
        int schedulers_default_nTasks = 610;
        int schedulers_default_nThreads = 827;
        int schedulers_monitor_update_publish_scheduler_nTasks = 281;
        int schedulers_monitor_update_publish_scheduler_nThreads = 654;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_PeriodicTasksConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_PeriodicTasksConfigurationEvent));
        Daq_monitor_PeriodicTasksConfigurationEvent item_ = (Daq_monitor_PeriodicTasksConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveDaq_monitor_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "";
        long agentmonitorservice_taskPeriodMillis = 294L;
        long heartbeat_taskPeriodMillis = 922L;
        long monitor_check_taskPeriodMillis = 964L;
        long monitor_publish_taskPeriodMillis = 66L;
        long monitor_update_taskPeriodMillis = 537L;
        long publishstats_taskPeriodMillis = 278L;
        long purgedaq_taskPeriodMillis = 631L;
        long runtimeinfo_taskPeriodMillis = 514L;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, publishstats_taskPeriodMillis, purgedaq_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_PeriodicTasks_timersConfigurationEvent));
        Daq_monitor_PeriodicTasks_timersConfigurationEvent item_ = (Daq_monitor_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)publishstats_taskPeriodMillis, (long)item_.getPublishstats_taskPeriodMillis());
        Assert.assertEquals((long)purgedaq_taskPeriodMillis, (long)item_.getPurgedaq_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveDaq_monitor_Stats_StatisticsConfigurationEvent() throws Exception {
        String version = "a";
        int minDiffAlertWarning = 32;
        int minDiffLogWarning = 616;
        String sumDriverChecks = "";
        String sumDriverStats = "";
        String sumFirmwareChecks = "f";
        String sumFirmwareStats = "k";
        String sumRdsChecks = "";
        String sumRdsStats = "";
        String sumRmsChecks = "s";
        String sumRmsStats = "";
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Stats_StatisticsConfigurationEvent(version, minDiffAlertWarning, minDiffLogWarning, sumDriverChecks, sumDriverStats, sumFirmwareChecks, sumFirmwareStats, sumRdsChecks, sumRdsStats, sumRmsChecks, sumRmsStats));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Stats_StatisticsConfigurationEvent));
        Daq_monitor_Stats_StatisticsConfigurationEvent item_ = (Daq_monitor_Stats_StatisticsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)minDiffAlertWarning, (long)item_.getMinDiffAlertWarning());
        Assert.assertEquals((long)minDiffLogWarning, (long)item_.getMinDiffLogWarning());
        Assert.assertEquals((Object)sumDriverChecks, (Object)item_.getSumDriverChecks());
        Assert.assertEquals((Object)sumDriverStats, (Object)item_.getSumDriverStats());
        Assert.assertEquals((Object)sumFirmwareChecks, (Object)item_.getSumFirmwareChecks());
        Assert.assertEquals((Object)sumFirmwareStats, (Object)item_.getSumFirmwareStats());
        Assert.assertEquals((Object)sumRdsChecks, (Object)item_.getSumRdsChecks());
        Assert.assertEquals((Object)sumRdsStats, (Object)item_.getSumRdsStats());
        Assert.assertEquals((Object)sumRmsChecks, (Object)item_.getSumRmsChecks());
        Assert.assertEquals((Object)sumRmsStats, (Object)item_.getSumRmsStats());
    }

    @Test
    public void sendReceiveDaq_monitor_Stats_buildConfigurationEvent() throws Exception {
        String version = "l";
        boolean enablePeriodicPublication = false;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Stats_buildConfigurationEvent(version, enablePeriodicPublication));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Stats_buildConfigurationEvent));
        Daq_monitor_Stats_buildConfigurationEvent item_ = (Daq_monitor_Stats_buildConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)enablePeriodicPublication, (Object)item_.isEnablePeriodicPublication());
    }

    @Test
    public void sendReceiveDaq_monitor_StoreConfigurationEvent() throws Exception {
        String version = "";
        String daqPartition = "";
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_StoreConfigurationEvent(version, daqPartition));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreConfigurationEvent));
        Daq_monitor_StoreConfigurationEvent item_ = (Daq_monitor_StoreConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)daqPartition, (Object)item_.getDaqPartition());
    }

    @Test
    public void sendReceiveDaq_monitor_Store_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double capacity_warnHi = 0.775881290435791;
        double capacity_warnLo = 0.7670015096664429;
        double capacity_limitHi = 0.8115732073783875;
        double capacity_limitLo = 0.9582842588424683;
        double freefraction_warnHi = 0.728636f;
        double freefraction_warnLo = 0.19857323169708252;
        double freefraction_limitHi = 0.4796156883239746;
        double freefraction_limitLo = 0.25690704584121704;
        double freespace_warnHi = 0.5727071166038513;
        double freespace_warnLo = 0.8387136459350586;
        double freespace_limitHi = 0.10003447532653809;
        double freespace_limitLo = 0.02270621f;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Store_LimitsConfigurationEvent(version, capacity_warnHi, capacity_warnLo, capacity_limitHi, capacity_limitLo, freefraction_warnHi, freefraction_warnLo, freefraction_limitHi, freefraction_limitLo, freespace_warnHi, freespace_warnLo, freespace_limitHi, freespace_limitLo));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Store_LimitsConfigurationEvent));
        Daq_monitor_Store_LimitsConfigurationEvent item_ = (Daq_monitor_Store_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)capacity_warnHi, (double)item_.getCapacity_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)capacity_warnLo, (double)item_.getCapacity_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)capacity_limitHi, (double)item_.getCapacity_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)capacity_limitLo, (double)item_.getCapacity_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)freefraction_warnHi, (double)item_.getFreefraction_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)freefraction_warnLo, (double)item_.getFreefraction_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)freefraction_limitHi, (double)item_.getFreefraction_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)freefraction_limitLo, (double)item_.getFreefraction_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)freespace_warnHi, (double)item_.getFreespace_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)freespace_warnLo, (double)item_.getFreespace_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)freespace_limitHi, (double)item_.getFreespace_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)freespace_limitLo, (double)item_.getFreespace_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_Store_StoreConfigurationEvent() throws Exception {
        String version = "";
        String daqFolder = "";
        boolean enableAutoPurge = false;
        double purgeTarget = 0.5878645181655884;
        double purgeThreshold = 0.3209095597267151;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Store_StoreConfigurationEvent(version, daqFolder, enableAutoPurge, purgeTarget, purgeThreshold));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Store_StoreConfigurationEvent));
        Daq_monitor_Store_StoreConfigurationEvent item_ = (Daq_monitor_Store_StoreConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)enableAutoPurge, (Object)item_.isEnableAutoPurge());
        Assert.assertEquals((double)purgeTarget, (double)item_.getPurgeTarget(), (double)1.0E-6f);
        Assert.assertEquals((double)purgeThreshold, (double)item_.getPurgeThreshold(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Ccd_HardwareIdConfigurationEvent() throws Exception {
        String version = "";
        String location = "";
        String manSerNum = "";
        String name = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Ccd_HardwareIdConfigurationEvent(version, location, manSerNum, name));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Ccd_HardwareIdConfigurationEvent));
        Focal_plane_Ccd_HardwareIdConfigurationEvent item_ = (Focal_plane_Ccd_HardwareIdConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)manSerNum, (Object)item_.getManSerNum());
        Assert.assertEquals((Object)name, (Object)item_.getName());
    }

    @Test
    public void sendReceiveFocal_plane_Ccd_LimitsConfigurationEvent() throws Exception {
        String version = "l";
        double[] gdv_warnHi = TestHelper.generateDoubleArray((int)201, (int)-394472627);
        double[] gdv_warnLo = TestHelper.generateDoubleArray((int)201, (int)267310270);
        double[] gdv_limitHi = TestHelper.generateDoubleArray((int)201, (int)-1778974453);
        double[] gdv_limitLo = TestHelper.generateDoubleArray((int)201, (int)-1754325764);
        String location = "";
        double[] odi_warnHi = TestHelper.generateDoubleArray((int)201, (int)-1811584348);
        double[] odi_warnLo = TestHelper.generateDoubleArray((int)201, (int)-547941667);
        double[] odi_limitHi = TestHelper.generateDoubleArray((int)201, (int)418796375);
        double[] odi_limitLo = TestHelper.generateDoubleArray((int)201, (int)-1301289640);
        double[] odv_warnHi = TestHelper.generateDoubleArray((int)201, (int)-1865589499);
        double[] odv_warnLo = TestHelper.generateDoubleArray((int)201, (int)1006939715);
        double[] odv_limitHi = TestHelper.generateDoubleArray((int)201, (int)1849382406);
        double[] odv_limitLo = TestHelper.generateDoubleArray((int)201, (int)-1186280725);
        double[] ogv_warnHi = TestHelper.generateDoubleArray((int)201, (int)982858083);
        double[] ogv_warnLo = TestHelper.generateDoubleArray((int)201, (int)579908407);
        double[] ogv_limitHi = TestHelper.generateDoubleArray((int)201, (int)-100216697);
        double[] ogv_limitLo = TestHelper.generateDoubleArray((int)201, (int)249450071);
        double[] rdv_warnHi = TestHelper.generateDoubleArray((int)201, (int)-196883534);
        double[] rdv_warnLo = TestHelper.generateDoubleArray((int)201, (int)-814583549);
        double[] rdv_limitHi = TestHelper.generateDoubleArray((int)201, (int)-2061800220);
        double[] rdv_limitLo = TestHelper.generateDoubleArray((int)201, (int)1953905626);
        double[] temp_warnHi = TestHelper.generateDoubleArray((int)201, (int)1628613914);
        double[] temp_warnLo = TestHelper.generateDoubleArray((int)201, (int)40535979);
        double[] temp_limitHi = TestHelper.generateDoubleArray((int)201, (int)651037204);
        double[] temp_limitLo = TestHelper.generateDoubleArray((int)201, (int)575665825);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Ccd_LimitsConfigurationEvent(version, gdv_warnHi, gdv_warnLo, gdv_limitHi, gdv_limitLo, location, odi_warnHi, odi_warnLo, odi_limitHi, odi_limitLo, odv_warnHi, odv_warnLo, odv_limitHi, odv_limitLo, ogv_warnHi, ogv_warnLo, ogv_limitHi, ogv_limitLo, rdv_warnHi, rdv_warnLo, rdv_limitHi, rdv_limitLo, temp_warnHi, temp_warnLo, temp_limitHi, temp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Ccd_LimitsConfigurationEvent));
        Focal_plane_Ccd_LimitsConfigurationEvent item_ = (Focal_plane_Ccd_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])gdv_warnHi, (double[])item_.getGdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])gdv_warnLo, (double[])item_.getGdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])gdv_limitHi, (double[])item_.getGdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])gdv_limitLo, (double[])item_.getGdv_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])odi_warnHi, (double[])item_.getOdi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_warnLo, (double[])item_.getOdi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_limitHi, (double[])item_.getOdi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_limitLo, (double[])item_.getOdi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnHi, (double[])item_.getOdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnLo, (double[])item_.getOdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitHi, (double[])item_.getOdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitLo, (double[])item_.getOdv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_warnHi, (double[])item_.getOgv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_warnLo, (double[])item_.getOgv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_limitHi, (double[])item_.getOgv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_limitLo, (double[])item_.getOgv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_warnHi, (double[])item_.getRdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_warnLo, (double[])item_.getRdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_limitHi, (double[])item_.getRdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_limitLo, (double[])item_.getRdv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_warnHi, (double[])item_.getTemp_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_warnLo, (double[])item_.getTemp_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_limitHi, (double[])item_.getTemp_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_limitLo, (double[])item_.getTemp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Ccd_RaftsConfigurationEvent() throws Exception {
        String version = "";
        String location = "s";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Ccd_RaftsConfigurationEvent(version, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Ccd_RaftsConfigurationEvent));
        Focal_plane_Ccd_RaftsConfigurationEvent item_ = (Focal_plane_Ccd_RaftsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFocal_plane_ImageDatabaseServiceConfigurationEvent() throws Exception {
        String version = "e";
        String dbURL = "f";
        boolean enabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_ImageDatabaseServiceConfigurationEvent(version, dbURL, enabled));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_ImageDatabaseServiceConfigurationEvent));
        Focal_plane_ImageDatabaseServiceConfigurationEvent item_ = (Focal_plane_ImageDatabaseServiceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)dbURL, (Object)item_.getDbURL());
        Assert.assertEquals((Object)enabled, (Object)item_.isEnabled());
    }

    @Test
    public void sendReceiveFocal_plane_ImageNameServiceConfigurationEvent() throws Exception {
        String version = "k";
        String controller = "d";
        String dbURL = "v";
        String offset = "";
        String source = "";
        String timeZoneId = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_ImageNameServiceConfigurationEvent(version, controller, dbURL, offset, source, timeZoneId));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_ImageNameServiceConfigurationEvent));
        Focal_plane_ImageNameServiceConfigurationEvent item_ = (Focal_plane_ImageNameServiceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)controller, (Object)item_.getController());
        Assert.assertEquals((Object)dbURL, (Object)item_.getDbURL());
        Assert.assertEquals((Object)offset, (Object)item_.getOffset());
        Assert.assertEquals((Object)source, (Object)item_.getSource());
        Assert.assertEquals((Object)timeZoneId, (Object)item_.getTimeZoneId());
    }

    @Test
    public void sendReceiveFocal_plane_InstrumentConfig_InstrumentConfigurationEvent() throws Exception {
        String version = "";
        String instrument = "";
        String telescope = "";
        String testStand = "x";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_InstrumentConfig_InstrumentConfigurationEvent(version, instrument, telescope, testStand));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_InstrumentConfig_InstrumentConfigurationEvent));
        Focal_plane_InstrumentConfig_InstrumentConfigurationEvent item_ = (Focal_plane_InstrumentConfig_InstrumentConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)instrument, (Object)item_.getInstrument());
        Assert.assertEquals((Object)telescope, (Object)item_.getTelescope());
        Assert.assertEquals((Object)testStand, (Object)item_.getTestStand());
    }

    @Test
    public void sendReceiveFocal_plane_PeriodicTasksConfigurationEvent() throws Exception {
        String version = "i";
        int schedulers_default_nTasks = 444;
        int schedulers_default_nThreads = 478;
        int schedulers_monitor_check_scheduler_nTasks = 830;
        int schedulers_monitor_check_scheduler_nThreads = 85;
        int schedulers_monitor_update_publish_scheduler_nTasks = 730;
        int schedulers_monitor_update_publish_scheduler_nThreads = 802;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_PeriodicTasksConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_check_scheduler_nTasks, schedulers_monitor_check_scheduler_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_PeriodicTasksConfigurationEvent));
        Focal_plane_PeriodicTasksConfigurationEvent item_ = (Focal_plane_PeriodicTasksConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nTasks, (long)item_.getSchedulers_monitor_check_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nThreads, (long)item_.getSchedulers_monitor_check_scheduler_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveFocal_plane_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "p";
        long agentmonitorservice_taskPeriodMillis = 369L;
        long heartbeat_taskPeriodMillis = 186L;
        long monitor_publish_taskPeriodMillis = 652L;
        long monitor_update_taskPeriodMillis = 902L;
        long runtimeinfo_taskPeriodMillis = 752L;
        long tempcontrol_R00_taskPeriodMillis = 388L;
        long tempcontrol_R01_taskPeriodMillis = 107L;
        long tempcontrol_R02_taskPeriodMillis = 833L;
        long tempcontrol_R03_taskPeriodMillis = 862L;
        long tempcontrol_R04_taskPeriodMillis = 796L;
        long tempcontrol_R10_taskPeriodMillis = 111L;
        long tempcontrol_R11_taskPeriodMillis = 798L;
        long tempcontrol_R12_taskPeriodMillis = 677L;
        long tempcontrol_R13_taskPeriodMillis = 700L;
        long tempcontrol_R14_taskPeriodMillis = 493L;
        long tempcontrol_R20_taskPeriodMillis = 919L;
        long tempcontrol_R21_taskPeriodMillis = 202L;
        long tempcontrol_R22_taskPeriodMillis = 856L;
        long tempcontrol_R23_taskPeriodMillis = 675L;
        long tempcontrol_R24_taskPeriodMillis = 208L;
        long tempcontrol_R30_taskPeriodMillis = 561L;
        long tempcontrol_R31_taskPeriodMillis = 512L;
        long tempcontrol_R32_taskPeriodMillis = 258L;
        long tempcontrol_R33_taskPeriodMillis = 461L;
        long tempcontrol_R34_taskPeriodMillis = 934L;
        long tempcontrol_R40_taskPeriodMillis = 443L;
        long tempcontrol_R41_taskPeriodMillis = 793L;
        long tempcontrol_R42_taskPeriodMillis = 884L;
        long tempcontrol_R43_taskPeriodMillis = 870L;
        long tempcontrol_R44_taskPeriodMillis = 236L;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, runtimeinfo_taskPeriodMillis, tempcontrol_R00_taskPeriodMillis, tempcontrol_R01_taskPeriodMillis, tempcontrol_R02_taskPeriodMillis, tempcontrol_R03_taskPeriodMillis, tempcontrol_R04_taskPeriodMillis, tempcontrol_R10_taskPeriodMillis, tempcontrol_R11_taskPeriodMillis, tempcontrol_R12_taskPeriodMillis, tempcontrol_R13_taskPeriodMillis, tempcontrol_R14_taskPeriodMillis, tempcontrol_R20_taskPeriodMillis, tempcontrol_R21_taskPeriodMillis, tempcontrol_R22_taskPeriodMillis, tempcontrol_R23_taskPeriodMillis, tempcontrol_R24_taskPeriodMillis, tempcontrol_R30_taskPeriodMillis, tempcontrol_R31_taskPeriodMillis, tempcontrol_R32_taskPeriodMillis, tempcontrol_R33_taskPeriodMillis, tempcontrol_R34_taskPeriodMillis, tempcontrol_R40_taskPeriodMillis, tempcontrol_R41_taskPeriodMillis, tempcontrol_R42_taskPeriodMillis, tempcontrol_R43_taskPeriodMillis, tempcontrol_R44_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_PeriodicTasks_timersConfigurationEvent));
        Focal_plane_PeriodicTasks_timersConfigurationEvent item_ = (Focal_plane_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R00_taskPeriodMillis, (long)item_.getTempcontrol_R00_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R01_taskPeriodMillis, (long)item_.getTempcontrol_R01_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R02_taskPeriodMillis, (long)item_.getTempcontrol_R02_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R03_taskPeriodMillis, (long)item_.getTempcontrol_R03_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R04_taskPeriodMillis, (long)item_.getTempcontrol_R04_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R10_taskPeriodMillis, (long)item_.getTempcontrol_R10_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R11_taskPeriodMillis, (long)item_.getTempcontrol_R11_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R12_taskPeriodMillis, (long)item_.getTempcontrol_R12_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R13_taskPeriodMillis, (long)item_.getTempcontrol_R13_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R14_taskPeriodMillis, (long)item_.getTempcontrol_R14_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R20_taskPeriodMillis, (long)item_.getTempcontrol_R20_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R21_taskPeriodMillis, (long)item_.getTempcontrol_R21_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R22_taskPeriodMillis, (long)item_.getTempcontrol_R22_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R23_taskPeriodMillis, (long)item_.getTempcontrol_R23_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R24_taskPeriodMillis, (long)item_.getTempcontrol_R24_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R30_taskPeriodMillis, (long)item_.getTempcontrol_R30_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R31_taskPeriodMillis, (long)item_.getTempcontrol_R31_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R32_taskPeriodMillis, (long)item_.getTempcontrol_R32_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R33_taskPeriodMillis, (long)item_.getTempcontrol_R33_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R34_taskPeriodMillis, (long)item_.getTempcontrol_R34_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R40_taskPeriodMillis, (long)item_.getTempcontrol_R40_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R41_taskPeriodMillis, (long)item_.getTempcontrol_R41_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R42_taskPeriodMillis, (long)item_.getTempcontrol_R42_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R43_taskPeriodMillis, (long)item_.getTempcontrol_R43_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R44_taskPeriodMillis, (long)item_.getTempcontrol_R44_taskPeriodMillis());
    }

    @Test
    public void sendReceiveFocal_plane_Raft_HardwareIdConfigurationEvent() throws Exception {
        String version = "";
        String location = "";
        String name = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Raft_HardwareIdConfigurationEvent(version, location, name));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Raft_HardwareIdConfigurationEvent));
        Focal_plane_Raft_HardwareIdConfigurationEvent item_ = (Focal_plane_Raft_HardwareIdConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)name, (Object)item_.getName());
    }

    @Test
    public void sendReceiveFocal_plane_Raft_RaftTempControlConfigurationEvent() throws Exception {
        String version = "";
        String location = "";
        double[] tempcontrol_basePower = TestHelper.generateDoubleArray((int)25, (int)-798215887);
        double[] tempcontrol_coefD = TestHelper.generateDoubleArray((int)25, (int)291052111);
        double[] tempcontrol_coefI = TestHelper.generateDoubleArray((int)25, (int)1322929016);
        double[] tempcontrol_coefP = TestHelper.generateDoubleArray((int)25, (int)-981978741);
        double[] tempcontrol_maxInput = TestHelper.generateDoubleArray((int)25, (int)1330223634);
        double[] tempcontrol_maxOutput = TestHelper.generateDoubleArray((int)25, (int)470571601);
        double[] tempcontrol_minInput = TestHelper.generateDoubleArray((int)25, (int)-841346615);
        double[] tempcontrol_minOutput = TestHelper.generateDoubleArray((int)25, (int)-1885213323);
        String tempcontrol_rebs = "";
        double[] tempcontrol_setTemp = TestHelper.generateDoubleArray((int)25, (int)-1992521164);
        double[] tempcontrol_smoothTime = TestHelper.generateDoubleArray((int)25, (int)1147661035);
        String tempcontrol_tempChans = "k";
        double[] tempcontrol_timeConst = TestHelper.generateDoubleArray((int)25, (int)335559173);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Raft_RaftTempControlConfigurationEvent(version, location, tempcontrol_basePower, tempcontrol_coefD, tempcontrol_coefI, tempcontrol_coefP, tempcontrol_maxInput, tempcontrol_maxOutput, tempcontrol_minInput, tempcontrol_minOutput, tempcontrol_rebs, tempcontrol_setTemp, tempcontrol_smoothTime, tempcontrol_tempChans, tempcontrol_timeConst));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Raft_RaftTempControlConfigurationEvent));
        Focal_plane_Raft_RaftTempControlConfigurationEvent item_ = (Focal_plane_Raft_RaftTempControlConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])tempcontrol_basePower, (double[])item_.getTempcontrol_basePower(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_coefD, (double[])item_.getTempcontrol_coefD(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_coefI, (double[])item_.getTempcontrol_coefI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_coefP, (double[])item_.getTempcontrol_coefP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_maxInput, (double[])item_.getTempcontrol_maxInput(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_maxOutput, (double[])item_.getTempcontrol_maxOutput(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_minInput, (double[])item_.getTempcontrol_minInput(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_minOutput, (double[])item_.getTempcontrol_minOutput(), (double)1.0E-6f);
        Assert.assertEquals((Object)tempcontrol_rebs, (Object)item_.getTempcontrol_rebs());
        Assert.assertArrayEquals((double[])tempcontrol_setTemp, (double[])item_.getTempcontrol_setTemp(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_smoothTime, (double[])item_.getTempcontrol_smoothTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)tempcontrol_tempChans, (Object)item_.getTempcontrol_tempChans());
        Assert.assertArrayEquals((double[])tempcontrol_timeConst, (double[])item_.getTempcontrol_timeConst(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Raft_RaftTempControlStatusConfigurationEvent() throws Exception {
        String version = "s";
        String location = "";
        boolean[] tempcontrol_active = new boolean[]{false, true, false, true, true, true, false, true, false, false, true, false, true, true, false, false, false, true, true, false, false, false, true, true, true};
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Raft_RaftTempControlStatusConfigurationEvent(version, location, tempcontrol_active));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Raft_RaftTempControlStatusConfigurationEvent));
        Focal_plane_Raft_RaftTempControlStatusConfigurationEvent item_ = (Focal_plane_Raft_RaftTempControlStatusConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((boolean[])tempcontrol_active, (boolean[])item_.getTempcontrol_active());
    }

    @Test
    public void sendReceiveFocal_plane_RebTotalPower_LimitsConfigurationEvent() throws Exception {
        String version = "e";
        double warnHi = 0.6034621596336365;
        double warnLo = 0.3448001f;
        double limitHi = 0.9650728106498718;
        double limitLo = 0.9620434045791626;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_RebTotalPower_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTotalPower_LimitsConfigurationEvent));
        Focal_plane_RebTotalPower_LimitsConfigurationEvent item_ = (Focal_plane_RebTotalPower_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Reb_HardwareIdConfigurationEvent() throws Exception {
        String version = "x";
        String location = "";
        String name = "r";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_HardwareIdConfigurationEvent(version, location, name));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_HardwareIdConfigurationEvent));
        Focal_plane_Reb_HardwareIdConfigurationEvent item_ = (Focal_plane_Reb_HardwareIdConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)name, (Object)item_.getName());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_LimitsConfigurationEvent() throws Exception {
        String version = "i";
        double[] anai_warnHi = TestHelper.generateDoubleArray((int)71, (int)49973773);
        double[] anai_warnLo = TestHelper.generateDoubleArray((int)71, (int)1719516456);
        double[] anai_limitHi = TestHelper.generateDoubleArray((int)71, (int)-74814473);
        double[] anai_limitLo = TestHelper.generateDoubleArray((int)71, (int)918359194);
        double[] anav_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1022583277);
        double[] anav_warnLo = TestHelper.generateDoubleArray((int)71, (int)402701376);
        double[] anav_limitHi = TestHelper.generateDoubleArray((int)71, (int)1254314993);
        double[] anav_limitLo = TestHelper.generateDoubleArray((int)71, (int)482321676);
        double[] aspicl_Temp0_warnHi = TestHelper.generateDoubleArray((int)71, (int)1487976910);
        double[] aspicl_Temp0_warnLo = TestHelper.generateDoubleArray((int)71, (int)-980626627);
        double[] aspicl_Temp0_limitHi = TestHelper.generateDoubleArray((int)71, (int)791695501);
        double[] aspicl_Temp0_limitLo = TestHelper.generateDoubleArray((int)71, (int)776271177);
        double[] aspicl_Temp1_warnHi = TestHelper.generateDoubleArray((int)71, (int)-995019962);
        double[] aspicl_Temp1_warnLo = TestHelper.generateDoubleArray((int)71, (int)697428564);
        double[] aspicl_Temp1_limitHi = TestHelper.generateDoubleArray((int)71, (int)846232046);
        double[] aspicl_Temp1_limitLo = TestHelper.generateDoubleArray((int)71, (int)1943847797);
        double[] aspicl_Temp2_warnHi = TestHelper.generateDoubleArray((int)71, (int)-356393314);
        double[] aspicl_Temp2_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1494667164);
        double[] aspicl_Temp2_limitHi = TestHelper.generateDoubleArray((int)71, (int)-844322945);
        double[] aspicl_Temp2_limitLo = TestHelper.generateDoubleArray((int)71, (int)2013239106);
        double[] aspicu_Temp0_warnHi = TestHelper.generateDoubleArray((int)71, (int)103198069);
        double[] aspicu_Temp0_warnLo = TestHelper.generateDoubleArray((int)71, (int)1328205970);
        double[] aspicu_Temp0_limitHi = TestHelper.generateDoubleArray((int)71, (int)-643254289);
        double[] aspicu_Temp0_limitLo = TestHelper.generateDoubleArray((int)71, (int)1624112040);
        double[] aspicu_Temp1_warnHi = TestHelper.generateDoubleArray((int)71, (int)521822350);
        double[] aspicu_Temp1_warnLo = TestHelper.generateDoubleArray((int)71, (int)506522901);
        double[] aspicu_Temp1_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1504520835);
        double[] aspicu_Temp1_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1776965675);
        double[] aspicu_Temp2_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1229181006);
        double[] aspicu_Temp2_warnLo = TestHelper.generateDoubleArray((int)71, (int)827257678);
        double[] aspicu_Temp2_limitHi = TestHelper.generateDoubleArray((int)71, (int)223099509);
        double[] aspicu_Temp2_limitLo = TestHelper.generateDoubleArray((int)71, (int)667665249);
        double[] clkhi_warnHi = TestHelper.generateDoubleArray((int)71, (int)978684884);
        double[] clkhi_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1180590821);
        double[] clkhi_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1868875271);
        double[] clkhi_limitLo = TestHelper.generateDoubleArray((int)71, (int)-529876539);
        double[] clkhv_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1472766090);
        double[] clkhv_warnLo = TestHelper.generateDoubleArray((int)71, (int)172831595);
        double[] clkhv_limitHi = TestHelper.generateDoubleArray((int)71, (int)326013188);
        double[] clkhv_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1835708147);
        double[] clkli_warnHi = TestHelper.generateDoubleArray((int)71, (int)713060684);
        double[] clkli_warnLo = TestHelper.generateDoubleArray((int)71, (int)-490412523);
        double[] clkli_limitHi = TestHelper.generateDoubleArray((int)71, (int)1658209196);
        double[] clkli_limitLo = TestHelper.generateDoubleArray((int)71, (int)1497888717);
        double[] clklv_warnHi = TestHelper.generateDoubleArray((int)71, (int)756337950);
        double[] clklv_warnLo = TestHelper.generateDoubleArray((int)71, (int)2072988901);
        double[] clklv_limitHi = TestHelper.generateDoubleArray((int)71, (int)-2015982938);
        double[] clklv_limitLo = TestHelper.generateDoubleArray((int)71, (int)-117670319);
        double[] digi_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1507305742);
        double[] digi_warnLo = TestHelper.generateDoubleArray((int)71, (int)-961976840);
        double[] digi_limitHi = TestHelper.generateDoubleArray((int)71, (int)1870501135);
        double[] digi_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1783386345);
        double[] digv_warnHi = TestHelper.generateDoubleArray((int)71, (int)1513942121);
        double[] digv_warnLo = TestHelper.generateDoubleArray((int)71, (int)887792969);
        double[] digv_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1863507351);
        double[] digv_limitLo = TestHelper.generateDoubleArray((int)71, (int)2031843969);
        double[] hvbiasswitch_warnHi = TestHelper.generateDoubleArray((int)71, (int)-409552791);
        double[] hvbiasswitch_warnLo = TestHelper.generateDoubleArray((int)71, (int)1826744715);
        double[] hvbiasswitch_limitHi = TestHelper.generateDoubleArray((int)71, (int)-657114909);
        double[] hvbiasswitch_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1807767098);
        double[] htrpi_warnHi = TestHelper.generateDoubleArray((int)71, (int)1345297660);
        double[] htrpi_warnLo = TestHelper.generateDoubleArray((int)71, (int)248277560);
        double[] htrpi_limitHi = TestHelper.generateDoubleArray((int)71, (int)-974292004);
        double[] htrpi_limitLo = TestHelper.generateDoubleArray((int)71, (int)-593605335);
        double[] htrpv_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1503864969);
        double[] htrpv_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1849363735);
        double[] htrpv_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1899043159);
        double[] htrpv_limitLo = TestHelper.generateDoubleArray((int)71, (int)743987566);
        double[] htrv_warnHi = TestHelper.generateDoubleArray((int)71, (int)-303545634);
        double[] htrv_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1185218584);
        double[] htrv_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1486360682);
        double[] htrv_limitLo = TestHelper.generateDoubleArray((int)71, (int)734668936);
        double[] htrw_warnHi = TestHelper.generateDoubleArray((int)71, (int)1402002566);
        double[] htrw_warnLo = TestHelper.generateDoubleArray((int)71, (int)765890563);
        double[] htrw_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1755228373);
        double[] htrw_limitLo = TestHelper.generateDoubleArray((int)71, (int)928960918);
        String location = "d";
        double[] odi_warnHi = TestHelper.generateDoubleArray((int)71, (int)-613800017);
        double[] odi_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1708356592);
        double[] odi_limitHi = TestHelper.generateDoubleArray((int)71, (int)123635493);
        double[] odi_limitLo = TestHelper.generateDoubleArray((int)71, (int)1342603548);
        double[] odv_warnHi = TestHelper.generateDoubleArray((int)71, (int)1439017201);
        double[] odv_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1273523651);
        double[] odv_limitHi = TestHelper.generateDoubleArray((int)71, (int)2092373926);
        double[] odv_limitLo = TestHelper.generateDoubleArray((int)71, (int)1363412549);
        double[] pclk0_warnHi = TestHelper.generateDoubleArray((int)71, (int)1994280005);
        double[] pclk0_warnLo = TestHelper.generateDoubleArray((int)71, (int)1276917480);
        double[] pclk0_limitHi = TestHelper.generateDoubleArray((int)71, (int)13463173);
        double[] pclk0_limitLo = TestHelper.generateDoubleArray((int)71, (int)451718987);
        double[] pclk1_warnHi = TestHelper.generateDoubleArray((int)71, (int)-515058483);
        double[] pclk1_warnLo = TestHelper.generateDoubleArray((int)71, (int)-331865518);
        double[] pclk1_limitHi = TestHelper.generateDoubleArray((int)71, (int)1278370064);
        double[] pclk1_limitLo = TestHelper.generateDoubleArray((int)71, (int)652776130);
        double[] pclkl_warnHi = TestHelper.generateDoubleArray((int)71, (int)2113093625);
        double[] pclkl_warnLo = TestHelper.generateDoubleArray((int)71, (int)1869998698);
        double[] pclkl_limitHi = TestHelper.generateDoubleArray((int)71, (int)316592637);
        double[] pclkl_limitLo = TestHelper.generateDoubleArray((int)71, (int)938341116);
        double[] pclku_warnHi = TestHelper.generateDoubleArray((int)71, (int)549401168);
        double[] pclku_warnLo = TestHelper.generateDoubleArray((int)71, (int)320698939);
        double[] pclku_limitHi = TestHelper.generateDoubleArray((int)71, (int)-911084078);
        double[] pclku_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1511639906);
        double[] power_warnHi = TestHelper.generateDoubleArray((int)71, (int)1839197295);
        double[] power_warnLo = TestHelper.generateDoubleArray((int)71, (int)1161755813);
        double[] power_limitHi = TestHelper.generateDoubleArray((int)71, (int)-597362297);
        double[] power_limitLo = TestHelper.generateDoubleArray((int)71, (int)361966191);
        double[] rg0_warnHi = TestHelper.generateDoubleArray((int)71, (int)1266158674);
        double[] rg0_warnLo = TestHelper.generateDoubleArray((int)71, (int)-336249265);
        double[] rg0_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1916801175);
        double[] rg0_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1776498061);
        double[] rg1_warnHi = TestHelper.generateDoubleArray((int)71, (int)278109906);
        double[] rg1_warnLo = TestHelper.generateDoubleArray((int)71, (int)85441244);
        double[] rg1_limitHi = TestHelper.generateDoubleArray((int)71, (int)842409536);
        double[] rg1_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1726177224);
        double[] rgl_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1515240082);
        double[] rgl_warnLo = TestHelper.generateDoubleArray((int)71, (int)-991704740);
        double[] rgl_limitHi = TestHelper.generateDoubleArray((int)71, (int)-825340236);
        double[] rgl_limitLo = TestHelper.generateDoubleArray((int)71, (int)1564315758);
        double[] rgu_warnHi = TestHelper.generateDoubleArray((int)71, (int)438662221);
        double[] rgu_warnLo = TestHelper.generateDoubleArray((int)71, (int)-156787708);
        double[] rgu_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1247997204);
        double[] rgu_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1243889219);
        double[] rtdtemp_warnHi = TestHelper.generateDoubleArray((int)71, (int)-912061309);
        double[] rtdtemp_warnLo = TestHelper.generateDoubleArray((int)71, (int)2079393570);
        double[] rtdtemp_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1268841353);
        double[] rtdtemp_limitLo = TestHelper.generateDoubleArray((int)71, (int)880393939);
        double[] ref05v_warnHi = TestHelper.generateDoubleArray((int)71, (int)34920083);
        double[] ref05v_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1200798902);
        double[] ref05v_limitHi = TestHelper.generateDoubleArray((int)71, (int)724108399);
        double[] ref05v_limitLo = TestHelper.generateDoubleArray((int)71, (int)-2002967109);
        double[] ref125v_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1819041484);
        double[] ref125v_warnLo = TestHelper.generateDoubleArray((int)71, (int)1371938517);
        double[] ref125v_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1493923365);
        double[] ref125v_limitLo = TestHelper.generateDoubleArray((int)71, (int)-252282763);
        double[] ref15v_warnHi = TestHelper.generateDoubleArray((int)71, (int)1680672856);
        double[] ref15v_warnLo = TestHelper.generateDoubleArray((int)71, (int)1855738507);
        double[] ref15v_limitHi = TestHelper.generateDoubleArray((int)71, (int)-935368107);
        double[] ref15v_limitLo = TestHelper.generateDoubleArray((int)71, (int)719119042);
        double[] ref25v_warnHi = TestHelper.generateDoubleArray((int)71, (int)-758962071);
        double[] ref25v_warnLo = TestHelper.generateDoubleArray((int)71, (int)92663199);
        double[] ref25v_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1756559124);
        double[] ref25v_limitLo = TestHelper.generateDoubleArray((int)71, (int)-731903682);
        double[] refn12_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1222786603);
        double[] refn12_warnLo = TestHelper.generateDoubleArray((int)71, (int)2146634971);
        double[] refn12_limitHi = TestHelper.generateDoubleArray((int)71, (int)1477513035);
        double[] refn12_limitLo = TestHelper.generateDoubleArray((int)71, (int)1858024884);
        double[] refp12_warnHi = TestHelper.generateDoubleArray((int)71, (int)904630476);
        double[] refp12_warnLo = TestHelper.generateDoubleArray((int)71, (int)340414747);
        double[] refp12_limitHi = TestHelper.generateDoubleArray((int)71, (int)1168774426);
        double[] refp12_limitLo = TestHelper.generateDoubleArray((int)71, (int)1815508141);
        double[] sclk0_warnHi = TestHelper.generateDoubleArray((int)71, (int)-2045059768);
        double[] sclk0_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1716401921);
        double[] sclk0_limitHi = TestHelper.generateDoubleArray((int)71, (int)-892020317);
        double[] sclk0_limitLo = TestHelper.generateDoubleArray((int)71, (int)436697162);
        double[] sclk1_warnHi = TestHelper.generateDoubleArray((int)71, (int)-2049145011);
        double[] sclk1_warnLo = TestHelper.generateDoubleArray((int)71, (int)-32488997);
        double[] sclk1_limitHi = TestHelper.generateDoubleArray((int)71, (int)673641400);
        double[] sclk1_limitLo = TestHelper.generateDoubleArray((int)71, (int)-5417901);
        double[] sclkl_warnHi = TestHelper.generateDoubleArray((int)71, (int)2031424369);
        double[] sclkl_warnLo = TestHelper.generateDoubleArray((int)71, (int)-283233294);
        double[] sclkl_limitHi = TestHelper.generateDoubleArray((int)71, (int)2087328724);
        double[] sclkl_limitLo = TestHelper.generateDoubleArray((int)71, (int)59205519);
        double[] sclku_warnHi = TestHelper.generateDoubleArray((int)71, (int)624130975);
        double[] sclku_warnLo = TestHelper.generateDoubleArray((int)71, (int)555531748);
        double[] sclku_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1386253184);
        double[] sclku_limitLo = TestHelper.generateDoubleArray((int)71, (int)1832453717);
        double[] temp10_warnHi = TestHelper.generateDoubleArray((int)71, (int)1604175895);
        double[] temp10_warnLo = TestHelper.generateDoubleArray((int)71, (int)205284196);
        double[] temp10_limitHi = TestHelper.generateDoubleArray((int)71, (int)1103394040);
        double[] temp10_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1413432733);
        double[] temp1_warnHi = TestHelper.generateDoubleArray((int)71, (int)-127945544);
        double[] temp1_warnLo = TestHelper.generateDoubleArray((int)71, (int)337937197);
        double[] temp1_limitHi = TestHelper.generateDoubleArray((int)71, (int)1055480334);
        double[] temp1_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1574753299);
        double[] temp2_warnHi = TestHelper.generateDoubleArray((int)71, (int)583526017);
        double[] temp2_warnLo = TestHelper.generateDoubleArray((int)71, (int)514308150);
        double[] temp2_limitHi = TestHelper.generateDoubleArray((int)71, (int)381894989);
        double[] temp2_limitLo = TestHelper.generateDoubleArray((int)71, (int)-2035087367);
        double[] temp3_warnHi = TestHelper.generateDoubleArray((int)71, (int)1298429269);
        double[] temp3_warnLo = TestHelper.generateDoubleArray((int)71, (int)1723898404);
        double[] temp3_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1788718496);
        double[] temp3_limitLo = TestHelper.generateDoubleArray((int)71, (int)130054121);
        double[] temp4_warnHi = TestHelper.generateDoubleArray((int)71, (int)-90714626);
        double[] temp4_warnLo = TestHelper.generateDoubleArray((int)71, (int)1253413119);
        double[] temp4_limitHi = TestHelper.generateDoubleArray((int)71, (int)408328885);
        double[] temp4_limitLo = TestHelper.generateDoubleArray((int)71, (int)839908953);
        double[] temp5_warnHi = TestHelper.generateDoubleArray((int)71, (int)386609267);
        double[] temp5_warnLo = TestHelper.generateDoubleArray((int)71, (int)1459204136);
        double[] temp5_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1508606115);
        double[] temp5_limitLo = TestHelper.generateDoubleArray((int)71, (int)1528941866);
        double[] temp6_warnHi = TestHelper.generateDoubleArray((int)71, (int)-2083238307);
        double[] temp6_warnLo = TestHelper.generateDoubleArray((int)71, (int)2118896778);
        double[] temp6_limitHi = TestHelper.generateDoubleArray((int)71, (int)1360259381);
        double[] temp6_limitLo = TestHelper.generateDoubleArray((int)71, (int)1078978783);
        double[] temp7_warnHi = TestHelper.generateDoubleArray((int)71, (int)-747123241);
        double[] temp7_warnLo = TestHelper.generateDoubleArray((int)71, (int)1509179920);
        double[] temp7_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1334603958);
        double[] temp7_limitLo = TestHelper.generateDoubleArray((int)71, (int)1700441383);
        double[] temp8_warnHi = TestHelper.generateDoubleArray((int)71, (int)1531622517);
        double[] temp8_warnLo = TestHelper.generateDoubleArray((int)71, (int)907353174);
        double[] temp8_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1063517319);
        double[] temp8_limitLo = TestHelper.generateDoubleArray((int)71, (int)375424698);
        double[] temp9_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1034879352);
        double[] temp9_warnLo = TestHelper.generateDoubleArray((int)71, (int)1292342946);
        double[] temp9_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1208720042);
        double[] temp9_limitLo = TestHelper.generateDoubleArray((int)71, (int)-206113176);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_LimitsConfigurationEvent(version, anai_warnHi, anai_warnLo, anai_limitHi, anai_limitLo, anav_warnHi, anav_warnLo, anav_limitHi, anav_limitLo, aspicl_Temp0_warnHi, aspicl_Temp0_warnLo, aspicl_Temp0_limitHi, aspicl_Temp0_limitLo, aspicl_Temp1_warnHi, aspicl_Temp1_warnLo, aspicl_Temp1_limitHi, aspicl_Temp1_limitLo, aspicl_Temp2_warnHi, aspicl_Temp2_warnLo, aspicl_Temp2_limitHi, aspicl_Temp2_limitLo, aspicu_Temp0_warnHi, aspicu_Temp0_warnLo, aspicu_Temp0_limitHi, aspicu_Temp0_limitLo, aspicu_Temp1_warnHi, aspicu_Temp1_warnLo, aspicu_Temp1_limitHi, aspicu_Temp1_limitLo, aspicu_Temp2_warnHi, aspicu_Temp2_warnLo, aspicu_Temp2_limitHi, aspicu_Temp2_limitLo, clkhi_warnHi, clkhi_warnLo, clkhi_limitHi, clkhi_limitLo, clkhv_warnHi, clkhv_warnLo, clkhv_limitHi, clkhv_limitLo, clkli_warnHi, clkli_warnLo, clkli_limitHi, clkli_limitLo, clklv_warnHi, clklv_warnLo, clklv_limitHi, clklv_limitLo, digi_warnHi, digi_warnLo, digi_limitHi, digi_limitLo, digv_warnHi, digv_warnLo, digv_limitHi, digv_limitLo, hvbiasswitch_warnHi, hvbiasswitch_warnLo, hvbiasswitch_limitHi, hvbiasswitch_limitLo, htrpi_warnHi, htrpi_warnLo, htrpi_limitHi, htrpi_limitLo, htrpv_warnHi, htrpv_warnLo, htrpv_limitHi, htrpv_limitLo, htrv_warnHi, htrv_warnLo, htrv_limitHi, htrv_limitLo, htrw_warnHi, htrw_warnLo, htrw_limitHi, htrw_limitLo, location, odi_warnHi, odi_warnLo, odi_limitHi, odi_limitLo, odv_warnHi, odv_warnLo, odv_limitHi, odv_limitLo, pclk0_warnHi, pclk0_warnLo, pclk0_limitHi, pclk0_limitLo, pclk1_warnHi, pclk1_warnLo, pclk1_limitHi, pclk1_limitLo, pclkl_warnHi, pclkl_warnLo, pclkl_limitHi, pclkl_limitLo, pclku_warnHi, pclku_warnLo, pclku_limitHi, pclku_limitLo, power_warnHi, power_warnLo, power_limitHi, power_limitLo, rg0_warnHi, rg0_warnLo, rg0_limitHi, rg0_limitLo, rg1_warnHi, rg1_warnLo, rg1_limitHi, rg1_limitLo, rgl_warnHi, rgl_warnLo, rgl_limitHi, rgl_limitLo, rgu_warnHi, rgu_warnLo, rgu_limitHi, rgu_limitLo, rtdtemp_warnHi, rtdtemp_warnLo, rtdtemp_limitHi, rtdtemp_limitLo, ref05v_warnHi, ref05v_warnLo, ref05v_limitHi, ref05v_limitLo, ref125v_warnHi, ref125v_warnLo, ref125v_limitHi, ref125v_limitLo, ref15v_warnHi, ref15v_warnLo, ref15v_limitHi, ref15v_limitLo, ref25v_warnHi, ref25v_warnLo, ref25v_limitHi, ref25v_limitLo, refn12_warnHi, refn12_warnLo, refn12_limitHi, refn12_limitLo, refp12_warnHi, refp12_warnLo, refp12_limitHi, refp12_limitLo, sclk0_warnHi, sclk0_warnLo, sclk0_limitHi, sclk0_limitLo, sclk1_warnHi, sclk1_warnLo, sclk1_limitHi, sclk1_limitLo, sclkl_warnHi, sclkl_warnLo, sclkl_limitHi, sclkl_limitLo, sclku_warnHi, sclku_warnLo, sclku_limitHi, sclku_limitLo, temp10_warnHi, temp10_warnLo, temp10_limitHi, temp10_limitLo, temp1_warnHi, temp1_warnLo, temp1_limitHi, temp1_limitLo, temp2_warnHi, temp2_warnLo, temp2_limitHi, temp2_limitLo, temp3_warnHi, temp3_warnLo, temp3_limitHi, temp3_limitLo, temp4_warnHi, temp4_warnLo, temp4_limitHi, temp4_limitLo, temp5_warnHi, temp5_warnLo, temp5_limitHi, temp5_limitLo, temp6_warnHi, temp6_warnLo, temp6_limitHi, temp6_limitLo, temp7_warnHi, temp7_warnLo, temp7_limitHi, temp7_limitLo, temp8_warnHi, temp8_warnLo, temp8_limitHi, temp8_limitLo, temp9_warnHi, temp9_warnLo, temp9_limitHi, temp9_limitLo));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_LimitsConfigurationEvent));
        Focal_plane_Reb_LimitsConfigurationEvent item_ = (Focal_plane_Reb_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])anai_warnHi, (double[])item_.getAnai_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anai_warnLo, (double[])item_.getAnai_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anai_limitHi, (double[])item_.getAnai_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anai_limitLo, (double[])item_.getAnai_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_warnHi, (double[])item_.getAnav_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_warnLo, (double[])item_.getAnav_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_limitHi, (double[])item_.getAnav_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_limitLo, (double[])item_.getAnav_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_warnHi, (double[])item_.getAspicl_Temp0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_warnLo, (double[])item_.getAspicl_Temp0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_limitHi, (double[])item_.getAspicl_Temp0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_limitLo, (double[])item_.getAspicl_Temp0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1_warnHi, (double[])item_.getAspicl_Temp1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1_warnLo, (double[])item_.getAspicl_Temp1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1_limitHi, (double[])item_.getAspicl_Temp1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1_limitLo, (double[])item_.getAspicl_Temp1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2_warnHi, (double[])item_.getAspicl_Temp2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2_warnLo, (double[])item_.getAspicl_Temp2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2_limitHi, (double[])item_.getAspicl_Temp2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2_limitLo, (double[])item_.getAspicl_Temp2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_warnHi, (double[])item_.getAspicu_Temp0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_warnLo, (double[])item_.getAspicu_Temp0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_limitHi, (double[])item_.getAspicu_Temp0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_limitLo, (double[])item_.getAspicu_Temp0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1_warnHi, (double[])item_.getAspicu_Temp1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1_warnLo, (double[])item_.getAspicu_Temp1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1_limitHi, (double[])item_.getAspicu_Temp1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1_limitLo, (double[])item_.getAspicu_Temp1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2_warnHi, (double[])item_.getAspicu_Temp2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2_warnLo, (double[])item_.getAspicu_Temp2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2_limitHi, (double[])item_.getAspicu_Temp2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2_limitLo, (double[])item_.getAspicu_Temp2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_warnHi, (double[])item_.getClkhi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_warnLo, (double[])item_.getClkhi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_limitHi, (double[])item_.getClkhi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_limitLo, (double[])item_.getClkhi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_warnHi, (double[])item_.getClkhv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_warnLo, (double[])item_.getClkhv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_limitHi, (double[])item_.getClkhv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_limitLo, (double[])item_.getClkhv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkli_warnHi, (double[])item_.getClkli_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkli_warnLo, (double[])item_.getClkli_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkli_limitHi, (double[])item_.getClkli_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkli_limitLo, (double[])item_.getClkli_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_warnHi, (double[])item_.getClklv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_warnLo, (double[])item_.getClklv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_limitHi, (double[])item_.getClklv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_limitLo, (double[])item_.getClklv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_warnHi, (double[])item_.getDigi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_warnLo, (double[])item_.getDigi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_limitHi, (double[])item_.getDigi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_limitLo, (double[])item_.getDigi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_warnHi, (double[])item_.getDigv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_warnLo, (double[])item_.getDigv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_limitHi, (double[])item_.getDigv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_limitLo, (double[])item_.getDigv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_warnHi, (double[])item_.getHvbiasswitch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_warnLo, (double[])item_.getHvbiasswitch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_limitHi, (double[])item_.getHvbiasswitch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_limitLo, (double[])item_.getHvbiasswitch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpi_warnHi, (double[])item_.getHtrpi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpi_warnLo, (double[])item_.getHtrpi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpi_limitHi, (double[])item_.getHtrpi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpi_limitLo, (double[])item_.getHtrpi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpv_warnHi, (double[])item_.getHtrpv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpv_warnLo, (double[])item_.getHtrpv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpv_limitHi, (double[])item_.getHtrpv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpv_limitLo, (double[])item_.getHtrpv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_warnHi, (double[])item_.getHtrv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_warnLo, (double[])item_.getHtrv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_limitHi, (double[])item_.getHtrv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_limitLo, (double[])item_.getHtrv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_warnHi, (double[])item_.getHtrw_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_warnLo, (double[])item_.getHtrw_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_limitHi, (double[])item_.getHtrw_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_limitLo, (double[])item_.getHtrw_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])odi_warnHi, (double[])item_.getOdi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_warnLo, (double[])item_.getOdi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_limitHi, (double[])item_.getOdi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_limitLo, (double[])item_.getOdi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnHi, (double[])item_.getOdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnLo, (double[])item_.getOdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitHi, (double[])item_.getOdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitLo, (double[])item_.getOdv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk0_warnHi, (double[])item_.getPclk0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk0_warnLo, (double[])item_.getPclk0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk0_limitHi, (double[])item_.getPclk0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk0_limitLo, (double[])item_.getPclk0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk1_warnHi, (double[])item_.getPclk1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk1_warnLo, (double[])item_.getPclk1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk1_limitHi, (double[])item_.getPclk1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk1_limitLo, (double[])item_.getPclk1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_warnHi, (double[])item_.getPclkl_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_warnLo, (double[])item_.getPclkl_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_limitHi, (double[])item_.getPclkl_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_limitLo, (double[])item_.getPclkl_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_warnHi, (double[])item_.getPclku_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_warnLo, (double[])item_.getPclku_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_limitHi, (double[])item_.getPclku_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_limitLo, (double[])item_.getPclku_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_warnHi, (double[])item_.getPower_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_warnLo, (double[])item_.getPower_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_limitHi, (double[])item_.getPower_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_limitLo, (double[])item_.getPower_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg0_warnHi, (double[])item_.getRg0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg0_warnLo, (double[])item_.getRg0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg0_limitHi, (double[])item_.getRg0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg0_limitLo, (double[])item_.getRg0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg1_warnHi, (double[])item_.getRg1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg1_warnLo, (double[])item_.getRg1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg1_limitHi, (double[])item_.getRg1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg1_limitLo, (double[])item_.getRg1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_warnHi, (double[])item_.getRgl_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_warnLo, (double[])item_.getRgl_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_limitHi, (double[])item_.getRgl_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_limitLo, (double[])item_.getRgl_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_warnHi, (double[])item_.getRgu_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_warnLo, (double[])item_.getRgu_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_limitHi, (double[])item_.getRgu_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_limitLo, (double[])item_.getRgu_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_warnHi, (double[])item_.getRtdtemp_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_warnLo, (double[])item_.getRtdtemp_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_limitHi, (double[])item_.getRtdtemp_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_limitLo, (double[])item_.getRtdtemp_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05v_warnHi, (double[])item_.getRef05v_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05v_warnLo, (double[])item_.getRef05v_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05v_limitHi, (double[])item_.getRef05v_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05v_limitLo, (double[])item_.getRef05v_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125v_warnHi, (double[])item_.getRef125v_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125v_warnLo, (double[])item_.getRef125v_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125v_limitHi, (double[])item_.getRef125v_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125v_limitLo, (double[])item_.getRef125v_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15v_warnHi, (double[])item_.getRef15v_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15v_warnLo, (double[])item_.getRef15v_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15v_limitHi, (double[])item_.getRef15v_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15v_limitLo, (double[])item_.getRef15v_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25v_warnHi, (double[])item_.getRef25v_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25v_warnLo, (double[])item_.getRef25v_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25v_limitHi, (double[])item_.getRef25v_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25v_limitLo, (double[])item_.getRef25v_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refn12_warnHi, (double[])item_.getRefn12_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refn12_warnLo, (double[])item_.getRefn12_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refn12_limitHi, (double[])item_.getRefn12_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refn12_limitLo, (double[])item_.getRefn12_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refp12_warnHi, (double[])item_.getRefp12_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refp12_warnLo, (double[])item_.getRefp12_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refp12_limitHi, (double[])item_.getRefp12_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refp12_limitLo, (double[])item_.getRefp12_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk0_warnHi, (double[])item_.getSclk0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk0_warnLo, (double[])item_.getSclk0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk0_limitHi, (double[])item_.getSclk0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk0_limitLo, (double[])item_.getSclk0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk1_warnHi, (double[])item_.getSclk1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk1_warnLo, (double[])item_.getSclk1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk1_limitHi, (double[])item_.getSclk1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk1_limitLo, (double[])item_.getSclk1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_warnHi, (double[])item_.getSclkl_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_warnLo, (double[])item_.getSclkl_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_limitHi, (double[])item_.getSclkl_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_limitLo, (double[])item_.getSclkl_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_warnHi, (double[])item_.getSclku_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_warnLo, (double[])item_.getSclku_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_limitHi, (double[])item_.getSclku_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_limitLo, (double[])item_.getSclku_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10_warnHi, (double[])item_.getTemp10_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10_warnLo, (double[])item_.getTemp10_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10_limitHi, (double[])item_.getTemp10_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10_limitLo, (double[])item_.getTemp10_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_warnHi, (double[])item_.getTemp1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_warnLo, (double[])item_.getTemp1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_limitHi, (double[])item_.getTemp1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_limitLo, (double[])item_.getTemp1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_warnHi, (double[])item_.getTemp2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_warnLo, (double[])item_.getTemp2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_limitHi, (double[])item_.getTemp2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_limitLo, (double[])item_.getTemp2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_warnHi, (double[])item_.getTemp3_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_warnLo, (double[])item_.getTemp3_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_limitHi, (double[])item_.getTemp3_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_limitLo, (double[])item_.getTemp3_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_warnHi, (double[])item_.getTemp4_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_warnLo, (double[])item_.getTemp4_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_limitHi, (double[])item_.getTemp4_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_limitLo, (double[])item_.getTemp4_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_warnHi, (double[])item_.getTemp5_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_warnLo, (double[])item_.getTemp5_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_limitHi, (double[])item_.getTemp5_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_limitLo, (double[])item_.getTemp5_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_warnHi, (double[])item_.getTemp6_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_warnLo, (double[])item_.getTemp6_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_limitHi, (double[])item_.getTemp6_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_limitLo, (double[])item_.getTemp6_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7_warnHi, (double[])item_.getTemp7_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7_warnLo, (double[])item_.getTemp7_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7_limitHi, (double[])item_.getTemp7_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7_limitLo, (double[])item_.getTemp7_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8_warnHi, (double[])item_.getTemp8_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8_warnLo, (double[])item_.getTemp8_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8_limitHi, (double[])item_.getTemp8_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8_limitLo, (double[])item_.getTemp8_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9_warnHi, (double[])item_.getTemp9_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9_warnLo, (double[])item_.getTemp9_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9_limitHi, (double[])item_.getTemp9_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9_limitLo, (double[])item_.getTemp9_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Reb_RaftsConfigurationEvent() throws Exception {
        String version = "i";
        double[] bias0_csGateP = TestHelper.generateDoubleArray((int)71, (int)-260776113);
        double[] bias0_gdP = TestHelper.generateDoubleArray((int)71, (int)-1763167890);
        double[] bias0_odP = TestHelper.generateDoubleArray((int)71, (int)-1561419441);
        double[] bias0_ogP = TestHelper.generateDoubleArray((int)71, (int)-1010202339);
        double[] bias0_rdP = TestHelper.generateDoubleArray((int)71, (int)83972624);
        double[] bias1_csGateP = TestHelper.generateDoubleArray((int)71, (int)1081733899);
        double[] bias1_gdP = TestHelper.generateDoubleArray((int)71, (int)-188182217);
        double[] bias1_odP = TestHelper.generateDoubleArray((int)71, (int)-2128708819);
        double[] bias1_ogP = TestHelper.generateDoubleArray((int)71, (int)1530450471);
        double[] bias1_rdP = TestHelper.generateDoubleArray((int)71, (int)-78163118);
        double[] bias2_csGateP = TestHelper.generateDoubleArray((int)71, (int)255866686);
        double[] bias2_gdP = TestHelper.generateDoubleArray((int)71, (int)785982384);
        double[] bias2_odP = TestHelper.generateDoubleArray((int)71, (int)504159211);
        double[] bias2_ogP = TestHelper.generateDoubleArray((int)71, (int)-1241467071);
        double[] bias2_rdP = TestHelper.generateDoubleArray((int)71, (int)-832412898);
        double[] dac_pclkHighP = TestHelper.generateDoubleArray((int)71, (int)-192130758);
        double[] dac_pclkLowP = TestHelper.generateDoubleArray((int)71, (int)-448962150);
        double[] dac_rgHighP = TestHelper.generateDoubleArray((int)71, (int)1212296723);
        double[] dac_rgLowP = TestHelper.generateDoubleArray((int)71, (int)-1403164634);
        double[] dac_sclkHighP = TestHelper.generateDoubleArray((int)71, (int)-2039346688);
        double[] dac_sclkLowP = TestHelper.generateDoubleArray((int)71, (int)134551489);
        boolean[] disableRTDHardwareCheck = new boolean[]{true, false, false, true, false, true, true, true, true, true, true, false, true, false, false, false, false, false, true, true, false, true, false, false, true, true, true, false, false, false, false, true, true, false, true, true, false, true, false, true, false, false, false, true, true, true, true, true, true, false, false, true, true, false, true, false, true, true, true, true, false, true, false, false, false, true, false, true, false, false, true};
        String location = "n";
        long[] serialNum = TestHelper.generateLongArray((int)71, (int)369183085);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_RaftsConfigurationEvent(version, bias0_csGateP, bias0_gdP, bias0_odP, bias0_ogP, bias0_rdP, bias1_csGateP, bias1_gdP, bias1_odP, bias1_ogP, bias1_rdP, bias2_csGateP, bias2_gdP, bias2_odP, bias2_ogP, bias2_rdP, dac_pclkHighP, dac_pclkLowP, dac_rgHighP, dac_rgLowP, dac_sclkHighP, dac_sclkLowP, disableRTDHardwareCheck, location, serialNum));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_RaftsConfigurationEvent));
        Focal_plane_Reb_RaftsConfigurationEvent item_ = (Focal_plane_Reb_RaftsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])bias0_csGateP, (double[])item_.getBias0_csGateP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdP, (double[])item_.getBias0_gdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odP, (double[])item_.getBias0_odP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogP, (double[])item_.getBias0_ogP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdP, (double[])item_.getBias0_rdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_csGateP, (double[])item_.getBias1_csGateP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdP, (double[])item_.getBias1_gdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odP, (double[])item_.getBias1_odP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogP, (double[])item_.getBias1_ogP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdP, (double[])item_.getBias1_rdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_csGateP, (double[])item_.getBias2_csGateP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdP, (double[])item_.getBias2_gdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odP, (double[])item_.getBias2_odP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogP, (double[])item_.getBias2_ogP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdP, (double[])item_.getBias2_rdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighP, (double[])item_.getDac_pclkHighP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowP, (double[])item_.getDac_pclkLowP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighP, (double[])item_.getDac_rgHighP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowP, (double[])item_.getDac_rgLowP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighP, (double[])item_.getDac_sclkHighP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowP, (double[])item_.getDac_sclkLowP(), (double)1.0E-6f);
        Assert.assertArrayEquals((boolean[])disableRTDHardwareCheck, (boolean[])item_.getDisableRTDHardwareCheck());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((long[])serialNum, (long[])item_.getSerialNum());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_RaftsLimitsConfigurationEvent() throws Exception {
        String version = "s";
        double[] bias0_gdMax = TestHelper.generateDoubleArray((int)71, (int)-1430475521);
        double[] bias0_gdMin = TestHelper.generateDoubleArray((int)71, (int)-526443333);
        double[] bias0_odMax = TestHelper.generateDoubleArray((int)71, (int)-506661827);
        double[] bias0_odMin = TestHelper.generateDoubleArray((int)71, (int)1443606241);
        double[] bias0_ogMax = TestHelper.generateDoubleArray((int)71, (int)1469143262);
        double[] bias0_ogMin = TestHelper.generateDoubleArray((int)71, (int)375648708);
        double[] bias0_rdMax = TestHelper.generateDoubleArray((int)71, (int)1371003482);
        double[] bias0_rdMin = TestHelper.generateDoubleArray((int)71, (int)769831705);
        double[] bias1_gdMax = TestHelper.generateDoubleArray((int)71, (int)1742180812);
        double[] bias1_gdMin = TestHelper.generateDoubleArray((int)71, (int)75518533);
        double[] bias1_odMax = TestHelper.generateDoubleArray((int)71, (int)-914679241);
        double[] bias1_odMin = TestHelper.generateDoubleArray((int)71, (int)-521650074);
        double[] bias1_ogMax = TestHelper.generateDoubleArray((int)71, (int)-1895574510);
        double[] bias1_ogMin = TestHelper.generateDoubleArray((int)71, (int)-809038289);
        double[] bias1_rdMax = TestHelper.generateDoubleArray((int)71, (int)1458576744);
        double[] bias1_rdMin = TestHelper.generateDoubleArray((int)71, (int)-1470858451);
        double[] bias2_gdMax = TestHelper.generateDoubleArray((int)71, (int)-1859801831);
        double[] bias2_gdMin = TestHelper.generateDoubleArray((int)71, (int)1692960358);
        double[] bias2_odMax = TestHelper.generateDoubleArray((int)71, (int)-500336898);
        double[] bias2_odMin = TestHelper.generateDoubleArray((int)71, (int)2004977280);
        double[] bias2_ogMax = TestHelper.generateDoubleArray((int)71, (int)565815291);
        double[] bias2_ogMin = TestHelper.generateDoubleArray((int)71, (int)1657888709);
        double[] bias2_rdMax = TestHelper.generateDoubleArray((int)71, (int)-1939950528);
        double[] bias2_rdMin = TestHelper.generateDoubleArray((int)71, (int)-1052698427);
        double[] dac_pclkHighMax = TestHelper.generateDoubleArray((int)71, (int)198504277);
        double[] dac_pclkHighMin = TestHelper.generateDoubleArray((int)71, (int)1880285797);
        double[] dac_pclkLowMax = TestHelper.generateDoubleArray((int)71, (int)-1652816741);
        double[] dac_pclkLowMin = TestHelper.generateDoubleArray((int)71, (int)484718233);
        double[] dac_rgHighMax = TestHelper.generateDoubleArray((int)71, (int)1787344994);
        double[] dac_rgHighMin = TestHelper.generateDoubleArray((int)71, (int)-1646556897);
        double[] dac_rgLowMax = TestHelper.generateDoubleArray((int)71, (int)-1094718250);
        double[] dac_rgLowMin = TestHelper.generateDoubleArray((int)71, (int)893990897);
        double[] dac_sclkHighMax = TestHelper.generateDoubleArray((int)71, (int)-5715131);
        double[] dac_sclkHighMin = TestHelper.generateDoubleArray((int)71, (int)1047168334);
        double[] dac_sclkLowMax = TestHelper.generateDoubleArray((int)71, (int)-2098693751);
        double[] dac_sclkLowMin = TestHelper.generateDoubleArray((int)71, (int)2061663106);
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_RaftsLimitsConfigurationEvent(version, bias0_gdMax, bias0_gdMin, bias0_odMax, bias0_odMin, bias0_ogMax, bias0_ogMin, bias0_rdMax, bias0_rdMin, bias1_gdMax, bias1_gdMin, bias1_odMax, bias1_odMin, bias1_ogMax, bias1_ogMin, bias1_rdMax, bias1_rdMin, bias2_gdMax, bias2_gdMin, bias2_odMax, bias2_odMin, bias2_ogMax, bias2_ogMin, bias2_rdMax, bias2_rdMin, dac_pclkHighMax, dac_pclkHighMin, dac_pclkLowMax, dac_pclkLowMin, dac_rgHighMax, dac_rgHighMin, dac_rgLowMax, dac_rgLowMin, dac_sclkHighMax, dac_sclkHighMin, dac_sclkLowMax, dac_sclkLowMin, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_RaftsLimitsConfigurationEvent));
        Focal_plane_Reb_RaftsLimitsConfigurationEvent item_ = (Focal_plane_Reb_RaftsLimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])bias0_gdMax, (double[])item_.getBias0_gdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdMin, (double[])item_.getBias0_gdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odMax, (double[])item_.getBias0_odMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odMin, (double[])item_.getBias0_odMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogMax, (double[])item_.getBias0_ogMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogMin, (double[])item_.getBias0_ogMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdMax, (double[])item_.getBias0_rdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdMin, (double[])item_.getBias0_rdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdMax, (double[])item_.getBias1_gdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdMin, (double[])item_.getBias1_gdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odMax, (double[])item_.getBias1_odMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odMin, (double[])item_.getBias1_odMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogMax, (double[])item_.getBias1_ogMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogMin, (double[])item_.getBias1_ogMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdMax, (double[])item_.getBias1_rdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdMin, (double[])item_.getBias1_rdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdMax, (double[])item_.getBias2_gdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdMin, (double[])item_.getBias2_gdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odMax, (double[])item_.getBias2_odMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odMin, (double[])item_.getBias2_odMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogMax, (double[])item_.getBias2_ogMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogMin, (double[])item_.getBias2_ogMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdMax, (double[])item_.getBias2_rdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdMin, (double[])item_.getBias2_rdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighMax, (double[])item_.getDac_pclkHighMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighMin, (double[])item_.getDac_pclkHighMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowMax, (double[])item_.getDac_pclkLowMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowMin, (double[])item_.getDac_pclkLowMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighMax, (double[])item_.getDac_rgHighMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighMin, (double[])item_.getDac_rgHighMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowMax, (double[])item_.getDac_rgLowMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowMin, (double[])item_.getDac_rgLowMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighMax, (double[])item_.getDac_sclkHighMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighMin, (double[])item_.getDac_sclkHighMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowMax, (double[])item_.getDac_sclkLowMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowMin, (double[])item_.getDac_sclkLowMin(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_RaftsPowerConfigurationEvent() throws Exception {
        String version = "n";
        double[] bias0_gdCal = TestHelper.generateDoubleArray((int)71, (int)-1008047005);
        double[] bias0_gdTestVolts = TestHelper.generateDoubleArray((int)71, (int)130067583);
        double[] bias0_gdTol = TestHelper.generateDoubleArray((int)71, (int)-478021520);
        double[] bias0_gdValueErr = TestHelper.generateDoubleArray((int)71, (int)1642455866);
        double[] bias0_gdZeroErr = TestHelper.generateDoubleArray((int)71, (int)1914682863);
        double[] bias0_odCal = TestHelper.generateDoubleArray((int)71, (int)194485814);
        double[] bias0_odIMax = TestHelper.generateDoubleArray((int)71, (int)1062957077);
        double[] bias0_odTol = TestHelper.generateDoubleArray((int)71, (int)119081991);
        double[] bias0_odZeroErr = TestHelper.generateDoubleArray((int)71, (int)363790831);
        double[] bias0_ogCal = TestHelper.generateDoubleArray((int)71, (int)1615248878);
        double[] bias0_ogTestVolts = TestHelper.generateDoubleArray((int)71, (int)-439045155);
        double[] bias0_ogTol = TestHelper.generateDoubleArray((int)71, (int)1380520082);
        double[] bias0_ogValueErr = TestHelper.generateDoubleArray((int)71, (int)2006777081);
        double[] bias0_ogZeroErr = TestHelper.generateDoubleArray((int)71, (int)-1612437733);
        double[] bias0_rdCal = TestHelper.generateDoubleArray((int)71, (int)-1142572297);
        double[] bias0_rdTestVolts = TestHelper.generateDoubleArray((int)71, (int)1661024012);
        double[] bias0_rdTol = TestHelper.generateDoubleArray((int)71, (int)-1118348014);
        double[] bias0_rdValueErr = TestHelper.generateDoubleArray((int)71, (int)-2017394604);
        double[] bias0_rdZeroErr = TestHelper.generateDoubleArray((int)71, (int)-2038123795);
        double[] bias1_gdCal = TestHelper.generateDoubleArray((int)71, (int)2037107818);
        double[] bias1_gdTestVolts = TestHelper.generateDoubleArray((int)71, (int)424130202);
        double[] bias1_gdTol = TestHelper.generateDoubleArray((int)71, (int)274989165);
        double[] bias1_gdValueErr = TestHelper.generateDoubleArray((int)71, (int)978362666);
        double[] bias1_gdZeroErr = TestHelper.generateDoubleArray((int)71, (int)-1933213280);
        double[] bias1_odCal = TestHelper.generateDoubleArray((int)71, (int)-2086737047);
        double[] bias1_odIMax = TestHelper.generateDoubleArray((int)71, (int)671002819);
        double[] bias1_odTol = TestHelper.generateDoubleArray((int)71, (int)-1232725829);
        double[] bias1_odZeroErr = TestHelper.generateDoubleArray((int)71, (int)1233971214);
        double[] bias1_ogCal = TestHelper.generateDoubleArray((int)71, (int)-246587340);
        double[] bias1_ogTestVolts = TestHelper.generateDoubleArray((int)71, (int)172228825);
        double[] bias1_ogTol = TestHelper.generateDoubleArray((int)71, (int)1482885209);
        double[] bias1_ogValueErr = TestHelper.generateDoubleArray((int)71, (int)-506937030);
        double[] bias1_ogZeroErr = TestHelper.generateDoubleArray((int)71, (int)-1082219467);
        double[] bias1_rdCal = TestHelper.generateDoubleArray((int)71, (int)-539230429);
        double[] bias1_rdTestVolts = TestHelper.generateDoubleArray((int)71, (int)317383846);
        double[] bias1_rdTol = TestHelper.generateDoubleArray((int)71, (int)1480005056);
        double[] bias1_rdValueErr = TestHelper.generateDoubleArray((int)71, (int)-969576693);
        double[] bias1_rdZeroErr = TestHelper.generateDoubleArray((int)71, (int)-1759917278);
        double[] bias2_gdCal = TestHelper.generateDoubleArray((int)71, (int)-1370705225);
        double[] bias2_gdTestVolts = TestHelper.generateDoubleArray((int)71, (int)1440892806);
        double[] bias2_gdTol = TestHelper.generateDoubleArray((int)71, (int)386865374);
        double[] bias2_gdValueErr = TestHelper.generateDoubleArray((int)71, (int)-1269427024);
        double[] bias2_gdZeroErr = TestHelper.generateDoubleArray((int)71, (int)104904402);
        double[] bias2_odCal = TestHelper.generateDoubleArray((int)71, (int)-138898637);
        double[] bias2_odIMax = TestHelper.generateDoubleArray((int)71, (int)-1811681082);
        double[] bias2_odTol = TestHelper.generateDoubleArray((int)71, (int)-1415463780);
        double[] bias2_odZeroErr = TestHelper.generateDoubleArray((int)71, (int)399231864);
        double[] bias2_ogCal = TestHelper.generateDoubleArray((int)71, (int)-627723039);
        double[] bias2_ogTestVolts = TestHelper.generateDoubleArray((int)71, (int)-1486088851);
        double[] bias2_ogTol = TestHelper.generateDoubleArray((int)71, (int)-2069271943);
        double[] bias2_ogValueErr = TestHelper.generateDoubleArray((int)71, (int)959620261);
        double[] bias2_ogZeroErr = TestHelper.generateDoubleArray((int)71, (int)1995809808);
        double[] bias2_rdCal = TestHelper.generateDoubleArray((int)71, (int)-1058622478);
        double[] bias2_rdTestVolts = TestHelper.generateDoubleArray((int)71, (int)2111581107);
        double[] bias2_rdTol = TestHelper.generateDoubleArray((int)71, (int)1120371541);
        double[] bias2_rdValueErr = TestHelper.generateDoubleArray((int)71, (int)1166187230);
        double[] bias2_rdZeroErr = TestHelper.generateDoubleArray((int)71, (int)1010553104);
        double[] clkhiAmin = TestHelper.generateDoubleArray((int)71, (int)-629903390);
        double[] clkhiQmax = TestHelper.generateDoubleArray((int)71, (int)-790553270);
        double[] clkliAmin = TestHelper.generateDoubleArray((int)71, (int)1243602036);
        double[] clkliQmax = TestHelper.generateDoubleArray((int)71, (int)-835780481);
        double[] dac_clkhIMax = TestHelper.generateDoubleArray((int)71, (int)1361311330);
        double[] dac_clklIMax = TestHelper.generateDoubleArray((int)71, (int)921812236);
        double[] dac_pclkHighCal = TestHelper.generateDoubleArray((int)71, (int)1463152323);
        double[] dac_pclkHighTestV = TestHelper.generateDoubleArray((int)71, (int)-239358311);
        double[] dac_pclkHighTol = TestHelper.generateDoubleArray((int)71, (int)-736591581);
        double[] dac_pclkHighValueErr = TestHelper.generateDoubleArray((int)71, (int)-1784553935);
        double[] dac_pclkHighZeroErr = TestHelper.generateDoubleArray((int)71, (int)1713126256);
        double[] dac_pclkLowCal = TestHelper.generateDoubleArray((int)71, (int)1822023745);
        double[] dac_pclkLowTestV = TestHelper.generateDoubleArray((int)71, (int)-535273283);
        double[] dac_pclkLowTol = TestHelper.generateDoubleArray((int)71, (int)-1438529058);
        double[] dac_pclkLowValueErr = TestHelper.generateDoubleArray((int)71, (int)-1094235124);
        double[] dac_pclkLowZeroErr = TestHelper.generateDoubleArray((int)71, (int)1450478848);
        double[] dac_rgHighCal = TestHelper.generateDoubleArray((int)71, (int)-1261228602);
        double[] dac_rgHighTestV = TestHelper.generateDoubleArray((int)71, (int)18478989);
        double[] dac_rgHighTol = TestHelper.generateDoubleArray((int)71, (int)-945678968);
        double[] dac_rgHighValueErr = TestHelper.generateDoubleArray((int)71, (int)-114755728);
        double[] dac_rgHighZeroErr = TestHelper.generateDoubleArray((int)71, (int)-311147673);
        double[] dac_rgLowCal = TestHelper.generateDoubleArray((int)71, (int)-564513264);
        double[] dac_rgLowTestV = TestHelper.generateDoubleArray((int)71, (int)1508640487);
        double[] dac_rgLowTol = TestHelper.generateDoubleArray((int)71, (int)-470243363);
        double[] dac_rgLowValueErr = TestHelper.generateDoubleArray((int)71, (int)-615919827);
        double[] dac_rgLowZeroErr = TestHelper.generateDoubleArray((int)71, (int)1591992533);
        double[] dac_sclkHighCal = TestHelper.generateDoubleArray((int)71, (int)1985793845);
        double[] dac_sclkHighTestV = TestHelper.generateDoubleArray((int)71, (int)235793704);
        double[] dac_sclkHighTol = TestHelper.generateDoubleArray((int)71, (int)-835941860);
        double[] dac_sclkHighValueErr = TestHelper.generateDoubleArray((int)71, (int)1932240234);
        double[] dac_sclkHighZeroErr = TestHelper.generateDoubleArray((int)71, (int)2087325367);
        double[] dac_sclkLowCal = TestHelper.generateDoubleArray((int)71, (int)1884096494);
        double[] dac_sclkLowTestV = TestHelper.generateDoubleArray((int)71, (int)2088857353);
        double[] dac_sclkLowTol = TestHelper.generateDoubleArray((int)71, (int)-1624007357);
        double[] dac_sclkLowValueErr = TestHelper.generateDoubleArray((int)71, (int)1402627939);
        double[] dac_sclkLowZeroErr = TestHelper.generateDoubleArray((int)71, (int)23749610);
        String location = "x";
        double[] maxDelta = TestHelper.generateDoubleArray((int)71, (int)-1122721646);
        double[] maxStep = TestHelper.generateDoubleArray((int)71, (int)199263127);
        double[] minTol = TestHelper.generateDoubleArray((int)71, (int)-2038628892);
        int[] nPowerOnPub = TestHelper.generateIntArray((int)71, (int)925560920);
        double[] odiAmin = TestHelper.generateDoubleArray((int)71, (int)-1420766733);
        double[] odiQmax = TestHelper.generateDoubleArray((int)71, (int)-504987111);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_RaftsPowerConfigurationEvent(version, bias0_gdCal, bias0_gdTestVolts, bias0_gdTol, bias0_gdValueErr, bias0_gdZeroErr, bias0_odCal, bias0_odIMax, bias0_odTol, bias0_odZeroErr, bias0_ogCal, bias0_ogTestVolts, bias0_ogTol, bias0_ogValueErr, bias0_ogZeroErr, bias0_rdCal, bias0_rdTestVolts, bias0_rdTol, bias0_rdValueErr, bias0_rdZeroErr, bias1_gdCal, bias1_gdTestVolts, bias1_gdTol, bias1_gdValueErr, bias1_gdZeroErr, bias1_odCal, bias1_odIMax, bias1_odTol, bias1_odZeroErr, bias1_ogCal, bias1_ogTestVolts, bias1_ogTol, bias1_ogValueErr, bias1_ogZeroErr, bias1_rdCal, bias1_rdTestVolts, bias1_rdTol, bias1_rdValueErr, bias1_rdZeroErr, bias2_gdCal, bias2_gdTestVolts, bias2_gdTol, bias2_gdValueErr, bias2_gdZeroErr, bias2_odCal, bias2_odIMax, bias2_odTol, bias2_odZeroErr, bias2_ogCal, bias2_ogTestVolts, bias2_ogTol, bias2_ogValueErr, bias2_ogZeroErr, bias2_rdCal, bias2_rdTestVolts, bias2_rdTol, bias2_rdValueErr, bias2_rdZeroErr, clkhiAmin, clkhiQmax, clkliAmin, clkliQmax, dac_clkhIMax, dac_clklIMax, dac_pclkHighCal, dac_pclkHighTestV, dac_pclkHighTol, dac_pclkHighValueErr, dac_pclkHighZeroErr, dac_pclkLowCal, dac_pclkLowTestV, dac_pclkLowTol, dac_pclkLowValueErr, dac_pclkLowZeroErr, dac_rgHighCal, dac_rgHighTestV, dac_rgHighTol, dac_rgHighValueErr, dac_rgHighZeroErr, dac_rgLowCal, dac_rgLowTestV, dac_rgLowTol, dac_rgLowValueErr, dac_rgLowZeroErr, dac_sclkHighCal, dac_sclkHighTestV, dac_sclkHighTol, dac_sclkHighValueErr, dac_sclkHighZeroErr, dac_sclkLowCal, dac_sclkLowTestV, dac_sclkLowTol, dac_sclkLowValueErr, dac_sclkLowZeroErr, location, maxDelta, maxStep, minTol, nPowerOnPub, odiAmin, odiQmax));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_RaftsPowerConfigurationEvent));
        Focal_plane_Reb_RaftsPowerConfigurationEvent item_ = (Focal_plane_Reb_RaftsPowerConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])bias0_gdCal, (double[])item_.getBias0_gdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdTestVolts, (double[])item_.getBias0_gdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdTol, (double[])item_.getBias0_gdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdValueErr, (double[])item_.getBias0_gdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdZeroErr, (double[])item_.getBias0_gdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odCal, (double[])item_.getBias0_odCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odIMax, (double[])item_.getBias0_odIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odTol, (double[])item_.getBias0_odTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odZeroErr, (double[])item_.getBias0_odZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogCal, (double[])item_.getBias0_ogCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogTestVolts, (double[])item_.getBias0_ogTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogTol, (double[])item_.getBias0_ogTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogValueErr, (double[])item_.getBias0_ogValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogZeroErr, (double[])item_.getBias0_ogZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdCal, (double[])item_.getBias0_rdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdTestVolts, (double[])item_.getBias0_rdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdTol, (double[])item_.getBias0_rdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdValueErr, (double[])item_.getBias0_rdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdZeroErr, (double[])item_.getBias0_rdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdCal, (double[])item_.getBias1_gdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdTestVolts, (double[])item_.getBias1_gdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdTol, (double[])item_.getBias1_gdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdValueErr, (double[])item_.getBias1_gdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdZeroErr, (double[])item_.getBias1_gdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odCal, (double[])item_.getBias1_odCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odIMax, (double[])item_.getBias1_odIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odTol, (double[])item_.getBias1_odTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odZeroErr, (double[])item_.getBias1_odZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogCal, (double[])item_.getBias1_ogCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogTestVolts, (double[])item_.getBias1_ogTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogTol, (double[])item_.getBias1_ogTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogValueErr, (double[])item_.getBias1_ogValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogZeroErr, (double[])item_.getBias1_ogZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdCal, (double[])item_.getBias1_rdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdTestVolts, (double[])item_.getBias1_rdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdTol, (double[])item_.getBias1_rdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdValueErr, (double[])item_.getBias1_rdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdZeroErr, (double[])item_.getBias1_rdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdCal, (double[])item_.getBias2_gdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdTestVolts, (double[])item_.getBias2_gdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdTol, (double[])item_.getBias2_gdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdValueErr, (double[])item_.getBias2_gdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdZeroErr, (double[])item_.getBias2_gdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odCal, (double[])item_.getBias2_odCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odIMax, (double[])item_.getBias2_odIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odTol, (double[])item_.getBias2_odTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odZeroErr, (double[])item_.getBias2_odZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogCal, (double[])item_.getBias2_ogCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogTestVolts, (double[])item_.getBias2_ogTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogTol, (double[])item_.getBias2_ogTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogValueErr, (double[])item_.getBias2_ogValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogZeroErr, (double[])item_.getBias2_ogZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdCal, (double[])item_.getBias2_rdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdTestVolts, (double[])item_.getBias2_rdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdTol, (double[])item_.getBias2_rdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdValueErr, (double[])item_.getBias2_rdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdZeroErr, (double[])item_.getBias2_rdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhiAmin, (double[])item_.getClkhiAmin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhiQmax, (double[])item_.getClkhiQmax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkliAmin, (double[])item_.getClkliAmin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkliQmax, (double[])item_.getClkliQmax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_clkhIMax, (double[])item_.getDac_clkhIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_clklIMax, (double[])item_.getDac_clklIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighCal, (double[])item_.getDac_pclkHighCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighTestV, (double[])item_.getDac_pclkHighTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighTol, (double[])item_.getDac_pclkHighTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighValueErr, (double[])item_.getDac_pclkHighValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighZeroErr, (double[])item_.getDac_pclkHighZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowCal, (double[])item_.getDac_pclkLowCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowTestV, (double[])item_.getDac_pclkLowTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowTol, (double[])item_.getDac_pclkLowTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowValueErr, (double[])item_.getDac_pclkLowValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowZeroErr, (double[])item_.getDac_pclkLowZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighCal, (double[])item_.getDac_rgHighCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighTestV, (double[])item_.getDac_rgHighTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighTol, (double[])item_.getDac_rgHighTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighValueErr, (double[])item_.getDac_rgHighValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighZeroErr, (double[])item_.getDac_rgHighZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowCal, (double[])item_.getDac_rgLowCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowTestV, (double[])item_.getDac_rgLowTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowTol, (double[])item_.getDac_rgLowTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowValueErr, (double[])item_.getDac_rgLowValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowZeroErr, (double[])item_.getDac_rgLowZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighCal, (double[])item_.getDac_sclkHighCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighTestV, (double[])item_.getDac_sclkHighTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighTol, (double[])item_.getDac_sclkHighTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighValueErr, (double[])item_.getDac_sclkHighValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighZeroErr, (double[])item_.getDac_sclkHighZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowCal, (double[])item_.getDac_sclkLowCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowTestV, (double[])item_.getDac_sclkLowTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowTol, (double[])item_.getDac_sclkLowTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowValueErr, (double[])item_.getDac_sclkLowValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowZeroErr, (double[])item_.getDac_sclkLowZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])maxDelta, (double[])item_.getMaxDelta(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])maxStep, (double[])item_.getMaxStep(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])minTol, (double[])item_.getMinTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((int[])nPowerOnPub, (int[])item_.getNPowerOnPub());
        Assert.assertArrayEquals((double[])odiAmin, (double[])item_.getOdiAmin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odiQmax, (double[])item_.getOdiQmax(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Reb_timersConfigurationEvent() throws Exception {
        String version = "";
        String location = "";
        long[] periodictasks_monitor_check_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-1581463101);
        long[] periodictasks_monitor_publish_aspicTemp_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-1707978915);
        long[] periodictasks_monitor_publish_biasVolt_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)2063325593);
        long[] periodictasks_monitor_publish_boardPower_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)1859101270);
        long[] periodictasks_monitor_publish_ccdCurrent_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-846978502);
        long[] periodictasks_monitor_publish_crVolt_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-1084224898);
        long[] periodictasks_monitor_publish_rebTemp_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)749546084);
        long[] periodictasks_monitor_publish_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-2067684473);
        long[] periodictasks_monitor_update_aspicTemp_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-2034255288);
        long[] periodictasks_monitor_update_biasVolt_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)1435115114);
        long[] periodictasks_monitor_update_boardPower_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-401431594);
        long[] periodictasks_monitor_update_ccdCurrent_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-925510460);
        long[] periodictasks_monitor_update_crVolt_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-313031295);
        long[] periodictasks_monitor_update_rebTemp_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-734788411);
        long[] periodictasks_monitor_update_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)1715371921);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_timersConfigurationEvent(version, location, periodictasks_monitor_check_taskPeriodMillis, periodictasks_monitor_publish_aspicTemp_taskPeriodMillis, periodictasks_monitor_publish_biasVolt_taskPeriodMillis, periodictasks_monitor_publish_boardPower_taskPeriodMillis, periodictasks_monitor_publish_ccdCurrent_taskPeriodMillis, periodictasks_monitor_publish_crVolt_taskPeriodMillis, periodictasks_monitor_publish_rebTemp_taskPeriodMillis, periodictasks_monitor_publish_taskPeriodMillis, periodictasks_monitor_update_aspicTemp_taskPeriodMillis, periodictasks_monitor_update_biasVolt_taskPeriodMillis, periodictasks_monitor_update_boardPower_taskPeriodMillis, periodictasks_monitor_update_ccdCurrent_taskPeriodMillis, periodictasks_monitor_update_crVolt_taskPeriodMillis, periodictasks_monitor_update_rebTemp_taskPeriodMillis, periodictasks_monitor_update_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_timersConfigurationEvent));
        Focal_plane_Reb_timersConfigurationEvent item_ = (Focal_plane_Reb_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((long[])periodictasks_monitor_check_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_check_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_aspicTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_aspicTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_biasVolt_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_biasVolt_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_boardPower_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_boardPower_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_ccdCurrent_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_ccdCurrent_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_crVolt_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_crVolt_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_rebTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_rebTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_aspicTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_aspicTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_biasVolt_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_biasVolt_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_boardPower_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_boardPower_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_ccdCurrent_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_ccdCurrent_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_crVolt_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_crVolt_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_rebTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_rebTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_taskPeriodMillis());
    }

    @Test
    public void sendReceiveFocal_plane_Segment_LimitsConfigurationEvent() throws Exception {
        String version = "k";
        double[] i_warnHi = TestHelper.generateDoubleArray((int)3024, (int)1482937101);
        double[] i_warnLo = TestHelper.generateDoubleArray((int)3024, (int)1637378209);
        double[] i_limitHi = TestHelper.generateDoubleArray((int)3024, (int)-995072274);
        double[] i_limitLo = TestHelper.generateDoubleArray((int)3024, (int)575868291);
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Segment_LimitsConfigurationEvent(version, i_warnHi, i_warnLo, i_limitHi, i_limitLo, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Segment_LimitsConfigurationEvent));
        Focal_plane_Segment_LimitsConfigurationEvent item_ = (Focal_plane_Segment_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])i_warnHi, (double[])item_.getI_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])i_warnLo, (double[])item_.getI_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])i_limitHi, (double[])item_.getI_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])i_limitLo, (double[])item_.getI_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFocal_plane_SequencerConfig_DAQConfigurationEvent() throws Exception {
        String version = "";
        String daqFolder = "x";
        String daqPartition = "";
        boolean emulatedDAQ = true;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_SequencerConfig_DAQConfigurationEvent(version, daqFolder, daqPartition, emulatedDAQ));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SequencerConfig_DAQConfigurationEvent));
        Focal_plane_SequencerConfig_DAQConfigurationEvent item_ = (Focal_plane_SequencerConfig_DAQConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)daqPartition, (Object)item_.getDaqPartition());
        Assert.assertEquals((Object)emulatedDAQ, (Object)item_.isEmulatedDAQ());
    }

    @Test
    public void sendReceiveFocal_plane_SequencerConfig_SequencerConfigurationEvent() throws Exception {
        String version = "";
        String clearCountParameter = "q";
        String clearMain = "";
        String idleFlushMain = "";
        long idleFlushTimeout = 936L;
        String integrateMain = "l";
        String metaDataRegisters = "u";
        int overCols = 756;
        int overRows = 876;
        int postCols = 722;
        int postRows = 693;
        int preCols = 598;
        int preRows = 79;
        String pseudoReadMain = "v";
        int readCols = 960;
        int readCols2 = 12;
        String readMain = "q";
        int readRows = 817;
        String rowShiftForwardMain = "";
        String rowShiftReverseMain = "";
        boolean scanMode = true;
        String sequencer = "";
        String sequencerChecksums = "c";
        String shiftCountParameter = "";
        boolean stepAfterIntegrate = false;
        int transparentMode = 743;
        int underCols = 285;
        boolean useParallelRegisters = false;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_SequencerConfig_SequencerConfigurationEvent(version, clearCountParameter, clearMain, idleFlushMain, idleFlushTimeout, integrateMain, metaDataRegisters, overCols, overRows, postCols, postRows, preCols, preRows, pseudoReadMain, readCols, readCols2, readMain, readRows, rowShiftForwardMain, rowShiftReverseMain, scanMode, sequencer, sequencerChecksums, shiftCountParameter, stepAfterIntegrate, transparentMode, underCols, useParallelRegisters));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SequencerConfig_SequencerConfigurationEvent));
        Focal_plane_SequencerConfig_SequencerConfigurationEvent item_ = (Focal_plane_SequencerConfig_SequencerConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)clearCountParameter, (Object)item_.getClearCountParameter());
        Assert.assertEquals((Object)clearMain, (Object)item_.getClearMain());
        Assert.assertEquals((Object)idleFlushMain, (Object)item_.getIdleFlushMain());
        Assert.assertEquals((long)idleFlushTimeout, (long)item_.getIdleFlushTimeout());
        Assert.assertEquals((Object)integrateMain, (Object)item_.getIntegrateMain());
        Assert.assertEquals((Object)metaDataRegisters, (Object)item_.getMetaDataRegisters());
        Assert.assertEquals((long)overCols, (long)item_.getOverCols());
        Assert.assertEquals((long)overRows, (long)item_.getOverRows());
        Assert.assertEquals((long)postCols, (long)item_.getPostCols());
        Assert.assertEquals((long)postRows, (long)item_.getPostRows());
        Assert.assertEquals((long)preCols, (long)item_.getPreCols());
        Assert.assertEquals((long)preRows, (long)item_.getPreRows());
        Assert.assertEquals((Object)pseudoReadMain, (Object)item_.getPseudoReadMain());
        Assert.assertEquals((long)readCols, (long)item_.getReadCols());
        Assert.assertEquals((long)readCols2, (long)item_.getReadCols2());
        Assert.assertEquals((Object)readMain, (Object)item_.getReadMain());
        Assert.assertEquals((long)readRows, (long)item_.getReadRows());
        Assert.assertEquals((Object)rowShiftForwardMain, (Object)item_.getRowShiftForwardMain());
        Assert.assertEquals((Object)rowShiftReverseMain, (Object)item_.getRowShiftReverseMain());
        Assert.assertEquals((Object)scanMode, (Object)item_.isScanMode());
        Assert.assertEquals((Object)sequencer, (Object)item_.getSequencer());
        Assert.assertEquals((Object)sequencerChecksums, (Object)item_.getSequencerChecksums());
        Assert.assertEquals((Object)shiftCountParameter, (Object)item_.getShiftCountParameter());
        Assert.assertEquals((Object)stepAfterIntegrate, (Object)item_.isStepAfterIntegrate());
        Assert.assertEquals((long)transparentMode, (long)item_.getTransparentMode());
        Assert.assertEquals((long)underCols, (long)item_.getUnderCols());
        Assert.assertEquals((Object)useParallelRegisters, (Object)item_.isUseParallelRegisters());
    }

    @Test
    public void sendReceiveFocal_plane_WebHooksConfig_VisualizationConfigurationEvent() throws Exception {
        String version = "";
        String webHooks = "x";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_WebHooksConfig_VisualizationConfigurationEvent(version, webHooks));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_WebHooksConfig_VisualizationConfigurationEvent));
        Focal_plane_WebHooksConfig_VisualizationConfigurationEvent item_ = (Focal_plane_WebHooksConfig_VisualizationConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)webHooks, (Object)item_.getWebHooks());
    }

    @Test
    public void sendReceiveImage_handling_ImageHandler_DAQConfigurationEvent() throws Exception {
        String version = "";
        int imagehandlingconfig_badPixelAlarmLevel = 229;
        int imagehandlingconfig_badPixelHighThreshold = 857;
        int imagehandlingconfig_badPixelLowThreshold = 153;
        int imagehandlingconfig_badPixelWarningLevel = 346;
        boolean imagehandlingconfig_checkForBadPixels = true;
        String imagehandlingconfig_daqFolder = "i";
        String imagehandlingconfig_daqPartition = "";
        int imagehandlingconfig_daqThreads = 255;
        String imagehandlingconfig_locations = "u";
        boolean imagehandlingconfig_useStreaming = true;
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_ImageHandler_DAQConfigurationEvent(version, imagehandlingconfig_badPixelAlarmLevel, imagehandlingconfig_badPixelHighThreshold, imagehandlingconfig_badPixelLowThreshold, imagehandlingconfig_badPixelWarningLevel, imagehandlingconfig_checkForBadPixels, imagehandlingconfig_daqFolder, imagehandlingconfig_daqPartition, imagehandlingconfig_daqThreads, imagehandlingconfig_locations, imagehandlingconfig_useStreaming));
        Assert.assertTrue((boolean)(item instanceof Image_handling_ImageHandler_DAQConfigurationEvent));
        Image_handling_ImageHandler_DAQConfigurationEvent item_ = (Image_handling_ImageHandler_DAQConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)imagehandlingconfig_badPixelAlarmLevel, (long)item_.getImagehandlingconfig_badPixelAlarmLevel());
        Assert.assertEquals((long)imagehandlingconfig_badPixelHighThreshold, (long)item_.getImagehandlingconfig_badPixelHighThreshold());
        Assert.assertEquals((long)imagehandlingconfig_badPixelLowThreshold, (long)item_.getImagehandlingconfig_badPixelLowThreshold());
        Assert.assertEquals((long)imagehandlingconfig_badPixelWarningLevel, (long)item_.getImagehandlingconfig_badPixelWarningLevel());
        Assert.assertEquals((Object)imagehandlingconfig_checkForBadPixels, (Object)item_.isImagehandlingconfig_checkForBadPixels());
        Assert.assertEquals((Object)imagehandlingconfig_daqFolder, (Object)item_.getImagehandlingconfig_daqFolder());
        Assert.assertEquals((Object)imagehandlingconfig_daqPartition, (Object)item_.getImagehandlingconfig_daqPartition());
        Assert.assertEquals((long)imagehandlingconfig_daqThreads, (long)item_.getImagehandlingconfig_daqThreads());
        Assert.assertEquals((Object)imagehandlingconfig_locations, (Object)item_.getImagehandlingconfig_locations());
        Assert.assertEquals((Object)imagehandlingconfig_useStreaming, (Object)item_.isImagehandlingconfig_useStreaming());
    }

    @Test
    public void sendReceiveImage_handling_ImageHandler_FitsHandlingConfigurationEvent() throws Exception {
        String version = "";
        boolean imagehandlingconfig_FITSAutoSave = true;
        String imagehandlingconfig_FITSDirectoryPattern = "z";
        String imagehandlingconfig_FITSFilePattern = "";
        String imagehandlingconfig_FITSRootDirectory = "j";
        String imagehandlingconfig_subsystemsToClearOnNewRun = "p";
        String imagehandlingconfig_tempFileRelativeLocation = "";
        boolean imagehandlingconfig_useTempFile = true;
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_ImageHandler_FitsHandlingConfigurationEvent(version, imagehandlingconfig_FITSAutoSave, imagehandlingconfig_FITSDirectoryPattern, imagehandlingconfig_FITSFilePattern, imagehandlingconfig_FITSRootDirectory, imagehandlingconfig_subsystemsToClearOnNewRun, imagehandlingconfig_tempFileRelativeLocation, imagehandlingconfig_useTempFile));
        Assert.assertTrue((boolean)(item instanceof Image_handling_ImageHandler_FitsHandlingConfigurationEvent));
        Image_handling_ImageHandler_FitsHandlingConfigurationEvent item_ = (Image_handling_ImageHandler_FitsHandlingConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)imagehandlingconfig_FITSAutoSave, (Object)item_.isImagehandlingconfig_FITSAutoSave());
        Assert.assertEquals((Object)imagehandlingconfig_FITSDirectoryPattern, (Object)item_.getImagehandlingconfig_FITSDirectoryPattern());
        Assert.assertEquals((Object)imagehandlingconfig_FITSFilePattern, (Object)item_.getImagehandlingconfig_FITSFilePattern());
        Assert.assertEquals((Object)imagehandlingconfig_FITSRootDirectory, (Object)item_.getImagehandlingconfig_FITSRootDirectory());
        Assert.assertEquals((Object)imagehandlingconfig_subsystemsToClearOnNewRun, (Object)item_.getImagehandlingconfig_subsystemsToClearOnNewRun());
        Assert.assertEquals((Object)imagehandlingconfig_tempFileRelativeLocation, (Object)item_.getImagehandlingconfig_tempFileRelativeLocation());
        Assert.assertEquals((Object)imagehandlingconfig_useTempFile, (Object)item_.isImagehandlingconfig_useTempFile());
    }

    @Test
    public void sendReceiveImage_handling_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "b";
        int schedulers_default_nTasks = 427;
        int schedulers_default_nThreads = 634;
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads));
        Assert.assertTrue((boolean)(item instanceof Image_handling_PeriodicTasks_GeneralConfigurationEvent));
        Image_handling_PeriodicTasks_GeneralConfigurationEvent item_ = (Image_handling_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
    }

    @Test
    public void sendReceiveImage_handling_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "";
        long agentmonitorservice_taskPeriodMillis = 225L;
        long heartbeat_taskPeriodMillis = 184L;
        long runtimeinfo_taskPeriodMillis = 871L;
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Image_handling_PeriodicTasks_timersConfigurationEvent));
        Image_handling_PeriodicTasks_timersConfigurationEvent item_ = (Image_handling_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveImage_handling_Reb_FitsHandlingConfigurationEvent() throws Exception {
        String version = "b";
        boolean[] enabled = new boolean[]{false, true, false, false, false, true, false, true};
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_Reb_FitsHandlingConfigurationEvent(version, enabled, location));
        Assert.assertTrue((boolean)(item instanceof Image_handling_Reb_FitsHandlingConfigurationEvent));
        Image_handling_Reb_FitsHandlingConfigurationEvent item_ = (Image_handling_Reb_FitsHandlingConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((boolean[])enabled, (boolean[])item_.getEnabled());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveImage_handling_Reb_GeneralConfigurationEvent() throws Exception {
        String version = "m";
        String fitsservice_headerFilesList = "f";
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_Reb_GeneralConfigurationEvent(version, fitsservice_headerFilesList, location));
        Assert.assertTrue((boolean)(item instanceof Image_handling_Reb_GeneralConfigurationEvent));
        Image_handling_Reb_GeneralConfigurationEvent item_ = (Image_handling_Reb_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)fitsservice_headerFilesList, (Object)item_.getFitsservice_headerFilesList());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveSummaryStatusEvent() throws Exception {
        double timestampStatusChanged = 0.6930426955223083;
        String subsystems = "a";
        String subsystemState = "j";
        String subsystemColor = "";
        String additionalInfo = "";
        String drillDownLinks = "";
        SALEvent item = this.testSendReceive((SALEvent)new SummaryStatusEvent(timestampStatusChanged, subsystems, subsystemState, subsystemColor, additionalInfo, drillDownLinks));
        Assert.assertTrue((boolean)(item instanceof SummaryStatusEvent));
        SummaryStatusEvent item_ = (SummaryStatusEvent)item;
        Assert.assertEquals((double)timestampStatusChanged, (double)item_.getTimestampStatusChanged(), (double)1.0E-6f);
        Assert.assertEquals((Object)subsystems, (Object)item_.getSubsystems());
        Assert.assertEquals((Object)subsystemState, (Object)item_.getSubsystemState());
        Assert.assertEquals((Object)subsystemColor, (Object)item_.getSubsystemColor());
        Assert.assertEquals((Object)additionalInfo, (Object)item_.getAdditionalInfo());
        Assert.assertEquals((Object)drillDownLinks, (Object)item_.getDrillDownLinks());
    }

    @Test
    public void sendReceiveConfigurationAppliedEvent() throws Exception {
        String configurations = "";
        String version = "g";
        String url = "";
        String schemaVersion = "";
        String otherInfo = "u";
        SALEvent item = this.testSendReceive((SALEvent)new ConfigurationAppliedEvent(configurations, version, url, schemaVersion, otherInfo));
        Assert.assertTrue((boolean)(item instanceof ConfigurationAppliedEvent));
        ConfigurationAppliedEvent item_ = (ConfigurationAppliedEvent)item;
        Assert.assertEquals((Object)configurations, (Object)item_.getConfigurations());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)url, (Object)item_.getUrl());
        Assert.assertEquals((Object)schemaVersion, (Object)item_.getSchemaVersion());
        Assert.assertEquals((Object)otherInfo, (Object)item_.getOtherInfo());
    }

    @Test
    public void sendReceiveConfigurationsAvailableEvent() throws Exception {
        String overrides = "n";
        String version = "";
        String url = "l";
        String schemaVersion = "";
        SALEvent item = this.testSendReceive((SALEvent)new ConfigurationsAvailableEvent(overrides, version, url, schemaVersion));
        Assert.assertTrue((boolean)(item instanceof ConfigurationsAvailableEvent));
        ConfigurationsAvailableEvent item_ = (ConfigurationsAvailableEvent)item;
        Assert.assertEquals((Object)overrides, (Object)item_.getOverrides());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)url, (Object)item_.getUrl());
        Assert.assertEquals((Object)schemaVersion, (Object)item_.getSchemaVersion());
    }

    @Test
    public void sendReceiveErrorCodeEvent() throws Exception {
        int errorCode = 851;
        String errorReport = "";
        String traceback = "k";
        SALEvent item = this.testSendReceive((SALEvent)new ErrorCodeEvent(errorCode, errorReport, traceback));
        Assert.assertTrue((boolean)(item instanceof ErrorCodeEvent));
        ErrorCodeEvent item_ = (ErrorCodeEvent)item;
        Assert.assertEquals((long)errorCode, (long)item_.getErrorCode());
        Assert.assertEquals((Object)errorReport, (Object)item_.getErrorReport());
        Assert.assertEquals((Object)traceback, (Object)item_.getTraceback());
    }

    @Test
    public void sendReceiveLogLevelEvent() throws Exception {
        int level = 924;
        String subsystem = "k";
        SALEvent item = this.testSendReceive((SALEvent)new LogLevelEvent(level, subsystem));
        Assert.assertTrue((boolean)(item instanceof LogLevelEvent));
        LogLevelEvent item_ = (LogLevelEvent)item;
        Assert.assertEquals((long)level, (long)item_.getLevel());
        Assert.assertEquals((Object)subsystem, (Object)item_.getSubsystem());
    }

    @Test
    public void sendReceiveLogMessageEvent() throws Exception {
        String name = "t";
        int level = 834;
        String message = "e";
        String traceback = "b";
        String filePath = "";
        String functionName = "";
        int lineNumber = 849;
        int process = 684;
        double timestamp = 0.725014f;
        SALEvent item = this.testSendReceive((SALEvent)new LogMessageEvent(name, level, message, traceback, filePath, functionName, lineNumber, process, timestamp));
        Assert.assertTrue((boolean)(item instanceof LogMessageEvent));
        LogMessageEvent item_ = (LogMessageEvent)item;
        Assert.assertEquals((Object)name, (Object)item_.getName());
        Assert.assertEquals((long)level, (long)item_.getLevel());
        Assert.assertEquals((Object)message, (Object)item_.getMessage());
        Assert.assertEquals((Object)traceback, (Object)item_.getTraceback());
        Assert.assertEquals((Object)filePath, (Object)item_.getFilePath());
        Assert.assertEquals((Object)functionName, (Object)item_.getFunctionName());
        Assert.assertEquals((long)lineNumber, (long)item_.getLineNumber());
        Assert.assertEquals((long)process, (long)item_.getProcess());
        Assert.assertEquals((double)timestamp, (double)item_.getTimestamp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveSimulationModeEvent() throws Exception {
        int mode = 637;
        SALEvent item = this.testSendReceive((SALEvent)new SimulationModeEvent(mode));
        Assert.assertTrue((boolean)(item instanceof SimulationModeEvent));
        SimulationModeEvent item_ = (SimulationModeEvent)item;
        Assert.assertEquals((long)mode, (long)item_.getMode());
    }

    @Test
    public void sendReceiveSoftwareVersionsEvent() throws Exception {
        String salVersion = "vzdjlmmfgbwnevlxwssmvgkyhmaeggadfjzvqlkwikumaqtksyswzlqqqooynumkuqwwprxbzvezlwjuviqrlfocphdwqyejsuflbcjgnkcfemjbnyzebsgnkguovfsplmrhvdcpmujhsx";
        String xmlVersion = "jkhissokivbkevvoxddtcbiy";
        String openSpliceVersion = "yrgzbcfehvwltkvlivlbxtjpslkksssatroxaolzavvjexzmouasrxkpjvpmbbgukwyimiadxlgdgdicvqsreonexfodgqgkbpykefiileskcykhdjrotmfigvujadcrzgvoiqdaesjnsdplbhrqgseliyccihubuyshqwnviuomvcitfmduyusijaprpcoegzmvmyaocdadgpicpclfqpgwoiytcrbrkmqxqawk";
        String cscVersion = "ngpcnxumpyhdyudjydvbdhaibcxbrcrmcfhemofgplyrebraetrypwaetlowzwqquauavtgpkeuhoehwozvoctducaqdvobavcugenkgqglonkbfouescjbxkkybdfuuptvxksbvgnbsiuhdsnzpdmzljkvsaqcygsqgdhjqqzhwvs";
        String subsystemVersions = "q";
        SALEvent item = this.testSendReceive((SALEvent)new SoftwareVersionsEvent(salVersion, xmlVersion, openSpliceVersion, cscVersion, subsystemVersions));
        Assert.assertTrue((boolean)(item instanceof SoftwareVersionsEvent));
        SoftwareVersionsEvent item_ = (SoftwareVersionsEvent)item;
        Assert.assertEquals((Object)salVersion, (Object)item_.getSalVersion());
        Assert.assertEquals((Object)xmlVersion, (Object)item_.getXmlVersion());
        Assert.assertEquals((Object)openSpliceVersion, (Object)item_.getOpenSpliceVersion());
        Assert.assertEquals((Object)cscVersion, (Object)item_.getCscVersion());
        Assert.assertEquals((Object)subsystemVersions, (Object)item_.getSubsystemVersions());
    }

    @Test
    public void sendReceiveHeartbeatEvent() throws Exception {
        boolean heartbeat = true;
        SALEvent item = this.testSendReceive((SALEvent)new HeartbeatEvent(heartbeat));
        Assert.assertTrue((boolean)(item instanceof HeartbeatEvent));
        HeartbeatEvent item_ = (HeartbeatEvent)item;
        Assert.assertEquals((Object)heartbeat, (Object)item_.isHeartbeat());
    }

    @Test
    public void sendReceiveAuthListEvent() throws Exception {
        String authorizedUsers = "w";
        String nonAuthorizedCSCs = "o";
        SALEvent item = this.testSendReceive((SALEvent)new AuthListEvent(authorizedUsers, nonAuthorizedCSCs));
        Assert.assertTrue((boolean)(item instanceof AuthListEvent));
        AuthListEvent item_ = (AuthListEvent)item;
        Assert.assertEquals((Object)authorizedUsers, (Object)item_.getAuthorizedUsers());
        Assert.assertEquals((Object)nonAuthorizedCSCs, (Object)item_.getNonAuthorizedCSCs());
    }

    @Test
    public void sendReceiveLargeFileObjectAvailableEvent() throws Exception {
        String url = "pukmxdxtrvxykoitncbfltptvbruchlykdvtdnxzywnyzcarxdricfmvqdfxagydtmtcnbfszoovjyoyhxfardtorzjhfwovmfgefkqkacdjpstuilniuaqghvjtksxydxzkaqnkqzpvmpgqtoajroqmocauqlopckkmjjpwqoisklcwcdpgpylwfbyskkldumvjhehpcqrzgwgqzhicdrkzsaqatbhsygid";
        String generator = "ssmwwmrbwlqgjrsjvlotdnzffgoaoxguglxnwdwvibmmocuqlputnfiqbfeqesohrwgpyudkptbubxbfyhebbtwehtqrithhhauzvvfpsbvegscukgebowbuzjcpfkqgrrndhoxndkiylfurmltxpmsfqwmijjhxqgvdvpoqjmohgbcxfjv";
        float version = 0.5569304f;
        int byteSize = 639;
        String checkSum = "keodohevreqneqxesdroxtffuhsngohdkcjtylhtxyshepvxetpowqdffnjeddrybspkvquxcezqjcraxumzlmgocmtlewjxtfsqjuuieknuupzleenvonikmtdgqgujbqwcwwlgiheeprkweuunrhwamatkkzsozxmkuatoqvfoyszhfhcsslaqnzerchmdxjvqxlyiwocwxqqawfwdxzzrzxegwtgxbn";
        String mimeType = "zicsjeoelaovmfecldxfrlbwzlxkmnzdnhkqlflpacnixyvprybymwfolrfrnctfdmuswffndpntazhceggbuqmscqjxwcwkarnnia";
        String id = "tlrsdaczyenxinnfqkaxyhybzpcqbzlicgwbudutrgtybdiuhkdvywrrossqihjxipsqrexbvelogobzaydfnqvagffotokmgvjlooqmwxlfdsvloauvebfigviasoerttadfnqhjsxhnnvjzxtpeafyxrsllzjclhdxxbabezfbrpjtackdzhvtetuyyhiwzcohoidqdbrzkskbchhxtiinhdlwwjagib";
        SALEvent item = this.testSendReceive((SALEvent)new LargeFileObjectAvailableEvent(url, generator, version, byteSize, checkSum, mimeType, id));
        Assert.assertTrue((boolean)(item instanceof LargeFileObjectAvailableEvent));
        LargeFileObjectAvailableEvent item_ = (LargeFileObjectAvailableEvent)item;
        Assert.assertEquals((Object)url, (Object)item_.getUrl());
        Assert.assertEquals((Object)generator, (Object)item_.getGenerator());
        Assert.assertEquals((float)version, (float)item_.getVersion(), (float)1.0E-6f);
        Assert.assertEquals((long)byteSize, (long)item_.getByteSize());
        Assert.assertEquals((Object)checkSum, (Object)item_.getCheckSum());
        Assert.assertEquals((Object)mimeType, (Object)item_.getMimeType());
        Assert.assertEquals((Object)id, (Object)item_.getId());
    }
}

