/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.TestHelper;
import org.lsst.sal.camera.SALCamera;
import org.lsst.sal.camera.telemetry.Daq_monitor_StoreTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_CcdTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebTotalPowerTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_SegmentTelemetry;
import org.lsst.sal.camera.telemetry.Hex_Cold1Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cold2Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo1Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo2Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo3Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo4Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo5Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo6Telemetry;
import org.lsst.sal.camera.telemetry.Quadbox_BFRTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_24VCTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_24VDTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_48VTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_5VTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_REB_Bulk_PSTelemetry;
import org.lsst.sal.camera.telemetry.Rebpower_RebTelemetry;
import org.lsst.sal.camera.telemetry.Rebpower_RebpsTelemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cold1Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cold2Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo1Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo2Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo3Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo4Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo5Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo6Telemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP1_ITelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP1_VTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP2_ITelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP2_VTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP3_ITelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP3_VTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP4_ITelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP4_VTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP5_ITelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP5_VTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP6_ITelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP6_VTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CryoVacTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_ForelineVacTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_Hex1VacTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_Hex2VacTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_TurboCurrentTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_TurboPowerTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_TurboPumpTempTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_TurboSpeedTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_TurboVacTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_TurboVoltageTelemetry;

public class TelemetrySendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = SALCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALTelemetry testSendReceive(SALTelemetry item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALTelemetry> future = executor.submit(() -> sal.getTelemetry(Duration.ofSeconds(10L)));
        try {
            sal.sendTelemetry(item);
            SALTelemetry sALTelemetry = future.get(10L, TimeUnit.SECONDS);
            return sALTelemetry;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveQuadbox_BFRTelemetry() throws Exception {
        double clean_5_24V_I = 0.9605495929718018;
        double dirty_24V_I = 0.2449181079864502;
        double dirty_28V_I = 0.8207762837409973;
        double dirty_48V_I = 0.004761755466461182;
        double heater_I = 0.46034324169158936;
        double protection_I = 0.16555821895599365;
        double rebps_0_2_I = 0.27150875329971313;
        double rebps_3_5_I = 0.656694f;
        double rebps_6_8_I = 0.10323494672775269;
        double rebps_9_12_I = 0.7840898036956787;
        double rebps_Spr_I = 0.42524755001068115;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_BFRTelemetry(clean_5_24V_I, dirty_24V_I, dirty_28V_I, dirty_48V_I, heater_I, protection_I, rebps_0_2_I, rebps_3_5_I, rebps_6_8_I, rebps_9_12_I, rebps_Spr_I));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFRTelemetry));
        Quadbox_BFRTelemetry item_ = (Quadbox_BFRTelemetry)item;
        Assert.assertEquals((double)clean_5_24V_I, (double)item_.getClean_5_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I, (double)item_.getDirty_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I, (double)item_.getDirty_28V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I, (double)item_.getDirty_48V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)heater_I, (double)item_.getHeater_I(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I, (double)item_.getProtection_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_2_I, (double)item_.getRebps_0_2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_3_5_I, (double)item_.getRebps_3_5_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_6_8_I, (double)item_.getRebps_6_8_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_9_12_I, (double)item_.getRebps_9_12_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_Spr_I, (double)item_.getRebps_Spr_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VCTelemetry() throws Exception {
        double n_24vc_Board_T = 0.7998093366622925;
        double n_24vc_FPGA_T = 0.37167954444885254;
        double n_24vc_Main_I = 0.3522723913192749;
        double n_24vc_Main_T = 0.3840165138244629;
        double n_24vc_Main_V = 0.2980801f;
        double body_Purge_I = 0.01173532f;
        double body_Purge_V = 0.5336012840270996;
        double bpu_Maq20_I = 0.7146857380867004;
        double bpu_Maq20_V = 0.4387451410293579;
        double fes_Shu_HCU_I = 0.7603783011436462;
        double fes_Shu_HCU_V = 0.9566890597343445;
        double gauges_I = 0.9117953777313232;
        double gauges_V = 0.2162758708000183;
        double ion_Pumps_I = 0.6132370829582214;
        double ion_Pumps_V = 0.7398157119750977;
        double pwr_Cry_HCU_I = 0.2990939f;
        double pwr_Cry_HCU_V = 0.6232790946960449;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VCTelemetry(n_24vc_Board_T, n_24vc_FPGA_T, n_24vc_Main_I, n_24vc_Main_T, n_24vc_Main_V, body_Purge_I, body_Purge_V, bpu_Maq20_I, bpu_Maq20_V, fes_Shu_HCU_I, fes_Shu_HCU_V, gauges_I, gauges_V, ion_Pumps_I, ion_Pumps_V, pwr_Cry_HCU_I, pwr_Cry_HCU_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VCTelemetry));
        Quadbox_PDU_24VCTelemetry item_ = (Quadbox_PDU_24VCTelemetry)item;
        Assert.assertEquals((double)n_24vc_Board_T, (double)item_.getN_24vc_Board_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_FPGA_T, (double)item_.getN_24vc_FPGA_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_I, (double)item_.getN_24vc_Main_I(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_T, (double)item_.getN_24vc_Main_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_V, (double)item_.getN_24vc_Main_V(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_I, (double)item_.getBody_Purge_I(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_V, (double)item_.getBody_Purge_V(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_I, (double)item_.getBpu_Maq20_I(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_V, (double)item_.getBpu_Maq20_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_I, (double)item_.getFes_Shu_HCU_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_V, (double)item_.getFes_Shu_HCU_V(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I, (double)item_.getGauges_I(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V, (double)item_.getGauges_V(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I, (double)item_.getIon_Pumps_I(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V, (double)item_.getIon_Pumps_V(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_I, (double)item_.getPwr_Cry_HCU_I(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_V, (double)item_.getPwr_Cry_HCU_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VDTelemetry() throws Exception {
        double n_24vd_Board_T = 0.23352354764938354;
        double n_24vd_FPGA_T = 0.0970807671546936;
        double n_24vd_Main_I = 0.9377151727676392;
        double n_24vd_Main_T = 0.7544595003128052;
        double n_24vd_Main_V = 0.524128f;
        double cryo_Turbo_I = 0.8414589166641235;
        double cryo_Turbo_V = 0.5860521793365479;
        double hex_Turbo_I = 0.003827214241027832;
        double hex_Turbo_V = 0.9386687278747559;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VDTelemetry(n_24vd_Board_T, n_24vd_FPGA_T, n_24vd_Main_I, n_24vd_Main_T, n_24vd_Main_V, cryo_Turbo_I, cryo_Turbo_V, hex_Turbo_I, hex_Turbo_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VDTelemetry));
        Quadbox_PDU_24VDTelemetry item_ = (Quadbox_PDU_24VDTelemetry)item;
        Assert.assertEquals((double)n_24vd_Board_T, (double)item_.getN_24vd_Board_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_FPGA_T, (double)item_.getN_24vd_FPGA_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_I, (double)item_.getN_24vd_Main_I(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_T, (double)item_.getN_24vd_Main_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_V, (double)item_.getN_24vd_Main_V(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I, (double)item_.getCryo_Turbo_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V, (double)item_.getCryo_Turbo_V(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_I, (double)item_.getHex_Turbo_I(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_V, (double)item_.getHex_Turbo_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_48VTelemetry() throws Exception {
        double n_48v_Board_T = 0.980285108089447;
        double n_48v_FPGA_T = 0.6908504962921143;
        double n_48v_Main_I = 0.927821f;
        double n_48v_Main_T = 0.46268075704574585;
        double n_48v_Main_V = 0.06930744647979736;
        double purge_Fan_I = 0.5201073288917542;
        double purge_Fan_V = 0.5370232462882996;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_48VTelemetry(n_48v_Board_T, n_48v_FPGA_T, n_48v_Main_I, n_48v_Main_T, n_48v_Main_V, purge_Fan_I, purge_Fan_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48VTelemetry));
        Quadbox_PDU_48VTelemetry item_ = (Quadbox_PDU_48VTelemetry)item;
        Assert.assertEquals((double)n_48v_Board_T, (double)item_.getN_48v_Board_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_FPGA_T, (double)item_.getN_48v_FPGA_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_I, (double)item_.getN_48v_Main_I(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_T, (double)item_.getN_48v_Main_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_V, (double)item_.getN_48v_Main_V(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_I, (double)item_.getPurge_Fan_I(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_V, (double)item_.getPurge_Fan_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_5VTelemetry() throws Exception {
        double otm_0_A_I = 0.47517257928848267;
        double otm_0_A_V = 0.3581211566925049;
        double otm_0_B_I = 0.1934003233909607;
        double otm_0_B_V = 0.9613986015319824;
        double otm_1_A_I = 0.7286586165428162;
        double otm_1_A_V = 0.4688141345977783;
        double otm_1_B_I = 0.6697930693626404;
        double otm_1_B_V = 0.9688416719436646;
        double otm_2_A_I = 0.2408191f;
        double otm_2_A_V = 0.7379346489906311;
        double otm_2_B_I = 0.9411064386367798;
        double otm_2_B_V = 0.5802518129348755;
        double otm_3_A_I = 0.9545862078666687;
        double otm_3_A_V = 0.896969199180603;
        double otm_3_B_I = 0.3008613f;
        double otm_3_B_V = 0.6579626202583313;
        double otm_4_A_I = 0.03028130531311035;
        double otm_4_A_V = 0.3365599513053894;
        double otm_4_B_I = 0.7464718818664551;
        double otm_4_B_V = 0.5053682923316956;
        double otm_5_A_I = 0.721122f;
        double otm_5_A_V = 0.30348747968673706;
        double otm_5_B_I = 0.28231215476989746;
        double otm_5_B_V = 0.12685906887054443;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_5VTelemetry(otm_0_A_I, otm_0_A_V, otm_0_B_I, otm_0_B_V, otm_1_A_I, otm_1_A_V, otm_1_B_I, otm_1_B_V, otm_2_A_I, otm_2_A_V, otm_2_B_I, otm_2_B_V, otm_3_A_I, otm_3_A_V, otm_3_B_I, otm_3_B_V, otm_4_A_I, otm_4_A_V, otm_4_B_I, otm_4_B_V, otm_5_A_I, otm_5_A_V, otm_5_B_I, otm_5_B_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5VTelemetry));
        Quadbox_PDU_5VTelemetry item_ = (Quadbox_PDU_5VTelemetry)item;
        Assert.assertEquals((double)otm_0_A_I, (double)item_.getOtm_0_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_V, (double)item_.getOtm_0_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I, (double)item_.getOtm_0_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_V, (double)item_.getOtm_0_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_I, (double)item_.getOtm_1_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_V, (double)item_.getOtm_1_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_I, (double)item_.getOtm_1_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_V, (double)item_.getOtm_1_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_I, (double)item_.getOtm_2_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_V, (double)item_.getOtm_2_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_I, (double)item_.getOtm_2_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_V, (double)item_.getOtm_2_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I, (double)item_.getOtm_3_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V, (double)item_.getOtm_3_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I, (double)item_.getOtm_3_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V, (double)item_.getOtm_3_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_I, (double)item_.getOtm_4_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_V, (double)item_.getOtm_4_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_I, (double)item_.getOtm_4_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_V, (double)item_.getOtm_4_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_I, (double)item_.getOtm_5_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_V, (double)item_.getOtm_5_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_I, (double)item_.getOtm_5_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_V, (double)item_.getOtm_5_B_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_REB_Bulk_PSTelemetry() throws Exception {
        double rebbulkps_0_2_I = 0.04280775785446167;
        double rebbulkps_0_2_T = 0.4164009094238281;
        double rebbulkps_0_2_V = 0.1602160930633545;
        double rebbulkps_3_5_I = 0.2971833348274231;
        double rebbulkps_3_5_T = 0.17291676998138428;
        double rebbulkps_3_5_V = 0.3964492678642273;
        double rebbulkps_6_8_I = 0.28606903553009033;
        double rebbulkps_6_8_T = 0.18219107389450073;
        double rebbulkps_6_8_V = 0.45358043909072876;
        double rebbulkps_9_12_I = 0.8229976892471313;
        double rebbulkps_9_12_T = 0.07878583669662476;
        double rebbulkps_9_12_V = 0.1583128571510315;
        double rebbulkps_Brd_T = 0.4715355634689331;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_REB_Bulk_PSTelemetry(rebbulkps_0_2_I, rebbulkps_0_2_T, rebbulkps_0_2_V, rebbulkps_3_5_I, rebbulkps_3_5_T, rebbulkps_3_5_V, rebbulkps_6_8_I, rebbulkps_6_8_T, rebbulkps_6_8_V, rebbulkps_9_12_I, rebbulkps_9_12_T, rebbulkps_9_12_V, rebbulkps_Brd_T));
        Assert.assertTrue((boolean)(item instanceof Quadbox_REB_Bulk_PSTelemetry));
        Quadbox_REB_Bulk_PSTelemetry item_ = (Quadbox_REB_Bulk_PSTelemetry)item;
        Assert.assertEquals((double)rebbulkps_0_2_I, (double)item_.getRebbulkps_0_2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_T, (double)item_.getRebbulkps_0_2_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_V, (double)item_.getRebbulkps_0_2_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_I, (double)item_.getRebbulkps_3_5_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_T, (double)item_.getRebbulkps_3_5_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_V, (double)item_.getRebbulkps_3_5_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_I, (double)item_.getRebbulkps_6_8_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_T, (double)item_.getRebbulkps_6_8_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_V, (double)item_.getRebbulkps_6_8_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_I, (double)item_.getRebbulkps_9_12_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_T, (double)item_.getRebbulkps_9_12_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_V, (double)item_.getRebbulkps_9_12_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_Brd_T, (double)item_.getRebbulkps_Brd_T(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebTelemetry() throws Exception {
        double[] analog_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)-1658663750);
        double[] analog_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-1023696156);
        double[] analog_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)779283464);
        double[] analog_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)1531222577);
        double[] analog_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)1096761139);
        double[] clockhi_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)1049568892);
        double[] clockhi_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-1898030729);
        double[] clockhi_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)-951476994);
        double[] clockhi_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)750547812);
        double[] clockhi_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)-1743917857);
        double[] clocklo_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)168905789);
        double[] clocklo_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)841147670);
        double[] clocklo_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)186867929);
        double[] clocklo_VaftLDO2 = TestHelper.generateDoubleArray((int)71, (int)1497942077);
        double[] clocklo_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-1831190928);
        double[] clocklo_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)2035554455);
        double[] digital_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)-564502031);
        double[] digital_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)795837391);
        double[] digital_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)-578197282);
        double[] digital_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-989383355);
        double[] digital_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)-76912962);
        double[] dphi_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)1561356003);
        double[] dphi_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-1477473638);
        double[] dphi_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)2088246210);
        double[] dphi_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)661254703);
        double[] dphi_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)-249277128);
        double[] heater_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)-1274862409);
        double[] heater_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-2102322691);
        double[] heater_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)320357745);
        double[] heater_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-1991499637);
        double[] heater_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)532098643);
        double[] hvbias_IbefSwch = TestHelper.generateDoubleArray((int)71, (int)-295622424);
        double[] hvbias_VbefSwch = TestHelper.generateDoubleArray((int)71, (int)376790417);
        String location = "x";
        double[] od_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)116117869);
        double[] od_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-517363867);
        double[] od_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)931290471);
        double[] od_VaftLDO2 = TestHelper.generateDoubleArray((int)71, (int)277322876);
        double[] od_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-1101140830);
        double[] od_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)-1806004820);
        double[] power = TestHelper.generateDoubleArray((int)71, (int)1749809191);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebTelemetry(analog_IaftLDO, analog_IbefLDO, analog_VaftLDO, analog_VaftSwch, analog_VbefLDO, clockhi_IaftLDO, clockhi_IbefLDO, clockhi_VaftLDO, clockhi_VaftSwch, clockhi_VbefLDO, clocklo_IaftLDO, clocklo_IbefLDO, clocklo_VaftLDO, clocklo_VaftLDO2, clocklo_VaftSwch, clocklo_VbefLDO, digital_IaftLDO, digital_IbefLDO, digital_VaftLDO, digital_VaftSwch, digital_VbefLDO, dphi_IaftLDO, dphi_IbefLDO, dphi_VaftLDO, dphi_VaftSwch, dphi_VbefLDO, heater_IaftLDO, heater_IbefLDO, heater_VaftLDO, heater_VaftSwch, heater_VbefLDO, hvbias_IbefSwch, hvbias_VbefSwch, location, od_IaftLDO, od_IbefLDO, od_VaftLDO, od_VaftLDO2, od_VaftSwch, od_VbefLDO, power));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebTelemetry));
        Rebpower_RebTelemetry item_ = (Rebpower_RebTelemetry)item;
        Assert.assertArrayEquals((double[])analog_IaftLDO, (double[])item_.getAnalog_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO, (double[])item_.getAnalog_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO, (double[])item_.getAnalog_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch, (double[])item_.getAnalog_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO, (double[])item_.getAnalog_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO, (double[])item_.getClockhi_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO, (double[])item_.getClockhi_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO, (double[])item_.getClockhi_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch, (double[])item_.getClockhi_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO, (double[])item_.getClockhi_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO, (double[])item_.getClocklo_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO, (double[])item_.getClocklo_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO, (double[])item_.getClocklo_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2, (double[])item_.getClocklo_VaftLDO2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch, (double[])item_.getClocklo_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO, (double[])item_.getClocklo_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO, (double[])item_.getDigital_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO, (double[])item_.getDigital_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO, (double[])item_.getDigital_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch, (double[])item_.getDigital_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO, (double[])item_.getDigital_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IaftLDO, (double[])item_.getDphi_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IbefLDO, (double[])item_.getDphi_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftLDO, (double[])item_.getDphi_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftSwch, (double[])item_.getDphi_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VbefLDO, (double[])item_.getDphi_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO, (double[])item_.getHeater_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO, (double[])item_.getHeater_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO, (double[])item_.getHeater_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch, (double[])item_.getHeater_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO, (double[])item_.getHeater_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch, (double[])item_.getHvbias_IbefSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch, (double[])item_.getHvbias_VbefSwch(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])od_IaftLDO, (double[])item_.getOd_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO, (double[])item_.getOd_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO, (double[])item_.getOd_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2, (double[])item_.getOd_VaftLDO2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch, (double[])item_.getOd_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO, (double[])item_.getOd_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebpsTelemetry() throws Exception {
        double[] boardTemp0 = TestHelper.generateDoubleArray((int)13, (int)832582928);
        double[] boardTemp1 = TestHelper.generateDoubleArray((int)13, (int)-755911878);
        double[] boardTemp2 = TestHelper.generateDoubleArray((int)13, (int)-2068363916);
        double[] boardTemp3 = TestHelper.generateDoubleArray((int)13, (int)1313439292);
        double[] boardTemp4 = TestHelper.generateDoubleArray((int)13, (int)2051610361);
        double[] boardTemp5 = TestHelper.generateDoubleArray((int)13, (int)-1635790786);
        double[] boardTemp6 = TestHelper.generateDoubleArray((int)13, (int)2052816059);
        String location = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebpsTelemetry(boardTemp0, boardTemp1, boardTemp2, boardTemp3, boardTemp4, boardTemp5, boardTemp6, location));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebpsTelemetry));
        Rebpower_RebpsTelemetry item_ = (Rebpower_RebpsTelemetry)item;
        Assert.assertArrayEquals((double[])boardTemp0, (double[])item_.getBoardTemp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp1, (double[])item_.getBoardTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp2, (double[])item_.getBoardTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp3, (double[])item_.getBoardTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp4, (double[])item_.getBoardTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp5, (double[])item_.getBoardTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp6, (double[])item_.getBoardTemp6(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveHex_Cold1Telemetry() throws Exception {
        double evapExitTmp = 0.5696732997894287;
        double hexRtrnTmp = 0.7104860544204712;
        double preExpnTmp = 0.304135262966156;
        double returnPrs = 0.656476616859436;
        double superHeat = 0.43687504529953003;
        double supplyPrs = 0.3795526f;
        double supplySubCooling = 0.03384626f;
        double supplyTmp = 0.6241716742515564;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cold1Telemetry(evapExitTmp, hexRtrnTmp, preExpnTmp, returnPrs, superHeat, supplyPrs, supplySubCooling, supplyTmp));
        Assert.assertTrue((boolean)(item instanceof Hex_Cold1Telemetry));
        Hex_Cold1Telemetry item_ = (Hex_Cold1Telemetry)item;
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preExpnTmp, (double)item_.getPreExpnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)superHeat, (double)item_.getSuperHeat(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyPrs, (double)item_.getSupplyPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)supplySubCooling, (double)item_.getSupplySubCooling(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyTmp, (double)item_.getSupplyTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cold2Telemetry() throws Exception {
        double evapExitTmp = 0.5565491318702698;
        double hexRtrnTmp = 0.651703f;
        double preExpnTmp = 0.37985825538635254;
        double returnPrs = 0.2004251480102539;
        double superHeat = 0.7636793851852417;
        double supplyPrs = 0.8251405954360962;
        double supplySubCooling = 0.35672032833099365;
        double supplyTmp = 0.4145827293395996;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cold2Telemetry(evapExitTmp, hexRtrnTmp, preExpnTmp, returnPrs, superHeat, supplyPrs, supplySubCooling, supplyTmp));
        Assert.assertTrue((boolean)(item instanceof Hex_Cold2Telemetry));
        Hex_Cold2Telemetry item_ = (Hex_Cold2Telemetry)item;
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preExpnTmp, (double)item_.getPreExpnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)superHeat, (double)item_.getSuperHeat(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyPrs, (double)item_.getSupplyPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)supplySubCooling, (double)item_.getSupplySubCooling(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyTmp, (double)item_.getSupplyTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo1Telemetry() throws Exception {
        double c3ExitTmp = 0.4782752990722656;
        double c4ExitTmp = 0.7239797711372375;
        double evapExitTmp = 0.7197815775871277;
        double hexRtrnTmp = 0.9183598160743713;
        double liquidPrs = 0.20888584852218628;
        double preC3Tmp = 0.24312078952789307;
        double preC4Tmp = 0.5844906568527222;
        double returnPrs = 0.4658542275428772;
        double vaporPrs = 0.35205912590026855;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo1Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo1Telemetry));
        Hex_Cryo1Telemetry item_ = (Hex_Cryo1Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo2Telemetry() throws Exception {
        double c3ExitTmp = 0.3917809f;
        double c4ExitTmp = 0.3365342f;
        double evapExitTmp = 0.03115654f;
        double hexRtrnTmp = 0.4191882014274597;
        double liquidPrs = 0.004744529724121094;
        double preC3Tmp = 0.6189401745796204;
        double preC4Tmp = 0.6160616278648376;
        double returnPrs = 0.22007405757904053;
        double vaporPrs = 0.541482150554657;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo2Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo2Telemetry));
        Hex_Cryo2Telemetry item_ = (Hex_Cryo2Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo3Telemetry() throws Exception {
        double c3ExitTmp = 0.5644496083259583;
        double c4ExitTmp = 0.9477417469024658;
        double evapExitTmp = 0.03009939193725586;
        double hexRtrnTmp = 0.10220110416412354;
        double liquidPrs = 0.4452778100967407;
        double preC3Tmp = 0.5164448618888855;
        double preC4Tmp = 0.944242537021637;
        double returnPrs = 0.5786952972412109;
        double vaporPrs = 0.8435121774673462;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo3Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo3Telemetry));
        Hex_Cryo3Telemetry item_ = (Hex_Cryo3Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo4Telemetry() throws Exception {
        double c3ExitTmp = 0.5737094879150391;
        double c4ExitTmp = 0.0709908f;
        double evapExitTmp = 0.05176180601119995;
        double hexRtrnTmp = 0.25011515617370605;
        double liquidPrs = 0.4477531909942627;
        double preC3Tmp = 0.8028997182846069;
        double preC4Tmp = 0.4242568016052246;
        double returnPrs = 0.5157331228256226;
        double vaporPrs = 0.5582222938537598;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo4Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo4Telemetry));
        Hex_Cryo4Telemetry item_ = (Hex_Cryo4Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo5Telemetry() throws Exception {
        double c3ExitTmp = 0.494049608707428;
        double c4ExitTmp = 0.32102978229522705;
        double evapExitTmp = 0.7797937989234924;
        double hexRtrnTmp = 0.8791483640670776;
        double liquidPrs = 0.6195932626724243;
        double preC3Tmp = 0.42856353521347046;
        double preC4Tmp = 0.7638687491416931;
        double returnPrs = 0.9366223216056824;
        double vaporPrs = 0.04617792367935181;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo5Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo5Telemetry));
        Hex_Cryo5Telemetry item_ = (Hex_Cryo5Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo6Telemetry() throws Exception {
        double c3ExitTmp = 0.3258591294288635;
        double c4ExitTmp = 0.6397758722305298;
        double evapExitTmp = 0.19437897205352783;
        double hexRtrnTmp = 0.8271254897117615;
        double liquidPrs = 0.06476038694381714;
        double preC3Tmp = 0.9718087911605835;
        double preC4Tmp = 0.4123146f;
        double returnPrs = 0.891336f;
        double vaporPrs = 0.08645033836364746;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo6Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo6Telemetry));
        Hex_Cryo6Telemetry item_ = (Hex_Cryo6Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cold1Telemetry() throws Exception {
        double ambientTmp = 0.525852f;
        double cabinetTmp = 0.12419843673706055;
        double compCurrent = 0.8240468502044678;
        double compPower = 0.7583534717559814;
        double compVfdCurr = 0.4666261076927185;
        double compVfdFreq = 0.21386557817459106;
        double compVfdVolt = 0.36055612564086914;
        double compVoltage = 0.8323262333869934;
        double coolFlowRate = 0.6992086172103882;
        double coolValvePosn = 0.9445028305053711;
        double dischrgPrs = 0.2161598801612854;
        double dischrgtmp_M = 0.3641442656517029;
        double dischrgtmp_P = 0.8141933679580688;
        double fan1Speed = 0.06189322471618652;
        double fan2Speed = 0.9578322172164917;
        double fan3Speed = 0.2023366093635559;
        double hGBValvePosn = 0.3699355125427246;
        double liquidSubCooling = 0.4264281392097473;
        double liquidtmp_M = 0.05219519f;
        double liquidtmp_P = 0.6109493970870972;
        double suctionPrs = 0.5834362506866455;
        double suctiontmp_M = 0.28520846366882324;
        double suctiontmp_P = 0.2823162078857422;
        double waterInTmp = 0.19853603839874268;
        double waterOutTmp = 0.03734469413757324;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cold1Telemetry(ambientTmp, cabinetTmp, compCurrent, compPower, compVfdCurr, compVfdFreq, compVfdVolt, compVoltage, coolFlowRate, coolValvePosn, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fan1Speed, fan2Speed, fan3Speed, hGBValvePosn, liquidSubCooling, liquidtmp_M, liquidtmp_P, suctionPrs, suctiontmp_M, suctiontmp_P, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cold1Telemetry));
        Refrig_Cold1Telemetry item_ = (Refrig_Cold1Telemetry)item;
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdCurr, (double)item_.getCompVfdCurr(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdFreq, (double)item_.getCompVfdFreq(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdVolt, (double)item_.getCompVfdVolt(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)coolFlowRate, (double)item_.getCoolFlowRate(), (double)1.0E-6f);
        Assert.assertEquals((double)coolValvePosn, (double)item_.getCoolValvePosn(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1Speed, (double)item_.getFan1Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2Speed, (double)item_.getFan2Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3Speed, (double)item_.getFan3Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)hGBValvePosn, (double)item_.getHGBValvePosn(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidSubCooling, (double)item_.getLiquidSubCooling(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M, (double)item_.getLiquidtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P, (double)item_.getLiquidtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cold2Telemetry() throws Exception {
        double ambientTmp = 0.857648491859436;
        double cabinetTmp = 0.9606726169586182;
        double compCurrent = 0.3003922700881958;
        double compPower = 0.7687066793441772;
        double compVfdCurr = 0.5367991924285889;
        double compVfdFreq = 0.8407281637191772;
        double compVfdVolt = 0.7217233777046204;
        double compVoltage = 0.2505093812942505;
        double coolFlowRate = 0.19337981939315796;
        double coolValvePosn = 0.1740619f;
        double dischrgPrs = 0.16812056303024292;
        double dischrgtmp_M = 0.8654240965843201;
        double dischrgtmp_P = 0.8776325583457947;
        double fan1Speed = 0.8186141848564148;
        double fan2Speed = 0.3416285514831543;
        double fan3Speed = 0.6987219452857971;
        double hGBValvePosn = 0.5410972833633423;
        double liquidSubCooling = 0.7867089509963989;
        double liquidtmp_M = 0.0941278338432312;
        double liquidtmp_P = 0.931046187877655;
        double suctionPrs = 0.21988266706466675;
        double suctiontmp_M = 0.7550634145736694;
        double suctiontmp_P = 0.9361757636070251;
        double waterInTmp = 0.019108355045318604;
        double waterOutTmp = 0.7347357273101807;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cold2Telemetry(ambientTmp, cabinetTmp, compCurrent, compPower, compVfdCurr, compVfdFreq, compVfdVolt, compVoltage, coolFlowRate, coolValvePosn, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fan1Speed, fan2Speed, fan3Speed, hGBValvePosn, liquidSubCooling, liquidtmp_M, liquidtmp_P, suctionPrs, suctiontmp_M, suctiontmp_P, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cold2Telemetry));
        Refrig_Cold2Telemetry item_ = (Refrig_Cold2Telemetry)item;
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdCurr, (double)item_.getCompVfdCurr(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdFreq, (double)item_.getCompVfdFreq(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdVolt, (double)item_.getCompVfdVolt(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)coolFlowRate, (double)item_.getCoolFlowRate(), (double)1.0E-6f);
        Assert.assertEquals((double)coolValvePosn, (double)item_.getCoolValvePosn(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1Speed, (double)item_.getFan1Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2Speed, (double)item_.getFan2Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3Speed, (double)item_.getFan3Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)hGBValvePosn, (double)item_.getHGBValvePosn(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidSubCooling, (double)item_.getLiquidSubCooling(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M, (double)item_.getLiquidtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P, (double)item_.getLiquidtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo1Telemetry() throws Exception {
        double afterCoolTmp = 0.2345951795578003;
        double compCurrent = 0.7834237813949585;
        double compPower = 0.8315953612327576;
        double compVoltage = 0.2510741949081421;
        double dischrgPrs = 0.7227205038070679;
        double dischrgtmp_M = 0.9719487428665161;
        double dischrgtmp_P = 0.21742552518844604;
        double fanSpeed = 0.7121472358703613;
        double oilLevel = 0.9078497886657715;
        double oilSepTmp = 0.12912046909332275;
        double phaseSepTmp = 0.27337998151779175;
        double suctionPrs = 0.9967654943466187;
        double suctiontmp_M = 0.05340749f;
        double suctiontmp_P = 0.4919287f;
        double surgeTankTmp = 0.1381072998046875;
        double waterInTmp = 0.7738508582115173;
        double waterOutTmp = 0.01103430986404419;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo1Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo1Telemetry));
        Refrig_Cryo1Telemetry item_ = (Refrig_Cryo1Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo2Telemetry() throws Exception {
        double afterCoolTmp = 0.2170717716217041;
        double compCurrent = 0.15021568536758423;
        double compPower = 0.1217767596244812;
        double compVoltage = 0.8693954944610596;
        double dischrgPrs = 0.32677024602890015;
        double dischrgtmp_M = 0.9909141063690186;
        double dischrgtmp_P = 0.571614682674408;
        double fanSpeed = 0.27157366275787354;
        double oilLevel = 0.33452296257019043;
        double oilSepTmp = 0.19836342334747314;
        double phaseSepTmp = 0.9186033606529236;
        double suctionPrs = 0.681343138217926;
        double suctiontmp_M = 0.6523274779319763;
        double suctiontmp_P = 0.5440795421600342;
        double surgeTankTmp = 0.8521692156791687;
        double waterInTmp = 0.8633056879043579;
        double waterOutTmp = 0.4047976f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo2Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo2Telemetry));
        Refrig_Cryo2Telemetry item_ = (Refrig_Cryo2Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo3Telemetry() throws Exception {
        double afterCoolTmp = 0.9445672631263733;
        double ambientTmp = 0.686534f;
        double cabinetTmp = 0.0961449146270752;
        double compCurrent = 0.7788357138633728;
        double compPower = 0.22763729095458984;
        double compVoltage = 0.5643602013587952;
        double dischrgPrs = 0.9599761366844177;
        double dischrgtmp_M = 0.9858710765838623;
        double dischrgtmp_P = 0.45698732137680054;
        double fanSpeed = 0.8661306500434875;
        double oilLevel = 0.2414093017578125;
        double oilSepTmp = 0.9761012196540833;
        double phaseSepTmp = 0.05564993619918823;
        double suctionPrs = 0.927304f;
        double suctiontmp_M = 0.662605f;
        double suctiontmp_P = 0.3427470922470093;
        double surgeTankTmp = 0.4644889831542969;
        double waterInTmp = 0.8611056208610535;
        double waterOutTmp = 0.858014f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo3Telemetry(afterCoolTmp, ambientTmp, cabinetTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo3Telemetry));
        Refrig_Cryo3Telemetry item_ = (Refrig_Cryo3Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo4Telemetry() throws Exception {
        double afterCoolTmp = 0.21424585580825806;
        double compCurrent = 0.9723508358001709;
        double compPower = 0.4526193141937256;
        double compVoltage = 0.6550036072731018;
        double dischrgPrs = 0.131877f;
        double dischrgtmp_M = 0.9966618418693542;
        double dischrgtmp_P = 0.9532673954963684;
        double fanSpeed = 0.1381598711013794;
        double oilLevel = 0.9309994578361511;
        double oilSepTmp = 0.954749f;
        double phaseSepTmp = 0.7155646085739136;
        double suctionPrs = 0.8333218693733215;
        double suctiontmp_M = 0.9204304814338684;
        double suctiontmp_P = 0.8151068091392517;
        double surgeTankTmp = 0.09608691930770874;
        double waterInTmp = 0.2935751f;
        double waterOutTmp = 0.3242270350456238;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo4Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo4Telemetry));
        Refrig_Cryo4Telemetry item_ = (Refrig_Cryo4Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo5Telemetry() throws Exception {
        double afterCoolTmp = 0.9630361199378967;
        double ambientTmp = 0.8779200315475464;
        double cabinetTmp = 0.3283578157424927;
        double compCurrent = 0.10404658317565918;
        double compPower = 0.5559445023536682;
        double compVoltage = 0.6585713028907776;
        double dischrgPrs = 0.5269941091537476;
        double dischrgtmp_M = 0.21232444047927856;
        double dischrgtmp_P = 0.620173990726471;
        double fanSpeed = 0.5797096490859985;
        double oilLevel = 0.7934626936912537;
        double oilSepTmp = 0.7837643623352051;
        double phaseSepTmp = 0.684160053730011;
        double suctionPrs = 0.3835126757621765;
        double suctiontmp_M = 0.5497651696205139;
        double suctiontmp_P = 0.2053104043006897;
        double surgeTankTmp = 0.32332944869995117;
        double waterInTmp = 0.8373674750328064;
        double waterOutTmp = 0.5662262439727783;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo5Telemetry(afterCoolTmp, ambientTmp, cabinetTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo5Telemetry));
        Refrig_Cryo5Telemetry item_ = (Refrig_Cryo5Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo6Telemetry() throws Exception {
        double afterCoolTmp = 0.8161535859107971;
        double compCurrent = 0.07231658697128296;
        double compPower = 0.9228143692016602;
        double compVoltage = 0.03941547870635986;
        double dischrgPrs = 0.785889208316803;
        double dischrgtmp_M = 0.3423633575439453;
        double dischrgtmp_P = 0.01270902156829834;
        double fanSpeed = 0.32872843742370605;
        double oilLevel = 0.5602349042892456;
        double oilSepTmp = 0.2593300938606262;
        double phaseSepTmp = 0.3174777030944824;
        double suctionPrs = 0.46322983503341675;
        double suctiontmp_M = 0.9124523401260376;
        double suctiontmp_P = 0.34436845779418945;
        double surgeTankTmp = 0.750078022480011;
        double waterInTmp = 0.18899625539779663;
        double waterOutTmp = 0.8106003403663635;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo6Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo6Telemetry));
        Refrig_Cryo6Telemetry item_ = (Refrig_Cryo6Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP1_ITelemetry() throws Exception {
        double cip1_I = 0.2194158434867859;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP1_ITelemetry(cip1_I));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP1_ITelemetry));
        Vacuum_CIP1_ITelemetry item_ = (Vacuum_CIP1_ITelemetry)item;
        Assert.assertEquals((double)cip1_I, (double)item_.getCip1_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP1_VTelemetry() throws Exception {
        double cip1_V = 0.7009671926498413;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP1_VTelemetry(cip1_V));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP1_VTelemetry));
        Vacuum_CIP1_VTelemetry item_ = (Vacuum_CIP1_VTelemetry)item;
        Assert.assertEquals((double)cip1_V, (double)item_.getCip1_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP2_ITelemetry() throws Exception {
        double cip2_I = 0.507375180721283;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP2_ITelemetry(cip2_I));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP2_ITelemetry));
        Vacuum_CIP2_ITelemetry item_ = (Vacuum_CIP2_ITelemetry)item;
        Assert.assertEquals((double)cip2_I, (double)item_.getCip2_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP2_VTelemetry() throws Exception {
        double cip2_V = 0.9249336123466492;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP2_VTelemetry(cip2_V));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP2_VTelemetry));
        Vacuum_CIP2_VTelemetry item_ = (Vacuum_CIP2_VTelemetry)item;
        Assert.assertEquals((double)cip2_V, (double)item_.getCip2_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP3_ITelemetry() throws Exception {
        double cip3_I = 0.6982911229133606;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP3_ITelemetry(cip3_I));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP3_ITelemetry));
        Vacuum_CIP3_ITelemetry item_ = (Vacuum_CIP3_ITelemetry)item;
        Assert.assertEquals((double)cip3_I, (double)item_.getCip3_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP3_VTelemetry() throws Exception {
        double cip3_V = 0.01829511f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP3_VTelemetry(cip3_V));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP3_VTelemetry));
        Vacuum_CIP3_VTelemetry item_ = (Vacuum_CIP3_VTelemetry)item;
        Assert.assertEquals((double)cip3_V, (double)item_.getCip3_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP4_ITelemetry() throws Exception {
        double cip4_I = 0.6854037046432495;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP4_ITelemetry(cip4_I));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP4_ITelemetry));
        Vacuum_CIP4_ITelemetry item_ = (Vacuum_CIP4_ITelemetry)item;
        Assert.assertEquals((double)cip4_I, (double)item_.getCip4_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP4_VTelemetry() throws Exception {
        double cip4_V = 0.028214454650878906;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP4_VTelemetry(cip4_V));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP4_VTelemetry));
        Vacuum_CIP4_VTelemetry item_ = (Vacuum_CIP4_VTelemetry)item;
        Assert.assertEquals((double)cip4_V, (double)item_.getCip4_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP5_ITelemetry() throws Exception {
        double cip5_I = 0.7769781351089478;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP5_ITelemetry(cip5_I));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP5_ITelemetry));
        Vacuum_CIP5_ITelemetry item_ = (Vacuum_CIP5_ITelemetry)item;
        Assert.assertEquals((double)cip5_I, (double)item_.getCip5_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP5_VTelemetry() throws Exception {
        double cip5_V = 0.3220542073249817;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP5_VTelemetry(cip5_V));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP5_VTelemetry));
        Vacuum_CIP5_VTelemetry item_ = (Vacuum_CIP5_VTelemetry)item;
        Assert.assertEquals((double)cip5_V, (double)item_.getCip5_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP6_ITelemetry() throws Exception {
        double cip6_I = 0.945830225944519;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP6_ITelemetry(cip6_I));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP6_ITelemetry));
        Vacuum_CIP6_ITelemetry item_ = (Vacuum_CIP6_ITelemetry)item;
        Assert.assertEquals((double)cip6_I, (double)item_.getCip6_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP6_VTelemetry() throws Exception {
        double cip6_V = 0.8596281409263611;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP6_VTelemetry(cip6_V));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP6_VTelemetry));
        Vacuum_CIP6_VTelemetry item_ = (Vacuum_CIP6_VTelemetry)item;
        Assert.assertEquals((double)cip6_V, (double)item_.getCip6_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CryoVacTelemetry() throws Exception {
        double cryoVac = 0.8599603772163391;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CryoVacTelemetry(cryoVac));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoVacTelemetry));
        Vacuum_CryoVacTelemetry item_ = (Vacuum_CryoVacTelemetry)item;
        Assert.assertEquals((double)cryoVac, (double)item_.getCryoVac(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_ForelineVacTelemetry() throws Exception {
        double forelineVac = 0.03954344987869263;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_ForelineVacTelemetry(forelineVac));
        Assert.assertTrue((boolean)(item instanceof Vacuum_ForelineVacTelemetry));
        Vacuum_ForelineVacTelemetry item_ = (Vacuum_ForelineVacTelemetry)item;
        Assert.assertEquals((double)forelineVac, (double)item_.getForelineVac(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Hex1VacTelemetry() throws Exception {
        double hex1Vac = 0.07610797882080078;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_Hex1VacTelemetry(hex1Vac));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Hex1VacTelemetry));
        Vacuum_Hex1VacTelemetry item_ = (Vacuum_Hex1VacTelemetry)item;
        Assert.assertEquals((double)hex1Vac, (double)item_.getHex1Vac(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Hex2VacTelemetry() throws Exception {
        double hex2Vac = 0.2586974f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_Hex2VacTelemetry(hex2Vac));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Hex2VacTelemetry));
        Vacuum_Hex2VacTelemetry item_ = (Vacuum_Hex2VacTelemetry)item;
        Assert.assertEquals((double)hex2Vac, (double)item_.getHex2Vac(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboCurrentTelemetry() throws Exception {
        double turboCurrent = 0.6401305794715881;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboCurrentTelemetry(turboCurrent));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboCurrentTelemetry));
        Vacuum_TurboCurrentTelemetry item_ = (Vacuum_TurboCurrentTelemetry)item;
        Assert.assertEquals((double)turboCurrent, (double)item_.getTurboCurrent(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboPowerTelemetry() throws Exception {
        double turboPower = 0.706870436668396;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboPowerTelemetry(turboPower));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboPowerTelemetry));
        Vacuum_TurboPowerTelemetry item_ = (Vacuum_TurboPowerTelemetry)item;
        Assert.assertEquals((double)turboPower, (double)item_.getTurboPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboPumpTempTelemetry() throws Exception {
        double turboPumpTemp = 0.15935587882995605;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboPumpTempTelemetry(turboPumpTemp));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboPumpTempTelemetry));
        Vacuum_TurboPumpTempTelemetry item_ = (Vacuum_TurboPumpTempTelemetry)item;
        Assert.assertEquals((double)turboPumpTemp, (double)item_.getTurboPumpTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboSpeedTelemetry() throws Exception {
        double turboSpeed = 0.7605285048484802;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboSpeedTelemetry(turboSpeed));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboSpeedTelemetry));
        Vacuum_TurboSpeedTelemetry item_ = (Vacuum_TurboSpeedTelemetry)item;
        Assert.assertEquals((double)turboSpeed, (double)item_.getTurboSpeed(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboVacTelemetry() throws Exception {
        double turboVac = 0.1153864860534668;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboVacTelemetry(turboVac));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboVacTelemetry));
        Vacuum_TurboVacTelemetry item_ = (Vacuum_TurboVacTelemetry)item;
        Assert.assertEquals((double)turboVac, (double)item_.getTurboVac(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboVoltageTelemetry() throws Exception {
        double turboVoltage = 0.9390849471092224;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboVoltageTelemetry(turboVoltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboVoltageTelemetry));
        Vacuum_TurboVoltageTelemetry item_ = (Vacuum_TurboVoltageTelemetry)item;
        Assert.assertEquals((double)turboVoltage, (double)item_.getTurboVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_StoreTelemetry() throws Exception {
        double capacity = 0.4172125f;
        double freeFraction = 0.0624614953994751;
        double freeSpace = 0.3936976194381714;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_StoreTelemetry(capacity, freeFraction, freeSpace));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreTelemetry));
        Daq_monitor_StoreTelemetry item_ = (Daq_monitor_StoreTelemetry)item;
        Assert.assertEquals((double)capacity, (double)item_.getCapacity(), (double)1.0E-6f);
        Assert.assertEquals((double)freeFraction, (double)item_.getFreeFraction(), (double)1.0E-6f);
        Assert.assertEquals((double)freeSpace, (double)item_.getFreeSpace(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_CcdTelemetry() throws Exception {
        double[] gDV = TestHelper.generateDoubleArray((int)201, (int)1760028035);
        String location = "l";
        double[] oDI = TestHelper.generateDoubleArray((int)201, (int)-133227751);
        double[] oDV = TestHelper.generateDoubleArray((int)201, (int)1751085095);
        double[] oGV = TestHelper.generateDoubleArray((int)201, (int)1529878327);
        double[] rDV = TestHelper.generateDoubleArray((int)201, (int)1597265810);
        double[] temp = TestHelper.generateDoubleArray((int)201, (int)-1323012996);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_CcdTelemetry(gDV, location, oDI, oDV, oGV, rDV, temp));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_CcdTelemetry));
        Focal_plane_CcdTelemetry item_ = (Focal_plane_CcdTelemetry)item;
        Assert.assertArrayEquals((double[])gDV, (double[])item_.getGDV(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oGV, (double[])item_.getOGV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rDV, (double[])item_.getRDV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp, (double[])item_.getTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTelemetry() throws Exception {
        double[] anaI = TestHelper.generateDoubleArray((int)71, (int)1455461608);
        double[] anaV = TestHelper.generateDoubleArray((int)71, (int)46612942);
        double[] aspicl_Temp0 = TestHelper.generateDoubleArray((int)71, (int)493924127);
        double[] aspicl_Temp1 = TestHelper.generateDoubleArray((int)71, (int)-2132939177);
        double[] aspicl_Temp2 = TestHelper.generateDoubleArray((int)71, (int)-2005515633);
        double[] aspicu_Temp0 = TestHelper.generateDoubleArray((int)71, (int)1165216671);
        double[] aspicu_Temp1 = TestHelper.generateDoubleArray((int)71, (int)1880495407);
        double[] aspicu_Temp2 = TestHelper.generateDoubleArray((int)71, (int)1383356391);
        double[] clkHI = TestHelper.generateDoubleArray((int)71, (int)361020546);
        double[] clkHV = TestHelper.generateDoubleArray((int)71, (int)-363410135);
        double[] clkLI = TestHelper.generateDoubleArray((int)71, (int)-1429355153);
        double[] clkLV = TestHelper.generateDoubleArray((int)71, (int)467741549);
        double[] digI = TestHelper.generateDoubleArray((int)71, (int)972929953);
        double[] digV = TestHelper.generateDoubleArray((int)71, (int)1600829783);
        double[] hVBiasSwitch = TestHelper.generateDoubleArray((int)71, (int)-296436445);
        double[] htrPI = TestHelper.generateDoubleArray((int)71, (int)-983286768);
        double[] htrPV = TestHelper.generateDoubleArray((int)71, (int)106252370);
        double[] htrV = TestHelper.generateDoubleArray((int)71, (int)1812082692);
        double[] htrW = TestHelper.generateDoubleArray((int)71, (int)-1555172005);
        String location = "";
        double[] oDI = TestHelper.generateDoubleArray((int)71, (int)1499570650);
        double[] oDV = TestHelper.generateDoubleArray((int)71, (int)-1509755712);
        double[] pClk0 = TestHelper.generateDoubleArray((int)71, (int)-759067549);
        double[] pClk1 = TestHelper.generateDoubleArray((int)71, (int)1813140704);
        double[] pClkL = TestHelper.generateDoubleArray((int)71, (int)1067566830);
        double[] pClkU = TestHelper.generateDoubleArray((int)71, (int)-1575809580);
        double[] power = TestHelper.generateDoubleArray((int)71, (int)1122013823);
        double[] rG0 = TestHelper.generateDoubleArray((int)71, (int)-1140812706);
        double[] rG1 = TestHelper.generateDoubleArray((int)71, (int)-1190431863);
        double[] rGL = TestHelper.generateDoubleArray((int)71, (int)365580163);
        double[] rGU = TestHelper.generateDoubleArray((int)71, (int)-471044649);
        double[] rTDTemp = TestHelper.generateDoubleArray((int)71, (int)-2012862686);
        double[] ref05V = TestHelper.generateDoubleArray((int)71, (int)2035984384);
        double[] ref125V = TestHelper.generateDoubleArray((int)71, (int)190502802);
        double[] ref15V = TestHelper.generateDoubleArray((int)71, (int)-2086925904);
        double[] ref25V = TestHelper.generateDoubleArray((int)71, (int)-899911696);
        double[] refN12 = TestHelper.generateDoubleArray((int)71, (int)-1276506797);
        double[] refP12 = TestHelper.generateDoubleArray((int)71, (int)1816608010);
        double[] sClk0 = TestHelper.generateDoubleArray((int)71, (int)-1941420836);
        double[] sClk1 = TestHelper.generateDoubleArray((int)71, (int)-1332528888);
        double[] sClkL = TestHelper.generateDoubleArray((int)71, (int)1019005637);
        double[] sClkU = TestHelper.generateDoubleArray((int)71, (int)619018300);
        double[] temp1 = TestHelper.generateDoubleArray((int)71, (int)466375540);
        double[] temp10 = TestHelper.generateDoubleArray((int)71, (int)449971660);
        double[] temp2 = TestHelper.generateDoubleArray((int)71, (int)-505962323);
        double[] temp3 = TestHelper.generateDoubleArray((int)71, (int)-791034106);
        double[] temp4 = TestHelper.generateDoubleArray((int)71, (int)1134430147);
        double[] temp5 = TestHelper.generateDoubleArray((int)71, (int)-1867883868);
        double[] temp6 = TestHelper.generateDoubleArray((int)71, (int)-1819255666);
        double[] temp7 = TestHelper.generateDoubleArray((int)71, (int)-1583017645);
        double[] temp8 = TestHelper.generateDoubleArray((int)71, (int)1131230852);
        double[] temp9 = TestHelper.generateDoubleArray((int)71, (int)-487842011);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTelemetry(anaI, anaV, aspicl_Temp0, aspicl_Temp1, aspicl_Temp2, aspicu_Temp0, aspicu_Temp1, aspicu_Temp2, clkHI, clkHV, clkLI, clkLV, digI, digV, hVBiasSwitch, htrPI, htrPV, htrV, htrW, location, oDI, oDV, pClk0, pClk1, pClkL, pClkU, power, rG0, rG1, rGL, rGU, rTDTemp, ref05V, ref125V, ref15V, ref25V, refN12, refP12, sClk0, sClk1, sClkL, sClkU, temp1, temp10, temp2, temp3, temp4, temp5, temp6, temp7, temp8, temp9));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTelemetry));
        Focal_plane_RebTelemetry item_ = (Focal_plane_RebTelemetry)item;
        Assert.assertArrayEquals((double[])anaI, (double[])item_.getAnaI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anaV, (double[])item_.getAnaV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0, (double[])item_.getAspicl_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1, (double[])item_.getAspicl_Temp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2, (double[])item_.getAspicl_Temp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0, (double[])item_.getAspicu_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1, (double[])item_.getAspicu_Temp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2, (double[])item_.getAspicu_Temp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHI, (double[])item_.getClkHI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHV, (double[])item_.getClkHV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLI, (double[])item_.getClkLI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLV, (double[])item_.getClkLV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digI, (double[])item_.getDigI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digV, (double[])item_.getDigV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hVBiasSwitch, (double[])item_.getHVBiasSwitch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrPI, (double[])item_.getHtrPI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrPV, (double[])item_.getHtrPV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrV, (double[])item_.getHtrV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrW, (double[])item_.getHtrW(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClk0, (double[])item_.getPClk0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClk1, (double[])item_.getPClk1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkL, (double[])item_.getPClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkU, (double[])item_.getPClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rG0, (double[])item_.getRG0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rG1, (double[])item_.getRG1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGL, (double[])item_.getRGL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGU, (double[])item_.getRGU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rTDTemp, (double[])item_.getRTDTemp(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05V, (double[])item_.getRef05V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125V, (double[])item_.getRef125V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15V, (double[])item_.getRef15V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25V, (double[])item_.getRef25V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refN12, (double[])item_.getRefN12(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refP12, (double[])item_.getRefP12(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClk0, (double[])item_.getSClk0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClk1, (double[])item_.getSClk1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkL, (double[])item_.getSClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkU, (double[])item_.getSClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1, (double[])item_.getTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10, (double[])item_.getTemp10(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2, (double[])item_.getTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3, (double[])item_.getTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4, (double[])item_.getTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5, (double[])item_.getTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6, (double[])item_.getTemp6(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7, (double[])item_.getTemp7(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8, (double[])item_.getTemp8(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9, (double[])item_.getTemp9(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTotalPowerTelemetry() throws Exception {
        double rebTotalPower = 0.8021236658096313;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTotalPowerTelemetry(rebTotalPower));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTotalPowerTelemetry));
        Focal_plane_RebTotalPowerTelemetry item_ = (Focal_plane_RebTotalPowerTelemetry)item;
        Assert.assertEquals((double)rebTotalPower, (double)item_.getRebTotalPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_SegmentTelemetry() throws Exception {
        double[] i = TestHelper.generateDoubleArray((int)3024, (int)672567783);
        String location = "w";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_SegmentTelemetry(i, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SegmentTelemetry));
        Focal_plane_SegmentTelemetry item_ = (Focal_plane_SegmentTelemetry)item;
        Assert.assertArrayEquals((double[])i, (double[])item_.getI(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }
}

