package org.lsst.sal.camera.states;

import org.lsst.sal.SALEnum;
import org.lsst.sal.camera.CameraStateChangeEvent;

public class FilterChangerDetailedStateEvent extends CameraStateChangeEvent {
  private final FilterChangerState substate;

  public FilterChangerDetailedStateEvent(FilterChangerState substate) {
    this.substate = substate;
  }

  @Override
  public FilterChangerState getSubstate() {
    return substate;
  }

  @Override
  public String toString() {
    return "FilterChangerDetailedStateEvent{" + "substate=" + substate +"}";
  }

  public enum FilterChangerState implements SALEnum {
    UNLOADING,

    LOADING,

    LOADED,

    UNLOADED,

    ROTATING
  }
}
