package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class Refrig_Cold2_DeviceConfigurationEvent extends CameraEvent {
  private final String version;

  private final String maq20_node;

  private final String maq20_serials;

  private final String plc_node;

  private final int vfd_address;

  private final int vfd_baudRate;

  private final String vfd_devcName;

  public Refrig_Cold2_DeviceConfigurationEvent(String version, String maq20_node,
      String maq20_serials, String plc_node, int vfd_address, int vfd_baudRate,
      String vfd_devcName) {
    this.version = version;
    this.maq20_node = maq20_node;
    this.maq20_serials = maq20_serials;
    this.plc_node = plc_node;
    this.vfd_address = vfd_address;
    this.vfd_baudRate = vfd_baudRate;
    this.vfd_devcName = vfd_devcName;
  }

  public String getVersion() {
    return version;
  }

  public String getMaq20_node() {
    return maq20_node;
  }

  public String getMaq20_serials() {
    return maq20_serials;
  }

  public String getPlc_node() {
    return plc_node;
  }

  public int getVfd_address() {
    return vfd_address;
  }

  public int getVfd_baudRate() {
    return vfd_baudRate;
  }

  public String getVfd_devcName() {
    return vfd_devcName;
  }

  @Override
  public String toString() {
    return "Refrig_Cold2_DeviceConfigurationEvent{" + "version=" + version +
        ", maq20_node=" + maq20_node +", maq20_serials=" + maq20_serials +", plc_node=" + plc_node +
        ", vfd_address=" + vfd_address +", vfd_baudRate=" + vfd_baudRate +
        ", vfd_devcName=" + vfd_devcName +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private String version;

    private String maq20_node;

    private String maq20_serials;

    private String plc_node;

    private int vfd_address;

    private int vfd_baudRate;

    private String vfd_devcName;

    private Builder() {
    }

    public Builder version(String version) {
      this.version = version;
      return this;
    }

    public Builder maq20_node(String maq20_node) {
      this.maq20_node = maq20_node;
      return this;
    }

    public Builder maq20_serials(String maq20_serials) {
      this.maq20_serials = maq20_serials;
      return this;
    }

    public Builder plc_node(String plc_node) {
      this.plc_node = plc_node;
      return this;
    }

    public Builder vfd_address(int vfd_address) {
      this.vfd_address = vfd_address;
      return this;
    }

    public Builder vfd_baudRate(int vfd_baudRate) {
      this.vfd_baudRate = vfd_baudRate;
      return this;
    }

    public Builder vfd_devcName(String vfd_devcName) {
      this.vfd_devcName = vfd_devcName;
      return this;
    }

    public Refrig_Cold2_DeviceConfigurationEvent build() {
      return new Refrig_Cold2_DeviceConfigurationEvent(version, maq20_node, maq20_serials, plc_node, vfd_address, vfd_baudRate, vfd_devcName);
    }
  }
}
