package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class Focal_plane_SequencerConfig_DAQConfigurationEvent extends CameraEvent {
  private final String version;

  private final String daqFolder;

  private final String daqPartition;

  private final boolean emulatedDAQ;

  public Focal_plane_SequencerConfig_DAQConfigurationEvent(String version, String daqFolder,
      String daqPartition, boolean emulatedDAQ) {
    this.version = version;
    this.daqFolder = daqFolder;
    this.daqPartition = daqPartition;
    this.emulatedDAQ = emulatedDAQ;
  }

  public String getVersion() {
    return version;
  }

  public String getDaqFolder() {
    return daqFolder;
  }

  public String getDaqPartition() {
    return daqPartition;
  }

  public boolean isEmulatedDAQ() {
    return emulatedDAQ;
  }

  @Override
  public String toString() {
    return "Focal_plane_SequencerConfig_DAQConfigurationEvent{" + "version=" + version +
        ", daqFolder=" + daqFolder +", daqPartition=" + daqPartition +
        ", emulatedDAQ=" + emulatedDAQ +"}";
  }
}
